<?php

/**
 * This is the model class for table "vtiger_leadaddress".
 *
 * The followings are the available columns in table 'vtiger_leadaddress':
 * @property integer $leadaddressid
 * @property string $city
 * @property string $code
 * @property string $state
 * @property string $pobox
 * @property string $country
 * @property string $phone
 * @property string $mobile
 * @property string $fax
 * @property string $lane
 * @property string $leadaddresstype
 */
class VtigerLeadaddress extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vtiger_leadaddress';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('leadaddressid', 'numerical', 'integerOnly'=>true),
			array('city, code, state, pobox, country, leadaddresstype', 'length', 'max'=>30),
			array('phone, mobile, fax', 'length', 'max'=>50),
			array('lane', 'length', 'max'=>250),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('leadaddressid, city, code, state, pobox, country, phone, mobile, fax, lane, leadaddresstype', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'leadaddressid' => 'Leadaddressid',
			'city' => 'City',
			'code' => 'Code',
			'state' => 'State',
			'pobox' => 'Pobox',
			'country' => 'Country',
			'phone' => 'Phone',
			'mobile' => 'Mobile',
			'fax' => 'Fax',
			'lane' => 'Lane',
			'leadaddresstype' => 'Leadaddresstype',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('leadaddressid',$this->leadaddressid);
		$criteria->compare('city',$this->city,true);
		$criteria->compare('code',$this->code,true);
		$criteria->compare('state',$this->state,true);
		$criteria->compare('pobox',$this->pobox,true);
		$criteria->compare('country',$this->country,true);
		$criteria->compare('phone',$this->phone,true);
		$criteria->compare('mobile',$this->mobile,true);
		$criteria->compare('fax',$this->fax,true);
		$criteria->compare('lane',$this->lane,true);
		$criteria->compare('leadaddresstype',$this->leadaddresstype,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return VtigerLeadaddress the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
