<?php
$user = User::model()->findByPK($userid);
if($user->engineering == 1){
	?>

	<div class="kt-portlet">
		<div class="kt-portlet__head">
			<div class="kt-portlet__head-label">
				<h3 class="kt-portlet__head-title">
					<?php echo $section->title ?> Section
				</h3>
			</div>
			<div class="kt-portlet__head-toolbar">
				<div class="kt-widget__action">
					<button type="button" class="btn btn-bold btn-label-brand btn-sm" data-toggle="modal" data-target="#kt_modal_4">Create Design Building on <?php echo $section->title ?> Section</button>
				</div>
			</div>
		</div>
		<div class="kt-portlet__body">
			<!--Solid Form-->
			<div class="kt-portlet__body kt-portlet__body--fit">
				<!--begin: Form -->
				<table class="kt-datatable1" id="html_table1" width="100%">
					<thead>
						<tr>
							<th title="ID">
								ID
							</th>
							<th title="Title">
								Title
							</th>
							<th title="Date">
								Date
							</th>
							<th title="Building">
								Building
							</th>
							<th title="File">
								File 
							</th>
							<th title="Extention">
								Extention
							</th>
							<th title="More">
								More
							</th>
						</tr>
					</thead>
					<tbody>
						<?php
						if(!empty($alldesign)){
							foreach($alldesign as  $design){ 
								?>
								<tr>
									<td data-title="ID">
										<?php echo $design->id?>
									</td>
									<td data-title="Title">
										<?php echo $design->title ?>
									</td>
									<td data-title="Date">
										<?php echo $design->date?>
									</td>
									<td data-title="Building">
										<?php echo $design->building->title?>  at <?php echo $design->building->project->title?>
									</td>
									<td data-title="File">
										<a download data-fancybox="gallery" href="<?php echo Yii::app()->getBaseUrl(true) ?>/uploads/<?php echo $design->image ?>"><i class="fas fa-download" aria-hidden="true"></i> <?php echo $design->image ?></a>
									</td>
									<td data-title="Extention">
										<?php
										$favcolor = $design->filetype;
										switch($favcolor){
											case 1:
											echo "Image";
											break;
											case 2:
											echo "PDF";
											break;
											case 3:
											echo "CAD";
											break;
											case 4:
											echo "Excel";
											break;
											default:
											echo "Other";
										}
										?>
									</td>
									<td data-title="More">
										<div class="table-icons-wrapper">
											<a href="<?php echo Yii::app()->getBaseUrl(true) ?>/login/deletedesign/<?php echo $design->id?>" >
												<?php if($design->confirm==0){ ?>
													<a href="<?php echo Yii::app()->getBaseUrl(true) ?>/confirm/<?php echo $design->secret ?>">
														<div class="btn btn-outline-danger" data-tooltip="Confirm">
															<i class="far fa-check-square kt-font-dark"></i>
														</div>
													</a>
													<?php }else{ ?>  
													<a href="<?php echo Yii::app()->getBaseUrl(true) ?>/disconfirm/<?php echo $design->secret ?>">
														<div class="btn btn-outline-danger" data-tooltip="Deny">
															<i class="fas fa-check-square kt-font-dark"></i>
														</div>
													</a>
													<?php }?>
											</a>
										</div>
									</td>
								</tr>
								<?php }	}?>
					</tbody>
				</table>
				<!--end: Form -->
			</div>
			<!--/Solid Form-->
		</div>
	</div>
	<!--/Solid Table-->
	<!--Solid Modal-->
	<div class="modal fade" id="kt_modal_4" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="exampleModalLabel">Create Design Building</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					</button>
				</div>
				<?php $form=$this->beginWidget('CActiveForm', array(
						'id'=>'area-area-form',
						'htmlOptions'=>array(
							'onsubmit' => 'return confirm("Are YOU SURE")',
							'class'=>'solid-form',
							'enctype'=>'multipart/form-data',
						),
						'enableAjaxValidation'=>false,
					)); ?>
				<?php echo $form->errorSummary($model); ?>
				<div class="modal-body">
					<div class="row">

						<div class="col-md-6 mb-2">
							<input name="Designmaterials[title]" id="Media_title" type="text" maxlength="255" placeholder="title" class="form-control" required>
						</div>
						<div class="col-md-6 mb-2">
							<select name="Designmaterials[filetype]" class="browser-default">
								<option value="1">Images</option>
								<option value="2">PDF</option>
								<option value="3">CAD</option> 
								<option value="4">Excel</option>
								<option value="5">other</option>
							</select>
						</div>
						<div class="col-md-12 file-field mb-2">
							<div class="comp-status-btn comp-reddish">
								<span>Upload</span>
								<input name="Designmaterials[image]" required type="file">
							</div>
						</div>
						<div class="col-md-6 mb-2">
							<select class="browser-default" name="Designmaterials[building_id]" id="Building_activity" required>
								<option value="" disabled selected>Choose Building</option>
								<?php
								$allbuilding= Building::model()->findAll();
								if(!empty($allbuilding)){
									foreach($allbuilding as  $building){ 
										?>
										<option value="<?php echo $building->id ?>"><?php echo $building->title ?> -> <?php echo $building->project->title ?> </option>
										<?php }	}?>
							</select>
							<?php echo $form->error($model,'building_id'); ?>
						</div>	
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
					<button type="submit" class="btn btn-primary">Submit</button>
				</div>
				<?php $this->endWidget(); ?>
			</div>
		</div>
	</div>
	<!--/Solid Modal-->
	<?php }else{ ?>
	<!-- Permission Message -->
	<div class="row">
		<div class="col-12">
			<div class="solid-box">
				<div class="solid-box-header">
					<div class="solid-box-title">
						Error 400
					</div>
					<div class="solid-box-content">
						<div class="row">
							<p>You don't have permission to access this Page</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- /Permission Message -->
	<?php } ?>