
				<?php
                if (Yii::app()->request->isAjaxRequest) {
                    
                $startdate = Yii::app()->request->getPost('startdate');
                $enddate = Yii::app()->request->getPost('enddate');
                $coldtype = Yii::app()->request->getPost('coldtype');
                    
				function build_table($array)
{
	// Initialize column sums
	$sums = [];

	// start table
	$html = '<div class="col p-0"><table class="sqltable table table-bordered table-striped table-fixed-header" id="exportable_table12">';

	// header row
	$html .= '<thead style="background: #48465b;position: sticky;top: 80px;color: white;font-weight: 900;height: 140px"><tr>';
	foreach ($array[0] as $key => $value) {
		if (!in_array($key, ['Agents ID', 'startdate', 'enddate', 'coldtype', 'Leads ID Group'])) {
			$class = '';
			switch ($key) {
				case 'Fresh Leads':
					$class = 'fresh-leads-title';
					break;
			}
			$html .= '<th>' . htmlspecialchars($key) . '</th>';
			$sums[$key] = 0; // Initialize the sums array
		}
	}
	$html .= '</tr></thead>';

	// data rows
	foreach ($array as $key => $value) {
		$html .= '<tr>';
		foreach ($value as $key2 => $value2) {
			if (!in_array($key2, ['Agents ID', 'startdate', 'enddate', 'coldtype', 'Leads ID Group'])) {
				// Check if the current column is 'Agents'
				if ($key2 === 'Agents') {
					$html .= '<td height="70" style="vertical-align: middle;">' . htmlspecialchars($value2) . '</td>';
				} else {
					// Generate a dynamic link based on the cell value
					$href = generate_dynamic_link($key2, $value2, $value['startdate'], $value['enddate'], $value['Agents ID'], $value['coldtype'], $value['Leads ID Group'], false);
					$class = '';
					switch ($key2) {
						case 'Fresh Leads':
							$class = 'fresh-leads-title';
							break;
					}
					$html .= '<td height="70" style="vertical-align: middle;" class="' . $class . '"><a href="' . $href . '">' . htmlspecialchars($value2) . '</a></td>';

					// Accumulate sums for numeric columns
					if (is_numeric($value2)) {
						$sums[$key2] += $value2;
					}
				}
			}
		}
		$html .= '</tr>';
	}

	// footer row for sums
	$html .= '<tfoot style="background: #d7d7d7;"><tr>';
	foreach ($array[0] as $key => $value) {
		if (!in_array($key, ['Agents ID', 'startdate', 'enddate', 'coldtype', 'Leads ID Group'])) {
			if (strtolower($key) === 'agents') {
				// Set "Total" for the Agents column
				$html .= '<th>Total</th>';
			} elseif (isset($sums[$key])) {
				// Generate the sum link for numeric columns
				$href = generate_dynamic_link($key, $sums[$key], $array[0]['startdate'], $array[0]['enddate'], $array[0]['Agents ID'], $array[0]['coldtype'], $array[0]['Leads ID Group'], true); // Pass true for sum row
				$html .= '<th><a target="_blank" style="color:black !important" href="' . $href . '">' . $sums[$key] . '</a></th>';
			} else {
				// For non-numeric columns, show a dash
				$html .= '<th>-</th>';
			}
		}
	}
	$html .= '</tr></tfoot>';

	// finish table and return it
	$loadingImageUrl = Yii::app()->getBaseUrl(true) . '/js/ring-loading.gif';
	$ajaxUrl = Yii::app()->createUrl('engineering/report_performancefreshleadactual');
	$html .= '</table></div>
		<div id="reportrest" class="col p-0">
			<div class="loading-spinner">
				<img style="width:30px" src="' . $loadingImageUrl . '" alt="Loading...">Loading, please wait...
			</div>
		</div>
		<script>
			$(document).ready(function() {
				setTimeout(function() {
					$.ajax({
						url: "' . $ajaxUrl . '",
						method: "POST",
						data: {startdate: "' . $array[0]['startdate'] . '", enddate: "' . $array[0]['enddate'] . '", coldtype: "' . $array[0]['coldtype'] . '"},
						success: function(response) {
							$("#reportrest").html(response);
						},
						error: function() {
							$("#reportrest").html("<p>Failed to load data.</p>");
						}
					});
				}, 100);
			});
		</script>';

	return $html;
}
				$extraConditionLink = array(); // Initialize as an array
				if ($cold == 1) {
					$extraConditionLink[] = '1';
				} elseif ($cold == 2) {
					// You can add a default condition for cold == 2 if needed
					$extraConditionLink[] = '2';
				} elseif ($cold == 3) {
					$extraConditionLink[] = '3';
				}
				// Function to generate dynamic links based on cell values
				function generate_dynamic_link($column, $cellValue, $startdate, $enddate, $agentsID, $coldtype, $leadIdsQueryParam, $isSum = false)
				{
					// Check if the row is a sum row
					if ($isSum) {
						// Generate links for sum row based on the column name
						switch ($column) {
							case 'Fresh Leads':
								return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&fresh%5B%5D=&startdate=' . $startdate . '&enddate=' . $enddate . '&yt0=Search';
							case 'Fresh Leads by Admin':
								return '#';
							case 'Fresh Leads by Sales':
								return '#';
							case 'Local':
								return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&ccode=1&yt0=Search';
							case 'Global':
								return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&ccode=2&yt0=Search';
							case 'Transfer Fresh (From)':
								return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&startdate=' . $startdate . '&enddate=' . $enddate . '&transferx=1&yt0=Search';
						}
					}

					// Original logic for individual cell links
					if ($column === 'Fresh Leads') {
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&fresh%5B%5D=&fresh%5B%5D=' . $agentsID  . '&startdate=' . $startdate . '&enddate=' . $enddate . '&yt0=Search';
					}
					if ($column === 'Fresh Leads by Admin') {
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&notuserids=' . $agentsID  . '&fresh%5B%5D=&fresh%5B%5D=' . $agentsID  . '&startdate=' . $startdate . '&enddate=' . $enddate . '&yt0=Search';
					}
					if ($column === 'Fresh Leads by Sales') {
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&fresh%5B%5D=&fresh%5B%5D=' . $agentsID  . '&startdate=' . $startdate . '&enddate=' . $enddate . '&callcenter%5B%5D=&callcenter%5B%5D=' . $agentsID  . '&yt0=Search';
					}
					if ($column === 'Local') {
						$leadIds = explode(',', $leadIdsQueryParam);
						$leadIdsQueryString = implode('&ids%5B%5D=', $leadIds);
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&ids%5B%5D=' . $leadIdsQueryString . '&fresh%5B%5D=&fresh%5B%5D=' . $agentsID . '&startdate=' . $startdate . '&enddate=' . $enddate . '&ccode=1&yt0=Search';
					}
					if ($column === 'Global') {
						$leadIds = explode(',', $leadIdsQueryParam);
						$leadIdsQueryString = implode('&ids%5B%5D=', $leadIds);
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&ids%5B%5D=' . $leadIdsQueryString . '&fresh%5B%5D=&fresh%5B%5D=' . $agentsID . '&startdate=' . $startdate . '&enddate=' . $enddate . '&ccode=2&yt0=Search';
					}
					if ($column === 'Transfer Fresh (From)') {
						$leadIds = explode(',', $leadIdsQueryParam);
						$leadIdsQueryString = implode('&ids%5B%5D=', $leadIds);
						return Yii::app()->getBaseUrl(true) . '/sales/searchsales?search=&cold=' . $coldtype . '&ids%5B%5D=' . $leadIdsQueryString . '&fresh%5B%5D=&fresh%5B%5D=' . $agentsID . '&startdate=' . $startdate . '&enddate=' . $enddate . '&transferx=1&yt0=Search';
					}
					return '#';
				}
				if ($cold == 1)
					$extraCondition = ' and freshlead.coldcall is not null';
				elseif ($cold == 2)
					$extraCondition = ' and freshlead.coldcall is null';
				elseif ($cold == 3)
					$extraCondition = ' and freshlead.coldcall = 3';
				$sql = "SELECT
CONCAT(user.fname, ' ', user.lname) AS Agents,
CONCAT(user.id ) as 'Agents ID',
COUNT(DISTINCT freshlead.id) AS 'Fresh Leads',
COUNT(DISTINCT CASE WHEN freshlead.user_id != user.id THEN freshlead.id END) AS 'Fresh Leads by Admin',
COUNT(DISTINCT CASE WHEN freshlead.user_id = user.id THEN freshlead.id END) AS 'Fresh Leads by Sales',
GROUP_CONCAT(DISTINCT freshlead.id) AS 'Leads ID Group',
COUNT(DISTINCT CASE WHEN freshlead.international_code = 20 THEN freshlead.id END) AS 'Local',
COUNT(DISTINCT CASE WHEN freshlead.international_code <> 20 THEN freshlead.id END) AS 'Global',
COUNT(DISTINCT CASE WHEN freshlead.fresh_sales = user.id AND freshlead.transfer = 1 THEN freshlead.id END) AS 'Transfer Fresh (From)',
:startdate AS startdate,
:enddate AS enddate,
:coldtype AS coldtype
FROM
    user
LEFT JOIN
    leads AS freshlead ON user.id = freshlead.fresh_sales AND freshlead.date BETWEEN :startdate AND :enddate $extraCondition

WHERE
    user.level <> 5
    AND (user.sales = 1 OR (user.telesales IS NOT NULL AND user.telesales != 0)) $extraCondition
GROUP BY
CONCAT(user.fname, ' ', user.lname), user.id";
				$command = Yii::app()->db->createCommand($sql);
				$command->bindParam(":startdate", $startdate);
				$command->bindParam(":enddate", $enddate);
				$command->bindParam(":coldtype", $extraConditionLink[0]);
				$list = $command->queryAll();
				$leadIdsQueryParam = isset($list[0]['Leads ID Group']) ? '&ids%5B%5D=' . $list[0]['Leads ID Group'] : '';
                    // Output the table
                    echo build_table($list);
                    Yii::app()->end();
                }
                ?>
                
                
					
		

				