<div id="dailyActivitiesTime" class="chartdiv"></div>
<?php
header('Content-Type: text/html; charset=utf-8');
Yii::app()->db->createCommand("SET NAMES 'utf8'")->execute();

$start = $_GET['start'];
$end = $_GET['end'];

if (!empty($start) && !empty($end)) {
    // Create chart instance
    echo '<script>';
    echo 'am4core.useTheme(am4themes_animated);';
    echo 'am4core.useTheme(am4themes_kelly);';
    echo 'var chart = am4core.create("dailyActivitiesTime", am4charts.XYChart);';

    // Build the SQL query
    $sql = "
    SELECT
    a.time,
    a.user_id,
    a.details,
    a.name AS lead_name,
    a.leads_id AS lead_id,
    a.date AS activity_date,
    COUNT(*) AS activity_count,
    u.fname,
    u.lname,
    (SELECT COUNT(*) FROM activities WHERE user_id = a.user_id AND date BETWEEN :start AND :end) AS total_activities
    FROM
    activities a
    INNER JOIN
    user u ON u.id = a.user_id
    WHERE
    a.date BETWEEN :start AND :end
    GROUP BY
    a.time, a.user_id, a.details, a.name, a.leads_id, a.date, u.fname, u.lname
    ";

    $command = Yii::app()->db->createCommand($sql);
    $command->bindValue(':start', $start, PDO::PARAM_STR);
    $command->bindValue(':end', $end, PDO::PARAM_STR);

    try {
        $result = $command->queryAll();

        // Transform the data to match the chart data structure
        $chartData = array();
        foreach ($result as $row) {
            $chartData[] = array(
                'activity_date' => $row['activity_date'],
                'lead_id' => json_decode('"' . $row['lead_id'] . '"'),
                'lead_name' => $row['lead_name'],
                'time' => $row['time'],
                'sale_name' => $row['fname'] . ' ' . $row['lname'] . ' (' . $row['total_activities'] . ')',
                'details' => json_decode('"' . $row['details'] . '"'),
                'activities_numbers' => $row['activity_count'],
            );
        }

        // Encode the transformed data as JSON
        $data = CJSON::encode($chartData);

        echo 'var chartData = ' . $data . ';';

        // Assign the encoded data to the chart
        echo 'chart.data = chartData;';

        // Create axes
        echo 'var xAxis = chart.xAxes.push(new am4charts.CategoryAxis());';
        echo 'xAxis.dataFields.category = "time";';
        echo 'xAxis.renderer.grid.template.location = 0;';
        echo 'xAxis.renderer.minGridDistance = 12;';
        echo 'xAxis.renderer.labels.template.rotation = 90;';
        echo 'xAxis.renderer.labels.template.tooltipText = 90;';

        echo 'var yAxis = chart.yAxes.push(new am4charts.CategoryAxis());';
        echo 'yAxis.dataFields.category = "sale_name";';
        echo 'yAxis.renderer.grid.template.location = 0;';
        echo 'yAxis.renderer.minGridDistance = 10;';

        // Create series
        echo 'var series = chart.series.push(new am4charts.ColumnSeries());';
        echo 'series.dataFields.categoryS = "activity_date";';
        echo 'series.dataFields.categoryT = "lead_id";';
        echo 'series.dataFields.categoryW = "lead_name";';
        echo 'series.dataFields.categoryX = "time";';
        echo 'series.dataFields.categoryY = "sale_name";';
        echo 'series.dataFields.categoryZ = "details";';
        echo 'series.dataFields.categoryR = "details";';
        echo 'series.tooltip.label.interactionsEnabled = true;';
        echo 'series.tooltip.keepTargetHover = true;';
        echo 'series.columns.template.tooltipHTML = \'<span style="color:black">{categoryY} Wrote on {categoryW} at {categoryS} {categoryX}</span><br><b style="text-align:right;color:black">{categoryZ}</b><br><a target="_blank" style="color:#333" href="<?php echo Yii::app()->getBaseUrl(true) ?>/leads/profile/{categoryT}">View Profile</a>\';';
        
        // Event to trigger modal when column is clicked
        echo 'series.columns.template.events.on("hit", function(ev) {';
        echo '    var leadId = ev.target.dataItem.dataContext.lead_id;';
        echo '    loadQuickHistory(leadId);';
        echo '    var $j = jQuery.noConflict();';
        echo '    $j("#quickhistory").modal("show");';
        echo '});';

        // Add cursor
        echo 'chart.cursor = new am4charts.XYCursor();';

        // Add horizontal scrollbar with preview
        echo 'var scrollbarX = new am4charts.XYChartScrollbar();';
        echo 'var scrollbarY = new am4charts.XYChartScrollbar();';
        echo 'chart.scrollbarX = scrollbarX;';
        echo 'chart.scrollbarY = scrollbarY;';

        // End of the chart creation script
        echo '</script>';

    } catch (Exception $e) {
        // Output the error message for debugging
        echo 'console.error("Error: ' . $e->getMessage() . '");';
    }
}
?>
