<div id="dailyActivitiesTime" class="chartdiv"></div>
<?php
$start = $_GET['start'];
$end = $_GET['end'];
$userid=Yii::app()->user->id;
Yii::app()->db->createCommand("SET NAMES 'utf8'")->execute();

if(!empty($start) && !empty($end)){
	// Create chart instance
	echo '<script>';
	echo 'am4core.useTheme(am4themes_animated);';
	echo 'am4core.useTheme(am4themes_kelly);';
	echo 'var chart = am4core.create("dailyActivitiesTime", am4charts.XYChart);';

	// Build the SQL query
	$sql = "
	SELECT
	a.time,
	a.user_id,
	a.details,
	a.name AS lead_name,
	a.leads_id AS lead_id,
	a.date AS activity_date,
	COUNT(*) AS activity_count,
	u.fname,
	u.lname
	FROM
	activities a
	INNER JOIN
	user u ON u.id = a.user_id
	INNER JOIN
    teamleader tl ON tl.sales_id = u.id
	WHERE
	a.date BETWEEN :start AND :end
	AND tl.leader_id = :userid
	GROUP BY
	a.time, a.user_id, a.details, a.name, a.leads_id, a.date, u.fname, u.lname
	";

	$command = Yii::app()->db->createCommand($sql);
	$command->bindValue(':start', $start, PDO::PARAM_STR);
	$command->bindValue(':end', $end, PDO::PARAM_STR);
    $command->bindValue(':userid', $userid, PDO::PARAM_INT);

	try{
		$result = $command->queryAll();

		// Transform the data to match the chart data structure
		$chartData = array();
		foreach($result as $row){
			$chartData[] = array(
				'activity_date' => $row['activity_date'],
				'lead_id' => json_decode('"' . $row['lead_id'] . '"'),
				'lead_name' => $row['lead_name'],
				'time' => $row['time'],
				'sale_name' => $row['fname'] . ' ' . $row['lname'],
				'details' => json_decode('"' . $row['details'] . '"'),
				'activities_numbers' => $row['activity_count'],
			);
		}

		// Encode the transformed data as JSON
		$data = CJSON::encode($chartData);

		echo 'var chartData = ' . $data . ';';

		// Calculate the count of details for each sale_name
		$countData = array();
		foreach($chartData as $dataRow){
			$saleName = $dataRow['sale_name'];
			if(!isset($countData[$saleName])){
				$countData[$saleName] = 0;
			}
			$countData[$saleName]++;
		}

		// Update the sale_name field with the count
		foreach($chartData as &$dataRow){
			$saleName = $dataRow['sale_name'];
			$dataRow['sale_name'] .= ' (' . $countData[$saleName] . ')';
		}

		// Encode the updated data as JSON
		$data = CJSON::encode($chartData);

		// Assign the updated encoded data to the chart
		echo 'chart.data = ' . $data . ';';
		// Rest of the chart generation code
		// Create axes
		echo 'var xAxis = chart.xAxes.push(new am4charts.CategoryAxis());';
		echo 'xAxis.dataFields.category = "time";';
		echo 'xAxis.renderer.grid.template.location = 0;';
		echo 'xAxis.renderer.minGridDistance = 12;';
		echo 'xAxis.renderer.labels.template.rotation = 90;';
		echo 'xAxis.renderer.labels.template.tooltipText = 90;';

		echo 'var yAxis = chart.yAxes.push(new am4charts.CategoryAxis());';
		echo 'yAxis.dataFields.category = "sale_name";';
		echo 'yAxis.renderer.grid.template.location = 0;';
		echo 'yAxis.renderer.minGridDistance = 10;';

		// Create series
		echo 'var series = chart.series.push(new am4charts.ColumnSeries());';
		echo 'series.dataFields.categoryS = "activity_date";';
		echo 'series.dataFields.categoryT = "lead_id";';
		echo 'series.dataFields.categoryW = "lead_name";';
		echo 'series.dataFields.categoryX = "time";';
		echo 'series.dataFields.categoryY = "sale_name";';
		echo 'series.dataFields.categoryZ = "details";';
		echo 'series.dataFields.categoryR = "details";';
		echo 'series.tooltip.label.interactionsEnabled = true;';
		echo 'series.tooltip.keepTargetHover = true;';
		echo 'series.columns.template.tooltipHTML = \'<span style="color:black">{categoryY} Wrote on {categoryW} at {categoryS} {categoryX}</span><br><b style="text-align:right;color:black">{categoryZ}</b><br><a target="_blank" style="color:#333" href="<?php echo Yii::app()->getBaseUrl(true) ?>/leads/profile/{categoryT}">View Profile</a>\';';
		echo 'series.tooltip.getFillFromObject = false;';
		echo 'series.tooltip.label.propertyFields.fill = "color";';
		echo 'series.tooltip.background.propertyFields.stroke = "color";';
		echo 'series.columns.template.tooltipText = "{categoryX}: {categoryY}";';

		echo 'var shadow = series.tooltip.background.filters.getIndex(0);';
		echo 'shadow.dx = 10;';
		echo 'shadow.dy = 10;';
		echo 'shadow.blur = 5;';
		echo 'shadow.color = am4core.color("#f7f8fa");';
		// Add cursor
		echo 'chart.cursor = new am4charts.XYCursor();';

		// Add horizotal scrollbar with preview
		echo 'var scrollbarX = new am4charts.XYChartScrollbar();';
		// Add horizotal scrollbar with preview
		echo 'var scrollbarY = new am4charts.XYChartScrollbar();';
		echo 'chart.scrollbarX = scrollbarX;';
		echo 'chart.scrollbarY = scrollbarY;';


		// ...
	} catch(Exception $e){
		// Output the error message for debugging
		echo 'console.error("Error: ' . $e->getMessage() . '");';
	}
	echo '</script>';
}
?>
