<?php
// Register necessary scripts and meta tags
Yii::app()->clientScript->registerMetaTag(Yii::app()->request->csrfToken, 'csrf-token');
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/megabox/vendors/general/jquery/dist/jquery.js');
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/js/jquery.ba-bbq.js');
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/js/jquery.yiigridview.js');

Yii::app()->clientScript->registerScript('search', "
var \$j = jQuery.noConflict();

function debounce(fn, delay) {
    let timer = null;
    return function () {
        const context = this, args = arguments;
        clearTimeout(timer);
        timer = setTimeout(() => fn.apply(context, args), delay);
    };
}

\$j(function() {
    \$j('#filter-code, #filter-booking, #filter-min-price, #filter-max-price, #filter-min-size-indoor, #filter-max-size-indoor, #filter-min-size-outdoor, #filter-max-size-outdoor').on('keyup change', debounce(function() {
        \$j('#loading-spinner').show(); // Show the spinner

        \$j.fn.yiiGridView.update('units-grid', {
            type: 'POST',
            data: {
                'YII_CSRF_TOKEN': \$j('meta[name=csrf-token]').attr('content'), // Add CSRF token for security
                'Units[code]': \$j('#filter-code').val(),
                'Units[booking]': \$j('#filter-booking').val(),
                'Units[min_price]': \$j('#filter-min-price').val(),
                'Units[max_price]': \$j('#filter-max-price').val(),
                'Units[min_size_indoor]': \$j('#filter-min-size-indoor').val(),
                'Units[max_size_indoor]': \$j('#filter-max-size-indoor').val(),
                'Units[min_size_outdoor]': \$j('#filter-min-size-outdoor').val(),
                'Units[max_size_outdoor]': \$j('#filter-max-size-outdoor').val()
            },
            complete: function() {
                console.log('Filter applied successfully');
                \$j('#loading-spinner').hide(); // Hide the spinner
            },
            error: function(xhr, status, error) {
                console.error('Error applying filter:', error);
                \$j('#loading-spinner').hide(); // Hide the spinner
            }
        });
    }, 300));
});
");
?>

<div class="filters row">
    <div class="col-md-4 mb-1 mt-1">
    <label>Unit Code:</label>
    <?php echo CHtml::textField('Units[code]', $model->code, array('id' => 'filter-code')); ?>
    
    </div>
    <div class="col-md-4 mb-1 mt-1">
    <label>Status:</label>
    <?php echo CHtml::dropDownList('Units[booking]', $model->booking, array(
        '' => 'All',
        '1' => 'Reserved',
        '2' => 'Sold',
        '3' => 'Block',
        '4' => 'Hold',
        '5' => 'OFF',
        '6' => 'DHL',
        '7' => 'Pending'
    ), array('id' => 'filter-booking')); ?>
    </div>
    <div class="col-md-4 mb-1 mt-1">

    <label>Minimum Price:</label>
    <?php echo CHtml::textField('Units[min_price]', $model->min_price, array('id' => 'filter-min-price')); ?>
    </div>
    <div class="col-md-4 mb-1 mt-1">

    <label>Maximum Price:</label>
    <?php echo CHtml::textField('Units[max_price]', $model->max_price, array('id' => 'filter-max-price')); ?>
    </div>
    <div class="col-md-4 mb-1 mt-1">
    
    <label>Minimum Size Indoor:</label>
    <?php echo CHtml::textField('Units[min_size_indoor]', $model->min_size_indoor, array('id' => 'filter-min-size-indoor')); ?>
    </div>
    <div class="col-md-4 mb-1 mt-1">

    <label>Maximum Size Indoor:</label>
    <?php echo CHtml::textField('Units[max_size_indoor]', $model->max_size_indoor, array('id' => 'filter-max-size-indoor')); ?>
    </div>
    <div class="col-md-4 mb-1 mt-1">
    
    <label>Minimum Size Outdoor:</label>
    <?php echo CHtml::textField('Units[min_size_outdoor]', $model->min_size_outdoor, array('id' => 'filter-min-size-outdoor')); ?>
    </div>
    <div class="col-md-4 mb-1 mt-1">

    <label>Maximum Size Outdoor:</label>
    <?php echo CHtml::textField('Units[max_size_outdoor]', $model->max_size_outdoor, array('id' => 'filter-max-size-outdoor')); ?>
    </div>
</div>

<div id="loading-spinner" style="display:none;">
    Loading...
</div>

<?php
Yii::log("DataProvider Item Count: " . $dataProvider->getTotalItemCount(), 'info');
$this->widget('zii.widgets.grid.CGridView', array(
    'id' => 'units-grid',
    'dataProvider' => $dataProvider,
    'filter' => null,
    'ajaxUpdate' => true,
    'enableHistory' => true,
    'enablePagination' => true,
    'itemsCssClass' => 'responsive dataTable responsive dataTable table table-striped table-bordered table-condensed',
    'emptyText' => 'No matching units found, please adjust your search criteria.',
    "summaryText" => "Showing {start} to {end} of {count} entries",
    'pager' => [
        'class' => 'CLinkPager',
        'maxButtonCount' => 5,
        'nextPageLabel' => 'Next',
        'prevPageLabel' => 'Prev',
        'firstPageLabel' => 'First',
        'lastPageLabel' => 'Last',
    ],
    'columns' => array(
        'id',
        'code',
        'title',
        'booking',
        'total',
        'indoor_size',
        'outdoor_size',
    ),
));
?>
