<?php
require 's3/aws-autoloader.php';
use Aws\S3\S3Client;
use Aws\S3\Exception\S3Exception;
class ApiappController extends FrontController
{
    public $layout = '//layouts/loginlayout';
    
    public function filters() {
        return array(
            'accessControl',
        );
    }
    
    public function accessRules() {
        return array(
            array(
                'allow',
                'actions' => array('loginApi'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('loginApi', 'getAllLeads'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('getAllLeads'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('getAllLeadsbdm'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAllPartners'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('getAllLeadsex'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('getAllacts'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('getAllstatues'),
                'users'   => array('*'),
            ),
            
             array(
                'allow',
                'actions' => array('getAllservices'),
                'users'   => array('*'),
            ),
            
            
            
             array(
                'allow',
                'actions' => array('leadmessageByUrl'),
                'users'   => array('*'),
            ),
            
            
            
             
             array(
                'allow',
                'actions' => array('closeticketbyurl'),
                'users'   => array('*'),
            ),
            
            
            
            
            
              
             array(
                'allow',
                'actions' => array('getAllUnits'),
                'users'   => array('*'),
            ),
            
            
            
            
            array(
                'allow',
                'actions' => array('getAllstatuesex'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('getAllbrokers'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('getAllsubstatues'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('getAllsubstatuesex'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAllstatuesforlead'),
                'users'   => array('*'), 
            ),
            array(
                'allow',
                'actions' => array('insertLeadActivityByUrl'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('InsertLeadCloseByUrl'),
                'users'   => array('*'),
            ),
            
            
             array(
                'allow',
                'actions' => array('CreateTicketByUrl'),
                'users'   => array('*'),
            ),
            
            
            
             
             array(
                'allow',
                'actions' => array('GetAllInstallments'),
                'users'   => array('*'),
            ),
            
            
            
            
            
            
            array(
                'allow',
                'actions' => array('InsertVisitByUrl'),
                'users'   => array('*'),
            ),
            
            
              array(
                'allow',
                'actions' => array('CreateTicket'),
                'users'   => array('*'),
            ),
            
            
            
            
              array(
                'allow',
                'actions' => array('GetAllreservations'),
                'users'   => array('*'),
            ),
            
            
            array(
                'allow',
                'actions' => array('InsertLeadByUrl'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('InsertLocationByUrl'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAllUsers'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAllUsersex'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAllplatforms'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAllplatformchild'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAllplatformsex'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAllcampaigns'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAllcampaignsex'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAlltypesex'),
                'users'   => array('*'),
            ),
            
            array(
                'allow',
                'actions' => array('GetAllvisits'),
                'users'   => array('*'),
            ),
            
            
            
               array(
                'allow',
                'actions' => array('GetAllcustomerservice'),
                'users'   => array('*'),
            ),
            
            
            
            
            
            array(
                'allow',
                'actions' => array('GetAllprojectsex'),
                'users'   => array('*'),
            ),
            
            array(
                'allow',
                'actions' => array('GetAllinterestedplacesex'),
                'users'   => array('*'),
            ),
            
               array(
                'allow',
                'actions' => array('ApiSearchUnits'),
                'users'   => array('*'),
            ),
            
            
                array(
                'allow',
                'actions' => array('GetTeamSalesByLeader'),
                'users'   => array('*'),
            ),
            
            
            
                array(
                'allow',
                'actions' => array('InsertActivePartner'),
                'users'   => array('*'),
            ),
            
            
            
            
            
            array(
                'allow',
                'actions' => array('GetAllstatuesforleadclose'),
                'users'   => array('*'),
            ),
            array(
                'deny',
                'users' => array('*'),
            ),
        );
    }
    
    
    
    
    
    public function actionGetAllPartners() {
    // ضبط المنطقة الزمنية
    $main = Mainsettings::model()->findByPk(1);
    if ($main && $main->countrytimezone !== null) {
        date_default_timezone_set($main->countrytimezone);
    } else {
        date_default_timezone_set('Africa/Cairo');
    }

    header('Content-Type: application/json; charset=utf-8');

    // قراءة التوكن
    $token = isset($_GET['token']) ? $_GET['token'] : null;
    if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
        echo json_encode([
            'status'  => false,
            'message' => 'Unauthorized or missing token',
        ]);
        Yii::app()->end();
    }

    // قراءة limit و offset
    $limit  = isset($_GET['limit']) ? (int)$_GET['limit'] : 100;
    $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
    $limit = min($limit, 500); // أقصى حد 500 صف

    // إعداد المعايير
    $criteria = new CDbCriteria();

    // فلترة حسب lead_id أو status (اختياري)
    if (!empty($_GET['lead_id'])) {
        $criteria->compare('lead_id', (int)$_GET['lead_id']);
    }
    if (!empty($_GET['status'])) {
        $criteria->compare('status', $_GET['status'], true);
    }

    // حساب إجمالي السجلات
    $totalCount = ActivePartners::model()->count($criteria);

    // تطبيق limit و offset
    $criteria->limit  = $limit;
    $criteria->offset = $offset;
    $criteria->order  = 'id DESC';

    // جلب البيانات
    $allPartners = ActivePartners::model()->findAll($criteria);
    $result = [];
    foreach ($allPartners as $partner) {
        $result[] = $partner->attributes;
    }

    // إعداد الرد النهائي
    $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;

    $response = [
        'status'      => true,
        'totalCount'  => (int)$totalCount,
        'limit'       => (int)$limit,
        'offset'      => (int)$offset,
        'returned'    => count($result),
        'pages'       => $pages,
        'data'        => $result,
    ];

    echo CJSON::encode($response);
    Yii::app()->end();
}

    
    public function actionGetTeamSalesByLeader()
{
    header('Content-Type: application/json; charset=utf-8');

    $VALID_TOKEN = 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3';

    $token = isset($_GET['token']) ? $_GET['token'] : '';
    $user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;

    if ($token !== $VALID_TOKEN) {
        echo json_encode([
            'status' => false,
            'message' => 'Invalid token'
        ]);
        return;
    }

    if ($user_id <= 0) {
        echo json_encode([
            'status' => false,
            'message' => 'Missing or invalid user_id'
        ]);
        return;
    }

    try {
        $allemployee = Teamleader::model()->findAll(array(
            'condition' => 'leader_id=' . $user_id,
            'order' => 'id DESC'
        ));

        $arr = array();
        foreach ($allemployee as $leader) {
            $arr[] = $leader->sales_id;
        }

        echo json_encode([
            'status' => true,
            'message' => 'Team sales retrieved successfully',
            'leader_id' => $user_id,
            'sales_ids' => $arr
        ]);

    } catch (Exception $e) {
        echo json_encode([
            'status' => false,
            'message' => 'Error: ' . $e->getMessage()
        ]);
    }
}

    
    
    public function actionLoginApi() {
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
        header('Content-Type: application/json');
        $token = $_GET['token'] ?? null;
        if ('ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3' !== $token) {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
        if (isset($_GET['username'], $_GET['password'])) {
            $credentials = [
                'username' => $_GET['username'],
                'password' => $_GET['password'],
            ];
        } else {
            echo CJSON::encode([
                'status'  => false,
                'message' => 'Missing login credentials.',
            ]);
            Yii::app()->end();
        }
        $model = new LoginForm;
        $model->attributes = $credentials;
        if ($model->validate() && $model->login()) {
            $userid = Yii::app()->user->id;
            $user   = User::model()->findByPk($userid);
            if ($user !== null) {
                unset($user->password);
                $data = $user->attributes;
                echo CJSON::encode([
                    'status'  => true,
                    'message' => 'Authentication successful.',
                    'data'    => $data,
                ]);
            } else {
                echo CJSON::encode([
                    'status' => false,
                    'message' => 'User not found.',
                ]);
            }
            Yii::app()->end();
        }
        $errors = [];
        foreach ($model->getErrors() as $attr => $msgs) {
            $errors[$attr] = $msgs;
        }
        echo CJSON::encode([
            'status'  => false,
            'message' => 'Authentication failed.',
            'errors'  => $errors,
        ]);
        Yii::app()->end();
    }
    
    
    public function actionInsertActivePartner()
{
    header('Content-Type: application/json; charset=utf-8');

    $VALID_TOKEN = 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3';
    $req = Yii::app()->request;

    // 🧩 تحديد نوع المحتوى بطريقة متوافقة مع Yii1
    $json = array();
    $ct = isset($_SERVER['CONTENT_TYPE']) ? $_SERVER['CONTENT_TYPE'] : (isset($_SERVER['HTTP_CONTENT_TYPE']) ? $_SERVER['HTTP_CONTENT_TYPE'] : '');
    if (stripos($ct, 'application/json') !== false) {
        $raw = @file_get_contents('php://input');
        if ($raw) {
            $tmp = json_decode($raw, true);
            if (is_array($tmp)) { $json = $tmp; }
        }
    }

    // 🧠 دالة موحدة لقراءة البرامز من JSON أو GET أو POST
    $param = function($key, $default=null) use ($req, $json) {
        if (array_key_exists($key, $json)) return is_string($json[$key]) ? trim($json[$key]) : $json[$key];
        $v = $req->getParam($key, $default); // يقرأ GET + POST في Yii1
        return is_string($v) ? trim($v) : $v;
    };

    // 🔐 التحقق من التوكن
    $token = $param('token', '');
    if ($token !== $VALID_TOKEN) {
        echo json_encode(array("success"=>false,"message"=>"Invalid token"));
        return;
    }

    // 📥 قراءة المتغيرات
    $lead_id = intval($param('lead_id', 0));
    $company_name = $param('company_name', '');
    $partner_name = $param('partner_name', '');
    $business_consultant = $param('business_consultant');
    $phone_number = $param('phone_number');
    $finance_contact_number = $param('finance_contact_number');
    $email = $param('email');
    $location = $param('location');
    $app_id = $param('app_id');
    $contract_date = $param('contract_date');
    $tax_id = $param('tax_id');
    $cr_id = $param('cr_id');
    $vat_id_date = $param('vat_id_date');
    $advance_payment = $param('advance_payment', 'No');
    $referral_form = $param('referral_form');
    $category = $param('category');
    $last_activity_date = $param('last_activity_date');
    $status = $param('status', 'Active');
    $notes = $param('notes');

    // ✅ التحقق من القيم الأساسية
    if ($lead_id <= 0) {
        echo json_encode(array("success"=>false,"message"=>"Missing or invalid lead_id"));
        return;
    }
    if ($company_name === '' || $partner_name === '') {
        echo json_encode(array("success"=>false,"message"=>"Missing required fields: company_name, partner_name"));
        return;
    }

    try {
        $sql = "INSERT INTO active_partners (
                    lead_id, company_name, partner_name, business_consultant,
                    phone_number, finance_contact_number, email, location, app_id,
                    contract_date, tax_id, cr_id, vat_id_date, advance_payment,
                    referral_form, category, last_activity_date, status, notes,
                    created_at, updated_at
                ) VALUES (
                    :lead_id, :company_name, :partner_name, :business_consultant,
                    :phone_number, :finance_contact_number, :email, :location, :app_id,
                    :contract_date, :tax_id, :cr_id, :vat_id_date, :advance_payment,
                    :referral_form, :category, :last_activity_date, :status, :notes,
                    NOW(), NOW()
                )";

        $cmd = Yii::app()->db->createCommand($sql);
        $cmd->bindParam(':lead_id', $lead_id, PDO::PARAM_INT);
        $cmd->bindParam(':company_name', $company_name, PDO::PARAM_STR);
        $cmd->bindParam(':partner_name', $partner_name, PDO::PARAM_STR);
        $cmd->bindParam(':business_consultant', $business_consultant, PDO::PARAM_STR);
        $cmd->bindParam(':phone_number', $phone_number, PDO::PARAM_STR);
        $cmd->bindParam(':finance_contact_number', $finance_contact_number, PDO::PARAM_STR);
        $cmd->bindParam(':email', $email, PDO::PARAM_STR);
        $cmd->bindParam(':location', $location, PDO::PARAM_STR);
        $cmd->bindParam(':app_id', $app_id, PDO::PARAM_STR);
        $cmd->bindParam(':contract_date', $contract_date, PDO::PARAM_STR);
        $cmd->bindParam(':tax_id', $tax_id, PDO::PARAM_STR);
        $cmd->bindParam(':cr_id', $cr_id, PDO::PARAM_STR);
        $cmd->bindParam(':vat_id_date', $vat_id_date, PDO::PARAM_STR);
        $cmd->bindParam(':advance_payment', $advance_payment, PDO::PARAM_STR);
        $cmd->bindParam(':referral_form', $referral_form, PDO::PARAM_STR);
        $cmd->bindParam(':category', $category, PDO::PARAM_STR);
        $cmd->bindParam(':last_activity_date', $last_activity_date, PDO::PARAM_STR);
        $cmd->bindParam(':status', $status, PDO::PARAM_STR);
        $cmd->bindParam(':notes', $notes, PDO::PARAM_STR);
        $cmd->execute();

        echo json_encode(array(
            "success" => true,
            "message" => "Active Partner added successfully",
            "id" => Yii::app()->db->getLastInsertID()
        ));
    } catch (Exception $e) {
        echo json_encode(array("success"=>false,"message"=>"Error: ".$e->getMessage()));
    }
}

    
    public function actionGetAllvisits() {
    // ضبط المنطقة الزمنية
    $main = Mainsettings::model()->findByPk(1);
    if ($main->countrytimezone !== null) {
        date_default_timezone_set($main->countrytimezone);
    } else {
        date_default_timezone_set('Africa/Cairo');
    }

    // جلب المتغيرات من GET
    $token = $_GET['token'] ?? null;
    $id    = $_GET['id']    ?? null;
    $user    = $_GET['user']    ?? null;
    $lead    = $_GET['lead']    ?? null;


    header('Content-Type: application/json');
    if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
        echo json_encode([
            'status'  => false,
            'message' => 'Unauthorized or missing token',
        ]);
        Yii::app()->end();
    }

    // قراءة limit و offset
    $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
    $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
    $limit = min($limit, 500); // أقصى حد 500

    $criteria = new CDbCriteria();

    // فلترة حسب ID الزيارة (اختياري)
    if ($id !== null) {
        $criteria->compare('id', $id);
    }
    
      if ($user !== null) {
        $criteria->compare('user_id', $user);
    }
    
    
      if ($user !== null) {
        $criteria->compare('lead_id', $lead);
    }
    
    
    

    // حساب عدد السجلات
    $totalCount = Visit::model()->count($criteria);

    // تطبيق limit و offset
    $criteria->limit  = $limit;
    $criteria->offset = $offset;

    // جلب البيانات
    $allVisits = Visit::model()->findAll($criteria);
    $result = [];
    foreach ($allVisits as $visit) {
        $result[] = $visit->attributes;
    }

    // إعداد الرد النهائي
    $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;

    $response = [
        'status'      => true,
        'totalCount'  => (int)$totalCount,
        'limit'       => (int)$limit,
        'offset'      => (int)$offset,
        'returned'    => count($result),
        'pages'       => $pages,
        'data'        => $result,
    ];

    echo CJSON::encode($response);
    Yii::app()->end();
}




public function actionGetAllreservations() {
    // ضبط المنطقة الزمنية
    $main = Mainsettings::model()->findByPk(1);
    if ($main && $main->countrytimezone) {
        date_default_timezone_set($main->countrytimezone);
    } else {
        date_default_timezone_set('Africa/Cairo');
    }

    // جلب المتغيرات من GET
    $token   = $_GET['token'] ?? null;
    $id      = $_GET['id'] ?? null;
    $user    = $_GET['user'] ?? null;
    $lead    = $_GET['lead'] ?? null;
    $unit    = $_GET['unit'] ?? null;
    $confirm = $_GET['confirm'] ?? null;
    $cancel  = $_GET['cancel'] ?? null;

    header('Content-Type: application/json');

    // التحقق من التوكن
    if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
        echo json_encode([
            'status'  => false,
            'message' => 'Unauthorized or missing token',
        ]);
        Yii::app()->end();
    }

    // limit & offset
    $limit  = isset($_GET['limit']) ? (int)$_GET['limit'] : 100;
    $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
    $limit  = min($limit, 500);

    $criteria = new CDbCriteria();

    // فلترة اختيارية
    if ($id !== null) {
        $criteria->compare('t.id', $id);
    }
    if ($user !== null) {
        $criteria->compare('t.user_id', $user);
    }
    if ($lead !== null) {
        $criteria->compare('t.lead_id', $lead);
    }
    if ($unit !== null) {
        $criteria->compare('t.unit_id', $unit);
    }
    if ($confirm !== null) {
        $criteria->compare('t.confirm', $confirm);
    }
    if ($cancel !== null) {
        $criteria->compare('t.cancel', $cancel);
    }

    // اجمالي النتائج
    $totalCount = Reservation::model()->count($criteria);

    // pagination
    $criteria->limit  = $limit;
    $criteria->offset = $offset;
    $criteria->order  = 't.id DESC';

    // جلب البيانات
    $rows = Reservation::model()->findAll($criteria);
    $data = [];
    foreach ($rows as $row) {
        $data[] = $row->attributes;
    }

    // الصفحات
    $pages = ($totalCount > 0) ? (int)ceil($totalCount / $limit) : 0;

    // رد JSON
    $response = [
        'status'      => true,
        'totalCount'  => (int)$totalCount,
        'limit'       => (int)$limit,
        'offset'      => (int)$offset,
        'returned'    => count($data),
        'pages'       => $pages,
        'data'        => $data,
    ];

    echo CJSON::encode($response);
    Yii::app()->end();
}




public function actionGetAllcustomerservice()
{
    // 1) timezone
    $main = Mainsettings::model()->findByPk(1);
    if (!empty($main) && !empty($main->countrytimezone)) {
        date_default_timezone_set($main->countrytimezone);
    } else {
        date_default_timezone_set('Africa/Cairo');
    }

    header('Content-Type: application/json');

    // 2) auth token
    $token = isset($_GET['token']) ? $_GET['token'] : null;
    if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
        echo CJSON::encode(['status' => false, 'message' => 'Unauthorized or missing token']);
        Yii::app()->end();
    }

    // 3) inputs (GET/REQUEST)
    // ملاحظة: لو عندك فورم بيبعت POST/REQUEST بدل GET، ممكن تستبدل $_GET بـ $_REQUEST
    $amount      = isset($_GET['amount'])      ? trim($_GET['amount'])      : null;
    $lead        = isset($_GET['lead'])        ? trim($_GET['lead'])        : null;
    $unit        = isset($_GET['unit'])        ? trim($_GET['unit'])        : null;
    $startdate2  = isset($_GET['startdate2'])  ? trim($_GET['startdate2'])  : null; // YYYY-MM-DD
    $enddate2    = isset($_GET['enddate2'])    ? trim($_GET['enddate2'])    : null; // YYYY-MM-DD
    $confirm     = isset($_GET['confirm'])     ? (int)$_GET['confirm']      : null; // 1/2 => done=1/2 , 3 => done IS NULL
    $usersParam  = isset($_GET['user'])        ? $_GET['user']              : null; // ممكن يكون array أو قيمة مفردة
    $parent  = isset($_GET['parent'])        ? $_GET['parent']              : null; // ممكن يكون array أو قيمة مفردة
    // Pagination
    $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
    $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
    $limit  = max(1, min($limit, 500));
    $offset = max(0, $offset);

    // Sorting (افتراضي date DESC)
    $sort = isset($_GET['sort']) ? trim($_GET['sort']) : 'date';
    $dir  = isset($_GET['dir'])  ? strtoupper(trim($_GET['dir'])) : 'DESC';
    $allowedSortFields = ['id','date','amount','user_id','lead_id','unit_id','done'];
    if (!in_array($sort, $allowedSortFields, true)) $sort = 'date';
    $dir = ($dir === 'ASC') ? 'ASC' : 'DESC';

    try {
        $criteria = new CDbCriteria();
        $criteria->order = $sort . ' ' . $dir;

        // 4) الشروط الأساسية حسب الكود الأصلي
        // Secret IS NOT NULL
        $criteria->addCondition('Secret IS NOT NULL');

        // amount / lead_id / unit_id (بنفس addSearchCondition اللي عندك)
        if ($amount !== null && $amount !== '') {
            $criteria->addSearchCondition('amount', $amount, false, 'AND');
        }
        if ($lead !== null && $lead !== '') {
            $criteria->addSearchCondition('lead_id', $lead, false, 'AND');
        }
        if ($unit !== null && $unit !== '') {
            $criteria->addSearchCondition('unit_id', $unit, false, 'AND');
        }
        
        if ($parent !== null) {
            $criteria->addSearchCondition('parent_id', $parent, false, 'AND');
        }else{
            
          $criteria->addCondition('parent_id IS NULL');

        }
        
        
        


        // بين تاريخين على عمود date (startdate2/enddate2)
        if ($startdate2 && $enddate2) {
            $criteria->addBetweenCondition('date', $startdate2, $enddate2, 'AND');
        } elseif ($startdate2 && !$enddate2) {
            $criteria->addCondition('date >= :startd'); 
            $criteria->params[':startd'] = $startdate2;
        } elseif (!$startdate2 && $enddate2) {
            $criteria->addCondition('date <= :endd'); 
            $criteria->params[':endd'] = $enddate2;
        }

        // confirm => done
        if ($confirm === 1 || $confirm === 2) {
            // addSearchCondition كما في كودك
            $criteria->addSearchCondition('done', (string)$confirm, false, 'AND');
        } elseif ($confirm === 3) {
            $criteria->addCondition('done IS NULL');
        }
        // غير كده: بدون فلترة على done

        // user (ممكن يكون array أو مفرد)
        if ($usersParam !== null) {
            if (is_array($usersParam)) {
                // لو أكتر من قيمة
                if (count($usersParam) >= 1) {
                    $criteria->addInCondition('user_id', $usersParam, 'AND');
                }
            } else {
                // قيمة مفردة
                $u = trim($usersParam);
                if ($u !== '') $criteria->compare('user_id', $u);
            }
        }

        // 5) إجمالي السجلات
        $totalCount = Customerservice::model()->count($criteria);

        // 6) limit/offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;

        // 7) جلب البيانات
        $rows = Customerservice::model()->findAll($criteria);
        $data = [];
        foreach ($rows as $row) {
            $data[] = $row->attributes; // لو عايز تختار أعمدة محددة، ابنِ مصفوفة هنا
        }

        $pages = ($totalCount > 0) ? (int)ceil($totalCount / $limit) : 0;

        echo CJSON::encode([
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($data),
            'pages'       => $pages,
            'sort'        => $sort,
            'dir'         => $dir,
            'filters'     => [
                'amount'     => $amount,
                'lead'       => $lead,
                'unit'       => $unit,
                'startdate2' => $startdate2,
                'enddate2'   => $enddate2,
                'confirm'    => $confirm,
                'user'       => $usersParam,
            ],
            'data'        => $data,
        ]);
    } catch (Exception $e) {
        echo CJSON::encode([
            'status'  => false,
            'message' => 'Server error',
            'error'   => $e->getMessage(),
        ]);
    }

    Yii::app()->end();
}




public function actionApiSearchUnits()
{
    header('Content-Type: application/json');

    // ✅ التحقق من التوكن
    $token = $_GET['token'] ?? null;
    if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
        echo json_encode(['status' => false, 'message' => 'Unauthorized']);
        Yii::app()->end();
    }

    // ✅ قراءة limit و offset
    $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 50;
    $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
    $limit = min($limit, 500); // أقصى حد

    // ✅ بناء الكريتيريا
    $criteria = new CDbCriteria();
    $criteria->order = 'code ASC';
    $criteria->addSearchCondition('hidden', 1, false, 'AND');

    // 🧠 فلترة حسب التواريخ إن وجدت
    if (!empty($_GET['date']))
        $criteria->addSearchCondition('date', $_GET['date'], false, 'AND');

    if (!empty($_GET['ddate']))
        $criteria->addSearchCondition('delivery_date', $_GET['ddate'], false, 'AND');

    if (!empty($_GET['cdate']))
        $criteria->addSearchCondition('dateofcontract', $_GET['cdate'], false, 'AND');

    // 🧠 فلترة indoor_size
    if (!empty($_GET['indoor_from']) || !empty($_GET['indoor_to'])) {
        $from = (int) ($_GET['indoor_from'] ?? 0);
        $to = (int) ($_GET['indoor_to'] ?? PHP_INT_MAX);
        $criteria->addBetweenCondition('indoor_size', $from, $to, 'AND');
    }

    // 🧠 فلترة السعر
    if (!empty($_GET['price_from']) || !empty($_GET['price_to'])) {
        $from = (int) ($_GET['price_from'] ?? 0);
        $to = (int) ($_GET['price_to'] ?? PHP_INT_MAX);
        $criteria->addBetweenCondition('total', $from, $to, 'AND');
    }

    // 🧠 فلترة بالحجز
    if (isset($_GET['booking'])) {
        if ($_GET['booking'] === '0') {
            $criteria->addCondition('booking IS NULL', 'AND');
        } elseif ($_GET['booking'] !== '404') {
            $criteria->addSearchCondition('booking', $_GET['booking'], false, 'AND');
        }
    }

    // 🧠 باقي الفلاتر البسيطة
    if (!empty($_GET['floor_id']))
        $criteria->addSearchCondition('floor_id', $_GET['floor_id'], false, 'AND');

    if (!empty($_GET['code']))
        $criteria->addSearchCondition('code', $_GET['code'], true, 'AND');

    if (!empty($_GET['activity']))
        $criteria->addSearchCondition('activity', $_GET['activity'], false, 'AND');

    if (!empty($_GET['Finishing']))
        $criteria->addSearchCondition('Finishing', $_GET['Finishing'], false, 'AND');

    // 🧠 فلترة بالمشروعات
    if (!empty($_GET['projects']) && is_array($_GET['projects']) && count($_GET['projects']) > 1) {
        $projectIds = array_map('intval', $_GET['projects']);
        $criteria->addInCondition('projects_id', $projectIds, 'AND');
    }

    // 🧠 فلترة بالمباني
    if (!empty($_GET['building']) && is_array($_GET['building']) && count($_GET['building']) > 1) {
        $buildingIds = array_map('intval', $_GET['building']);
        $criteria->addInCondition('building_id', $buildingIds, 'AND');
    }

    // ✅ تحديد الأعمدة المطلوبة
    $criteria->select = "
        id, user_id, booking, title, indoor_price, outdoor_price, total, code, 
        type_unit, floor_id, building_id, activity, indoor_size, outdoor_size, 
        lead_id, client, sales, teamleader, details, resv_date, contract_date, 
        cancel_date, soldprice, downpayment, installments, instyears, 
        totalbefordisc, level
    ";

    // ✅ حساب العدد الكلي
    $totalCount = Units::model()->count($criteria);

    // ✅ تطبيق limit و offset
    $criteria->limit  = $limit;
    $criteria->offset = $offset;

    // ✅ جلب البيانات
    $units = Units::model()->findAll($criteria);
    $data = [];
    foreach ($units as $unit) {
        $data[] = $unit->attributes;
    }

    // ✅ الرد النهائي
    $pages = ($totalCount > 0) ? ceil($totalCount / $limit) : 0;
    echo json_encode([
        'status'      => true,
        'totalCount'  => $totalCount,
        'limit'       => $limit,
        'offset'      => $offset,
        'pages'       => $pages,
        'returned'    => count($data),
        'data'        => $data,
    ]);
    Yii::app()->end();
}


    
    
    
    public function actionGetAllInstallments()
{
    header('Content-Type: application/json; charset=utf-8');

    try {
        // 1) التوقيت
        $main = Mainsettings::model()->findByPk(1);
        if ($main && !empty($main->countrytimezone)) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }

        $req = Yii::app()->request;

        // 2) التوكن (أنصح لاحقاً ننقله للهيدر X-API-KEY)
        $token = $req->getQuery('token');
        $VALID_TOKEN = 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3';
        if ($token !== $VALID_TOKEN) {
            echo CJSON::encode(['status'=>false,'message'=>'Unauthorized or missing token']);
            Yii::app()->end();
        }

        // 3) بارامترز شائعة لأقساط (عدّل الأسماء حسب جدولك لو بتختلف)
        $id            = $req->getQuery('id');
        $lead_id       = $req->getQuery('lead_id');
        $customer_id   = $req->getQuery('customer_id');
        $contract_id   = $req->getQuery('contract_id');
        $project_id    = $req->getQuery('project_id');
        $unit_id       = $req->getQuery('unit_id');

        $status        = $req->getQuery('status');       // نص/كود حالة القسط
        $method        = $req->getQuery('method');       // طريقة الدفع (cash, bank, ...)

        $paid          = $req->getQuery('paid');         // '1'، '0'، غير ذلك تجاهُل
        $overdue       = $req->getQuery('overdue');      // أي قيمة => متأخر
        $due_today     = $req->getQuery('due_today');    // أي قيمة => مستحق اليوم

        $due_from      = $req->getQuery('due_from');     // d-m-Y أو Y-m-d
        $due_to        = $req->getQuery('due_to');
        $date_from     = $req->getQuery('date_from');    // تاريخ إنشاء/إضافة
        $date_to       = $req->getQuery('date_to');

        $amount_min    = $req->getQuery('amount_min');
        $amount_max    = $req->getQuery('amount_max');

        $receipt_no    = $req->getQuery('receipt_no');   // رقم إيصال/مرجع
        $notes         = $req->getQuery('notes');

        $limit  = (int) $req->getQuery('limit', 100);
        $offset = (int) $req->getQuery('offset', 0);
        if ($limit > 500) $limit = 500;
        if ($limit < 1)   $limit = 100;
        if ($offset < 0)  $offset = 0;

        // helper: parse date
        $parseDate = function ($val) {
            if (!$val) return null;
            $d1 = DateTime::createFromFormat('d-m-Y', $val);
            if ($d1 && $d1->format('d-m-Y') === $val) return $d1->format('Y-m-d');
            $d2 = DateTime::createFromFormat('Y-m-d', $val);
            if ($d2 && $d2->format('Y-m-d') === $val) return $d2->format('Y-m-d');
            return null;
        };

        $criteria = new CDbCriteria();
        $criteria->alias = 't';
        $criteria->order = 't.id DESC';

        // 4) فلاتر مباشرة بالأرقام/المفاتيح
        if (!empty($id))          $criteria->compare('t.id', (int)$id);
        if (!empty($lead_id))     $criteria->compare('t.lead_id', (int)$lead_id);
        if (!empty($customer_id)) $criteria->compare('t.customer_id', (int)$customer_id);
        if (!empty($contract_id)) $criteria->compare('t.contract_id', (int)$contract_id);
        if (!empty($project_id))  $criteria->compare('t.project_id', (int)$project_id);
        if (!empty($unit_id))     $criteria->compare('t.unit_id', (int)$unit_id);

        if ($status !== null && $status !== '') $criteria->compare('t.status', $status);
        if ($method !== null && $method !== '') $criteria->compare('t.method', $method);

        if ($receipt_no !== null && $receipt_no !== '') {
            // لو عايز بحث جزئي:
            $criteria->compare('t.receipt_no', $receipt_no, true);
        }

        if ($notes !== null && $notes !== '') {
            $criteria->compare('t.notes', $notes, true);
        }

        // 5) تواريخ الاستحقاق (due_date)
        $dueFrom = $parseDate($due_from);
        $dueTo   = $parseDate($due_to);
        if ($dueFrom && $dueTo) {
            $criteria->addBetweenCondition('t.due_date', $dueFrom, $dueTo);
        }

        // 6) تواريخ الإنشاء/الإدخال (created_at أو date) — غيّر اسم الحقل لو مختلف
        $createdFrom = $parseDate($date_from);
        $createdTo   = $parseDate($date_to);
        if ($createdFrom && $createdTo) {
            // استخدم t.created_at لو ده اسم الحقل عندك
            $criteria->addBetweenCondition('t.created_at', $createdFrom, $createdTo);
        }

        // 7) مدى المبلغ
        if ($amount_min !== null && $amount_min !== '' && $amount_max !== null && $amount_max !== '') {
            $criteria->addBetweenCondition('t.amount', (float)$amount_min, (float)$amount_max);
        } elseif ($amount_min !== null && $amount_min !== '') {
            $criteria->addCondition('t.amount >= :amin');
            $criteria->params[':amin'] = (float)$amount_min;
        } elseif ($amount_max !== null && $amount_max !== '') {
            $criteria->addCondition('t.amount <= :amax');
            $criteria->params[':amax'] = (float)$amount_max;
        }

        // 8) paid tri-state
        // نفترض وجود t.paid (0/1) و t.payment_date (قد تكون NULL)
        if ($paid !== null) {
            if ((string)$paid === '1') {
                $criteria->compare('t.paid', 1);
            } elseif ((string)$paid === '0') {
                $criteria->addCondition('(t.paid = 0 OR t.paid IS NULL)');
            }
        }

        // 9) due_today & overdue
        $today = date('Y-m-d');
        if ($due_today !== null) {
            $criteria->addBetweenCondition('t.due_date', $today, $today);
        }
        if ($overdue !== null) {
            // متأخر: تاريخ الاستحقاق < اليوم ولم يُسدد بعد
            // غيّر المنطق لو نظامك يعتمد على payment_date فقط
            $criteria->addCondition('t.due_date < :today AND (t.paid = 0 OR t.paid IS NULL)');
            $criteria->params[':today'] = $today;
        }

        // 10) اجمالي السجلات قبل الـ pagination
        $countCriteria = clone $criteria;
        $totalCount = (int) Installments::model()->count($countCriteria);

        // 11) جلب الدُفعة
        $criteria->limit  = $limit;
        $criteria->offset = $offset;

        // بإمكانك تقليل الأعمدة:
        // $criteria->select = 't.id,t.lead_id,t.customer_id,t.contract_id,t.project_id,t.unit_id,t.amount,t.paid,t.method,t.receipt_no,t.due_date,t.payment_date,t.status,t.created_at,t.notes';

        $rows = Installments::model()->findAll($criteria);

        $data = [];
        foreach ($rows as $r) {
            $data[] = $r->attributes;
        }

        $pages = ($totalCount > 0) ? (int)ceil($totalCount / $limit) : 0;

        echo CJSON::encode([
            'status'     => true,
            'totalCount' => $totalCount,
            'limit'      => $limit,
            'offset'     => $offset,
            'returned'   => count($data),
            'pages'      => $pages,
            'data'       => $data,
        ]);
        Yii::app()->end();

    } catch (Exception $e) {
        echo CJSON::encode([
            'status'  => false,
            'message' => 'server_error',
            'error'   => $e->getMessage(),
        ]);
        Yii::app()->end();
    }
}

    
       
public function actionGetAllLeadsbdm()
{
    // ===== Shared: timezone + token (required) =====
    $main = Mainsettings::model()->findByPk(1);
    date_default_timezone_set($main->countrytimezone ?: 'Africa/Cairo');

    header('Content-Type: application/json; charset=UTF-8');
    $token = $_GET['token'] ?? $_POST['token'] ?? null;
    if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
        echo CJSON::encode(['status' => false, 'message' => 'Unauthorized or missing token']);
        Yii::app()->end();
    }

    // --- Pagination & ordering ---
    $limit    = (int)$this->getParam('limit', 1000);
    if ($limit <= 0) $limit = 1000;
    if ($limit > 500000) $limit = 500000;

    $offset   = (int)$this->getParam('offset', 0);
    if ($offset < 0) $offset = 0;

    $orderBy  = $this->sanitizeOrderBy($this->getParam('order_by', 'l.id'));
    $orderDir = strtoupper($this->getParam('order_dir', 'DESC')) === 'ASC' ? 'ASC' : 'DESC';

    $db = Yii::app()->db;

    $wheres = array();
    $params = array();
    $joinActivitiesMax = false;

    // ==============
    // Normalizers
    // ==============
    $parseDMYorYMD = function($s) {
        if ($s === null || $s === '') return null;
        $d = DateTime::createFromFormat('d-m-Y', $s);
        if (!$d) $d = DateTime::createFromFormat('Y-m-d', $s);
        return $d ? $d->format('Y-m-d') : null;
    };

    // ============================
    // Combined filter set (SQL)
    // ============================

    // From V2: leader_id -> user_sales IN (team)
    $leaderId = $this->getParamInt('leader_id', null);
    if ($leaderId !== null) {
        $salesIds = $this->getTeamSalesByLeaderIds($leaderId);
        if (empty($salesIds)) {
            echo CJSON::encode([
                'items'        => [],
                'total'        => 0,
                'filters_echo' => $this->echoFilters(),
                'limit'        => $limit,
                'offset'       => $offset,
                'order_by'     => $orderBy,
                'order_dir'    => $orderDir,
            ]);
            Yii::app()->end();
        }
        $in = $this->bindArray($params, 'ls_', $salesIds);
        $wheres[] = "l.user_sales IN ($in)";
    }

    // employee[] -> user_sales IN (...)
    $employee = $this->getParamIntArray('employee');
    if (!empty($employee)) {
        $in = $this->bindArray($params, 'emp_', $employee);
        $wheres[] = "l.user_sales IN ($in)";
    }

    // user (alias of user_sales) -> allow multi
    $userArr = $this->getParam('user', null);
    $userIds = $this->normalizeMaybeArray($userArr);
    $userIds = array_values(array_filter(array_map('intval', $userIds), function($v){ return $v !== 0 || $v === 0; }));
    if (!empty($userIds)) {
        $in = $this->bindArray($params, 'u_', $userIds);
        $wheres[] = "l.user_sales IN ($in)";
    }

    // New: exceptuser (exclude specific user_sales IDs) -> allow multi
    $exceptuserRaw = $this->getParam('exceptuser', null);
    $exceptUsers = $this->normalizeMaybeArray($exceptuserRaw);
    $exceptIds = array_values(array_filter(array_map('intval', $exceptUsers), function($v){ return $v !== 0 || $v === 0; }));
    if (!empty($exceptIds)) {
        $in = $this->bindArray($params, 'xusr_', $exceptIds);
        // allow NULL or not in excluded list (consistent with except_* style)
        $wheres[] = "(l.user_sales IS NULL OR l.user_sales NOT IN ($in))";
    }

    // id (single)
    $id = $this->getParamInt('id', null);
    if ($id !== null) {
        $wheres[] = "l.id = :f_id";
        $params[':f_id'] = $id;
    }

    // phone (single; exact match)
    $phone = $this->getParam('phone', null);
    if ($phone !== null && $phone !== '') {
        if (substr($phone, 0, 1) === '0') $phone = substr($phone, 1);
        $wheres[] = "l.tel = :f_phone";
        $params[':f_phone'] = $phone;
    }

    // ============================
    // unit_type via TypeBuliding tree (already supports multi)
    // ============================
    $usedUnitTypeTree = false;

    $rows = Yii::app()->db->createCommand("
        SELECT id, title, parent_id
        FROM type_buliding
        WHERE hidden = 1
    ")->queryAll();

    $childrenOf = []; $existsId = [];
    foreach ($rows as $r) {
        $tid  = (int)$r['id'];
        $pid = $r['parent_id'] !== null ? (int)$r['parent_id'] : null;
        $existsId[$tid] = true;
        if (!array_key_exists($pid, $childrenOf)) $childrenOf[$pid] = [];
        $childrenOf[$pid][] = $tid;
    }

    $getDescendantsInclSelf = function($rootId) use (&$childrenOf) {
        $stack = [$rootId];
        $out   = [];
        while (!empty($stack)) {
            $cur = array_pop($stack);
            if (isset($out[$cur])) continue;
            $out[$cur] = true;
            if (!empty($childrenOf[$cur])) {
                foreach ($childrenOf[$cur] as $ch) $stack[] = (int)$ch;
            }
        }
        return array_map('intval', array_keys($out));
    };

    $unitTypeParam = $this->getParam('unit_type', null);
    $selected = [];
    if ($unitTypeParam !== null) {
        $raw = $this->normalizeMaybeArray($unitTypeParam);
        foreach ($raw as $v) {
            $vid = (int)$v;
            if (isset($existsId[$vid])) $selected[] = $vid;
        }
    }

    if (!empty($selected)) {
        $finalIds = [];
        foreach ($selected as $sid) {
            foreach ($getDescendantsInclSelf($sid) as $d) $finalIds[$d] = true;
        }
        $finalIds = array_map('intval', array_keys($finalIds)); // unique

        if (!empty($finalIds)) {
            $in = $this->bindArray($params, 'ut_', $finalIds);
            $wheres[] = "l.unit_type IN ($in)";
            $usedUnitTypeTree = true;
        }
    }

    // 1st Code (Prefix)
    $codePrefix = $this->getParam('code_prefix', null);
    if ($codePrefix !== null && $codePrefix !== '') {
        $wheres[] = "l.code LIKE :code_prefix";
        $params[':code_prefix'] = $codePrefix . '%';
        // note: could accept multi prefixes if needed (not typical)
    }

    // except_platform[] (already multi)
    $exceptPlatform = $this->getParamIntArray('except_platform');
    if (!empty($exceptPlatform)) {
        $in = $this->bindArray($params, 'xpf_', $exceptPlatform);
        $wheres[] = "(l.platform_id IS NULL OR l.platform_id NOT IN ($in))";
    }

    // except_campaign[] (already multi)
    $exceptCampaign = $this->getParamIntArray('except_campaign');
    if (!empty($exceptCampaign)) {
        $in = $this->bindArray($params, 'xcp_', $exceptCampaign);
        $wheres[] = "(l.campaign_id IS NULL OR l.campaign_id NOT IN ($in))";
    }

    // place_field + place_value(s) (already multi)
    $placeField = $this->getParamEnum('place_field', array('city','country','area'), null);
    $placeValues = $this->normalizeMaybeArray($this->getParam('place_value', null));
    if ($placeField && !empty($placeValues)) {
        if ($placeField === 'area') {
            $placeValues = array_values(array_filter(array_map('intval', $placeValues), function($v){ return $v !== 0 || $v === 0; }));
            if (!empty($placeValues)) {
                $in = $this->bindArray($params, 'ar_', $placeValues);
                $wheres[] = "l.area IN ($in)";
            }
        } else {
            $in = $this->bindArray($params, 'pl_', $placeValues, true);
            $wheres[] = "l.$placeField IN ($in)";
        }
    }

    // transfer_user[], transfer_from[] (already multi)
    $transferUser = $this->getParamIntArray('transfer_user');
    if (!empty($transferUser)) {
        $in = $this->bindArray($params, 'tu_', $transferUser);
        $wheres[] = "l.transferuser IN ($in)";
    }
    $transferFrom = $this->getParamIntArray('transfer_from');
    if (!empty($transferFrom)) {
        $in = $this->bindArray($params, 'tf_', $transferFrom);
        $wheres[] = "l.transferfrom IN ($in)";
    }

    // accounts yes/no
    $accounts = $this->getParamEnum('accounts', array('yes','no'), null);
    if ($accounts === 'yes') {
        $wheres[] = "(l.coldcall IS NOT NULL)";
    } elseif ($accounts === 'no') {
        $wheres[] = "(l.coldcall IS NULL)";
    }

    // except_transfer_today
    $exceptToday = $this->getParamInt('except_transfer_today', 0);
    if ($exceptToday === 1) {
        $today = date('Y-m-d');
        $wheres[] = "(l.transferdate IS NULL OR LEFT(l.transferdate,10) <> :today_s)";
        $params[':today_s'] = $today;
    }

    // locale_scope local/global
    $locale = $this->getParamEnum('locale_scope', array('local','global'), null);
    if ($locale === 'local') {
        $in = $this->bindArray($params, 'eg_', array('Egypt','EG','EGY'), true);
        $wheres[] = "(l.country IN ($in))";
    } elseif ($locale === 'global') {
        $in = $this->bindArray($params, 'eg_', array('Egypt','EG','EGY'), true);
        $wheres[] = "(l.country IS NOT NULL AND l.country NOT IN ($in))";
    }

    // communication / transfer / close (flags) — single
    $communication = $this->getParam('communication', null);
    if ($communication !== null) {
        if ((string)$communication === '1') $wheres[] = "l.communication = 1";
        else $wheres[] = "l.communication IS NULL";
    }

    $transfer = $this->getParam('transfer', null);
    if ($transfer !== null) {
        if ((string)$transfer === '1') $wheres[] = "l.transfer = 1";
        else $wheres[] = "l.transfer IS NULL";
    }

    $close = $this->getParam('close', null);
    if ($close !== null) {
        if ((string)$close === '1') $wheres[] = "l.close = 1";
        else $wheres[] = "l.close IS NULL";
    }

    // followup (today) — single toggle
    $followup = $this->getParam('followup', null);
    if ($followup !== null) {
        $today = date('Y-m-d');
        $wheres[] = "(l.follow_date BETWEEN :fup_from AND :fup_to)";
        $params[':fup_from'] = $today;
        $params[':fup_to']   = $today;
    }

    // delay (<= yesterday)
    $delay = $this->getParam('delay', null);
    if ($delay !== null) {
        $yesterday = date('Y-m-d', strtotime('-1 day'));
        $wheres[] = "l.follow_date <= :f_delay_to";
        $params[':f_delay_to'] = $yesterday;
    }

    // Date ranges
    $startdate = $parseDMYorYMD($this->getParam('startdate', null));
    $enddate   = $parseDMYorYMD($this->getParam('enddate', null));
    if ($startdate && $enddate) {
        $wheres[] = "(l.date BETWEEN :ld_from AND :ld_to)";
        $params[':ld_from'] = $startdate;
        $params[':ld_to']   = $enddate;
    }

    $startfollowdate = $parseDMYorYMD($this->getParam('startfollowdate', null));
    $endfollowdate   = $parseDMYorYMD($this->getParam('endfollowdate', null));
    if ($startfollowdate && $endfollowdate) {
        $wheres[] = "(l.follow_date BETWEEN :lfd_from AND :lfd_to)";
        $params[':lfd_from'] = $startfollowdate;
        $params[':lfd_to']   = $endfollowdate;
    }

    $starttransferdate = $parseDMYorYMD($this->getParam('starttransferdate', null));
    $endtransferdate   = $parseDMYorYMD($this->getParam('endtransferdate', null));
    if ($starttransferdate && $endtransferdate) {
        $wheres[] = "(LEFT(l.transferdate,10) BETWEEN :ltd_from AND :ltd_to)";
        $params[':ltd_from'] = $starttransferdate;
        $params[':ltd_to']   = $endtransferdate;
    }

    $startlastactiondate = $parseDMYorYMD($this->getParam('startlastactiondate', null));
    $endlastactiondate   = $parseDMYorYMD($this->getParam('endlastactiondate', null));
    if ($startlastactiondate && $endlastactiondate) {
        $wheres[] = "(LEFT(l.checkup_activity,10) BETWEEN :ltd_from AND :ltd_to)";
        $params[':ltd_from'] = $startlastactiondate;
        $params[':ltd_to']   = $endlastactiondate;
    }

    // ==== Equality filters (now multi) ====
    // NOTE: unit_type handled above via tree; if لم يُستخدم، هنسمح بقيمة/قائمة مباشرة
    $multiEqInt = [
        'project_id','marketing_id','interest_id',
        'campaign_id','platform_id','platformchild_id',
        'status','substatus','fresh_sales',
        'property_type','client_type'
    ];
    foreach ($multiEqInt as $k) {
        $vals = $this->getParam($k, null);
        $arr  = $this->normalizeMaybeArray($vals);
        $arr  = array_values(array_filter(array_map('intval', $arr), function($v){ return $v !== 0 || $v === 0; }));
        if (!empty($arr)) {
            $in = $this->bindArray($params, "eq_{$k}_", $arr);
            $wheres[] = "l.$k IN ($in)";
        }
    }

    // لو الشجرة ما استخدمتش: اقبل unit_type كـ multi مباشرة
    if (!$usedUnitTypeTree) {
        $utVals = $this->getParam('unit_type', null);
        $utArr  = $this->normalizeMaybeArray($utVals);
        $utArr  = array_values(array_filter(array_map('intval', $utArr), function($v){ return $v !== 0 || $v === 0; }));
        if (!empty($utArr)) {
            $in = $this->bindArray($params, 'eq_unit_type_', $utArr);
            $wheres[] = "l.unit_type IN ($in)";
        }
    }

    // user_sales direct (allow multi)
    $userSalesVals = $this->getParam('user_sales', null);
    $userSalesArr  = $this->normalizeMaybeArray($userSalesVals);
    $userSalesArr  = array_values(array_filter(array_map('intval', $userSalesArr), function($v){ return $v !== 0 || $v === 0; }));
    if (!empty($userSalesArr)) {
        $in = $this->bindArray($params, 'us_', $userSalesArr);
        $wheres[] = "l.user_sales IN ($in)";
    }

    // =========================
    // Build SQL & Execute
    // =========================
    $whereSql = empty($wheres) ? '' : ('WHERE ' . implode(' AND ', $wheres));

    $joinSql = '';
    if ($joinActivitiesMax) {
        $joinSql = "LEFT JOIN (
            SELECT a.leads_id, MAX(a.date) AS maxdate
            FROM activities a
            WHERE a.leads_id IS NOT NULL
            GROUP BY a.leads_id
        ) amax ON amax.leads_id = l.id";
    }

    // total count
    $countSql = "SELECT COUNT(1) AS cnt
                 FROM leads l
                 $joinSql
                 $whereSql";
    $cmdCount = $db->createCommand($countSql);
    foreach ($params as $k => $v) $cmdCount->bindValue($k, $v);
    $total = (int)$cmdCount->queryScalar();

    // items
    $selectCols = "l.*";
    if ($joinActivitiesMax) $selectCols .= ", amax.maxdate AS last_action_date";

    $itemsSql = "SELECT $selectCols
                 FROM leads l
                 $joinSql
                 $whereSql
                 ORDER BY $orderBy $orderDir
                 LIMIT :lim OFFSET :off";
    $cmdItems = $db->createCommand($itemsSql);
    foreach ($params as $k => $v) $cmdItems->bindValue($k, $v);
    $cmdItems->bindValue(':lim', $limit, PDO::PARAM_INT);
    $cmdItems->bindValue(':off', $offset, PDO::PARAM_INT);
    $rows = $cmdItems->queryAll();

    echo CJSON::encode([
        'status'      => true,
        'items'       => $rows,
        'total'       => $total,
        'filters_echo'=> $this->echoFilters(),
        'limit'       => $limit,
        'offset'      => $offset,
        'order_by'    => $orderBy,
        'order_dir'   => $orderDir,
    ]);
    Yii::app()->end();
}

    // =========================================================================
    // Helpers
    // =========================================================================

    /** Lightweight JSON response helper */
    protected function json($data, $status = 200)
    {
        // Some stacks use renderJSON; keep it simple here
        header('Content-Type: application/json; charset=UTF-8');
        http_response_code($status);
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    /** Read scalar param (string) with default */
    protected function getParam($name, $default = null)
    {
        if (isset($_GET[$name])) return $_GET[$name];
        if (isset($_POST[$name])) return $_POST[$name];
        return $default;
    }

    /** Read integer param with default */
    protected function getParamInt($name, $default = null)
    {
        $v = $this->getParam($name, null);
        if ($v === null || $v === '') return $default;
        return (int)$v;
    }

    /** Read enum with whitelist */
    protected function getParamEnum($name, array $allowed, $default = null)
    {
        $v = $this->getParam($name, null);
        if ($v === null) return $default;
        return in_array($v, $allowed, true) ? $v : $default;
    }

    /** Read 'YYYY-MM-DD' date; returns string or null */
    protected function getParamDate($name, $default = null)
    {
        $v = $this->getParam($name, null);
        if ($v === null || $v === '') return $default;
        $d = date_create_from_format('Y-m-d', $v);
        return $d ? date_format($d, 'Y-m-d') : $default;
    }

    /**
     * Accepts param as CSV string or array; returns int[] (unique, sanitized)
     * Recognizes formats:
     * - employee[]=1&employee[]=2
     * - employee=1,2,3
     */
    protected function getParamIntArray($name)
    {
        $raw = $this->getParam($name, null);
        if ($raw === null) {
            // check for array form in $_GET/$_POST
            if (isset($_GET[$name]) && is_array($_GET[$name])) $raw = $_GET[$name];
            if (isset($_POST[$name]) && is_array($_POST[$name])) $raw = $_POST[$name];
        }

        $out = array();
        if ($raw === null) return $out;

        if (is_array($raw)) {
            foreach ($raw as $v) {
                if ($v === '' || $v === null) continue;
                $out[] = (int)$v;
            }
        } else {
            // CSV
            $parts = preg_split('/[,\s]+/', (string)$raw, -1, PREG_SPLIT_NO_EMPTY);
            foreach ($parts as $p) {
                $out[] = (int)$p;
            }
        }

        $out = array_values(array_unique($out));
        return $out;
    }

    /** Normalize possibly CSV or array string to array of strings */
    protected function normalizeMaybeArray($value)
    {
        if ($value === null) {
            // Also check raw superglobals for array form
            return array();
        }
        if (is_array($value)) {
            return array_values(array_filter(array_map(function($v){
                return trim((string)$v);
            }, $value), function($v){ return $v !== ''; }));
        }
        $parts = preg_split('/,/', (string)$value);
        $parts = array_map('trim', $parts);
        $parts = array_values(array_filter($parts, function($v){ return $v !== ''; }));
        return $parts;
    }

    /**
     * Bind an array to named placeholders.
     * @param array $params ref
     * @param string $prefix
     * @param array $values
     * @param bool $asString use PDO::PARAM_STR if true
     * @return string placeholder list e.g. :p0,:p1,...
     */
    protected function bindArray(&$params, $prefix, array $values, $asString = false)
    {
        $holders = array();
        $i = 0;
        foreach ($values as $v) {
            $name = ':' . $prefix . $i++;
            $holders[] = $name;
            $params[$name] = $v;
        }
        return implode(',', $holders);
    }

    /** Sanitize ORDER BY to whitelist known columns only */
    protected function sanitizeOrderBy($orderBy)
    {
        // Whitelist a few safe columns; extend as needed
        $allowed = array(
            'l.id','l.date','l.time','l.user_sales','l.status','l.campaign_id','l.platform_id','l.status_date','l.substatus_date'
        );
        // Allow last_action_date if joined
        $allowed[] = 'last_action_date';

        if (in_array($orderBy, $allowed, true)) return $orderBy;
        return 'l.id';
    }

    /**
     * Resolve team sales IDs for a leader.
     * Uses the teamleader table described in your schema:
     * - teamleader.leader_id = :leader_id
     * - teamleader.sales_id  -> the user IDs of team members
     */
    protected function getTeamSalesByLeaderIds($leaderId)
    {
        $leaderId = (int)$leaderId;
        if ($leaderId <= 0) return array();

        $sql = "SELECT DISTINCT t.sales_id
                FROM teamleader t
                WHERE t.leader_id = :lid AND t.sales_id IS NOT NULL";
        $cmd = Yii::app()->db->createCommand($sql);
        $cmd->bindValue(':lid', $leaderId, PDO::PARAM_INT);
        $rows = $cmd->queryColumn();

        $out = array();
        foreach ($rows as $v) {
            $iv = (int)$v;
            if ($iv !== 0) $out[] = $iv;
        }
        return array_values(array_unique($out));
    }

    /** Echo back filters for debugging/traceability */
    protected function echoFilters()
    {
        // Return raw request values as sent (no secrets)
        $keys = array(
            'leader_id','employee','order_type','last_action_from','last_action_to','code_prefix',
            'except_platform','except_campaign','place_field','place_value',
            'transfer_user','transfer_from','accounts','except_transfer_today','locale_scope'
        );
        $out = array();
        foreach ($keys as $k) {
            if (isset($_GET[$k])) {
                $out[$k] = $_GET[$k];
            } elseif (isset($_POST[$k])) {
                $out[$k] = $_POST[$k];
            }
        }
        return $out;
    }

    // =========================================================================
    // DO NOT MODIFY your existing actionGetAllLeads. Keep it intact in your code.
    // If it's in another file or already below, leave it untouched.
    // =========================================================================
    // public function actionGetAllLeads() { ... }  // <- your existing endpoint


    
    public function actionGetAllLeads() {
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
        $token         = isset($_GET['token'])         ? $_GET['token']         : null;
        $userSales     = isset($_GET['user'])          ? $_GET['user']          : null;
        $communication = isset($_GET['communication']) ? $_GET['communication'] : null;
        $transfer      = isset($_GET['transfer'])         ? $_GET['transfer']         : null;
        $close      = isset($_GET['close'])         ? $_GET['close']         : null;
        $type      = isset($_GET['type'])         ? $_GET['type']         : null;
        $followup      = isset($_GET['followup'])         ? $_GET['followup']         : null;
        $delay      = isset($_GET['delay'])         ? $_GET['delay']         : null;
        $startfollowdate      = isset($_GET['startfollowdate'])         ? $_GET['startfollowdate']         : null;
        $endfollowdate      = isset($_GET['endfollowdate'])         ? $_GET['endfollowdate']         : null;
        $id      = isset($_GET['id'])         ? $_GET['id']         : null;
        $phone      = isset($_GET['phone'])         ? $_GET['phone']         : null;
        $status      = isset($_GET['status'])         ? $_GET['status']         : null;
        $tel      = isset($_GET['tel'])         ? $_GET['tel']         : null;
        $title      = isset($_GET['title'])         ? $_GET['title']         : null;
        $date_from      = isset($_GET['date_from'])         ? $_GET['date_from']         : null;
        $date_to      = isset($_GET['date_to'])         ? $_GET['date_to']         : null;
        $notes      = isset($_GET['notes'])         ? $_GET['notes']         : null;
        $project_id      = isset($_GET['project_id'])         ? $_GET['project_id']         : null;
        $campaign_id      = isset($_GET['campaign_id'])         ? $_GET['campaign_id']         : null;
        $interest_id      = isset($_GET['interest_id'])         ? $_GET['interest_id']         : null;
        $platform_id      = isset($_GET['platform_id'])         ? $_GET['platform_id']         : null;
        $platformchild_id      = isset($_GET['platformchild_id'])         ? $_GET['platformchild_id']         : null;
        $client_id      = isset($_GET['client_id'])         ? $_GET['client_id']         : null;

     
        header('Content-Type: application/json');
        if ('ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3' !== $token) {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        if ($limit > 500) {
            $limit = 500;
        }
        $criteria = new CDbCriteria();
        if (!empty($startfollowdate) && !empty($endfollowdate)) {
            $startObj = DateTime::createFromFormat('d-m-Y', $startfollowdate);
            $endObj   = DateTime::createFromFormat('d-m-Y', $endfollowdate);
            if ($startObj && $endObj) {
                $start = $startObj->format('Y-m-d');
                $end   = $endObj->format('Y-m-d');
                $criteria->addBetweenCondition(
                    'follow_date',
                    $start,
                    $end
                );
            }
        }
        
        if (!empty($date_from) && !empty($date_to)) {
            $startObjfrom = DateTime::createFromFormat('d-m-Y', $date_from);
            $endObjfrom   = DateTime::createFromFormat('d-m-Y', $date_to);
            if ($startObj && $endObj) {
                $startfrom = $startObjfrom->format('Y-m-d');
                $endfrom   = $endObjfrom->format('Y-m-d');
                $criteria->addBetweenCondition(
                    'date',
                    $startfrom,
                    $endObjfrom
                );
            }
        }

        if ($id !== null) {
            $criteria->compare('id', $id);
        }
        if ($phone !== null) {
            if (substr($phone, 0, 1) === '0') {
                $phone = substr($phone, 1);
            }
            $criteria->compare('tel', $phone);
        }
        
        
        
        if (!empty($tel)) {
         //   var_dump($tel);exit;
        $where .= ' AND l.tel = :tel';
        $params[':tel'] = $tel;
        }

       
       
        
        if ($notes !== null) {
        
        $criteria->compare('note', $notes);
        
        //   $where .= ' AND l.title = :title';
        //   $params[':title'] = $title;
        }
        
        
         
        if ($campaign_id !== null) {
        
        $criteria->compare('campaign_id', $campaign_id);
        
        //   $where .= ' AND l.title = :title';
        //   $params[':title'] = $title;
        }
        
         if ($platform_id !== null) {
        
        $criteria->compare('platform_id', $platform_id);
        
        //   $where .= ' AND l.title = :title';
        //   $params[':title'] = $title;
        }
        
         if ($platformchild_id !== null) {
        
        $criteria->compare('platformchild_id', $platformchild_id);
        
        //   $where .= ' AND l.title = :title';
        //   $params[':title'] = $title;
        }


         if ($client_id !== null) {
        
        $criteria->compare('client_id', $client_id);
        
        //   $where .= ' AND l.title = :title';
        //   $params[':title'] = $title;
        }


    
        if ($title !== null) {
        
        $criteria->compare('title', $title);
        
        //   $where .= ' AND l.title = :title';
        //   $params[':title'] = $title;
        }
    
    
    
    
    
    
     if ($status !== null) {
            $criteria->compare('status', $status);
        }
        if ($followup !== null) {
            $today = date('Y-m-d');
            $criteria->addBetweenCondition(
                'follow_date', $today, $today
            );
        }
        if ($delay !== null) {
            $yesterday = date('Y-m-d', strtotime('-1 day'));
            $criteria->addCondition("follow_date <= :yesterday");
            $criteria->params[':yesterday'] = $yesterday;
        }
        if ($userSales !== null) {
            $criteria->compare('user_sales', $userSales);
        }
        if ($communication !== null) {
            if ((string)$communication === '1') {
                $criteria->compare('communication', 1);
            } else {
                $criteria->addCondition('communication IS NULL');
            
            }
        }
    
       
        
        
        if ($transfer !== null) {
        // عند value = '1'، نُشترط أن يكون transfer = 1 فقط
        if ((string)$transfer === '1') {
        $criteria->compare('transfer', 1);
        } else {
        $criteria->addCondition('transfer IS NULL');
    
        }
        }
        
        
        if ($close !== null) {
        // عند value = '1'، نُشترط أن يكون transfer = 1 فقط
        if ((string)$close === '1') {
        $criteria->compare('close', 1);
        } else {
            
        $criteria->addCondition('close IS NULL');
    
        }
        }
        
        
        
        
      
      
      if ($type !== null) {
    
        switch ((string)$type) {
            case '1':
                // حالة 1: عرض السجلات اللي فيها coldcall فاضية (NULL)
                $criteria->addCondition('coldcall IS NULL');
                $criteria->addCondition('indirect IS NULL');
    
                break;
            case '2':
                // حالة 2: عرض السجلات المُغلقة فقط (close = 1)
                $criteria->addCondition('coldcall IS NOT NULL');
                $criteria->addCondition('indirect IS NULL');
    //var_dump(11);exit;
                break;
            case '3':
                // حالة 3: عرض السجلات غير المُغلقة (close = 0)
               // $criteria->compare('close', 0);
                //$criteria->addCondition('coldcall IS NOT NULL');
                $criteria->addCondition('indirect IS NOT NULL');
                
    
                break;
            default:
                // أي قيمة أخرى: ما نضيف شرط
                break;
        }
    }
    
        
    
        // لحساب totalCount لا تُضيف limit و offset
        $totalCount = Leads::model()->count($criteria);
    
        // بعد حساب totalCount، نضيف limit و offset لجلب الدُفعة
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب الدُفعة المحددة من السجلات
        $allLeads = Leads::model()->findAll($criteria);
    
        $result = [];
        foreach ($allLeads as $lead) {
            $result[] = $lead->attributes;
        }
    
        // حساب عدد الصفحات بالتقريب للأعلى
        $pages = ($totalCount > 0)
            ? (int) ceil($totalCount / $limit)
            : 0;
    
        // تجهيز الاستجابة بصيغة JSON مع معلومات pagination
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    

    public function actionGetAllActs() {
        
      //  var_dump(111);exit;
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token         = $_GET['token']         ?? null;
        $userSales     = $_GET['user']          ?? null;
        $close         = $_GET['close']         ?? null;
        $type          = $_GET['type']          ?? null;
        $followup      = $_GET['followup']      ?? null;
        $startfollowdate = $_GET['startfollowdate'] ?? null;
        $endfollowdate   = $_GET['endfollowdate']   ?? null;
        $lead   = $_GET['id']   ?? null;
        $hidden   = $_GET['hidden']   ?? null;
    
    
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 500); // أقصى حد 500
    
        $criteria = new CDbCriteria();
    
        // فلترة تاريخ follow_date: الأولوية لـ start/end، ثم followup، ثم delay
      
    
        // فلترة حسب المستخدم
        if ($userSales !== null) {
            $criteria->compare('user_id', $userSales);
        }
        
        
         if ($lead !== null) {
            $criteria->compare('leads_id', $lead);
        }
    
      
        if ($followup !== null) {
        $today = date('Y-m-d');
        $criteria->addBetweenCondition(
        'date',
        $today,
        $today
        );
        }
        
        // فلترة النوع
        if ($hidden !== null) {
            switch ((string)$hidden) {
                case '1':
                    $criteria->addCondition('hidden IS NULL');
                    break;
                case '2':
                    $criteria->addCondition('hidden IS NOT NULL');
                    break;
               
            }
        }
        
    
        // فلترة النوع
        if ($type !== null) {
            switch ((string)$type) {
                case '1':
                    $criteria->addCondition('coldcall IS NULL');
                    $criteria->addCondition('indirect IS NULL');
                    break;
                case '2':
                    $criteria->addCondition('coldcall IS NOT NULL');
                    $criteria->addCondition('indirect IS NULL');
                    break;
                case '3':
                    $criteria->addCondition('indirect IS NOT NULL');
                    break;
            }
        }
    
        // حساب عدد السجلات
        $totalCount = Activities::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allactivities = Activities::model()->findAll($criteria);
        $result = [];
        foreach ($allactivities as $activities) {
            $result[] = $activities->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionGetAllbrokers() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token = $_GET['token'] ?? null;
        $id    = $_GET['id']    ?? null;
        $user    = $_GET['user']    ?? null;
    
        header('Content-Type: application/json');
    
        // التحقق من التوكن
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // إعداد limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 500);
    
        // إعداد الكريتيريا
        $criteria = new CDbCriteria();
    
        // فلترة حسب الـ ID إن وجد
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
        
        
         if ($user !== null) {
            $criteria->compare('user_sales', $user);
        }
    
        // حساب العدد الكلي
        $totalCount = Brokers::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allBrokers = Brokers::model()->findAll($criteria);
        $result = [];
        foreach ($allBrokers as $broker) {
            $result[] = $broker->attributes;
        }
    
        // إعداد الرد
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    
    
    
    
    
  
    public function actionGetAllservices()
    {
        // 1) ضبط المنطقة الزمنية
        try {
            $main = Mainsettings::model()->findByPk(1);
            date_default_timezone_set(
                ($main && $main->countrytimezone) ? $main->countrytimezone : 'Africa/Cairo'
            );
        } catch (Exception $e) {
            date_default_timezone_set('Africa/Cairo');
        }

        // 2) الهيدر
        header('Content-Type: application/json; charset=UTF-8');

        // 3) التحقق من التوكن (من الهيدر Bearer أو من GET)
        $authHeader  = isset($_SERVER['HTTP_AUTHORIZATION']) ? trim($_SERVER['HTTP_AUTHORIZATION']) : '';
        $bearerToken = null;
        if (stripos($authHeader, 'Bearer ') === 0) {
            $bearerToken = substr($authHeader, 7);
        }
        $token = isset($_GET['token']) ? $_GET['token'] : $bearerToken;

        // التوكن المخزّن في الإعدادات
        $serverToken = Yii::app()->params['apiToken'] ?? null;

        // بديل مؤقت: هاردكود (احذفه في الإنتاج)
        $hardcoded = 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3';

        if (!$token || !hash_equals($serverToken ?: $hardcoded, $token)) {
            http_response_code(401);
            echo CJSON::encode([
                'status'  => false,
                'message' => 'Unauthorized',
                'code'    => 401,
            ]);
            Yii::app()->end();
        }

        // 4) بارامز الإدخال
        $id     = isset($_GET['id']) ? $_GET['id'] : null;
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;

        if ($limit <= 0)  $limit = 100;
        if ($offset < 0)  $offset = 0;
        $limit = min($limit, 500);

        if ($id !== null && !ctype_digit((string)$id)) {
            http_response_code(400);
            echo CJSON::encode([
                'status'  => false,
                'message' => 'Invalid id (must be integer).',
                'code'    => 400,
            ]);
            Yii::app()->end();
        }

        // 5) بناء الاستعلام
        $criteria = new CDbCriteria();
        $criteria->order = 't.id DESC';

        if ($id !== null) {
            $criteria->compare('t.id', (int)$id);
        }

        // لو عايز أعمدة محددة (أسرع وأأمن):
        // $criteria->select = 't.id, t.name, t.price, t.status, t.created_at';

        try {
            // إجمالي السجلات
            $totalCount = (int) Services::model()->count($criteria);

            // Pagination
            $criteria->limit  = $limit;
            $criteria->offset = $offset;

            // جلب البيانات
            $rows = Services::model()->findAll($criteria);

            // تجهيز الداتا
            $data = [];
            foreach ($rows as $row) {
                // لو محدد select فوق، يفضّل تبني المصفوفة يدويًا:
                // $data[] = [
                //     'id'         => (int)$row->id,
                //     'name'       => $row->name,
                //     'price'      => (float)$row->price,
                //     'status'     => $row->status,
                //     'created_at' => $row->created_at,
                // ];
                $data[] = $row->attributes; // مختصر لو مش محدد select
            }

            $pages = $limit > 0 ? (int)ceil($totalCount / $limit) : 0;

            http_response_code(200);
            echo CJSON::encode([
                'status'      => true,
                'totalCount'  => $totalCount,
                'limit'       => $limit,
                'offset'      => $offset,
                'returned'    => count($data),
                'pages'       => $pages,
                'data'        => $data,
            ]);
            Yii::app()->end();

        } catch (Exception $e) {
            Yii::log('GetAllservices error: ' . $e->getMessage(), CLogger::LEVEL_ERROR);
            http_response_code(500);
            echo CJSON::encode([
                'status'  => false,
                'message' => 'Internal server error',
                'code'    => 500,
            ]);
            Yii::app()->end();
        }
    }



public function actionGetAllUnits()
{
    header('Content-Type: application/json; charset=utf-8');

    try {
        // Timezone
        $main = Mainsettings::model()->findByPk(1);
        $tz   = $main && !empty($main->countrytimezone) ? $main->countrytimezone : 'Africa/Cairo';
        date_default_timezone_set($tz);

        // === Auth (Yii1 compatible) ===
        $headers = function_exists('getallheaders') ? getallheaders() : [];
        $auth    = isset($headers['Authorization']) ? $headers['Authorization'] : null;

        $token = null;
        if ($auth && stripos($auth, 'Bearer ') === 0) {
            $token = trim(substr($auth, 7));
        } elseif (!empty($_GET['token'])) {
            $token = $_GET['token']; // fallback للتجربة
        }

        $expectedToken = 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3';

        if (!$token || $token !== $expectedToken) {
            echo CJSON::encode([
                'status'  => false,
                'error'   => 'unauthorized',
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }

        // Inputs
        $id     = isset($_GET['id']) ? (int)$_GET['id'] : null;
        $limit  = isset($_GET['limit']) ? (int)$_GET['limit'] : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        if ($limit < 1)   $limit = 1;
        if ($limit > 500) $limit = 500;
        if ($offset < 0)  $offset = 0;

        // Criteria
        $criteria = new CDbCriteria();
        if ($id !== null) {
            $criteria->compare('id', $id);
        }

        $totalCount = Units::model()->count($criteria);

        $criteria->limit  = $limit;
        $criteria->offset = $offset;

        $rows = Units::model()->findAll($criteria);
        $data = [];
        foreach ($rows as $row) {
            $data[] = $row->attributes;
        }

        echo CJSON::encode([
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => $limit,
            'offset'      => $offset,
            'returned'    => count($data),
            'data'        => $data,
        ]);
        Yii::app()->end();

    } catch (Exception $e) {
        echo CJSON::encode([
            'status'  => false,
            'error'   => 'server_error',
            'message' => 'Unexpected server error',
            'detail'  => YII_DEBUG ? $e->getMessage() : null,
        ]);
        Yii::app()->end();
    }
}

    
   
    public function actionGetAllstatues() {
        
      //  var_dump(111);exit;
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token         = $_GET['token']         ?? null;
        $id     = $_GET['id']          ?? null;
       
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 500); // أقصى حد 500
    
        $criteria = new CDbCriteria();
    
        // فلترة تاريخ follow_date: الأولوية لـ start/end، ثم followup، ثم delay
      
    
        // فلترة حسب المستخدم
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
    
        // حساب عدد السجلات
        $totalCount = Statues::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allstatues = Statues::model()->findAll($criteria);
        $result = [];
        foreach ($allstatues as $statues) {
            $result[] = $statues->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionGetAllUsers() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token = $_GET['token'] ?? null;
        $id    = $_GET['id']    ?? null;
    
        header('Content-Type: application/json');
    
        // التحقق من التوكن
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 500); // الحد الأقصى 500
    
        $criteria = new CDbCriteria();
    
        // فلترة حسب id
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
        // حساب العدد الكلي
        $totalCount = User::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allUsers = User::model()->findAll($criteria);
        $result = [];
        foreach ($allUsers as $user) {
            $result[] = $user->attributes;
        }
    
        // إعداد الرد
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'     => true,
            'totalCount' => (int)$totalCount,
            'limit'      => (int)$limit,
            'offset'     => (int)$offset,
            'returned'   => count($result),
            'pages'      => $pages,
            'data'       => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionGetAllsubstatues() {
        
      //  var_dump(111);exit;
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token         = $_GET['token']         ?? null;
        $id     = $_GET['id']          ?? null;
        $status     = $_GET['status']          ?? null;
       
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 500); // أقصى حد 500
    
        $criteria = new CDbCriteria();
    
        // فلترة تاريخ follow_date: الأولوية لـ start/end، ثم followup، ثم delay
      
    
        // فلترة حسب المستخدم
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
        
        
         if ($status !== null) {
            $criteria->compare('parent_id', $status);
        }
    
      
      
        
        
    
        
    
    
        // حساب عدد السجلات
        $totalCount = Substatus::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allstatues = Substatus::model()->findAll($criteria);
        $result = [];
        foreach ($allstatues as $statues) {
            $result[] = $statues->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }

    public function actionGetAllstatuesforlead() {
        header('Content-Type: application/json');
    
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
    
        // التحقق من التوكن
        $token = $_GET['token'] ?? null;
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // إعداد limit و offset
        $limit  = min((int) ($_GET['limit'] ?? 100), 500);
        $offset = (int) ($_GET['offset'] ?? 0);
    
        // إعداد الاستعلام
        $id = $_GET['id'] ?? null;
        $criteria = new CDbCriteria();
        $criteria->order = "sort ASC, id ASC";
    
        // فقط الحالات التي clear = 1
    if ($id !== null) {
    $lead = Leads::model()->findByPk($id);
    if ($lead) {
        $status = $lead->status ? Statues::model()->findByPk($lead->status) : null;

        // لو communication = 1 → نفس منطقك الحالي
        if ((int)$lead->communication === 1) {
            if ($status) {
                $startingSort = (int)$status->sort;
                $criteria->addCondition("t.sort >= :startSort");
                $criteria->params[':startSort'] = $startingSort;
            }

            if ((int)$lead->visit === 1) {
                $criteria->addCondition('t.visit = 1');
            } else {
                $criteria->addCondition('t.clear = 1');
            }

        } else {
            // communication != 1 → رجّع كل الحالات اللي clear=1 بدون قصّ بـ startSort
            $criteria->addCondition('t.clear = 1');
            // لو عايز ترتيب فقط بدون فلترة بالبداية:
            $criteria->order = 't.sort ASC';

            // لو حابب تضم الـ NULL في sort في الآخر:
            // $criteria->order = 'ISNULL(t.sort) ASC, t.sort ASC';
        }
    }
}
    
        // حساب عدد السجلات
        $totalCount = Statues::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allstatues = Statues::model()->findAll($criteria);
        $result = [];
        foreach ($allstatues as $statues) {
            $result[] = $statues->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        echo json_encode([
            'status'      => true,
            'totalCount'  => $totalCount,
            'limit'       => $limit,
            'offset'      => $offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ]);
    
        Yii::app()->end();
    }
    
    public function actionGetAllstatuesforleadclose() {
        header('Content-Type: application/json');
    
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
    
        // التحقق من التوكن
        $token = $_GET['token'] ?? null;
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // إعداد limit و offset
        $limit  = min((int) ($_GET['limit'] ?? 100), 500);
        $offset = (int) ($_GET['offset'] ?? 0);
    
        // إعداد الاستعلام
        $criteria = new CDbCriteria();
        $criteria->order = "sort ASC, id ASC";
    
        // فقط الحالات التي clear = 2 (مغلقة)
        $criteria->addCondition("clear = 2");
    
        // لا نحتاج فلترة حسب lead أو الترتيب
        // فقط نفلتر visit إذا تم إرسال ID
        $id = $_GET['id'] ?? null;
        if ($id !== null) {
            $lead = Leads::model()->findByPk($id);
            if ($lead && (int)$lead->visit !== 1) {
                $criteria->addCondition("(visit IS NULL OR visit != 1)");
            }
        }
    
        // حساب عدد السجلات
        $totalCount = Statues::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allstatues = Statues::model()->findAll($criteria);
        $result = [];
        foreach ($allstatues as $statues) {
            $result[] = $statues->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        echo json_encode([
            'status'      => true,
            'totalCount'  => $totalCount,
            'limit'       => $limit,
            'offset'      => $offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ]);
    
        Yii::app()->end();
    }
 
 
 public function actionInsertLeadByUrl()
{
    header('Content-Type: application/json; charset=utf-8');

    $VALID_TOKEN = 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3';

    // === Helpers ===
    $startsWith = function ($haystack, $needle) {
        if ($needle === '') return true;
        return strncmp($haystack, $needle, strlen($needle)) === 0;
    };
    $digitsOnly = function ($v) {
        return preg_replace('/\D+/', '', (string)$v);
    };

    try {
        // Timezone + Settings
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main && !empty($main->countrytimezone) ? $main->countrytimezone : 'Africa/Cairo');
        $defaultIc = $main && !empty($main->countrycode) ? preg_replace('/\D+/', '', $main->countrycode) : '20';

        $req = Yii::app()->request;

        // --- Normalize GET ---
        $clean = [];
        foreach ($_GET as $k => $v) {
            $nk = is_string($k) ? trim($k) : $k;
            $clean[$nk] = is_array($v) ? $v : (is_string($v) ? trim($v) : $v);
        }
        $g = function ($key, $default=null) use ($clean, $req) {
            if (array_key_exists($key, $clean)) return $clean[$key];
            $val = $req->getQuery($key);
            return $val !== null ? $val : $default;
        };

        // --- Auth ---
        $token = (string)$g('token', '');
        if ($token !== $VALID_TOKEN) {
            echo json_encode(['status'=>false,'message'=>'Invalid token']); Yii::app()->end();
        }

        // --- IDs ---
        $user_id     = $g('user_id');
        $project_id  = $g('project_id');
        $campaign_id = $g('campaign_id');

        if (!$user_id || !User::model()->findByPk($user_id)) {
            echo json_encode(['status'=>false,'message'=>'Invalid user_id']); Yii::app()->end();
        }
        if (!$project_id || !Projects::model()->findByPk($project_id)) {
            echo json_encode(['status'=>false,'message'=>'Invalid project_id']); Yii::app()->end();
        }

        $campaign = Campaign::model()->findByPk($campaign_id);
        if (!$campaign || !$campaign->strategy_id) {
            echo json_encode(['status'=>false,'message'=>'Invalid campaign or missing strategy_id']); Yii::app()->end();
        }
        $strategy_id = $campaign->strategy_id;

        // --- Switches ---
        $allow_duplicate     = (string)$g('allow_duplicate', '') === '1';
        $update_if_duplicate = (string)$g('update_if_duplicate', '') === '1';

        // --- Phones normalize ---
        $icRaw  = (string)($g('international_code', $g('isd_code', $g('code', ''))));
        $icRaw  = rtrim($icRaw, '.');
        $telRaw = (string)$g('tel', '');

        $international_code = $digitsOnly($icRaw);
        $tel                = $digitsOnly($telRaw);

        if ($international_code === '') {
            $raw = preg_replace('/\s+/', '', $telRaw);
            if ($raw !== '' && ($raw[0] === '+' || $startsWith($raw, '00'))) {
                $tmp = ltrim($raw, '+');
                if ($startsWith($tmp, '00')) $tmp = substr($tmp, 2);
                $cand = $digitsOnly(substr($tmp, 0, 3));
                if ($cand === '966') {
                    $international_code = '966';
                    $tel = $digitsOnly(substr($tmp, 3));
                } elseif (substr($cand, 0, 2) === '20') {
                    $international_code = '20';
                    $tel = $digitsOnly(substr($tmp, 2));
                } else {
                    $international_code = $digitsOnly(substr($tmp, 0, 3));
                    if (strlen($international_code) === 3) {
                        $tel = $digitsOnly(substr($tmp, 3));
                    } else {
                        $international_code = $digitsOnly(substr($tmp, 0, 2));
                        $tel = $digitsOnly(substr($tmp, 2));
                    }
                }
            }
        }
        if ($international_code === '' && $tel !== '') {
            $international_code = $defaultIc;
        }
        if ($international_code !== '' && $tel !== '' && $startsWith($tel, $international_code)) {
            $tel = substr($tel, strlen($international_code));
            if (strlen($tel) > 0 && $tel[0] === '0') $tel = substr($tel, 1);
        }
        if ($international_code === '' || $tel === '') {
            echo json_encode(['status'=>false,'message'=>'international_code and tel are required']); Yii::app()->end();
        }

        $full_e164 = $international_code . $tel;

        // --- Schema / columns availability ---
        $leadsModel      = Leads::model();
        $leadsTable      = $leadsModel->tableSchema;
        $hasFullE164Col  = ($leadsTable->getColumn('full_e164') !== null);
        $hasSecertCol    = ($leadsTable->getColumn('secert') !== null);
        $hasTel2Col      = ($leadsTable->getColumn('tel2') !== null);
        $hasTel3Col      = ($leadsTable->getColumn('tel3') !== null);
        $hasTel4Col      = ($leadsTable->getColumn('tel4') !== null);
        $hasSecondTelCol = ($leadsTable->getColumn('second_tel') !== null);

        // tel2..tel4 from URL
        $tel2 = $digitsOnly($g('tel2'));
        $tel3 = $digitsOnly($g('tel3'));
        $tel4 = $digitsOnly($g('tel4'));

        // --- Duplicate check ---
        $dup = null;
        if ($hasFullE164Col) {
            $dup = Leads::model()->findByAttributes(['full_e164' => $full_e164]);
        }
        if (!$dup) {
            $criteria = new CDbCriteria();
            $criteria->addColumnCondition(['international_code' => $international_code, 'tel' => $tel]);
            $dup = Leads::model()->find($criteria);
        }

        $tx = Yii::app()->db->beginTransaction();
        try {
            if ($dup && !$allow_duplicate && !$update_if_duplicate) {
                $tx->rollback();
                echo json_encode([
                    'status' => false,
                    'message' => 'Duplicate lead (same phone exists)',
                    'existing_lead_id' => $dup->id
                ]);
                Yii::app()->end();
            }

            if ($dup && $update_if_duplicate) {
                // === Update existing lead ===
                $lead = $dup;

                $map = [
                    'title'            => 'title',
                    'email'            => 'email',
                    'job'              => 'career',
                    'notes'            => 'notes',
                    'interest_id'      => 'interest_id',
                    'platform_id'      => 'platform_id',
                    'platformchild_id' => 'platformchild_id',
                    'user_marketing'   => 'user_marketing',
                    'fresh_sales'      => 'fresh_sales',
                    'mediabuyer'       => 'mediabuyer',
                ];
                foreach ($map as $q => $attr) {
                    $val = $g($q, null);
                    if ($val !== null && $lead->hasAttribute($attr)) {
                        $lead->$attr = $val;
                    }
                }

                // project/campaign + strategy/user/date/time
                if ($project_id   && $lead->hasAttribute('project_id'))  $lead->project_id  = $project_id;
                if ($campaign_id  && $lead->hasAttribute('campaign_id')) $lead->campaign_id = $campaign_id;

                if ($lead->hasAttribute('strategy_id')) $lead->strategy_id = $strategy_id;
                if ($lead->hasAttribute('user_id'))     $lead->user_id     = $user_id;
                if ($lead->hasAttribute('date'))        $lead->date        = date('Y-m-d');
                if ($lead->hasAttribute('time'))        $lead->time        = date('H:i:s');

                // user_sales = user_id (إجباري)
                if ($lead->hasAttribute('user_sales'))  $lead->user_sales  = $user_id;

                if ($hasFullE164Col) $lead->full_e164 = $full_e164;

                // tel2..tel4
                $notesAppend = [];
                if ($tel2 !== '') {
                    if ($hasTel2Col)        $lead->tel2 = $tel2;
                    elseif ($hasSecondTelCol && empty($lead->second_tel)) $lead->second_tel = $tel2;
                    else                    $notesAppend[] = "tel2:$tel2";
                }
                if ($tel3 !== '') {
                    if ($hasTel3Col)        $lead->tel3 = $tel3;
                    else                    $notesAppend[] = "tel3:$tel3";
                }
                if ($tel4 !== '') {
                    if ($hasTel4Col)        $lead->tel4 = $tel4;
                    else                    $notesAppend[] = "tel4:$tel4";
                }
                if (!empty($notesAppend) && $lead->hasAttribute('notes')) {
                    $lead->notes = trim(($lead->notes ? $lead->notes."\n" : '') . implode(', ', $notesAppend));
                }

                if (!$lead->save(false)) {
                    throw new Exception('Failed to update duplicate lead');
                }

                // === Force secert = id after update ===
                Yii::app()->db->schema->refresh();
                $hasSecertAttr = $lead->hasAttribute('secert');
                if ($hasSecertCol && $hasSecertAttr) {
                    $lead->secert = (int)$lead->id;
                    $lead->save(false, ['secert']);
                } elseif ($hasSecertCol) {
                    Yii::app()->db->createCommand('UPDATE `leads` SET `secert` = `id` WHERE `id` = :id')
                        ->execute([':id' => (int)$lead->id]);
                }

                $tx->commit();
                echo json_encode(['status'=>true,'message'=>'Lead updated (duplicate found & updated)','lead_id'=>$lead->id,'secert'=>(int)$lead->id]);
                Yii::app()->end();
            }

            // === Create new lead ===
            $lead = new Leads();
            if ($lead->hasAttribute('international_code')) $lead->international_code = $international_code;
            if ($lead->hasAttribute('tel'))                $lead->tel                = $tel;

            // تعيين الحقول
            $assignIfHas = function($model, $attr, $val) {
                if ($val !== null && $model->hasAttribute($attr)) $model->$attr = $val;
            };
            $assignIfHas($lead, 'title',            $g('title'));
            $assignIfHas($lead, 'email',            $g('email'));
            $assignIfHas($lead, 'career',           $g('job'));
            $assignIfHas($lead, 'notes',            $g('notes'));
            $assignIfHas($lead, 'project_id',       $project_id);
            $assignIfHas($lead, 'campaign_id',      $campaign_id);
            $assignIfHas($lead, 'interest_id',      $g('interest_id'));
            $assignIfHas($lead, 'platform_id',      $g('platform_id'));
            $assignIfHas($lead, 'platformchild_id', $g('platformchild_id'));
            $assignIfHas($lead, 'strategy_id',      $strategy_id);
            $assignIfHas($lead, 'date',             date('Y-m-d'));
            $assignIfHas($lead, 'time',             date('H:i:s'));
            $assignIfHas($lead, 'hidden',           1);

            // user_id + user_sales = user_id (إجباري)
            if ($lead->hasAttribute('user_id'))     $lead->user_id    = $user_id;
            if ($lead->hasAttribute('user_sales'))  $lead->user_sales = $user_id;

            if ($hasFullE164Col) $lead->full_e164 = $full_e164;

            // tel2..tel4
            if ($tel2 !== '') {
                if     ($hasTel2Col)        $lead->tel2 = $tel2;
                elseif ($hasSecondTelCol)   $lead->second_tel = $tel2;
                else   $assignIfHas($lead, 'notes', trim(($lead->notes ? $lead->notes."\n" : '')."tel2:$tel2"));
            }
            if ($tel3 !== '') {
                if     ($hasTel3Col)        $lead->tel3 = $tel3;
                else   $assignIfHas($lead, 'notes', trim(($lead->notes ? $lead->notes."\n" : '')."tel3:$tel3"));
            }
            if ($tel4 !== '') {
                if     ($hasTel4Col)        $lead->tel4 = $tel4;
                else   $assignIfHas($lead, 'notes', trim(($lead->notes ? $lead->notes."\n" : '')."tel4:$tel4"));
            }

            if (!$lead->save()) {
                throw new Exception('Failed to save lead');
            }

            // === Force secert = id after create ===
            Yii::app()->db->schema->refresh();
            $hasSecertAttr = $lead->hasAttribute('secert');
            if ($hasSecertCol && $hasSecertAttr) {
                $lead->secert = (int)$lead->id;
                $lead->save(false, ['secert']);
            } elseif ($hasSecertCol) {
                Yii::app()->db->createCommand('UPDATE `leads` SET `secert` = `id` WHERE `id` = :id')
                    ->execute([':id' => (int)$lead->id]);
            }

            $tx->commit();
            echo json_encode([
                'status'  => true,
                'message' => 'Lead created successfully',
                'lead_id' => $lead->id,
                'secert'  => (int)$lead->id
            ]);
            Yii::app()->end();

        } catch (Exception $inner) {
            if (Yii::app()->db->currentTransaction) {
                Yii::app()->db->currentTransaction->rollback();
            }
            throw $inner;
        }

    } catch (Exception $e) {
        echo json_encode(['status'=>false,'message'=>'Exception','error'=>$e->getMessage()]);
        Yii::app()->end();
    }
}


public function actionCreateTicketByUrl()
{
    header('Content-Type: application/json; charset=utf-8');

    // ثابت/ENV للتوكن
    $VALID_TOKEN = getenv('TICKET_API_TOKEN') ?: 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3';

    try {
        // ضبط التوقيت
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main && $main->countrytimezone ? $main->countrytimezone : 'Africa/Cairo');

        /** @var CHttpRequest $req */
        $req = Yii::app()->request;

        // ======= التحقق من التوكن (query أو Authorization: Bearer) =======
        $token = $req->getQuery('token');
        if (!$token) {
            $authHeader = null;

            if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
                $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
            }
            if (!$authHeader && function_exists('apache_request_headers')) {
                $headers = apache_request_headers();
                if (isset($headers['Authorization'])) {
                    $authHeader = $headers['Authorization'];
                } elseif (isset($headers['authorization'])) {
                    $authHeader = $headers['authorization'];
                }
            }
            if ($authHeader && stripos($authHeader, 'Bearer ') === 0) {
                $token = trim(substr($authHeader, 7));
            }
        }
        if (trim((string)$token) !== $VALID_TOKEN) {
            http_response_code(401);
            echo json_encode(['status'=>false,'message'=>'Invalid or missing token']); Yii::app()->end();
        }

        // ======= lead_id (يدعم id القديم) =======
        $lead_id = $req->getQuery('lead_id');
        if (!$lead_id) $lead_id = $req->getQuery('id');
        if (!$lead_id || !ctype_digit((string)$lead_id) || !Leads::model()->findByPk((int)$lead_id)) {
            http_response_code(422);
            echo json_encode(['status'=>false,'message'=>'Invalid lead_id']); Yii::app()->end();
        }

        // ======= Customerservice array =======
        $cs = $req->getQuery('Customerservice', []);
        if (!is_array($cs)) $cs = [];
        if (isset($_GET['Customerservice']) && is_array($_GET['Customerservice'])) {
            $cs = array_replace($cs, $_GET['Customerservice']);
        }

        // user_id: مباشر أو Customerservice[employee_id]
        $user_id = $req->getQuery('user_id');
        $csEmployeeId = isset($cs['employee_id']) ? $cs['employee_id'] : null;
        if (!$csEmployeeId) {
            $flatEmp = $req->getQuery('Customerservice[employee_id]');
            if ($flatEmp) $csEmployeeId = $flatEmp;
        }
        if (!$user_id && $csEmployeeId) $user_id = $csEmployeeId;

        if (!$user_id || !ctype_digit((string)$user_id) || !User::model()->findByPk((int)$user_id)) {
            http_response_code(422);
            echo json_encode(['status'=>false,'message'=>'Invalid user_id']); Yii::app()->end();
        }

        // ======= مفاتيح مسطّحة =======
        $flatKeys = [
            'message','subject','title','details','note',
            'priority','status','channel','tickettype','type','typ',
            'name','unit_id','service_id','follow_date','follow_time'
        ];
        foreach ($flatKeys as $k) {
            $v = $req->getQuery($k);
            if ($v !== null && $v !== '' && !isset($cs[$k])) $cs[$k] = $v;
        }

        // message = details لو ناقص
        if (empty($cs['message']) && !empty($cs['details'])) $cs['message'] = $cs['details'];

        // channel افتراضي من tickettype (1 Visit / 2 Call / غيره Other)
        if (empty($cs['channel']) && !empty($cs['tickettype'])) {
            $cs['channel'] = ((string)$cs['tickettype'] === '1') ? 'Visit' :
                             (((string)$cs['tickettype'] === '2') ? 'Call' : 'Other');
        }

        // ربط tickettype => type/typ
        if (!empty($cs['tickettype'])) {
            if (empty($cs['type'])) $cs['type'] = $cs['tickettype'];
            if (empty($cs['typ']))  $cs['typ']  = $cs['tickettype'];
        }

        // ======= serviceMap للعرض فقط (التخزين بالـ IDs) =======
        if (!empty($cs['service_id'])) {
            
            var_dump($cs['service_id']);exit;
            if (empty($cs['service_id'])) $cs['service_id'] = $cs['service_id'];
            if (empty($cs['service_id']))  $cs['service_id']  = $cs['service_id'];
        }


        // توليد subject تلقائي لو ناقص
        if (empty($cs['subject'])) {
            $parts = [];
            if (!empty($cs['tickettype']) && isset($typeMap[(string)$cs['tickettype']])) $parts[] = $typeMap[(string)$cs['tickettype']];
            if (!empty($cs['unit_id'])) $parts[] = 'Unit#' . $cs['unit_id'];
            if (!empty($cs['name'])) $parts[] = $cs['name'];
            $autoSubject = trim(implode(' - ', $parts));
            if ($autoSubject !== '') $cs['subject'] = $autoSubject;
        }

        // تحقق أساسي
        $errors = [];
        if (empty($cs['message']))  $errors['message'][] = 'Message is required';
        if (empty($cs['subject']))  $errors['subject'][] = 'Subject is required';
        if (empty($cs['priority'])) $errors['priority'][] = 'Priority is required';
        if (empty($cs['status']))   $errors['status'][]   = 'Status is required';
        if (!empty($errors)) {
            http_response_code(422);
            echo json_encode(['status'=>false,'message'=>'Validation failed','errors'=>$errors]); Yii::app()->end();
        }

        // تنسيق follow_date / follow_time
        if (!empty($cs['follow_date'])) {
            $ts = strtotime($cs['follow_date'] . (!empty($cs['follow_time']) ? ' '.$cs['follow_time'] : ''));
            if ($ts !== false) {
                $cs['follow_date'] = date('Y-m-d', $ts);
                if (!empty($cs['follow_time'])) $cs['follow_time'] = date('H:i:s', $ts);
            }
        }

        // ======= الحفظ =======
        $tx = Yii::app()->db->beginTransaction();
        try {
            $ticket = new Customerservice();

            // اكتب الخصائص حتى لو مش معلّمة safe
            $allowed = [
                'message','subject','title','note','priority','status','channel',
                'tickettype','type','typ','name','unit_id','service_id','follow_date','follow_time'
            ];
            $payload = array_intersect_key($cs, array_flip($allowed));
            $ticket->setAttributes($payload, false);

            $ticket->lead_id = (int)$lead_id;
            $ticket->user_id = (int)$user_id;
            $ticket->date    = date('Y-m-d');
            $ticket->time    = date('H:i:s');

            // 1) حفظ السجل للحصول على id (AUTO_INCREMENT)
            if (!$ticket->save(false)) {
                $tx->rollback();
                http_response_code(500);
                echo json_encode(['status'=>false,'message'=>'Failed to save ticket']); Yii::app()->end();
            }

            // 2) جعل Secret = نفس id (تحديث سريع بدون Validation)
            $id = (int)$ticket->id;
            $updated = Customerservice::model()->updateByPk($id, ['Secret' => $id]);
            if ($updated === 0) {
                // لو لأي سبب محدثش ولا صف، رجّع تاني واحفظ من الموديل
                $ticket->Secret = $id;
                if (!$ticket->save(false)) {
                    $tx->rollback();
                    http_response_code(500);
                    echo json_encode(['status'=>false,'message'=>'Failed to set Secret']); Yii::app()->end();
                }
            } else {
                // حافظ على القيمة في الكائن الحالي للرد
                $ticket->Secret = $id;
            }

            $tx->commit();
            http_response_code(201);
            echo json_encode([
                'status'    => true,
                'message'   => 'Ticket created successfully',
                'ticket_id' => $id,
                'lead_id'   => (int)$lead_id,
                'secret'    => (string)$ticket->Secret, // هي نفس الـ id
            ]);
            Yii::app()->end();

        } catch (Exception $e) {
            if ($tx->active) $tx->rollback();
            throw $e;
        }

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['status'=>false,'message'=>'Exception','error'=>$e->getMessage()]);
        Yii::app()->end();
    }
}






public function actionLeadmessageByUrl()
{
    header('Content-Type: application/json; charset=utf-8');

    $main = Mainsettings::model()->findByPk(1);
    date_default_timezone_set($main && $main->countrytimezone ? $main->countrytimezone : 'Africa/Cairo');

    $req = Yii::app()->request;

    $VALID_TOKEN = getenv('TICKET_API_TOKEN') ?: 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3';
    $token = $req->getParam('token', null);
    if ($token !== $VALID_TOKEN) {
        echo json_encode(['status'=>false,'message'=>'Invalid or missing token']); Yii::app()->end();
    }

    $user_id    = (int) $req->getParam('user_id', 0);
    $lead_id    = (int) $req->getParam('lead_id', $req->getParam('leads_id', $req->getParam('id', 0)));
    $tickettype = $req->getParam('tickettype', null); // من اللينك

    $csParams = (array) $req->getParam('Customerservice', []);

    // tickettype من اللينك ياخد الأولوية
    if ($tickettype !== null && $tickettype !== '') {
        $csParams['tickettype'] = $tickettype;
    }

    if ($user_id <= 0 || $lead_id <= 0) {
        echo json_encode(['status'=>false,'message'=>'Missing required fields','fields'=>compact('user_id','lead_id','tickettype')]);
        Yii::app()->end();
    }

    $lead = Leads::model()->findByPk($lead_id);
    $user = User::model()->findByPk($user_id);
    if (!$lead || !$user) {
        echo json_encode(['status'=>false,'message'=>'Lead or User not found']); Yii::app()->end();
    }

    $today = date('Y-m-d'); $time = date('H:i:s');

    $tx = Yii::app()->db->beginTransaction();
    try {
        $model = new Customerservice();
        $model->attributes = $csParams;         // يلتقط: tickettype, name, unit_id, service_id, follow_date, follow_time, details ... إلخ
        $model->date       = $today;
        $model->time       = $time;
        $model->user_id    = $user_id;
        $model->lead_id    = $lead_id;
        $model->Secret     = (string)$user_id;   // مؤقت

        if (!$model->save()) {
            throw new CException('Customerservice save failed: '.json_encode($model->getErrors()));
        }

        $model->Secret = (string)$model->id;     // Secret = id
        $model->save(false, ['Secret']);

        $tx->commit();
        echo json_encode([
            'status'      => true,
            'message'     => 'Customerservice created',
            'id'          => (int)$model->id,
            'lead_id'     => (int)$lead_id,
            'tickettype'  => $model->tickettype,
            'profile_url' => Yii::app()->createUrl('leads/profile/'.$lead_id),
        ]);
    } catch (Exception $e) {
        if ($tx->active) $tx->rollback();
        echo json_encode(['status'=>false,'message'=>'Failed to save','error'=>$e->getMessage()]);
    }

    Yii::app()->end();
}




public function actionCloseTicketByUrl()
{
    header('Content-Type: application/json; charset=utf-8');

    try {
        // ====== إعدادات عامة / ENV ======
        // ممكن تنقل التوكن لـ Mainsettings أو ENV
        $VALID_TOKEN = getenv('TICKET_API_TOKEN') ?: 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3';

        // ====== timezone ======
        $main = Mainsettings::model()->findByPk(1);
        if ($main && !empty($main->countrytimezone)) {
            @date_default_timezone_set($main->countrytimezone);
        } else {
            @date_default_timezone_set('Africa/Cairo');
        }

        // ====== قراءة المدخلات من GET/POST ======
        // نقرأ من GET ثم POST (أو العكس حسب تفضيلك)
        $req = array_merge($_GET, $_POST);

        $token  = isset($req['token']) ? trim($req['token']) : null;
        $id     = isset($req['id']) ? (int)$req['id'] : null;           // ticket id (PK)
        $done   = isset($req['done']) ? (int)$req['done'] : null;       // 0/1 أو أي numeric
        $report = isset($req['report']) ? trim($req['report']) : null;

        // ====== تحقق أساسي ======
        if (!$token)  throw new CHttpException(400, 'token_is_required');
        if ($token !== $VALID_TOKEN) throw new CHttpException(401, 'invalid_token');

        if (!$id)     throw new CHttpException(400, 'id_is_required');
        if ($done === null) throw new CHttpException(400, 'done_is_required');
        if ($report === null || $report === '') throw new CHttpException(400, 'report_is_required');

        // ====== جلب التيكت ======
        $ticket = Customerservice::model()->findByPk($id);
        if (!$ticket) throw new CHttpException(404, 'ticket_not_found');

        // ====== تعيين القيم ======
        $ticket->done   = $done;
        $ticket->report = $report;

        // لو عندك أعمدة وقت/تاريخ للإغلاق، هنحدثها لو موجودة
        $nowDate = date("Y-m-d");
        $nowTime = date("H:i:s");

        if (property_exists($ticket, 'close_date')) $ticket->close_date = $nowDate;
        if (property_exists($ticket, 'close_time')) $ticket->close_time = $nowTime;
        if (property_exists($ticket, 'updated_at')) $ticket->updated_at = $nowDate . ' ' . $nowTime;

        // ====== حفظ ======
        if (!$ticket->save(false)) {
            // حاول تعرض الأخطاء لو في rules
            $errs = $ticket->getErrors();
            throw new CHttpException(500, 'failed_to_save_ticket: ' . json_encode($errs, JSON_UNESCAPED_UNICODE));
        }

        // ====== استجابة نجاح ======
        echo json_encode([
            'status'  => true,
            'message' => 'ticket_closed_successfully',
            'data'    => [
                'id'        => (int)$ticket->id,
                'lead_id'   => isset($ticket->lead_id) ? (int)$ticket->lead_id : null,
                'done'      => (int)$ticket->done,
                'report'    => (string)$ticket->report,
                'close_date'=> property_exists($ticket, 'close_date') ? $ticket->close_date : $nowDate,
                'close_time'=> property_exists($ticket, 'close_time') ? $ticket->close_time : $nowTime,
                'updated_at'=> property_exists($ticket, 'updated_at') ? $ticket->updated_at : ($nowDate.' '.$nowTime),
            ],
        ], JSON_UNESCAPED_UNICODE);
        Yii::app()->end();

    } catch (CHttpException $e) {
        http_response_code($e->statusCode);
        echo json_encode([
            'status'  => false,
            'error'   => 'client_error',
            'message' => $e->getMessage(),
        ], JSON_UNESCAPED_UNICODE);
        Yii::app()->end();
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            'status'  => false,
            'error'   => 'server_error',
            'message' => 'Unexpected server error',
            'detail'  => $e->getMessage(),
        ], JSON_UNESCAPED_UNICODE);
        Yii::app()->end();
    }
}



    public function actionInsertLeadActivityByUrl() {
        header('Content-Type: application/json');
    
        // ضبط التوقيت المحلي
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
    
        // التحقق من التوكن
        $token = $_GET['token'] ?? null;
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode(['status' => false, 'message' => 'Invalid or missing token']);
            Yii::app()->end();
        }
    
        // استقبال البيانات
        $user_id       = $_GET['user_id']       ?? null;
        $lead_id       = $_GET['leads_id']      ?? null;
        $report        = $_GET['report']        ?? null;
        $follow_date   = $_GET['follow_date']   ?? null;
        $follow_time   = $_GET['follow_time']   ?? null;
        $status_id     = $_GET['status']        ?? null;
        $substatus_id  = $_GET['substatus']     ?? null;
        $type          = $_GET['type']          ?? 1;
        $star          = $_GET['star']          ?? 0;
    
        // الوقت الحالي
        $today  = date('Y-m-d');
        $time   = date('H:i:s');
        $uniqid = uniqid();
        $rnd    = rand(10000, 99999);
    
        // تحقق من الحقول الأساسية
        if (!$user_id || !$lead_id || !$report || !$follow_date || !$status_id) {
            echo json_encode([
                'status' => false,
                'message' => 'Missing required fields',
                'fields' => compact('user_id', 'lead_id', 'report', 'follow_date', 'status_id')
            ]);
            Yii::app()->end();
        }
    
        // تحميل السجلات
        $lead       = Leads::model()->findByPk($lead_id);
        $user       = User::model()->findByPk($user_id);
        $status     = Statues::model()->findByPk($status_id);
        $substatus  = Substatus::model()->findByPk($substatus_id);
    
        if(!empty($lead->id)){	
            $criteriaopenx = new CDbCriteria;
            $criteriaopenx->addCondition('close IS NULL OR report IS NULL ');
            $criteriaopenx->addSearchCondition('leads_id', $lead->id, false, 'AND');
            $allopenactivities= Activities::model()->findAll($criteriaopenx);
            if(!empty($allopenactivities)){
                foreach($allopenactivities as $openactivities){	
                    $openactivities->close=1;
                    $openactivities->report=1;
                    $openactivities->save();
                }
            }
       }
       
        if (!$lead || !$user || !$status) {
            echo json_encode(['status' => false, 'message' => 'Lead, User, or Status not found']);
            Yii::app()->end();
        }
    
        // تحقق من شرط visit
        if ((int)$status->visit === 1 && (int)$lead->visit !== 1) {
            echo json_encode(['status' => false, 'message' => 'This status requires visit = 1 in lead']);
            Yii::app()->end();
        }
    
        // إنشاء Activity
        $activity = new Activities();
        $activity->user_id       = $lead->user_sales;
        $activity->marketing_id  = $lead->user_id;
        $activity->date          = $today;
        $activity->details       = $report;
        $activity->follow_date   = $follow_date;
        $activity->follow_time   = $follow_time;
        $activity->status        = $status_id;
        $activity->substatus     = $substatus_id;
        $activity->type          = $type;
        $activity->star          = $star;
        $activity->time          = $time;
        $activity->code          = $uniqid;
    
        if ($user->salesmanger == 1 || $user->teamleader == 1) {
            $activity->manger_id = $user->id;
        }
    
        // تحديث بيانات Lead
        $lead->sales_report      = $report;
        $lead->communication     = 1;
        $lead->receipt           = 1;
        $lead->follow_date       = $follow_date;
        $lead->follow_time       = $follow_time;
        $lead->action_time       = $time;
        $lead->checkup_activity  = $today;
        $lead->visitactive       = null;
        $lead->details          .= ' / ' . $today . ' ' . $report;
    
        if (empty($lead->first_communication)) {
            $lead->first_communication = $user_id;
        }
    
        if ($status_id != $lead->status) {
            $lead->status_date = $today;
        }
    
        $lead->status = $status_id;
    
        if ($substatus_id != $lead->substatus) {
            $lead->substatus_date = $today;
        }
    
        $lead->substatus = $substatus_id;
    
        // زيارة تلقائية إذا مطلوب
        if ((int)$status->visit === 1 && (int)$main->createvisitauto === 1) {
            $visit = new Visit();
            $visit->date         = $today;
            $visit->lead_id      = $lead->id;
            $visit->user_id      = $user_id;
            $visit->lead_date    = $lead->date;
            $visit->code         = $uniqid;
            $visit->details      = $report;
            $visit->dateaction   = $today;
            $visit->timeaction   = $time;
            $visit->from_time    = $time;
            $visit->to_time      = $time;
    
            if (!$visit->save()) {
                echo json_encode([
                    'status' => false,
                    'message' => 'Visit creation failed',
                    'errors' => $visit->getErrors()
                ]);
                Yii::app()->end();
            }
        }
    
        // التأهيل
        if ((int)$status->qualified === 1) {
            $lead->qualified = 1;
            if (empty($lead->first_classification)) {
                $lead->first_classification = 1;
                $lead->first_classification_user = $user_id;
            }
        }
    
        if ((int)$status->nonqualified === 1) {
            $lead->nonqualified = 1;
            if (empty($lead->first_classification)) {
                $lead->first_classification = 2;
                $lead->first_classification_user = $user_id;
            }
        }
    
        // معالجة answer, callback, expvisit
        foreach ([$status, $substatus] as $source) {
            if ($source) {
                if ($source->answer == 1) { $lead->answer = 1; $activity->answer = 1; }
                if ($source->answer == 2) { $lead->answer = 2; $activity->answer = 2; }
                if ($source->callback == 1) { $lead->callback = 1; $activity->callback = 1; }
                if ($source->expvisit == 1) { $lead->expvisit = 1; $activity->expvisit = 1; }
            }
        }
    
        // إغلاق أو عميل
        if ((int)$status->close === 1 || (int)$status->client === 1) {
            $lead->close         = 1;
            $lead->reopen        = null;
            $lead->communication = 1;
            $lead->receipt       = 1;
            $lead->visitactive   = null;
            $lead->close_date    = $today;
            $activity->report    = 'Closed In ' . $today . ' - ' . $report;
            $activity->close     = 1;
    
            if (empty($lead->first_communication)) {
                $lead->first_communication = $user_id;
            }
        }
    
        // بيانات إضافية للـ Activity
        $activity->name       = $lead->title;
        $activity->tel        = $lead->tel;
        $activity->coldcall   = $lead->coldcall;
        $activity->indirect   = $lead->indirect;
        $activity->lead_date  = $lead->date;
        $activity->leads_id   = $lead->id;
        $activity->secert     = $rnd . $user_id;
    
        // حفظ
        if ($activity->save() && $lead->save()) {
            $activity->secert = $activity->id;
            $activity->save(false);
    
            echo json_encode([
                'status' => true,
                'message' => 'Activity saved and lead updated',
                'activity_id' => $activity->id
            ]);
        } else {
            echo json_encode([
                'status' => false,
                'message' => 'Failed to save',
                'activity_errors' => $activity->getErrors(),
                'lead_errors' => $lead->getErrors()
            ]);
        }
    
        Yii::app()->end();
    }
    
    public function actionInsertLeadCloseByUrl() {
        header('Content-Type: application/json');
    
        // التوقيت المحلي
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
    
        $today = date("Y-m-d");
        $time  = date("H:i:s");
    
        // التحقق من التوكن
        $token = $_GET['token'] ?? null;
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode(['status' => false, 'message' => 'Unauthorized']);
            Yii::app()->end();
        }
    
        // استقبال البيانات من GET
        $secert    = $_GET['secert']    ?? null;
        $code      = $_GET['code']      ?? uniqid();
        $status_id = $_GET['status']    ?? null;
        $report    = $_GET['report']    ?? null;
        $substatus = $_GET['substatus'] ?? null;
        $user_id   = $_GET['user_id']   ?? Yii::app()->user->id;
    
        $user = User::model()->findByPk($user_id);
        $lead = Leads::model()->findByAttributes(['secert' => $secert]);
    
        if (!$lead || !$status_id || !$report) {
            echo json_encode(['status' => false, 'message' => 'Missing required fields']);
            Yii::app()->end();
        }
    
        // تحديث بيانات الـ Lead
        $lead->close         = 1;
        $lead->reopen        = null;
        $lead->communication = 1;
        if (empty($lead->first_communication)) {
            $lead->first_communication = $user_id;
        }
        $lead->close_date = $today;
        $lead->status     = $status_id;
    
        $status = Statues::model()->findByPk($status_id);
        if ($status) {
            if ($status->qualified == 1) {
                $lead->qualified = 1;
                if (empty($lead->first_classification)) {
                    $lead->first_classification = 1;
                    $lead->first_classification_user = $user_id;
                }
            }
            if ($status->nonqualified == 1) {
                $lead->nonqualified = 1;
                if (empty($lead->first_classification)) {
                    $lead->first_classification = 2;
                    $lead->first_classification_user = $user_id;
                }
            }
        }
    
        // حفظ الـ Substatus
        $lead->othersubstatus = '';
        if (is_array($substatus)) {
            foreach ($substatus as $s) {
                $lead->othersubstatus .= ',' . $s;
            }
            $lead->substatus = array_shift($substatus);
        } else {
            $lead->substatus = $substatus;
        }
    
        // تحميل الـ Substatus
        $substatus_model = Substatus::model()->findByPk($lead->substatus);
        if ($substatus_model) {
            if ($substatus_model->answer == 1) $lead->answer = 1;
            if ($substatus_model->answer == 2) $lead->answer = 2;
            if ($substatus_model->expvisit == 1) $lead->expvisit = 1;
            if ($substatus_model->callback == 1) $lead->callback = 1;
        }
    
        if ($user->salesmanger == 1 || $user->teamleader == 1) {
            $lead->manger_id = $user_id;
        }
    
        $lead->sales_report = $report;
        $lead->save();
    
        // إغلاق جميع الأنشطة السابقة
        $criteria = new CDbCriteria;
        $criteria->condition = "close IS NULL OR report IS NULL";
        $criteria->addCondition('leads_id=' . $lead->id);
        $activities = Activities::model()->findAll($criteria);
    
        foreach ($activities as $act) {
            $act->close  = 1;
            $act->report = 'Closed In ' . $today . ' - ' . $report;
            $act->save();
        }
    
        // إنشاء Activity جديدة
        $activity = new Activities();
        $activity->user_id     = $user_id;
        $activity->manger_id   = $user_id;
        $activity->leads_id    = $lead->id;
        $activity->lead_date   = $lead->date;
        $activity->date        = $today;
        $activity->time        = $time;
        $activity->details     = $report;
        $activity->code        = $code;
        $activity->report      = 'Closed In ' . $today . ' - ' . $report;
        $activity->follow_date = $today;
        $activity->status      = $status_id;
        $activity->substatus   = $lead->substatus;
        $activity->type        = 1;
        $activity->close       = 1;
    
        if ($substatus_model) {
            if ($substatus_model->answer == 1) $activity->answer = 1;
            if ($substatus_model->answer == 2) $activity->answer = 2;
            if ($substatus_model->expvisit == 1) $activity->expvisit = 1;
            if ($substatus_model->callback == 1) $activity->callback = 1;
        }
    
        if ($activity->save()) {
            $activity->secert     = $activity->id;
            $activity->name       = $lead->title;
            $activity->tel        = $lead->tel;
            $activity->coldcall   = $lead->coldcall;
            $activity->indirect   = $lead->indirect;
            $activity->save();
    
            $lead->follow_date      = $today;
            $lead->checkup_activity = $today;
            $lead->save();
        }
    
        // تحديث Best Sales
        $best = Bestsales::model()->findByAttributes(['user_sales' => $user_id, 'date' => $today]);
        if ($best) {
            $best->actnum += 1;
            $best->save();
        } else {
            $best = new Bestsales();
            $best->user_sales = $user_id;
            $best->date       = $today;
            $best->actnum     = 1;
            $best->save();
        }
    
        echo json_encode([
            'status' => true,
            'message' => 'Lead closed and activity created successfully',
            'activity_id' => $activity->id
        ]);
        Yii::app()->end();
    }
    
    public function actionInsertLocationByUrl() {
        header('Content-Type: application/json');
    
        // إعداد المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
    
        // التحقق من التوكن
        $token = $_GET['token'] ?? null;
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode(['status' => false, 'message' => 'Invalid token']);
            Yii::app()->end();
        }
    
        // جلب المتغيرات
        $user_id        = $_GET['user_id']     ?? null;
        $company_id     = $_GET['com']         ?? null;
        $close          = $_GET['close']       ?? 0;
        $latitude       = $_GET['latitude']    ?? null;
        $longitude      = $_GET['longitude']   ?? null;
        $description    = $_GET['description'] ?? "Start Meeting";
        $orientation_id = $_GET['or']          ?? null;
    
        $date = date("Y-m-d");
        $time = date("H:i:s");
    
        // التحقق من القيم الأساسية
        if (!$user_id || !$company_id || $latitude === null || $longitude === null) {
            echo json_encode(['status' => false, 'message' => 'Missing required parameters']);
            Yii::app()->end();
        }
    
        // ✅ حالة بدء الاجتماع
        if ($close != 1) {
            $or = new Orientation();
            $or->date = $date;
            $or->time = $time;
            $or->user_id = $user_id;
            $or->company_id = $company_id;
            $or->meeting_description = "Start Meeting";
    
            if ($or->save()) {
                $location = new OrientationLocations();
                $location->user_id = $user_id;
                $location->company_id = $company_id;
                $location->orientation_id = $or->id;
                $location->type_id = 1;
                $location->date = $date;
                $location->time = $time;
                $location->latitude = $latitude;
                $location->longitude = $longitude;
                $location->meeting_description = "Start Meeting";
    
                if ($location->save()) {
                    echo json_encode([
                        'status' => true,
                        'message' => 'Orientation started successfully',
                        'orientation_id' => $or->id
                    ]);
                } else {
                    $or->delete(); // rollback
                    echo json_encode([
                        'status' => false,
                        'message' => 'Failed to save location',
                        'errors' => $location->getErrors()
                    ]);
                }
            } else {
                echo json_encode([
                    'status' => false,
                    'message' => 'Failed to create orientation',
                    'errors' => $or->getErrors()
                ]);
            }
        }
    
        // ✅ حالة إغلاق الاجتماع
        else {
            if (!$orientation_id) {
                echo json_encode(['status' => false, 'message' => 'Missing orientation ID']);
                Yii::app()->end();
            }
    
            $or = Orientation::model()->findByPk($orientation_id);
            if (!$or) {
                echo json_encode(['status' => false, 'message' => 'Orientation not found']);
                Yii::app()->end();
            }
    
            $or->close = 1;
            $or->meeting_description = $description;
    
            if ($or->save()) {
                $location = new OrientationLocations();
                $location->user_id = $user_id;
                $location->company_id = $company_id;
                $location->orientation_id = $or->id;
                $location->type_id = 2;
                $location->date = $date;
                $location->time = $time;
                $location->latitude = $latitude;
                $location->longitude = $longitude;
                $location->meeting_description = $description;
    
                if ($location->save()) {
                    echo json_encode([
                        'status' => true,
                        'message' => 'Orientation closed successfully'
                    ]);
                } else {
                    $or->delete(); // rollback
                    echo json_encode([
                        'status' => false,
                        'message' => 'Failed to save closing location',
                        'errors' => $location->getErrors()
                    ]);
                }
            } else {
                echo json_encode([
                    'status' => false,
                    'message' => 'Failed to close orientation',
                    'errors' => $or->getErrors()
                ]);
            }
        }
    
        Yii::app()->end();
    }
    
    
    public function actionCreateTicket()
{
    header('Content-Type: application/json; charset=utf-8');

    // --- تحديد وضع التشغيل ---
    // API mode = لو فيه token في الطلب (GET/POST) أو طلب AJAX، هانرجع JSON ومفيش Redirect.
    $tokenFromHeader = str_replace('Bearer ', '', (string)Yii::app()->request->getHeader('Authorization'));
    $token = isset($_REQUEST['token']) ? (string)$_REQUEST['token'] : $tokenFromHeader;
    $isApiMode = !empty($token) || Yii::app()->request->isAjaxRequest;

    // قراءة إعدادات التايمزون
    $main = Mainsettings::model()->findByPk(1);
    date_default_timezone_set($main && $main->countrytimezone ? $main->countrytimezone : 'Africa/Cairo');

    // --- توثيق (API) أو جلسة (Panel) ---
    if ($isApiMode) {
        // تحقق التوكن
        $EXPECTED = getenv('TICKET_API_TOKEN') ?: 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3';
        if (!hash_equals($EXPECTED, (string)$token)) {
            http_response_code(401);
            echo json_encode(['status' => false, 'message' => 'Invalid token']);
            Yii::app()->end();
        }
    } else {
        // وضع اللوحة (بدون token): نفس منطقك القديم
        if (!Yii::app()->user->isMember()) {
            $model = new LoginForm;
            if (isset($_POST['ajax']) && $_POST['ajax'] === 'login-form') {
                echo CActiveForm::validate($model);
                Yii::app()->end();
            }
            if (isset($_POST['LoginForm'])) {
                $model->attributes = $_POST['LoginForm'];
                if ($model->validate() && $model->login()) {
                    $this->redirect(['home/index']);
                }
            }
            $this->redirect(['home/index']);
            return;
        }
    }

    // --- تحضير البيانات العامة ---
    $uid   = $isApiMode
        ? (int)($_REQUEST['user'] ?? 0) // في API تقدر تبعته في اللينك user=756
        : (int)Yii::app()->user->id;

    // لو API ومفيش user، نfallback
    if ($isApiMode && $uid <= 0) {
        // استخدم system user أو 1 حسب نظامك
        $uid = 1;
    }

    $today = date('Y-m-d');
    $time  = date('H:i:s');

    // في وضع API، بنسمح GET أو POST
    $hasPayload = $isApiMode
        ? (isset($_REQUEST['leadmessage']) || isset($_REQUEST['Customerservice']))
        : isset($_POST['leadmessage']);

    if (!$hasPayload) {
        http_response_code(400);
        echo json_encode(['status' => false, 'message' => 'No payload']);
        Yii::app()->end();
    }

    // --- lead id ---
    $leadIdRaw = $_REQUEST['id'] ?? null;
    if (!ctype_digit((string)$leadIdRaw)) {
        http_response_code(422);
        echo json_encode(['status' => false, 'message' => 'Invalid lead id']);
        Yii::app()->end();
    }
    $leadId = (int)$leadIdRaw;

    $lead = Leads::model()->findByPk($leadId);
    if (!$lead) {
        http_response_code(404);
        echo json_encode(['status' => false, 'message' => 'Lead not found']);
        Yii::app()->end();
    }

    // (اختياري) صلاحيات على الـlead في وضع اللوحة فقط
    // if (!$isApiMode && $lead->user_id != $uid && !Yii::app()->user->isAdmin()) { ... }

    // --- نموذج التيكت ---
    $model = new Customerservice();

    // نجمع بيانات Customerservice من أي مصدر (GET/POST)، وندّي فرصه لحقول message/status/priority
    $cs = [];
    if (isset($_REQUEST['Customerservice']) && is_array($_REQUEST['Customerservice'])) {
        $cs = $_REQUEST['Customerservice'];
    }
    // دعم مختصر: تسمح بإرسال message/priority/status مباشرة في الرووت
    foreach (['message','priority','status','details','note','title','subject'] as $k) {
        if (isset($_REQUEST[$k]) && !isset($cs[$k])) $cs[$k] = $_REQUEST[$k];
    }
    $model->attributes = $cs;

    $model->date     = $today;
    $model->time     = $time;
    $model->user_id  = $uid;
    $model->lead_id  = $leadId;

    try {
        $model->Secret = $uid . '_' . bin2hex(openssl_random_pseudo_bytes(8));
    } catch (Exception $e) {
        $model->Secret = $uid . '_' . uniqid('', true);
    }

    // --- تحقق ---
    $errors = [];
    if (!$model->validate()) {
        $errors = $model->getErrors();
    }
    if (empty($model->message) && empty($model->details) && empty($model->note)) {
        $errors['content'][] = 'مطلوب إدخال محتوى للتيكِت/الملاحظة';
    }

    if (!empty($errors)) {
        http_response_code(422);
        echo json_encode(['status' => false, 'message' => 'Validation error', 'errors' => $errors]);
        Yii::app()->end();
    }

    // --- حفظ داخل Transaction ---
    $tx = Yii::app()->db->beginTransaction();
    try {
        if (!$model->save()) {
            throw new Exception('Save failed: ' . json_encode($model->getErrors()));
        }
        $tx->commit();

        http_response_code(201);
        echo json_encode([
            'status'   => true,
            'message'  => 'Ticket created',
            'recordId' => (int)$model->id,
            'leadId'   => $leadId,
            'secret'   => (string)$model->Secret,
        ]);
        Yii::app()->end();
    } catch (Exception $e) {
        if ($tx->active) $tx->rollback();
        http_response_code(500);
        echo json_encode(['status' => false, 'message' => 'Server error', 'error' => $e->getMessage()]);
        Yii::app()->end();
    }
}

    
    
    public function actionInsertVisitByUrl() {
        header('Content-Type: application/json');
    
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
    
        $token = $_GET['token'] ?? null;
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode(['status' => false, 'message' => 'Invalid token']);
            Yii::app()->end();
        }
    
        $secert      = $_GET['secert'] ?? null;
        $uniqid      = $_GET['code'] ?? uniqid();
        $date        = $_GET['date'] ?? date("Y-m-d");
        $details     = $_GET['details'] ?? null;
        $from_time   = $_GET['from_time'] ?? null;
        $to_time     = $_GET['to_time'] ?? null;
        $user_id     = $_GET['user'] ?? Yii::app()->user->id;
    
        if (!$secert || !$details || !$from_time || !$to_time) {
            echo json_encode(['status' => false, 'message' => 'Missing required parameters']);
            Yii::app()->end();
        }
    
        $today = date("Y-m-d");
        $time  = date("H:i:s");
    
        $lead = Leads::model()->findByAttributes(['secert' => $secert]);
        if (!$lead) {
            echo json_encode(['status' => false, 'message' => 'Lead not found']);
            Yii::app()->end();
        }
    
        $lead->visit         = 1;
        $lead->visitactive   = 1;
        $lead->pending_visit = $_GET['pending_visit'] ?? null;
        $lead->save();
    
        $visit = new Visit();
        if ($lead->coldcall == 1) $visit->coldcall = 1;
        if ($lead->coldcall == 3) $visit->coldcall = 3;
    
        $visit->date          = $date;
        $visit->lead_id       = $lead->id;
        $visit->lead_date     = $lead->date;
        $visit->marketing_id  = $lead->user_id;
        $visit->code          = $uniqid;
        $visit->details       = $details;
        $visit->dateaction    = $today;
        $visit->timeaction    = $time;
        $visit->user_id       = $user_id;
        $visit->from_time     = $from_time;
        $visit->to_time       = $to_time;
    
        if (!empty($from_time) && !empty($to_time)) {
            $visit->hour = strtotime($to_time) - strtotime($from_time);
        }
    
        $lastVisit = Visit::model()->find([
            'condition' => 'lead_id = :lid',
            'params' => [':lid' => $lead->id],
            'order' => 'id DESC',
            'limit' => 1
        ]);
        if ($lastVisit) {
            $visit->novisit = $lastVisit->novisit + 1;
        }
    
        $visit->downpayment   = $_GET['downpayment']   ?? null;
        $visit->months        = $_GET['months']        ?? null;
        $visit->amount        = $_GET['amount']        ?? null;
        $visit->pending_visit = $_GET['pending_visit'] ?? null;
    
        $visit->unit_ids   = isset($_GET['unit'])      ? implode(",", (array)$_GET['unit'])      : null;
        $visit->attended   = isset($_GET['sales'])     ? implode(",", (array)$_GET['sales'])     : null;
        $visit->color_ids  = isset($_GET['colors'])    ? implode(",", (array)$_GET['colors'])    : null;
        $visit->cash       = isset($_GET['cash'])      ? implode(",", (array)$_GET['cash'])      : null;
        $visit->cash_date  = isset($_GET['cash_date']) ? implode(",", (array)$_GET['cash_date']) : null;
    
        if (isset($_GET['confirmsales'])) {
            $visit->confirmsales = 1;
            $visit->type         = $_GET['type'] ?? 1;
        }
    
        if ($visit->save()) {
            // SMS Notification only
            if (!empty($main->visitmessage)) {
                $agent = User::model()->findByPk($lead->user_sales);
                $message = "{$main->visitmessage}\nللتواصل:\n{$agent->fname} {$agent->lname}\n{$agent->mobile}";
                $encodedMessage = rawurlencode($message);
                $url = "https://smsmisr.com/api/SMS/?environment=1&username={$main->username}&password={$main->password}&language=2&sender={$main->sender}&mobile={$lead->international_code}{$lead->tel}&message={$encodedMessage}";
    
                $curl = curl_init($url);
                curl_setopt_array($curl, [
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_HTTPHEADER => ["Content-Type: application/json"],
                ]);
                curl_exec($curl);
                curl_close($curl);
            }
    
            echo json_encode(['status' => true, 'message' => 'Visit created successfully']);
        } else {
            echo json_encode([
                'status' => false,
                'message' => 'Visit creation failed',
                'errors' => $visit->getErrors()
            ]);
        }
    
        Yii::app()->end();
    }

    public function actionGetAllplatforms() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token = $_GET['token'] ?? null;
        $id    = $_GET['id']    ?? null;
    
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 500); // أقصى حد 500
    
        $criteria = new CDbCriteria();
    
        // فلترة حسب المستخدم
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
        // حساب عدد السجلات
        $totalCount = Platform::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allPlatforms = Platform::model()->findAll($criteria);
        $result = [];
        foreach ($allPlatforms as $platform) {
            $result[] = $platform->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }

    public function actionGetAllplatformchild() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token = $_GET['token'] ?? null;
        $id    = $_GET['id']    ?? null;
    
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 500); // أقصى حد 500
    
        $criteria = new CDbCriteria();
    
        // فلترة حسب المستخدم
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
        // حساب عدد السجلات
        $totalCount = PlatformChild::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allPlatformchild = PlatformChild::model()->findAll($criteria);
        $result = [];
        foreach ($allPlatformchild as $platformchild) {
            $result[] = $platformchild->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionGetAllcampaigns() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token = $_GET['token'] ?? null;
        $id    = $_GET['id']    ?? null;
    
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 500); // أقصى حد 500
    
        $criteria = new CDbCriteria();
    
        // فلترة حسب ID الحملة (اختياري)
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
        // حساب عدد السجلات
        $totalCount = Campaign::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allCampaigns = Campaign::model()->findAll($criteria);
        $result = [];
        foreach ($allCampaigns as $campaign) {
            $result[] = $campaign->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionCloseLeadByApi() {
        header('Content-Type: application/json');
    
        if (!Yii::app()->request->isGetRequest) {
            echo json_encode(['status' => false, 'message' => 'Invalid request method']);
            Yii::app()->end();
        }
    
        // بيانات من اللينك
        $token     = $_GET['token']    ?? null;
        $secert    = $_GET['secert']   ?? null;
        $status    = $_GET['status']   ?? null;
        $substatus = $_GET['substatus'] ?? null; // بصيغة "8,12"
        $report    = $_GET['report']   ?? '';
    
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode(['status' => false, 'message' => 'Unauthorized']);
            Yii::app()->end();
        }
    
        $userId = Yii::app()->user->id;
        $lead = Leads::model()->findByAttributes(['secert' => $secert]);
        if (!$lead) {
            echo json_encode(['status' => false, 'message' => 'Lead not found']);
            Yii::app()->end();
        }
    
        // إعدادات الوقت
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
        $today = date("Y-m-d");
        $time = date("H:i:s");
    
        // تحديث lead
        $lead->close = 1;
        $lead->reopen = null;
        $lead->communication = 1;
        if (empty($lead->first_communication)) {
            $lead->first_communication = $userId;
        }
        $lead->close_date = $today;
    
        $qualifiedtest = Statues::model()->findByPk($status);
        if ($qualifiedtest) {
            if ($qualifiedtest->qualified == 1) {
                $lead->qualified = 1;
                if (empty($lead->first_classification)) {
                    $lead->first_classification = 1;
                    $lead->first_classification_user = $userId;
                }
            }
            if ($qualifiedtest->nonqualified == 1) {
                $lead->nonqualified = 1;
                if (empty($lead->first_classification)) {
                    $lead->first_classification = 2;
                    $lead->first_classification_user = $userId;
                }
            }
        }
    
        $lead->status = $status;
    
        // substatus معالجة
        $subArr = explode(',', $substatus);
        $lead->othersubstatus = implode(',', $subArr);
        $lead->substatus = !empty($subArr) ? $subArr[0] : null;
    
        $substatusModel = Substatus::model()->findByPk($lead->substatus);
        if ($substatusModel) {
            if ($substatusModel->answer == 1) $lead->answer = 1;
            if ($substatusModel->answer == 2) $lead->answer = 2;
            if ($substatusModel->expvisit == 1) $lead->expvisit = 1;
            if ($substatusModel->callback == 1) $lead->callback = 1;
        }
    
        $lead->sales_report = $report;
        $lead->save();
    
        // إغلاق الأنشطة القديمة
        $criteria = new CDbCriteria;
        $criteria->condition = "close IS NULL OR report IS NULL";
        $criteria->addCondition('leads_id=' . $lead->id);
        $activities = Activities::model()->findAll($criteria);
        foreach ($activities as $activity) {
            $activity->close = 1;
            $activity->report = 'Closed In ' . $today . ' - ' . $report;
            $activity->save();
        }
    
        // إنشاء Activity جديدة
        $newActivity = new Activities();
        $newActivity->user_id = $userId;
        $newActivity->manger_id = $userId;
        $newActivity->leads_id = $lead->id;
        $newActivity->lead_date = $lead->date;
        $newActivity->date = $today;
        $newActivity->time = $time;
        $newActivity->details = $report;
        $newActivity->report = 'Closed In ' . $today . ' - ' . $report;
        $newActivity->follow_date = $today;
        $newActivity->status = $status;
        $newActivity->substatus = $lead->substatus;
    
        if ($substatusModel) {
            if ($substatusModel->answer == 1) $newActivity->answer = 1;
            if ($substatusModel->answer == 2) $newActivity->answer = 2;
            if ($substatusModel->expvisit == 1) $newActivity->expvisit = 1;
            if ($substatusModel->callback == 1) $newActivity->callback = 1;
        }
    
        $newActivity->type = 1;
        $newActivity->close = 1;
        $newActivity->save();
    
        // تحديث بيانات lead النهائية
        $lead->follow_date = $newActivity->follow_date;
        $lead->checkup_activity = $today;
        $lead->save();
    
        $newActivity->secert = $newActivity->id;
        $newActivity->name = $lead->title;
        $newActivity->tel = $lead->tel;
        $newActivity->coldcall = $lead->coldcall;
        $newActivity->indirect = $lead->indirect;
        $newActivity->save();
    
        // تسجيل bestsales
        $best = Bestsales::model()->findByAttributes(['user_sales' => $userId, 'date' => $today]);
        if ($best) {
            $best->actnum += 1;
            $best->save();
        } else {
            $best = new Bestsales();
            $best->user_sales = $userId;
            $best->date = $today;
            $best->actnum = 1;
            $best->save();
        }
    
        echo json_encode(['status' => true, 'message' => 'Lead closed successfully via GET URL']);
        Yii::app()->end();
    }
    
    //Business Developing Module APIs
    public function actionGetAllLeadsex() {
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?: 'Africa/Cairo');
    
        $token = $_GET['token'] ?? null;
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo CJSON::encode(['status' => false, 'message' => 'Unauthorized or missing token']);
            Yii::app()->end();
        }
    
        $criteria = new CDbCriteria();
    
        // All filters
        $filters = [
            'id', 'phone', 'user', 'exceptuser', 'communication', 'transfer', 'close', 'type',
            'followup', 'delay', 'startdate', 'enddate',
            'startfollowdate', 'endfollowdate',
            'starttransferdate', 'endtransferdate', 'project_id', 'marketing_id', 'interest_id',
            'campaign_id', 'platform_id', 'platformchild_id', 'status', 'substatus',
            'user_sales', 'fresh_sales', 'unit_type', 'property_type', 'client_type'
        ];
    
        foreach ($filters as $key) {
            $$key = $_GET[$key] ?? null;
        }
    
        // ID & phone
        if ($id !== null) $criteria->compare('id', $id);
        if ($phone !== null) {
            if (substr($phone, 0, 1) === '0') $phone = substr($phone, 1);
            $criteria->compare('tel', $phone);
        }
    
        if ($user !== null) $criteria->compare('user_sales', $user);

        if ($exceptuser !== null) {
            // support multiple IDs separated by commas
            $exceptIds = array_filter(array_map('trim', explode(',', $exceptuser)));
            if (!empty($exceptIds)) {
                $placeholders = [];
                foreach ($exceptIds as $i => $id) {
                    $ph = ":except_user_$i";
                    $placeholders[] = $ph;
                    $criteria->params[$ph] = $id;
                }
                $criteria->addCondition('user_sales NOT IN (' . implode(',', $placeholders) . ')');
            }
        }
    
        // Date filter: lead date
        if ($startdate && $enddate) {
            $startObj = DateTime::createFromFormat('d-m-Y', $startdate) ?: DateTime::createFromFormat('Y-m-d', $startdate);
            $endObj = DateTime::createFromFormat('d-m-Y', $enddate) ?: DateTime::createFromFormat('Y-m-d', $enddate);
            if ($startObj && $endObj) {
                $criteria->addBetweenCondition('date', $startObj->format('Y-m-d'), $endObj->format('Y-m-d'));
            }
        }
    
        // Date filter: follow_date
        if ($startfollowdate && $endfollowdate) {
            $startObj = DateTime::createFromFormat('d-m-Y', $startfollowdate) ?: DateTime::createFromFormat('Y-m-d', $startfollowdate);
            $endObj = DateTime::createFromFormat('d-m-Y', $endfollowdate) ?: DateTime::createFromFormat('Y-m-d', $endfollowdate);
            if ($startObj && $endObj) {
                $criteria->addBetweenCondition('follow_date', $startObj->format('Y-m-d'), $endObj->format('Y-m-d'));
            }
        }
    
        // Date filter: transferdate
        if ($starttransferdate && $endtransferdate) {
            $startObj = DateTime::createFromFormat('d-m-Y', $starttransferdate) ?: DateTime::createFromFormat('Y-m-d', $starttransferdate);
            $endObj = DateTime::createFromFormat('d-m-Y', $endtransferdate) ?: DateTime::createFromFormat('Y-m-d', $endtransferdate);
            if ($startObj && $endObj) {
                $criteria->addBetweenCondition('transferdate', $startObj->format('Y-m-d'), $endObj->format('Y-m-d'));
            }
        }
    
        // followup = today
        if ($followup !== null) {
            $today = date('Y-m-d');
            $criteria->addBetweenCondition('follow_date', $today, $today);
        }
    
        // delay = before yesterday
        if ($delay !== null) {
            $yesterday = date('Y-m-d', strtotime('-1 day'));
            $criteria->addCondition('follow_date <= :yesterday');
            $criteria->params[':yesterday'] = $yesterday;
        }
    
        // other conditions
        if ($communication !== null) {
            $criteria->addCondition((string)$communication === '1' ? 'communication = 1' : 'communication IS NULL');
        }
    
        if ($transfer !== null) {
            $criteria->addCondition((string)$transfer === '1' ? 'transfer = 1' : 'transfer IS NULL');
        }
    
        if ($close !== null) {
            $criteria->addCondition((string)$close === '1' ? 'close = 1' : 'close IS NULL');
        }
    
        // type logic
        if ($type !== null) {
            switch ((string)$type) {
                case '1': // fresh
                    $criteria->addCondition('coldcall IS NULL');
                    $criteria->addCondition('indirect IS NULL');
                    break;
                case '2': // cold
                    $criteria->addCondition('coldcall IS NOT NULL');
                    $criteria->addCondition('indirect IS NULL');
                    break;
                case '3': // indirect
                    $criteria->addCondition('indirect IS NOT NULL');
                    break;
            }
        }
        
        // other filters
        if ($campaign_id !== null)       $criteria->compare('campaign_id', $campaign_id);
        if ($platform_id !== null)       $criteria->compare('platform_id', $platform_id);
        if ($platformchild_id !== null)  $criteria->compare('platformchild_id', $platformchild_id);
        if ($project_id !== null)        $criteria->compare('project_id', $project_id);
        if ($marketing_id !== null)      $criteria->compare('marketing_id', $marketing_id);
        if ($interest_id !== null)       $criteria->compare('interest_id', $interest_id);
        if ($status !== null)            $criteria->compare('status', $status);
        if ($substatus !== null)         $criteria->compare('substatus', $substatus);
        if ($fresh_sales !== null)       $criteria->compare('fresh_sales', $fresh_sales);
        if ($unit_type !== null)         $criteria->compare('unit_type', $unit_type);
        if ($property_type !== null)     $criteria->compare('property_type', $property_type);
        if ($client_type !== null)       $criteria->compare('client_type', $client_type);
    
        // pagination
        $limit = min((int)($_GET['limit'] ?? 100000000), 50000000);
        $offset = (int)($_GET['offset'] ?? 0);
    
        $totalCount = Leads::model()->count($criteria);
        $criteria->limit = $limit;
        $criteria->offset = $offset;
    
        $leads = Leads::model()->findAll($criteria);
        $result = array_map(function ($lead) {
            return $lead->attributes;
        }, $leads);
    
        echo CJSON::encode([
            'status'     => true,
            'totalCount' => $totalCount,
            'limit'      => $limit,
            'offset'     => $offset,
            'returned'   => count($result),
            'pages'      => $totalCount > 0 ? ceil($totalCount / $limit) : 0,
            'data'       => $result,
        ]);
    
        Yii::app()->end();
    }
    
    public function actionGetAllcampaignsex() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token = $_GET['token'] ?? null;
        $id    = $_GET['id']    ?? null;
    
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 10000000;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 5000000); // أقصى حد 500
    
        $criteria = new CDbCriteria();
    
        // فلترة حسب ID الحملة (اختياري)
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
        // حساب عدد السجلات
        $totalCount = Campaign::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allCampaigns = Campaign::model()->findAll($criteria);
        $result = [];
        foreach ($allCampaigns as $campaign) {
            $result[] = $campaign->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionGetAllUsersex() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token = $_GET['token'] ?? null;
        $id    = $_GET['id']    ?? null;
    
        header('Content-Type: application/json');
    
        // التحقق من التوكن
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 1000;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 50000000); // الحد الأقصى 500
    
        $criteria = new CDbCriteria();
    
        // فلترة حسب id
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
        // حساب العدد الكلي
        $totalCount = User::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allUsers = User::model()->findAll($criteria);
        $result = [];
        foreach ($allUsers as $user) {
            $result[] = $user->attributes;
        }
    
        // إعداد الرد
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'     => true,
            'totalCount' => (int)$totalCount,
            'limit'      => (int)$limit,
            'offset'     => (int)$offset,
            'returned'   => count($result),
            'pages'      => $pages,
            'data'       => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }

    public function actionGetAlltypesex() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main && $main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // التوكن والأي دي
        $token = $_GET['token'] ?? null;
        $id    = $_GET['id']    ?? null;
    
        header('Content-Type: application/json');
    
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100000;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 5000000); // أقصى حد
    
        $criteria = new CDbCriteria();
    
        // فلترة اختيارية بـ id
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
        // ممكن تضيف فلترة بالعنوان أو parent_id لو حبيت هنا
    
        $totalCount = TypeBuliding::model()->count($criteria);
    
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        $allTypes = TypeBuliding::model()->findAll($criteria);
        $result = [];
    
        foreach ($allTypes as $type) {
            $item = $type->attributes;
    
            // جلب اسم الأب لو موجود
            if (!empty($type->parent_id)) {
                $parent = TypeBuliding::model()->findByPk($type->parent_id);
                $item['parent_title'] = $parent ? $parent->title : null;
            } else {
                $item['parent_title'] = null;
            }
    
            $result[] = $item;
        }
    
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        echo CJSON::encode([
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ]);
    
        Yii::app()->end();
    }

    public function actionGetAllplatformsex() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token = $_GET['token'] ?? null;
        $id    = $_GET['id']    ?? null;
    
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100000000;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 5000000000); // أقصى حد 500
    
        $criteria = new CDbCriteria();
    
        // فلترة حسب المستخدم
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
        // حساب عدد السجلات
        $totalCount = Platform::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allPlatforms = Platform::model()->findAll($criteria);
        $result = [];
        foreach ($allPlatforms as $platform) {
            $result[] = $platform->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionGetAllstatuesex() {
        
      //  var_dump(111);exit;
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token         = $_GET['token']         ?? null;
        $id     = $_GET['id']          ?? null;
       
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 10000000;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 5000000); // أقصى حد 500
    
        $criteria = new CDbCriteria();
    
        // فلترة تاريخ follow_date: الأولوية لـ start/end، ثم followup، ثم delay
      
    
        // فلترة حسب المستخدم
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
    
        // حساب عدد السجلات
        $totalCount = Statues::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allstatues = Statues::model()->findAll($criteria);
        $result = [];
        foreach ($allstatues as $statues) {
            $result[] = $statues->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionGetAllsubstatuesex() {
        
      //  var_dump(111);exit;
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token         = $_GET['token']         ?? null;
        $id     = $_GET['id']          ?? null;
        $status     = $_GET['status']          ?? null;
       
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 1000000;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 5000000); // أقصى حد 500
    
        $criteria = new CDbCriteria();
    
        // فلترة تاريخ follow_date: الأولوية لـ start/end، ثم followup، ثم delay
      
    
        // فلترة حسب المستخدم
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
        
        
         if ($status !== null) {
            $criteria->compare('parent_id', $status);
        }
    
      
      
        
        
    
        
    
    
        // حساب عدد السجلات
        $totalCount = Substatus::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allstatues = Substatus::model()->findAll($criteria);
        $result = [];
        foreach ($allstatues as $statues) {
            $result[] = $statues->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionGetAllprojectsex() {
        // Set timezone
        $main = Mainsettings::model()->findByPk(1);
        if ($main && $main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // GET params
        $token     = $_GET['token']   ?? null;
        $id        = $_GET['id']      ?? null;
        $user_id   = $_GET['user_id'] ?? null;
        $status    = $_GET['status']  ?? null;
    
        // Token check
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // Pagination
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 1000000;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 5000000); // hard cap
    
        // Build criteria
        $criteria = new CDbCriteria();
    
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
        if ($user_id !== null) {
            $criteria->compare('user_id', $user_id);
        }
        if ($status !== null) {
            $criteria->compare('status', $status);
        }
    
        // Count total
        $totalCount = Projects::model()->count($criteria);
    
        // Apply pagination
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // Fetch data
        $projects = Projects::model()->findAll($criteria);
        $result = [];
        foreach ($projects as $project) {
            $result[] = $project->attributes;
        }
    
        // Return response
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        echo CJSON::encode([
            'status'     => true,
            'totalCount' => $totalCount,
            'limit'      => $limit,
            'offset'     => $offset,
            'returned'   => count($result),
            'pages'      => $pages,
            'data'       => $result,
        ]);
        Yii::app()->end();
    }
    
    public function actionGetAllinterestedplacesex() {
        // Set timezone
        $main = Mainsettings::model()->findByPk(1);
        if ($main && $main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // GET parameters
        $token   = $_GET['token']   ?? null;
        $id      = $_GET['id']      ?? null;
        $user_id = $_GET['user_id'] ?? null;
        $date    = $_GET['date']    ?? null;
    
        // Token validation
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // Pagination setup
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 1000000;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 5000000); // max cap
    
        // Criteria definition
        $criteria = new CDbCriteria();
    
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
        if ($user_id !== null) {
            $criteria->compare('user_id', $user_id);
        }
    
        if ($date !== null) {
            $criteria->compare('date', $date);
        }
    
        // Get total count
        $totalCount = Interestedplace::model()->count($criteria);
    
        // Apply pagination
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // Fetch results
        $records = Interestedplace::model()->findAll($criteria);
        $result = [];
        foreach ($records as $record) {
            $result[] = $record->attributes;
        }
    
        // Build response
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        echo CJSON::encode([
            'status'     => true,
            'totalCount' => $totalCount,
            'limit'      => $limit,
            'offset'     => $offset,
            'returned'   => count($result),
            'pages'      => $pages,
            'data'       => $result,
        ]);
        Yii::app()->end();
    }
    
}
