<?php

require 's3/aws-autoloader.php';
use Aws\S3\S3Client;
use Aws\S3\Exception\S3Exception;

class HomeController extends FrontController{
	/**
	* @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	* using two-column layout. See 'protected/views/layouts/column2.php'.
	*/

	public $layout='//layouts/loginlayout';

	/**
	* @return array action filters
	*/
	public function filters(){
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}





public function actionConfirminstallmentApi()
{
    header('Content-Type: application/json; charset=utf-8');

    try {
        // 1) timezone
        $main = Mainsettings::model()->findByPk(1);
        if (!empty($main->countrytimezone)) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }

        // 2) token (من الـ GET زي الاكشن التاني)
        $token = isset($_GET['token']) ? $_GET['token'] : null;
        if ($token !== '123') {
            echo CJSON::encode(['status' => false, 'message' => 'Unauthorized or missing token']);
            Yii::app()->end();
        }

        // 3) دعم JSON body (اختياري)
        $raw = file_get_contents('php://input');
        if ($raw) {
            $asJson = json_decode($raw, true);
            if (is_array($asJson)) {
                // املأ $_POST لو جالك JSON
                foreach ($asJson as $k => $v) {
                    if (!isset($_POST[$k])) $_POST[$k] = $v;
                }
            }
        }

        // 4) قراءة البراميترز من POST أو GET معًا
        $req        = Yii::app()->request;
        $secert     = $req->getParam('id');         // إلزامي
        $dueDate    = $req->getParam('duedate');        // اختياري
        $cash       = $req->getParam('cash', null);
        $quickpay   = $req->getParam('quickpay', null);
        $note       = $req->getParam('note', null);
        $bank       = $req->getParam('bank', null);
        $bankcheck  = $req->getParam('bankcheck', null);
        $settlement = $req->getParam('settlement', null);
        $visa       = $req->getParam('visa', null);
        $buildingTree = $req->getParam('buildingtree', null);
        $bankerId     = $req->getParam('banker', null);

        if (!$secert) {
            echo CJSON::encode(['status' => false, 'message' => 'Missing required parameter: secert']);
            Yii::app()->end();
        }

        $inst = Installments::model()->findByPk($secert);
        if (!$inst) {
            echo CJSON::encode(['status' => false, 'message' => 'Installment not found']);
            Yii::app()->end();
        }

        $userId = !Yii::app()->user->isGuest ? Yii::app()->user->id : null;

        $tx = Yii::app()->db->beginTransaction();

        // 5) التحديثات
        $inst->confirm      = 1;
        $inst->lastactionby = $userId;
        if (!empty($dueDate)) {
            $inst->due_date = $dueDate;
        }

        // فلاجز اختيارية
        if ($cash !== null)         $inst->cash = 1;
        if ($quickpay !== null)     $inst->quickpay = $quickpay;
        if ($note !== null)         $inst->note = $note;
        if ($bank !== null)         $inst->bank = 1;
        if ($bankcheck !== null)    $inst->bankcheck = 1;
        if ($settlement !== null)   $inst->settlement = 1;
        if ($visa !== null)         $inst->visa = 1;
        if ($buildingTree !== null) $inst->building_tree = $buildingTree;
        if ($bankerId !== null)     $inst->banker_id = $bankerId;

        if (!$inst->save()) {
            $tx->rollback();
            echo CJSON::encode([
                'status'  => false,
                'message' => 'Validation failed on installment save',
                'errors'  => $inst->getErrors(),
            ]);
            Yii::app()->end();
        }

        $tx->commit();

        // 6) رد نهائي
        echo CJSON::encode([
            'status'  => true,
            'message' => 'Installment confirmed successfully',
            'data'    => [
                'installment_id' => $inst->id,
                'amount'         => $inst->amount,
                'due_date'       => $inst->due_date,
                'confirm'        => (int)$inst->confirm,
                'flags'          => [
                    'cash'       => (int)$inst->cash,
                    'bank'       => (int)$inst->bank,
                    'bankcheck'  => (int)$inst->bankcheck,
                    'settlement' => (int)$inst->settlement,
                    'visa'       => (int)$inst->visa,
                ],
                'quickpay'       => $inst->quickpay,
                'note'           => $inst->note,
                'building_tree'  => $inst->building_tree,
                'banker_id'      => $inst->banker_id,
                'lastactionby'   => $inst->lastactionby,
            ]
        ]);
        Yii::app()->end();

    } catch (CHttpException $e) {
        echo CJSON::encode(['status' => false, 'message' => $e->getMessage(), 'code' => $e->statusCode]);
        Yii::app()->end();
    } catch (Exception $e) {
        echo CJSON::encode(['status' => false, 'message' => $e->getMessage()]);
        Yii::app()->end();
    }
}



// SiteController.php

public function actionChecklink()
{
    $url = "https://demo5.so-sdw-0104.com/sales/transferaction/212"; // ضع الرابط هنا
    $retryInterval = 5; // مدة الانتظار بين المحاولات (بالثواني)
    $successCount = 0; // عداد النجاح المتتالي
    $requiredSuccessCount = 3; // عدد النجاحات المتتالية المطلوبة

    while (true) {
        $response = $this->checklink($url);

        if ($response === true) {
            $successCount++;
            echo "Success detected ({$successCount}/{$requiredSuccessCount})<br>";

            if ($successCount >= $requiredSuccessCount) {
                echo "Task completed successfully after {$requiredSuccessCount} consecutive true responses!<br>";
                break;
            }
        } else {
            $successCount = 0; // إعادة العد عند الحصول على false
            echo "Response is false. Resetting success count.<br>";
        }

        // الانتظار بين المحاولات
        sleep($retryInterval);
    }
}

private function checklink($url)
{
    // إعداد cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // تعيين مهلة الطلب

    // تنفيذ الطلب
    $response = curl_exec($ch);

    // تحقق من الأخطاء
    if (curl_errno($ch)) {
        echo "cURL Error: " . curl_error($ch) . "<br>";
        curl_close($ch);
        return false;
    }

    curl_close($ch);

    // تحقق من الرد (توقع أن يكون النص 'true' أو 'false')
    return trim($response) === 'true';
}



public function actionGetNotifications() {
    $userId = Yii::app()->user->id;
    $em=User::model()->findByPk($userId);
    $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { 
        date_default_timezone_set('Africa/Cairo');
        
        
        
        
        
if($main->change_time == 1) {
    
$currentMonth = date('n'); // رقم الشهر بدون الصفر البادئ
$currentDay = date('j');    // رقم اليوم

// التحقق إذا كان التوقيت الصيفي يجب أن يطبق
if (($currentMonth > 4 && $currentMonth < 10) || ($currentMonth == 4 && $currentDay >= 27) || ($currentMonth == 10 && $currentDay < 31)) {
    // إضافة ساعة واحدة للتوقيت الصيفي
    $currentHour = date("H") + 1;
} else {
    // التوقيت الشتوي
    $currentHour = date("H");
}

}else{
    
        $currentHour = date("H");

    
}

//var_dump($currentHour);exit;

    
    }; 

//$currentHour = date("H");  // الحصول على الساعة الحالية
$today = date("Y-m-d");    // الحصول على تاريخ اليوم

$criteria = new CDbCriteria;
$criteria->limit = 10;
$criteria->addCondition('notfi IS NULL');
$criteria->addCondition('close IS NULL');
//$criteria->addSearchCondition('user_id', $userId, false);
$criteria->addSearchCondition('follow_date', $today, "AND");


$criteria->addCondition("SUBSTRING(follow_time, 1, 2) = :currentHour");
$criteria->params[":currentHour"] = str_pad($currentHour, 2, '0', STR_PAD_LEFT); // التأكد من أن الساعة بصيغة من رقمين

// إضافة شرط جديد للتحقق من أن follow_time ضمن الساعة الحالية 
//$criteria->addCondition("DATE_FORMAT(follow_time, '%H') = :currentHour");
//$criteria->params[":currentHour"] = $currentHour;

$allactivities = Activities::model()->findAll($criteria);
//var_dump($allactivities);exit;


   $response = array();
foreach ($allactivities as $activities) {
$lead = Leads::model()->findByAttributes(array('id' => $activities->leads_id));

    $response[] = array(
        'name' => $lead->title,
        'message' => $activities->details,
        'url' => $activities->leads_id,
    );
    
        
        if (!empty($em->email)) {

        
        $emailContent .= "<p><strong>Name:</strong> {$lead->title}</p>";
        $emailContent .= "<p><strong>Message:</strong> {$activities->details}</p>";
        $emailContent .= "<p><strong>ID:</strong> {$activities->leads_id}</p>";
        $emailContent .= "<hr>";
        
        
        
        
        if (!empty($emailContent)) {
        $to = $em->email;
        $subject = 'New Notifications Details By Solid CRM';
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= "From: no-reply@yourdomain.com" . "\r\n";
        mail($to, $subject, $emailContent, $headers);
        }
        
        }

    // تحديث الحالة إلى 'read'
    $activities->notfi = '1';
    $activities->save();





if($activities->save()){
$lead = Leads::model()->findByAttributes(array('id' => $activities->leads_id));
$em=User::model()->findByPk($lead->user_sales);
$main = Mainsettings::model()->findByPk(1);

if (!empty($em->mobile)) {                                                     
                                                                           
$url = Yii::app()->getBaseUrl(true) . "/leads/profile/" . $lead->id;



$sid    = $main->whatsapp_sid;
$token  = $main->whatsapp_token;

// Recipient's WhatsApp number
$to = "whatsapp:+" . $em->mobile;
// Your WhatsApp Business number
$from = "whatsapp:+" . $main->whatsapp_from;

// Template SID (Use your actual Template SID)
//$templateSid = "HX3651fc98925d84c20a5ebba0cac47ad1";

$templateSid = $main->whatsapp_templatesid_4;

// Template SID (Use your actual Template SID)




if(!empty($main->hide_number_whatsapp)) {                                                     
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $url,
    '3' =>  $activities->details,

    
);
}else{
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $url,
    '3' =>  $activities->details,

);  
}

// Convert TemplateParams to JSON
$templateParams = json_encode($templateParams);

// Twilio API URL for sending template messages
$url = "https://api.twilio.com/2010-04-01/Accounts/$sid/Messages.json";

// Data to be sent in the POST request
$data = array(
    'To' => $to,
    'From' => $from,
    'ContentSid' => $templateSid, // استخدم ContentSid وليس TemplateSid
    'ContentVariables' => $templateParams // استخدم ContentVariables لتمرير المعلمات
);

// Initialize cURL
$ch = curl_init($url);

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_USERPWD, "$sid:$token");

// Execute the request and get the response
$responsewhats = curl_exec($ch);

// Check for cURL errors
if ($responsewhats === false) {
  //  echo 'cURL Error: ' . curl_error($ch);
} else {
   // $response_data = json_decode($response, true);
    
    // Check if SID exists in the response
    if (isset($response_data['sid'])) {
      //  echo 'Message SID: ' . $response_data['sid'];
         // echo json_encode($responsewhats);

    } else {
     //   echo 'No SID found in the response. Full response: ' . print_r($response_data, true);
    }
}

// Close the cURL session
curl_close($ch);

}
 
}

    echo json_encode($response);
    
    
   
    
    
}
}




public function actionCreateColumn()
{
        		        $this->layout = '//layouts/system';

    $model = new CreateColumnForm(); // Assuming you have a form model for validation

    if (isset($_POST['CreateColumnForm'])) {
        $model->attributes = $_POST['CreateColumnForm'];
        if ($model->validate()) {
            // Process the form
            $table = $model->table_name;
            $column = $model->column_name;
            $type = $model->column_type;

            $sql = "ALTER TABLE {$table} ADD COLUMN {$column} {$type}";
            Yii::app()->db->createCommand($sql)->execute();

            Yii::app()->user->setFlash('success', "Column '{$column}' added successfully to '{$table}'");
            $this->refresh(); // Refresh the page to clear form inputs
        }
    }

    $this->render('createColumn', array('model' => $model));
}


public function actionBackupDatabase()
{
    
    		        $this->layout = '//layouts/system';
    		        $token="h6LTqrATx5";

    // Backup directory
    $backupDir = Yii::getPathOfAlias('webroot.protected.backups');

    // Ensure the directory exists
    if (!is_dir($backupDir)) {
        // If directory does not exist, create it
        mkdir($backupDir, 0755, true);
    }

    // Get all the backup files in the directory, sorted by creation time
    $files = glob($backupDir . '/*.sql.gz');
    usort($files, function ($a, $b) {
        return filemtime($b) - filemtime($a);
    });

    // If there are more than 4 files, delete the oldest ones, leaving only the latest 4
    while (count($files) > 4) {
        $fileToDelete = array_pop($files);
        if (is_file($fileToDelete)) {
            unlink($fileToDelete); // Delete the file
        }
    }

    // Define the path to the mysqldump utility
    $mysqldumpPath = '/usr/bin/mysqldump'; // Adjust this path according to your server configuration

    // Database configuration
    $dbHost = Yii::app()->db->connectionString; // usually in the form of 'mysql:host=localhost;dbname=yourdbname'
    $dbHost = str_replace(['mysql:', 'host=', 'dbname='], '', $dbHost);
    $dbParts = explode(';', $dbHost);
    $host = $dbParts[0];
    $dbname = $dbParts[1];

    $username = Yii::app()->db->username;
    $password = Yii::app()->db->password;

    // Output file
   // $backupFile = $backupDir . '/backup-' . date('Y-m-d-H-i-s') . '.sql.gz';
    $backupFile = $backupDir . '/backup-' . $dbname . '-' . date('Y-m-d-H-i-s') . '.sql.gz';


    // Prepare the mysqldump command with gzip compression
    $command = "$mysqldumpPath --host=$host --user=$username --password=$password $dbname | gzip > $backupFile";

    // Execute the command
    $output = null;
    $resultCode = null;
    exec($command, $output, $resultCode);

    if ($resultCode === 0) {
        // Backup was successful, insert record into the backups table
        $backup = new Backups(); // Assuming your model is named Backups
        $backup->date = date('Y-m-d');
        $backup->time = date('H:i:s');
        $backup->file = basename($backupFile);
        $backup->details = 'Database backup created successfully.';
        $backup->save();

        // Pass the backup details to the view
        $this->render('backupResult', [
            'backupFile' => $backupFile,
            'backup' => $backup,
            'token' => $token,

            
        ]);
    } else {
        // Handle failure
        echo "Failed to create database backup.";
    }
}




public function actionBackact()
{
ini_set('max_execution_time', 300);
ini_set('memory_limit', '-1');


$allactivities = Activities::model()->findAll(); 

$fields = array('leads_id','follow_date','date','details');
$labels= array('leads_id','follow_date','date','details');
XlsExporter2::downloadXls('SOLID Activities XLS', $allactivities, 'Report-', TRUE  , $labels  , $fields, 'COUNT');

}




public function actionAutofrindis()
		{

        
// First section: Fetch and process $allfrancis
$allfrancis = Francis::model()->findAll();
if (!empty($allfrancis)) {
        $processedLeadIds = [];
        

    foreach ($allfrancis as $francis) {
        $type = TypeBuliding::model()->findByAttributes(array('id' => $francis->type));
        //echo $type->title;
        
        
        
$criteria = new CDbCriteria();
$criteria->addCondition('close IS NULL');
$criteria->addCondition('user_sales IS NULL');
$criteria->addCondition('user_integration IS NULL');
$criteria->addCondition('coldcall IS NULL');

// Assuming you're using Yii Framework or a similar ORM system
$typeIds = explode(',', $francis->type);
$projectsIds = explode(',', $francis->projects); 
$campaignsIds = explode(',', $francis->campaigns);

// Apply conditions based on non-empty arrays
if (!empty($typeIds) && array_filter($typeIds)) {
    $criteria->addInCondition('unit_type', $typeIds);
}

if (!empty($projectsIds) && array_filter($projectsIds)) {
    $criteria->addInCondition('project_id', $projectsIds);
}

if (!empty($campaignsIds) && array_filter($campaignsIds)) {
    $criteria->addInCondition('campaign_id', $campaignsIds);
}

// Fetch all lead IDs that match the criteria
$allLeads = Leads::model()->findAll($criteria);
$totalLeads = count($allLeads);

        
        


        $ratio = $francis->ratio / 100; // Convert to a decimal

        // Calculate the dynamic limit based on the ratio
        $limit = ceil($totalLeads * $ratio); // Use ceil to ensure at least one lead is fetched if the total is small



$filteredLeads = array_filter($allLeads, function($lead) use ($processedLeadIds) {
            return !in_array($lead->id, $processedLeadIds);
        });

        // Slice the array of filtered leads to get the limited set based on the ratio
        $limitedLeads = array_slice($filteredLeads, 0, $limit);


        // Slice the array of all leads to get the limited set based on the ratio
        //$limitedLeads = array_slice($allLeads, 0, $limit);

        $limitedLeadIds = array();
        $uniqueLeads = [];

        foreach ($limitedLeads as $lead) {

            
            if (in_array($lead->id, $processedLeadIds)) {
                continue; // إذا كان موجودًا، تخطيه
            }
            
            
            date_default_timezone_set('Africa/Cairo');
            $today = date("Y-m-d");
            $time = date("H:i:s");
            $rnd = rand(0, 99999);
            $userid = Yii::app()->user->id;

            $model = new Francisreadytoistrub;
            $model->attributes = $_POST['Francisreadytoistrub'];
            $model->time = $time;
            $model->date = $today;
            $model->owner_id = $francis->owner_id;
            $model->lead_id = $lead->id;
            $model->user_id = $userid;
            
            
          

            
            
            $criteria = new CDbCriteria();
            $criteria->order = 'total ASC';
            $criteria->limit = 1;
            $criteria->addSearchCondition("owner_id", $francis->owner_id, false);
            $autorot = Francisrotation::model()->find($criteria);
            if(!empty($autorot->assign_id)){
            $sales=User::model()->findByAttributes(array('id'=>$autorot->assign_id));
            $model->assign_to = $sales->id;
            $autorot->total =  $autorot->total + 1;
            $autorot->save();
            }



            if (!$model->save()) {
                

                
                var_dump($model->getErrors());
                exit;
            }
            


            $limitedLeadIds[] = $lead->id;
            $processedLeadIds[] = $lead->id; // أضف lead_id إلى مصفوفة المعالجة
            


        }


        // Output the limited lead IDs and the count
        //echo "Disturb " . count($limitedLeadIds) . " lead IDs out of " . $totalLeads . " total leads (" . ($ratio * 100) . "%).";
        // Print owner information
        $owner = User::model()->findByAttributes(array('id' => $francis->owner_id));

        //echo $owner->fname . " " . $owner->lname . "<br>";
    }
}

// Last section: Fetch and process $allfrancisreadytoistrub
$di = new CDbCriteria;
$di->condition = "confirm IS NULL";
$allfrancisreadytoistrub = Francisreadytoistrub::model()->findAll($di);

if (!empty($allfrancisreadytoistrub)) {
    foreach ($allfrancisreadytoistrub as $francisreadytoistrub) { 
         $lead = Leads::model()->findByAttributes(array('id' => $francisreadytoistrub->lead_id)); 

        // Update the confirm attribute of the Francisreadytoistrub record
        $francisreadytoistrub->confirm = 1;
        $francisreadytoistrub->save();
      

 

$lead->user_sales = $francisreadytoistrub->assign_to;
$lead->fresh_sales = $francisreadytoistrub->assign_to;
$lead->save();


 if (!$lead->save()) {

                
                
                var_dump($lead->getErrors());
                exit;
            }

     } 
} 

$this->redirect(array('engineering/francis'));

}






public function actionAutofrindiscam($id)
		{
		    
$criteriaex = new CDbCriteria();
$criteriaex->addSearchCondition('campaign_distribution_id', $id, false);
$criteriaex->order = "CASE WHEN last_update IS NULL THEN 0 ELSE 1 END, last_update ASC";
$allfrancis = Francis::model()->findAll($criteriaex);
		    
		    
// First section: Fetch and process $allfrancis
//$allfrancis = Francis::model()->findAll();
		  //  var_dump(count($allfrancis));exit;

if (!empty($allfrancis)) {
        $processedLeadIds = [];
        

    foreach ($allfrancis as $francis) {
        $francis->last_update = NULL;
        $francis->save();
        $type = TypeBuliding::model()->findByAttributes(array('id' => $francis->type));
        //echo $type->title;
        
        
        
$criteria = new CDbCriteria();
$criteria->addCondition('close IS NULL');
$criteria->addCondition('user_sales IS NULL');
$criteria->addCondition('user_integration IS NULL');
$criteria->addCondition('coldcall IS NULL');

// Assuming you're using Yii Framework or a similar ORM system
$campaignsIds = explode(',', $francis->campaigns);


if (!empty($campaignsIds) && array_filter($campaignsIds)) {
    $criteria->addInCondition('campaign_id', $campaignsIds);
}

// Fetch all lead IDs that match the criteria
$allLeads = Leads::model()->findAll($criteria);
$totalLeads = count($allLeads);

        
        


        $ratio = $francis->ratio / 100; // Convert to a decimal

        // Calculate the dynamic limit based on the ratio
        $limit = ceil($totalLeads * $ratio); // Use ceil to ensure at least one lead is fetched if the total is small



$filteredLeads = array_filter($allLeads, function($lead) use ($processedLeadIds) {
            return !in_array($lead->id, $processedLeadIds);
        });

        // Slice the array of filtered leads to get the limited set based on the ratio
        $limitedLeads = array_slice($filteredLeads, 0, $limit);


        // Slice the array of all leads to get the limited set based on the ratio
        //$limitedLeads = array_slice($allLeads, 0, $limit);

        $limitedLeadIds = array();
        $uniqueLeads = [];

        foreach ($limitedLeads as $lead) {

            
            if (in_array($lead->id, $processedLeadIds)) {
                continue; // إذا كان موجودًا، تخطيه
            }
            
            
            date_default_timezone_set('Africa/Cairo');
            $today = date("Y-m-d");
            $time = date("H:i:s");
            $rnd = rand(0, 99999);
            $userid = Yii::app()->user->id;

            $model = new Francisreadytoistrub;
            $model->attributes = $_POST['Francisreadytoistrub'];
            $model->time = $time;
            $model->date = $today;
            $model->owner_id = $francis->owner_id;
            $model->lead_id = $lead->id;
            $model->user_id = $userid;
            
            
          

            
            
            $criteria = new CDbCriteria();
            $criteria->order = 'total ASC';
            $criteria->limit = 1;
            $criteria->addSearchCondition("owner_id", $francis->owner_id, false);
            $criteria->addSearchCondition("campaign_distribution_id", $francis->campaign_distribution_id, false);

            
            $autorot = Francisrotation::model()->find($criteria);
            if(!empty($autorot->assign_id)){
            $sales=User::model()->findByAttributes(array('id'=>$autorot->assign_id));
            $model->assign_to = $sales->id;
            $autorot->total =  $autorot->total + 1;
            $autorot->save();
            }



            if (!$model->save()) {
                

                
                var_dump($model->getErrors());
                exit;
            }else{
                
        $francis->last_update = 1;
        $francis->save();
                
            }
            


            $limitedLeadIds[] = $lead->id;
            $processedLeadIds[] = $lead->id; // أضف lead_id إلى مصفوفة المعالجة
            


        }


        // Output the limited lead IDs and the count
        //echo "Disturb " . count($limitedLeadIds) . " lead IDs out of " . $totalLeads . " total leads (" . ($ratio * 100) . "%).";
        // Print owner information
        $owner = User::model()->findByAttributes(array('id' => $francis->owner_id));

        //echo $owner->fname . " " . $owner->lname . "<br>";
    }
}

// Last section: Fetch and process $allfrancisreadytoistrub
$di = new CDbCriteria;
$di->condition = "confirm IS NULL";
$allfrancisreadytoistrub = Francisreadytoistrub::model()->findAll($di);

if (!empty($allfrancisreadytoistrub)) {
    foreach ($allfrancisreadytoistrub as $francisreadytoistrub) { 
         $lead = Leads::model()->findByAttributes(array('id' => $francisreadytoistrub->lead_id)); 

        // Update the confirm attribute of the Francisreadytoistrub record
        $francisreadytoistrub->confirm = 1;
        $francisreadytoistrub->save();
      

 

$lead->user_sales = $francisreadytoistrub->assign_to;
$lead->fresh_sales = $francisreadytoistrub->assign_to;
$lead->save();


 if (!$lead->save()) {

                
                
                var_dump($lead->getErrors());
                exit;
            }

     } 
} 

$this->redirect(array('engineering/campaigndistribution/'.$id));

}



public function actionGetcontaract()
		{



        $userid=Yii::app()->user->id;
        $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        $main=Mainsettings::model()->findByPk(1);

        $tel= $_GET['tel'];
        $token= $_GET['token'];
$phone= $_GET['tel'];
 if($main->apicode == $token){



$criteriaex = new CDbCriteria();
$criteriaex->addSearchCondition('phone', $tel, false);
$allres = Reservation::model()->findAll($criteriaex); 

header('Content-Type: application/json');



 
 
 if ($main->apicode == $token) {
     
     
     
     
     $countrys = [
   // '1' => 'USA (+1)',
							'44' => 'UK (+44)',
							'213' => 'Algeria (+213)',
							'376' => 'Andorra (+376)',
							'244' => 'Angola (+244)',
							'1264' => 'Anguilla (+1264)',
							'1268' => 'Antigua & Barbuda (+1268)',
							'54' => 'Argentina (+54)',
							'374' => 'Armenia (+374)',
							'297' => 'Aruba (+297)',
							'61' => 'Australia (+61)',
							'43' => 'Austria (+43)',
							'994' => 'Azerbaijan (+994)',
							'1242' => 'Bahamas (+1242)',
							'973' => 'Bahrain (+973)',
							'880' => 'Bangladesh (+880)',
							'1246' => 'Barbados (+1246)',
							'375' => 'Belarus (+375)',
							'32' => 'Belgium (+32)',
							'501' => 'Belize (+501)',
							'229' => 'Benin (+229)',
							'1441' => 'Bermuda (+1441)',
							'975' => 'Bhutan (+975)',
							'591' => 'Bolivia (+591)',
							'387' => 'Bosnia Herzegovina (+387)',
							'267' => 'Botswana (+267)',
							'55' => 'Brazil (+55)',
							'673' => 'Brunei (+673)',
							'359' => 'Bulgaria (+359)',
							'226' => 'Burkina Faso (+226)',
							'257' => 'Burundi (+257)',
							'855' => 'Cambodia (+855)',
							'237' => 'Cameroon (+237)',
							'238' => 'Cape Verde Islands (+238)',
							'1345' => 'Cayman Islands (+1345)',
							'236' => 'Central African Republic (+236)',
							'56' => 'Chile (+56)',
							'86' => 'China (+86)',
							'57' => 'Colombia (+57)',
							'269' => 'Comoros (+269)',
							'242' => 'Congo (+242)',
							'682' => 'Cook Islands (+682)',
							'506' => 'Costa Rica (+506)',
							'385' => 'Croatia (+385)',
							'53' => 'Cuba (+53)',
							'90392' => 'Cyprus North (+90392)',
							'357' => 'Cyprus South (+357)',
							'42' => 'Czech Republic (+42)',
							'45' => 'Denmark (+45)',
							'253' => 'Djibouti (+253)',
							'1809' => 'Dominica (+1809)',
							'1809' => 'Dominican Republic (+1809)',
							'593' => 'Ecuador (+593)',
							'20' => 'Egypt (+20)',
							'200' => 'Egypt (+20)',
							'503' => 'El Salvador (+503)',
							'240' => 'Equatorial Guinea (+240)',
							'291' => 'Eritrea (+291)',
							'372' => 'Estonia (+372)',
							'251' => 'Ethiopia (+251)',
							'500' => 'Falkland Islands (+500)',
							'298' => 'Faroe Islands (+298)',
							'679' => 'Fiji (+679)',
							'358' => 'Finland (+358)',
							'33' => 'France (+33)',
							'594' => 'French Guiana (+594)',
							'689' => 'French Polynesia (+689)',
							'241' => 'Gabon (+241)',
							'220' => 'Gambia (+220)',
							'7880' => 'Georgia (+7880)',
							'49' => 'Germany (+49)',
							'233' => 'Ghana (+233)',
							'350' => 'Gibraltar (+350)',
							'30' => 'Greece (+30)',
							'299' => 'Greenland (+299)',
							'1473' => 'Grenada (+1473)',
							'590' => 'Guadeloupe (+590)',
							'671' => 'Guam (+671)',
							'502' => 'Guatemala (+502)',
							'224' => 'Guinea (+224)',
							'245' => 'Guinea - Bissau (+245)',
							'592' => 'Guyana (+592)',
							'509' => 'Haiti (+509)',
							'504' => 'Honduras (+504)',
							'852' => 'Hong Kong (+852)',
							'36' => 'Hungary (+36)',
							'354' => 'Iceland (+354)',
							'91' => 'India (+91)',
							'62' => 'Indonesia (+62)',
							'98' => 'Iran (+98)',
							'964' => 'Iraq (+964)',
							'353' => 'Ireland (+353)',
							'39' => 'Italy (+39)',
							'1876' => 'Jamaica (+1876)',
							'81' => 'Japan (+81)',
							'962' => 'Jordan (+962)',
							'7' => 'Kazakhstan (+7)',
							'254' => 'Kenya (+254)',
							'686' => 'Kiribati (+686)',
							'850' => 'Korea North (+850)',
							'82' => 'Korea South (+82)',
							'965' => 'Kuwait (+965)',
							'996' => 'Kyrgyzstan (+996)',
							'856' => 'Laos (+856)',
							'371' => 'Latvia (+371)',
							'961' => 'Lebanon (+961)',
							'266' => 'Lesotho (+266)',
							'231' => 'Liberia (+231)',
							'218' => 'Libya (+218)',
							'417' => 'Liechtenstein (+417)',
							'370' => 'Lithuania (+370)',
							'352' => 'Luxembourg (+352)',
							'853' => 'Macao (+853)',
							'389' => 'Macedonia (+389)',
							'261' => 'Madagascar (+261)',
							'265' => 'Malawi (+265)',
							'60' => 'Malaysia (+60)',
							'960' => 'Maldives (+960)',
							'223' => 'Mali (+223)',
							'356' => 'Malta (+356)',
							'692' => 'Marshall Islands (+692)',
							'596' => 'Martinique (+596)',
							'222' => 'Mauritania (+222)',
							'269' => 'Mayotte (+269)',
							'52' => 'Mexico (+52)',
							'691' => 'Micronesia (+691)',
							'373' => 'Moldova (+373)',
							'377' => 'Monaco (+377)',
							'976' => 'Mongolia (+976)',
							'1664' => 'Montserrat (+1664)',
							'212' => 'Morocco (+212)',
							'258' => 'Mozambique (+258)',
							'95' => 'Myanmar (+95)',
							'264' => 'Namibia (+264)',
							'674' => 'Nauru (+674)',
							'977' => 'Nepal (+977)',
							'31' => 'Netherlands (+31)',
							'687' => 'New Caledonia (+687)',
							'64' => 'New Zealand (+64)',
							'505' => 'Nicaragua (+505)',
							'227' => 'Niger (+227)',
							'234' => 'Nigeria (+234)',
							'683' => 'Niue (+683)',
							'672' => 'Norfolk Islands (+672)',
							'670' => 'Northern Marianas (+670)',
							'47' => 'Norway (+47)',
							'968' => 'Oman (+968)',
							'680' => 'Palau (+680)',
							'507' => 'Panama (+507)',
							'675' => 'Papua New Guinea (+675)',
							'595' => 'Paraguay (+595)',
							'51' => 'Peru (+51)',
							'63' => 'Philippines (+63)',
							'48' => 'Poland (+48)',
							'351' => 'Portugal (+351)',
							'1787' => 'Puerto Rico (+1787)',
							'974' => 'Qatar (+974)',
							'262' => 'Reunion (+262)',
							'40' => 'Romania (+40)',
							'7' => 'Russia (+7)',
							'250' => 'Rwanda (+250)',
							'378' => 'San Marino (+378)',
							'239' => 'Sao Tome & Principe (+239)',
							'966' => 'Saudi Arabia (+966)',
							'221' => 'Senegal (+221)',
							'381' => 'Serbia (+381)',
							'248' => 'Seychelles (+248)',
							'232' => 'Sierra Leone (+232)',
							'65' => 'Singapore (+65)',
							'421' => 'Slovak Republic (+421)',
							'386' => 'Slovenia (+386)',
							'677' => 'Solomon Islands (+677)',
							'252' => 'Somalia (+252)',
							'27' => 'South Africa (+27)',
							'34' => 'Spain (+34)',
							'94' => 'Sri Lanka (+94)',
							'290' => 'St. Helena (+290)',
							'1869' => 'St. Kitts (+1869)',
							'1758' => 'St. Lucia (+1758)',
							'249' => 'Sudan (+249)',
							'597' => 'Suriname (+597)',
							'268' => 'Swaziland (+268)',
							'46' => 'Sweden (+46)',
							'41' => 'Switzerland (+41)',
							'963' => 'Syria (+963)',
							'886' => 'Taiwan (+886)',
							'7' => 'Tajikstan (+7)',
							'66' => 'Thailand (+66)',
							'228' => 'Togo (+228)',
							'676' => 'Tonga (+676)',
							'1868' => 'Trinidad & Tobago (+1868)',
							'216' => 'Tunisia (+216)',
							'90' => 'Turkey (+90)',
							'7' => 'Turkmenistan (+7)',
							'993' => 'Turkmenistan (+993)',
							'1649' => 'Turks & Caicos Islands (+1649)',
							'688' => 'Tuvalu (+688)',
							'256' => 'Uganda (+256)',
							'380' => 'Ukraine (+380)',
							'971' => 'United Arab Emirates (+971)',
							'598' => 'Uruguay (+598)',
							'7' => 'Uzbekistan (+7)',
							'678' => 'Vanuatu (+678)',
							'379' => 'Vatican City (+379)',
							'58' => 'Venezuela (+58)',
							'84' => 'Vietnam (+84)',
							'84' => 'Virgin Islands - British (+1284)',
							'84' => 'Virgin Islands - US (+1340)',
							'681' => 'Wallis & Futuna (+681)',
							'969' => 'Yemen (North)(+969)',
							'967' => 'Yemen (South)(+967)',
							'260' => 'Zambia (+260)',
							'263' => 'Zimbabwe (+263)',
						];

						$temp=  substr(strstr($phone, '+'),1);
					if($temp != false){$phone=$temp;}
                                                $countrycode='';
						// sort the array by key, descending
						krsort($countrys, SORT_NUMERIC);

						// iterate over all countries
						foreach($countrys as $we => $ccode){
							// if number begins with current number
							if(strpos($phone, '' . $we) === 0){
								// store country code and break the loop
								$countrycode = $we;
								break;
							}
						}  
						
					

						if(!empty($countrycode)){
							$size=strlen($countrycode);
							$phone=substr($phone,$size);
							

							
						}
     

   
   
   
   $criteria = new CDbCriteria();
$criteria->addSearchCondition('tel', $phone, false);
$allleads = Leads::model()->findAll($criteria);

$contractData = [];

foreach ($allleads as $lead) {
    $leadData = [
        'lead_name' => $lead->title,
        'lead_tel' => $lead->tel,
        'units' => []
    ];

    $criteria = new CDbCriteria();
    $criteria->addSearchCondition('lead_id', $lead->id, false);
    $reservations = Reservation::model()->findAll($criteria);

    foreach ($reservations as $reservation) {
        $leadData['units'][] = [
            'id' => $reservation->id,
            'date' => $reservation->date,
            'name' => $reservation->name,
            'address' => $reservation->address, 
            'details' => $reservation->details,  
            'job' => $reservation->job,  
            'phone' => $reservation->phone,  
            'lead_id' => $reservation->lead_id,  
            'unit' => $reservation->unit->code, 
            'unit_status' => $reservation->unit->booking, 
            'project' => $reservation->unit->project->title, 
            'project_id' => $reservation->unit->project->id, 
            'building' => $reservation->unit->building->title, 
            'id_card' => $reservation->id_card,  
            'downpayment' => $reservation->downpayment,  
            'unit_price' => $reservation->unit_price
        ];
    }

    $contractData[] = $leadData;
}

// Convert $contractData array to JSON
$jsonOutput = json_encode($contractData, JSON_PRETTY_PRINT);

// Print JSON output
echo $jsonOutput;

   
}

 
 
    




        
}else{
    
    
            header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => false);
                echo json_encode($arr);
                die();         
}


}







public function actionGetcontaractbyid()
		{



        $userid=Yii::app()->user->id;
        $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        $main=Mainsettings::model()->findByPk(1);

        $tel= $_GET['tel'];
        $token= $_GET['token'];
$id= $_GET['id'];
 if($main->apicode == $token){


$criteriaex = new CDbCriteria();
$criteriaex->addSearchCondition('lead_id', $id, false);
$allres = Reservation::model()->findAll($criteriaex); 
//var_dump($allres);exit;

header('Content-Type: application/json');



 
 
 if ($main->apicode == $token) {
     
     
     
     

					

     

   
   
   
   $criteria = new CDbCriteria();
$criteria->addSearchCondition('id', $id, false);
$allleads = Leads::model()->findAll($criteria);

$contractData = [];

foreach ($allleads as $lead) {
    $leadData = [
        'lead_name' => $lead->title,
        'lead_tel' => $lead->tel,
        'units' => []
    ];

    $criteria = new CDbCriteria();
    $criteria->addSearchCondition('lead_id', $lead->id, false);
    $reservations = Reservation::model()->findAll($criteria);

    foreach ($reservations as $reservation) {
        $leadData['units'][] = [
            'id' => $reservation->id,
            'date' => $reservation->date,
            'name' => $reservation->name,
            'address' => $reservation->address, 
            'details' => $reservation->details,  
            'job' => $reservation->job,  
            'phone' => $reservation->phone,  
            'lead_id' => $reservation->lead_id,  
            'unit' => $reservation->unit->code, 
            'unit_status' => $reservation->unit->booking, 
            'project' => $reservation->unit->project->title, 
            'project_id' => $reservation->unit->project->id, 
            'building' => $reservation->unit->building->title, 
            'id_card' => $reservation->id_card,  
            'downpayment' => $reservation->downpayment,  
            'unit_price' => $reservation->unit_price
        ];
    }

    $contractData[] = $leadData;
}

// Convert $contractData array to JSON
$jsonOutput = json_encode($contractData, JSON_PRETTY_PRINT);

// Print JSON output
echo $jsonOutput;

   
}

 
 
    




        
}else{
    
    
            header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => false);
                echo json_encode($arr);
                die();         
}


}


public function actionGetcontaractdata()
{
    // ===== Timezone =====
    $main = Mainsettings::model()->findByPk(1);
    if ($main && $main->countrytimezone) {
        date_default_timezone_set($main->countrytimezone);
    } else {
        date_default_timezone_set('Africa/Cairo');
    }

    header('Content-Type: application/json; charset=utf-8');

    // ===== Auth =====
    $token = Yii::app()->request->getQuery('token');
    if (!$main || $main->apicode !== $token) {
        echo json_encode(['status' => false, 'error' => 'Unauthorized'], JSON_UNESCAPED_UNICODE);
        Yii::app()->end();
    }

    // ===== Optional filters =====
    $projectId = Yii::app()->request->getQuery('project_id'); // int
    $fromDate  = Yii::app()->request->getQuery('from');       // YYYY-MM-DD
    $toDate    = Yii::app()->request->getQuery('to');         // YYYY-MM-DD

    // ===== Query base =====
    $criteria = new CDbCriteria();
    $criteria->with = [
        'unit' => [
            'with' => [
                'project'  => [],
                'building' => [],
            ],
        ],
        'lead' => [], // كل بيانات الليد
    ];

    // فلتر المشروع بشكل آمن
    if (!empty($projectId)) {
        $unitsSchema = Units::model()->getTableSchema();
        $hasProjectIdColOnUnits = $unitsSchema && $unitsSchema->getColumn('project_id') !== null;
        if ($hasProjectIdColOnUnits) {
            $criteria->addCondition('unit.project_id = :pid');
        } else {
            // fallback عبر العلاقة project
            $criteria->addCondition('project.id = :pid');
        }
        $criteria->params[':pid'] = (int)$projectId;
    }

    // فلاتر التاريخ (على حقل date في التعاقد)
    if (!empty($fromDate)) {
        $criteria->addCondition('DATE(t.date) >= :fromDate');
        $criteria->params[':fromDate'] = $fromDate;
    }
    if (!empty($toDate)) {
        $criteria->addCondition('DATE(t.date) <= :toDate');
        $criteria->params[':toDate'] = $toDate;
    }

    $criteria->order = 't.date DESC';
    $reservations = Reservation::model()->findAll($criteria);

    // ===== Helpers =====
    $has = function($model, $attr) {
        return method_exists($model, 'hasAttribute') && $model->hasAttribute($attr);
    };
    $val = function($model, $attr) use ($has) {
        return $has($model, $attr) ? $model->$attr : null;
    };

    // تجهيز model لجدول طلب الحجز (لو موجود)
    $rrModel = class_exists('RequestReservation') ? RequestReservation::model() : null;
    $rrHasCol = function($col) use ($rrModel) {
        if (!$rrModel) return false;
        $schema = $rrModel->getTableSchema();
        return $schema && $schema->getColumn($col) !== null;
    };

    $contracts = [];
    foreach ($reservations as $r) {
        $unit     = $r->unit;
        $project  = $unit ? $unit->project : null;
        $building = $unit ? $unit->building : null;
        $lead     = $r->lead;

        // ===== Deposit من RequestReservation أولاً (بشكل آمن) =====
        $depositOut        = null;
        $depositFieldUsed  = null;
        $depositSource     = null;
        $req               = null;
        $reqAttrs          = null;

        if ($rrModel) {
            // أ) جرّب الربط بـ reservation_no لو العمود موجود على الطلب والتعاقد عندك
            if (!$req && $rrHasCol('reservation_no') && $has($r, 'reservation_no') && !empty($r->reservation_no)) {
                $req = $rrModel->find('reservation_no = :no', [':no' => $r->reservation_no]);
            }

            // ب) جرّب الربط بـ reservation_id فقط إذا العمود موجود فعلًا
            if (!$req && $rrHasCol('reservation_id')) {
                $req = $rrModel->find('reservation_id = :rid', [':rid' => (int)$r->id]);
            }

            // ج) جرّب الأحدث على نفس الوحدة (+ تضييق بالـ lead لو متاح)
            if (!$req && $rrHasCol('unit_id') && $has($r, 'unit_id') && !empty($r->unit_id)) {
                $c = new CDbCriteria();
                $c->addCondition('unit_id = :uid');
                $c->params[':uid'] = (int)$r->unit_id;

                if ($rrHasCol('lead_id') && $has($r, 'lead_id') && !empty($r->lead_id)) {
                    $c->addCondition('lead_id = :lid');
                    $c->params[':lid'] = (int)$r->lead_id;
                }

                if     ($rrHasCol('created_at')) $c->order = 'created_at DESC';
                elseif ($rrHasCol('updated_at')) $c->order = 'updated_at DESC';
                else                              $c->order = 'id DESC';

                $req = $rrModel->find($c);
            }

            // لو لقينا طلب الحجز، التقط الديبوزت من أول عمود منطقي متاح
            if ($req) {
                $reqAttrs = $req->attributes;
                $depositCandidates = [
                    'deposit','deposit_amount','deposit_value',
                    'requested_deposit','booking_deposit',
                    'booking_amount','booking_fees',
                    'serious_deposit','jedyh','jedia','jadeyah',
                    'downpayment','amount','paid'
                ];
                foreach ($depositCandidates as $cname) {
                    if ($req->hasAttribute($cname) && $req->$cname !== null && $req->$cname !== '') {
                        $depositOut       = $req->$cname;
                        $depositFieldUsed = $cname;
                        $depositSource    = 'request_reservation';
                        break;
                    }
                }
            }
        }

        // Fallback: لو مفيش قيمة من الطلب، نستخدم downpayment من التعاقد
        if ($depositOut === null) {
            $depositOut       = $val($r, 'downpayment');
            $depositFieldUsed = $depositOut !== null ? 'downpayment' : null;
            $depositSource    = $depositOut !== null ? 'reservation' : null;
        }

        // ===== بعض الحقول المهمة من التعاقد (لو موجودة) =====
        $contractKeyFields = [
            'financialapproval'   => $val($r,'financialapproval'),
            'collect_status'      => $val($r,'collect_status'),
            'collect_status_done' => $val($r,'collect_status_done'),
            'contract_code'       => $val($r,'contract_code'),
            'reservation_no'      => $val($r,'reservation_no'),
            'delivery_date'       => $val($r,'delivery_date'),
            'discount'            => $val($r,'discount'),
            'tax'                 => $val($r,'tax'),
            'maintenance'         => $val($r,'maintenance'),
            'net_price'           => $val($r,'net_price'),
            'paid_amount'         => $val($r,'paid_amount'),
            'remaining_amount'    => $val($r,'remaining_amount'),
            'notes'               => $val($r,'notes'),
            'created_at'          => $val($r,'created_at'),
            'updated_at'          => $val($r,'updated_at'),
            'created_by'          => $val($r,'created_by'),
            'sales_id'            => $val($r,'sales_id'),
            'branch_id'           => $val($r,'branch_id'),
        ];

        // ===== بيانات العميل المخزّنة داخل سجل التعاقد نفسه =====
        $customerFromContract = [
            'name'     => $val($r,'name'),
            'id_card'  => $val($r,'id_card'),
            'job'      => $val($r,'job'),
            'address'  => $val($r,'address'),
            'phone'    => $val($r,'phone'),
            'details'  => $val($r,'details'),
        ];

        // ===== ملخص الليد + كامل الأعمدة =====
        $leadSummary = $lead ? [
            'id'         => (int)$lead->id,
            'name'       => isset($lead->title) ? $lead->title : null,
            'tel'        => isset($lead->tel) ? $lead->tel : null,
            'email'      => isset($lead->email) ? $lead->email : null,
            'address'    => isset($lead->address) ? $lead->address : null,
            'source'     => isset($lead->source) ? $lead->source : null,
            'status'     => isset($lead->status) ? $lead->status : null,
            'created_at' => isset($lead->created_at) ? $lead->created_at : null,
            'updated_at' => isset($lead->updated_at) ? $lead->updated_at : null,
        ] : null;

        // ===== Assemble record =====
        $contracts[] = [
            // أساسية
            'id'           => (int)$r->id,
            'date'         => $val($r,'date'),
            'unit_price'   => $val($r,'unit_price'),
            'downpayment'  => $val($r,'downpayment'),

            // الديبوزت النهائي + معلومات المصدر
            'deposit'              => $depositOut,
            'deposit_source'       => $depositSource,     // request_reservation | reservation | null
            'deposit_field'        => $depositFieldUsed,  // اسم العمود المستخدم
            'deposit_request_all'  => $reqAttrs,          // كامل ريكورد الطلب (لو متاح)

            // التعاقد
            'contract'     => $contractKeyFields,
           // 'contract_all' => $r->attributes,             // كل الأعمدة Raw

            // العميل داخل التعاقد
            'customer'     => $customerFromContract,

            // الليد
            'lead'         => $leadSummary,
            'lead_all'     => $lead ? $lead->attributes : null,

            // الوحدة/المشروع
            'unit'         => $unit ? $unit->code : null,
            'unit_status'  => $unit ? $unit->booking : null,
            'project'      => $project ? $project->title : null,
            'project_id'   => $project ? (int)$project->id : null,
            'building'     => $building ? $building->title : null,
        ];
    }

    echo json_encode([
        'status'    => true,
        'count'     => count($contracts),
        'contracts' => $contracts,
    ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);

    Yii::app()->end();
}


public function actionQuickfinancialapprovalApi()
{
    header('Content-Type: application/json; charset=utf-8');

    // ===== Timezone =====
    $main = Mainsettings::model()->findByPk(1);
    if ($main && $main->countrytimezone) {
        date_default_timezone_set($main->countrytimezone);
    } else {
        date_default_timezone_set('Africa/Cairo');
    }

    // ===== Read params =====
    $req = Yii::app()->request;
    $token         = $req->getPost('token',         $req->getQuery('token'));
    $reservationId = $req->getPost('reservation_id',$req->getQuery('reservation_id'));
    $collectStatus = $req->getPost('collect_status',$req->getQuery('collect_status'));

    // ===== Auth =====
    if (!$main || empty($token) || $main->apicode !== $token) {
        echo json_encode(['status' => false, 'error' => 'Unauthorized or missing token'], JSON_UNESCAPED_UNICODE);
        Yii::app()->end();
    }

    // ===== Validate =====
    if (empty($reservationId)) {
        echo json_encode(['status' => false, 'error' => 'reservation_id is required'], JSON_UNESCAPED_UNICODE);
        Yii::app()->end();
    }

    // ===== Load reservation & unit =====
    $res = Reservation::model()->findByPk((int)$reservationId);
    if (!$res) {
        echo json_encode(['status' => false, 'error' => 'Reservation not found'], JSON_UNESCAPED_UNICODE);
        Yii::app()->end();
    }
    $unit = Units::model()->findByPk($res->unit_id);
    if (!$unit) {
        echo json_encode(['status' => false, 'error' => 'Unit not found for this reservation'], JSON_UNESCAPED_UNICODE);
        Yii::app()->end();
    }

    // ===== WhatsApp (Twilio) config =====
    $sid         = trim($main->whatsapp_sid);
    $twToken     = trim($main->whatsapp_token);
    $fromNumber  = trim($main->whatsapp_from);      // +E164
    $from        = !empty($fromNumber) ? 'whatsapp:'.$fromNumber : null;
    $templateSid = trim($main->whatsapp_templatesid_5);
    $confirmUrl  = Yii::app()->getBaseUrl(true) . "/account/confirmreservation";

    // ===== Recipients =====
    $crit = new CDbCriteria();
    $crit->addCondition('notification IS NOT NULL');
    $crit->compare('salesmanger', 1);
    $crit->compare('level', 1);
    $users = User::model()->findAll($crit);

    $normalize = function ($msisdn) {
        $m = preg_replace('/\s+/', '', (string)$msisdn);
        if ($m === '') return null;
        if (strpos($m, 'whatsapp:') === 0) $m = substr($m, 9);
        if ($m[0] !== '+') {
            if (preg_match('/^01\d{9}$/', $m)) {
                $m = '+20' . ltrim($m, '0'); // مصر
            } elseif (preg_match('/^0\d+$/', $m)) {
                $m = '+20' . ltrim($m, '0');
            } elseif (preg_match('/^\d{10,15}$/', $m)) {
                $m = '+' . $m;
            } else {
                return null;
            }
        }
        if (!preg_match('/^\+\d{8,15}$/', $m)) return null;
        return 'whatsapp:' . $m;
    };

    $recipients = [];
    foreach ($users as $u) {
        if (!empty($u->mobile)) {
            $to = $normalize($u->mobile);
            if ($to) $recipients[] = $to;
        }
    }
    if (!empty($res->phone)) {
        $to = $normalize($res->phone);
        if ($to) $recipients[] = $to;
    }
    $recipients = array_values(array_unique($recipients));

    // ===== Transaction =====
    $tx = Yii::app()->db->beginTransaction();
    $messages = [];
    try {
        // -- Reservation updates
        $res->financialapproval = 1;

        if ($collectStatus === 'have_collect') {
            $res->collect_status = 1;
            $unit->booking = 1;

        } elseif ($collectStatus === 'full_collect') {
            $res->collect_status = 2;
            if ($res->hasAttribute('collect_status_done')) {
                $res->collect_status_done = 1;
            }
            $unit->booking = 2;

        } else {
            if ((int)$unit->booking < 1) $unit->booking = 1;
        }

        if (!$res->save()) {
            throw new CException('Reservation save failed: '.json_encode($res->getErrors(), JSON_UNESCAPED_UNICODE));
        }
        if (property_exists($unit, 'updated_at')) {
            $unit->updated_at = new CDbExpression('NOW()');
        }
        if (!$unit->save()) {
            throw new CException('Unit save failed: '.json_encode($unit->getErrors(), JSON_UNESCAPED_UNICODE));
        }

        // -- WhatsApp notifications
        if (!empty($sid) && !empty($twToken) && !empty($from) && !empty($templateSid) && count($recipients) > 0) {
            $apiUrl = "https://api.twilio.com/2010-04-01/Accounts/$sid/Messages.json";
            foreach ($recipients as $to) {
                $tplVars = [
                    '1' => $res->name ?: 'عميل',
                    '2' => isset($unit->code) ? $unit->code : 'UNIT',
                    '3' => $confirmUrl,
                ];
                $payload = [
                    'To'               => $to,
                    'From'             => $from,
                    'ContentSid'       => $templateSid,
                    'ContentVariables' => json_encode($tplVars, JSON_UNESCAPED_UNICODE),
                    'message_id'       => uniqid('msg_', true),
                ];

                $ch = curl_init($apiUrl);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));
                curl_setopt($ch, CURLOPT_USERPWD, "$sid:$twToken");
                $response = curl_exec($ch);

                if ($response === false) {
                    $messages[] = ['to' => $to, 'success' => false, 'error' => 'cURL: '.curl_error($ch)];
                } else {
                    $decoded = json_decode($response, true);
                    if (isset($decoded['sid'])) {
                        $messages[] = ['to' => $to, 'success' => true, 'sid' => $decoded['sid']];
                    } else {
                        $messages[] = ['to' => $to, 'success' => false, 'error' => $decoded];
                    }
                }
                curl_close($ch);
            }
        }

        $tx->commit();

        echo json_encode([
            'status' => true,
            'reservation' => [
                'id'                 => (int)$res->id,
                'financialapproval'  => (int)$res->financialapproval,
                'collect_status'     => (int)$res->collect_status,
                'collect_status_done'=> $res->hasAttribute('collect_status_done') ? (int)$res->collect_status_done : 0,
                'customer_name'      => $res->name,
            ],
            'unit' => [
                'id'      => (int)$unit->id,
                'code'    => isset($unit->code) ? $unit->code : null,
                'booking' => (int)$unit->booking,
            ],
            'notifications' => [
                'recipients_count' => count($recipients),
                'messages'         => $messages,
            ],
            'meta' => [
                'method' => $req->isPostRequest ? 'POST' : 'GET',
                'applied_collect_status' => $collectStatus ?: null,
            ],
        ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        Yii::app()->end();

    } catch (Exception $e) {
        if ($tx->active) $tx->rollback();
        echo json_encode(['status' => false, 'error' => $e->getMessage()], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        Yii::app()->end();
    }
}








public function actionGetprojects()
		{



        $userid=Yii::app()->user->id;
        $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        $main=Mainsettings::model()->findByPk(1);

        $tel= $_GET['tel'];
        $token= $_GET['token'];
$phone= $_GET['tel'];
 if($main->apicode == $token){



header('Content-Type: application/json');



 
 
 if ($main->apicode == $token) {
     
     
     
     

					

   
   
   
$criteria = new CDbCriteria();
$allprojects = Projects::model()->findAll($criteria);
$countprojectData = [];

foreach ($allprojects as $projects) {
    $projects = [
        'project_name' => $projects->title,
        'building' => []
    ];

    $criteria = new CDbCriteria();
    $criteria->addSearchCondition('project_id', $projects->id, false);
    $allbuilding = Building::model()->findAll($criteria);

    foreach ($allbuilding as $building) {
        $projects['building'][] = [
            'id' => $building->id,
            'building_name' => $building->title,
            'units' => []
            
        ];
        
        
        
        
        
    $criteria = new CDbCriteria();
    $criteria->addSearchCondition('building_id', $building->id, false);
    $allunits = Units::model()->findAll($criteria);


     
     
      foreach ($allunits as $units) {
        $projects['units'][] = [
            'id' => $units->id,
            'code' => $units->code,
            'booking' => $units->booking,

        ];
        
      }    
        
    }
    
    
    
    
    
    

    $countprojectData[] = $projects;
}

// Convert $contractData array to JSON
$jsonOutput = json_encode($countprojectData, JSON_PRETTY_PRINT);

// Print JSON output
echo $jsonOutput;

   
}

 
 
    




        
}else{
    
    
            header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => false);
                echo json_encode($arr);
                die();         
}


}










public function actionGetAllUnits()
{
    header('Content-Type: application/json; charset=utf-8');

    try {
        // Timezone
        $main = Mainsettings::model()->findByPk(1);
        $tz   = $main && !empty($main->countrytimezone) ? $main->countrytimezone : 'Africa/Cairo';
        date_default_timezone_set($tz);

        // === Auth (Yii1 compatible) ===
        $headers = function_exists('getallheaders') ? getallheaders() : [];
        $auth    = isset($headers['Authorization']) ? $headers['Authorization'] : null;

        $token = null;
        if ($auth && stripos($auth, 'Bearer ') === 0) {
            $token = trim(substr($auth, 7));
        } elseif (!empty($_GET['token'])) {
            $token = $_GET['token']; // fallback للتجربة
        }

        $expectedToken = '123';

        if (!$token || $token !== $expectedToken) {
            echo CJSON::encode([
                'status'  => false,
                'error'   => 'unauthorized',
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }

        // Inputs
        $id     = isset($_GET['id']) ? (int)$_GET['id'] : null;
        $limit  = isset($_GET['limit']) ? (int)$_GET['limit'] : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        if ($limit < 1)   $limit = 1;
        if ($limit > 500) $limit = 500;
        if ($offset < 0)  $offset = 0;

        // Criteria
        $criteria = new CDbCriteria();
        if ($id !== null) {
            $criteria->compare('id', $id);
        }

        $totalCount = Units::model()->count($criteria);

        $criteria->limit  = $limit;
        $criteria->offset = $offset;

        $rows = Units::model()->findAll($criteria);
        $data = [];
        foreach ($rows as $row) {
            $data[] = $row->attributes;
        }

        echo CJSON::encode([
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => $limit,
            'offset'      => $offset,
            'returned'    => count($data),
            'data'        => $data,
        ]);
        Yii::app()->end();

    } catch (Exception $e) {
        echo CJSON::encode([
            'status'  => false,
            'error'   => 'server_error',
            'message' => 'Unexpected server error',
            'detail'  => YII_DEBUG ? $e->getMessage() : null,
        ]);
        Yii::app()->end();
    }
}

    



public function actionGetinst()
		{



        $userid=Yii::app()->user->id;
        $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        $main=Mainsettings::model()->findByPk(1);

        $id= $_GET['id'];
        $token= $_GET['token'];

 if($main->apicode == $token){




$criteriaex = new CDbCriteria();
$criteriaex->addSearchCondition('reservation_id', $id, false);
$allinstallment= Installments::model()->findAll($criteriaex); 

// Initialize counters
$totalAmount = 0;
$paidAmount = 0;
$remainingAmount = 0;
$delayedAmount = 0;
$quickpay = 0;
$dissc = 0;

header('Content-Type: application/json');




        if(!empty($allinstallment)){
            foreach($allinstallment as  $installment){ 
               
               
               
                $foo[] = array (  
        'payment_date' => $installment->payment_date,  
        'due_date' => $installment->due_date,  
        'amount' => $installment->amount,  
        'pay' => $installment->confirm, 
        'unit' => $installment->unit->code,  

        
 );
               
            }
        } 



$json_data = new CJSON;

echo $json_data->encode($foo);
die();     

    




        
}else{
    
    
            header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => false);
                echo json_encode($arr);
                die();         
}


}




public function actionGetinstlead()
{
    // ======== Basic Setup ========
    $request = Yii::app()->request;
    $id     = (int)$request->getParam('id');
    $token  = (string)$request->getParam('token');

    // Load settings once
    $main = Mainsettings::model()->findByPk(1);
    $tz   = !empty($main->countrytimezone) ? $main->countrytimezone : 'Africa/Cairo';
    date_default_timezone_set($tz);

    // JSON header
    header('Content-Type: application/json; charset=UTF-8');

    // Quick guards
    if (empty($id) || empty($token)) {
        http_response_code(400);
        echo CJSON::encode([
            'status' => false,
            'error'  => 'Missing required parameters: id or token'
        ], JSON_UNESCAPED_UNICODE);
        Yii::app()->end();
    }

    // Token check (timing-attack safe)
    $apiCode = (string)$main->apicode;
    if (!function_exists('hash_equals')) {
        // Polyfill for very old PHP, if needed
        function hash_equals($a, $b) { return (is_string($a) && is_string($b) && strlen($a) === strlen($b) && ($a ^ $b) === "\0"); }
    }
    if (!hash_equals($apiCode, $token)) {
        http_response_code(401);
        echo CJSON::encode(['status' => false, 'error' => 'Unauthorized'], JSON_UNESCAPED_UNICODE);
        Yii::app()->end();
    }

    // ======== Query Criteria ========
    $criteria = new CDbCriteria();
    $criteria->compare('t.lead_id', $id);

    // ======== Fetch Reservations (eager load unit) ========
    $reservations = Reservation::model()
        ->with('unit') // assumes relation name is "unit"
        ->findAll($criteria);

    $units = [];
    if (!empty($reservations)) {
        foreach ($reservations as $r) {
            $unitCode = null;
            $unitId   = null;
            if (!empty($r->unit)) {
                $unitCode = $r->unit->code;
                $unitId   = $r->unit->id;
            }
            $units[] = [
                'id'               => (int)$r->id,
                'lead_id'          => (int)$r->lead_id,
                'unit'             => $unitCode,
                'unit_id'          => $unitId,
                'downpayment'      => (float)$r->downpayment,
                'reservation_date' => $r->resv_date,
                'contract_date'    => $r->con_date,
                'unit_price'       => (float)$r->unit_price,
            ];
        }
    }

    // ======== Fetch Installments (eager load unit) ========
    $installments = Installments::model()
        ->with('unit')
        ->findAll($criteria);

    $installmentsArr = [];
    $totalAmount     = 0.0;
    $paidAmount      = 0.0;
    $delayedAmount   = 0.0;
    $today           = date('Y-m-d');

    if (!empty($installments)) {
        foreach ($installments as $ins) {
            $amt   = (float)$ins->amount;
            $paid  = (int)$ins->confirm === 1; // assuming confirm=1 means paid
            $due   = $ins->due_date;
            $isDelayedUnpaid = (!$paid && !empty($due) && $due < $today);

            $totalAmount += $amt;
            if ($paid) {
                $paidAmount += $amt;
            } elseif ($isDelayedUnpaid) {
                $delayedAmount += $amt;
            }

            $unitCode = !empty($ins->unit) ? $ins->unit->code : null;
            $unitId   = !empty($ins->unit) ? $ins->unit->id   : null;

            $installmentsArr[] = [
                'id'           => (int)$ins->id,
                'payment_date' => $ins->payment_date,
                'due_date'     => $due,
                'amount'       => $amt,
                'paid'         => $paid ? 1 : 0,
                'unit'         => $unitCode,
                'unit_id'      => $unitId,
            ];
        }
    }

    $remainingAmount = max(0.0, $totalAmount - $paidAmount);

    // ======== Next Due (nearest unpaid) ========
    $nextDue = null;
    if (!empty($installmentsArr)) {
        // Filter unpaid with a due_date in the future or today
        $unpaid = array_filter($installmentsArr, function ($i) use ($today) {
            return ((int)$i['paid'] === 0) && !empty($i['due_date']) && $i['due_date'] >= $today;
        });
        if (!empty($unpaid)) {
            usort($unpaid, function ($a, $b) {
                return strcmp($a['due_date'], $b['due_date']);
            });
            $nextDue = $unpaid[0];
        }
    }

    // ======== Final Response ========
    $response = [
        'status' => true,
        'meta'   => [
            'timezone' => $tz,
            'generated_at' => date('c'),
            'lead_id'  => $id,
        ],
        'data'   => [
            'units'        => $units,
            'installments' => $installmentsArr,
            'summary'      => [
                'total'     => round($totalAmount, 2),
                'paid'      => round($paidAmount, 2),
                'remaining' => round($remainingAmount, 2),
                'delayed'   => round($delayedAmount, 2),
                'next_due'  => $nextDue, // null or the nearest unpaid
            ],
        ],
    ];

    // 200 OK
    http_response_code(200);
    echo CJSON::encode($response, JSON_UNESCAPED_UNICODE);
    Yii::app()->end();
}









public function actionUpdatequotation()
		{


    $userid=Yii::app()->user->id;
        $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        $main=Mainsettings::model()->findByPk(1);

        
        $title= $_GET['title'];
        $code= $_GET['code'];
        $req=RequestReservation::model()->findByAttributes(array('id'=>$code));
        //var_dump($req);exit;

        $token= $_GET['token'];

 if($main->apicode == $token){

		$req->cancel = 1;
		$req->cancel_date = $today;
        if(!$req->save()){
        var_dump($req->getErrors());
        }else{
            
        
            header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => true);
                echo json_encode($arr);
                die();         
            
            
            
        }
        
        
}else{
    
    
            header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => false);
                echo json_encode($arr);
                die();         
}


}








public function actionCreateproject()
		{



        $userid=Yii::app()->user->id;
        $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        $main=Mainsettings::model()->findByPk(1);

        
        $title= $_GET['title'];
        $token= $_GET['token'];

 if($main->apicode == $token){

		$model = new Projects();
		$model->setScenario('com_porfile');
		$rnd = rand(0,9999);
		$model->title = $title;
		$model->user_id = 1;
		$model->date = $today;
		$model->time = $time;
		$model->hidden = 1;
		$model->status = 1;
		$model->secert = $rnd.$userid;
        if(!$model->save()){
        var_dump($model->getErrors());
        }else{
            
        
            header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => true);
                echo json_encode($arr);
                die();         
            
            
            
        }
        
        
}else{
    
    
            header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => false);
                echo json_encode($arr);
                die();         
}


}








public function actionCreateBuilding()
		{



        $userid=Yii::app()->user->id;
        $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        $main=Mainsettings::model()->findByPk(1);

        
        $title= $_GET['title'];
        $token= $_GET['token'];

 if($main->apicode == $token){

		$model = new Building();
		$model->setScenario('com_porfile');
		$rnd = rand(0,9999);
		$model->title = $title;
		$model->user_id = 1;
		$model->date = $today;
		$model->time = $time;
		$model->hidden = 1;
		$model->status = 1;
		$model->secert = $rnd.$userid;
        if(!$model->save()){
        var_dump($model->getErrors());
        }else{
            
        
            header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => true);
                echo json_encode($arr);
                die();         
            
            
            
        }
        
        
}else{
    
    
            header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => false);
                echo json_encode($arr);
                die();         
}


}




public function actionCreateunit()
		{







        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        $main=Mainsettings::model()->findByPk(1);

        
        $title= $_GET['title'];
        $token= $_GET['token'];
        $project= $_GET['project'];
        $building= $_GET['building'];
        $code= $_GET['code'];
        $spaceindoor = $_GET['spaceindoor'];
        $spaceoutdoor = $_GET['spaceoutdoor'];
        $spacesquareindoor = $_GET['spacesquareindoor'];
        $pricesquareoutdoor = $_GET['pricesquareoutdoor'];
        $pricesquareindoortotal = $_GET['pricesquareindoortotal'];
        $pricesquareoutdoortotal = $_GET['pricesquareoutdoortotal'];
        $total = $_GET['total'];

        $project = Projects::model()->findByAttributes(array('title'=>$project)); 
        $building = Building::model()->findByAttributes(array('title'=>$building)); 

//var_dump($project);exit;

 if($main->apicode == $token){

		$model = new Units();
		$model->setScenario('com_porfile');
		$rnd = rand(0,9999);

	    $model->code = $code;
		$model->user_id = 1;
		$model->projects_id = $project->id;
		$model->building_id = $building->id;
		$model->date = $today;
		$model->time = $time;
		$model->hidden = 1;
		$model->status = 1;
		$model->delivery_date = $today;	
		$model->secert = $rnd.$userid;
        $model->indoor_size = $spaceindoor;
        $model->outdoor_size = $spaceoutdoor;
        $model->indoor_price = $spacesquareindoor;
        $model->outdoor_price = $pricesquareoutdoor;
        $model->indoor_total_price = $pricesquareindoortotal;
        $model->outdoor_total_price = $pricesquareoutdoortotal;
        $model->total = $total;


        if(!$model->save()){
        var_dump($model->getErrors());
        }else{
            
        
            header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => true);
                echo json_encode($arr);
                die();         
            
            
            
        }
        
        
}else{
    
    
            header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => false);
                echo json_encode($arr);
                die();         
}


}







public function actionUpdateunit()
		{






        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        $main=Mainsettings::model()->findByPk(1);

        
        $title= $_GET['title'];
        $token= $_GET['token'];
        $project= $_GET['project'];
        $building= $_GET['building'];
        $code= $_GET['code'];
        $spaceindoor = $_GET['spaceindoor'];
        $spaceoutdoor = $_GET['spaceoutdoor'];
        $spacesquareindoor = $_GET['spacesquareindoor'];
        $pricesquareoutdoor = $_GET['pricesquareoutdoor'];
        $pricesquareindoortotal = $_GET['pricesquareindoortotal'];
        $pricesquareoutdoortotal = $_GET['pricesquareoutdoortotal'];
        $total = $_GET['total'];
        $status = $_GET['status'];

        $model = Units::model()->findByAttributes(array('code'=>$code)); 
        $project = Projects::model()->findByAttributes(array('id'=>$model->projects_id)); 
        $building = Building::model()->findByAttributes(array('id'=>$model->building_id)); 

//var_dump($status);exit;

 if($main->apicode == $token){

		$rnd = rand(0,9999);

		$model->user_id = 1;
		$model->projects_id = $project->id;
		$model->building_id = $building->id;
		$model->date = $today;
		$model->time = $time;
		$model->hidden = 1;
		$model->status = 1;
		$model->delivery_date = $today;	
		$model->secert = $rnd.$userid;
        $model->indoor_size = $spaceindoor;
        $model->outdoor_size = $spaceoutdoor;
        $model->indoor_price = $spacesquareindoor;
        $model->outdoor_price = $pricesquareoutdoor;
        $model->indoor_total_price = $pricesquareindoortotal;
        $model->outdoor_total_price = $pricesquareoutdoortotal;
        $model->total = $total;
        		$model->booking = $status;

        


        if(!$model->save()){
        var_dump($model->getErrors());
        }else{
            
        
            header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => true);
                echo json_encode($arr);
                die();         
            
            
            
        }
        
        
}else{
    
    
            header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => false);
                echo json_encode($arr);
                die();         
}


}





public function actionUpdateRes()
		{






        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        $main=Mainsettings::model()->findByPk(1);

        
        $title= $_GET['title'];
        $token= $_GET['token'];
        $project= $_GET['project'];
        $building= $_GET['building'];
        $code= $_GET['code'];
        $spaceindoor = $_GET['spaceindoor'];
        $spaceoutdoor = $_GET['spaceoutdoor'];
        $spacesquareindoor = $_GET['spacesquareindoor'];
        $pricesquareoutdoor = $_GET['pricesquareoutdoor'];
        $pricesquareindoortotal = $_GET['pricesquareindoortotal'];
        $pricesquareoutdoortotal = $_GET['pricesquareoutdoortotal'];
        $total = $_GET['total'];
        $status = $_GET['status'];

        $model = Reservation::model()->findByAttributes(array('id'=>$code)); 


 if($main->apicode == $token){

		$rnd = rand(0,9999);


        if(!$model->save()){
        var_dump($model->getErrors());
        }else{
            
        
            header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => true);
                echo json_encode($arr);
                die();         
            
            
            
        }
        
        
}else{
    
    
            header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => false);
                echo json_encode($arr);
                die();         
}


}






public function actionUnitcode(){
if(Yii::app()->user->isMember()){
 
 
         $code= $_GET['code'];

//var_dump($code);exit;
    
//$allreservation=Reservation::model()->findAll();



$criteria = new CDbCriteria;
$criteria->addSearchCondition('code', $code, false, "AND");
$allunits = Units::model()->findAll($criteria);
    
header('Content-Type: application/json; charset=utf-8');

//$foo = array('leads' => array());
header('Content-Type: application/json; charset=utf-8');

foreach ($allunits as $units) {
    

    $foo[] = array (  
        'id'   => $units->id,  
        'code' => $units->code,  
        'indoor_size' => $units->indoor_size,  
        'outdoor_size' => $units->outdoor_size,  
        'total' => $units->total,  

        
        
    );
}

echo json_encode($foo, JSON_UNESCAPED_UNICODE);



die();     

}
}









public function actionCustomer($id){
if(Yii::app()->user->isMember()){
 
//var_dump($id);exit;
    
//$allreservation=Reservation::model()->findAll();



$criteria = new CDbCriteria;
$criteria->addSearchCondition('lead_id', $id, false, "AND");
$allreservation = Reservation::model()->findAll($criteria);
    
header('Content-Type: application/json; charset=utf-8');

//$foo = array('leads' => array());
header('Content-Type: application/json; charset=utf-8');

foreach ($allreservation as $reservation) {
    
    $unit=Units::model()->findByAttributes(array('id'=>$reservation->unit_id));

    $foo[] = array (  
        'id'   => $reservation->id,  
        'date' => $reservation->date,  
        'name' => $reservation->name,  
        'unit' => $unit->code,  
        'price' => $reservation->unit_price,  
        'downpayment' => $reservation->downpayment,  
        'amount_paid' => $reservation->amount_paid,  
        'details' => $reservation->details,  
        'address' => $reservation->address,  

        
        
    );
}

echo json_encode($foo, JSON_UNESCAPED_UNICODE);



die();     

}
}









public function actionWhatsapp(){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
            
		    }
         
		    $this->layout = '//';
		        
		  $this->render('whatsapp');

    }



public function actionAttendancestatus(){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
            
		    }
         
		    $this->layout = '//';
		        
		  $this->render('attendancestatus');

    }
    


public function actionAttendance()
{

$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
$today = date("Y-m-d");                     // 03.10.01
$time = date('Y-m-d H:i:s');                      // 17:16:18	


//var_dump($time);exit;
$code= $_GET['code'];

//var_dump($date);exit;

$userid=Yii::app()->user->id;
$user=User::model()->findByPk($userid);


$criteria = new CDbCriteria;
$criteria->compare('user_id', $user->id);
$criteria->addCondition('leave_time IS NULL');
$checkin = HrAttendance::model()->find($criteria);

if(empty($checkin)){
$model = new HrAttendance(); 
$model->user_id= $user->id;
$model->name= $user->fname.''.$user->lname;
$model->date= $date;
$model->reg_no= $code;
$model->attendance_time= $time;
$model->save();



if($model->save()){
$this->redirect(array('home/attendancestatus')	);

}

if(!$model->save()){
//var_dump($model->getErrors());
$this->redirect(array('home/index')	);

}
}else{

$checkin->leave_time= $time;



// Create DateTime objects for the two times
$attendance_datetime = new DateTime($checkin->attendance_time);
$current_datetime = new DateTime($time);

// Calculate the difference in minutes
$interval = $attendance_datetime->diff($current_datetime);
$minutes_difference = $interval->days * 24 * 60 + $interval->h * 60 + $interval->i;
$checkin->working_hours = $minutes_difference;





if($checkin->save()){
$this->redirect(array('home/attendancestatus')	);

}

$checkin->save();
if(!$checkin->save()){
//var_dump($checkin->getErrors());
$this->redirect(array('home/index')	);

}
    
    
}






}






public function actionCamattendance()
{

$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
$today = date("Y-m-d");                     // 03.10.01
$time = date('Y-m-d H:i:s');                      // 17:16:18	

$image= $_GET['image'];
$latitude= $_GET['latitude'];
$longitude= $_GET['longitude'];
    	     	$code = rand(0,99999);


//var_dump($code);exit;

//var_dump($date);exit;

$userid=Yii::app()->user->id;
$user=User::model()->findByPk($userid);


$criteria = new CDbCriteria;
$criteria->compare('user_id', $user->id);
$criteria->addCondition('leave_time IS NULL');
$checkin = HrAttendance::model()->find($criteria);

if(empty($checkin)){

$model = new HrAttendance(); 
$model->user_id= $user->id;
$model->name= $user->fname.''.$user->lname;
$model->date= $date;
$model->reg_no= $code;
$model->attendance_time= $time;
$model->attendance_latitude= $latitude;
$model->attendance_longitude= $longitude;

$model->save();



if($model->save()){
$this->redirect(array('home/attendancestatus')	);

}

if(!$model->save()){
//var_dump($model->getErrors());
$this->redirect(array('home/index')	);

}
}else{

$checkin->leave_time= $time;
$checkin->leave_latitude= $latitude;
$checkin->leave_longitude= $longitude;


// Create DateTime objects for the two times
$attendance_datetime = new DateTime($checkin->attendance_time);
$current_datetime = new DateTime($time);

// Calculate the difference in minutes
$interval = $attendance_datetime->diff($current_datetime);
$minutes_difference = $interval->days * 24 * 60 + $interval->h * 60 + $interval->i;
$checkin->working_hours = $minutes_difference;





if($checkin->save()){
$this->redirect(array('home/attendancestatus')	);

}

$checkin->save();
if(!$checkin->save()){
//var_dump($checkin->getErrors());
$this->redirect(array('home/index')	);

}
    
    
}






}



public function actionReservationstb(){
if(Yii::app()->user->isMember()){
 
    
$allreservation=Reservation::model()->findAll();
    
header('Content-Type: application/json');

//$foo = array('leads' => array());

foreach ($allreservation as $reservation) {
    $foo[] = array (  
        'id' => $reservation->id,  
        'date' => $reservation->date,  
        'name' => $reservation->name,  
        'address' => $reservation->address, 
        'details' => $reservation->details,  

        'job' => $reservation->job,  
        'phone' => $reservation->phone,  
        'lead' => $reservation->lead_id,  
        'unit' => $reservation->unit->code, 
        'id_card' => $reservation->id_card,  
        'downpayment' => $reservation->downpayment,  
        'unit_price' => $reservation->unit_price,  


      
        
    );
}

$json_data = new CJSON;

echo $json_data->encode($foo);
die();     

}
}






public function actionFetchTodayLeads()
{
    // تحقق من وجود كلمة مرور صحيحة في GET
    if (!isset($_GET['password']) || $_GET['password'] !== 'XLy@V$EyvYbsjrjL') {
        header('Content-Type: application/json');
        echo CJSON::encode(['error' => 'Unauthorized access.']);
        Yii::app()->end();
    }

    // تحديد تاريخ اليوم بصيغة YYYY-MM-DD
    $today = date('Y-m-d');

    // إعداد شرط جلب الليدز بتاريخ اليوم فقط
    $criteria = new CDbCriteria;
    $criteria->condition = "communication IS NULL ";
    $criteria->addCondition("DATE(t.date) = :today");
    $criteria->params[':today'] = $today;

    // تنفيذ الاستعلام
    $allleads = Leads::model()->findAll($criteria);

    // إعداد الهيدر والنتيجة بصيغة JSON
    header('Content-Type: application/json');
    $result = [];

    foreach ($allleads as $lead) {
        $result[] = array(
            'id' => $lead->id,
            'date' => $lead->date,
            'name' => $lead->title,
            'user_sales' => $lead->sales->fname . " " . $lead->sales->lname,
            'tel' => $lead->international_code . " " . $lead->tel,


        );
    }

    // طباعة البيانات بصيغة JSON
    echo CJSON::encode($result);
    Yii::app()->end();
}





public function actionInsertLeadByUrl() {
    header('Content-Type: application/json');

    // إعداد التوقيت المحلي
    $main = Mainsettings::model()->findByPk(1);
    date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');

    // التحقق من التوكن
    $token = $_GET['token'] ?? null;
    if ($token !== 'XLy@V$EyvYbsjrjL') {
        echo json_encode(['status' => false, 'message' => 'Invalid token']);
        Yii::app()->end();
    }

    // استقبال البيانات
    $title       = $_GET['title']        ?? null;
    $tel         = $_GET['tel']          ?? null;
    $second_tel  = $_GET['second_tel']   ?? null;
    $tel3        = $_GET['tel3']         ?? null;
    $tel4        = $_GET['tel4']         ?? null;
    $email       = $_GET['email']        ?? null;
    $job         = $_GET['job']          ?? null;
    $notes       = $_GET['notes']        ?? null;
    $project_id  = $_GET['project_id']   ?? null;
    $campaign_id = $_GET['campaign_id']  ?? null;
    $interest_id = $_GET['interest_id']  ?? null;
    $platform_id = $_GET['platform_id']  ?? null;
    $platformchild_id = $_GET['platformchild_id'] ?? null;
    $user_id     = $_GET['user_id']      ?? null;
    $user_sales  = $_GET['user_sales']   ?? null;
    $user_marketing = $_GET['user_marketing'] ?? null;
    $fresh_sales = $_GET['fresh_sales']  ?? null;
    $orgrainc    = $_GET['orgrainc']     ?? null;
    $mediabuyer  = $_GET['mediabuyer']   ?? null;
    $branch      = $_GET['branch']       ?? null;
    $tag_id      = $_GET['tag_id']       ?? null;
    $tag         = $_GET['tag']          ?? null;
    $place       = $_GET['place']        ?? null;
    $campaign    = $_GET['campaign']     ?? null;

    // تحقق من user
    if (!$user_id || !User::model()->findByPk($user_id)) {
        echo json_encode(['status' => false, 'message' => 'Invalid user_id']);
        Yii::app()->end();
    }

    // تحقق من project
    if (!$project_id || !Projects::model()->findByPk($project_id)) {
        echo json_encode(['status' => false, 'message' => 'Invalid project_id']);
        Yii::app()->end();
    }

    // ربط strategy من campaign
    $campaignModel = Campaign::model()->findByPk($campaign_id);
    if (!$campaignModel || !$campaignModel->strategy_id) {
        echo json_encode(['status' => false, 'message' => 'Invalid campaign or missing strategy_id']);
        Yii::app()->end();
    }
    $strategy_id = $campaignModel->strategy_id;

    // إدخال البيانات
    $lead = new Leads();
    $lead->title           = $title;
    $lead->tel             = $tel;
    $lead->second_tel      = $second_tel;
    $lead->tel3            = $tel3;
    $lead->tel4            = $tel4;
    $lead->email           = $email;
    $lead->career          = $job;
    $lead->notes           = $notes;
    $lead->project_id      = $project_id;
    $lead->campaign_id     = $campaign_id;
    $lead->interest_id     = $interest_id;
    $lead->platform_id     = $platform_id;
    $lead->platformchild_id = $platformchild_id;
    $lead->user_id         = $user_id;
    $lead->user_sales      = $user_sales;
    $lead->user_marketing  = $user_marketing;
    $lead->fresh_sales     = $fresh_sales;
    $lead->orgrainc        = $orgrainc;
    $lead->mediabuyer      = $mediabuyer;
    $lead->strategy_id     = $strategy_id;
    $lead->date            = date('Y-m-d');
    $lead->time            = date('H:i:s');
    //$lead->communication   = NULL;
    $lead->hidden   = 1;


    // tag تلقائي إذا مش موجود
    if ($tag_id) {
        $lead->tag_id = $tag_id;
    } elseif ($tag) {
        $tagModel = Tag::model()->find('title=:t', [':t' => $tag]);
        if ($tagModel) {
            $lead->tag_id = $tagModel->id;
        } else {
            $newTag = new Tag();
            $newTag->title = $tag;
            if ($newTag->save()) {
                $lead->tag_id = $newTag->id;
            }
        }
    }

    // place تلقائي
    if ($place) {
        $placeModel = Interestedplace::model()->find('title=:t', [':t' => $place]);
        if ($placeModel) {
            $lead->place = $placeModel->id;
        } else {
            $newPlace = new Interestedplace();
            $newPlace->title = $place;
            if ($newPlace->save()) {
                $lead->place = $newPlace->id;
            }
        }
    }

  

    // الحفظ
    if ($lead->save()) {
        echo json_encode([
            'status' => true,
            'message' => 'Lead created successfully',
            'lead_id' => $lead->id,
            'secert' => $lead->id
        ]);
    } else {
        echo json_encode([
            'status' => false,
            'message' => 'Failed to save lead',
            'errors' => $lead->getErrors()
        ]);
    }

    Yii::app()->end();
}



public function actionUpdateLeadDetails()
{
    // تحقق من كلمة المرور
    if (Yii::app()->request->getParam('password') !== 'XLy@V$EyvYbsjrjL') {
        header('Content-Type: application/json');
        echo CJSON::encode(['error' => 'Unauthorized access.']);
        Yii::app()->end();
    }

    // هنا نسمح بالـ GET أو POST معاً
    $id      = (int) Yii::app()->request->getParam('id');
    $details = trim(Yii::app()->request->getParam('details', ''));

    header('Content-Type: application/json');
    if (!$id || $details === '') {
        echo CJSON::encode(['error' => 'Missing required parameters.']);
        Yii::app()->end();
    }

    $lead = Leads::model()->findByPk($id);
    if (!$lead) {
        echo CJSON::encode(['error' => "Lead with ID {$id} not found."]);
        Yii::app()->end();
    }

    // دمج القديم بالجديد
    $old = $lead->details;
    $now = date('Y-m-d H:i:s');
    $lead->details = trim($old . "\n[{$now}] " . $details);

    if ($lead->save(false, ['details'])) {
        echo CJSON::encode([
            'success' => true,
            'id'      => $lead->id,
            'details' => $lead->details,
        ]);
    } else {
        echo CJSON::encode([
            'success' => false,
            'errors'  => $lead->getErrors(),
        ]);
    }

    Yii::app()->end();
}


public function actionDistributeLead()
{
    // 1. التحقق من كلمة المرور
    $password = Yii::app()->request->getParam('password');
    if ($password !== 'XLy@V$EyvYbsjrjL') {
        header('Content-Type: application/json');
        echo CJSON::encode(['error' => 'Unauthorized access.']);
        Yii::app()->end();
    }

    // 2. جلب المعطيات (id و user_sales) من GET أو POST
    $id         = (int) Yii::app()->request->getParam('id');
    $newSalesId = (int) Yii::app()->request->getParam('user_sales');

    header('Content-Type: application/json');

    // 3. التحقق من المعطيات المطلوبة
    if ($id <= 0 || $newSalesId <= 0) {
        echo CJSON::encode(['error' => 'Missing or invalid parameters.']);
        Yii::app()->end();
    }

    // 4. جلب سجل الـ Lead
    /** @var Leads $lead */
    $lead = Leads::model()->findByPk($id);
    if (!$lead) {
        echo CJSON::encode(['error' => "Lead with ID {$id} not found."]);
        Yii::app()->end();
    }

    // 5. تحديث حقل user_sales (تأكد من اسم العمود في جدولك)
    $lead->user_sales = $newSalesId;
    $lead->fresh_sales = $newSalesId;


    // 6. حفظ التغيير (دون إعادة تحقق من القواعد إلا على user_sales)
    if ($lead->save(false, ['user_sales'])) {
        echo CJSON::encode([
            'success'    => true,
            'id'         => $lead->id,
            'user_sales' => $lead->sales->fname . ' ' . $lead->sales->lname,
        ]);
    } else {
        echo CJSON::encode([
            'success' => false,
            'errors'  => $lead->getErrors(),
        ]);
    }

    Yii::app()->end();
}


public function actionLeadstb(){
if(Yii::app()->user->isMember()){
 
    
$allleads=Leads::model()->findAll();
    
header('Content-Type: application/json');

//$foo = array('leads' => array());

foreach ($allleads as $leads) {
    $foo[] = array (  
        'id' => $leads->id,  
        'date' => $leads->date,  
        
        
'user_id' => $leads->employee->fname." ".$leads->employee->lname,
'user_sales' => $leads->sales->fname." ".$leads->sales->lname,
'fresh_sales' => $leads->freshsales->fname." ".$leads->freshsales->lname,

        
       
        'close' => $leads->close,
         'communication' => $leads->communication,
         'transfer' => $leads->transfer,
        
    );
}

$json_data = new CJSON;



echo $json_data->encode($foo);
die();     

}
}







function actionGdms() {
   
   
   
   // GDMS API endpoint URL
    $api_url = 'https://gdms.example.com/api';

    // API credentials
    $api_id = '103106';
    $secret_key = 'HPrNPvdnywWNb3DBT3A8kfR38Tutyccb';

    // Function to make API request
    function call_gdms_api($endpoint, $data) {
        global $api_url, $api_id, $secret_key;

        $url = $api_url . $endpoint;

        // Prepare data for the request
        $data_string = json_encode($data);

        // Prepare headers
        $headers = [
            'Content-Type: application/json',
            'x-api-id: ' . $api_id,
            'x-secret-key: ' . $secret_key
        ];

        // Initialize cURL
        $ch = curl_init($url);

        // Set cURL options
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        // Execute the request
        $result = curl_exec($ch);

        // Check for cURL error
        if ($result === false) {
            $error_message = curl_error($ch);
            curl_close($ch);
            return ['error' => 'cURL Error: ' . $error_message];
        }

        // Close cURL session
        curl_close($ch);

        return $result;
    }

    // Example usage for calling the endpoint 201113244077 from extension 1001
    $endpoint = '/201113244077';
    $data = array(
        'extension' => '1001'
        // Include any other parameters required by the endpoint here
    );

    // Make the API call
    $response = call_gdms_api($endpoint, $data);

    // Handle the response
    if (isset($response['error'])) {
        echo 'Error making API request: ' . $response['error'];
    } else {
        // Decode JSON response
        $decoded_response = json_decode($response, true);
        
        if ($decoded_response !== null) {
            // Process the response
            var_dump($decoded_response);
        } else {
            echo 'Error decoding JSON response.';
        }
    }
}

// Call the function


// Call the function





public function actionPbx($id){
    if(Yii::app()->user->isMember()){
        $url= $_GET['url'];
        //var_dump($url);exit;
            $lead= Leads::model()->findByAttributes(array('id'=>$id)); 
            $userid=Yii::app()->user->id;
            $user=User::model()->findByPk($userid);
            $mainapp=Mainsettings::model()->findByPk(1);
            //var_dump($user);exit;
            $com=$mainapp->com_s;
            $key=$mainapp->key_s;
            $tenant=$mainapp->tenant_s;
            $ext=$user->ext_no;
            $callee=$lead->tel;
            $cosid=1;
            $prefix=90;
            $name=$lead->title;
            
            $alldata = array(
            "caller" => $ext,
            "callee" => $prefix.$callee,
            "cos_id" => $cosid,
            "cid_name" => $name,
            "cid_number" => $prefix.$callee,
            );
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL,$com);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $alldata);                                 
            
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
            		"app-key: {$key}",
            		"tenant: {$tenant}",
            	//	"Content-Type: application/json"
            	]);
            
            $result = curl_exec ($ch);
            curl_close($ch);
           // $this->redirect(array('sales/profile','secert' => $lead->id), false);
           	header('Location:'.$url);

            die(); 


    
    } 
}





public function actionSendsmsreport(){
$today = date("Y-m-d");                     // 03.10.01
$criteriaact = new CDbCriteria();
$criteriaact->addBetweenCondition("date",$today,$today,'AND');
$allact = Activities::model()->count($criteriaact);


$criteriafollowact = new CDbCriteria();
$criteriafollowact->addCondition('close IS  NULL');
$criteriafollowact->addBetweenCondition("follow_date",$today,$today,'AND');
$allfollowact = Activities::model()->count($criteriafollowact);

//var_dump($allfollowact);exit;

$main=Mainsettings::model()->findByPk(1);	    

$message=$main->visitmessage;
$smsmessagecontent = rawurlencode($message);

$sendername=$main->sender;
$senderuser=$main->username;
$senderpass=$main->password;
$sendernumber="201094007009";
$curl = curl_init();

curl_setopt_array($curl, array(

CURLOPT_URL => "https://smsmisr.com/api/SMS/?environment=1&username=".$senderuser."&password=".$senderpass."&language=2&sender=".$sendername."&mobile=".$sendernumber."&message=".$smsmessagecontent ,


CURLOPT_RETURNTRANSFER => true,
CURLOPT_ENCODING => "",
CURLOPT_MAXREDIRS => 10,
CURLOPT_TIMEOUT => 30,
CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
CURLOPT_CUSTOMREQUEST => "POST",
CURLOPT_HTTPHEADER => array(
'Content-Type: application/json', 
'Content-Length:0 ' ,
"Cache-Control: no-cache",
),
));
$response = curl_exec($curl);
$err = curl_error($curl);
var_dump($response);



}



public function actionSendsms($id){
    if(Yii::app()->user->isMember()){
            $lead= Leads::model()->findByAttributes(array('id'=>$id)); 
            $userid=Yii::app()->user->id;
            $user=User::model()->findByPk($userid);
            $mainapp=Mainsettings::model()->findByPk(1);
            //var_dump($user);exit;
            $com='https://smsmisr.com/api/webapi/?username=HitYA6Rf&password=TC8MKomxDaA101d&language=1&sender=CapitalHils&mobile=201155016281&message=test';
            $name=$lead->title;
            
           
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL,$com);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);

           
            
            $result = curl_exec ($ch);
            curl_close($ch);
            var_dump($result);exit;
            $this->redirect(array('sales/profile','secert' => $lead->id), false);



    
    } 
}











public function actionLatecheck(){
if(Yii::app()->user->isMember()){

$criteria = new CDbCriteria();             
$criteria->condition = "close IS NULL AND too IS NULL";
$start = '2019-01-01';
$end = date('Y-m-d', strtotime("-1 days"));
$criteria->addBetweenCondition("follow_date",$start,$end,'AND');
$criteria->addCondition('coldcall IS NULL AND broker_id IS NULL AND indirect IS NULL');
$allactivities = Activities::model()->FindAll($criteria);
if(!empty($allactivities)){
foreach($allactivities as $activities){ 

$alllast = Activities::model()->findAll(array( 'condition' => 'leads_id=' . $activities->leads_id ,'limit'=>1 ,'order'=>'id DESC'  ));

if(!empty($alllast)){
foreach($alllast as $last){     

//if(!empty($last->close)){
    
//var_dump($last->leads_id);exit;
$last->close = NULL;
$last->report = NULL;

$last->save();

//}
} }

} }

} 
    
}


public function actionToken()
		{

 
$code= $_GET['code'];
$apptoken= $_GET['apptoken'];



  


	$user= User::model()->findByAttributes(array('token'=>$code));
	if(!empty($user)){
	//$user=User::model()->findByPk($lead->user_sales);
	//$int=(int)$user->token;
    //echo($lead->title);
    
    
    	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
	$today = date("Y-m-d");                     // 03.10.01
	$time = date("H:i:s");   
    

    
	$tok= FirebaseToken::model()->findByAttributes(array('token'=>$apptoken));
	
	//var_dump($tok);
//exit;


if(!empty($tok)){
$tok->userid= $user->id;
$tok->token= $apptoken;
$tok->ip= $user->token;
$tok->type= 'app';
$tok->os= 'app';
$tok->browser= 'app';
$tok->date= $today;
$tok->time= $time;

$tok->save();    

header('Content-Type: application/json');
    $true="true";
    
    $arr = array('status' => true);

echo json_encode($arr);
		//echo CJSON::encode($tok);
		die();     


    
}
    
if(empty($tok)){    
$model = new FirebaseToken(); 
$model->userid= $user->id;
$model->token= $apptoken;
$model->ip= $user->token;
$model->type= 'app';
$model->os= 'app';
$model->browser= 'app';
$model->date= $today;
$model->time= $time;

$model->save();


if(!$model->save()){
    
 
var_dump($model->getErrors());

}else{
    
  header('Content-Type: application/json');
    $true="true";
    
    $arr = array('status' => true);

echo json_encode($arr);
		//echo CJSON::encode($tok);
		die();     
    
}

}else{
    
    
    
    header('Content-Type: application/json');
    $true="true";
    
    $arr = array('status' => true);

echo json_encode($arr);
		//echo CJSON::encode($tok);
		die();  
    
    
   
    
}
    
    
    
      //$this->redirect(array('sales/profile','secert' => $lead->secert), false);

	}else{
	    
	    
	    
	    
	    
    header('Content-Type: application/json');
    $true="true";
    
    $arr = array('status' => false);

echo json_encode($arr);
		//echo CJSON::encode($tok);
		die();  
	    //echo "not found";
	    
	    
	    
	    
	      
//$model = new FbLeadForm(); 
 
//$today = date("Y-m-d");                     // 03.10.01


  
	//	$model->name= 'unknow';
	//	$model->tel= $phone;
      //  $model->callcenter= 1;
      //  $model->date= $today;
	//	if(!$model->save()){
		  //  var_dump($model->getErrors());
	///	}
    
	    

	 //   $this->redirect(array('marketing/leads','code' => $countrycode,'tel' => $phone), false);
	}


}







public function actionCard()
		{

 
$phone= $_GET['mobile'];
$apptoken= $_GET['apptoken'];
$phone = (int)$phone;
//var_dump($phone);exit;

  



    
$tok= FirebaseToken::model()->findByAttributes(array('token'=>$apptoken));
if(!empty($tok)){   
if(!empty($phone) ){
if($phone[0]=='0')
    $phone = substr($phone , 1);
    
  
$countrys = [
   // '1' => 'USA (+1)',
							'44' => 'UK (+44)',
							'213' => 'Algeria (+213)',
							'376' => 'Andorra (+376)',
							'244' => 'Angola (+244)',
							'1264' => 'Anguilla (+1264)',
							'1268' => 'Antigua & Barbuda (+1268)',
							'54' => 'Argentina (+54)',
							'374' => 'Armenia (+374)',
							'297' => 'Aruba (+297)',
							'61' => 'Australia (+61)',
							'43' => 'Austria (+43)',
							'994' => 'Azerbaijan (+994)',
							'1242' => 'Bahamas (+1242)',
							'973' => 'Bahrain (+973)',
							'880' => 'Bangladesh (+880)',
							'1246' => 'Barbados (+1246)',
							'375' => 'Belarus (+375)',
							'32' => 'Belgium (+32)',
							'501' => 'Belize (+501)',
							'229' => 'Benin (+229)',
							'1441' => 'Bermuda (+1441)',
							'975' => 'Bhutan (+975)',
							'591' => 'Bolivia (+591)',
							'387' => 'Bosnia Herzegovina (+387)',
							'267' => 'Botswana (+267)',
							'55' => 'Brazil (+55)',
							'673' => 'Brunei (+673)',
							'359' => 'Bulgaria (+359)',
							'226' => 'Burkina Faso (+226)',
							'257' => 'Burundi (+257)',
							'855' => 'Cambodia (+855)',
							'237' => 'Cameroon (+237)',
							'238' => 'Cape Verde Islands (+238)',
							'1345' => 'Cayman Islands (+1345)',
							'236' => 'Central African Republic (+236)',
							'56' => 'Chile (+56)',
							'86' => 'China (+86)',
							'57' => 'Colombia (+57)',
							'269' => 'Comoros (+269)',
							'242' => 'Congo (+242)',
							'682' => 'Cook Islands (+682)',
							'506' => 'Costa Rica (+506)',
							'385' => 'Croatia (+385)',
							'53' => 'Cuba (+53)',
							'90392' => 'Cyprus North (+90392)',
							'357' => 'Cyprus South (+357)',
							'42' => 'Czech Republic (+42)',
							'45' => 'Denmark (+45)',
							'253' => 'Djibouti (+253)',
							'1809' => 'Dominica (+1809)',
							'1809' => 'Dominican Republic (+1809)',
							'593' => 'Ecuador (+593)',
							'20' => 'Egypt (+20)',
							'200' => 'Egypt (+20)',
							'503' => 'El Salvador (+503)',
							'240' => 'Equatorial Guinea (+240)',
							'291' => 'Eritrea (+291)',
							'372' => 'Estonia (+372)',
							'251' => 'Ethiopia (+251)',
							'500' => 'Falkland Islands (+500)',
							'298' => 'Faroe Islands (+298)',
							'679' => 'Fiji (+679)',
							'358' => 'Finland (+358)',
							'33' => 'France (+33)',
							'594' => 'French Guiana (+594)',
							'689' => 'French Polynesia (+689)',
							'241' => 'Gabon (+241)',
							'220' => 'Gambia (+220)',
							'7880' => 'Georgia (+7880)',
							'49' => 'Germany (+49)',
							'233' => 'Ghana (+233)',
							'350' => 'Gibraltar (+350)',
							'30' => 'Greece (+30)',
							'299' => 'Greenland (+299)',
							'1473' => 'Grenada (+1473)',
							'590' => 'Guadeloupe (+590)',
							'671' => 'Guam (+671)',
							'502' => 'Guatemala (+502)',
							'224' => 'Guinea (+224)',
							'245' => 'Guinea - Bissau (+245)',
							'592' => 'Guyana (+592)',
							'509' => 'Haiti (+509)',
							'504' => 'Honduras (+504)',
							'852' => 'Hong Kong (+852)',
							'36' => 'Hungary (+36)',
							'354' => 'Iceland (+354)',
							'91' => 'India (+91)',
							'62' => 'Indonesia (+62)',
							'98' => 'Iran (+98)',
							'964' => 'Iraq (+964)',
							'353' => 'Ireland (+353)',
							'39' => 'Italy (+39)',
							'1876' => 'Jamaica (+1876)',
							'81' => 'Japan (+81)',
							'962' => 'Jordan (+962)',
							'7' => 'Kazakhstan (+7)',
							'254' => 'Kenya (+254)',
							'686' => 'Kiribati (+686)',
							'850' => 'Korea North (+850)',
							'82' => 'Korea South (+82)',
							'965' => 'Kuwait (+965)',
							'996' => 'Kyrgyzstan (+996)',
							'856' => 'Laos (+856)',
							'371' => 'Latvia (+371)',
							'961' => 'Lebanon (+961)',
							'266' => 'Lesotho (+266)',
							'231' => 'Liberia (+231)',
							'218' => 'Libya (+218)',
							'417' => 'Liechtenstein (+417)',
							'370' => 'Lithuania (+370)',
							'352' => 'Luxembourg (+352)',
							'853' => 'Macao (+853)',
							'389' => 'Macedonia (+389)',
							'261' => 'Madagascar (+261)',
							'265' => 'Malawi (+265)',
							'60' => 'Malaysia (+60)',
							'960' => 'Maldives (+960)',
							'223' => 'Mali (+223)',
							'356' => 'Malta (+356)',
							'692' => 'Marshall Islands (+692)',
							'596' => 'Martinique (+596)',
							'222' => 'Mauritania (+222)',
							'269' => 'Mayotte (+269)',
							'52' => 'Mexico (+52)',
							'691' => 'Micronesia (+691)',
							'373' => 'Moldova (+373)',
							'377' => 'Monaco (+377)',
							'976' => 'Mongolia (+976)',
							'1664' => 'Montserrat (+1664)',
							'212' => 'Morocco (+212)',
							'258' => 'Mozambique (+258)',
							'95' => 'Myanmar (+95)',
							'264' => 'Namibia (+264)',
							'674' => 'Nauru (+674)',
							'977' => 'Nepal (+977)',
							'31' => 'Netherlands (+31)',
							'687' => 'New Caledonia (+687)',
							'64' => 'New Zealand (+64)',
							'505' => 'Nicaragua (+505)',
							'227' => 'Niger (+227)',
							'234' => 'Nigeria (+234)',
							'683' => 'Niue (+683)',
							'672' => 'Norfolk Islands (+672)',
							'670' => 'Northern Marianas (+670)',
							'47' => 'Norway (+47)',
							'968' => 'Oman (+968)',
							'680' => 'Palau (+680)',
							'507' => 'Panama (+507)',
							'675' => 'Papua New Guinea (+675)',
							'595' => 'Paraguay (+595)',
							'51' => 'Peru (+51)',
							'63' => 'Philippines (+63)',
							'48' => 'Poland (+48)',
							'351' => 'Portugal (+351)',
							'1787' => 'Puerto Rico (+1787)',
							'974' => 'Qatar (+974)',
							'262' => 'Reunion (+262)',
							'40' => 'Romania (+40)',
							'7' => 'Russia (+7)',
							'250' => 'Rwanda (+250)',
							'378' => 'San Marino (+378)',
							'239' => 'Sao Tome & Principe (+239)',
							'966' => 'Saudi Arabia (+966)',
							'221' => 'Senegal (+221)',
							'381' => 'Serbia (+381)',
							'248' => 'Seychelles (+248)',
							'232' => 'Sierra Leone (+232)',
							'65' => 'Singapore (+65)',
							'421' => 'Slovak Republic (+421)',
							'386' => 'Slovenia (+386)',
							'677' => 'Solomon Islands (+677)',
							'252' => 'Somalia (+252)',
							'27' => 'South Africa (+27)',
							'34' => 'Spain (+34)',
							'94' => 'Sri Lanka (+94)',
							'290' => 'St. Helena (+290)',
							'1869' => 'St. Kitts (+1869)',
							'1758' => 'St. Lucia (+1758)',
							'249' => 'Sudan (+249)',
							'597' => 'Suriname (+597)',
							'268' => 'Swaziland (+268)',
							'46' => 'Sweden (+46)',
							'41' => 'Switzerland (+41)',
							'963' => 'Syria (+963)',
							'886' => 'Taiwan (+886)',
							'7' => 'Tajikstan (+7)',
							'66' => 'Thailand (+66)',
							'228' => 'Togo (+228)',
							'676' => 'Tonga (+676)',
							'1868' => 'Trinidad & Tobago (+1868)',
							'216' => 'Tunisia (+216)',
							'90' => 'Turkey (+90)',
							'7' => 'Turkmenistan (+7)',
							'993' => 'Turkmenistan (+993)',
							'1649' => 'Turks & Caicos Islands (+1649)',
							'688' => 'Tuvalu (+688)',
							'256' => 'Uganda (+256)',
							'380' => 'Ukraine (+380)',
							'971' => 'United Arab Emirates (+971)',
							'598' => 'Uruguay (+598)',
							'7' => 'Uzbekistan (+7)',
							'678' => 'Vanuatu (+678)',
							'379' => 'Vatican City (+379)',
							'58' => 'Venezuela (+58)',
							'84' => 'Vietnam (+84)',
							'84' => 'Virgin Islands - British (+1284)',
							'84' => 'Virgin Islands - US (+1340)',
							'681' => 'Wallis & Futuna (+681)',
							'969' => 'Yemen (North)(+969)',
							'967' => 'Yemen (South)(+967)',
							'260' => 'Zambia (+260)',
							'263' => 'Zimbabwe (+263)',
						];

						$temp=  substr(strstr($phone, '+'),1);
					if($temp != false){$phone=$temp;}
                                                $countrycode='';
						// sort the array by key, descending
						krsort($countrys, SORT_NUMERIC);

						// iterate over all countries
						foreach($countrys as $we => $ccode){
							// if number begins with current number
							if(strpos($phone, '' . $we) === 0){
								// store country code and break the loop
								$countrycode = $we;
								break;
							}
						}  
						
					

						if(!empty($countrycode)){
							$size=strlen($countrycode);
							$phone=substr($phone,$size);
							

							
						}



		
			}




$leads = Leads::model()->findByAttributes(array('tel'=>$phone));
if(!empty($leads)){  

if($tok->userid == $leads->user_sales ){ 
$status = Statues::model()->findByAttributes(array('id'=>$leads->status));
$substatus = Substatus::model()->findByAttributes(array('id'=>$leads->substatus));

    header('Content-Type: application/json');
    $arr = array('title' => $leads->title , 'lastreport' => $leads->sales_report , 'status' => $status->title , 'substatus' => $substatus->title);
   // echo json_encode($arr);
    echo json_encode($arr, JSON_UNESCAPED_UNICODE);

    
    
    
}   
    
}

}else{
    
    
    
    
    
    $model = new FbLeadForm(); 
    $model->tel= $phone;
    $model->callcenter= 1;
    if(!$model->save()){
    var_dump($model->getErrors());
    }
    
    
    
     header('Content-Type: application/json');
    $true="true";
    $arr = array('status' => false);
    echo json_encode($arr);
    //echo CJSON::encode($tok);
    die();
    
    
    
}
    
    

	
	    
	    
	    


}






 public function actionUnitscheck()
		{

        
        $code= $_GET['code'];
        
        //$unit= Units::model()->findByAttributes(array('code'=>$code));
        
        
        
        
$criteria = new CDbCriteria();        
$criteria->condition = "booking IS NOT NULL ";      
$criteria->addSearchCondition('code', $code, false);
$unit = Units::model()->findAll($criteria);
        
        if(!empty($unit)){

                header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => true);
                echo json_encode($arr);
                die();     
                
        
                }else{
                
                
                header('Content-Type: application/json');
                $true="true";
                $arr = array('status' => false);
                echo json_encode($arr);
                die();  
                
                }
        
        

        
        }



















	
	
public function actionNotclearauto(){

ini_set('max_execution_time', 300);
//ini_set('memory_limit', '-1'); // run script in background even if user closes browser
//set_time_limit(1800);
        
$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
$start = date("Y-m-01");
$today = date("Y-m-d");                     // 03.10.01

$end = date('Y-m-d', strtotime("-2 days"));
$starttime = date("00:00:00");                      // 17:16:18	
$endtime = date('H:i:s', strtotime("-3 hours"));
$time = date('H:i:s');



$notclear = new CDbCriteria();
$notclear->condition = "qualified IS  NULL AND nonqualified IS  NULL";
$notclear->addBetweenCondition("communicate_date",$start,$end,'AND');
$notclear->addCondition('coldcall IS NULL');
$notclear->addCondition('user_sales IS NOT NULL');

$allleads = Leads::model()->findAll($notclear);

//var_dump(count($allleads));exit;
    
        
    		if(!empty($allleads)){

    		    foreach($allleads as $lead){ 
    		        
    		        $pull=new Pull();
    		        $pull->date=$today;
    		        $pull->time=$time;
    		        $pull->user_sales=$lead->user_sales;
    		        $pull->lead_id=$lead->id;
    		        $pull->dtime=$lead->dtime;
    		        $pull->transfer=$lead->transfer;
    		        if(!$pull->save())var_dump($pull->getErrors());
    		        
    		        
    		        //var_dump(($lead));exit;
    		       $lead->unseenauto=$lead->user_sales;
    		       $lead->dtime=$time;

    		      $lead->communicate_date=$today;
    		       $lead->user_sales=NULL;
                $lead->communication=NULL;
                $lead->receipt=NULL;

                    
                    if(!$lead->save()){
                            		 

					var_dump($lead->getErrors());
					exit;
					}
                    
                    
                    if($lead->save()){
                    
                     $criteriaact = new CDbCriteria; 
                        $criteriaact->addCondition('leads_id=' . $lead->id);
                        $allactivities=Activities::model()->findAll($criteriaact);
                        if(!empty($allactivities)){
                                foreach($allactivities as $activity){
                                $activity->close=1;
                                //$activity->hidden=1;
                                    if(empty($activity->report)){
                                    $activity->report='Automatically - Not Clear'.$today;
                                    }
                                  $activity->save();
                                }
                        }

                    
                    }
                    
                    
                    
                		    }
    		    
    		         
    		    }
    	
    		
    		
		

	}
	
	






public function actionLateauto(){
 
    		
		//var_dump("xxx");
		
		
ini_set('max_execution_time', 300);
//ini_set('memory_limit', '-1'); // run script in background even if user closes browser
//set_time_limit(1800);
        
$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
$endtime = date('H:i:s', strtotime("-3 hours"));
$time = date('H:i:s');



$late = new CDbCriteria();
$start = '2019-01-01';
$end = date('Y-m-d', strtotime("-1 days"));
//$end = '2021-11-01';

$late->limit= 100;

$late->condition = "close IS NULL";
$late->addBetweenCondition("follow_date",$start,$end,'AND');
//$late->addCondition('coldcall IS NULL AND broker_id IS NULL AND indirect IS NULL');
$allactivities = Activities::model()->findAll($late); 

    //var_dump(count($allactivities));exit;

        
    		if(!empty($allactivities)){

    		    foreach($allactivities as $activities){ 
    		        $lead = Leads::model()->findByAttributes(array('id'=>$activities->leads_id));


if(!empty($lead)){

    		     // var_dump(($lead->id));exit;
    		      $lead->unseenauto=$lead->user_sales;
    		      $lead->communication=NULL;
    		      $lead->user_sales=NULL;
    		      $lead->dtime=$time;
    		      $lead->user_integration=NULL;
                  $lead->receipt=1;

                    
                    if(!$lead->save()){
                            		 

					var_dump($lead->getErrors());
					exit;
					}
					
					

                    
                    
                    if($lead->save()){
                    
                     $criteriaact = new CDbCriteria; 
                        $criteriaact->addCondition('leads_id=' . $lead->id);
                        $allactivities=Activities::model()->findAll($criteriaact);
                        if(!empty($allactivities)){
                                foreach($allactivities as $activity){
                                $activity->close=1;
                                //$activity->hidden=1;
                                    if(empty($activity->report)){
                                    $activity->report='Automatically - late auto'.$today;
                                    }
                                  $activity->save();
                                }
                        }

                    
                    }
                    
}                    
                    
                		    }
    		    
    		         
    		    }
    	
    		
		
		

	}





public function actionNotcomautotrans(){

$main=Mainsettings::model()->findByPk(1);	    
var_dump('fix');exit;
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1'); // run script in background even if user closes browser
        set_time_limit(1800);
        
$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
$start = '2019-01-01';
//$end = date('Y-m-d');
$end = date('Y-m-d', strtotime("-1 days"));

$today = date('Y-m-d');
$starttime = date("00:00:00");                      // 17:16:18	
$endtime = date('H:i:s', strtotime("-3 hours"));
$time = date('H:i:s');



$criteria = new CDbCriteria();
$criteria->limit= 1000;
$criteria->condition = "close IS NULL ";      
$criteria->addBetweenCondition("transferdate",$start,$end,'AND');
 //$criteria->addBetweenCondition("dtime",$starttime,$endtime,'AND');

$criteria->addCondition('user_sales IS NOT NULL');
$criteria->addCondition('communication IS NULL');
//$criteria->addCondition('unseenauto IS NULL');

$criteria->addCondition('coldcall IS NULL AND indirect IS NULL');
$allleads = Leads::model()->findAll($criteria); 
    		        // var_dump(count($allleads));exit;

    
    		if(!empty($allleads)){
    		    foreach($allleads as $lead){ 

    		        $pull=new Pull();
    		        $pull->date=$today;
    		        $pull->time=$time;
    		     $pull->user_sales=$lead->user_sales;
    		        //$pull->user_sales=1;
    		        $pull->lead_id=$lead->id;
    		        $pull->dtime=$lead->dtime;
    		        $pull->transfer=$lead->transfer;
    		        if(!$pull->save())var_dump($pull->getErrors());
    		        
    		       $lead->unseenauto=$lead->user_sales;
    		       
    		       $lead->dtime=$time;
    		       $lead->receipt=1;
    		       $lead->user_sales=NULL;
    		       $lead->user_integration=NULL;
                    $lead->save();
                    
                       if($lead->save()){
                    
                     $criteriaact = new CDbCriteria; 
                        $criteriaact->addCondition('leads_id=' . $lead->id);
                        $allactivities=Activities::model()->findAll($criteriaact);
                        if(!empty($allactivities)){
                                foreach($allactivities as $activity){
                                $activity->close=1;
                                //$activity->hidden=1;
                                    if(empty($activity->report)){
                                    $activity->report='Automatically - Not communication after transfer 3 H '.$today;
                                    }
                                  $activity->save();
                                }
                        }

                    
                    }
                    
                    
                    
                    	if(!$lead->save()){
		    var_dump($lead->getErrors());exit;
	}
    
                    
                    
                    
                    
                		    }
    		    
    		         
    		    }
    	
    		
    		
		

	}



public function actionNotcomauto(){

$main=Mainsettings::model()->findByPk(1);	    
//var_dump('fix');exit;
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1'); // run script in background even if user closes browser
        set_time_limit(1800);
        
$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
$start = '2019-01-01';
//$end = date('Y-m-d');
$end = date('Y-m-d');

$today = date('Y-m-d');
$starttime = date("00:00:00");                      // 17:16:18	
$endtime = date('H:i:s', strtotime("-3 hours"));
$time = date('H:i:s');



$criteria = new CDbCriteria();
$criteria->limit= 100;
$criteria->condition = "close IS NULL ";      
$criteria->addBetweenCondition("date",$start,$end,'AND');
 //$criteria->addBetweenCondition("dtime",$starttime,$endtime,'AND');

 $criteria->addCondition('user_sales IS NOT NULL');
$criteria->addCondition('communication IS NULL');
$criteria->addCondition('coldcall IS NULL AND indirect IS NULL');
$allleads = Leads::model()->findAll($criteria); 
        
    
        //var_dump(count($allleads));exit;
    		if(!empty($allleads)){
    		    foreach($allleads as $lead){ 
    		        
    		        $pull=new Pull();
    		        $pull->date=$today;
    		        $pull->time=$time;
    		        $pull->user_sales=$lead->user_sales;
    		        $pull->lead_id=$lead->id;
    		        $pull->dtime=$lead->dtime;
    		        $pull->transfer=$lead->transfer;
    		        if(!$pull->save())var_dump($pull->getErrors());
    		        
    		       $lead->unseenauto=$lead->user_sales;
    		       
    		       $lead->dtime=$time;
    		       $lead->receipt=1;
    		       $lead->user_sales=NULL;
                    $lead->save();
                    
                       if($lead->save()){
                    
                     $criteriaact = new CDbCriteria; 
                        $criteriaact->addCondition('leads_id=' . $lead->id);
                        $allactivities=Activities::model()->findAll($criteriaact);
                        if(!empty($allactivities)){
                                foreach($allactivities as $activity){
                                $activity->close=1;
                                //$activity->hidden=1;
                                    if(empty($activity->report)){
                                    $activity->report='Automatically - Not communication 3 H '.$today;
                                    }
                                  $activity->save();
                                }
                        }

                    
                    }
                    
                    
                    
                    
                		    }
    		    
    		         
    		    }
    	
    		
    		
		

	}
	
	
	
	
	
	
	
	
	
	
public function actionNotcomautotime(){

		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1'); // run script in background even if user closes browser
        set_time_limit(1800);
        
$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
$start = date('Y-m-d');
$end = date('Y-m-d');
//$end = date('Y-m-d', strtotime("-2 days"));

$today = date('Y-m-d');
$starttime = date("00:00:00");                      // 17:16:18	
$endtime = date('H:i:s', strtotime("-2 hours"));
$time = date('H:i:s');


        //var_dump($endtime);exit;

$criteria = new CDbCriteria();
$criteria->limit= 100;
$criteria->condition = "close IS NULL ";      
$criteria->addBetweenCondition("date",$start,$end,'AND');
$criteria->addBetweenCondition("dtime",$starttime,$endtime,'AND');

 $criteria->addCondition('user_sales IS NOT NULL');
$criteria->addCondition('communication IS NULL');
$criteria->addCondition('coldcall IS NULL AND indirect IS NULL');
$allleads = Leads::model()->findAll($criteria); 
        
    
       // var_dump(count($allleads));exit;
    		if(!empty($allleads)){
    		    foreach($allleads as $lead){ 
    		        
    		        $pull=new Pull();
    		        $pull->date=$today;
    		        $pull->time=$time;
    		        $pull->user_sales=$lead->user_sales;
    		        $pull->lead_id=$lead->id;
    		        $pull->dtime=$lead->dtime;
    		        $pull->transfer=$lead->transfer;
    		        if(!$pull->save())var_dump($pull->getErrors());
    		        
    		       $lead->unseenauto=$lead->user_sales;
    		       
    		       $lead->dtime=$time;
    		       $lead->receipt=1;
    		       $lead->user_sales=NULL;
                    $lead->save();
                    
                       if($lead->save()){
                    
                     $criteriaact = new CDbCriteria; 
                        $criteriaact->addCondition('leads_id=' . $lead->id);
                        $allactivities=Activities::model()->findAll($criteriaact);
                        if(!empty($allactivities)){
                                foreach($allactivities as $activity){
                                $activity->close=1;
                                //$activity->hidden=1;
                                    if(empty($activity->report)){
                                    $activity->report='Automatically - Not communication 3 H '.$today;
                                    }
                                  $activity->save();
                                }
                        }

                    
                    }
                    
                    
                    
                    
                		    }
    		    
    		         
    		    }
    	
    		
    		
		

	}






public function actionAutodistoleader(){

		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1'); // run script in background even if user closes browser
        set_time_limit(1800);
        
$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
$start = '2019-01-01';
//$end = date('Y-m-d');
$end = date('Y-m-d', strtotime("-2 days"));

$today = date('Y-m-d');
$starttime = date("00:00:00");                      // 17:16:18	
$endtime = date('H:i:s', strtotime("-3 hours"));
$time = date('H:i:s');


    
    $criteria = new CDbCriteria();
    $criteria->limit= 1;
    $criteria->condition = "close IS NULL ";      
    $criteria->addCondition('user_sales IS  NULL');
    $criteria->addCondition('user_integration IS  NULL');

    $criteria->addCondition('communication IS NULL');
    $criteria->addCondition('coldcall IS NULL AND indirect IS NULL');
    $criteria->addBetweenCondition("date",$today,$today);






    $allleads = Leads::model()->findAll($criteria); 
    
    
    //var_dump($allleads);exit;
    if(!empty($allleads)){
    foreach($allleads as $lead){ 
    
    
    
    $criteria = new CDbCriteria();
    $criteria->order = 'total ASC';
    $criteria->limit= 1;
    $allrotaion = RotationUsers::model()->findAll($criteria); 
    
   // var_dump($allrotaion);exit;        
    
    if(!empty($allrotaion)){
    foreach($allrotaion as $rotaion){ 
        
    
    $rotaion->total+=1;
    $rotaion->save();    
        
        
    $lead->user_integration=$rotaion->sales_id;
    //$lead->fresh_sales=$rotaion->sales_id;

    $lead->dtime=$time;
    $lead->save();
    
    if($lead->save()){
    //var_dump($lead->id);exit;
    }
    }}
    
    
    
    
    }
    
    
    }
    
    
    
    
    
    }




public function actionNotseenauto(){

		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1'); // run script in background even if user closes browser
        set_time_limit(1800);
        
$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
$start = '2019-01-01';
$end = date('Y-m-d', strtotime("-1 days"));

$today = date('Y-m-d');
$starttime = date("00:00:00");                      // 17:16:18	
$endtime = date('H:i:s', strtotime("-3 hours"));
$time = date('H:i:s');



$criteria = new CDbCriteria(); 
$criteria->limit= 100;
$criteria->condition = "close IS NULL ";      
$criteria->addBetweenCondition("date",$start,$end,'AND');
//$criteria->addBetweenCondition("dtime",$starttime,$endtime,'AND');

 $criteria->addCondition('user_sales IS NOT NULL');
$criteria->addCondition('receipt IS NULL');
$criteria->addCondition('coldcall IS NULL AND indirect IS NULL');
$allleads = Leads::model()->findAll($criteria); 
        
     //var_dump(count($allleads));exit;
        //var_dump(($allleads));exit;
    		if(!empty($allleads)){
    		    foreach($allleads as $lead){ 
    		        
    		        $pull=new Pull();
    		        $pull->date=$today;
    		        $pull->time=$time;
    		        $pull->user_sales=$lead->user_sales;
    		        $pull->lead_id=$lead->id;
    		        $pull->dtime=$lead->dtime;
    		        $pull->transfer=$lead->transfer;
    		        if(!$pull->save())var_dump($pull->getErrors());
    		        
    		       $lead->unseenauto=$lead->user_sales;
    		       
    		       $lead->dtime=$time;
    		       $lead->receipt=NULL;
    		       $lead->user_sales=NULL;
                    $lead->save();
                    
                       if($lead->save()){
                    
                     $criteriaact = new CDbCriteria; 
                        $criteriaact->addCondition('leads_id=' . $lead->id);
                        $allactivities=Activities::model()->findAll($criteriaact);
                        if(!empty($allactivities)){
                                foreach($allactivities as $activity){
                                $activity->close=1;
                                //$activity->hidden=1;
                                    if(empty($activity->report)){
                                    $activity->report='Automatically - Not seen '.$today;
                                    }
                                  $activity->save();
                                }
                        }

                    
                    }
                    
                    
                    
                    
                		    }
    		    
    		         
    		    }
    	
    		
    		
		

	}







		public function actionRedoautoassign(){
		    
		if(Yii::app()->user->isMember()){    

		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1'); // run script in background even if user closes browser
        set_time_limit(1800);
 
 
        $criteria = new CDbCriteria();        
        $criteria->condition = "close IS NULL ";   
        $criteria->addCondition('unseenauto IS NOT NULL');
        $criteria->addCondition('user_sales IS  NULL');
        $criteria->addCondition('communication IS NULL');
        $criteria->addCondition('coldcall IS NULL AND indirect IS NULL');
        $allleads = Leads::model()->findAll($criteria); 
        
    
		
        //var_dump(($allleads));exit;
        
    		if(!empty($allleads)){
    		    foreach($allleads as $lead){  
    		       $time = date('H:i:s');
    		       $lead->dtime=$time; 
    		       $lead->user_sales=$lead->unseenauto;
                   $lead->save();
                }
    		    
    		         
    		 }
    	
    		
    	$this->redirect(array('sales/salesmanger')	);	
    	
    	
		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
		

	}







	
public function actionQuicktel()
		{
		    
		    
		    
if(Yii::app()->user->isMember()){


$userid=Yii::app()->user->id;
$user=User::model()->findByPk($userid);


$phone= $_GET['tel'];


if(!empty($phone) ){

if($phone[0]=='0')
    $phone = substr($phone , 1);
    
  
$countrys = [
   // '1' => 'USA (+1)',
							'44' => 'UK (+44)',
							'213' => 'Algeria (+213)',
							'376' => 'Andorra (+376)',
							'244' => 'Angola (+244)',
							'1264' => 'Anguilla (+1264)',
							'1268' => 'Antigua & Barbuda (+1268)',
							'54' => 'Argentina (+54)',
							'374' => 'Armenia (+374)',
							'297' => 'Aruba (+297)',
							'61' => 'Australia (+61)',
							'43' => 'Austria (+43)',
							'994' => 'Azerbaijan (+994)',
							'1242' => 'Bahamas (+1242)',
							'973' => 'Bahrain (+973)',
							'880' => 'Bangladesh (+880)',
							'1246' => 'Barbados (+1246)',
							'375' => 'Belarus (+375)',
							'32' => 'Belgium (+32)',
							'501' => 'Belize (+501)',
							'229' => 'Benin (+229)',
							'1441' => 'Bermuda (+1441)',
							'975' => 'Bhutan (+975)',
							'591' => 'Bolivia (+591)',
							'387' => 'Bosnia Herzegovina (+387)',
							'267' => 'Botswana (+267)',
							'55' => 'Brazil (+55)',
							'673' => 'Brunei (+673)',
							'359' => 'Bulgaria (+359)',
							'226' => 'Burkina Faso (+226)',
							'257' => 'Burundi (+257)',
							'855' => 'Cambodia (+855)',
							'237' => 'Cameroon (+237)',
							'238' => 'Cape Verde Islands (+238)',
							'1345' => 'Cayman Islands (+1345)',
							'236' => 'Central African Republic (+236)',
							'56' => 'Chile (+56)',
							'86' => 'China (+86)',
							'57' => 'Colombia (+57)',
							'269' => 'Comoros (+269)',
							'242' => 'Congo (+242)',
							'682' => 'Cook Islands (+682)',
							'506' => 'Costa Rica (+506)',
							'385' => 'Croatia (+385)',
							'53' => 'Cuba (+53)',
							'90392' => 'Cyprus North (+90392)',
							'357' => 'Cyprus South (+357)',
							'42' => 'Czech Republic (+42)',
							'45' => 'Denmark (+45)',
							'253' => 'Djibouti (+253)',
							'1809' => 'Dominica (+1809)',
							'1809' => 'Dominican Republic (+1809)',
							'593' => 'Ecuador (+593)',
							'20' => 'Egypt (+20)',
							'200' => 'Egypt (+20)',
							'503' => 'El Salvador (+503)',
							'240' => 'Equatorial Guinea (+240)',
							'291' => 'Eritrea (+291)',
							'372' => 'Estonia (+372)',
							'251' => 'Ethiopia (+251)',
							'500' => 'Falkland Islands (+500)',
							'298' => 'Faroe Islands (+298)',
							'679' => 'Fiji (+679)',
							'358' => 'Finland (+358)',
							'33' => 'France (+33)',
							'594' => 'French Guiana (+594)',
							'689' => 'French Polynesia (+689)',
							'241' => 'Gabon (+241)',
							'220' => 'Gambia (+220)',
							'7880' => 'Georgia (+7880)',
							'49' => 'Germany (+49)',
							'233' => 'Ghana (+233)',
							'350' => 'Gibraltar (+350)',
							'30' => 'Greece (+30)',
							'299' => 'Greenland (+299)',
							'1473' => 'Grenada (+1473)',
							'590' => 'Guadeloupe (+590)',
							'671' => 'Guam (+671)',
							'502' => 'Guatemala (+502)',
							'224' => 'Guinea (+224)',
							'245' => 'Guinea - Bissau (+245)',
							'592' => 'Guyana (+592)',
							'509' => 'Haiti (+509)',
							'504' => 'Honduras (+504)',
							'852' => 'Hong Kong (+852)',
							'36' => 'Hungary (+36)',
							'354' => 'Iceland (+354)',
							'91' => 'India (+91)',
							'62' => 'Indonesia (+62)',
							'98' => 'Iran (+98)',
							'964' => 'Iraq (+964)',
							'353' => 'Ireland (+353)',
							'39' => 'Italy (+39)',
							'1876' => 'Jamaica (+1876)',
							'81' => 'Japan (+81)',
							'962' => 'Jordan (+962)',
							'7' => 'Kazakhstan (+7)',
							'254' => 'Kenya (+254)',
							'686' => 'Kiribati (+686)',
							'850' => 'Korea North (+850)',
							'82' => 'Korea South (+82)',
							'965' => 'Kuwait (+965)',
							'996' => 'Kyrgyzstan (+996)',
							'856' => 'Laos (+856)',
							'371' => 'Latvia (+371)',
							'961' => 'Lebanon (+961)',
							'266' => 'Lesotho (+266)',
							'231' => 'Liberia (+231)',
							'218' => 'Libya (+218)',
							'417' => 'Liechtenstein (+417)',
							'370' => 'Lithuania (+370)',
							'352' => 'Luxembourg (+352)',
							'853' => 'Macao (+853)',
							'389' => 'Macedonia (+389)',
							'261' => 'Madagascar (+261)',
							'265' => 'Malawi (+265)',
							'60' => 'Malaysia (+60)',
							'960' => 'Maldives (+960)',
							'223' => 'Mali (+223)',
							'356' => 'Malta (+356)',
							'692' => 'Marshall Islands (+692)',
							'596' => 'Martinique (+596)',
							'222' => 'Mauritania (+222)',
							'269' => 'Mayotte (+269)',
							'52' => 'Mexico (+52)',
							'691' => 'Micronesia (+691)',
							'373' => 'Moldova (+373)',
							'377' => 'Monaco (+377)',
							'976' => 'Mongolia (+976)',
							'1664' => 'Montserrat (+1664)',
							'212' => 'Morocco (+212)',
							'258' => 'Mozambique (+258)',
							'95' => 'Myanmar (+95)',
							'264' => 'Namibia (+264)',
							'674' => 'Nauru (+674)',
							'977' => 'Nepal (+977)',
							'31' => 'Netherlands (+31)',
							'687' => 'New Caledonia (+687)',
							'64' => 'New Zealand (+64)',
							'505' => 'Nicaragua (+505)',
							'227' => 'Niger (+227)',
							'234' => 'Nigeria (+234)',
							'683' => 'Niue (+683)',
							'672' => 'Norfolk Islands (+672)',
							'670' => 'Northern Marianas (+670)',
							'47' => 'Norway (+47)',
							'968' => 'Oman (+968)',
							'680' => 'Palau (+680)',
							'507' => 'Panama (+507)',
							'675' => 'Papua New Guinea (+675)',
							'595' => 'Paraguay (+595)',
							'51' => 'Peru (+51)',
							'63' => 'Philippines (+63)',
							'48' => 'Poland (+48)',
							'351' => 'Portugal (+351)',
							'1787' => 'Puerto Rico (+1787)',
							'974' => 'Qatar (+974)',
							'262' => 'Reunion (+262)',
							'40' => 'Romania (+40)',
							'7' => 'Russia (+7)',
							'250' => 'Rwanda (+250)',
							'378' => 'San Marino (+378)',
							'239' => 'Sao Tome & Principe (+239)',
							'966' => 'Saudi Arabia (+966)',
							'221' => 'Senegal (+221)',
							'381' => 'Serbia (+381)',
							'248' => 'Seychelles (+248)',
							'232' => 'Sierra Leone (+232)',
							'65' => 'Singapore (+65)',
							'421' => 'Slovak Republic (+421)',
							'386' => 'Slovenia (+386)',
							'677' => 'Solomon Islands (+677)',
							'252' => 'Somalia (+252)',
							'27' => 'South Africa (+27)',
							'34' => 'Spain (+34)',
							'94' => 'Sri Lanka (+94)',
							'290' => 'St. Helena (+290)',
							'1869' => 'St. Kitts (+1869)',
							'1758' => 'St. Lucia (+1758)',
							'249' => 'Sudan (+249)',
							'597' => 'Suriname (+597)',
							'268' => 'Swaziland (+268)',
							'46' => 'Sweden (+46)',
							'41' => 'Switzerland (+41)',
							'963' => 'Syria (+963)',
							'886' => 'Taiwan (+886)',
							'7' => 'Tajikstan (+7)',
							'66' => 'Thailand (+66)',
							'228' => 'Togo (+228)',
							'676' => 'Tonga (+676)',
							'1868' => 'Trinidad & Tobago (+1868)',
							'216' => 'Tunisia (+216)',
							'90' => 'Turkey (+90)',
							'7' => 'Turkmenistan (+7)',
							'993' => 'Turkmenistan (+993)',
							'1649' => 'Turks & Caicos Islands (+1649)',
							'688' => 'Tuvalu (+688)',
							'256' => 'Uganda (+256)',
							'380' => 'Ukraine (+380)',
							'971' => 'United Arab Emirates (+971)',
							'598' => 'Uruguay (+598)',
							'7' => 'Uzbekistan (+7)',
							'678' => 'Vanuatu (+678)',
							'379' => 'Vatican City (+379)',
							'58' => 'Venezuela (+58)',
							'84' => 'Vietnam (+84)',
							'84' => 'Virgin Islands - British (+1284)',
							'84' => 'Virgin Islands - US (+1340)',
							'681' => 'Wallis & Futuna (+681)',
							'969' => 'Yemen (North)(+969)',
							'967' => 'Yemen (South)(+967)',
							'260' => 'Zambia (+260)',
							'263' => 'Zimbabwe (+263)',
						];

						$temp=  substr(strstr($phone, '+'),1);
					if($temp != false){$phone=$temp;}
                                                $countrycode='';
						// sort the array by key, descending
						krsort($countrys, SORT_NUMERIC);

						// iterate over all countries
						foreach($countrys as $we => $ccode){
							// if number begins with current number
							if(strpos($phone, '' . $we) === 0){
								// store country code and break the loop
								$countrycode = $we;
								break;
							}
						}  
						
					

						if(!empty($countrycode)){
							$size=strlen($countrycode);
							$phone=substr($phone,$size);
							
						//		var_dump($countrycode);
//exit;
							
						}



			//	$criteria->addSearchCondition('tel', $phone ,TRUE, "or");
				//$criteria->addSearchCondition('second_tel', $phone ,TRUE, "or");
			}


  




$criteria = new CDbCriteria();
$criteria->select = 'tel, tel3, tel4, id'; // Specify the columns to select
$criteria->addSearchCondition('tel', $phone ,TRUE, "or");
$criteria->addSearchCondition('second_tel', $phone ,TRUE, "or");
$criteria->addSearchCondition('tel3', $phone ,TRUE, "or");
$criteria->addSearchCondition('tel4', $phone ,TRUE, "or");

$allleads = Leads::model()->findAll($criteria); 

						if(($user->salesmanger == 1) ){ 

foreach ($allleads as $leads) {
    $foo[] = array (  
        'id' => $leads->id,  
        'title' => $leads->title,  
        'tel' => $leads->tel, 
       'second_tel' => $leads->second_tel,  
       'tel3' => $leads->tel3,  
       'tel4' => $leads->tel4,  


        
        
        
    );
}


$json_data = new CJSON;



echo $json_data->encode($foo);
die();     
}

//var_dump($allleads);exit;



}
}







	
	
public function actionWebhooktel()
		{

 //var_dump('1');exit;
$phone= $_GET['tel'];
$ext= $_GET['ext'];


if(!empty($phone) ){

if($phone[0]=='0')
    $phone = substr($phone , 1);
    
  
$countrys = [
   // '1' => 'USA (+1)',
							'44' => 'UK (+44)',
							'213' => 'Algeria (+213)',
							'376' => 'Andorra (+376)',
							'244' => 'Angola (+244)',
							'1264' => 'Anguilla (+1264)',
							'1268' => 'Antigua & Barbuda (+1268)',
							'54' => 'Argentina (+54)',
							'374' => 'Armenia (+374)',
							'297' => 'Aruba (+297)',
							'61' => 'Australia (+61)',
							'43' => 'Austria (+43)',
							'994' => 'Azerbaijan (+994)',
							'1242' => 'Bahamas (+1242)',
							'973' => 'Bahrain (+973)',
							'880' => 'Bangladesh (+880)',
							'1246' => 'Barbados (+1246)',
							'375' => 'Belarus (+375)',
							'32' => 'Belgium (+32)',
							'501' => 'Belize (+501)',
							'229' => 'Benin (+229)',
							'1441' => 'Bermuda (+1441)',
							'975' => 'Bhutan (+975)',
							'591' => 'Bolivia (+591)',
							'387' => 'Bosnia Herzegovina (+387)',
							'267' => 'Botswana (+267)',
							'55' => 'Brazil (+55)',
							'673' => 'Brunei (+673)',
							'359' => 'Bulgaria (+359)',
							'226' => 'Burkina Faso (+226)',
							'257' => 'Burundi (+257)',
							'855' => 'Cambodia (+855)',
							'237' => 'Cameroon (+237)',
							'238' => 'Cape Verde Islands (+238)',
							'1345' => 'Cayman Islands (+1345)',
							'236' => 'Central African Republic (+236)',
							'56' => 'Chile (+56)',
							'86' => 'China (+86)',
							'57' => 'Colombia (+57)',
							'269' => 'Comoros (+269)',
							'242' => 'Congo (+242)',
							'682' => 'Cook Islands (+682)',
							'506' => 'Costa Rica (+506)',
							'385' => 'Croatia (+385)',
							'53' => 'Cuba (+53)',
							'90392' => 'Cyprus North (+90392)',
							'357' => 'Cyprus South (+357)',
							'42' => 'Czech Republic (+42)',
							'45' => 'Denmark (+45)',
							'253' => 'Djibouti (+253)',
							'1809' => 'Dominica (+1809)',
							'1809' => 'Dominican Republic (+1809)',
							'593' => 'Ecuador (+593)',
							'20' => 'Egypt (+20)',
							'200' => 'Egypt (+20)',
							'503' => 'El Salvador (+503)',
							'240' => 'Equatorial Guinea (+240)',
							'291' => 'Eritrea (+291)',
							'372' => 'Estonia (+372)',
							'251' => 'Ethiopia (+251)',
							'500' => 'Falkland Islands (+500)',
							'298' => 'Faroe Islands (+298)',
							'679' => 'Fiji (+679)',
							'358' => 'Finland (+358)',
							'33' => 'France (+33)',
							'594' => 'French Guiana (+594)',
							'689' => 'French Polynesia (+689)',
							'241' => 'Gabon (+241)',
							'220' => 'Gambia (+220)',
							'7880' => 'Georgia (+7880)',
							'49' => 'Germany (+49)',
							'233' => 'Ghana (+233)',
							'350' => 'Gibraltar (+350)',
							'30' => 'Greece (+30)',
							'299' => 'Greenland (+299)',
							'1473' => 'Grenada (+1473)',
							'590' => 'Guadeloupe (+590)',
							'671' => 'Guam (+671)',
							'502' => 'Guatemala (+502)',
							'224' => 'Guinea (+224)',
							'245' => 'Guinea - Bissau (+245)',
							'592' => 'Guyana (+592)',
							'509' => 'Haiti (+509)',
							'504' => 'Honduras (+504)',
							'852' => 'Hong Kong (+852)',
							'36' => 'Hungary (+36)',
							'354' => 'Iceland (+354)',
							'91' => 'India (+91)',
							'62' => 'Indonesia (+62)',
							'98' => 'Iran (+98)',
							'964' => 'Iraq (+964)',
							'353' => 'Ireland (+353)',
							'39' => 'Italy (+39)',
							'1876' => 'Jamaica (+1876)',
							'81' => 'Japan (+81)',
							'962' => 'Jordan (+962)',
							'7' => 'Kazakhstan (+7)',
							'254' => 'Kenya (+254)',
							'686' => 'Kiribati (+686)',
							'850' => 'Korea North (+850)',
							'82' => 'Korea South (+82)',
							'965' => 'Kuwait (+965)',
							'996' => 'Kyrgyzstan (+996)',
							'856' => 'Laos (+856)',
							'371' => 'Latvia (+371)',
							'961' => 'Lebanon (+961)',
							'266' => 'Lesotho (+266)',
							'231' => 'Liberia (+231)',
							'218' => 'Libya (+218)',
							'417' => 'Liechtenstein (+417)',
							'370' => 'Lithuania (+370)',
							'352' => 'Luxembourg (+352)',
							'853' => 'Macao (+853)',
							'389' => 'Macedonia (+389)',
							'261' => 'Madagascar (+261)',
							'265' => 'Malawi (+265)',
							'60' => 'Malaysia (+60)',
							'960' => 'Maldives (+960)',
							'223' => 'Mali (+223)',
							'356' => 'Malta (+356)',
							'692' => 'Marshall Islands (+692)',
							'596' => 'Martinique (+596)',
							'222' => 'Mauritania (+222)',
							'269' => 'Mayotte (+269)',
							'52' => 'Mexico (+52)',
							'691' => 'Micronesia (+691)',
							'373' => 'Moldova (+373)',
							'377' => 'Monaco (+377)',
							'976' => 'Mongolia (+976)',
							'1664' => 'Montserrat (+1664)',
							'212' => 'Morocco (+212)',
							'258' => 'Mozambique (+258)',
							'95' => 'Myanmar (+95)',
							'264' => 'Namibia (+264)',
							'674' => 'Nauru (+674)',
							'977' => 'Nepal (+977)',
							'31' => 'Netherlands (+31)',
							'687' => 'New Caledonia (+687)',
							'64' => 'New Zealand (+64)',
							'505' => 'Nicaragua (+505)',
							'227' => 'Niger (+227)',
							'234' => 'Nigeria (+234)',
							'683' => 'Niue (+683)',
							'672' => 'Norfolk Islands (+672)',
							'670' => 'Northern Marianas (+670)',
							'47' => 'Norway (+47)',
							'968' => 'Oman (+968)',
							'680' => 'Palau (+680)',
							'507' => 'Panama (+507)',
							'675' => 'Papua New Guinea (+675)',
							'595' => 'Paraguay (+595)',
							'51' => 'Peru (+51)',
							'63' => 'Philippines (+63)',
							'48' => 'Poland (+48)',
							'351' => 'Portugal (+351)',
							'1787' => 'Puerto Rico (+1787)',
							'974' => 'Qatar (+974)',
							'262' => 'Reunion (+262)',
							'40' => 'Romania (+40)',
							'7' => 'Russia (+7)',
							'250' => 'Rwanda (+250)',
							'378' => 'San Marino (+378)',
							'239' => 'Sao Tome & Principe (+239)',
							'966' => 'Saudi Arabia (+966)',
							'221' => 'Senegal (+221)',
							'381' => 'Serbia (+381)',
							'248' => 'Seychelles (+248)',
							'232' => 'Sierra Leone (+232)',
							'65' => 'Singapore (+65)',
							'421' => 'Slovak Republic (+421)',
							'386' => 'Slovenia (+386)',
							'677' => 'Solomon Islands (+677)',
							'252' => 'Somalia (+252)',
							'27' => 'South Africa (+27)',
							'34' => 'Spain (+34)',
							'94' => 'Sri Lanka (+94)',
							'290' => 'St. Helena (+290)',
							'1869' => 'St. Kitts (+1869)',
							'1758' => 'St. Lucia (+1758)',
							'249' => 'Sudan (+249)',
							'597' => 'Suriname (+597)',
							'268' => 'Swaziland (+268)',
							'46' => 'Sweden (+46)',
							'41' => 'Switzerland (+41)',
							'963' => 'Syria (+963)',
							'886' => 'Taiwan (+886)',
							'7' => 'Tajikstan (+7)',
							'66' => 'Thailand (+66)',
							'228' => 'Togo (+228)',
							'676' => 'Tonga (+676)',
							'1868' => 'Trinidad & Tobago (+1868)',
							'216' => 'Tunisia (+216)',
							'90' => 'Turkey (+90)',
							'7' => 'Turkmenistan (+7)',
							'993' => 'Turkmenistan (+993)',
							'1649' => 'Turks & Caicos Islands (+1649)',
							'688' => 'Tuvalu (+688)',
							'256' => 'Uganda (+256)',
							'380' => 'Ukraine (+380)',
							'971' => 'United Arab Emirates (+971)',
							'598' => 'Uruguay (+598)',
							'7' => 'Uzbekistan (+7)',
							'678' => 'Vanuatu (+678)',
							'379' => 'Vatican City (+379)',
							'58' => 'Venezuela (+58)',
							'84' => 'Vietnam (+84)',
							'84' => 'Virgin Islands - British (+1284)',
							'84' => 'Virgin Islands - US (+1340)',
							'681' => 'Wallis & Futuna (+681)',
							'969' => 'Yemen (North)(+969)',
							'967' => 'Yemen (South)(+967)',
							'260' => 'Zambia (+260)',
							'263' => 'Zimbabwe (+263)',
						];

						$temp=  substr(strstr($phone, '+'),1);
					if($temp != false){$phone=$temp;}
                                                $countrycode='';
						// sort the array by key, descending
						krsort($countrys, SORT_NUMERIC);

						// iterate over all countries
						foreach($countrys as $we => $ccode){
							// if number begins with current number
							if(strpos($phone, '' . $we) === 0){
								// store country code and break the loop
								$countrycode = $we;
								break;
							}
						}  
						
					

						if(!empty($countrycode)){
							$size=strlen($countrycode);
							$phone=substr($phone,$size);
							
						//		var_dump($countrycode);
//exit;
							
						}



			//	$criteria->addSearchCondition('tel', $phone ,TRUE, "or");
				//$criteria->addSearchCondition('second_tel', $phone ,TRUE, "or");
			}


  
$charCount = strlen($phone);

if ($charCount > 3) {
    
    
    	$lead= Leads::model()->findByAttributes(array('tel'=>$phone));
	if(!empty($lead)){
	//$user=User::model()->findByPk($lead->user_sales);
	//$int=(int)$user->token;
    //echo($lead->title);
    
    
    
    
$model = new FbLeadForm(); 
 


  
		$model->name= $lead->title;
		$model->tel= $lead->tel;
		$model->ext= $ext;

		
		
		$model->lead_id= $lead->id;
        $model->callcenter= 1;
        
		if(!$model->save()){
		    var_dump($model->getErrors());
		}
    
    
    
      $this->redirect(array('sales/profile','secert' => $lead->secert), false);

	}else{
	    //echo "not found";
	    
	    
	    
	    
	      
$model = new FbLeadForm(); 
 
	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);


  
		$model->name= 'unknow';
		$model->tel= $phone;
        $model->callcenter= 1;
        $model->date= $today;
        $model->time = $time;
		if(!$model->save()){
		    var_dump($model->getErrors());
		}
    
	    

	    $this->redirect(array('marketing/leads','code' => $countrycode,'tel' => $phone), false);
	}
    
  
} else {

			$this->redirect(array('login/dashboard'));

    
    
}




}








	

public function actionLogout()
{
    // Find the user model from the currently logged in user
    $user = User::model()->findByPk(Yii::app()->user->id);
    if ($user) {
        // Delete all of the user's sessions from the session store
        Yii::app()->session->destroySession($user->session_id);
    }

    // Log the user out of the current session
    Yii::app()->user->logout();

    // Expire the session cookie on the client side
    Yii::app()->request->cookies['PHPSESSID'] = new CHttpCookie('PHPSESSID', '');
    Yii::app()->request->cookies['PHPSESSID']->expire = time() - 3600;

    // Redirect the user to the home page
    $this->redirect(array('home/index'));
}
	
	
	
	
	public function actionError(){
		

		$this->render('error',array(
			));
		



	}
	
	
	
	
	
	
	
	
	
		public function actionRecorddelete()
	{
	if(Yii::app()->user->isMember())
	{
	$userid=Yii::app()->user->id;
	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
	$today = date("Y-m-d");                     // 03.10.01
	$time = date("H:i:s");                      // 17:16:18	
	$rnd = rand(0,99999);

	if (isset($_POST['Deletemedia'])) {
	$media= Recorder::model()->findByAttributes(array('file'=>$_POST['Deletemedia']['file']));
    if ($media->delete()) {

        
        					//Yii::app()->controller->refresh();
	$this->redirect(array('login/catchleads')	);

        
        
    }
	}
	

	
	
	}

	else{
	$model=new LoginForm;
	// if it is ajax validation request
	if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
	{
	echo CActiveForm::validate($model);
	Yii::app()->end();
	}
	// collect user input data
	if(isset($_POST['LoginForm']))
	{
	$model->attributes=$_POST['LoginForm'];
	// validate user input and redirect to the previous page if valid
	if($model->validate() && $model->login())
	$this->redirect(array('home/index')	);
	}
	// display the login form
	$this->redirect(array('home/index')	);
	}

	}








public function actionVer($id){
$se = Sessions::model()->findByAttributes(array('id'=>$id)); 
    // var_dump($_POST['confirmcode']);exit;   

if ($_POST['confirmcode'] == $se->code) {
    // var_dump($_POST['confirmcode']);exit;   
     
     $se->confirmcode=$_POST['confirmcode'];
     $se->approved=1;
	 $se->save();
	 
        $ok=1;
        $cookie2_name = "device";
        setcookie($cookie2_name, $ok, time() + (86400 * 360), "/"); // 86400 = 1 day

	 $this->redirect(array('home/index')	);
	 



    
}else{
    
$this->redirect(array('home/logout')	);

  // var_dump(1) ;exit;
    
}

    
}








	public function actionVerificationcode(){
	    if(Yii::app()->user->isMember())
	{
		
		    $this->layout = '';

			$userid=Yii::app()->user->id;
			
            //var_dump($session_id);exit;
            $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
            $today = date("Y-m-d");                     // 03.10.01
            $time = date("H:i:s");                      // 17:16:18	
            $rnd = rand(0,99999);
    
		$this->render('verificationcode',array(
		'userid'=>$userid ,	

		));
		
		
	}

	else{
	$model=new LoginForm;
	// if it is ajax validation request
	if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
	{
	echo CActiveForm::validate($model);
	Yii::app()->end();
	}
	// collect user input data
	if(isset($_POST['LoginForm']))
	{
	$model->attributes=$_POST['LoginForm'];
	// validate user input and redirect to the previous page if valid
	if($model->validate() && $model->login())
	$this->redirect(array('home/index')	);
	}
	// display the login form
	$this->redirect(array('home/index')	);
	}


      	}
      	
      	


	public function actionVerification(){
		
		    $this->layout = '';

			$userid=Yii::app()->user->id;
			
            //var_dump($session_id);exit;
            $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
            $today = date("Y-m-d");                     // 03.10.01
            $time = date("H:i:s");                      // 17:16:18	
            $rnd = rand(0,99999);
    
		$this->render('verification',array(
		'userid'=>$userid ,	

		));

      	}
	
	

	public function actionIndex(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$criteria = new CDbCriteria;

			$eng= User::model()->findAll(array( 'condition' => 'id='.$userid));
			$employeelogin = User::model()->findByPk($userid);
			$cookie_name = "token";
			$cookie_value = password_hash($employeelogin->password.$employeelogin->id, PASSWORD_DEFAULT);
			setcookie($cookie_name, $cookie_value, time() + (86400 * 30), "/"); // 86400 = 1 day
            $employeelogin->token=$cookie_value;
            
            
            $rnd = rand(0,99999);
           

           // var_dump($employeelogin);exit;
            
            Yii::app()->user->setState('session_id', session_id());
            // Get the PHPSESSID cookie
            $cookie = Yii::app()->request->cookies['PHPSESSID'];
            //  var_dump($cookie);exit;
            $session_id = $cookie->value;
            
            //var_dump($session_id);exit;
            $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
            $today = date("Y-m-d");                     // 03.10.01
            $time = date("H:i:s");                      // 17:16:18	
           
            
            
           // var_dump(1111);exit;
            $newmodel=new Sessions();
            $newmodel->user_id = $userid;
            $newmodel->date = $today;
            $newmodel->time = $time;
            $newmodel->sessions_value = $session_id;
            $newmodel->token_value = $cookie_value;
            $newmodel->code = $rnd;

            $newmodel->save();
            if(!$newmodel->save()){
            var_dump($newmodel->getErrors());exit;
            }

            
            
            $employeelogin->session_id=$session_id;
            
            

            $employeelogin->save();
			$this->redirect(array('login/dashboard'), array('eng'=>$eng));
                
			$this->render('index',array(
					'userid'=>$userid ,
					'eng'=>$eng,
                
				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}

			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->render('index',array('model'=>$model));
		}

	}


 

	
	
	
	
	
	
	
		public function actionUnseenauto(){
if(Yii::app()->user->isMember()){
    
    
$main=Mainsettings::model()->findByPk(1);	    
var_dump('fix');exit;
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1'); // run script in background even if user closes browser
        set_time_limit(1800);
        
        
$start = '2019-01-01';
$end = date('Y-m-d');
$starttime = date("00:00:00");                      // 17:16:18	
$endtime = date('H:i:s', strtotime("-2 hours"));
$time = date('H:i:s');

//var_dump($endtime);
//exit;


$criteria = new CDbCriteria();        
$criteria->condition = "close IS NULL ";      
$criteria->addBetweenCondition("date",$start,$end,'AND');
$criteria->addBetweenCondition("time",$starttime,$endtime,'AND');

$criteria->addCondition('user_sales IS NOT NULL');
$criteria->addCondition('receipt IS NULL');
$criteria->addCondition('coldcall IS NULL AND indirect IS NULL');
$allleads = Leads::model()->findAll($criteria); 
        
    
         //var_dump(count($allleads));exit;
    		if(!empty($allleads)){
    		    foreach($allleads as $lead){ 
    		       $lead->unseenauto=$lead->user_sales;
    		       $lead->time=$time;
    		       
    		       $lead->user_sales=NULL;
                    $lead->save();
                		    }
    		    
    		         
    		    }
    	
}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
    		
		

	}

	
	

	
	
	
	
	
	public function actionCheckRecorder(){	
	    
	    if(Yii::app()->user->isMember()){
	
$criterianotset = new CDbCriteria();        
$criterianotset->condition = "user_sales IS NULL ";      
$allrecordernotset = Recorder::model()->findAll($criterianotset);


if(!empty($allrecordernotset))
{ 
    foreach($allrecordernotset as $recordernotset)
    { 
        
        
    
     //var_dump($recordernotset->tel);exit;
   
        
        
        
        
       //var_dump($recordernotset->file);

 $phone = $recordernotset->tel;
						
						
						
						
						    

$criterialeads= new CDbCriteria(); 
$criterialeads->addSearchCondition('tel', $phone, false , 'OR');
$criterialeads->addSearchCondition('second_tel', $phone, false , 'OR');
$criterialeads->addSearchCondition('tel3', $phone, false , 'OR');
$criterialeads->addSearchCondition('tel4', $phone, false , 'OR');
$leadxxx= Leads::model()->findAll($criterialeads);



if(empty($leadxxx)){

	$leadtwo= new Leadstwo();
						$leadtwo->title='unknow';
						$leadtwo->tel=$phone;
					
						$leadtwo->save();
						
						
}else{
    
    $recordernotset->lead_id = $leadxxx->id;
    $recordernotset->user_sales = $leadxxx->user_sales;
    $recordernotset->save();
    
    
}
					

$lead =Leads::model()->findByAttributes(array('tel'=>$phone));
  
  
  
  $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
$today = date("Y-m-d");                     // 03.10.01
$time = date("H:i:s");                      // 17:16:18	
$rnd = rand(0,99999);
$recordernotset->user_sales = $lead->user_sales;
$recordernotset->lead_id = $lead->id;
$recordernotset->save();      
        
        
    
    }   
}


}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
	
	
	
	


	
	
		
public function actionRecorder(){

	





$directory = Yii::getPathOfAlias('webroot').'/recording/';
chdir($directory); // probably add some error handling around this
//$records = glob("*.{mp3,3gp}", GLOB_BRACE);
$records = glob("*.{mp3,3gp,mp4,mav,m4a}", GLOB_BRACE);
foreach($records as $record){ 
    
$arr = explode("_", $record, 2); $number = $arr[0]; 
$phone= $number;
if($phone[0]=='0')
    $phone = substr($phone , 1);
$countrys = [
							'44' => 'UK (+44)',
							'213' => 'Algeria (+213)',
							'376' => 'Andorra (+376)',
							'244' => 'Angola (+244)',
							'1264' => 'Anguilla (+1264)',
							'1268' => 'Antigua & Barbuda (+1268)',
							'54' => 'Argentina (+54)',
							'374' => 'Armenia (+374)',
							'297' => 'Aruba (+297)',
							'61' => 'Australia (+61)',
							'43' => 'Austria (+43)',
							'994' => 'Azerbaijan (+994)',
							'1242' => 'Bahamas (+1242)',
							'973' => 'Bahrain (+973)',
							'880' => 'Bangladesh (+880)',
							'1246' => 'Barbados (+1246)',
							'375' => 'Belarus (+375)',
							'32' => 'Belgium (+32)',
							'501' => 'Belize (+501)',
							'229' => 'Benin (+229)',
							'1441' => 'Bermuda (+1441)',
							'975' => 'Bhutan (+975)',
							'591' => 'Bolivia (+591)',
							'387' => 'Bosnia Herzegovina (+387)',
							'267' => 'Botswana (+267)',
							'55' => 'Brazil (+55)',
							'673' => 'Brunei (+673)',
							'359' => 'Bulgaria (+359)',
							'226' => 'Burkina Faso (+226)',
							'257' => 'Burundi (+257)',
							'855' => 'Cambodia (+855)',
							'237' => 'Cameroon (+237)',
							'238' => 'Cape Verde Islands (+238)',
							'1345' => 'Cayman Islands (+1345)',
							'236' => 'Central African Republic (+236)',
							'56' => 'Chile (+56)',
							'86' => 'China (+86)',
							'57' => 'Colombia (+57)',
							'269' => 'Comoros (+269)',
							'242' => 'Congo (+242)',
							'682' => 'Cook Islands (+682)',
							'506' => 'Costa Rica (+506)',
							'385' => 'Croatia (+385)',
							'53' => 'Cuba (+53)',
							'90392' => 'Cyprus North (+90392)',
							'357' => 'Cyprus South (+357)',
							'42' => 'Czech Republic (+42)',
							'45' => 'Denmark (+45)',
							'253' => 'Djibouti (+253)',
							'1809' => 'Dominica (+1809)',
							'1809' => 'Dominican Republic (+1809)',
							'593' => 'Ecuador (+593)',
							'20' => 'Egypt (+20)',
							'503' => 'El Salvador (+503)',
							'240' => 'Equatorial Guinea (+240)',
							'291' => 'Eritrea (+291)',
							'372' => 'Estonia (+372)',
							'251' => 'Ethiopia (+251)',
							'500' => 'Falkland Islands (+500)',
							'298' => 'Faroe Islands (+298)',
							'679' => 'Fiji (+679)',
							'358' => 'Finland (+358)',
							'33' => 'France (+33)',
							'594' => 'French Guiana (+594)',
							'689' => 'French Polynesia (+689)',
							'241' => 'Gabon (+241)',
							'220' => 'Gambia (+220)',
							'7880' => 'Georgia (+7880)',
							'49' => 'Germany (+49)',
							'233' => 'Ghana (+233)',
							'350' => 'Gibraltar (+350)',
							'30' => 'Greece (+30)',
							'299' => 'Greenland (+299)',
							'1473' => 'Grenada (+1473)',
							'590' => 'Guadeloupe (+590)',
							'671' => 'Guam (+671)',
							'502' => 'Guatemala (+502)',
							'224' => 'Guinea (+224)',
							'245' => 'Guinea - Bissau (+245)',
							'592' => 'Guyana (+592)',
							'509' => 'Haiti (+509)',
							'504' => 'Honduras (+504)',
							'852' => 'Hong Kong (+852)',
							'36' => 'Hungary (+36)',
							'354' => 'Iceland (+354)',
							'91' => 'India (+91)',
							'62' => 'Indonesia (+62)',
							'98' => 'Iran (+98)',
							'964' => 'Iraq (+964)',
							'353' => 'Ireland (+353)',
							'39' => 'Italy (+39)',
							'1876' => 'Jamaica (+1876)',
							'81' => 'Japan (+81)',
							'962' => 'Jordan (+962)',
							'7' => 'Kazakhstan (+7)',
							'254' => 'Kenya (+254)',
							'686' => 'Kiribati (+686)',
							'850' => 'Korea North (+850)',
							'82' => 'Korea South (+82)',
							'965' => 'Kuwait (+965)',
							'996' => 'Kyrgyzstan (+996)',
							'856' => 'Laos (+856)',
							'371' => 'Latvia (+371)',
							'961' => 'Lebanon (+961)',
							'266' => 'Lesotho (+266)',
							'231' => 'Liberia (+231)',
							'218' => 'Libya (+218)',
							'417' => 'Liechtenstein (+417)',
							'370' => 'Lithuania (+370)',
							'352' => 'Luxembourg (+352)',
							'853' => 'Macao (+853)',
							'389' => 'Macedonia (+389)',
							'261' => 'Madagascar (+261)',
							'265' => 'Malawi (+265)',
							'60' => 'Malaysia (+60)',
							'960' => 'Maldives (+960)',
							'223' => 'Mali (+223)',
							'356' => 'Malta (+356)',
							'692' => 'Marshall Islands (+692)',
							'596' => 'Martinique (+596)',
							'222' => 'Mauritania (+222)',
							'269' => 'Mayotte (+269)',
							'52' => 'Mexico (+52)',
							'691' => 'Micronesia (+691)',
							'373' => 'Moldova (+373)',
							'377' => 'Monaco (+377)',
							'976' => 'Mongolia (+976)',
							'1664' => 'Montserrat (+1664)',
							'212' => 'Morocco (+212)',
							'258' => 'Mozambique (+258)',
							'95' => 'Myanmar (+95)',
							'264' => 'Namibia (+264)',
							'674' => 'Nauru (+674)',
							'977' => 'Nepal (+977)',
							'31' => 'Netherlands (+31)',
							'687' => 'New Caledonia (+687)',
							'64' => 'New Zealand (+64)',
							'505' => 'Nicaragua (+505)',
							'227' => 'Niger (+227)',
							'234' => 'Nigeria (+234)',
							'683' => 'Niue (+683)',
							'672' => 'Norfolk Islands (+672)',
							'670' => 'Northern Marianas (+670)',
							'47' => 'Norway (+47)',
							'968' => 'Oman (+968)',
							'680' => 'Palau (+680)',
							'507' => 'Panama (+507)',
							'675' => 'Papua New Guinea (+675)',
							'595' => 'Paraguay (+595)',
							'51' => 'Peru (+51)',
							'63' => 'Philippines (+63)',
							'48' => 'Poland (+48)',
							'351' => 'Portugal (+351)',
							'1787' => 'Puerto Rico (+1787)',
							'974' => 'Qatar (+974)',
							'262' => 'Reunion (+262)',
							'40' => 'Romania (+40)',
							'7' => 'Russia (+7)',
							'250' => 'Rwanda (+250)',
							'378' => 'San Marino (+378)',
							'239' => 'Sao Tome & Principe (+239)',
							'966' => 'Saudi Arabia (+966)',
							'221' => 'Senegal (+221)',
							'381' => 'Serbia (+381)',
							'248' => 'Seychelles (+248)',
							'232' => 'Sierra Leone (+232)',
							'65' => 'Singapore (+65)',
							'421' => 'Slovak Republic (+421)',
							'386' => 'Slovenia (+386)',
							'677' => 'Solomon Islands (+677)',
							'252' => 'Somalia (+252)',
							'27' => 'South Africa (+27)',
							'34' => 'Spain (+34)',
							'94' => 'Sri Lanka (+94)',
							'290' => 'St. Helena (+290)',
							'1869' => 'St. Kitts (+1869)',
							'1758' => 'St. Lucia (+1758)',
							'249' => 'Sudan (+249)',
							'597' => 'Suriname (+597)',
							'268' => 'Swaziland (+268)',
							'46' => 'Sweden (+46)',
							'41' => 'Switzerland (+41)',
							'963' => 'Syria (+963)',
							'886' => 'Taiwan (+886)',
							'7' => 'Tajikstan (+7)',
							'66' => 'Thailand (+66)',
							'228' => 'Togo (+228)',
							'676' => 'Tonga (+676)',
							'1868' => 'Trinidad & Tobago (+1868)',
							'216' => 'Tunisia (+216)',
							'90' => 'Turkey (+90)',
							'7' => 'Turkmenistan (+7)',
							'993' => 'Turkmenistan (+993)',
							'1649' => 'Turks & Caicos Islands (+1649)',
							'688' => 'Tuvalu (+688)',
							'256' => 'Uganda (+256)',
							'380' => 'Ukraine (+380)',
							'971' => 'United Arab Emirates (+971)',
							'598' => 'Uruguay (+598)',
							'7' => 'Uzbekistan (+7)',
							'678' => 'Vanuatu (+678)',
							'379' => 'Vatican City (+379)',
							'58' => 'Venezuela (+58)',
							'84' => 'Vietnam (+84)',
							'84' => 'Virgin Islands - British (+1284)',
							'84' => 'Virgin Islands - US (+1340)',
							'681' => 'Wallis & Futuna (+681)',
							'969' => 'Yemen (North)(+969)',
							'967' => 'Yemen (South)(+967)',
							'260' => 'Zambia (+260)',
							'263' => 'Zimbabwe (+263)',
						];

						$temp=  substr(strstr($phone, '+'),1);
					if($temp != false){$phone=$temp;}
                                                $countrycode='';
						// sort the array by key, descending
						krsort($countrys, SORT_NUMERIC);

						// iterate over all countries
						foreach($countrys as $we => $ccode){
							// if number begins with current number
							if(strpos($phone, '' . $we) === 0){
								// store country code and break the loop
								$countrycode = $we;
								break;
							}
						}

						if(!empty($countrycode)){
							$size=strlen($countrycode);
							$phone=substr($phone,$size);
						}



$criterialeads= new CDbCriteria(); 
$criterialeads->addSearchCondition('tel', $phone, false , 'OR');
$criterialeads->addSearchCondition('second_tel', $phone, false , 'OR');
$criterialeads->addSearchCondition('tel3', $phone, false , 'OR');
$criterialeads->addSearchCondition('tel4', $phone, false , 'OR');
$alllead= Leads::model()->findAll($criterialeads);
//var_dump($alllead);
//$lead =Leads::model()->findByAttributes(array('tel'=>$phone));
$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
$today = date("Y-m-d");                     // 03.10.01
$time = date("H:i:s");                      // 17:16:18	
$rnd = rand(0,99999);

if(!empty($alllead)){
foreach($alllead as $lead){ 

$recorder = new Recorder();
$recorder->date = $today;
$recorder->time = $time;
$recorder->user_sales = $lead->user_sales;
$recorder->lead_id = $lead->id;
$recorder->file = $record;
$recorder->save();
if($recorder->save()){

rename(Yii::app()->basePath.'/../recording/'.$record, Yii::app()->basePath.'/../uploads/recording/'.$record);
}

} 

}else{
    
    
$recorder = new Recorder();
$recorder->date = $today;
$recorder->time = $time;
//$recorder->user_sales = $lead->user_sales;
//$recorder->lead_id = $lead->id;
$recorder->file = $record;
$recorder->save();
if($recorder->save()){

rename(Yii::app()->basePath.'/../recording/'.$record, Yii::app()->basePath.'/../recordingcatch/'.$record);    

}
    
}





}








}




 









	


	
public function actionHourlyactivity()
{
    date_default_timezone_set('Africa/Cairo');
    $today = date("Y-m-d");
    $time = date("H:i:s");
    $allsales = User::model()->findAll();

    $start = date("H:00:00");
    $end = date("H:59:59");
    
    foreach ($allsales as $sales) {
        $criteria = new CDbCriteria;
        $criteria->condition .= "close IS NULL";

        $start2 = date('Y-m-d');
        $criteria->addSearchCondition('follow_date', $start2, "AND");
        // $criteria->addBetweenCondition("follow_time", $start, $end, "AND");
        $criteria->addCondition('user_id=' . $sales->id, "and");

        $allactivities = Activities::model()->findAll($criteria);

        if (!empty($allactivities)) {
            foreach ($allactivities as $activity) {

                $notifi = new Notifi();
                $notifi->date = $today;
                $notifi->time = $time;
                $notifi->message = $activity->client->title . ' Follow : ' . $activity->details;
                $notifi->user_id = $sales->id;
                $notifi->sendto = $sales->id;
                $notifi->url = Yii::app()->getBaseUrl(true) . '/leads/profile/' . $activity->leads_id;
                $notifi->save();

                $criteria = new CDbCriteria();
                $criteria->order = 'id DESC';
                $criteria->limit = 1;
                $criteria->addSearchCondition('userid', $sales->id, false);
                $vars = FirebaseToken::model()->findAll($criteria);

                $arr = array();
                if (!empty($vars)) {
                    foreach ($vars as $var) {
                        $arr[] = $var->token;
                    }
                }

                foreach ($vars as $var) {

                    $main = Mainsettings::model()->findByPk(1);
                    $fcmUrl = 'https://fcm.googleapis.com/fcm/send';
                    $token = $var->token;
                    
                    $headers = array(
                        'Authorization: key=YOUR_FIREBASE_SERVER_KEY',
                        'Content-Type: application/json'
                    );

                    $body = array(
                        'to' => $token,
                        'notification' => array(
                            'title' => $activity->client->title,
                            'body' => $activity->details,
                            'icon' => 'YOUR_ICON_URL',
                            'click_action' => 'OPEN_ACTIVITY_1'
                        ),
                    );

                    $data = array(
                        'headers' => $headers,
                        'body' => json_encode($body),
                    );

                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $fcmUrl);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $data['body']);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $data['headers']);
                    $result = curl_exec($ch);
                    curl_close($ch);
                }
            }
        }
    }

    // Echo or log any additional result or status message if needed
    echo 'Hourly activity processing completed successfully.';
}

	



































}
		
		
		
