<?php


class LoginController extends FrontController{
		
	/**
	* @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	* using two-column layout. See 'protected/views/layouts/column2.php'.
	*/
	public $layout='//layouts/system';
	public $salesx='';

	
	
	public function arrayflatten($array) {
  if (!is_array($array)) {
    return FALSE;
  }
  $result = array();
  foreach ($array as $key => $value) {
    if (is_array($value)) {
      $result = array_merge($result, $this->arrayflatten($value));
    }
    else {
      $result[$key] = $value;
    }
  }
  return $result;
}


// public function actionResultOCR()
// {
//     if(Yii::app()->user->isMember()){
        
//             $this->layout = '//layouts/systemcgridview';
// 			$userid=Yii::app()->user->id;
// 			date_default_timezone_set('Africa/Cairo');  
// 			$today = date("Y-m-d");                     // 03.10.01
// 			$time = date("H:i:s");                      // 17:16:18	
// 			$rnd = rand(0,99999);
			
// 			$imagePath = Yii::getAlias('@webroot') . '/uploads/image_to_process.jpg'; // Path to the uploaded image
//             $apiKey = 'K84818884688957'; // Replace with your OCR.Space API key
//             $url = 'https://api.ocr.space/parse/image';
            
//             $data = [
//                 'apikey' => $apiKey,
//                 'language' => 'eng', // Set the language (e.g., 'ara' for Arabic)
//                 'isOverlayRequired' => false,
//                 'base64Image' => base64_encode(file_get_contents($imagePath)),
//             ];
            
//             $options = [
//                 'http' => [
//                     'header' => "Content-Type: application/x-www-form-urlencoded\r\n",
//                     'method' => 'POST',
//                     'content' => http_build_query($data),
//                 ],
//             ];
            
//             $context = stream_context_create($options);
//             $response = file_get_contents($url, false, $context);
            
//             $result = json_decode($response, true);
            
//             if (!empty($result['ParsedResults'][0]['ParsedText'])) {
//                 $extractedText = $result['ParsedResults'][0]['ParsedText'];
//                 return $this->render('resultOCR', ['text' => $extractedText]);
//             } else {
//                 return $this->render('resultOCR', ['text' => 'No text detected or an error occurred.']);
//             }

// 		}else{
// 			$model=new LoginForm;
// 			// if it is ajax validation request
// 			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
// 				echo CActiveForm::validate($model);
// 				Yii::app()->end();
// 			}
// 			// collect user input data
// 			if(isset($_POST['LoginForm'])){
// 				$model->attributes=$_POST['LoginForm'];
// 				// validate user input and redirect to the previous page if valid
// 				if($model->validate() && $model->login())
// 				$this->redirect(array('login/index')	);
// 			}
// 			// display the login form
// 			$this->redirect(array('home/index')	);
// 		}

// 	}


public function actionRuncallcenter($id)
{
    $this->layout = '//layouts/systemdashboard';

    $possibleCodes = ['20', '966', '965', '971', '962', '973', '974']; // Egypt, KSA, Kuwait, UAE, etc.

    $callerId = preg_replace('/[^0-9]/', '', $id);
    
    $lead = null;
    foreach ($possibleCodes as $code) {
        if (strpos($callerId, $code) === 0) {
            $tel = substr($callerId, strlen($code));
            $lead = Leads::model()->findByAttributes([
                'international_code' => $code,
                'tel' => $tel
            ]);
            if ($lead) break;
        }
    }

    if ($lead && $lead->user_sales) {
        $userSalesId = (int) $lead->user_sales;

        $tokenModel = FirebaseToken::model()->find([
            'condition' => 'userid = :uid AND token IS NOT NULL',
            'params' => [':uid' => $userSalesId],
            'order' => 'id DESC',
        ]);

        if ($tokenModel && trim($tokenModel->token) !== '') {
            $this->sendFirebaseNotification(
                $tokenModel->token,
                "Incoming Call",
                "Caller: $id",
                $lead->id
            );

            echo json_encode(['status' => 'sent', 'lead_id' => $lead->id]);
            Yii::app()->end();
        } else {
            echo json_encode(['status' => 'no_token']);
            Yii::app()->end();
        }
    }

    echo json_encode(['status' => 'not_found']);
    Yii::app()->end();
}

private function sendFirebaseNotification($token, $title, $body, $leadId)
{
    $webAppUrl = 'https://script.google.com/macros/s/AKfycbxt7LfT0D_uALCYGiy-2AiYC2vju_V-Nw5fPKhhsr4eQLluCFvORFW8ClGT18Zrhqlivw/exec';

    $payload = [
        'token' => $token,
        'title' => $title,
        'body' => $body,
        'leadId' => $leadId
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $webAppUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // ✅ Fix 302 redirection

    $result = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);

    file_put_contents('/home/sosdw0104/fcm_log.txt', "🔑 Token: $token\n📤 Payload: " . json_encode($payload) . "\n", FILE_APPEND);
    if ($result === false) {
        file_put_contents('/home/sosdw0104/fcm_log.txt', "❌ CURL ERROR: $error\n", FILE_APPEND);
    } else {
        file_put_contents('/home/sosdw0104/fcm_log.txt', "✅ Script Response: $result\n", FILE_APPEND);
    }
}



public function actionTransferactionconfirmation()
{
    if (Yii::app()->user->isMember()) {
        $this->layout = '//layouts/systemcgridview';
        
        $userid = Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");
        $time = date("H:i:s");
        $rnd = rand(0, 99999);

        // Fetch transferaction data with user and sales details
        $connection = Yii::app()->db;
        $sql = "SELECT 
            ta.id, 
            ta.date, 
            ta.time, 
            ta.user_id, 
            u.fname AS fname, 
            u.lname AS lname, 
            ta.sales, 
            s.fname AS sales_fname, 
            s.lname AS sales_lname, 
            ta.total, 
            ta.accepted, 
            ta.rejected, 
            ta.done, 
            ta.details, 
            ta.hidden, 
            ta.url 
        FROM transferaction ta
        LEFT JOIN user u ON ta.user_id = u.id
        LEFT JOIN user s ON ta.sales = s.id
        WHERE ta.hidden IS NULL OR ta.hidden = 0
        ORDER BY ta.id DESC
        LIMIT 50";
        $command = $connection->createCommand($sql);
        $transferActions = $command->queryAll();

        $this->render('transferactionconfirmation', [
            'transferActions' => $transferActions,
        ]);
    } else {
        $this->redirect(['home/index']);
    }
}

public function actionTransferactionrejected($id)
{
    if (Yii::app()->user->isMember()) {
        $transferaction = Transferaction::model()->findByPk($id);
        if ($transferaction !== null) {
            $transferaction->hidden = 1;
            if ($transferaction->save()) {
                Yii::app()->user->setFlash('success', 'Transfer action marked as deleted.');
            } else {
                Yii::app()->user->setFlash('error', 'Failed to delete the transfer action.');
            }
        } else {
            Yii::app()->user->setFlash('error', 'Transfer action not found.');
        }
        $this->redirect(['login/transferactionconfirmation']);
    } else {
        $this->redirect(['home/index']);
    }
}

public function actionTransferactionconfirmationprocess($id)
{
    $userid = Yii::app()->user->id;
    date_default_timezone_set('Africa/Cairo');
    $today = date("Y-m-d");$time = date("H:i:s"); 

    $transferActionId = intval($id);
    if (empty($transferActionId)) {
        Yii::app()->user->setFlash('error', 'Invalid transfer action ID.');
        $this->redirect(['login/transferactionconfirmation']);
    }

    $connection = Yii::app()->db;

    // جلب كل التحويلات المرتبطة بنفس العملية دفعة واحدة مع تحسين الاستعلام
    $transferQuery = "
        SELECT SQL_NO_CACHE id, fromm, too, lead_id, hide, hideteamleader, user_id, fakenewlead 
        FROM transfer 
        WHERE transferaction_id = :id AND done IS NULL
    ";
    $transferCommand = $connection->createCommand($transferQuery);
    $transferCommand->bindParam(':id', $transferActionId, PDO::PARAM_INT);
    $transferData = $transferCommand->queryAll();

    if (empty($transferData)) {
        Yii::app()->user->setFlash('error', 'No matching transfer records found.');
        $this->redirect(['login/transferactionconfirmation']);
    }

    $transaction = $connection->beginTransaction();

    try {
        $leadIds = [];
        $updateLeads = [];
        $updateActivities = [];
        $updateTransfer = [];
        $hideLeads = [];
        $fakeLeads = [];
        $hideTeamLeaderLeads = [];

        foreach ($transferData as $transfer) {
            $leadId = $transfer['lead_id'];
            if (empty($leadId)) {
                throw new Exception('Invalid lead ID for transfer ID: ' . $transfer['id']);
            }

            $leadIds[] = $leadId;
            $updateLeads[] = "WHEN id = {$leadId} THEN '{$transfer['too']}'";
            $updateActivities[] = "WHEN leads_id = {$leadId} THEN 1";
            $updateTransfer[] = $transfer['id'];

            if ($transfer['fakenewlead'] == 1) {
                $fakeLeads[] = $leadId;
            } elseif ($transfer['hide'] == 1) {
                $hideLeads[] = $leadId;
            } elseif ($transfer['hideteamleader'] == 1) {
                $hideTeamLeaderLeads[] = $leadId;
            }
        }

        // تحديث جدول `leads` بدون التأثير على الكاش
        if (!empty($leadIds)) {
            $leadIdsString = implode(',', $leadIds);
            $updateLeadsCases = implode(' ', $updateLeads);
        
            $connection->createCommand("
                UPDATE LOW_PRIORITY leads 
                SET user_sales = CASE $updateLeadsCases END, 
                    transfer = 1, 
                    transferuser = '$userid', 
                    transferdate = '$today',
                    communication = NULL,
                    fake = NULL,
                    fakedate = NULL,
                    close = NULL
                WHERE id IN ($leadIdsString)
            ")->execute();
        }

        // تحديث `activities` بدون التأثير على الكاش
        if (!empty($leadIds)) {
            $updateActivitiesCases = implode(' ', $updateActivities);
            $connection->createCommand("
                UPDATE LOW_PRIORITY activities 
                SET close = CASE $updateActivitiesCases END, 
                    report = IFNULL(report, 'done')
                WHERE leads_id IN ($leadIdsString)
            ")->execute();
        }

        // تحديث التحويلات (Mark as done) بدون التأثير على الكاش
        if (!empty($updateTransfer)) {
            $transferIdsString = implode(',', $updateTransfer);
            $connection->createCommand("
                UPDATE LOW_PRIORITY transfer 
                SET done = 1 
                WHERE id IN ($transferIdsString)
            ")->execute();
        }

        // معالجة الحالات الخاصة مثل الإخفاء أو الـ fake
        if (!empty($fakeLeads)) {
            $fakeLeadsString = implode(',', $fakeLeads);
            $connection->createCommand("
                UPDATE IGNORE leads 
                SET hiddenactivtiesdate = '$today',
                    hidden = 1, 
                    fake = 1,
                    fakedate = '$today'
                WHERE id IN ($fakeLeadsString)
            ")->execute();

            $connection->createCommand("
                UPDATE IGNORE activities 
                SET close = 1,
                    report = IFNULL(report, 'done'),
                    hidden = 1,
                    hideteamleader = 1
                WHERE leads_id IN ($fakeLeadsString)
            ")->execute();
        }

        if (!empty($hideLeads)) {
            $hideLeadsString = implode(',', $hideLeads);
            $connection->createCommand("
                UPDATE IGNORE leads 
                SET hiddenactivtiesdate = '$today',
                    hidden = 1, 
                    fake = NULL,
                    fakedate = NULL
                WHERE id IN ($hideLeadsString)
            ")->execute();

            $connection->createCommand("
                UPDATE IGNORE activities 
                SET close = 1,
                    report = IFNULL(report, 'done'),
                    hidden = 1
                WHERE leads_id IN ($hideLeadsString)
            ")->execute();
        }

        if (!empty($hideTeamLeaderLeads)) {
            $hideTeamLeaderLeadsString = implode(',', $hideTeamLeaderLeads);
            $connection->createCommand("
                UPDATE IGNORE leads 
                SET hiddenactivtiesdate = '$today',
                    hidden = 1, 
                    fake = NULL,
                    fakedate = NULL
                WHERE id IN ($hideTeamLeaderLeadsString)
            ")->execute();

            $connection->createCommand("
                UPDATE IGNORE activities 
                SET close = 1,
                    report = IFNULL(report, 'done'),
                    hidden = 1,
                    hideteamleader = 1
                WHERE leads_id IN ($hideTeamLeaderLeadsString)
            ")->execute();
        }

        // تحديث `transferaction` بدون التأثير على الكاش
        $connection->createCommand("
            UPDATE LOW_PRIORITY transferaction 
            SET done = 1 
            WHERE id = :transferActionId
        ")->execute([':transferActionId' => $transferActionId]);

        $transaction->commit();
        Yii::app()->user->setFlash('success', 'Transfer actions successfully processed.');
    } catch (Exception $e) {
        $transaction->rollback();
        Yii::app()->user->setFlash('error', 'An error occurred: ' . $e->getMessage());
    }

    $this->redirect(['login/transferactionconfirmation']);
}

public function actionCallcenterpopup()
{
    if(Yii::app()->user->isMember()){
        
            $this->layout = '//layouts/systemdashboard';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
    $this->render('callcenterpopup');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
public function actionLosteddata()
{
    if(Yii::app()->user->isMember()){
        
            $this->layout = '//layouts/systemcgridview';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
    $this->renderPartial('losteddata');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
public function actionMainsettingsview()
{
    $model = Mainsettings::model()->findByPk(1);

    if (!$model) {
        throw new CHttpException(404, 'Mainsettings record not found.');
    }

    if (isset($_POST['Mainsettings'])) {
        $model->attributes = $_POST['Mainsettings']; // Mass assignment of all fields

        if ($model->save(false)) { // Save without validation
            Yii::app()->user->setFlash('success', 'Settings updated successfully.');
            $this->refresh();
        } else {
            echo "<pre>Errors:\n";
            print_r($model->getErrors());
            echo "</pre>";
            Yii::app()->end();
        }
    }

    $this->render('mainsettingsview', ['model' => $model]);
}

public function actionPartialContent()
{
    if(Yii::app()->user->isMember()){
        $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
    $this->renderPartial('partials');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}

public function actionAutoqr()
{
    if(Yii::app()->user->isMember()){
        $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
    $this->renderPartial('autoqr');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}

public function actionDataanalysisforleads()
{
    if (Yii::app()->user->isMember()) {
        $this->layout = '//layouts/systemcgridview';
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
        $model = new Leads('searchdataanalysislead');
        if (isset($_POST['Leads'])) {
            Yii::log("POST values received in controller: " . print_r($_POST['Leads'], true), 'info');
            $model->attributes = $_POST['Leads'];
        }
        if (isset($_POST['Leads']['user_sales_filter_type'])) {
            $model->user_sales_filter_type = $_POST['Leads']['user_sales_filter_type'];
        }
        if (isset($_POST['Leads']['user_sales_not_value'])) {
            $model->user_sales_not_value = $_POST['Leads']['user_sales_not_value'];
        }
        
        if(isset($_POST['checks']) AND isset($_POST['salescheck'])){
            $hide= $_POST['Hideee'];
            $hideteamleader= $_POST['Hideteamleader'];
            $fakenewlead= $_POST['fakenewlead'];
            $criteria = new CDbCriteria();       
            $criteria->addInCondition('id', $_POST['checks']);
            $allleadsss= Leads::model()->findAll($criteria);
            $total = count($allleadsss);
            $total = (int)$total;
            $sales = (int)$_POST['salescheck'];
            $transferaction=new Transferaction();
            $transferaction->user_id=$userid;
            $transferaction->date= $today ;                     // 03.10.01
            $transferaction->time= $time  ;
            $transferaction->sales= $sales  ;
            $transferaction->total= $total  ;
            if($transferaction->save()){
                foreach($allleadsss as $lead){
                    $treason ="Multi Transfer";
                    $transfer=new Transfer();
                    $transfer->reason=$treason;
                    $transfer->user_id=$userid;
                    $transfer->lead_id=$lead->id;
                    $transfer->fromm=$lead->user_sales;
                    $transfer->too=$transferaction->sales;
                    $transfer->transferaction_id=$transferaction->id;
                    $transfer->date= $today ;                     // 03.10.01
                    $transfer->time= $time  ;
                    $transfer->hide= $hide  ;
                    $transfer->hideteamleader= $hideteamleader  ;
                    $transfer->fakenewlead= $fakenewlead  ;
                    if($transfer->save()){
                        $transferaction->accepted = $transferaction->accepted+1;
                        $transferaction->save();
                    }
                    if(!$transfer->save()){
                        $transferaction->accepted = $transferaction->accepted+1;
                        $transferaction->save(); 
                    }
                }
            }
            Yii::app()->controller->refresh();
        }

        $dataProvider = $model->searchdataanalysislead();
        Yii::log("Controller DataProvider Item Count: " . $dataProvider->getTotalItemCount(), 'info');
        

        $this->render('dataanalysisforleads', array(
            'model' => $model,
            'dataProvider' => $dataProvider,
        ));
    } else {
        $model = new LoginForm;
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'login-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
        if (isset($_POST['LoginForm'])) {
            $model->attributes = $_POST['LoginForm'];
            if ($model->validate() && $model->login()) {
                $this->redirect(array('login/index'));
            }
        }
        $this->redirect(array('home/index'));
    }
}

 

public function actionGetLeadsJsonDT()
{
    header('Content-Type: application/json');
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    ini_set('memory_limit', '1024M');
    set_time_limit(0);

    $draw = (int)($_GET['draw'] ?? 1);
    $start = (int)($_GET['start'] ?? 0);
    $length = (int)($_GET['length'] ?? 100);
    $orderColumn = $_GET['order'][0]['column'] ?? 0;
    $orderDir = $_GET['order'][0]['dir'] ?? 'desc';

    $columns = [
        "l.id", "l.code", "l.date", "l.time", "l.title", "l.tel", "l.second_tel",
        "created_user.fname", "sales_user.id", "unseen_user.id", "l.adname",
        "l.unit_type", "l.property_type", "projects.id", "campaign.id",
        "platform.id", "platform_child.id", "l.notes", "l.sales_report", "l.checkup_activity",
        "statues.id", "substatus.id", "l.follow_date", "l.follow_time", "l.action_time",
        "l.transferdate", "transfer_user.id", "l.visit", "l.client_id"
    ];

    $orderBy = $columns[$orderColumn] . ' ' . strtoupper($orderDir);

    $whereParts = [];
    $params = [];

    if (isset($_GET['columns'])) {
        foreach ($_GET['columns'] as $index => $col) {
            $searchVal = trim($col['search']['value']);
            if ($searchVal !== '') {
                $columnName = $columns[$index];

                // Date range filter
                if (preg_match('/^\d{4}-\d{2}-\d{2}\s+to\s+\d{4}-\d{2}-\d{2}$/', $searchVal)) {
                    list($startDate, $endDate) = explode(' to ', $searchVal);
                    $paramStart = ":start$index";
                    $paramEnd = ":end$index";
                    $whereParts[] = "$columnName BETWEEN $paramStart AND $paramEnd";
                    $params[$paramStart] = $startDate;
                    $params[$paramEnd] = $endDate;

                // Multi-value filter
                } elseif (strpos($searchVal, '|') !== false) {
                    $parts = explode('|', $searchVal);
                    $inParams = [];
                    foreach ($parts as $i => $part) {
                        $key = ":val{$index}_$i";
                        $inParams[] = $key;
                        $params[$key] = $part;
                    }
                    $whereParts[] = "$columnName IN (" . implode(',', $inParams) . ")";

                // Normal single-value exact match
                } else {
                    $paramKey = ":param$index";
                    $params[$paramKey] = $searchVal;
                    $whereParts[] = "$columnName = $paramKey";
                }
            }
        }
    }

    $whereClause = $whereParts ? "WHERE " . implode(" AND ", $whereParts) : "";
    $cacheKey = 'leadsDT_' . md5($whereClause . ":$start:$length:$orderBy");

    $data = null;
    $recordsFiltered = null;
    $cacheStatus = 'MISS';

    try {
        if (Yii::app()->cache !== null && Yii::app()->cache->get($cacheKey)) {
            list($data, $recordsFiltered) = Yii::app()->cache->get($cacheKey);
            $cacheStatus = 'HIT';
        }

        if ($data === null) {
            $sql = "
                SELECT l.id, l.code, l.date, l.time, l.title, l.tel, l.second_tel,
                       created_user.fname AS created_fname, created_user.lname AS created_lname,
                       sales_user.fname AS sales_fname, sales_user.lname AS sales_lname,
                       unseen_user.fname AS unseen_fname, unseen_user.lname AS unseen_lname,
                       l.adname,
                       unittype.title AS unittype_title,
                       propertytype.title AS propertytype_title,
                       projects.title AS project_title,
                       campaign.title AS campaign_title,
                       platform.title AS platform_title,
                       platform_child.title AS platformchild_title,
                       l.notes, l.sales_report, l.checkup_activity,
                       statues.title AS status_title,
                       substatus.title AS substatus_title,
                       l.follow_date, l.follow_time, l.action_time,
                       l.transferdate,
                       transfer_user.fname AS transfer_fname, transfer_user.lname AS transfer_lname,
                       l.visit, l.client_id
                FROM leads l
                LEFT JOIN user created_user ON created_user.id = l.user_id
                LEFT JOIN user sales_user ON sales_user.id = l.user_sales
                LEFT JOIN user unseen_user ON unseen_user.id = l.unseenauto
                LEFT JOIN user transfer_user ON transfer_user.id = l.transferuser
                LEFT JOIN statues ON statues.id = l.status
                LEFT JOIN substatus ON substatus.id = l.substatus
                LEFT JOIN type_buliding unittype ON unittype.id = l.unit_type
                LEFT JOIN type_buliding propertytype ON propertytype.id = l.property_type
                LEFT JOIN projects ON projects.id = l.project_id
                LEFT JOIN campaign ON campaign.id = l.campaign_id
                LEFT JOIN platform_child ON platform_child.id = l.platformchild_id
                LEFT JOIN platform ON platform.id = platform_child.parent_id
                $whereClause
                ORDER BY $orderBy
                LIMIT :start, :length
            ";

            $command = Yii::app()->db->createCommand($sql);
            foreach ($params as $key => $value) {
                $command->bindValue($key, $value);
            }
            $command->bindParam(":start", $start, PDO::PARAM_INT);
            $command->bindParam(":length", $length, PDO::PARAM_INT);

            $data = $command->queryAll();

            $countSql = "SELECT COUNT(*) FROM leads l
                LEFT JOIN user created_user ON created_user.id = l.user_id
                LEFT JOIN user sales_user ON sales_user.id = l.user_sales
                LEFT JOIN user unseen_user ON unseen_user.id = l.unseenauto
                LEFT JOIN user transfer_user ON transfer_user.id = l.transferuser
                LEFT JOIN statues ON statues.id = l.status
                LEFT JOIN substatus ON substatus.id = l.substatus
                LEFT JOIN type_buliding unittype ON unittype.id = l.unit_type
                LEFT JOIN type_buliding propertytype ON propertytype.id = l.property_type
                LEFT JOIN projects ON projects.id = l.project_id
                LEFT JOIN campaign ON campaign.id = l.campaign_id
                LEFT JOIN platform_child ON platform_child.id = l.platformchild_id
                LEFT JOIN platform ON platform.id = platform_child.parent_id
                $whereClause";

            $countCommand = Yii::app()->db->createCommand($countSql);
            foreach ($params as $key => $value) {
                $countCommand->bindValue($key, $value);
            }
            $recordsFiltered = $countCommand->queryScalar();

            if (Yii::app()->cache !== null) {
                Yii::app()->cache->set($cacheKey, [$data, $recordsFiltered], 60);
            }
        }

        $recordsTotal = Yii::app()->db->createCommand("SELECT COUNT(*) FROM leads")->queryScalar();

        echo json_encode([
            'draw' => $draw,
            'recordsTotal' => (int)$recordsTotal,
            'recordsFiltered' => (int)$recordsFiltered,
            'data' => $data,
            'cacheStatus' => $cacheStatus
        ]);
    } catch (Exception $e) {
        echo json_encode([
            'draw' => $draw,
            'recordsTotal' => 0,
            'recordsFiltered' => 0,
            'data' => [],
            'error' => $e->getMessage(),
            'cacheStatus' => 'ERROR'
        ]);
    }

    Yii::app()->end();
}


public function actionGetFilterOptions()
{
    $term = $_GET['term'] ?? '';
    $column = $_GET['column'] ?? null;

    $columnsMap = [
        7  => 'created_user.fname',
        8  => 'sales_user.fname',
        13 => 'projects.title',
        14 => 'campaign.title',
        15 => 'platform.title',
        16 => 'platform_child.title',
        20 => 'statues.title',
        21 => 'substatus.title',
        26 => 'transfer_user.fname'
    ];

    if (!isset($columnsMap[$column])) {
        echo json_encode(['results' => []]);
        Yii::app()->end();
    }

    $colName = $columnsMap[$column];

    $sql = "
        SELECT DISTINCT $colName AS text
        FROM leads l
        LEFT JOIN user created_user ON created_user.id = l.user_id
        LEFT JOIN user sales_user ON sales_user.id = l.user_sales
        LEFT JOIN user transfer_user ON transfer_user.id = l.transferuser
        LEFT JOIN campaign ON campaign.id = l.campaign_id
        LEFT JOIN platform_child ON platform_child.id = l.platformchild_id
        LEFT JOIN platform ON platform.id = platform_child.parent_id
        LEFT JOIN statues ON statues.id = l.status
        LEFT JOIN substatus ON substatus.id = l.substatus
        LEFT JOIN projects ON projects.id = l.project_id
        WHERE $colName LIKE :term
        ORDER BY text ASC
        LIMIT 20
    ";

    $command = Yii::app()->db->createCommand($sql);
    $command->bindValue(':term', "%$term%", PDO::PARAM_STR);
    $results = $command->queryAll();

    echo json_encode(['results' => $results]);
    Yii::app()->end();
}


public function actionDataanalysisforunits()
{
    if (Yii::app()->user->isMember()) {
            $this->layout = '//layouts/systemcgridview';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

        $model = new Units('searchdataanalysisunit');
        if (isset($_POST['Units'])) {
            Yii::log("POST values received in controller: " . print_r($_POST['Units'], true), 'info');
            $model->attributes = $_POST['Units'];
        }

        $dataProvider = $model->searchdataanalysisunit();
        Yii::log("Controller DataProvider Item Count: " . $dataProvider->getTotalItemCount(), 'info');

        $this->render('dataanalysisforunits', array(
            'model' => $model,
            'dataProvider' => $dataProvider,
        ));
    } else {
        $model = new LoginForm;
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'login-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
        if (isset($_POST['LoginForm'])) {
            $model->attributes = $_POST['LoginForm'];
            if ($model->validate() && $model->login()) {
                $this->redirect(array('login/index'));
            }
        }
        $this->redirect(array('home/index'));
    }
}

public function actionDataanalysisforeoi()
{
    if (Yii::app()->user->isMember()) {
            $this->layout = '//layouts/systemcgridview';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

        $model = new Eoiform('searchdataanalysiseoi');
        if (isset($_POST['Eoiform'])) {
            $model->attributes = $_POST['Eoiform'];
            if (!empty($_POST['Eoiform']['from_date'])) {
                $model->from_date = $_POST['Eoiform']['from_date'];
            }
            if (!empty($_POST['Eoiform']['to_date'])) {
                $model->to_date = $_POST['Eoiform']['to_date'];
            }
        }

        $dataProvider = $model->searchdataanalysiseoi();
        Yii::log("Controller DataProvider Item Count: " . $dataProvider->getTotalItemCount(), 'info');

        $this->render('dataanalysisforeoi', array(
            'model' => $model,
            'dataProvider' => $dataProvider,
        ));
    } else {
        $model = new LoginForm;
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'login-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
        if (isset($_POST['LoginForm'])) {
            $model->attributes = $_POST['LoginForm'];
            if ($model->validate() && $model->login()) {
                $this->redirect(array('login/index'));
            }
        }
        $this->redirect(array('home/index'));
    }
}



public function actionDeletehistory(){
		if(Yii::app()->user->isMember()){
            $this->layout = '//layouts/systemcgridview';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

            $this->render('deletehistory');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}

public function actionStatussalesindirect(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('statussalesindirect');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
public function actionDashajaxunitsanalyzes(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('dashajaxunitsanalyzes');
 
		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
public function actionDashajaxunitsanalyzeschart(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('dashajaxunitsanalyzeschart');
 
		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
public function actionDashajaxagentdistribution(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('dashajaxagentdistribution');
 
		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}


public function actionDailyActionTime(){
    if(Yii::app()->user->isMember()){
        $this->layout = '';
        $userid = Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");
        $time = date("H:i:s");
        $rnd = rand(0,99999);
         
        $this->layout = '//layouts/systemcgridview';
        
        $start = $today . " 00:00:00";
        $end = $today . " 23:59:59";

        $sql = "
            SELECT
                u.fname,
                u.lname,
                HOUR(a.time) as hour,
                COUNT(*) AS activity_count
            FROM
                activities a
            INNER JOIN
                user u ON u.id = a.user_id
            WHERE
                a.date BETWEEN :start AND :end
            GROUP BY
                u.fname, u.lname, HOUR(a.time)
        ";

        $command = Yii::app()->db->createCommand($sql);
        $command->bindParam(':start', $start, PDO::PARAM_STR);
        $command->bindParam(':end', $end, PDO::PARAM_STR);
        $results = $command->queryAll();

        $this->render('dailyactiontime', array('results' => $results));
    } else {
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}



// Grand Stream API :: Begin

public function actionApigrand()
{
  
    $this->render('apigrand');
}
public function actionGDMS()
{
  
    $this->render('GDMS');
}

// POST request to get access token
private function sendOAuthRequest($url, $data)
{
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded',
    ]);

    $response = curl_exec($ch);
    $error = curl_error($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    Yii::log("🌐 OAuth HTTP Code: $httpCode", 'error');
    Yii::log("🧾 Raw OAuth Response: $response", 'error'); // ✅ Add this line

    if ($error) Yii::log('❌ cURL Error: ' . $error, 'error');

    return json_decode($response, true);
}

private function sendAuthorizedRequest($url, $headers, $data = [])
{
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    if (!empty($data)) {
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    }

    $response = curl_exec($ch);
    $error = curl_error($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    Yii::log("🌐 API HTTP Code: $httpCode", 'error');
    if ($error) Yii::log('❌ cURL Error: ' . $error, 'error');

    return json_decode($response, true);
}

// GET request with Bearer token
private function sendBearerRequest($url, $token)
{
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $token",
        'Content-Type: application/json'
    ]);

    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);

    if ($error) {
        Yii::log('cURL Error (SIP): ' . $error, 'error');
        return [];
    }

    return json_decode($response, true);
}
// Grand Stream API :: End



public function actionAjaxengdashboard(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('ajaxengdashboard');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}

public function actionAjaxsales7indirect(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('sales7indirect');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
		
public function actionAjaxsaleslateindirect(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('saleslateindirect');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
	
	
public function actionAjaxsalesfreshindirect(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('salesfreshindirect');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	


	
		public function actionSqlupdates()
		{
		if(Yii::app()->user->isMember())
		{
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		$this->render('sqlupdates',array(
		'userid'=>$userid ,	
        

		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->render('index',array('model'=>$model));
		}

		}
		




public function actionIndirectSalesDashboard($id){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
            
		    }
         
		        
		    
		        
		  $this->render('indirectsalesdashboard');

    }


public function actionTestxml(){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
            
            
            
            
            
            
            
            
              // Replace this with your actual XML link
        $xmlLink = 'https://mexml.propspace.com/mefeed/xml.php?cl=1061&pid=11001&acc=11100';

        // Initialize cURL session
        $ch = curl_init($xmlLink);

        // Set cURL options
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

        // Execute the cURL session
        $xmlData = curl_exec($ch);

        // Close the cURL session
        curl_close($ch);

        // Parse the XML data using DOMDocument
        $dom = new DOMDocument();
        $dom->loadXML($xmlData);

        // Now you have the $dom containing the parsed XML data
        // You can further process or render the data in a view
        // For example, you might want to extract specific elements or attributes
        // and pass the extracted data to the view for rendering
        $elements = $dom->getElementsByTagName('elementName');
var_dump($xmlData);exit;
    }

		        
		  $this->render('testxml', array('elements' => $elements));

    }
		



	public function actionCountrycode(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);		
			
			
			
		$model = new Countrycode();
		$model->setScenario('com_porfile');
		if (isset($_POST['Countrycode'])) {
		$rnd = rand(0,9999);
$model->date= $today;
$model->time= $time;
		$model->user_id= $userid;
		$model->attributes = $_POST['Countrycode'];

		if ($model->save()) {
		    		Yii::app()->controller->refresh();

		    
		}
		}


			$allcountrycode = Countrycode::model()->findAll();
	
		

			$this->render('countrycode',array(
					'$allcountrycode'=>$$allcountrycode,
						'model'=>$model,
					

				));
		}
		

	




}














public function actionEoiReservationSettings(){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
            
		    }
         
		    $this->layout = '//layouts/systemcgridview';
		        
		  $this->render('eoireservationsettings');

    }
    
    
    
    
    

public function actionQuickdistribute($id){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
        		$lead=Leads::model()->findByPk($id);

            
		    }
         
		        
		    
		        
		  $this->render('quickdistribute',array('lead'=>$lead));

    }
    

public function actionQuickreport($id){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
        		$lead=Leads::model()->findByPk($id);

            
		    }
         
		        
		    
		        
		  $this->render('quickreport',array('lead'=>$lead));

    }
    
    
    
    
    
    
    
                
                public function actionQuickdevelopercommision($id){
                
                if(Yii::app()->user->isMember()){
                $this->layout = '';
                $userid=Yii::app()->user->id;
                date_default_timezone_set('Africa/Cairo');  
                $today = date("Y-m-d");                     // 03.10.01
                $time = date("H:i:s"); 
                $tcr=Tcr::model()->findByPk($id);
                
                

                
                
                $model=$tcr;
                if(isset($_POST['Tcr']))
                {
                    //var_dump($_POST['Tcr']['total_commision']);exit;

                    
                    
                $model->total_commision=$_POST['Tcr']['total_commision'];    
                $model->total_commision_before_value_added_tax=$_POST['Tcr']['total_commision_before_value_added_tax'];    
                $model->value_added_tax=$_POST['Tcr']['value_added_tax'];    
                $model->withholding_tax=$_POST['Tcr']['withholding_tax'];    
                $model->net_commision=$_POST['Tcr']['net_commision'];   


                    

                if ($model->save()) {

                
                $this->redirect(array('account/tcrdashboard/'.$id), false);
                
                }
                }
                

                
                
                
                

		    }
         
		        
		    
		        
		  $this->render('quickdevelopercommision',array('model'=>$model));

    }
    
    
    
    
    
    	
    
                    public function actionQuickcollect($id){
                
                if(Yii::app()->user->isMember()){
                $this->layout = '';
                $userid=Yii::app()->user->id;
                date_default_timezone_set('Africa/Cairo');  
                $today = date("Y-m-d");                     // 03.10.01
                $time = date("H:i:s"); 
                $tcr=Tcr::model()->findByPk($id);
                
                

                
                
                $model= new Collectedtcr();
                if(isset($_POST['Collectedtcr']))
                {
                //var_dump($_POST['Collectedtcr']);exit;

                    
                    
                $model->amount=$_POST['Collectedtcr']['amount'];   
                $model->debit_tree_id=$_POST['Collectedtcr']['debit_tree_id'];    
                $model->credit_tree_id=$_POST['Collectedtcr']['credit_tree_id'];    
                $model->tcr_id=$tcr->id;    
                $model->user_id=$userid;    

                $model->date=$today;    
                $model->time=$time;    



                    

                if ($model->save()) {

                
                $this->redirect(array('account/tcrdashboard/'.$id), false);
                
                }
                }
                

                
                
                
                

		    }
         
		        
		    
		        
		  $this->render('quickcollect',array(
		      'model'=>$model,
		      'tcr'=>$tcr
		      
		      ));

    }

    
    
    
    
     public function actionQuickfinancialapproval($id){
                
                if(Yii::app()->user->isMember()){
                $this->layout = '';
                $userid=Yii::app()->user->id;
                date_default_timezone_set('Africa/Cairo');  
                $today = date("Y-m-d");                     // 03.10.01
                $time = date("H:i:s"); 
                $res=Reservation::model()->findByPk($id);
                
                $unitsclose=Units::model()->findByPk($res->unit_id);
                $unitsclose->booking = 1;
                
                 
                  $main = Mainsettings::model()->findByPk(1);
    $url = Yii::app()->getBaseUrl(true) . "/account/confirmreservation";
    
    $sid    = $main->whatsapp_sid;
    $token  = $main->whatsapp_token;
    
    // Recipient's WhatsApp number
    $to = "whatsapp:+" . $em->mobile;
    // Your WhatsApp Business number
    $from = "whatsapp:+" . $main->whatsapp_from;
    
    // Template SID (Use your actual Template SID)
    //$templateSid = "HX3651fc98925d84c20a5ebba0cac47ad1";
    $templateSid = $main->whatsapp_templatesid_5;

    $visible = 1;
    $criteria = new CDbCriteria;
    $criteria->addCondition('notification IS NOT NULL');
    $criteria->addSearchCondition('salesmanger', $visible, false, 'AND');
    $criteria->addSearchCondition('level', $visible, false, 'AND');
    $allUser = User::model()->findAll($criteria);

    // Initialize recipients array
    $recipients = [];

    // Check if users are found
    if (!empty($allUser)) {
        foreach ($allUser as $user) {
            if (!empty($user->mobile)) {
                $recipients[] = $user->mobile; // Add user's mobile to recipients list
            }
        }
    }
    
    

    // Ensure no duplicate numbers are present
    $recipients = array_unique($recipients);
                // var_dump($recipients);exit;

    // Debugging step: Ensure you are gathering all numbers correctly
    error_log('Unique Recipients: ' . print_r($recipients, true));

    // Make sure recipients array is not empty
    if (!empty($recipients)) {
        foreach ($recipients as $mobile) {
            // Debugging step: Print the current recipient being sent to
            error_log("Sending to: " . $mobile);

            $to = "whatsapp:" . $mobile;

            // Template parameters as key-value pairs
            if (!empty($main->hide_number_whatsapp)) {
                $templateParams = array(
                    '1' => $res->name,
                    '2' => $unitsclose->code,
                    '3' => $url,
                );
            } else {
                $templateParams = array(
                    '1' => $res->name,
                    '2' => $unitsclose->code,
                    '3' => $url,

                );
            }

            // Convert TemplateParams to JSON
            $templateParams = json_encode($templateParams);

            // Twilio API URL for sending template messages
            $apiUrl = "https://api.twilio.com/2010-04-01/Accounts/$sid/Messages.json";

            // Data to be sent in the POST request
            $data = array(
                'To' => $to,
                'From' => $from,
                'ContentSid' => $templateSid,
                'ContentVariables' => $templateParams,
                'message_id' => uniqid() // Unique ID for each message
            );

            // Initialize cURL
            $ch = curl_init($apiUrl);

            // Set cURL options
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
            curl_setopt($ch, CURLOPT_USERPWD, "$sid:$token");

            // Execute the request and get the response
            $response = curl_exec($ch);

            // Check for cURL errors
            if ($response === false) {
                error_log('cURL Error: ' . curl_error($ch));
            } else {
                $response_data = json_decode($response, true);
                if (isset($response_data['sid'])) {
                    error_log('Message SID: ' . $response_data['sid']);
                } else {
                    error_log('No SID found in the response. Full response: ' . print_r($response_data, true));
                }
            }

            // Close the cURL session
            curl_close($ch);
        }
    } else {
        error_log('No recipients found.');
    }

//var_dump($response_data['sid']);exit;

                
                
                
                if (isset($_POST['collect_status'])) {
                // Get the selected value from the dropdown
                $collectStatus = $_POST['collect_status'];
                
                // Process the selected value as needed
                if ($collectStatus === 'have_collect') {
                // Logic for "Have Collect"
                
                $res->collect_status = 1;
                
                
               
                


                } elseif ($collectStatus === 'full_collect') {
                // Logic for "Full Collect"
                 
                 
               $res->collect_status = 2;
               $res->collect_status_done = 1;
                
                
    
//var_dump($response_data['sid']);exit;

                



                }
                
                }

                
                
                
                
                
            	$unitsclose->save();
                
                $res->financialapproval=1;    
                if ($res->save()) {
                $this->redirect(array('account/confirmreservation/'), false);
                
                }

                

                
                
                
                

		    }
         
		        
		    
		        
		  $this->render('quickfinancialapproval',array(
		      'model'=>$model,
		      'res'=>$res
		      
		      ));

    }
    
    
    

public function actionTicketclose($id){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $ticket=Customerservice::model()->findByPk($id);
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
        		$ticket->done=$_POST['done'];
        		$ticket->report=$_POST['report'];
				$ticket->save();
        		
        		//var_dump($ticket);exit;
        		$this->redirect(array('sales/profile','secert' => $ticket->lead_id), false);



            
		    }
         
		        
		    
		        

    }
    
    
    
    
    
    
         
                  
    
    
    

public function actionAjaxunitsprofile($id){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
        		$lead=Leads::model()->findByPk($id);
        		
        		
        		
        		$allresale=new Resale('lead');

             	$allresale->unsetAttributes();  // clear any default values
                if(isset($_GET['Resale'])){
                $allresale->attributes=$_GET['Resale'];
                }
                
                
                
                
                
                $allres=new Reservation('client');
                
                $allres->unsetAttributes();  // clear any default values
                if(isset($_GET['Reservation'])){
                $allres->attributes=$_GET['Reservation'];
                }
                  

            
		    }
         
		        
		    
		        
		  $this->render('ajaxunitsprofile',array(
		      'lead'=>$lead,
		      'allres'=>$allres,
		      
		      
		      ));

    }
    
    
    
    
    
    
    

public function actionAjaxresalesprofile($id){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
        		$lead=Leads::model()->findByPk($id);
        		
        		
        		
        		
                
                $allresale=new Resale('lead');
                
                $allresale->unsetAttributes();  // clear any default values
                if(isset($_GET['Resale'])){
                $allresale->attributes=$_GET['Resale'];
                }
                

                
        		
        		

            
		    }
         
		        
		    
		        
		  $this->render('ajaxresalesprofile',array(
		      'lead'=>$lead,
		      'allresale'=>$allresale,
		      
		      
		      ));

    }










public function actionAjaxai($id){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
                $lead = Leads::model()->findByAttributes(array('id' => $id));

        		
        		
        		
               
                

                
        		
        		

            
		    }
         
		        
		    
		        
		  $this->render('ajaxai',array(
		      'lead'=>$lead,

		      
		      ));

    }







public function actionAjaxaichat(){
		 if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 

        		
        		
        		
               
                

                
        		
        		
$this->render('ajaxaichat',array());
            
		    }
		  

    }


public function actionAjaxduplicatedetails($id){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
        		$excel=Excel::model()->findByPk($id);
        		
        		
        		
        		
                
                $allexcel=new Excel('du');
                
                $allexcel->unsetAttributes();  // clear any default values
                if(isset($_GET['Excel'])){
                $allexcel->attributes=$_GET['Excel'];
                }
                

                
        		
        		

            
		    }
         
		        
		    
		        
		  $this->render('ajaxduplicatedetails',array(
		      'excel'=>$excel,
		      'allexcel'=>$allexcel,
		      
		      
		      ));

    }








public function actionQuickhistory($id){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
        		$lead=Leads::model()->findByPk($id);
        		//var_dump($lead);exit;

            
		    }
         
		        
		    
		        
		  $this->render('quickhistory',array('lead'=>$lead));

    }

public function actionQuickaction($id){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
        		$lead=Leads::model()->findByPk($id);
        		//var_dump($lead);exit;

            
		    }
         
		        
		    
		        
		  $this->render('quickaction',array('lead'=>$lead));

    }
    
    
    
    
public function actionQuickpaymentmethods(){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
        		$lead=Leads::model()->findByPk($id);
        		//var_dump($lead);exit;

            
		    }
         
		        
		    
		        
		  $this->render('quickpaymentmethods',array('lead'=>$lead));

    }    


public function actionQuicktransfer($id){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
        		$lead=Leads::model()->findByPk($id);
        		//var_dump($lead);exit;
        		
        		
        		
        		
        $oldsales=$lead->user_sales;
		$transfer=new Transfer();										
		if(isset($_POST['Lead'])){
		    
            $lead->transferfrom=$lead->user_sales;
            $lead->transferuser=$userid;
            $lead->user_sales=$_POST['Lead']['sales'];
            $lead->transfer=1;
            $lead->counttransfer=$lead->counttransfer+1;
            $lead->dtime = $time;
            $lead->transferdate=$today;
            $lead->checkup_activity=$today;
            $lead->communicate_date=$today;
            $lead->communication=NULL;
			$transfer->reason=$_POST['Transfer']['reason'];
			$transfer->hide=$_POST['Transfer']['Hideee'];
			$transfer->hideteamleader=$_POST['Transfer']['Hideteamleader'];
			$transfer->fakenewlead=$_POST['Transfer']['fakenewlead'];

			$lead->transferreason=$transfer->reason;
			if(!empty($lead->backtolife)){
			$lead->backtolifetransfer=1;
			}
			if($lead->save()){
				$lead->close=NULL;
				$lead->save();
				$transfer->user_id=$userid;
				$transfer->lead_id=$lead->id;
				$transfer->fromm=$oldsales;
				$transfer->too=$lead->user_sales;
				$transfer->date= $today ;                     // 03.10.01
				$transfer->time= $time  ;
				if($transfer->save()){ 
                        // Your additional logic here
                        if ($transfer->hide == 1) {
                            

                        $lead = Leads::model()->findByPk($transfer->lead_id);
                        $lead->hiddenactivtiesdate = $today;
                        $lead->transferfrom = $transfer->fromm;
                        $lead->transferuser = $transfer->user_id;
                        $lead->fakedate = NULL;
                        $lead->fake = NULL;
                        $lead->save();
                        if($lead->save()){
                        // Update related activities
                        Yii::app()->db->createCommand()
                        ->update(
                        'activities',
                        array('close' => 1,'hidden' => 1,   'too' => $transfer->too),
                        'leads_id = :lead_id',
                        array(':lead_id' => $lead->id)
                        );
                        }
                        }
                        
                        
                        
                        if ($transfer->hideteamleader == 1) {
                        $lead = Leads::model()->findByPk($transfer->lead_id);
                        $lead->hiddenactivtiesdate = $today;
                        $lead->transferfrom = $transfer->fromm;
                        $lead->transferuser = $transfer->user_id;
                        $lead->fakedate = NULL;
                        $lead->fake = NULL;
                        $lead->save();
                        if($lead->save()){
                        Yii::app()->db->createCommand()
                        ->update(
                        'activities',
                        array('hidden' => 1, 'hideteamleader' => 1, 'close' => 1, 'too' => $transfer->too),
                        'leads_id = :lead_id',
                        array(':lead_id' => $lead->id)
                        );
                        }
                        }
                        
                        
                        
                        
                        
                        if ($transfer->fakenewlead == 1) {
                        $lead = Leads::model()->findByPk($transfer->lead_id);
                        $lead->fake = 1;
                        $lead->fakedate = $today;
                        $lead->transferfrom = $transfer->fromm;
                        $lead->transferuser = $transfer->user_id;
                        $lead->save();
                        if($lead->save()){
                        Yii::app()->db->createCommand()
                        ->update(
                        'activities',
                        array('hidden' => 1, 'hideteamleader' => 1, 'close' => 1, 'too' => $transfer->too),
                        'leads_id = :lead_id',
                        array(':lead_id' => $lead->id)
                        );
                        }
                        }
	    
				    
				    
				    
				    
				    
		$usercheck=User::model()->findByPk($userid);    
		if($usercheck->addleadup == 1){
       //var_dump($usercheck->addleadup);exit; 
        
            $modelchat = new Chatandsupport();
            $rnd = rand(0,99999);
            $modelchat->date=$today;
            $modelchat->time=$time;
            $modelchat->lead_id=$lead->id;
            $modelchat->user_sales=$userid;
            $modelchat->details='other sales';
            $modelchat->close=1;
            $modelchat->user_id=$userid;
            $modelchat->save();
            if(!$modelchat->save()){
            var_dump($lead->getErrors());
            }
            
    }
				    
				    
				    $main=Mainsettings::model()->findByPk(1);
$iconurl=Yii::app()->getBaseUrl(true).'/img/'.$main->logo;
							

// Assuming $transfer is an instance of some model with lead_id property
$leadId = $transfer->lead_id;
$tooValue = $transfer->too;

// Update 'activities' table
$condition = "leads_id = :lead_id AND close IS NULL";
$params = array(':lead_id' => $leadId);

Activities::model()->updateAll(
    array('too' => $tooValue),
    $condition,
    $params
);

			
					



					Yii::app()->controller->refresh();
				}
			}
			
			
			
			
			
			
			
			
		}
        		
        		

            
		    }
         
		        
		    
		        
		  $this->render('quicktransfer',array('lead'=>$lead));

    }





public function  actionQuickedit($id){

		if(Yii::app()->user->isMember()){
		    		        $this->layout = '';

			$model=Leads::model()->findByPk($id);
			$leaduserid=$model->user_id;
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$visible=1;
			$allcampaign= Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allstatus= Statues::model()->findAll();
			$titlebefore = $model->title;
			$telbefore = $model->tel;
			
			$marketing = User::model()->findByAttributes(array('id'=>$model->user_marketing));
			$marketingbefore = $marketing->fname.$marketing->lname;
			
			
			//$tel2before = $model->tel2;
			//$tel3before = $model->tel3;
			//$tel4before = $model->tel4;
			$platform = Platform::model()->findByAttributes(array('id'=>$model->platform_id));
			$platformbefore = $platform->title; 
			$campaign = Campaign::model()->findByAttributes(array('id'=>$model->campaign_id));
			$campaignbefore = $campaign->title; 


			if(isset($_POST['Leads'])){


if($model->tel != $_POST['Leads']['tel'] AND !empty($_POST['Leads']['tel']) ){
                            $name = str_replace(' ', '', $_POST['Leads']['tel']);
        					$name = preg_replace('/\D/', '', $name);
        					
							$criteriaduplecat= new CDbCriteria(); 
    						$criteriaduplecat->addSearchCondition('tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('second_tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel3', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel4', $name, false , 'OR');
							$allduplecat1= Leads::model()->findAll($criteriaduplecat);
}
if ($model->second_tel != $_POST['Leads']['second_tel']   AND !empty($_POST['Leads']['second_tel'])  ){
    
                            $name = str_replace(' ', '', $_POST['Leads']['second_tel']);
        					$name = preg_replace('/\D/', '', $name);
							$criteriaduplecat= new CDbCriteria(); 
    						$criteriaduplecat->addSearchCondition('tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('second_tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel3', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel4', $name, false , 'OR');
							$allduplecat2= Leads::model()->findAll($criteriaduplecat);
}
if ($model->tel3 != $_POST['Leads']['tel3']   AND !empty($_POST['Leads']['tel3'])  ){
    
                            $name = str_replace(' ', '', $_POST['Leads']['tel3']);
        					$name = preg_replace('/\D/', '', $name);
							$criteriaduplecat= new CDbCriteria(); 
    						$criteriaduplecat->addSearchCondition('tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('second_tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel3', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel4', $name, false , 'OR');
							$allduplecat3= Leads::model()->findAll($criteriaduplecat);
}
if ($model->tel4 != $_POST['Leads']['tel4'] AND !empty($_POST['Leads']['tel4'])  ){
    
                            $name = str_replace(' ', '', $_POST['Leads']['tel4']);
        					$name = preg_replace('/\D/', '', $name);
							$criteriaduplecat= new CDbCriteria(); 
    						$criteriaduplecat->addSearchCondition('tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('second_tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel3', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel4', $name, false , 'OR');
							$allduplecat4= Leads::model()->findAll($criteriaduplecat);
}
if(!empty($allduplecat1) or !empty($allduplecat2) or !empty($allduplecat3) or !empty($allduplecat4) ) Yii::app()->controller->refresh();
		 
				$model->attributes = $_POST['Leads'];
			//	var_dump($_POST['Leads']['duplicate_date']);exit;

$main=Mainsettings::model()->findByPk(1);
if(!empty($main->hideselectcampaign)){
				
				$xcam=Campaign::model()->findByAttributes(array('title'=>$_POST['campaignx']));
                if(empty($xcam)) {
                
                

                
            $modelca = new Campaign();
            $modelca->setScenario('com_porfile');
            $rnd = rand(0,9999);
            $modelca->user_id = $userid;
            $modelca->strategy_id = 1;
            $modelca->date = $today;
            $modelca->time = $time;
            $modelca->title = $_POST['campaignx'];
            $modelca->details = $_POST['campaignx'];
            $modelca->cost = 0;
            $modelca->objective_id = 1;
            $modelca->hidden = 1;
            $modelca->secert = $rnd.$userid;
            $modelca->save();
            if(!$modelca->save()){
            var_dump($modelca->getErrors());
            exit;
            }

           
            $model->campaign_id = $modelca->id ;
            
                
            }else{
                
            $model->campaign_id = $xcam->id ;    
                
            }
            
}

           
                
$checktypelead=Platform::model()->findByAttributes(array('id'=>$_POST['Leads']['platform_id']));
if($checktypelead->indirect == 1){
$model->coldcall = 3;
}elseif($checktypelead->coldcall == 1){
$model->coldcall = 1;
}else{
}
				$model->platformchild_id=$_POST['Leads']['platformchild_id'];

				if(empty($model->user_id)){
				    $model->user_id=$leaduserid;
				}
 //var_dump($allduplecat2);
	           // exit;
				//$allleads=Leads::model()->findAll(array( 'condition' => 'tel!=' . $model->tel ,'order'=>'id DESC'  ));  
				
				//var_dump($_POST['Leads']['fresh_sales']);exit;

$model->fresh_sales = $_POST['Leads']['fresh_sales'];
$model->project_id = $_POST['Leads']['project_id'];

if(!empty($_POST['Leads']['user_marketing'])){
$model->user_marketing = $_POST['Leads']['user_marketing'];
$model->user_id = $_POST['Leads']['user_marketing'];

}
if(!empty($_POST['Leads']['duplicate_date'])){
$model->duplicate_date=$_POST['Leads']['duplicate_date'];
}

				if($model->save()){
				    
				    
				    
				      
            $editlog = new Editlog();
            $editlog->date = $today;
            $editlog->time = $time;
            $editlog->lead_id = $model->id;
            
            
            $platform = Platform::model()->findByAttributes(array('id'=>$model->platform_id));
			$platformnow = $platform->title; 
			
			$marketing = User::model()->findByAttributes(array('id'=>$model->user_marketing));
			$marketingnow = $marketing->fname.$marketing->lname; 
			
			$campaign = Campaign::model()->findByAttributes(array('id'=>$model->campaign_id));
			$campaignnow = $campaign->title; 

            
            $editlog->user_id = $userid;
            $editlog->editfrom = '  name : '
            .$titlebefore
            .' </br> tel : '.
            $telbefore 
            .' </br> campaign : '.
            $campaignbefore
             .' </br> platform : '.
            $platformbefore
             .' </br> marketing : '.
            $marketingbefore
            ;
            
            $editlog->editto = '  name : '
            .$model->title
            .' </br> tel : '.
            $model->tel
             .' </br> campaign : '.
            $campaignnow
            .' </br> platform : '.
            $platformnow
            .' </br> marketing : '.
            $marketingnow

            ;
            $editlog->editcolumn = 'User Edit Lead';
            $editlog->save();
            
				    
				    


					$this->redirect(array('leads/profile/'.$model->id)	);

					//$this->redirect(array('sales/editlead/'.$model->secert)	);

				//	Yii::app()->controller->refresh();
				}else{
				    
				    
				    var_dump($model->getErrors());
				}
			}








			$this->render('/sales/editlead',array(
					'userid'=>$userid ,	
					'model'=>$model ,	
					'allsales'=>$allsales,	
					'allproject'=>$allproject ,	
					'allcampaign'=>$allcampaign,	
					'allplatform'=>$allplatform,	
					'allstatus'=>$allstatus,	
        

				));
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}







public function actionQuickreplaycomment($id){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
        		$com=Comments::model()->findByPk($id);
        		//var_dump($lead);exit;
        		
        		
        		
                $model=new Commentsaction;
                if(isset($_POST['Commentsaction']))
                {
                $model->attributes=$_POST['Commentsaction'];
                $model->time = $time;
                $model->date = $today;
                $model->user_id = $userid;
                $model->comments_id = $com->id;
                
                if ($model->save()) {
              //  Yii::app()->controller->refresh();
              
              
              $this->redirect(array('sales/comments'), false);
              
                }
                }
        		
        		

            
		    }
         
		        
		    
		        
		  $this->render('quickreplaycomment',array(
		      'com'=>$com,
		      'model'=>$model,
		      
		      ));

    }


public function actionMastermap(){
      
		    if(Yii::app()->user->isMember()){
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
		        $model=new Mastermap;
            if(isset($_POST['Mastermap']))
            {
                $model->attributes=$_POST['Mastermap'];
                $model->time = $time;
        		$model->date = $today;
        		$model->user_id = $userid;
        	if ($model->save()) {
		Yii::app()->controller->refresh();
		}
            }
		        
		        }
		        
		  $this->render('mastermap',array('model'=>$model));

    }
    
    
    
    
    
    
    
    


public function actionGetlocation(){
      
		    if(Yii::app()->user->isMember()){
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
		        
   
   if($_POST['close'] != 1)
            {
   
		        $model=new OrientationLocations;
            if(isset($_POST['OrientationLocations']))
            {
                
                

                $or=new Orientation;
                $or->attributes=$_POST['Orientation'];
                $or->time = $time;
        		$or->date = $today;
        		$or->user_id = $userid;
                $or->company_id = $_POST['com'];
        		//->company_id = 1;
        		$or->meeting_description = "Start Meeting";
                if ($or->save()) {
                    

                $model->attributes=$_POST['OrientationLocations'];
                $model->time = $time;
        		$model->date = $today;
        		$model->user_id = $userid;
        		$model->type_id = 1;
        		$model->company_id =  $_POST['com'];
        		$model->orientation_id = $or->id;
        		$model->meeting_description = "Start Meeting";
        	if ($model->save()) {
		Yii::app()->controller->refresh();
		}
                }  
                
            }
            
            
            }else{
                
                $com = $_POST['com'];
                $or = $_POST['or'];
                $or = Orientation::model()->findByAttributes(array('id'=>$or));
                //var_dump($or);exit;
                $or->close = 1;
                $or->meeting_description = $_POST['description'];
                if ($or->save()) {
                    
                $model=new OrientationLocations;
                $model->attributes=$_POST['OrientationLocations'];
                $model->time = $time;
        		$model->date = $today;
        		$model->user_id = $userid;
        		$model->type_id = 2;
        		$model->company_id =  $_POST['com'];
        		$model->orientation_id = $or->id;
        		$model->meeting_description = $_POST['description'];
        	if ($model->save()) {
		Yii::app()->controller->refresh();
		}
		
		
		if (!$model->save()) {
		$or->delete();
		Yii::app()->controller->refresh();
		}
		
		
                

                var_dump($or);exit;
                
                
            }
		        
		        }
		    }
		        
		  $this->render('getlocation',array('model'=>$model));

    }








	public function actionPrintdashboard()
		{  


		if(Yii::app()->user->isMember())
		{
		    	
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 
		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
		$user=User::model()->findByPk($userid);
		//$mpdf->autoLangToFont = false;
		//$mpdf->autoArabic = false;
		//$mpdf->charset_in='utf-8';
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');
		$html = $this->renderPartial('_printdashboard',array(
				'today' => $today,'time' => $time,'user' => $user), true);
		$main=Mainsettings::model()->findByPk(1);	    
		$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
		$mpdf1->SetProtection(array('print'));
		$mpdf1->SetTitle('Print');
		$mpdf1->SetAuthor("Brandshtine.");
		//$mpdf1->SetWatermarkText("");
		//$mpdf1->showWatermarkText = true;
		//$mpdf1->watermark_font = 'DejaVuSansCondensed';
		//$mpdf1->watermarkTextAlpha = 0.1;
		$mpdf1->SetDisplayMode('fullpage');
		$mpdf1->SetAutoFont('4');		  
		$mpdf1->WriteHTML($html);
		$file_name= 'Dashboard.pdf';
		ob_end_clean();
         	$mpdf1->Output($file_name,'I' );

		}


    }
    
    
    
	public function actionSearchbyallajax()
		{  


		if(Yii::app()->user->isMember())
		{

 
							$allleads= Leads::model()->findAll();
							
         if(!empty($allleads)){
             $data_array = array();
             foreach($allleads as $lead){
                $lead->substatus=$lead->substatusaction->title;
                $lead->status=$lead->statuesaction->title;
                $lead->campaign_id=$lead->campaign->title;
                $lead->interest_id=$lead->place->title;
                $lead->platform_id=$lead->platform->title;
                $lead->platformchild_id=$lead->platformchild->title;
                $lead->user_sales=$lead->sales->fname." ".$lead->sales->lname;
                
                
               $data_array[] = $lead->getAttributes();  
             }
             $json_data = json_encode($data_array);
             //file_put_contents('myfile.json', $json_data);
           echo $json_data;   
         }else{
             file_put_contents('myfile.json', "");
         }
         
        
        
        }


    }
    
    
    
    
    
    
    
    
    
    
		public function actionSearchbytelajax()
		{  


		if(Yii::app()->user->isMember())
		{


                            $phone=$_REQUEST['tel'];
                            $code=$_REQUEST['code'];
                            $title=$_REQUEST['title'];
                            $date=$_REQUEST['date'];
        					$criteria= new CDbCriteria();
        					$criteria->limit=100;
        					if(!empty($phone)){
							$criteria->addSearchCondition('tel', $phone, false , 'OR');
							$criteria->addSearchCondition('second_tel', $phone, false , 'OR');
							$criteria->addSearchCondition('tel3', $phone, false , 'OR');
							$criteria->addSearchCondition('tel4', $phone, false , 'OR');
        					}  
        					
        					
        					if(!empty($code)){
							$criteria->addSearchCondition('secert', $code, false , 'AND'); 
        					}  
        					
        					
        					if(!empty($date)){
							$criteria->addSearchCondition('date', $date, false , 'AND'); 
        					}  
        					
        					
        					
        					if(!empty($title)){
			            	$criteria->addSearchCondition('title', $title ,TRUE, "AND");
        					}  
							$allleads= Leads::model()->findAll($criteria);
         if(!empty($allleads)){
             $data_array = array();
             foreach($allleads as $lead){
               $data_array[] = $lead->getAttributes();  
             }
             $json_data = json_encode($data_array);
             //file_put_contents('myfile.json', $json_data);
           echo $json_data;   
         }else{
             file_put_contents('myfile.json', "");
         }
         
        
        
        }


    }
	
	public function actionLeaddel()
		{  


		if(Yii::app()->user->isMember())
		{


         $data=Leads::model()->findByPk($_POST['id']);
        
        $data->delete();
         
        echo 'yes' ;
        
        }


    }
    
    
    
    	public function actionNewnote()
		{  


		if(Yii::app()->user->isMember())
		{

			$lead=Leads::model()->findByPk($_POST['lead_id']);
			
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$model = new Notes();
			$rnd = rand(0,99999); 
				$model->note = $_POST['note'];
				$model->note_type = $_POST['note_type'];
				$model->sales_id=$lead->user_sales;
				$model->date=$today;
				$model->time=$time;
				$model->lead_id=$_POST['lead_id'];
				$model->user_id=$userid;
				$model->activities_id=$_POST['id'];
				$model->secert=$rnd.$userid;
				if($model->save()){
				    $activity=Activities::model()->findByPk($model->activities_id);
				    $activity->notes=$model->note;
				    if($activity->save()){
				        echo 'yes' ;
				    }
				}  
			 
        
        }


    }
    
    
    
    
  
    
    
    
    
    
    
    
     
    
    
     
    
    

    






	
	










	public function actionCustomers(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);			
  

			$this->render('customer',array( 
					'userid'=>$userid , 
				));
		}
		

		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
public function actionDailyactivitieschartteamleader(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('dailyactivitieschartteamleader');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
public function actionReportteamleader1(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('reportteamleader1');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
public function actionReportteamleader2(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('reportteamleader2');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
public function actionClosemonthchartteamleader(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('closemonthchartteamleader');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
	
public function actionReport2(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('report2');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
public function actionReport8teamleader(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('report8teamleader');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}

	



	
		public function actionAllwebsiteLead()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
		
		
				
       $this->layout = '//layouts/systemcgridview';
                	    
                	    
                        	    
                        	    
        $allwebsite=new FbLeadForm('websiteleads');
        $allwebsite->unsetAttributes();  // clear any default values
        if(isset($_GET['websiteleads'])){
        $allwebsite->attributes=$_GET['websiteleads'];
        }
	
		
		
		
		
                                           	
$criteriax = new CDbCriteria(); 
$criteriax->order = 'id DESC';
//$criteriax->addSearchCondition('website', $website, false);
$criteriax->addCondition('lead_id IS  NULL');
$allcallcenter= FbLeadForm::model()->findAll($criteriax);


if(!empty($allcallcenter)){
foreach($allcallcenter as $callcenter){	
    
    
    

    
$mobile=$callcenter->tel;  

    
$findlead=Leads::model()->findByAttributes(array('tel'=>$mobile));

if(!empty($findlead)){
$callcenter->lead_id=$findlead->id;
$callcenter->name=$findlead->title;
$callcenter->save();
}
}
} 
 
                          
                                                            	
$criteria = new CDbCriteria();        
//$criteria->addSearchCondition('date', $today, false);
$criteria->order = 'id DESC';
$criteria->addCondition('lead_id IS NULL AND website IS NOT NULL ');

     $allleads = new CActiveDataProvider('FbLeadForm', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ), 
                                                                           'criteria' => $criteria,
                                                            ));
                                   


 




		$this->render('allwebsiteleads',array(
		'userid'=>$userid ,	
		'allleads'=>$allleads ,	
		'$array'=>$array ,	
			'allwebsite'=>$allwebsite ,	
		

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
		
		
		
		
		
		
		
		
		public function actionReroutian()
		{
		if(Yii::app()->user->isMember())
		{


        		$userid=Yii::app()->user->id;
        		date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s");                      // 17:16:18	
        		$rnd = rand(0,99999);
        		
        		
                
                $criteria = new CDbCriteria();        
                $criteria->order = 'id DESC';
                $criteria->addCondition('done IS  NULL');
                $allleads = new CActiveDataProvider('Requestroutation', array(
                'pagination' => array(
                'pageSize' =>50,
                ), 
                'criteria' => $criteria,
                ));
        


		$this->render('reroutian',array(
		'userid'=>$userid ,	
		'allleads'=>$allleads ,	

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
		
		
		public function actionAllfblead()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
		
		
		
		
       $this->layout = '//layouts/systemcgridview';
                	    
                	    
                        	    
                        	    
        $allfbleads=new FbLeadForm('fbleads');
        $allfbleads->unsetAttributes();  // clear any default values
        if(isset($_GET['fbleads'])){
        $allfbleads->attributes=$_GET['fbleads'];
        }

 
		

                                           	
$criteriax = new CDbCriteria(); 
$criteriax->order = 'id DESC';
$criteriax->addCondition('lead_id IS  NULL');
$criteriax->addCondition('website IS  NULL');
$criteriax->addCondition('callcenter IS  NULL');
$allcallcenter= FbLeadForm::model()->findAll($criteriax);


if(!empty($allcallcenter)){
foreach($allcallcenter as $callcenter){	
    
    
    
    
    

$phone= $callcenter->tel;
if($phone[0]=='0')
    $phone = substr($phone , 1);
$countrys = [
    '1' => 'USA (+1)',
							'44' => 'UK (+44)',
							'213' => 'Algeria (+213)',
							'376' => 'Andorra (+376)',
							'244' => 'Angola (+244)',
							'1264' => 'Anguilla (+1264)',
							'1268' => 'Antigua & Barbuda (+1268)',
							'54' => 'Argentina (+54)',
							'374' => 'Armenia (+374)',
							'297' => 'Aruba (+297)',
							'61' => 'Australia (+61)',
							'43' => 'Austria (+43)',
							'994' => 'Azerbaijan (+994)',
							'1242' => 'Bahamas (+1242)',
							'973' => 'Bahrain (+973)',
							'880' => 'Bangladesh (+880)',
							'1246' => 'Barbados (+1246)',
							'375' => 'Belarus (+375)',
							'32' => 'Belgium (+32)',
							'501' => 'Belize (+501)',
							'229' => 'Benin (+229)',
							'1441' => 'Bermuda (+1441)',
							'975' => 'Bhutan (+975)',
							'591' => 'Bolivia (+591)',
							'387' => 'Bosnia Herzegovina (+387)',
							'267' => 'Botswana (+267)',
							'55' => 'Brazil (+55)',
							'673' => 'Brunei (+673)',
							'359' => 'Bulgaria (+359)',
							'226' => 'Burkina Faso (+226)',
							'257' => 'Burundi (+257)',
							'855' => 'Cambodia (+855)',
							'237' => 'Cameroon (+237)',
							'238' => 'Cape Verde Islands (+238)',
							'1345' => 'Cayman Islands (+1345)',
							'236' => 'Central African Republic (+236)',
							'56' => 'Chile (+56)',
							'86' => 'China (+86)',
							'57' => 'Colombia (+57)',
							'269' => 'Comoros (+269)',
							'242' => 'Congo (+242)',
							'682' => 'Cook Islands (+682)',
							'506' => 'Costa Rica (+506)','225' => 'Cote d Ivoire (+225)',
							'385' => 'Croatia (+385)',
							'53' => 'Cuba (+53)',
							'90392' => 'Cyprus North (+90392)',
							'357' => 'Cyprus South (+357)',
							'42' => 'Czech Republic (+42)',
							'45' => 'Denmark (+45)',
							'253' => 'Djibouti (+253)',
							'1809' => 'Dominica (+1809)',
							'1809' => 'Dominican Republic (+1809)',
							'593' => 'Ecuador (+593)',
							'20' => 'Egypt (+20)',
							'503' => 'El Salvador (+503)',
							'240' => 'Equatorial Guinea (+240)',
							'291' => 'Eritrea (+291)',
							'372' => 'Estonia (+372)',
							'251' => 'Ethiopia (+251)',
							'500' => 'Falkland Islands (+500)',
							'298' => 'Faroe Islands (+298)',
							'679' => 'Fiji (+679)',
							'358' => 'Finland (+358)',
							'33' => 'France (+33)',
							'594' => 'French Guiana (+594)',
							'689' => 'French Polynesia (+689)',
							'241' => 'Gabon (+241)',
							'220' => 'Gambia (+220)',
							'7880' => 'Georgia (+7880)',
							'49' => 'Germany (+49)',
							'233' => 'Ghana (+233)',
							'350' => 'Gibraltar (+350)',
							'30' => 'Greece (+30)',
							'299' => 'Greenland (+299)',
							'1473' => 'Grenada (+1473)',
							'590' => 'Guadeloupe (+590)',
							'671' => 'Guam (+671)',
							'502' => 'Guatemala (+502)',
							'224' => 'Guinea (+224)',
							'245' => 'Guinea - Bissau (+245)',
							'592' => 'Guyana (+592)',
							'509' => 'Haiti (+509)',
							'504' => 'Honduras (+504)',
							'852' => 'Hong Kong (+852)',
							'36' => 'Hungary (+36)',
							'354' => 'Iceland (+354)',
							'91' => 'India (+91)',
							'62' => 'Indonesia (+62)',
							'98' => 'Iran (+98)',
							'964' => 'Iraq (+964)',
							'353' => 'Ireland (+353)',
							'39' => 'Italy (+39)',
							'1876' => 'Jamaica (+1876)',
							'81' => 'Japan (+81)',
							'962' => 'Jordan (+962)',
							'7' => 'Kazakhstan (+7)',
							'254' => 'Kenya (+254)',
							'686' => 'Kiribati (+686)',
							'850' => 'Korea North (+850)',
							'82' => 'Korea South (+82)',
							'965' => 'Kuwait (+965)',
							'996' => 'Kyrgyzstan (+996)',
							'856' => 'Laos (+856)',
							'371' => 'Latvia (+371)',
							'961' => 'Lebanon (+961)',
							'266' => 'Lesotho (+266)',
							'231' => 'Liberia (+231)',
							'218' => 'Libya (+218)',
							'417' => 'Liechtenstein (+417)',
							'370' => 'Lithuania (+370)',
							'352' => 'Luxembourg (+352)',
							'853' => 'Macao (+853)',
							'389' => 'Macedonia (+389)',
							'261' => 'Madagascar (+261)',
							'265' => 'Malawi (+265)',
							'60' => 'Malaysia (+60)',
							'960' => 'Maldives (+960)',
							'223' => 'Mali (+223)',
							'356' => 'Malta (+356)',
							'692' => 'Marshall Islands (+692)',
							'596' => 'Martinique (+596)',
							'222' => 'Mauritania (+222)',
							'269' => 'Mayotte (+269)',
							'52' => 'Mexico (+52)',
							'691' => 'Micronesia (+691)',
							'373' => 'Moldova (+373)',
							'377' => 'Monaco (+377)',
							'976' => 'Mongolia (+976)',
							'1664' => 'Montserrat (+1664)',
							'212' => 'Morocco (+212)',
							'258' => 'Mozambique (+258)',
							'95' => 'Myanmar (+95)',
							'264' => 'Namibia (+264)',
							'674' => 'Nauru (+674)',
							'977' => 'Nepal (+977)',
							'31' => 'Netherlands (+31)',
							'687' => 'New Caledonia (+687)',
							'64' => 'New Zealand (+64)',
							'505' => 'Nicaragua (+505)',
							'227' => 'Niger (+227)',
							'234' => 'Nigeria (+234)',
							'683' => 'Niue (+683)',
							'672' => 'Norfolk Islands (+672)',
							'670' => 'Northern Marianas (+670)',
							'47' => 'Norway (+47)',
							'968' => 'Oman (+968)',
							'680' => 'Palau (+680)',
							'507' => 'Panama (+507)',
							'675' => 'Papua New Guinea (+675)',
							'595' => 'Paraguay (+595)',
							'51' => 'Peru (+51)',
							'63' => 'Philippines (+63)',
							'48' => 'Poland (+48)',
							'351' => 'Portugal (+351)',
							'1787' => 'Puerto Rico (+1787)',
							'974' => 'Qatar (+974)',
							'262' => 'Reunion (+262)',
							'40' => 'Romania (+40)',
							'7' => 'Russia (+7)',
							'250' => 'Rwanda (+250)',
							'378' => 'San Marino (+378)',
							'239' => 'Sao Tome & Principe (+239)',
							'966' => 'Saudi Arabia (+966)',
							'221' => 'Senegal (+221)',
							'381' => 'Serbia (+381)',
							'248' => 'Seychelles (+248)',
							'232' => 'Sierra Leone (+232)',
							'65' => 'Singapore (+65)',
							'421' => 'Slovak Republic (+421)',
							'386' => 'Slovenia (+386)',
							'677' => 'Solomon Islands (+677)',
							'252' => 'Somalia (+252)',
							'27' => 'South Africa (+27)',
							'34' => 'Spain (+34)',
							'94' => 'Sri Lanka (+94)',
							'290' => 'St. Helena (+290)',
							'1869' => 'St. Kitts (+1869)',
							'1758' => 'St. Lucia (+1758)',
							'249' => 'Sudan (+249)','211' => 'South Sudan (+211)',
							'597' => 'Suriname (+597)',
							'268' => 'Swaziland (+268)',
							'46' => 'Sweden (+46)',
							'41' => 'Switzerland (+41)',
							'963' => 'Syria (+963)',
							'886' => 'Taiwan (+886)',
							'7' => 'Tajikstan (+7)',
							'66' => 'Thailand (+66)',
							'228' => 'Togo (+228)',
							'676' => 'Tonga (+676)',
							'1868' => 'Trinidad & Tobago (+1868)',
							'216' => 'Tunisia (+216)',
							'90' => 'Turkey (+90)',
							'7' => 'Turkmenistan (+7)',
							'993' => 'Turkmenistan (+993)',
							'1649' => 'Turks & Caicos Islands (+1649)',
							'688' => 'Tuvalu (+688)',
							'256' => 'Uganda (+256)',
							'380' => 'Ukraine (+380)',
							'971' => 'United Arab Emirates (+971)',
							'598' => 'Uruguay (+598)',
							'7' => 'Uzbekistan (+7)',
							'678' => 'Vanuatu (+678)',
							'379' => 'Vatican City (+379)',
							'58' => 'Venezuela (+58)',
							'84' => 'Vietnam (+84)',
							'84' => 'Virgin Islands - British (+1284)',
							'84' => 'Virgin Islands - US (+1340)',
							'681' => 'Wallis & Futuna (+681)',
							'969' => 'Yemen (North)(+969)',
							'967' => 'Yemen (South)(+967)',
							'260' => 'Zambia (+260)',
							'263' => 'Zimbabwe (+263)',
						];

						$temp=  substr(strstr($phone, '+'),1);
					if($temp != false){$phone=$temp;}
                                                $countrycode='';
						// sort the array by key, descending
						krsort($countrys, SORT_NUMERIC);

						// iterate over all countries
						foreach($countrys as $we => $ccode){
							// if number begins with current number
							if(strpos($phone, '' . $we) === 0){
								// store country code and break the loop
								$countrycode = $we;
								break;
							}
						}

						if(!empty($countrycode)){
							$size=strlen($countrycode);
							$phone=substr($phone,$size);
						}



			
    
    

					
    
    
//mobile=$callcenter->tel;
//var_dump($phone);
//exit;


                                           	
$criteriaall = new CDbCriteria(); 
$criteriaall->order = 'id DESC';
$criteriaall->addSearchCondition('tel', $phone ,TRUE);

$allleads= Leads::model()->findAll($criteriaall);



if(!empty($allleads)){
foreach($allleads as $leads){	
    
$callcenter->lead_id=$leads->id;
$callcenter->name=$leads->title;
$callcenter->save();
}
}
}
} 
 
    		
		
 
                          
                                                            	
$criteria = new CDbCriteria();        
//$criteria->addSearchCondition('date', $today, false);
$criteria->order = 'id DESC';
$criteria->addCondition('lead_id IS  NULL AND website IS NULL AND callcenter IS NULL ');

     $allleads = new CActiveDataProvider('FbLeadForm', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ), 
                                                                           'criteria' => $criteria,
                                                            ));
                                   


 




		$this->render('allfbleads',array(
		'userid'=>$userid ,	
		'allleads'=>$allleads ,	
		'$array'=>$array ,
		'allfbleads'=>$allfbleads ,
		
		
		

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
		
		
		
		
			public function actionAllcallcenter()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");  
		$website = 1; 
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
 
 
$this->layout = '//layouts/systemcgridview';
 

$allcallcentergv=new FbLeadForm('callcenter');
$allcallcentergv->unsetAttributes();  // clear any default values
if(isset($_GET['callcenter'])){
$allcallcentergv->attributes=$_GET['callcenter'];
}

 
                                           	
$criteriax = new CDbCriteria(); 
$criteriax->order = 'id DESC';
//$criteriax->addSearchCondition('callcenter', $website, false);
$criteriax->addCondition('lead_id IS  NULL');

$allcallcenter= FbLeadForm::model()->findAll($criteriax);


if(!empty($allcallcenter)){
foreach($allcallcenter as $callcenter){	
$findlead=Leads::model()->findByAttributes(array('tel'=>$callcenter->tel));

if(!empty($findlead)){
$callcenter->lead_id=$findlead->id;
$callcenter->name=$findlead->title;
$callcenter->save();
}
}
} 
                          
                                                            	
$criteria = new CDbCriteria(); 
$criteria->order = 'id DESC';
$criteria->addSearchCondition('callcenter', $website, false);

$criteria->addCondition('lead_id IS  NULL');
//$criteria->addCondition('we IS  NULL');

     $allleads = new CActiveDataProvider('FbLeadForm', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ), 
                                                                           'criteria' => $criteria,
                                                            ));
                                   


 




		$this->render('callcenter',array(
		'userid'=>$userid ,	
		'allleads'=>$allleads ,	
		'$array'=>$array ,	
		'allcallcentergv'=>$allcallcentergv ,	
		

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
		
		
		
	

public function actionAssignfblead()
		{
			$userid=Yii::app()->user->id;

		if(Yii::app()->user->isMember()){
 
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s"); 
			
		if(isset($_POST['fblead'])){
 
				$fblead = FbLeadForm::model()->findByPk($_POST['fblead']);
				
				
				
				$phone=$fblead->tel;
				 
					$countrys = [
        						'44' => 'UK (+44)',
        						'213' => 'Algeria (+213)',
        						'376' => 'Andorra (+376)',
        						'244' => 'Angola (+244)',
        						'54' => 'Argentina (+54)',
        						'374' => 'Armenia (+374)',
        						'297' => 'Aruba (+297)',
        						'61' => 'Australia (+61)',
        						'43' => 'Austria (+43)',
        						'994' => 'Azerbaijan (+994)',
        						'973' => 'Bahrain (+973)',
        						'880' => 'Bangladesh (+880)',
        						'375' => 'Belarus (+375)',
        						'32' => 'Belgium (+32)',
        						'501' => 'Belize (+501)',
        						'229' => 'Benin (+229)',
        						'1441' => 'Bermuda (+1441)',
        						'975' => 'Bhutan (+975)',
        						'591' => 'Bolivia (+591)',
        						'387' => 'Bosnia Herzegovina (+387)',
        						'267' => 'Botswana (+267)',
        						'55' => 'Brazil (+55)',
        						'673' => 'Brunei (+673)',
        						'359' => 'Bulgaria (+359)',
        						'226' => 'Burkina Faso (+226)',
        						'257' => 'Burundi (+257)',
        						'855' => 'Cambodia (+855)',
        						'237' => 'Cameroon (+237)',
        						'238' => 'Cape Verde Islands (+238)',
        						'1345' => 'Cayman Islands (+1345)',
        						'236' => 'Central African Republic (+236)',
        						'56' => 'Chile (+56)',
        						'86' => 'China (+86)',
        						'57' => 'Colombia (+57)',
        						'269' => 'Comoros (+269)',
        						'242' => 'Congo (+242)',
        						'682' => 'Cook Islands (+682)',
        						'506' => 'Costa Rica (+506)','225' => 'Cote d Ivoire (+225)',
        						'385' => 'Croatia (+385)',
        						'53' => 'Cuba (+53)',
        						'90392' => 'Cyprus North (+90392)',
        						'357' => 'Cyprus South (+357)',
        						'42' => 'Czech Republic (+42)',
        						'45' => 'Denmark (+45)',
        						'253' => 'Djibouti (+253)',
        						'1809' => 'Dominica (+1809)',
        						'1809' => 'Dominican Republic (+1809)',
        						'593' => 'Ecuador (+593)',
        						'20' => 'Egypt (+20)',
        						'503' => 'El Salvador (+503)',
        						'240' => 'Equatorial Guinea (+240)',
        						'291' => 'Eritrea (+291)',
        						'372' => 'Estonia (+372)',
        						'251' => 'Ethiopia (+251)',
        						'500' => 'Falkland Islands (+500)',
        						'298' => 'Faroe Islands (+298)',
        						'679' => 'Fiji (+679)',
        						'358' => 'Finland (+358)',
        						'33' => 'France (+33)',
        						'594' => 'French Guiana (+594)',
        						'689' => 'French Polynesia (+689)',
        						'241' => 'Gabon (+241)',
        						'220' => 'Gambia (+220)',
        						'7880' => 'Georgia (+7880)',
        						'49' => 'Germany (+49)',
        						'233' => 'Ghana (+233)',
        						'350' => 'Gibraltar (+350)',
        						'30' => 'Greece (+30)',
        						'299' => 'Greenland (+299)',
        						'1473' => 'Grenada (+1473)',
        						'590' => 'Guadeloupe (+590)',
        						'671' => 'Guam (+671)',
        						'502' => 'Guatemala (+502)',
        						'224' => 'Guinea (+224)',
        						'245' => 'Guinea - Bissau (+245)',
        						'592' => 'Guyana (+592)',
        						'509' => 'Haiti (+509)',
        						'504' => 'Honduras (+504)',
        						'852' => 'Hong Kong (+852)',
        						'36' => 'Hungary (+36)',
        						'354' => 'Iceland (+354)',
        						'91' => 'India (+91)',
        						'62' => 'Indonesia (+62)',
        						'98' => 'Iran (+98)',
        						'964' => 'Iraq (+964)',
        						'353' => 'Ireland (+353)',
        						'39' => 'Italy (+39)',
        						'1876' => 'Jamaica (+1876)',
        						'81' => 'Japan (+81)',
        						'962' => 'Jordan (+962)',
        						'7' => 'Kazakhstan (+7)',
        						'254' => 'Kenya (+254)',
        						'686' => 'Kiribati (+686)',
        						'850' => 'Korea North (+850)',
        						'82' => 'Korea South (+82)',
        						'965' => 'Kuwait (+965)',
        						'996' => 'Kyrgyzstan (+996)',
        						'856' => 'Laos (+856)',
        						'371' => 'Latvia (+371)',
        						'961' => 'Lebanon (+961)',
        						'266' => 'Lesotho (+266)',
        						'231' => 'Liberia (+231)',
        						'218' => 'Libya (+218)',
        						'417' => 'Liechtenstein (+417)',
        						'370' => 'Lithuania (+370)',
        						'352' => 'Luxembourg (+352)',
        						'853' => 'Macao (+853)',
        						'389' => 'Macedonia (+389)',
        						'261' => 'Madagascar (+261)',
        						'265' => 'Malawi (+265)',
        						'60' => 'Malaysia (+60)',
        						'960' => 'Maldives (+960)',
        						'223' => 'Mali (+223)',
        						'356' => 'Malta (+356)',
        						'692' => 'Marshall Islands (+692)',
        						'596' => 'Martinique (+596)',
        						'222' => 'Mauritania (+222)',
        						'269' => 'Mayotte (+269)',
        						'52' => 'Mexico (+52)',
        						'691' => 'Micronesia (+691)',
        						'373' => 'Moldova (+373)',
        						'377' => 'Monaco (+377)',
        						'976' => 'Mongolia (+976)',
        						'1664' => 'Montserrat (+1664)',
        						'258' => 'Mozambique (+258)',
        						'95' => 'Myanmar (+95)',
        						'264' => 'Namibia (+264)',
        						'674' => 'Nauru (+674)',
        						'977' => 'Nepal (+977)',
        						'31' => 'Netherlands (+31)',
        						'687' => 'New Caledonia (+687)',
        						'64' => 'New Zealand (+64)',
        						'505' => 'Nicaragua (+505)',
        						'227' => 'Niger (+227)',
        						'234' => 'Nigeria (+234)',
        						'683' => 'Niue (+683)',
        						'672' => 'Norfolk Islands (+672)',
        						'670' => 'Northern Marianas (+670)',
        						'47' => 'Norway (+47)',
        						'968' => 'Oman (+968)',
        						'680' => 'Palau (+680)',
        						'507' => 'Panama (+507)',
        						'675' => 'Papua New Guinea (+675)',
        						'595' => 'Paraguay (+595)',
        						'51' => 'Peru (+51)',
        						'63' => 'Philippines (+63)',
        						'48' => 'Poland (+48)',
        						'351' => 'Portugal (+351)',
        						'1787' => 'Puerto Rico (+1787)',
        						'974' => 'Qatar (+974)',
        						'262' => 'Reunion (+262)',
        						'40' => 'Romania (+40)',
        						'7' => 'Russia (+7)',
        						'250' => 'Rwanda (+250)',
        						'378' => 'San Marino (+378)',
        						'239' => 'Sao Tome & Principe (+239)',
        						'966' => 'Saudi Arabia (+966)',
        						'221' => 'Senegal (+221)',
        						'381' => 'Serbia (+381)',
        						'248' => 'Seychelles (+248)',
        						'232' => 'Sierra Leone (+232)',
        						'65' => 'Singapore (+65)',
        						'421' => 'Slovak Republic (+421)',
        						'386' => 'Slovenia (+386)',
        						'677' => 'Solomon Islands (+677)',
        						'252' => 'Somalia (+252)',
        						'27' => 'South Africa (+27)',
        						'34' => 'Spain (+34)',
        						'94' => 'Sri Lanka (+94)',
        						'290' => 'St. Helena (+290)',
        						'1869' => 'St. Kitts (+1869)',
        						'1758' => 'St. Lucia (+1758)',
        						'249' => 'Sudan (+249)','211' => 'South Sudan (+211)',
        						'597' => 'Suriname (+597)',
        						'268' => 'Swaziland (+268)',
        						'46' => 'Sweden (+46)',
        						'41' => 'Switzerland (+41)',
        						'963' => 'Syria (+963)',
        						'886' => 'Taiwan (+886)',
        						'7' => 'Tajikstan (+7)',
        						'66' => 'Thailand (+66)',
        						'228' => 'Togo (+228)',
        						'676' => 'Tonga (+676)',
        						'1868' => 'Trinidad & Tobago (+1868)',
        						'216' => 'Tunisia (+216)',
        						'90' => 'Turkey (+90)',
        						'7' => 'Turkmenistan (+7)',
        						'993' => 'Turkmenistan (+993)',
        						'1649' => 'Turks & Caicos Islands (+1649)',
        						'688' => 'Tuvalu (+688)',
        						'256' => 'Uganda (+256)',
        						'380' => 'Ukraine (+380)',
        						'971' => 'United Arab Emirates (+971)',
        						'598' => 'Uruguay (+598)',
        						'7' => 'Uzbekistan (+7)',
        						'678' => 'Vanuatu (+678)',
        						'379' => 'Vatican City (+379)',
        						'58' => 'Venezuela (+58)',
        						'969' => 'Yemen (North)(+969)',
        						'967' => 'Yemen (South)(+967)',
        						'260' => 'Zambia (+260)',
        						'263' => 'Zimbabwe (+263)',
        					];
        
        					$temp=  substr(strstr($phone, '+'),1);
        					if($temp != false){$phone=$temp;}
        					$countrycode='';
        					// sort the array by key, descending
        					krsort($countrys, SORT_NUMERIC);
        
        					// iterate over all countries
        					foreach($countrys as $we => $ccode){
        						// if number begins with current number
        						if(strpos($phone, '' . $we) === 0){
        							// store country code and break the loop
        							$countrycode = $we;
        							break;
        						}
        					}
        
        					if(!empty($countrycode)){
        						$size=strlen($countrycode);
        						$phone=substr($phone,$size);
        					}else{$countrycode=20;} 
        					
        					
        					
        					
        					
        						if(!empty($phone)){
							$criteriaduplecat1= new CDbCriteria(); 
							$criteriaduplecat1->addSearchCondition('tel', $phone, false , 'OR');
							$criteriaduplecat1->addSearchCondition('second_tel', $phone, false , 'OR');
							$criteriaduplecat1->addSearchCondition('tel3', $phone, false , 'OR');
							$criteriaduplecat1->addSearchCondition('tel4', $phone, false , 'OR');
						    $allduplecat1= Leads::model()->findAll($criteriaduplecat1);
                            }
                            
                            
                            
                            
                             if(!empty($email)){
							$criteriaduplecatemail= new CDbCriteria(); 
							$criteriaduplecatemail->addSearchCondition('email', $fblead->email, false , 'OR');
						    $allduplecatemail= Leads::model()->findAll($criteriaduplecatemail);
						    }
							
							
							
							if(!empty($fbid)){	
							$criteriaduplecatfb= new CDbCriteria(); 
							$criteriaduplecatfb->addSearchCondition('facebook_id', $fblead->fb_id, false , 'OR');
						    $allduplecatfb= Leads::model()->findAll($criteriaduplecatfb);
							}
        					
        					


		                    
						
							
						if(empty($allduplecat1 OR $allduplecatemail OR $allduplecatfb )){
			//	var_dump('test');exit;
 
 			$userid=Yii::app()->user->id;

                                                            $model = new Leads();
                                                            $model->user_id = $userid;
                                                            $model->time = $time;
                                                            $model->dtime = $time;
                                                            $model->date = $today;
                                                            $model->feedback_date = $today;
                                                            $model->communicate_date = $today;
                                                            $model->hidden = 1;
                                                            $model->strategy_id = 1;
                                                            $model->user_marketing = 1;
                                                            $model->title = $fblead->name;
                                                            $model->facebook_id = $fblead->fb_id;
                                                            $model->notes = $fblead->note;
                                                            $model->tel = $phone;
                                                            //$model->career = $_POST['job'];
                                                            $model->career = $fblead->job;
                                                            $model->email = $fblead->email;
        							                    	$model->international_code = $countrycode;
                                                            $model->user_sales = $_POST['user'];
                                                            $model->fresh_sales = $_POST['user'];
                                                            $model->campaign_id = $_POST['campaign'];
                                                            $model->platform_id = $_POST['platform'];
                                                            $model->platformchild_id = $_POST['platformchild'];
                                                            $model->project_id = $_POST['projects'];
                                                            $model->unit_type = $_POST['type'];
                                                            $model->avtocall = $_POST['callingtime'];
                                                            $model->property_type = $_POST['typeunit'];


                                                            $model->title = $_POST['title'];
                                                            
                                                            if(empty($allduplecat1 OR $allduplecatemail OR $allduplecatfb )){
                                                             $model->user_marketing = $_POST['marketing'];
                                                             if(!empty($_POST['marketing'])){
                                                             $model->user_id = $_POST['marketing'];
                                                             }else{
                                                                                                                          $model->user_id = $userid;
   
                                                             }
                                                             
                                                            }
                                                            
                                                            ///////////////branch////////////
                                                            $main=Mainsettings::model()->findByPk(1);
                                                            if(!empty($main->default_branch) AND empty($model->branch))$model->branch=$main->default_branch;
                                                            ///////////////branch////////////
                                                            
                                                            
                                                            if($model->save()){
                                                                $model->secert=$model->id;
                                                                $model->save();
                                                                $fblead->lead_id=$model->id;
                                                                $fblead->save();
                                                            }
                                                            
                                                            
                                                            
                                                            
if(!$model->save()){
$err = $model->getErrors();
var_dump($err);exit;
}
                                                            
                                                            
							}
 


		$this->redirect(array('login/allfblead')	);
  




            }

		}
	}
	
		
		




public function actionWebhook()
		{
		    
$main=Mainsettings::model()->findByPk(1);
$password = $_GET['password'];

//var_dump($main->apicode);exit;



if($main->apicode == $password){

$name=$_GET['name'];
$email=$_GET['email'];
$tel=$_GET['tel'];
$tel2=$_GET['tel2'];
$ad_name=$_GET['ad_name'];
$adset_name=$_GET['adsetname'];
$fb_id=$_GET['fb_id'];
$ad_id=$_GET['ad_id'];
$job=$_GET['job'];
$campaign_name=$_GET['campaign_name'];
$campaign_id=$_GET['campaign_id'];
$form_id=$_GET['form_id'];
$note=$_GET['note'];
$today = date("Y-m-d");                    // 03.10.01
$time = date("H:i:s");  
$website = $_GET['website']; 
$typeunit = $_GET['typeunit'];
$unitsize = $_GET['unitsize'];
$callingtime = $_GET['callingtime'];
$formlocation = $_GET['formlocation'];

$city = $_GET['city'];
$address = $_GET['address'];
$nationality = $_GET['nationality'];
$budget = $_GET['budget'];
$country = $_GET['country'];
$numberofrooms = $_GET['numberofrooms'];
$clienttype = $_GET['clienttype'];
$support = $_GET['support'];
$banktype = $_GET['banktype'];
$typeofproperty = $_GET['typeofproperty'];
$purchasemethod = $_GET['purchasemethod'];






$model = new FbLeadForm(); 
 


  
		$model->name= $name;
		$model->email= $email;
		$model->tel= $tel;
		$model->tel2= $tel2;
		$model->ad_name= $ad_name;
		$model->adset_name= $adset_name;
		$model->fb_id= $fb_id;
		$model->ad_id= $ad_id;
		$model->job= $job;
		$model->campaign_name= $campaign_name;
		$model->campaign_id= $campaign_id;
		$model->form_id= $form_id;
		$model->note= $note;
		$model->date= $today;
		$model->time= $time;
		$model->website= $website;
		$model->typeunit= $typeunit;
		$model->unitsize= $unitsize;
		$model->callingtime= $callingtime;
		$model->formlocation= $formlocation;
		
		$model->city= $city;
		$model->address= $address;
		$model->nationality= $nationality;
		$model->budget= $budget;
		$model->country= $country;
		$model->numberofrooms= $numberofrooms;
		$model->clienttype= $clienttype;
		$model->support= $support;
		$model->banktype= $banktype;
		$model->typeofproperty= $typeofproperty;
		$model->purchasemethod= $purchasemethod;

		//$model->password= $website;
		if(!$model->save()){
		    var_dump($model->getErrors());
		}

}else{
    
    
var_dump('Password Error');   
    
}

}



public function actionCilcompanies()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		$allstatues=CilCompany::model()->findAll();
		$allcategory=CilCategory::model()->findAll();
		
		$model = new CilCompany();
		$model->setScenario('com_porfile');
		if (isset($_POST['CilCompany'])) {

if(!empty($_POST['secert']))
  $model = CilCompany::model()->findByPk($_POST['secert']);


 
		$rnd = rand(0,9999);
		//$model->user_id = $userid;
		$model->date = $today;
		$model->time = $time;
		$model->name = $_POST['CilCompany']['name'];
		$model->number = $_POST['CilCompany']['number'];
		$model->commission = $_POST['CilCompany']['commission'];
		$model->renewal_days= $_POST['CilCompany']['renewal_days'];
		$model->email= $_POST['CilCompany']['email'];

 


$model->body=$_POST['CilCompany']['body'];

$old=$model->header; 
              $uploadedFile=CUploadedFile::getInstance($model,'header');
	       if(! empty ($uploadedFile)){
	       $fileName = "{$rnd}-{$uploadedFile}";  // random number + file name
	       $model->header = $fileName;
	       $uploadedFile->saveAs(Yii::app()->basePath.'/../uploads/'.$fileName);
	       
	       }else{
$model->header=$old;
}



$old=$model->footer;
              $uploadedFile=CUploadedFile::getInstance($model,'footer');
	       if(! empty ($uploadedFile)){
	       $fileName = "{$rnd}-{$uploadedFile}";  // random number + file name
	       $model->footer = $fileName;
	       $uploadedFile->saveAs(Yii::app()->basePath.'/../uploads/'.$fileName);
	       
	       }else{
$model->footer=$old;
}

$select=$_POST['category'];
$select=implode(", ", $select);
$model->category_ids=$select;

		if ($model->save()) {

                

		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User Create CIL Company';
		$logsystem->action_id = $model->id;
		$logsystem->ip = $model->id;
        $logsystem->secert = $model->id;
		$logsystem->user_id = $userid;
		$logsystem->save();


		Yii::app()->controller->refresh();
		}
		}

		
		
		
	
		$this->render('cilcompany',array(
		'userid'=>$userid ,	
                'model'=>$model,	
                'allstatues'=>$allstatues,
                'allcategory'=>$allcategory,			
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
		
		
		
		
		
		


















public function actionLogleads()
		{
		if(Yii::app()->user->isMember())
		{

                	    $this->layout = '//layouts/systemcgridview';

		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		

	

$alllog=new Leadslog('search');
$alllog->unsetAttributes();  // clear any default values
if(isset($_GET['search'])){
$alllog->attributes=$_GET['search'];
}


		
		
		
	
		$this->render('logleads',array(
		'userid'=>$userid ,	
        'alllog'=>$alllog,	 

		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}




public function actionLogaction()
		{
		if(Yii::app()->user->isMember())
		{

                	    $this->layout = '//layouts/systemcgridview';

		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		

	

$alllog=new Logsystem('search');
$alllog->unsetAttributes();  // clear any default values
if(isset($_GET['search'])){
$alllog->attributes=$_GET['search'];
}


		
		
		
	
		$this->render('Logaction',array(
		'userid'=>$userid ,	
        'alllog'=>$alllog,	 

		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
	

public function actionCilcategory()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		$allcategory=CilCategory::model()->findAll();
		
		$model = new CilCategory();
		$model->setScenario('com_porfile');
		if (isset($_POST['CilCategory'])) {

if(!empty($_POST['secert']))
  $model = CilCategory::model()->findByPk($_POST['secert']);


 
		$rnd = rand(0,9999); 
		$model->title= $_POST['CilCategory']['title'];

 
  
		if ($model->save()) {

                

		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User Create InventoryPlaces ';
		$logsystem->action_id = $model->id;
		$logsystem->ip = $model->id;
        $logsystem->secert = $model->id;
		$logsystem->user_id = $userid;
		$logsystem->save();


		Yii::app()->controller->refresh();
		}
		}

		
		
		
	
		$this->render('cilcategory',array(
		'userid'=>$userid ,	
                'model'=>$model,	 
                'allcategory'=>$allcategory,			
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}

	



public function actionCilconfirm()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		//$allcategory=CilCategory::model()->findAll();
		
		
$criteria = new CDbCriteria;
$criteria->addCondition('done is NULL');
$allcillog = CilLog::model()->findAll($criteria);
	

		
		
		
	
		$this->render('cilconfirm',array(
		'userid'=>$userid ,	
         'allcillog'=>$allcillog,			
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}

	
		
	


public function actionTransferconfirm()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		//$allcategory=CilCategory::model()->findAll();
		
		
$criteria = new CDbCriteria;
$criteria->order = 'id DESC';
//$criteria->addCondition('done is NULL');
$alltransferaction = Transferaction::model()->findAll($criteria);
	

		
		
		
	
		$this->render('transferconfirm',array(
		'userid'=>$userid ,	
         'alltransferaction'=>$alltransferaction,			
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}		
	
	
	
	
	
	
	
public function actionExportconfirm()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		//$allcategory=CilCategory::model()->findAll();
		
		
$criteria = new CDbCriteria;
$criteria->order = 'id DESC';
//$criteria->addCondition('done is NULL');
$allexportxlxs = Exportxlxs::model()->findAll($criteria);
	

		
		
		
	
		$this->render('exportconfirm',array(
		'userid'=>$userid ,	
         'allexportxlxs'=>$allexportxlxs,			
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}		
	



public function actionCilsettings(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);		
		
			$this->render('cilsettings',array(
					'userid'=>$userid ,	
       

				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);		}

	}








public function actionCilsend(){
	if(Yii::app()->user->isMember()){
		$userid=Yii::app()->user->id;
		$user=User::model()->findByPk($userid);
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		$main=Mainsettings::model()->findByPk(1);
			$lead=Leads::model()->findByPk($_POST['secert']);

			 

 
		
		if(isset($_POST['company'])){
			

			foreach($_POST['company'] as $comp){

				$company=CilCompany::model()->findByPk($comp);

				
				
				$user=User::model()->findByPk($userid);

				//$mpdf= Yii::app()->ePdf->mpdf('ar-s');
				//$mpdf->autoLangToFont = false;
				//$mpdf->autoArabic = false;
				//$mpdf->charset_in='utf-8';

		  


				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$main=Mainsettings::model()->findByPk(1);		    
				
					$newmodel= new CilLog();
					$newmodel->date=$today;
					$newmodel->userid=$userid;
					$newmodel->time=$time;
					$newmodel->profile_id=$_POST['secert'];
					$newmodel->company_id=$comp;
					$newmodel->renewaldate= date('Y-m-d', strtotime($Date. ' + '.$company->renewal_days.' days'));; 
					$newmodel->save();
					
					
					if(!$newmodel->save()){
					$errores = $newmodel->getErrors();
					var_dump($errores);exit;
				}
					
			
			}

                         $this->redirect(array('leads/profile/'.$lead->id), false);
                        //Yii::app()->getController()->redirect(array('leads/profile/'.$lead->id));
		}
		
	 
  
		 
	}


	else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
	}

}





	
	

                                     
	public function actionLogout(){
		Yii::app()->user->logout();
		$this->redirect(array('home/index')	);
	}
	
	
	

		
	
	
	
	



	public function actionSearchrecorder(){
	    if(Yii::app()->user->isMember()){
		$userid=Yii::app()->user->id;
		if(isset($_GET['Search'])){


			$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
		
			if(!empty($_GET['Search']['user']))
			$criteria->addSearchCondition('user_sales', $_GET['Search']['user'],false, "AND");
			$criteria->addSearchCondition('file', $_GET['Search']['file'],true, "AND");

			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');




            $allrecordercount=Recorder::model()->count($criteria);



			$allrecorder = new CActiveDataProvider('Recorder', array(
					'pagination' => array(
						'pageSize' =>50,
					),
					'criteria' => $criteria,
				));

	
		} 
		
		



		$this->render('allrecorder', array(
						
				'userid' => $userid,					
				'allrecorder' => $allrecorder,
				'allrecordercount' => $allrecordercount,			

				
      

											
			));
			
			
	    }else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
			
	}


	
	
	
	
	
	
	
	



	
	public function actionWhatsapp()
		{
		if(Yii::app()->user->isMember())
		{
		    
		    
		    	
	

		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
		$allwhatsapp=Whatsapp::model()->findAll(array('condition'=>'user_id='.$userid));


    	$model = new Whatsapp();
		$model->setScenario('com_porfile');
		if (isset($_POST['Whatsapp'])) {
		$rnd = rand(0,9999);
		$model->attributes = $_POST['Whatsapp'];
		$model->date = $today;
		$model->time = $time;
		$model->user_id = $userid;

		if ($model->save()) {
		    		Yii::app()->controller->refresh();

		    
		}

}



		$this->render('whatsapp',array(
		'userid'=>$userid ,	
	    'model'=>$model ,	
	    'allwhatsapp'=>$allwhatsapp ,	


		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
			
	
	
	
	
	
		public function  actionConfirmroutaian($id){

		if(Yii::app()->user->isMember()){
			$model=Requestroutation::model()->findByPk($id);
		
			
			$lead = Leads::model()->findByAttributes(array('id'=>$model->lead_id));
		//	var_dump($lead);exit;
			if(!empty($lead)){
                  //var_dump($lead);exit;
    		      $lead->unseenauto=$lead->user_sales;
    		      $lead->dtime=$time;
    		      $lead->user_integration=NULL;
    		      $lead->communication=NULL;
    		      $lead->user_sales=NULL;
                  $lead->receipt=1;

                
                if(!$lead->save()){
                var_dump($lead->getErrors());
                exit;
                }
					
					

                    
                    
                    if($lead->save()){
                    
                     $criteriaact = new CDbCriteria; 
                        $criteriaact->addCondition('leads_id=' . $lead->id);
                        $allactivities=Activities::model()->findAll($criteriaact);
                        if(!empty($allactivities)){
                                foreach($allactivities as $activity){
                                $activity->close=1;
                                //$activity->hidden=1;
                                    if(empty($activity->report)){
                                    $activity->report='request Routaion'.$today;
                                    }
                                  $activity->save();
                                }
                        }

                    
                    }
                    
}
			
			
			 if($lead->save()){
					$model->done = 1;
					$model->save();
					$this->redirect(array('reroutian')	);
						//Yii::app()->controller->refresh();
}
			
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	public function  actionDeletewhatsapp($id){

		if(Yii::app()->user->isMember()){
			$model=Whatsapp::model()->findByPk($id);
			
					$model->delete();
					$this->redirect(array('whatsapp')	);
						//Yii::app()->controller->refresh();

			
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
	
		
	public function  actionDeletex(){


$_POST['lead'];
//$_POST['reason'];
//var_dump($_POST['reason']);exit;

		if(Yii::app()->user->isMember()){
			$model=FbLeadForm::model()->findByPk($_POST['lead']);
			$model->lead_id=0;
			$model->reason=$_POST['reason'];
					$model->save();
					
					
					
						$this->redirect(array('login/allcallcenter')	);
					
					//$this->redirect(array($_POST['url'])	);
						//Yii::app()->controller->refresh();

			
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
	
	
	
	
	
	
		public function actionAllcatchleads()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
$criteria = new CDbCriteria();        
//$criteria->addSearchCondition('date', $today, false);
//$criteria->addCondition('user_sales IS NOT NULL');




$allleads = Leadstwo::model()->findAll($criteria);


     $allleads = new CActiveDataProvider('Leadstwo', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));





		$this->render('allcatchleads',array(
		'userid'=>$userid ,	
		'allleads'=>$allleads ,	
		'$array'=>$array ,			

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
	
	
	
	public function actionDailyfeedbacklist()
		{
		if(Yii::app()->user->isMember())
		{


		    $this->layout = '//layouts/systemcgridview';
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
		
$criteria = new CDbCriteria();
$criteria->order = 'id DESC';
$close = 1;
$today = date('Y-m-d');
$criteria->addSearchCondition('feedback_date', $today, false);
$criteria->addSearchCondition('feedback', $close, false);

$allleads = Leads::model()->findAll($criteria);


     $allleads = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));





		$this->render('dailyfeedbacklist',array(
		'userid'=>$userid ,	
		'allleads'=>$allleads ,	
		'$array'=>$array ,			

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
		
		
		
		
		
		
		



	
	public function actionBacktolifelistallwaiting()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
		
$criteria = new CDbCriteria();
$criteria->order = 'feedback_date DESC';
$close = 1;


$start = '2019-01-01';
$end = date('Y-m-d');

$criteria->addBetweenCondition("feedback_date",$start,$end);
$criteria->addSearchCondition('feedback', $close, false);
$criteria->addSearchCondition('backtolife', $close, false);
$criteria->addCondition('backtolifetransfer IS NULL');

if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}elseif($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}
if($_GET['indirect']==1){
$criteria->addCondition('indirect IS NOT NULL');
}elseif($_GET['indirect']==2){
$criteria->addCondition('indirect IS NULL');
}


$allleads = Leads::model()->findAll($criteria);


     $allleads = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));





		$this->render('backtolifelistallwaiting',array(
		'userid'=>$userid ,	
		'allleads'=>$allleads ,	
		'$array'=>$array ,			

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
		


		
	
	public function actionBacktolifelistall()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
		
$criteria = new CDbCriteria();
$criteria->order = 'feedback_date DESC';
$close = 1;


$start = '2019-01-01';
$end = date('Y-m-d');

$criteria->addBetweenCondition("feedback_date",$start,$end);
$criteria->addSearchCondition('feedback', $close, false);
$criteria->addSearchCondition('backtolife', $close, false);

$allleads = Leads::model()->findAll($criteria);


     $allleads = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));





		$this->render('backtolifelistall',array(
		'userid'=>$userid ,	
		'allleads'=>$allleads ,	
		'$array'=>$array ,			

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
		
		
		
	
	public function actionBacktolifelistmonth()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
		
$criteria = new CDbCriteria();
$criteria->order = 'id DESC';
$close = 1;
$start = date('Y-m-01');
$end = date('Y-m-30');
$criteria->addBetweenCondition("feedback_date",$start,$end);
$criteria->addSearchCondition('feedback', $close, false);
$criteria->addSearchCondition('backtolife', $close, false);

$allleads = Leads::model()->findAll($criteria);


     $allleads = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>100,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));





			
if(isset($_POST['downloadexcel'])){
    

$criteria2 = new CDbCriteria();
$criteria2->order = 'id DESC';
$close = 1;
$start = date('Y-m-01');
$end = date('Y-m-30');
$criteria2->addBetweenCondition("feedback_date",$start,$end);
$criteria2->addSearchCondition('feedback', $close, false);
$criteria2->addSearchCondition('backtolife', $close, false);

$allleadss = Leads::model()->findAll($criteria2);
    
    
    
ini_set('max_execution_time', 300);
ini_set('memory_limit', '-1');
foreach($allleadss as $data){
$data->user_id = $data->employee->fname." ".$data->employee->lname;

$data->user_sales = $data->sales->fname." ".$data->sales->lname;
$data->status= $data->statuesaction->title;
$data->substatus= $data->substatusaction->title;

$data->platform_id= $data->platform->title;
$data->interest_id= $data->place->title;
$data->branch= $data->branchtitle->title;

$data->tel= $data->international_code.$data->tel;
$data->campaign_id= $data->campaign->title;
if($data->visit == 1){
$data->visit = 'visit';
}
                    
                    
if($data->international_code == 20){
$data->international_code = 'Local';
}else{

$data->international_code = 'Global';    

}

}




$fields = array('id','title','campaign_id'
,'tel','user_id','date','user_sales','notes','communicate_date','status','substatus','visit','sales_report','platform_id','interest_id','feedback_report','branch','details','facebook_id','adsetname','adname','career','international_code');
$labels= array('id','title','campaign_id'
,'tel','user_id','date','user_sales','notes','communicate_date','status','substatus','visit','sales_report','platform_id','interest_id','feedback_report','branch','details','facebook_id','adsetname','adname','career','international_code');
XlsExporter2::downloadXls('SOLID Feedback XLS', $allleadss, 'Report-', TRUE  , $labels  , $fields, 'COUNT');

}



		$this->render('backtolifelistmonth',array(
		'userid'=>$userid ,	
		'allleads'=>$allleads ,	
		'$array'=>$array ,			

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
			
		
	
		
	
	public function actionbacktolifelist()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
		
$criteria = new CDbCriteria();
$criteria->order = 'id DESC';
$close = 1;
$today = date('Y-m-d');
$criteria->addSearchCondition('feedback_date', $today, false);
$criteria->addSearchCondition('feedback', $close, false);
$criteria->addSearchCondition('backtolife', $close, false);

$allleads = Leads::model()->findAll($criteria);


     $allleads = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));





		$this->render('backtolifelist',array(
		'userid'=>$userid ,	
		'allleads'=>$allleads ,	
		'$array'=>$array ,			

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
		
		









	public function actionAllrecorderteamleader()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
		
		$allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
$arr=array();

			foreach($allemployee as $leader){
				$arr[]=$leader->sales_id;
			} 
			
		
		
		
     $criteria = new CDbCriteria(); 
     $criteria->order = 'id DESC';
     $criteria->addInCondition('user_sales', $arr);

     //$criteria->addCondition('user_sales IS NOT NULL');
     //$allrecorder = Recorder::model()->findAll($criteria); 

	




     $allrecorder = new CActiveDataProvider('Recorder', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));





		$this->render('allrecorder',array(
		'userid'=>$userid ,	
		'allrecorder'=>$allrecorder ,	
		'$array'=>$array ,			

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		



	
	
	
	public function actionAllrecorder()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
		
		
     $criteria = new CDbCriteria(); 
     $criteria->order = 'id DESC';

     //$criteria->addCondition('user_sales IS NOT NULL');
     //$allrecorder = Recorder::model()->findAll($criteria); 

	




     $allrecorder = new CActiveDataProvider('Recorder', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));





		$this->render('allrecorder',array(
		'userid'=>$userid ,	
		'allrecorder'=>$allrecorder ,	
		'$array'=>$array ,			

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
		
		
		
		
		
		
		
	public function actionCatchLeads()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
		
		
		$criterialead = new CDbCriteria;
													$criterialead->select="tel";
$criterialead->addSearchCondition('t.check', 3, false , 'AND');
													$criterialead->distinct=true; 
													


     $allrecorderlead = new CActiveDataProvider('Recorder', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criterialead,
                                                            ));
													
													
													
		
     $criteria = new CDbCriteria(); 
     $criteria->order = 'id DESC';
$criteria->condition = "user_sales IS NULL ";      

     //$criteria->addCondition('user_sales IS NOT NULL');
     //$allrecorder = Recorder::model()->findAll($criteria); 

	




     $allrecorder = new CActiveDataProvider('Recorder', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));





		$this->render('allrecorder',array(
		'userid'=>$userid ,	
		'allrecorderlead'=>$allrecorderlead ,
		'allrecorder'=>$allrecorder ,	
		'$array'=>$array ,			

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
		
		
	
	
	
		
		
		
	public function actionCatchLeadslead()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
		
		
		$criterialead = new CDbCriteria;
													$criterialead->select="tel";
$criterialead->addSearchCondition('t.check', 3, false , 'AND');
													$criterialead->distinct=true; 
													


     $allrecorderlead = new CActiveDataProvider('Recorder', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criterialead,
                                                            ));
													
													
													 





		$this->render('allrecoderlead',array(
		'userid'=>$userid ,	
		'allrecorderlead'=>$allrecorderlead , 	
		'$array'=>$array ,			

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
		
		
	
	
public function actionRecordsales()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

	


if(isset($_POST['file'])){

$array=array();
foreach (glob( Yii::getPathOfAlias('webroot')."/recording/*.mp3") as $filename) {
if (strpos($filename, '/'.$_POST['file']) !== false) {
    $array[]=$_POST['file'] ;
}
    
  }	
//var_dump($array);exit;

                 }
                 
                 
            

	
	
	
	
	
	
$criteria = new CDbCriteria();             
$criteria->addSearchCondition('date', $today, false);
$criteria->addSearchCondition('user_sales', $userid, false);


$allrecorder = new CActiveDataProvider('Recorder', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));

		
		



		$this->render('recordsales',array(
		'userid'=>$userid ,			
		'array'=>$array ,	
		'allrecorder'=>$allrecorder ,	

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
			
	
public function actionRecordteamleader()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

	


if(isset($_POST['file'])){

$array=array();
foreach (glob( Yii::getPathOfAlias('webroot')."/recording/*.mp3") as $filename) {
if (strpos($filename, '/'.$_POST['file']) !== false) {
    $array[]=$_POST['file'] ;
}
    
  }	
//var_dump($array);exit;

                 }


		$this->render('recordteamleader',array(
		'userid'=>$userid ,			
		'$array'=>$array ,			

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
		



	
public function actionRecord()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

	


if(isset($_POST['file'])){

$array=array();
foreach (glob( Yii::getPathOfAlias('webroot')."/recording/*.mp3") as $filename) {
if (strpos($filename, '/'.$_POST['file']) !== false) {
    $array[]=$_POST['file'] ;
}
    
  }	
//var_dump($array);exit;

                 }


		$this->render('record',array(
		'userid'=>$userid ,			
		'$array'=>$array ,			

		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}






public function actionCampaignresults()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		if(isset($_GET["campaignreport"])){
		    $teamleader = $_GET["teamleader"];
		     $type = $_GET["type"];
		     $startdate = $_GET["startdate"];
		     $enddate = $_GET["enddate"];
$model = Campaign::model()->findByPk($_GET["campaignreport"]);
}
		$this->render('campaignresults',array(
		'userid'=>$userid ,			
		'model'=>$model ,
		'teamleader'=>$teamleader ,
		'type'=>$type ,
		'startdate'=>$startdate ,
		'enddate'=>$enddate ,
		
                
		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}





public function actionResults()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
$id=$_POST['secert'];

if(isset($_POST['Results'])){
foreach((array)$_POST['Results'] as $num){

$newanswer=Answers::model()->findByPk($num[0]);
$newquestion=Questions::model()->findByPk($newanswer->question_id);
$newmodel = new Results();
					//$newmodel->user_id=$userid->id;
					$newmodel->date=$today ;
					$newmodel->time=$time;
					$newmodel->lead_id=$id;
					$newmodel->question_id=$newquestion->id;
					$newmodel->answer_id=$newanswer->id;								
					if(!$newmodel->save()){
						$errores = $newmodel->getErrors();
						//var_dump($errores);
					}
					else{

                

		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User Create result';
		$logsystem->action_id = $newmodel->id;
		$logsystem->ip = $newmodel->id;
                $logsystem->secert = $newmodel->id;
		$logsystem->user_id = $userid;
		$logsystem->save();
					}


}
}
		$this->redirect(array('marketing/leads/feedback')	);
	
		
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}





public function actionQuestions()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		$allstatues=Questions::model()->findAll();
		
		$model = new Questions();
		$model->setScenario('com_porfile');
		if (isset($_POST['Questions'])) {
		$rnd = rand(0,9999);
		$model->attributes = $_POST['Questions'];

		if ($model->save()) {

                

		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User Create Questions';
		$logsystem->action_id = $model->id;
		$logsystem->ip = $model->id;
        $logsystem->secert = $model->id;
		$logsystem->user_id = $userid;
		$logsystem->save();


		Yii::app()->controller->refresh();
		}
		}

		
		
		
		
		$this->render('questions',array(
		'userid'=>$userid ,	
                'model'=>$model,	
                'allstatues'=>$allstatues,			
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}






public function actionAddanswer($id)
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		$allstatues=Answers::model()->findAll(array('condition'=>'question_id='.$id));
		$question=Questions::model()->findByPk($id);
		$model = new Answers();
		$model->setScenario('com_porfile');
		if (isset($_POST['Answers'])) {
		$rnd = rand(0,9999);
		$model->attributes = $_POST['Answers'];
		$model->question_id= $id;

		if ($model->save()) {

                

		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User Create Questions';
		$logsystem->action_id = $model->id;
		$logsystem->ip = $model->id;
                $logsystem->secert = $model->id;
		$logsystem->user_id = $userid;
		$logsystem->save();


		Yii::app()->controller->refresh();
		}
		}

		
		
		
		
		$this->render('answers',array(
		'userid'=>$userid ,	
                'model'=>$model,	
                'allstatues'=>$allstatues,
                'question'=>$question,			
      
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}


public function  actionEditquestions(){

if(Yii::app()->user->isMember())
	{
$userid=Yii::app()->user->id;
	date_default_timezone_set('Africa/Cairo');  
	$today = date("Y-m-d");                     // 03.10.01
	$time = date("H:i:s");                      // 17:16:18	
	$rnd = rand(0,99999);
$id=$_POST['secert'];
$model=Questions::model()->findByPk($id);



$model->attributes = $_POST['Questions'];

if($model->save()){

$this->redirect(array('questions')	);
}else{
}



}
else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

}





public function  actionEditanswers(){

if(Yii::app()->user->isMember())
	{
$userid=Yii::app()->user->id;
	date_default_timezone_set('Africa/Cairo');  
	$today = date("Y-m-d");                     // 03.10.01
	$time = date("H:i:s");                      // 17:16:18	
	$rnd = rand(0,99999);
$id=$_POST['secert'];
$model=Answers::model()->findByPk($id);



$model->attributes = $_POST['Answers'];

if($model->save()){

$this->redirect(array('login/addanswer/'.$model->question_id)	);
}else{
}



}
else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

}

public function actionInventorydetails($secret)
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		$user=User::model()->findByPk($userid);
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		$inventory=Inventory::model()->findByAttributes(array('secret'=>$secret));
		$model=new Inventory() ;
		
		$allinventory=Inventory::model()->findAll(array('condition'=>'parent_id ='.$inventory->id));

		$allmat=InventoryTitles::model()->findAll();
		$allplac=InventoryPlaces::model()->findAll();
		$alldesign=Designbuilding::model()->findAll();
		$allsupp=Suppliers::model()->findAll();

		






if(isset($_POST['downloadpdf'])){

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');
				//$mpdf->autoLangToFont = false;
				//$mpdf->autoArabic = false;
				//$mpdf->charset_in='utf-8';

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('_inventory',array('inventory' => $inventory,'allinventory' => $allinventory,'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('search Result-');
				$mpdf1->SetAuthor("Brandshtine.");
				//$mpdf1->SetWatermarkText("");
				//$mpdf1->showWatermarkText = true;
				//$mpdf1->watermark_font = 'DejaVuSansCondensed';
				//$mpdf1->watermarkTextAlpha = 0.1;
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'Search Result.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}





		$model->setScenario('com_porfile');
		if (isset($_POST['Inventory'])AND isset($_POST['Inventory']['details'])) {
		$model->parent_id= $inventory->id;
		$model->user_id = $userid;
		$model->date = $today;
		$model->secret= $rnd;
		$model->design_id= $inventory->design_id;
		$model->building_id= $inventory->building_id;
		$model->attributes = $_POST['Inventory'];
		$model->supplier_id= $_POST['Inventory']['supplier_id'];

		if ($model->save()) { // var_dump($model->getErrors());exit;
                
                

		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User Create Inventory ';
		$logsystem->action_id = $model->id;
		$logsystem->ip = $model->id;
                $logsystem->secert = $model->id;
		$logsystem->user_id = $userid;
		$logsystem->save();


		Yii::app()->controller->refresh();
		}
		}

		
		
		
		
		$this->render('inventorydetails',array(
		'userid'=>$userid ,	
                'model'=>$model,	
                'allinventory'=>$allinventory,	
                'allmat'=>$allmat,
                'alldesign'=>$alldesign,
                'allplac'=>$allplac,	
                'inventory'=>$inventory,
                                'alldesign'=>$alldesign,
                                'allsupp'=>$allsupp,


                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
		
		
		public function actionShowinventorydetails($secret)
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		$user=User::model()->findByPk($userid);
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		$inventory=Inventory::model()->findByAttributes(array('secret'=>$secret));
		$model=new Inventory() ;
		
		$allinventory=Inventory::model()->findAll(array('condition'=>'parent_id ='.$inventory->id));

		$allmat=InventoryTitles::model()->findAll();
		$allplac=InventoryPlaces::model()->findAll();
		$alldesign=Designbuilding::model()->findAll();
		$allsupp=Suppliers::model()->findAll();

		






if(isset($_POST['downloadpdf'])){

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');
				//$mpdf->autoLangToFont = false;
				//$mpdf->autoArabic = false;
				//$mpdf->charset_in='utf-8';

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('_showinventory',array('inventory' => $inventory,'allinventory' => $allinventory,'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('search Result-');
				$mpdf1->SetAuthor("Brandshtine.");
				//$mpdf1->SetWatermarkText("");
				//$mpdf1->showWatermarkText = true;
				//$mpdf1->watermark_font = 'DejaVuSansCondensed';
				//$mpdf1->watermarkTextAlpha = 0.1;
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'Search Result.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}





		$model->setScenario('com_porfile');
		if (isset($_POST['Inventory'])AND isset($_POST['Inventory']['details'])) {
		$model->parent_id= $inventory->id;
		$model->user_id = $userid;
		$model->date = $today;
		$model->secret= $rnd;
		$model->design_id= $inventory->design_id;
		$model->building_id= $inventory->building_id;
		$model->attributes = $_POST['Inventory'];

		if (!$model->save()) { var_dump($model->getErrors());exit;
                
                

		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User Create Inventory ';
		$logsystem->action_id = $model->id;
		$logsystem->ip = $model->id;
                $logsystem->secert = $model->id;
		$logsystem->user_id = $userid;
		$logsystem->save();


		Yii::app()->controller->refresh();
		}
		}

		
		
		
		
		$this->render('showinventorydetails',array(
		'userid'=>$userid ,	
                'model'=>$model,	
                'allinventory'=>$allinventory,	
                'allmat'=>$allmat,
                'alldesign'=>$alldesign,
                'allplac'=>$allplac,	
                'inventory'=>$inventory,
                                'alldesign'=>$alldesign,
                                'allsupp'=>$allsupp,


                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}





public function actionInventory()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		$allinventory=Inventory::model()->findAll(array('condition'=>'parent_id is NULL','order'=>'id desc'));
		$alldesign=Designmaterials::model()->findAll(array('condition'=>'confirm=1'));
		$allbuilding= Building::model()->findAll();
		$suppliers=Suppliers::model()->findAll();
		
		$model = new Inventory();
		$model->setScenario('com_porfile');
		if (isset($_POST['Inventory'])) {
		$model->user_id = $userid;
		$model->date = $today;
		$model->secret= $rnd;
		if(!empty($_POST['Inventory']['design_id'])){
        $design= Designmaterials::model()->findByPk($_POST['Inventory']['design_id']);
		$model->building_id = $design->building_id;
		}
		$model->attributes = $_POST['Inventory'];
		$model->details = $_POST['Inventory']['details'];

		if ($model->save()) {
                
                

		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User Create Inventory ';
		$logsystem->action_id = $model->id;
		$logsystem->ip = $model->id;
                $logsystem->secert = $model->id;
		$logsystem->user_id = $userid;
		$logsystem->save();


		Yii::app()->controller->refresh();
		}
		}

		
		
		
		
		$this->render('inventory',array(
		'userid'=>$userid ,	
                'model'=>$model,	
                'allinventory'=>$allinventory,	
                'alldesign'=>$alldesign,	
                'allbuilding'=>$allbuilding,
                'suppliers'=>$suppliers,			
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}



public function actionParchasesvoucher()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		//$allinventory=Inventory::model()->findAll(array('condition'=>'parent_id is NULL','order'=>'id desc'));
		$alldesign=Designmaterials::model()->findAll(array('condition'=>'confirm=1'));
		$allbuilding= Building::model()->findAll();
		$suppliers=Suppliers::model()->findAll();
		
		$model = new Inventory();
		$model->setScenario('com_porfile');
		if (isset($_POST['Inventory'])) {
		$model->user_id = $userid;
		$model->date = $today;
		$model->secret= $rnd;
		 
		$model->attributes = $_POST['Inventory'];
		$model->details = $_POST['Inventory']['details'];

		if ($model->save()) {
                
                

		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User Create Inventory ';
		$logsystem->action_id = $model->id;
		$logsystem->ip = $model->id;
                $logsystem->secert = $model->id;
		$logsystem->user_id = $userid;
		$logsystem->save();


		Yii::app()->controller->refresh();
		}
		}

		
		
		
		
		$this->render('parchasesvoucher',array(
		'userid'=>$userid ,	
                'model'=>$model,	
                'allinventory'=>$allinventory,	
                'alldesign'=>$alldesign,	
                'allbuilding'=>$allbuilding,
                'suppliers'=>$suppliers,			
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}


public function actionRationcompleteness()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		//$allinventory=Inventory::model()->findAll(array('condition'=>'parent_id is NULL','order'=>'id desc'));
		$alldesign=Designmaterials::model()->findAll(array('condition'=>'confirm=1'));
		$allbuilding= Building::model()->findAll();
		$suppliers=Suppliers::model()->findAll();
		
		$model = new Inventory();
		$model->setScenario('com_porfile');
		if (isset($_POST['Inventory'])) {
		$model->user_id = $userid;
		$model->date = $today;
		$model->secret= $rnd;
		 
		$model->attributes = $_POST['Inventory'];
		$model->details = $_POST['Inventory']['details'];

		if ($model->save()) {
                
                

		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User Create Inventory ';
		$logsystem->action_id = $model->id;
		$logsystem->ip = $model->id;
                $logsystem->secert = $model->id;
		$logsystem->user_id = $userid;
		$logsystem->save();


		Yii::app()->controller->refresh();
		}
		}

		
		
		
		
		$this->render('rationcompleteness',array(
		'userid'=>$userid ,	
                'model'=>$model,	
                'allinventory'=>$allinventory,	
                'alldesign'=>$alldesign,	
                'allbuilding'=>$allbuilding,
                'suppliers'=>$suppliers,			
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}



public function actionColors()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		$allstatues=Colors::model()->findAll();
		
		$model = new Colors();
		$model->setScenario('com_porfile');
		if (isset($_POST['Colors'])) {
		$rnd = rand(0,9999); 
		$model->attributes = $_POST['Colors'];

		if ($model->save()) {

                

		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User Create Colors ';
		$logsystem->action_id = $model->id;
		$logsystem->ip = $model->id;
        $logsystem->secert = $model->id;
		$logsystem->user_id = $userid;
		$logsystem->save();


		Yii::app()->controller->refresh();
		}
		}

		
		
		
		
		$this->render('colors',array(
		'userid'=>$userid ,	
                'model'=>$model,	
                'allstatues'=>$allstatues,			
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}

public function actionInventorytitles()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		$allstatues=InventoryTitles::model()->findAll();
		
		$model = new InventoryTitles();
		$model->setScenario('com_porfile');
		if (isset($_POST['InventoryTitles'])) {
		$rnd = rand(0,9999);
		$model->user_id = $userid;
		$model->date = $today;
		$model->time = $time;
		$model->attributes = $_POST['InventoryTitles'];

		if ($model->save()) {

                

		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User Create InventoryTitles ';
		$logsystem->action_id = $model->id;
		$logsystem->ip = $model->id;
        $logsystem->secert = $model->id;
		$logsystem->user_id = $userid;
		$logsystem->save();


		Yii::app()->controller->refresh();
		}
		}

		
		
		
		
		$this->render('inventorytitles',array(
		'userid'=>$userid ,	
                'model'=>$model,	
                'allstatues'=>$allstatues,			
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}

public function actionInventoryplaces()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		$allstatues=InventoryPlaces::model()->findAll();
		
		$model = new InventoryPlaces();
		$model->setScenario('com_porfile');
		if (isset($_POST['InventoryPlaces'])) {
		$rnd = rand(0,9999);
		$model->user_id = $userid;
		$model->date = $today;
		$model->time = $time;
		$model->attributes = $_POST['InventoryPlaces'];

		if ($model->save()) {

                

		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User Create InventoryPlaces ';
		$logsystem->action_id = $model->id;
		$logsystem->ip = $model->id;
        $logsystem->secert = $model->id;
		$logsystem->user_id = $userid;
		$logsystem->save();


		Yii::app()->controller->refresh();
		}
		}

		
		
		
		
		$this->render('inventoryplaces',array(
		'userid'=>$userid ,	
                'model'=>$model,	
                'allstatues'=>$allstatues,			
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}















	public function  actionDeleteinventorydetails($id){

		if(Yii::app()->user->isMember()){
			$model=Inventory::model()->findByPk($id);
			
					$model->delete();
					$this->redirect(array('inventory')	);
						//Yii::app()->controller->refresh();

			
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}



	public function  actionDeleteinventorytitle($id){

		if(Yii::app()->user->isMember()){
			$model=InventoryTitles ::model()->findByPk($id);
			
					$model->delete();
					$this->redirect(array('login/inventorytitles')	);
				
			
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	public function  actionDeleteinventoryplace($id){

		if(Yii::app()->user->isMember()){
			$model=InventoryPlaces::model()->findByPk($id);
			
				
					$this->redirect(array('login/inventoryplaces')	);
				
			
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
	
	
	
	
	
	public function  actionEditinventorydetails(){

if(Yii::app()->user->isMember())
	{
$userid=Yii::app()->user->id;
	date_default_timezone_set('Africa/Cairo');  
	$today = date("Y-m-d");                     // 03.10.01
	$time = date("H:i:s");                      // 17:16:18	
	$rnd = rand(0,99999);
$id=$_POST['secert'];

$model=Inventory::model()->findByPk($id);



$model->attributes = $_POST['Inventory'];
$model->supplier_id = $_POST['Inventory']['supplier_id'];

if($model->save()){

$this->redirect(array('login/inventorydetails/'.$model->parent->secret)	);
}else{
}



}
else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

}

	






	
	
public function  actionEditinventorytitles(){

if(Yii::app()->user->isMember())
	{
$userid=Yii::app()->user->id;
	date_default_timezone_set('Africa/Cairo');  
	$today = date("Y-m-d");                     // 03.10.01
	$time = date("H:i:s");                      // 17:16:18	
	$rnd = rand(0,99999);
$id=$_POST['secert'];
$model=InventoryTitles ::model()->findByPk($id);



$model->attributes = $_POST['InventoryTitles'];

if($model->save()){

$this->redirect(array('inventorytitles')	);
}else{
}



}
else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

}



	
	
public function  actionEditcolors(){

if(Yii::app()->user->isMember())
	{
$userid=Yii::app()->user->id;
	date_default_timezone_set('Africa/Cairo');  
	$today = date("Y-m-d");                     // 03.10.01
	$time = date("H:i:s");                      // 17:16:18	
	$rnd = rand(0,99999);
$id=$_POST['secert'];
$model=Colors ::model()->findByPk($id);



$model->attributes = $_POST['Colors'];

if($model->save()){

$this->redirect(array('colors')	);
}else{
}



}
else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

}



public function  actionEditinventoryplaces(){

if(Yii::app()->user->isMember())
	{
$userid=Yii::app()->user->id;
	date_default_timezone_set('Africa/Cairo');  
	$today = date("Y-m-d");                     // 03.10.01
	$time = date("H:i:s");                      // 17:16:18	
	$rnd = rand(0,99999);
$id=$_POST['secert'];
$model=InventoryPlaces::model()->findByPk($id);



$model->attributes = $_POST['InventoryPlaces'];

if($model->save()){

$this->redirect(array('inventoryplaces')	);
}else{
}



}
else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

}



public function actionFreshleadssalescold(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

		    $this->layout = '//layouts/systemcgridview';
$criteria = new CDbCriteria();
$criteria->order = 'id DESC';
$criteria->condition = "coldcall IS NOT NULL";
$criteria->addSearchCondition('date', $today, false);
$criteria->addSearchCondition('fakedate', $today, false, 'OR');

//$criteria->addSearchCondition('user_sales', $userid, false);



$agent=User::model()->findByPk($userid);
if($agent->sales ==1 or $agent->telesales ==1 ){
$criteria->addSearchCondition('user_sales', $userid, false);
}else{
$criteria->addSearchCondition('user_id', $userid, false);
}   



$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
	
	
	


public function actionFreshleadssales(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

		    $this->layout = '//layouts/systemcgridview';
		    
  
  $criteria1 = new CDbCriteria();
$criteria1->order = 'id DESC';
$criteria1->condition = "coldcall IS NULL";
$criteria1->addSearchCondition('date', $today, false);

$agent = User::model()->findByPk($userid);
if ($agent->sales == 1 or $agent->telesales == 1) {
    $criteria1->addSearchCondition('user_sales', $userid, false);
} else {
    $criteria1->addSearchCondition('user_id', $userid, false);
}

$dataProvider1 = new CActiveDataProvider('Leads', array(
    'pagination' => array(
        'pageSize' => 50,
    ),
    'criteria' => $criteria1,
));

$criteria2 = new CDbCriteria();
$criteria2->order = 'id DESC';
$criteria2->condition = "coldcall IS NULL";
$criteria2->addSearchCondition('fakedate', $today, false);

$agent = User::model()->findByPk($userid);
if ($agent->sales == 1 or $agent->telesales == 1) {
    $criteria2->addSearchCondition('user_sales', $userid, false);
} else {
    $criteria2->addSearchCondition('user_id', $userid, false);
}

$dataProvider2 = new CActiveDataProvider('Leads', array(
    'pagination' => array(
        'pageSize' => 50,
    ),
    'criteria' => $criteria2,
));

// Fetch data from both providers
$data1 = $dataProvider1->getData();
$data2 = $dataProvider2->getData();

// Merge data arrays
$mergedData = array_merge($data1, $data2);

// Create a new data provider with merged data
$dataProvider = new CArrayDataProvider($mergedData, array(
    'keyField' => 'id', // Set the primary key field
    'pagination' => array(
        'pageSize' => 50,
    ),
));

// Note: You might need to adjust 'keyField' based on your actual primary key field in the 'Leads' model.

  
                                           


$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,	
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}




public function actionNotcommunicationteamleader(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


$start = '2019-01-01';
$end = date('Y-m-d');
$allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
$arr=array();
foreach($allemployee as $leader){
$arr[]=$leader->sales_id;
} 


  $criteria = new CDbCriteria();       
$criteria->condition = "close IS NULL ";       
$criteria->addBetweenCondition("date",$start,$end,'AND');
$criteria->addCondition('communication IS NULL');
$criteria->addCondition('transfer IS NULL');
$criteria->addInCondition('user_sales', $arr);
if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}
$pdf=TRUE;
$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


if(isset($_POST['downloadpdf'])){
                        $allleadss=Leads::model()->findAll($criteria);

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//sales/_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('Notrecived');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'notcommunication.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}



$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,
                'pdf'=>$pdf,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}



public function actionFreshleadsteamleadermonth(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			  $today = date("Y-m-d");  
 $start = date('Y-m-1');  $end = date('Y-m-31'); 
			
			
$allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
$arr=array();

			foreach($allemployee as $leader){
				$arr[]=$leader->sales_id;
			} 
			

$criteria = new CDbCriteria();             
$criteria->addBetweenCondition("date",$start,$end); 
//$criteria->addSearchCondition('date', $today, false);
//$criteria->addCondition('user_sales IS NOT NULL');
$criteria->addInCondition('user_sales', $arr);
if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}


$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));
if(isset($_POST['downloadpdf'])){
                        $allleadss=Leads::model()->findAll($criteria);

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//sales/_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('FreshLeads');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'FreshLeads.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}
$pdf=TRUE;

$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
		'pdf'=>$pdf ,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}


public function actionFreshleadsteamleader(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			
			
$allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
$arr=array();

			foreach($allemployee as $leader){
				$arr[]=$leader->sales_id;
			} 
			

$criteria = new CDbCriteria();             
$criteria->addSearchCondition('date', $today, false);
//$criteria->addCondition('user_sales IS NOT NULL');
$criteria->addInCondition('user_sales', $arr);
if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}

$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));
if(isset($_POST['downloadpdf'])){
                        $allleadss=Leads::model()->findAll($criteria);

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//sales/_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('FreshLeads');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'FreshLeads.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}
$pdf=TRUE;

$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
		'pdf'=>$pdf ,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}



public function actionFreshleads(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


                	    $this->layout = '//layouts/systemcgridview';


$allfreshleadsadmin=new Leads('freshleadsadmin');
$allfreshleadsadmin->unsetAttributes();  // clear any default values
if(isset($_GET['freshleadsadmin'])){
$allfreshleadsadmin->attributes=$_GET['freshleadsadmin'];
}

if(isset($_POST['downloadpdf'])){
                        $allleadss=Leads::model()->findAll($criteria);

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//sales/_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('FreshLeads');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'FreshLeads.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}
$pdf=TRUE;
if(isset($_POST['downloadexcel'])){
    

	ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');

                $allleadss=Leads::model()->findAll($criteria);

				foreach($allleadss as $data){
					$data->user_id = $data->employee->fname." ".$data->employee->lname;
					
					$data->user_sales = $data->sales->fname." ".$data->sales->lname;
					$data->status= $data->statuesaction->title;
					$data->substatus= $data->substatusaction->title;
					
					
					if(!empty($data->unit_type)){
					$typebuilding=TypeBuliding::model()->findByAttributes(array('id'=>$data->unit_type));
					$data->unit_type= $typebuilding->title;
					}

					$data->platform_id= $data->platform->title;
					$data->platformchild_id= $data->platformchild->title;

					$data->interest_id= $data->place->title;
					$data->branch= $data->branchtitle->title;

					$data->tel= $data->international_code.$data->tel;
					$data->campaign_id= $data->campaign->title;
					if($data->visit == 1){
					$data->visit = 'visit';
                    }
                    
                    $main=Mainsettings::model()->findByPk(1);
                    $suser=User::model()->findByPk($userid);
                    
                    if($main->exportxlxs == 1){
                    if($suser->hiddenxlxs != 1){    
                        
                    $faketel='*********';
                    $data->tel= $faketel;
                    }
                    }
                    
                    if($data->international_code == 20){
					$data->international_code = 'Local';
                    }else{
                        
                    $data->international_code = 'Global';    
                        
                    }
					
				}




$fields = array('id','title','email','campaign_id'
,'tel','user_id','date','user_sales','notes','communicate_date','status','substatus','visit','sales_report','platform_id','platformchild_id','interest_id','feedback_report','branch','details','facebook_id','adsetname','adname','career','international_code','unit_type');
$labels= array('id','title','email','campaign_id'
,'tel','user_id','date','user_sales','notes','communicate_date','status','substatus','visit','sales_report','platform_id','platformchild_id','interest_id','feedback_report','branch','details','facebook_id','adsetname','adname','career','international_code','unit_type');
XlsExporter2::downloadXls('SOLID XLS', $allleadss, 'Report-', TRUE  , $labels  , $fields, 'COUNT');


			}
$this->render('freshleadsadmingv',array(
		'userid'=>$userid ,	
		'pdf'=>$pdf ,	
                'allfreshleadsadmin'=>$allfreshleadsadmin,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}












public function actionStatreportteamleader($id){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			
			
			
			
			

$allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
$arr=array();

			foreach($allemployee as $leader){
				$arr[]=$leader->sales_id;
			} 

			

$criteria = new CDbCriteria();             
$criteria->addSearchCondition('status', $id, false);
$criteria->addInCondition('user_sales', $arr);


$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));
if(isset($_POST['downloadpdf'])){
                        $allleadss=Leads::model()->findAll($criteria);

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//sales/_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('FreshLeads');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'FreshLeads.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}
$pdf=TRUE;
$charts=TRUE;

$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
		'pdf'=>$pdf ,		
		'charts'=>$charts,	
		'id'=>$id,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
	
	

public function actionStatreport($id){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->layout = '//layouts/systemcgridview';
$criteria = new CDbCriteria();             
$criteria->addSearchCondition('status', $id, false);


$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));
if(isset($_POST['downloadpdf'])){
                        $allleadss=Leads::model()->findAll($criteria);

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//sales/_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('FreshLeads');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'FreshLeads.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}
$pdf=TRUE;
$charts=TRUE;

$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
		'pdf'=>$pdf ,		
		'charts'=>$charts,	
		'id'=>$id,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	










public function actionLeadsqu(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$criteria = new CDbCriteria();             
$criteria->condition = "qualified IS NOT NULL";


$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));
if(isset($_POST['downloadpdf'])){
                        $allleadss=Leads::model()->findAll($criteria);

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//sales/_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('FreshLeads');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'FreshLeads.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}
$pdf=TRUE;

$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
		'pdf'=>$pdf ,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}


public function actionLeadsrecommendation(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$criteria = new CDbCriteria();             
$criteria->condition = "recommendation IS NOT NULL";


$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));
if(isset($_POST['downloadpdf'])){
                        $allleadss=Leads::model()->findAll($criteria);

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//sales/_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('FreshLeads');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'FreshLeads.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}
$pdf=TRUE;

$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
		'pdf'=>$pdf ,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}




public function actionLeadswithoutclients(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$criteria = new CDbCriteria();             
//$criteria->condition = "client_id IS NULL ";

	$criteria->order = 'id DESC'; 
	
	
	if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}
 
 if($_GET['indirect']==1){
$criteria->addCondition('indirect IS NOT NULL');
}else if($_GET['indirect']==2){
$criteria->addCondition('indirect IS NULL');
}
 
 
$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                                          
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));
if(isset($_POST['downloadpdf'])){
                        $allleadss=Leads::model()->findAll($criteria);

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//sales/_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('FreshLeads');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'FreshLeads.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}
$pdf=TRUE;

$this->render('freshleadsfileexcel',array(
		'userid'=>$userid ,	
		'pdf'=>$pdf ,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}







public function actionClients(){
		if(Yii::app()->user->isMember()){



$this->layout='//layouts/systemcgridview';

			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			

		
			$model = new RequestReservation();
			$model->setScenario('com_porfile');
			if(isset($_POST['RequestReservation'])){
				$rnd = rand(0,9999);
				$model->attributes = $_POST['RequestReservation'];
				$model->user_id = $userid;
				$model->date = $today;
				$model->time = $time;
				$model->secret = $rnd.$userid;

				if($model->save()){

					


					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create Request Reservation';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secret;
					$logsystem->user_id = $userid;
					$logsystem->save();


					Yii::app()->controller->refresh();
				}
			}
			//$allplace=RequestReservation::model()->findAll(array('condition'=>' cancel IS  NULL && con IS NOT NULL  '));
            //$criteria = new CDbCriteria;
           // $criteria->order = 'id DESC';
                       //$criteria->addCondition('cancel IS  NULL AND con IS NOT NULL');

          
            //$criteria->order = 'id DESC';
            
            //$allplace=RequestReservation::model()->findAll($criteria);
           

	
	$allcon=new Reservation('con');

             	$allcon->unsetAttributes();  // clear any default values
                if(isset($_GET['Reservation'])){
                   // var_dump($_GET['Status']);exit;
                $allcon->attributes=$_GET['Reservation'];
             
                }

	


		
		
		
			$this->render('clients',array(
					'userid'=>$userid ,	
					'allcon'=>$allcon,	
				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->render('index',array('model'=>$model));
		}

	}






public function actionNotrecivedsales(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


 $start = '2019-01-01'; 
 $criteria = new CDbCriteria();       
$criteria->condition = "close IS NULL";      
$criteria->addCondition('user_sales IS NOT NULL');
$criteria->addCondition('receipt IS NULL');

$criteria->addSearchCondition('user_sales', $userid, false);
$criteria->addBetweenCondition("date",$start,$today);

if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else{
$criteria->addCondition('coldcall IS NULL');
}



$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));




















			




$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}







public function actionStatuessaleslead($id){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


$this->layout = '//layouts/systemcgridview';
 $start = '2019-01-01'; 
 $criteria = new CDbCriteria();
$criteria->addCondition('close IS NULL && coldcall IS NULL ');
       
//$criteria->addSearchCondition('user_sales', $userid, false);





$agent=User::model()->findByPk($userid);
if($agent->sales ==1 or $agent->telesales ==1 ){
    //var_dump($agent);exit;
$criteria->addSearchCondition('user_sales', $userid, false);
}else{
$criteria->addSearchCondition('user_id', $userid, false);
}   


$criteria->addSearchCondition('status', $id, false);


$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));




$this->render('statuessaleslead',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}

public function actionSubstatuessaleslead($id){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->layout='//layouts/systemcgridview';

 $start = '2019-01-01'; 
 $criteria = new CDbCriteria();
$criteria->addCondition('close IS NULL  && coldcall IS NULL ');
       
//$criteria->addSearchCondition('user_sales', $userid, false);



$agent=User::model()->findByPk($userid);
if($agent->sales ==1 or $agent->telesales ==1 ){
$criteria->addSearchCondition('user_sales', $userid, false);
}else{
$criteria->addSearchCondition('user_id', $userid, false);
}   





$criteria->addSearchCondition('substatus', $id, false);


$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));




$this->render('statuessaleslead',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}




public function actionStatuessalesleadcold($id){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


$this->layout = '//layouts/systemcgridview';
 $start = '2019-01-01'; 
 $criteria = new CDbCriteria();
$criteria->addCondition('close IS NULL && coldcall IS NOT NULL ');
       
//$criteria->addSearchCondition('user_sales', $userid, false);





$agent=User::model()->findByPk($userid);
if($agent->sales ==1 or $agent->telesales ==1 ){
    //var_dump($agent);exit;
$criteria->addSearchCondition('user_sales', $userid, false);
}else{
$criteria->addSearchCondition('user_id', $userid, false);
}   


$criteria->addSearchCondition('status', $id, false);


$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));




$this->render('statuessaleslead',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}


public function actionSubstatuessalesleadcold($id){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->layout='//layouts/systemcgridview';

 $start = '2019-01-01'; 
 $criteria = new CDbCriteria();
$criteria->addCondition('close IS NULL && coldcall IS NOT NULL ');
       
//$criteria->addSearchCondition('user_sales', $userid, false);



$agent=User::model()->findByPk($userid);
if($agent->sales ==1 or $agent->telesales ==1 ){
$criteria->addSearchCondition('user_sales', $userid, false);
}else{
$criteria->addSearchCondition('user_id', $userid, false);
}   

$criteria->addSearchCondition('substatus', $id, false);


$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));




$this->render('statuessaleslead',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}







public function actionNotreceivedteamleader(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
 $start = '2019-01-01';


$allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
$arr=array();

			foreach($allemployee as $leader){
				$arr[]=$leader->sales_id;
			} 

$criteria = new CDbCriteria();       
$criteria->condition = "close IS NULL ";      
$criteria->addInCondition('user_sales', $arr);
$criteria->addCondition('receipt IS NULL');
$criteria->addBetweenCondition("date",$start,$today);
if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}

$pdf=TRUE;
$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


if(isset($_POST['downloadpdf'])){
                        $allleadss=Leads::model()->findAll($criteria);

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//sales/_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('Notrecived');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'NotRecived.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}



$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,
                'pdf'=>$pdf,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}


public function actionNotreceived(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
$this->layout='//layouts/systemcgridview';

 $start = '2019-01-01'; 
 $criteria = new CDbCriteria();       
$criteria->condition = "close IS NULL ";      
$criteria->addCondition('user_sales IS NOT NULL');
$criteria->addCondition('receipt IS NULL');


if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}
 
 if($_GET['indirect']==1){
$criteria->addCondition('indirect IS NOT NULL');
}else if($_GET['indirect']==2){
$criteria->addCondition('indirect IS NULL');
}
 
 
$criteria->addBetweenCondition("date",$start,$today);

$pdf=TRUE;
$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


if(isset($_POST['downloadpdf'])){
                        $allleadss=Leads::model()->findAll($criteria);

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//sales/_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('Notrecived');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'NotRecived.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}



$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,
                'pdf'=>$pdf,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}










public function actionAlltrasferdnotrecivedteamleader(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


 $start = '2019-01-01'; 
$end = date('Y-m-d');

$allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
$arr=array();
foreach($allemployee as $leader){
$arr[]=$leader->sales_id;
} 


 $criteria = new CDbCriteria();       
$criteria->condition = "transfer IS NOT NULL && communication IS  NULL ";
$criteria->addBetweenCondition("date",$start,$end);
$criteria->addInCondition('user_sales', $arr);
if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}
$pdf=TRUE;
$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>150,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


if(isset($_POST['downloadpdf'])){
                        $allleadss=Leads::model()->findAll($criteria);

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//sales/_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('Notrecived');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'notcommunication.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}



$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,
                'pdf'=>$pdf,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}




public function actionNotreceived2dayteamleader(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			
			
			
			

$allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
$arr=array();

			foreach($allemployee as $leader){
				$arr[]=$leader->sales_id;
			} 


 $start = '2019-01-01'; 
$end = date('Y-m-d', strtotime("-2 days"));
 $criteria = new CDbCriteria();       
$criteria->condition = "close IS NULL ";
$criteria->addInCondition('user_sales', $arr);
$criteria->addCondition('user_sales IS NOT NULL');
$criteria->addCondition('receipt IS NULL');
$criteria->addBetweenCondition("date",$start,$end);

$pdf=TRUE;
$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


if(isset($_POST['downloadpdf'])){
                        $allleadss=Leads::model()->findAll($criteria);

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//sales/_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('Notrecived');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'NotRecived.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}



$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,
                'pdf'=>$pdf,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}



public function actionNotreceived2day(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


 $start = '2019-01-01'; 
$end = date('Y-m-d', strtotime("-2 days"));
 $criteria = new CDbCriteria();       
$criteria->condition = "close IS NULL ";   

$criteria->addCondition('user_sales IS NOT NULL');
$criteria->addCondition('receipt IS NULL');
$criteria->addBetweenCondition("date",$start,$end);

if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}

if($_GET['indirect']==1){
$criteria->addCondition('indirect IS NOT NULL');
}else if($_GET['indirect']==2){
$criteria->addCondition('indirect IS NULL');
}
 

$pdf=TRUE;
$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


if(isset($_POST['downloadpdf'])){
                        $allleadss=Leads::model()->findAll($criteria);

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//sales/_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('Notrecived');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'NotRecived.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}



$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,
                'pdf'=>$pdf,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}









public function actionAlltrasferdnotrecived(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);



                	    $this->layout = '//layouts/systemcgridview';


$allrotationforadmin=new Leads('rotationforadmin');
$allrotationforadmin->unsetAttributes();  // clear any default values
if(isset($_GET['Leads'])){
$allrotationforadmin->attributes=$_GET['Leads'];
}

$pdf=TRUE;


if(isset($_POST['downloadpdf'])){
                        $allleadss=Leads::model()->findAll($criteria);

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//sales/_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('Notrecived');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'notcommunication.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}



$this->render('rotationforadmingv',array(
		'userid'=>$userid ,	
		'allleadscount'=>$allleadscount ,	
                'allrotationforadmin'=>$allrotationforadmin,
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}











public function actionNotcommunication(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);




                	    $this->layout = '//layouts/systemcgridview';

$allnotcommunicationforadmin=new Leads('notcommunicationforadmin');
$allnotcommunicationforadmin->unsetAttributes();  // clear any default values
if(isset($_GET['Leads'])){
$allnotcommunicationforadmin->attributes=$_GET['Leads'];
}





$pdf=TRUE;


if(isset($_POST['downloadpdf'])){
                        $allleadss=Leads::model()->findAll($criteria);

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//sales/_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('Notrecived');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'notcommunication.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}


if(isset($_POST['downloadexcel'])){
    
 
$allleadss = Leads::model()->findAll($criteria);
    
    
    
ini_set('max_execution_time', 300);
ini_set('memory_limit', '-1');
foreach($allleadss as $data){
$data->user_id = $data->employee->fname." ".$data->employee->lname;

$data->user_sales = $data->sales->fname." ".$data->sales->lname;
$data->status= $data->statuesaction->title;
$data->substatus= $data->substatusaction->title;

$data->platform_id= $data->platform->title;
$data->interest_id= $data->place->title;
$data->branch= $data->branchtitle->title;

$data->tel= $data->international_code.$data->tel;
$data->campaign_id= $data->campaign->title;
if($data->visit == 1){
$data->visit = 'visit';
}
                    
                    
if($data->international_code == 20){
$data->international_code = 'Local';
}else{

$data->international_code = 'Global';    

}

}




$fields = array('id','title','campaign_id'
,'tel','user_id','date','user_sales','notes','communicate_date','status','substatus','visit','sales_report','platform_id','interest_id','feedback_report','branch','details','facebook_id','adsetname','adname','career','international_code');
$labels= array('id','title','campaign_id'
,'tel','user_id','date','user_sales','notes','communicate_date','status','substatus','visit','sales_report','platform_id','interest_id','feedback_report','branch','details','facebook_id','adsetname','adname','career','international_code');
XlsExporter2::downloadXls('SOLID Feedback XLS', $allleadss, 'Report-', TRUE  , $labels  , $fields, 'COUNT');

}


$this->render('notcommunicationforadmingv',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,
                'pdf'=>$pdf,
                'allnotcommunicationforadmin'=>$allnotcommunicationforadmin,
                
                
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}




        
        
        
        public function actionQuickreportaction(){
        if(Yii::app()->user->isMember()){
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        
        
        
        
        
        
        
        	
			    
            $lead = Leads::model()->findByAttributes(array('id'=>$_POST['lead']));
        	$model = new Activities();
		$model->setScenario('com_porfile');
		if(isset($_POST['Activities'])){
		    
		    
		    $act= Activities::model()->findByAttributes(array('id'=>$_POST['secert']));
		    
		    if(!empty($act)){	
				$act->report=$_POST['Activities']['report'];
				$act->close=1;
				$act->confirm=1;
			    $act->save();
			    
		    }
		    
		    
		    
            	if(!empty($lead->id)){ 	
            $criteriaopenx = new CDbCriteria;
            $criteriaopenx->addCondition('close IS NULL OR report IS NULL ');
            $criteriaopenx->addSearchCondition('leads_id', $lead->id, false, 'AND');
            $allopenactivities= Activities::model()->findAll($criteriaopenx);
            
            if(!empty($allopenactivities)){
            foreach($allopenactivities as $openactivities){	
            
            
            $openactivities->close=1;
            $openactivities->report=1;
            $openactivities->save();
            
            
            }
            
            }
            	}

		    
		    

		    
		    
		    

		    
			$rnd = rand(0,9999);
			$model->attributes = $_POST['Activities'];
			$model->user_id = $userid;
			$model->date = $today;
			$model->time = $time;
			$model->leads_id = $lead->id;

			$user=User::model()->findByPk($userid);
			//check for salesmanger or teamleader
            if($user->salesmanger ==1 or $user->teamleader ==1 ){
               $model->manger_id=$user->id; 
            }
			//check for salesmanger or teamleader

			$model->name=$lead->title;
			$model->code=$_POST['code'];
			$model->tel=$lead->tel;
			$model->coldcall=$lead->coldcall;
			$model->indirect=$lead->indirect;
			$model->user_id = $lead->user_sales;
            $model->lead_date= $lead->date;


                                
            $model->secert = $rnd.$userid;
            $status=Statues::model()->findByPk($_POST['Activities']['status']);
            $substatus=Substatus::model()->findByPk($_POST['Activities']['substatus']);
            
            
            if($substatus->answer == 1){
            $lead->answer=1;
            $model->answer=1;
            }
            
            
            if($status->answer == 1){
            $lead->answer=1;
            $model->answer=1;
            }

            
            if($substatus->answer == 2){
            $lead->answer=2;
            $model->answer=2;
            }
            
            
            
            if($status->answer == 2){
            $lead->answer=2;
            $model->answer=2;
            }
            
            
                          
            if($substatus->expvisit == 1){
            $lead->expvisit=1;
            $model->expvisit=1;
            }
            
            
            
                            
            if($status->expvisit == 1){
            $lead->expvisit=1;
            $model->expvisit=1;
            }
			
			
            
            
            if($substatus->callback == 1){
            $lead->callback=1;
            $model->callback=1;
            }	
		 
		 
		 
            if($status->callback == 1){
            $lead->callback=1;
            $model->callback=1;
            }	

			 
                               
                
                

			if($model->save()){
				$model->secert=$model->id;
				$model->save();

					
					 $lead->sales_report=$model->report;
                                $lead->communication=1;
                                $lead->follow_date=$model->follow_date;
                                $lead->checkup_activity=$today;
                               $lead->details= $lead->details.'  /  '.$today.'/ '.$model->details;
                               
                               $lead->status=$model->status;
                                 
                                $qualifiedtest=Statues::model()->findByPk($lead->status);
                                
    if($qualifiedtest->close == 1){                
                $lead->close=1;
				$lead->reopen=NULL;
				$lead->communication=1;
				$lead->close_date= $today;
				$model->report= 'Closed In '.$today.'-'.$model->details;
				$model->close= 1;
$model->save();
				//$lead->save();
                }
                
                
                
                                
    if($qualifiedtest->client == 1){                
                $lead->close=1;
				$lead->reopen=NULL;
				$lead->communication=1;
				$lead->close_date= $today;
				$model->report= 'Closed In '.$today.'-'.$model->details;
				$model->close= 1;
$model->save();
				//$lead->save();
                }
                
                
                
                
                
                
                
                
                
                                
                if($qualifiedtest->visit == 1){
                //var_dump($model->details);exit;
                $mainapp=Mainsettings::model()->findByPk(1);    
                if($mainapp->createvisitauto == 1){    
                $visit=new Visit();
                $visit->date=$today;
                $visit->lead_id=$lead->id;
                $visit->user_id=$userid;
                $visit->lead_date=$lead->date;
                $visit->code= $uniqid;
                $visit->details=$model->details;
                $visit->dateaction=$today;
                $visit->timeaction=$time;
                $visit->from_time=$time;
                $visit->to_time=$time;
                
                
                
                $visit->save();
                
                if(!$visit->save()){
                var_dump($visit->getErrors());
                }
                
                }
                }
                
                if($qualifiedtest->qualified == 1){
                $lead->qualified=1;
                  if(empty($lead->first_classification)){
                    
                $lead->first_classification=1;
                $lead->first_classification_user=$userid; 
                    
                }
                }
                
                
                if($qualifiedtest->nonqualified == 1){
                $lead->nonqualified=1;
                  if(empty($lead->first_classification)){
                    
                $lead->first_classification=2; 
                $lead->first_classification_user=$userid; 
                
                    
                }
                }
                
                        
                
                
                
					
					
					
				$allsalesmanger=User::model()->findAll(array('condition'=>'salesmanger=1'));
				foreach($allsalesmanger as $sales){	
					if(!empty($sales->player_id)){	
											
						
						$content = array(
							"en" => $model->employee->fname. ' ' .$model->employee->lname. ' created new activity to '.$model->client->title.' says '.$model->details 
						);
		
						 $mainapp=Mainsettings::model()->findByPk(1);
						$fields = array(
							'app_id' =>"$main->appkey",
							'include_player_ids' => array($sales->player_id),
							'data' => array("foo" => "bar"),
							'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->leads_id ,
							'contents' => $content
						);
		
						$fields = json_encode($fields);
    			
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
						curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
								'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
						curl_setopt($ch, CURLOPT_HEADER, FALSE);
						curl_setopt($ch, CURLOPT_POST, TRUE);
						curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

						$response = curl_exec($ch);
						curl_close($ch);
					
					
					
									
					}
					if(!empty($sales->player_id_mobile)){	
											
						
						$content = array(
							"en" => $model->employee->fname. ' ' .$model->employee->lname. ' created new activity to '.$model->client->title.' says '.$model->details 
						);
		
						 $mainapp=Mainsettings::model()->findByPk(1);
						$fields = array(
							'app_id' =>"$main->appkey",
							'include_player_ids' => array($sales->player_id_mobile),
							'data' => array("foo" => "bar"),
							'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->leads_id ,
							'contents' => $content
						);
		
						$fields = json_encode($fields);
    			
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
						curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
								'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
						curl_setopt($ch, CURLOPT_HEADER, FALSE);
						curl_setopt($ch, CURLOPT_POST, TRUE);
						curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

						$response = curl_exec($ch);
						curl_close($ch);
					
					
					
									
					}
				}
						





				//notification to team leader



				$criteria = new CDbCriteria;
				$criteria->addCondition('sales_id=' . $lead->sales->id);
				$leader=Teamleader::model()->find($criteria);
				$leader=User::model()->findByPk($leader->leader_id);
				if(!empty($leader)){
					if(!empty($leader->player_id)){
						$content = array(
							"en" => $model->employee->fname. ' ' .$model->employee->lname. ' created new activity to '.$model->client->title.' says '.$model->details 
						);
							
						 $mainapp=Mainsettings::model()->findByPk(1);
						$fields = array(
							'app_id' =>"$main->appkey",
							'include_player_ids' => array($leader->player_id),
							'data' => array("foo" => "bar"),
							'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$lead->secert ,
							'contents' => $content
						);
							
						$fields = json_encode($fields);
					    			
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
						curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
								'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
						curl_setopt($ch, CURLOPT_HEADER, FALSE);
						curl_setopt($ch, CURLOPT_POST, TRUE);
						curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

						$response = curl_exec($ch);
						curl_close($ch);
					}else{
						
					}



					if(!empty($leader->player_id_mobile)){
						$content = array(
							"en" => $model->employee->fname. ' ' .$model->employee->lname. ' created new activity to '.$model->client->title.' says '.$model->details 
						);
							
						 $mainapp=Mainsettings::model()->findByPk(1);
						$fields = array(
							'app_id' =>"$main->appkey",
							'include_player_ids' => array($leader->player_id_mobile),
							'data' => array("foo" => "bar"),
							'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$lead->secert ,
							'contents' => $content
						);
							
						$fields = json_encode($fields);
					    			
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
						curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
								'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
						curl_setopt($ch, CURLOPT_HEADER, FALSE);
						curl_setopt($ch, CURLOPT_POST, TRUE);
						curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

						$response = curl_exec($ch);
						curl_close($ch);
					}else{
					
					}




				}



	
							
							
							
				$lead->status = $model->status;
				$lead->substatus = $model->substatus;
				$lead->checkup_activity= $model->date;
				$lead->sales_report = $model->details;
				$lead->communication = 1;
				$lead->receipt=1;
				
				if($lead->feedback_date==0000-00-00){
				    
				$lead->feedback_date= $lead->date;

				}

				$lead->save();




				//SMS

			

				$logsystem = new Logsystem();
				$logsystem->date = $today;
				$logsystem->time = $time;
				$logsystem->action = 'User Create Activities';
				$logsystem->action_id = $model->id;
				$logsystem->ip = $model->id;
				$logsystem->secert = $model->secert;
				$logsystem->user_id = $userid;
				$logsystem->save();

    		     //add best sales
                    $userid=Yii::app()->user->id;
                	date_default_timezone_set('Africa/Cairo');  
                	$today = date("Y-m-d");
                    $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
                    if(!empty($best)){
                        $best->actnum+=1;
                        $best->save();
                    }else{
                        $best =new Bestsales();
                        $best->user_sales=$userid;
                        $best->date=$today;
                        $best->actnum=1;
                        $best->save();
                    }
                    //add bestsales
                    
                     //notification to team leaders AND Salesmanger
                $allsalesmanger=User::model()->findAll(array('condition'=>'salesmanger=1 AND level=1 AND activitiesnotifi=1 '));
                $arr=array();
				foreach($allsalesmanger as $sales){	
				    $arr[]=$sales->id;
				}
				$criteria = new CDbCriteria;
				$criteria->addCondition('sales_id=' . $lead->user_sales);
				$leaders=Teamleader::model()->findAll($criteria); 
				if(!empty($leaders)){
				    foreach($leaders as $teamlleader){
				        $arr[]=$teamlleader->leader_id;
				    }
				}
				
                $criteria = new CDbCriteria();         
        		$criteria->order = 'id DESC';
        		$criteria->addInCondition('userid',$arr);
        		$vars= FirebaseToken::model()->findAll($criteria);
                
                $arr=array();
                if(!empty($vars)){
                			foreach($vars as $var){
                    			$arr[]=$var->token;
                			}
                
                } 
				$man=User::model()->findByPk($userid);
	 
                $main=Mainsettings::model()->findByPk(1);
                $iconurl=Yii::app()->getBaseUrl(true).'/img/'.$main->logo;
                $fields = array(
                        'registration_ids' =>  $arr ,
                        'data' => array( "title" => " Activities ", "body" => $lead->title." Has a New Activity Written By :  ".$man->username  ,"icon" => $iconurl , "click_action" => Yii::app()->getBaseUrl(true).'/leads/profile/'.$lead->id),
                    );
                $url = 'https://fcm.googleapis.com/fcm/send';

                $headers = array(
                    'Authorization: key='.$main->appkey ,
                    'Content-Type: application/json'
                );
                // Open connection
                $ch = curl_init();
            
                // Set the url, number of POST vars, POST data
                curl_setopt($ch, CURLOPT_URL, $url);
            
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            
                // Disabling SSL Certificate support temporarly
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
            
                // Execute post
                $result = curl_exec($ch);
                // echo "Result".$result;
                if ($result === FALSE) {
                    die('Curl failed: ' . curl_error($ch));
                }
            
                // Close connection
                curl_close($ch); 

				//Yii::app()->controller->refresh();
			}
		
		}
        
        
        
     header('Location:'.$_POST['url']);
        
        $logsystem = new Logsystem();
        $logsystem->date = $today;
        $logsystem->time = $time;
        $logsystem->action = 'User Create Activities';
        $logsystem->action_id = $model->id;
        $logsystem->ip = $model->id;
        $logsystem->secert = $model->secert;
        $logsystem->user_id = $userid;
        $logsystem->save();
        
      
        
        
        }
        }







public function actionNotcommunicationsales(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


 
	    $this->layout = '//layouts/systemcgridview';




$model = new Activities();
		$model->setScenario('com_porfile');
		if(isset($_POST['Activities'])){
		    
		    
$lead = Leads::model()->findByAttributes(array('id'=>$_POST['lead']));
			$rnd = rand(0,9999);
			$model->attributes = $_POST['Activities'];
			$model->user_id = $userid;
			$model->date = $today;
			$model->time = $time;
			$model->leads_id = $lead->id;

			$user=User::model()->findByPk($userid);
			//check for salesmanger or teamleader
            if($user->salesmanger ==1 or $user->teamleader ==1 ){
               $model->manger_id=$user->id; 
            }
			//check for salesmanger or teamleader

			$model->name=$lead->title;
			$model->code=$_POST['code'];
			$model->tel=$lead->tel;
			$model->coldcall=$lead->coldcall;
			$model->indirect=$lead->indirect;
			$model->user_id = $lead->user_sales;
            $model->lead_date= $lead->date;


                                
			$model->secert = $rnd.$userid;
			
			    $substatus=Substatus::model()->findByPk($_POST['Activities']['substatus']);
                      
                 if($substatus->answer == 1){
                $lead->answer=1;
                $model->answer=1;
                }
                
                
                if($substatus->answer == 2){
                $lead->answer=2;
                $model->answer=2;
                }
			
		 
			 
                               
                
                

			if($model->save()){
				$model->secert=$model->id;
				$model->save();
					
					
					
					
					 $lead->sales_report=$model->report;
                                $lead->communication=1;
                                $lead->follow_date=$model->follow_date;
                                $lead->checkup_activity=$today;
                               $lead->details= $lead->details.'  /  '.$today.'/ '.$model->details;
                               
                               $lead->status=$model->status;

                                 
                                $qualifiedtest=Statues::model()->findByPk($model->status);
                
                if($qualifiedtest->qualified == 1){
                $lead->qualified=1;
                  if(empty($lead->first_classification)){
                    
                $lead->first_classification=1;
                $lead->first_classification_user=$userid; 
                    
                }
                }
                
                
                if($qualifiedtest->nonqualified == 1){
                $lead->nonqualified=1;
                  if(empty($lead->first_classification)){
                    
                $lead->first_classification=2; 
                $lead->first_classification_user=$userid; 
                
                    
                }
                }
                
                        
                
                
                
					
					
					
				$allsalesmanger=User::model()->findAll(array('condition'=>'salesmanger=1'));
				foreach($allsalesmanger as $sales){	
					if(!empty($sales->player_id)){	
											
						
						$content = array(
							"en" => $model->employee->fname. ' ' .$model->employee->lname. ' created new activity to '.$model->client->title.' says '.$model->details 
						);
		
						 $mainapp=Mainsettings::model()->findByPk(1);
						$fields = array(
							'app_id' =>"$main->appkey",
							'include_player_ids' => array($sales->player_id),
							'data' => array("foo" => "bar"),
							'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->leads_id ,
							'contents' => $content
						);
		
						$fields = json_encode($fields);
    			
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
						curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
								'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
						curl_setopt($ch, CURLOPT_HEADER, FALSE);
						curl_setopt($ch, CURLOPT_POST, TRUE);
						curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

						$response = curl_exec($ch);
						curl_close($ch);
					
					
					
									
					}
					if(!empty($sales->player_id_mobile)){	
											
						
						$content = array(
							"en" => $model->employee->fname. ' ' .$model->employee->lname. ' created new activity to '.$model->client->title.' says '.$model->details 
						);
		
						 $mainapp=Mainsettings::model()->findByPk(1);
						$fields = array(
							'app_id' =>"$main->appkey",
							'include_player_ids' => array($sales->player_id_mobile),
							'data' => array("foo" => "bar"),
							'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->leads_id ,
							'contents' => $content
						);
		
						$fields = json_encode($fields);
    			
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
						curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
								'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
						curl_setopt($ch, CURLOPT_HEADER, FALSE);
						curl_setopt($ch, CURLOPT_POST, TRUE);
						curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

						$response = curl_exec($ch);
						curl_close($ch);
					
					
					
									
					}
				}
						





				//notification to team leader



				$criteria = new CDbCriteria;
				$criteria->addCondition('sales_id=' . $lead->sales->id);
				$leader=Teamleader::model()->find($criteria);
				$leader=User::model()->findByPk($leader->leader_id);
				if(!empty($leader)){
					if(!empty($leader->player_id)){
						$content = array(
							"en" => $model->employee->fname. ' ' .$model->employee->lname. ' created new activity to '.$model->client->title.' says '.$model->details 
						);
							
						 $mainapp=Mainsettings::model()->findByPk(1);
						$fields = array(
							'app_id' =>"$main->appkey",
							'include_player_ids' => array($leader->player_id),
							'data' => array("foo" => "bar"),
							'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$lead->secert ,
							'contents' => $content
						);
							
						$fields = json_encode($fields);
					    			
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
						curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
								'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
						curl_setopt($ch, CURLOPT_HEADER, FALSE);
						curl_setopt($ch, CURLOPT_POST, TRUE);
						curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

						$response = curl_exec($ch);
						curl_close($ch);
					}else{
						$notifi= new Notifi();
						$notifi->date=$today;
						$notifi->time=$time;
						$notifi->platform=1;
						$notifi->message= $model->employee->fname. ' ' .$model->employee->lname. ' created new activity to '.$model->client->title.' says '.$model->details ;
						$notifi->user_id=$userid;
						$notifi->sendto=$leader->id;
						$notifi->url= Yii::app()->getBaseUrl(true).'/leads/profile/'.$lead->secert ;
						if(!$notifi->save())
						var_dump($notifi->getErrors());
					}



					if(!empty($leader->player_id_mobile)){
						$content = array(
							"en" => $model->employee->fname. ' ' .$model->employee->lname. ' created new activity to '.$model->client->title.' says '.$model->details 
						);
							
						 $mainapp=Mainsettings::model()->findByPk(1);
						$fields = array(
							'app_id' =>"$main->appkey",
							'include_player_ids' => array($leader->player_id_mobile),
							'data' => array("foo" => "bar"),
							'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$lead->secert ,
							'contents' => $content
						);
							
						$fields = json_encode($fields);
					    			
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
						curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
								'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
						curl_setopt($ch, CURLOPT_HEADER, FALSE);
						curl_setopt($ch, CURLOPT_POST, TRUE);
						curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

						$response = curl_exec($ch);
						curl_close($ch);
					}else{
						$notifi= new Notifi();
						$notifi->date=$today;
						$notifi->time=$time;
						$notifi->platform=2;
						$notifi->message= $model->employee->fname. ' ' .$model->employee->lname. ' created new activity to '.$model->client->title.' says '.$model->details ;
						$notifi->user_id=$userid;
						$notifi->sendto=$leader->id;
						$notifi->url= Yii::app()->getBaseUrl(true).'/leads/profile/'.$lead->secert ;
						if(!$notifi->save())
						var_dump($notifi->getErrors());
					}




				}



	
							
							
							
				$lead->status = $model->status;
				$lead->substatus = $model->substatus;
				$lead->checkup_activity= $model->date;
				$lead->sales_report = $model->details;
				$lead->communication = 1;
				
				if($lead->feedback_date==0000-00-00){
				    
				$lead->feedback_date= $lead->date;

				}

				$lead->save();




				//SMS

				$statues= Statues::model()->findByPk($model->status);

				if($statues->duplicate==1){



					$smsmessagecontent = rawurlencode($statues->sms_text);
					$curl = curl_init();

					curl_setopt_array($curl, array(
							CURLOPT_URL => "https://smsmisr.com/api/webapi/?username=".$main->username."&password=".$main->password."&language=2&sender=".$main->sender."&mobile=".$lead->international_code.$lead->tel."&message=".$smsmessagecontent ,
							CURLOPT_RETURNTRANSFER => true,
							CURLOPT_ENCODING => "",
							CURLOPT_MAXREDIRS => 10,
							CURLOPT_TIMEOUT => 30,
							CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
							CURLOPT_CUSTOMREQUEST => "POST",
							CURLOPT_HTTPHEADER => array(
								'Content-Type: application/json', 
								'Content-Length:0 ' ,
								"Cache-Control: no-cache",
							),
						));

					$response = curl_exec($curl);
					$err = curl_error($curl);
//var_dump($response);
					$sms= new Smssheet();
					$sms->date=$today;
					$sms->time=$time;
					$sms->tomobile=$lead->tel;
					$sms->totitle=$lead->title;
					$sms->content=$statues->sms_text;
					$sms->user_id=1;
					if(!$sms->save()){
						$errores = $sms->getErrors();
						//var_dump($errores);
					}



				}else{


					$past= new CDbCriteria();
					$past->addSearchCondition('leads_id', $lead->id, false, 'AND');
					$past->addSearchCondition('status', $model->status, false);

					$activities= Activities::model()->findAll($past);


					if(!empty($activities) ){

						$smsmessagecontent = rawurlencode($statues->sms_text);
						$curl = curl_init();

						curl_setopt_array($curl, array(
								CURLOPT_URL => "https://smsmisr.com/api/webapi/?username=".$main->username."&password=".$main->password."&language=2&sender=".$main->sender."&mobile=".$lead->international_code.$lead->tel."&message=".$smsmessagecontent ,
								CURLOPT_RETURNTRANSFER => true,
								CURLOPT_ENCODING => "",
								CURLOPT_MAXREDIRS => 10,
								CURLOPT_TIMEOUT => 30,
								CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
								CURLOPT_CUSTOMREQUEST => "POST",
								CURLOPT_HTTPHEADER => array(
									'Content-Type: application/json', 
									'Content-Length:0 ' ,
									"Cache-Control: no-cache",
								),
							));

						$response = curl_exec($curl);
						$err = curl_error($curl);

						$sms= new Smssheet();
						$sms->date=$today;
						$sms->time=$time;
						$sms->tomobile=$lead->tel;
						$sms->totitle=$lead->title;
						$sms->content=$statues->sms_text;
						$sms->user_id=1;
						if(!$sms->save()){
							$errores = $sms->getErrors();
							//var_dump($errores);
						}


					}




				}

				$logsystem = new Logsystem();
				$logsystem->date = $today;
				$logsystem->time = $time;
				$logsystem->action = 'User Create Activities';
				$logsystem->action_id = $model->id;
				$logsystem->ip = $model->id;
				$logsystem->secert = $model->secert;
				$logsystem->user_id = $userid;
				$logsystem->save();

    		     //add best sales
                    $userid=Yii::app()->user->id;
                	date_default_timezone_set('Africa/Cairo');  
                	$today = date("Y-m-d");
                    $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
                    if(!empty($best)){
                        $best->actnum+=1;
                        $best->save();
                    }else{
                        $best =new Bestsales();
                        $best->user_sales=$userid;
                        $best->date=$today;
                        $best->actnum=1;
                        $best->save();
                    }
                    //add bestsales
                    
                     //notification to team leaders AND Salesmanger
                $allsalesmanger=User::model()->findAll(array('condition'=>'salesmanger=1 AND level=1 AND activitiesnotifi=1 '));
                $arr=array();
				foreach($allsalesmanger as $sales){	
				    $arr[]=$sales->id;
				}
				$criteria = new CDbCriteria;
				$criteria->addCondition('sales_id=' . $lead->user_sales);
				$leaders=Teamleader::model()->findAll($criteria); 
				if(!empty($leaders)){
				    foreach($leaders as $teamlleader){
				        $arr[]=$teamlleader->leader_id;
				    }
				}
				
                $criteria = new CDbCriteria();         
        		$criteria->order = 'id DESC';
        		$criteria->addInCondition('userid',$arr);
        		$vars= FirebaseToken::model()->findAll($criteria);
                
                $arr=array();
                if(!empty($vars)){
                			foreach($vars as $var){
                    			$arr[]=$var->token;
                			}
                
                } 
				$man=User::model()->findByPk($userid);
	 
                $main=Mainsettings::model()->findByPk(1);
                $iconurl=Yii::app()->getBaseUrl(true).'/img/'.$main->logo;
                $fields = array(
                        'registration_ids' =>  $arr ,
                        'data' => array( "title" => " Activities ", "body" => $lead->title." Has a New Activity Written By :  ".$man->username  ,"icon" => $iconurl , "click_action" => Yii::app()->getBaseUrl(true).'/leads/profile/'.$lead->id),
                    );
                $url = 'https://fcm.googleapis.com/fcm/send';

                $headers = array(
                    'Authorization: key='.$main->appkey ,
                    'Content-Type: application/json'
                );
                // Open connection
                $ch = curl_init();
            
                // Set the url, number of POST vars, POST data
                curl_setopt($ch, CURLOPT_URL, $url);
            
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            
                // Disabling SSL Certificate support temporarly
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
            
                // Execute post
                $result = curl_exec($ch);
                // echo "Result".$result;
                if ($result === FALSE) {
                    die('Curl failed: ' . curl_error($ch));
                }
            
                // Close connection
                curl_close($ch); 

				Yii::app()->controller->refresh();
			}
		
		}










$allnotcommunicationsales = new Leads('notcommunicationsales');
$allnotcommunicationsales->unsetAttributes();  // clear any default values

if (isset($_GET['Leads'])) {
    $allnotcommunicationsales->attributes = $_GET['Leads'];
}

$allnotcommunicationsalesfake = new Leads('notcommunicationsalesfake');
$allnotcommunicationsalesfake->unsetAttributes();  // clear any default values

if (isset($_GET['Leads'])) {
    $allnotcommunicationsalesfake->attributes = $_GET['Leads'];
}

// Fetch data for both instances
$dataProvider1 = $allnotcommunicationsales->notcommunicationsales();
$dataProvider2 = $allnotcommunicationsalesfake->notcommunicationsalesfake();

// Combine data from both providers
$mergedData = array_merge($dataProvider1->getData(), $dataProvider2->getData());


$mergedDataProvider = new CArrayDataProvider($mergedData, array(
    'id' => 'mergedDataProvider',
    'sort' => array(
        'attributes' => array('id', 'title', 'date', 'tel', 'second_tel', 'project_id', 'campaign_id', 'platform_id', 'platformchild_id'), // Add sortable attributes
        'defaultOrder' => array('date' => true), // Default sorting
    ),
    'pagination' => array(
        'pageSize' => Yii::app()->user->getState('pageSize', Yii::app()->params['defaultPageSize']),
    ),
));



$this->render('notcommunicationsalesgv',array(
		'userid'=>$userid ,	
            'model'=>$model,
            'allnotcommunicationsales'=>$allnotcommunicationsales,
            //'allnotcommunicationsalesfake'=>$allnotcommunicationsalesfake,
            'mergedDataProvider'=>$mergedDataProvider,
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}



















public function actionMonactivitiesconf(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


$close = 1;
$criteria= new CDbCriteria;
//$criteria->condition = "confirm IS NOT NULL ";
$criteria->addSearchCondition('confirm', 3,true, "AND");
$mon = date('m');
$year=date('y');
$start="20".$year."-".$mon."-01";
$check = date('d');
$check="20".$year."-".$mon."-".$check ;
$check= date("Y-m-t", strtotime($check));
$criteria->addBetweenCondition("follow_date",$start,$check);

$dataProvider = new CActiveDataProvider('Activities', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


if(isset($_POST['downloadpdf'])){
                 $allactivities=Activities::model()->findAll($criteria);


		
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 
		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
		//$mpdf->autoLangToFont = false;
		//$mpdf->autoArabic = false;
		//$mpdf->charset_in='utf-8';
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');
		$html = $this->renderPartial('//sales/_result2',array('allactivities'=>$allactivities,
				'today' => $today,'time' => $time), true);
		$main=Mainsettings::model()->findByPk(1);	    
		$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
		$mpdf1->SetProtection(array('print'));
		$mpdf1->SetTitle('LateActivities');
		$mpdf1->SetAuthor("Brandshtine.");
		//$mpdf1->SetWatermarkText("");
		//$mpdf1->showWatermarkText = true;
		//$mpdf1->watermark_font = 'DejaVuSansCondensed';
		//$mpdf1->watermarkTextAlpha = 0.1;
		$mpdf1->SetDisplayMode('fullpage');
		$mpdf1->SetAutoFont('4');		  
		$mpdf1->WriteHTML($html);
		$file_name= 'LateActivities.pdf';
		ob_end_clean();
         	$mpdf1->Output($file_name,'I' );

			}

$latesearch=FALSE;
$pdf=TRUE;
$this->render('activitiesfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,	
                'pdf'=>$pdf,		
                'latesearch'=>$latesearch,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}







public function actionMonactivities(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


$close = 1;
$criteria= new CDbCriteria;
$mon = date('m');
$year=date('y');
$start="20".$year."-".$mon."-01";
$check = date('d');
$check="20".$year."-".$mon."-".$check ;
$check= date("Y-m-t", strtotime($check));
$criteria->addBetweenCondition("follow_date",$start,$check);

$dataProvider = new CActiveDataProvider('Activities', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


if(isset($_POST['downloadpdf'])){
                 $allactivities=Activities::model()->findAll($criteria);


		
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 
		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
		//$mpdf->autoLangToFont = false;
		//$mpdf->autoArabic = false;
		//$mpdf->charset_in='utf-8';
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');
		$html = $this->renderPartial('//sales/_result2',array('allactivities'=>$allactivities,
				'today' => $today,'time' => $time), true);
		$main=Mainsettings::model()->findByPk(1);	    
		$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
		$mpdf1->SetProtection(array('print'));
		$mpdf1->SetTitle('LateActivities');
		$mpdf1->SetAuthor("Brandshtine.");
		//$mpdf1->SetWatermarkText("");
		//$mpdf1->showWatermarkText = true;
		//$mpdf1->watermark_font = 'DejaVuSansCondensed';
		//$mpdf1->watermarkTextAlpha = 0.1;
		$mpdf1->SetDisplayMode('fullpage');
		$mpdf1->SetAutoFont('4');		  
		$mpdf1->WriteHTML($html);
		$file_name= 'LateActivities.pdf';
		ob_end_clean();
         	$mpdf1->Output($file_name,'I' );

			}

$latesearch=FALSE;
$pdf=TRUE;
$this->render('activitiesfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,	
                'pdf'=>$pdf,		
                'latesearch'=>$latesearch,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}








public function actionFreshactivitiesall(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
 
 
                	    $this->layout = '//layouts/systemcgridview';
 
 
$allfreshactivitiesforadmin=new Activities('freshactivitiesforadmin');
$allfreshactivitiesforadmin->unsetAttributes();  // clear any default values
if(isset($_GET['freshactivitiesforadmin'])){
$allfreshactivitiesforadmin->attributes=$_GET['freshactivitiesforadmin'];
}



if(isset($_POST['downloadpdf'])){
                 $allactivities=Activities::model()->findAll($criteria);


		
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 
		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
		//$mpdf->autoLangToFont = false;
		//$mpdf->autoArabic = false;
		//$mpdf->charset_in='utf-8';
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');
		$html = $this->renderPartial('//sales/_result2',array('allactivities'=>$allactivities,
				'today' => $today,'time' => $time), true);
		$main=Mainsettings::model()->findByPk(1);	    
		$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
		$mpdf1->SetProtection(array('print'));
		$mpdf1->SetTitle('LateActivities');
		$mpdf1->SetAuthor("Brandshtine.");
		//$mpdf1->SetWatermarkText("");
		//$mpdf1->showWatermarkText = true;
		//$mpdf1->watermark_font = 'DejaVuSansCondensed';
		//$mpdf1->watermarkTextAlpha = 0.1;
		$mpdf1->SetDisplayMode('fullpage');
		$mpdf1->SetAutoFont('4');		  
		$mpdf1->WriteHTML($html);
		$file_name= 'LateActivities.pdf';
		ob_end_clean();
         	$mpdf1->Output($file_name,'I' );

			}

$latesearch=TRUE;
$pdf=TRUE;
$this->render('freshactivitiesforadmingv',array(
		'userid'=>$userid ,	
                'allfreshactivitiesforadmin'=>$allfreshactivitiesforadmin,	
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}







public function actionFreshactivitiesteamleader(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
                	    $this->layout = '//layouts/systemcgridview';
 $criteria = new CDbCriteria(); 
$userid=Yii::app()->user->id;
$allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
$arr=array();

			foreach($allemployee as $leader){
				$arr[]=$leader->sales_id;
			}             
//$criteria->addCondition('close=' . $close);

$criteria->condition = "close IS NULL";
$criteria->addInCondition('user_id', $arr);

if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}

//$criteria->condition = "report IS NULL";

$start = date('Y-m-d');
$end = date('Y-m-d');

$criteria->addBetweenCondition("follow_date",$start,$end,'AND');
$dataProvider = new CActiveDataProvider('Activities', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


if(isset($_POST['downloadpdf'])){
                 $allactivities=Activities::model()->findAll($criteria);


		
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 
		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
		//$mpdf->autoLangToFont = false;
		//$mpdf->autoArabic = false;
		//$mpdf->charset_in='utf-8';
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');
		$html = $this->renderPartial('//sales/_result2',array('allactivities'=>$allactivities,
				'today' => $today,'time' => $time), true);
		$main=Mainsettings::model()->findByPk(1);	    
		$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
		$mpdf1->SetProtection(array('print'));
		$mpdf1->SetTitle('LateActivities');
		$mpdf1->SetAuthor("Brandshtine.");
		//$mpdf1->SetWatermarkText("");
		//$mpdf1->showWatermarkText = true;
		//$mpdf1->watermark_font = 'DejaVuSansCondensed';
		//$mpdf1->watermarkTextAlpha = 0.1;
		$mpdf1->SetDisplayMode('fullpage');
		$mpdf1->SetAutoFont('4');		  
		$mpdf1->WriteHTML($html);
		$file_name= 'LateActivities.pdf';
		ob_end_clean();
         	$mpdf1->Output($file_name,'I' );

			}

$latesearch=TRUE;
$pdf=TRUE;
$this->render('activitiesfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,	
                'pdf'=>$pdf,		
                'latesearch'=>$latesearch,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}






public function actionLateactivitiesteamleader(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
                	    $this->layout = '//layouts/systemcgridview';
 $criteria = new CDbCriteria(); 
$userid=Yii::app()->user->id;
$allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
$arr=array();

			foreach($allemployee as $leader){
				$arr[]=$leader->sales_id;
			}             
//$criteria->addCondition('close=' . $close);

$criteria->condition = "close IS NULL AND too IS NULL ";
$criteria->addInCondition('user_id', $arr);
//$criteria->condition = "report IS NULL";

$start = '2019-01-01';
$end = date('Y-m-d', strtotime("-1 days"));

$criteria->addBetweenCondition("follow_date",$start,$end,'AND');

if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}

$dataProvider = new CActiveDataProvider('Activities', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


if(isset($_POST['downloadpdf'])){
                 $allactivities=Activities::model()->findAll($criteria);


		
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 
		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
		//$mpdf->autoLangToFont = false;
		//$mpdf->autoArabic = false;
		//$mpdf->charset_in='utf-8';
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');
		$html = $this->renderPartial('//sales/_result2',array('allactivities'=>$allactivities,
				'today' => $today,'time' => $time), true);
		$main=Mainsettings::model()->findByPk(1);	    
		$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
		$mpdf1->SetProtection(array('print'));
		$mpdf1->SetTitle('LateActivities');
		$mpdf1->SetAuthor("Brandshtine.");
		//$mpdf1->SetWatermarkText("");
		//$mpdf1->showWatermarkText = true;
		//$mpdf1->watermark_font = 'DejaVuSansCondensed';
		//$mpdf1->watermarkTextAlpha = 0.1;
		$mpdf1->SetDisplayMode('fullpage');
		$mpdf1->SetAutoFont('4');		  
		$mpdf1->WriteHTML($html);
		$file_name= 'LateActivities.pdf';
		ob_end_clean();
         	$mpdf1->Output($file_name,'I' );

			}

$latesearch=TRUE;
$pdf=TRUE;
$this->render('activitiesfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,	
                'pdf'=>$pdf,		
                'latesearch'=>$latesearch,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}







public function actionLateactivitiestransferteamleader(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
 $criteria = new CDbCriteria(); 
$userid=Yii::app()->user->id;
$allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
$arr=array();

			foreach($allemployee as $leader){
				$arr[]=$leader->sales_id;
			}             
			
			$criteria->condition = "close IS NULL && too IS NOT NULL";
$start = '2019-01-01';
$end = date('Y-m-d', strtotime("-1 days"));
$criteria->addBetweenCondition("follow_date",$start,$end,'AND');
$criteria->addInCondition('too', $arr);
if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}
$dataProvider = new CActiveDataProvider('Activities', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


if(isset($_POST['downloadpdf'])){
                 $allactivities=Activities::model()->findAll($criteria);


		
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 
		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
		//$mpdf->autoLangToFont = false;
		//$mpdf->autoArabic = false;
		//$mpdf->charset_in='utf-8';
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');
		$html = $this->renderPartial('//sales/_result2',array('allactivities'=>$allactivities,
				'today' => $today,'time' => $time), true);
		$main=Mainsettings::model()->findByPk(1);	    
		$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
		$mpdf1->SetProtection(array('print'));
		$mpdf1->SetTitle('LateActivities');
		$mpdf1->SetAuthor("Brandshtine.");
		//$mpdf1->SetWatermarkText("");
		//$mpdf1->showWatermarkText = true;
		//$mpdf1->watermark_font = 'DejaVuSansCondensed';
		//$mpdf1->watermarkTextAlpha = 0.1;
		$mpdf1->SetDisplayMode('fullpage');
		$mpdf1->SetAutoFont('4');		  
		$mpdf1->WriteHTML($html);
		$file_name= 'LateActivities.pdf';
		ob_end_clean();
         	$mpdf1->Output($file_name,'I' );

			}

$latesearch=TRUE;
$pdf=TRUE;
$this->render('activitiesfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,	
                'pdf'=>$pdf,		
                'latesearch'=>$latesearch,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}






    public function actionLateactivities(){
                if(Yii::app()->user->isMember()){
                date_default_timezone_set('Africa/Cairo');  
    	     	$today = date("Y-m-d");                     // 03.10.01
    		    $time = date("H:i:s");                      // 17:16:18	
    	     	$rnd = rand(0,99999);
                $userid=Yii::app()->user->id;
                
                	    $this->layout = '//layouts/systemcgridview';

                $userid=User::model()->findByPk($userid);

                $alllateforadmin=new Activities('lateforadmin');
             	$alllateforadmin->unsetAttributes();  // clear any default values
                if(isset($_GET['Activities'])){
                   // var_dump($_GET['Status']);exit;
                $alllateforadmin->attributes=$_GET['Activities'];
                }





               
                
                $this->render('lateforadmin',array(
                
                'userid'=>$userid,
                'alllateforadmin'=>$alllateforadmin,

    
    
                ));
                }
                
                
                
               
                
                
                else{
               
                $this->redirect(array('home/index')	);		}
                
                }



	
	

public function actionnextactivities(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


$close = 1;
$criteria = new CDbCriteria();             


$criteria->condition = "close IS NULL AND too IS NULL";



$end = '2040-01-01';
$start = date('Y-m-d', strtotime("+1 days"));

$criteria->addBetweenCondition("follow_date",$start,$end,'AND');
if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}

if($_GET['indirect']==1){
$criteria->addCondition('indirect IS NOT NULL');
}else if($_GET['indirect']==2){
$criteria->addCondition('indirect IS NULL AND broker_id IS NULL');
}


if(!empty($_GET['sales'])){
$criteria->addSearchCondition('user_id', $_GET['sales'] , false);
}

if($_GET['broker']==1){
$criteria->addCondition('broker_id IS NOT NULL');
$dataProvider = new CActiveDataProvider('Activities', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));
 
$this->render('activitiesfilebroker',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider, 				
		));
		exit;
} 







$dataProvider = new CActiveDataProvider('Activities', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


if(isset($_POST['downloadpdf'])){
                 $allactivities=Activities::model()->findAll($criteria);


		
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 
		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
		//$mpdf->autoLangToFont = false;
		//$mpdf->autoArabic = false;
		//$mpdf->charset_in='utf-8';
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');
		$html = $this->renderPartial('//sales/_result2',array('allactivities'=>$allactivities,
				'today' => $today,'time' => $time), true);
		$main=Mainsettings::model()->findByPk(1);	    
		$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
		$mpdf1->SetProtection(array('print'));
		$mpdf1->SetTitle('LateActivities');
		$mpdf1->SetAuthor("Brandshtine.");
		//$mpdf1->SetWatermarkText("");
		//$mpdf1->showWatermarkText = true;
		//$mpdf1->watermark_font = 'DejaVuSansCondensed';
		//$mpdf1->watermarkTextAlpha = 0.1;
		$mpdf1->SetDisplayMode('fullpage');
		$mpdf1->SetAutoFont('4');		  
		$mpdf1->WriteHTML($html);
		$file_name= 'LateActivities.pdf';
		ob_end_clean();
         	$mpdf1->Output($file_name,'I' );

			}
			
			
			


if(isset($_POST['downloadexcel'])){
    
                     $allactivities=Activities::model()->findAll($criteria);

    
	ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');




	foreach($allactivities as $data){
					$data->user_id = $data->employee->fname." ".$data->employee->lname;
					$data->status= $data->statuesaction->title;
					$data->substatus= $data->substatusaction->title;
					if($data->confirm == 1 ){
					    $success='sucess';
					    					$data->confirm= $success;

					}elseif ($data->confirm == 3 ){
					  
					  
					   $failure='failure';
										    					$data->confirm= $failure;  
					 
					}

				
					
				}




$fields = array('name','tel','date','time','user_id','details','follow_date','status','substatus','report' ,'sucess');
$labels= array('name','tel','date','time','user_id','details','follow_date','status','substatus','report' ,'confirm');
XlsExporter2::downloadXls('SOLID late Activities XLS', $allactivities, 'Report-', TRUE  , $labels  , $fields, 'COUNT');


    
    
    
    
    
}
			
			

$latesearch=TRUE;
$pdf=TRUE;
$this->render('activitiesfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,	
                'pdf'=>$pdf,		
                'latesearch'=>$latesearch,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
		
	





public function actionLateactivitiestransfer(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


$close = 1;
$criteria = new CDbCriteria();             


$criteria->condition = "close IS NULL AND too IS NOT NULL";
		
 

if(empty($_REQUEST['startdate'])){
$start = '2019-01-01';
$end = date('Y-m-d', strtotime("-1 days"));
$criteria->addBetweenCondition("follow_date",$start,$end,'AND');
}else{
$start = $_REQUEST['startdate'];
$end = $_REQUEST['enddate'];
$criteria->addBetweenCondition("follow_date",$start,$end,'AND');    
}


if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}

if($_GET['indirect']==1){
$criteria->addCondition('indirect IS NOT NULL');
}else if($_GET['indirect']==2){
$criteria->addCondition('indirect IS NULL AND broker_id IS NULL');
}



if($_GET['broker']==1){
$criteria->addCondition('broker_id IS NOT NULL');
$dataProvider = new CActiveDataProvider('Activities', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));

$this->render('activitiesfilebroker',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,					
		));
		exit;
} 

$dataProvider = new CActiveDataProvider('Activities', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


if(isset($_POST['downloadpdf'])){
                 $allactivities=Activities::model()->findAll($criteria);


		
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 
		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
		//$mpdf->autoLangToFont = false;
		//$mpdf->autoArabic = false;
		//$mpdf->charset_in='utf-8';
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');
		$html = $this->renderPartial('//sales/_result2',array('allactivities'=>$allactivities,
				'today' => $today,'time' => $time), true);
		$main=Mainsettings::model()->findByPk(1);	    
		$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
		$mpdf1->SetProtection(array('print'));
		$mpdf1->SetTitle('LateActivities');
		$mpdf1->SetAuthor("Brandshtine.");
		//$mpdf1->SetWatermarkText("");
		//$mpdf1->showWatermarkText = true;
		//$mpdf1->watermark_font = 'DejaVuSansCondensed';
		//$mpdf1->watermarkTextAlpha = 0.1;
		$mpdf1->SetDisplayMode('fullpage');
		$mpdf1->SetAutoFont('4');		  
		$mpdf1->WriteHTML($html);
		$file_name= 'LateActivities.pdf';
		ob_end_clean();
         	$mpdf1->Output($file_name,'I' );

			}
			
			


if(isset($_POST['downloadexcel'])){
    
                     $allactivities=Activities::model()->findAll($criteria);

    
	ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');




	foreach($allactivities as $data){
					$data->user_id = $data->employee->fname." ".$data->employee->lname;
					$data->status= $data->statuesaction->title;
					$data->substatus= $data->substatusaction->title;
					if($data->confirm == 1 ){
					    $success='sucess';
					    					$data->confirm= $success;

					}elseif ($data->confirm == 3 ){
					  
					  
					   $failure='failure';
										    					$data->confirm= $failure;  
					 
					}

				
					
				}




$fields = array('name','tel','date','time','user_id','details','follow_date','status','substatus','report' ,'sucess');
$labels= array('name','tel','date','time','user_id','details','follow_date','status','substatus','report' ,'confirm');
XlsExporter2::downloadXls('SOLID late Activities transfer XLS', $allactivities, 'Report-', TRUE  , $labels  , $fields, 'COUNT');


    
    
    
    
    
}
					
			
			

$latesearch=TRUE;
$pdf=TRUE;
$this->render('activitiesfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,	
                'pdf'=>$pdf,		
                'latesearch'=>$latesearch,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	






public function actionSearchlateactivities(){
	if(Yii::app()->user->isMember()){
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);


$this->layout = '//layouts/systemcgridview';
		$close = 1;

		$user=$_REQUEST['userr'];

		$status=$_REQUEST['status'];

		$criteria = new CDbCriteria();             


        if(empty($_REQUEST['transfer'])){
		$criteria->condition = "close IS NULL AND too IS  NULL ";
        }else{
            
        $criteria->condition = "close IS NULL && too IS NOT NULL ";
        }
		//$criteria->addCondition(' ');
		
		
		
				if($_REQUEST['cold']==1){


				$criteria->addSearchCondition('coldcall', $_REQUEST['cold'],false, "AND");
			}else if($_REQUEST['cold']==2){



				$criteria->addCondition('coldcall IS NULL');
			}else{
			}
			
		
if(empty($_REQUEST['startdate'])){
$start = '2019-01-01';
$end = date('Y-m-d', strtotime("-1 days"));
$criteria->addBetweenCondition("follow_date",$start,$end,'AND');
}else{
$start = $_REQUEST['startdate'];
$end = $_REQUEST['enddate'];
$criteria->addBetweenCondition("follow_date",$start,$end,'AND');    
}
		

	

		if(!empty($user) && empty($_REQUEST['transfer']) ){

		    $criteria->addSearchCondition('user_id', $user,false, "AND");


		}else{
		    
            $criteria->addSearchCondition('too', $user, false);
		}
		
		
		if(!empty($status) ){
			$criteria->addSearchCondition('status', $status,false, "AND");
		}

		$dataProvider = new CActiveDataProvider('Activities', array(
				'pagination' => array(
					'pageSize' =>50,
				),
				'criteria' => $criteria,
			));
		$numbers=Activities::model()->count($criteria);

		if(isset($_POST['downloadpdf'])){
			$allactivities=Activities::model()->findAll($criteria);


		
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s"); 
			$mpdf= Yii::app()->ePdf->mpdf('ar-s');
			//$mpdf->autoLangToFont = false;
			//$mpdf->autoArabic = false;
			//$mpdf->charset_in='utf-8';
			ini_set('max_execution_time', 300);
			ini_set('memory_limit', '-1');
			$html = $this->renderPartial('//sales/_result2',array('allactivities'=>$allactivities,
					'today' => $today,'time' => $time), true);
			$main=Mainsettings::model()->findByPk(1);	    
			$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
			$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
			$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
			$mpdf1->SetProtection(array('print'));
			$mpdf1->SetTitle('LateActivities');
			$mpdf1->SetAuthor("Brandshtine.");
			//$mpdf1->SetWatermarkText("");
			//$mpdf1->showWatermarkText = true;
			//$mpdf1->watermark_font = 'DejaVuSansCondensed';
			//$mpdf1->watermarkTextAlpha = 0.1;
			$mpdf1->SetDisplayMode('fullpage');
			$mpdf1->SetAutoFont('4');		  
			$mpdf1->WriteHTML($html);
			$file_name= 'LateActivities.pdf';
			ob_end_clean();
			$mpdf1->Output($file_name,'I' );

		}




if(isset($_POST['downloadexcel'])){
    
                     $allactivities=Activities::model()->findAll($criteria);

    
	ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');




	foreach($allactivities as $data){
					$data->user_id = $data->employee->fname." ".$data->employee->lname;
					$data->status= $data->statuesaction->title;
					$data->tel= $data->client->international_code.$data->tel;
					$data->substatus= $data->substatusaction->title;
					if($data->confirm == 1 ){
					    $success='sucess';
					    					$data->confirm= $success;

					}elseif ($data->confirm == 3 ){
					  
					  
					   $failure='failure';
										    					$data->confirm= $failure;  
					 
					}

				
					
				}




$fields = array('name','tel','date','time','user_id','details','follow_date','status','substatus','report' ,'sucess');
$labels= array('name','tel','date','time','user_id','details','follow_date','status','substatus','report' ,'confirm');
XlsExporter2::downloadXls('SOLID late Activities  XLS', $allactivities, 'Report-', TRUE  , $labels  , $fields, 'COUNT');


    
    
    
    
    
}



		if(isset($_POST['Transfer'])){
			
			
			$res= $_POST['Transfer']['reason'];
			$per= $_POST['Lead']['sales'];
			$num= $_POST['number2'];
			$sumsize=0;
			for($x=0;$x<sizeof($num);$x++){
				$sumsize+=(int)$num[$x];
			}
		
			$leadsnum=Activities::model()->count($criteria);

			$leadsnum = (int)$leadsnum;
			if($sumsize > $leadsnum){
				Yii::app()->user->setFlash('success', "Cannot Proceed This Action Because There is No Enough Leads ");
				Yii::app()->controller->refresh();
	
			}
			 
		$arr=array();
		$i=0;
		foreach($num as $number){
		    for($x=0 ; $x < $number ; $x++){
		        $arr[]=$per[$i];
		        
		    }
		    $i++;
		} 
		$i=0;
				$criteria2 = new CDbCriteria();
		
				$criteria2->condition = "close IS NULL";


				$criteria2->addBetweenCondition("follow_date",$start,$end,'AND');

				if(!empty($user) ){

					$criteria2->addSearchCondition('user_id', $user,false, "AND");
				}
				if(!empty($status) ){
					$criteria2->addSearchCondition('status', $status,false, "AND");
				} 
				$leads=Activities::model()->findAll($criteria2);
				foreach($leads as $lead){
				
				
				 
					$leadss=Leads::model()->findByPk((int)$lead->leads_id);
					$oldsales=$leadss->user_sales;
					$leadss->user_sales=(int)$arr[$i];
					$leadss->transfer=1;
					$leadss->communication=Null;
					$leadss->transferdate=$today;
					$leadss->checkup_activity=$today;
					$leadss->close=NULL;
					$lead->too=(int)$arr[$i];
					$lead->save();
					if($leadss->save()){
						$counter++;
						$transfer=new Transfer();
						$transfer->reason='multi trasfer From Late';
						$transfer->user_id=$userid;
						$transfer->lead_id=$leadss->id;
						$transfer->fromm=$oldsales;
						$transfer->too=$leadss->user_sales;
						$transfer->date= $today ;                     // 03.10.01
						$transfer->time= $time  ;

						if($transfer->save()){ 
                    
							$act = new CDbCriteria;
							$act->condition = "close IS NULL ";
							$act->addCondition('leads_id='.$transfer->lead_id);
							$allactivitiesact=Activities::model()->findAll($act);

							if(!empty($allactivitiesact)){
								foreach($allactivitiesact as $activitiesact){
									$activitiesact->too=$transfer->too;
									$activitiesact->save();
								}
							}

						}else{var_dump($transfer->getErrors());}
					}
				$i++;
				}
		/*
			for($i=0;$i<sizeof($per);$i++){
				$criteria2 = new CDbCriteria();
		
				$criteria2->condition = "close IS NULL";


				$criteria2->addBetweenCondition("follow_date",$start,$end,'AND');

				if(!empty($user) ){

					$criteria2->addSearchCondition('user_id', $user,false, "AND");
				}
				if(!empty($status) ){
					$criteria2->addSearchCondition('status', $status,false, "AND");
				}
				$criteria2->limit = (int)$num[$i];
				$leads=Activities::model()->findAll($criteria2);
				foreach($leads as $lead){
				
				
				
				
				
				
				
					$leadss=Leads::model()->findByPk((int)$lead->leads_id);
					$oldsales=$leadss->user_sales;
					$leadss->user_sales=(int)$per[$i];
					$leadss->transfer=1;
					$leadss->communication=Null;
					$leadss->transferdate=$today;
					$leadss->checkup_activity=$today;
					$leadss->close=NULL;
					$lead->too=(int)$per[$i];
					$lead->save();
					if($leadss->save()){
						$counter++;
						$transfer=new Transfer();
						$transfer->reason='multi trasfer From Late';
						$transfer->user_id=$userid;
						$transfer->lead_id=$leadss->id;
						$transfer->fromm=$oldsales;
						$transfer->too=$leadss->user_sales;
						$transfer->date= $today ;                     // 03.10.01
						$transfer->time= $time  ;

						if($transfer->save()){ 
                    
							$act = new CDbCriteria;
							$act->condition = "close IS NULL ";
							$act->addCondition('leads_id='.$transfer->lead_id);
							$allactivitiesact=Activities::model()->findAll($act);

							if(!empty($allactivitiesact)){
								foreach($allactivitiesact as $activitiesact){
									$activitiesact->too=$transfer->too;
									$activitiesact->save();
								}
							}

						}else{var_dump($transfer->getErrors());}
					}
				
				}
			}
		*/
		
		
		
	
			Yii::app()->user->setFlash('success', $counter."  Leads Transfered " );
			$this->redirect(array('login/searchlateactivities')	);
		}





		$latesearch=TRUE;
		$pdf=TRUE;
		$transfer=TRUE;
		$this->render('activitiesfile',array(
				'userid'=>$userid ,	
				'dataProvider'=>$dataProvider,	
				'pdf'=>$pdf,		
				'latesearch'=>$latesearch,
				'transfer'=>$transfer,
				'numbers'=>$numbers,				
			));

	}else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('login/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
	}

}



public function actionSearchlatetransferactivities(){
	if(Yii::app()->user->isMember()){
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);


		$close = 1;

		$user=$_REQUEST['userr'];

		$status=$_REQUEST['status'];

		$criteria = new CDbCriteria();             
           
        $criteria->order="id ASC";   


		$criteria->condition = "close IS NULL AND too IS NOT NULL";
		//$criteria->addCondition(' ');
		$start = '2019-01-01';
		$end = date('Y-m-d', strtotime("-1 days"));
		$criteria->addBetweenCondition("follow_date",$start,$end,'AND');
		if(!empty($user) ){

			$criteria->addSearchCondition('too', $user,false, "AND");
		}
		if(!empty($status) ){
			$criteria->addSearchCondition('status', $status,false, "AND");
		}

		$dataProvider = new CActiveDataProvider('Activities', array(
				'pagination' => array(
					'pageSize' =>50,
				),
				'criteria' => $criteria,
			));
		$numbers=Activities::model()->count($criteria);

		if(isset($_POST['downloadpdf'])){
			$allactivities=Activities::model()->findAll($criteria);


		
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s"); 
			$mpdf= Yii::app()->ePdf->mpdf('ar-s');
			//$mpdf->autoLangToFont = false;
			//$mpdf->autoArabic = false;
			//$mpdf->charset_in='utf-8';
			ini_set('max_execution_time', 300);
			ini_set('memory_limit', '-1');
			$html = $this->renderPartial('//sales/_result2',array('allactivities'=>$allactivities,
					'today' => $today,'time' => $time), true);
			$main=Mainsettings::model()->findByPk(1);	    
			$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
			$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
			$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
			$mpdf1->SetProtection(array('print'));
			$mpdf1->SetTitle('LateActivities');
			$mpdf1->SetAuthor("Brandshtine.");
			//$mpdf1->SetWatermarkText("");
			//$mpdf1->showWatermarkText = true;
			//$mpdf1->watermark_font = 'DejaVuSansCondensed';
			//$mpdf1->watermarkTextAlpha = 0.1;
			$mpdf1->SetDisplayMode('fullpage');
			$mpdf1->SetAutoFont('4');		  
			$mpdf1->WriteHTML($html);
			$file_name= 'LateActivities.pdf';
			ob_end_clean();
			$mpdf1->Output($file_name,'I' );

		}


if(isset($_POST['downloadexcel'])){
    
                     $allactivities=Activities::model()->findAll($criteria);

    
	ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');




	foreach($allactivities as $data){
					$data->user_id = $data->employee->fname." ".$data->employee->lname;
					$data->status= $data->statuesaction->title;
					$data->substatus= $data->substatusaction->title;
					if($data->confirm == 1 ){
					    $success='sucess';
					    					$data->confirm= $success;

					}elseif ($data->confirm == 3 ){
					  
					  
					   $failure='failure';
										    					$data->confirm= $failure;  
					 
					}

				
					
				}




$fields = array('name','tel','date','time','user_id','details','follow_date','status','substatus','report' ,'sucess');
$labels= array('name','tel','date','time','user_id','details','follow_date','status','substatus','report' ,'confirm');
XlsExporter2::downloadXls('SOLID late Activities transfer XLS', $allactivities, 'Report-', TRUE  , $labels  , $fields, 'COUNT');


    
    
    
    
    
}




$arrayofids=array();
if(isset($_POST['Leads']) AND isset($_POST['number'])){

//ini_set('display_errors','On'); 
//error_reporting(E_ALL);

	$per= $_POST['Leads'];
	$num= $_POST['number'];
	$sumsize=0;
	for($x=0;$x<sizeof($num);$x++){
		$sumsize+=(int)$num[$x];
	}
 

	$leadsnum=Activities::model()->count($criteria);

     
    
	$leadsnum = (int)$leadsnum;
	if($sumsize > $leadsnum){
		Yii::app()->user->setFlash('success', "Cannot Proceed This Action Because There is No Enough Leads ");
		Yii::app()->controller->refresh();
	
	}
	
		$close = 1;

		$user=$_REQUEST['userr'];

		$status=$_REQUEST['status'];
		
	$count=0;
	for($i=0;$i<sizeof($per);$i++){
	   
	      
	    	$close = 1;
            $criteria2 = new CDbCriteria();         
            $criteria2->order="id ASC";            
            
            
            $criteria2->condition = "close IS NULL AND too IS NOT NULL";
    		//$criteria->addCondition(' ');
    		$start = '2019-01-01';
    		$end = date('Y-m-d', strtotime("-1 days"));
    		$criteria2->addBetweenCondition("follow_date",$start,$end,'AND');
    		if(!empty($user) ){
    
    			$criteria2->addSearchCondition('too', $user,false, "AND");
    		}
    		if(!empty($status) ){
    			$criteria2->addSearchCondition('status', $status,false, "AND");
    		}

            

			$criteria2->addNotInCondition('leads_id', $arrayofids);
                    
	    	$criteria2->limit = (int)$num[$i];





			$allactivities = Activities::model()->findAll($criteria2);    
                        
 
	    
	
		foreach($allactivities as $activity){
		    $arrayofids[]=$activity->leads_id;
            $activity->too=(int)$per[$i];
            if($activity->save()){
                $lead=Leads::model()->findByPk($activity->leads_id);
                $oldsales=$lead->user_sales;
    			$lead->user_sales= (int)$per[$i]; 
    			$lead->transferdate=$today;
    			$lead->close=NULL;
    			$lead->dtime=$time;
                $lead->communication=NULL;
                $lead->transfer=1;
                if($lead->save()){
        		    $treason ="Multi Transfer";
        			$transfer=new Transfer();
        			$transfer->reason=$treason;
        			$transfer->user_id=$userid;
        			$transfer->lead_id=$lead->id;
        			$transfer->fromm=$oldsales;
        			$transfer->too=$lead->user_sales;
        			$transfer->date= $today ;                     // 03.10.01
        			$transfer->time= $time  ;
        			if($transfer->save()){
        			    $count++;
        			}
                }
            }
             
		}
		
	}
  
Yii::app()->controller->refresh();
}





		$latesearch=TRUE;
		$pdf=TRUE;
		$transfer=TRUE;
		$transfertosales=TRUE;
		$this->render('activitiesfile',array(
				'userid'=>$userid ,	
				'dataProvider'=>$dataProvider,	
				'pdf'=>$pdf,		
				'latesearch'=>$latesearch,
				'transfer'=>$transfer,
				'numbers'=>$numbers,				
				'transfertosales'=>$transfertosales,				
			));

	}else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('login/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
	}

}




public function actionSearchfreshactivities(){
	if(Yii::app()->user->isMember()){
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);


		$close = 1;

		$user=$_REQUEST['userr'];

		$status=$_REQUEST['status'];

		$criteria = new CDbCriteria();        
        $criteria->order="id ASC";                



		$criteria->condition = "close IS NULL";
		//$criteria->addCondition(' ');
		//$start = '2019-01-01';
		$start = date('Y-m-d');
		$end = date('Y-m-d');
		$criteria->addBetweenCondition("follow_date",$start,$end,'AND');
		if(!empty($user) ){

			$criteria->addSearchCondition('user_id', $user,false, "AND");
		}
		if(!empty($status) ){
			$criteria->addSearchCondition('status', $status,false, "AND");
		}

		$dataProvider = new CActiveDataProvider('Activities', array(
				'pagination' => array(
					'pageSize' =>50,
				),
				'criteria' => $criteria,
			));
		$numbers=Activities::model()->count($criteria);
        $count=$numbers;
		if(isset($_POST['downloadpdf'])){
			$allactivities=Activities::model()->findAll($criteria);


		
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s"); 
			$mpdf= Yii::app()->ePdf->mpdf('ar-s');
			//$mpdf->autoLangToFont = false;
			//$mpdf->autoArabic = false;
			//$mpdf->charset_in='utf-8';
			ini_set('max_execution_time', 300);
			ini_set('memory_limit', '-1');
			$html = $this->renderPartial('//sales/_result2',array('allactivities'=>$allactivities,
					'today' => $today,'time' => $time), true);
			$main=Mainsettings::model()->findByPk(1);	    
			$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
			$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
			$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
			$mpdf1->SetProtection(array('print'));
			$mpdf1->SetTitle('LateActivities');
			$mpdf1->SetAuthor("Brandshtine.");
			//$mpdf1->SetWatermarkText("");
			//$mpdf1->showWatermarkText = true;
			//$mpdf1->watermark_font = 'DejaVuSansCondensed';
			//$mpdf1->watermarkTextAlpha = 0.1;
			$mpdf1->SetDisplayMode('fullpage');
			$mpdf1->SetAutoFont('4');		  
			$mpdf1->WriteHTML($html);
			$file_name= 'LateActivities.pdf';
			ob_end_clean();
			$mpdf1->Output($file_name,'I' );

		}



if(isset($_POST['downloadexcel'])){
    
                     $allactivities=Activities::model()->findAll($criteria);

    
	ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');




	foreach($allactivities as $data){
					$data->user_id = $data->employee->fname." ".$data->employee->lname;
					$data->status= $data->statuesaction->title;
					$data->substatus= $data->substatusaction->title;
					if($data->confirm == 1 ){
					    $success='sucess';
					    					$data->confirm= $success;

					}elseif ($data->confirm == 3 ){
					  
					  
					   $failure='failure';
										    					$data->confirm= $failure;  
					 
					}

				
					
				}




$fields = array('name','tel','date','time','user_id','details','follow_date','status','substatus','report' ,'sucess');
$labels= array('name','tel','date','time','user_id','details','follow_date','status','substatus','report' ,'confirm');
XlsExporter2::downloadXls('SOLID fresh Activities  XLS', $allactivities, 'Report-', TRUE  , $labels  , $fields, 'COUNT');


    
    
    
    
    
}



 $arrayofids=array();
if(isset($_POST['Leads']) AND isset($_POST['number'])){

//ini_set('display_errors','On'); 
//error_reporting(E_ALL);

	$per= $_POST['Leads'];
	$num= $_POST['number'];
	$sumsize=0;
	for($x=0;$x<sizeof($num);$x++){
		$sumsize+=(int)$num[$x];
	}
 

	$leadsnum=Activities::model()->count($criteria);

     
    
	$leadsnum = (int)$leadsnum;
	if($sumsize > $leadsnum){
		Yii::app()->user->setFlash('success', "Cannot Proceed This Action Because There is No Enough Leads ");
		Yii::app()->controller->refresh();
	
	}
	    $close = 1;

		$user=$_REQUEST['userr'];

		$status=$_REQUEST['status'];
		
    	$count=0;
	for($i=0;$i<sizeof($per);$i++){
	   
	      

	    	$criteria2 = new CDbCriteria();           
            $criteria2->order="id ASC";             



    		$criteria2->condition = "close IS NULL";
    		//$criteria->addCondition(' ');
    		//$start = '2019-01-01';
    		$start = date('Y-m-d');
    		$end = date('Y-m-d');
    		$criteria2->addBetweenCondition("follow_date",$start,$end,'AND');
    		if(!empty($user) ){
    
    			$criteria2->addSearchCondition('user_id', $user,false, "AND");
    		}
    		if(!empty($status) ){
    			$criteria2->addSearchCondition('status', $status,false, "AND");
    		}
		

			$criteria2->addNotInCondition('leads_id', $arrayofids);
                    
	    	$criteria2->limit = (int)$num[$i];





			$allactivities = Activities::model()->findAll($criteria2);    
                        
 
	    
	
		foreach($allactivities as $activity){
		    $arrayofids[]=$activity->leads_id;
            $activity->too=(int)$per[$i];
            if($activity->save()){
                $lead=Leads::model()->findByPk($activity->leads_id);
                $oldsales=$lead->user_sales;
    			$lead->user_sales= (int)$per[$i]; 
    			$lead->transferdate=$today;
    			$lead->close=NULL;
    			$lead->dtime=$time;
                $lead->communication=NULL;
                $lead->transfer=1;
                if($lead->save()){
        		    $treason ="Multi Transfer";
        			$transfer=new Transfer();
        			$transfer->reason=$treason;
        			$transfer->user_id=$userid;
        			$transfer->lead_id=$lead->id;
        			$transfer->fromm=$oldsales;
        			$transfer->too=$lead->user_sales;
        			$transfer->date= $today ;                     // 03.10.01
        			$transfer->time= $time  ;
        			if($transfer->save()){
        			    $count++;
        			}
                }
            }
             
		}
		
	}
  
Yii::app()->controller->refresh();
}





		$latesearch=TRUE;
		$pdf=TRUE;
		$transfer=TRUE;
		$this->render('activitiesfile',array(
				'userid'=>$userid ,	
				'dataProvider'=>$dataProvider,	
				'pdf'=>$pdf,	
				'count'=>$count,		
				'latesearch'=>$latesearch,
				'transfer'=>$transfer,
				'numbers'=>$numbers,				
			));

	}else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('login/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
	}

}



public function actionDailysalesactivities(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			
			
$this->layout='//layouts/systemcgridview';			


$close = 1; 
$criteria = new CDbCriteria();             
$criteria->addSearchCondition('date', $today, false);



$agent=User::model()->findByPk($userid);
if($agent->sales ==1 or $agent->telesales ==1 ){
$criteria->addSearchCondition('user_id', $userid, false);
}else{
$criteria->addSearchCondition('marketing_id', $userid, false);
}   



$criteria->addCondition('broker_id IS NULL && coldcall IS NULL ');
 
if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}

//$criteria->addSearchCondition('user_id', $today, false);


//$criteria->addSearchCondition('user_id', $arr);


$dataProvider = new CActiveDataProvider('Activities', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));



if(isset($_POST['downloadpdf'])){
                 $allactivities=Activities::model()->findAll($criteria);


		
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 
		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
		//$mpdf->autoLangToFont = false;
		//$mpdf->autoArabic = false;
		//$mpdf->charset_in='utf-8';
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');
		$html = $this->renderPartial('//sales/_result2',array('allactivities'=>$allactivities,
				'today' => $today,'time' => $time), true);
		$main=Mainsettings::model()->findByPk(1);	    
		$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
		$mpdf1->SetProtection(array('print'));
		$mpdf1->SetTitle('DailyActivities-');
		$mpdf1->SetAuthor("Solid.");
		//$mpdf1->SetWatermarkText("");
		//$mpdf1->showWatermarkText = true;
		//$mpdf1->watermark_font = 'DejaVuSansCondensed';
		//$mpdf1->watermarkTextAlpha = 0.1;
		$mpdf1->SetDisplayMode('fullpage');
		$mpdf1->SetAutoFont('4');		  
		$mpdf1->WriteHTML($html);
		$file_name= 'DailyActivities.pdf';
		ob_end_clean();
         	$mpdf1->Output($file_name,'I' );

			}
$pdf=TRUE;

$this->render('activitiesfile',array(
		'userid'=>$userid ,	
		'pdf'=>$pdf,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}

public function actionDailysalesactivitiescold(){
    
$this->layout = '//layouts/systemcgridview';
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			
			
			


$close = 1; 
$criteria = new CDbCriteria();             
$criteria->addSearchCondition('date', $today, false);
$criteria->addSearchCondition('user_id', $userid, false);
            $criteria->addCondition('broker_id IS NULL && coldcall IS NOT NULL ');

 if($_REQUEST['cold']==1){


				$criteria->addSearchCondition('coldcall', $_REQUEST['cold'],false, "AND");
			}else if($_REQUEST['cold']==2){



				$criteria->addCondition('coldcall IS NULL');
			}else{
			}
			
$dataProvider = new CActiveDataProvider('Activities', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));



if(isset($_POST['downloadpdf'])){
                 $allactivities=Activities::model()->findAll($criteria);


		
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 
		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
		//$mpdf->autoLangToFont = false;
		//$mpdf->autoArabic = false;
		//$mpdf->charset_in='utf-8';
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');
		$html = $this->renderPartial('//sales/_result2',array('allactivities'=>$allactivities,
				'today' => $today,'time' => $time), true);
		$main=Mainsettings::model()->findByPk(1);	    
		$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
		$mpdf1->SetProtection(array('print'));
		$mpdf1->SetTitle('DailyActivities-');
		$mpdf1->SetAuthor("Solid.");
		//$mpdf1->SetWatermarkText("");
		//$mpdf1->showWatermarkText = true;
		//$mpdf1->watermark_font = 'DejaVuSansCondensed';
		//$mpdf1->watermarkTextAlpha = 0.1;
		$mpdf1->SetDisplayMode('fullpage');
		$mpdf1->SetAutoFont('4');		  
		$mpdf1->WriteHTML($html);
		$file_name= 'DailyActivities.pdf';
		ob_end_clean();
         	$mpdf1->Output($file_name,'I' );

			}
$pdf=TRUE;

$this->render('activitiesfile',array(
		'userid'=>$userid ,	
		'pdf'=>$pdf,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}



public function actionDailyactivitiesteamleader(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			
			
			
                	    $this->layout = '//layouts/systemcgridview';
			
$allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
$arr=array();

			foreach($allemployee as $leader){
				$arr[]=$leader->sales_id;
			} 

$close = 1; 
$criteria = new CDbCriteria();             
$criteria->addSearchCondition('date', $today, false);
$criteria->addInCondition('user_id', $arr);
if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}
//$criteria->addSearchCondition('user_id', $arr);


$dataProvider = new CActiveDataProvider('Activities', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));



if(isset($_POST['downloadpdf'])){
                 $allactivities=Activities::model()->findAll($criteria);


		
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 
		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
		//$mpdf->autoLangToFont = false;
		//$mpdf->autoArabic = false;
		//$mpdf->charset_in='utf-8';
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');
		$html = $this->renderPartial('//sales/_result2',array('allactivities'=>$allactivities,
				'today' => $today,'time' => $time), true);
		$main=Mainsettings::model()->findByPk(1);	    
		$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
		$mpdf1->SetProtection(array('print'));
		$mpdf1->SetTitle('DailyActivities-');
		$mpdf1->SetAuthor("Solid.");
		//$mpdf1->SetWatermarkText("");
		//$mpdf1->showWatermarkText = true;
		//$mpdf1->watermark_font = 'DejaVuSansCondensed';
		//$mpdf1->watermarkTextAlpha = 0.1;
		$mpdf1->SetDisplayMode('fullpage');
		$mpdf1->SetAutoFont('4');		  
		$mpdf1->WriteHTML($html);
		$file_name= 'DailyActivities.pdf';
		ob_end_clean();
         	$mpdf1->Output($file_name,'I' );

			}
$pdf=TRUE;

$this->render('activitiesfile',array(
		'userid'=>$userid ,	
		'pdf'=>$pdf,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}










public function actionDailysalessuccessactivities(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

                	    $this->layout = '//layouts/systemcgridview';
$close = 1; 
$criteria = new CDbCriteria();   
$criteria->addCondition('broker_id IS NULL');          
$criteria->addSearchCondition('follow_date', $today, false);
$criteria->addSearchCondition('user_id', $userid, false);
$criteria->addSearchCondition('confirm', $close, false);
$criteria->addSearchCondition('close', $close, false);

$dataProvider = new CActiveDataProvider('Activities', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));



if(isset($_POST['downloadpdf'])){
                 $allactivities=Activities::model()->findAll($criteria);


		
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 
		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
		//$mpdf->autoLangToFont = false;
		//$mpdf->autoArabic = false;
		//$mpdf->charset_in='utf-8';
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');
		$html = $this->renderPartial('//sales/_result2',array('allactivities'=>$allactivities,
				'today' => $today,'time' => $time), true);
		$main=Mainsettings::model()->findByPk(1);	    
		$mpdf1 = new mPDF('s','A4','','',10,10,30,35,10,10);
		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
		$mpdf1->SetProtection(array('print'));
		$mpdf1->SetTitle('DailyActivities-');
		$mpdf1->SetAuthor("Solid.");
		//$mpdf1->SetWatermarkText("");
		//$mpdf1->showWatermarkText = true;
		//$mpdf1->watermark_font = 'DejaVuSansCondensed';
		//$mpdf1->watermarkTextAlpha = 0.1;
		$mpdf1->SetDisplayMode('fullpage');
		$mpdf1->SetAutoFont('4');		  
		$mpdf1->WriteHTML($html);
		$file_name= 'DailyActivities.pdf';
		ob_end_clean();
         	$mpdf1->Output($file_name,'I' );

			}
$pdf=TRUE;

$this->render('activitiesfile',array(
		'userid'=>$userid ,	
		'pdf'=>$pdf,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}


public function actionDailyactivities(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);



$this->layout = '//layouts/systemcgridview';




$alldailyactivitiesforadmin=new Activities('dailyactivitiesforadmin');
$alldailyactivitiesforadmin->unsetAttributes();  // clear any default values
if(isset($_GET['Activities'])){
$alldailyactivitiesforadmin->attributes=$_GET['Activities'];
}


                                                            
                                                            
               

$this->render('dailyactivitiesgv',array(
		'count'=>$count ,	
		'userid'=>$userid ,	
		'pdf'=>$pdf,	
                'alldailyactivitiesforadmin'=>$alldailyactivitiesforadmin,				
		));

	    $this->layout = '//layouts/systemcgridview';
		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}








public function actionReopenleadsmonth(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

 $today = date("Y-m-d");
 $reopen = 1; 
 $start = date('Y-m-1'); 
 $end = date('Y-m-31'); 
  $today = date("M");   
 $criteria = new CDbCriteria();
 $criteria->condition = "close IS NULL ";     
 if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}
 if($_GET['indirect']==1){
$criteria->addCondition('indirect IS NOT NULL');
}else if($_GET['indirect']==2){
$criteria->addCondition('indirect IS NULL');
}

$criteria->addBetweenCondition("reopen_date",$start,$end); 
$criteria->addSearchCondition('reopen', $close, false);


$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
	
	
	



public function actionClosedleadsmonth(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

 $today = date("Y-m-d");
 $close = 1; 
 $start = date('Y-m-1'); 
 $end = date('Y-m-31'); 
  $today = date("M");  
  $closedleadsmonth = 1;
 $criteria = new CDbCriteria();       
$criteria->addBetweenCondition("close_date",$start,$end); 
$criteria->addSearchCondition('close', $close, false);
if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else{
$criteria->addCondition('coldcall IS NULL');
}

$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,
                'closedleadsmonth'=>$closedleadsmonth,
                
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}


public function actionClosedleadsmonthbydate() {
    if (Yii::app()->user->isMember()) {
        $this->layout = '//layouts/systemcgridview';
        $userid = Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');
        
        $todayDate = date("Y-m-d");
        $todayMonth = date("M");
        $start = date('Y-m-01');
        $end = date('Y-m-t');
        $close = 1;
        
        $criteria = new CDbCriteria();
        $criteria->addBetweenCondition("date", $start, $end);
        $criteria->compare('close', $close);

        if (!empty($_GET['cold']) && $_GET['cold'] == 1) {
            $criteria->addCondition('coldcall IS NOT NULL');
        } else {
            $criteria->addCondition('coldcall IS NULL');
        }

        if (!empty($_GET['sales'])) {
            $criteria->compare('user_sales', $_GET['sales'], false);
        } else {
            $criteria->compare('user_sales', $userid, false);
        }

        $dataProvider = new CActiveDataProvider('Leads', array(
            'pagination' => array(
                'pageSize' => Yii::app()->params['defaultPageSize'] ?? 50,
            ),
            'criteria' => $criteria,
        ));

        $allleadscount = Leads::model()->count($criteria);

        $this->render('freshleadsfile', array(
            'userid' => $userid,
            'allleadscount' => $allleadscount,
            'dataProvider' => $dataProvider,
            'closedleadsmonth' => 1,
        ));
    } else {
        $this->redirect(array('login/index'));
    }
}

public function actionClosedleadstoday(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$closedleadstoday = 1;

$close = 1; 
$criteria = new CDbCriteria();             
$criteria->addSearchCondition('close_date', $today, false);
$criteria->addSearchCondition('close', $close, false);
if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else{
$criteria->addCondition('coldcall IS NULL');
}

$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


$this->render('freshleadsfile',array(
		'userid'=>$userid ,	
		'closedleadstoday'=>$closedleadstoday ,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}








public function actionDuplicatetoday()
{
    if (Yii::app()->user->isMember()) {
        $userid = Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');
        $today = date("Y-m-d");
        $time = date("H:i:s");
        $rnd = rand(0, 99999);

        $this->layout = '//layouts/systemcgridview';

        $criteria = new CDbCriteria();
        $criteria->addSearchCondition('date', $today, false);

        $dataProvider = new CActiveDataProvider('Duplicate', array(
            'pagination' => array(
                'pageSize' => 50,
            ),
            'criteria' => $criteria,
        ));

        if (isset($_POST['downloadexcel'])) {
            ini_set('max_execution_time', 300);
            ini_set('memory_limit', '-1');

            $allleadss = Duplicate::model()->findAll($criteria);

            foreach ($allleadss as $data) {
                $data->user_id = $data->employee->fname . " " . $data->employee->lname;
            }

            $fields = array('max_date', 'time', 'international_code', 'tel', 'title', 'details', 'user_id');
            $labels = array('max_date', 'time', 'international_code', 'tel', 'title', 'details', 'user_id');
            XlsExporter2::downloadXls('SOLID XLS', $allleadss, 'Report-', TRUE, $labels, $fields, 'COUNT');
        }

        $this->render('duplicatefile', array(
            'userid' => $userid,
            'dataProvider' => $dataProvider,
        ));
    } else {
        $model = new LoginForm;
        // if it is ajax validation request
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'login-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
        // collect user input data
        if (isset($_POST['LoginForm'])) {
            $model->attributes = $_POST['LoginForm'];
            // validate user input and redirect to the previous page if valid
            if ($model->validate() && $model->login())
                $this->redirect(array('login/index'));
        }
        // display the login form
        $this->redirect(array('home/index'));
    }
}








public function actionDuplicatemonth(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


 $today = date("Y-m-d"); 
 $duplicate = 1; 
 $criteria = new CDbCriteria();             
//$criteria->addSearchCondition('date', $today, false);
$start = date("Y-m-01");
$end = date("Y-m-31");
$criteria->addBetweenCondition("date",$start,$end); 





$dataProvider = new CActiveDataProvider('Duplicate', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));

if(isset($_POST['downloadexcel'])){
    

	ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');

                $allleadss=Duplicate::model()->findAll($criteria);

				foreach($allleadss as $data){
					$data->user_id = $data->employee->fname." ".$data->employee->lname;
					 

					 
					
				}




$fields = array('date','time','international_code','tel'
,'title','details','user_id');
$labels= array('date','time','international_code','tel'
,'title','details','user_id');
XlsExporter2::downloadXls('SOLID XLS', $allleadss, 'Report-', TRUE  , $labels  , $fields, 'COUNT');


			}
$this->render('duplicatefile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}









public function actionTransferedtoday(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
                	    $this->layout = '//layouts/systemcgridview';


 $duplicate = 1;
$criteria = new CDbCriteria();             
$criteria->addSearchCondition('date', $today, false);

$dataProvider = new CActiveDataProvider('Transfer', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


$this->render('transferfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}





public function actionClosefeedback(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


$criteria = new CDbCriteria();
$criteria->order = 'id DESC';
$close = 1;
$today = date('Y-m-d');

$criteria->addSearchCondition('feedback_date', $today, false);
$criteria->addSearchCondition('confirmclose', $close, false);

$dataProvider = new CActiveDataProvider('Leads', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));


$this->render('closefeedbackfile',array(
		'userid'=>$userid ,	
                'dataProvider'=>$dataProvider,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}






public function actionReservationtoday(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


$criteria = new CDbCriteria();
$criteria->order = 'id DESC';
$close = 1;
$today = date('Y-m-d');


$criteria->addSearchCondition('date', $today, false);
$allmedia= Reservation::model()->findAll($criteria);



$this->render('reservationfile',array(
		'userid'=>$userid ,	
                'allmedia'=>$allmedia,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}




	}











public function actionActivecampaigns(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$criteria = new CDbCriteria();
$criteria->order = 'id DESC';
$close = 1;
$today = date('Y-m-d');


$criteria->addSearchCondition('hidden', $close, false);
$allcampaign= Campaign::model()->findAll($criteria);



$this->render('campaignsfile',array(
		'userid'=>$userid ,	
                'allcampaign'=>$allcampaign,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}




public function actionCompany(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


$criteria = new CDbCriteria();
$criteria->order = 'id DESC';
$close = 1;
$today = date('Y-m-d');

$criteria->condition = "close IS NULL";

$allcompany = Company::model()->findAll($criteria);



$this->render('companyfile',array(
		'userid'=>$userid ,	
                'allcompany'=>$allcompany ,				
		));

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}




public function actionReport9(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('report9');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}



public function actionReport1(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('report1');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
public function actionAjaxtabaccounting(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('ajaxtabaccounting');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
public function actionAjaxtabcoldsales(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('ajaxtabcoldsales');
 
		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
public function actionAjaxtabcold(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('ajaxtabcold');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
public function actionAjaxtabfreshsalesteamleader(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('ajaxtabfreshsalesteamleader');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
public function actionAjaxtabcoldteamleader(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('ajaxtabcoldteamleader');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
public function actionAjaxtabindirectsales(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('ajaxtabindirectsales');
 
		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
public function actionAjaxtabindirect(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('ajaxtabindirect');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
public function actionAjaxtabfeedback(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('ajaxtabfeedback');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
public function actionAjaxtaballsales(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('ajaxtaballsales');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}

public function actionAjaxtabcharts(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('ajaxtabcharts');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}

public function actionAjaxtabchartsteamleader(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('ajaxtabchartsteamleader');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}


public function actionAjaxmonactivities(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('monactivities');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
	
	
	


public function actionAjaxmonactivitiesconf(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('monactivitiesconf');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	


public function actionAjaxfreshactall(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('freshactall');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
		
	
	
	
	
	

public function actionAjaxdailyactivities(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('dailyactivities');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
		
	
	
	
	
	
	

public function actionAjaxlateactivities(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('lateactivities');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	public function actionAjaxnextactivities(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('nextactivities');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}

	
	
	
public function actionAjaxalllatetransferactivities(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('alllatetransferactivities');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
		
	
	
	
	
	
	
public function actionAjaxclosedleads(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('closedleads');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	

public function actionAjaxsales7(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('sales7');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
	

	




public function actionAjaxsales7cold(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('sales7cold');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
	
	

	
	
	
	
		
	
	
	
public function actionAjaxnotpaidinstallments(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('installments');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
		
public function actionAjaxpaidinstallments(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('paidinstallments');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
		
public function actionAjaxtotalinstallments(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('installmentstotal');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
		
public function actionAjaxprogressinstallments(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('installmentsprogress');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
		
public function actionAjaxinstallmentnums(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('installmentnum');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
			
public function actionAjaxnotpaidinstallmentsnum(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('installmentone');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
	
public function actionAjaxpaidinstallmentsnum(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('installmentnull');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
public function actionAjaxnotpaidforthismonth(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('installmentmonthnull');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
		
public function actionAjaxpaidforthismonth(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('installmentmonth');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
	

public function actionAjaxsuccessactivities(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('successactivities');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
	
	
	
	
	
	
public function actionAjaxsuccessactivitiescold(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('successactivitiescold');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
		
		
	
public function actionAjaxsalesfresh(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('salesfresh');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
	

public function actionAjaxsalesfreshcold(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('salesfreshcold');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
		
		

public function actionAjaxsalesfreshtransfercold(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('salesfreshtransfer');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
			
public function actionAjaxsalesfreshtransfer(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('salesfreshtransfercold');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
			
		

public function actionAjaxsaleslate(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('saleslate');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
				
public function actionAjaxsaleslatecold(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('saleslatecold');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
	
	

public function actionAjaxsaleslatetransfer(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('saleslatetransfer');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
	
	
public function actionAjaxsaleslatetransfercold(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('saleslatetransfercold');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
	
	
	

public function actionAjaxsalenext(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('salenext');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
	
public function actionAjaxsalenextcold(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('salenextcold');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
	
	
	
	
	

public function actionAjaxsalenexttransfer(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('salenexttransfer');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}		
	
	
public function actionAjaxsalenexttransfercold(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('salenexttransfercold');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}		
	
	
	
	
	
public function actionAjaxstatueses(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('statueses');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
	
	
	
	
	
	
public function actionAjaxsales2(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('sales2');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
	
	
	
	
	
	
	
	
public function actionAjaxsales2cold(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('sales2cold');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
	
	
	
	
	
	
	
	
public function actionAjaxclosemonthesales(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('closemonthesales');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}		
	
	public function actionAjaxclosemonthesalescold(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('closemonthesalescold');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}		


	
public function actionAjaxvisitformonthsales(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('visitformonthsales');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}		
	
	
	
	
	
	
public function actionAjaxvisitformonthsalescold(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('visitformonthsalescold');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}		
	
	
public function actionAjaxchatandsupportsales(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('chatandsupportsales');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}		

	
public function actionAjaxdailyrecordersales(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('dailyrecordersales');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}		
	
public function actionAjaxdailyrecordersalescold(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('dailyrecordersalescold');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}		
	

	
public function actionAjaxsalesclosemonthchart(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('salesclosemonthchart');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}		
	
	

	
public function actionAjaxsales1(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('sales1');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}		
	
public function actionAjaxsales1cold(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('sales1cold');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}			

	
public function actionAjaxallfeedbackleads(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('allfeedbackleads');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}		
		




public function actionAjaxfeedbackleads(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('feedbackleads');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}		
			
	
	
	
public function actionAjaxfeedbackleadsactivties(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('feedbackleadsactivties');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}		
		
		
		
public function actionAjaxlatefeedbackleadsactivties(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('latefeedbackleadsactivties');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}		
		
		
		
public function actionAjaxnextfeedbackleadsactivties(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('nextfeedbackleadsactivties');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}		
			
	

public function actionAjaxdailyfeedback(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('dailyfeedback');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	



public function actionAjaxbacktolifeall(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('backtolifeall');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
public function actionAjaxbacktolife(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('backtolife');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	public function actionAjaxbacktolifemonth(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('backtolifemonth');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
		
	
	
public function actionAjaxclosefeedback(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('closefeedback');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
				
	
	
	
public function actionAjaxclosemonth(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('closemonth');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	

	

	
		
	
	
	
	
	
public function actionDailyactivitieschart(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('dailyactivitieschart');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	

	
		
	
	
	
	
	
public function actionPlatformvscampaignchart(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('platformvscampaignchart');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
	
	
public function actionReport8(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('report8');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}





	
public function actionStatussales(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('statussales');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}

public function actionStatussalescold(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('statussalescold');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}

	
public function actionActivitycalendarsales(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('activitycalendarsales');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
public function actionActivitycalendarmanager(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('activitycalendarmanager');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	public function actionActivitycalendarteamleader(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('activitycalendarteamleader');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}


	
public function actionClosemonthchart(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('closemonthchart');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
	
	
public function actionAllleads(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('allleads');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
public function actionMixed(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('mixed');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
	
public function actionNotclear(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('notclear');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
public function actionNonqualified(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('nonqualified');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
		
public function actionAllleadsrec(){
		if(Yii::app()->user->isMember()){
		    $this->layout = '';
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('qualified');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	





























	public function actionOnesignal(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

		$user=User::model()->findByPk($userid);

if(strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'mobile') ) { 

$user->player_id_mobile=$_POST['player_id'];
$user->save();

}else{

$user->player_id=$_POST['player_id'];
$user->save();

}
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);		}

	}


public function actionReset(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);                    // 17:16:18

                        $model1 = Mainsettings::model()->findByPk(1);     //  used

                        $model2 = Mainsettings::model()->findByPk(2);    // last used 

                        $model3 = Mainsettings::model()->findByPk(3);   // default
                        

                        $model2->setAttributes($model1->getAttributes(), false);
                        $model2->id=2;
                        $model2->save(false);


                        $model1->setAttributes($model3->getAttributes(), false);
                        $model1->id=1;
                        $model1->save(false); 
                        
                        
        
		$this->redirect('theme');                
                    
		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}




public function actionUndo(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);                    // 17:16:18

                        $model1 = Mainsettings::model()->findByPk(1);     //  used

                        $model2 = Mainsettings::model()->findByPk(2);    // last used 
                        

                        $model1->setAttributes($model2->getAttributes(), false);
                        $model1->id=1;
                        $model1->save(false);


                        
                        
        
		$this->redirect('theme');                
                    
		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}






public function actionNotifications(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

$this->render('notifications');

		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}











	public function actionDashboardsales($id){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
            $salesid = $id;
            $ones = 3;
			$this->oness = $ones ;
			$this->salesx = $id ;

                	    $this->layout = '//layouts/systemdashboardsales';
			$activities = new CDbCriteria();
			$activities->addSearchCondition('follow_date', $today, false);
			$activities->addSearchCondition('user_id', $userid, false);
			$allactivities = Activities::model()->findAll($activities);
			$visible = 1;

			$allfloor = Floor::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$alltypebuliding = TypeBuliding::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));



			$user=User::model()->findByAttributes(array('id'=>$userid));

		

		
		
		
		
			$this->render('dashboardsales',array(
					'userid'=>$userid ,
					'allactivities'=>$allactivities,
					'user'=>$user,	
					'allfloor'=>$allfloor,       
					'alltypebuliding'=>$alltypebuliding, 
					'salesid'=>$salesid,
					'ones'=>$ones,
					'sales'=>$salesx,


				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);		}

	}


	public function actionDashboard(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			
	    $this->layout = '//layouts/systemdashboard';
			
		
		
			$visible = 1;
			$ones = 1;
			$this->oness = $ones ;

			$allfloor = Floor::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$alltypebuliding = TypeBuliding::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));



			$user=User::model()->findByAttributes(array('id'=>$userid));

		
		if($user->salesmanger == 1){
		    				$this->redirect(array('login/admin')	);

		    
		}elseif($user->sales == 1 or $user->telesales == 1 ){
		    
		    
		    
$main = Mainsettings::model()->findByPk(1);



		    		    				$this->redirect(array('login/sales')	);

		    
		    
		}elseif($user->teamleader == 1){
		    		    				$this->redirect(array('login/teamleader')	);

		    
		    
		}else{
		    
		}
		
		
			$this->render('dashboard',array(
					'userid'=>$userid ,
					'user'=>$user,
					'ones'=>$ones,
					'allfloor'=>$allfloor,       
					'alltypebuliding'=>$alltypebuliding,       

				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);		}

	}




public function actionAdmin(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			
	    $this->layout = '//layouts/systemdashboard';
			
		
			$visible = 1;
			$ones = 1;
			$this->oness = $ones ;

			$allfloor = Floor::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$alltypebuliding = TypeBuliding::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));



			$user=User::model()->findByAttributes(array('id'=>$userid));

		

		
		
		
		
			$this->render('admin',array(
					'userid'=>$userid ,
					'user'=>$user,
					'ones'=>$ones,
					'allfloor'=>$allfloor,       
					'alltypebuliding'=>$alltypebuliding,       

				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);		}

	}


public function actionSales(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			
	    $this->layout = '//layouts/systemdashboard';
			
		
			$visible = 1;
			$ones = 1;
			$this->oness = $ones ;

			$allfloor = Floor::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$alltypebuliding = TypeBuliding::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));



			$user=User::model()->findByAttributes(array('id'=>$userid));

		

		
		
		
		
			$this->render('sales',array(
					'userid'=>$userid ,
					'user'=>$user,
					'ones'=>$ones,
					'allfloor'=>$allfloor,       
					'alltypebuliding'=>$alltypebuliding,       

				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);		}

	}


public function actionTeamleader(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			
	    $this->layout = '//layouts/systemdashboard';
			
		
			$visible = 1;
			$ones = 1;
			$this->oness = $ones ;

			$allfloor = Floor::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$alltypebuliding = TypeBuliding::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));



			$user=User::model()->findByAttributes(array('id'=>$userid));

		

		
		
		
		
			$this->render('teamleader',array(
					'userid'=>$userid ,
					'user'=>$user,
					'ones'=>$ones,
					'allfloor'=>$allfloor,       
					'alltypebuliding'=>$alltypebuliding,       

				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);		}

	}








	public function actionSettings(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

		
		

		
		
		
		
			$this->render('settings',array(
					'userid'=>$userid ,	
       

				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);		}

	}





public function actionMainsettings(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);		
		
			$this->render('mainsettings',array(
					'userid'=>$userid ,	
       

				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);		}

	}











	
public function  actionEditdesign(){

if(Yii::app()->user->isMember())
	{
$userid=Yii::app()->user->id;
	date_default_timezone_set('Africa/Cairo');  
	$today = date("Y-m-d");                     // 03.10.01
	$time = date("H:i:s");                      // 17:16:18	
	$rnd = rand(0,99999);
$id=$_POST['id'];
$model=Designbuilding::model()->findByPk(array('id'=>$id));

$model->title= $_POST['Designbuilding']['title'];
$model->icon= $_POST['Designbuilding']['icon'];


if($model->save()){

$this->redirect(array('adddesign')	);
}else{
}



}
else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

}










	
public function  actionDeletedesign($id){

if(Yii::app()->user->isMember())
	{
$userid=Yii::app()->user->id;
	date_default_timezone_set('Africa/Cairo');  
	$today = date("Y-m-d");                     // 03.10.01
	$time = date("H:i:s");                      // 17:16:18	
	$rnd = rand(0,99999);
$model=Designbuilding::model()->findByPk(array('id'=>$id));



if($model->delete()){

$this->redirect(array('adddesign')	);
}else{
}



}
else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

}




public function actionAdddesign()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		$alldesign=Designbuilding::model()->findAll();
		
		$model = new Designbuilding();
		$model->setScenario('com_porfile');
		if (isset($_POST['Designbuilding'])) {
		$rnd = rand(0,9999);


		$model->attributes = $_POST['Designbuilding'];

		if ($model->save()) {

                

		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User Create Design building ';
		$logsystem->action_id = $model->id;
		$logsystem->ip = $model->id;
        $logsystem->secert = $model->id;
		$logsystem->user_id = $userid;
		$logsystem->save();


		Yii::app()->controller->refresh();
		}
		}

		
		
		
		
		$this->render('adddesign',array(
		'userid'=>$userid ,	
                'model'=>$model,	
                'alldesign'=>$alldesign,			
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}






		public function actionSmsControl()
		{
		if(Yii::app()->user->isMember())
		{
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		
		$settings= Mainsettings::model()->findByPk(1);

		
		
		
		$model = new Mainsettings();
		if (isset($_POST['Mainsettings'])) {

		
		
		$model = Mainsettings::model()->findByPk(1);


		$rnd = rand(0,9999);

if(!empty($_POST['Mainsettings']['username'])){
		$model->username= $_POST['Mainsettings']['username'];
}
if(!empty($_POST['Mainsettings']['password'])){
		$model->password= $_POST['Mainsettings']['password'];
}
if(!empty($_POST['Mainsettings']['sender'])){
		$model->sender= $_POST['Mainsettings']['sender'];
}
if(!empty($_POST['Mainsettings']['msg_pt1'])){
		$model->msg_pt1= $_POST['Mainsettings']['msg_pt1'];
}
if(!empty($_POST['Mainsettings']['msg_pt2'])){
		$model->msg_pt2= $_POST['Mainsettings']['msg_pt2'];
}

		if ($model->save()) {



		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User update SMS control';
		$logsystem->action_id = $model->id;
		$logsystem->ip = $model->id;
		$logsystem->user_id = $userid;
		$logsystem->save();


		Yii::app()->controller->refresh();
		}
		}

		
		
		
		
		$this->render('smscontrol',array(
		'userid'=>$userid ,	
        'model'=>$model ,			
        'settings'=>$settings,

		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}






		public function actionTheme()
		{
		if(Yii::app()->user->isMember())
		{
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		
		$settings= Mainsettings::model()->findByPk(1);

		
		$model= Mainsettings::model()->findByPk(1);

		if (isset($_POST['Mainsettings'])) {

		



		$rnd = rand(0,9999);

if(!empty($_POST['Mainsettings']['menu_color'])){
		$model->menu_color= $_POST['Mainsettings']['menu_color'];
}
if(!empty($_POST['Mainsettings']['menu_header_color'])){
		$model->menu_header_color= $_POST['Mainsettings']['menu_header_color'];
}
if(!empty($_POST['Mainsettings']['menu_nav_header_color'])){
		$model->menu_nav_header_color= $_POST['Mainsettings']['menu_nav_header_color'];
}
if(!empty($_POST['Mainsettings']['menu_links_bg'])){
		$model->menu_links_bg= $_POST['Mainsettings']['menu_links_bg'];
}
if(!empty($_POST['Mainsettings']['side_menu_nav_circle'])){
		$model->side_menu_nav_circle= $_POST['Mainsettings']['side_menu_nav_circle'];
}
if(!empty($_POST['Mainsettings']['side_menu_calendar_text'])){
		$model->side_menu_calendar_text= $_POST['Mainsettings']['side_menu_calendar_text'];
}
if(!empty($_POST['Mainsettings']['comp_title_color'])){
		$model->comp_title_color= $_POST['Mainsettings']['comp_title_color'];
}
if(!empty($_POST['Mainsettings']['comp_beside_title_color'])){
		$model->comp_beside_title_color= $_POST['Mainsettings']['comp_beside_title_color'];
}
if(!empty($_POST['Mainsettings']['table_content_text_size'])){
		$model->table_content_text_size= $_POST['Mainsettings']['table_content_text_size'];
}
if(!empty($_POST['Mainsettings']['table_content_text_color'])){
		$model->table_content_text_color= $_POST['Mainsettings']['table_content_text_color'];
}
if(!empty($_POST['Mainsettings']['comp_text_size'])){
		$model->comp_text_size= $_POST['Mainsettings']['comp_text_size'];
}

if(!empty($_POST['Mainsettings']['menu_links_color'])){
		$model->menu_links_color= $_POST['Mainsettings']['menu_links_color'];
}

if(!empty($_POST['Mainsettings']['menu_links_color_on_hover'])){
		$model->menu_links_color_on_hover= $_POST['Mainsettings']['menu_links_color_on_hover'];
}

if(!empty($_POST['Mainsettings']['menu_links_color_on_active'])){
		$model->menu_links_color_on_active= $_POST['Mainsettings']['menu_links_color_on_active'];
}

if(!empty($_POST['Mainsettings']['menu_links_size'])){
		$model->menu_links_size= $_POST['Mainsettings']['menu_links_size'];
}
if(!empty($_POST['Mainsettings']['box_main_background'])){
		$model->box_main_background= $_POST['Mainsettings']['box_main_background'];
}
if(!empty($_POST['Mainsettings']['box_title_color'])){
		$model->box_title_color= $_POST['Mainsettings']['box_title_color'];
}
if(!empty($_POST['Mainsettings']['box_title_size'])){
		$model->box_title_size= $_POST['Mainsettings']['box_title_size'];
}
if(!empty($_POST['Mainsettings']['bar_lvl_1'])){
		$model->bar_lvl_1= $_POST['Mainsettings']['bar_lvl_1'];
}
if(!empty($_POST['Mainsettings']['bar_lvl_2'])){
		$model->bar_lvl_2= $_POST['Mainsettings']['bar_lvl_2'];
}
if(!empty($_POST['Mainsettings']['bar_lvl_3'])){
		$model->bar_lvl_3= $_POST['Mainsettings']['bar_lvl_3'];
}
if(!empty($_POST['Mainsettings']['bar_lvl_4'])){
		$model->bar_lvl_4= $_POST['Mainsettings']['bar_lvl_4'];
}



if(!empty($_POST['Mainsettings']['unlock_sales'])){
		$model->unlock_sales= $_POST['Mainsettings']['unlock_sales'];
}


if(!empty($_POST['Mainsettings']['platformhidden'])){
		$model->platformhidden= $_POST['Mainsettings']['platformhidden'];
}
if(!empty($_POST['Mainsettings']['substatusreq'])){
		$model->substatusreq= $_POST['Mainsettings']['substatusreq'];
}


$old=$model->logo_colored;
              $uploadedFile=CUploadedFile::getInstance($model,'logo_colored');
	       if(! empty ($uploadedFile)){
	       $fileName = "{$rnd}-{$uploadedFile}";  // random number + file name
	       $model->logo_colored = $fileName;
	       $uploadedFile->saveAs(Yii::app()->basePath.'/../img/'.$fileName);
	       
	       }else{
$model->logo_colored=$old;
}


		if ($model->save()) {



		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User update Theme control';
		$logsystem->action_id = $model->id;
		$logsystem->ip = $model->id;
		$logsystem->user_id = $userid;
		$logsystem->save();


		Yii::app()->controller->refresh();
		}
		}

		
		
		
		
		$this->render('theme',array(
		'userid'=>$userid ,	
        'model'=>$model ,			
        'settings'=>$settings,

		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}












		public function actionReportedemails()
		{
		if(Yii::app()->user->isMember())
		{
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		
		$reported= Reportedemails::model()->findAll();

		
		
		
						$model= new Reportedemails();


if(isset($_POST['Reportedemails'])){
		$i=0;
					foreach((array)$_POST['Reportedemails']["title"] as $item){

						$model= new Reportedemails();
						$model->setScenario('com_porfile');
						if(isset($_POST['Reportedemails'])){
				    
			

							$arr=$_POST['Reportedemails'];


							$model->email=$arr['email'][$i];
							$model->mobile=$arr['mobile'][$i];
							$i++;
							$model->title=$item;


							if(!$model->save()){
								$errores = $model->getErrors();
								//var_dump($errores);
							}
							else{
								//echo($newmodel->id);
							}
				
						}
					}
}

		
		
		
		
		$this->render('reportedemails',array(
		'userid'=>$userid ,	
        'model'=>$model ,			
        'reported'=>$reported,

		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}












public function  actionDeletereportedemail($id){

		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$model=Reportedemails::model()->findByPk($id);
			if($model->delete()){

				$logsystem = new Logsystem();
				$logsystem->date = $today;
				$logsystem->time = $time;
				$logsystem->action = 'User deleted reportedemails ';
				$logsystem->action_id = $model->id;
				$logsystem->ip = $model->id;
				$logsystem->secert = $model->id;
				$logsystem->user_id = $userid;
				$logsystem->save();
				$this->redirect(array('login/reportedemails')	);
			}



		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}


public function  actionOrderiscomming($id){

		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$model=Officeboyorders::model()->findByPk($id);
                        $model->close=1;
			if($model->save()){

				$this->redirect(array('login/coffeemaker')	);
			}



		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}






public function actionHeaderimg()
		{
		if(Yii::app()->user->isMember())
		{
		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		
		$model = Mainsettings::model()->findByPk(1);

		
		
		if (isset($_POST['Mainsettings'])) {

               

$model->clause=$_POST['Mainsettings']['clause'];
$model->clause2=$_POST['Mainsettings']['clause2'];

$old=$model->headerphoto;
              $uploadedFile1=CUploadedFile::getInstance($model,'headerphoto');
	       if(! empty ($uploadedFile1)){
	       $fileName1 = "{$rnd}-{$uploadedFile1}";  // random number + file name
	       $model->headerphoto = $fileName1;
	       

	       }else{
$model->headerphoto=$old;
}



$old=$model->footerphoto;
              $uploadedFile2=CUploadedFile::getInstance($model,'footerphoto');
	       if(! empty ($uploadedFile2)){
	       $fileName2 = "{$rnd}-{$uploadedFile2}";  // random number + file name
	       $model->footerphoto = $fileName2;

	       }else{
$model->footerphoto=$old;
}
$old=$model->logo;
              $uploadedFile3=CUploadedFile::getInstance($model,'logo');
	       if(! empty ($uploadedFile3)){
	       $fileName3 = "{$rnd}-{$uploadedFile3}";  // random number + file name
	       $model->logo = $fileName3;

	       }else{
$model->logo =$old;
}







		if ($model->save()) {
		    
if(!empty($uploadedFile1)){		    
$uploadedFile1->saveAs(Yii::app()->basePath.'/../img/'.$fileName1);
}

if(!empty($uploadedFile2)){	
$uploadedFile2->saveAs(Yii::app()->basePath.'/../img/'.$fileName2);
}

if(!empty($uploadedFile3)){	
$uploadedFile3->saveAs(Yii::app()->basePath.'/../img/'.$fileName3);
}


		$logsystem = new Logsystem();
		$logsystem->date = $today;
		$logsystem->time = $time;
		$logsystem->action = 'User update SMS control';
		$logsystem->action_id = $model->id;
		$logsystem->ip = $model->id;
		$logsystem->user_id = $userid;
		$logsystem->save();


		Yii::app()->controller->refresh();
		}else{

}
		}

		
		
		
		
		$this->render('headerfooterimg',array(
		'userid'=>$userid ,	
        'model'=>$model ,	

		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}








	public function actionMakereport()
		{
			if(Yii::app()->user->isMember())
			{
                $userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);			
if(isset($_POST['reportbtn'])){
                $messagesecret=$_POST['secert'];

			$model=Customerservice::model()->findByAttributes(array('Secret'=>$messagesecret));

        $model->report=$_POST['report'];
        if ($model->save() AND $_POST['profile']){
 
					$this->redirect(array('leads/profile/'.$model->lead_id), false);
        }else{
         	    $this->redirect(array('messages')	);   
        }
}
			
		}
		
	
			else{
				$model=new LoginForm;
				// if it is ajax validation request
				if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
				{
					echo CActiveForm::validate($model);
					Yii::app()->end();
				}
				// collect user input data
				if(isset($_POST['LoginForm']))
				{
					$model->attributes=$_POST['LoginForm'];
					// validate user input and redirect to the previous page if valid
					if($model->validate() && $model->login())
						$this->redirect(array('home/index')	);
				}
				// display the login form
				$this->redirect(array('home/index')	);
			}

}








public function actionSubticket($id)
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
                	    $this->layout = '//layouts/systemcgridview';
 
$message  = Customerservice::model()->findByPk($id);
/*
if($message->employee_id != $userid AND $message->user_id != $userid  ) {
    $this->redirect(array('leads/profile/'.$message->lead_id)	);
}
*/
$allservices = Customerservice::model()->findAll(array('condition'=>" parent_id = ".$id , 'order'=>'id DESC'));


		$model = new Customerservice();
		$model->setScenario('com_porfile');
		if (isset($_POST['Customerservice'])) {
		$rnd = rand(0,9999);
		$model->user_id = $userid;
		$model->date = $today;
		$model->time = $time;  
		$model->attributes = $_POST['Customerservice'];
		$model->parent_id=$_POST['Customerservice']["parent_id"];

		if ($model->save()) {

     

		Yii::app()->controller->refresh();
		}
		}

		
		
		
		
		$this->render('subticket',array(
		'userid'=>$userid ,	
                'model'=>$model,
                'message'=>$message,	
                'allservices'=>$allservices,			
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}




	public function actionMessages()
		{
			if(Yii::app()->user->isMember())
			{
                $userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);			

$criteria= new CDbCriteria();

            $criteria->condition = "parent_id IS  NULL  "; 
							$criteria->addSearchCondition('employee_id', $userid, false , 'AND');
        			 
        					
$allmessagesunseen = Customerservice::model()->findAll($criteria);
if(empty($allmessagesunseen)){
    
$criteria= new CDbCriteria();

            $criteria->condition = "parent_id IS  NULL  "; 
            $criteria->addSearchCondition('user_id', $userid, false , 'AND'); 
            $allmessagesunseen = Customerservice::model()->findAll($criteria);
}

 
			$this->render('msg',array(
			'userid'=>$userid ,		
                        'allmessagesseen'=>$allmessagesseen,
                        'allmessagesunseen'=>$allmessagesunseen,
       

				));
		

		}	else{
				$model=new LoginForm;
				// if it is ajax validation request
				if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
				{
					echo CActiveForm::validate($model);
					Yii::app()->end();
				}
				// collect user input data
				if(isset($_POST['LoginForm']))
				{
					$model->attributes=$_POST['LoginForm'];
					// validate user input and redirect to the previous page if valid
					if($model->validate() && $model->login())
						$this->redirect(array('home/index')	);
				}
				// display the login form
				$this->redirect(array('home/index')	);
			}
	}
		





public function actionLeaddocument(){

if(Yii::app()->user->isMember())
	{
$userid=Yii::app()->user->id;
 
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                    // 03.10.01
			$time = date("H:i:s");   
if(isset($_POST['leaddocument'])){


$secert=$_POST['id'];
$filestorage=$_POST['file'];
$model= new DocumentStorage();
$rnd = rand(0,9999);
				$model->attributes = $_POST['DocumentStorage'];
				$model->date= $today;
				$model->user_id= $userid;
				$model->date= $today;
				$model->time= $time;
				$model->lead_id= $secert;
				$model->type_document_id= 1;
				$model->file=$_POST['file'];
				//$model->Secret= $userid.$rnd;
				//var_dump($filestorage);exit;

				
				

	       
	       
	       	$uploadedFile=CUploadedFile::getInstance($model,'file');
	
			if(! empty ($uploadedFile)){
				$fileName = "{$rnd}-{$uploadedFile}";  // random number + file name
				$building->upload= $fileName;
				$uploadedFile->saveAs(Yii::app()->basePath.'/../uploads/'.$fileName);
				var_dump($uploadedFile);exit;
				$out=Yii::app()->basePath.'/../uploads/'.$fileName;
			}
				
				if($model->save()){


 


					$this->redirect(array('leads/profile/'.$secert)	);
}


}
	}
else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

}


	
public function actionLeadmessage(){

if(Yii::app()->user->isMember())
	{
$userid=Yii::app()->user->id;
 
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                    // 03.10.01
			$time = date("H:i:s");   
if(isset($_POST['leadmessage'])){

$secert=$_POST['id'];
$model= new Customerservice();
$rnd = rand(0,9999);
				$model->attributes = $_POST['Customerservice'];
				$model->date= $today;
				$model->user_id= $userid;
				$model->date= $today;
				$model->time= $time;
				$model->lead_id= $secert;
				$model->Secret= $userid.$rnd;
				if($model->save()){


 


					$this->redirect(array('leads/profile/'.$secert)	);
}


}
	}
else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

}





	public function actionCs(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

		
		$allmedia=Contract::model()->findAll();
	                $model = new Customerservice();
			$model->setScenario('com_porfile');
			if(isset($_POST['Customerservice'])){
                                
				$rnd = rand(0,9999);
				$model->attributes = $_POST['Customerservice'];
				$model->date= $today;
				$model->user_id= $userid;
				$model->time= $time;
				$model->Secret= $userid.$rnd;
				if($model->save()){



$user=User::model()->findByPk($model->employee_id);



					Yii::app()->controller->refresh();
				}
			}
		
		$visible = 1;
		
			$allsales = User::model()->findAll(array('condition'=>'level='.$visible , 'order'=>'id DESC'));



			$allservices = Services::model()->findAll();




$criteria = new CDbCriteria();
 $criteria->order = 'id DESC';
$criteria->addCondition('Secret IS NOT NULL');
$allmessages = Customerservice::model()->findAll($criteria); 

		//	$allmessages = Customerservice::model()->findAll(array('order'=>'id DESC'));


		
			$this->render('cs',array(
			'userid'=>$userid ,	
                        'allsales'=>$allsales,	
                        'allservices'=>$allservices ,	
                        'allmessages'=>$allmessages,	
                        'model'=>$model ,		
                        'allmedia'=>$allmedia,	
       

				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);		}

	}












	public function actionUser(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");
			$time = date("H:i:s");
			$rnd = rand(0,99999);			
            $active = 1;
            $block = 5;
            $this->layout = '//layouts/systemcgridview';
            $criteria = new CDbCriteria();
            $criteria->condition = "flag IS NULL ";
            $criteria->addCondition('level=' . $active);
            $alluser=User::model()->findAll($criteria);
			$criteriax = new CDbCriteria();
            $criteriax->condition = "flag IS NULL ";
            $criteriax->addCondition('level=' . $block);
            $allblockuser=User::model()->findAll($criteriax);
			$activeuser = 1;
			$model = new User();
			$model->setScenario('com_porfile');
			if(isset($_POST['User'])){
                $rnd = rand(0,9999);
                $model->attributes = $_POST['User'];
                $model->level = $activeuser;

                if(sizeOf((array)$_REQUEST['distributeto'])>1){
                    $intArray4 = array_map(
					function($value4){ return (int)$value4; },
    					$_REQUEST['distributeto']
    				);
                    $remove = array(0);
                    $result = array_diff($intArray4, $remove); 
                    $string=implode(",",$result );
				    $model->distribute_to = $string; 
			    }


               $uploadedFile=CUploadedFile::getInstance($model,'image');
	       if(! empty ($uploadedFile)){
	       $fileName = "{$rnd}-{$uploadedFile}";  // random number + file name
	       $model->image = $fileName;
	       $uploadedFile->saveAs(Yii::app()->basePath.'/../uploads/'.$fileName);
	       }
	       
	       if($model->teamleader==1){
	           $model->teamname=$model->fname." ".$model->lname." Team";
	       }

				if($model->save()){
			$this->redirect(array('login/settings'));
				}else{var_dump($model->getErrors());}
			}
			if(isset($_POST['Change'])){
			    
			    
			   
			    
				$edituser = User::model()->findByPk($_POST['Change']);
				if($edituser->level == 1) { $edituser->level = 5; $edituser->diactivation_date=$today;}
				else if($edituser->level == 5) {$edituser->level = 1; $edituser->diactivation_date=NULL;}
				if($edituser->save())
				Yii::app()->controller->refresh(); else throw new CHttpException(404,'The specified post cannot be found.');
				
			   
				
			}


			$this->render('user',array(
					'alluser'=>$alluser ,
					'allblockuser'=>$allblockuser ,
					'userid'=>$userid ,
					'model'=>$model ,
				));
		}
		

		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
		
	
	
	
	public function actionExportUsers()
{
    if (!Yii::app()->user->isMember()) {
        throw new CHttpException(403, 'Forbidden');
    }

    ini_set('max_execution_time', 300);
    ini_set('memory_limit', '-1');

    // نفس فلترة الشاشة افتراضيًا — مرّر ?all=1 لو عايز الكل
    $criteria = new CDbCriteria();
    $criteria->order = 'id DESC';
    if (Yii::app()->request->getQuery('all') != 1) {
        $criteria->addCondition('flag IS NULL');
    }

    $users = User::model()->findAll($criteria);

    // اختَر حقول موجودة فعلًا في جدول user
    $preferredOrder = [
        'id','fname','lname','email','mobile',
        'level','teamleader','teamname','distribute_to',
        'activation_date','diactivation_date','created_at','updated_at','image','hrid'
    ];
    $cols = array_keys(User::model()->tableSchema->columns);
    $has  = function($n) use ($cols){ return in_array($n, $cols, true); };
    $fields = array_values(array_filter($preferredOrder, $has)); // أسماء attributes بالظبط

    // تحسينات عرض بسيطة بدون إضافة خصائص جديدة
    foreach ($users as $u) {
        // دمج كود دولي لو العمودين موجودين
        if ($has('mobile') && $has('international_code') && $u->international_code && $u->mobile) {
            if (strpos($u->mobile, (string)$u->international_code) !== 0) {
                $u->mobile = $u->international_code . $u->mobile;
            }
        }
        // Level نصي (لسه نفس العمود "level")
        if ($has('level')) {
            $u->level = ((int)$u->level === 1) ? 'Active' : (((int)$u->level === 5) ? 'Blocked' : (string)$u->level);
        }
        // Teamleader نص
        if ($has('teamleader')) {
            $u->teamleader = ((int)$u->teamleader === 1) ? 'Yes' : 'No';
        }
        // تنسيق تواريخ لو موجودة
        foreach (['activation_date','diactivation_date','created_at','updated_at'] as $dt) {
            if ($has($dt) && !empty($u->$dt)) {
                $ts = strtotime($u->$dt);
                if ($ts) {
                    $u->$dt = in_array($dt, ['created_at','updated_at'], true)
                        ? date('Y-m-d H:i:s', $ts)
                        : date('Y-m-d', $ts);
                }
            }
        }
    }

    // مهم: نظّف أي output قبل التصدير
    while (ob_get_level()) { ob_end_clean(); }

    /**
     * الترتيب الصحيح للباراميترات:
     * downloadXls($filename, $data, $title=false, $header=false, $fields=false, $type='lines')
     *
     * بنمرر: filename, users(AR), title, header=true, fields(Attributes)، type اختياري
     */
    XlsExporter2::downloadXls('SOLID Users XLS', $users, 'Users-', true, $fields, 'COUNT');

    Yii::app()->end();
}

	
	
	public function actionEdituser($id){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$model = User::model()->findByPk($id);
			$model->setScenario('com_porfile');
			if(isset($_POST['User'])){
				$oldpassword = $model->password;
	       $_POST['User']['image'] = $model->image;

				$model->attributes = $_POST['User'];
				
			//	if(empty($_POST['User']['marketinglevel'])){
	       	    
	       	   // var_dump($_POST['User']['marketinglevel']);exit;
	       	    
	       //	}
if (isset($_POST['User']['limitsformarketing']) && is_array($_POST['User']['limitsformarketing'])) {
    $model->limitsformarketing = implode(',', array_filter($_POST['User']['limitsformarketing']));
}
if($_POST['User']['pre_distribute']==0 OR $_POST['User']['distribute']==0){

$criteria = new CDbCriteria();
	$criteria->condition = "communicate_date IS NULL ";
	$criteria->addCondition('distribute_id=' . $id);
	$criteria->addCondition('hidden=1');
	$allduplicate=Leads::model()->findAll($criteria);
        if(!empty($allduplicate)){
        Yii::app()->user->setFlash('bad', "Cannot Remove Distribution Because The User Have Leads");
	Yii::app()->controller->refresh();
}
}

                        if(sizeOf($_REQUEST['distributeto'])>1){
                                        $intArray4 = array_map(
					function($value4){ return (int)$value4; },
					$_REQUEST['distributeto']
				);
                                $remove = array(0);
                                $result = array_diff($intArray4, $remove); 
                                $string=implode(",",$result );
				$model->distribute_to = $string; 
			}else{$model->distribute_to ='';}



$old=$model->image;
              $uploadedFile=CUploadedFile::getInstance($model,'image');
	       if(! empty ($uploadedFile)){
	       $fileName = "{$rnd}-{$uploadedFile}";  // random number + file name
	       $model->image = $fileName;
	       $uploadedFile->saveAs(Yii::app()->basePath.'/../uploads/'.$fileName);
	       
	       }
	       
	       	

				if(empty($_POST['User']['password'])){
					$model->password = $oldpassword;
				} else{ $model->password = $model->hashPassword($_POST['User']['password']);
				
				
                    $criteria = new CDbCriteria();         
                    $criteria->order = 'id DESC';
                    $criteria->addSearchCondition('user_id', $id , false);
                    $allsess= Sessions::model()->findAll($criteria);
                    if(!empty($allsess)){
                    foreach($allsess as $sess){
                    $sess->expire = 1;
                    $sess->save();
                    }
                    }

				    
				}
				if($model->save())
				$this->redirect(array('user')); else throw new CHttpException(404,'The specified post cannot be found.');
			}


			$this->render('edituser',array(
					'userid'=>$userid ,
					'model'=>$model ,
				));
		}
		

		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
		
		

		
	public function actionProfile(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                        // 17:16:18	
			$rnd= rand(0,99999);                    // 17:16:18	
			$model = User::model()->findByPk($userid);
			$model->setScenario('com_porfile');
			
			
			  $va=new Vacationsbalance;
            if(isset($_POST['Vacationsbalance']))
            {   
                $va->attributes=$_POST['Vacationsbalance'];
                $type = $_POST['Vacationsbalance']['type'];
                $typedetails=Vacations::model()->findByPk($type);

                //var_dump($type);exit;
                            $va->time = $time;
                        	$va->date = $today;
                            $va->user_id = $userid;
                            $va->employee_id = $userid;
                            $va->noofdays = $typedetails->nodays;
                            $va->gender = $typedetails->gender;

                            
                            if ($va->save()) {
                		        Yii::app()->controller->refresh();
                		        }
            }
            
            
            
                
        $allattendance=new HrAttendance('user');
        $allattendance->unsetAttributes();  // clear any default values
        if(isset($_GET['user'])){
        $allattendance->attributes=$_GET['user'];
        }

			
			
			if(isset($_POST['User'])){


				$oldpassword = $model->password;


	       $_POST['User']['image'] = $model->image;

		$model->attributes = $_POST['User'];


              $uploadedFile=CUploadedFile::getInstance($model,'image');
	       if(! empty ($uploadedFile)){
	       $fileName = "{$rnd}-{$uploadedFile}";  // random number + file name
	       $model->image = $fileName;
	       $uploadedFile->saveAs(Yii::app()->basePath.'/../uploads/'.$fileName);
	       
	       }

				if(empty($_POST['User']['password'])){
					$model->password = $oldpassword;
				} else{ 
				    $model->password = $model->hashPassword($_POST['User']['password']);
				    
		
		
                    $criteria = new CDbCriteria();         
                    $criteria->order = 'id DESC';
                    $criteria->addSearchCondition('user_id', $userid , false);
                    $allsess= Sessions::model()->findAll($criteria);
                    if(!empty($allsess)){
                    foreach($allsess as $sess){
                    $sess->expire = 1;
                    $sess->save();
                    }
                    }

				    
				    
				}
				if($model->save())
				Yii::app()->controller->refresh(); else throw new CHttpException(404,'The specified post cannot be found.');
			}


			$this->render('profile',array(
					'userid'=>$userid ,
					'model'=>$model ,
					'va'=>$va ,
					'allattendance'=>$allattendance ,
					
					
					
				));
		}
		

		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}








	public function actionexport(){
 	
 	
 	
 	
		if(Yii::app()->user->isMember()){
				
			
			

			if(isset($_GET['Search'])){
				$criteria = new CDbCriteria();
				$criteria->order = 'id ASC';
				$criteria->addSearchCondition('hidden', 1,false, "AND");
				if(!empty($_GET['Search']['title']))
				$criteria->addSearchCondition('title', $_GET['title'],false, "AND");
				if(!empty($_GET['Search']['floor_id']))
				$criteria->addSearchCondition('floor_id', $_GET['Search']['floor_id'],false, "AND");
				if(!empty($_GET['Search']['code']))
				$criteria->addSearchCondition('code', $_GET['Search']['code'],false, "AND");
				if(!empty($_GET['Search']['activity']))
				$criteria->addSearchCondition('activity', $_GET['Search']['activity'],false, "AND");
				if(!empty($_GET['Search']['delivery_date']))
				$criteria->addSearchCondition('delivery_date', $_GET['Search']['delivery_date'],false, "AND");
				if(!empty($_GET['Search']['area_sold']))
				$criteria->addSearchCondition('area_sold', $_GET['Search']['area_sold'],false, "AND");
				if(!empty($_GET['Search']['garden']))
				$criteria->addSearchCondition('garden', $_GET['Search']['garden'],false, "AND");
				if(!empty($_GET['Search']['studio']))
				$criteria->addSearchCondition('studio', $_GET['Search']['studio'],false, "AND");
				if(!empty($_GET['Search']['parking']))
				$criteria->addSearchCondition('parking', $_GET['Search']['parking'],false, "AND");
				if(!empty($_GET['Search']['closet']))
				$criteria->addSearchCondition('closet', $_GET['Search']['closet'],false, "AND");
				if(!empty($_GET['Search']['roof']))
				$criteria->addSearchCondition('roof', $_GET['Search']['roof'],false, "AND");
				if(!empty($_GET['Search']['number_receptions']))
				$criteria->addSearchCondition('number_receptions', $_GET['Search']['number_receptions'],false, "AND");
				if(!empty($_GET['Search']['number_rooms']))
				$criteria->addSearchCondition('number_rooms', $_GET['Search']['number_rooms'],false, "AND");
				if(!empty($_GET['Search']['number_terace']))
				$criteria->addSearchCondition('number_terace', $_GET['Search']['number_terace'],false, "AND");
				if(!empty($_GET['Search']['number_baths']))
				$criteria->addSearchCondition('number_baths', $_GET['Search']['number_baths'],false, "AND");
				if(!empty($_GET['Search']['number_kitchen']))
				$criteria->addSearchCondition('number_kitchen', $_GET['Search']['number_kitchen'],false, "AND");



		
				$visible = 1;
				$alltypebuliding = TypeBuliding::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

				$allfloor = Floor::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));


				$allunit = Units::model()->findAllExport($criteria);


				$fields = array( 'code','user_id','date','time','building_id','projects_id','floor_id','type_unit','size_unit_cross','percentage_unit','size_unit_net','delivery_date','number_rooms','number_baths','number_terace','number_kitchen','roof','roof_size','percentage_roof','roof_size_net','garden','garden_size','percentage_garden','garden_size_net','parking','parking_slots','percentage_parking','parking_slots_net','number_receptions','master_rooms','studio','percentage_studio','studio_size','studio_size_net','closet','closet_size','percentage_closet','closet_size_net','number_area','neighboring_area','area_area','details','activity','price','area_sold','studio_sold','parking_sold','roof_sold','garden_sold','duplex','duplex_id');



				$labels= Units::model()->arabiclabels;


				// downloadXls($filename, $data, $title = false, $header = false, $labels = false, $fields = false,$type = 'lines')

				XlsExporter::downloadXls('report', $allunit, 'Report', TRUE  , $labels  , $fields, 'COUNT');

					
			} 
		}
		

		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
			
			
		

		
	}


    // public function actionSendnotification()
    // {
    //     if (Yii::app()->user->isMember()) {
    //         $serverKey = 'AAAAGI2_AAk:APA91bEeKC-ZyZRoMMAF7fUXoSmkyDwhjjYafH5Cx0qqFOqeCg09g3o6Q_9mYy9ta0RTgSRlp_-nYZkdFbD5v2yE_nUafV5OHo1_p04x2xDWVMFc9YPVZ3wYfvmUvIhObAKMZUv4E3Em';
    
    //         $fields = array(
    //             'to' => 'dUzQMrtHsPreVpsKSWi--D:APA91bHBF04djyFiVXdIxbvr7L9LUkrBgon0QW04LFj66mFAWFKFIU-Fd-5Slnt4BYOtVPyiT3OG2D5BdcgeiFuDT-tvgXyhrIJDqgT9L4Sji7v1bvarFsaYK0X34i3x3jcAYkeku8aA',
    //             'notification' => array(
    //                 "title" => "Test Notification",
    //                 "body" => "Firebase Notification Sent Successfully!",
    //                 "icon" => "https://solid250220.online/backstage/ib290120/img/8048-IBuild%20Logo%20SQ.png",
    //                 "click_action" => "https://shareurcodes.com"
    //             )
    //         );
    
    //         $url = 'https://fcm.googleapis.com/fcm/send';
    //         $headers = array(
    //             'Authorization: key=' . $serverKey,
    //             'Content-Type: application/json'
    //         );
    
    //         $ch = curl_init();
    //         curl_setopt($ch, CURLOPT_URL, $url);
    //         curl_setopt($ch, CURLOPT_POST, true);
    //         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    //         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    //         curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    
    //         $result = curl_exec($ch);
    //         if ($result === false) {
    //             throw new CHttpException(500, 'cURL Error: ' . curl_error($ch));
    //         }
    
    //         curl_close($ch);
    //         echo "The Result: " . htmlspecialchars($result);
    //     } else {
    //         $this->redirectToLogin();
    //     }
    // }

    private function redirectToLogin()
    {
        $model = new LoginForm();
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'login-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    
        if (isset($_POST['LoginForm'])) {
            $model->attributes = $_POST['LoginForm'];
            if ($model->validate() && $model->login()) {
                $this->redirect(array('home/index'));
            }
        }
    
        $this->redirect(array('home/index'));
    }
    //New Notification Start Here
    public function actionAjax()
    {
        header('Content-Type: application/json');
        header("Access-Control-Allow-Origin: *");

        try {
            $input = json_decode(file_get_contents('php://input'), true, 512, JSON_THROW_ON_ERROR);

            $token = isset($input['token']) ? trim($input['token']) : null;
            $userid = isset($input['userid']) ? intval($input['userid']) : null;

            if (empty($token) || empty($userid)) {
                echo json_encode(['status' => 'error', 'message' => 'Token or User ID missing.']);
                Yii::app()->end();
            }

            // Remove existing token for the user
            FirebaseToken::model()->deleteAllByAttributes(['userid' => $userid]);

            // Save the new token
            $newToken = new FirebaseToken();
            $newToken->userid = $userid;
            $newToken->token = $token;
            $newToken->date = date('Y-m-d');
            $newToken->time = date('H:i:s');
            $newToken->ip = Yii::app()->request->getUserHostAddress();
            $newToken->type = $this->detectDeviceType();
            $newToken->os = $this->detectOs($_SERVER['HTTP_USER_AGENT']);
            $newToken->browser = $this->detectBrowser($_SERVER['HTTP_USER_AGENT']);

            if ($newToken->save()) {
                echo json_encode(['status' => 'success', 'message' => 'Token saved successfully.']);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Failed to save token.']);
            }
        } catch (Exception $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }

        Yii::app()->end();
    }
    
    public function actionSendnotifyaction()
{
    header('Content-Type: application/json');

    try {
        $rawInput = file_get_contents('php://input');
        $postData = json_decode($rawInput, true);

        $title = isset($postData['title']) ? trim($postData['title']) : null;
        $body = isset($postData['body']) ? trim($postData['body']) : null;

        if (empty($title) || empty($body)) {
            echo json_encode(['status' => 'error', 'message' => 'Title and body cannot be empty.']);
            Yii::app()->end();
        }

        // Fetch all Firebase tokens
        $tokens = FirebaseToken::model()->findAll(['select' => 'token']);
        $tokenList = array_filter(array_map(function ($t) {
                return trim($t->token);
            }, $tokens));

        if (empty($tokenList)) {
            echo json_encode(['status' => 'error', 'message' => 'No valid tokens found.']);
            Yii::app()->end();
        }

        // Send the notification to Firebase
        $serviceAccount = [
                "type" => "service_account",
                "project_id" => "solid-erp-287513",
                "private_key_id" => "a4b24ce64929d80a99645501ea2ee95e42b2145e",
                "private_key" => "-----BEGIN PRIVATE KEY-----\nMIIEugIBADANBgkqhkiG9w0BAQEFAASCBKQwggSgAgEAAoIBAQCQcVKsv/gBLOIe\nEwkOpRvMME4gJ9ATQWTxkZl2V1xwvMb0rzoCB2XboplcT/yMYj0kLWO6QTE8Murr\n/IKmaIhrk+2IjmKIRiZAu5IPcHKqaOZf2iwzBdMeHHiOku59RN0oJrTT5+HeguB6\nmzOw5rGGCs4z/drhRbhLH/q/hb/cKeQi+r98DhrogVnvrOEx2eA4/yVs4wmlDMD+\nLVtA2qQY/pQ9ccTDs+YW3T7Hti2Z2uYqb7CXIuEbaeLFHEThC9TImnwRLeEEln7c\na1+9YCuisc5R02ZbDo1vlQIJwyQWePYNIMPWEnFQHwFTRtp0n4dfR/fjSiAmpITy\nwmvoTABtAgMBAAECgf8ed8j4p4Wouc74iQtgC3PRnl7caYl6hlDEo/G7BLJ7FVbi\nRhP2WZkiuymeT0D2W8KJ3wkqQJYiHJtxK9JjR6l/B7UTGPWvyRxIi0hD+XQ2feoa\nTesE2DWwJFFJwbSMt/nufjumd0MtrG2tbw94QTExFRZp4SJKYmp9bkF2JMBTsDFP\nEEIWQNnL6NA28k6GWBuP8s9fN0nW0kwWwk40+r3tdxuIF23C9ye9ZmrRDm0Uu66Q\n7xEe/VKVIjfocqK/Oi/AG93sPK82pWW2hGyg+eS2tF0EOI6mKVVM2oVsrfa9uvs/\nc0YlKzTf3IPo33+r76Zzf1jzApHCDkxVfpT/+gECgYEAwUlbhQ6D0bJPp+0+LgBm\nHzIB80BUpPmp6ZEKnRbNTV3DDlvSMsxmxcV4ejBidlSXZwYSW2STufydG/f356qs\nD+SJjlchmy1bPsxgwNtHppyYl7oF/bZxSietZeOWuiOBSE07ivfXstdvi1P/PAdo\novvoTXM5stBk+nNWanOLLC0CgYEAv07tIgLRsUWNnnVZQ+v++lwOZM2eOb3T+QlQ\nR86gi1H0Psj51QhlOWs0naNN0xBcUw57hFg3t18B3k65fXlk0zf/x6aXncdxPlxM\nVxRYagy+xiNBNRx3a8JHRX9LwgdhSkwSJ9KmHRTOzGp51Lu+2RIUxMOz5PR4KdW8\n/xzFjUECgYAWGJDB0Tr4ie3ZQKHPGHSUNF9Ms5n5kiD+dnpEIwstQP6/cXfCHuPQ\n0BZJwaY/6MO2H1eR4xmQNXSwcdSBQ12QI4wmHYfV+YVo1GxrH6Y9QcGf9sAglO62\nj3qfHzln5g8teMbJyDN8WmyB/QQ8lIw9tZaE5BtAedpRV0YVvUe3sQKBgC/AHYRN\nu9VJjQ2uMLe5Yg1PiPA0OngjH5ObdYRW2M+thw9czq8Tx2BLl/h42GYEQWchyEbC\nVjXY6vh4IehlsnreEWPd+x4Qt/1ewFdD5sWhpMSD7DS7hDtLZMq9+UTW3rvSvP1f\noMLFfNCdCwfETOCVmMV8K5zMQGoAxYnPvqeBAoGAN0UGtHxWpMnudF23EbnZyi3f\nK/HwWhLgluSL+UFmvqMyCos2ZKhBPfRK0ouSQMSAFZifWosd8NYLXfgi4Pbl81Ps\n2uzJpmIY29qQLUzt8dZuT0Co7PKFOIEmOmK2enKw4bliK7o0rvFJH/IfuhVZQJC2\nj9gRL+u1ncQj0s9SQps=\n-----END PRIVATE KEY-----\n",
                "client_email" => "firebase-adminsdk-ibdyz@solid-erp-287513.iam.gserviceaccount.com",
                "token_uri" => "https://oauth2.googleapis.com/token",
        ];

        $accessToken = $this->getAccessToken($serviceAccount);

        $url = "https://fcm.googleapis.com/v1/projects/solid-erp-287513/messages:send";
        $headers = [
            "Authorization: Bearer $accessToken",
            "Content-Type: application/json",
        ];

        foreach ($tokenList as $token) {
            $payload = [
                "message" => [
                    "token" => $token,
                    "notification" => [
                        "title" => $title,
                        "body" => $body,
                    ],
                ],
            ];

            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_exec($ch);
            curl_close($ch);
        }

        echo json_encode(['status' => 'success', 'message' => 'Notification sent successfully.']);
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }

    Yii::app()->end();
}


    private function getAccessToken($serviceAccount)
    {
        $jwtHeader = base64_encode(json_encode(["alg" => "RS256", "typ" => "JWT"]));
        $jwtPayload = base64_encode(json_encode([
            "iss" => $serviceAccount["client_email"],
            "scope" => "https://www.googleapis.com/auth/firebase.messaging",
            "aud" => $serviceAccount["token_uri"],
            "iat" => time(),
            "exp" => time() + 3600,
        ]));
    
        $signature = '';
        openssl_sign("$jwtHeader.$jwtPayload", $signature, $serviceAccount['private_key'], "SHA256");
    
        $jwt = "$jwtHeader.$jwtPayload." . base64_encode($signature);
    
        $ch = curl_init($serviceAccount['token_uri']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            "grant_type" => "urn:ietf:params:oauth:grant-type:jwt-bearer",
            "assertion" => $jwt,
        ]));
    
        $result = json_decode(curl_exec($ch), true);
        curl_close($ch);
    
        return $result['access_token'] ?? null;
    }

    private function detectDeviceType()
    {
        $userAgent = strtolower($_SERVER['HTTP_USER_AGENT']);
        return (preg_match('/tablet|ipad|playbook|android(?!.*mobile)/i', $userAgent)) ? 'Tablet' :
            (preg_match('/mobile|phone|iemobile/i', $userAgent) ? 'Mobile' : 'Computer');
    }

    private function detectOs($userAgent)
    {
        foreach ([
            '/windows nt 10/i' => 'Windows 10',
            '/macintosh|mac os x/i' => 'Mac OS X',
            '/android/i' => 'Android',
            '/iphone/i' => 'iPhone',
            '/linux/i' => 'Linux',
            '/ubuntu/i' => 'Ubuntu'
        ] as $regex => $os) {
            if (preg_match($regex, $userAgent)) {
                return $os;
            }
        }
        return 'Unknown OS';
    }

    private function detectBrowser($userAgent)
    {
        foreach ([
            '/msie|trident/i' => 'Internet Explorer',
            '/firefox/i' => 'Firefox',
            '/safari/i' => 'Safari',
            '/chrome|crios/i' => 'Chrome',
            '/edge/i' => 'Edge',
            '/opera|opr/i' => 'Opera'
        ] as $regex => $browser) {
            if (preg_match($regex, $userAgent)) {
                return $browser;
            }
        }
        return 'Unknown Browser';
    }
    
    private function getClientIp()
    {
        foreach ([
            'HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED',
            'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR'
        ] as $key) {
            if (getenv($key)) {
                return getenv($key);
            }
        }
        return 'UNKNOWN';
    }
    
    public function actionNotificationForm()
    {
        if(Yii::app()->user->isMember()){
            
            $this->layout = '//layouts/systemdashboard';
            $userid=Yii::app()->user->id;
        	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
        	$today = date("Y-m-d");                     // 03.10.01
        	$time = date("H:i:s"); 
        }
        $this->render('notificationform');
    }
    //New Notification End Here
}	





	

	