<?php

    

require 's3/aws-autoloader.php';
use Aws\S3\S3Client;
use Aws\S3\Exception\S3Exception;


class SalesController extends FrontController{
		
	/**
	* @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	* using two-column layout. See 'protected/views/layouts/column2.php'.
	*/
	public $layout='//layouts/system';

	


                                               
	public function actionLogout(){
		Yii::app()->user->logout();
		$this->redirect(array('home/index')	);
	}
	
	

public function arrayflatten($array) {
  if (!is_array($array)) {
    return FALSE;
  }
  $result = array();
  foreach ($array as $key => $value) {
    if (is_array($value)) {
      $result = array_merge($result, $this->arrayflatten($value));
    }
    else {
      $result[$key] = $value;
    }
  }
  return $result;
}	

public function actionGetInstallments()
{
    header('Content-Type: text/html; charset=utf-8');

    $leadId = (int)Yii::app()->request->getParam('leadId', 0);
    if ($leadId <= 0) {
        http_response_code(400);
        echo '<div class="alert alert-danger">Invalid leadId</div>';
        Yii::app()->end();
    }

    // ========= Call upstream API =========
    $url = "https://intl.so-sdw-0104.com/vd/api/get-units-with-installments?entity_code={$leadId}";

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 12,
        CURLOPT_CONNECTTIMEOUT => 6,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_SSL_VERIFYHOST => 2,
        CURLOPT_USERAGENT => 'SolidCRM-InstallmentsProxy/1.0',
    ]);
    $resp = curl_exec($ch);
    $err  = curl_error($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($err) {
        http_response_code(502);
        echo '<div class="alert alert-danger text-center">Upstream error: '.CHtml::encode($err).'</div>';
        Yii::app()->end();
    }

    if ($code >= 400) {
        http_response_code($code);
        echo '<div class="alert alert-danger text-center">API returned HTTP '.(int)$code.'</div>';
        Yii::app()->end();
    }

    // ========= Try to decode JSON; if not JSON, just echo HTML as-is =========
    $data = @json_decode($resp, true);
    if ($data === null) {
        // الـ API بيرجع HTML جاهز؟ اعرضه كما هو
        echo $resp;
        Yii::app()->end();
        return;
    }

    // ========= Build HTML UI =========
    $success     = isset($data['success']) ? (bool)$data['success'] : true;
    $units       = isset($data['units']) && is_array($data['units']) ? $data['units'] : [];
    $units_count = isset($data['units_count']) ? (int)$data['units_count'] : count($units);

    if (!$success) {
        echo '<div class="alert alert-warning text-center">No installment data found.</div>';
        Yii::app()->end();
    }

    // Helpers
    $fmtMoney = function($n) {
        if ($n === null || $n === '' || !is_numeric($n)) return '-';
        // تنسيق مبسط بدون intl
        return number_format((float)$n, 0, '.', ',') . ' EGP';
    };
    $fmtDate = function($s) {
        if (empty($s)) return '-';
        $ts = strtotime($s);
        if ($ts === false) return CHtml::encode($s);
        return date('d M Y', $ts);
    };
    $statusBadge = function($amount, $paid) {
        $a = (float)$amount; $p = (float)$paid;
        if ($p <= 0) return '<span class="badge badge-danger">Unpaid</span>';
        if ($p >= $a && $a > 0) return '<span class="badge badge-success">Paid</span>';
        return '<span class="badge badge-warning">Partial</span>';
    };

    ob_start();
    ?>
    <div class="card shadow-sm">
      <div class="card-header d-flex align-items-center justify-content-between">
        <div class="font-weight-bold">Installments</div>
        <div class="text-muted small">Units: <?= (int)$units_count ?></div>
      </div>
      <div class="card-body">
        <?php if (!$units_count): ?>
          <div class="alert alert-info text-center mb-0">No units found for this lead.</div>
        <?php else: ?>
          <?php foreach ($units as $uIndex => $unit):
              $unitId   = isset($unit['unit_id']) ? $unit['unit_id'] : '-';
              $unitName = isset($unit['unit_name']) ? $unit['unit_name'] : ('Unit #'.($uIndex+1));
              $insts    = isset($unit['installments']) && is_array($unit['installments']) ? $unit['installments'] : [];

              $totalAmount = 0.0; $totalPaid = 0.0;
              foreach ($insts as $i) {
                  $totalAmount += (float)($i['amount'] ?? 0);
                  $totalPaid   += (float)($i['paid'] ?? 0);
              }
              $pct = $totalAmount > 0 ? min(100, round(($totalPaid/$totalAmount)*100)) : 0;
              $cardId = 'unit_'.$uIndex;
          ?>
          <div class="card border mb-4">
            <div class="card-header bg-light d-flex align-items-center justify-content-between">
              <div>
                <div class="font-weight-bold"><?= CHtml::encode($unitName) ?></div>
                <div class="small text-muted">Unit ID: <?= CHtml::encode($unitId) ?></div>
              </div>
              <div class="text-right">
                <div class="small text-muted">Total</div>
                <div class="font-weight-bold"><?= $fmtMoney($totalAmount) ?></div>
              </div>
            </div>
            <div class="card-body">
              <div class="mb-3">
                <div class="d-flex justify-content-between mb-1">
                  <span class="small text-muted">Paid</span>
                  <span class="small text-muted"><?= $fmtMoney($totalPaid) ?> / <?= $fmtMoney($totalAmount) ?> (<?= (int)$pct ?>%)</span>
                </div>
                <div class="progress" style="height:10px;">
                  <div class="progress-bar" role="progressbar" style="width:<?= (int)$pct ?>%;" aria-valuenow="<?= (int)$pct ?>" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
              </div>

              <div class="table-responsive">
                <table class="table table-sm table-striped mb-0">
                  <thead class="thead-light">
                    <tr>
                      <th style="width:56px;">#</th>
                      <th>Due Date</th>
                      <th>Amount</th>
                      <th>Paid</th>
                      <th>Remaining</th>
                      <th>Status</th>
                      <th>Type</th>
                      <th style="width:90px;">Details</th>
                    </tr>
                  </thead>
                  <tbody>
                  <?php if (!$insts): ?>
                    <tr><td colspan="8" class="text-center text-muted">No installments found for this unit.</td></tr>
                  <?php else: ?>
                    <?php foreach ($insts as $iIndex => $inst):
                        $amount     = $inst['amount']     ?? 0;
                        $paid       = $inst['paid']       ?? 0;
                        $remaining  = $inst['remaining']  ?? (($amount - $paid) > 0 ? ($amount - $paid) : 0);
                        $due        = $inst['payment_date'] ?? $inst['due_date'] ?? null;
                        $isDP       = !empty($inst['is_downpayment']);
                        $payments   = isset($inst['payments']) && is_array($inst['payments']) ? $inst['payments'] : [];
                        $collapseId = $cardId.'_inst_'.$iIndex.'_payments';
                    ?>
                      <tr>
                        <td><?= (int)($iIndex+1) ?></td>
                        <td><?= $fmtDate($due) ?></td>
                        <td><?= $fmtMoney($amount) ?></td>
                        <td><?= $fmtMoney($paid) ?></td>
                        <td><?= $fmtMoney($remaining) ?></td>
                        <td><?= $statusBadge($amount, $paid) ?></td>
                        <td>
                          <?php if ($isDP): ?>
                            <span class="badge badge-info">Downpayment</span>
                          <?php else: ?>
                            <span class="badge badge-secondary">Installment</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <?php if ($payments): ?>
                            <button type="button"
                                    class="btn btn-sm btn-outline-primary toggle-payments"
                                    data-target="#<?= CHtml::encode($collapseId) ?>">
                              Payments
                            </button>
                          <?php else: ?>
                            <span class="text-muted small">—</span>
                          <?php endif; ?>
                        </td>
                      </tr>

                      <?php if ($payments): ?>
                        <tr class="bg-light">
                          <td colspan="8" class="p-0">
                            <div id="<?= CHtml::encode($collapseId) ?>" class="collapse">
                              <div class="p-3">
                                <div class="font-weight-bold mb-2">Payment Details</div>
                                <div class="table-responsive">
                                  <table class="table table-sm table-bordered mb-0">
                                    <thead class="thead-light">
                                      <tr>
                                        <th>#</th>
                                        <th>Date</th>
                                        <th>Amount</th>
                                        <th>Ref</th>
                                        <th>Note</th>
                                      </tr>
                                    </thead>
                                    <tbody>
                                      <?php foreach ($payments as $pIndex => $p):
                                          $pAmount = $p['amount'] ?? null;
                                          $pDate   = $p['date']   ?? ($p['payment_date'] ?? null);
                                          $pRef    = $p['ref']    ?? ($p['reference'] ?? '');
                                          $pNote   = $p['note']   ?? ($p['description'] ?? '');
                                      ?>
                                      <tr>
                                        <td><?= (int)($pIndex+1) ?></td>
                                        <td><?= $fmtDate($pDate) ?></td>
                                        <td><?= $fmtMoney($pAmount) ?></td>
                                        <td><?= CHtml::encode((string)$pRef) ?></td>
                                        <td><?= CHtml::encode((string)$pNote) ?></td>
                                      </tr>
                                      <?php endforeach; ?>
                                    </tbody>
                                  </table>
                                </div>
                              </div>
                            </div>
                          </td>
                        </tr>
                      <?php endif; ?>

                    <?php endforeach; ?>
                  <?php endif; ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
          <?php endforeach; ?>
        <?php endif; ?>
      </div>
    </div>
    <?php
    $html = ob_get_clean();
    echo $html;
    Yii::app()->end();
}
   public function actionApiLeadsJson()
{
    if (Yii::app()->user->isMember()) {
        $this->layout = ''; // No layout
        $userid = Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');
    }

    header('Content-Type: application/json');
    $this->renderPartial('apiLeadsJson', array(), false, true);
    Yii::app()->end();
}
 // Action for rendering the WhatsApp view
    public function actionWhatsapp()
    {
        if (Yii::app()->user->isMember()) {
            $this->layout = ''; // No layout
            $userid = Yii::app()->user->id;
            date_default_timezone_set('Africa/Cairo'); // Set timezone
            $today = date("Y-m-d");
            $time = date("H:i:s");
        }

        // Render the view to display messages
        $this->render('whatsapp');
    }

    // Action to handle WhatsApp webhook and save incoming messages
    public function actionWhatsappWebhook()
    {
        $verifyToken = 'YOUR_VERIFY_TOKEN'; // Token set in WhatsApp Business webhook settings

        // Verification request from WhatsApp
        if (isset($_GET['hub_verify_token']) && $_GET['hub_verify_token'] === $verifyToken) {
            echo $_GET['hub_challenge'];
            Yii::app()->end();
        }

        // Handle incoming JSON from WhatsApp
        $input = file_get_contents('php://input');
        $data = CJSON::decode($input);

        if (isset($data['entry']) && isset($data['entry'][0]['changes'][0]['value']['messages'])) {
            $messages = $data['entry'][0]['changes'][0]['value']['messages'];

            foreach ($messages as $message) {
                $sender = $message['from']; // WhatsApp sender number
                $messageText = $message['text']['body']; // Message content

                // Save messages to a log file (you can switch to a database)
                file_put_contents(Yii::app()->basePath . "/runtime/whatsapp_log.txt", "Message from: $sender, Content: $messageText\n", FILE_APPEND);
            }
        }

        // Respond with HTTP 200 to WhatsApp to indicate success
        header("HTTP/1.1 200 OK");
    }

    // Action to fetch messages for display in the frontend
    public function actionWhatsappfetchMessages()
    {
        $messages = array();

        // Read messages from the log file (you can switch to a database)
        $logFile = Yii::app()->basePath . "/runtime/whatsapp_log.txt";
        if (file_exists($logFile)) {
            $lines = file($logFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            foreach ($lines as $line) {
                // Parse the message format from the log
                preg_match('/Message from: (.*), Content: (.*)/', $line, $matches);
                if ($matches) {
                    $messages[] = array('from' => $matches[1], 'body' => $matches[2]);
                }
            }
        }

        // Return the messages as JSON
        header('Content-Type: application/json');
        echo CJSON::encode($messages);
        Yii::app()->end();
    }



public function actionQuickprofilelist(){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	date_default_timezone_set('Africa/Cairo');  
        		$today = date("Y-m-d");   
        		$time = date("H:i:s"); 
		    }
		  $this->render('quickprofilelist');

    }





public function actionSalesmanagerautoassignredo(){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
            
		    }
         
		        
		    
		        
		  $this->render('salesmanagerautoassignredo');

    }
		


public function actionSalesmanagerdistribute(){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
            
		    }
         
		        
		    
		        
		  $this->render('salesmanagerdistribute');

    }
		


public function actionLeaderdistribute(){
      
		    if(Yii::app()->user->isMember()){
		        $this->layout = '';
		        $userid=Yii::app()->user->id;
            	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
        		$today = date("Y-m-d");                     // 03.10.01
        		$time = date("H:i:s"); 
            
		    }
         
		        
		    
		        
		  $this->render('leaderdistribute');

    }
		






        
         public function actionCheckxlxs($id){
        if(Yii::app()->user->isMember()){
        $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        $userid=Yii::app()->user->id;
        
        
ini_set('max_execution_time', 300);
ini_set('memory_limit', '-1');
$xlxs=Exportxlxs::model()->findByAttributes(array('id'=>$id));        
$criteriaex = new CDbCriteria;
$criteriaex->limit = 1500;
$criteriaex->addCondition('user_id IS NULL');
$criteriaex->addSearchCondition('exportxlx_id', $id, false);
$allleadss=Exportxlxsleads::model()->findAll($criteriaex);
//var_dump($allleadss);exit;


if(!empty($allleadss)){
    foreach($allleadss as $data){
    $data->user_id = $data->lead->employee->fname." ".$data->lead->employee->lname;
    $data->user_sales = $data->lead->sales->fname." ".$data->lead->sales->lname;
    $data->fresh_sales = $data->lead->freshsales->fname." ".$data->lead->freshsales->lname;
    $data->statues= $data->lead->statuesaction->title;
    $data->substatues= $data->lead->substatusaction->title;
    $data->platform= $data->lead->platform->title;
    $data->platformchild= $data->lead->platformchild->title;
    $data->tel= $data->lead->international_code.$data->lead->tel;
    $data->tel2= $data->lead->international_code2.$data->lead->second_tel;
    $data->strategy= $data->lead->strategyaction->details;
    $data->campaign= $data->lead->campaign->title;
    $data->details= $data->lead->details;
    $data->followdate= $data->lead->follow_date;
    $data->date= $data->lead->date;
    $data->email= $data->lead->email;
    $data->title= $data->lead->title;
    $data->notes= $data->lead->notes;
    
    $data->project= $data->lead->project->title;
    $data->unit_type= $data->lead->unittype->title;
    $data->code= $data->code;

    
  




if ($data->lead->statuesaction->qualified == 1 && $data->lead->statuesaction->nonqualified == 1) {
    $data->lastclassification = 'Mixed';
} elseif ($data->lead->statuesaction->qualified == 1 && $data->lead->statuesaction->nonqualified === null) {
    $data->lastclassification = 'Qualified';
} elseif ($data->lead->statuesaction->qualified === null && $data->lead->statuesaction->nonqualified == 1) {
    $data->lastclassification = 'Non Qualified';
} elseif ($data->lead->statuesaction->qualified === null && $data->lead->statuesaction->nonqualified === null) {
    $data->lastclassification = 'Not Clear';
}




if ($data->lead->qualified == 1 && $data->lead->nonqualified == 1) {
    $data->classification = 'Mixed';
} elseif ($data->lead->qualified == 1 && $data->lead->nonqualified === null) {
    $data->classification = 'Qualified';
} elseif ($data->lead->qualified === null && $data->lead->nonqualified == 1) {
    $data->classification = 'Non Qualified';
} elseif ($data->lead->qualified === null && $data->lead->nonqualified === null) {
    $data->classification = 'Not Clear';
}



    
    


    $data->lastreport= $data->lead->sales_report;
    $data->duplicatedate= $data->lead->duplicate_date;
    if($data->lead->visit == 1){
    $data->visit = 'visit';
    }
    $main=Mainsettings::model()->findByPk(1);
    $suser=User::model()->findByPk($userid);
    if($main->exportxlxs == 1){
    if($suser->hiddenxlxs != 1){    
    $faketel='*********';
    $data->tel=$data->lead->id; 
    }
    }
    if($data->lead->international_code == 20){
    $data->international_code = 'Local';
    }else{
    $data->international_code = 'Global';    
    }
    $data->save();
    if($data->save()){
        
    $xlxs->done = $xlxs->done+1; 
    $xlxs->save();    
    }else{
        
        
                                                       var_dump($data->lead->id);exit;

    }
    }
    
    header('Content-Type: application/json');
    $true="true";
    $ratio= $xlxs->done / $xlxs->total * 100;
    $arr = array(
        
        'status' => true,
        'total' =>  $xlxs->total,
        'done' =>  $xlxs->done,
        'ratio' => $ratio,
        );
    echo json_encode($arr);
    die();     
    
}else{

  
    header('Content-Type: application/json');
    $true="true";
    $arr = array('status' => false);
    echo json_encode($arr);
    die();     

}





//list($array1, $array2) = array_chunk($allleadss, ceil(count($allleadss) / 5));
//var_dump(count($array1));exit;

	




    
    
//XlsExporter2::downloadXls('SOLID XLS', $allleadss, 'Report-', TRUE  , $labels  , $fields, 'COUNT');



        
        
        }
        
        }

        public function actionDownloadxlxs($id){
        if(Yii::app()->user->isMember()){
        $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        $userid=Yii::app()->user->id;
        
        
        
$criteriaex = new CDbCriteria;
$criteriaex->addSearchCondition('exportxlx_id', $id, false);


$fields = array(
'leads_id',
'title',
'email',
'notes',
'campaign',
'strategy',
'tel',
'tel2',
'user_id',
'date',
'followdate',
'user_sales',
'fresh_sales',
'statues',
'substatues',
'lastclassification',

'visit',
'platform',
'platformchild',
'project',
'lastreport',
'details',
'international_code',
'duplicatedate',
'classification',
'unit_type',
'code',


    
    
    
   
    
    
    
    
    
    
    
    
    
   
    
    
    
    
    
    
    
    
    );
    
    
$headerFields = array(
'leads_id',
'title',
'email',
'notes',
'campaign',
'strategy',
'tel',
'tel2',
'user_id',
'date',
'followdate',
'user_sales',
'fresh_sales',
'statues',
'substatues',
'lastclassification',
'visit',
'platform',
'platformchild',
'project',
'lastreport',
'details',
'international_code',
'duplicatedate',
'classification',
'unit_type',
'code',

    
    );
    
$criteriaex->select = $fields;
$allleadss=Exportxlxsleads::model()->findAll($criteriaex);
XlsExporter2::downloadXls('report', $allleadss, false, true, $headerFields); 

//var_dump($allleadss);exit;



ini_set('max_execution_time', 300);
	ini_set('memory_limit', '-1');


//list($array1, $array2) = array_chunk($allleadss, ceil(count($allleadss) / 5));
//var_dump(count($array1));exit;

	




    
    
//XlsExporter2::downloadXls('SOLID XLS', $allleadss, 'Report-', TRUE  , $labels  , $fields, 'COUNT');



        
        
        }
        
        }



        public function actionDownloadxlxsact(){
        if(Yii::app()->user->isMember()){
        $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        $userid=Yii::app()->user->id;
        
        
        
        $criteriaex = new CDbCriteria;
        $fields = array(
        'id',
        'leads_id',
        'date',
        'details',
        'follow_date',
        );
        
        $headerFields = array(
        'id',
        'leads_id',
        'date',
        'details',
        'follow_date',
        );
        
        $criteriaex->select = $fields;
        $allleadss=Activities::model()->findAll($criteriaex);
        XlsExporter2::downloadXls('activities', $allleadss, false, true, $headerFields); 
        ini_set('max_execution_time', 300);
        ini_set('memory_limit', '-1');
        
        
        
        }
        }

	



public function actionReadycancelreservation(){
    $this->layout = '//layouts/systemcgridview';
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);	
                
		
		


	
	$allres=new Reservation('readycancelres');

             	$allres->unsetAttributes();  // clear any default values
                if(isset($_GET['Reservation'])){
                   // var_dump($_GET['Status']);exit;
                $allres->attributes=$_GET['Reservation'];
             
                }

	

	
	
	
	
	
		
			$allcontract=Contract::model()->findAll();


			if(isset($_POST['DocumentStorage'])){
			    $file=new DocumentStorage();
				$reservation= Reservation::model()->findByPk($_POST['Change']);
				$unit= Units::model()->findByPk($reservation->unit_id);
				if($reservation->confirm== NULL) $reservation->confirm= 1; 
				$reservation->save(); 
         
			
				$file->attributes = $_POST['DocumentStorage'];


				$uploadedFile=CUploadedFile::getInstance($file,'file');
				if(! empty ($uploadedFile)){
					$fileName = "{$rnd}-{$uploadedFile}";  // random number + file name
					$file->file= $fileName;
					
				}


				$file->date= $today;
				$file->time= $time;
				$file->lead_id= $reservation->lead_id;
				$file->user_id= $userid;
				if($reservation->confirm== 1){
				    //$uploadedFile->saveAs(Yii::app()->basePath.'/../uploads/'.$fileName);
				    $unit->booking=2;
				    $unit->dateofcontract=$today;
				    $unit->save();
                    Yii::app()->controller->refresh();
				}else{
				    var_dump($file->getErrors());
				}
				
			}

			/*
			if(isset($_POST['Change'])){
			$reservation= Reservation::model()->findByPk($_POST['Change']);
			if($reservation->confirm== NULL) $reservation->confirm= 1; 
			if($reservation->save())
			Yii::app()->controller->refresh();
			}
			*/
			
			
        
        
        
			$alldocument=TypeDocument::model()->findAll();
			$this->render('readycancelreservationgv',array(
					'userid'=>$userid ,
					'model'=>$model,
					'lead'=>$lead,
					'allfav'=>$allfav,
					'allpayment'=>$allpayment,
					//'allmedia'=>$allmedia,
					'allcontract'=>$allcontract,
					'file'=>$file,
					'alldocument'=>$alldocument,
					
					'allres'=>$allres,

				));
		}
		

		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}


	



public function actionTransferaction($id) {
    if (Yii::app()->user->isMember()) {
        $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};
        $today = date("Y-m-d");
        $time = date("H:i:s");
        $userid = Yii::app()->user->id;
        $transferaction = Transferaction::model()->findByPk($id);
        // Check if Transferaction is already done


        if ($transferaction->done == 1) {
            
         
            
            
            header('Content-Type: application/json');
            echo json_encode(['status' => true]);
            die();
        }

        
      $criteria = new CDbCriteria;
                $criteria->limit= 10;
                $criteria->addCondition('done IS NULL');
                $criteria->addSearchCondition('transferaction_id', $transferaction->id, false , 'AND');
                $alltransfer = Transfer::model()->findAll($criteria);




        if (!empty($alltransfer)) {
            $leadIds = [];
            foreach ($alltransfer as $transfer) {
                
                
                
                $leadIds[] = $transfer->lead_id;
                
                
                

                // Your additional logic here
                if ($transfer->hide == 1) {
                  //  var_dump(2);exit;

                    $lead = Leads::model()->findByPk($transfer->lead_id);
                    $lead->hiddenactivtiesdate = $today;
                    $lead->transferfrom = $transfer->fromm;
                    $lead->transferuser = $transfer->user_id;
                    $lead->fakedate = NULL;
                    $lead->fake = NULL;
                    $lead->save();
                    
    
                       if($lead->save()) {
    Yii::app()->db->createCommand()
        ->update(
            'activities',
            array(
            'hidden' => 1,
            'close' => 1,
            'report' => 'done', 
            'too' => $transfer->too),
            'leads_id = :lead_id',
            array(':lead_id' => $lead->id)
        );

                    
                    
                  
                    
                    
                   
                    }
                    
                    
                }
                
                
                
                if ($transfer->hideteamleader == 1) {
                                  //  var_dump(3);exit;

                   // var_dump($transfer->lead_id);exit;
                    $lead = Leads::model()->findByPk($transfer->lead_id);
                    $lead->hiddenactivtiesdate = $today;
                    $lead->transferfrom = $transfer->fromm;
                    $lead->transferuser = $transfer->user_id;
                    $lead->fakedate = NULL;
                    $lead->fake = NULL;
                    $lead->save();
                    
                   
                   
                   if($lead->save()) {
    Yii::app()->db->createCommand()
        ->update(
            'activities',
            array(
            'hidden' => 1,
            'hideteamleader' => 1, 
            'close' => 1, 
            'report' => 'done', 
            'too' => $transfer->too),
            'leads_id = :lead_id',
            array(':lead_id' => $lead->id)
        );
} else {
    // Output or log the errors from the save operation
    print_r($lead->getErrors());
}

                   
                   
                    
                    
                }
            
                
                
                

                if ($transfer->fakenewlead == 1) {
                                   // var_dump(4);exit;

                    $lead = Leads::model()->findByPk($transfer->lead_id);
                    $lead->fake = 1;
                    $lead->fakedate = $today;
                    $lead->transferfrom = $transfer->fromm;
                    $lead->transferuser = $transfer->user_id;
                    $lead->save();
                    
                    
                    if($lead->save()){

                   

Yii::app()->db->createCommand()
    ->update(
        'activities',
        array(
        'hidden' => 1, 
        'hideteamleader' => 1, 
        'close' => 1, 
        'report' => 'done', 
        'too' => $transfer->too),
        'leads_id = :lead_id',
        array(':lead_id' => $lead->id)
    );
                  
}
                   
                   
                    }
                    
                
            }

            if (!empty($leadIds)) {
                // Batch update Leads
                $sqlUpdateLeads = "
                    UPDATE leads
                    SET user_sales = :user_sales,
                        transferdate = :transferdate,
                        close = NULL,
                        dtime = :dtime,
                        communication = NULL,
                        transferuser = :transferuser,
                        transfer = 1,
                        counttransfer = counttransfer + 1,
                        transferreason = :transferreason
                    WHERE id IN (" . implode(',', $leadIds) . ")
                ";

                Yii::app()->db->createCommand($sqlUpdateLeads)
                    ->bindValues([
                        ':user_sales' => $transfer->too,
                        ':transferdate' => $today,
                        ':dtime' => $time,
                        ':transferuser' => $userid,
                        ':transferreason' => $transfer->reason,
                    ])
                    ->execute();

                // Batch update Activities
                $sqlUpdateActivities = "
                    UPDATE activities
                    SET too = :user_sales,
                    close = 1,
                    WHERE leads_id IN (" . implode(',', $leadIds) . ") AND close IS NULL
                ";


                // Mark Transfer as done
                $sqlMarkTransferDone = "
                    UPDATE transfer
                    SET done = 1
                    WHERE lead_id IN (" . implode(',', $leadIds) . ")
                ";

                Yii::app()->db->createCommand($sqlMarkTransferDone)->execute();
            }

            header('Content-Type: application/json');
            echo json_encode(['status' => false]);
            die();
        } else {
            
                           	
$main = Mainsettings::model()->findByPk(1);
$em=User::model()->findByPk($transferaction->sales);
if (!empty($em->mobile)) {                                                     
                                                                           
$url = Yii::app()->getBaseUrl(true) . "/leads/profile/" . $lead->id;
// Twilio Account SID and Auth Token


$sid    = $main->whatsapp_sid;
$token  = $main->whatsapp_token;

// Recipient's WhatsApp number
$to = "whatsapp:+" . $em->mobile;
// Your WhatsApp Business number
$from = "whatsapp:+" . $main->whatsapp_from;

// Template SID (Use your actual Template SID)
//$templateSid = "HX1a66dc0bb3138ca02fbb2f8a73c8e9d6";

$templateSid = $main->whatsapp_templatesid_2;



if(!empty($main->hide_number_whatsapp)) {                                                     
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $transferaction->total,
   // '2' => $em->fname.$em->lname,
);
}else{
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $transferaction->total,
    '2' => $em->fname.$em->lname,
);  
}



// Convert TemplateParams to JSON
$templateParams = json_encode($templateParams);

// Twilio API URL for sending template messages
$url = "https://api.twilio.com/2010-04-01/Accounts/$sid/Messages.json";

// Data to be sent in the POST request
$data = array(
    'To' => $to,
    'From' => $from,
    'ContentSid' => $templateSid, // استخدم ContentSid وليس TemplateSid
    'ContentVariables' => $templateParams // استخدم ContentVariables لتمرير المعلمات
);

// Initialize cURL
$ch = curl_init($url);

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_USERPWD, "$sid:$token");

// Execute the request and get the response
$response = curl_exec($ch);

// Check for cURL errors
if ($response === false) {
  //  echo 'cURL Error: ' . curl_error($ch);
} else {
   // $response_data = json_decode($response, true);
    
    // Check if SID exists in the response
    if (isset($response_data['sid'])) {
      //  echo 'Message SID: ' . $response_data['sid'];
    } else {
     //   echo 'No SID found in the response. Full response: ' . print_r($response_data, true);
    }
}

// Close the cURL session
curl_close($ch);

}
 


            
            
            
            // Mark Transferaction as done
            $transferaction->done = 1;
            $transferaction->save();

            header('Content-Type: application/json');
            echo json_encode(['status' => true]);
            die();
        }
    }
}

	
	
	
	
	




        
        
        public function actionTransferactionrejected($id){
        if(Yii::app()->user->isMember()){
                        $transferaction=Transferaction::model()->findByPk($id);
$transferaction->hidden=1;
$transferaction->save();
		$this->redirect(array('login/transferconfirm')	);



        }
        
        }
	
	
	
	
public function actionActiontocalss()
{
    if (Yii::app()->user->isMember()) {
        $layout = '//layouts/systemcgridview';
        $userid = Yii::app()->user->id;

        // Fetch settings
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');

        // Retrieve GET parameters safely
        $params = [
            'leadstate' => $_GET['leadstate'] ?? null,
            'startdate' => $_GET['startdate'] ?? null,
            'enddate' => $_GET['enddate'] ?? null,
            'startfollow' => $_GET['startfollow'] ?? null,
            'endfollow' => $_GET['endfollow'] ?? null,
            'sales' => $_GET['sales'] ?? null,
            'answer' => $_GET['answer'] ?? null,
            'local' => $_GET['local'] ?? null,
            'cold' => $_GET['cold'] ?? null,
            'close' => $_GET['close'] ?? null,
            'startduplicatedate' => $_GET['startduplicatedate'] ?? null,
            'endduplicatedate' => $_GET['endduplicatedate'] ?? null,
            'startactiondate' => $_GET['startactiondate'] ?? null,
            'lastactiondate' => $_GET['endactiondate'] ?? null,
        ];

        // Debug Logging (No output sent to browser)
        Yii::log("Filter Applied: startactiondate = " . $params['startactiondate'] . ", lastactiondate = " . $params['lastactiondate'], 'info');

        // First criteria to fetch leads from activities
        $criteria = new CDbCriteria();
        $criteria->select = "leads_id";
        $criteria->distinct = true;

        if (!empty($params['sales'])) {
            $criteria->compare("user_id", $params['sales']);
        }

        if (!empty($params['startdate'])) {
            $criteria->addBetweenCondition("date", $params['startdate'], $params['enddate']);
        }

        if (!empty($params['startduplicatedate'])) {
            $criteria->addBetweenCondition("duplicate_date", $params['startduplicatedate'], $params['endduplicatedate']);
            $criteria->addCondition("duplicate IS NOT NULL");
        }

        if (!empty($params['startfollow'])) {
            $criteria->addBetweenCondition("follow_date", $params['startfollow'], $params['endfollow']);
        }

        if ($params['cold'] == 1) {
            $criteria->addCondition('coldcall IS NOT NULL');
        } elseif ($params['cold'] == 2) {
            $criteria->addCondition('coldcall IS NULL');
        }

        if ($params['close'] == 1) {
            $criteria->addCondition('close IS NOT NULL');
        } elseif ($params['close'] == 2) {
            $criteria->addCondition('close IS NULL');
        }

        // Apply `startactiondate` and `lastactiondate` to `activities.date`
        if (!empty($params['startactiondate']) && !empty($params['lastactiondate'])) {
            $criteria->addBetweenCondition("date", $params['startactiondate'], $params['lastactiondate']);
        }

        // Fetch relevant leads
        $models = Activities::model()->findAll($criteria);
        $arrayleads = array_column($models, 'leads_id');

        // Second criteria to filter leads
        $criteria = new CDbCriteria();
        $criteria->order = 'id DESC';
        if (!empty($arrayleads)) {
            $criteria->addInCondition('id', $arrayleads);
        }

        // Apply `startactiondate` and `lastactiondate` to `leads.checkup_activity`
        if (!empty($params['startactiondate']) && !empty($params['lastactiondate'])) {
            $criteria->addBetweenCondition("checkup_activity", $params['startactiondate'], $params['lastactiondate']);
        }

        // Fetch leads
        $allleads = Leads::model()->findAll($criteria);

        // Log total leads found instead of printing
        Yii::log("Total Leads Found: " . count($allleads), 'info');

        // Check if empty before rendering
        if (empty($allleads)) {
            Yii::log("No leads found.", 'warning');
        }

        // Render the view
        $this->render('salesresultold', [
            'userid' => $userid,
            'allleads' => $allleads,
        ]);
    } else {
        // Handle unauthenticated users
        $model = new LoginForm();
        if (isset($_POST['LoginForm'])) {
            $model->attributes = $_POST['LoginForm'];
            if ($model->validate() && $model->login()) {
                $this->redirect(['home/index']);
            }
        }
        $this->render('index', ['model' => $model]);
    }
}
		
	
	
	
	
		
		public function actionDuplicaterules()
		{
		if(Yii::app()->user->isMember())
		{
		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		$visible = 1;
		$allduplicaterules = Duplicaterules::model()->findAll(array( 'order'=>'id DESC'  ));

		
		
		
		$model = new Duplicaterules();
		$model->setScenario('com_porfile');
		if (isset($_POST['Duplicaterules'])) {
		$rnd = rand(0,9999);
		$model->attributes = $_POST['Duplicaterules'];
		$model->user_id = $userid;
		$model->date = $today;
		$model->time = $time;

		if ($model->save()) {





		Yii::app()->controller->refresh();
		}
		}

		
		
		
		
		$this->render('duplicaterules',array(
		'userid'=>$userid ,	
        'model'=>$model ,			
        'allduplicaterules'=>$allduplicaterules ,

		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->render('index',array('model'=>$model));
		}

		}
		
		
	







	
	public function actionAllchatandsupport()
		{
		if(Yii::app()->user->isMember())
		{
		    
		    
		    	
	

		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
	//	$allwhatsapp=Chatandsupport::model()->findAll(array('condition'=>'user_id='.$userid));
		$allchat=Chatandsupport::model()->findAll(array('condition'=>'user_sales='.$userid));




		$this->render('allchatandsupport',array(
		'userid'=>$userid ,	
	    'allchat'=>$allchat ,	


		));
		
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
			



public function actionResetteamleader() {
    if (Yii::app()->user->isMember()) {

        $teamleader = $_REQUEST['teamleader'];
        $startdate = $_REQUEST['startdate'];
        $enddate = $_REQUEST['enddate'];

        $command = Yii::app()->db->createCommand();
        $sql = "
            UPDATE leads 
            SET user_sales = NULL, user_integration = NULL 
            WHERE coldcall IS NULL 
              AND user_sales IS NULL 
              AND user_integration = :teamleader 
              AND date BETWEEN :startdate AND :enddate
        ";

        $command->setText($sql)
                ->bindParam(':teamleader', $teamleader)
                ->bindParam(':startdate', $startdate)
                ->bindParam(':enddate', $enddate);

        $command->execute(); // number of updated rows (optional to store)

        // Redirect to login/admin.php
        $this->redirect(Yii::app()->baseUrl . '/login/admin');
    }
}



public function actionResetteamleadercold() {
    if (Yii::app()->user->isMember()) {

        $teamleader = $_REQUEST['teamleader'];
        $startdate = $_REQUEST['startdate'];
        $enddate = $_REQUEST['enddate'];

        $command = Yii::app()->db->createCommand();
        $sql = "
            UPDATE leads 
            SET user_sales = NULL, user_integration = NULL 
            WHERE coldcall IS NOT NULL 
              AND user_sales IS NULL 
              AND user_integration = :teamleader 
              AND date BETWEEN :startdate AND :enddate
        ";

        $command->setText($sql)
                ->bindParam(':teamleader', $teamleader)
                ->bindParam(':startdate', $startdate)
                ->bindParam(':enddate', $enddate);

        $command->execute();

        // Redirect to login/admin.php
        $this->redirect(Yii::app()->baseUrl . '/login/admin');
    }
}	


public function actionSalesactivtime($id){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
		

			$this->render('salesactivtime',array(
					'userid'=>$userid ,
					'id'=>$id,
				
                
				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}

			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/dashboard')	);
			}
			// display the login form
			$this->render('index',array('model'=>$model));
		}

	}



public function actionPulllog(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$today2=date("Y");
		
		  
 


			$criteria = new CDbCriteria;
            // $criteria2->addSearchCondition('date', $today, false);
            // $criteria2->addSearchCondition('user_sales', $userid, false);
			//$criteria2->condition = "close IS NULL ";

            //$criteria2->addCondition('hidden=' . $visible);
			//$criteria2->addCondition('user_sales=' . $userid);
			//$criteria2->addCondition('duplicate IS NULL');

			//$criteria2->addSearchCondition('date' , $today);
			$criteria->order = 'id DESC';
			$total = Pull::model()->count($criteria);

			$pages = new CPagination($total);
			$pages->pageSize = 50;
			$pages->applyLimit($criteria);

			$alllog = Pull::model()->findAll($criteria);



		
		 
		
			$this->render('pulllog',array(
					'userid'=>$userid ,	 		
					'alllog'=>$alllog ,	
					'pages' => $pages,		 



				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
public function actionDistributelog(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$today2=date("Y");
			
			
            $this->layout='//layouts/systemcgridview';

			$criteria = new CDbCriteria;
            // $criteria2->addSearchCondition('date', $today, false);
            $criteria->addSearchCondition('user_id', $userid, false);
			//$criteria2->condition = "close IS NULL ";

            //$criteria2->addCondition('hidden=' . $visible);
			//$criteria2->addCondition('user_sales=' . $userid);
			//$criteria2->addCondition('duplicate IS NULL');

			//$criteria2->addSearchCondition('date' , $today);
			$criteria->order = 'id DESC';
			$total = Distributelog::model()->count($criteria);

			$pages = new CPagination($total);
			$pages->pageSize = 200;
			$pages->applyLimit($criteria);

			$alllog = Distributelog::model()->findAll($criteria);




                                                            
            if(isset($_GET['Search'])){
            //var_dump($_GET['Search']['too']);exit;
            
    			$criteria = new CDbCriteria();
    			$criteria->order = 'id DESC'; 
    			
                // $criteria->addSearchCondition('user_id', $userid, false);
    			if(!empty($_GET['Search']['too'] ))
    			$criteria->addSearchCondition('too', $_GET['Search']['too']  ,false, "AND");
    			
    			
    			if(!empty($_GET['Search']['team'] ))
    			$criteria->addSearchCondition('too', $_GET['Search']['team']  ,false, "AND");
    
    			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
    			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');
    		 
    			
    				$alllog = Distributelog::model()->findAll($criteria);
    				$total=count($alllog);
    			
	    	}
	    
			

		
		 
		
			$this->render('distributelog',array(
					'userid'=>$userid ,	 		
					'alllog'=>$alllog ,	
					'pages' => $pages,	
					'total' => $total,



				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}	
	
public function  actionChangesalesstatusbroker(){

		if(Yii::app()->user->isMember()){

 
			if(isset($_POST['submit'])){
				$secert=$_POST['secert'];
				$model= Brokers::model()->findByPk($secert);
				if($model->close==1){$model->close=NULL;}else{$model->close=1;}
				$model->save();
				$this->redirect(array('marketing/addbrokersales')	);

			}
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}






	public function  actionChangestatusbroker(){

		if(Yii::app()->user->isMember()){

 
			if(isset($_POST['submit'])){
				$secert=$_POST['secert'];
				$model= Brokers::model()->findByPk($secert);
				if($model->active==1){$model->active=NULL;}else{$model->active=1;}
				$model->save();
				$this->redirect(array('marketing/addbrokers')	);

			}
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}


public function actionRecordholder($title){
    
    if(Yii::app()->user->isMember())
		{
    $this->layout = '//';
		    
$main=Mainsettings::model()->findByPk(1);
	


	
	$bucketName = 'recordsolid';
	$IAM_KEY = 'AKIASCY6ZVTSZZTOUZWV';
	$IAM_SECRET = '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';
	$ENDPOINT = 'https://s3.us-east-1.amazonaws.com';	


		    
// Get path from db
//var_dump($title);
//exit;

$file=Recorder::model()->findByAttributes(array('id'=>$title));
$data=Recorder::model()->findByAttributes(array('id'=>$title));





$keyPath = $main->recordpath.$file->file;
//var_dump($keyPath);exit;
    
try {
// Instantiate the S3 class and point it at the desired host
$client = new S3Client([
'region' => 'us-east-1',
'version' => 'latest',
'endpoint' => $ENDPOINT,
'credentials' => [
'key' => $IAM_KEY,
'secret' => $IAM_SECRET
],
// Set the S3 class to use objects.dreamhost.com/bucket
// instead of bucket.objects.dreamhost.com
'use_path_style_endpoint' => true
]);
         
    
   // $object = $client->getObject(array(
    //'Bucket' => $BUCKET_NAME,
   // 'Key'    => $keyPath
//));

$object = $client->getObject(['Bucket' => $bucketName, 'Key' => $keyPath ]);
//file_put_contents('people.m4a', $object['Body']->getContents());
$secret_plans_cmd = $client->getCommand('GetObject', ['Bucket' => $bucketName, 'Key' => $keyPath]);
$request = $client->createPresignedRequest($secret_plans_cmd, '+1 hour');

} catch (Exception $e) {
die("Error: " . $e->getMessage());
}
		    
		    
		

		$this->render('recordholder',array(
		    
		    'request'=>$request,
		    'file'=>$file,
		    'data'=>$data,
		    
		    ));
		

	}
		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
	
	
	
	
	



public function actionConfirmeoi($id)
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);


	
	
        $model=Eoiform::model()->findByAttributes(array('id'=>$id));
        //var_dump($model);
       //exit;
	//	$model->con_date = $today;
		$model->active = 1;
		$model->secert= $rnd.$userid;
		if ($model->save()) {
		
		
		$this->redirect(array('account/pendingdailyrestrictions')	);


		}
	



		
		
		
		
	
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
		
		
		
public function actionCanceleoi()
		{
		if(Yii::app()->user->isMember())
		{


 

		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);


	
	
        $model=Eoiform::model()->findByAttributes(array('id'=>$_POST['id']));
        //var_dump($model);
       //exit; 
		$model->rejected = 1 ; 
		if ($model->save()) {
		
		
		$this->redirect(array('eoi')	);


		}
	



		
		
		
		
	
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}
		
		
		
		
		
		
		
public function actionDeleteeoi()
		{
		if(Yii::app()->user->isMember())
		{


 

		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);


	
	
        $model=Eoiform::model()->findByAttributes(array('id'=>$_POST['id']));
        //var_dump($model);
       //exit; 
		$model->delete = 1 ; 
		if ($model->save()) {
		
		
		$this->redirect(array('eoi')	);


		}
	



		
		
		
		
	
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}





public function actionConfirmxeoi()
		{
		if(Yii::app()->user->isMember())
		{


 

		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);


	
	
        $model=Eoiform::model()->findByAttributes(array('id'=>$_POST['id']));
        
        $criteriaeoi = new CDbCriteria;
        $criteriaeoi->order = 'done DESC';
        $criteriaeoi->limit= 1;
        $lasteoiform= Eoiform::model()->findAll($criteriaeoi); 
        
        

        if(!empty($lasteoiform)){
        foreach($lasteoiform as $lasteoi){
        $eoi=Eoiform::model()->findByAttributes(array('id'=>$_POST['eoi_id']));
        $model->done = $lasteoi->done + 1;
        $model->save();
        if(!$model->save()){
        $errores = $model->getErrors();
        var_dump($errores);
        }
        }
        }
                
        
        //var_dump($model);
        //exit; 
        $model->accepted = 1 ; 
        if ($model->save()) {
            
            
            
            
            
            
  //var_dump('s');exit;          
		    
$main = Mainsettings::model()->findByPk(1);
if (!empty($main->post_url_eoi)) {
   // var_dump($main->post_url_eoi);exit;

    
if (!empty($main->post_token)) {
//var_dump('11');exit;
// API URL
$url = $main->post_url_eoi;
// Authorization token
$token = $main->post_token;
//$deliveryDate = DateTime::createFromFormat('Y-m-d', $conlead->delivery_date);
if ($deliveryDate !== false) {
    // Format the date as 'Y-m-d\TH:i:s\Z' (ISO 8601 format)
    //$formattedDate = $deliveryDate->format('Y-m-d\TH:i:s\Z');
} else {
    // Handle the case where the date could not be parsed (e.g., set to null)
    $formattedDate = null;
}

$lead=Leads::model()->findByAttributes(array('id'=>$model->lead_id));
$sales =User::model()->findByAttributes(array('id'=>$lead->user_sales));

// Data to be sent in the POST request
$data = array(
    "TITLE" => $model->title,
    "IDCARD" => $model->codeid,
    "NATIONALITY" => $model->nationality,
    "FULLADDRESS" => $model->address,
    "PROJECT" => $model->project,
    "BUILDING" => $model->building,
    "EOI" => 1,
    "EOIDATE" => $model->date,
    "NAME" => $model->title,
    "EMAIL" => $model->email,
    "JOB" => $model->job,
    "BROKERAGENTNAME" => $model->salesbroker,
    "PAYMENTMETHOD" => $model->amount_type,
    "UNITPRICE" => $model->amount,
    "EOIID" => $model->id,
    "CONFIRM_" => 0,
    "Salesname" => $sales->fname.''.$sales->lname,
    "Salesman" => $sales->id,
    "Phone" => $lead->tel,
    "CustomerCode" => $lead->id
    
);

// Convert data array to JSON
$data_json = json_encode($data);

// Initialize cURL session
$ch = curl_init($url);

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $data_json);
curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    'Content-Type: application/json',
    'Authorization: Bearer ' . $token
));

// Execute the request
$response = curl_exec($ch);

// Get the HTTP status code
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

//
if ($response === false) {
    echo 'cURL Error: ' . curl_error($ch);
} else {
    // Get HTTP status code
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Display the HTTP status code
    //echo "HTTP Status Code: " . $http_code . "\n";
   // $response_data = json_decode($response, true);

    // Check if status code is not 200
    if ($http_code != 200) {
        // Decode the response
        $response_data = json_decode($response, true);
        $data_json = json_encode($response_data);

        // var_dump the HTTP status code and JSON data separately
        var_dump($http_code);
        var_dump($data_json);
        exit;
    }

    // Decode and pretty print the JSON response
    $response_data = json_decode($response, true);
    //echo '<pre>' . json_encode($response_data, JSON_PRETTY_PRINT) . '</pre>';
}

// Close cURL session
curl_close($ch);




}
}
				    
	
		    
            
            
        $this->redirect(array('eoi')	);

		}
	



		
		
		
		
	
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}










public function actionMortgage($id)
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);


				
		
$this->layout='//layouts/systemcgridview';
if (isset($_POST['bankaccount'])) {

$bankaccount=$_POST['bankaccount'];

$mf=MortgageFinancingBank::model()->findByAttributes(array('id'=>$bankaccount));

$mortgage = new MortgageFinancing();
$mortgage->credit_score_approval_sent=1;
$mortgage->email_sent_to_employee=$bankaccount;
$mortgage->name=$_POST['name'];
$mortgage->birthdate=$_POST['birthdate'];
$mortgage->idcard=$_POST['idcard'];
$mortgage->email_sent_to_employee_account=$mf->email;



//var_dump($_POST['birthdate']);exit;


  // Handle file upload using the model name and attribute (MortgageFinancing[upload])
        $uploadedFile = CUploadedFile::getInstance($mortgage, 'upload');
       // var_dump($uploadedFile);exit;
        if (!empty($uploadedFile)) {
            $fileName = "{$rnd}-{$uploadedFile->name}";  // Create a unique file name with random number
          //  var_dump($fileName);exit;
            $mortgage->idcard = $fileName;  // Save the file name to the database (adjust this according to your database structure)

            // Save the uploaded file to the specified directory
            $uploadPath = Yii::app()->basePath . '/../uploads/' . $fileName;
            if ($uploadedFile->saveAs($uploadPath)) {
                // File successfully uploaded
                $out = $uploadPath;
            } else {
                // Handle file saving error
                throw new CHttpException(500, 'File upload failed.');
            }
        }

$mortgage->date=$today;
$mortgage->time=$time;
$mortgage->user_id=$userid;
$mortgage->lead_id=$id;
$mortgage->save();


if ($mortgage->save()) {
$this->redirect(array('leads/profile/'.$id)	);

}

if (!$mortgage->save()) {
var_dump($mortgage->getErrors());
exit;
}
}
var_dump($bankaccount);exit;
$allmortgage= MortgageFinancing::model()->findAll(array('order'=>'id DESC' ));

		
		
		
		$this->render('eoi',array(
		'userid'=>$userid ,	
                'model'=>$model,
                'model2'=>$model2,
                'allmortgage'=>$allmortgage,		
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}





public function actionMortgageapprove($id)
		{
		if(Yii::app()->user->isMember())
		{

		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

$creditscoreapprovalstatus=$_POST['creditscoreapprovalstatus'];
$mortgage = MortgageFinancing::model()->findByPk($id);

if($creditscoreapprovalstatus == 1){
$mortgage->credit_score_approval_status=1;

}else{
    
  $mortgage->credit_score_approval_status=2;
  
}
$mortgage->save();

if ($mortgage->save()) {
$this->redirect(array('leads/profile/'.$mortgage->lead_id)	);

}

if (!$mortgage->save()) {
var_dump($mortgage->getErrors());
exit;
}


		
		
		
		$this->render('eoi',array(
		'userid'=>$userid ,	
                'model'=>$model,
                'model2'=>$model2,
                'allmortgage'=>$allmortgage,		
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}






public function actionMortgageeoi($id)
		{
		if(Yii::app()->user->isMember())
		{

		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

$mortgage = MortgageFinancing::model()->findByPk($id);
$mortgage->form_approval_status=1;
$mortgage->save();

if ($mortgage->save()) {
$this->redirect(array('leads/profile/'.$mortgage->lead_id)	);

}

if (!$mortgage->save()) {
var_dump($mortgage->getErrors());
exit;
}


		
		
		
		$this->render('eoi',array(
		'userid'=>$userid ,	
                'model'=>$model,
                'model2'=>$model2,
                'allmortgage'=>$allmortgage,		
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}






public function actionMortgagefinal($id)
		{
		if(Yii::app()->user->isMember())
		{

		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

$mortgage = MortgageFinancing::model()->findByPk($id);
$final=$_POST['final'];

$mortgage->approval_status=$final;
$mortgage->save();

if ($mortgage->save()) {
$this->redirect(array('leads/profile/'.$mortgage->lead_id)	);

}

if (!$mortgage->save()) {
var_dump($mortgage->getErrors());
exit;
}


		
		
		
		$this->render('eoi',array(
		'userid'=>$userid ,	
                'model'=>$model,
                'model2'=>$model2,
                'allmortgage'=>$allmortgage,		
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}




public function actionMortgagefinaltransfer($id)
		{
		if(Yii::app()->user->isMember())
		{

		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

$mortgage = MortgageFinancing::model()->findByPk($id);
$final=$_POST['final'];

$mortgage->transfer=$final;
$mortgage->save();

if ($mortgage->save()) {
$this->redirect(array('leads/profile/'.$mortgage->lead_id)	);

}

if (!$mortgage->save()) {
var_dump($mortgage->getErrors());
exit;
}


		
		
		
		$this->render('eoi',array(
		'userid'=>$userid ,	
                'model'=>$model,
                'model2'=>$model2,
                'allmortgage'=>$allmortgage,		
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}




public function actionMortgageeoipay($id)
{
    if (Yii::app()->user->isMember()) {
        $userid = Yii::app()->user->id;
        $main = Mainsettings::model()->findByPk(1);

        // Set the timezone based on the settings or default to Cairo
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }

        $today = date("Y-m-d");
        $time = date("H:i:s");
        $rnd = rand(0, 99999);

        // Find the mortgage record by ID
        $mortgage = MortgageFinancing::model()->findByPk($id);
        if ($mortgage === null) {
            throw new CHttpException(404, 'Mortgage not found.');
        }

        // Handle file upload using the model name and attribute (MortgageFinancing[upload])
        $uploadedFile = CUploadedFile::getInstance($mortgage, 'upload');
        if (!empty($uploadedFile)) {
            $fileName = "{$rnd}-{$uploadedFile->name}";  // Create a unique file name with random number
          //  var_dump($fileName);exit;
            $mortgage->receipt = $fileName;  // Save the file name to the database (adjust this according to your database structure)

            // Save the uploaded file to the specified directory
            $uploadPath = Yii::app()->basePath . '/../uploads/' . $fileName;
            if ($uploadedFile->saveAs($uploadPath)) {
                // File successfully uploaded
                $out = $uploadPath;
            } else {
                // Handle file saving error
                throw new CHttpException(500, 'File upload failed.');
            }
        }

        // Update the mortgage record
      //  $mortgage->form_approval_status = 1;  // Set the approval status (adjust as necessary)

        if ($mortgage->save()) {
            // Redirect to the leads profile after successful save
            $this->redirect(array('leads/profile/' . $mortgage->lead_id));
        } else {
            // Output validation errors for debugging
            var_dump($mortgage->getErrors());
            exit;
        }

    } else {
        // User is not logged in, redirect to the login page
        $model = new LoginForm;

        if (isset($_POST['ajax']) && $_POST['ajax'] === 'login-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if (isset($_POST['LoginForm'])) {
            $model->attributes = $_POST['LoginForm'];

            if ($model->validate() && $model->login()) {
                $this->redirect(array('home/index'));
            }
        }

        // Redirect to the home page if login fails
        $this->redirect(array('home/index'));
    }
}







public function actionEoi()
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
		
$this->layout='//layouts/systemcgridview';

		//$allcontract=Eoiform::model()->findAll();
		$allcontract= Eoiform::model()->findAll(array('order'=>'id DESC' ));

		$model = new Eoiform();
		if (isset($_POST['Eoiform'])) {
		$rnd = rand(0,9999);
		$model->attributes = $_POST['Eoiform'];
		
		
		 // $mail = $_POST['Eoiform']['email'];
//var_dump($mail);exit;
		$lead=Leads::model()->findByAttributes(array('id'=>$_POST['Eoiform']['lead_id']));
        if (!empty($lead)) {
        $idcard=$_POST['Eoiform']['codeid'];
        $lead->idcard = $idcard;
        $lead->eoi = 1;
        $lead->save();
        }
        
              
        
        $unit=$_POST['Eoiform']['unit_id'];
        if (!empty($unit)) {
        $unit=Units::model()->findByAttributes(array('id'=>$unit));
$unit->booking=4;
$unit->save();
        }
        

        $model->date = $today;
        //$model->con_date = $today;
        
        
         
       $salesbroker= $_POST['Eoiform']['salesbroker'];
       
       $addbroker= $_POST['Eoiform']['addbroker'];
       if(!empty($addbroker)){
           
           

           
                           
            $userid=Yii::app()->user->id;
            $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
            $today = date("Y-m-d");                     // 03.10.01
            $time = date("H:i:s");                      // 17:16:18	
            $rnd = rand(0,99999);
            
            $modelbroker = new Brokers();
            $modelbroker->setScenario('com_porfile');
            $user=User::model()->findByPk($userid);
            $rnd = rand(0,9999);
            $modelbroker->attributes=$_POST['Brokers'];
            $modelbroker->user_id = $userid;
            $modelbroker->title = $addbroker;
            $modelbroker->date = $today;
            $modelbroker->time = $time;
            $modelbroker->secert = $rnd;
            
            $modelbroker->save();
            // var_dump($addbroker);exit;
            $model->broker = $modelbroker->title;
            
            
            
            
            }else{
                
            $broker=Brokers::model()->findByAttributes(array('id'=>$_POST['Eoiform']['broker']));
            $sales=User::model()->findByAttributes(array('id'=>$broker->user_sales));
            $othersales=User::model()->findByAttributes(array('id'=>$broker->othersales));
            $thirdsales=User::model()->findByAttributes(array('id'=>$broker->thirdsales));    
            
            $model->broker = $broker->title;
            
            
            }
       
        
        
       
        $model->sales = $sales->fname.$sales->lname;
        $model->othersales = $othersales->fname.$othersales->lname;
        $model->thirdsales = $thirdsales->fname.$thirdsales->lname;
        $model->time = $time;
        $model->secert= $rnd.$userid;
        $model->user_id= $userid;
        $model->salesbroker=$_POST['Eoiform']['salesbroker'];
        $model->sales=$_POST['Eoiform']['sales'];

        $model->teamleaderbroker=$_POST['Eoiform']['teamleaderbroker'];
        $model->building = $_POST['Eoiform']['building'];
        $model->floor = $_POST['Eoiform']['floor'];
        $model->job = $_POST['Eoiform']['job'];
        $model->broker = $_POST['Eoiform']['broker'];
        $model->email = $_POST['Eoiform']['email'];

        $model->autocode= 1;
        
        if(!empty($_POST['Eoiform']['code'])){
        $model->done= $_POST['Eoiform']['code'];
        //var_dump($_POST['Eoiform']['code']);
        //exit;
        }

        
        if(!$model->save()){
        $errores = $model->getErrors();
        var_dump($errores);
        }
		
		if ($model->save()) {
		    
		    
		    if(!empty($model->lead_id)){
			$lead=Leads::model()->findByAttributes(array('id'=>$model->lead_id));
			$sales=User::model()->findByAttributes(array('id'=>$lead->user_sales));
            $model->sales = $sales->fname.$sales->lname;
            $model->teamleader = $_POST['Eoiform']['teamleader'];
			$model->save()  ;
			
			
			
			$main=Mainsettings::model()->findByPk(1);

			            if(!empty($main->autoclosedeal)){
                    $lead->close=1;
                    $lead->reopen=NULL;
                    $lead->communication=1;
                    $lead->close_date= $today;
                    $substatus=Substatus::model()->findByPk($main->autoclosedeal);
                    $qualifiedtest=Statues::model()->findByPk($substatus->parent_id);
                    if($qualifiedtest->qualified == 1){
                    $lead->qualified=1;
                    if(empty($lead->first_classification)){
                    $lead->first_classification=1;
                    $lead->first_classification_user=$userid; 
                    }
                    }
                    if($lead->nonqualified == 1){
                    $lead->nonqualified=1;
                    if(empty($lead->first_classification)){
                    $lead->first_classification=2;
                    $lead->first_classification_user=$userid; 
                    }
                    }
                    $lead->substatus=$main->autoclosedeal;
                    $substatus=Substatus::model()->findByPk($main->autoclosedeal);
                    $lead->status=$substatus->parent_id;

                    if($substatus->answer == 1){
                    $lead->answer=1;
                    }
                    if($substatus->answer == 2){
                    $lead->answer=2;
                    }
                    if($substatus->expvisit == 1){
                    $lead->expvisit=1;
                    }
                    if($substatus->callback == 1){
                    $lead->callback=1;
                    }
                    $lead->sales_report='Close Deal by EOI';
                    $lead->save(); 
                    
                    
                    
                   // var_dump($lead->id);exit;
                    
                    
                    //clear activities of closed leads
                    $criteria = new CDbCriteria;
                    $criteria->condition = "close IS NULL OR report IS NULL  ";
                    $criteria->addCondition('leads_id=' . $lead->id);
                    $allactivities=Activities::model()->findAll($criteria);
                    

                    
                    if(!empty($allactivities)){
                    foreach($allactivities as $activity){
                    $activity->close=1;
                    $activity->report='Closed In '.$today.'-'.$_POST['report'];
                    $activity->save();
                    }
                    
                    
                    
                    
                    $newmodel= new Activities();
                    $newmodel->user_id = $userid;
                    $newmodel->leads_id = $lead->id;
                    $newmodel->lead_date = $lead->date;
                    
                    $newmodel->date = $today;
                    $newmodel->time = $time;
                    
                    $newmodel->details= $lead->sales_report;
                    $rnd = rand(0,99999);
                    $newmodel->code= $rnd; 
                    $newmodel->report= 'Closed In '.$today.'-'.$lead->sales_report;
                    $newmodel->follow_date= $today;
                    $newmodel->status= $lead->status;
                    $newmodel->substatus=$lead->substatus;
                    $substatus=Substatus::model()->findByPk($lead->substatus);
                      
                    if($substatus->answer == 1){
                    $newmodel->answer=1; 
                    }
                    
                    
                    if($substatus->answer == 2){
                    $newmodel->answer=2; 
                    }
                    
                    
                    
                      
                    if($substatus->expvisit == 1){
                    $newmodel->expvisit=1;
                    }
                    
                    
                    
                    if($substatus->callback == 1){
                    $newmodel->callback=1;
                    }
                    
                    
                    $newmodel->type= 1;
                    $newmodel->close=1;
                    
                    
                    $newmodel->save();
                    $lead=Leads::model()->findByPk($newmodel->leads_id);
                    $lead->follow_date=$newmodel->follow_date;
                    $lead->checkup_activity=$today; 
                    $lead->save();
                    $newmodel->secert=$newmodel->id;
                    $newmodel->name=$lead->title;
                    $newmodel->tel=$lead->tel;
                    $newmodel->coldcall=$lead->coldcall;
                    $newmodel->indirect=$lead->indirect;
                    $newmodel->save();
                    
                    //if(!$newmodel->save()){
                    	//var_dump($newmodel->getErrors());
                    //	}
                    
                    }else{
                        
                                           // var_dump('ddd');exit;

                    //clear activities of closed leads
                    
                    
                    $newmodel= new Activities();
                    $newmodel->user_id = $userid;
                    $newmodel->leads_id = $lead->id;
                    $newmodel->lead_date = $lead->date;
                    $newmodel->date = $today;
                    $newmodel->time = $time;
                    
                    $newmodel->details= $lead->sales_report;
                    $rnd = rand(0,99999);
                    $newmodel->code= $rnd; 
                    
                    $newmodel->report= 'Closed In '.$today.'-'.$lead->sales_report;
                    $newmodel->follow_date= $today;
                    $newmodel->status= $lead->status;
                    $newmodel->substatus=$lead->substatus;
                    $substatus=Substatus::model()->findByPk($lead->substatus);
                      
                    if($substatus->answer == 1){
                    $newmodel->answer=1; 
                    }
                    
                    
                    if($substatus->answer == 2){
                    $newmodel->answer=2; 
                    }
                    
                    
                    
                    
                                    
                    if($substatus->expvisit == 1){
                    $newmodel->expvisit=1;
                    }
                    
                    
                    
                    if($substatus->callback == 1){
                    $newmodel->callback=1;
                    }
                    
                    $newmodel->type= 1;
                    $newmodel->close=1;
                    
                    
                    $newmodel->save();
                    $lead=Leads::model()->findByPk($newmodel->leads_id);
                    $lead->follow_date=$newmodel->follow_date;
                    $lead->checkup_activity=$today; 
                    $lead->save();
                    $newmodel->secert=$newmodel->id;
                    $newmodel->name=$lead->title;
                    $newmodel->tel=$lead->tel;
                    $newmodel->coldcall=$lead->coldcall;
                    $newmodel->indirect=$lead->indirect;
                    $newmodel->save();
                    
                    
                    
                    
                    
                    

                    }


			
			
			}


			
			
			}
		
		

		Yii::app()->controller->refresh();


		}
		}
		
$model2 = new Deposit();
$model2->setScenario('com_porfile');
if(isset($_POST['Deposit'])){
    
    

  
				$rnd = rand(0,9999);
				$model2->attributes = $_POST['Deposit'];
				$model2->date= $today;
				$model2->time= $time;
				$model2->user_id = $userid;
				$model2->secret = $rnd.$userid;
				$model2->code = $_POST['code'];
				$bankertitle=Banker::model()->findByAttributes(array('id'=>$_POST['Deposit']['banker_id']));
				if(empty($bankertitle)){
				    
				$codebankertitle=Treeaccount::model()->findByAttributes(array('title'=>$_POST['Deposit']['banker_id']));
 
				    
				$banker = new Banker();
				$rnd = rand(0,9999);
				$banker->date= $today;
				$banker->time= $time;
				$banker->user_id = $userid;
				$banker->accountant_id = $userid;
				$banker->details = $_POST['Deposit']['banker_id'];
				$banker->title = $_POST['Deposit']['banker_id'];
				$banker->tree_id = $codebankertitle->id;
				$banker->secret = $rnd.$userid;
				$banker->code = $_POST['code'];
				//$banker->typebank = 4;
				$banker->save(); 
				
				//var_dump($banker);
				//exit;
				    
			     $model2->banker_id= $banker->id;    
				}

if(!empty($_POST['Deposit']['tree_id'])){
$code=Treeaccount::model()->findByAttributes(array('code'=>$_POST['Deposit']['tree_id']));
$model2->tree_id=$code->id;}else{$model2->tree_id=$_POST['tree_id'];}
				if($model2->save()){
				    
				$codebanker=Banker::model()->findByAttributes(array('id'=>$model2->banker_id));
				   
				$visible =1;  
                $criteriaeoi = new CDbCriteria;
                $criteriaeoi->order = 'done DESC';
                $criteriaeoi->limit= 1;
                $criteriaeoi->addSearchCondition('active', $visible );
                $lasteoiform= Eoiform::model()->findAll($criteriaeoi); 
  
if(!empty($lasteoiform)){
	foreach($lasteoiform as $lasteoi){


				   $eoi=Eoiform::model()->findByAttributes(array('id'=>$_POST['eoi_id']));
				
                   $eoi->active = 1;
                   //$eoi->done = $eoi->id;
				   $eoi->save();
				   
				   
                    if($eoi->save()){
                    $lead=Leads::model()->findByAttributes(array('id'=>$eoi->lead_id));
                    $lead->client_id = 1;
                    $lead->save();
                    }
				   
				   if(!$eoi->save()){
					$errores = $eoi->getErrors();
					var_dump($errores);
				   }
				   
	}
}else{
    
    
      $eoi=Eoiform::model()->findByAttributes(array('id'=>$_POST['eoi_id']));
      
         
				
                   $eoi->active = 1;
                   //$eoi->done = 1;
				   $eoi->save();
				   
				   
				   
    
    
}
				    
				    $dailyrestrictions = new Dailyrestrictions();
				    $dailyrestrictions->date= $today;
				    $dailyrestrictions->time= $time;
				    $dailyrestrictions->user_id = $userid;
				    $dailyrestrictions->tree_id_to = $codebanker->tree_id;
				    $dailyrestrictions->tree_id = $model2->tree_id;
				    $dailyrestrictions->details = $model2->details;
				    $dailyrestrictions->lead_id = $model2->lead_id;
				    $dailyrestrictions->building_tree = $model2->building_tree;
				    $dailyrestrictions->unit_id = $model2->service_id;


				    $dailyrestrictions->amount = $model2->amount;
				    $dailyrestrictions->secret = $rnd.$userid;
				    $dailyrestrictions->code = $rnd.$userid;

				    
				    $dailyrestrictions->file = 1;
				    $dailyrestrictions->save();
				    //$errores = $dailyrestrictions->getErrors();
				    
				    
				    
				    
				    
					Yii::app()->controller->refresh();
				}else{}
			}

		if(isset($_POST['downloadexcel'])){
    

	ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');


 

$fields = array('id','project','title','time'
,'nationality','unit_type','date','from_id','amount_type','address','details' );
$labels= array('id','project','title','time'
,'nationality','unit_type','date','from_id','amount_type','address','details' );
XlsExporter2::downloadXls('SOLID XLS', $allcontract, 'Report-', TRUE  , $labels  , $fields, 'COUNT');


			}
		
		
		
		
		$this->render('eoi',array(
		'userid'=>$userid ,	
                'model'=>$model,
                'model2'=>$model2,
                'allcontract'=>$allcontract,		
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}


public function actionEditeoi($id)
		{
		if(Yii::app()->user->isMember())
		{


		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		//$allcontract=Eoiform::model()->findAll();
		  
		$model = Eoiform::model()->findByPk($id);
		//var_dump($model);exit;
		
		$rnd = rand(0,9999);
		$model->attributes = $_POST['Eoiform'];
  
		 
		
		if(!$model->save()){
        $errores = $model->getErrors();
        var_dump($errores);
        }else{
    		$this->redirect(array('sales/eoi')	);
        }
		 

 
		
		
        

		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}





public function actionEoisales()
		{
		if(Yii::app()->user->isMember())
		{
		    
		   // var_dump('ss');exit;


		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
		
$this->layout='//layouts/systemcgridview';

		//$allcontract=Eoiform::model()->findAll();
	//	$allcontract= Eoiform::model()->findAll(array('order'=>'id DESC' ));
					$allcontract = Eoiform::model()->findAll(array( 'condition' => 'user_id=' . $userid ,'order'=>'id DESC'  ));


		$model = new Eoiform();
		if (isset($_POST['Eoiform'])) {
		$rnd = rand(0,9999);
		$model->attributes = $_POST['Eoiform'];
		$lead=Leads::model()->findByAttributes(array('id'=>$_POST['Eoiform']['lead_id']));
        if (!empty($lead)) {
        $idcard=$_POST['Eoiform']['codeid'];
        $lead->idcard = $idcard;
        

        $lead->eoi = 1;
        $lead->save();
        }

        $model->date = $today;
       // $model->con_date = $today;
                $model->con_date = $_POST['Eoiform']['con_date'];

        
       $salesbroker= $_POST['Eoiform']['salesbroker'];
       $passport=$_POST['Eoiform']['passport'];
       $email=$_POST['Eoiform']['email'];

      // var_dump($email);exit;
        
        
        $broker=Brokers::model()->findByAttributes(array('id'=>$_POST['Eoiform']['brokerid']));
       // var_dump($broker);exit;
        $sales=User::model()->findByAttributes(array('id'=>$broker->user_sales));
        $othersales=User::model()->findByAttributes(array('id'=>$broker->othersales));
        $thirdsales=User::model()->findByAttributes(array('id'=>$broker->thirdsales));
        
        
        
        
        $model->sales = $sales->fname.$sales->lname;
        $model->othersales = $othersales->fname.$othersales->lname;
        $model->thirdsales = $thirdsales->fname.$thirdsales->lname;
        $model->broker = $broker->title;
        $model->time = $time;
        $model->secert= $rnd.$userid;
        $model->user_id= $userid;
        $model->salesbroker= $salesbroker;
        $model->autocode= 1;
        $model->building = $_POST['Eoiform']['building'];
        $model->floor = $_POST['Eoiform']['floor'];
        $model->job = $_POST['Eoiform']['job'];
        $model->local = $_POST['Eoiform']['local'];

        $model->email = $email;


$leader=Teamleader::model()->findByAttributes(array('sales_id'=>$lead->user_sales));
if(!empty($leader)){
$leaderuser=User::model()->findByAttributes(array('id'=>$leader->leader_id));

$model->teamleader = $leaderuser->fname.''.$leaderuser->lname;

}

        $model->passport = $passport;
        $model->broker = $_POST['Eoiform']['broker'];
        if(!empty($_POST['Eoiform']['code'])){
        $model->done= $_POST['Eoiform']['code'];
        //var_dump($_POST['Eoiform']['code']);
        //exit;
        }
        
        
$unit=$_POST['Eoiform']['unit_id'];
if (!empty($unit)) {
$unit=Units::model()->findByAttributes(array('id'=>$unit));
$unit->booking=4;
$unit->save();
}
        

        
        if(!$model->save()){
        $errores = $model->getErrors();
        var_dump($errores);
        }
		
		if ($model->save()) {
		    
		    
	//	var_dump($model);exit;    
		    
		    
		    
		    
		    
		    
		    
		    
		    	if(!empty($model->lead_id)){
			$lead=Leads::model()->findByAttributes(array('id'=>$model->lead_id));
			$sales=User::model()->findByAttributes(array('id'=>$lead->user_sales));
            $model->sales = $sales->fname.$sales->lname;
			$model->save();
			
			
						$main=Mainsettings::model()->findByPk(1);

			            if(!empty($main->autoclosedeal)){
                    $lead->close=1;
                    $lead->reopen=NULL;
                    $lead->communication=1;
                    $lead->close_date= $today;
                    $substatus=Substatus::model()->findByPk($main->autoclosedeal);
                    $qualifiedtest=Statues::model()->findByPk($substatus->parent_id);
                    if($qualifiedtest->qualified == 1){
                    $lead->qualified=1;
                    if(empty($lead->first_classification)){
                    $lead->first_classification=1;
                    $lead->first_classification_user=$userid; 
                    }
                    }
                    if($lead->nonqualified == 1){
                    $lead->nonqualified=1;
                    if(empty($lead->first_classification)){
                    $lead->first_classification=2;
                    $lead->first_classification_user=$userid; 
                    }
                    }
                    $lead->substatus=$main->autoclosedeal;
                    $substatus=Substatus::model()->findByPk($main->autoclosedeal);
                    $lead->status=$substatus->parent_id;

                    if($substatus->answer == 1){
                    $lead->answer=1;
                    }
                    if($substatus->answer == 2){
                    $lead->answer=2;
                    }
                    if($substatus->expvisit == 1){
                    $lead->expvisit=1;
                    }
                    if($substatus->callback == 1){
                    $lead->callback=1;
                    }
                    $lead->sales_report='Close Deal by EOI';
                    $lead->save(); 
                    
                    
                    
                   // var_dump($lead->id);exit;
                    
                    
                    //clear activities of closed leads
                    $criteria = new CDbCriteria;
                    $criteria->condition = "close IS NULL OR report IS NULL  ";
                    $criteria->addCondition('leads_id=' . $lead->id);
                    $allactivities=Activities::model()->findAll($criteria);
                    

                    
                    if(!empty($allactivities)){
                    foreach($allactivities as $activity){
                    $activity->close=1;
                    $activity->report='Closed In '.$today.'-'.$_POST['report'];
                    $activity->save();
                    }
                    
                    
                    
                    
                    $newmodel= new Activities();
                    $newmodel->user_id = $userid;
                    $newmodel->leads_id = $lead->id;
                    $newmodel->lead_date = $lead->date;
                    
                    $newmodel->date = $today;
                    $newmodel->time = $time;
                    
                    $newmodel->details= $lead->sales_report;
                    $rnd = rand(0,99999);
                    $newmodel->code= $rnd; 
                    $newmodel->report= 'Closed In '.$today.'-'.$lead->sales_report;
                    $newmodel->follow_date= $today;
                    $newmodel->status= $lead->status;
                    $newmodel->substatus=$lead->substatus;
                    $substatus=Substatus::model()->findByPk($lead->substatus);
                      
                    if($substatus->answer == 1){
                    $newmodel->answer=1; 
                    }
                    
                    
                    if($substatus->answer == 2){
                    $newmodel->answer=2; 
                    }
                    
                    
                    
                      
                    if($substatus->expvisit == 1){
                    $newmodel->expvisit=1;
                    }
                    
                    
                    
                    if($substatus->callback == 1){
                    $newmodel->callback=1;
                    }
                    
                    
                    $newmodel->type= 1;
                    $newmodel->close=1;
                    
                    
                    $newmodel->save();
                    $lead=Leads::model()->findByPk($newmodel->leads_id);
                    $lead->follow_date=$newmodel->follow_date;
                    $lead->checkup_activity=$today; 
                    $lead->save();
                    $newmodel->secert=$newmodel->id;
                    $newmodel->name=$lead->title;
                    $newmodel->tel=$lead->tel;
                    $newmodel->coldcall=$lead->coldcall;
                    $newmodel->indirect=$lead->indirect;
                    $newmodel->save();
                    
                    //if(!$newmodel->save()){
                    	//var_dump($newmodel->getErrors());
                    //	}
                    
                    }else{
                        
                                           // var_dump('ddd');exit;

                    //clear activities of closed leads
                    
                    
                    $newmodel= new Activities();
                    $newmodel->user_id = $userid;
                    $newmodel->leads_id = $lead->id;
                    $newmodel->lead_date = $lead->date;
                    $newmodel->date = $today;
                    $newmodel->time = $time;
                    
                    $newmodel->details= $lead->sales_report;
                    $rnd = rand(0,99999);
                    $newmodel->code= $rnd; 
                    
                    $newmodel->report= 'Closed In '.$today.'-'.$lead->sales_report;
                    $newmodel->follow_date= $today;
                    $newmodel->status= $lead->status;
                    $newmodel->substatus=$lead->substatus;
                    $substatus=Substatus::model()->findByPk($lead->substatus);
                      
                    if($substatus->answer == 1){
                    $newmodel->answer=1; 
                    }
                    
                    
                    if($substatus->answer == 2){
                    $newmodel->answer=2; 
                    }
                    
                    
                    
                    
                                    
                    if($substatus->expvisit == 1){
                    $newmodel->expvisit=1;
                    }
                    
                    
                    
                    if($substatus->callback == 1){
                    $newmodel->callback=1;
                    }
                    
                    $newmodel->type= 1;
                    $newmodel->close=1;
                    
                    
                    $newmodel->save();
                    $lead=Leads::model()->findByPk($newmodel->leads_id);
                    $lead->follow_date=$newmodel->follow_date;
                    $lead->checkup_activity=$today; 
                    $lead->save();
                    $newmodel->secert=$newmodel->id;
                    $newmodel->name=$lead->title;
                    $newmodel->tel=$lead->tel;
                    $newmodel->coldcall=$lead->coldcall;
                    $newmodel->indirect=$lead->indirect;
                    $newmodel->save();
                    
                    
                    
                    
                    
                    

                    }


			
			
			}

			
			}
		
		

		Yii::app()->controller->refresh();


		}
		}
		
$model2 = new Deposit();
$model2->setScenario('com_porfile');
if(isset($_POST['Deposit'])){
    
    

  
				$rnd = rand(0,9999);
				$model2->attributes = $_POST['Deposit'];
				$model2->date= $today;
				$model2->time= $time;
				$model2->user_id = $userid;
				$model2->secret = $rnd.$userid;
				$model2->code = $_POST['code'];
				$bankertitle=Banker::model()->findByAttributes(array('id'=>$_POST['Deposit']['banker_id']));
				if(empty($bankertitle)){
				    
				$codebankertitle=Treeaccount::model()->findByAttributes(array('title'=>$_POST['Deposit']['banker_id']));
 
				    
				$banker = new Banker();
				$rnd = rand(0,9999);
				$banker->date= $today;
				$banker->time= $time;
				$banker->user_id = $userid;
				$banker->accountant_id = $userid;
				$banker->details = $_POST['Deposit']['banker_id'];
				$banker->title = $_POST['Deposit']['banker_id'];
				$banker->tree_id = $codebankertitle->id;
				$banker->secret = $rnd.$userid;
				$banker->code = $_POST['code'];
				//$banker->typebank = 4;
				$banker->save(); 
				
				//var_dump($banker);
				//exit;
				    
			     $model2->banker_id= $banker->id;    
				}

if(!empty($_POST['Deposit']['tree_id'])){
$code=Treeaccount::model()->findByAttributes(array('code'=>$_POST['Deposit']['tree_id']));
$model2->tree_id=$code->id;}else{$model2->tree_id=$_POST['tree_id'];}
				if($model2->save()){
				    
				$codebanker=Banker::model()->findByAttributes(array('id'=>$model2->banker_id));
				   
				$visible =1;  
                $criteriaeoi = new CDbCriteria;
                $criteriaeoi->order = 'done DESC';
                $criteriaeoi->limit= 1;
                $criteriaeoi->addSearchCondition('active', $visible );
                $lasteoiform= Eoiform::model()->findAll($criteriaeoi); 
  
if(!empty($lasteoiform)){
	foreach($lasteoiform as $lasteoi){


				   $eoi=Eoiform::model()->findByAttributes(array('id'=>$_POST['eoi_id']));
				
                   $eoi->active = 1;
                   //$eoi->done = $eoi->id;
				   $eoi->save();
				   
				   
				       if($eoi->save()){
					$lead=Leads::model()->findByAttributes(array('id'=>$eoi->lead_id));
					$lead->client_id = 1;
				   $lead->save();
				   }
				   
				   if(!$eoi->save()){
					$errores = $eoi->getErrors();
					var_dump($errores);
				   }
				   
	}
}else{
    
    
      $eoi=Eoiform::model()->findByAttributes(array('id'=>$_POST['eoi_id']));
      
         
				
                   $eoi->active = 1;
                   //$eoi->done = 1;
				   $eoi->save();
				   
				   
				   
    
    
}
				    
				    $dailyrestrictions = new Dailyrestrictions();
				    $dailyrestrictions->date= $today;
				    $dailyrestrictions->time= $time;
				    $dailyrestrictions->user_id = $userid;
				    $dailyrestrictions->tree_id_to = $codebanker->tree_id;
				    $dailyrestrictions->tree_id = $model2->tree_id;
				    $dailyrestrictions->details = $model2->details;
				    $dailyrestrictions->lead_id = $model2->lead_id;
				    $dailyrestrictions->building_tree = $model2->building_tree;
				    $dailyrestrictions->unit_id = $model2->service_id;


				    $dailyrestrictions->amount = $model2->amount;
				    $dailyrestrictions->secret = $rnd.$userid;
				    $dailyrestrictions->code = $rnd.$userid;

				    
				    $dailyrestrictions->file = 1;
				    $dailyrestrictions->save();
				    //$errores = $dailyrestrictions->getErrors();
				    
				    
				    
				    
				    
					Yii::app()->controller->refresh();
				}else{}
			}

		if(isset($_POST['downloadexcel'])){
    

	ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');


 

$fields = array('id','project','title','time'
,'nationality','unit_type','date','from_id','amount_type','address','details' );
$labels= array('id','project','title','time'
,'nationality','unit_type','date','from_id','amount_type','address','details' );
XlsExporter2::downloadXls('SOLID XLS', $allcontract, 'Report-', TRUE  , $labels  , $fields, 'COUNT');


			}
		
		
		
		
		$this->render('eoisales',array(
		'userid'=>$userid ,	
                'model'=>$model,
                'model2'=>$model2,
                'allcontract'=>$allcontract,		
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}




public function actionEoileader()
		{
		if(Yii::app()->user->isMember())
		{
		    
		   // var_dump('ss');exit;


		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		
		
$this->layout='//layouts/systemcgridview';

		//$allcontract=Eoiform::model()->findAll();
	//	$allcontract= Eoiform::model()->findAll(array('order'=>'id DESC' ));
					$allcontract = Eoiform::model()->findAll(array( 'condition' => 'user_id=' . $userid ,'order'=>'id DESC'  ));


		$model = new Eoiform();
		if (isset($_POST['Eoiform'])) {
		$rnd = rand(0,9999);
		$model->attributes = $_POST['Eoiform'];
		$lead=Leads::model()->findByAttributes(array('id'=>$_POST['Eoiform']['lead_id']));
        if (!empty($lead)) {
        $idcard=$_POST['Eoiform']['codeid'];
        $lead->idcard = $idcard;
        

        $lead->eoi = 1;
        $lead->save();
        }

        $model->date = $today;
       // $model->con_date = $today;
                $model->con_date = $_POST['Eoiform']['con_date'];

        
       $salesbroker= $_POST['Eoiform']['salesbroker'];
       $passport=$_POST['Eoiform']['passport'];
       $email=$_POST['Eoiform']['email'];

      // var_dump($email);exit;
        
        
        $broker=Brokers::model()->findByAttributes(array('id'=>$_POST['Eoiform']['brokerid']));
       // var_dump($broker);exit;
        $sales=User::model()->findByAttributes(array('id'=>$broker->user_sales));
        $othersales=User::model()->findByAttributes(array('id'=>$broker->othersales));
        $thirdsales=User::model()->findByAttributes(array('id'=>$broker->thirdsales));
        
        
        
        
        $model->sales = $sales->fname.$sales->lname;
        $model->othersales = $othersales->fname.$othersales->lname;
        $model->thirdsales = $thirdsales->fname.$thirdsales->lname;
        $model->broker = $broker->title;
        $model->time = $time;
        $model->secert= $rnd.$userid;
        $model->user_id= $userid;
        $model->salesbroker= $salesbroker;
        $model->autocode= 1;
        $model->building = $_POST['Eoiform']['building'];
        $model->floor = $_POST['Eoiform']['floor'];
        $model->job = $_POST['Eoiform']['job'];
        $model->email = $email;


$leader=Teamleader::model()->findByAttributes(array('sales_id'=>$lead->user_sales));
if(!empty($leader)){
$leaderuser=User::model()->findByAttributes(array('id'=>$leader->leader_id));

$model->teamleader = $leaderuser->fname.''.$leaderuser->lname;

}

        $model->passport = $passport;
        $model->broker = $_POST['Eoiform']['broker'];
        if(!empty($_POST['Eoiform']['code'])){
        $model->done= $_POST['Eoiform']['code'];
        //var_dump($_POST['Eoiform']['code']);
        //exit;
        }
        
        
$unit=$_POST['Eoiform']['unit_id'];
if (!empty($unit)) {
$unit=Units::model()->findByAttributes(array('id'=>$unit));
$unit->booking=4;
$unit->save();
}
        

        
        if(!$model->save()){
        $errores = $model->getErrors();
        var_dump($errores);
        }
		
		if ($model->save()) {
		    
		    
	//	var_dump($model);exit;    
		    
		    
		    
		    
		    
		    
		    
		    
		    	if(!empty($model->lead_id)){
			$lead=Leads::model()->findByAttributes(array('id'=>$model->lead_id));
			$sales=User::model()->findByAttributes(array('id'=>$lead->user_sales));
            $model->sales = $sales->fname.$sales->lname;
			$model->save();
			
			
						$main=Mainsettings::model()->findByPk(1);

			            if(!empty($main->autoclosedeal)){
                    $lead->close=1;
                    $lead->reopen=NULL;
                    $lead->communication=1;
                    $lead->close_date= $today;
                    $substatus=Substatus::model()->findByPk($main->autoclosedeal);
                    $qualifiedtest=Statues::model()->findByPk($substatus->parent_id);
                    if($qualifiedtest->qualified == 1){
                    $lead->qualified=1;
                    if(empty($lead->first_classification)){
                    $lead->first_classification=1;
                    $lead->first_classification_user=$userid; 
                    }
                    }
                    if($lead->nonqualified == 1){
                    $lead->nonqualified=1;
                    if(empty($lead->first_classification)){
                    $lead->first_classification=2;
                    $lead->first_classification_user=$userid; 
                    }
                    }
                    $lead->substatus=$main->autoclosedeal;
                    $substatus=Substatus::model()->findByPk($main->autoclosedeal);
                    $lead->status=$substatus->parent_id;

                    if($substatus->answer == 1){
                    $lead->answer=1;
                    }
                    if($substatus->answer == 2){
                    $lead->answer=2;
                    }
                    if($substatus->expvisit == 1){
                    $lead->expvisit=1;
                    }
                    if($substatus->callback == 1){
                    $lead->callback=1;
                    }
                    $lead->sales_report='Close Deal by EOI';
                    $lead->save(); 
                    
                    
                    
                   // var_dump($lead->id);exit;
                    
                    
                    //clear activities of closed leads
                    $criteria = new CDbCriteria;
                    $criteria->condition = "close IS NULL OR report IS NULL  ";
                    $criteria->addCondition('leads_id=' . $lead->id);
                    $allactivities=Activities::model()->findAll($criteria);
                    

                    
                    if(!empty($allactivities)){
                    foreach($allactivities as $activity){
                    $activity->close=1;
                    $activity->report='Closed In '.$today.'-'.$_POST['report'];
                    $activity->save();
                    }
                    
                    
                    
                    
                    $newmodel= new Activities();
                    $newmodel->user_id = $userid;
                    $newmodel->leads_id = $lead->id;
                    $newmodel->lead_date = $lead->date;
                    
                    $newmodel->date = $today;
                    $newmodel->time = $time;
                    
                    $newmodel->details= $lead->sales_report;
                    $rnd = rand(0,99999);
                    $newmodel->code= $rnd; 
                    $newmodel->report= 'Closed In '.$today.'-'.$lead->sales_report;
                    $newmodel->follow_date= $today;
                    $newmodel->status= $lead->status;
                    $newmodel->substatus=$lead->substatus;
                    $substatus=Substatus::model()->findByPk($lead->substatus);
                      
                    if($substatus->answer == 1){
                    $newmodel->answer=1; 
                    }
                    
                    
                    if($substatus->answer == 2){
                    $newmodel->answer=2; 
                    }
                    
                    
                    
                      
                    if($substatus->expvisit == 1){
                    $newmodel->expvisit=1;
                    }
                    
                    
                    
                    if($substatus->callback == 1){
                    $newmodel->callback=1;
                    }
                    
                    
                    $newmodel->type= 1;
                    $newmodel->close=1;
                    
                    
                    $newmodel->save();
                    $lead=Leads::model()->findByPk($newmodel->leads_id);
                    $lead->follow_date=$newmodel->follow_date;
                    $lead->checkup_activity=$today; 
                    $lead->save();
                    $newmodel->secert=$newmodel->id;
                    $newmodel->name=$lead->title;
                    $newmodel->tel=$lead->tel;
                    $newmodel->coldcall=$lead->coldcall;
                    $newmodel->indirect=$lead->indirect;
                    $newmodel->save();
                    
                    //if(!$newmodel->save()){
                    	//var_dump($newmodel->getErrors());
                    //	}
                    
                    }else{
                        
                                           // var_dump('ddd');exit;

                    //clear activities of closed leads
                    
                    
                    $newmodel= new Activities();
                    $newmodel->user_id = $userid;
                    $newmodel->leads_id = $lead->id;
                    $newmodel->lead_date = $lead->date;
                    $newmodel->date = $today;
                    $newmodel->time = $time;
                    
                    $newmodel->details= $lead->sales_report;
                    $rnd = rand(0,99999);
                    $newmodel->code= $rnd; 
                    
                    $newmodel->report= 'Closed In '.$today.'-'.$lead->sales_report;
                    $newmodel->follow_date= $today;
                    $newmodel->status= $lead->status;
                    $newmodel->substatus=$lead->substatus;
                    $substatus=Substatus::model()->findByPk($lead->substatus);
                      
                    if($substatus->answer == 1){
                    $newmodel->answer=1; 
                    }
                    
                    
                    if($substatus->answer == 2){
                    $newmodel->answer=2; 
                    }
                    
                    
                    
                    
                                    
                    if($substatus->expvisit == 1){
                    $newmodel->expvisit=1;
                    }
                    
                    
                    
                    if($substatus->callback == 1){
                    $newmodel->callback=1;
                    }
                    
                    $newmodel->type= 1;
                    $newmodel->close=1;
                    
                    
                    $newmodel->save();
                    $lead=Leads::model()->findByPk($newmodel->leads_id);
                    $lead->follow_date=$newmodel->follow_date;
                    $lead->checkup_activity=$today; 
                    $lead->save();
                    $newmodel->secert=$newmodel->id;
                    $newmodel->name=$lead->title;
                    $newmodel->tel=$lead->tel;
                    $newmodel->coldcall=$lead->coldcall;
                    $newmodel->indirect=$lead->indirect;
                    $newmodel->save();
                    
                    
                    
                    
                    
                    

                    }


			
			
			}

			
			}
		
		

		Yii::app()->controller->refresh();


		}
		}
		
$model2 = new Deposit();
$model2->setScenario('com_porfile');
if(isset($_POST['Deposit'])){
    
    

  
				$rnd = rand(0,9999);
				$model2->attributes = $_POST['Deposit'];
				$model2->date= $today;
				$model2->time= $time;
				$model2->user_id = $userid;
				$model2->secret = $rnd.$userid;
				$model2->code = $_POST['code'];
				$bankertitle=Banker::model()->findByAttributes(array('id'=>$_POST['Deposit']['banker_id']));
				if(empty($bankertitle)){
				    
				$codebankertitle=Treeaccount::model()->findByAttributes(array('title'=>$_POST['Deposit']['banker_id']));
 
				    
				$banker = new Banker();
				$rnd = rand(0,9999);
				$banker->date= $today;
				$banker->time= $time;
				$banker->user_id = $userid;
				$banker->accountant_id = $userid;
				$banker->details = $_POST['Deposit']['banker_id'];
				$banker->title = $_POST['Deposit']['banker_id'];
				$banker->tree_id = $codebankertitle->id;
				$banker->secret = $rnd.$userid;
				$banker->code = $_POST['code'];
				//$banker->typebank = 4;
				$banker->save(); 
				
				//var_dump($banker);
				//exit;
				    
			     $model2->banker_id= $banker->id;    
				}

if(!empty($_POST['Deposit']['tree_id'])){
$code=Treeaccount::model()->findByAttributes(array('code'=>$_POST['Deposit']['tree_id']));
$model2->tree_id=$code->id;}else{$model2->tree_id=$_POST['tree_id'];}
				if($model2->save()){
				    
				$codebanker=Banker::model()->findByAttributes(array('id'=>$model2->banker_id));
				   
				$visible =1;  
                $criteriaeoi = new CDbCriteria;
                $criteriaeoi->order = 'done DESC';
                $criteriaeoi->limit= 1;
                $criteriaeoi->addSearchCondition('active', $visible );
                $lasteoiform= Eoiform::model()->findAll($criteriaeoi); 
  
if(!empty($lasteoiform)){
	foreach($lasteoiform as $lasteoi){


				   $eoi=Eoiform::model()->findByAttributes(array('id'=>$_POST['eoi_id']));
				
                   $eoi->active = 1;
                   //$eoi->done = $eoi->id;
				   $eoi->save();
				   
				   
				       if($eoi->save()){
					$lead=Leads::model()->findByAttributes(array('id'=>$eoi->lead_id));
					$lead->client_id = 1;
				   $lead->save();
				   }
				   
				   if(!$eoi->save()){
					$errores = $eoi->getErrors();
					var_dump($errores);
				   }
				   
	}
}else{
    
    
      $eoi=Eoiform::model()->findByAttributes(array('id'=>$_POST['eoi_id']));
      
         
				
                   $eoi->active = 1;
                   //$eoi->done = 1;
				   $eoi->save();
				   
				   
				   
    
    
}
				    
				    $dailyrestrictions = new Dailyrestrictions();
				    $dailyrestrictions->date= $today;
				    $dailyrestrictions->time= $time;
				    $dailyrestrictions->user_id = $userid;
				    $dailyrestrictions->tree_id_to = $codebanker->tree_id;
				    $dailyrestrictions->tree_id = $model2->tree_id;
				    $dailyrestrictions->details = $model2->details;
				    $dailyrestrictions->lead_id = $model2->lead_id;
				    $dailyrestrictions->building_tree = $model2->building_tree;
				    $dailyrestrictions->unit_id = $model2->service_id;


				    $dailyrestrictions->amount = $model2->amount;
				    $dailyrestrictions->secret = $rnd.$userid;
				    $dailyrestrictions->code = $rnd.$userid;

				    
				    $dailyrestrictions->file = 1;
				    $dailyrestrictions->save();
				    //$errores = $dailyrestrictions->getErrors();
				    
				    
				    
				    
				    
					Yii::app()->controller->refresh();
				}else{}
			}

		if(isset($_POST['downloadexcel'])){
    

	ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');


 

$fields = array('id','project','title','time'
,'nationality','unit_type','date','from_id','amount_type','address','details' );
$labels= array('id','project','title','time'
,'nationality','unit_type','date','from_id','amount_type','address','details' );
XlsExporter2::downloadXls('SOLID XLS', $allcontract, 'Report-', TRUE  , $labels  , $fields, 'COUNT');


			}
		
		
		
		
		$this->render('eoileader',array(
		'userid'=>$userid ,	
                'model'=>$model,
                'model2'=>$model2,
                'allcontract'=>$allcontract,		
                
		));
		}


		else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm']))
		{
		$model->attributes=$_POST['LoginForm'];
		// validate user input and redirect to the previous page if valid
		if($model->validate() && $model->login())
		$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
		}

		}


	
public function actionJsonleadfrombranch(){
$json = file_get_contents('php://input');
// Converts it into a PHP object
$data = json_decode($json ,true);

$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
$today = date("Y-m-d");                     // 03.10.01
$time = date("H:i:s"); 


$criteriaduplecat= new CDbCriteria(); 
$criteriaduplecat->addSearchCondition('tel', $data['tel'], false , 'OR');
$criteriaduplecat->addSearchCondition('second_tel', $data['second_tel'], false , 'OR');
$criteriaduplecat->addSearchCondition('tel3', $data['tel3'], false , 'OR');
$criteriaduplecat->addSearchCondition('tel4', $data['tel4'], false , 'OR');
$criteriaduplecat->addSearchCondition('email',$data['email'], false , 'OR');
$criteriaduplecat->addSearchCondition('facebook_id', $data['facebook_id'], false , 'OR');
$allduplecat= Leads::model()->findAll($criteriaduplecat);
if(empty($allduplecat)){



    $model = new Leads();
    $model->user_id = $data['user_id'];
    $model->date = $data['date'];
    $model->communicate_date = $data['communicate_date'];
    $model->feedback_date = $data['feedback_date'];
    $model->title = $data['title'];
    $model->tel = $data['tel'];
    $model->second_tel = $data['second_tel'];
    $model->tel3 = $data['tel3'];
    $model->tel4 = $data['tel4'];
    $model->notes = $data['notes'];
    $model->details = $data['details'];

    $model->feedback_date = $data['feedback_date'];
    $model->adsetname = $data['adsetname'];
    $model->adname = $data['adname'];
    $model->facebook_id = $data['facebook_id'];
    $model->branch = $data['branch'];
    $model->status = $data['status'];
    $model->area = $data['area'];
    $model->time = $data['time'];
    $model->hidden = 1;
    $model->transfer_branch = 1;
    $model->strategy_id = $data['strategy_id'];
    
    $platform=Platform::model()->findByAttributes(array('title'=>$data['platformtitle']));
    if(!empty($platform)){
    $model->platform_id = $platform->id;
    }else{
        

    $userid=Yii::app()->user->id;
    $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
    $today = date("Y-m-d");                     // 03.10.01
    $time = date("H:i:s");
    $rnd = rand(0,9999);
	$newmodel=new Platform();
	$newmodel->user_id = $userid;
	$newmodel->date = $today;
	$newmodel->time = $time;
	$newmodel->hidden = 1;
	$newmodel->secert = $rnd;
	$newmodel->title = $data['platformtitle'];
$newmodel->save();

	if($newmodel->save()){
	$model->platform_id = $newmodel->id;
   
	}
        
    }
    $model->platformchild_id = $data['platformchild_id'];
    $model->interest_id = $data['interest_id'];
    $model->international_code = $data['international_code'];
    $model->international_code2 = $data['international_code2'];
    $model->user_marketing = 1;
    $model->career = $data['career'];
    $model->email = $data['email'];
    $model->save();


if($model->save()){
$model->secert = $model->id;
$model->save();
    
}


if(!$model->save()){echo'0';}else{echo'1';}


}

}		



	
public function actionJsonrecord(){
$json = file_get_contents('php://input');
// Converts it into a PHP object
$data = json_decode($json ,true);

$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
$today = date("Y-m-d");                     // 03.10.01
$time = date("H:i:s"); 

$recorder = new Recorder();
$recorder->date = $today;
$recorder->time = $time;
$recorder->tel = $data['tel'];
$recorder->size = $data['filesize'];
$recorder->user_sales = $data['sales'];
$recorder->foldername = $data['foldername'];

$sales = User::model()->findByAttributes(array('details'=>$data['foldername']));
$recorder->user_sales = $sales->id;

$recorder->check = 1;
$recorder->file = $data['filename'];
if(!$recorder->save()){echo'0';}else{echo'1';}


}	
	



public function actionRecordrefresh(){



//$in =1;
$criteria = new CDbCriteria;
$today = date("Y-m-d");                     // 03.10.01
$criteria->addSearchCondition('check', $in, false);
//$start = '2022-07-20';
$criteria->addBetweenCondition("date",$today,$today);
$allrecords = Recorder::model()->findAll($criteria);

			//$allrecords = Recorder::model()->findAllByAttributes(array('check'=>1));
			//var_dump(count($allrecords));
			foreach($allrecords as $record){
			    $criterialeads= new CDbCriteria(); 
                $criterialeads->addSearchCondition('tel', $record->tel, false , 'OR');
                $criterialeads->addSearchCondition('second_tel', $record->tel, false , 'OR');
                $criterialeads->addSearchCondition('tel3', $record->tel, false , 'OR');
                $criterialeads->addSearchCondition('tel4', $record->tel, false , 'OR');
                $lead= Leads::model()->find($criterialeads);
                          
                if(!empty($lead)){
                    $record->user_sales = $lead->user_sales;
                    $record->lead_id = $lead->id;
                    $record->check = 2 ;
                    $record->save() ;
                }else{
                    
                   
                    $record->check = 3 ;
                    $record->save() ;
                    
                }
			}

}	









public function actionRecordreunknow(){



			$allrecords = Recorder::model()->findAllByAttributes(array('check'=>3));
			
			foreach($allrecords as $record){
			    $criterialeads= new CDbCriteria(); 
                $criterialeads->addSearchCondition('tel', $record->tel, false , 'OR');
                $criterialeads->addSearchCondition('second_tel', $record->tel, false , 'OR');
                $criterialeads->addSearchCondition('tel3', $record->tel, false , 'OR');
                $criterialeads->addSearchCondition('tel4', $record->tel, false , 'OR');
                $lead= Leads::model()->find($criterialeads);
                          
                if(!empty($lead)){
                    $record->user_sales = $lead->user_sales;
                    $record->lead_id = $lead->id;
                    $record->check = 2 ;
                    $record->save() ;
                }else{
                    
                    $criteria = new CDbCriteria;
                    $criteria->addSearchCondition('date', $record->date , false , 'AND');
                    $criteria->addSearchCondition('name', $record->tel , false , 'AND');
					$model = Activities::model()->find($criteria);
					if(!empty($model)){
					   // var_dump(count($model));
					   $record->tel=$model->tel;
					   $record->lead_id=$model->leads_id;
					   $record->check=4;
					   $record->save();
					   var_dump(count($model));
					}
                    
                }
			}

}	
	
	
	
	
	
	
	




public function actionMatchedLeads(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

		
			$visible = 1;
			$allduplicate= Duplicate::model()->findAll(array( 'condition' => 'integration=2'  ,'order'=>'id DESC'  ));

		
		
		

		
		
		
		
			$this->render('matchedleads',array(
					'userid'=>$userid ,	
					'model'=>$model ,			
					'allduplicate'=>$allduplicate,

				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}

	






public function actionDistributed(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

		
			$visible = 1;
			

		$criteria = new CDbCriteria();
	$criteria->condition = "communicate_date IS NULL AND distribute_id IS NOT NULL";
$user=User::model()->findByPk($userid);
if($user->salesmanger==1){}else{$criteria->addCondition('distribute_id=' . $userid);}
	
	$criteria->addCondition('hidden=' . $visible);
		
		$allduplicate=Leads::model()->findAll($criteria);
$dataProvider = new CActiveDataProvider('Leads', array(
					'pagination' => array(
						'pageSize' =>50,

					),
					'criteria' => $criteria,
				));
		
		
			$visible=1;
			$allcampaign= Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		
		
			$this->render('distributed',array(
					'userid'=>$userid ,	
					'allcampaign'=>$allcampaign,			
					'dataProvider'=>$dataProvider,

				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}



	
	
	

	
		public function actionUnitv($id){
	$this->layout='//layouts/clients';

			$unit = Units::model()->findByAttributes(array('id'=>$id));

			$building = Building::model()->findByAttributes(array('id'=>$unit->building_id));
			$project = Projects::model()->findByAttributes(array('id'=>$unit->projects_id));

			$allstage = Stage::model()->findAll(array( 'condition' => 'projects_id=' . $project->id ,'order'=>'id DESC'  ));


			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

		
		

		
		
		
			$model = new units();
			$model->setScenario('com_porfile');
			if(isset($_POST['Units'])){
				$rnd = rand(0,9999);
				$model->attributes = $_POST['Units'];
				$model->user_id = $userid;
				$model->projects_id = $project->id;
				$model->building_id = $building->id;
				$model->date = $today;
				$model->time = $time;
				$model->hidden = 1;
				$model->status = 1;
				$model->secert = $rnd.$userid;

				if($model->save()){

					$unit = 1;
					$building->remaning_units =  $building->remaning_units + $unit ;
		
					if($building->save()){
						$project->remaning_units =  $project->remaning_units + $unit ;	
						$project->save();		
			
					}


					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create unit Type';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secert;
					$logsystem->user_id = $userid;
					$logsystem->save();


					Yii::app()->controller->refresh();
				}
			}







			$projects = 1;
			$build = 2;
			$pic =1;
			$file = 2;
			$criteria2 = new CDbCriteria();
			//$criteria2->addSearchCondition('hidden', $visible, false);
			$criteria2->addSearchCondition('depth', $projects, false);
			$criteria2->addSearchCondition('depth_id', $project->id, false);

			$allmedia = Media::model()->findAll($criteria2);



                







			$criteria4 = new CDbCriteria();
			//$criteria4->addSearchCondition('hidden', $visible, false);
			$criteria4->addSearchCondition('depth', $build, false);
			$criteria4->addSearchCondition('depth_id', $building->id, false);

			$allmediabuilding = Media::model()->findAll($criteria4);







			$criteria6 = new CDbCriteria();
			//$criteria6->addSearchCondition('hidden', $visible, false);
			$criteria6->addSearchCondition('depth', 3, false);
			$criteria6->addSearchCondition('depth_id', $unit->id, false);

			$allmediaunit = Media::model()->findAll($criteria6);



		
		
		
			$this->render('unitv',array(
					'userid'=>$userid ,	
					'model'=>$model ,
					'unit'=>$unit ,
					'project'=>$project ,
					'building'=>$building ,

					'allmedia'=>$allmedia ,
					'allmediabuilding'=>$allmediabuilding ,
					'allmediaunit'=>$allmediaunit ,
					'allstage'=>$allstage ,
				));
	
	}

	
	
	
	public function actionUnit($secert){
	
$this->layout='//layouts/systemcgridview';

			$unit = Units::model()->findByAttributes(array('id'=>$secert));

			$building = Building::model()->findByAttributes(array('id'=>$unit->building_id));
			$project = Projects::model()->findByAttributes(array('id'=>$unit->projects_id));

			$allstage = Stage::model()->findAll(array( 'condition' => 'projects_id=' . $project->id ,'order'=>'id DESC'  ));


			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

		
		

		
		
		
			$model = new units();
			$model->setScenario('com_porfile');
			if(isset($_POST['Units'])){
				$rnd = rand(0,9999);
				$model->attributes = $_POST['Units'];
				$model->user_id = $userid;
				$model->projects_id = $project->id;
				$model->building_id = $building->id;
				$model->date = $today;
				$model->time = $time;
				$model->hidden = 1;
				$model->status = 1;
				$model->secert = $rnd.$userid;

				if($model->save()){

					$unit = 1;
					$building->remaning_units =  $building->remaning_units + $unit ;
		
					if($building->save()){
						$project->remaning_units =  $project->remaning_units + $unit ;	
						$project->save();		
			
					}


					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create unit Type';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secert;
					$logsystem->user_id = $userid;
					$logsystem->save();


					Yii::app()->controller->refresh();
				}
			}







			$projects = 1;
			$build = 2;
			$pic =1;
			$file = 2;
			$criteria2 = new CDbCriteria();
			//$criteria2->addSearchCondition('hidden', $visible, false);
			$criteria2->addSearchCondition('depth', $projects, false);
			$criteria2->addSearchCondition('depth_id', $project->id, false);

			$allmedia = Media::model()->findAll($criteria2);



                







			$criteria4 = new CDbCriteria();
			//$criteria4->addSearchCondition('hidden', $visible, false);
			$criteria4->addSearchCondition('depth', $build, false);
			$criteria4->addSearchCondition('depth_id', $building->id, false);

			$allmediabuilding = Media::model()->findAll($criteria4);







			$criteria6 = new CDbCriteria();
			//$criteria6->addSearchCondition('hidden', $visible, false);
			$criteria6->addSearchCondition('depth', 3, false);
			$criteria6->addSearchCondition('depth_id', $unit->id, false);

			$allmediaunit = Media::model()->findAll($criteria6);



		
		
		
			$this->render('unit',array(
					'userid'=>$userid ,	
					'model'=>$model ,
					'unit'=>$unit ,
					'project'=>$project ,
					'building'=>$building ,

					'allmedia'=>$allmedia ,
					'allmediabuilding'=>$allmediabuilding ,
					'allmediaunit'=>$allmediaunit ,
					'allstage'=>$allstage ,
				));
	
	}






	












public function actionRequestreservationleader(){
		if(Yii::app()->user->isMember()){



$this->layout='//layouts/systemcgridview';


			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

		
			$model = new RequestReservation();
			$model->setScenario('com_porfile');
			if(isset($_POST['RequestReservation'])){
				$rnd = rand(0,9999);
				$model->attributes = $_POST['requestreservationxleader'];
				$model->user_id = $userid;
				$model->date = $today;
				$model->time = $time;
				$model->secret = $rnd.$userid;

				if($model->save()){

					


					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create Request Reservation';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secret;
					$logsystem->user_id = $userid;
					$logsystem->save();


					Yii::app()->controller->refresh();
				}
			}
			//$allplace=RequestReservation::model()->findAll(array('condition'=>' confirm IS NULL '));


$confirm=1;
$criteria = new CDbCriteria();
$criteria->addCondition('cancel IS NULL');
$criteria->addCondition('confirm IS NULL');

 $allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid ,'order'=>'id DESC'  ));
            $arr=array();
            foreach($allemployee as $leader){
            $arr[]=$leader->sales_id;
            } 

			$criteria->addInCondition('sales', $arr  , "AND");
			

$allplace = RequestReservation::model()->findAll($criteria);








$allrequestreservation=new Requestreservation('requestreservationxleader');
$allrequestreservation->unsetAttributes();  // clear any default values
if(isset($_GET['requestreservationxleader'])){
$allrequestreservation->attributes=$_GET['requestreservationxleader'];
}



		
		
		
			$this->render('requestreservationleader',array(
					'userid'=>$userid ,	
					'allplace'=>$allplace,
					'allrequestreservation'=>$allrequestreservation,
				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->render('index',array('model'=>$model));
		}

	}





public function actionRequestreservation(){
		if(Yii::app()->user->isMember()){



$this->layout='//layouts/systemcgridview';


			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

		
			$model = new RequestReservation();
			$model->setScenario('com_porfile');
			if(isset($_POST['RequestReservation'])){
				$rnd = rand(0,9999);
				$model->attributes = $_POST['RequestReservation'];
				$model->user_id = $userid;
				$model->date = $today;
				$model->time = $time;
				$model->secret = $rnd.$userid;

				if($model->save()){

					


					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create Request Reservation';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secret;
					$logsystem->user_id = $userid;
					$logsystem->save();


					Yii::app()->controller->refresh();
				}
			}
			//$allplace=RequestReservation::model()->findAll(array('condition'=>' confirm IS NULL '));


$confirm=1;
$criteria = new CDbCriteria();
$criteria->addCondition('cancel IS NULL');
$criteria->addCondition('confirm IS NULL');

$allplace = RequestReservation::model()->findAll($criteria);








$allrequestreservation=new Requestreservation('requestreservationx');
$allrequestreservation->unsetAttributes();  // clear any default values
if(isset($_GET['requestReservationx'])){
$allrequestreservation->attributes=$_GET['requestReservationx'];
}



		
		
		
			$this->render('requestreservation',array(
					'userid'=>$userid ,	
					'allplace'=>$allplace,
					'allrequestreservation'=>$allrequestreservation,
				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->render('index',array('model'=>$model));
		}

	}



public function actionCancelreservation(){
		if(Yii::app()->user->isMember()){





			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

		
			$model = new RequestReservation();
			$model->setScenario('com_porfile');
			if(isset($_POST['RequestReservation'])){
				$rnd = rand(0,9999);
				$model->attributes = $_POST['RequestReservation'];
				$model->user_id = $userid;
				$model->date = $today;
				$model->time = $time;
				$model->secret = $rnd.$userid;

				if($model->save()){

					


					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create Request Reservation';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secret;
					$logsystem->user_id = $userid;
					$logsystem->save();


					Yii::app()->controller->refresh();
				}
			}
			$allplace=RequestReservation::model()->findAll(array('condition'=>' cancel IS NOT NULL '));





		
		
		
			$this->render('cancelreservation',array(
					'userid'=>$userid ,	
					'allplace'=>$allplace,	
				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->render('index',array('model'=>$model));
		}

	}
	
	
	
	



public function actionConreservationleader(){
		if(Yii::app()->user->isMember()){



$this->layout='//layouts/systemcgridview';

			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			

		
			$model = new RequestReservation();
			$model->setScenario('com_porfile');
			if(isset($_POST['RequestReservation'])){
				$rnd = rand(0,9999);
				$model->attributes = $_POST['RequestReservation'];
				$model->user_id = $userid;
				$model->date = $today;
				$model->time = $time;
				$model->secret = $rnd.$userid;

				if($model->save()){

					


					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create Request Reservation';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secret;
					$logsystem->user_id = $userid;
					$logsystem->save();


					Yii::app()->controller->refresh();
				}
			}
			//$allplace=RequestReservation::model()->findAll(array('condition'=>' cancel IS  NULL && con IS NOT NULL  '));
            //$criteria = new CDbCriteria;
           // $criteria->order = 'id DESC';
                       //$criteria->addCondition('cancel IS  NULL AND con IS NOT NULL');

          
            //$criteria->order = 'id DESC';
            
            //$allplace=RequestReservation::model()->findAll($criteria);
           

	
	$allcon=new Reservation('conleader');

             	$allcon->unsetAttributes();  // clear any default values
                if(isset($_GET['Reservation'])){
                   // var_dump($_GET['Status']);exit;
                $allcon->attributes=$_GET['Reservation'];
             
                }

	


		
		
		
			$this->render('confirmcongvleader',array(
					'userid'=>$userid ,	
					'allcon'=>$allcon,	
				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->render('index',array('model'=>$model));
		}

	}


public function actionconreservation(){
		if(Yii::app()->user->isMember()){



$this->layout='//layouts/systemcgridview';

			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			

		
			$model = new RequestReservation();
			$model->setScenario('com_porfile');
			if(isset($_POST['RequestReservation'])){
				$rnd = rand(0,9999);
				$model->attributes = $_POST['RequestReservation'];
				$model->user_id = $userid;
				$model->date = $today;
				$model->time = $time;
				$model->secret = $rnd.$userid;

				if($model->save()){

					


					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create Request Reservation';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secret;
					$logsystem->user_id = $userid;
					$logsystem->save();


					Yii::app()->controller->refresh();
				}
			}
			//$allplace=RequestReservation::model()->findAll(array('condition'=>' cancel IS  NULL && con IS NOT NULL  '));
            //$criteria = new CDbCriteria;
           // $criteria->order = 'id DESC';
                       //$criteria->addCondition('cancel IS  NULL AND con IS NOT NULL');

          
            //$criteria->order = 'id DESC';
            
            //$allplace=RequestReservation::model()->findAll($criteria);
           

	
	$allcon=new Reservation('con');

             	$allcon->unsetAttributes();  // clear any default values
                if(isset($_GET['Reservation'])){
                   // var_dump($_GET['Status']);exit;
                $allcon->attributes=$_GET['Reservation'];
             
                }

	


		
		
		
			$this->render('confirmcongv',array(
					'userid'=>$userid ,	
					'allcon'=>$allcon,	
				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->render('index',array('model'=>$model));
		}

	}



	public function  actionDuplicatedeleteid($id){

		if(Yii::app()->user->isMember()){
			$model=Duplicate::model()->findByPk($id);
			$model->delete();
			$this->redirect(array('sales/duplicate')	);
		
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
	
	
	
	
	
	
	public function  actionDocdeleteid($id){

		if(Yii::app()->user->isMember()){
			$model=DocumentStorage::model()->findByPk($id);
			$lead = $model->lead_id;
			$model->delete();
			$this->redirect(array('sales/adddocument/'.$lead)	);
		
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}






	
		public function  actionVisitdeleteid($id){

		if(Yii::app()->user->isMember()){
			$model=Visit::model()->findByPk($id);
			$lead = $model->lead_id;
			$model->delete();
			$this->redirect(array('leads/profile/'.$lead)	);
		
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}












	public function  actionDeletelead($id){

		if(Yii::app()->user->isMember()){
			$model=Leads::model()->findByPk($id);
			$var=$model->date;
			
		
		
		
		if(!empty($model->id)){ 	
		$criteria = new CDbCriteria(); 
        $criteria->addSearchCondition('leads_id', $model->id, false);
        $allactivities = Activities::model()->FindAll($criteria);
        if(!empty($allactivities)){ 
        foreach($allactivities as $activities){
        $activities->delete();
        } 
        } 
		}
			
				if($model){
					//$model->hidden = 2;
					$model->delete();

					$this->redirect(array('marketing/leads')	);
				
			
			}
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}











	public function  actionAddleadfrpmduplicate($id){

		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$lead=Leads::model()->findByPk($id);
		
			if($_REQUEST['addduplicate']){
		
 	
$model= new Leads();

$rnd = rand(0,99999);

$model->user_id = $userid;
$model->date = $today;
$model->title = $lead->title;
$model->tel = $lead->tel;

    
    if($_REQUEST['leadtype'] == 1){
    
    
    
    $model->coldcall = 1;
    
    }else{
    
    $model->coldcall = NULL;
    
    
    }

$model->international_code = $lead->international_code;
$model->user_sales = $_REQUEST['sales'];
if (!empty($_REQUEST['marketing'])) {
$model->user_marketing =$_REQUEST['marketing'];
$model->user_id =$_REQUEST['marketing'];

}
$model->feedback_date = $lead->feedback_date;
$model->communicate_date = $lead->feedback_date;
$model->campaign_id = $_REQUEST['campaign_id'];
$model->platform_id = $_REQUEST['platform_id'];
$model->project_id = $_REQUEST['project_id'];
$model->interest_id = $_REQUEST['interest_id'];
$model->unit_type = $_REQUEST['unittype'];

$model->strategy_id = $lead->strategy_id;
//$model->allowduplicate = $lead->id;
$model->time = $time;
$model->dtime = $time;
$model->hidden = 1;
$model->notes = $_REQUEST['choise'] ;
$model->block_duplicate=1;



if(!$model->save()){
var_dump($model->getErrors());exit;
}	

if($model->save()){ 
$usercheck=User::model()->findByPk($userid);    
    
    if($usercheck->addleadup == 1){
       //var_dump($usercheck->addleadup);exit; 
        
            $modelchat = new Chatandsupport();
            $rnd = rand(0,99999);
            $modelchat->date=$today;
            $modelchat->time=$time;
            $modelchat->lead_id=$model->id;
            $modelchat->user_sales=$userid;
            $modelchat->details='other sales';
            $modelchat->close=1;
            
            $modelchat->user_id=$userid;
            $modelchat->save();
            
            
            if(!$modelchat->save()){
            var_dump($lead->getErrors());
            }
            
    }
    
    
$leadnew = Leads::model()->findByAttributes(array('id'=>$model->id));
$leadnew->secert = $leadnew->id;
$leadnew->fresh_sales = $_REQUEST['sales'];
$leadnew->save();

if(!$leadnew->save()){
var_dump($leadnew->getErrors());exit;
}	
$lead->allowduplicate=$leadnew->id;
$lead->block_duplicate=1;
$lead->save();
$this->redirect(array('leads/profile/'.$leadnew->id)	);
			
			}
 	
				


		
		
		
		
			}
		

		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}



	public function  actionDuplicatelead($id){

		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$model=Leads::model()->findByPk($id);
			if($_REQUEST['choise']==1){
				$model->duplicate=1;
				$model->last_duplicate=$today;
			}else if($_REQUEST['choise']==2){
				$model->duplicate=1;
				$model->last_duplicate=$today;
				$model->close=1;
				$model->feedback_report=' old Data ';
			}
			if($model->save()){
				$newmodel= new Duplicate();
				$newmodel->title=$model->title;
				$newmodel->leads_id=$model->id;
				$newmodel->user_id=$userid;
				$newmodel->date=$today;
				$newmodel->time=$time;
				$newmodel->tel=$model->tel;
				if($newmodel->save()){

					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User duplicate lead';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secert;
					$logsystem->user_id = $userid;
					$logsystem->save();

					$this->redirect(array('leads/profile/'.$model->secert)	);
				}
			}


		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}





public function  actionClientlead($id){

		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$model=Leads::model()->findByPk($id);
			$model->client_id=1;
		    $model->save();
			if($model->save()){
				
			$this->redirect(array('leads/profile/'.$model->secert)	);

			
			}


		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}





public function  actionDeleteallsales($id){

		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$model=Teamleader::model()->findByPk($id);
			
			
	
//var_dump($model->id);exit;


$criteria = new CDbCriteria;
$criteria->addCondition('sales_id=' . $model->sales_id);

$allsales = Teamleader::model()->findAll($criteria);

if(!empty($allsales)){
foreach($allsales as $sales){ 
    
//var_dump($allsales);exit;
$sales->delete();


    
}
$this->redirect(array('teamleader')	);

}else{
    
//var_dump('2');exit;
$this->redirect(array('teamleader')	);
    
    
}

			
			
			
			//if($model->delete()){
			//	$logsystem = new Logsystem();
			//	$logsystem->date = $today;
			//	$logsystem->time = $time;
			//	$logsystem->action = 'User deleted sales';
			//	$logsystem->action_id = $model->id;
			//	$logsystem->ip = $model->id;
			//	$logsystem->secert = $model->id;
			//	$logsystem->user_id = $userid;
			//	$logsystem->save();
			//	$this->redirect(array('teamleader')	);
		//	}



		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}


public function  actionDeletesales($id){

		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$model=Teamleader::model()->findByPk($id);
			
			
	
//var_dump($model->id);exit;

    
//var_dump($allsales);exit;
$model->delete();


    

$this->redirect(array('teamleader')	);

			
			
			
			//if($model->delete()){
			//	$logsystem = new Logsystem();
			//	$logsystem->date = $today;
			//	$logsystem->time = $time;
			//	$logsystem->action = 'User deleted sales';
			//	$logsystem->action_id = $model->id;
			//	$logsystem->ip = $model->id;
			//	$logsystem->secert = $model->id;
			//	$logsystem->user_id = $userid;
			//	$logsystem->save();
			//	$this->redirect(array('teamleader')	);
		//	}



		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
















public function  actionTransferleadtobranch(){
if(Yii::app()->user->isMember()){
if(isset($_POST['branchcheck'])){
    $allleadss = Leads::model()->findAll(array( 'condition' => 'id=' . $_POST['leadidbranch'] ,'order'=>'id ASC'   ));
	foreach($allleadss  as $lead){	
	
	
$allsalesreport = Activities::model()->findAll(array( 'condition' => 'leads_id=' . $lead->id ,'order'=>'id ASC'   ));
foreach($allsalesreport as $salesreport){

$lead->details = $lead->details.'  /  '.$salesreport->date.' '.$salesreport->details;
$lead->save();

}

$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
$today = date("Y-m-d");                     // 03.10.01
$time = date("H:i:s"); 	
	
	
//API Url
$url = $_POST['branchcheck'].'/en/sales/jsonleadfrombranch';
 
//Initiate cURL.
// init curl object        
$ch = curl_init();

// define options
$optArray = array(
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true
);

// apply those options
curl_setopt_array($ch, $optArray);
$record = 123;  
$platform=Platform::model()->findByAttributes(array('id'=>$lead->platform_id));

//The JSON data.
$jsonData = array(
    
'user_id' => $lead->user_id,
'date' => $lead->date,
'communicate_date' => $today,
'feedback_date' => $today,
'transfer' => 1,
'transferdate' => $today,
'branch' => 1,

'title' => $lead->title,
'tel' => $lead->tel,
'second_tel' => $lead->second_tel,
'tel3' => $lead->tel3,
'tel4' => $lead->tel4,
'notes' => $lead->notes,
'details' => $lead->details,



'adsetname' => $lead->adsetname,
'adname' => $lead->adname,
'facebook_id' => $lead->facebook_id,
'status' => $lead->status,
'area' => $lead->area,
'time' => $lead->time,
'hidden' => $lead->hidden,
'strategy_id' => $lead->strategy_id,

'platformtitle' => $platform->title,
'campaign_id' => $lead->campaign_id,
'platformchild_id' => $lead->platformchild_id,
'international_code' => $lead->international_code,
'international_code2' => $lead->international_code2,
'user_marketing' => $lead->user_marketing,
'career' => $lead->career,
'email' => $lead->email,

  
    
);
 
//Encode the array into JSON.
$jsonDataEncoded = json_encode($jsonData);
 
//Tell cURL that we want to send a POST request.
curl_setopt($ch, CURLOPT_POST, 1);
 
//Attach our encoded JSON string to the POST fields.
curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonDataEncoded);
 
//Set the content type to application/json
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json')); 
 
//Execute the request
$result = curl_exec($ch);       
    
		

		
	}
}
$this->redirect(array('leads/profile/'.$_POST['leadidbranch'])	);
}
}



	
	
	
	
	
	
	
	
		public function  actionCloseleadfrompagination(){

		if(Yii::app()->user->isMember()){

 
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s"); 
            $user=User::model()->findByPk($userid);
			if(isset($_POST['secert'])){
				$secert=$_POST['secert'];
				$code=$_POST['code'];
				$model= Leads::model()->findByAttributes(array('secert'=>$secert));
				$model->close=1;
				$model->reopen=NULL;
				$model->communication=1;
                if(empty($model->first_communication)){
                $model->first_communication=$userid;
                }
				
				$model->receipt=1;
				$model->close_date= $today;
				$qualifiedtest=Statues::model()->findByPk($_POST['status']);
                if($qualifiedtest->qualified == 1){
                $model->qualified=1;
                if(empty($model->first_classification)){
                $model->first_classification=1;
                $model->first_classification_user=$userid; 
                }
                }
                
                
                if($qualifiedtest->nonqualified == 1){
                    
                    			

                $model->nonqualified=1;
                if(empty($model->first_classification)){
                $model->first_classification=2;
                $model->first_classification_user=$userid; 
                    
                }
                }

				$model->status=$_POST['status'];
				$model->substatus=$_POST['substatus'];
				$substatus=Substatus::model()->findByPk($_POST['substatus']);
                      
                 if($substatus->answer == 1){
                $model->answer=1;
                }
                
                
                if($substatus->answer == 2){
                $model->answer=2;
                }
                
                
                     if($substatus->expvisit == 1){
                $model->expvisit=1;
                }
                
                
                
                  if($substatus->callback == 1){
                $model->callback=1;
                }
                
                
                
                
			
				
				
				$model->sales_report=$_POST['report'];
				$model->save();
				
				 

//clear activities of closed leads
$criteria = new CDbCriteria;
$criteria->condition = "close IS NULL OR report IS NULL  ";
$criteria->addCondition('leads_id=' . $model->id);
$allactivities=Activities::model()->findAll($criteria);
if(!empty($allactivities)){
foreach($allactivities as $activity){
$activity->close=1;
$activity->report='Closed In '.$today.'-'.$_POST['report'];
$activity->save();
}


$newmodel= new Activities();
$newmodel->user_id = $userid;
$newmodel->leads_id = $model->id;
$newmodel->lead_date = $model->date;
$newmodel->date = $today;
$newmodel->time = $time;
$newmodel->details= $_POST['report'];
$newmodel->code= $_POST['code']; 
$newmodel->report= 'Closed In '.$today.'-'.$_POST['report'];
$newmodel->follow_date= $today;
$newmodel->status= $_POST['status'];
$newmodel->substatus=$_POST['substatus'];
$substatus=Substatus::model()->findByPk($_POST['substatus']);
                      
if($substatus->answer == 1){
$newmodel->answer=1; 
}


if($substatus->answer == 2){
$newmodel->answer=2; 
}


   if($substatus->expvisit == 1){
                $newmodel->expvisit=1;
                }
                
                
    
                  if($substatus->callback == 1){
                $newmodel->callback=1;
                }
                            
			
$newmodel->type= 1;
$newmodel->close=1;
$newmodel->save();
$lead=Leads::model()->findByPk($newmodel->leads_id);
$lead->follow_date=$newmodel->follow_date;
$lead->checkup_activity=$today; 
$lead->save();
$newmodel->secert=$newmodel->id;
$newmodel->name=$lead->title;
$newmodel->tel=$lead->tel;
$newmodel->coldcall=$lead->coldcall;
$newmodel->indirect=$lead->indirect;
$newmodel->save();
 

}

//clear activities of closed leads


$newmodel= new Activities();
$newmodel->user_id = $userid;
$newmodel->leads_id = $model->id;
$newmodel->lead_date = $model->date;
$newmodel->date = $today;
$newmodel->time = $time;

$newmodel->details= $_POST['report'];
$newmodel->code= $_POST['code']; 

$newmodel->report= 'Closed In '.$today.'-'.$_POST['report'];
$newmodel->follow_date= $today;
$newmodel->status= $_POST['status'];
$newmodel->substatus=$_POST['substatus'];
$substatus=Substatus::model()->findByPk($_POST['substatus']);
                      
                 if($substatus->answer == 1){
                $newmodel->answer=1; 
                }
                
                
                if($substatus->answer == 2){
                $newmodel->answer=2; 
                }
                
                
                

if($substatus->expvisit == 1){
$newmodel->expvisit=1;
}



                  if($substatus->callback == 1){
                $newmodel->callback=1;
                }
                        

$newmodel->type= 1;
$newmodel->close=1;


$newmodel->save();
$lead=Leads::model()->findByPk($newmodel->leads_id);
$lead->follow_date=$newmodel->follow_date;
$lead->checkup_activity=$today; 
$lead->save();
$newmodel->secert=$newmodel->id;
$newmodel->name=$lead->title;
$newmodel->tel=$lead->tel;
$newmodel->coldcall=$lead->coldcall;
$newmodel->indirect=$lead->indirect;
$newmodel->save(); 
					


				
			    //add best sales
                $userid=Yii::app()->user->id;
            	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
            	$today = date("Y-m-d");
                $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
                if(!empty($best)){
                    $best->actnum+=1;
                    $best->save();
                }else{
                    $best =new Bestsales();
                    $best->user_sales=$userid;
                    $best->date=$today;
                    $best->actnum=1;
                    $best->save();
                }
                //add bestsales
                
                
					header('Location:'.$_POST['url']);

			
			}
			
								header('Location:'.$_POST['url']);

			
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}

	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
		public function  actionDupaction(){

		if(Yii::app()->user->isMember()){

 
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s"); 
                        $user=User::model()->findByPk($userid);
			if(isset($_POST['closelead'])){
				$secert=$_POST['secert'];
				$code=$_POST['code'];
				$model= Duplicate::model()->findByAttributes(array('id'=>$secert));
				//var_dump($model);exit;
				$model->confirm_details=$_POST['report'];
				$model->confirm=1;
				$model->save();
				
				$this->redirect(array('login/duplicatetoday')	);

				
               
			}	
   
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}

	
	
	
	
	
	public function  actionCloselead(){

		if(Yii::app()->user->isMember()){

 
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s"); 
                        $user=User::model()->findByPk($userid);
                        
			if(isset($_POST['closelead'])){
				$secert=$_POST['secert'];
				$code=$_POST['code'];
				$model= Leads::model()->findByAttributes(array('secert'=>$secert));
				$model->close=1;
				$model->reopen=NULL;

				$model->communication=1;
				 if(empty($model->first_communication)){
                $model->first_communication=$userid;
                }
				

				$model->close_date= $today;
				
				

				
				
				$qualifiedtest=Statues::model()->findByPk($_POST['status']);
                
                if($qualifiedtest->qualified == 1){
                $model->qualified=1;
                
               if(empty($model->first_classification)){
                $model->first_classification=1;
                $model->first_classification_user=$userid; 
               }
                
                }
                
                
                
                
                
                
                
                
                
                
                if($qualifiedtest->nonqualified == 1){
                $model->nonqualified=1;
                 if(empty($model->first_classification)){
                $model->first_classification=2;
                $model->first_classification_user=$userid; 
                 }
                }
                
                
                
                
                
                
                

				$model->status=$_POST['status'];
			 $model->othersubstatus=NULL;

				
				$arr=$_POST['substatus'];
				
                if(!empty($arr)){
                foreach ($arr as $ar) {
                // Process each $number here
$model->othersubstatus = $model->othersubstatus . ',' . $ar;


                }
                }

				$model->substatus=$_POST['substatus'];
				$model->substatus = array_shift($model->substatus);

			//	var_dump($arr);exit;
				
				$substatus=Substatus::model()->findByPk($_POST['substatus']);
                      
                 if($substatus->answer == 1){
                $model->answer=1;
                }
                
                
                if($substatus->answer == 2){
                $model->answer=2;
                }
                
                
                
   if($substatus->expvisit == 1){
                $model->expvisit=1;
                }
                
                
                
                  if($substatus->callback == 1){
                $model->callback=1;
                }
                
                
                        
                if($user->salesmanger == 1){      
                $model->manger_id=$user->id;
                }
                
                
                 if($user->teamleader == 1){      
                $model->manger_id=$user->id;
                }

                        
			
				
				
				$model->sales_report=$_POST['report'];
				$model->save();
				
				
				
				
				
			



//clear activities of closed leads
$criteria = new CDbCriteria;
$criteria->condition = "close IS NULL OR report IS NULL  ";
$criteria->addCondition('leads_id=' . $model->id);
$allactivities=Activities::model()->findAll($criteria);
if(!empty($allactivities)){
foreach($allactivities as $activity){
$activity->close=1;
$activity->report='Closed In '.$today.'-'.$_POST['report'];
$activity->save();
}


$newmodel= new Activities();
$newmodel->user_id = $userid;
$newmodel->leads_id = $model->id;
$newmodel->lead_date = $model->date;

$newmodel->date = $today;
$newmodel->time = $time;

$newmodel->details= $_POST['report'];
$newmodel->code= $_POST['code']; 
$newmodel->report= 'Closed In '.$today.'-'.$_POST['report'];
$newmodel->follow_date= $today;
$newmodel->status= $_POST['status'];
$newmodel->substatus=$model->substatus;
 $substatus=Substatus::model()->findByPk($_POST['substatus']);
                      
                 if($substatus->answer == 1){
                $newmodel->answer=1; 
                }
                
                
                if($substatus->answer == 2){
                $newmodel->answer=2; 
                }
                
                
                
                      
   if($substatus->expvisit == 1){
                $newmodel->expvisit=1;
                }
                
                
                 
                  if($substatus->callback == 1){
                $newmodel->callback=1;
                }
			
			
$newmodel->type= 1;
$newmodel->close=1;
$newmodel->manger_id=$userid;


$newmodel->save();
$lead=Leads::model()->findByPk($newmodel->leads_id);
$lead->follow_date=$newmodel->follow_date;
$lead->checkup_activity=$today; 
$lead->save();
$newmodel->secert=$newmodel->id;
$newmodel->name=$lead->title;
$newmodel->tel=$lead->tel;
$newmodel->coldcall=$lead->coldcall;
$newmodel->indirect=$lead->indirect;
$newmodel->save();

	//if(!$newmodel->save()){
						//var_dump($newmodel->getErrors());
				//	}

}elseif(!empty($_POST['code'])){
//clear activities of closed leads


$newmodel= new Activities();
$newmodel->user_id = $userid;
$newmodel->manger_id=$userid;

$newmodel->leads_id = $model->id;
$newmodel->lead_date = $model->date;
$newmodel->date = $today;
$newmodel->time = $time;

$newmodel->details= $_POST['report'];
$newmodel->code= $_POST['code']; 

$newmodel->report= 'Closed In '.$today.'-'.$_POST['report'];
$newmodel->follow_date= $today;
$newmodel->status= $_POST['status'];
$newmodel->substatus=$model->substatus;
$substatus=Substatus::model()->findByPk($_POST['substatus']);
                      
                 if($substatus->answer == 1){
                $newmodel->answer=1; 
                }
                
                
                if($substatus->answer == 2){
                $newmodel->answer=2; 
                }
                
                
                
                
                                    
   if($substatus->expvisit == 1){
                $newmodel->expvisit=1;
                }
                
                
                
                   if($substatus->callback == 1){
                $newmodel->callback=1;
                }

$newmodel->type= 1;
$newmodel->close=1;


$newmodel->save();
$lead=Leads::model()->findByPk($newmodel->leads_id);
$lead->follow_date=$newmodel->follow_date;
$lead->checkup_activity=$today; 
$lead->save();
$newmodel->secert=$newmodel->id;
$newmodel->name=$lead->title;
$newmodel->tel=$lead->tel;
$newmodel->coldcall=$lead->coldcall;
$newmodel->indirect=$lead->indirect;
$newmodel->save();
//if(!$newmodel->save()){
					//	var_dump($newmodel->getErrors());
				//	}
					
}

				
			    //add best sales
                $userid=Yii::app()->user->id;
            	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
            	$today = date("Y-m-d");
                $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
                if(!empty($best)){
                    $best->actnum+=1;
                    $best->save();
                }else{
                    $best =new Bestsales();
                    $best->user_sales=$userid;
                    $best->date=$today;
                    $best->actnum=1;
                    $best->save();
                }
                //add bestsales
                
                
					$this->redirect(array('leads/profile/'.$model->secert)	);

			
			}
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}










	public function  actionIntegration(){

		if(Yii::app()->user->isMember()){



 
			if(isset($_POST['integrationlead'])){
				$secert=$_POST['secert'];
				$model= Leads::model()->findByAttributes(array('secert'=>$secert));
				$secret=$_POST['report'];
				$model2= Leads::model()->findByAttributes(array('secert'=>$secret));
				$modelid=(int)$model->id;
$olddatails = 
    'Title: ' . $model2->title . '-' .
    'Phone: ' . $model2->tel . '-' .
    'Career: ' . $model2->career . '-' .
    'Sales First Name: ' . $model2->sales->fname . '-' .
    'Sales Last Name: ' . $model2->sales->lname . '-' .
    'Campaign Title: ' . $model2->campaign->title . '-' .
    'Platform Title: ' . $model2->platform->title . '-' .
    'Platform Child Title: ' . $model2->platformchild->title . '-' .
    'Place Title: ' . $model2->place->title . '-' .
    'Project Title: ' . $model2->project->title . '-' .
    'Marketing First Name: ' . $model2->usermarketing->fname . '-' .
    'Marketing Last Name: ' . $model2->usermarketing->lname . '-' .
    'New Sales First Name: ' . $model2->freshsales->fname . '-' .
    'New Sales Last Name: ' . $model2->freshsales->lname;
    'Duplicate Date: ' . $model2->duplicate_date;
    'Details: ' . $model2->details;


				//var_dump($olddatails);exit;
				//var_dump($modelid);
				
				
				
				if(!empty($model)){
					$allactivities=Activities::model()->findAll(array( 'condition'=>'leads_id='.$model->id));
					if(!empty($allactivities)){
						foreach($allactivities as $activity){
						    if(empty($activity->report)){
							$activity->leads_id=$modelid;
							$activity->close=1;
							$activity->report="Integration lead ";
							$activity->save();
						    }else{
						        
						        
						    $activity->leads_id=$modelid;
							$activity->save();
						        
						        
						        
						    }
						}
					} 
				}
				
				
				if(!empty($model2)){
					$allactivities=Activities::model()->findAll(array( 'condition'=>'leads_id='.$model2->id));
 
					if(!empty($allactivities)){
						foreach($allactivities as $activity){
						    if(empty($activity->report)){
							$activity->leads_id=$modelid;
							$activity->close=1;
							$activity->report="Integration lead ";
							$activity->save();
						    }else{
						        
						        
						    $activity->leads_id=$modelid;
							$activity->save();
						        
						        
						        
						    }
						}
					} 
					
					
					$oldlead= Leads::model()->findByAttributes(array('id'=>$_POST['report']));
					$newlead= Leads::model()->findByAttributes(array('id'=>$_POST['secert']));

					$newlead->international_code2 = $oldlead->international_code;	
					$newlead->second_tel = $model2->tel;
					$newlead->integratedplatform = $model2->platform_id;
					$newlead->integratedplatformchild = $model2->platformchild_id;
					$newlead->integratedmarketing = $model2->user_marketing;
					$newlead->details = $newlead->details.$olddatails;

					$newlead->communication = NULL;
					$newlead->close = NULL;
					$model2->delete(); 
					$newlead->save();
					
					
					
				//	$oldlead->tel = $newlead->id;	
					//$oldlead->international_code = 'Merged -- ';
					//var_dump($leadsx);
					//$oldlead->save();
					
					
					$this->redirect(array('leads/profile/'.$secert)	);
				}else{
					Yii::app()->user->setFlash('bad', "Code Is Wrong Please Try Again ! ");
					$this->redirect(array('leads/profile/'.$secert)	);
				}
			}

		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}









	public function  actionHidenote(){

		if(Yii::app()->user->isMember()){

 
			if(isset($_POST['hide'])){
				$secert=$_POST['secert'];
				$model= Notes::model()->findByPk($secert);
				$model->hide=1;
				$model->save();
				$this->redirect(array('home/index')	);

			}
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}










	public function  actionHidelead($secert){

		if(Yii::app()->user->isMember()){

			$model= Leads::model()->findByAttributes(array('secert'=>$secert));
			$model->hidden=2;
			$model->save();
			$this->redirect(array('leads/profile/'.$secert)	);
		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}







	public function  actionVisitlead(){

		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			
			
			
			
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");    

			$main=Mainsettings::model()->findByPk(1);
 
			if(isset($_POST['visitlead'])){
			  
			  
				$secert=$_POST['id'];
				$uniqid=$_POST['code'];
				$model= Leads::model()->findByAttributes(array('secert'=>$secert));
				
			
				$model->visit=1;
				$model->visitactive=1;
				$model->pending_visit=$_POST['pending_visit'];

				$model->save();
				$visit=new Visit();
				
				if($model->coldcall == 1){$visit->coldcall=1;}
			    if($model->coldcall == 3){$visit->coldcall=3;}
				
				$visit->date=$_POST['date'];
				$visit->lead_id=$model->id;
				$visit->lead_date=$model->date;
				$visit->marketing_id=$model->user_id;

				$visit->code= $uniqid;
				$visit->details=$_POST['details'];
				$visit->dateaction=$today;
				$visit->timeaction=$time;

				if(!empty($_POST['user'])){
			    $visit->user_id=$_POST['user'];;
			    }else{
			        
			    $visit->user_id=$userid;    
			        
			    }
			    
				
				//$visit->unit_ids=$_POST['unit'];
				$visit->from_time=$_POST['from_time'];
				$visit->to_time=$_POST['to_time'];
				
				
				
            
            if(!empty($visit->from_time)){
            if(!empty($visit->to_time)){    
            $hourx=$visit->to_time - $visit->from_time;
            $visit->hour=$hourx;
            }    
            }
            
            
          $alloldlvisit = Visit::model()->findAll(array( 'condition' => 'lead_id=' . $model->id ,'limit'=>1 ,'order'=>'id DESC'  ));
if(!empty($alloldlvisit)){
foreach($alloldlvisit as $oldlvisit){
           $visit->novisit=$oldlvisit->novisit+1;
           
} }
          
				
				$visit->downpayment=$_POST['downpayment'];
				$visit->months=$_POST['months'];
				$visit->amount=$_POST['amount'];
				$visit->pending_visit=$_POST['pending_visit'];
			    if(!empty($_POST['unit'])){
			        $unit=implode(",",$_POST['unit']);
			    	$visit->unit_ids=$unit;
			    }
			    
			    
			   
			    
			    if(!empty($_POST['sales'])){
			        $sales=implode(",",$_POST['sales']);
			    	$visit->attended=$sales;
			    }
			    
			    
			    if(!empty($_POST['colors'])){
			        $sales=implode(",",$_POST['colors']);
			    	$visit->color_ids=$sales;
			    }
			    
			    
			    if(!empty($_POST['cash'])){
			        $cash=implode(",",$_POST['cash']);
			    	$visit->cash=$cash;
			    }
			    if(!empty($_POST['cash_date'])){
			       $cashdate=implode(",",$_POST['cash_date']);
				   $visit->cash_date=$cashdate;
			    } 
				
				
				if(isset($_POST['confirmsales'])){
				$visit->confirmsales=1;
				$visit->type=$_POST['type'];

				}
				
				
				
				if(isset($_POST['sales'])){
				    
				 //$visit->attended= $_POST['sales'];

			

				}
				
				
				
				 
				
				

				if($visit->save()){



					
$main=Mainsettings::model()->findByPk(1);	
$lead = Leads::model()->findByAttributes(array('id' => $visit->lead_id));
$agent = User::model()->findByAttributes(array('id' => $lead->user_sales));

if(!empty($main->visitmessage)){
$message = "{$main->visitmessage} 
للتواصل :
{$agent->fname} {$agent->lname}
{$agent->mobile}";

$smsmessagecontent = rawurlencode($message);
$sendername=$main->sender;
$senderuser=$main->username;
$senderpass=$main->password;
$sendernumber=$lead->international_code.$lead->tel;
$curl = curl_init();

curl_setopt_array($curl, array(

CURLOPT_URL => "https://smsmisr.com/api/SMS/?environment=1&username=".$senderuser."&password=".$senderpass."&language=2&sender=".$sendername."&mobile=".$sendernumber."&message=".$smsmessagecontent ,


CURLOPT_RETURNTRANSFER => true,
CURLOPT_ENCODING => "",
CURLOPT_MAXREDIRS => 10,
CURLOPT_TIMEOUT => 30,
CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
CURLOPT_CUSTOMREQUEST => "POST",
CURLOPT_HTTPHEADER => array(
'Content-Type: application/json', 
'Content-Length:0 ' ,
"Cache-Control: no-cache",
),
));
$response = curl_exec($curl);
$err = curl_error($curl);
//var_dump($response);
}
					
					
											
						/*
						$allsalesmanger=User::model()->findAll(array('condition'=>'salesmanger=1'));
						foreach($allsalesmanger as $sales){	
							if(!empty($sales->player_id)){	
											
								
								$content = array(
									"en" => $model->employee->fname. ' ' .$model->employee->lname. ' Add Visit to '.$visit->lead->title.' at '.$visit->date
								);
		
								$fields = array(
									'app_id' => "d55878ac-5a32-444a-90c8-d9a053cad61c",
									'include_player_ids' => array($sales->player_id),
									'data' => array("foo" => "bar"),
									'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$visit->lead_id ,
									'contents' => $content
								);
		
								$fields = json_encode($fields);
    			
								$ch = curl_init();
								curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
								curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
										'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
								curl_setopt($ch, CURLOPT_HEADER, FALSE);
								curl_setopt($ch, CURLOPT_POST, TRUE);
								curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
								curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

								$response = curl_exec($ch);
								curl_close($ch);
					
					
					
									
							}
							if(!empty($sales->player_id_mobile)){	
											
								
								$content = array(
									"en" => $model->employee->fname. ' ' .$model->employee->lname. ' Add Visit to '.$visit->lead->title.' at '.$visit->date
								);
		
								$fields = array(
									'app_id' => "d55878ac-5a32-444a-90c8-d9a053cad61c",
									'include_player_ids' => array($sales->player_id_mobile),
									'data' => array("foo" => "bar"),
									'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$visit->lead_id ,
									'contents' => $content
								);
		
								$fields = json_encode($fields);
    			
								$ch = curl_init();
								curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
								curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
										'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
								curl_setopt($ch, CURLOPT_HEADER, FALSE);
								curl_setopt($ch, CURLOPT_POST, TRUE);
								curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
								curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

								$response = curl_exec($ch);
								curl_close($ch);
					
					
					
									
							}
						}
						*/
						
				//notification to team leaders AND Salesmanger
			    $allsalesmanger=User::model()->findAll(array('condition'=>'salesmanger=1 AND level=1 '));
                $arr=array();
				foreach($allsalesmanger as $sales){	
				    $arr[]=$sales->id;
				}

				
                $criteria = new CDbCriteria();         
        		$criteria->order = 'id DESC';
        		$criteria->addInCondition('userid',$arr);
        		$vars= FirebaseToken::model()->findAll($criteria);
                
                $arr=array();
                if(!empty($vars)){
                			foreach($vars as $var){
                    			$arr[]=$var->token;
                			}
                
                }  
				$man=User::model()->findByPk($userid);
                $main=Mainsettings::model()->findByPk(1);
                $iconurl=Yii::app()->getBaseUrl(true).'/img/'.$main->logo;
                $fields = array(
                        'registration_ids' =>  $arr ,
                        'data' => array( "title" => " Visit ", "body" => $model->title." Has a New Visit Written By :  ".$man->username  ,"icon" => $iconurl , "click_action" => Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->id),
                    );
                $url = 'https://fcm.googleapis.com/fcm/send';

                $headers = array(
                    'Authorization: key='.$main->appkey ,
                    'Content-Type: application/json'
                );
                // Open connection
                $ch = curl_init();
            
                // Set the url, number of POST vars, POST data
                curl_setopt($ch, CURLOPT_URL, $url);
            
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            
                // Disabling SSL Certificate support temporarly
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
            
                // Execute post
                $result = curl_exec($ch);
                // echo "Result".$result;
                if ($result === FALSE) {
                    die('Curl failed: ' . curl_error($ch));
                }
            
                // Close connection
                curl_close($ch); 




				$this->redirect(array('leads/profile/'.$secert)	);
                                }else{$this->redirect(array('leads/profile/'.$secert)	);}
			}
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}



public function  actionconlead(){

		if(Yii::app()->user->isMember()){
		    
		$unitcheck=Units::model()->findByAttributes(array('id'=>$_POST['unit']));
		
		
		
		    
		  if($unitcheck->booking != NULL){  
		  Yii::app()->user->setFlash('error', 'No booking available for this unit.');
		  $this->redirect(array('sales/unit/'.$unitcheck->id)	);

		// var_dump($unitcheck->booking);exit;   
		    
		  }
		    
		//sleep(10);

		
        if($unitcheck->booking == NULL){
	//	var_dump($unitcheck);exit;

		    
			$userid=Yii::app()->user->id;
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");   
			$rnd = rand(0,99999);


			$main=Mainsettings::model()->findByPk(1);
 
			if(isset($_POST['conlead'])){

				$secert=$_POST['id'];
				$uniqid=$_POST['code'];
				$model= Leads::model()->findByAttributes(array('secert'=>$secert)); 
				$model->client_id=1;
				$model->save();
				
		//	var_dump($_POST['bookingform']);exit;
				$conlead=new RequestReservation();
				$conlead->date=$_POST['end_date'];
				$conlead->secret=$rnd;
							//	$conlead->date=$_POST['bookingform'];
				$conlead->bookingform=$_POST['bookingform'];

				$conlead->time=$time;
				$conlead->user_id= $userid;
				$conlead->lead_id=$model->id;
				$conlead->details=$_POST['details'];
				$conlead->downpayment=$_POST['downpayment'];
				$conlead->amount=$_POST['amount'];
				$conlead->unit_id=$_POST['unit'];
				$conlead->sales=$_POST['sales'];
				$conlead->mandatoryrent=$_POST['mandatoryrent'];
				$conlead->campaign_id=$model->campaign_id;
				$conlead->name=$_POST['name'];
				$conlead->id_card=$_POST['id_card'];
				$conlead->job=$_POST['job'];
				$conlead->full_address=$_POST['full_address'];
				$conlead->address_email=$_POST['address_email'];

				$conlead->paymentplan_id=$_POST['paymentplan'];
							//	var_dump($conlead->paymentplan_id);exit;

				$conlead->state=$_POST['state'];
				$conlead->government=$_POST['government'];
				$conlead->floor=$_POST['floor'];
				$conlead->region=$_POST['region'];
				$conlead->street=$_POST['street'];
				$conlead->buliding=$_POST['buliding'];
				$conlead->apartment=$_POST['apartment'];
				$conlead->mail=$_POST['mail'];
				$conlead->nationality=$_POST['nationality'];
				$conlead->salesbroker=$_POST['salesbroker'];
				$conlead->teamleaderbroker=$_POST['teamleaderbroker'];
				$conlead->cashflow=$_POST['cashflow'];
				$conlead->delivery_date=$_POST['delivery_date'];
				$conlead->email=$_POST['mail'];





				$conlead->destination=$_POST['destination'];
				$conlead->incentive=$_POST['incentive'];
				$conlead->date_allowdownpayment=$_POST['date_allowdownpayment'];
				$conlead->unitcode=$_POST['unitcode'];
				$conlead->developerforbroker=$_POST['developerforbroker'];
				$conlead->projects=$_POST['projects'];
				$conlead->bua_indoor_size=$_POST['bua_indoor_size'];
				$conlead->documents=$_POST['documents'];
				$conlead->outdoor_size=$_POST['outdoor_size'];
				$conlead->license=$_POST['license'];
				$conlead->transaction_type=$_POST['transaction_type'];
				$conlead->unit_type=$_POST['unit_type'];
				$conlead->passport=$_POST['passport'];
				$conlead->local=$_POST['local'];


				$conlead->parking_sold=$_POST['parking_sold'];
				$conlead->parking_price=$_POST['parking_price'];




			

				$conlead->deposit=$_POST['deposit'];
				$conlead->end_date=$_POST['end_date'];
				$conlead->con_date=$_POST['con_date'];

				
			
$conlead->sales = $model->user_sales;
$conlead->campaign_id = $model->campaign_id;
$conlead->strategy_id = $model->strategy_id;



$leader=Teamleader::model()->findByAttributes(array('sales_id'=>$model->user_sales));
if(!empty($leader)){
$conlead->teamleader = $leader->leader_id;
}



				

				if($conlead->save()){
				    
				    

$main = Mainsettings::model()->findByPk(1);

if (!empty($main->post_url)) {
//var_dump('1');exit;

if (empty($main->post_token)) {

//var_dump($main->post_token);exit;




// API URL

$url = $main->post_url;

// Authorization token

$token = $main->post_token;


$deliveryDate = DateTime::createFromFormat('Y-m-d', $conlead->delivery_date);

if ($deliveryDate !== false) {
    // Format the date as 'Y-m-d\TH:i:s\Z' (ISO 8601 format)
    $formattedDate = $deliveryDate->format('Y-m-d\TH:i:s\Z');
} else {
    // Handle the case where the date could not be parsed (e.g., set to null)
    $formattedDate = null;
}

$lead=Leads::model()->findByAttributes(array('id'=>$conlead->lead_id));
$unit=Units::model()->findByAttributes(array('id'=>$conlead->unit_id));
$sales =User::model()->findByAttributes(array('id'=>$lead->user_sales));

// Data to be sent in the POST request
$data = array(
    "TITLE" => $conlead->name,
    "IDCARD" => $conlead->id_card,
    "NATIONALITY" => $conlead->nationality,
    "FULLADDRESS" => $conlead->full_address,
    "BOOKINGFORM" => $conlead->bookingform,
    "BROKER_TEAMLEADER" => $conlead->teamleaderbroker,
    "UNITID" => $unit->code,
    "RESERVATIONDATE" => $conlead->date,
    "DEPOSIT" => $conlead->deposit,
    "DOWNPAYMENT" => $conlead->downpayment,
    "NAME" => $conlead->name,
    "EMAIL" => $conlead->email,
    "JOB" => $conlead->job,
    "BROKERAGENTNAME" => $conlead->salesbroker,
    "PAYMENTMETHOD" => $conlead->cashflow,
    "UNITPRICE" => $conlead->amount,
    "DELIVERYDATE" => $formattedDate,
   // "DOWNPAYMENTPERCENTAGE" => 15.00,
    "RENT" => 0,
    "PARKING" => 0,
   "CLUBHOUSE" => 0,
    "REQUESTID" => $conlead->id,
    "CONFIRM_" => 0,
    "Salesname" => $sales->fname.''.$sales->lname,
    "Salesman" => $lead->user_sales,

    "Phone" => $lead->tel,
    "CustomerCode" =>$lead->id,
    "EntityCode" => $lead->id,
    

"EntityName"=>$conlead->name
    
);

// Convert data array to JSON
$data_json = json_encode($data);
//var_dump($data_json);exit;

// Initialize cURL session
$ch = curl_init($url);

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $data_json);
curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    'Content-Type: application/json',
    'Authorization: Bearer ' . $token
));

// Execute the request
$response = curl_exec($ch);
 

// Get the HTTP status code
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
var_dump($http_code);exit;
//
if ($response === false) {
    echo 'cURL Error: ' . curl_error($ch);
} else {
    // Get HTTP status code
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Display the HTTP status code
    //echo "HTTP Status Code: " . $http_code . "\n";
   // $response_data = json_decode($response, true);

    // Check if status code is not 200
    if ($http_code != 200) {
        $conlead->delete();
        // Decode the response
        $response_data = json_decode($response, true);
        $data_json = json_encode($response_data);

        // var_dump the HTTP status code and JSON data separately
      //  var_dump($http_code);
        var_dump($data_json);
        exit;
    }

    // Decode and pretty print the JSON response
    $response_data = json_decode($response, true);
    //echo '<pre>' . json_encode($response_data, JSON_PRETTY_PRINT) . '</pre>';
}

// Close cURL session
curl_close($ch);




}
}
				    
				    
				    
				    
				    				$lead= Leads::model()->findByAttributes(array('id'=>$conlead->lead_id)); 

				        $main=Mainsettings::model()->findByPk(1);

				    			            if(!empty($main->autoclosedeal)){
                    $lead->close=1;
                    $lead->reopen=NULL;
                    $lead->communication=1;
                    $lead->close_date= $today;
                    $substatus=Substatus::model()->findByPk($main->autoclosedeal);
                    $qualifiedtest=Statues::model()->findByPk($substatus->parent_id);
                    if($qualifiedtest->qualified == 1){
                    $lead->qualified=1;
                    if(empty($lead->first_classification)){
                    $lead->first_classification=1;
                    $lead->first_classification_user=$userid; 
                    }
                    }
                    if($lead->nonqualified == 1){
                    $lead->nonqualified=1;
                    if(empty($lead->first_classification)){
                    $lead->first_classification=2;
                    $lead->first_classification_user=$userid; 
                    }
                    }
                    $lead->substatus=$main->autoclosedeal;
                    $substatus=Substatus::model()->findByPk($main->autoclosedeal);
                    $lead->status=$substatus->parent_id;

                    if($substatus->answer == 1){
                    $lead->answer=1;
                    }
                    if($substatus->answer == 2){
                    $lead->answer=2;
                    }
                    if($substatus->expvisit == 1){
                    $lead->expvisit=1;
                    }
                    if($substatus->callback == 1){
                    $lead->callback=1;
                    }
                    $lead->sales_report='Close Deal by EOI';
                    $lead->save(); 
                    
                    
                    
                   // var_dump($lead->id);exit;
                    
                    
                    //clear activities of closed leads
                    $criteria = new CDbCriteria;
                    $criteria->condition = "close IS NULL OR report IS NULL  ";
                    $criteria->addCondition('leads_id=' . $lead->id);
                    $allactivities=Activities::model()->findAll($criteria);
                    

                    
                    if(!empty($allactivities)){
                    foreach($allactivities as $activity){
                    $activity->close=1;
                    $activity->report='Closed In '.$today.'-'.$_POST['report'];
                    $activity->save();
                    }
                    
                    
                    
                    
                    $newmodel= new Activities();
                    $newmodel->user_id = $userid;
                    $newmodel->leads_id = $lead->id;
                    $newmodel->lead_date = $lead->date;
                    
                    $newmodel->date = $today;
                    $newmodel->time = $time;
                    
                    $newmodel->details= $lead->sales_report;
                    $rnd = rand(0,99999);
                    $newmodel->code= $rnd; 
                    $newmodel->report= 'Closed In '.$today.'-'.$lead->sales_report;
                    $newmodel->follow_date= $today;
                    $newmodel->status= $lead->status;
                    $newmodel->substatus=$lead->substatus;
                    $substatus=Substatus::model()->findByPk($lead->substatus);
                      
                    if($substatus->answer == 1){
                    $newmodel->answer=1; 
                    }
                    
                    
                    if($substatus->answer == 2){
                    $newmodel->answer=2; 
                    }
                    
                    
                    
                      
                    if($substatus->expvisit == 1){
                    $newmodel->expvisit=1;
                    }
                    
                    
                    
                    if($substatus->callback == 1){
                    $newmodel->callback=1;
                    }
                    
                    
                    $newmodel->type= 1;
                    $newmodel->close=1;
                    
                    
                    $newmodel->save();
                    $lead=Leads::model()->findByPk($newmodel->leads_id);
                    $lead->follow_date=$newmodel->follow_date;
                    $lead->checkup_activity=$today; 
                    $lead->save();
                    $newmodel->secert=$newmodel->id;
                    $newmodel->name=$lead->title;
                    $newmodel->tel=$lead->tel;
                    $newmodel->coldcall=$lead->coldcall;
                    $newmodel->indirect=$lead->indirect;
                    $newmodel->save();
                    
                    //if(!$newmodel->save()){
                    	//var_dump($newmodel->getErrors());
                    //	}
                    
                    }else{
                        
                                           // var_dump('ddd');exit;

                    //clear activities of closed leads
                    
                    
                    $newmodel= new Activities();
                    $newmodel->user_id = $userid;
                    $newmodel->leads_id = $lead->id;
                    $newmodel->lead_date = $lead->date;
                    $newmodel->date = $today;
                    $newmodel->time = $time;
                    
                    $newmodel->details= $lead->sales_report;
                    $rnd = rand(0,99999);
                    $newmodel->code= $rnd; 
                    
                    $newmodel->report= 'Closed In '.$today.'-'.$lead->sales_report;
                    $newmodel->follow_date= $today;
                    $newmodel->status= $lead->status;
                    $newmodel->substatus=$lead->substatus;
                    $substatus=Substatus::model()->findByPk($lead->substatus);
                      
                    if($substatus->answer == 1){
                    $newmodel->answer=1; 
                    }
                    
                    
                    if($substatus->answer == 2){
                    $newmodel->answer=2; 
                    }
                    
                    
                    
                    
                                    
                    if($substatus->expvisit == 1){
                    $newmodel->expvisit=1;
                    }
                    
                    
                    
                    if($substatus->callback == 1){
                    $newmodel->callback=1;
                    }
                    
                    $newmodel->type= 1;
                    $newmodel->close=1;
                    
                    
                    $newmodel->save();
                    $lead=Leads::model()->findByPk($newmodel->leads_id);
                    $lead->follow_date=$newmodel->follow_date;
                    $lead->checkup_activity=$today; 
                    $lead->save();
                    $newmodel->secert=$newmodel->id;
                    $newmodel->name=$lead->title;
                    $newmodel->tel=$lead->tel;
                    $newmodel->coldcall=$lead->coldcall;
                    $newmodel->indirect=$lead->indirect;
                    $newmodel->save();
                    
                    
                    
                    
                    
                    

                    }


			
			
			}

				    
	
if($main->accounting ==  1){

$client= ObjectAccount::model()->findByAttributes(array('client'=>1));
if(!empty($client)){
        $lead= ObjectAccount::model()->findByAttributes(array('lead_id'=>$model->id));
        if(empty($lead)){
            $newobj = new ObjectAccount();
            $newobj->parent_id= $client->id;
    		$newobj->user_id= $userid;
    		$newobj->title= $model->title;
    		$newobj->lead_id= $model->id;
    		if($newobj->save()){
    	            $pending=new DailyrestrictionsPending();
                    $pending->date=$today;
                    $pending->time=$time;
                    $pending->user_id=$userid;
                    $pending->tree_id=$client->tree_id; 
                    $pending->amount=$conlead->deposit;
                    $pending->object_id=$newobj->id;
                    $pending->unit_id=$conlead->unit_id;
    				$pending->lead_id=$conlead->lead_id;
    				$pending->details='Deposite of unit with Details : '.$conlead->details;
                    if(!$pending->save())var_dump($pending->getErrors()); 
    		}  
        }else{
    	            $pending=new DailyrestrictionsPending();
                    $pending->date=$today;
                    $pending->time=$time;
                    $pending->user_id=$userid;
                    $pending->object_id=$lead->id;
                    $pending->tree_id=$client->tree_id; 
                    $pending->amount=$conlead->deposit;
                    $pending->unit_id=$conlead->unit_id;
    				$pending->lead_id=$conlead->lead_id;
    				$pending->details='Deposite of unit with Details : '.$conlead->details;
                    if(!$pending->save())var_dump($pending->getErrors()); 
            
        }
		
}
                

}

				$this->redirect(array('leads/profile/'.$secert)	);
                                }else{
                                    
                                    var_dump($conlead->getErrors());exit; 
                                    
                                    $this->redirect(array('leads/profile/'.$secert)	);}
			}
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
		
		}

	}


	public function actionDeletenote($secert,$id){

		if(Yii::app()->user->isMember()){
			$lead=Leads::model()->findByPk($id);
			$model= Notes::model()->findByAttributes(array('secert'=>$secert));
			$var=$model->date;
			if((strtotime(date("Y-m-d"))-(60*60*24)) < strtotime($var) ){
				if($model){
					$model->delete();
					$this->redirect(array('leads/profile/'.$lead->secert)	);
				
				}
			}else{
				echo'You Cannot Update This Record Because the Date Is Expired';
			}
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}


public function  actionUnhide($id){

		if(Yii::app()->user->isMember()){
$lead=Leads::model()->findByPk($id);
$criteriaact = new CDbCriteria; 
$criteriaact->addSearchCondition('leads_id', $lead->id, false);
$allactivities=Activities::model()->findAll($criteriaact);
if(!empty($allactivities)){
foreach($allactivities as $activity){ 
   
   $activity->hidden = NULL;
   $activity->hideteamleader = NULL;
   $activity->save();

   //var_dump($allactivities);exit; 
    
}
}
	
	   		$this->redirect(array('leads/profile/'.$lead->id)	);
		
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$model = new Notes();
			$rnd = rand(0,99999);
		
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}



	public function  actionAddnote($id){

		if(Yii::app()->user->isMember()){
			$lead=Leads::model()->findByPk($id);
			$allnotetype=NoteType::model()->findAll();
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$model = new Notes();
			$rnd = rand(0,99999);
			if(isset($_POST['Notes'])){
				$model->attributes = $_POST['Notes'];
				$model->note_type = $_POST['Note']['note_type'];
				$model->sales_id=$lead->user_sales;
				$model->date=$today;
				$model->time=$time;
				$model->lead_id=$id;
				$model->user_id=$userid;
				$model->secert=$rnd.$userid;
				if($model->save()){
					
					
					
											
						$allsalesmanger=User::model()->findAll(array('condition'=>'salesmanger=1'));
						foreach($allsalesmanger as $sales){	
							if(!empty($sales->player_id)){	
											
								
								$content = array(
									"en" => $model->employee->fname. ' ' .$model->employee->lname. ' Add Note to '.$model->lead->title.' And Wrote '.$model->note 
								);
		
								$fields = array(
									'app_id' => "d55878ac-5a32-444a-90c8-d9a053cad61c",
									'include_player_ids' => array($sales->player_id),
									'data' => array("foo" => "bar"),
									'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->lead_id ,
									'contents' => $content
								);
		
								$fields = json_encode($fields);
    			
								$ch = curl_init();
								curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
								curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
										'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
								curl_setopt($ch, CURLOPT_HEADER, FALSE);
								curl_setopt($ch, CURLOPT_POST, TRUE);
								curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
								curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

								$response = curl_exec($ch);
								curl_close($ch);
					
					
					
									
							}
							if(!empty($sales->player_id_mobile)){	
											
								
								$content = array(
									"en" => $model->employee->fname. ' ' .$model->employee->lname. ' Add Note to '.$model->lead->title.' And Wrote '.$model->note 
								);
		
								$fields = array(
									'app_id' => "d55878ac-5a32-444a-90c8-d9a053cad61c",
									'include_player_ids' => array($sales->player_id_mobile),
									'data' => array("foo" => "bar"),
									'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->lead_id ,
									'contents' => $content
								);
		
								$fields = json_encode($fields);
    			
								$ch = curl_init();
								curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
								curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
										'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
								curl_setopt($ch, CURLOPT_HEADER, FALSE);
								curl_setopt($ch, CURLOPT_POST, TRUE);
								curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
								curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

								$response = curl_exec($ch);
								curl_close($ch);
					
					
					
									
							}
						}




//notification to team leader



					$criteria = new CDbCriteria;
					$criteria->addCondition('sales_id=' . $model->employee->id);
					$leader=Teamleader::model()->find($criteria);
                                        $leader=User::model()->findByPk($leader->leader_id);
					if(!empty($leader)){
						if(!empty($leader->player_id)){
							$content = array(
								"en" => $model->employee->fname. ' ' .$model->employee->lname. ' Add Note to '.$model->lead->title.' And Wrote '.$model->note
							);
							
							$fields = array(
								'app_id' => "d55878ac-5a32-444a-90c8-d9a053cad61c",
								'include_player_ids' => array($leader->player_id),
								'data' => array("foo" => "bar"),
								'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->secert ,
								'contents' => $content
							);
							
							$fields = json_encode($fields);
					    			
							$ch = curl_init();
							curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
							curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
									'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
							curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
							curl_setopt($ch, CURLOPT_HEADER, FALSE);
							curl_setopt($ch, CURLOPT_POST, TRUE);
							curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
							curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

							$response = curl_exec($ch);
							curl_close($ch);
						}else{
						
						}



						if(!empty($leader->player_id_mobile)){
							$content = array(
								"en" => $model->employee->fname. ' ' .$model->employee->lname. ' Add Note to '.$model->lead->title.' And Wrote '.$model->note
							);
							
							$fields = array(
								'app_id' => "d55878ac-5a32-444a-90c8-d9a053cad61c",
								'include_player_ids' => array($leader->player_id),
								'data' => array("foo" => "bar"),
								'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->secert ,
								'contents' => $content
							);
							
							$fields = json_encode($fields);
					    			
							$ch = curl_init();
							curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
							curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
									'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
							curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
							curl_setopt($ch, CURLOPT_HEADER, FALSE);
							curl_setopt($ch, CURLOPT_POST, TRUE);
							curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
							curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

							$response = curl_exec($ch);
							curl_close($ch);
						}else{
							
						}




					}

						
						
					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Add Note';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secert;
					$logsystem->user_id = $userid;
					$logsystem->save();


					$this->redirect(array('leads/profile/'.$lead->secert)	);
				}
			}
			$this->render('addnote',array(
					'userid'=>$userid ,	
					'model'=>$model ,	
					'allnotetype'=>$allnotetype,	
        
        

				));
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
	
		public function  actionAdddocument($id){

		if(Yii::app()->user->isMember()){
			$lead=Leads::model()->findByPk($id);
		
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$model = new Notes();
			$rnd = rand(0,99999);
			
			
			 
				
		$model=new DocumentStorage;
		if(isset($_POST['DocumentStorage'])){
		  //var_dump('test');exit;
			$rnd = rand(0,9999);
			$model->attributes = $_POST['DocumentStorage'];
			$model->user_id = $userid;
			$model->date = $today;
			$model->time = $time;
			$model->lead_id = $lead->id;
			$model->type_document_id = 1;

	$uploadedFile=CUploadedFile::getInstance($model,'file');
		//var_dump($uploadedFile);exit;
		if(!empty ($uploadedFile)){
			$fileName = "{$rnd}-{$uploadedFile}";  // random number + file name
			$model->file= $fileName;
				$uploadedFile->saveAs(Yii::app()->basePath.'/../uploads/'.$fileName);
				$out=Yii::app()->basePath.'/../uploads/'.$fileName;
			}
		if(!$model->save()){
$errores = $model->getErrors();
var_dump($errores);exit;
}
		if($model->save()){ 
			    
			    
			    	Yii::app()->controller->refresh();
				    
				    
			}
			
		}
			
			
			
			
		
			$this->render('adddocument',array(
					'userid'=>$userid ,	
					'model'=>$model ,	
					'lead'=>$lead ,	
					

        

				));
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
	
	
	
	
	
	public function actionRequestroutaion(){
	if(Yii::app()->user->isMember()){

		$userid=Yii::app()->user->id;
	//	var_dump($userid);exit;
        $user = User::model()->findByPK($userid);
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);	
		
		$secert=$_POST['secert'];
		$requestres=$_POST['requestres'];
		
        
        $model = new Requestroutation();
        $model->user_id = $userid;
        $model->date = $today;
        $model->time = $time;
        $model->lead_id = $secert;
        $model->details = $requestres;
        $model->save();
        
        //Yii::app()->controller->refresh();
		$this->redirect(array('leads/profile/'.$secert)	);
		
	
			
	}
		

	else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
	}

}

	
	
	
	
	
	
	
		public function  actionAddtags($id){

		if(Yii::app()->user->isMember()){
			$lead=Leads::model()->findByPk($id);
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$model = new Taglead();
			$rnd = rand(0,99999);
			
			if(isset($_POST['Taglead'])){
			    
			   
				$model->attributes = $_POST['Taglead'];
				$model->date=$today;
				$model->time=$time;
				$model->lead_id=$id;
				
				$model->user_id=$userid;
							
	if(!$model->save()){
					var_dump($model->getErrors());exit;
					}
				if($model->save()){
					
		$lead->tags = $lead->tags.','.$model->tag_id;
		$lead->save();		

					$this->redirect(array('leads/profile/'.$lead->secert)	);
				}
			}
			$this->render('addtag',array(
					'userid'=>$userid ,	
					'model'=>$model ,	

        

				));
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
	
		public function  actionChatandsupport($id){

		if(Yii::app()->user->isMember()){
			$lead=Leads::model()->findByPk($id);
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$model = new Chatandsupport();
			$rnd = rand(0,99999);
			if(isset($_POST['Chatandsupport'])){
				$model->attributes = $_POST['Chatandsupport'];
				//$model->note_type = $_POST['Chatandsupport']['note_type'];
				//$model->sales_id=$lead->user_sales;
				$model->date=$today;
				$model->time=$time;
				$model->lead_id=$id;
				$model->user_id=$userid;
				//$model->secert=$rnd.$userid;
				if($model->save()){
					
					
					
			


				

					$this->redirect(array('leads/profile/'.$lead->secert)	);
				}
			}
			$this->render('chatandsupport',array(
					'userid'=>$userid ,	
					'model'=>$model ,	

        

				));
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}









	public function  actionEditeoiop($id){

		if(Yii::app()->user->isMember()){
			$model=Eoiform::model()->findByPk($id);
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


			
				
	




			$this->render('editeoiop',array(
					'userid'=>$userid ,	
					'model'=>$model ,	
					
        

				));
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}




	public function  actionEditleadforsales($id){

		if(Yii::app()->user->isMember()){
			$model=Leads::model()->findByPk($id);
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


			$oldname=$model->title;
			$second_tel=$model->second_tel;
			$career=$model->career;
			$email=$model->email;
				
	

			if(isset($_POST['Leads'])){

if($model->tel != $_POST['Leads']['tel'] ){
                            $name = str_replace(' ', '', $_POST['Leads']['tel']);
							$criteriaduplecat= new CDbCriteria(); 
    						$criteriaduplecat->addSearchCondition('tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('second_tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel3', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel4', $name, false , 'OR');
							$allduplecat1= Leads::model()->count($criteriaduplecat);
}
if ($model->second_tel != $_POST['Leads']['second_tel']){
    
                            //$name = str_replace(' ', '', $_POST['Leads']['second_tel']);
                            $secondtel = str_replace(' ', '', $_POST['Leads']['second_tel']);
                           // var_dump($secondtel);exit;
							$criteriaduplecat2= new CDbCriteria(); 
    						$criteriaduplecat2->addSearchCondition('tel', $secondtel, false , 'OR');
    						$criteriaduplecat2->addSearchCondition('second_tel', $secondtel, false , 'OR');
    						$criteriaduplecat2->addSearchCondition('tel3', $secondtel, false , 'OR');
    						$criteriaduplecat2->addSearchCondition('tel4', $secondtel, false , 'OR');
							$allduplecat2= Leads::model()->count($criteriaduplecat2);
							                            //var_dump($allduplecat2);exit;

}
if(empty($allduplecat1) or empty($allduplecat2)  ) {
    //var_dump($allduplecat2);exit;
				$model->attributes = $_POST['Leads'];
				
				 if(!empty($_POST['Leads']['tag_id']) AND !empty($_POST['tag'])){
                                                     //Yii::app()->controller->refresh();
                                                 }elseif(!empty($_POST['tag'])){
                                                     $newtag=new Tag();
                                                     $newtag->title=$_POST['tag'];
                                                     $newtag->save();
                                                     $model->tag_id=$newtag->id;
                                                 }
                                                 
                                                 
                                                 
	  

				if($model->save()){
$string=' ';
settype($string, "string");
if($oldname != $model->title)$string.='( Name from '.$oldname.' to '.$model->title.' )'; 

if($second_tel != $model->second_tel ){
if(!empty($second_tel)){
$string.='( Second tel from '.$second_tel.' to '.$model->second_tel.' )';
}else{
$string.='( Second tel set to '.$model->second_tel.' )';
}
}

if($career != $model->career){
if(!empty($career )){
$string.='( Career from '.$career.' to '.$model->career.' )';
}else{
$string.='( Career set to '.$model->career.' )';
}
}

if($email != $model->email){
if(!empty($email)){
$string.='( Email from '.$email.' to '.$model->email.' )';
}else{
$string.='( Email set to '.$model->email.' )';
}
}

					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = $string ;
					$logsystem->action_id = $model->id;
					$logsystem->ip = 'update';
					$logsystem->secert = $model->secert;
					$logsystem->user_id = $userid;
					$logsystem->save();


					$this->redirect(array('leads/profile/'.$model->secert)	);
				}else{var_dump($model->getErrors());}
				$model->attributes = $_POST['Leads'];
	  

				if($model->save()){
$string=' ';
settype($string, "string");
if($oldname != $model->title)$string.='( Name from '.$oldname.' to '.$model->title.' )'; 

if($second_tel != $model->second_tel ){
if(!empty($second_tel)){
$string.='( Second tel from '.$second_tel.' to '.$model->second_tel.' )';
}else{
$string.='( Second tel set to '.$model->second_tel.' )';
}
}

if($career != $model->career){
if(!empty($career )){
$string.='( Career from '.$career.' to '.$model->career.' )';
}else{
$string.='( Career set to '.$model->career.' )';
}
}

if($email != $model->email){
if(!empty($email)){
$string.='( Email from '.$email.' to '.$model->email.' )';
}else{
$string.='( Email set to '.$model->email.' )';
}
}

					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = $string ;
					$logsystem->action_id = $model->id;
					$logsystem->ip = 'update';
					$logsystem->secert = $model->secert;
					$logsystem->user_id = $userid;
					$logsystem->save();


					$this->redirect(array('leads/profile/'.$model->secert)	);
				}else{var_dump($model->getErrors());}
}

	
			
			}








			$this->render('editleadforsales',array(
					'userid'=>$userid ,	
					'model'=>$model ,	
					'allsales'=>$allsales,	
					'allproject'=>$allproject ,	
					'allcampaign'=>$allcampaign,	
					'allplatform'=>$allplatform,	
					'allstatus'=>$allstatus,	
        

				));
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}









public function  actionEditlead($id){

		if(Yii::app()->user->isMember()){
			$model=Leads::model()->findByPk($id);
			$leaduserid=$model->user_id;
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$visible=1;
			$allcampaign= Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allstatus= Statues::model()->findAll();
			$titlebefore = $model->title;
			$telbefore = $model->tel;
			
			$marketing = User::model()->findByAttributes(array('id'=>$model->user_marketing));
			$marketingbefore = $marketing->fname.$marketing->lname;
			
			
			//$tel2before = $model->tel2;
			//$tel3before = $model->tel3;
			//$tel4before = $model->tel4;
			$platform = Platform::model()->findByAttributes(array('id'=>$model->platform_id));
			$platformbefore = $platform->title; 
			$campaign = Campaign::model()->findByAttributes(array('id'=>$model->campaign_id));
			$campaignbefore = $campaign->title; 


			if(isset($_POST['Leads'])){


if($model->tel != $_POST['Leads']['tel'] AND !empty($_POST['Leads']['tel']) ){
                            $name = str_replace(' ', '', $_POST['Leads']['tel']);
        					$name = preg_replace('/\D/', '', $name);
        					
							$criteriaduplecat= new CDbCriteria(); 
    						$criteriaduplecat->addSearchCondition('tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('second_tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel3', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel4', $name, false , 'OR');
							$allduplecat1= Leads::model()->findAll($criteriaduplecat);
}
if ($model->second_tel != $_POST['Leads']['second_tel']   AND !empty($_POST['Leads']['second_tel'])  ){
    
                            $name = str_replace(' ', '', $_POST['Leads']['second_tel']);
        					$name = preg_replace('/\D/', '', $name);
							$criteriaduplecat= new CDbCriteria(); 
    						$criteriaduplecat->addSearchCondition('tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('second_tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel3', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel4', $name, false , 'OR');
							$allduplecat2= Leads::model()->findAll($criteriaduplecat);
}
if ($model->tel3 != $_POST['Leads']['tel3']   AND !empty($_POST['Leads']['tel3'])  ){
    
                            $name = str_replace(' ', '', $_POST['Leads']['tel3']);
        					$name = preg_replace('/\D/', '', $name);
							$criteriaduplecat= new CDbCriteria(); 
    						$criteriaduplecat->addSearchCondition('tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('second_tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel3', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel4', $name, false , 'OR');
							$allduplecat3= Leads::model()->findAll($criteriaduplecat);
}
if ($model->tel4 != $_POST['Leads']['tel4'] AND !empty($_POST['Leads']['tel4'])  ){
    
                            $name = str_replace(' ', '', $_POST['Leads']['tel4']);
        					$name = preg_replace('/\D/', '', $name);
							$criteriaduplecat= new CDbCriteria(); 
    						$criteriaduplecat->addSearchCondition('tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('second_tel', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel3', $name, false , 'OR');
    						$criteriaduplecat->addSearchCondition('tel4', $name, false , 'OR');
							$allduplecat4= Leads::model()->findAll($criteriaduplecat);
}
if(!empty($allduplecat1) or !empty($allduplecat2) or !empty($allduplecat3) or !empty($allduplecat4) ) Yii::app()->controller->refresh();
		 
				$model->attributes = $_POST['Leads'];
			//	var_dump($_POST['Leads']['duplicate_date']);exit;

$main=Mainsettings::model()->findByPk(1);
if(!empty($main->hideselectcampaign)){
				
				$xcam=Campaign::model()->findByAttributes(array('title'=>$_POST['campaignx']));
                if(empty($xcam)) {
                
                

                
            $modelca = new Campaign();
            $modelca->setScenario('com_porfile');
            $rnd = rand(0,9999);
            $modelca->user_id = $userid;
            $modelca->strategy_id = 1;
            $modelca->date = $today;
            $modelca->time = $time;
            $modelca->title = $_POST['campaignx'];
            $modelca->details = $_POST['campaignx'];
            $modelca->cost = 0;
            $modelca->objective_id = 1;
            $modelca->hidden = 1;
            $modelca->secert = $rnd.$userid;
            $modelca->save();
            if(!$modelca->save()){
            var_dump($modelca->getErrors());
            exit;
            }

           
            $model->campaign_id = $modelca->id ;
            
                
            }else{
                
            $model->campaign_id = $xcam->id ;    
                
            }
            
}

           
                
$checktypelead=Platform::model()->findByAttributes(array('id'=>$_POST['Leads']['platform_id']));
if($checktypelead->indirect == 1){
$model->coldcall = 3;
}elseif($checktypelead->coldcall == 1){
$model->coldcall = 1;
}else{
}
				$model->platformchild_id=$_POST['Leads']['platformchild_id'];

				if(empty($model->user_id)){
				    $model->user_id=$leaduserid;
				}
 //var_dump($allduplecat2);
	           // exit;
				//$allleads=Leads::model()->findAll(array( 'condition' => 'tel!=' . $model->tel ,'order'=>'id DESC'  ));  
				
				//var_dump($_POST['Leads']['fresh_sales']);exit;

$model->fresh_sales = $_POST['Leads']['fresh_sales'];
$model->project_id = $_POST['Leads']['project_id'];
$model->unit_type = $_POST['Leads']['unit_type'];

if(!empty($_POST['Leads']['user_marketing'])){
$model->user_marketing = $_POST['Leads']['user_marketing'];
$model->user_id = $_POST['Leads']['user_marketing'];

}
if(!empty($_POST['Leads']['duplicate_date'])){
$model->duplicate_date=$_POST['Leads']['duplicate_date'];
}

				if($model->save()){
				    
				    
				    
				      
            $editlog = new Editlog();
            $editlog->date = $today;
            $editlog->time = $time;
            $editlog->lead_id = $model->id;
            
            
            $platform = Platform::model()->findByAttributes(array('id'=>$model->platform_id));
			$platformnow = $platform->title; 
			
			$marketing = User::model()->findByAttributes(array('id'=>$model->user_marketing));
			$marketingnow = $marketing->fname.$marketing->lname; 
			
			$campaign = Campaign::model()->findByAttributes(array('id'=>$model->campaign_id));
			$campaignnow = $campaign->title; 

            
            $editlog->user_id = $userid;
            $editlog->editfrom = '  name : '
            .$titlebefore
            .' </br> tel : '.
            $telbefore 
            .' </br> campaign : '.
            $campaignbefore
             .' </br> platform : '.
            $platformbefore
             .' </br> marketing : '.
            $marketingbefore
            ;
            
            $editlog->editto = '  name : '
            .$model->title
            .' </br> tel : '.
            $model->tel
             .' </br> campaign : '.
            $campaignnow
            .' </br> platform : '.
            $platformnow
            .' </br> marketing : '.
            $marketingnow

            ;
            $editlog->editcolumn = 'User Edit Lead';
            $editlog->save();
            
				    
				    


					$this->redirect(array('leads/profile/'.$model->id)	);

					//$this->redirect(array('sales/editlead/'.$model->secert)	);

				//	Yii::app()->controller->refresh();
				}else{
				    
				    
				    var_dump($model->getErrors());
				}
			}








			$this->render('editlead',array(
					'userid'=>$userid ,	
					'model'=>$model ,	
					'allsales'=>$allsales,	
					'allproject'=>$allproject ,	
					'allcampaign'=>$allcampaign,	
					'allplatform'=>$allplatform,	
					'allstatus'=>$allstatus,	
        

				));
		}
		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}





	public function actionAds(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$today2=date("Y");
		
			$visible = 1;
		
			$allplatform = Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

			$criteria = new CDbCriteria;

			$criteria->condition = "close IS NULL ";
			$criteria->addCondition('user_id=' . $userid);
			$criteria->order = 'id DESC';
			$dataProvider = new CActiveDataProvider('Ads', array(
					'pagination' => array(
						'pageSize' =>50,
					),
					'criteria' => $criteria,
				));



			



		
			$model = new Ads();
			$model->setScenario('com_porfile');
			if(isset($_POST['Ads'])){
				$rnd = rand(0,9999);
				$model->attributes = $_POST['Ads'];
			
				$model->user_id = $userid;
				$model->date = $today;
				$model->time = $time;
			

$model->save();

			
			}

		
		
		
		
			$this->render('ads',array(
					'userid'=>$userid ,	
					'model'=>$model ,	
					'dataProvider' => $dataProvider ,		
					'pages2' => $pages2,		
			
					'allplatform'=>$allplatform,

					



				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}





	public function actionLivemeeting(){
	
$this->layout = '//';
	$this->render('livemeeting');
	

	}




		
	public function actionSales(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$today2=date("Y");
		
$this->layout = '//layouts/systemcgridview';
			$visible = 1;
		
			$allplatform = Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			//$allleads= Leads::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));

			$allplaces= Interestedplace::model()->findAll();
			$allstatues= Statues::model()->findAll();
			$allsubstatues= Substatus::model()->findAll();





  
            $allleadssales=new Leads('salesx');
            
            $allleadssales->unsetAttributes();  // clear any default values
            if(isset($_GET['Leads'])){
            $allleadssales->attributes=$_GET['Leads'];
            }
                 


			$criteria = new CDbCriteria;

			$criteria->condition = "close IS NULL ";
			//$criteria->addCondition('duplicate IS NULL');
			$criteria->addCondition('hidden=' . $visible);
			$criteria->addCondition('user_sales=' . $userid);
			$criteria->order = 'id DESC';
			$start = '2018-01-1';
			$check = date('Y-m-d', strtotime("-1 days"));
			$criteria->addBetweenCondition("date",$start,$check);
			//$criteria->condition .= "AND communication IS NULL";
            



			$dataProvider = new CActiveDataProvider('Leads', array(
					'pagination' => array(
						'pageSize' =>50,
					),
					'criteria' => $criteria,
				));



			$allleads = Leads::model()->findAll($criteria);
$allleadscount = Leads::model()->Count(array('condition'=>'user_sales='.$userid));


			$criteria2 = new CDbCriteria;
$criteria2->addSearchCondition('date', $today, false);
$criteria2->addSearchCondition('user_sales', $userid, false);
			//$criteria2->condition = "close IS NULL ";

			$criteria2->addCondition('hidden=' . $visible);
			//$criteria2->addCondition('user_sales=' . $userid);
			//$criteria2->addCondition('duplicate IS NULL');

			//$criteria2->addSearchCondition('date' , $today);
			$criteria2->order = 'id DESC';
			$total2 = Leads::model()->count($criteria2);

			$pages2 = new CPagination($total2);
			$pages2->pageSize = 50;
			$pages2->applyLimit($criteria2);

			$allleads2 = Leads::model()->findAll($criteria2);



		
			$model = new Leads();
			$model->setScenario('com_porfile');
			if(isset($_POST['Leads'])){
			
				$rnd = rand(0,9999);
				$model->attributes = $_POST['Leads'];
				
				if(!empty($_POST['Leads']['platformchild_id']))
			    $model->platformchild_id=$_POST['Leads']['platformchild_id'];
				$model->user_id = $userid;
				$model->date = $today;
				$model->time = $time;
				$model->dtime = $time;
				$model->hidden = 1;
				$model->strategy_id = 1;
				$model->user_marketing = 1;
				$model->user_sales = $userid;
				$model->fresh_sales = $userid;
				
				
				if(!empty($_POST['Leads']['interest_id']) AND !empty($_POST['place'])){
                 Yii::app()->controller->refresh();
             }elseif(!empty($_POST['place'])){ 
                 $newplace=new interestedplace();
                 $newplace->title=$_POST['place'];
                 $newplace->date = $today;
                 $newplace->time = $time;
                 $newplace->user_id = $userid;
                 $newplace->save();
                 $model->interest_id=$newplace->id;
             }
             
             
				$name=$_POST['Leads']['tel'];
				$criteriaduplecat = new CDbCriteria();
				 $criteriaduplecat->addSearchCondition('tel', $name, false , 'OR');
    $criteriaduplecat->addSearchCondition('second_tel', $name, false , 'OR');
    $criteriaduplecat->addSearchCondition('tel3', $name, false , 'OR');
    $criteriaduplecat->addSearchCondition('tel4', $name, false , 'OR');
    //$criteriaduplecat->addSearchCondition('email', $email, false , 'OR'); 
    $allduplecat= Leads::model()->findAll($criteriaduplecat); 
    if(!empty($allduplecat)){
    
    Yii::app()->user->setFlash('success', "Cannot Proceed This Action Because Duplicate Leads ");
				Yii::app()->controller->refresh();
    
    }


                 ///////////////branch////////////
                $main=Mainsettings::model()->findByPk(1);
                if(!empty($main->default_branch) AND empty($model->branch))$model->branch=$main->default_branch;
                ///////////////branch////////////

				if($model->save()){
					$model->secert = $model->id;
					$model->save();
					
					
				


//notification to team leader





						
						
					$campaign = Campaign::model()->findByAttributes(array('id'=>$model->campaign_id));

					$lead = Leads::model()->findByAttributes(array('id'=>$model->id));

					$lead->strategy_id = $campaign->strategy_id;
					$lead->user_marketing = $campaign->user_id;
					$lead->save();

					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create Lead';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secert;
					$logsystem->user_id = $userid;
					$logsystem->save();


					Yii::app()->controller->refresh();
				}
			}

		
		
		
		
			$this->render('sales',array(
					'userid'=>$userid ,	
					'model'=>$model ,	
					'dataProvider' => $dataProvider ,		
					'allleads'=>$allleads ,	
					'pages2' => $pages2,		
					'allleads2'=>$allleads2 ,
					'allcampaign'=>$allcampaign,
					'allproject'=>$allproject,
					'allsales'=>$allsales,
					'allstatues'=>$allstatues,
					'allsubstatues'=>$allsubstatues,

					'allplatform'=>$allplatform,
					'allplaces'=>$allplaces,
					'allleadscount'=>$allleadscount,
					'allleadssales'=>$allleadssales,
					
					
					



				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
			




	public function actionMarketingsearch(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$today2=date("Y");
		
			$visible = 1;
		
			$allplatform = Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			//$allleads= Leads::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));

			$allplaces= Interestedplace::model()->findAll();
			$allstatues= Statues::model()->findAll();
			$allsubstatues= Substatus::model()->findAll();

			$criteria = new CDbCriteria;

			$criteria->condition = "close IS NULL ";
			//$criteria->addCondition('duplicate IS NULL');
			$criteria->addCondition('hidden=' . $visible);
			$criteria->addCondition('user_id=' . $userid);
			$criteria->order = 'id DESC';
			$start = '2018-01-1';
			$check = date('Y-m-d', strtotime("-1 days"));
			$criteria->addBetweenCondition("date",$start,$check);
			//$criteria->condition .= "AND communication IS NULL";
            



			$dataProvider = new CActiveDataProvider('Leads', array(
					'pagination' => array(
						'pageSize' =>50,
					),
					'criteria' => $criteria,
				));



			$allleads = Leads::model()->findAll($criteria);
$allleadscount = Leads::model()->Count(array('condition'=>'user_sales='.$userid));


			$criteria2 = new CDbCriteria;
$criteria2->addSearchCondition('date', $today, false);
$criteria2->addSearchCondition('user_id', $userid, false);
			//$criteria2->condition = "close IS NULL ";

			$criteria2->addCondition('hidden=' . $visible);
			//$criteria2->addCondition('user_sales=' . $userid);
			//$criteria2->addCondition('duplicate IS NULL');

			//$criteria2->addSearchCondition('date' , $today);
			$criteria2->order = 'id DESC';
			$total2 = Leads::model()->count($criteria2);

			$pages2 = new CPagination($total2);
			$pages2->pageSize = 50;
			$pages2->applyLimit($criteria2);

			$allleads2 = Leads::model()->findAll($criteria2);



		
			$model = new Leads();
			$model->setScenario('com_porfile');
			if(isset($_POST['Leads'])){
			
				$rnd = rand(0,9999);
				$model->attributes = $_POST['Leads'];
				
				if(!empty($_POST['Leads']['platformchild_id']))
			    $model->platformchild_id=$_POST['Leads']['platformchild_id'];
				$model->user_id = $userid;
				$model->date = $today;
				$model->time = $time;
				$model->dtime = $time;
				$model->hidden = 1;
				$model->strategy_id = 1;
				$model->user_marketing = 1;
				$model->user_sales = $userid;
				$model->fresh_sales = $userid;
				
				
				if(!empty($_POST['Leads']['interest_id']) AND !empty($_POST['place'])){
                 Yii::app()->controller->refresh();
             }elseif(!empty($_POST['place'])){ 
                 $newplace=new interestedplace();
                 $newplace->title=$_POST['place'];
                 $newplace->date = $today;
                 $newplace->time = $time;
                 $newplace->user_id = $userid;
                 $newplace->save();
                 $model->interest_id=$newplace->id;
             }
             
             
				$name=$_POST['Leads']['tel'];
				$criteriaduplecat = new CDbCriteria();
				 $criteriaduplecat->addSearchCondition('tel', $name, false , 'OR');
    $criteriaduplecat->addSearchCondition('second_tel', $name, false , 'OR');
    $criteriaduplecat->addSearchCondition('tel3', $name, false , 'OR');
    $criteriaduplecat->addSearchCondition('tel4', $name, false , 'OR');
    //$criteriaduplecat->addSearchCondition('email', $email, false , 'OR'); 
    $allduplecat= Leads::model()->findAll($criteriaduplecat); 
    if(!empty($allduplecat)){
    
    Yii::app()->user->setFlash('success', "Cannot Proceed This Action Because Duplicate Leads ");
				Yii::app()->controller->refresh();
    
    }


                 ///////////////branch////////////
                $main=Mainsettings::model()->findByPk(1);
                if(!empty($main->default_branch) AND empty($model->branch))$model->branch=$main->default_branch;
                ///////////////branch////////////

				if($model->save()){
					$model->secert = $model->id;
					$model->save();
					
					
				


//notification to team leader





						
						
					$campaign = Campaign::model()->findByAttributes(array('id'=>$model->campaign_id));

					$lead = Leads::model()->findByAttributes(array('id'=>$model->id));

					$lead->strategy_id = $campaign->strategy_id;
					$lead->user_marketing = $campaign->user_id;
					$lead->save();

					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create Lead';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secert;
					$logsystem->user_id = $userid;
					$logsystem->save();


					Yii::app()->controller->refresh();
				}
			}

		
		
		
		
			$this->render('marketingsearch',array(
					'userid'=>$userid ,	
					'model'=>$model ,	
					'dataProvider' => $dataProvider ,		
					'allleads'=>$allleads ,	
					'pages2' => $pages2,		
					'allleads2'=>$allleads2 ,
					'allcampaign'=>$allcampaign,
					'allproject'=>$allproject,
					'allsales'=>$allsales,
					'allstatues'=>$allstatues,
					'allsubstatues'=>$allsubstatues,

					'allplatform'=>$allplatform,
					'allplaces'=>$allplaces,
					'allleadscount'=>$allleadscount,



				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}


		
	public function actionClosedforSales(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			$today2=date("Y");
		
$this->layout = '//layouts/systemcgridview';
			$visible = 1;
		
			$allplatform = Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			//$allleads= Leads::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));

			$allplaces= Interestedplace::model()->findAll();
			$allstatues= Statues::model()->findAll();
			$allsubstatues= Substatus::model()->findAll();

			$criteria = new CDbCriteria;

			$criteria->condition = "close IS NOT NULL ";
			//$criteria->addCondition('duplicate IS NULL');
			$criteria->addCondition('hidden=' . $visible);
			$criteria->addCondition('user_sales=' . $userid);
			$criteria->order = 'id DESC';
			$start = '2018-01-1';
			$check = date('Y-m-d', strtotime("-1 days"));
			//$criteria->addBetweenCondition("date",$start,$check);
			//$criteria->condition .= "AND communication IS NULL";
            



			$dataProvider = new CActiveDataProvider('Leads', array(
					'pagination' => array(
						'pageSize' =>50,
					),
					'criteria' => $criteria,
				));



			$allleads = Leads::model()->findAll($criteria);

 
 
			$this->render('closedforsales',array(
					'userid'=>$userid ,	
					'model'=>$model ,	
					'dataProvider' => $dataProvider ,		
					'allleads'=>$allleads ,	
					'pages2' => $pages2,		
					'allleads2'=>$allleads2 ,
					'allcampaign'=>$allcampaign,
					'allproject'=>$allproject,
					'allsales'=>$allsales,
					'allstatues'=>$allstatues,
					'allsubstatues'=>$allsubstatues,

					'allplatform'=>$allplatform,
					'allplaces'=>$allplaces,



				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}
			




	
	public function actionTransfered(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			
			
	    $this->layout = '//layouts/systemcgridview';

			$visible = 1;
			$transfer = 1;
            $communication = NULL;

		
		
		
		
        		
        
        $allnotcommunicationtransfersales=new Leads('notcommunicationtransfersales');
        $allnotcommunicationtransfersales->unsetAttributes();  // clear any default values
        if(isset($_GET['notcommunicationtransfersales'])){
        $allnotcommunicationtransfersales->attributes=$_GET['notcommunicationtransfersales'];
        }
        
        
        
        
        
        $allnotcommunicationtransfersalestoday=new Leads('notcommunicationtransfersalestoday');
        $allnotcommunicationtransfersalestoday->unsetAttributes();  // clear any default values
        if(isset($_GET['notcommunicationtransfersalestoday'])){
        $allnotcommunicationtransfersalestoday->attributes=$_GET['notcommunicationtransfersalestoday'];
        }




	  	$visible=1;
		$allcampaign= Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allstatues= Statues::model()->findAll();
		
			$allplaces= Interestedplace::model()->findAll();


			$this->render('notcommunicationtransfersalesgv',array(
					'userid'=>$userid ,    
					'pages'=>$pages,
			'allcampaign' => $allcampaign,	
			'allplatform' => $allplatform,	
			'allstatues' => $allstatues,	
			'allplaces' => $allplaces,
				'allnotcommunicationtransfersales' => $allnotcommunicationtransfersales,
					'allnotcommunicationtransfersalestoday' => $allnotcommunicationtransfersalestoday,
			
			



				));

		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);

		}

	}
	
	
	
	
		public function actionComments(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			
			
	    $this->layout = '//layouts/systemcgridview';

		
        
        $allcomments=new Comments('search');
        $allcomments->unsetAttributes();  // clear any default values
        if(isset($_GET['search'])){
        $allcomments->attributes=$_GET['search'];
        }
        
        
        
        
       


			$this->render('commentsgv',array(
			'allcomments' => $allcomments,

				));

		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);

		}

	}
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
				public function actionAllmention(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			
			
	    $this->layout = '//layouts/systemcgridview';

		
        
        $allmention=new Comments('allsearch');
        $allmention->unsetAttributes();  // clear any default values
        if(isset($_GET['allsearch'])){
        $allmention->attributes=$_GET['allsearch'];
        }
        
        
        
        
       


			$this->render('allmentiongv',array(
			'allmention' => $allmention,

				));

		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);

		}

	}
		
		
		
		
				public function actionMention(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			
			
	    $this->layout = '//layouts/systemcgridview';

		
        
        $allmention=new Mention('search');
        $allmention->unsetAttributes();  // clear any default values
        if(isset($_GET['search'])){
        $allmention->attributes=$_GET['search'];
        }
        
        
        
        
       


			$this->render('mentiongv',array(
			'allmention' => $allmention,

				));

		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);

		}

	}




	public function actionTransferfresh(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
			
			
	    $this->layout = '//layouts/systemcgridview';

			$visible = 1;
			$transfer = 1;
            $communication = NULL;

		
		
		
		
        		
        
        $allnotcommunicationtransfersales=new Leads('notcommunicationtransfersales');
        $allnotcommunicationtransfersales->unsetAttributes();  // clear any default values
        if(isset($_GET['notcommunicationtransfersales'])){
        $allnotcommunicationtransfersales->attributes=$_GET['notcommunicationtransfersales'];
        }
        
        
        
        
        
        $allnotcommunicationtransfersalestoday=new Leads('notcommunicationtransfersalestoday');
        $allnotcommunicationtransfersalestoday->unsetAttributes();  // clear any default values
        if(isset($_GET['notcommunicationtransfersalestoday'])){
        $allnotcommunicationtransfersalestoday->attributes=$_GET['notcommunicationtransfersalestoday'];
        }




	  	$visible=1;
		$allcampaign= Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allstatues= Statues::model()->findAll();
		
			$allplaces= Interestedplace::model()->findAll();


			$this->render('notcommunicationtransfersalefreshsgv',array(
					'userid'=>$userid ,    
					'pages'=>$pages,
			'allcampaign' => $allcampaign,	
			'allplatform' => $allplatform,	
			'allstatues' => $allstatues,	
			'allplaces' => $allplaces,
				'allnotcommunicationtransfersales' => $allnotcommunicationtransfersales,
					'allnotcommunicationtransfersalestoday' => $allnotcommunicationtransfersalestoday,
			
			



				));

		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);

		}

	}






	
	public function actionVisit($id){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

	


			$this->render('visit',array(
					'userid'=>$userid ,    
        



				));

		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);

		}

	}

















	
	public function actionReopen($secret){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
$user=User::model()->findByPk($userid);

			$model= Leads::model()->findByAttributes(array('secert'=>$secret));

$model->close=NULL;
$model->communication=NULL;
$model->reopen=1;
$model->reopen_date= $today;


$model->save();




//notification to sales



					
                                        $leader=User::model()->findByPk($model->user_sales);
					if(!empty($leader)){
						if(!empty($leader->player_id)){
							$content = array(
								"en" => $user->fname. ' ' .$user->lname. ' Opened '.$model->title 
							);
							
							$fields = array(
								'app_id' => "d55878ac-5a32-444a-90c8-d9a053cad61c",
								'include_player_ids' => array($leader->player_id),
								'data' => array("foo" => "bar"),
								'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->secert ,
								'contents' => $content
							);
							
							$fields = json_encode($fields);
					    			
							$ch = curl_init();
							curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
							curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
									'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
							curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
							curl_setopt($ch, CURLOPT_HEADER, FALSE);
							curl_setopt($ch, CURLOPT_POST, TRUE);
							curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
							curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

							$response = curl_exec($ch);
							curl_close($ch);
						}else{
						
						}



						if(!empty($leader->player_id_mobile)){
							$content = array(
								"en" => $user->fname. ' ' .$user->lname. ' Opened '.$model->title 
							);
							
							$fields = array(
								'app_id' => "d55878ac-5a32-444a-90c8-d9a053cad61c",
								'include_player_ids' => array($leader->player_id_mobile),
								'data' => array("foo" => "bar"),
								'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->secert ,
								'contents' => $content
							);
							
							$fields = json_encode($fields);
					    			
							$ch = curl_init();
							curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
							curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
									'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
							curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
							curl_setopt($ch, CURLOPT_HEADER, FALSE);
							curl_setopt($ch, CURLOPT_POST, TRUE);
							curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
							curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

							$response = curl_exec($ch);
							curl_close($ch);
						}else{
						
						}




					}




						$this->redirect(array('leads/profile/'.$model->secert)	);
	


			

		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);

		}

	}







	
	
	
	
	
	

public function actionNextactivitiestransfer(){
	if(Yii::app()->user->isMember()){

		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		$criteria = new CDbCriteria;
		$criteria->condition = "close IS NULL && too IS NOT NULL ";
		$criteria->addCondition('too=' . $userid);
		$criteria->order = 'follow_date DESC';
		//$start = '2018-01-1';
		//$check = date('Y-m-d', strtotime("-1 days"));
		
		$check = '3000-01-01';
$start = date('Y-m-d', strtotime("+1 days"));
//$start = date("Y-m-d");
		$criteria->addBetweenCondition("follow_date",$start,$check);
		$allstatues=Statues::model()->findAll(); 
        
		$dataProvider = new CActiveDataProvider('Activities', array(
				'pagination' => array(
					'pageSize' =>50,
				),
				'criteria' => $criteria,
			));




            





	



		if(isset($_POST['Activities'])){
				$secert=$_POST['secert'];
				$uniqid=$_POST['code'];
				$model= Activities::model()->findByAttributes(array('id'=>$secert));
				$model->report=$_POST['Activities']['report'];
				$model->close=1;
				$model->confirm=1;
			    $model->save();
				
				
				
				$criteria = new CDbCriteria;
		       $criteria->addCondition('close IS NULL');
	      	$criteria->addSearchCondition('leads_id', $model->leads_id, false, 'AND');
	       	$allopenactivities= Activities::model()->findAll($criteria);

					if(!empty($allopenactivities)){
						foreach($allopenactivities as $openactivities){	
						    
						    
				$openactivities->close=1;
				$openactivities->confirm=1;
				$openactivities->save();
						    
						    
						}
						
					}

				$newmodel=new Activities();
				$newmodel->user_id = $userid;
				$newmodel->date = $today;
				$newmodel->details= $_POST['Activities']['report'];
				$newmodel->follow_date= $_POST['Activities']['follow_date'];
				$newmodel->follow_time= $_POST['Activities']['follow_time'];
				$newmodel->status= $_POST['Activities']['status'];
				$newmodel->type= $_POST['Activities']['type'];
				$newmodel->time = $time;
				$newmodel->code= $uniqid;

				$lead=Leads::model()->findByPk($model->leads_id);
                                $lead->sales_report=$_POST['Activities']['report'];
                                $lead->communicate_time=$time;
                                $lead->communicate_date=$today;
                                $lead->communication=1;
                                 if(empty($lead->first_communication)){
                $lead->first_communication=$userid;
                }
				

$lead->follow_date=$newmodel->follow_date;                              
$lead->follow_time=$newmodel->follow_time;
$lead->action_time=$newmodel->time;


                                
                                $lead->checkup_activity=$today;
                                $lead->status=$_POST['Activities']['status'];
                                
                              
                                
                                $lead->save();
                                
                                
                
                
				$newmodel->name=$lead->title;
				$newmodel->tel=$lead->tel;
				$newmodel->coldcall=$lead->coldcall;
                $newmodel->indirect=$lead->indirect;
				
				$newmodel->lead_date=$lead->date;

				$newmodel->leads_id = $model->leads_id;
				$newmodel->secert = $rnd.$userid;

				if($newmodel->save()){

					$newmodel->secert=$newmodel->id;
					$newmodel->save();


							
							
					if(!empty($_POST['Activities']['status'])){
						$lead=Leads::model()->findByPk($model->leads_id);
						$lead->status=$_POST['Activities']['status'];
						$lead->save();
					}
					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create Activities';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secert;
					$logsystem->user_id = $userid;
					$logsystem->save();

                    //add best sales
                    $userid=Yii::app()->user->id;
                	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
                	$today = date("Y-m-d");
                    $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
                    if(!empty($best)){
                        $best->actnum+=1;
                        $best->save();
                    }else{
                        $best =new Bestsales();
                        $best->user_sales=$userid;
                        $best->date=$today;
                        $best->actnum=1;
                        $best->save();
                    }
                    //add bestsales
					
					$this->redirect(array('leads/profile/'.$model->leads_id)	);
				}else{
					$this->redirect(array('leads/profile/'.$model->leads_id)	);
				}
			
		
		    
		}



		$this->render('nextactivitiestransfer',array(
				'userid'=>$userid ,	
				'model'=>$model ,	
				'dataProvider' => $dataProvider,		
				'allstatues'=>$allstatues,



			));


	}


	else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);

	}

}



	

public function actionNextactivities(){
	if(Yii::app()->user->isMember()){

		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		$criteria = new CDbCriteria;
		$criteria->condition = "close IS NULL && too IS NULL && broker_id IS NULL  && coldcall IS NULL ";
		
		
		
$this->layout = '//layouts/systemcgridview';
		
$agent=User::model()->findByPk($userid);
if($agent->sales ==1 or $agent->telesales ==1 ){
$criteria->addCondition('user_id=' . $userid);
}else{

$criteria->addCondition('marketing_id=' . $userid);


}   
		
		
		$criteria->order = 'follow_date DESC';
		//$start = '2018-01-1';
		//$check = date('Y-m-d', strtotime("-1 days"));
		
		$check = '3000-01-01';
$start = date('Y-m-d', strtotime("+1 days"));
//$start = date("Y-m-d");
		$criteria->addBetweenCondition("follow_date",$start,$check);
		$allstatues=Statues::model()->findAll(); 
        
		$dataProvider = new CActiveDataProvider('Activities', array(
				'pagination' => array(
					'pageSize' =>50,
				),
				'criteria' => $criteria,
			));




            





	



		if(isset($_POST['Activities'])){
				$secert=$_POST['secert'];
				$uniqid=$_POST['code'];
				$model= Activities::model()->findByAttributes(array('id'=>$secert));
				$model->report=$_POST['Activities']['report'];
				$model->close=1;
				$model->confirm=1;
			    $model->save();
				
				
				
				$criteria = new CDbCriteria;
		       $criteria->addCondition('close IS NULL');
	      	$criteria->addSearchCondition('leads_id', $model->leads_id, false, 'AND');
	       	$allopenactivities= Activities::model()->findAll($criteria);

					if(!empty($allopenactivities)){
						foreach($allopenactivities as $openactivities){	
						    
						    
				$openactivities->close=1;
				$openactivities->confirm=1;
				$openactivities->save();
						    
						    
						}
						
					}

				$newmodel=new Activities();
				$newmodel->user_id = $userid;
				$newmodel->date = $today;
				$newmodel->details= $_POST['Activities']['report'];
				$newmodel->follow_date= $_POST['Activities']['follow_date'];
				$newmodel->follow_time= $_POST['Activities']['follow_time'];
				$newmodel->status= $_POST['Activities']['status'];
				$newmodel->type= $_POST['Activities']['type'];
				$newmodel->time = $time;
				$newmodel->code= $uniqid;

				$lead=Leads::model()->findByPk($model->leads_id);
                                $lead->sales_report=$_POST['Activities']['report'];
                                $lead->communicate_time=$time;
                                $lead->communicate_date=$today;
                                $lead->communication=1;
                                 if(empty($lead->first_communication)){
                $lead->first_communication=$userid;
                }

$lead->follow_date=$newmodel->follow_date;                               
$lead->follow_time=$newmodel->follow_time;
$lead->action_time=$newmodel->time;

			
                                $lead->checkup_activity=$today;
                                $lead->status=$_POST['Activities']['status'];
                                $lead->save();
				$newmodel->name=$lead->title;
				$newmodel->tel=$lead->tel;
				$newmodel->coldcall=$lead->coldcall;
                $newmodel->indirect=$lead->indirect;
            	$newmodel->lead_date=$lead->date;
				$newmodel->leads_id = $model->leads_id;
				$newmodel->secert = $rnd.$userid;

				if($newmodel->save()){

					$newmodel->secert=$newmodel->id;
					$newmodel->save();


							
							
					if(!empty($_POST['Activities']['status'])){
						$lead=Leads::model()->findByPk($model->leads_id);
						$lead->status=$_POST['Activities']['status'];
						$lead->save();
					}
					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create Activities';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secert;
					$logsystem->user_id = $userid;
					$logsystem->save();


					//add best sales
                    $userid=Yii::app()->user->id;
                	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
                	$today = date("Y-m-d");
                    $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
                    if(!empty($best)){
                        $best->actnum+=1;
                        $best->save();
                    }else{
                        $best =new Bestsales();
                        $best->user_sales=$userid;
                        $best->date=$today;
                        $best->actnum=1;
                        $best->save();
                    }
                    //add bestsales
					$this->redirect(array('leads/profile/'.$model->leads_id)	);
				}else{
					$this->redirect(array('leads/profile/'.$model->leads_id)	);
				}
			
		
		    
		}



		$this->render('nextactivities',array(
				'userid'=>$userid ,	
				'model'=>$model ,	
				'dataProvider' => $dataProvider,		
				'allstatues'=>$allstatues,



			));


	}


	else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);

	}

}




public function actionNextactivitiescold(){
	if(Yii::app()->user->isMember()){

		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		$criteria = new CDbCriteria;
		$criteria->condition = "close IS NULL && too IS NULL && broker_id IS NULL && coldcall IS NOT NULL ";
		$criteria->addCondition('user_id=' . $userid);
		$criteria->order = 'follow_date DESC';
		//$start = '2018-01-1';
		//$check = date('Y-m-d', strtotime("-1 days"));
		
		$check = '3000-01-01';
$start = date('Y-m-d', strtotime("+1 days"));
//$start = date("Y-m-d");
		$criteria->addBetweenCondition("follow_date",$start,$check);
		$allstatues=Statues::model()->findAll(); 
        
		$dataProvider = new CActiveDataProvider('Activities', array(
				'pagination' => array(
					'pageSize' =>50,
				),
				'criteria' => $criteria,
			));




            





	



		if(isset($_POST['Activities'])){
				$secert=$_POST['secert'];
				$uniqid=$_POST['code'];
				$model= Activities::model()->findByAttributes(array('id'=>$secert));
				$model->report=$_POST['Activities']['report'];
				$model->close=1;
				$model->confirm=1;
			    $model->save();
				
				
				
				$criteria = new CDbCriteria;
		       $criteria->addCondition('close IS NULL');
	      	$criteria->addSearchCondition('leads_id', $model->leads_id, false, 'AND');
	       	$allopenactivities= Activities::model()->findAll($criteria);

					if(!empty($allopenactivities)){
						foreach($allopenactivities as $openactivities){	
						    
						    
				$openactivities->close=1;
				$openactivities->confirm=1;
				$openactivities->save();
						    
						    
						}
						
					}

				$newmodel=new Activities();
				$newmodel->user_id = $userid;
				$newmodel->date = $today;
				$newmodel->details= $_POST['Activities']['report'];
				$newmodel->follow_date= $_POST['Activities']['follow_date'];
				$newmodel->follow_time= $_POST['Activities']['follow_time'];
				$newmodel->status= $_POST['Activities']['status'];
				$newmodel->type= $_POST['Activities']['type'];
				$newmodel->time = $time;
				$newmodel->code= $uniqid;

				$lead=Leads::model()->findByPk($model->leads_id);
                                $lead->sales_report=$_POST['Activities']['report'];
                                $lead->communicate_time=$time;
                                $lead->communicate_date=$today;
                                $lead->communication=1;
                                 if(empty($lead->first_communication)){
                $lead->first_communication=$userid;
                }

$lead->follow_date=$newmodel->follow_date;                                 
$lead->follow_time=$newmodel->follow_time;
$lead->action_time=$newmodel->time;

			
                                $lead->checkup_activity=$today;
                                $lead->status=$_POST['Activities']['status'];
                                $lead->save();
				$newmodel->name=$lead->title;
				$newmodel->tel=$lead->tel;
				$newmodel->coldcall=$lead->coldcall;
                $newmodel->indirect=$lead->indirect;
            	$newmodel->lead_date=$lead->date;
				$newmodel->leads_id = $model->leads_id;
				$newmodel->secert = $rnd.$userid;

				if($newmodel->save()){

					$newmodel->secert=$newmodel->id;
					$newmodel->save();


							
							
					if(!empty($_POST['Activities']['status'])){
						$lead=Leads::model()->findByPk($model->leads_id);
						$lead->status=$_POST['Activities']['status'];
						$lead->save();
					}
					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create Activities';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secert;
					$logsystem->user_id = $userid;
					$logsystem->save();


					//add best sales
                    $userid=Yii::app()->user->id;
                	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
                	$today = date("Y-m-d");
                    $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
                    if(!empty($best)){
                        $best->actnum+=1;
                        $best->save();
                    }else{
                        $best =new Bestsales();
                        $best->user_sales=$userid;
                        $best->date=$today;
                        $best->actnum=1;
                        $best->save();
                    }
                    //add bestsales
					$this->redirect(array('leads/profile/'.$model->leads_id)	);
				}else{
					$this->redirect(array('leads/profile/'.$model->leads_id)	);
				}
			
		
		    
		}



		$this->render('nextactivitiescold',array(
				'userid'=>$userid ,	
				'model'=>$model ,	
				'dataProvider' => $dataProvider,		
				'allstatues'=>$allstatues,



			));


	}


	else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);

	}

}




public function actionPerformance(){
	if(Yii::app()->user->isMember()){

		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
	
  

		$this->render('performance',array(
				'userid'=>$userid ,	
				



			));


	}


	else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);

	}

}


public function actionActivitiestransfer(){
	if(Yii::app()->user->isMember()){

		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		$criteria = new CDbCriteria;
		$criteria->condition = "close IS NULL && too IS NOT NULL && broker_id IS NULL"; 
		$criteria->addCondition('too=' . $userid);
		$criteria->order = 'follow_date DESC';
		$start = '2018-01-1';
		$check = date('Y-m-d', strtotime("-1 days"));
		$criteria->addBetweenCondition("follow_date",$start,$check);
		$allstatues=Statues::model()->findAll(); 
        
        
        
        
        if($_REQUEST['cold']==1){


				$criteria->addSearchCondition('coldcall', $_REQUEST['cold'],false, "AND");
			}else if($_REQUEST['cold']==2){



				$criteria->addCondition('coldcall IS NULL');
			}else{
			}
			
			
			
		$dataProvider = new CActiveDataProvider('Activities', array(
				'pagination' => array(
					'pageSize' =>50,
				),
				'criteria' => $criteria,
			));




            





	



		if(isset($_POST['Activities'])){
				$secert=$_POST['secert'];
				$uniqid=$_POST['code'];
				$model= Activities::model()->findByAttributes(array('id'=>$secert));
				$model->report=$_POST['Activities']['report'];
				$model->close=1;
				
				
if($_POST['sucess'] == 1){
$model->confirm=1;
}else{
    
$model->confirm=3;
    
    
}
				
				$model->save();
				
				if($model->save()){
				
				$criteria = new CDbCriteria;
		       $criteria->addCondition('close IS NULL OR report IS NULL ');
	      	$criteria->addSearchCondition('leads_id', $model->leads_id, false, 'AND');
	       	$allopenactivities= Activities::model()->findAll($criteria);

					if(!empty($allopenactivities)){
						foreach($allopenactivities as $openactivities){	
						    
						    
				$openactivities->close=1;
				$openactivities->report=$model->report;
				$openactivities->save();
						    
						    
						}
						
					}
					
					
					
				}

				$newmodel=new Activities();
				$newmodel->user_id = $userid;
				$newmodel->date = $today;
				$newmodel->details= $_POST['Activities']['report'];
				$newmodel->follow_date= $_POST['Activities']['follow_date'];
				$newmodel->follow_time= $_POST['Activities']['follow_time'];
				$newmodel->status= $_POST['Activities']['status'];
				$newmodel->substatus= $_POST['Activities']['substatus'];

				$newmodel->type= $_POST['Activities']['type'];
				$newmodel->time = $time;
				$newmodel->code= $uniqid;

				$lead=Leads::model()->findByPk($model->leads_id);
                                $lead->sales_report=$_POST['Activities']['report'];
                                $lead->communicate_time=$time;
                                $lead->communicate_date=$today;
                                $lead->communication=1;
                                 if(empty($lead->first_communication)){
                $lead->first_communication=$userid;
                }

$lead->follow_date=$newmodel->follow_date;                                
$lead->follow_time=$newmodel->follow_time;
$lead->action_time=$newmodel->time;

				
                                $lead->checkup_activity=$today;
                                $lead->status=$_POST['Activities']['status'];
                                $lead->substatus=$_POST['Activities']['substatus'];
                                $lead->save();
				$newmodel->name=$lead->title;
				$newmodel->tel=$lead->tel;
				$newmodel->coldcall=$lead->coldcall;
                $newmodel->indirect=$lead->indirect;
                $newmodel->lead_date=$lead->date;
				$newmodel->leads_id = $model->leads_id;
				$newmodel->secert = $rnd.$userid;

				if($newmodel->save()){

					$newmodel->secert=$newmodel->id;
					$newmodel->save();




					$allsalesmanger=User::model()->findAll(array('condition'=>'salesmanger=1 AND player_id IS NOT NULL'));

					if(!empty($allsalesmanger)){
						foreach($allsalesmanger as $sales){	
							$content = array(
								"en" => $newmodel->employee->fname. ' ' .$model->employee->lname. ' reported to '.$model->client->title.' with '.$model->report 
							);
							$url= Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->leads_id ;
							$playerid=$sales->player_id;
							$this->notification($content,$playerid,$url);
						}
					}


					$allsalesmanger=User::model()->findAll(array('condition'=>'salesmanger=1 AND player_id_mobile IS NOT NULL'));

					if(!empty($allsalesmanger)){
						foreach($allsalesmanger as $sales){	
							$content = array(
								"en" => $newmodel->employee->fname. ' ' .$model->employee->lname. ' reported to '.$model->client->title.' with '.$model->report 
							);
							$url= Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->leads_id ;
							$playerid=$sales->player_id_mobile;
							$this->notification($content,$playerid,$url);
						}
					}

					


					//notification to team leader




					$criteria = new CDbCriteria;
					$criteria->addCondition('sales_id=' . $model->employee->id);
					$leader=Teamleader::model()->find($criteria);
					$leader=User::model()->findByPk($leader->leader_id);
					if(!empty($leader->player_id)){ 
						$content = array(
							"en" => $newmodel->employee->fname. ' ' .$newmodel->employee->lname. ' reported to '.$newmodel->client->title.' with '.$model->report
						);
						$url= Yii::app()->getBaseUrl(true).'/leads/profile/'.$newmodel->client->secert ;
						$playerid=$leader->player_id;
						$this->notification($content,$playerid,$url);
					}
					if(!empty($leader->player_id_mobile)){ 
						$content = array(
							"en" => $newmodel->employee->fname. ' ' .$newmodel->employee->lname. ' reported to '.$newmodel->client->title.' with '.$model->report
						);
						$url= Yii::app()->getBaseUrl(true).'/leads/profile/'.$newmodel->client->secert ;
						$playerid=$leader->player_id_mobile;
						$this->notification($content,$playerid,$url);
					}


					





							
							
							
					if(!empty($_POST['Activities']['status'])){
						$lead=Leads::model()->findByPk($model->leads_id);
						$lead->status=$_POST['Activities']['status'];
						$lead->save();
					}
					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create Activities';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secert;
					$logsystem->user_id = $userid;
					$logsystem->save();


					//add best sales
                    $userid=Yii::app()->user->id;
                	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
                	$today = date("Y-m-d");
                    $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
                    if(!empty($best)){
                        $best->actnum+=1;
                        $best->save();
                    }else{
                        $best =new Bestsales();
                        $best->user_sales=$userid;
                        $best->date=$today;
                        $best->actnum=1;
                        $best->save();
                    }
                    //add bestsales
                    
					$this->redirect(array('leads/profile/'.$model->leads_id)	);
				}else{
					$this->redirect(array('leads/profile/'.$model->leads_id)	);
				}
			
		
		    
		}



		$this->render('activitiestransfer',array(
				'userid'=>$userid ,	
				'model'=>$model ,	
				'dataProvider' => $dataProvider,		
				'allstatues'=>$allstatues,



			));


	}


	else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);

	}

}



public function actionActivities(){
	if(Yii::app()->user->isMember()){

		$userid=Yii::app()->user->id;
		
		$user= User::model()->findByAttributes(array('id'=>$userid));
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		$criteria = new CDbCriteria;
		$criteria->condition = "close IS NULL && too IS NULL ";
		$criteria->addCondition('user_id=' . $userid);
		$criteria->order = 'follow_date DESC';
		$start = '2018-01-1';
		$check = date('Y-m-d', strtotime("-1 days"));
		$criteria->addBetweenCondition("follow_date",$start,$check);
		$allstatues=Statues::model()->findAll(); 
        
$this->layout = '//layouts/systemcgridview';
		$dataProvider = new CActiveDataProvider('Activities', array(
				'pagination' => array(
					'pageSize' =>50,
				),
				'criteria' => $criteria,
			));




            





	



		if(isset($_POST['Activities'])){
				$secert=$_POST['secert'];
				$uniqid=$_POST['code'];
				$model= Activities::model()->findByAttributes(array('id'=>$secert));
				$model->report=$_POST['Activities']['report'];
				$model->close=1;
				
				
if($_POST['sucess'] == 1){
$model->confirm=1;
}else{
    
$model->confirm=3;
    
    
}




				
			
				
				if($model->save()){
				    
				    
					ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');    
				
				$criteriaopenx = new CDbCriteria;
		       $criteriaopenx->addCondition('close IS NULL OR report IS NULL ');
	      	$criteriaopenx->addSearchCondition('leads_id', $model->leads_id, false, 'AND');
	       	$allopenactivities= Activities::model()->findAll($criteriaopenx);

					if(!empty($allopenactivities)){
						foreach($allopenactivities as $openactivities){	
						    
						    
				$openactivities->close=1;
				$openactivities->report=$model->report;
				$openactivities->save();
						    
						    
						}
						
					}
					
					
					
				$newmodel=new Activities();
				$lead=Leads::model()->findByPk($model->leads_id);

				$newmodel->user_id = $lead->user_sales;
				$newmodel->marketing_id = $lead->user_id;
				$newmodel->date = $today;
				$newmodel->details= $_POST['Activities']['report'];
				$newmodel->follow_date= $_POST['Activities']['follow_date'];
				$newmodel->follow_time= $_POST['Activities']['follow_time'];
				$newmodel->status= $_POST['Activities']['status'];
				$newmodel->substatus= $_POST['Activities']['substatus'];
				$newmodel->type= $_POST['Activities']['type'];
				$newmodel->star= $_POST['Activities']['star'];
				$newmodel->time = $time;
				$newmodel->code= $uniqid;
				
				//check for salesmanger or teamleader
                if($user->salesmanger ==1 or $user->teamleader ==1 ){
                   $newmodel->manger_id=$user->id; 
                }
    			//check for salesmanger or teamleader
				
		

				

                                $lead->sales_report=$_POST['Activities']['report'];
                                $lead->communicate_time=$time;
                                $lead->communicate_date=$today;
                                $lead->communication=1;
                                 if(empty($lead->first_communication)){
                $lead->first_communication=$userid;
                }

$lead->follow_date=$newmodel->follow_date;                                 
$lead->follow_time=$newmodel->follow_time;
$lead->action_time=$newmodel->time;

				
                                $lead->checkup_activity=$today;
                                $lead->visitactive=NULL;
                               $lead->details= $lead->details.'  /  '.$today.' '.$_POST['Activities']['report'];
                               
                               
                        
                        if($_POST['Activities']['status'] != $lead->status ){
                        $lead->status_date=$today; 
                        }
                               
                               $lead->status=$_POST['Activities']['status'];

                                 
                                $qualifiedtest=Statues::model()->findByPk($_POST['Activities']['status']);
                                
              
                                 
                                  if($qualifiedtest->close == 1){                
                $lead->close=1;
				$lead->reopen=NULL;
				$lead->communication=1;
								$lead->visitactive=NULL;

				 if(empty($lead->first_communication)){
                $lead->first_communication=$userid;
                }
				$lead->close_date= $today;
				$newmodel->report= 'Closed In '.$today.'-'.$_POST['Activities']['report'];
				$newmodel->close= 1;

				//$lead->save();
                }
                
                
                
                
                 if($qualifiedtest->client == 1){                
                $lead->close=1;
				$lead->reopen=NULL;
				$lead->communication=1;
								$lead->visitactive=NULL;

				 if(empty($lead->first_communication)){
                $lead->first_communication=$userid;
                }
				$lead->close_date= $today;
				$newmodel->report= 'Closed In '.$today.'-'.$_POST['Activities']['report'];
				$newmodel->close= 1;

				//$lead->save();
                }
                
                
                
                
                 $main=Mainsettings::model()->findByPk(1);
    
                if($qualifiedtest->visit == 1){
                    if($main->createvisitauto == 1){
                    
                    
                $visit=new Visit();
				$visit->date=$today;
				$visit->lead_id=$lead->id;
				$visit->user_id=$userid;
				$visit->lead_date=$lead->date;
				$visit->code= $uniqid;
				$visit->details=$_POST['Activities']['report'];
				$visit->dateaction=$today;
				$visit->timeaction=$time;
				$visit->from_time=$time;
				$visit->to_time=$time;

				$visit->save();
				
					if(!$visit->save()){
				     var_dump($visit->getErrors());
					}
                    
                }
                }
                                
                
                if($qualifiedtest->qualified == 1){
                $lead->qualified=1;
                
                if(empty($lead->first_classification)){
                    
                $lead->first_classification=1;
                $lead->first_classification_user=$userid; 
                    
                }
                
                
                }
                
                
                if($qualifiedtest->nonqualified == 1){
                $lead->nonqualified=1;
                
                
                if(empty($lead->first_classification)){
                    
                $lead->first_classification=2;
                $lead->first_classification_user=$userid; 
                    
                }
                
                }
                
                
                
                 if($_POST['Activities']['substatus'] != $lead->substatus ){
                        $lead->substatus_date=$today; 
                        }

                                $lead->substatus=$_POST['Activities']['substatus'];
                                
                                
                                
                        
                        
                        
                        
                           $status=Statues::model()->findByPk($_POST['Activities']['status']);
                           
                      
                 if($status->answer == 1){
                     
                     //var_dump($status);exit;
                $lead->answer=1;
				$newmodel->answer=1;
                }
                
                
                if($status->answer == 2){
                    
                                               

                $lead->answer=2;
				$newmodel->answer=2;
                }         
                       
                                
                                
                           $substatus=Substatus::model()->findByPk($_POST['Activities']['substatus']);
                      
                 if($substatus->answer == 1){
                $lead->answer=1;
				$newmodel->answer=1;
                }
                
                
                if($substatus->answer == 2){
                $lead->answer=2;
				$newmodel->answer=2;
                }
                
                
              
                
                
                                    
   if($substatus->expvisit == 1){
       $lead->expvisit=1;
                $newmodel->expvisit=1;
                }
                
                
                
                   if($substatus->callback == 1){
                 $lead->callback=1;
                $newmodel->callback=1;
                }
                
                
                
                
                                $lead->save();
				$newmodel->name=$lead->title;
				$newmodel->tel=$lead->tel;
				$newmodel->coldcall=$lead->coldcall;
                $newmodel->indirect=$lead->indirect;
				$newmodel->lead_date= $lead->date;

				$newmodel->leads_id = $model->leads_id;
				$newmodel->secert = $rnd.$userid;

				if($newmodel->save()){

					$newmodel->secert=$newmodel->id;
					$newmodel->save();
					
					
					
				}

			


 if($newmodel->save()){



					$allsalesmangernotfie=User::model()->findAll(array('condition'=>'salesmanger=1 AND level=1'));
					if(!empty($allsalesmangernotfie)){
						foreach($allsalesmangernotfie as $sales){






$criteria = new CDbCriteria();         
		$criteria->order = 'id DESC';
        $criteria->limit = 1;
		$criteria->addSearchCondition('userid', $sales->id, false);
		$vars= FirebaseToken::model()->findAll($criteria);

$arr=array();
if(!empty($vars)){
			foreach($vars as $var){
				
				
				
				
//mobileapp				
				
$main=Mainsettings::model()->findByPk(1);
define('API_ACCESS_KEY','AAAAGI2_AAk:APA91bEeKC-ZyZRoMMAF7fUXoSmkyDwhjjYafH5Cx0qqFOqeCg09g3o6Q_9mYy9ta0RTgSRlp_-nYZkdFbD5v2yE_nUafV5OHo1_p04x2xDWVMFc9YPVZ3wYfvmUvIhObAKMZUv4E3Em');
 $fcmUrl = 'https://fcm.googleapis.com/fcm/send';
 $token=$var->token;

    $notification = [
            'title' =>'Action',
            'body' => $newmodel->employee->fname. ' ' .$newmodel->employee->lname. ' reported to '.$model->client->title.' with '.$model->report ,
            'icon' =>'myIcon', 
            'sound' => 'mySound'
        ];
        $extraNotificationData = ["message" => $notification,"moredata" =>'dd'];

        $fcmNotification = [
            //'registration_ids' => $tokenList, //multple token array
            'to'        => $token, //single token
            'notification' => $notification,
            'data' => $extraNotificationData
        ];

        $headers = [
            'Authorization: key=' . API_ACCESS_KEY,
            'Content-Type: application/json'
        ];


        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$fcmUrl);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fcmNotification));
        $result = curl_exec($ch);
        curl_close($ch);
				
				
				
				
				
				
				
				
				
				
				
			}

}





}
}

				


					//notification to team leader

/*


					$criteria = new CDbCriteria;
					$criteria->addCondition('sales_id=' . $model->employee->id);
					$leader=Teamleader::model()->find($criteria);
					$leader=User::model()->findByPk($leader->leader_id);
					if(!empty($leader->player_id)){ 
						$content = array(
							"en" => $newmodel->employee->fname. ' ' .$newmodel->employee->lname. ' reported to '.$newmodel->client->title.' with '.$model->report
						);
						$url= Yii::app()->getBaseUrl(true).'/leads/profile/'.$newmodel->client->secert ;
						$playerid=$leader->player_id;
						$this->notification($content,$playerid,$url);
					}
					if(!empty($leader->player_id_mobile)){ 
						$content = array(
							"en" => $newmodel->employee->fname. ' ' .$newmodel->employee->lname. ' reported to '.$newmodel->client->title.' with '.$model->report
						);
						$url= Yii::app()->getBaseUrl(true).'/leads/profile/'.$newmodel->client->secert ;
						$playerid=$leader->player_id_mobile;
						$this->notification($content,$playerid,$url);
					}
*/

					

	}



	if($newmodel->save()){						
							
							
					if(!empty($_POST['Activities']['status'])){
						$lead=Leads::model()->findByPk($model->leads_id);
						$lead->status=$_POST['Activities']['status'];
						$lead->save();
					}
					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create Activities';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secert;
					$logsystem->user_id = $userid;
					$logsystem->save();

                    
                    //add best sales
                    $userid=Yii::app()->user->id;
                	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
                	$today = date("Y-m-d");
                    $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
                    if(!empty($best)){
                        $best->actnum+=1;
                        $best->save();
                    }else{
                        $best =new Bestsales();
                        $best->user_sales=$userid;
                        $best->date=$today;
                        $best->actnum=1;
                        $best->save();
                    }
                    //add bestsales
                    
                     //notification to team leaders AND Salesmanger
                    $allsalesmanger=User::model()->findAll(array('condition'=>'salesmanger=1 AND level=1 AND activitiesnotifi=1 '));
                    $arr=array();
    				foreach($allsalesmanger as $sales){	
    				    $arr[]=$sales->id;
    				}
    				$criteria = new CDbCriteria;
    				$criteria->addCondition('sales_id=' . $lead->user_sales);
    				$leaders=Teamleader::model()->findAll($criteria); 
    				if(!empty($leaders)){
    				    foreach($leaders as $teamlleader){
    				        $arr[]=$teamlleader->leader_id;
    				    }
    				}
    				
                    $criteria = new CDbCriteria();         
            		$criteria->order = 'id DESC';
            		$criteria->addInCondition('userid',$arr);
            		$vars= FirebaseToken::model()->findAll($criteria);
                    
                    $arr=array();
                    if(!empty($vars)){
                    			foreach($vars as $var){
                        			$arr[]=$var->token;
                    			}
                    
                    } 
    				$man=User::model()->findByPk($userid);
    	 
                    $main=Mainsettings::model()->findByPk(1);
                    $iconurl=Yii::app()->getBaseUrl(true).'/img/'.$main->logo;
                    $fields = array(
                            'registration_ids' =>  $arr ,
                            'data' => array( "title" => " Activities ", "body" => $lead->title." Has a New Activity Written By :  ".$man->username  ,"icon" => $iconurl , "click_action" => Yii::app()->getBaseUrl(true).'/leads/profile/'.$lead->id),
                        );
                    $url = 'https://fcm.googleapis.com/fcm/send';
    
                    $headers = array(
                        'Authorization: key='.$main->appkey ,
                        'Content-Type: application/json'
                    );
                    // Open connection
                    $ch = curl_init();
                
                    // Set the url, number of POST vars, POST data
                    curl_setopt($ch, CURLOPT_URL, $url);
                
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                
                    // Disabling SSL Certificate support temporarly
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
                
                    // Execute post
                    $result = curl_exec($ch);
                    // echo "Result".$result;
                    if ($result === FALSE) {
                        die('Curl failed: ' . curl_error($ch));
                    }
                
                    // Close connection
                    curl_close($ch); 
                    
                    
					
					$this->redirect(array('leads/profile/'.$model->leads_id)	);
					
	}		
					
				}else{
					$this->redirect(array('leads/profile/'.$model->leads_id)	);
				}



//var_dump($model->leads_id);

$criteriaerror = new CDbCriteria;
$criteriaerror->order = 'id DESC';
$criteriaerror->limit = 1;


$criteriaerror->addSearchCondition('leads_id', $model->leads_id, false, 'AND');
	       	$allopenactivitieserror = Activities::model()->findAll($criteriaerror);

					if(!empty($allopenactivitieserror)){
						foreach($allopenactivitieserror as $openactivitieserror){	
						    
						    
				$openactivitieserror->close=NULL;
				$openactivitieserror->report=NULL;
				$openactivitieserror->save();
						    
						    
						}
						
					}

        		    //add best sales
                    $userid=Yii::app()->user->id;
                	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
                	$today = date("Y-m-d");
                    $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
                    if(!empty($best)){
                        $best->actnum+=1;
                        $best->save();
                    }else{
                        $best =new Bestsales();
                        $best->user_sales=$userid;
                        $best->date=$today;
                        $best->actnum=1;
                        $best->save();
                    }
                    //add bestsales
            
            
					$this->redirect(array('leads/profile/'.$model->leads_id)	);






			
		
		}



		$this->render('activities',array(
				'userid'=>$userid ,	
				'model'=>$model ,	
				'dataProvider' => $dataProvider,		
				'allstatues'=>$allstatues,



			));


	}


	else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);

	}

}






public function actionFreshactivities(){
	if(Yii::app()->user->isMember()){

	    $this->layout = '//layouts/systemcgridview';
		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		$criteria = new CDbCriteria;
		$criteria->condition = "close IS NULL && too IS NULL && broker_id IS NULL  && coldcall IS  NULL";
		$criteria->addCondition('user_id=' . $userid);
		
		$criteria->order = 'follow_date DESC';
		$start = '2018-01-1';
		$check = date('Y-m-d', strtotime("-1 days"));
		$criteria->addBetweenCondition("follow_date",$start,$check);
		$allstatues=Statues::model()->findAll(); 
        
		$dataProvider = new CActiveDataProvider('Activities', array(
				'pagination' => array(
					'pageSize' =>50,
				),
				'criteria' => $criteria,
			));




            





	



		if(isset($_POST['Activities'])){
				$secert=$_POST['secert'];
				$uniqid=$_POST['code'];
				$model= Activities::model()->findByAttributes(array('id'=>$secert));
				$model->report=$_POST['Activities']['report'];
				$model->close=1;
				
				
if($_POST['sucess'] == 1){
$model->confirm=1;
}else{
    
$model->confirm=3;
    
    
}
				
			
				
				if($model->save()){
				    
				    
					ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');    
				
				$criteriaopenx = new CDbCriteria;
		       $criteriaopenx->addCondition('close IS NULL OR report IS NULL ');
	      	$criteriaopenx->addSearchCondition('leads_id', $model->leads_id, false, 'AND');
	       	$allopenactivities= Activities::model()->findAll($criteriaopenx);

					if(!empty($allopenactivities)){
						foreach($allopenactivities as $openactivities){	
						    
						    
				$openactivities->close=1;
				$openactivities->report=$model->report;
				$openactivities->save();
						    
						    
						}
						
					}
					
					
					
				$newmodel=new Activities();
				$newmodel->user_id = $userid;
				$newmodel->date = $today;
				$newmodel->details= $_POST['Activities']['report'];
				$newmodel->follow_date= $_POST['Activities']['follow_date'];
				$newmodel->follow_time= $_POST['Activities']['follow_time'];
				$newmodel->status= $_POST['Activities']['status'];
				$newmodel->substatus= $_POST['Activities']['substatus'];
				$newmodel->type= $_POST['Activities']['type'];
				$newmodel->time = $time;
				$newmodel->code= $uniqid;
				
		

				

				$lead=Leads::model()->findByPk($model->leads_id);
                                $lead->sales_report=$_POST['Activities']['report'];
                                $lead->communicate_time=$time;
                                $lead->communicate_date=$today;
                                $lead->communication=1;
                                 if(empty($lead->first_communication)){
                $lead->first_communication=$userid;
                }

$lead->follow_date=$newmodel->follow_date;                               
$lead->follow_time=$newmodel->follow_time;
$lead->action_time=$newmodel->time;

				
                                $lead->checkup_activity=$today;
                                $lead->visitactive=NULL;
                               $lead->details= $lead->details.'  /  '.$today.' '.$_POST['Activities']['report'];
                               
                               $lead->status=$_POST['Activities']['status'];

                                 
                                $qualifiedtest=Statues::model()->findByPk($_POST['Activities']['status']);
                                
                                
                                
                                  if($qualifiedtest->close == 1){                
                $lead->close=1;
				$lead->reopen=NULL;
				$lead->communication=1;
								$lead->visitactive=NULL;

				 if(empty($lead->first_communication)){
                $lead->first_communication=$userid;
                }
				$lead->close_date= $today;
				$newmodel->report= 'Closed In '.$today.'-'.$_POST['Activities']['report'];
				$newmodel->close= 1;

				//$lead->save();
                }
$main=Mainsettings::model()->findByPk(1);
if($qualifiedtest->visit == 1){
if($main->createvisitauto == 1){

                    
                $visit=new Visit();
				$visit->date=$today;
				$visit->lead_id=$lead->id;
				$visit->user_id=$userid;
				$visit->lead_date=$lead->date;
				$visit->code= $uniqid;
				$visit->details=$_POST['Activities']['report'];
				$visit->dateaction=$today;
				$visit->timeaction=$time;
				
					$visit->from_time=$time;
				$visit->to_time=$time;
			
				
				
				$visit->save();
				
					if(!$visit->save()){
				     var_dump($visit->getErrors());
					}
                    
                }
                
                                }
                
                if($qualifiedtest->qualified == 1){
                $lead->qualified=1;
                  if(empty($lead->first_classification)){
                    
                $lead->first_classification=1;
                $lead->first_classification_user=$userid; 
                    
                }
                }
                
                
                if($qualifiedtest->nonqualified == 1){
                $lead->nonqualified=1;
                  if(empty($lead->first_classification)){
                    
                $lead->first_classification=2;
                $lead->first_classification_user=$userid; 
                    
                }
                }
                

                                $lead->substatus=$_POST['Activities']['substatus'];
                                
                                
                                
                                   
                           $status=Statues::model()->findByPk($_POST['Activities']['status']);
                      
                 if($status->answer == 1){
                $lead->answer=1;
				$newmodel->answer=1;
                }
                
                
                if($status->answer == 2){
                $lead->answer=2;
				$newmodel->answer=2;
                }         
                       
                                
                           $substatus=Substatus::model()->findByPk($_POST['Activities']['substatus']);
                      
                 if($substatus->answer == 1){
                $lead->answer=1;
				$newmodel->answer=1;
                }
                
                
                if($substatus->answer == 2){
                $lead->answer=2;
				$newmodel->answer=2;
                }
                
                
                                              
   if($substatus->expvisit == 1){
       $lead->expvisit=1;
                $newmodel->expvisit=1;
                }
                
                
                
                 if($substatus->callback == 1){
                $lead->callback=1;
				$newmodel->callback=1;
                }
                
                                $lead->save();
				$newmodel->name=$lead->title;
				$newmodel->tel=$lead->tel;
				$newmodel->coldcall=$lead->coldcall;
                $newmodel->indirect=$lead->indirect;
				$newmodel->lead_date= $lead->date;

				$newmodel->leads_id = $model->leads_id;
				$newmodel->secert = $rnd.$userid;

				if($newmodel->save()){

					$newmodel->secert=$newmodel->id;
					$newmodel->save();
					
					
					
				}

			


 if($newmodel->save()){

					$allsalesmangernotfie=User::model()->findAll(array('condition'=>'salesmanger=1 AND level=1 AND notification=1 AND activitiesnotifi=1'));



					if(!empty($allsalesmangernotfie)){
						foreach($allsalesmangernotfie as $sales){








$criteria = new CDbCriteria();         
		$criteria->addSearchCondition('userid', $sales->id, false);
		$vars= FirebaseToken::model()->findAll($criteria);

$arr=array();
if(!empty($vars)){
			foreach($vars as $var){
				$arr[]=$var->token;
			}

}


$main=Mainsettings::model()->findByPk(1);


$main=Mainsettings::model()->findByPk(1);
$iconurl=Yii::app()->getBaseUrl(true).'/img/'.$main->logo;
if(!empty($arr)){
$fields = array(
        'registration_ids' =>  $arr ,
        'data' => array( "title" => "Activities Notification ",
        "body" => $newmodel->employee->fname. ' ' .$newmodel->employee->lname. '
        reported to '.$model->client->title.' with '.$model->report ,
        "icon" => $iconurl, 
        "click_action" => Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->client->id),
    );
$url = 'https://fcm.googleapis.com/fcm/send';

    $headers = array(
        'Authorization: key='.$main->appkey ,
        'Content-Type: application/json'
    );
    // Open connection
    $ch = curl_init();

    // Set the url, number of POST vars, POST data
    curl_setopt($ch, CURLOPT_URL, $url);

    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    // Disabling SSL Certificate support temporarly
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

    // Execute post
    $result = curl_exec($ch);
    // echo "Result".$result;
    if ($result === FALSE) {
        die('Curl failed: ' . curl_error($ch));
    }

    // Close connection
    curl_close($ch);

 

						}
					}


}			 

					


					//notification to team leader

/*


					$criteria = new CDbCriteria;
					$criteria->addCondition('sales_id=' . $model->employee->id);
					$leader=Teamleader::model()->find($criteria);
					$leader=User::model()->findByPk($leader->leader_id);
					if(!empty($leader->player_id)){ 
						$content = array(
							"en" => $newmodel->employee->fname. ' ' .$newmodel->employee->lname. ' reported to '.$newmodel->client->title.' with '.$model->report
						);
						$url= Yii::app()->getBaseUrl(true).'/leads/profile/'.$newmodel->client->secert ;
						$playerid=$leader->player_id;
						$this->notification($content,$playerid,$url);
					}
					if(!empty($leader->player_id_mobile)){ 
						$content = array(
							"en" => $newmodel->employee->fname. ' ' .$newmodel->employee->lname. ' reported to '.$newmodel->client->title.' with '.$model->report
						);
						$url= Yii::app()->getBaseUrl(true).'/leads/profile/'.$newmodel->client->secert ;
						$playerid=$leader->player_id_mobile;
						$this->notification($content,$playerid,$url);
					}
*/

					

	}



	if($newmodel->save()){						
							
							
					if(!empty($_POST['Activities']['status'])){
						$lead=Leads::model()->findByPk($model->leads_id);
						$lead->status=$_POST['Activities']['status'];
						$lead->save();
					}
					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create Activities';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secert;
					$logsystem->user_id = $userid;
					$logsystem->save();

                    //add best sales
                                $userid=Yii::app()->user->id;
                            	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
                            	$today = date("Y-m-d");
                                $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
                                if(!empty($best)){
                                    $best->actnum+=1;
                                    $best->save();
                                }else{
                                    $best =new Bestsales();
                                    $best->user_sales=$userid;
                                    $best->date=$today;
                                    $best->actnum=1;
                                    $best->save();
                                }
                                //add bestsales
					
					$this->redirect(array('leads/profile/'.$model->leads_id)	);
					
	}		
					
				}else{
					$this->redirect(array('leads/profile/'.$model->leads_id)	);
				}



//var_dump($model->leads_id);

$criteriaerror = new CDbCriteria;
$criteriaerror->order = 'id DESC';
$criteriaerror->limit = 1;


$criteriaerror->addSearchCondition('leads_id', $model->leads_id, false, 'AND');
	       	$allopenactivitieserror = Activities::model()->findAll($criteriaerror);

					if(!empty($allopenactivitieserror)){
						foreach($allopenactivitieserror as $openactivitieserror){	
						    
						    
				$openactivitieserror->close=NULL;
				$openactivitieserror->report=NULL;
				$openactivitieserror->save();
						    
						    
						}
						
					}

		    //add best sales
            $userid=Yii::app()->user->id;
        	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
        	$today = date("Y-m-d");
            $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
            if(!empty($best)){
                $best->actnum+=1;
                $best->save();
            }else{
                $best =new Bestsales();
                $best->user_sales=$userid;
                $best->date=$today;
                $best->actnum=1;
                $best->save();
            }
            //add bestsales
            
            
					$this->redirect(array('leads/profile/'.$model->leads_id)	);






			
		
		}
		
		
		
		
		
        
 
 
 $allfreshactivitiesforsales=new Activities('freshactivitiesforsales');
        
        

        $allfreshactivitiesforsales->unsetAttributes();  // clear any default values
        if(isset($_GET['Activities'])){
        $allfreshactivitiesforsales->attributes=$_GET['Activities'];
        }



		$this->render('freshactivities',array(
				'userid'=>$userid ,	
				'model'=>$model ,	
				'dataProvider' => $dataProvider,		
				'allstatues'=>$allstatues,
				'allfreshactivitiesforsales'=>$allfreshactivitiesforsales,
				
				



			));


	}


	else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);

	}

}

public function actionFreshactivitiescold(){
	if(Yii::app()->user->isMember()){

$this->layout = '//layouts/systemcgridview';
		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		$criteria = new CDbCriteria;
		$criteria->condition = "close IS NULL && too IS NULL && broker_id IS NULL && coldcall IS NOT NULL";
		$criteria->addCondition('user_id=' . $userid);
		$criteria->order = 'follow_date DESC';
		$start = '2018-01-1';
		$check = date('Y-m-d', strtotime("-1 days"));
		$criteria->addBetweenCondition("follow_date",$start,$check);
		$allstatues=Statues::model()->findAll(); 
        
		$dataProvider = new CActiveDataProvider('Activities', array(
				'pagination' => array(
					'pageSize' =>50,
				),
				'criteria' => $criteria,
			));




            





	



		if(isset($_POST['Activities'])){
				$secert=$_POST['secert'];
				$uniqid=$_POST['code'];
				$model= Activities::model()->findByAttributes(array('id'=>$secert));
				$model->report=$_POST['Activities']['report'];
				$model->close=1;
				
				
if($_POST['sucess'] == 1){
$model->confirm=1;
}else{
    
$model->confirm=3;
    
    
}
				
			
				
				if($model->save()){
				    
				    
					ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');    
				
				$criteriaopenx = new CDbCriteria;
		       $criteriaopenx->addCondition('close IS NULL OR report IS NULL ');
	      	$criteriaopenx->addSearchCondition('leads_id', $model->leads_id, false, 'AND');
	       	$allopenactivities= Activities::model()->findAll($criteriaopenx);

					if(!empty($allopenactivities)){
						foreach($allopenactivities as $openactivities){	
						    
						    
				$openactivities->close=1;
				$openactivities->report=$model->report;
				$openactivities->save();
						    
						    
						}
						
					}
					
					
					
				$newmodel=new Activities();
				$newmodel->user_id = $userid;
				$newmodel->date = $today;
				$newmodel->details= $_POST['Activities']['report'];
				$newmodel->follow_date= $_POST['Activities']['follow_date'];
				$newmodel->follow_time= $_POST['Activities']['follow_time'];
				$newmodel->status= $_POST['Activities']['status'];
				$newmodel->substatus= $_POST['Activities']['substatus'];
				$newmodel->type= $_POST['Activities']['type'];
				$newmodel->time = $time;
				$newmodel->code= $uniqid;
				
		

				

				$lead=Leads::model()->findByPk($model->leads_id);
                                $lead->sales_report=$_POST['Activities']['report'];
                                $lead->communicate_time=$time;
                                $lead->communicate_date=$today;
                                $lead->communication=1;
                                 if(empty($lead->first_communication)){
                $lead->first_communication=$userid;
                }

$lead->follow_date=$newmodel->follow_date;                               
$lead->follow_time=$newmodel->follow_time;
$lead->action_time=$newmodel->time;

				
                                $lead->checkup_activity=$today;
                                $lead->visitactive=NULL;
                               $lead->details= $lead->details.'  /  '.$today.' '.$_POST['Activities']['report'];
                               
                               $lead->status=$_POST['Activities']['status'];

                                 
                                $qualifiedtest=Statues::model()->findByPk($_POST['Activities']['status']);
                                
                                
                                
                                    if($qualifiedtest->close == 1){                
                $lead->close=1;
				$lead->reopen=NULL;
				$lead->communication=1;
								$lead->visitactive=NULL;

				$lead->close_date= $today;
				$newmodel->report= 'Closed In '.$today.'-'.$_POST['Activities']['report'];
				$newmodel->close= 1;

				//$lead->save();
                }
                                
$main=Mainsettings::model()->findByPk(1);
if($qualifiedtest->visit == 1){
if($main->createvisitauto == 1){
                    
                    
                    
                $visit=new Visit();
				$visit->date=$today;
				$visit->lead_id=$lead->id;
				$visit->user_id=$userid;
				$visit->lead_date=$lead->date;
				$visit->code= $uniqid;
				$visit->details=$_POST['Activities']['report'];
				$visit->dateaction=$today;
				$visit->timeaction=$time;
				
					$visit->from_time=$time;
				$visit->to_time=$time;
			
				
				
				$visit->save();
				
					if(!$visit->save()){
				     var_dump($visit->getErrors());
					}
                    
                }
}
                
                if($qualifiedtest->qualified == 1){
                $lead->qualified=1;
                  if(empty($lead->first_classification)){
                    
                $lead->first_classification=1;
                $lead->first_classification_user=$userid; 
                    
                }
                }
                
                
                if($qualifiedtest->nonqualified == 1){
                $lead->nonqualified=1;
                  if(empty($lead->first_classification)){
                    
                $lead->first_classification=2;
                $lead->first_classification_user=$userid; 
                    
                }
                }
                

                                $lead->substatus=$_POST['Activities']['substatus'];
                                
                           $substatus=Substatus::model()->findByPk($_POST['Activities']['substatus']);
                      
                 if($substatus->answer == 1){
                $lead->answer=1;
				$newmodel->answer=1;
                }
                
                
                if($substatus->answer == 2){
                $lead->answer=2;
				$newmodel->answer=2;
                }
                
                
                                              
   if($substatus->expvisit == 1){
       $lead->expvisit=1;
                $newmodel->expvisit=1;
                }
                
                
                
                
                 if($substatus->callback == 1){
                $lead->callback=1;
				$newmodel->callback=1;
                }
                
                
                                $lead->save();
				$newmodel->name=$lead->title;
				$newmodel->tel=$lead->tel;
				$newmodel->coldcall=$lead->coldcall;
                $newmodel->indirect=$lead->indirect;
				$newmodel->lead_date= $lead->date;

				$newmodel->leads_id = $model->leads_id;
				$newmodel->secert = $rnd.$userid;

				if($newmodel->save()){

					$newmodel->secert=$newmodel->id;
					$newmodel->save();
					
					
					
				}

			


 if($newmodel->save()){

					$allsalesmangernotfie=User::model()->findAll(array('condition'=>'salesmanger=1 AND level=1 AND notification=1 AND activitiesnotifi=1'));



					if(!empty($allsalesmangernotfie)){
						foreach($allsalesmangernotfie as $sales){







$criteria = new CDbCriteria();         
		$criteria->addSearchCondition('userid', $sales->id, false);
		$vars= FirebaseToken::model()->findAll($criteria);

$arr=array();
if(!empty($vars)){
			foreach($vars as $var){
				$arr[]=$var->token;
			}

}


$main=Mainsettings::model()->findByPk(1);


$main=Mainsettings::model()->findByPk(1);
$iconurl=Yii::app()->getBaseUrl(true).'/img/'.$main->logo;
if(!empty($arr)){
$fields = array(
        'registration_ids' =>  $arr ,
        'data' => array( "title" => "Activities Notification ",
        "body" => $newmodel->employee->fname. ' ' .$newmodel->employee->lname. '
        reported to '.$model->client->title.' with '.$model->report ,
        "icon" => $iconurl, 
        "click_action" => Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->client->id),
    );
$url = 'https://fcm.googleapis.com/fcm/send';

    $headers = array(
        'Authorization: key='.$main->appkey ,
        'Content-Type: application/json'
    );
    // Open connection
    $ch = curl_init();

    // Set the url, number of POST vars, POST data
    curl_setopt($ch, CURLOPT_URL, $url);

    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    // Disabling SSL Certificate support temporarly
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

    // Execute post
    $result = curl_exec($ch);
    // echo "Result".$result;
    if ($result === FALSE) {
        die('Curl failed: ' . curl_error($ch));
    }

    // Close connection
    curl_close($ch);

 

						}
					}


}			 

					


					//notification to team leader

/*


					$criteria = new CDbCriteria;
					$criteria->addCondition('sales_id=' . $model->employee->id);
					$leader=Teamleader::model()->find($criteria);
					$leader=User::model()->findByPk($leader->leader_id);
					if(!empty($leader->player_id)){ 
						$content = array(
							"en" => $newmodel->employee->fname. ' ' .$newmodel->employee->lname. ' reported to '.$newmodel->client->title.' with '.$model->report
						);
						$url= Yii::app()->getBaseUrl(true).'/leads/profile/'.$newmodel->client->secert ;
						$playerid=$leader->player_id;
						$this->notification($content,$playerid,$url);
					}
					if(!empty($leader->player_id_mobile)){ 
						$content = array(
							"en" => $newmodel->employee->fname. ' ' .$newmodel->employee->lname. ' reported to '.$newmodel->client->title.' with '.$model->report
						);
						$url= Yii::app()->getBaseUrl(true).'/leads/profile/'.$newmodel->client->secert ;
						$playerid=$leader->player_id_mobile;
						$this->notification($content,$playerid,$url);
					}
*/

					

	}



	if($newmodel->save()){						
							
							
					if(!empty($_POST['Activities']['status'])){
						$lead=Leads::model()->findByPk($model->leads_id);
						$lead->status=$_POST['Activities']['status'];
						$lead->save();
					}
					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create Activities';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secert;
					$logsystem->user_id = $userid;
					$logsystem->save();

                    //add best sales
                                $userid=Yii::app()->user->id;
                            	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
                            	$today = date("Y-m-d");
                                $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
                                if(!empty($best)){
                                    $best->actnum+=1;
                                    $best->save();
                                }else{
                                    $best =new Bestsales();
                                    $best->user_sales=$userid;
                                    $best->date=$today;
                                    $best->actnum=1;
                                    $best->save();
                                }
                                //add bestsales
					
					$this->redirect(array('leads/profile/'.$model->leads_id)	);
					
	}		
					
				}else{
					$this->redirect(array('leads/profile/'.$model->leads_id)	);
				}



//var_dump($model->leads_id);

$criteriaerror = new CDbCriteria;
$criteriaerror->order = 'id DESC';
$criteriaerror->limit = 1;


$criteriaerror->addSearchCondition('leads_id', $model->leads_id, false, 'AND');
	       	$allopenactivitieserror = Activities::model()->findAll($criteriaerror);

					if(!empty($allopenactivitieserror)){
						foreach($allopenactivitieserror as $openactivitieserror){	
						    
						    
				$openactivitieserror->close=NULL;
				$openactivitieserror->report=NULL;
				$openactivitieserror->save();
						    
						    
						}
						
					}

		    //add best sales
            $userid=Yii::app()->user->id;
        	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
        	$today = date("Y-m-d");
            $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
            if(!empty($best)){
                $best->actnum+=1;
                $best->save();
            }else{
                $best =new Bestsales();
                $best->user_sales=$userid;
                $best->date=$today;
                $best->actnum=1;
                $best->save();
            }
            //add bestsales
            
            
					$this->redirect(array('leads/profile/'.$model->leads_id)	);






			
		
		}



		$this->render('freshactivitiescold',array(
				'userid'=>$userid ,	
				'model'=>$model ,	
				'dataProvider' => $dataProvider,		
				'allstatues'=>$allstatues,



			));


	}


	else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);

	}

}


public function actionLastactivities(){
	if(Yii::app()->user->isMember()){

		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		$this->layout = '//layouts/systemcgridview';
        $alllateforsales=new Activities('lateforsales');
        $alllateforsales->unsetAttributes();  // clear any default values
        if(isset($_GET['lateforsales'])){
            $alllateforsales->attributes=$_GET['lateforsales'];
        }
		if(isset($_POST['Activities'])){
			$secert=$_POST['secert'];
			$uniqid=$_POST['code'];
			$model= Activities::model()->findByAttributes(array('id'=>$secert));
			$model->report=$_POST['Activities']['report'];
			$model->close=1;
            if($_POST['sucess'] == 1){
            $model->confirm=1;
            }else{
                $model->confirm=3;   
            }
			if($model->save()){
				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');    
                $criteriaopenx = new CDbCriteria;
                $criteriaopenx->addCondition('close IS NULL OR report IS NULL ');
                $criteriaopenx->addSearchCondition('leads_id', $model->leads_id, false, 'AND');
                $allopenactivities= Activities::model()->findAll($criteriaopenx);
                if(!empty($allopenactivities)){
					foreach($allopenactivities as $openactivities){		    
        				$openactivities->close=1;
        				$openactivities->report=$model->report;
        				$openactivities->save();
					}	
				}	
				$newmodel=new Activities();
				$newmodel->user_id = $userid;
				$newmodel->date = $today;
				$newmodel->details= $_POST['Activities']['report'];
				$newmodel->follow_date= $_POST['Activities']['follow_date'];
				$newmodel->follow_time= $_POST['Activities']['follow_time'];
				$newmodel->status= $_POST['Activities']['status'];
				$newmodel->substatus= $_POST['Activities']['substatus'];
				$newmodel->type= $_POST['Activities']['type'];
				$newmodel->time = $time;
				$newmodel->code= $uniqid;
				
				$lead=Leads::model()->findByPk($model->leads_id);
                $lead->sales_report=$_POST['Activities']['report'];
                $lead->communicate_time=$time;
                $lead->communicate_date=$today;
                $lead->communication=1;
                if(empty($lead->first_communication)){
                    $lead->first_communication=$userid;
                }

                $lead->follow_date=$newmodel->follow_date;                                 
                $lead->follow_time=$newmodel->follow_time;
                $lead->action_time=$newmodel->time;
                $lead->checkup_activity=$today;
                $lead->visitactive=NULL;
                $lead->details= $lead->details.'  /  '.$today.' '.$_POST['Activities']['report'];
                $lead->status=$_POST['Activities']['status'];
                $qualifiedtest=Statues::model()->findByPk($_POST['Activities']['status']);
                if($qualifiedtest->close == 1){                
                    $lead->close=1;
    				$lead->reopen=NULL;
    				$lead->communication=1;
    				$lead->visitactive=NULL;
    				if(empty($lead->first_communication)){
                        $lead->first_communication=$userid;
                    }
    				$lead->close_date= $today;
    				$newmodel->report= 'Closed In '.$today.'-'.$_POST['Activities']['report'];
    				$newmodel->close= 1;
    				//$lead->save();
                }
                
                $main=Mainsettings::model()->findByPk(1);
                if($qualifiedtest->visit == 1){
                    if($main->createvisitauto == 1){
                        $visit=new Visit();
                        $visit->date=$today;
                        $visit->lead_id=$lead->id;
                        $visit->user_id=$userid;
                        $visit->lead_date=$lead->date;
                        $visit->code= $uniqid;
                        $visit->details=$_POST['Activities']['report'];
                        $visit->dateaction=$today;
                        $visit->timeaction=$time;
                        $visit->from_time=$time;
                        $visit->to_time=$time;
                        $visit->save();
                        if(!$visit->save()){
                            var_dump($visit->getErrors());
                        }
                    }
                }
                if($qualifiedtest->qualified == 1){
                    $lead->qualified=1;
                    if(empty($lead->first_classification)){
                        $lead->first_classification=1; 
                        $lead->first_classification_user=$userid;   
                    }
                }
                if($qualifiedtest->nonqualified == 1){
                    $lead->nonqualified=1;
                    if(empty($lead->first_classification)){
                        $lead->first_classification=2; 
                        $lead->first_classification_user=$userid;      
                    }
                }
                $lead->substatus=$_POST['Activities']['substatus'];
                $status=Statues::model()->findByPk($_POST['Activities']['status']);
                if($status->answer == 1){
                    $lead->answer=1;
    				$newmodel->answer=1;
                }
                if($status->answer == 2){
                    $lead->answer=2;
    				$newmodel->answer=2;
                }         
                
                $substatus=Substatus::model()->findByPk($_POST['Activities']['substatus']);
                
                if($substatus->answer == 1){
                    $lead->answer=1;
    				$newmodel->answer=1;
                }
                
                if($substatus->answer == 2){
                    $lead->answer=2;
    				$newmodel->answer=2;
                }
                
                if($substatus->expvisit == 1){
                    $lead->expvisit=1;
                    $newmodel->expvisit=1;
                }
                
                if($substatus->callback == 1){
                    $lead->callback=1;
    				$newmodel->callback=1;
                }
                
                $lead->save();
				$newmodel->name=$lead->title;
				$newmodel->tel=$lead->tel;
				$newmodel->coldcall=$lead->coldcall;
                $newmodel->indirect=$lead->indirect;
				$newmodel->lead_date= $lead->date;

				$newmodel->leads_id = $model->leads_id;
				$newmodel->secert = $rnd.$userid;

				if($newmodel->save()){
					$newmodel->secert=$newmodel->id;
					$newmodel->save();	
				}
				
                if($newmodel->save()){
					$allsalesmangernotfie=User::model()->findAll(array('condition'=>'salesmanger=1 AND level=1 AND notification=1 AND activitiesnotifi=1'));
					if(!empty($allsalesmangernotfie)){
						foreach($allsalesmangernotfie as $sales){
                            $criteria = new CDbCriteria();         
                            $criteria->addSearchCondition('userid', $sales->id, false);
                            $vars= FirebaseToken::model()->findAll($criteria);

                            $arr=array();
                            if(!empty($vars)){
                    			foreach($vars as $var){
                    				$arr[]=$var->token;
                    			}
                            }


                        $main=Mainsettings::model()->findByPk(1);
                        $iconurl=Yii::app()->getBaseUrl(true).'/img/'.$main->logo;
                        if(!empty($arr)){
                            $fields = array(
                                'registration_ids' =>  $arr ,
                                'data' => array( "title" => "Activities Notification ",
                                "body" => $newmodel->employee->fname. ' ' .$newmodel->employee->lname. '
                                reported to '.$model->client->title.' with '.$model->report ,
                                "icon" => $iconurl, 
                                "click_action" => Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->client->id),
                            );
                            $url = 'https://fcm.googleapis.com/fcm/send';
                            
                            $headers = array(
                                'Authorization: key='.$main->appkey ,
                                'Content-Type: application/json'
                            );
                            // Open connection
                            $ch = curl_init();
                        
                            // Set the url, number of POST vars, POST data
                            curl_setopt($ch, CURLOPT_URL, $url);
                        
                            curl_setopt($ch, CURLOPT_POST, true);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        
                            // Disabling SSL Certificate support temporarly
                            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                        
                            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
                        
                            // Execute post
                            $result = curl_exec($ch);
                            // echo "Result".$result;
                            if ($result === FALSE) {
                                die('Curl failed: ' . curl_error($ch));
                            }
                        
                            // Close connection
                            curl_close($ch);
                        }
                    }         
                }		
	        }
            if($newmodel->save()){						
				if(!empty($_POST['Activities']['status'])){
					$lead=Leads::model()->findByPk($model->leads_id);
					$lead->status=$_POST['Activities']['status'];
					$lead->save();
				}
				$logsystem = new Logsystem();
				$logsystem->date = $today;
				$logsystem->time = $time;
				$logsystem->action = 'User Create Activities';
				$logsystem->action_id = $model->id;
				$logsystem->ip = $model->id;
				$logsystem->secert = $model->secert;
				$logsystem->user_id = $userid;
				$logsystem->save();
				
                //add best sales
                $userid=Yii::app()->user->id;
                $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
                $today = date("Y-m-d");
                $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
                if(!empty($best)){
                    $best->actnum+=1;
                    $best->save();
                }else{
                    $best =new Bestsales();
                    $best->user_sales=$userid;
                    $best->date=$today;
                    $best->actnum=1;
                    $best->save();
                }
                //add bestsales
            	$this->redirect(array('leads/profile/'.$model->leads_id)	);
            }
		}else{
			$this->redirect(array('leads/profile/'.$model->leads_id)	);
		}
        //var_dump($model->leads_id);
        $criteriaerror = new CDbCriteria;
        $criteriaerror->order = 'id DESC';
        $criteriaerror->limit = 1;
        
        $criteriaerror->addSearchCondition('leads_id', $model->leads_id, false, 'AND');
        $allopenactivitieserror = Activities::model()->findAll($criteriaerror);

        if(!empty($allopenactivitieserror)){
            foreach($allopenactivitieserror as $openactivitieserror){
                $openactivitieserror->close=NULL;
                $openactivitieserror->report=NULL;
                $openactivitieserror->save();
            }
        }
	    //add best sales
        $userid=Yii::app()->user->id;
    	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
    	$today = date("Y-m-d");
        $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
        if(!empty($best)){
            $best->actnum+=1;
            $best->save();
        }else{
            $best =new Bestsales();
            $best->user_sales=$userid;
            $best->date=$today;
            $best->actnum=1;
            $best->save();
        }
        //add bestsales
        $this->redirect(array('leads/profile/'.$model->leads_id)	);
    }
    $this->render('lateforsales',array(
    	'userid'=>$userid ,	
    	'model'=>$model ,	
    	'dataProvider' => $dataProvider,		
    	'allstatues'=>$allstatues,
    	'alllateforsales'=>$alllateforsales,
    ));
    }else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);

	}

}


public function actionLastactivitiescold(){
	if(Yii::app()->user->isMember()){

$this->layout = '//layouts/systemcgridview';
		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);
		$criteria = new CDbCriteria;
		$criteria->condition = "close IS NULL && too IS NULL && broker_id IS NULL && coldcall IS NOT NULL";
		$criteria->addCondition('user_id=' . $userid);
		$criteria->order = 'follow_date DESC';
		$start = '2018-01-1';
		$check = date('Y-m-d', strtotime("-1 days"));
		$criteria->addBetweenCondition("follow_date",$start,$check);
		$allstatues=Statues::model()->findAll(); 
        
		$dataProvider = new CActiveDataProvider('Activities', array(
				'pagination' => array(
					'pageSize' =>50,
				),
				'criteria' => $criteria,
			));




            





	



		if(isset($_POST['Activities'])){
				$secert=$_POST['secert'];
				$uniqid=$_POST['code'];
				$model= Activities::model()->findByAttributes(array('id'=>$secert));
				$model->report=$_POST['Activities']['report'];
				$model->close=1;
				
				
if($_POST['sucess'] == 1){
$model->confirm=1;
}else{
    
$model->confirm=3;
    
    
}
				
			
				
				if($model->save()){
				    
				    
					ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');    
				
				$criteriaopenx = new CDbCriteria;
		       $criteriaopenx->addCondition('close IS NULL OR report IS NULL ');
	      	$criteriaopenx->addSearchCondition('leads_id', $model->leads_id, false, 'AND');
	       	$allopenactivities= Activities::model()->findAll($criteriaopenx);

					if(!empty($allopenactivities)){
						foreach($allopenactivities as $openactivities){	
						    
						    
				$openactivities->close=1;
				$openactivities->report=$model->report;
				$openactivities->save();
						    
						    
						}
						
					}
					
					
					
				$newmodel=new Activities();
				$newmodel->user_id = $userid;
				$newmodel->date = $today;
				$newmodel->details= $_POST['Activities']['report'];
				$newmodel->follow_date= $_POST['Activities']['follow_date'];
				$newmodel->follow_time= $_POST['Activities']['follow_time'];
				$newmodel->status= $_POST['Activities']['status'];
				$newmodel->substatus= $_POST['Activities']['substatus'];
				$newmodel->type= $_POST['Activities']['type'];
				$newmodel->time = $time;
				$newmodel->code= $uniqid;
				
		

				

				$lead=Leads::model()->findByPk($model->leads_id);
                                $lead->sales_report=$_POST['Activities']['report'];
                                $lead->communicate_time=$time;
                                $lead->communicate_date=$today;
                                $lead->communication=1;
                                 if(empty($lead->first_communication)){
                $lead->first_communication=$userid;
                }

$lead->follow_date=$newmodel->follow_date;                                
$lead->follow_time=$newmodel->follow_time;
$lead->action_time=$newmodel->time;

				
                                $lead->checkup_activity=$today;
                                $lead->visitactive=NULL;
                               $lead->details= $lead->details.'  /  '.$today.' '.$_POST['Activities']['report'];
                               
                               $lead->status=$_POST['Activities']['status'];

                                 
                                $qualifiedtest=Statues::model()->findByPk($_POST['Activities']['status']);
                                
                                
                                
                                
                                   if($qualifiedtest->close == 1){                
                $lead->close=1;
				$lead->reopen=NULL;
				$lead->communication=1;
								$lead->visitactive=NULL;

				 if(empty($lead->first_communication)){
                $lead->first_communication=$userid;
                }
				
				$lead->close_date= $today;
				$newmodel->report= 'Closed In '.$today.'-'.$_POST['Activities']['report'];
				$newmodel->close= 1;

				//$lead->save();
                }
                                
                                
                             $main=Mainsettings::model()->findByPk(1);
if($qualifiedtest->visit == 1){
if($main->createvisitauto == 1){
                    
                    
                $visit=new Visit();
				$visit->date=$today;
				$visit->lead_id=$lead->id;
				$visit->user_id=$userid;
				$visit->lead_date=$lead->date;
				$visit->code= $uniqid;
				$visit->details=$_POST['Activities']['report'];
				$visit->dateaction=$today;
				$visit->timeaction=$time;
				
					$visit->from_time=$time;
				$visit->to_time=$time;
			
				
				
				$visit->save();
				
					if(!$visit->save()){
				     var_dump($visit->getErrors());
					}
                    
                }
}
                
                if($qualifiedtest->qualified == 1){
                $lead->qualified=1;
                  if(empty($lead->first_classification)){
                    
                $lead->first_classification=1;   
                $lead->first_classification_user=$userid; 
                    
                }
                }
                
                
                if($qualifiedtest->nonqualified == 1){
                $lead->nonqualified=1;
                  if(empty($lead->first_classification)){
                    
                $lead->first_classification=2;  
                $lead->first_classification_user=$userid; 
                    
                }
                }
                

                                $lead->substatus=$_POST['Activities']['substatus'];
                                
                                
                   
                           $status=Statues::model()->findByPk($_POST['Activities']['status']);
                      
                 if($status->answer == 1){
                $lead->answer=1;
				$newmodel->answer=1;
                }
                
                
                if($status->answer == 2){
                $lead->answer=2;
				$newmodel->answer=2;
                }         
                                       
                                
                           $substatus=Substatus::model()->findByPk($_POST['Activities']['substatus']);
                      
                 if($substatus->answer == 1){
                $lead->answer=1;
				$newmodel->answer=1;
                }
                
                
                if($substatus->answer == 2){
                $lead->answer=2;
				$newmodel->answer=2;
                }
                
                
                
                                              
   if($substatus->expvisit == 1){
       $lead->expvisit=1;
                $newmodel->expvisit=1;
                }
                
                
                if($substatus->callback == 1){
                $lead->callback=1;
				$newmodel->callback=1;
                }
                
                                $lead->save();
				$newmodel->name=$lead->title;
				$newmodel->tel=$lead->tel;
				$newmodel->coldcall=$lead->coldcall;
                $newmodel->indirect=$lead->indirect;
				$newmodel->lead_date= $lead->date;

				$newmodel->leads_id = $model->leads_id;
				$newmodel->secert = $rnd.$userid;

				if($newmodel->save()){

					$newmodel->secert=$newmodel->id;
					$newmodel->save();
					
					
					
				}

			


 if($newmodel->save()){

					$allsalesmangernotfie=User::model()->findAll(array('condition'=>'salesmanger=1 AND level=1 AND notification=1 AND activitiesnotifi=1'));



					if(!empty($allsalesmangernotfie)){
						foreach($allsalesmangernotfie as $sales){









$criteria = new CDbCriteria();         
		$criteria->addSearchCondition('userid', $sales->id, false);
		$vars= FirebaseToken::model()->findAll($criteria);

$arr=array();
if(!empty($vars)){
			foreach($vars as $var){
				$arr[]=$var->token;
			}

}


$main=Mainsettings::model()->findByPk(1);


$main=Mainsettings::model()->findByPk(1);
$iconurl=Yii::app()->getBaseUrl(true).'/img/'.$main->logo;
if(!empty($arr)){
$fields = array(
        'registration_ids' =>  $arr ,
        'data' => array( "title" => "Activities Notification ",
        "body" => $newmodel->employee->fname. ' ' .$newmodel->employee->lname. '
        reported to '.$model->client->title.' with '.$model->report ,
        "icon" => $iconurl, 
        "click_action" => Yii::app()->getBaseUrl(true).'/leads/profile/'.$model->client->id),
    );
$url = 'https://fcm.googleapis.com/fcm/send';

    $headers = array(
        'Authorization: key='.$main->appkey ,
        'Content-Type: application/json'
    );
    // Open connection
    $ch = curl_init();

    // Set the url, number of POST vars, POST data
    curl_setopt($ch, CURLOPT_URL, $url);

    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    // Disabling SSL Certificate support temporarly
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

    // Execute post
    $result = curl_exec($ch);
    // echo "Result".$result;
    if ($result === FALSE) {
        die('Curl failed: ' . curl_error($ch));
    }

    // Close connection
    curl_close($ch);

 

						}
					}


}			 

					


					//notification to team leader

/*


					$criteria = new CDbCriteria;
					$criteria->addCondition('sales_id=' . $model->employee->id);
					$leader=Teamleader::model()->find($criteria);
					$leader=User::model()->findByPk($leader->leader_id);
					if(!empty($leader->player_id)){ 
						$content = array(
							"en" => $newmodel->employee->fname. ' ' .$newmodel->employee->lname. ' reported to '.$newmodel->client->title.' with '.$model->report
						);
						$url= Yii::app()->getBaseUrl(true).'/leads/profile/'.$newmodel->client->secert ;
						$playerid=$leader->player_id;
						$this->notification($content,$playerid,$url);
					}
					if(!empty($leader->player_id_mobile)){ 
						$content = array(
							"en" => $newmodel->employee->fname. ' ' .$newmodel->employee->lname. ' reported to '.$newmodel->client->title.' with '.$model->report
						);
						$url= Yii::app()->getBaseUrl(true).'/leads/profile/'.$newmodel->client->secert ;
						$playerid=$leader->player_id_mobile;
						$this->notification($content,$playerid,$url);
					}
*/

					

	}



	if($newmodel->save()){						
							
							
					if(!empty($_POST['Activities']['status'])){
						$lead=Leads::model()->findByPk($model->leads_id);
						$lead->status=$_POST['Activities']['status'];
						$lead->save();
					}
					$logsystem = new Logsystem();
					$logsystem->date = $today;
					$logsystem->time = $time;
					$logsystem->action = 'User Create Activities';
					$logsystem->action_id = $model->id;
					$logsystem->ip = $model->id;
					$logsystem->secert = $model->secert;
					$logsystem->user_id = $userid;
					$logsystem->save();

                    //add best sales
                                $userid=Yii::app()->user->id;
                            	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
                            	$today = date("Y-m-d");
                                $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
                                if(!empty($best)){
                                    $best->actnum+=1;
                                    $best->save();
                                }else{
                                    $best =new Bestsales();
                                    $best->user_sales=$userid;
                                    $best->date=$today;
                                    $best->actnum=1;
                                    $best->save();
                                }
                                //add bestsales
					
					$this->redirect(array('leads/profile/'.$model->leads_id)	);
					
	}		
					
				}else{
					$this->redirect(array('leads/profile/'.$model->leads_id)	);
				}



//var_dump($model->leads_id);

$criteriaerror = new CDbCriteria;
$criteriaerror->order = 'id DESC';
$criteriaerror->limit = 1;


$criteriaerror->addSearchCondition('leads_id', $model->leads_id, false, 'AND');
	       	$allopenactivitieserror = Activities::model()->findAll($criteriaerror);

					if(!empty($allopenactivitieserror)){
						foreach($allopenactivitieserror as $openactivitieserror){	
						    
						    
				$openactivitieserror->close=NULL;
				$openactivitieserror->report=NULL;
				$openactivitieserror->save();
						    
						    
						}
						
					}

		    //add best sales
            $userid=Yii::app()->user->id;
        	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
        	$today = date("Y-m-d");
            $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
            if(!empty($best)){
                $best->actnum+=1;
                $best->save();
            }else{
                $best =new Bestsales();
                $best->user_sales=$userid;
                $best->date=$today;
                $best->actnum=1;
                $best->save();
            }
            //add bestsales
            
            
					$this->redirect(array('leads/profile/'.$model->leads_id)	);






			
		
		}



		$this->render('lastactivitiescold',array(
				'userid'=>$userid ,	
				'model'=>$model ,	
				'dataProvider' => $dataProvider,		
				'allstatues'=>$allstatues,



			));


	}


	else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);

	}

}




	public function actionDuplicate(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

	
$this->layout = '//layouts/systemcgridview';

			$criteria = new CDbCriteria;
			$criteria->order = 'id DESC';
			$dataProvider = new CActiveDataProvider('Duplicate', array(
					'pagination' => array(
						'pageSize' =>50,
					),
					'criteria' => $criteria,
				));

			$visible=1;
			$allstatues=Statues::model()->findAll();
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

			$alldubleads = Duplicate::model()->findAll($criteria);


			$this->render('duplicate',array(
					'userid'=>$userid ,    
					'dataProvider'=>$dataProvider ,
					'alldubleads'=>$alldubleads,
					'allcampaign'=>$allcampaign,
					'allstatues'=>$allstatues,



				));

		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);

		}

	}
			







	public function actionDislike($id){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

			$model=LikeUnit::model()->findByPk($id);

			if($model->delete()){
				$this->redirect(array('sales/searchunit')	);
			}

	
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);

		}

	}
			






	public function actionLike(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

			$model= new LikeUnit();	

			if(isset($_POST['submit'])){
				$secert=$_POST['secert'];
				$lead = Leads::model()->findByAttributes(array('secert'=>$secert));
				$unit_id=$_POST['unit_id'];
				$model->user_id= $userid;
				$model->date= $today;
				$model->time= $time;
				$model->unit_id= $unit_id;
				$model->lead_id= $lead->id;
				if($model->save()){
					$this->redirect(array('sales/searchunit')	);
				}

			}

		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);

		}

	}
			













		
public function actionSalesmanger(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

		
			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			
			
			$allstatues= Statues::model()->findAll();
			$allsubstatues= Substatus::model()->findAll();

			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

			$allplace= Interestedplace::model()->findAll();


		
		
		
		
		
			$this->render('salesmanger',array(
					'userid'=>$userid ,	
					'model'=>$model ,	
					'pages' => $pages,		
					'allcampaign'=>$allcampaign,
					'allproject'=>$allproject,
					'allsales'=>$allsales,
					'allstatues'=>$allstatues,
					'allplatform'=>$allplatform,
					'allplace'=>$allplace,
										'allsubstatues'=>$allsubstatues,



				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);

		}

	}

















	
	
public function actionSmsfilter(){
	if(Yii::app()->user->isMember()){
		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

	
		$main=Mainsettings::model()->findByPk(1);	
		$visible = 1;
		$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		//$allleads= Leads::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
		$allstatues= Statues::model()->findAll();

		$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));




		$criteria = new CDbCriteria();
		$criteria->order = 'id DESC';


		$dataProvider = new CActiveDataProvider('Smssheet', array(
				'pagination' => array(
					'pageSize' =>50,
				),
				'criteria' => $criteria,
			));





		if(isset($_REQUEST['search'])){

			$arrayofinfo=array(
			'title'=>$_REQUEST['search'],
			'tel'=>$_REQUEST['tel'],
			'second_tel'=>$_REQUEST['secondtel'],
			'campaign'=>$_REQUEST['campaign'],
			'user'=>$_REQUEST['user'],
			'receipt'=>$_REQUEST['receipt'],
			'communication'=>$_REQUEST['communication'],
			'close'=>$_REQUEST['close'],
			'duplicate'=>$_REQUEST['duplicate'],
			'status'=>$_REQUEST['status'],
			'platform'=>$_REQUEST['platform'],
			'startdate'=>$_REQUEST['startdate'],
			'enddate'=>$_REQUEST['enddate']
			);
			
			
			$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
			if(!empty($_REQUEST['search'])){
			$criteria->addSearchCondition('title', $_REQUEST['search'],TRUE, "AND");
                         }
			if(!empty($_REQUEST['tel'])){
				$phone= $_REQUEST['tel'] ;
                                $phone= ltrim($phone, '0');

				$countrys = [
					'44' => 'UK (+44)',
					'213' => 'Algeria (+213)',
					'376' => 'Andorra (+376)',
					'244' => 'Angola (+244)',
					'1268' => 'Antigua & Barbuda (+1268)',
					'54' => 'Argentina (+54)',
					'374' => 'Armenia (+374)',
					'297' => 'Aruba (+297)',
					'61' => 'Australia (+61)',
					'43' => 'Austria (+43)',
					'994' => 'Azerbaijan (+994)',
					'973' => 'Bahrain (+973)',
					'880' => 'Bangladesh (+880)',
					'1246' => 'Barbados (+1246)',
					'375' => 'Belarus (+375)',
					'32' => 'Belgium (+32)',
					'501' => 'Belize (+501)',
					'229' => 'Benin (+229)',
					'975' => 'Bhutan (+975)',
					'591' => 'Bolivia (+591)',
					'387' => 'Bosnia Herzegovina (+387)',
					'267' => 'Botswana (+267)',
					'55' => 'Brazil (+55)',
					'673' => 'Brunei (+673)',
					'359' => 'Bulgaria (+359)',
					'226' => 'Burkina Faso (+226)',
					'257' => 'Burundi (+257)',
					'855' => 'Cambodia (+855)',
					'237' => 'Cameroon (+237)',
					'238' => 'Cape Verde Islands (+238)',
					'236' => 'Central African Republic (+236)',
					'56' => 'Chile (+56)',
					'86' => 'China (+86)',
					'57' => 'Colombia (+57)',
					'269' => 'Comoros (+269)',
					'242' => 'Congo (+242)',
					'682' => 'Cook Islands (+682)',
					'506' => 'Costa Rica (+506)','225' => 'Cote d Ivoire (+225)',
					'385' => 'Croatia (+385)',
					'53' => 'Cuba (+53)',
					'90392' => 'Cyprus North (+90392)',
					'357' => 'Cyprus South (+357)',
					'420' => 'Czech Republic (+420)',
					'45' => 'Denmark (+45)',
					'253' => 'Djibouti (+253)',
					'593' => 'Ecuador (+593)',
					'20' => 'Egypt (+20)',
					'503' => 'El Salvador (+503)',
					'240' => 'Equatorial Guinea (+240)',
					'291' => 'Eritrea (+291)',
					'372' => 'Estonia (+372)',
					'251' => 'Ethiopia (+251)',
					'500' => 'Falkland Islands (+500)',
					'298' => 'Faroe Islands (+298)',
					'679' => 'Fiji (+679)',
					'358' => 'Finland (+358)',
					'33' => 'France (+33)',
					'594' => 'French Guiana (+594)',
					'689' => 'French Polynesia (+689)',
					'241' => 'Gabon (+241)',
					'220' => 'Gambia (+220)',
					'995' => 'Georgia (+995)',
					'49' => 'Germany (+49)',
					'233' => 'Ghana (+233)',
					'350' => 'Gibraltar (+350)',
					'30' => 'Greece (+30)',
					'299' => 'Greenland (+299)',
					'590' => 'Guadeloupe (+590)',
					'671' => 'Guam (+671)',
					'502' => 'Guatemala (+502)',
					'224' => 'Guinea (+224)',
					'245' => 'Guinea - Bissau (+245)',
					'592' => 'Guyana (+592)',
					'509' => 'Haiti (+509)',
					'504' => 'Honduras (+504)',
					'852' => 'Hong Kong (+852)',
					'36' => 'Hungary (+36)',
					'354' => 'Iceland (+354)',
					'91' => 'India (+91)',
					'62' => 'Indonesia (+62)',
					'98' => 'Iran (+98)',
					'964' => 'Iraq (+964)',
					'353' => 'Ireland (+353)',
					'39' => 'Italy (+39)','972' => 'Israel (+972)',
					'81' => 'Japan (+81)',
					'962' => 'Jordan (+962)',
					'7' => 'Kazakhstan (+7)',
					'254' => 'Kenya (+254)',
					'686' => 'Kiribati (+686)',
					'850' => 'Korea North (+850)',
					'82' => 'Korea South (+82)',
					'965' => 'Kuwait (+965)',
					'996' => 'Kyrgyzstan (+996)',
					'856' => 'Laos (+856)',
					'371' => 'Latvia (+371)',
					'961' => 'Lebanon (+961)',
					'266' => 'Lesotho (+266)',
					'231' => 'Liberia (+231)',
					'218' => 'Libya (+218)',
					'417' => 'Liechtenstein (+417)',
					'370' => 'Lithuania (+370)',
					'352' => 'Luxembourg (+352)',
					'853' => 'Macao (+853)',
					'389' => 'Macedonia (+389)',
					'261' => 'Madagascar (+261)',
					'265' => 'Malawi (+265)',
					'60' => 'Malaysia (+60)',
					'960' => 'Maldives (+960)',
					'223' => 'Mali (+223)',
					'356' => 'Malta (+356)',
					'692' => 'Marshall Islands (+692)',
					'596' => 'Martinique (+596)',
					'222' => 'Mauritania (+222)',
					'269' => 'Mayotte (+269)',
					'52' => 'Mexico (+52)',
					'691' => 'Micronesia (+691)',
					'373' => 'Moldova (+373)',
					'377' => 'Monaco (+377)',
					'976' => 'Mongolia (+976)',
					'1664' => 'Montserrat (+1664)',
					'212' => 'Morocco (+212)',
					'258' => 'Mozambique (+258)',
					'95' => 'Myanmar (+95)',
					'264' => 'Namibia (+264)',
					'674' => 'Nauru (+674)',
					'977' => 'Nepal (+977)',
					'31' => 'Netherlands (+31)',
					'687' => 'New Caledonia (+687)',
					'64' => 'New Zealand (+64)',
					'505' => 'Nicaragua (+505)',
					'227' => 'Niger (+227)',
					'234' => 'Nigeria (+234)',
					'683' => 'Niue (+683)',
					'672' => 'Norfolk Islands (+672)',
					'670' => 'Northern Marianas (+670)',
					'47' => 'Norway (+47)',
					'968' => 'Oman (+968)',
					'680' => 'Palau (+680)','970' => 'Palestine (+970)',
					'507' => 'Panama (+507)',
					'675' => 'Papua New Guinea (+675)',
					'595' => 'Paraguay (+595)',
					'51' => 'Peru (+51)',
					'63' => 'Philippines (+63)',
					'48' => 'Poland (+48)',
					'351' => 'Portugal (+351)',
					'1787' => 'Puerto Rico (+1787)',
					'974' => 'Qatar (+974)',
					'262' => 'Reunion (+262)',
					'40' => 'Romania (+40)',
					'7' => 'Russia (+7)',
					'250' => 'Rwanda (+250)',
					'378' => 'San Marino (+378)',
					'239' => 'Sao Tome & Principe (+239)',
					'966' => 'Saudi Arabia (+966)',
					'221' => 'Senegal (+221)',
					'381' => 'Serbia (+381)',
					'248' => 'Seychelles (+248)',
					'232' => 'Sierra Leone (+232)',
					'65' => 'Singapore (+65)',
					'421' => 'Slovak Republic (+421)',
					'386' => 'Slovenia (+386)',
					'677' => 'Solomon Islands (+677)',
					'252' => 'Somalia (+252)',
					'27' => 'South Africa (+27)',
					'34' => 'Spain (+34)',
					'94' => 'Sri Lanka (+94)',
					'290' => 'St. Helena (+290)',
					'1869' => 'St. Kitts (+1869)',
					'1758' => 'St. Lucia (+1758)',
					'249' => 'Sudan (+249)','211' => 'South Sudan (+211)',
					'597' => 'Suriname (+597)',
					'268' => 'Swaziland (+268)',
					'46' => 'Sweden (+46)',
					'41' => 'Switzerland (+41)',
					'963' => 'Syria (+963)',
					'886' => 'Taiwan (+886)',
					'7' => 'Tajikstan (+7)',
					'66' => 'Thailand (+66)',
					'228' => 'Togo (+228)',
					'676' => 'Tonga (+676)',
					'1868' => 'Trinidad & Tobago (+1868)',
					'216' => 'Tunisia (+216)',
					'90' => 'Turkey (+90)',
					'7' => 'Turkmenistan (+7)',
					'993' => 'Turkmenistan (+993)',
					'688' => 'Tuvalu (+688)',
					'256' => 'Uganda (+256)',
					'380' => 'Ukraine (+380)',
					'971' => 'United Arab Emirates (+971)',
					'598' => 'Uruguay (+598)',
					'7' => 'Uzbekistan (+7)',
					'678' => 'Vanuatu (+678)',
					'379' => 'Vatican City (+379)',
					'58' => 'Venezuela (+58)',
					'84' => 'Vietnam (+84)',
					'84' => 'Virgin Islands - British (+1284)',
					'84' => 'Virgin Islands - US (+1340)',
					'681' => 'Wallis & Futuna (+681)',
					'969' => 'Yemen (North)(+969)',
					'967' => 'Yemen (South)(+967)',
					'260' => 'Zambia (+260)',
					'263' => 'Zimbabwe (+263)',
				];

				$temp=  substr(strstr($phone, '+'),1);
				if($temp != false){$phone=$temp;}
				$countrycode='';
				// sort the array by key, descending
				krsort($countrys, SORT_NUMERIC);

				// iterate over all countries
				foreach($countrys as $we => $ccode){
					// if number begins with current number
					if(strpos($phone, '' . $we) === 0){
						// store country code and break the loop
						$countrycode = $we;
						break;
					}
				}

				if(!empty($countrycode)){
					$size=strlen($countrycode);
					$phone=substr($phone,$size);
				}



				$criteria->addSearchCondition('tel', $phone ,false, "AND");
			}

			if(!empty($_REQUEST['secondtel'])){
			$criteria->addSearchCondition('second_tel', $_REQUEST['secondtel'],false, "AND");
                        }
			if(!empty($_REQUEST['campaign'])){
			$criteria->addSearchCondition('campaign_id', $_REQUEST['campaign'],false, "AND");
                        }

			if(!empty($_REQUEST['userr'])){
			$criteria->addSearchCondition('user_sales', $_REQUEST['userr'],false, "AND");
                        }

			if(!empty($_REQUEST['receipt'])){
			$criteria->addSearchCondition('receipt', $_REQUEST['receipt'],false, "AND");
                        }

			if(!empty($_REQUEST['communication'])){
			$criteria->addSearchCondition('communication', $_REQUEST['communication'],false, "AND");
                        }

			if(!empty($_REQUEST['close'])){
			$criteria->addSearchCondition('close', $_REQUEST['close'],false, "AND");
                        }

			if(!empty($_REQUEST['duplicate'])){
			$criteria->addSearchCondition('duplicate', $_REQUEST['duplicate'],false, "AND");
                        }

			if(!empty($_REQUEST['status'])){
			$criteria->addSearchCondition('status', $_REQUEST['status'],false, "AND");
                        }

			if(!empty($_REQUEST['platform'])){
			$criteria->addSearchCondition('platform_id', $_REQUEST['platform'],false, "AND");
                        }

			if(!empty($_REQUEST['startdate']) AND !empty($_REQUEST['enddate']) ){
			$criteria->addBetweenCondition("date",$_REQUEST['startdate'],$_REQUEST['enddate'],'AND');
                        }

			$allleadss = Leads::model()->findAll($criteria); 
//var_dump($allleadss);exit;
			$message=$_REQUEST['message'];
				
				
				
				
			$num=0;
			foreach($allleadss as $leadd){
				if(substr($leadd->tel, 0, 1)=='1'){
					$num++;	
						
					$smsmessagecontent = rawurlencode($message);
					$curl = curl_init();

					curl_setopt_array($curl, array(

							CURLOPT_URL => "https://smsmisr.com/api/SMS/?environment=1&username=".$main->username."&password=".$main->password."&language=2&sender=".$main->sender."&mobile=".$leadd->international_code.$leadd->tel."&message=".$smsmessagecontent ,


							CURLOPT_RETURNTRANSFER => true,
							CURLOPT_ENCODING => "",
							CURLOPT_MAXREDIRS => 10,
							CURLOPT_TIMEOUT => 30,
							CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
							CURLOPT_CUSTOMREQUEST => "POST",
							CURLOPT_HTTPHEADER => array(
								'Content-Type: application/json', 
								'Content-Length:0 ' ,
								"Cache-Control: no-cache",
							),
						));

					$response = curl_exec($curl);

					$err = curl_error($curl);
					//var_dump($response);

					$sms= new Smssheet();
					$sms->date=$today;
					$sms->time=$time;
					$sms->tomobile=$leadd->international_code.$leadd->tel;
					$sms->totitle=$leadd->title;
					$sms->content=$message;
					$sms->user_id=1;
					if(!$sms->save()){
						$errores = $sms->getErrors();
						var_dump($errores);
					}


	
						
					
				}
			}
				
				
				
				
				
			/*
			$num=0;
			$teltest='';
			foreach($allleadss as $leadd){
			if(substr($leadd->tel, 0, 1)=='1'){
			$teltest.=$leadd->international_code;
			$teltest.=$leadd->tel.',';
			$num++;
			}
			}
			$teltest = substr($teltest, 0, -1);


			$smsmessagecontent = rawurlencode($message);
			$curl = curl_init();

			curl_setopt_array($curl, array(

			CURLOPT_URL => "https://smsmisr.com/api/webapi/?username=".$main->username."&password=".$main->password."&language=2&sender=".$main->sender."&mobile={$teltest}&message=".$smsmessagecontent ,


			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_HTTPHEADER => array(
			'Content-Type: application/json', 
			'Content-Length:0 ' ,
			"Cache-Control: no-cache",
			),
			));

			$response = curl_exec($curl);
			$err = curl_error($curl);
			//var_dump($response);

			$sms= new Smssheet();
			$sms->date=$today;
			$sms->time=$time;
			//$sms->tomobile=$teltest;
			$sms->totitle='Group of people';
			$sms->content=$message;
			$sms->user_id=1;
			if(!$sms->save()){
			$errores = $sms->getErrors();
			//var_dump($errores);
			}
			*/
              







			Yii::app()->user->setFlash('message', 'Successfully Send Messages To '.$num.' Lead');

	          

		}

		
	
		
		
		
		
		$this->render('smsfilter',array(
				'userid'=>$userid ,	
				'model'=>$model ,	
				'pages' => $pages,		
				'allleads'=>$allleads ,
				'allcampaign'=>$allcampaign,
				'allproject'=>$allproject,
				'allsales'=>$allsales,
				'allstatues'=>$allstatues,
				'allplatform'=>$allplatform,
				'dataProvider'=>$dataProvider,



			));
	}


	else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);

	}

}















		
	public function actionLeader(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

		
			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			//$allleads= Leads::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

			$allstatues= Statues::model()->findAll();



			$criteria = new CDbCriteria;
			$criteria->addCondition('hidden=' . $visible);
			$criteria->addCondition('user_sales=' . $userid);
			$criteria->order = 'id DESC';
			$total = Leads::model()->count($criteria);

			$pages = new CPagination($total);
			$pages->pageSize = 50;
			$pages->applyLimit($criteria);

			$allleads = Leads::model()->findAll($criteria);

		
			$model = new Leads();
                                             $model->setScenario('com_porfile');
                                             if(isset($_POST['Leads'])){
                                                            $rnd = rand(0,99999);
                                                            $model->attributes = $_POST['Leads'];
                                                            $model->user_id = $userid;
                                                            $model->date = $today;
                                                            $model->feedback_date = $today;
                                                            $model->communicate_date = $today;
                                                            $model->transferdate = $today;
 
 
                                                            $model->time = $time;
                                                            $model->dtime = $time;
                                                            
                                                            $model->hidden = 1;
                                                            $model->strategy_id = 1;
                                                            $model->user_marketing = 1;
			                                             	if(!empty($_POST['Leads']['platformchild_id']))
			                                                 	$model->platformchild_id=$_POST['Leads']['platformchild_id'];
 
                                                            $name = str_replace(' ', '', $model->tel);
                                                            
                                                            
                                                            
                                                            
                                                            	$criteriaduplecat= new CDbCriteria();
                                                            	//$criteriaduplecat->limit = 1;

						$criteriaduplecat->addSearchCondition('tel', $name, false , 'OR');
						$criteriaduplecat->addSearchCondition('second_tel', $name, false , 'OR');
						$criteriaduplecat->addSearchCondition('tel3', $name, false , 'OR');
						$criteriaduplecat->addSearchCondition('tel4', $name, false , 'OR');
						//$criteriaduplecat->addSearchCondition('email', $email, false , 'OR');

		                    
						$allduplecat= Leads::model()->findAll($criteriaduplecat);


						if(!empty($allduplecat)){
						    
						    
						    	foreach($allduplecat as $duplecat){
							    
									$duplecat->duplicate=1;
									$duplecat->duplicate_date=$today;
									$duplecat->save();
                                    $duplicate = new Duplicate();
                                    $duplicate->date = $today;
                                    $duplicate->time = $time;
                                    $duplicate->leads_id = $duplecat->id;
                                    $duplicate->international_code= $duplecat->international_code;
                                    $duplicate->title = $_POST['Leads']['title'];
                                    $duplicate->tel = $_POST['Leads']['tel'];
                                    $duplicate->user_id = $userid;
                                    $duplicate->save();
								
								
								    $this->redirect(array('sales/profile','secert' => $duplecat->secert), false);

								
								}
						    
						    
						   
						}else{
						    
						     $model->tel=$name;
						    
						}
                                                            
                                                            
                                                            
                ///////////////branch////////////
                $main=Mainsettings::model()->findByPk(1);
                if(!empty($main->default_branch) AND empty($model->branch))$model->branch=$main->default_branch;
                ///////////////branch////////////
                                                            if($model->save()){
                             
                                                                           if(!empty($model->campaign_id)){
                                                                                          $campaign = Campaign::model()->findByAttributes(array('id'=>$model->campaign_id));
                                                                                          $strategy = Strategy::model()->findByAttributes(array('id'=>$campaign->strategy_id));
                                                                                          $strategy->leads += 1;
                                                                                          $strategy->save();
 
 
                                                                                          $lead = Leads::model()->findByAttributes(array('id'=>$model->id));
                                                $lead->secert = $lead->id;
 
                                                                                          $lead->strategy_id = $campaign->strategy_id;
                                                                                          $lead->user_marketing = $campaign->user_id;
                                                                                          
                                                                                         
                                                                           }else{
                                                                                          $lead = Leads::model()->findByAttributes(array('id'=>$model->id));
 
                                                                                          $lead->secert = $lead->id;
                                                                           }
 
 
 
                                                                                          $lead = Leads::model()->findByAttributes(array('id'=>$model->id));
                                                $lead->secert = $lead->id;
                                                $lead->fresh_sales = $lead->user_sales;
              
 
 
 
 
 
 
                                                                           $user=User::model()->findByPk($lead->user_sales);
                                                                          
 
 
 
 
 
 
                                                                           $employee= user::model()->findByAttributes(array('id'=>$userid));
 
 
 

 
                                                                           $lead->save();
 
                                                                           $logsystem = new Logsystem();
                                                                           $logsystem->date = $today;
                                                                           $logsystem->time = $time;
                                                                           $logsystem->action = 'User Create Lead';
                                                                           $logsystem->action_id = $model->id;
                                                                           $logsystem->ip = $model->id;
                                                                           $logsystem->secert = $model->secert;
                                                                           $logsystem->user_id = $userid;
                                                                           $logsystem->save();
 
 
 
 
 
 
 
 
 
 
                                                                           Yii::app()->controller->refresh();
                                                            }else{
 
                                                                           //var_dump($model->getErrors());
 
                                                                           $lead = Leads::model()->findByAttributes(array('tel'=>$_POST['Leads']['tel']));
                                                                           $model->duplicate=1;
                                                                          
                                                                           $this->redirect(array('sales/profile','secert' => $lead->secert), false);
 
                                                            }
                                             }

		
		
		
		
			$this->render('leader',array(
					'userid'=>$userid ,	
					'model'=>$model ,	
					'pages' => $pages,		
					'allleads'=>$allleads ,
					'allcampaign'=>$allcampaign,
					'allproject'=>$allproject,
					'allsales'=>$allsales,
					'allstatues'=>$allstatues,
				    'allplatform'=>$allplatform,




				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);

		}

	}







public function actionTeamleader(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

		
$this->layout='//layouts/systemcgridview';
		
			$model = new Teamleader();
			$model->setScenario('com_porfile');
			
			
			
			
			
			
if(isset($_POST['leadscheckforaction'])){
			    
			    

$userArray = $_POST['leadscheckforaction'] ;
$uniqueArray = array_unique($userArray);

if (!empty($uniqueArray)) {
foreach ($uniqueArray as $uniqueArr) {
    if ($uniqueArr != 0) {
$de= Teamleader::model()->findByAttributes(array('id' => $uniqueArr));
//var_dump($de);exit;
$de->delete();




}

}

}
}   




	
if(isset($_POST['Teamleader'])){
    
    
    
        
        $team=$_POST['teamadd'];
        $usertopleader=User::model()->findByPk($_POST['Teamleader']['leader_id']);
        if(empty($usertopleader->teamname)){
        $usertopleader->teamname=$usertopleader->fname." ".$usertopleader->lname." Team";
        $usertopleader->save();
        } 
        
        
        
        if($team != 1){ 
            
            
        
        
        
    
			$rnd = rand(0,9999);
			$select=$_POST['sales'];
			$teamselected=User::model()->findByPk($_POST['Teamleader']['leader_id']);
    	   //var_dump($_POST['Teamleader']['leader_id']);exit;

        $leadersArray = [];  // Initialize an empty array

// Assuming Teamleader::model()->findAllByAttributes(array('sales_id' => $teamselected->id)) returns an array of Teamleader instances.
$teamLeaders = Teamleader::model()->findAllByAttributes(array('sales_id' => $teamselected->id));
foreach ($teamLeaders as $teamslevel) {
    $leadersArray[] = $teamslevel->leader_id; // Add the current leader ID to the array.
}
// $leadersArray now contains the list of leader IDs obtained through the foreach loop.
if (!empty($leadersArray)) {
foreach ($leadersArray as $leaderId) {
$allteamLeaders2 = Teamleader::model()->findAllByAttributes(array('sales_id' => $leaderId));
if (!empty($allteamLeaders2)) {
foreach ($allteamLeaders2 as $teamLeaders2) {
$leadersArray[] = $teamLeaders2->leader_id; // Add the current leader ID to the array.



}

}else{
}
}
} else {
}
    
            
$uniqueArray = array_unique($leadersArray);
if (!empty($uniqueArray)) {
foreach ($uniqueArray as $uniqueArr) {




foreach((array)$select as $sale){
				    
				  
				    
				    
				    
				        
				        //var_dump(1);exit;
				        //if(!empty($userleader->id) ){ 
				        $model = new Teamleader();
    					$model->attributes = $_POST['Teamleader'];
    					$model->leader_id=$uniqueArr;
    					$model->sales_id=$sale;
    					$model->user_id = $userid;
    					$model->date = $today;
    					$model->time = $time;
    					$model->type = 2;
    					if($model->save()){
	
                       
			    	}

					

			}




}

}else{
    
    
    
    
    	foreach((array)$select as $sale){
				    
				  
				    
				    
				    
				        
				        //var_dump(1);exit;
				        //if(!empty($userleader->id) ){ 
				        $model = new Teamleader();
    					$model->attributes = $_POST['Teamleader'];
    					$model->leader_id=$_POST['Teamleader']['leader_id'];
    					$model->sales_id=$sale;
    					$model->user_id = $userid;
    					$model->date = $today;
    					$model->time = $time;
    					$model->type = 2;
    					if($model->save()){
	
                       
			    	}

}
    





}
		
		
		
		
		
		
        }else{
            
            $select=$_POST['sales'];
      foreach((array)$select as $sale){

            $userleader=User::model()->findByPk($sale); 
            $allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userleader->id ,'order'=>'id DESC'  ));
            $arr=array();
            foreach($allemployee as $leader){
            $model = new Teamleader();
            $model->attributes = $_POST['Teamleader'];
            $model->sales_id=$leader->sales_id;
            $model->user_id = $userid;
            $model->date = $today;
            $model->time = $time; 
            $model->save();
            }
      }
      
        
        
        }
        Yii::app()->controller->refresh();


        }
		
		

     
	
                
                 
                
                
	
	
	
		


			$arr=array();
			$criteria=new CDbCriteria;
			$criteria->order='id DESC';
			$allleaders=Teamleader::model()->findAll($criteria);

			foreach($allleaders as $leader){
				$arr[]=$leader->sales_id;
			}   


			$allteamleader=User::model()->findAll(array('condition'=>'teamleader=1 AND level!=5'));


			$criteria1=new CDbCriteria;
			//$criteria1->addCondition('sales=1');
			//$criteria1->addCondition('');
		$criteria1->addSearchCondition('sales', 1 , false, 'AND');

			//$criteria1->addSearchCondition('teamleader', 0 , false, 'AND');

			//$criteria1->addCondition('teamleader is NULL');
			//$criteria1->addNotInCondition('id', $arr);
			$allsales= User::model()->findAll($criteria1);

			$criteria1=new CDbCriteria;
			//$criteria1->addCondition('sales=1');
			//$criteria1->addCondition('');
			//$criteria1->addSearchCondition('sales', 1 , false, 'AND');

			//$criteria1->addSearchCondition('teamleader', 0 , false, 'AND');

			$criteria1->addCondition('  teamname IS NOT NULL AND level!=5');
			//$criteria1->addNotInCondition('id', $arr);
			$teamleaders= User::model()->findAll($criteria1);





	
		
		
		
			$this->render('teamleader',array(
					'userid'=>$userid ,	
					'model'=>$model ,	
					'allsales'=>$allsales,	
					'allteamleader'=>$allteamleader,
					'allleaders'=>$allleaders,	
					'teamleaders'=>$teamleaders,	
        


				));
		}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);

		}

	}








public function actionProfile($secert){
    
	if(Yii::app()->user->isMember()){
	     try {
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');

		$main=Mainsettings::model()->findByPk(1);
		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

		
		
$this->layout='//layouts/systemcgridview';
		

    $lead = Leads::model()->findByAttributes(array('secert'=>$secert));

		
		
		
		$leadslog= new Leadslog();
		$leadslog->date=$today;
		$leadslog->user_id=$userid;
        $leadslog->time=$time;
        $leadslog->leads_id=$lead->id;
        $leadslog->save();
	
		
		$this->leadname = $lead->title ;
		$this->leadid = $lead->id ;
		$criteria = new CDbCriteria;
		$criteria->addCondition('confirm IS NULL');
		$criteria->addCondition('missed IS NULL');
		$criteria->addSearchCondition('lead_id', $lead->id, false, 'AND');
		$visits= Visit::model()->find($criteria);
		$campaign = Campaign::model()->findByAttributes(array('id'=>$lead->id));
		$allinstallment=Installments::model()->findAll(array( 'condition' => 'lead_id=' . $lead->id ,"order"=>'payment_date ASC'));
		$visible = 1;
		$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allduplicate= Duplicate::model()->findAll(array( 'condition' => 'leads_id=' . $lead->id ,'order'=>'id DESC'  ));
		$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		//$allleads = Leads::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allsales= User::model()->findAll(array('condition'=>'sales=1'));
		//$allstatues= Statues::model()->findAll();
		
		

$criteria = new CDbCriteria();         
$criteria->order = 'sort ASC';
$allstatues= Statues::model()->findAll($criteria);

		$allresults= Results::model()->findAll(array('condition'=>'lead_id='.$secert));
		$allnotes= Notes::model()->findAll(array( 'condition' => 'lead_id=' . $lead->id ,'order'=>'id DESC'  ));
		$allvisit= Visit::model()->findAll(array( 'condition' => 'lead_id=' . $lead->id ,'order'=>'id DESC'  ));
		$allfloor = Floor::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$alltypebuliding = TypeBuliding::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allservices = Services::model()->findAll();
		
		

  //$allresale=new Resale('lead');

             //	$allresale->unsetAttributes();  // clear any default values
           //     if(isset($_GET['Resale'])){
            //    $allresale->attributes=$_GET['Resale'];
            //    }
                
                
                
            
            
          //  $allres=new Reservation('client');
            
         //   $allres->unsetAttributes();  // clear any default values
          //  if(isset($_GET['Reservation'])){
          //  $allres->attributes=$_GET['Reservation'];
         //   }
                  
		

		$message= new Customerservice();


			$criteriam = new CDbCriteria();
			$criteriam->order = 'id DESC';
			$criteriam->condition .= "file IS NOT NULL ";
		        $criteriam->addSearchCondition('lead_id', $lead->id,false, "AND");
			$allmediam=Reservation::model()->findAll($criteriam);

			$criterias = new CDbCriteria();
			$criterias->order = 'id DESC';
			$criterias->condition .= "file IS NOT NULL ";
		        $criterias->addSearchCondition('lead_id', $lead->id,false, "AND");
			$allmedias=DocumentStorage::model()->findAll($criterias);
			                                                        
										
		$oldsales=$lead->user_sales;
		$transfer=new Transfer();										
		if(isset($_POST['Lead'])){
		    
            $lead->transferfrom=$lead->user_sales;
            $lead->transferuser=$userid;
            $lead->user_sales=$_POST['Lead']['sales'];
            $lead->transfer=1;
            $lead->counttransfer=$lead->counttransfer+1;
            $lead->dtime = $time;
            $lead->transferdate=$today;
            //$lead->checkup_activity=$today;
            $lead->visitactive=NULL;
            $lead->communicate_date=$today;
            $lead->communication=NULL;
			$transfer->reason=$_POST['Transfer']['reason'];
			$transfer->hide=$_POST['Transfer']['Hideee'];
			$transfer->hideteamleader=$_POST['Transfer']['Hideteamleader'];
			$transfer->fakenewlead=$_POST['Transfer']['fakenewlead'];

			$lead->transferreason=$transfer->reason;
			if(!empty($lead->backtolife)){
			$lead->backtolifetransfer=1;
			}
			if($lead->save()){
				$lead->close=NULL;
				$lead->save();
				$transfer->user_id=$userid;
				$transfer->lead_id=$lead->id;
				$transfer->fromm=$oldsales;
				$transfer->too=$lead->user_sales;
				$transfer->date= $today ;                     // 03.10.01
				$transfer->time= $time  ;
				if($transfer->save()){ 
                        // Your additional logic here
                        if ($transfer->hide == 1) {
                            

                        $lead = Leads::model()->findByPk($transfer->lead_id);
                        $lead->hiddenactivtiesdate = $today;
                        $lead->transferfrom = $transfer->fromm;
                        $lead->transferuser = $transfer->user_id;
                        $lead->fakedate = NULL;
                        $lead->fake = NULL;
                        $lead->save();
                        if($lead->save()){
                        // Update related activities
                        Yii::app()->db->createCommand()
                        ->update(
                        'activities',
                        array('close' => 1,'hidden' => 1,   'too' => $transfer->too),
                        'leads_id = :lead_id',
                        array(':lead_id' => $lead->id)
                        );
                        }
                        }
                        
                        
                        
                        if ($transfer->hideteamleader == 1) {
                        $lead = Leads::model()->findByPk($transfer->lead_id);
                        $lead->hiddenactivtiesdate = $today;
                        $lead->transferfrom = $transfer->fromm;
                        $lead->transferuser = $transfer->user_id;
                        $lead->fakedate = NULL;
                        $lead->fake = NULL;
                        $lead->save();
                        if($lead->save()){
                        Yii::app()->db->createCommand()
                        ->update(
                        'activities',
                        array('hidden' => 1, 'hideteamleader' => 1, 'close' => 1, 'too' => $transfer->too),
                        'leads_id = :lead_id',
                        array(':lead_id' => $lead->id)
                        );
                        }
                        }
                        
                        
                        
                        
                        
                        if ($transfer->fakenewlead == 1) {
                        $lead = Leads::model()->findByPk($transfer->lead_id);
                        $lead->fake = 1;
                        $lead->fakedate = $today;
                        $lead->transferfrom = $transfer->fromm;
                        $lead->transferuser = $transfer->user_id;
                        $lead->save();
                        if($lead->save()){
                        Yii::app()->db->createCommand()
                        ->update(
                        'activities',
                        array('hidden' => 1, 'hideteamleader' => 1, 'close' => 1, 'too' => $transfer->too),
                        'leads_id = :lead_id',
                        array(':lead_id' => $lead->id)
                        );
                        }
                        }
	    
	    
	    
	    if ($transfer->fakenewlead == 1) {
	        
	        
	        
	        
	        $main = Mainsettings::model()->findByPk(1);
$em=User::model()->findByPk($lead->user_sales);
if (!empty($em->mobile)) {                                                     
                                                                           
$url = Yii::app()->getBaseUrl(true) . "/leads/profile/" . $lead->id;
// Twilio Account SID and Auth Token

$sid    = $main->whatsapp_sid;
$token  = $main->whatsapp_token;

// Recipient's WhatsApp number
$to = "whatsapp:+" . $em->mobile;
// Your WhatsApp Business number
$from = "whatsapp:+" . $main->whatsapp_from;

// Template SID (Use your actual Template SID)
//$templateSid = "HX1a66dc0bb3138ca02fbb2f8a73c8e9d6";

$templateSid = $main->whatsapp_templatesid_1;



if(!empty($main->hide_number_whatsapp)) {                                                     
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $url,
);
}else{
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $lead->international_code.$lead->tel,
);  
}



// Convert TemplateParams to JSON
$templateParams = json_encode($templateParams);

// Twilio API URL for sending template messages
$url = "https://api.twilio.com/2010-04-01/Accounts/$sid/Messages.json";

// Data to be sent in the POST request
$data = array(
    'To' => $to,
    'From' => $from,
    'ContentSid' => $templateSid, // استخدم ContentSid وليس TemplateSid
    'ContentVariables' => $templateParams // استخدم ContentVariables لتمرير المعلمات
);

// Initialize cURL
$ch = curl_init($url);

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_USERPWD, "$sid:$token");

// Execute the request and get the response
$response = curl_exec($ch);

// Check for cURL errors
if ($response === false) {
  //  echo 'cURL Error: ' . curl_error($ch);
} else {
   // $response_data = json_decode($response, true);
    
    // Check if SID exists in the response
    if (isset($response_data['sid'])) {
      //  echo 'Message SID: ' . $response_data['sid'];
    } else {
     //   echo 'No SID found in the response. Full response: ' . print_r($response_data, true);
    }
}

// Close the cURL session
curl_close($ch);

}
 
	        
	        
	        
	    }else{
	        
	       // var_dump('1');exit;
	        
	        
$location =$lead->campaign->title.'-'.$lead->platform->title;	 
//var_dump($location);exit;
$main = Mainsettings::model()->findByPk(1);
$em=User::model()->findByPk($lead->user_sales);
if (!empty($em->mobile)) {                                                     
                                                                           
$url = Yii::app()->getBaseUrl(true) . "/leads/profile/" . $lead->id;
// Twilio Account SID and Auth Token



$sid    = $main->whatsapp_sid;
$token  = $main->whatsapp_token;

// Recipient's WhatsApp number
$to = "whatsapp:+" . $em->mobile;
// Your WhatsApp Business number
$from = "whatsapp:+" . $main->whatsapp_from;

// Template SID (Use your actual Template SID)
//$templateSid = "HXd5381105923e5be56e8b70026fec715c";

$templateSid = $main->whatsapp_templatesid_3;



// Template SID (Use your actual Template SID)


if(!empty($main->hide_number_whatsapp)) {                                                     
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $location,
    '3' => $url,
);
}else{
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $lead->international_code.$lead->tel,
);  
}



// Convert TemplateParams to JSON
$templateParams = json_encode($templateParams);

// Twilio API URL for sending template messages
$url = "https://api.twilio.com/2010-04-01/Accounts/$sid/Messages.json";

// Data to be sent in the POST request
$data = array(
    'To' => $to,
    'From' => $from,
    'ContentSid' => $templateSid, // استخدم ContentSid وليس TemplateSid
    'ContentVariables' => $templateParams // استخدم ContentVariables لتمرير المعلمات
);

// Initialize cURL
$ch = curl_init($url);

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_USERPWD, "$sid:$token");

// Execute the request and get the response
$response = curl_exec($ch);

// Check for cURL errors
if ($response === false) {
  //  echo 'cURL Error: ' . curl_error($ch);
} else {
   // $response_data = json_decode($response, true);
    
    // Check if SID exists in the response
    if (isset($response_data['sid'])) {
      //  echo 'Message SID: ' . $response_data['sid'];
    } else {
     //   echo 'No SID found in the response. Full response: ' . print_r($response_data, true);
    }
}

// Close the cURL session
curl_close($ch);

}
 	        
	        
	        
	        
	        
	        
	        
	        
	    }
				    
				    
				    
				    
				    
		$usercheck=User::model()->findByPk($userid);    
		if($usercheck->addleadup == 1){
       //var_dump($usercheck->addleadup);exit; 
        
            $modelchat = new Chatandsupport();
            $rnd = rand(0,99999);
            $modelchat->date=$today;
            $modelchat->time=$time;
            $modelchat->lead_id=$lead->id;
            $modelchat->user_sales=$userid;
            $modelchat->details='other sales';
            $modelchat->close=1;
            $modelchat->user_id=$userid;
            $modelchat->save();
            if(!$modelchat->save()){
            var_dump($lead->getErrors());
            }
            
    }
				    
				    
				    $main=Mainsettings::model()->findByPk(1);
$iconurl=Yii::app()->getBaseUrl(true).'/img/'.$main->logo;
							

// Assuming $transfer is an instance of some model with lead_id property
$leadId = $transfer->lead_id;
$tooValue = $transfer->too;

// Update 'activities' table
$condition = "leads_id = :lead_id AND close IS NULL";
$params = array(':lead_id' => $leadId);

Activities::model()->updateAll(
    array('too' => $tooValue),
    $condition,
    $params
);

			
					



					Yii::app()->controller->refresh();
				}
			}
			
			
			
			
			
			
			
			
		}
		
		$model = new Activities();
		$model->setScenario('com_porfile');
		if(isset($_POST['Activities'])){
			$rnd = rand(0,9999);
			$model->attributes = $_POST['Activities'];
			$model->user_id = $userid;
			$model->date = $today;
			$model->time = $time;
			$model->leads_id = $lead->id;

			$user=User::model()->findByPk($userid);
			//check for salesmanger or teamleader
            if($user->salesmanger ==1 or $user->teamleader ==1 ){
               $model->manger_id=$user->id; 
            }
			//check for salesmanger or teamleader

			$model->name=$lead->title;
			$model->code=$_POST['code'];
			$model->tel=$lead->tel;
			$model->coldcall=$lead->coldcall;
			$model->indirect=$lead->indirect;
			$model->user_id = $lead->user_sales;
            $model->lead_date= $lead->date;


                                
			$model->secert = $rnd.$userid;

			    $substatus=Substatus::model()->findByPk($_POST['Activities']['substatus']);
			    $status=Statues::model()->findByPk($_POST['Activities']['status']);
                      
                 if($substatus->answer == 1){
                $lead->answer=1;
                $model->answer=1;
                }
                
                
                if($status->answer == 1){
                $lead->answer=1;
                $model->answer=1;
                }
                
                
                if($substatus->answer == 2){
                $lead->answer=2;
                $model->answer=2;
                }
                
                
                 
                if($status->answer == 2){
                $lead->answer=2;
                $model->answer=2;
                }
                
                
                                              
   if($substatus->expvisit == 1){
       $lead->expvisit=1;
                $model->expvisit=1;
                }
			
			
			
			
			                                        
   if($status->expvisit == 1){
       $lead->expvisit=1;
                $model->expvisit=1;
                }
			
			
			
		 if($substatus->callback == 1){
                $lead->callback=1;
				$model->callback=1;
                }	
		 
		 
		 
		      if($status->callback == 1){
            $lead->callback=1;
            $model->callback=1;
            }	

			 
                               
                
                

			if($model->save()){
				$model->secert=$model->id;
				$model->save();
					
					
					
					
					 $lead->sales_report=$model->report;
                                $lead->communication=1;
                                
                                 if(empty($lead->first_communication)){
                $lead->first_communication=$userid;
                }
                                $lead->follow_date=$model->follow_date;
                                $lead->follow_time=$model->follow_time;
                                $lead->action_time=$model->time;


                                $lead->checkup_activity=$today;
                                $lead->visitactive=NULL;
                               $lead->details= $lead->details.'  /  '.$today.'/ '.$model->details;
                               
                               $lead->status=$model->status;

                                 
                                $qualifiedtest=Statues::model()->findByPk($model->status);
                                
                                  if($qualifiedtest->close == 1){   
                                      
                                                                      //var_dump($qualifiedtest);exit;

                $lead->close=1;
				$lead->reopen=NULL;
				$lead->communication=1;
				$lead->close_date= $today;
				$model->report= 'Closed In '.$today.'-'.$model->details;
				$model->close= 1;
$model->save();
				$lead->save();
               
                }
                                
                                
                
                if($qualifiedtest->qualified == 1){
                $lead->qualified=1;
                  if(empty($lead->first_classification)){
                    
                $lead->first_classification=1;
                $lead->first_classification_user=$userid; 
                    
                }
                }
                
                
                if($qualifiedtest->nonqualified == 1){
                $lead->nonqualified=1;
                  if(empty($lead->first_classification)){
                    
                $lead->first_classification=2; 
                $lead->first_classification_user=$userid; 
                
                    
                }
                }
                
                        
                
                
                
					
					
					
				






	
							
							
							
				$lead->status = $model->status;
				$lead->substatus = $model->substatus;
				$lead->checkup_activity= $model->date;
				$lead->sales_report = $model->details;
				$lead->communication = 1;
				
				if($lead->feedback_date==0000-00-00){
				    
				$lead->feedback_date= $lead->date;

				}

				$lead->save();




				//SMS

				$statues= Statues::model()->findByPk($model->status);

				if($statues->duplicate==1){



					$smsmessagecontent = rawurlencode($statues->sms_text);
					$curl = curl_init();

					curl_setopt_array($curl, array(
							CURLOPT_URL => "https://smsmisr.com/api/webapi/?username=".$main->username."&password=".$main->password."&language=2&sender=".$main->sender."&mobile=".$lead->international_code.$lead->tel."&message=".$smsmessagecontent ,
							CURLOPT_RETURNTRANSFER => true,
							CURLOPT_ENCODING => "",
							CURLOPT_MAXREDIRS => 10,
							CURLOPT_TIMEOUT => 30,
							CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
							CURLOPT_CUSTOMREQUEST => "POST",
							CURLOPT_HTTPHEADER => array(
								'Content-Type: application/json', 
								'Content-Length:0 ' ,
								"Cache-Control: no-cache",
							),
						));

					$response = curl_exec($curl);
					$err = curl_error($curl);
//var_dump($response);
					$sms= new Smssheet();
					$sms->date=$today;
					$sms->time=$time;
					$sms->tomobile=$lead->tel;
					$sms->totitle=$lead->title;
					$sms->content=$statues->sms_text;
					$sms->user_id=1;
					if(!$sms->save()){
						$errores = $sms->getErrors();
						//var_dump($errores);
					}



				}else{


					$past= new CDbCriteria();
					$past->addSearchCondition('leads_id', $lead->id, false, 'AND');
					$past->addSearchCondition('status', $model->status, false);

					$activities= Activities::model()->findAll($past);


					if(!empty($activities) ){

						$smsmessagecontent = rawurlencode($statues->sms_text);
						$curl = curl_init();

						curl_setopt_array($curl, array(
								CURLOPT_URL => "https://smsmisr.com/api/webapi/?username=".$main->username."&password=".$main->password."&language=2&sender=".$main->sender."&mobile=".$lead->international_code.$lead->tel."&message=".$smsmessagecontent ,
								CURLOPT_RETURNTRANSFER => true,
								CURLOPT_ENCODING => "",
								CURLOPT_MAXREDIRS => 10,
								CURLOPT_TIMEOUT => 30,
								CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
								CURLOPT_CUSTOMREQUEST => "POST",
								CURLOPT_HTTPHEADER => array(
									'Content-Type: application/json', 
									'Content-Length:0 ' ,
									"Cache-Control: no-cache",
								),
							));

						$response = curl_exec($curl);
						$err = curl_error($curl);

						$sms= new Smssheet();
						$sms->date=$today;
						$sms->time=$time;
						$sms->tomobile=$lead->tel;
						$sms->totitle=$lead->title;
						$sms->content=$statues->sms_text;
						$sms->user_id=1;
						if(!$sms->save()){
							$errores = $sms->getErrors();
							//var_dump($errores);
						}


					}




				}

				$logsystem = new Logsystem();
				$logsystem->date = $today;
				$logsystem->time = $time;
				$logsystem->action = 'User Create Activities';
				$logsystem->action_id = $model->id;
				$logsystem->ip = $model->id;
				$logsystem->secert = $model->secert;
				$logsystem->user_id = $userid;
				$logsystem->save();

    		     //add best sales
                    $userid=Yii::app()->user->id;
                	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
                	$today = date("Y-m-d");
                    $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
                    if(!empty($best)){
                        $best->actnum+=1;
                        $best->save();
                    }else{
                        $best =new Bestsales();
                        $best->user_sales=$userid;
                        $best->date=$today;
                        $best->actnum=1;
                        $best->save();
                    }
                    //add bestsales
                    
                     //notification to team leaders AND Salesmanger
                $allsalesmanger=User::model()->findAll(array('condition'=>'salesmanger=1 AND level=1 AND activitiesnotifi=1 '));
                $arr=array();
				foreach($allsalesmanger as $sales){	
				    $arr[]=$sales->id;
				}
				$criteria = new CDbCriteria;
				$criteria->addCondition('sales_id=' . $lead->user_sales);
				$leaders=Teamleader::model()->findAll($criteria); 
				if(!empty($leaders)){
				    foreach($leaders as $teamlleader){
				        $arr[]=$teamlleader->leader_id;
				    }
				}
				
                $criteria = new CDbCriteria();         
        		$criteria->order = 'id DESC';
        		$criteria->addInCondition('userid',$arr);
        		$vars= FirebaseToken::model()->findAll($criteria);
                
                $arr=array();
                if(!empty($vars)){
                			foreach($vars as $var){
                    			$arr[]=$var->token;
                			}
                
                } 
				$man=User::model()->findByPk($userid);
	 
                $main=Mainsettings::model()->findByPk(1);
                $iconurl=Yii::app()->getBaseUrl(true).'/img/'.$main->logo;
                $fields = array(
                        'registration_ids' =>  $arr ,
                        'data' => array( "title" => " Activities ", "body" => $lead->title." Has a New Activity Written By :  ".$man->username  ,"icon" => $iconurl , "click_action" => Yii::app()->getBaseUrl(true).'/leads/profile/'.$lead->id),
                    );
                $url = 'https://fcm.googleapis.com/fcm/send';

                $headers = array(
                    'Authorization: key='.$main->appkey ,
                    'Content-Type: application/json'
                );
                // Open connection
                $ch = curl_init();
            
                // Set the url, number of POST vars, POST data
                curl_setopt($ch, CURLOPT_URL, $url);
            
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            
                // Disabling SSL Certificate support temporarly
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
            
                // Execute post
                $result = curl_exec($ch);
                // echo "Result".$result;
                if ($result === FALSE) {
                    die('Curl failed: ' . curl_error($ch));
                }
            
                // Close connection
                curl_close($ch); 

				Yii::app()->controller->refresh();
			}
		
		}


		$matchlead = new CDbCriteria();
		$matchlead->addSearchCondition('hidden', $visible, false);
		$matchlead->addSearchCondition('tel', $lead->tel, false);

		$allmatchlead = Leads::model()->findAll($matchlead);	
		$allactivities = Activities::model()->findAll(array( 'condition' => 'leads_id=' . $lead->id ,'order'=>'date DESC, id DESC'  ));
		

		
       // $lastactivities = new CDbCriteria;
        //$lastactivities->order = 'id DESC';
       // $lastactivities->limit = 1;
       // $lastactivities->addCondition('close IS NULL');
       // $lastactivities->addSearchCondition('leads_id', $lead->id, false, 'AND');
       // $alllastactivities= Activities::model()->findAll($lastactivities);
        

		
		$alllastactivities = Activities::model()->findAll(array( 'condition' => 'leads_id=' . $lead->id ,'limit'=>1 ,'order'=>'id DESC'  ));
			
		
		
		$allfav= LikeUnit::model()->findAll(array( 'condition' => 'lead_id=' . $lead->id ,'order'=>'id DESC'  ));


	        $criteria2 = new CDbCriteria;
		$criteria2->addSearchCondition('action_id', $lead->id, false);
		$criteria2->addSearchCondition('ip', 'update', false);
		$alllog=Logsystem::model()->findAll($criteria2);
		$allusers= User::model()->findAll(array('order'=>'id DESC'  ));	
		
		
		
		
	$request=new Request;
	$model->setScenario('com_porfile');
		if(isset($_POST['Request'])){
			$rnd = rand(0,9999);
			$request->attributes = $_POST['Request'];
			$request->user_id = $userid;
			$request->date = $today;
			$request->time = $time;
			$request->lead_id = $lead->id;
			
			if($request->save()){ 
			    
			    
			    	Yii::app()->controller->refresh();
				    
				    
			}
			
		}
		
		
		
		
		
			
	$newresale=new Resaleupdate;
	$newresale->setScenario('com_porfile');
		if(isset($_POST['Resaleupdate'])){
			$rnd = rand(0,9999);
			$newresale->attributes = $_POST['Resaleupdate'];
			$newresale->user_id = $userid;
			$newresale->date = $today;
			$newresale->time = $time;

			if($newresale->save()){ 
			    
			    
			    	Yii::app()->controller->refresh();
				    
				    
			}else{
			    
			    var_dump($newresale->getErrors());exit;

			    
			    
			}
			
		}
		
		
		
		
		
		
		
		
		
	$comments=new Comments;
	$comments->setScenario('com_porfile');
		if(isset($_POST['Comments'])){
			$rnd = rand(0,9999);
			$comments->attributes = $_POST['Comments'];
			$comments->user_id = $userid;
			$comments->date = $today;
			$comments->time = $time;
			$comments->lead_id = $lead->id;
			if(isset($_POST['Comments']['mention'])){
			$comments->mention = 1;    
			}
          
			
			
			if($comments->save()){ 
			    
			    
         
$main = Mainsettings::model()->findByPk(1);
$em=User::model()->findByPk($lead->user_sales);
if (!empty($em->mobile)) {     
    
                                                                           
$url = Yii::app()->getBaseUrl(true) . "/leads/profile/" . $lead->id;
// Twilio Account SID and Auth Token


$sid    = $main->whatsapp_sid;
$token  = $main->whatsapp_token;

// Recipient's WhatsApp number
$to = "whatsapp:+" . $em->mobile;
// Your WhatsApp Business number
$from = "whatsapp:+" . $main->whatsapp_from;

// Template SID (Use your actual Template SID)
//$templateSid = "HX1a66dc0bb3138ca02fbb2f8a73c8e9d6";

$templateSid = "HXee824ff4880041c4a7df2172235cfa4a";

$templateParams = array(
    '1' => $lead->title,
    '2' => $url,
);





// Convert TemplateParams to JSON
$templateParams = json_encode($templateParams);

// Twilio API URL for sending template messages
$url = "https://api.twilio.com/2010-04-01/Accounts/$sid/Messages.json";

// Data to be sent in the POST request
$data = array(
    'To' => $to,
    'From' => $from,
    'ContentSid' => $templateSid, // استخدم ContentSid وليس TemplateSid
    'ContentVariables' => $templateParams // استخدم ContentVariables لتمرير المعلمات
);

// Initialize cURL
$ch = curl_init($url);

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_USERPWD, "$sid:$token");

// Execute the request and get the response
$response = curl_exec($ch);

// Check for cURL errors
if ($response === false) {
  //  echo 'cURL Error: ' . curl_error($ch);
} else {
   // $response_data = json_decode($response, true);
    
    // Check if SID exists in the response
    if (isset($response_data['sid'])) {
      //  echo 'Message SID: ' . $response_data['sid'];
    } else {
     //   echo 'No SID found in the response. Full response: ' . print_r($response_data, true);
    }
}

// Close the cURL session
curl_close($ch);

}
 
			    
            if(isset($_POST['Comments']['mention'])){
            foreach ($_POST['Comments']['mention'] as $value) {
                
                
                
            
            $mention=new Mention;
            $rnd = rand(0,9999);
            $mention->user_id = $userid;
            $mention->date = $today;
            $mention->time = $time;
            $mention->too = $value;
            $mention->comments_id = $comments->id;
            $mention->save();
			
                
            
            //var_dump($value);exit;
            }
            
            
   
            
            
            
            
            }
			
			    
			    	Yii::app()->controller->refresh();
				    
				    
			}
			
		}
		
		$allcomments = Comments::model()->findAll(array( 'condition' => 'lead_id=' . $lead->id ,'order'=>'id DESC'  ));

		
	
		
		
		
		
 		
		
		$this->render('profile',array(
				'userid'=>$userid ,	
				'model'=>$model ,	
				'allfav'=>$allfav,			 
				'allcampaign'=>$allcampaign,
				'allproject'=>$allproject,
				'lead'=>$lead,
				'allmatchlead'=>$allmatchlead,
				'allactivities'=>$allactivities,
				'alllastactivities'=>$alllastactivities,
				'allservices'=>$allservices,
				'message'=>$message,
				'allfloor'=>$allfloor,
				'alltypebuliding'=>$alltypebuliding,
				'allsales'=>$allsales,
				'allstatues'=>$allstatues,
				'allduplicate'=>$allduplicate,
				'allnotes'=>$allnotes,
				'allvisit'=>$allvisit,
				'transfer'=>$transfer,
				'campaign'=>$campaign,
				'allusers'=>$allusers,
				'allplatform'=>$allplatform,
				'allinstallment'=>$allinstallment,
				'allresults'=>$allresults,
				'alllog'=>$alllog,
				'allmediam'=>$allmediam,
				'allmedias'=>$allmedias,
				'visits'=>$visits,
				'note'=>$note,
				'request'=>$request,
				'allresale'=>$allresale,
			    'allres'=>$allres,
			    'newresale'=>$newresale,
			    'comments'=>$comments,
			     'allcomments'=>$allcomments,
			    
				
				
			  



			));
			
		
} catch(CDbException $e) {
    var_dump($e);exit;
    $this->redirect(array('home/error')	);

}	
			
			
	}


	else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
	}

}












	public function actionSearchindirect(){
	    
	    	if(Yii::app()->user->isMember()){
	    
			$userid=Yii::app()->user->id;
			$user=User::model()->findByPk($userid);
		if(isset($_REQUEST['search'])){

			$arrayofinfo=array('title'=>$_REQUEST['search'],'tel'=>$_REQUEST['tel'],'startdate'=>$_REQUEST['startdate'],'enddate'=>$_REQUEST['enddate']);
			$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';


			if(!empty($_REQUEST['search']) ){
				$criteria->addSearchCondition('name', $_REQUEST['search'],TRUE, "AND");
			}

			if(!empty($_REQUEST['company']) ){
				$criteria->addSearchCondition('company_id', $_REQUEST['company'],false, "AND");
			}


			if(!empty($_REQUEST['tel']) ){

$phone= $_REQUEST['tel'];

$phone= ltrim($phone, '0');
if($phone[0]=='0')
    $phone = substr($phone , 1);
$countrys = [
							'44' => 'UK (+44)',
							'213' => 'Algeria (+213)',
							'376' => 'Andorra (+376)',
							'244' => 'Angola (+244)',
							'1264' => 'Anguilla (+1264)',
							'1268' => 'Antigua & Barbuda (+1268)',
							'54' => 'Argentina (+54)',
							'374' => 'Armenia (+374)',
							'297' => 'Aruba (+297)',
							'61' => 'Australia (+61)',
							'43' => 'Austria (+43)',
							'994' => 'Azerbaijan (+994)',
							'1242' => 'Bahamas (+1242)',
							'973' => 'Bahrain (+973)',
							'880' => 'Bangladesh (+880)',
							'1246' => 'Barbados (+1246)',
							'375' => 'Belarus (+375)',
							'32' => 'Belgium (+32)',
							'501' => 'Belize (+501)',
							'229' => 'Benin (+229)',
							'1441' => 'Bermuda (+1441)',
							'975' => 'Bhutan (+975)',
							'591' => 'Bolivia (+591)',
							'387' => 'Bosnia Herzegovina (+387)',
							'267' => 'Botswana (+267)',
							'55' => 'Brazil (+55)',
							'673' => 'Brunei (+673)',
							'359' => 'Bulgaria (+359)',
							'226' => 'Burkina Faso (+226)',
							'257' => 'Burundi (+257)',
							'855' => 'Cambodia (+855)',
							'237' => 'Cameroon (+237)',
							'238' => 'Cape Verde Islands (+238)',
							'1345' => 'Cayman Islands (+1345)',
							'236' => 'Central African Republic (+236)',
							'56' => 'Chile (+56)',
							'86' => 'China (+86)',
							'57' => 'Colombia (+57)',
							'269' => 'Comoros (+269)',
							'242' => 'Congo (+242)',
							'682' => 'Cook Islands (+682)',
							'506' => 'Costa Rica (+506)','225' => 'Cote d Ivoire (+225)',
							'385' => 'Croatia (+385)',
							'53' => 'Cuba (+53)',
							'90392' => 'Cyprus North (+90392)',
							'357' => 'Cyprus South (+357)',
							'420' => 'Czech Republic (+420)',
							'45' => 'Denmark (+45)',
							'253' => 'Djibouti (+253)',
							'1809' => 'Dominica (+1809)',
							'1809' => 'Dominican Republic (+1809)',
							'593' => 'Ecuador (+593)',
							'20' => 'Egypt (+20)',
							'503' => 'El Salvador (+503)',
							'240' => 'Equatorial Guinea (+240)',
							'291' => 'Eritrea (+291)',
							'372' => 'Estonia (+372)',
							'251' => 'Ethiopia (+251)',
							'500' => 'Falkland Islands (+500)',
							'298' => 'Faroe Islands (+298)',
							'679' => 'Fiji (+679)',
							'358' => 'Finland (+358)',
							'33' => 'France (+33)',
							'594' => 'French Guiana (+594)',
							'689' => 'French Polynesia (+689)',
							'241' => 'Gabon (+241)',
							'220' => 'Gambia (+220)',
							'995' => 'Georgia (+995)',
							'49' => 'Germany (+49)',
							'233' => 'Ghana (+233)',
							'350' => 'Gibraltar (+350)',
							'30' => 'Greece (+30)',
							'299' => 'Greenland (+299)',
							'1473' => 'Grenada (+1473)',
							'590' => 'Guadeloupe (+590)',
							'671' => 'Guam (+671)',
							'502' => 'Guatemala (+502)',
							'224' => 'Guinea (+224)',
							'245' => 'Guinea - Bissau (+245)',
							'592' => 'Guyana (+592)',
							'509' => 'Haiti (+509)',
							'504' => 'Honduras (+504)',
							'852' => 'Hong Kong (+852)',
							'36' => 'Hungary (+36)',
							'354' => 'Iceland (+354)',
							'91' => 'India (+91)',
							'62' => 'Indonesia (+62)',
							'98' => 'Iran (+98)',
							'964' => 'Iraq (+964)',
							'353' => 'Ireland (+353)',
							'39' => 'Italy (+39)','972' => 'Israel (+972)',
							'1876' => 'Jamaica (+1876)',
							'81' => 'Japan (+81)',
							'962' => 'Jordan (+962)',
							'7' => 'Kazakhstan (+7)',
							'254' => 'Kenya (+254)',
							'686' => 'Kiribati (+686)',
							'850' => 'Korea North (+850)',
							'82' => 'Korea South (+82)',
							'965' => 'Kuwait (+965)',
							'996' => 'Kyrgyzstan (+996)',
							'856' => 'Laos (+856)',
							'371' => 'Latvia (+371)',
							'961' => 'Lebanon (+961)',
							'266' => 'Lesotho (+266)',
							'231' => 'Liberia (+231)',
							'218' => 'Libya (+218)',
							'417' => 'Liechtenstein (+417)',
							'370' => 'Lithuania (+370)',
							'352' => 'Luxembourg (+352)',
							'853' => 'Macao (+853)',
							'389' => 'Macedonia (+389)',
							'261' => 'Madagascar (+261)',
							'265' => 'Malawi (+265)',
							'60' => 'Malaysia (+60)',
							'960' => 'Maldives (+960)',
							'223' => 'Mali (+223)',
							'356' => 'Malta (+356)',
							'692' => 'Marshall Islands (+692)',
							'596' => 'Martinique (+596)',
							'222' => 'Mauritania (+222)',
							'269' => 'Mayotte (+269)',
							'52' => 'Mexico (+52)',
							'691' => 'Micronesia (+691)',
							'373' => 'Moldova (+373)',
							'377' => 'Monaco (+377)',
							'976' => 'Mongolia (+976)',
							'1664' => 'Montserrat (+1664)',
							'212' => 'Morocco (+212)',
							'258' => 'Mozambique (+258)',
							'95' => 'Myanmar (+95)',
							'264' => 'Namibia (+264)',
							'674' => 'Nauru (+674)',
							'977' => 'Nepal (+977)',
							'31' => 'Netherlands (+31)',
							'687' => 'New Caledonia (+687)',
							'64' => 'New Zealand (+64)',
							'505' => 'Nicaragua (+505)',
							'227' => 'Niger (+227)',
							'234' => 'Nigeria (+234)',
							'683' => 'Niue (+683)',
							'672' => 'Norfolk Islands (+672)',
							'670' => 'Northern Marianas (+670)',
							'47' => 'Norway (+47)',
							'968' => 'Oman (+968)',
							'680' => 'Palau (+680)','970' => 'Palestine (+970)',
							'507' => 'Panama (+507)',
							'675' => 'Papua New Guinea (+675)',
							'595' => 'Paraguay (+595)',
							'51' => 'Peru (+51)',
							'63' => 'Philippines (+63)',
							'48' => 'Poland (+48)',
							'351' => 'Portugal (+351)',
							'1787' => 'Puerto Rico (+1787)',
							'974' => 'Qatar (+974)',
							'262' => 'Reunion (+262)',
							'40' => 'Romania (+40)',
							'7' => 'Russia (+7)',
							'250' => 'Rwanda (+250)',
							'378' => 'San Marino (+378)',
							'239' => 'Sao Tome & Principe (+239)',
							'966' => 'Saudi Arabia (+966)',
							'221' => 'Senegal (+221)',
							'381' => 'Serbia (+381)',
							'248' => 'Seychelles (+248)',
							'232' => 'Sierra Leone (+232)',
							'65' => 'Singapore (+65)',
							'421' => 'Slovak Republic (+421)',
							'386' => 'Slovenia (+386)',
							'677' => 'Solomon Islands (+677)',
							'252' => 'Somalia (+252)',
							'27' => 'South Africa (+27)',
							'34' => 'Spain (+34)',
							'94' => 'Sri Lanka (+94)',
							'290' => 'St. Helena (+290)',
							'1869' => 'St. Kitts (+1869)',
							'1758' => 'St. Lucia (+1758)',
							'249' => 'Sudan (+249)','211' => 'South Sudan (+211)',
							'597' => 'Suriname (+597)',
							'268' => 'Swaziland (+268)',
							'46' => 'Sweden (+46)',
							'41' => 'Switzerland (+41)',
							'963' => 'Syria (+963)',
							'886' => 'Taiwan (+886)',
							'7' => 'Tajikstan (+7)',
							'66' => 'Thailand (+66)',
							'228' => 'Togo (+228)',
							'676' => 'Tonga (+676)',
							'1868' => 'Trinidad & Tobago (+1868)',
							'216' => 'Tunisia (+216)',
							'90' => 'Turkey (+90)',
							'7' => 'Turkmenistan (+7)',
							'993' => 'Turkmenistan (+993)',
							'1649' => 'Turks & Caicos Islands (+1649)',
							'688' => 'Tuvalu (+688)',
							'256' => 'Uganda (+256)',
							'380' => 'Ukraine (+380)',
							'971' => 'United Arab Emirates (+971)',
							'598' => 'Uruguay (+598)',
							'7' => 'Uzbekistan (+7)',
							'678' => 'Vanuatu (+678)',
							'379' => 'Vatican City (+379)',
							'58' => 'Venezuela (+58)',
							'84' => 'Vietnam (+84)',
							'84' => 'Virgin Islands - British (+1284)',
							'84' => 'Virgin Islands - US (+1340)',
							'681' => 'Wallis & Futuna (+681)',
							'969' => 'Yemen (North)(+969)',
							'967' => 'Yemen (South)(+967)',
							'260' => 'Zambia (+260)',
							'263' => 'Zimbabwe (+263)',
						];

						$temp=  substr(strstr($phone, '+'),1);
					if($temp != false){$phone=$temp;}
                                                $countrycode='';
						// sort the array by key, descending
						krsort($countrys, SORT_NUMERIC);

						// iterate over all countries
						foreach($countrys as $we => $ccode){
							// if number begins with current number
							if(strpos($phone, '' . $we) === 0){
								// store country code and break the loop
								$countrycode = $we;
								break;
							}
						}

						if(!empty($countrycode)){
							$size=strlen($countrycode);
							$phone=substr($phone,$size);
						}



				$criteria->addSearchCondition('mobile', $phone ,TRUE, "AND");
			}



			

			









			$allleadss = BrokerLeads::model()->findAll($criteria);    



			$criteriatransfer = new CDbCriteria();
			$criteriatransfer->order = 'id DESC';
   



			$userid=Yii::app()->user->id;
			$user=User::model()->findByPk($userid);
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s"); 

			$visible = 1;














			$count=BrokerLeads::model()->count($criteria);

    
			$dataProvider = new CActiveDataProvider('BrokerLeads', array(
					'pagination' => array(
						'pageSize' =>50,
					),
					'criteria' => $criteria,
				));
			$allleads = BrokerLeads::model()->findAll($criteria);

					
		} 





		

		$this->render('indirectresult', array(
											
				'arrayofinfo' => $arrayofinfo,					
				'allleads' => $allleads,
				'allleadss' => $allleadss,
				'count'=>$count,
				'dataProvider'=>$dataProvider, 
    

											
			));
			
			
	    	}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
	}





	public function actionSearchforall(){
	    
	

	if(Yii::app()->user->isMember()){    

	    $this->layout = '//layouts/systemcgridview';
	    
		if(($_REQUEST['search'])OR !empty($_REQUEST['tel'])OR !empty($_REQUEST['x'])OR !empty($_REQUEST['idcard'])OR !empty($_REQUEST['code']) OR !empty($_REQUEST['campaign']) OR !empty($_REQUEST['platform'])){
			$userid=Yii::app()->user->id;
			$user=User::model()->findByPk($userid);
			//var_dump($_REQUEST['x']);exit;
		    
			$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
			
	    //	if(!empty($_REQUEST['search']) ){
			//	$criteria->addSearchCondition('title', $_REQUEST['search'],TRUE, "AND");
		//	}
			
			
			
                if (!empty($_REQUEST['search'])) {
                $searchTerm = $_REQUEST['search'];
                $criteria->addSearchCondition('title', $searchTerm, true, 'OR');
                
                // Search in the reservation table based on lead_id
                $reservationCriteria = new CDbCriteria;
                $reservationCriteria->with = 'lead';
                $reservationCriteria->addSearchCondition('name', $searchTerm, true, 'OR');
                $reservationRecords = Reservation::model()->findAll($reservationCriteria);
                
                // Extract lead_id from reservation records
                $leadIds = [];
                foreach ($reservationRecords as $reservationRecord) {
                $leadIds[] = $reservationRecord->lead_id;
                }
                
                // Include lead_id in the search condition for leads
                if (!empty($leadIds)) {
                $criteria->addInCondition('id', $leadIds, 'OR');
                }
                }

			
            
            
            $main=Mainsettings::model()->findByPk(1);	    
            if(empty($main->fakecode)){
            if(!empty($_REQUEST['code']) ){
            $criteria->addSearchCondition('id', $_REQUEST['code'],true, "AND");
            }
            }else{
            $criteria->addSearchCondition('code', $_REQUEST['code'],true, "AND");
            }			
			
			
			
			
			
				if(!empty($_REQUEST['x']) ){
				$criteria->addSearchCondition('units', $_REQUEST['x'],TRUE, "AND");
			}
			
			
			
			
			
			
				if(!empty($_REQUEST['campaign']) ){
				$criteria->addSearchCondition('campaign_id', $_REQUEST['campaign'],false, "AND");
			}
			
			
			
			
			
				if(!empty($_REQUEST['platform']) ){
				$criteria->addSearchCondition('platform_id', $_REQUEST['platform'],false, "AND");
			}
			
			
			
			
				
				if(!empty($_REQUEST['idcard']) ){
				$criteria->addSearchCondition('idcard', $_REQUEST['idcard'],false, "AND");
			}
			
			
			if(!empty($_REQUEST['tel']) ){

$phone= $_REQUEST['tel'];
if (strlen($phone) > 6) {
if($phone[0]=='0')
    $phone = substr($phone , 1);
$countrys = [
    '1' => 'USA (+1)',
							'44' => 'UK (+44)',
							'213' => 'Algeria (+213)',
							'376' => 'Andorra (+376)',
							'244' => 'Angola (+244)',
							'1264' => 'Anguilla (+1264)',
							'1268' => 'Antigua & Barbuda (+1268)',
							'54' => 'Argentina (+54)',
							'374' => 'Armenia (+374)',
							'297' => 'Aruba (+297)',
							'61' => 'Australia (+61)',
							'43' => 'Austria (+43)',
							'994' => 'Azerbaijan (+994)',
							'1242' => 'Bahamas (+1242)',
							'973' => 'Bahrain (+973)',
							'880' => 'Bangladesh (+880)',
							'1246' => 'Barbados (+1246)',
							'375' => 'Belarus (+375)',
							'32' => 'Belgium (+32)',
							'501' => 'Belize (+501)',
							'229' => 'Benin (+229)',
							'1441' => 'Bermuda (+1441)',
							'975' => 'Bhutan (+975)',
							'591' => 'Bolivia (+591)',
							'387' => 'Bosnia Herzegovina (+387)',
							'267' => 'Botswana (+267)',
							'55' => 'Brazil (+55)',
							'673' => 'Brunei (+673)',
							'359' => 'Bulgaria (+359)',
							'226' => 'Burkina Faso (+226)',
							'257' => 'Burundi (+257)',
							'855' => 'Cambodia (+855)',
							'237' => 'Cameroon (+237)',
							'238' => 'Cape Verde Islands (+238)',
							'1345' => 'Cayman Islands (+1345)',
							'236' => 'Central African Republic (+236)',
							'56' => 'Chile (+56)',
							'86' => 'China (+86)',
							'57' => 'Colombia (+57)',
							'269' => 'Comoros (+269)',
							'242' => 'Congo (+242)',
							'682' => 'Cook Islands (+682)',
							'506' => 'Costa Rica (+506)','225' => 'Cote d Ivoire (+225)',
							'385' => 'Croatia (+385)',
							'53' => 'Cuba (+53)',
							'90392' => 'Cyprus North (+90392)',
							'357' => 'Cyprus South (+357)',
							'420' => 'Czech Republic (+420)',
							'45' => 'Denmark (+45)',
							'253' => 'Djibouti (+253)',
							'1809' => 'Dominica (+1809)',
							'1809' => 'Dominican Republic (+1809)',
							'593' => 'Ecuador (+593)',
							'20' => 'Egypt (+20)',
							'503' => 'El Salvador (+503)',
							'240' => 'Equatorial Guinea (+240)',
							'291' => 'Eritrea (+291)',
							'372' => 'Estonia (+372)',
							'251' => 'Ethiopia (+251)',
							'500' => 'Falkland Islands (+500)',
							'298' => 'Faroe Islands (+298)',
							'679' => 'Fiji (+679)',
							'358' => 'Finland (+358)',
							'33' => 'France (+33)',
							'594' => 'French Guiana (+594)',
							'689' => 'French Polynesia (+689)',
							'241' => 'Gabon (+241)',
							'220' => 'Gambia (+220)',
							'995' => 'Georgia (+995)',
							'49' => 'Germany (+49)',
							'233' => 'Ghana (+233)',
							'350' => 'Gibraltar (+350)',
							'30' => 'Greece (+30)',
							'299' => 'Greenland (+299)',
							'1473' => 'Grenada (+1473)',
							'590' => 'Guadeloupe (+590)',
							'671' => 'Guam (+671)',
							'502' => 'Guatemala (+502)',
							'224' => 'Guinea (+224)',
							'245' => 'Guinea - Bissau (+245)',
							'592' => 'Guyana (+592)',
							'509' => 'Haiti (+509)',
							'504' => 'Honduras (+504)',
							'852' => 'Hong Kong (+852)',
							'36' => 'Hungary (+36)',
							'354' => 'Iceland (+354)',
							'91' => 'India (+91)',
							'62' => 'Indonesia (+62)',
							'98' => 'Iran (+98)',
							'964' => 'Iraq (+964)',
							'353' => 'Ireland (+353)',
							'39' => 'Italy (+39)','972' => 'Israel (+972)',
							'1876' => 'Jamaica (+1876)',
							'81' => 'Japan (+81)',
							'962' => 'Jordan (+962)',
							'7' => 'Kazakhstan (+7)',
							'254' => 'Kenya (+254)',
							'686' => 'Kiribati (+686)',
							'850' => 'Korea North (+850)',
							'82' => 'Korea South (+82)',
							'965' => 'Kuwait (+965)',
							'996' => 'Kyrgyzstan (+996)',
							'856' => 'Laos (+856)',
							'371' => 'Latvia (+371)',
							'961' => 'Lebanon (+961)',
							'266' => 'Lesotho (+266)',
							'231' => 'Liberia (+231)',
							'218' => 'Libya (+218)',
							'417' => 'Liechtenstein (+417)',
							'370' => 'Lithuania (+370)',
							'352' => 'Luxembourg (+352)',
							'853' => 'Macao (+853)',
							'389' => 'Macedonia (+389)',
							'261' => 'Madagascar (+261)',
							'265' => 'Malawi (+265)',
							'60' => 'Malaysia (+60)',
							'960' => 'Maldives (+960)',
							'223' => 'Mali (+223)',
							'356' => 'Malta (+356)',
							'692' => 'Marshall Islands (+692)',
							'596' => 'Martinique (+596)',
							'222' => 'Mauritania (+222)',
							'269' => 'Mayotte (+269)',
							'52' => 'Mexico (+52)',
							'691' => 'Micronesia (+691)',
							'373' => 'Moldova (+373)',
							'377' => 'Monaco (+377)',
							'976' => 'Mongolia (+976)',
							'1664' => 'Montserrat (+1664)',
							'212' => 'Morocco (+212)',
							'258' => 'Mozambique (+258)',
							'95' => 'Myanmar (+95)',
							'264' => 'Namibia (+264)',
							'674' => 'Nauru (+674)',
							'977' => 'Nepal (+977)',
							'31' => 'Netherlands (+31)',
							'687' => 'New Caledonia (+687)',
							'64' => 'New Zealand (+64)',
							'505' => 'Nicaragua (+505)',
							'227' => 'Niger (+227)',
							'234' => 'Nigeria (+234)',
							'683' => 'Niue (+683)',
							'672' => 'Norfolk Islands (+672)',
							'670' => 'Northern Marianas (+670)',
							'47' => 'Norway (+47)',
							'968' => 'Oman (+968)',
							'680' => 'Palau (+680)','970' => 'Palestine (+970)',
							'507' => 'Panama (+507)',
							'675' => 'Papua New Guinea (+675)',
							'595' => 'Paraguay (+595)',
							'51' => 'Peru (+51)',
							'63' => 'Philippines (+63)',
							'48' => 'Poland (+48)',
							'351' => 'Portugal (+351)',
							'1787' => 'Puerto Rico (+1787)',
							'974' => 'Qatar (+974)',
							'262' => 'Reunion (+262)',
							'40' => 'Romania (+40)',
							'7' => 'Russia (+7)',
							'250' => 'Rwanda (+250)',
							'378' => 'San Marino (+378)',
							'239' => 'Sao Tome & Principe (+239)',
							'966' => 'Saudi Arabia (+966)',
							'221' => 'Senegal (+221)',
							'381' => 'Serbia (+381)',
							'248' => 'Seychelles (+248)',
							'232' => 'Sierra Leone (+232)',
							'65' => 'Singapore (+65)',
							'421' => 'Slovak Republic (+421)',
							'386' => 'Slovenia (+386)',
							'677' => 'Solomon Islands (+677)',
							'252' => 'Somalia (+252)',
							'27' => 'South Africa (+27)',
							'34' => 'Spain (+34)',
							'94' => 'Sri Lanka (+94)',
							'290' => 'St. Helena (+290)',
							'1869' => 'St. Kitts (+1869)',
							'1758' => 'St. Lucia (+1758)',
							'249' => 'Sudan (+249)','211' => 'South Sudan (+211)',
							'597' => 'Suriname (+597)',
							'268' => 'Swaziland (+268)',
							'46' => 'Sweden (+46)',
							'41' => 'Switzerland (+41)',
							'963' => 'Syria (+963)',
							'886' => 'Taiwan (+886)',
							'7' => 'Tajikstan (+7)',
							'66' => 'Thailand (+66)',
							'228' => 'Togo (+228)',
							'676' => 'Tonga (+676)',
							'1868' => 'Trinidad & Tobago (+1868)',
							'216' => 'Tunisia (+216)',
							'90' => 'Turkey (+90)',
							'7' => 'Turkmenistan (+7)',
							'993' => 'Turkmenistan (+993)',
							'1649' => 'Turks & Caicos Islands (+1649)',
							'688' => 'Tuvalu (+688)',
							'256' => 'Uganda (+256)',
							'380' => 'Ukraine (+380)',
							'971' => 'United Arab Emirates (+971)',
							'598' => 'Uruguay (+598)',
							'7' => 'Uzbekistan (+7)',
							'678' => 'Vanuatu (+678)',
							'379' => 'Vatican City (+379)',
							'58' => 'Venezuela (+58)',
							'84' => 'Vietnam (+84)',
							'84' => 'Virgin Islands - British (+1284)',
							'84' => 'Virgin Islands - US (+1340)',
							'681' => 'Wallis & Futuna (+681)',
							'969' => 'Yemen (North)(+969)',
							'967' => 'Yemen (South)(+967)',
							'260' => 'Zambia (+260)',
							'263' => 'Zimbabwe (+263)',
						];

						$temp=  substr(strstr($phone, '+'),1);
					if($temp != false){$phone=$temp;}
                                                $countrycode='';
						// sort the array by key, descending
						krsort($countrys, SORT_NUMERIC);

						// iterate over all countries
						foreach($countrys as $we => $ccode){
							// if number begins with current number
							if(strpos($phone, '' . $we) === 0){
								// store country code and break the loop
								$countrycode = $we;
								break;
							}
						}

						if(!empty($countrycode)){
							$size=strlen($countrycode);
							$phone=substr($phone,$size);
						}
}

//var_dump($phone);exit;
				$criteria->addSearchCondition('tel', $phone ,TRUE, "or");
				$criteria->addSearchCondition('second_tel', $phone ,TRUE, "or");
				$criteria->addSearchCondition('tel3', $phone ,TRUE, "or");
				$criteria->addSearchCondition('tel4', $phone ,TRUE, "or");
			}
			$count=Leads::model()->count($criteria);
			
			
			

    
			$dataProvider = new CActiveDataProvider('Leads', array(
					'pagination' => array(
						'pageSize' =>50,
					),
					'criteria' => $criteria,
				));
			
				$this->render('searchforallx', array(
										
				'user'=>$user,	
				'count'=>$count,
				'dataProvider'=>$dataProvider,     

											
			));
	    
		}else{
		$this->redirect(array('login/dashboard')	);
		}
		
		
	}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
		
		
	}
	    
	    
	public function actionSearchsales(){
	    
	    	if(Yii::app()->user->isMember()){
	    
			$userid=Yii::app()->user->id;
			$user=User::model()->findByPk($userid);
	    $this->layout = '//layouts/systemcgridview';


	    
				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');    
				






		if(isset($_REQUEST['search'])){

            //Search
			$arrayofinfo=array(
		    'email'=>$_REQUEST['email'],
            'details'=>$_REQUEST['details'],
            'project'=>$_REQUEST['project'],
            'transferreason'=>$_REQUEST['transferreason'],
            'career'=>$_REQUEST['career'],
            'lastreport'=>$_REQUEST['lastreport'],
            'exusersales'=>$_REQUEST['exusersales'],
            'teamdistributed'=>$_REQUEST['teamdistributed'],
            'othersubstatus'=>$_REQUEST['othersubstatus'],
            'strategy'=>$_REQUEST['strategy'],
            'dupcampaign'=>$_REQUEST['dupcampaign'],
            'tags'=>$_REQUEST['tags'],
            'marketingby'=>$_REQUEST['marketingby'],
            'unit_type'=>$_REQUEST['unit_type'],
            'hidden'=>$_REQUEST['hidden'],
            'fb_id'=>$_REQUEST['fb_id'],
            'coderef'=>$_REQUEST['coderef'],
            'adsetname'=>$_REQUEST['adsetname'],
            'adname'=>$_REQUEST['adname'],
            'search'=>$_REQUEST['search'],
            'title'=>$_REQUEST['title'],
            'fresh'=>$_REQUEST['fresh'],
            'except'=>$_REQUEST['except'],
            'exceptplatform'=>$_REQUEST['exceptplatform'],
            'exceptcam'=>$_REQUEST['exceptcam'],
            'branch'=>$_REQUEST['branch'],
            'leadstate'=>$_REQUEST['leadstate'],
            'transferfrom'=>$_REQUEST['transferfrom'],
            'transferuser'=>$_REQUEST['transferuser'],
            'tel'=>$_REQUEST['tel'],
            'second_tel'=>$_REQUEST['secondtel'],
            'campaign'=>$_REQUEST['campaign'],
            'usersales'=>$_REQUEST['usersales'],
            'receipt'=>$_REQUEST['receipt'],
            'communication'=>$_REQUEST['communication'],
            'unseenauto'=>$_REQUEST['unseenauto'],
            'close'=>$_REQUEST['close'],
            'duplicate'=>$_REQUEST['duplicate'],
            'substatus'=>$_REQUEST['substatus'],
            'status'=>$_REQUEST['status'],
            'platformchild'=>$_REQUEST['platformchild'],
            'platform'=>$_REQUEST['platform'],
            'startdate'=>$_REQUEST['startdate'],
            'enddate'=>$_REQUEST['enddate'],
            'startsysdate'=>$_REQUEST['startsysdate'],
            'endsysdate'=>$_REQUEST['endsysdate'],
            'startactiondate'=>$_REQUEST['startactiondate'],
            'endactiondate'=>$_REQUEST['endactiondate'],
            'startduplicatedate'=>$_REQUEST['startduplicatedate'],
            'endduplicatedate'=>$_REQUEST['endduplicatedate'],
            'startfakeedate'=>$_REQUEST['startfakeedate'],
            'endfakedate'=>$_REQUEST['endfakedate'],
            'startfollowdate'=>$_REQUEST['startfollowdate'],
            'endfollowdate'=>$_REQUEST['endfollowdate'],
            'starttransferdate'=>$_REQUEST['starttransferdate'],
            'endtransferdate'=>$_REQUEST['endtransferdate'],
            'expstarttransferedate'=>$_REQUEST['expstarttransferedate'],
            'expendtransferedate'=>$_REQUEST['expendtransferedate'],
            'place'=>$_REQUEST['place'],
            'team'=>$_REQUEST['team'],
            'callcenter'=>$_REQUEST['callcenter'],
            'client_id'=>$_REQUEST['client_id'],
            'eoi'=>$_REQUEST['eoi'],
            'indirect'=>$_REQUEST['indirect'],
            'cold'=>$_REQUEST['cold'],
            'transferx'=>$_REQUEST['transferx'],
            'death'=>$_REQUEST['death'],
            'reopen'=>$_REQUEST['reopen'],
            'expvisit'=>$_REQUEST['expvisit'],
            'visit'=>$_REQUEST['visit'],
            'answer'=>$_REQUEST['answer'],
            'ccode'=>$_REQUEST['ccode'],
            'callback'=>$_REQUEST['callback'],
            'netduplicate'=>$_REQUEST['netduplicate'],
            'distributedteamleaders'=>$_REQUEST['distributedteamleaders']);
		
			$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';

			if(!empty($_REQUEST['search']) ){
				$criteria->addSearchCondition('title', $_REQUEST['search'],TRUE, "AND");
			}
			if($_REQUEST['client_id']==1){
				$criteria->addSearchCondition('client_id', 1 ,false, "AND");
			}else if($_REQUEST['client_id']==2){ 
				$criteria->addCondition('client_id IS NULL');
			}else{
			}
			
			if($_REQUEST['callback']==1){
				$criteria->addSearchCondition('callback', 1 ,false, "AND");
			}else if($_REQUEST['callback']==2){ 
				$criteria->addCondition('callback IS NULL');
			}else{
			}
			
			if(!empty($_REQUEST['email']) ){
				$criteria->addSearchCondition('email', $_REQUEST['email'],TRUE, "AND");
			}
			
			if(!empty($_REQUEST['notuserids']) ){
			    $arrayofsalesx=explode(',',$_REQUEST['notuserids']);
				$criteria->addNotInCondition('user_id', $arrayofsalesx ,'AND'); 
				
			}
			
			if (!empty($_REQUEST['team']) && is_array($_REQUEST['team'])) {
                $arr = array();
                foreach ($_REQUEST['team'] as $teamleader_id) {
                    $allemployee = Teamleader::model()->findAll(array(
                        'condition' => 'leader_id=' . (int)$teamleader_id,
                        'order' => 'id DESC'
                    ));
                    foreach ($allemployee as $leader) {
                        if (!in_array($leader->sales_id, $arr)) {
                            $arr[] = $leader->sales_id;
                        }
                    }
                }
                if (!empty($arr)) {
                    $criteria->addInCondition('user_sales', $arr, "AND");
                }
            }
			
			if(!empty($_REQUEST['details']) ){
				$criteria->addSearchCondition('details', $_REQUEST['details'],TRUE, "AND");
			}
			
            if(!empty($_REQUEST['transferreason']) ){
                $criteria->addSearchCondition('transferreason', $_REQUEST['transferreason'],TRUE, "AND");
            }
            
            if(!empty($_REQUEST['career']) ){
                $criteria->addSearchCondition('career', $_REQUEST['career'],TRUE, "AND");
            }
            
            if(!empty($_REQUEST['fb_id']) ){
				$criteria->addSearchCondition('facebook_id', $_REQUEST['fb_id'],TRUE, "AND");
			}
            if(!empty($_REQUEST['adsetname']) ){
				$criteria->addSearchCondition('adsetname', $_REQUEST['adsetname'],TRUE, "AND");
			}
            if(!empty($_REQUEST['adname']) ){
				$criteria->addSearchCondition('adname', $_REQUEST['adname'],TRUE, "AND");
			}
            			
            if(!empty($_REQUEST['coderef']) ){
    			$criteria->addSearchCondition('code', $_REQUEST['coderef'],TRUE, "AND");
    		}
		
		
            if(!empty($_REQUEST['code']) ){
                $_REQUEST['startdate']="2008-6-30";
                $_REQUEST['enddate']=date("Y-m-d");
    				$criteria->addSearchCondition('id', $_REQUEST['code'],false, "AND");
    			}
                if(!empty($_REQUEST['tel2']) ){
                    $_REQUEST['startdate']="2008-6-30";
                    $_REQUEST['enddate']=date("Y-m-d");
                    
                    $phone= $_REQUEST['tel2'];
                    if($phone[0]=='0')
                        $phone = substr($phone , 1);
                        $countrys = [
							'44' => 'UK (+44)',
							'213' => 'Algeria (+213)',
							'376' => 'Andorra (+376)',
							'244' => 'Angola (+244)',
							'1264' => 'Anguilla (+1264)',
							'1268' => 'Antigua & Barbuda (+1268)',
							'54' => 'Argentina (+54)',
							'374' => 'Armenia (+374)',
							'297' => 'Aruba (+297)',
							'61' => 'Australia (+61)',
							'43' => 'Austria (+43)',
							'994' => 'Azerbaijan (+994)',
							'1242' => 'Bahamas (+1242)',
							'973' => 'Bahrain (+973)',
							'880' => 'Bangladesh (+880)',
							'1246' => 'Barbados (+1246)',
							'375' => 'Belarus (+375)',
							'32' => 'Belgium (+32)',
							'501' => 'Belize (+501)',
							'229' => 'Benin (+229)',
							'1441' => 'Bermuda (+1441)',
							'975' => 'Bhutan (+975)',
							'591' => 'Bolivia (+591)',
							'387' => 'Bosnia Herzegovina (+387)',
							'267' => 'Botswana (+267)',
							'55' => 'Brazil (+55)',
							'673' => 'Brunei (+673)',
							'359' => 'Bulgaria (+359)',
							'226' => 'Burkina Faso (+226)',
							'257' => 'Burundi (+257)',
							'855' => 'Cambodia (+855)',
							'237' => 'Cameroon (+237)',
							'238' => 'Cape Verde Islands (+238)',
							'1345' => 'Cayman Islands (+1345)',
							'236' => 'Central African Republic (+236)',
							'56' => 'Chile (+56)',
							'86' => 'China (+86)',
							'57' => 'Colombia (+57)',
							'269' => 'Comoros (+269)',
							'242' => 'Congo (+242)',
							'682' => 'Cook Islands (+682)',
							'506' => 'Costa Rica (+506)','225' => 'Cote d Ivoire (+225)',
							'385' => 'Croatia (+385)',
							'53' => 'Cuba (+53)',
							'90392' => 'Cyprus North (+90392)',
							'357' => 'Cyprus South (+357)',
							'420' => 'Czech Republic (+420)',
							'45' => 'Denmark (+45)',
							'253' => 'Djibouti (+253)',
							'1809' => 'Dominica (+1809)',
							'1809' => 'Dominican Republic (+1809)',
							'593' => 'Ecuador (+593)',
							'20' => 'Egypt (+20)',
							'503' => 'El Salvador (+503)',
							'240' => 'Equatorial Guinea (+240)',
							'291' => 'Eritrea (+291)',
							'372' => 'Estonia (+372)',
							'251' => 'Ethiopia (+251)',
							'500' => 'Falkland Islands (+500)',
							'298' => 'Faroe Islands (+298)',
							'679' => 'Fiji (+679)',
							'358' => 'Finland (+358)',
							'33' => 'France (+33)',
							'594' => 'French Guiana (+594)',
							'689' => 'French Polynesia (+689)',
							'241' => 'Gabon (+241)',
							'220' => 'Gambia (+220)',
							'995' => 'Georgia (+995)',
							'49' => 'Germany (+49)',
							'233' => 'Ghana (+233)',
							'350' => 'Gibraltar (+350)',
							'30' => 'Greece (+30)',
							'299' => 'Greenland (+299)',
							'1473' => 'Grenada (+1473)',
							'590' => 'Guadeloupe (+590)',
							'671' => 'Guam (+671)',
							'502' => 'Guatemala (+502)',
							'224' => 'Guinea (+224)',
							'245' => 'Guinea - Bissau (+245)',
							'592' => 'Guyana (+592)',
							'509' => 'Haiti (+509)',
							'504' => 'Honduras (+504)',
							'852' => 'Hong Kong (+852)',
							'36' => 'Hungary (+36)',
							'354' => 'Iceland (+354)',
							'91' => 'India (+91)',
							'62' => 'Indonesia (+62)',
							'98' => 'Iran (+98)',
							'964' => 'Iraq (+964)',
							'353' => 'Ireland (+353)',
							'39' => 'Italy (+39)','972' => 'Israel (+972)',
							'1876' => 'Jamaica (+1876)',
							'81' => 'Japan (+81)',
							'962' => 'Jordan (+962)',
							'7' => 'Kazakhstan (+7)',
							'254' => 'Kenya (+254)',
							'686' => 'Kiribati (+686)',
							'850' => 'Korea North (+850)',
							'82' => 'Korea South (+82)',
							'965' => 'Kuwait (+965)',
							'996' => 'Kyrgyzstan (+996)',
							'856' => 'Laos (+856)',
							'371' => 'Latvia (+371)',
							'961' => 'Lebanon (+961)',
							'266' => 'Lesotho (+266)',
							'231' => 'Liberia (+231)',
							'218' => 'Libya (+218)',
							'417' => 'Liechtenstein (+417)',
							'370' => 'Lithuania (+370)',
							'352' => 'Luxembourg (+352)',
							'853' => 'Macao (+853)',
							'389' => 'Macedonia (+389)',
							'261' => 'Madagascar (+261)',
							'265' => 'Malawi (+265)',
							'60' => 'Malaysia (+60)',
							'960' => 'Maldives (+960)',
							'223' => 'Mali (+223)',
							'356' => 'Malta (+356)',
							'692' => 'Marshall Islands (+692)',
							'596' => 'Martinique (+596)',
							'222' => 'Mauritania (+222)',
							'269' => 'Mayotte (+269)',
							'52' => 'Mexico (+52)',
							'691' => 'Micronesia (+691)',
							'373' => 'Moldova (+373)',
							'377' => 'Monaco (+377)',
							'976' => 'Mongolia (+976)',
							'1664' => 'Montserrat (+1664)',
							'212' => 'Morocco (+212)',
							'258' => 'Mozambique (+258)',
							'95' => 'Myanmar (+95)',
							'264' => 'Namibia (+264)',
							'674' => 'Nauru (+674)',
							'977' => 'Nepal (+977)',
							'31' => 'Netherlands (+31)',
							'687' => 'New Caledonia (+687)',
							'64' => 'New Zealand (+64)',
							'505' => 'Nicaragua (+505)',
							'227' => 'Niger (+227)',
							'234' => 'Nigeria (+234)',
							'683' => 'Niue (+683)',
							'672' => 'Norfolk Islands (+672)',
							'670' => 'Northern Marianas (+670)',
							'47' => 'Norway (+47)',
							'968' => 'Oman (+968)',
							'680' => 'Palau (+680)','970' => 'Palestine (+970)',
							'507' => 'Panama (+507)',
							'675' => 'Papua New Guinea (+675)',
							'595' => 'Paraguay (+595)',
							'51' => 'Peru (+51)',
							'63' => 'Philippines (+63)',
							'48' => 'Poland (+48)',
							'351' => 'Portugal (+351)',
							'1787' => 'Puerto Rico (+1787)',
							'974' => 'Qatar (+974)',
							'262' => 'Reunion (+262)',
							'40' => 'Romania (+40)',
							'7' => 'Russia (+7)',
							'250' => 'Rwanda (+250)',
							'378' => 'San Marino (+378)',
							'239' => 'Sao Tome & Principe (+239)',
							'966' => 'Saudi Arabia (+966)',
							'221' => 'Senegal (+221)',
							'381' => 'Serbia (+381)',
							'248' => 'Seychelles (+248)',
							'232' => 'Sierra Leone (+232)',
							'65' => 'Singapore (+65)',
							'421' => 'Slovak Republic (+421)',
							'386' => 'Slovenia (+386)',
							'677' => 'Solomon Islands (+677)',
							'252' => 'Somalia (+252)',
							'27' => 'South Africa (+27)',
							'34' => 'Spain (+34)',
							'94' => 'Sri Lanka (+94)',
							'290' => 'St. Helena (+290)',
							'1869' => 'St. Kitts (+1869)',
							'1758' => 'St. Lucia (+1758)',
							'249' => 'Sudan (+249)','211' => 'South Sudan (+211)',
							'597' => 'Suriname (+597)',
							'268' => 'Swaziland (+268)',
							'46' => 'Sweden (+46)',
							'41' => 'Switzerland (+41)',
							'963' => 'Syria (+963)',
							'886' => 'Taiwan (+886)',
							'7' => 'Tajikstan (+7)',
							'66' => 'Thailand (+66)',
							'228' => 'Togo (+228)',
							'676' => 'Tonga (+676)',
							'1868' => 'Trinidad & Tobago (+1868)',
							'216' => 'Tunisia (+216)',
							'90' => 'Turkey (+90)',
							'7' => 'Turkmenistan (+7)',
							'993' => 'Turkmenistan (+993)',
							'1649' => 'Turks & Caicos Islands (+1649)',
							'688' => 'Tuvalu (+688)',
							'256' => 'Uganda (+256)',
							'380' => 'Ukraine (+380)',
							'971' => 'United Arab Emirates (+971)',
							'598' => 'Uruguay (+598)',
							'7' => 'Uzbekistan (+7)',
							'678' => 'Vanuatu (+678)',
							'379' => 'Vatican City (+379)',
							'58' => 'Venezuela (+58)',
							'84' => 'Vietnam (+84)',
							'84' => 'Virgin Islands - British (+1284)',
							'84' => 'Virgin Islands - US (+1340)',
							'681' => 'Wallis & Futuna (+681)',
							'969' => 'Yemen (North)(+969)',
							'967' => 'Yemen (South)(+967)',
							'260' => 'Zambia (+260)',
							'263' => 'Zimbabwe (+263)',
						];

						$temp=  substr(strstr($phone, '+'),1);
					if($temp != false){$phone=$temp;}
                                                $countrycode='';
						// sort the array by key, descending
						krsort($countrys, SORT_NUMERIC);

						// iterate over all countries
						foreach($countrys as $we => $ccode){
							// if number begins with current number
							if(strpos($phone, '' . $we) === 0){
								// store country code and break the loop
								$countrycode = $we;
								break;
							}
						}

						if(!empty($countrycode)){
							$size=strlen($countrycode);
							$phone=substr($phone,$size);
						}



				$criteria->addSearchCondition('tel', $phone ,TRUE, "or");
				$criteria->addSearchCondition('second_tel', $phone ,TRUE, "or");
			}
            if(!empty($_REQUEST['tel']) ){
            
            $phone= $_REQUEST['tel'];
            if($phone[0]=='0')
                $phone = substr($phone , 1);
            $countrys = [
            							'44' => 'UK (+44)',
            							'213' => 'Algeria (+213)',
            							'376' => 'Andorra (+376)',
            							'244' => 'Angola (+244)',
            							'1264' => 'Anguilla (+1264)',
            							'1268' => 'Antigua & Barbuda (+1268)',
            							'54' => 'Argentina (+54)',
            							'374' => 'Armenia (+374)',
            							'297' => 'Aruba (+297)',
            							'61' => 'Australia (+61)',
            							'43' => 'Austria (+43)',
            							'994' => 'Azerbaijan (+994)',
            							'1242' => 'Bahamas (+1242)',
            							'973' => 'Bahrain (+973)',
            							'880' => 'Bangladesh (+880)',
            							'1246' => 'Barbados (+1246)',
            							'375' => 'Belarus (+375)',
            							'32' => 'Belgium (+32)',
            							'501' => 'Belize (+501)',
            							'229' => 'Benin (+229)',
            							'1441' => 'Bermuda (+1441)',
            							'975' => 'Bhutan (+975)',
            							'591' => 'Bolivia (+591)',
            							'387' => 'Bosnia Herzegovina (+387)',
            							'267' => 'Botswana (+267)',
            							'55' => 'Brazil (+55)',
            							'673' => 'Brunei (+673)',
            							'359' => 'Bulgaria (+359)',
            							'226' => 'Burkina Faso (+226)',
            							'257' => 'Burundi (+257)',
            							'855' => 'Cambodia (+855)',
            							'237' => 'Cameroon (+237)',
            							'238' => 'Cape Verde Islands (+238)',
            							'1345' => 'Cayman Islands (+1345)',
            							'236' => 'Central African Republic (+236)',
            							'56' => 'Chile (+56)',
            							'86' => 'China (+86)',
            							'57' => 'Colombia (+57)',
            							'269' => 'Comoros (+269)',
            							'242' => 'Congo (+242)',
            							'682' => 'Cook Islands (+682)',
            							'506' => 'Costa Rica (+506)','225' => 'Cote d Ivoire (+225)',
            							'385' => 'Croatia (+385)',
            							'53' => 'Cuba (+53)',
            							'90392' => 'Cyprus North (+90392)',
            							'357' => 'Cyprus South (+357)',
            							'420' => 'Czech Republic (+420)',
            							'45' => 'Denmark (+45)',
            							'253' => 'Djibouti (+253)',
            							'1809' => 'Dominica (+1809)',
            							'1809' => 'Dominican Republic (+1809)',
            							'593' => 'Ecuador (+593)',
            							'20' => 'Egypt (+20)',
            							'503' => 'El Salvador (+503)',
            							'240' => 'Equatorial Guinea (+240)',
            							'291' => 'Eritrea (+291)',
            							'372' => 'Estonia (+372)',
            							'251' => 'Ethiopia (+251)',
            							'500' => 'Falkland Islands (+500)',
            							'298' => 'Faroe Islands (+298)',
            							'679' => 'Fiji (+679)',
            							'358' => 'Finland (+358)',
            							'33' => 'France (+33)',
            							'594' => 'French Guiana (+594)',
            							'689' => 'French Polynesia (+689)',
            							'241' => 'Gabon (+241)',
            							'220' => 'Gambia (+220)',
            							'995' => 'Georgia (+995)',
            							'49' => 'Germany (+49)',
            							'233' => 'Ghana (+233)',
            							'350' => 'Gibraltar (+350)',
            							'30' => 'Greece (+30)',
            							'299' => 'Greenland (+299)',
            							'1473' => 'Grenada (+1473)',
            							'590' => 'Guadeloupe (+590)',
            							'671' => 'Guam (+671)',
            							'502' => 'Guatemala (+502)',
            							'224' => 'Guinea (+224)',
            							'245' => 'Guinea - Bissau (+245)',
            							'592' => 'Guyana (+592)',
            							'509' => 'Haiti (+509)',
            							'504' => 'Honduras (+504)',
            							'852' => 'Hong Kong (+852)',
            							'36' => 'Hungary (+36)',
            							'354' => 'Iceland (+354)',
            							'91' => 'India (+91)',
            							'62' => 'Indonesia (+62)',
            							'98' => 'Iran (+98)',
            							'964' => 'Iraq (+964)',
            							'353' => 'Ireland (+353)',
            							'39' => 'Italy (+39)','972' => 'Israel (+972)',
            							'1876' => 'Jamaica (+1876)',
            							'81' => 'Japan (+81)',
            							'962' => 'Jordan (+962)',
            							'7' => 'Kazakhstan (+7)',
            							'254' => 'Kenya (+254)',
            							'686' => 'Kiribati (+686)',
            							'850' => 'Korea North (+850)',
            							'82' => 'Korea South (+82)',
            							'965' => 'Kuwait (+965)',
            							'996' => 'Kyrgyzstan (+996)',
            							'856' => 'Laos (+856)',
            							'371' => 'Latvia (+371)',
            							'961' => 'Lebanon (+961)',
            							'266' => 'Lesotho (+266)',
            							'231' => 'Liberia (+231)',
            							'218' => 'Libya (+218)',
            							'417' => 'Liechtenstein (+417)',
            							'370' => 'Lithuania (+370)',
            							'352' => 'Luxembourg (+352)',
            							'853' => 'Macao (+853)',
            							'389' => 'Macedonia (+389)',
            							'261' => 'Madagascar (+261)',
            							'265' => 'Malawi (+265)',
            							'60' => 'Malaysia (+60)',
            							'960' => 'Maldives (+960)',
            							'223' => 'Mali (+223)',
            							'356' => 'Malta (+356)',
            							'692' => 'Marshall Islands (+692)',
            							'596' => 'Martinique (+596)',
            							'222' => 'Mauritania (+222)',
            							'269' => 'Mayotte (+269)',
            							'52' => 'Mexico (+52)',
            							'691' => 'Micronesia (+691)',
            							'373' => 'Moldova (+373)',
            							'377' => 'Monaco (+377)',
            							'976' => 'Mongolia (+976)',
            							'1664' => 'Montserrat (+1664)',
            							'212' => 'Morocco (+212)',
            							'258' => 'Mozambique (+258)',
            							'95' => 'Myanmar (+95)',
            							'264' => 'Namibia (+264)',
            							'674' => 'Nauru (+674)',
            							'977' => 'Nepal (+977)',
            							'31' => 'Netherlands (+31)',
            							'687' => 'New Caledonia (+687)',
            							'64' => 'New Zealand (+64)',
            							'505' => 'Nicaragua (+505)',
            							'227' => 'Niger (+227)',
            							'234' => 'Nigeria (+234)',
            							'683' => 'Niue (+683)',
            							'672' => 'Norfolk Islands (+672)',
            							'670' => 'Northern Marianas (+670)',
            							'47' => 'Norway (+47)',
            							'968' => 'Oman (+968)',
            							'680' => 'Palau (+680)','970' => 'Palestine (+970)',
            							'507' => 'Panama (+507)',
            							'675' => 'Papua New Guinea (+675)',
            							'595' => 'Paraguay (+595)',
            							'51' => 'Peru (+51)',
            							'63' => 'Philippines (+63)',
            							'48' => 'Poland (+48)',
            							'351' => 'Portugal (+351)',
            							'1787' => 'Puerto Rico (+1787)',
            							'974' => 'Qatar (+974)',
            							'262' => 'Reunion (+262)',
            							'40' => 'Romania (+40)',
            							'7' => 'Russia (+7)',
            							'250' => 'Rwanda (+250)',
            							'378' => 'San Marino (+378)',
            							'239' => 'Sao Tome & Principe (+239)',
            							'966' => 'Saudi Arabia (+966)',
            							'221' => 'Senegal (+221)',
            							'381' => 'Serbia (+381)',
            							'248' => 'Seychelles (+248)',
            							'232' => 'Sierra Leone (+232)',
            							'65' => 'Singapore (+65)',
            							'421' => 'Slovak Republic (+421)',
            							'386' => 'Slovenia (+386)',
            							'677' => 'Solomon Islands (+677)',
            							'252' => 'Somalia (+252)',
            							'27' => 'South Africa (+27)',
            							'34' => 'Spain (+34)',
            							'94' => 'Sri Lanka (+94)',
            							'290' => 'St. Helena (+290)',
            							'1869' => 'St. Kitts (+1869)',
            							'1758' => 'St. Lucia (+1758)',
            							'249' => 'Sudan (+249)','211' => 'South Sudan (+211)',
            							'597' => 'Suriname (+597)',
            							'268' => 'Swaziland (+268)',
            							'46' => 'Sweden (+46)',
            							'41' => 'Switzerland (+41)',
            							'963' => 'Syria (+963)',
            							'886' => 'Taiwan (+886)',
            							'7' => 'Tajikstan (+7)',
            							'66' => 'Thailand (+66)',
            							'228' => 'Togo (+228)',
            							'676' => 'Tonga (+676)',
            							'1868' => 'Trinidad & Tobago (+1868)',
            							'216' => 'Tunisia (+216)',
            							'90' => 'Turkey (+90)',
            							'7' => 'Turkmenistan (+7)',
            							'993' => 'Turkmenistan (+993)',
            							'1649' => 'Turks & Caicos Islands (+1649)',
            							'688' => 'Tuvalu (+688)',
            							'256' => 'Uganda (+256)',
            							'380' => 'Ukraine (+380)',
            							'971' => 'United Arab Emirates (+971)',
            							'598' => 'Uruguay (+598)',
            							'7' => 'Uzbekistan (+7)',
            							'678' => 'Vanuatu (+678)',
            							'379' => 'Vatican City (+379)',
            							'58' => 'Venezuela (+58)',
            							'84' => 'Vietnam (+84)',
            							'84' => 'Virgin Islands - British (+1284)',
            							'84' => 'Virgin Islands - US (+1340)',
            							'681' => 'Wallis & Futuna (+681)',
            							'969' => 'Yemen (North)(+969)',
            							'967' => 'Yemen (South)(+967)',
            							'260' => 'Zambia (+260)',
            							'263' => 'Zimbabwe (+263)',
            						];
            
            						$temp=  substr(strstr($phone, '+'),1);
            					if($temp != false){$phone=$temp;}
                                                            $countrycode='';
            						// sort the array by key, descending
            						krsort($countrys, SORT_NUMERIC);
            
            						// iterate over all countries
            						foreach($countrys as $we => $ccode){
            							// if number begins with current number
            							if(strpos($phone, '' . $we) === 0){
            								// store country code and break the loop
            								$countrycode = $we;
            								break;
            							}
            						}
            
            						if(!empty($countrycode)){
            							$size=strlen($countrycode);
            							$phone=substr($phone,$size);
            						}
            
            
            
            				$criteria->addSearchCondition('tel', $phone ,TRUE, "or");
            				$criteria->addSearchCondition('second_tel', $phone ,TRUE, "or");
            			}
            if(!empty($_REQUEST['secondtel']) ){
            				$criteria->addSearchCondition('second_tel', $_REQUEST['secondtel'],false, "AND");
            			}
            if(!empty($_REQUEST['internationalcode']) ){
            				$criteria->addSearchCondition('international_code', $_REQUEST['internationalcode'],false, "AND");
            			}
            if(!empty($_REQUEST['internationalcode2']) ){
            				$criteria->addSearchCondition('international_code2', $_REQUEST['internationalcode2'],false, "AND");
            			}
			if($_REQUEST['communication']==1){


				$criteria->addSearchCondition('communication', $_REQUEST['communication'],false, "AND");
			}else if($_REQUEST['communication']==2){



				$criteria->addCondition('communication IS NULL');
				$criteria->addCondition('user_sales IS NOT NULL');

			}else{
			}
			
			if($_REQUEST['netduplicate']==1){
				$criteria->addCondition('allowduplicate IS NULL');
			}else{
			}
			
$main = Mainsettings::model()->findByPk(1);
$timezone = !empty($main->countrytimezone) ? $main->countrytimezone : 'Africa/Cairo';
date_default_timezone_set($timezone);

$today = date("Y-m-d");

if (!empty($_REQUEST['exptransfer']) && $_REQUEST['exptransfer'] == 1 && 
    (empty($_REQUEST['expstarttransferedate']) || empty($_REQUEST['expendtransferedate']))) {

    // فقط استبعاد تاريخ النهاردة
    $criteria->addCondition("(transferdate != '$today' OR transferdate IS NULL)", 'AND');

} elseif (!empty($_REQUEST['expstarttransferedate']) && !empty($_REQUEST['expendtransferedate']) &&
          empty($_REQUEST['exptransfer'])) {

    // فقط استبعاد فترة
    $start = $_REQUEST['expstarttransferedate'];
    $end = $_REQUEST['expendtransferedate'];
    $criteria->addCondition("(transferdate IS NULL OR transferdate < '$start' OR transferdate > '$end')", 'AND');

} elseif (!empty($_REQUEST['exptransfer']) && $_REQUEST['exptransfer'] == 1 &&
          !empty($_REQUEST['expstarttransferedate']) && !empty($_REQUEST['expendtransferedate'])) {

    // استبعاد تاريخ النهاردة + استبعاد فترة
    $start = $_REQUEST['expstarttransferedate'];
    $end = $_REQUEST['expendtransferedate'];
    $criteria->addCondition("(
        (transferdate != '$today' OR transferdate IS NULL)
        AND
        (transferdate IS NULL OR transferdate < '$start' OR transferdate > '$end')
    )", 'AND');
}
			
			
        if($_REQUEST['startfollowdate']){
        $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
        $today = date("Y-m-d");                     // 03.10.01
        
        //var_dump($arrayoftoday);exit;
        //$criteria->addNotInCondition('transferdate', $arrayoftoday , "AND");
        $criteria->addBetweenCondition("follow_date",$_REQUEST['startfollowdate'],$_REQUEST['endfollowdate'],'AND');
        $criteria->addCondition('close IS NULL');
        $criteria->addCondition('communication IS NOT NULL');
        $criteria->addCondition('user_sales IS NOT NULL');

        
        
        }else{
        }

			
			
			
			
						
        if($_REQUEST['starttransferdate']){

        //var_dump($arrayoftoday);exit;
        //$criteria->addNotInCondition('transferdate', $arrayoftoday , "AND");
        $criteria->addBetweenCondition("transferdate",$_REQUEST['starttransferdate'],$_REQUEST['endtransferdate'],'AND');

        
        }else{
        }	
			
			
			
			
		
				if(!empty($_REQUEST['startfakedate']) ){
				$criteria->addBetweenCondition("fakedate",$_REQUEST['startfakedate'],$_REQUEST['endfakedate'],'AND');
			}
				
			
			
			
			
			
		if($_REQUEST['distributedteamleaders']==1){
				 	$criteria->addCondition('user_integration IS NOT NULL && user_sales IS  NULL');

			}else{
			}
						
			
			
			
			
			if($_REQUEST['leadstate']==1){
                $criteria->condition = "nonqualified IS  NULL ";
			    $criteria->addSearchCondition('qualified', 1 ,false, "AND");
			}else if($_REQUEST['leadstate']==2){
                $criteria->addSearchCondition('nonqualified', 1 , false);
				$criteria->addCondition('qualified IS NULL');
			}else if($_REQUEST['leadstate']==3){
                $criteria->condition = "qualified IS  NULL AND nonqualified IS  NULL";
			}else if($_REQUEST['leadstate']==4){
                $criteria->addSearchCondition('nonqualified', 1, false,'AND');
                $criteria->addSearchCondition('qualified', 1, false,'AND');
			}else if($_REQUEST['leadstate']==5){
			     $criteria->addSearchCondition('first_classification', 1, false,'AND');
                $criteria->addSearchCondition('nonqualified', 1, false,'AND');
                $criteria->addSearchCondition('qualified', 1, false,'AND');
			}else if($_REQUEST['leadstate']==6){
			     $criteria->addSearchCondition('first_classification', 2, false,'AND');
                $criteria->addSearchCondition('nonqualified', 1, false,'AND');
                $criteria->addSearchCondition('qualified', 1, false,'AND');
			}else{
			}
			
			
			
			
				if($_REQUEST['firstleadstate']==1){
            $criteria->addSearchCondition('first_classification', 1 , false);

			}else if($_REQUEST['firstleadstate']==2){
                $criteria->addSearchCondition('first_classification', 2 , false);
			}else{
			}
			
			
			
			
			
			
			
			
			
				if($_REQUEST['cold']==1){


				$criteria->addSearchCondition('coldcall', $_REQUEST['cold'],false, "AND");
			}else if($_REQUEST['cold']==2){



				$criteria->addCondition('coldcall IS NULL');
			}else{
			}
			
			if($_REQUEST['indirect']==1){


				$criteria->addSearchCondition('indirect', $_REQUEST['indirect'],false, "AND");
			}else if($_REQUEST['indirect']==2){



				$criteria->addCondition('indirect IS NULL');
			}else{
			}
			
			
			
			
			
			
			
			
			if($_REQUEST['receipt']==1){


				$criteria->addSearchCondition('receipt', $_REQUEST['receipt'],false, "AND");
			}else if($_REQUEST['receipt']==2){



				$criteria->addCondition('receipt IS NULL');
			}else{
			}
			if($_REQUEST['close']==1){


				$criteria->addSearchCondition('close', $_REQUEST['close'],false, "AND");
			}else if($_REQUEST['close']==2){



				$criteria->addCondition('close IS NULL');
			}else{
			}
			if($_REQUEST['death']==1){
				$criteria->addSearchCondition('confirmclose', $_REQUEST['death'],false, "AND");
			}else if($_REQUEST['death']==2){
				$criteria->addCondition('confirmclose IS NULL');
			}else{
			}
			if($_REQUEST['visit']==1){
				$criteria->addSearchCondition('visit', $_REQUEST['visit'],false, "AND");
			}else if($_REQUEST['visit']==2){
				$criteria->addCondition('visit IS NULL');
			}else{
			}
			
			
			
				if($_REQUEST['eoi']==1){
				$criteria->addSearchCondition('eoi', $_REQUEST['eoi'],false, "AND");
			}else if($_REQUEST['eoi']==2){
				$criteria->addCondition('eoi IS NULL');
			}else{
			}
			
			
			
			if($_REQUEST['expvisit']==1){
				$criteria->addSearchCondition('expvisit', $_REQUEST['expvisit'],false, "AND");
			}else if($_REQUEST['expvisit']==2){
				$criteria->addCondition('expvisit IS NULL');
			}else{
			}
			
			
			
			
			
			if($_REQUEST['duplicate']==1){
				$criteria->addSearchCondition('duplicate', $_REQUEST['duplicate'],false, "AND");
			}else if($_REQUEST['duplicate']==2){
 
				$criteria->addCondition('duplicate IS NULL');
			}else{
			}
			if($_REQUEST['transferx']==1){


				$criteria->addSearchCondition('transfer', $_REQUEST['transferx'],false, "AND");
			}else if($_REQUEST['transferx']==2){
				$criteria->addCondition('transfer IS NULL');
			}else{
			}
			if($_REQUEST['reopen']==1){
				$criteria->addSearchCondition('reopen', $_REQUEST['reopen'],false, "AND");
			}else if($_REQUEST['reopen']==2){
				$criteria->addCondition('reopen IS NULL');
			}else{
			}
			if($_REQUEST['answer']==1){
				$criteria->addSearchCondition('answer', $_REQUEST['answer'],false, "AND");
			}else if($_REQUEST['answer']==2){
				$criteria->addSearchCondition('answer', $_REQUEST['answer'],false, "AND");
			}else{
			}
            if($_REQUEST['ccode']==1){
					$criteria->addSearchCondition('international_code', 20 ,false, "AND");
			}else if($_REQUEST['ccode']==2){
			            $criteria->addNotInCondition('international_code', array(20));
				}else{}
			if(!empty($_REQUEST['hidden']) ){
				$criteria->addSearchCondition('hidden', $_REQUEST['hidden'],false, "AND");
			}
			
			
			if(sizeOf((array)$_REQUEST['platform'])>1){
			    
			     if($_REQUEST['platform'][1]!=0){
				$intArray = array_map(
					function($value){ return (int)$value; },
					$_REQUEST['platform']
				);
				$criteria->addInCondition('platform_id', $intArray  , "AND");
			     }else{
				$criteria->addCondition('platform_id IS NULL');
			    }
				
			}
			
			
				
			if(!empty($_REQUEST['transferfrom']) ){
                $criteria->addSearchCondition('transferfrom', $_REQUEST['transferfrom'],false, "AND");
            }
			
		
			

			
			
			if(!empty($_REQUEST['transferuser']) ){
                $criteria->addSearchCondition('transferuser', $_REQUEST['transferuser'],false, "AND");
            }
			
			
			
			
		
			
			
				if(sizeOf((array)$_REQUEST['platformchild'])>1){
			    
			     if($_REQUEST['platformchild'][1]!=0){
				$intArray = array_map(
					function($value){ return (int)$value; },
					$_REQUEST['platformchild']
				);
				$criteria->addInCondition('platformchild_id', $intArray  , "AND");
			     }else{
				$criteria->addCondition('platformchild_id IS NULL');
			    }
				
			}
			 
			if(sizeOf((array)$_REQUEST['ids'])>1){
			     
				$intArray = array_map(
					function($value){ return (int)$value; },
					$_REQUEST['ids']
				);
				$criteria->addInCondition('id', $intArray  , "AND");
			      
			
			}
			
			
			
			
            
            
            if (isset($_REQUEST['dupcampaign']) && is_array($_REQUEST['dupcampaign'])) {
            if(sizeOf((array)$_REQUEST['dupcampaign'])>1){
            $searchValue = implode(',', $_REQUEST['dupcampaign']);
            $likeCondition = '%' . $searchValue . '%';
            
            // Adding a LIKE condition to the criteria
            $criteria->addSearchCondition('dup_campaigns', $likeCondition, false, 'AND');
            }
            }

	
	
	
	
	
	
			
           		
			
			    
            			
            if (isset($_REQUEST['tags']) && is_array($_REQUEST['tags'])) {
                
            if(sizeOf((array)$_REQUEST['tags'])>1){

            $searchValue = implode(',', $_REQUEST['tags']);
            $likeCondition = '%' . $searchValue . '%';

            // Adding a LIKE condition to the criteria
            $criteria->addSearchCondition('tags', $likeCondition, false, 'AND');
                	}
            }
			
			
			
            		
            if (isset($_REQUEST['othersubstatus']) && is_array($_REQUEST['othersubstatus'])) {
            if(sizeOf((array)$_REQUEST['othersubstatus'])>1){
            $searchValue = implode(',', $_REQUEST['othersubstatus']);
            $likeCondition = '%' . $searchValue . '%';
            
            // Adding a LIKE condition to the criteria
            $criteria->addSearchCondition('othersubstatus', $likeCondition, false, 'AND');
                	}
            }
			
		 
		 	
		 	
		 	
			if(sizeOf((array)$_REQUEST['place'])>1){
				$intArray2 = array_map(
					function($value2){ return (int)$value2; },
					$_REQUEST['place']
				);
				$criteria->addInCondition('interest_id', $intArray2  , "AND");

			}
			
			
			
				if(sizeOf((array)$_REQUEST['project'])>1){
				$intArray2p = array_map(
					function($value2p){ return (int)$value2p; },
					$_REQUEST['project']
				);
				$criteria->addInCondition('project_id', $intArray2p  , "AND");

			}
			if(sizeOf((array)$_REQUEST['branch'])>1){
				$intArray22 = array_map(
					function($value22){ return (int)$value22; },
					$_REQUEST['branch']
				);
				$criteria->addInCondition('branch', $intArray22  , "AND");

			}
			
			
			
				if(sizeOf((array)$_REQUEST['unit_type'])>1){
				$intArray223 = array_map(
					function($value223){ return (int)$value223; },
					$_REQUEST['unit_type']
				);
				$criteria->addInCondition('unit_type', $intArray223  , "AND");

			}
			
			
			if(sizeOf((array)$_REQUEST['callcenter'])>1){
				$intArray3 = array_map(
					function($value3){ return (int)$value3; },
					$_REQUEST['callcenter']
				);
				$criteria->addInCondition('user_id', $intArray3  , "AND");

			}
			
			
			
				if(sizeOf((array)$_REQUEST['marketingby'])>1){
				$intArray34 = array_map(
					function($value34){ return (int)$value34; },
					$_REQUEST['marketingby']
				);
				$criteria->addInCondition('user_marketing', $intArray34  , "AND");

			}
			
			
			
			
			
			if(sizeOf((array)$_REQUEST['campaign'])>1){
			    
			    if($_REQUEST['campaign'][1]!=0){
			      
               $intArray4 = array_map(
					function($value4){ return (int)$value4; },
					$_REQUEST['campaign']
				);
                                unset($intArray4[0]);

				$criteria->addInCondition('campaign_id', $intArray4 , "AND");
			    }else{
				$criteria->addCondition('campaign_id IS NULL');
			    }
			    
                                        
			}
			
			
				if(sizeOf((array)$_REQUEST['strategy'])>1){
			    
			    if($_REQUEST['strategy'][1]!=0){
			      
               $intArray4strategy = array_map(
					function($value4strategy){ return (int)$value4strategy; },
					$_REQUEST['strategy']
				);
                                unset($intArray4strategy[0]);

				$criteria->addInCondition('strategy_id', $intArray4strategy , "AND");
			    }else{
				$criteria->addCondition('strategy_id IS NULL');
			    }
			    
                                        
			}
			
			
			
            $val=false;
			if(sizeOf((array)$_REQUEST['usersales'])>1 AND $_REQUEST['unseenauto']!=1 ){
$val=true;

                                        $intArray5 = array_map(
					function($value5){ return (int)$value5; },
					$_REQUEST['usersales']
				);
				$criteria->addInCondition('user_sales', $intArray5 , "AND");
			}
			if(sizeOf((array)$_REQUEST['exusersales'])>1){
            $val=true;
             $intArrayex = array_map(
					function($valueex){ return (int)$valueex; },
					$_REQUEST['exusersales']
				);
				$criteria->addInCondition('user_sales', $intArrayex , "AND");
			}
			
			
			
			
			
			if(sizeOf((array)$_REQUEST['lastreport'])>1){
            $val=true;
             $intArraylastreport = array_map(
					function($valuelastreport){ return (int)$valuelastreport; },
					$_REQUEST['lastreport']
				);
				$criteria->addInCondition('lastreport', $intArraylastreport , "AND");
			}
			
			
			
			
			
			    if(sizeOf((array)$_REQUEST['teamdistributed'])>1){
            $val=true;
            $intArrayteamdistributed = array_map(
            function($valueteamdistributed){ return (int)$valueteamdistributed; },
            $_REQUEST['teamdistributed']
            );
            $criteria->addInCondition('user_integration', $intArrayteamdistributed , "AND");
            }
			
			
			
			
            $val=false;
			if(sizeOf((array)$_REQUEST['fresh'])>1){
$val=true;

                                        $intArrayfresh = array_map(
					function($valuefresh){ return (int)$valuefresh; },
					$_REQUEST['fresh']
				);
				$criteria->addInCondition('fresh_sales', $intArrayfresh , "AND");
			}
			
			
			
				if(sizeOf((array)$_REQUEST['except'])>1){
$val=true;

                                        $intArrayexcept = array_map(
					function($valueexcept){ return (int)$valueexcept; },
					$_REQUEST['except']
				);
				$criteria->addNotInCondition('user_sales', $intArrayexcept , "AND");
			}
			
			
			
			
				
				if(sizeOf((array)$_REQUEST['exceptplatform'])>1){
$val=true;

                                        $intArrayexceptplatform = array_map(
					function($valueexceptplatform){ return (int)$valueexceptplatform; },
					$_REQUEST['exceptplatform']
				);
				$criteria->addNotInCondition('platform_id', $intArrayexceptplatform , "AND");
			}
			
			
			
			
				
				if(sizeOf((array)$_REQUEST['exceptcam'])>1){
$val=true;

                                        $intArrayexceptcam = array_map(
					function($valueexceptcam){ return (int)$valueexceptcam; },
					$_REQUEST['exceptcam']
				);
				$criteria->addNotInCondition('campaign_id', $intArrayexceptcam , "AND");
			}
			
			
			
			if(sizeOf((array)$_REQUEST['status'])>1){
                $val=true;
			    //var_dump($_REQUEST['status']);exit;
			    
			    if($_REQUEST['status'][1]!=0){
			      
                $intArraystatus = array_map(
					function($value6){ return (int)$value6; },
					$_REQUEST['status']
				);
				 $criteria->addInCondition('status', $intArraystatus , "AND");
				  
			    }else{
				$criteria->addCondition('status IS NULL');
			    }
		 	}
		 	if(sizeOf((array)$_REQUEST['substatus'])>1){
$val=true;

                    $intArraysubstatus = array_map(
					function($intArraysubstatus){ return (int)$intArraysubstatus; },
					$_REQUEST['substatus']
				);
				$criteria->addInCondition('substatus', $intArraysubstatus , "AND");
			}
			
			
			
			
			if($_REQUEST['unseenauto']==1){

                if(sizeOf((array)$_REQUEST['usersales'])>1){
                        $intArray5 = array_map(
    					function($value5){ return (int)$value5; },
    					$_REQUEST['usersales']
    				);
    				$criteria->addInCondition('unseenauto', $intArray5 , "AND");
    			}else{
				    $criteria->addCondition('unseenauto IS NOT NULL');
    			}
				$criteria->addCondition('user_sales IS NULL');
			}else if($_REQUEST['unseenauto']==2){



				$criteria->addCondition('unseenauto IS NULL');
			}else{
			}

//search for Brokers in view company 31/3/2019 7:25


	if(!empty($user->company_id) AND empty($user->broker) ){  
               $allcampaign=Campaign::model()->findAll(array('condition'=>'company_id='.$user->company_id));

                        foreach($allcampaign as $leader){
				$arr[]=$leader->id ;
			} 

                     $criteria->addInCondition('campaign_id', $arr);
	} 

// END OF search for Brokers in view company ahmed said dont do thing here but its organised as you see

			if(!empty($_REQUEST['startdate']) ){
				$criteria->addBetweenCondition("date",$_REQUEST['startdate'],$_REQUEST['enddate'],'AND');
			}
			
			
			
			
			if(!empty($_REQUEST['startsysdate']) ){
				$criteria->addBetweenCondition("sysdate",$_REQUEST['startsysdate'],$_REQUEST['endsysdate'],'AND');
			}
			
			if(!empty($_REQUEST['startactiondate']) ){
				$criteria->addBetweenCondition("checkup_activity",$_REQUEST['startactiondate'],$_REQUEST['endactiondate'],'AND');
			}
			
			
			if(!empty($_REQUEST['startduplicatedate']) ){
				$criteria->addBetweenCondition("duplicate_date",$_REQUEST['startduplicatedate'],$_REQUEST['endduplicatedate'],'AND');
			}
			
            if(!empty($_REQUEST['transfer']) ){
            $transferstatus=1;
            $criteria->addSearchCondition('transfer', $transferstatus,false, "AND");
            $criteria->addBetweenCondition("transferdate",$_REQUEST['starttransferdate'],$_REQUEST['endtransferdate'],'AND');
            
            
            }
            if(!empty($_REQUEST['dup']) ){
            $criteria->addSearchCondition('duplicate',$_REQUEST['dup'],false, "AND");
            }
            if(!empty($_REQUEST['startclosedate']) ){
            $criteria->addBetweenCondition("close_date",$_REQUEST['startclosedate'],$_REQUEST['endclosedate'],'AND');
            }
            
            
            if($_REQUEST['netduplicate']==1 ){
                
                $allleadss = Leads::model()->findAll($criteria); 
                if(!empty($allleadss)){
                    $array=array();
                    $arrayid=array();
                foreach($allleadss as $lead){
                    if(!in_array($lead->tel,$array)){
                        $array[]=$lead->tel;
                        $arrayid[]=$lead->id;
                    }
                }
                } 
            	$criteria = new CDbCriteria();
		        $criteria->order = 'id DESC';
		    	$criteria->addInCondition('id', $arrayid);
		    	$allleadss = Leads::model()->findAll($criteria);    
                 
                  
            }else{
		    	$allleadss = Leads::model()->findAll($criteria);    
            }   
                        

		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");  
 
        //Transfer first level
if (isset($_POST['Transfer'])) {
    $targetSales = (int)$_POST['Lead']['sales'];
    $ids = isset($_POST['checks']) ? array_map('intval', (array)$_POST['checks']) : [];
    $ids = array_values(array_unique(array_filter($ids)));
    if (!$ids || !$targetSales) {
        Yii::app()->user->setFlash('danger', 'No leads or target sales.');
        $this->redirect(['salesmanger']); Yii::app()->end();
    }

    $transferaction = new Transferaction();
    $transferaction->user_id = $userid;
    $transferaction->date    = $today;
    $transferaction->time    = $time;
    $transferaction->sales   = $targetSales;
    $transferaction->total   = count($ids);
    $transferaction->save(false);
    $taId = (int)$transferaction->id;

    $db = Yii::app()->db;
    $chunkSize = 500;
    $reason = $_POST['Transfer']['reason'] ?? 'Bulk Transfer';

    foreach (array_chunk($ids, $chunkSize) as $batch) {
        $tx = $db->beginTransaction();
        try {
            // INSERT transfer rows (fromm من leads قبل التحديث)
            $params = [
                ':reason'=>$reason, ':uid'=>$userid, ':too'=>$targetSales,
                ':date'=>$today, ':time'=>$time, ':ta'=>$taId,
                ':hide'=> isset($_POST['Hideee']) ? (int)$_POST['Hideee'] : 0,
                ':hidetl'=> isset($_POST['Hideteamleader']) ? (int)$_POST['Hideteamleader'] : 0,
                ':fake'=> isset($_POST['fakenewlead']) ? (int)$_POST['fakenewlead'] : 0,
            ];
            $in = [];
            foreach ($batch as $i=>$id){ $in[]=":id$i"; $params[":id$i"]=$id; }
            $inList = implode(',', $in);

            $db->createCommand("
                INSERT INTO transfer (reason,user_id,lead_id,fromm,too,date,time,hide,hideteamleader,fakenewlead,transferaction_id)
                SELECT :reason,:uid,l.id,l.user_sales,:too,:date,:time,:hide,:hidetl,:fake,:ta
                FROM leads l WHERE l.id IN ($inList)
            ")->execute($params);

            // UPDATE leads دفعة واحدة
            $params2 = [':too'=>$targetSales, ':reason'=>$reason, ':time'=>$time, ':uid'=>$userid, ':today'=>$today];
            $in2=[]; foreach ($batch as $i=>$id){ $in2[]=":lid$i"; $params2[":lid$i"]=$id; }
            $db->createCommand("
                UPDATE leads SET
                    transfer=1,
                    counttransfer=IFNULL(counttransfer,0)+1,
                    transferreason=:reason,
                    dtime=:time,
                    communication=NULL,
                    transferuser=:uid,
                    transferdate=:today,
                    visitactive=NULL,
                    close=NULL,
                    transferfrom=user_sales,
                    user_sales=:too
                WHERE id IN (".implode(',',$in2).")
            ")->execute($params2);

            // UPDATE activities دفعة واحدة
            $params3 = [':too'=>$targetSales];
            $in3=[]; foreach ($batch as $i=>$id){ $in3[]=":aid$i"; $params3[":aid$i"]=$id; }
            $db->createCommand("
                UPDATE activities SET too=:too
                WHERE close IS NULL AND leads_id IN (".implode(',',$in3).")
            ")->execute($params3);

            $tx->commit();
        } catch (Exception $e) {
            if ($tx->active) $tx->rollback();
            Yii::app()->user->setFlash('danger', 'Bulk transfer failed: '.$e->getMessage());
            $this->redirect(['salesmanger']); Yii::app()->end();
        }
    }

    // خلّي العملية مقبولة بالكامل
    $db->createCommand("UPDATE transferaction SET accepted=total, rejected=0 WHERE id=:id")->execute([':id'=>$taId]);

    Yii::app()->user->setFlash('success', 'Transfer done for '.count($ids).' leads.');
    $this->redirect(['salesmanger']); Yii::app()->end();
}

$arrayofids = array();

/**
 * توزيع بالأعداد — Staging ONLY
 * - كل محاولة = عملية جديدة مستقلة في transferaction
 * - إدراج صفوف جديدة في transfer فقط (من غير UPDATE/DELETE)
 * - الصفوف الجديدة تكون pending: done = NULL
 */
if (isset($_POST['Leads']) && isset($_POST['number'])) {
    // 1) مدخلات + تنظيف
    $salesIdsRaw = (array)$_POST['Leads'];     // الوجهات (too)
    $numbersRaw  = (array)$_POST['number'];    // الكميات المطلوبة لكل وجهة

    $salesIds = array();
    foreach ($salesIdsRaw as $v) { $v = (int)$v; if ($v > 0) $salesIds[] = $v; }

    $numbers  = array();
    foreach ($numbersRaw as $n) { $n = (int)$n; if ($n > 0) $numbers[] = $n; }

    $pairCount = min(count($salesIds), count($numbers));
    if ($pairCount === 0) {
        Yii::app()->user->setFlash('danger', 'No sales/count pairs provided.');
        Yii::app()->controller->refresh(); Yii::app()->end();
    }

    // Options
    $hide           = isset($_POST['Hideee']) ? (int)$_POST['Hideee'] : 0;
    $hideteamleader = isset($_POST['Hideteamleader']) ? (int)$_POST['Hideteamleader'] : 0;
    $fakenewlead    = isset($_POST['fakenewlead']) ? (int)$_POST['fakenewlead'] : 0;

    // 2) إعدادات DB
    $db        = Yii::app()->db;
    $chunkSize = 1000;
    $reason    = 'Multi Transfer';

    // WHERE من $criteria (نفس فلاتر الجدول بالظبط)
    $where       = '1=1';
    $paramsWhere = array();
    if (isset($criteria) && !empty($criteria->condition)) {
        $where       = '(' . $criteria->condition . ')';
        $paramsWhere = !empty($criteria->params) ? $criteria->params : array();
    }

    // سنستبعد ما اختير بالفعل داخل نفس الريكوست
    $usedIds = array();  // per-request de-duplication

    // 3) تنفيذ لكل زوج (وجهة/عدد)
    for ($i = 0; $i < $pairCount; $i++) {
        $salesId = (int)$salesIds[$i];   // الوجهة (too)
        $take    = (int)$numbers[$i];
        if ($salesId <= 0 || $take <= 0) continue;

        // 3.1 رأس العملية — صف واحد في transferaction
        $ta = new Transferaction();
        $ta->user_id  = $userid;
        $ta->date     = $today;
        $ta->time     = $time;
        $ta->sales    = $salesId;
        $ta->total    = $take;       // المطلوب (هنحسب accepted فعليًا)
        $ta->accepted = 0;
        $ta->rejected = 0;
        $ta->details  = NULL;
        $ta->save(false);
        $taId = (int)$ta->id;

        // 3.2 اختَر IDs من leads حسب الفلاتر + استبعد اللي اتاخدوا بالفعل في نفس POST
        $excludeSql = '';
        $excludeParams = array();
        if (!empty($usedIds)) {
            $phs = array();
            foreach ($usedIds as $j => $lid) { $ph=":ex{$j}"; $phs[]=$ph; $excludeParams[$ph]=(int)$lid; }
            $excludeSql = ' AND l.id NOT IN ('.implode(',', $phs).')';
        }

        $pickSql = "
            SELECT l.id
            FROM leads l
            WHERE {$where} {$excludeSql}
            ORDER BY l.id ASC
            LIMIT {$take}
        ";
        $pickParams = $paramsWhere;
        foreach ($excludeParams as $k=>$v) { $pickParams[$k]=$v; }

        $pickedIds = $db->createCommand($pickSql)->queryColumn($pickParams);

        if (!$pickedIds) {
            // مفيش مرشحين متاحين — العملية رفضت بالكامل
            $db->createCommand("UPDATE transferaction SET rejected = total, accepted = 0 WHERE id = :i")
               ->execute(array(':i' => $taId));
            continue;
        }

        // حدّث لستة الاستبعاد لللفات التالية
        foreach ($pickedIds as $lid) { $usedIds[] = (int)$lid; }

        // 3.3 إدراج على باتشات — دايمًا INSERT جديد في transfer (done = NULL)
        $acceptedThisAction = 0;

        foreach (array_chunk($pickedIds, $chunkSize) as $batch) {
            $tx = $db->beginTransaction();
            try {
                // placeholders
                $inPlaceholders = array();
                $par = array(
                    ':reason' => $reason,
                    ':uid'    => $userid,
                    ':too'    => $salesId,
                    ':datee'  => $today,
                    ':timee'  => $time,
                    ':hide'   => $hide,
                    ':hidetl' => $hideteamleader,
                    ':fake'   => $fakenewlead,
                    ':ta'     => $taId,
                );
                foreach ($batch as $k => $lid) { $ph=":L{$k}"; $inPlaceholders[]=$ph; $par[$ph]=(int)$lid; }

                // fromm بيتجاب من leads.user_sales لحظة الإدراج
                $insertSql = "
                    INSERT INTO transfer
                      (reason,user_id,lead_id,fromm,too,date,time,hide,hideteamleader,fakenewlead,transferaction_id,done)
                    SELECT :reason,:uid,l.id,l.user_sales,:too,:datee,:timee,:hide,:hidetl,:fake,:ta, NULL
                    FROM leads l
                    WHERE l.id IN (".implode(',', $inPlaceholders).")
                ";
                $inserted = (int)$db->createCommand($insertSql)->execute($par);
                $acceptedThisAction += $inserted;

                if ($inserted > 0) {
                    $db->createCommand("
                        UPDATE transferaction
                        SET accepted = accepted + :n
                        WHERE id = :i
                    ")->execute(array(':n'=>$inserted, ':i'=>$taId));
                }

                $tx->commit();
            } catch (Exception $e) {
                if ($tx->active) $tx->rollback();
                $db->createCommand("
                    UPDATE transferaction
                    SET details = CONCAT(IFNULL(details,''),'[ERR] ', :msg)
                    WHERE id = :i
                ")->execute(array(':msg'=>substr($e->getMessage(),0,300), ':i'=>$taId));
                Yii::log('Multi-assign insert failed: '.$e->getMessage(), CLogger::LEVEL_ERROR);
            }
        }

        // 3.4 اضبط rejected بدقّة
        $db->createCommand("
            UPDATE transferaction
            SET rejected = GREATEST(total - accepted, 0)
            WHERE id = :i
        ")->execute(array(':i' => $taId));

        if ($acceptedThisAction === 0) {
            Yii::log('No rows inserted for TA#'.$taId.' (sales '.$salesId.')', CLogger::LEVEL_WARNING);
        }
    }

    Yii::app()->controller->refresh();
}


	
if(isset($_POST['checks']) AND isset($_POST['salescheck'])){
 
$hide= $_POST['Hideee'];
	$hideteamleader= $_POST['Hideteamleader'];
	$fakenewlead= $_POST['fakenewlead'];

$criteria = new CDbCriteria();       
$criteria->addInCondition('id', $_POST['checks']);
$allleadsss= Leads::model()->findAll($criteria);

$total = count($allleadsss);
$total = (int)$total;
$sales = (int)$_POST['salescheck'];

//var_dump($sales);exit;


$transferaction=new Transferaction();
$transferaction->user_id=$userid;
$transferaction->date= $today ;                     // 03.10.01
$transferaction->time= $time  ;
$transferaction->sales= $sales  ;
$transferaction->total= $total  ;
if($transferaction->save()){
//var_dump($allleadsss);exit;
foreach($allleadsss as $lead){ 



$treason ="Multi Transfer";
        $transfer=new Transfer();
        $transfer->reason=$treason;
        $transfer->user_id=$userid;
        $transfer->lead_id=$lead->id;
        $transfer->fromm=$lead->user_sales;
        $transfer->too=$transferaction->sales;
        $transfer->transferaction_id=$transferaction->id;
        $transfer->date= $today ;                     // 03.10.01
        $transfer->time= $time  ;
        $transfer->hide= $hide  ;
        $transfer->hideteamleader= $hideteamleader  ;
        $transfer->fakenewlead= $fakenewlead  ;

        //var_dump($transfer->hideteamleader);exit;

        if($transfer->save()){
        $transferaction->accepted = $transferaction->accepted+1;
        $transferaction->save();

     
        }
        
        
        
        
        
    if(!$transfer->save()){
    $transferaction->accepted = $transferaction->accepted+1;
    $transferaction->save(); 
    }






}
}
	
	  

	
			//$this->redirect(array('marketing/uploadleads')	);
					Yii::app()->controller->refresh();

}


if(isset($_POST['checksdis'])){
 
 
$criteria = new CDbCriteria();       
$criteria->addInCondition('id', $_POST['checksdis']);
$allleadsss= Leads::model()->findAll($criteria);
	
//	var_dump(count($allleadsss));exit;
	    
  		foreach($allleadsss as $lead){ 

	    	$lead->user_integration=NULL;
	        $lead->save();











		}
	
	  

	
			//$this->redirect(array('marketing/uploadleads')	);
					Yii::app()->controller->refresh();

}
//Bulk Close
if (isset($_POST['closeallresult'])) {
    $db      = Yii::app()->db;
    $today   = date('Y-m-d');
    $userid  = (int)Yii::app()->user->id;
    $deadVal = isset($_POST['dead']) ? (int)$_POST['dead'] : 0;
    $reason  = trim((string)$_POST['closeallresult']);

    // collect lead IDs only (avoid N+1 ActiveRecord overhead)
    $leadIds = [];
    foreach ($allleadss as $lead) {
        $leadIds[] = (int)$lead->id;
    }
    if (!$leadIds) {
        $this->redirect(['salesmanger']);
        return;
    }

    // helper: chunk big IN() lists to keep packets + locks small
    $chunks = array_chunk($leadIds, 2000);

    $tx = $db->beginTransaction();
    try {
        foreach ($chunks as $chunk) {
            // --- 1) LEADS: bulk update (keeps your original semantics) ---
            // - close=1, dates = today, visitactive=NULL, communication=1
            // - first_communication only when empty (NULL)  -> COALESCE
            // - if dead == 2 -> set feedback_date, feedback=1, confirmclose=1
            $placeholders = implode(',', array_fill(0, count($chunk), '?'));

            $sqlLeads = "
                UPDATE leads
                SET
                    close = 1,
                    close_date = ?,
                    checkup_activity = ?,
                    visitactive = NULL,
                    communication = 1,
                    first_communication = IFNULL(first_communication, ?)
                    " . ($deadVal === 2 ? ",
                    feedback_date = ?,
                    feedback = 1,
                    confirmclose = 1" : "") . "
                WHERE id IN ($placeholders)
            ";

            $params = [$today, $today, $userid];
            if ($deadVal === 2) {
                $params[] = $today;
            }
            // add ids
            $params = array_merge($params, $chunk);

            $db->createCommand($sqlLeads)->execute($params);

            // --- 2) ACTIVITIES: bulk update per leads set ---
            // Apply only to rows where (close IS NULL OR report IS NULL), as you had
            $sqlActs = "
                UPDATE activities
                SET
                    close = 1,
                    report = CONCAT(?, '-Closed BY ADMIN ', ?)
                WHERE (close IS NULL OR report IS NULL)
                  AND leads_id IN ($placeholders)
            ";
            $actParams = [$reason, $today];
            $actParams = array_merge($actParams, $chunk);

            $db->createCommand($sqlActs)->execute($actParams);
        }

        $tx->commit();
    } catch (Exception $e) {
        if ($tx->active) $tx->rollback();
        // Optional: log and show a safe message
        Yii::log('Bulk close error: ' . $e->getMessage(), CLogger::LEVEL_ERROR);
        Yii::app()->user->setFlash('error', 'Closing failed: ' . CHtml::encode($e->getMessage()));
        $this->redirect(['salesmanger']);
        return;
    }

    // Fast redirect after DB work completes
    $this->redirect(['salesmanger']);
}

if(isset($_POST['branchcheck'])){
    
    
	foreach($allleadss  as $lead){	
	
	
$allsalesreport = Activities::model()->findAll(array( 'condition' => 'leads_id=' . $lead->id ,'order'=>'id ASC'   ));
foreach($allsalesreport as $salesreport){

$lead->details = $lead->details.'  /  '.$salesreport->date.' '.$salesreport->details;
$lead->save();

}

$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
$today = date("Y-m-d");                     // 03.10.01
$time = date("H:i:s"); 	
	
	
//API Url
$url = $_POST['branchcheck'].'/en/sales/jsonleadfrombranch';
 
//Initiate cURL.
// init curl object        
$ch = curl_init();

// define options
$optArray = array(
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true
);

// apply those options
curl_setopt_array($ch, $optArray);
$record = 123;  
$platform=Platform::model()->findByAttributes(array('id'=>$lead->platform_id));

//The JSON data.
$jsonData = array(
    
'user_id' => $lead->user_id,
'date' => $lead->date,
'communicate_date' => $today,
'feedback_date' => $today,
'transfer' => 1,
'transferdate' => $today,
'branch' => 1,

'title' => $lead->title,
'tel' => $lead->tel,
'second_tel' => $lead->second_tel,
'tel3' => $lead->tel3,
'tel4' => $lead->tel4,
'notes' => $lead->notes,
'details' => $lead->details,



'adsetname' => $lead->adsetname,
'adname' => $lead->adname,
'facebook_id' => $lead->facebook_id,
'status' => $lead->status,
'area' => $lead->area,
'time' => $lead->time,
'hidden' => $lead->hidden,
'strategy_id' => $lead->strategy_id,

'platformtitle' => $platform->title,
'campaign_id' => $lead->campaign_id,
'platformchild_id' => $lead->platformchild_id,
'international_code' => $lead->international_code,
'international_code2' => $lead->international_code2,
'user_marketing' => $lead->user_marketing,
'career' => $lead->career,
'email' => $lead->email,

  
    
);
 
//Encode the array into JSON.
$jsonDataEncoded = json_encode($jsonData);
 
//Tell cURL that we want to send a POST request.
curl_setopt($ch, CURLOPT_POST, 1);
 
//Attach our encoded JSON string to the POST fields.
curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonDataEncoded);
 
//Set the content type to application/json
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json')); 
 
//Execute the request
$result = curl_exec($ch);       
    
		

		
	}
	
}

if(isset($_POST['Edit']) AND count($allleadss)<=100000){
     
     





     
     
     
  
if(isset($_POST['editllresultsrc'])){
    
        $userid=Yii::app()->user->id;
        $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18      
    
    
    if($_POST['editllresultsrc']==1){
        foreach($allleadss  as $lead){	
            
            
            
            
            
            
            $editlog = new Editlog();
            $editlog->date = $today;
            $editlog->time = $time;
            $editlog->lead_id = $lead->id;
            $editlog->user_id = $userid;
            $editlog->editfrom = $lead->coldcall;
            $editlog->editto = NULL;
            $editlog->editcolumn = 'coldcall';
            $editlog->save();
            
            
            
            $lead->coldcall=NULL; 
            if($lead->save()){
                $criteriaopenx = new CDbCriteria; 
    	      	$criteriaopenx->addSearchCondition('leads_id', $lead->id, false, 'AND');
    	       	$allopenactivities= Activities::model()->findAll($criteriaopenx);
    	       	if(!empty($allopenactivities)){
        	       	foreach($allopenactivities as $activity){
        	       	    $activity->coldcall=NULL;
        	       	    $activity->save();
        	       	}
    	       	}
            }
        }
    }elseif($_POST['editllresultsrc']==2){
        foreach($allleadss  as $lead){	
            
            
            
            
            
            $editlog = new Editlog();
            $editlog->date = $today;
            $editlog->time = $time;
            $editlog->lead_id = $lead->id;
            $editlog->user_id = $userid;
            $editlog->editfrom = $lead->coldcall;
            $editlog->editto = NULL;
            $editlog->editcolumn = 'coldcall';
            $editlog->save();
            
            
            $lead->coldcall=1; 
            if($lead->save()){
                $criteriaopenx = new CDbCriteria; 
    	      	$criteriaopenx->addSearchCondition('leads_id', $lead->id, false, 'AND');
    	       	$allopenactivities= Activities::model()->findAll($criteriaopenx);
    	       	if(!empty($allopenactivities)){
        	       	foreach($allopenactivities as $activity){
        	       	    $activity->coldcall=1;
        	       	    $activity->save();
        	       	}
    	       	}
            }
        }
    }elseif($_POST['editllresultsrc']==3){
        foreach($allleadss  as $lead){	
            
            
            
            
            
            $editlog = new Editlog();
            $editlog->date = $today;
            $editlog->time = $time;
            $editlog->lead_id = $lead->id;
            $editlog->user_id = $userid;
            $editlog->editfrom = $lead->coldcall;
            $editlog->editto = NULL;
            $editlog->editcolumn = 'coldcall';
            $editlog->save();
            
            
            $lead->coldcall=3; 
             $lead->indirect=1; 
            if($lead->save()){
                $criteriaopenx = new CDbCriteria; 
    	      	$criteriaopenx->addSearchCondition('leads_id', $lead->id, false, 'AND');
    	       	$allopenactivities= Activities::model()->findAll($criteriaopenx);
    	       	if(!empty($allopenactivities)){
        	       	foreach($allopenactivities as $activity){
        	       	    $activity->coldcall=3;
        	       	    $activity->save();
        	       	}
    	       	}
            }
        }
    }
    
}

if(isset($_POST['editllresultplatform']) AND !empty($_POST['editllresultplatform'])){
    foreach($allleadss  as $lead){	
        if(isset($_POST['editllresultplatform'])){
            
            
            // Assuming $connection is your Yii database connection
            $connection = Yii::app()->db;
            
            // Create a new Editlog record
            $editlogCommand = $connection->createCommand("
            INSERT INTO editlog (date, time, lead_id, user_id, editfrom, editto, editcolumn)
            VALUES (:date, :time, :lead_id, :user_id, :editfrom, :editto, :editcolumn)
            ");
            $editlogCommand->bindParam(':date', $today);
            $editlogCommand->bindParam(':time', $time);
            $editlogCommand->bindParam(':lead_id', $lead->id);
            $editlogCommand->bindParam(':user_id', $userid);
            $editlogCommand->bindParam(':editfrom', $lead->platform_id);
            $editlogCommand->bindParam(':editto', $_POST['editllresultplatform']);
            $editlogCommand->bindValue(':editcolumn', 'platform_id'); // Use bindValue for non-reference values
            $editlogCommand->execute();
            
            // Update the platform_id of the Lead record
            $leadCommand = $connection->createCommand("
            UPDATE leads
            SET platform_id = :platform_id
            WHERE id = :lead_id
            ");
            $leadCommand->bindParam(':platform_id', $_POST['editllresultplatform']);
            $leadCommand->bindParam(':lead_id', $lead->id);
            $leadCommand->execute();

           
           
        }
        if(isset($_POST['editllresultplatformchild'])){
            
            
            
            
            // Assuming $connection is your Yii database connection
// Assuming $lead is an instance of the Lead model
// Assuming $today, $time, $userid, $_POST['editllresultplatformchild'] are defined

$connection = Yii::app()->db;

// Create a new Editlog record
$editlogCommand = $connection->createCommand("
    INSERT INTO editlog (date, time, lead_id, user_id, editfrom, editto, editcolumn)
    VALUES (:date, :time, :lead_id, :user_id, :editfrom, :editto, :editcolumn)
");
$editlogCommand->bindParam(':date', $today);
$editlogCommand->bindParam(':time', $time);
$editlogCommand->bindParam(':lead_id', $lead->id);
$editlogCommand->bindParam(':user_id', $userid);
$editlogCommand->bindParam(':editfrom', $lead->platformchild_id);
$editlogCommand->bindParam(':editto', $_POST['editllresultplatformchild']);
$editlogCommand->bindValue(':editcolumn', 'platformchild_id');
$editlogCommand->execute();

// Update the platformchild_id of the Lead record
$leadCommand = $connection->createCommand("
    UPDATE leads
    SET platformchild_id = :platformchild_id
    WHERE id = :lead_id
");
$leadCommand->bindParam(':platformchild_id', $_POST['editllresultplatformchild']);
$leadCommand->bindParam(':lead_id', $lead->id);
$leadCommand->execute();

            
        }
    }
    	
}

if(isset($_POST['editllresultcam']) AND !empty($_POST['editllresultcam'] )){
    foreach($allleadss  as $lead){	
        if(isset($_POST['editllresultcam'])){
            
            
         
         
         // Assuming $connection is your Yii database connection
// Assuming $lead is an instance of the Lead model
// Assuming $today, $time, $userid, $_POST['editllresultcam'] are defined

$connection = Yii::app()->db;

// Create a new Editlog record
$editlogCommand = $connection->createCommand("
    INSERT INTO editlog (date, time, lead_id, user_id, editfrom, editto, editcolumn)
    VALUES (:date, :time, :lead_id, :user_id, :editfrom, :editto, :editcolumn)
");
$editlogCommand->bindParam(':date', $today);
$editlogCommand->bindParam(':time', $time);
$editlogCommand->bindParam(':lead_id', $lead->id);
$editlogCommand->bindParam(':user_id', $userid);
$editlogCommand->bindParam(':editfrom', $lead->campaign_id);
$editlogCommand->bindParam(':editto', $_POST['editllresultcam']);
$editlogCommand->bindValue(':editcolumn', 'campaign_id');
$editlogCommand->execute();

// Find the Campaign record by primary key
$sql = "SELECT * FROM campaign WHERE id = :campaign_id";
$sta = $connection->createCommand($sql)->bindParam(':campaign_id', $_POST['editllresultcam'])->queryRow();

// Update the campaign_id and strategy_id of the Lead record
$leadCommand = $connection->createCommand("
    UPDATE leads
    SET campaign_id = :campaign_id, strategy_id = :strategy_id
    WHERE id = :lead_id
");
$leadCommand->bindParam(':campaign_id', $_POST['editllresultcam']);
$leadCommand->bindParam(':strategy_id', $sta['strategy_id']);
$leadCommand->bindParam(':lead_id', $lead->id);
$leadCommand->execute();

         
         
         
        }
    }
    	
}



if(isset($_POST['editllresultproject']) AND !empty($_POST['editllresultproject'] )){
    foreach($allleadss  as $lead){	
        if(isset($_POST['editllresultproject'])){
            
            
            
            
            // Assuming $connection is your Yii database connection
            // Assuming $lead is an instance of the Lead model
            // Assuming $today, $time, $userid, $_POST['editllresultproject'] are defined
            
            $connection = Yii::app()->db;
            
            // Create a new Editlog record
            $editlogCommand = $connection->createCommand("
            INSERT INTO editlog (date, time, lead_id, user_id, editfrom, editto, editcolumn)
            VALUES (:date, :time, :lead_id, :user_id, :editfrom, :editto, :editcolumn)
            ");
            $editlogCommand->bindParam(':date', $today);
            $editlogCommand->bindParam(':time', $time);
            $editlogCommand->bindParam(':lead_id', $lead->id);
            $editlogCommand->bindParam(':user_id', $userid);
            $editlogCommand->bindParam(':editfrom', $lead->project_id);
            $editlogCommand->bindParam(':editto', $_POST['editllresultproject']);
            $editlogCommand->bindValue(':editcolumn', 'project_id');
            $editlogCommand->execute();
            
            // Update the project_id of the Lead record
            $leadCommand = $connection->createCommand("
            UPDATE leads
            SET project_id = :project_id
            WHERE id = :lead_id
            ");
            $leadCommand->bindParam(':project_id', $_POST['editllresultproject']);
            $leadCommand->bindParam(':lead_id', $lead->id);
            $leadCommand->execute();

            
        }
    }
    	
}


if(isset($_POST['editllresultplace']) AND !empty($_POST['editllresultplace'] )){
    foreach($allleadss  as $lead){	
        if(isset($_POST['editllresultplace'])){
            
            
            
            // Assuming $connection is your Yii database connection
// Assuming $lead is an instance of the Lead model
// Assuming $today, $time, $userid, $_POST['editllresultplace'] are defined

$connection = Yii::app()->db;

// Create a new Editlog record
$editlogCommand = $connection->createCommand("
    INSERT INTO editlog (date, time, lead_id, user_id, editfrom, editto, editcolumn)
    VALUES (:date, :time, :lead_id, :user_id, :editfrom, :editto, :editcolumn)
");
$editlogCommand->bindParam(':date', $today);
$editlogCommand->bindParam(':time', $time);
$editlogCommand->bindParam(':lead_id', $lead->id);
$editlogCommand->bindParam(':user_id', $userid);
$editlogCommand->bindParam(':editfrom', $lead->interest_id);
$editlogCommand->bindParam(':editto', $_POST['editllresultcam']);
$editlogCommand->bindValue(':editcolumn', 'campaign_id');
$editlogCommand->execute();

// Update the interest_id of the Lead record
$leadCommand = $connection->createCommand("
    UPDATE leads
    SET interest_id = :interest_id
    WHERE id = :lead_id
");
$leadCommand->bindParam(':interest_id', $_POST['editllresultplace']);
$leadCommand->bindParam(':lead_id', $lead->id);
$leadCommand->execute();

            
            
        }
    }
    	
}




if(isset($_POST['editllresultunittype']) AND !empty($_POST['editllresultunittype'] )){
    foreach($allleadss  as $lead){	
        if(isset($_POST['editllresultunittype'])){
            
            
            
            // Assuming $connection is your Yii database connection
// Assuming $lead is an instance of the Lead model
// Assuming $today, $time, $userid, $_POST['editllresultplace'] are defined

$connection = Yii::app()->db;

// Create a new Editlog record
$editlogCommand = $connection->createCommand("
    INSERT INTO editlog (date, time, lead_id, user_id, editfrom, editto, editcolumn)
    VALUES (:date, :time, :lead_id, :user_id, :editfrom, :editto, :editcolumn)
");
$editlogCommand->bindParam(':date', $today);
$editlogCommand->bindParam(':time', $time);
$editlogCommand->bindParam(':lead_id', $lead->id);
$editlogCommand->bindParam(':user_id', $userid);
$editlogCommand->bindParam(':editfrom', $lead->interest_id);
$editlogCommand->bindParam(':editto', $_POST['editllresultcam']);
$editlogCommand->bindValue(':editcolumn', 'campaign_id');
$editlogCommand->execute();

// Update the interest_id of the Lead record
$leadCommand = $connection->createCommand("
    UPDATE leads
    SET unit_type = :unit_type
    WHERE id = :lead_id
");
$leadCommand->bindParam(':unit_type', $_POST['editllresultunittype']);
$leadCommand->bindParam(':lead_id', $lead->id);
$leadCommand->execute();

            
            
        }
    }
    	
}


if(isset($_POST['editllresultsubstatus']) AND !empty($_POST['editllresultsubstatus'] )){
    
    $substatus = Substatus::model()->findByAttributes(array('id'=>$_POST['editllresultsubstatus']));
    //var_dump($substatus->parent_id);exit;
    //$substatus=Substatus::model()->findByPk($_POST['substatus']);
    foreach($allleadss  as $lead){	
        if(isset($_POST['editllresultsubstatus'])){
            
            
            
            // Assuming $connection is your Yii database connection
// Assuming $lead is an instance of the Lead model
// Assuming $today, $time, $userid, $_POST['editllresultsubstatus'] are defined

$connection = Yii::app()->db;

// Create a new Editlog record
$editlogCommand = $connection->createCommand("
    INSERT INTO editlog (date, time, lead_id, user_id, editfrom, editto, editcolumn)
    VALUES (:date, :time, :lead_id, :user_id, :editfrom, :editto, :editcolumn)
");
$editlogCommand->bindParam(':date', $today);
$editlogCommand->bindParam(':time', $time);
$editlogCommand->bindParam(':lead_id', $lead->id);
$editlogCommand->bindParam(':user_id', $userid);
$editlogCommand->bindParam(':editfrom', $lead->campaign_id);
$editlogCommand->bindParam(':editto', $_POST['editllresultsubstatus']);
$editlogCommand->bindValue(':editcolumn', 'status and sub');
$editlogCommand->execute();

// Assuming $substatus is an instance of the Substatus model, you need to fetch it somehow
$sql = "SELECT * FROM substatus WHERE id = :substatus_id";
$substatus = $connection->createCommand($sql)->bindParam(':substatus_id', $_POST['editllresultsubstatus'])->queryRow();

// Update the status and substatus of the Lead record
$leadCommand = $connection->createCommand("
    UPDATE leads
    SET status = :status, substatus = :substatus
    WHERE id = :lead_id
");
$leadCommand->bindParam(':status', $substatus['parent_id']);
$leadCommand->bindParam(':substatus', $substatus['id']);
$leadCommand->bindParam(':lead_id', $lead->id);
$leadCommand->execute();

            
            
        }
    }
    	
}


     
}

if(isset($_POST['deleteall']) AND count($allleadss)<=100000){
    





            		ini_set('max_execution_time', 300);
            		ini_set('memory_limit', '-1');

                //Genrate sql Backup in Backups folder
                
    
$userid=Yii::app()->user->id;
$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
$today = date("Y-m-d");                     // 03.10.01
$time = date("H:i:s");   
if(isset($_POST['deleteall'])){
        foreach($allleadss  as $lead){	
            
            
             $newleaddelete=new Deleteleads();
    		     $newleaddelete->user_id=$userid;
    		     $newleaddelete->date=$today;
    		     $newleaddelete->time=$time;
    		     $newleaddelete->details=$lead->details;
    		     $newleaddelete->lead_id=$lead->id;
    		     $newleaddelete->user_sales=$lead->user_sales;
    		     $newleaddelete->camp_id=$lead->campaign_id;
    		     $newleaddelete->platform_id=$lead->platform_id;
    		     $newleaddelete->title=$lead->title;
    		     $newleaddelete->tel=$lead->tel;
    		     if($newleaddelete->save()){
    		         
                $criteriaopenx = new CDbCriteria; 
    	      	$criteriaopenx->addSearchCondition('leads_id', $lead->id, false, 'AND');
    	       	$allopenactivities= Activities::model()->findAll($criteriaopenx);
    	       	if(!empty($allopenactivities)){
        	       	foreach($allopenactivities as $activity){
        	       	    $activity->delete();
        	      
    	       
            }
        }
        
        
         $lead->delete();
    		     }
    }
    
}





     
}

if(isset($_POST['fakeleads']) AND count($allleadss)<=100000){
    $userid=Yii::app()->user->id;
    $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
    $today = date("Y-m-d");                     // 03.10.01
    $time = date("H:i:s"); 
    foreach($allleadss  as $lead){	
    //var_dump($lead->id);echo"!<br>";
    $oldlead= Leads::model()->findByAttributes(array('id'=>$lead->id));
		if(!empty($oldlead)){
            $criteria = new CDbCriteria; 
            $criteria->addCondition('leads_id=' . $oldlead->id);
            $allactivities=Activities::model()->findAll($criteria);
            if(!empty($allactivities)){
                foreach($allactivities as $activity){
                $activity->close=1;
                $activity->hidden=1;
                    if(empty($activity->report)){
                        $activity->report='Fake Lead In '.$today;
                    }
                    $activity->save();
                }
            }
            
            
            $newfake=new FakeLead();
            $newfake->user_id=$userid;
            $newfake->date=$today;
            $newfake->time=$time;
            $newfake->lead_id=$oldlead->id;
            $newfake->code=$oldlead->international_code;
            $newfake->tel=$oldlead->tel;
            $newfake->details=$oldlead->details;
            $newfake->title=$oldlead->title;
            $newfake->details=$oldlead->details; 
    
    		if($newfake->save()){ 
    		     $oldlead->hidden=2;
    		     $oldlead->close_date=$today;
    		     $oldlead->close=1;
    		     $oldlead->save();
    		     $newlead=new Leads();
    		     $newlead->user_id=$newfake->user_id;
    		     $newlead->date=$newfake->date;
    		     $newlead->time=$newfake->time;
    		     $newlead->dtime=$newfake->dtime;
    		     $newlead->strategy_id=1;
    		     $newlead->hidden=1;
    		     $newlead->title=$newfake->title;
    		     $newlead->international_code=$newfake->code;
    		     $newlead->tel=$newfake->tel;
    		     $newlead->fake_id=$newfake->lead_id;
    		     $newlead->details=$newfake->details;
    		     if($newlead->save()){
    		         $newlead->secert=$newlead->id;
    		         $newlead->save();
        		     $oldlead->fake_id=$newlead->id;
        		     $oldlead->save();
    		         
                 //var_dump($newlead->id);echo"!!<br>";
    		    }else{var_dump($newlead->getErrors());}
    		    
    		    
    		}else{var_dump($newfake->getErrors());}
		}
     
    
    
    }
    
    Yii::app()->controller->refresh();

}

if(isset($_POST['hiddenresult'])){
    
    
    $userid=Yii::app()->user->id;
$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
$today = date("Y-m-d");                     // 03.10.01
$time = date("H:i:s"); 
foreach($allleadss  as $lead){	





	$newmodel=new Activitieshidden();
		$newmodel->user_id = $userid;
		$newmodel->date = $today;
		$newmodel->time = $time;
		$newmodel->lead_id= $lead->id;
              

		if($newmodel->save()){
		    
		    
		   $lead= Leads::model()->findByAttributes(array('id'=>$newmodel->lead_id));
		   $lead->communication=NULL;
		   $lead->hiddenactivtiesdate=	$newmodel->date;
		   
		   $lead->save();
		   
		   $criteria = new CDbCriteria;
//$criteria->condition = "close IS NULL ";
$criteria->addCondition('leads_id=' . $lead->id);
$allactivities=Activities::model()->findAll($criteria);
if(!empty($allactivities)){
foreach($allactivities as $activity){
$activity->close=1;
$activity->hidden=1;
if(empty($activity->report)){
$activity->report='hidden In '.$today;
}

if(empty($activity->code)){
$rnd = rand(0,99999);
$activity->code=$rnd;
}
$activity->save();
}
}

		   
		   
		   
		   
		   

		    
		    $this->redirect(array('sales/profile','secert' => $newmodel->lead_id), false);
//$this->redirect(array('sales/manager')	);
		    
		    
		}




}
$this->redirect(array('salesmanger')	);	

}

			$criteriatransfer = new CDbCriteria();
			$criteriatransfer->order = 'id DESC';


			$criteriatransfer->addSearchCondition('id', $_REQUEST['search'],false, "AND");
			$criteriatransfer->addSearchCondition('fromm', $_REQUEST['user'],false, "AND");
			$criteriatransfer->addBetweenCondition("date",$_REQUEST['startdate'],$_REQUEST['enddate'],'AND');
			$allleadsstransfer = Transfer::model()->findAll($criteriatransfer);    



			$userid=Yii::app()->user->id;
			$user=User::model()->findByPk($userid);
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s"); 

			$visible = 1;
			$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
			$allstatues= Statues::model()->findAll();
			$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

 
			if(isset($_POST['downloadpdf'])){
 
				$mpdf= Yii::app()->ePdf->mpdf('ar-s');
				//$mpdf->autoLangToFont = false;
				//$mpdf->autoArabic = false;
				//$mpdf->charset_in='utf-8';

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	
				 
				$mpdf1 = new mPDF('s','A4','','',10,10,80,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('search Result-');
				$mpdf1->SetAuthor("Brandshtine.");
				//$mpdf1->SetWatermarkText("");
				//$mpdf1->showWatermarkText = true;
				//$mpdf1->watermark_font = 'DejaVuSansCondensed';
				//$mpdf1->watermarkTextAlpha = 0.1;
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'Search Result.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}

if(isset($_POST['downloadexcel'])){
				if(isset($_POST['data2'])){

					$allleads = $_POST['data2'];


					$allleadss= unserialize(base64_decode($allleads));


					foreach($allleadss as $data){
						$data->user_id = $data->employee->fname." ".$data->employee->lname;
						$data->user_sales = $data->sales->fname;
						$data->status= $data->statuesaction->title;
						
						
						
					}


					$fields = array('id','code','title','email','international_code','tel','user_id','date','user_sales','notes','communicate_date','status','sales_report','feedback_report');



					$labels = array('id','code','title','email','international_code','tel','user_id','date','user_sales','notes','communicate_date','status','sales_report','feedback_report');


					// downloadXls($filename, $data, $title = false, $header = false, $labels = false, $fields = false,$type = 'lines')

					XlsExporter2::downloadXls('report', $allleadss, 'Report-', TRUE  , $labels  , $fields, 'COUNT');


				}
				
				
			}
			
if(isset($_POST['downloadexcel'])){
    
    
	ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');


        
        $actual_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
        $total=count($allleadss);
        $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $exportxlxs = new Exportxlxs();
        $rnd = rand(0,99999);
        $exportxlxs->date=$today;
        $exportxlxs->time=$time;
        $exportxlxs->user_id=$user->id;
        $exportxlxs->total=$total;
        $exportxlxs->url=$actual_link;
        $exportxlxs->save();
        if(!$exportxlxs->save()){
        var_dump($exportxlxs->getErrors());
        }
        
        
        if($exportxlxs->save()){
       
            
            
            
               foreach($allleadss as $data){
                  // var_dump($data);exit;
$exportxlxsleads = new Exportxlxsleads();
$exportxlxsleads->exportxlx_id=$exportxlxs->id;
$exportxlxsleads->leads_id=$data->id;
$exportxlxsleads->save();
					
				}
            
            
            
        }
        
        
        
     

        
        //var_dump('11');exit;









			if(isset($_POST['sendmail'])){


				$userid=Yii::app()->user->id;
				$user=User::model()->findByPk($userid);



				$mpdf= Yii::app()->ePdf->mpdf('ar-s');
				//$mpdf->autoLangToFont = false;
				//$mpdf->autoArabic = false;
				//$mpdf->charset_in='utf-8';

		  


				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');

				$html = $this->renderPartial('_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,
						'user' => $user,'today' => $today,'time' => $time), true);

				$main=Mainsettings::model()->findByPk(1);		    
				$mpdf1 = new mPDF('s','A4','','',10,10,80,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">');






				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('search Result-');
				$mpdf1->SetAuthor("Brandshtine.");
				//$mpdf1->SetWatermarkText("");
				//$mpdf1->showWatermarkText = true;
				//$mpdf1->watermark_font = 'DejaVuSansCondensed';
				//$mpdf1->watermarkTextAlpha = 0.1;
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'Search Result.pdf';
				ob_end_clean();
				$att=$mpdf1->Output('','S' );








				$email_from = "solid@info.com"; // Who the email is from
				$email_subject = "Your attached file"; // The Subject of the email
				$email_to = $user->email; // Who the email is to


				$semi_rand = md5(time());
				$data = chunk_split(base64_encode($att));

				$fileatt_type = "application/pdf"; // File Type
				$mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";

				// set header ........................
				$headers = "From: ".$email_from;
				$headers .= "\nMIME-Version: 1.0\n" .
				"Content-Type: multipart/mixed;\n" .
				" boundary=\"{$mime_boundary}\"";

				// set email message......................
				$email_message = "";
				$email_message .= "There is your search Result.<br>";// Message that the email has in it
				$email_message .= "This is a multi-part message in MIME format.\n\n" .
				"--{$mime_boundary}\n" .
				"Content-Type:text/html; charset=\"iso-8859-1\"\n" .
				"Content-Transfer-Encoding: 7bit\n\n" .
				$email_message .= "\n\n";
				$email_message .= "--{$mime_boundary}\n" .
				"Content-Type: {$fileatt_type};\n" .
				" name=\"{$file_name}\"\n" .
				"Content-Disposition: attachment;\n" .
				" filename=\"{$file_name}\"\n" .
				"Content-Transfer-Encoding: base64\n\n" .
				$data .= "\n\n" .
				"--{$mime_boundary}--\n";

				$sent = @mail($email_to, $email_subject, $email_message, $headers);
				if($sent){
					$this->redirect(array('sales/manager')	);
				} else{
					die("Sorry but the email could not be sent. Please try again!");
				}






			}


















		//	$count=Leads::model()->count($criteria);

		//	$main=Mainsettings::model()->findByPk(1);
          //  if(empty($main->pagecount)){$pagecount=10;}else{$pagecount=$main->pagecount;}
		//	$dataProvider = new CActiveDataProvider('Leads', array(
				//	'pagination' => array(
				//		'pageSize' =>$pagecount,
				//	),
				//	'criteria' => $criteria,
			//	));
			//$allleads = Leads::model()->findAll($criteria);

					
		} 

if(isset($_POST['savesearch'])){
    
    


        
        $actual_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    //    var_dump($actual_link);exit;
        
        
        $savesearch = new Savesearch();
        $rnd = rand(0,99999);
        $savesearch->date=$today;
        $savesearch->time=$time;
        $savesearch->user_id=$user->id;
        $savesearch->title=$_POST['title'];
        $savesearch->url=$actual_link;
        $savesearch->save();
        if(!$savesearch->save()){
        var_dump($savesearch->getErrors());
        }
        
        
        if($savesearch->save()){
            
            
        }
  
					
		} 

		$visible = 1;
		$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
		$allstatues= Statues::model()->findAll();
		$allplace=Interestedplace::model()->findAll();
        $allleadssgv=new Leads('searchadmin');
        $allleadssgv->unsetAttributes();  // clear any default values
        if(isset($_GET['Leads'])){
        $allleadssgv->attributes=$_GET['Leads'];
        }
		$this->render('salesresult', array(
											
				'allleads' => $allleads,
				'allleadss' => $allleadss,
				'allleadssgv' => $allleadssgv,
				'allcampaign' => $allcampaign,
				'allproject' => $allproject,
				'allsales' => $allsales,
				'allstatues' => $allstatues,
				'count'=>$count,
				'dataProvider'=>$dataProvider, 
				'allplatform'=>$allplatform,
				'arrayofinfo'=>$arrayofinfo, 
				'allleadsstransfer'=>$allleadsstransfer,
				'allplace'=>$allplace, 
				'val'=>$val,  
				'serialized_array'=>$serialized_array, 
				


											
			));
			
			
	    	}
	    		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

			
	}
	}
	
	//Begin: Teamleader Search
	public function actionProcessbulktransfer() {
        $this->render('processbulktransfer');
    }
    public function actionAjaxbulkprocess()
{
    if (isset($_POST['checks']) && isset($_POST['salescheck'])) {
        $leadIds = $_POST['checks'];
        $newUserId = $_POST['salescheck'];
        $hide = $_POST['Hideee'];

        $today = date('Y-m-d');
        $time = date('H:i:s');
        $userid = Yii::app()->user->id;

        // Step 1: Get old sales for each lead (to use in transfer log)
        $criteria = new CDbCriteria();
        $criteria->addInCondition('id', $leadIds);
        $leads = Leads::model()->findAll($criteria);

        $fromSalesMap = []; // [lead_id => old_sales]
        foreach ($leads as $lead) {
            $fromSalesMap[$lead->id] = $lead->user_sales;
        }

        // Step 2: Bulk update leads
        Leads::model()->updateByPk($leadIds, [
            'user_sales' => $newUserId,
            'transferdate' => $today,
            'close' => null,
            'communication' => null,
            'transferuser' => $userid,
            'transfer' => 1,
            'transferreason' => 'Multi Transfer',
            'counttransfer' => new CDbExpression('counttransfer + 1'),
        ]);

        // Step 3: Bulk insert transfer logs
        $rows = [];
        foreach ($leadIds as $lead_id) {
            $rows[] = [
                'reason' => 'Multi Transfer',
                'user_id' => $userid,
                'lead_id' => $lead_id,
                'fromm' => $fromSalesMap[$lead_id],
                'too' => $newUserId,
                'hide' => $hide,
                'date' => $today,
                'time' => $time,
            ];
        }

        Yii::app()->db->schema->commandBuilder
            ->createMultipleInsertCommand(Transfer::model()->tableName(), $rows)
            ->execute();

        // Step 4: Optional – Update activities table if hide = 1
        if ($hide == 1) {
            Yii::app()->db->createCommand()
                ->update(
                    'activities',
                    ['close' => 1, 'hidden' => 1, 'too' => $newUserId],
                    ['in', 'leads_id', $leadIds]
                );

            // Update leads hidden activities fields
            Leads::model()->updateByPk($leadIds, [
                'hiddenactivtiesdate' => $today,
                'fakedate' => null,
                'fake' => null,
            ]);
        }

        Yii::app()->end(); // Stop execution and return empty 200 OK
    }

    throw new CHttpException(400, 'Invalid request');
}
    public function actionSearchsalesofleader(){
        if(Yii::app()->user->isMember()){
    	    $this->layout = '//layouts/systemcgridview';
    		$userid=Yii::app()->user->id;
    		$user=User::model()->findByPk($userid);
            $allleadssgv=new Leads('searchsalesofleader');
            $allleadssgv->unsetAttributes();
            if(isset($_GET['Leads'])){
                $allleadssgv->attributes=$_GET['Leads'];
            }
            if(isset($_REQUEST['search'])){
                $allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
                $arr=array();
                foreach($allemployee as $leader){
                    $arr[]=$leader->sales_id;
                } 
                $arrayofinfo=array(
                    'hidden'=>$_REQUEST['hidden'],
                    'fb_id'=>$_REQUEST['fb_id'],
                    'adsetname'=>$_REQUEST['adsetname'],
                    'adname'=>$_REQUEST['adname'],
                    'title'=>$_REQUEST['search'],
                    'tel'=>$_REQUEST['tel'],
                    'second_tel'=>$_REQUEST['secondtel'],
                    'campaign_id'=>$_REQUEST['campaign'],
                    'usersales'=>$_REQUEST['usersales'],
                    'exusersales'=>$_REQUEST['exusersales'],
                    'receipt'=>$_REQUEST['receipt'],
                    'communication'=>$_REQUEST['communication'],
                    'close'=>$_REQUEST['close'],
                    'duplicate'=>$_REQUEST['duplicate'],
                    'status'=>$_REQUEST['status'],
                    'platform'=>$_REQUEST['platform'],
                    'startdate'=>$_REQUEST['startdate'],
                    'enddate'=>$_REQUEST['enddate'],
                    'place'=>$_REQUEST['place'],
                    'team'=>$_REQUEST['team'],
                    'callcenter'=>$_REQUEST['callcenter']);
                $criteria = new CDbCriteria();
                $criteria->order = 'id DESC';
                $val=false;
    			if($_REQUEST['distributedteamleaders']!=1){
    				if(sizeOf((array)$_REQUEST['usersales'])>1){
    				$intArray5 = array_map(
    					function($value5){ return (int)$value5; },
    					$_REQUEST['usersales']
    				);
    				$criteria->addInCondition('user_sales', $intArray5  , "AND");
        			}else{
        			    $criteria->addInCondition('user_sales', $arr , "AND");
        			}
    			}
    			if(!empty($_REQUEST['search']) ){
    				$criteria->addSearchCondition('title', $_REQUEST['search'],TRUE, "AND");
    			}
                if($_REQUEST['answer']==1){
    				$criteria->addSearchCondition('answer', $_REQUEST['answer'],false, "AND");
        			}else if($_REQUEST['answer']==2){
        				$criteria->addSearchCondition('answer', $_REQUEST['answer'],false, "AND");
        			}else{ 
    			}
    			if($_REQUEST['transferx']==1){
    				$criteria->addSearchCondition('transfer', $_REQUEST['transferx'],false, "AND");
        			}else if($_REQUEST['transferx']==2){
        				$criteria->addCondition('transfer IS NULL');
        			}else{
    			}
    			if($_REQUEST['visit']==1){
    				$criteria->addSearchCondition('visit', $_REQUEST['visit'],false, "AND");
        			}else if($_REQUEST['visit']==2){
        				$criteria->addCondition('visit IS NULL');
        			}else{
    			}
                if($_REQUEST['eoi']==1){
                    $criteria->addSearchCondition('eoi', $_REQUEST['eoi'],false, "AND");
                    }else if($_REQUEST['eoi']==2){
                    $criteria->addCondition('eoi IS NULL');
                    }else{
                }
    			if(!empty($_REQUEST['team']) ){
    			    $allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $_REQUEST['team'] ,'order'=>'id DESC'  ));
                    $arr=array();
                    foreach($allemployee as $leader){
                        $arr[]=$leader->sales_id;
                    } 
    				$criteria->addInCondition('user_sales', $arr  , "AND");
    			}
    			if(sizeOf((array)$_REQUEST['project'])>1){
    				$intArray2p = array_map(
    					function($value2p){ return (int)$value2p; },
    					$_REQUEST['project']
    				);
    				$criteria->addInCondition('project_id', $intArray2p  , "AND");
    			}
    			if(sizeOf((array)$_REQUEST['unit_type'])>1){
    				$intArray223 = array_map(
    					function($value223){ return (int)$value223; },
    					$_REQUEST['unit_type']
    				);
    				$criteria->addInCondition('unit_type', $intArray223  , "AND");
    
    			}
    			if(sizeOf((array)$_REQUEST['teamdistributed'])>1){
                    $val=true;
                    $intArrayteamdistributed = array_map(
                        function($valueteamdistributed){ return (int)$valueteamdistributed; },
                        $_REQUEST['teamdistributed']
                    );
                    $criteria->addInCondition('user_integration', $intArrayteamdistributed , "AND");
                }
    			if(sizeOf((array)$_REQUEST['fresh'])>1){
                    $val=true;
                    $intArrayfresh = array_map(
    					function($valuefresh){ return (int)$valuefresh; },
    					$_REQUEST['fresh']
    				);
    				$criteria->addInCondition('fresh_sales', $intArrayfresh , "AND");
    			    }else{ 
    			}
    			if($_REQUEST['leadstate']==1){
                    $criteria->addCondition (" nonqualified IS  NULL ");
    			    $criteria->addSearchCondition('qualified', 1 ,false, "AND");
    			}else if($_REQUEST['leadstate']==2){
                    $criteria->addSearchCondition(' nonqualified', 1 , false);
    				$criteria->addCondition(' qualified IS NULL');
    			}else if($_REQUEST['leadstate']==3){
                    $criteria->addCondition ( " qualified IS  NULL AND nonqualified IS  NULL ") ;
    			}else if($_REQUEST['leadstate']==4){
                    $criteria->addSearchCondition(' nonqualified', 1, false,'AND');
                    $criteria->addSearchCondition(' qualified', 1, false,'AND');
    			}else if($_REQUEST['leadstate']==5){
    			     $criteria->addSearchCondition('first_classification', 1, false,'AND');
                    $criteria->addSearchCondition('nonqualified', 1, false,'AND');
                    $criteria->addSearchCondition('qualified', 1, false,'AND');
    			}else if($_REQUEST['leadstate']==6){
    			     $criteria->addSearchCondition('first_classification', 2, false,'AND');
                    $criteria->addSearchCondition('nonqualified', 1, false,'AND');
                    $criteria->addSearchCondition('qualified', 1, false,'AND');
    			}else{
    			}
    			if($_REQUEST['client_id']==1 ){
    				$criteria->addSearchCondition('client_id', 1 ,false, "AND");
    			}elseif($_REQUEST['client_id']==2){
                    $criteria->addCondition ( "client_id IS  NULL ");
    			}
                if(!empty($_REQUEST['fb_id']) ){
    				$criteria->addSearchCondition('facebook_id', $_REQUEST['fb_id'],TRUE, "AND");
    			}
                if(!empty($_REQUEST['adsetname']) ){
    				$criteria->addSearchCondition('adsetname', $_REQUEST['adsetname'],TRUE, "AND");
    			}
                if(!empty($_REQUEST['adname']) ){
    				$criteria->addSearchCondition('adname', $_REQUEST['adname'],TRUE, "AND");
    			}
                if(!empty($_REQUEST['code']) ){
                $_REQUEST['startdate']="2008-6-30";
                $_REQUEST['enddate']=date("Y-m-d");
    				$criteria->addSearchCondition('id', $_REQUEST['code'],false, "AND");
    			}
                if(!empty($_REQUEST['tel2']) ){
                $_REQUEST['startdate']="2008-6-30";
                $_REQUEST['enddate']=date("Y-m-d");
                $phone= $_REQUEST['tel2'];
                if($phone[0]=='0')
                $phone = substr($phone , 1);
                $countrys = [
    				'44' => 'UK (+44)',
    				'213' => 'Algeria (+213)',
    				'376' => 'Andorra (+376)',
    				'244' => 'Angola (+244)',
    				'1264' => 'Anguilla (+1264)',
    				'1268' => 'Antigua & Barbuda (+1268)',
    				'54' => 'Argentina (+54)',
    				'374' => 'Armenia (+374)',
    				'297' => 'Aruba (+297)',
    				'61' => 'Australia (+61)',
    				'43' => 'Austria (+43)',
    				'994' => 'Azerbaijan (+994)',
    				'1242' => 'Bahamas (+1242)',
    				'973' => 'Bahrain (+973)',
    				'880' => 'Bangladesh (+880)',
    				'1246' => 'Barbados (+1246)',
    				'375' => 'Belarus (+375)',
    				'32' => 'Belgium (+32)',
    				'501' => 'Belize (+501)',
    				'229' => 'Benin (+229)',
    				'1441' => 'Bermuda (+1441)',
    				'975' => 'Bhutan (+975)',
    				'591' => 'Bolivia (+591)',
    				'387' => 'Bosnia Herzegovina (+387)',
    				'267' => 'Botswana (+267)',
    				'55' => 'Brazil (+55)',
    				'673' => 'Brunei (+673)',
    				'359' => 'Bulgaria (+359)',
    				'226' => 'Burkina Faso (+226)',
    				'257' => 'Burundi (+257)',
    				'855' => 'Cambodia (+855)',
    				'237' => 'Cameroon (+237)',
    				'238' => 'Cape Verde Islands (+238)',
    				'1345' => 'Cayman Islands (+1345)',
    				'236' => 'Central African Republic (+236)',
    				'56' => 'Chile (+56)',
    				'86' => 'China (+86)',
    				'57' => 'Colombia (+57)',
    				'269' => 'Comoros (+269)',
    				'242' => 'Congo (+242)',
    				'682' => 'Cook Islands (+682)',
    				'506' => 'Costa Rica (+506)',
    				'225' => 'Cote d Ivoire (+225)',
    				'385' => 'Croatia (+385)',
    				'53' => 'Cuba (+53)',
    				'90392' => 'Cyprus North (+90392)',
    				'357' => 'Cyprus South (+357)',
    				'420' => 'Czech Republic (+420)',
    				'45' => 'Denmark (+45)',
    				'253' => 'Djibouti (+253)',
    				'1809' => 'Dominica (+1809)',
    				'1809' => 'Dominican Republic (+1809)',
    				'593' => 'Ecuador (+593)',
    				'20' => 'Egypt (+20)',
    				'503' => 'El Salvador (+503)',
    				'240' => 'Equatorial Guinea (+240)',
    				'291' => 'Eritrea (+291)',
    				'372' => 'Estonia (+372)',
    				'251' => 'Ethiopia (+251)',
    				'500' => 'Falkland Islands (+500)',
    				'298' => 'Faroe Islands (+298)',
    				'679' => 'Fiji (+679)',
    				'358' => 'Finland (+358)',
    				'33' => 'France (+33)',
    				'594' => 'French Guiana (+594)',
    				'689' => 'French Polynesia (+689)',
    				'241' => 'Gabon (+241)',
    				'220' => 'Gambia (+220)',
    				'995' => 'Georgia (+995)',
    				'49' => 'Germany (+49)',
    				'233' => 'Ghana (+233)',
    				'350' => 'Gibraltar (+350)',
    				'30' => 'Greece (+30)',
    				'299' => 'Greenland (+299)',
    				'1473' => 'Grenada (+1473)',
    				'590' => 'Guadeloupe (+590)',
    				'671' => 'Guam (+671)',
    				'502' => 'Guatemala (+502)',
    				'224' => 'Guinea (+224)',
    				'245' => 'Guinea - Bissau (+245)',
    				'592' => 'Guyana (+592)',
    				'509' => 'Haiti (+509)',
    				'504' => 'Honduras (+504)',
    				'852' => 'Hong Kong (+852)',
    				'36' => 'Hungary (+36)',
    				'354' => 'Iceland (+354)',
    				'91' => 'India (+91)',
    				'62' => 'Indonesia (+62)',
    				'98' => 'Iran (+98)',
    				'964' => 'Iraq (+964)',
    				'353' => 'Ireland (+353)',
    				'39' => 'Italy (+39)',
    				'972' => 'Israel (+972)',
    				'1876' => 'Jamaica (+1876)',
    				'81' => 'Japan (+81)',
    				'962' => 'Jordan (+962)',
    				'7' => 'Kazakhstan (+7)',
    				'254' => 'Kenya (+254)',
    				'686' => 'Kiribati (+686)',
    				'850' => 'Korea North (+850)',
    				'82' => 'Korea South (+82)',
    				'965' => 'Kuwait (+965)',
    				'996' => 'Kyrgyzstan (+996)',
    				'856' => 'Laos (+856)',
    				'371' => 'Latvia (+371)',
    				'961' => 'Lebanon (+961)',
    				'266' => 'Lesotho (+266)',
    				'231' => 'Liberia (+231)',
    				'218' => 'Libya (+218)',
    				'417' => 'Liechtenstein (+417)',
    				'370' => 'Lithuania (+370)',
    				'352' => 'Luxembourg (+352)',
    				'853' => 'Macao (+853)',
    				'389' => 'Macedonia (+389)',
    				'261' => 'Madagascar (+261)',
    				'265' => 'Malawi (+265)',
    				'60' => 'Malaysia (+60)',
    				'960' => 'Maldives (+960)',
    				'223' => 'Mali (+223)',
    				'356' => 'Malta (+356)',
    				'692' => 'Marshall Islands (+692)',
    				'596' => 'Martinique (+596)',
    				'222' => 'Mauritania (+222)',
    				'269' => 'Mayotte (+269)',
    				'52' => 'Mexico (+52)',
    				'691' => 'Micronesia (+691)',
    				'373' => 'Moldova (+373)',
    				'377' => 'Monaco (+377)',
    				'976' => 'Mongolia (+976)',
    				'1664' => 'Montserrat (+1664)',
    				'212' => 'Morocco (+212)',
    				'258' => 'Mozambique (+258)',
    				'95' => 'Myanmar (+95)',
    				'264' => 'Namibia (+264)',
    				'674' => 'Nauru (+674)',
    				'977' => 'Nepal (+977)',
    				'31' => 'Netherlands (+31)',
    				'687' => 'New Caledonia (+687)',
    				'64' => 'New Zealand (+64)',
    				'505' => 'Nicaragua (+505)',
    				'227' => 'Niger (+227)',
    				'234' => 'Nigeria (+234)',
    				'683' => 'Niue (+683)',
    				'672' => 'Norfolk Islands (+672)',
    				'670' => 'Northern Marianas (+670)',
    				'47' => 'Norway (+47)',
    				'968' => 'Oman (+968)',
    				'680' => 'Palau (+680)',
    				'970' => 'Palestine (+970)',
    				'507' => 'Panama (+507)',
    				'675' => 'Papua New Guinea (+675)',
    				'595' => 'Paraguay (+595)',
    				'51' => 'Peru (+51)',
    				'63' => 'Philippines (+63)',
    				'48' => 'Poland (+48)',
    				'351' => 'Portugal (+351)',
    				'1787' => 'Puerto Rico (+1787)',
    				'974' => 'Qatar (+974)',
    				'262' => 'Reunion (+262)',
    				'40' => 'Romania (+40)',
    				'7' => 'Russia (+7)',
    				'250' => 'Rwanda (+250)',
    				'378' => 'San Marino (+378)',
    				'239' => 'Sao Tome & Principe (+239)',
    				'966' => 'Saudi Arabia (+966)',
    				'221' => 'Senegal (+221)',
    				'381' => 'Serbia (+381)',
    				'248' => 'Seychelles (+248)',
    				'232' => 'Sierra Leone (+232)',
    				'65' => 'Singapore (+65)',
    				'421' => 'Slovak Republic (+421)',
    				'386' => 'Slovenia (+386)',
    				'677' => 'Solomon Islands (+677)',
    				'252' => 'Somalia (+252)',
    				'27' => 'South Africa (+27)',
    				'34' => 'Spain (+34)',
    				'94' => 'Sri Lanka (+94)',
    				'290' => 'St. Helena (+290)',
    				'1869' => 'St. Kitts (+1869)',
    				'1758' => 'St. Lucia (+1758)',
    				'249' => 'Sudan (+249)',
    				'211' => 'South Sudan (+211)',
    				'597' => 'Suriname (+597)',
    				'268' => 'Swaziland (+268)',
    				'46' => 'Sweden (+46)',
    				'41' => 'Switzerland (+41)',
    				'963' => 'Syria (+963)',
    				'886' => 'Taiwan (+886)',
    				'7' => 'Tajikstan (+7)',
    				'66' => 'Thailand (+66)',
    				'228' => 'Togo (+228)',
    				'676' => 'Tonga (+676)',
    				'1868' => 'Trinidad & Tobago (+1868)',
    				'216' => 'Tunisia (+216)',
    				'90' => 'Turkey (+90)',
    				'7' => 'Turkmenistan (+7)',
    				'993' => 'Turkmenistan (+993)',
    				'1649' => 'Turks & Caicos Islands (+1649)',
    				'688' => 'Tuvalu (+688)',
    				'256' => 'Uganda (+256)',
    				'380' => 'Ukraine (+380)',
    				'971' => 'United Arab Emirates (+971)',
    				'598' => 'Uruguay (+598)',
    				'7' => 'Uzbekistan (+7)',
    				'678' => 'Vanuatu (+678)',
    				'379' => 'Vatican City (+379)',
    				'58' => 'Venezuela (+58)',
    				'84' => 'Vietnam (+84)',
    				'84' => 'Virgin Islands - British (+1284)',
    				'84' => 'Virgin Islands - US (+1340)',
    				'681' => 'Wallis & Futuna (+681)',
    				'969' => 'Yemen (North)(+969)',
    				'967' => 'Yemen (South)(+967)',
    				'260' => 'Zambia (+260)',
    				'263' => 'Zimbabwe (+263)',
    			];
    			$temp=  substr(strstr($phone, '+'),1);
    		    if($temp != false){$phone=$temp;}
                $countrycode='';
    			krsort($countrys, SORT_NUMERIC);
    			// iterate over all countries
    			foreach($countrys as $we => $ccode){
    				// if number begins with current number
    				if(strpos($phone, '' . $we) === 0){
    					// store country code and break the loop
    					$countrycode = $we;
    					break;
    				}
    			}
    			if(!empty($countrycode)){
        				$size=strlen($countrycode);
        				$phone=substr($phone,$size);
        			}
    				$criteria->addSearchCondition('tel', $phone ,TRUE, "or");
    				$criteria->addSearchCondition('second_tel', $phone ,TRUE, "or");
    			}
                if(!empty($_REQUEST['tel']) ){
                $phone= $_REQUEST['tel'];
                if($phone[0]=='0')
                $phone = substr($phone , 1);
                $countrys = [
    				'44' => 'UK (+44)',
    				'213' => 'Algeria (+213)',
    				'376' => 'Andorra (+376)',
    				'244' => 'Angola (+244)',
    				'1264' => 'Anguilla (+1264)',
    				'1268' => 'Antigua & Barbuda (+1268)',
    				'54' => 'Argentina (+54)',
    				'374' => 'Armenia (+374)',
    				'297' => 'Aruba (+297)',
    				'61' => 'Australia (+61)',
    				'43' => 'Austria (+43)',
    				'994' => 'Azerbaijan (+994)',
    				'1242' => 'Bahamas (+1242)',
    				'973' => 'Bahrain (+973)',
    				'880' => 'Bangladesh (+880)',
    				'1246' => 'Barbados (+1246)',
    				'375' => 'Belarus (+375)',
    				'32' => 'Belgium (+32)',
    				'501' => 'Belize (+501)',
    				'229' => 'Benin (+229)',
    				'1441' => 'Bermuda (+1441)',
    				'975' => 'Bhutan (+975)',
    				'591' => 'Bolivia (+591)',
    				'387' => 'Bosnia Herzegovina (+387)',
    				'267' => 'Botswana (+267)',
    				'55' => 'Brazil (+55)',
    				'673' => 'Brunei (+673)',
    				'359' => 'Bulgaria (+359)',
    				'226' => 'Burkina Faso (+226)',
    				'257' => 'Burundi (+257)',
    				'855' => 'Cambodia (+855)',
    				'237' => 'Cameroon (+237)',
    				'238' => 'Cape Verde Islands (+238)',
    				'1345' => 'Cayman Islands (+1345)',
    				'236' => 'Central African Republic (+236)',
    				'56' => 'Chile (+56)',
    				'86' => 'China (+86)',
    				'57' => 'Colombia (+57)',
    				'269' => 'Comoros (+269)',
    				'242' => 'Congo (+242)',
    				'682' => 'Cook Islands (+682)',
    				'506' => 'Costa Rica (+506)',
    				'225' => 'Cote d Ivoire (+225)',
    				'385' => 'Croatia (+385)',
    				'53' => 'Cuba (+53)',
    				'90392' => 'Cyprus North (+90392)',
    				'357' => 'Cyprus South (+357)',
    				'420' => 'Czech Republic (+420)',
    				'45' => 'Denmark (+45)',
    				'253' => 'Djibouti (+253)',
    				'1809' => 'Dominica (+1809)',
    				'1809' => 'Dominican Republic (+1809)',
    				'593' => 'Ecuador (+593)',
    				'20' => 'Egypt (+20)',
    				'503' => 'El Salvador (+503)',
    				'240' => 'Equatorial Guinea (+240)',
    				'291' => 'Eritrea (+291)',
    				'372' => 'Estonia (+372)',
    				'251' => 'Ethiopia (+251)',
    				'500' => 'Falkland Islands (+500)',
    				'298' => 'Faroe Islands (+298)',
    				'679' => 'Fiji (+679)',
    				'358' => 'Finland (+358)',
    				'33' => 'France (+33)',
    				'594' => 'French Guiana (+594)',
    				'689' => 'French Polynesia (+689)',
    				'241' => 'Gabon (+241)',
    				'220' => 'Gambia (+220)',
    				'995' => 'Georgia (+995)',
    				'49' => 'Germany (+49)',
    				'233' => 'Ghana (+233)',
    				'350' => 'Gibraltar (+350)',
    				'30' => 'Greece (+30)',
    				'299' => 'Greenland (+299)',
    				'1473' => 'Grenada (+1473)',
    				'590' => 'Guadeloupe (+590)',
    				'671' => 'Guam (+671)',
    				'502' => 'Guatemala (+502)',
    				'224' => 'Guinea (+224)',
    				'245' => 'Guinea - Bissau (+245)',
    				'592' => 'Guyana (+592)',
    				'509' => 'Haiti (+509)',
    				'504' => 'Honduras (+504)',
    				'852' => 'Hong Kong (+852)',
    				'36' => 'Hungary (+36)',
    				'354' => 'Iceland (+354)',
    				'91' => 'India (+91)',
    				'62' => 'Indonesia (+62)',
    				'98' => 'Iran (+98)',
    				'964' => 'Iraq (+964)',
    				'353' => 'Ireland (+353)',
    				'39' => 'Italy (+39)',
    				'972' => 'Israel (+972)',
    				'1876' => 'Jamaica (+1876)',
    				'81' => 'Japan (+81)',
    				'962' => 'Jordan (+962)',
    				'7' => 'Kazakhstan (+7)',
    				'254' => 'Kenya (+254)',
    				'686' => 'Kiribati (+686)',
    				'850' => 'Korea North (+850)',
    				'82' => 'Korea South (+82)',
    				'965' => 'Kuwait (+965)',
    				'996' => 'Kyrgyzstan (+996)',
    				'856' => 'Laos (+856)',
    				'371' => 'Latvia (+371)',
    				'961' => 'Lebanon (+961)',
    				'266' => 'Lesotho (+266)',
    				'231' => 'Liberia (+231)',
    				'218' => 'Libya (+218)',
    				'417' => 'Liechtenstein (+417)',
    				'370' => 'Lithuania (+370)',
    				'352' => 'Luxembourg (+352)',
    				'853' => 'Macao (+853)',
    				'389' => 'Macedonia (+389)',
    				'261' => 'Madagascar (+261)',
    				'265' => 'Malawi (+265)',
    				'60' => 'Malaysia (+60)',
    				'960' => 'Maldives (+960)',
    				'223' => 'Mali (+223)',
    				'356' => 'Malta (+356)',
    				'692' => 'Marshall Islands (+692)',
    				'596' => 'Martinique (+596)',
    				'222' => 'Mauritania (+222)',
    				'269' => 'Mayotte (+269)',
    				'52' => 'Mexico (+52)',
    				'691' => 'Micronesia (+691)',
    				'373' => 'Moldova (+373)',
    				'377' => 'Monaco (+377)',
    				'976' => 'Mongolia (+976)',
    				'1664' => 'Montserrat (+1664)',
    				'212' => 'Morocco (+212)',
    				'258' => 'Mozambique (+258)',
    				'95' => 'Myanmar (+95)',
    				'264' => 'Namibia (+264)',
    				'674' => 'Nauru (+674)',
    				'977' => 'Nepal (+977)',
    				'31' => 'Netherlands (+31)',
    				'687' => 'New Caledonia (+687)',
    				'64' => 'New Zealand (+64)',
    				'505' => 'Nicaragua (+505)',
    				'227' => 'Niger (+227)',
    				'234' => 'Nigeria (+234)',
    				'683' => 'Niue (+683)',
    				'672' => 'Norfolk Islands (+672)',
    				'670' => 'Northern Marianas (+670)',
    				'47' => 'Norway (+47)',
    				'968' => 'Oman (+968)',
    				'680' => 'Palau (+680)',
    				'970' => 'Palestine (+970)',
    				'507' => 'Panama (+507)',
    				'675' => 'Papua New Guinea (+675)',
    				'595' => 'Paraguay (+595)',
    				'51' => 'Peru (+51)',
    				'63' => 'Philippines (+63)',
    				'48' => 'Poland (+48)',
    				'351' => 'Portugal (+351)',
    				'1787' => 'Puerto Rico (+1787)',
    				'974' => 'Qatar (+974)',
    				'262' => 'Reunion (+262)',
    				'40' => 'Romania (+40)',
    				'7' => 'Russia (+7)',
    				'250' => 'Rwanda (+250)',
    				'378' => 'San Marino (+378)',
    				'239' => 'Sao Tome & Principe (+239)',
    				'966' => 'Saudi Arabia (+966)',
    				'221' => 'Senegal (+221)',
    				'381' => 'Serbia (+381)',
    				'248' => 'Seychelles (+248)',
    				'232' => 'Sierra Leone (+232)',
    				'65' => 'Singapore (+65)',
    				'421' => 'Slovak Republic (+421)',
    				'386' => 'Slovenia (+386)',
    				'677' => 'Solomon Islands (+677)',
    				'252' => 'Somalia (+252)',
    				'27' => 'South Africa (+27)',
    				'34' => 'Spain (+34)',
    				'94' => 'Sri Lanka (+94)',
    				'290' => 'St. Helena (+290)',
    				'1869' => 'St. Kitts (+1869)',
    				'1758' => 'St. Lucia (+1758)',
    				'249' => 'Sudan (+249)',
    				'211' => 'South Sudan (+211)',
    				'597' => 'Suriname (+597)',
    				'268' => 'Swaziland (+268)',
    				'46' => 'Sweden (+46)',
    				'41' => 'Switzerland (+41)',
    				'963' => 'Syria (+963)',
    				'886' => 'Taiwan (+886)',
    				'7' => 'Tajikstan (+7)',
    				'66' => 'Thailand (+66)',
    				'228' => 'Togo (+228)',
    				'676' => 'Tonga (+676)',
    				'1868' => 'Trinidad & Tobago (+1868)',
    				'216' => 'Tunisia (+216)',
    				'90' => 'Turkey (+90)',
    				'7' => 'Turkmenistan (+7)',
    				'993' => 'Turkmenistan (+993)',
    				'1649' => 'Turks & Caicos Islands (+1649)',
    				'688' => 'Tuvalu (+688)',
    				'256' => 'Uganda (+256)',
    				'380' => 'Ukraine (+380)',
    				'971' => 'United Arab Emirates (+971)',
    				'598' => 'Uruguay (+598)',
    				'7' => 'Uzbekistan (+7)',
    				'678' => 'Vanuatu (+678)',
    				'379' => 'Vatican City (+379)',
    				'58' => 'Venezuela (+58)',
    				'84' => 'Vietnam (+84)',
    				'84' => 'Virgin Islands - British (+1284)',
    				'84' => 'Virgin Islands - US (+1340)',
    				'681' => 'Wallis & Futuna (+681)',
    				'969' => 'Yemen (North)(+969)',
    				'967' => 'Yemen (South)(+967)',
    				'260' => 'Zambia (+260)',
    				'263' => 'Zimbabwe (+263)',
    			];
    			$temp=  substr(strstr($phone, '+'),1);
    		    if($temp != false){$phone=$temp;}
                $countrycode='';
    			// sort the array by key, descending
    			krsort($countrys, SORT_NUMERIC);
    
    			// iterate over all countries
    			foreach($countrys as $we => $ccode){
    				// if number begins with current number
    				if(strpos($phone, '' . $we) === 0){
    					// store country code and break the loop
    					$countrycode = $we;
    					break;
    				}
    			}
    			if(!empty($countrycode)){
    				$size=strlen($countrycode);
    				$phone=substr($phone,$size);
    			}
    				$criteria->addSearchCondition('tel', $phone ,TRUE, "or");
    				$criteria->addSearchCondition('second_tel', $phone ,TRUE, "or");
    			}
                if(!empty($_REQUEST['secondtel']) ){
    				$criteria->addSearchCondition('second_tel', $_REQUEST['secondtel'],false, "AND");
    			}
                if(!empty($_REQUEST['internationalcode']) ){
    				$criteria->addSearchCondition('international_code', $_REQUEST['internationalcode'],false, "AND");
    			}	
                if(!empty($_REQUEST['internationalcode2']) ){
    				$criteria->addSearchCondition('international_code2', $_REQUEST['internationalcode2'],false, "AND");
    			}		
                if($_REQUEST['cold']==1){
                    $criteria->addCondition('coldcall IS NOT NULL');
                }else if($_REQUEST['cold']==2){
                    $criteria->addCondition('coldcall IS NULL');
                }
    			if($_REQUEST['communication']==1){
                    $criteria->addSearchCondition('communication', $_REQUEST['communication'],false, "AND");
    			}else if($_REQUEST['communication']==2){
    				$criteria->addCondition('communication IS NULL');
    			}else{
    			}
    			if($_REQUEST['receipt']==1){
    			    $criteria->addSearchCondition('receipt', $_REQUEST['receipt'],false, "AND");
    		    }else if($_REQUEST['receipt']==2){
    			    $criteria->addCondition('receipt IS NULL');
    		    }else{
    			}
    			if($_REQUEST['close']==1){
    			$criteria->addSearchCondition('close', $_REQUEST['close'],false, "AND");
    			}else if($_REQUEST['close']==2){
    				$criteria->addCondition('close IS NULL');
    			}else{
    			}
    			if($_REQUEST['reopen']==1){
    				$criteria->addSearchCondition('reopen', $_REQUEST['reopen'],false, "AND");
    			}else if($_REQUEST['reopen']==2){
                    $criteria->addCondition('reopen IS NULL');
    			}else{
    		    }	
                if($_REQUEST['ccode']==1){
        			$criteria->addSearchCondition('international_code', 20 ,false, "AND");
        		}else if($_REQUEST['ccode']==2){
        	        $criteria->addNotInCondition('international_code', array(20));
        		}else{}
        		if(!empty($_REQUEST['hidden']) ){
        			$criteria->addSearchCondition('hidden', $_REQUEST['hidden'],false, "AND");
        		}
        		if(sizeOf((array)$_REQUEST['platform'])>1){
        			$intArray = array_map(
        				function($value){ return (int)$value; },
        				$_REQUEST['platform']
        			);
        			$criteria->addInCondition('platform_id', $intArray  , "AND");
        		}
        		if(sizeOf((array)$_REQUEST['platformchild'])>1){
        			$intArray = array_map(
        				function($value){ return (int)$value; },
        				$_REQUEST['platformchild']
        			);
        			$criteria->addInCondition('platformchild_id', $intArray  , "AND");
        		}
			    if (!empty($_REQUEST['place']) && is_array($_REQUEST['place'])) {
                    $intArrayPlace = array_map('intval', $_REQUEST['place']);
                    $criteria->addInCondition('interest_id', $intArrayPlace, "AND");
                }
        		if(sizeOf((array)$_REQUEST['callcenter'])>1){
        			$intArray3 = array_map(
        				function($value3){ return (int)$value3; },
        				$_REQUEST['callcenter']
        			);
        			$criteria->addInCondition('user_id', $intArray3  , "AND");
        		}
        		if(sizeOf((array)$_REQUEST['campaign'])>1){
                    $intArray4 = array_map(
        				function($value4){ return (int)$value4; },
        				$_REQUEST['campaign']
        			);
                    unset($intArray4[0]);
        			$criteria->addInCondition('campaign_id', $intArray4 , "AND");
        		}
        		if(sizeOf((array)$_REQUEST['status'])>1){
                    $val=true;
        		    if($_REQUEST['status'][1]!=0){
                    $intArraystatus = array_map(
        				function($value6){ return (int)$value6; },
        				$_REQUEST['status']
        			);
        			 $criteria->addInCondition('status', $intArraystatus , "AND");
        		    }else{
        			$criteria->addCondition('status IS NULL');
        		    }
        	 	}
        		if(sizeOf((array)$_REQUEST['substatus'])>1){
                    $val=true;
                    $intArraysubstatus = array_map(
        				function($intArraysubstatus){ return (int)$intArraysubstatus; },
        				$_REQUEST['substatus']
        			);
        			$criteria->addInCondition('substatus', $intArraysubstatus , "AND");
        		}
                //search for Brokers in view company 31/3/2019 7:25
                if(!empty($user->company_id) AND empty($user->broker) ){  
                      $allcampaign=Campaign::model()->findAll(array('condition'=>'company_id='.$user->company_id));
                    foreach($allcampaign as $leader){
                		$arr[]=$leader->id ;
                	} 
                    $criteria->addInCondition('campaign_id', $arr);
                } 
                // END OF search for Brokers in view company ahmed said dont do thing here but its organised as you see
        		if(!empty($_REQUEST['startdate']) ){
        			$criteria->addBetweenCondition("date",$_REQUEST['startdate'],$_REQUEST['enddate'],'AND');
        		}
        		if(!empty($_REQUEST['startfollowdate']) ){
                    $criteria->addBetweenCondition("follow_date",$_REQUEST['startfollowdate'],$_REQUEST['endfollowdate'],'AND');
                    $criteria->addCondition('close IS NULL');
                    $criteria->addCondition('communication IS NOT NULL');
            	}	
        		if(!empty($_REQUEST['starttransferedate']) ){
        			$criteria->addBetweenCondition("transferdate",$_REQUEST['starttransferedate'],$_REQUEST['endtransferedate'],'AND');
        		}
        	    if(!empty($_REQUEST['startsysdate']) ){
        			$criteria->addBetweenCondition("sysdate",$_REQUEST['startsysdate'],$_REQUEST['endsysdate'],'AND');
        		}
                if(!empty($_REQUEST['transfer']) ){
                        $transferstatus=1;
                        $criteria->addSearchCondition('transfer', $transferstatus,false, "AND");
                        $criteria->addBetweenCondition("transferdate",$_REQUEST['starttransferdate'],$_REQUEST['endtransferdate'],'AND');
                    }
                    
                   
if (!empty($_REQUEST['exptransfer']) && $_REQUEST['exptransfer'] == 1 && 
    (empty($_REQUEST['expstarttransferedate']) || empty($_REQUEST['expendtransferedate']))) {

    // فقط استبعاد تاريخ النهاردة
    $criteria->addCondition("(transferdate != '$today' OR transferdate IS NULL)", 'AND');

} elseif (!empty($_REQUEST['expstarttransferedate']) && !empty($_REQUEST['expendtransferedate']) &&
          empty($_REQUEST['exptransfer'])) {

    // فقط استبعاد فترة
    $start = $_REQUEST['expstarttransferedate'];
    $end = $_REQUEST['expendtransferedate'];
    $criteria->addCondition("(transferdate IS NULL OR transferdate < '$start' OR transferdate > '$end')", 'AND');

} elseif (!empty($_REQUEST['exptransfer']) && $_REQUEST['exptransfer'] == 1 &&
          !empty($_REQUEST['expstarttransferedate']) && !empty($_REQUEST['expendtransferedate'])) {

    // استبعاد تاريخ النهاردة + استبعاد فترة
    $start = $_REQUEST['expstarttransferedate'];
    $end = $_REQUEST['expendtransferedate'];
    $criteria->addCondition("(
        (transferdate != '$today' OR transferdate IS NULL)
        AND
        (transferdate IS NULL OR transferdate < '$start' OR transferdate > '$end')
    )", 'AND');
}
                if(sizeOf((array)$_REQUEST['ids'])>1){
        				$intArray = array_map(
        					function($value){ return (int)$value; },
        					$_REQUEST['ids']
        				);
        				$criteria->addInCondition('id', $intArray  , "AND");
        		}	
        		if(sizeOf((array)$_REQUEST['teamdistributed'])>1){
                    $val=true;
                    $intArrayteamdistributed = array_map(
                    function($valueteamdistributed){ return (int)$valueteamdistributed; },
                    $_REQUEST['teamdistributed']
                    );
                    $criteria->addInCondition('user_integration', $intArrayteamdistributed , "AND");
                }
        		if($_REQUEST['distributedteamleaders']==1){
        		    $criteria->addCondition('user_integration IS NOT NULL && user_sales IS  NULL');
        		}else{}
        		
        		
        		
        		
                $allleadss = Leads::model()->findAll($criteria);    
                $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
                $today = date("Y-m-d");
                $time = date("H:i:s");  
                //Begin: Bulk Random Transfer Teamleader
                if (isset($_POST['Leads']) && isset($_POST['number'])) {
                    // 1) مدخلات + تنظيف
                    $salesIdsRaw = (array)$_POST['Leads'];   // الوجهات (too)
                    $numbersRaw  = (array)$_POST['number'];  // الكميات المطلوبة لكل وجهة
                    $hide        = isset($_POST['Hideee']) ? (int)$_POST['Hideee'] : 0;
                    $salesIds = array();
                    foreach ($salesIdsRaw as $v) { $v = (int)$v; if ($v > 0) $salesIds[] = $v; }
                    $numbers = array();
                    foreach ($numbersRaw as $n) { $n = (int)$n; if ($n > 0) $numbers[] = $n; }
                    $pairCount = min(count($salesIds), count($numbers));
                    if ($pairCount === 0) {
                        Yii::app()->user->setFlash('danger', 'No sales/count pairs provided.');
                        Yii::app()->controller->refresh(); Yii::app()->end();
                    }
                    // 2) DB + WHERE من نفس فلاتر الجدول
                    $db        = Yii::app()->db;
                    $chunkSize = 1000;
                    $reason    = 'Multi Transfer';
                    if (!isset($criteria)) { $criteria = new CDbCriteria(); } // أمان
                    $where       = '1=1';
                    $paramsWhere = array();
                    if (!empty($criteria->condition)) {
                        $where       = '(' . $criteria->condition . ')';
                        $paramsWhere = !empty($criteria->params) ? $criteria->params : array();
                    }
                    // (اختياري) تحقّق سريع أن فيه Leads كفاية للفلاتر الحالية
                    $requestedTotal = array_sum($numbers);
                    $availableTotal = (int)$db->createCommand("SELECT COUNT(*) FROM leads l WHERE {$where}")
                                              ->queryScalar($paramsWhere);
                    if ($availableTotal <= 0) {
                        Yii::app()->user->setFlash('warning', 'No eligible leads for current filters.');
                        Yii::app()->controller->refresh(); Yii::app()->end();
                    }
                    // هنستبعد اللي اتاخدوا داخل نفس POST بس (توزيع عادل بين كل السيلز)
                    $usedIds = array();
                    // 3) تنفيذ لكل زوج (وجهة/عدد)
                    for ($i = 0; $i < $pairCount; $i++) {
                        $salesId = (int)$salesIds[$i];   // destination
                        $take    = (int)$numbers[$i];
                        if ($salesId <= 0 || $take <= 0) continue;
                
                        // رأس العملية (transferaction)
                        $ta = new Transferaction();
                        $ta->user_id  = $userid;
                        $ta->date     = $today;
                        $ta->time     = $time;
                        $ta->sales    = $salesId;
                        $ta->total    = $take;       // المطلوب
                        $ta->accepted = 0;
                        $ta->rejected = 0;
                        $ta->details  = NULL;
                        $ta->save(false);
                        $taId = (int)$ta->id;
                        // بناء استبعاد لما تم اختياره في نفس الطلب
                        $excludeSql    = '';
                        $excludeParams = array();
                        if (!empty($usedIds)) {
                            $phs = array();
                            foreach ($usedIds as $j => $lid) {
                                $ph = ":ex{$j}";
                                $phs[] = $ph;
                                $excludeParams[$ph] = (int)$lid;
                            }
                            $excludeSql = ' AND l.id NOT IN (' . implode(',', $phs) . ')';
                        }
                        // اختيار IDs للدفعة الحالية
                        $pickSql = "
                            SELECT l.id
                            FROM leads l
                            WHERE {$where} {$excludeSql}
                            ORDER BY l.id ASC
                            LIMIT {$take}
                        ";
                        $pickParams = $paramsWhere;
                        foreach ($excludeParams as $k => $v) { $pickParams[$k] = $v; }
                        $pickedIds = $db->createCommand($pickSql)->queryColumn($pickParams);
                        if (!$pickedIds) {
                            // مفيش مرشحين — العملية اترفضت بالكامل
                            $db->createCommand("
                                UPDATE transferaction
                                SET rejected = total, accepted = 0
                                WHERE id = :i
                            ")->execute(array(':i' => $taId));
                            continue;
                        }
                        // ضيف IDs المختارة لقائمة الاستبعاد عشان المرات الجاية في نفس POST
                        foreach ($pickedIds as $lid) { $usedIds[] = (int)$lid; }
                        // إدراج (staging) في transfer بصفوف جديدة دائمًا — done = NULL
                        $acceptedThisAction = 0;
                        foreach (array_chunk($pickedIds, $chunkSize) as $batch) {
                            $tx = $db->beginTransaction();
                            try {
                                $inPlaceholders = array();
                                $par = array(
                                    ':reason' => $reason,
                                    ':uid'    => $userid,
                                    ':too'    => $salesId,
                                    ':datee'  => $today,
                                    ':timee'  => $time,
                                    ':hide'   => $hide,
                                    ':ta'     => $taId,
                                );
                                foreach ($batch as $k => $lid) {
                                    $ph = ":L{$k}";
                                    $inPlaceholders[] = $ph;
                                    $par[$ph] = (int)$lid;
                                }
                
                                $insertSql = "
                                    INSERT INTO transfer
                                      (reason,user_id,lead_id,fromm,too,date,time,hide,hideteamleader,fakenewlead,transferaction_id,done)
                                    SELECT :reason,:uid,l.id,l.user_sales,:too,:datee,:timee,:hide,NULL,NULL,:ta, NULL
                                    FROM leads l
                                    WHERE l.id IN (" . implode(',', $inPlaceholders) . ")
                                ";
                                $inserted = (int)$db->createCommand($insertSql)->execute($par);
                                $acceptedThisAction += $inserted;
                
                                if ($inserted > 0) {
                                    $db->createCommand("
                                        UPDATE transferaction
                                        SET accepted = accepted + :n
                                        WHERE id = :i
                                    ")->execute(array(':n' => $inserted, ':i' => $taId));
                                }
                
                                $tx->commit();
                            } catch (Exception $e) {
                                if ($tx->active) $tx->rollback();
                                $db->createCommand("
                                    UPDATE transferaction
                                    SET details = CONCAT(IFNULL(details,''),'[ERR] ', :msg)
                                    WHERE id = :i
                                ")->execute(array(':msg' => substr($e->getMessage(), 0, 300), ':i' => $taId));
                                Yii::log('TL multi-assign insert failed: ' . $e->getMessage(), CLogger::LEVEL_ERROR);
                            }
                        }
                        // rejected = requested - accepted
                        $db->createCommand("
                            UPDATE transferaction
                            SET rejected = GREATEST(total - accepted, 0)
                            WHERE id = :i
                        ")->execute(array(':i' => $taId));
                        // (اختياري) لو قبل صفر — دوّن سبب
                        if ($acceptedThisAction === 0) {
                            $db->createCommand("
                                UPDATE transferaction
                                SET details = CONCAT(IFNULL(details,''),'[EMPTY] no candidates after exclude; take=', :t, '; used=', :u, ';')
                                WHERE id = :i
                            ")->execute(array(':t' => $take, ':u' => count($usedIds), ':i' => $taId));
                        }
                    }
                    Yii::app()->controller->refresh();
                }
                // End: Bulk Random Transfer Teamleader
                if(isset($_POST['closeallresult'])){
                    foreach ($allleadss as $lead) {
                        $lead->close = 1;
                        $lead->close_date = $today;
                        $lead->checkup_activity = $today;
                        $lead->communication = 1;
                    
                        if (empty($lead->first_communication)) {
                            $lead->first_communication = $userid;
                        }
                    
                        if ($lead->save()) {
                            $leadsId = $lead->id;
                            
                            // SQL query for updating activities
                            $sql = "UPDATE activities SET close = 1, report = :report WHERE close IS NULL AND leads_id = :leadsId";
                    
                            $command = Yii::app()->db->createCommand($sql);
                            $command->bindParam(':report', $_POST['closeallresult'] . '-Closed BY ADMIN ' . $today, PDO::PARAM_STR);
                            $command->bindParam(':leadsId', $leadsId, PDO::PARAM_INT);
                    
                            $command->execute();
                        }
                    }
                    $this->redirect(array('salesmanger'));			
                }
            	$criteriatransfer = new CDbCriteria();
            	$criteriatransfer->order = 'id DESC';
            	$criteriatransfer->addSearchCondition('id', $_REQUEST['search'],false, "AND");
            	$criteriatransfer->addSearchCondition('fromm', $_REQUEST['user'],false, "AND");
            	$criteriatransfer->addBetweenCondition("date",$_REQUEST['startdate'],$_REQUEST['enddate'],'AND');
            	$allleadsstransfer = Transfer::model()->findAll($criteriatransfer);    
            	$userid=Yii::app()->user->id;
            	$user=User::model()->findByPk($userid);
            	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
            	$today = date("Y-m-d");                     // 03.10.01
            	$time = date("H:i:s"); 
            	$visible = 1;
            	$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
            	$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
            	$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
            	$allstatues= Statues::model()->findAll();
            	$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
            	if(isset($_POST['downloadpdf'])){
            		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
            		ini_set('max_execution_time', 300);
            		ini_set('memory_limit', '-1');
            		$html = $this->renderPartial('_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,'user' => $user,'today' => $today,'time' => $time), true);
            		$main=Mainsettings::model()->findByPk(1);	    
            		$mpdf1 = new mPDF('s','A4','','',10,10,80,35,10,10);
            		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
            		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
            		$mpdf1->SetProtection(array('print'));
            		$mpdf1->SetTitle('search Result-');
            		$mpdf1->SetAuthor("Brandshtine.");
            		$mpdf1->SetDisplayMode('fullpage');
            		$mpdf1->SetAutoFont('4');		  
            		$mpdf1->WriteHTML($html);
            		$file_name= 'Search Result.pdf';
            		ob_end_clean();
            		$mpdf1->Output($file_name,'I' );
            	}
            
                if(isset($_POST['downloadexcel'])){
                	ini_set('max_execution_time', 300);
                	ini_set('memory_limit', '-1');
                    $actual_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
                    $total=count($allleadss);
                    $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
                    $today = date("Y-m-d");                     // 03.10.01
                    $time = date("H:i:s");                      // 17:16:18	
                    $exportxlxs = new Exportxlxs();
                    $rnd = rand(0,99999);
                    $exportxlxs->date=$today;
                    $exportxlxs->time=$time;
                    $exportxlxs->user_id=$user->id;
                    $exportxlxs->total=$total;
                    $exportxlxs->url=$actual_link;
                    $exportxlxs->save();
                    if(!$exportxlxs->save()){
                        var_dump($exportxlxs->getErrors());
                    }
                    if($exportxlxs->save()){
                        foreach($allleadss as $data){
                            $exportxlxsleads = new Exportxlxsleads();
                            $exportxlxsleads->exportxlx_id=$exportxlxs->id;
                            $exportxlxsleads->leads_id=$data->id;
                            $exportxlxsleads->save();			
                		}    
                    }				
                }
            	
            	if(isset($_POST['sendmail'])){
            		$userid=Yii::app()->user->id;
            		$user=User::model()->findByPk($userid);
            		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
            		ini_set('max_execution_time', 300);
            		ini_set('memory_limit', '-1');
            		$html = $this->renderPartial('_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => $allsales,'allstatues' => $allstatues,'user' => $user,'today' => $today,'time' => $time), true);
            		$main=Mainsettings::model()->findByPk(1);		    
            		$mpdf1 = new mPDF('s','A4','','',10,10,80,35,10,10);
            		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
            		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">');
            		$mpdf1->SetProtection(array('print'));
            		$mpdf1->SetTitle('search Result-');
            		$mpdf1->SetAuthor("Brandshtine.");
            		$mpdf1->SetDisplayMode('fullpage');
            		$mpdf1->SetAutoFont('4');		  
            		$mpdf1->WriteHTML($html);
            		$file_name= 'Search Result.pdf';
            		ob_end_clean();
            		$att=$mpdf1->Output('','S' );
            		$email_from = "info@soliderp.com"; // Who the email is from
            		$email_subject = "Your attached file"; // The Subject of the email
            		$email_to = $user->email; // Who the email is to
            		$semi_rand = md5(time());
            		$data = chunk_split(base64_encode($att));
            		$fileatt_type = "application/pdf"; // File Type
            		$mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";
            		// set header
            		$headers = "From: ".$email_from;
            		$headers .= "\nMIME-Version: 1.0\n" .
            		"Content-Type: multipart/mixed;\n" .
            		" boundary=\"{$mime_boundary}\"";
            		// set email message
            		$email_message = "";
            		$email_message .= "There is your search Result.<br>";// Message that the email has in it
            		$email_message .= "This is a multi-part message in MIME format.\n\n" .
            		"--{$mime_boundary}\n" .
            		"Content-Type:text/html; charset=\"iso-8859-1\"\n" .
            		"Content-Transfer-Encoding: 7bit\n\n" .
            		$email_message .= "\n\n";
            		$email_message .= "--{$mime_boundary}\n" .
            		"Content-Type: {$fileatt_type};\n" .
            		" name=\"{$file_name}\"\n" .
            		"Content-Disposition: attachment;\n" .
            		" filename=\"{$file_name}\"\n" .
            		"Content-Transfer-Encoding: base64\n\n" .
            		$data .= "\n\n" .
            		"--{$mime_boundary}--\n";
            		$sent = @mail($email_to, $email_subject, $email_message, $headers);
            		if($sent){
            			$this->redirect(array('sales/manager')	);
            		} else{
            			die("Sorry but the email could not be sent. Please try again!");
            		}
            	}
            	$count=Leads::model()->count($criteria);
            	$dataProvider = new CActiveDataProvider('Leads', array(
            		'pagination' => array(
            			'pageSize' =>50,
            		),
            		'criteria' => $criteria,
            	));
            	$allleads = Leads::model()->findAll($criteria);		
            }
            $arrayofids=array();
        //Begin: Selected Transfer
if (isset($_POST['checks']) AND isset($_POST['salescheck'])) {
    $hide = $_POST['Hideee'];

    // ✅ تعديل هنا فقط لاستخدام SQL_NO_CACHE بدون تغيير هيكل الكود
    $ids = $_POST['checks'];
    $idPlaceholders = implode(',', array_fill(0, count($ids), '?'));
    $sql = "SELECT SQL_NO_CACHE * FROM leads WHERE id IN ($idPlaceholders)";
    $allleadsss = Leads::model()->findAllBySql($sql, $ids);

    foreach ($allleadsss as $lead) {
        $oldsales = $lead->user_sales;
        $lead->user_sales = $_POST['salescheck']; 
        $lead->transferdate = $today;
        $lead->close = NULL;
        $lead->communication = NULL;
        $lead->transferuser = $userid;
        $lead->transfer = 1;

        if ($hide == 1) {
            $lead->hiddenactivtiesdate = $today;
            $lead->transferfrom = $transfer->fromm;
            $lead->transferuser = $transfer->user_id;
            $lead->fakedate = NULL;
            $lead->fake = NULL;
            $lead->save();

            if ($lead->save()) {
                Yii::app()->db->createCommand()
                    ->update(
                        'activities',
                        array('close' => 1, 'hidden' => 1, 'too' => $transfer->too),
                        'leads_id = :lead_id',
                        array(':lead_id' => $lead->id)
                    );
            }
        }

        $lead->counttransfer = $lead->counttransfer + 1;
        $treason = "Multi Transfer";
        $lead->transferreason = $treason;

        if ($lead->save()) {
            $transfer = new Transfer();
            $transfer->reason = $treason;
            $transfer->user_id = $userid;
            $transfer->lead_id = $lead->id;
            $transfer->fromm = $oldsales;
            $transfer->too = $lead->user_sales;
            $transfer->hide = $hide;
            $transfer->date = $today;
            $transfer->time = $time;

            if ($transfer->save()) {
                $act = new CDbCriteria;
                $act->condition = "close IS NULL ";
                $act->addCondition('leads_id=' . $transfer->lead_id);
                $allactivitiesact = Activities::model()->findAll($act);

                if (!empty($allactivitiesact)) {
                    foreach ($allactivitiesact as $activitiesact) {
                        $activitiesact->too = $transfer->too;
                        $activitiesact->save();
                    }
                }
            }
        }
    }

    Yii::app()->controller->refresh();
}
//End: Selected Transfer
        	$visible = 1;
        	$allcampaign = Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
        	$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
        	$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
        	$allstatues= Statues::model()->findAll();
        	$this->render('salesresultofleader', array(
        		'allleads' => $allleads,
        		'allleadss' => $allleadss,
        		'allcampaign' => $allcampaign,
        		'allproject' => $allproject,
        		'allsales' => $allsales,
        		'allstatues' => $allstatues,
        		'count'=>$count,
        		'dataProvider'=>$dataProvider,   
        		'allleadssgv'=>$allleadssgv,  	
        	));
        }else{
    		$model=new LoginForm;
    		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
    			echo CActiveForm::validate($model);
    			Yii::app()->end();
    		}
    		if(isset($_POST['LoginForm'])){
    			$model->attributes=$_POST['LoginForm'];
    			if($model->validate() && $model->login())
    			$this->redirect(array('home/index')	);
    		}
    		$this->redirect(array('home/index')	);
    	}
    }
	//End: Teamleader Search
	
    public function actionSearchactivities(){
	    
	    

	if(Yii::app()->user->isMember()){
$this->layout = '//layouts/systemcgridview';

	    
		if(isset($_REQUEST['search'])){



			$criteria = new CDbCriteria();
			$criteria->order = 'follow_date  DESC';
            $criteria->addCondition('broker_id IS NULL');
			
			if(!empty($_REQUEST['search']) ){
				$criteria->addSearchCondition('report', $_REQUEST['search'],TRUE, "AND");
			}
			
			
			
				
			if($_REQUEST['cold']==1){

				$criteria->addSearchCondition('coldcall', $_REQUEST['cold'],false, "AND");
			}else if($_REQUEST['cold']==2){



				$criteria->addCondition('coldcall IS NULL');
			}else{
			}
			
			if($_REQUEST['indirect']==1){


				$criteria->addSearchCondition('indirect', $_REQUEST['indirect'],false, "AND");
			}else if($_REQUEST['indirect']==2){



				$criteria->addCondition('indirect IS NULL');
			}else{
			}
			
			

if(!empty($_REQUEST['conf'])){
if($_REQUEST['conf'] == 1){
$criteria->addSearchCondition('confirm', $_REQUEST['conf'],false, "AND");
$criteria->addSearchCondition('details', $_REQUEST['search'],TRUE, "AND");


}



if($_REQUEST['conf'] == 2){
$criteria->condition = "confirm IS NULL ";
$criteria->addSearchCondition('details', $_REQUEST['search'],TRUE, "AND");



}




}




		
if(!empty($_REQUEST['report'])){
    
if($_REQUEST['report'] == 1){
$criteria->addSearchCondition('close', $_REQUEST['report'],false, "AND");
$criteria->addSearchCondition('details', $_REQUEST['search'],TRUE, "AND");
$close=1;

}  


if($_REQUEST['report'] == 2){
$criteria->addCondition(" close IS NULL ");
$criteria->addSearchCondition('details', $_REQUEST['search'],TRUE, "AND");
$close=2;

}  

    
}

if($_REQUEST['answer']==1){
				$criteria->addSearchCondition('answer', $_REQUEST['answer'],false, "AND");
			}else if($_REQUEST['answer']==2){
				$criteria->addSearchCondition('answer', $_REQUEST['answer'],false, "AND");
			}else{
			}
			
			
			
			
if($_REQUEST['star']==1){
				$criteria->addSearchCondition('star', $_REQUEST['star'],false, "AND");
			}else if($_REQUEST['star']==2){
				$criteria->addSearchCondition('star', $_REQUEST['star'],false, "AND");
			}else{
			}			

			


//$criteria->addBetweenCondition("date",$_REQUEST['startdate'],$_REQUEST['enddate'],'AND');


if(!empty($_REQUEST['userr'])){
if($_REQUEST['userr'] != 'None'){
$criteria->addSearchCondition('user_id', $_REQUEST['userr'],false, "AND");
}else{
    
$userid=Yii::app()->user->id;
$allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
$arr=array();
foreach($allemployee as $leader){
$arr[]=$leader->sales_id;
}     
$criteria->addInCondition('user_id', $arr);
    

}
}



if(!empty($_REQUEST['man'])){
 //   $criteria->addSearchCondition('user_id', $_REQUEST['man'], false, "AND");
    $criteria->addSearchCondition('manger_id', $_REQUEST['man'], false, "AND");
}


if(!empty($_REQUEST['status'])){
$criteria->addSearchCondition('status', $_REQUEST['status'],false, "AND");}


if(!empty($_REQUEST['substatus'])){
$criteria->addSearchCondition('substatus', $_REQUEST['substatus'],false, "AND");}
			
if(!empty($_REQUEST['type'])){
$criteria->addSearchCondition('type', $_REQUEST['type'],false, "AND");}




if(!empty($_REQUEST['startdateleads'])){
$criteria->addBetweenCondition("lead_date",$_REQUEST['startdateleads'],$_REQUEST['enddateleads'],'AND');
}


if(!empty($_REQUEST['startdate'])){
$criteria->addBetweenCondition("date",$_REQUEST['startdate'],$_REQUEST['enddate'],'AND');
}


if(!empty($_REQUEST['startfollowdate'])){
    
$startfollow=$_REQUEST['startfollowdate'];
$endfollow=$_REQUEST['endfollowdate'];
$criteria->addBetweenCondition("follow_date",$_REQUEST['startfollowdate'],$_REQUEST['endfollowdate'],'AND');
}



      
$allactivities2 = Activities::model()->findAll($criteria);

			$count= Activities::model()->count($criteria);
			$pages=new CPagination($count);
    
			$pages->pageSize=50;
			$pages->applyLimit($criteria);
            

			$allactivities = Activities::model()->findAll($criteria);
            
            $arrayleads=array();
            foreach($allactivities2 as $act){
                $arrayleads[]=$act->leads_id;
            }
            
            $leads=array_unique($arrayleads);
            
            
													$local = new CDbCriteria();
													$local->addInCondition('id', $leads );  
													$countlocal = Leads::model()->count($local);
													//var_dump($countlocal);exit;
													


					
		} 
		
		
		
		
		
		
		
		
				
			
if(isset($_POST['downloadexcel'])){
    







			$criteria2 = new CDbCriteria();
			$criteria2->order = 'follow_date  DESC';
			

if(!empty($_REQUEST['conf'])){
if($_REQUEST['conf'] == 1){
$criteria2->addSearchCondition('confirm', $_REQUEST['conf'],false, "AND");
$criteria2->addSearchCondition('details', $_REQUEST['search'],TRUE, "AND");


}



if($_REQUEST['conf'] == 2){
$criteria2->condition = "confirm IS NULL ";
$criteria2->addSearchCondition('details', $_REQUEST['search'],TRUE, "AND");



}




}




		
if(!empty($_REQUEST['report'])){
    
if($_REQUEST['report'] == 1){
$criteria2->addSearchCondition('close', $_REQUEST['report'],false, "AND");
$criteria2->addSearchCondition('details', $_REQUEST['search'],TRUE, "AND");

}  


if($_REQUEST['report'] == 2){
$criteria2->condition = "close IS NULL ";
$criteria2->addSearchCondition('details', $_REQUEST['search'],TRUE, "AND");


}  

    
}



if($_REQUEST['answer']==1){
				$criteria2->addSearchCondition('answer', $_REQUEST['answer'],false, "AND");
			}else if($_REQUEST['answer']==2){
				$criteria2->addSearchCondition('answer', $_REQUEST['answer'],false, "AND");
			}else{
			}


			


//$criteria->addBetweenCondition("date",$_REQUEST['startdate'],$_REQUEST['enddate'],'AND');


if(!empty($_REQUEST['userr'])){
$criteria2->addSearchCondition('user_id', $_REQUEST['userr'],false, "AND");}

if(!empty($_REQUEST['status'])){
$criteria2->addSearchCondition('status', $_REQUEST['status'],false, "AND");}
			
if(!empty($_REQUEST['type'])){
$criteria2->addSearchCondition('type', $_REQUEST['type'],false, "AND");}



if(!empty($_REQUEST['startdateleads'])){
$criteria2->addBetweenCondition("lead_date",$_REQUEST['startdateleads'],$_REQUEST['enddateleads'],'AND');
}


if(!empty($_REQUEST['startdate'])){
$criteria2->addBetweenCondition("date",$_REQUEST['startdate'],$_REQUEST['enddate'],'AND');
}


if(!empty($_REQUEST['startfollowdate'])){
$criteria2->addBetweenCondition("follow_date",$_REQUEST['startfollowdate'],$_REQUEST['endfollowdate'],'AND');
}




$allactivitiesex = Activities::model()->findAll($criteria2);    

	foreach($allactivitiesex as $data){
					$data->user_id = $data->employee->fname." ".$data->employee->lname;
					$data->leads_id = $data->client->title;
					$data->tel = $data->client->tel;
					
				 $main=Mainsettings::model()->findByPk(1);
                    $suser=User::model()->findByPk($userid);
                    
                    if($main->exportxlxs == 1){
                    if($suser->hiddenxlxs != 1){    
                        
                    $faketel='*********';
                    //$data->tel= $data->client->id;
                    //$data->tel= $data->client->id;
                     $data->tel=$data->client->id; 
                    }
                    }
				
					$data->status= $data->statuesaction->title;
					$data->substatus= $data->substatusaction->title;
					if($data->confirm == 1 ){
					    $success='sucess';
					    $data->confirm= $success;

					}elseif ($data->confirm == 3 ){
					  
					  
					   $failure='failure';
					$data->confirm= $failure;  
					 
					}
					
					
					
					if($data->answer == 1 ){
					    $answer='Yes';
					    $data->answer= $answer;

					}elseif ($data->answer == 2 ){
					  
					  
					   $notanswer='No ';
					$data->answer= $notanswer;  
					 
					}

				
					
				}






$fields = array('leads_id','tel','date','lead_date','time','user_id','details','follow_date','type','status','substatus','report' ,'sucess','answer');
$labels= array('leads_id','tel','date','lead_date','time','user_id','details','follow_date','type','status','substatus','report' ,'confirm','answer');
XlsExporter2::downloadXls('SOLID Activities XLS', $allactivitiesex, 'Report-', TRUE  , $labels  , $fields, 'COUNT');


		


}		
		
		
		

		$this->render('activitiesresult', array(
											
				'allactivities' => $allactivities,
				'leads' => $leads,
				'countlocal' => $countlocal,
				'count'=>$count,
				'pages'=>$pages,
				'startfollow'=>$startfollow,
				'endfollow'=>$endfollow,
				'close'=>$close,
				

											
			));
			

}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}			
			
	}











// answer search from sales manger 31/3/2019  4:30
public function actionSearchquistions(){
    


	if(Yii::app()->user->isMember()){
    
    
	if(isset($_REQUEST['startdate'])){


		$criteria = new CDbCriteria();
		$criteria->order = 'date  DESC';
		$criteria->addBetweenCondition("date",$_REQUEST['startdate'],$_REQUEST['enddate'],'AND');



                $arr=array();
		if(isset($_REQUEST['Results'])){
			foreach((array)$_REQUEST['Results'] as $num){	
				//$criteria->addSearchCondition('answer_id', $num[0] ,false, "OR");
                                $arr[]=(int)$num;
			}
                     $criteria->addInCondition('answer_id', $arr);
		}
		$count= Results::model()->count($criteria);
		$pages=new CPagination($count);
    
		$pages->pageSize=50;
		$pages->applyLimit($criteria);
            

		$allactivities = Results::model()->findAll($criteria);

		


					
	} 
		

	$this->render('answerresult', array(
											
			'allactivities' => $allactivities,
			'count'=>$count,
			'pages'=>$pages,     

											
		));
		
	
}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}	
}














// answer search from sales manger 31/3/2019  4:30
public function actionLeadhidden(){
	if(Yii::app()->user->isMember()){    
    
    
	if(isset($_REQUEST['leadhiddenx'])){

$userid=Yii::app()->user->id;
$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
$today = date("Y-m-d");                     // 03.10.01
$time = date("H:i:s"); 




	$newmodel=new Activitieshidden();
		$newmodel->user_id = $userid;
		$newmodel->date = $today;
		$newmodel->time = $time;
		$newmodel->lead_id= $_REQUEST['leadhiddenx'];
              //var_dump($newmodel->getErrors());
              //var_dump($_REQUEST['leadhiddenx']);

		if($newmodel->save()){
		    
		    
		   $lead= Leads::model()->findByAttributes(array('id'=>$newmodel->lead_id));
		   $lead->communication=NULL;
		   $lead->hiddenactivtiesdate=	$newmodel->date;
		   
		   $lead->save();
		   
		   $criteria = new CDbCriteria;
//$criteria->condition = "close IS NULL ";
$criteria->addCondition('leads_id=' . $lead->id);
$allactivities=Activities::model()->findAll($criteria);
if(!empty($allactivities)){
foreach($allactivities as $activity){
$activity->close=1;
$activity->hidden=1;
if(empty($activity->report)){
$activity->report='hidden In '.$today;
}

if(empty($activity->code)){
$rnd = rand(0,99999);
$activity->code=$rnd;
}
$activity->save();
}
}

		   
		   
		   
		   
		   

		    
		    $this->redirect(array('sales/profile','secert' => $newmodel->lead_id), false);
//$this->redirect(array('sales/manager')	);
		    
		    
		}



    
		


					
	} 
	
	}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}	
		

}









public function actionFakeactivities(){
    

	if(Yii::app()->user->isMember()){    
	if(isset($_REQUEST['leadfake'])){

$userid=Yii::app()->user->id;
$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
$today = date("Y-m-d");                     // 03.10.01
$time = date("H:i:s"); 

 
		$oldleadid= $_REQUEST['leadfake']; 
		$oldlead= Leads::model()->findByAttributes(array('id'=>$oldleadid));
		if(!empty($oldlead)){
            $criteria = new CDbCriteria; 
            $criteria->addCondition('leads_id=' . $oldlead->id);
            $allactivities=Activities::model()->findAll($criteria);
            if(!empty($allactivities)){
                foreach($allactivities as $activity){
                $activity->close=1;
                $activity->hidden=1;
                    if(empty($activity->report)){
                        $activity->report='Fake Lead In '.$today;
                    }
                    $activity->save();
                }
            }
            
            
            $newfake=new FakeLead();
            $newfake->user_id=$userid;
            $newfake->date=$today;
            $newfake->time=$time;
            $newfake->lead_id=$oldlead->id;
            $newfake->code=$oldlead->international_code;
            $newfake->tel=$oldlead->tel;
            $newfake->details=$oldlead->details;
            $newfake->title=$oldlead->title;
            $newfake->details=$oldlead->details; 
    
    		if($newfake->save()){ 
    		     $oldlead->delete();
    		     $newlead=new Leads();
    		     $newlead->user_id=$newfake->user_id;
    		     $newlead->date=$newfake->date;
    		     $newlead->time=$newfake->time;
    		     $newlead->dtime=$newfake->dtime;
    		     $newlead->strategy_id=1;
    		     $newlead->hidden=1;
    		     $newlead->title=$newfake->title;
    		     $newlead->international_code=$newfake->code;
    		     $newlead->tel=$newfake->tel;
    		     $newlead->fake_id=$newfake->lead_id;
    		     $newlead->details=$newfake->details;
    		     if($newlead->save()){
    		         $newlead->secert=$newlead->id;
    		         $newlead->save();
    		        $this->redirect(array('sales/profile','secert' => $newlead->id), false);
    		    }else{var_dump($newlead->getErrors());}
    		    
    		    
    		}else{var_dump($newfake->getErrors());}
		}else{
            $this->redirect(array('sales/manager')	);
		}


    
		


					
	} 
	
	}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}	
		
		

}











	public function actionSearchleadid(){
		Yii::app()->user->setState('searchlead', $_GET['Search']);
		$this->redirect(array('searchlead'));
	}
	
	
	
	
	
		public function actionMarketingleadid(){
		Yii::app()->user->setState('marketinglead', $_GET['Search']);
		$this->redirect(array('marketinglead'));
	}





	public function actionSearchlead(){
	
	
$this->layout = '//layouts/systemcgridview';
	if(Yii::app()->user->isMember()){    
	    
	$userid=Yii::app()->user->id;

		if(empty($_GET['Search']) && Yii::app()->user->hasState('searchlead'))
		$_GET['Search'] = Yii::app()->user->getState('searchlead');

		if(isset($_GET['Search'])){

//var_dump($_GET['cold']);exit;



			$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
			$criteria->addSearchCondition('user_sales', $userid ,false, "AND");

			$criteria->addCondition('close IS NULL');
			
			

			
			if(!empty($_GET['Search']['title']))
			$criteria->addSearchCondition('title', $_GET['Search']['title'],TRUE, "AND");

			if(!empty($_GET['Search']['international_code']))
			$criteria->addSearchCondition('international_code', $_GET['Search']['international_code'],false, "AND"); 
			
			if(!empty($_GET['Search']['tel'])){


$phone= $_GET['Search']['tel'];
if($phone[0]=='0')
    $phone = substr($phone , 1);
$countrys = [
							'44' => 'UK (+44)',
							'213' => 'Algeria (+213)',
							'376' => 'Andorra (+376)',
							'244' => 'Angola (+244)',
							'1264' => 'Anguilla (+1264)',
							'1268' => 'Antigua & Barbuda (+1268)',
							'54' => 'Argentina (+54)',
							'374' => 'Armenia (+374)',
							'297' => 'Aruba (+297)',
							'61' => 'Australia (+61)',
							'43' => 'Austria (+43)',
							'994' => 'Azerbaijan (+994)',
							'1242' => 'Bahamas (+1242)',
							'973' => 'Bahrain (+973)',
							'880' => 'Bangladesh (+880)',
							'1246' => 'Barbados (+1246)',
							'375' => 'Belarus (+375)',
							'32' => 'Belgium (+32)',
							'501' => 'Belize (+501)',
							'229' => 'Benin (+229)',
							'1441' => 'Bermuda (+1441)',
							'975' => 'Bhutan (+975)',
							'591' => 'Bolivia (+591)',
							'387' => 'Bosnia Herzegovina (+387)',
							'267' => 'Botswana (+267)',
							'55' => 'Brazil (+55)',
							'673' => 'Brunei (+673)',
							'359' => 'Bulgaria (+359)',
							'226' => 'Burkina Faso (+226)',
							'257' => 'Burundi (+257)',
							'855' => 'Cambodia (+855)',
							'237' => 'Cameroon (+237)',
							'238' => 'Cape Verde Islands (+238)',
							'1345' => 'Cayman Islands (+1345)',
							'236' => 'Central African Republic (+236)',
							'56' => 'Chile (+56)',
							'86' => 'China (+86)',
							'57' => 'Colombia (+57)',
							'269' => 'Comoros (+269)',
							'242' => 'Congo (+242)',
							'682' => 'Cook Islands (+682)',
							'506' => 'Costa Rica (+506)','225' => 'Cote d Ivoire (+225)',
							'385' => 'Croatia (+385)',
							'53' => 'Cuba (+53)',
							'90392' => 'Cyprus North (+90392)',
							'357' => 'Cyprus South (+357)',
							'420' => 'Czech Republic (+420)',
							'45' => 'Denmark (+45)',
							'253' => 'Djibouti (+253)',
							'1809' => 'Dominica (+1809)',
							'1809' => 'Dominican Republic (+1809)',
							'593' => 'Ecuador (+593)',
							'20' => 'Egypt (+20)',
							'503' => 'El Salvador (+503)',
							'240' => 'Equatorial Guinea (+240)',
							'291' => 'Eritrea (+291)',
							'372' => 'Estonia (+372)',
							'251' => 'Ethiopia (+251)',
							'500' => 'Falkland Islands (+500)',
							'298' => 'Faroe Islands (+298)',
							'679' => 'Fiji (+679)',
							'358' => 'Finland (+358)',
							'33' => 'France (+33)',
							'594' => 'French Guiana (+594)',
							'689' => 'French Polynesia (+689)',
							'241' => 'Gabon (+241)',
							'220' => 'Gambia (+220)',
							'995' => 'Georgia (+995)',
							'49' => 'Germany (+49)',
							'233' => 'Ghana (+233)',
							'350' => 'Gibraltar (+350)',
							'30' => 'Greece (+30)',
							'299' => 'Greenland (+299)',
							'1473' => 'Grenada (+1473)',
							'590' => 'Guadeloupe (+590)',
							'671' => 'Guam (+671)',
							'502' => 'Guatemala (+502)',
							'224' => 'Guinea (+224)',
							'245' => 'Guinea - Bissau (+245)',
							'592' => 'Guyana (+592)',
							'509' => 'Haiti (+509)',
							'504' => 'Honduras (+504)',
							'852' => 'Hong Kong (+852)',
							'36' => 'Hungary (+36)',
							'354' => 'Iceland (+354)',
							'91' => 'India (+91)',
							'62' => 'Indonesia (+62)',
							'98' => 'Iran (+98)',
							'964' => 'Iraq (+964)',
							'353' => 'Ireland (+353)',
							'39' => 'Italy (+39)','972' => 'Israel (+972)',
							'1876' => 'Jamaica (+1876)',
							'81' => 'Japan (+81)',
							'962' => 'Jordan (+962)',
							'7' => 'Kazakhstan (+7)',
							'254' => 'Kenya (+254)',
							'686' => 'Kiribati (+686)',
							'850' => 'Korea North (+850)',
							'82' => 'Korea South (+82)',
							'965' => 'Kuwait (+965)',
							'996' => 'Kyrgyzstan (+996)',
							'856' => 'Laos (+856)',
							'371' => 'Latvia (+371)',
							'961' => 'Lebanon (+961)',
							'266' => 'Lesotho (+266)',
							'231' => 'Liberia (+231)',
							'218' => 'Libya (+218)',
							'417' => 'Liechtenstein (+417)',
							'370' => 'Lithuania (+370)',
							'352' => 'Luxembourg (+352)',
							'853' => 'Macao (+853)',
							'389' => 'Macedonia (+389)',
							'261' => 'Madagascar (+261)',
							'265' => 'Malawi (+265)',
							'60' => 'Malaysia (+60)',
							'960' => 'Maldives (+960)',
							'223' => 'Mali (+223)',
							'356' => 'Malta (+356)',
							'692' => 'Marshall Islands (+692)',
							'596' => 'Martinique (+596)',
							'222' => 'Mauritania (+222)',
							'269' => 'Mayotte (+269)',
							'52' => 'Mexico (+52)',
							'691' => 'Micronesia (+691)',
							'373' => 'Moldova (+373)',
							'377' => 'Monaco (+377)',
							'976' => 'Mongolia (+976)',
							'1664' => 'Montserrat (+1664)',
							'212' => 'Morocco (+212)',
							'258' => 'Mozambique (+258)',
							'95' => 'Myanmar (+95)',
							'264' => 'Namibia (+264)',
							'674' => 'Nauru (+674)',
							'977' => 'Nepal (+977)',
							'31' => 'Netherlands (+31)',
							'687' => 'New Caledonia (+687)',
							'64' => 'New Zealand (+64)',
							'505' => 'Nicaragua (+505)',
							'227' => 'Niger (+227)',
							'234' => 'Nigeria (+234)',
							'683' => 'Niue (+683)',
							'672' => 'Norfolk Islands (+672)',
							'670' => 'Northern Marianas (+670)',
							'47' => 'Norway (+47)',
							'968' => 'Oman (+968)',
							'680' => 'Palau (+680)','970' => 'Palestine (+970)',
							'507' => 'Panama (+507)',
							'675' => 'Papua New Guinea (+675)',
							'595' => 'Paraguay (+595)',
							'51' => 'Peru (+51)',
							'63' => 'Philippines (+63)',
							'48' => 'Poland (+48)',
							'351' => 'Portugal (+351)',
							'1787' => 'Puerto Rico (+1787)',
							'974' => 'Qatar (+974)',
							'262' => 'Reunion (+262)',
							'40' => 'Romania (+40)',
							'7' => 'Russia (+7)',
							'250' => 'Rwanda (+250)',
							'378' => 'San Marino (+378)',
							'239' => 'Sao Tome & Principe (+239)',
							'966' => 'Saudi Arabia (+966)',
							'221' => 'Senegal (+221)',
							'381' => 'Serbia (+381)',
							'248' => 'Seychelles (+248)',
							'232' => 'Sierra Leone (+232)',
							'65' => 'Singapore (+65)',
							'421' => 'Slovak Republic (+421)',
							'386' => 'Slovenia (+386)',
							'677' => 'Solomon Islands (+677)',
							'252' => 'Somalia (+252)',
							'27' => 'South Africa (+27)',
							'34' => 'Spain (+34)',
							'94' => 'Sri Lanka (+94)',
							'290' => 'St. Helena (+290)',
							'1869' => 'St. Kitts (+1869)',
							'1758' => 'St. Lucia (+1758)',
							'249' => 'Sudan (+249)','211' => 'South Sudan (+211)',
							'597' => 'Suriname (+597)',
							'268' => 'Swaziland (+268)',
							'46' => 'Sweden (+46)',
							'41' => 'Switzerland (+41)',
							'963' => 'Syria (+963)',
							'886' => 'Taiwan (+886)',
							'7' => 'Tajikstan (+7)',
							'66' => 'Thailand (+66)',
							'228' => 'Togo (+228)',
							'676' => 'Tonga (+676)',
							'1868' => 'Trinidad & Tobago (+1868)',
							'216' => 'Tunisia (+216)',
							'90' => 'Turkey (+90)',
							'7' => 'Turkmenistan (+7)',
							'993' => 'Turkmenistan (+993)',
							'1649' => 'Turks & Caicos Islands (+1649)',
							'688' => 'Tuvalu (+688)',
							'256' => 'Uganda (+256)',
							'380' => 'Ukraine (+380)',
							'971' => 'United Arab Emirates (+971)',
							'598' => 'Uruguay (+598)',
							'7' => 'Uzbekistan (+7)',
							'678' => 'Vanuatu (+678)',
							'379' => 'Vatican City (+379)',
							'58' => 'Venezuela (+58)',
							'84' => 'Vietnam (+84)',
							'84' => 'Virgin Islands - British (+1284)',
							'84' => 'Virgin Islands - US (+1340)',
							'681' => 'Wallis & Futuna (+681)',
							'969' => 'Yemen (North)(+969)',
							'967' => 'Yemen (South)(+967)',
							'260' => 'Zambia (+260)',
							'263' => 'Zimbabwe (+263)',
						];

						$temp=  substr(strstr($phone, '+'),1);
					if($temp != false){$phone=$temp;}
                                                $countrycode='';
						// sort the array by key, descending
						krsort($countrys, SORT_NUMERIC);

						// iterate over all countries
						foreach($countrys as $we => $ccode){
							// if number begins with current number
							if(strpos($phone, '' . $we) === 0){
								// store country code and break the loop
								$countrycode = $we;
								break;
							}
						}

						if(!empty($countrycode)){
							$size=strlen($countrycode);
							$phone=substr($phone,$size);
						}



				$criteria->addSearchCondition('tel', $phone ,TRUE, "AND");
				$criteria->addSearchCondition('second_tel', $phone ,TRUE, "OR");
			$criteria->addSearchCondition('user_sales', $userid ,false, "AND");
			



}

	

			if(!empty($_GET['Search']['international_code2']))
			$criteria->addSearchCondition('international_code2', $_GET['Search']['international_code2'],false, "AND"); 
			
			if(!empty($_GET['Search']['secondtel']))
			$criteria->addSearchCondition('secondtel', $_GET['Search']['secondtel'],false, "AND"); 
			
			
			
			if(!empty($_GET['Search']['communication'])){
    			if($_GET['Search']['communication']==1){
    				$criteria->addSearchCondition('communication', $_GET['Search']['communication'],false, "AND");
    			}else if($_GET['Search']['communication']==2){
    				$criteria->addCondition('communication IS NULL');
    			}else{
    			}
			}
			
			
			
			
			
			if(!empty($_GET['Search']['receipt'])){
    			if($_GET['Search']['receipt']==1){
    				$criteria->addSearchCondition('receipt', $_GET['Search']['receipt'],false, "AND");
    			}else if($_GET['Search']['receipt']==2){
    				$criteria->addCondition('receipt IS NULL');
    			}else{
    			}
			}
			
			
			
			
			if(!empty($_GET['Search']['close']))
			$criteria->addSearchCondition('close', $_GET['Search']['close'],false, "AND");
			if(!empty($_GET['Search']['duplicate']))
			$criteria->addSearchCondition('duplicate', $_GET['Search']['duplicate'],false, "AND"); 
			if(!empty($_GET['Search']['place']))
			$criteria->addSearchCondition('interest_id', $_GET['Search']['place'],false, "AND");
			
			
			
			if(!empty($_GET['Search']['project'])){
			    
			$criteria->addSearchCondition('project_id', $_GET['Search']['project'],false, "AND");
			
			}
			
			
			
			
			if(!empty($_GET['Search']['tags'])){
			$criteria->addSearchCondition('tag_id', $_GET['Search']['tags'],true, "AND");
			
			}
			
			
			
			if(!empty($_GET['Search']['code'])){
			if($_GET['Search']['code']==1){


				$criteria->addSearchCondition('international_code', 20 ,false, "AND");

				}else if($_GET['Search']['code']==2){

					
			            $criteria->addNotInCondition('international_code', array(20));
				}else{}
			
			}
			
			
			
			
			if(!empty($_GET['Search']['client_id'])){
			    
			    
			    
    			if($_GET['Search']['client_id']==1){
    				$criteria->addSearchCondition('client_id', $_GET['Search']['client_id'],false, "AND");
    			}else if($_GET['Search']['client_id']==2){
    				$criteria->addCondition('client_id IS NULL');
    			}else{
    			}
			}
			
			
			if(!empty($_GET['Search']['indirect'])){
    			if($_GET['Search']['indirect']==1){
    				$criteria->addSearchCondition('indirect', $_GET['Search']['indirect'],false, "AND");
    			}else if($_GET['Search']['indirect']==2){
    				$criteria->addCondition('indirect IS NULL');
    			}else{
    			}
			}
			if(!empty($_GET['Search']['coldcall'])){
			    			   // var_dump($_GET['Search']['coldcall']);exit;

    			if($_GET['Search']['coldcall']==1){
    				$criteria->addSearchCondition('coldcall', $_GET['Search']['coldcall'],false, "AND");
    			}else if($_GET['Search']['coldcall']==2){
    				$criteria->addCondition('coldcall IS NULL');
    			}else{
    			}
			}
			
			
			
			
		
			
			
			
			if(!empty($_GET['Search']['transfer'])){
    			if($_GET['Search']['transfer']==1){
    				$criteria->addSearchCondition('transfer', $_GET['Search']['transfer'],false, "AND");
    			}else if($_GET['Search']['transfer']==2){
    				$criteria->addCondition('transfer IS NULL');
    			}else{
    			}
			}
			if(!empty($_GET['Search']['expvisit'])){
    			if($_GET['Search']['expvisit']==1){
    				$criteria->addSearchCondition('expvisit', $_GET['Search']['expvisit'],false, "AND");
    			}else if($_GET['Search']['expvisit']==2){
    				$criteria->addCondition('expvisit IS NULL');
    			}else{
    			}
			}
			if(!empty($_GET['Search']['visit'])){
    			if($_GET['Search']['visit']==1){
    				$criteria->addSearchCondition('visit', $_GET['Search']['visit'],false, "AND");
    			}else if($_GET['Search']['visit']==2){
    				$criteria->addCondition('visit IS NULL');
    			}else{
    			}
			}
			
			
			
			if(!empty($_GET['Search']['ccode'])){
    			if($_GET['Search']['ccode']==1){
    				$criteria->addSearchCondition('international_code', 20 ,false, "AND");
    			}else if($_GET['Search']['ccode']==2){
    				$criteria->addNotInCondition('international_code', array(20));
    			}else{
    			}
			}
			
         
				
			if(!empty($_GET['Search']['answer'])){
    			if($_GET['Search']['answer']==1){
    				$criteria->addSearchCondition('answer', $_GET['Search']['answer'],false, "AND");
    			}else if($_GET['Search']['answer']==2){
    				$criteria->addSearchCondition('answer', $_GET['Search']['answer'],false, "AND");
    			}else{
    			}
			}
			
			if(!empty($_GET['Search']['substatus'])){
				if(sizeOf((array)$_GET['Search']['substatus'])>1){  

                    $intArraysubstatus = array_map(
					function($intArraysubstatus){ return (int)$intArraysubstatus; },
					$_GET['Search']['substatus']
				);
				$criteria->addInCondition('substatus', $intArraysubstatus , "AND");
		       	}
		}
			
			if(!empty($_GET['Search']['status'])){
    			if(sizeOf((array)$_GET['Search']['status'])>1){
                    $val=true;
    			    //var_dump($_REQUEST['status']);exit;
    			    
    			    if($_GET['Search']['status'][1]!=0){
    			      
                    $intArraystatus = array_map(
    					function($value6){ return (int)$value6; },
    					$_GET['Search']['status']
    				);
    				 $criteria->addInCondition('status', $intArraystatus , "AND");
    				  
    			    }else{
    				$criteria->addCondition('status IS NULL');
    			    }
    		 	}
			}	
			
			if(!empty($_GET['Search']['campaign'])){
		 		if(sizeOf((array)$_GET['Search']['campaign'])>1){
                    $intArray4 = array_map(
					function($value4){ return (int)$value4; },
					$_GET['Search']['campaign']
				);
                                unset($intArray4[0]);

				$criteria->addInCondition('campaign_id', $intArray4 , "AND");
			}
			}
			if(!empty($_GET['Search']['platform'])){
			    if(sizeOf((array)$_GET['Search']['platform'])>1){
				$intArray = array_map(
					function($value){ return (int)$value; },
					$_GET['Search']['platform']
				);
				$criteria->addInCondition('platform_id', $intArray  , "AND");
			}
			}
			
			
			
			
				if(!empty($_GET['cold'])){
			    			   // var_dump($_GET['Search']['coldcall']);exit;

    			if($_GET['cold']==1){
    				$criteria->addCondition('coldcall IS NOT NULL');
    			}else if($_GET['cold']==2){
    			   // var_dump('sss');exit;
    			    
    				$criteria->addCondition('coldcall IS NULL');
    			}else{
    			}
			}
			
			
		 
			 
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');
			 
			if(!empty($_GET['Search']['startfollowdate']) && !empty($_GET['Search']['endfollowdate'] ))
			$criteria->addBetweenCondition("follow_date",$_GET['Search']['startfollowdate'],$_GET['Search']['endfollowdate'],'AND');


			$main=Mainsettings::model()->findByPk(1);
            if(empty($main->pagecount)){$pagecount=10;}else{$pagecount=$main->pagecount;}
			$dataProvider = new CActiveDataProvider('Leads', array(
					'pagination' => array(
						'pageSize' =>$pagecount,
					),
					'criteria' => $criteria,
				));
			$allleads = Leads::model()->findAll($criteria); 	
			$count=count($allleads);
	
		} else{

                
                 
		}
		$option=4;
		$visible=1;
		$allcampaign= Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allstatues= Statues::model()->findAll();
		
			$allplaces= Interestedplace::model()->findAll();

		$this->render('leadsresult', array(
											
				'allleads' => $allleads,					
				'userid' => $userid,					
				'dataProvider' => $dataProvider,			
				'allplatform' => $allplatform,			
				'allcampaign' => $allcampaign,			
				'allstatues' => $allstatues,		
				'option' => $option,		
				'count' => $count,		
				'allplaces' => $allplaces,
        
      

											
			));
			
			
			
}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
			
	}



	public function actionMarketinglead(){
	
		if(Yii::app()->user->isMember()){    
	    
	$userid=Yii::app()->user->id;

		if(empty($_GET['Search']) && Yii::app()->user->hasState('marketinglead'))
		$_GET['Search'] = Yii::app()->user->getState('marketinglead');

		if(isset($_GET['Search'])){


			$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
			$criteria->addSearchCondition('user_id', $userid ,false, "AND");

			//$criteria->addCondition('close IS NULL');
			if(!empty($_GET['Search']['title']))
			$criteria->addSearchCondition('title', $_GET['Search']['title'],TRUE, "AND");

			if(!empty($_GET['Search']['tel'])){


$phone= $_GET['Search']['tel'];
if($phone[0]=='0')
    $phone = substr($phone , 1);
$countrys = [
							'44' => 'UK (+44)',
							'213' => 'Algeria (+213)',
							'376' => 'Andorra (+376)',
							'244' => 'Angola (+244)',
							'1264' => 'Anguilla (+1264)',
							'1268' => 'Antigua & Barbuda (+1268)',
							'54' => 'Argentina (+54)',
							'374' => 'Armenia (+374)',
							'297' => 'Aruba (+297)',
							'61' => 'Australia (+61)',
							'43' => 'Austria (+43)',
							'994' => 'Azerbaijan (+994)',
							'1242' => 'Bahamas (+1242)',
							'973' => 'Bahrain (+973)',
							'880' => 'Bangladesh (+880)',
							'1246' => 'Barbados (+1246)',
							'375' => 'Belarus (+375)',
							'32' => 'Belgium (+32)',
							'501' => 'Belize (+501)',
							'229' => 'Benin (+229)',
							'1441' => 'Bermuda (+1441)',
							'975' => 'Bhutan (+975)',
							'591' => 'Bolivia (+591)',
							'387' => 'Bosnia Herzegovina (+387)',
							'267' => 'Botswana (+267)',
							'55' => 'Brazil (+55)',
							'673' => 'Brunei (+673)',
							'359' => 'Bulgaria (+359)',
							'226' => 'Burkina Faso (+226)',
							'257' => 'Burundi (+257)',
							'855' => 'Cambodia (+855)',
							'237' => 'Cameroon (+237)',
							'238' => 'Cape Verde Islands (+238)',
							'1345' => 'Cayman Islands (+1345)',
							'236' => 'Central African Republic (+236)',
							'56' => 'Chile (+56)',
							'86' => 'China (+86)',
							'57' => 'Colombia (+57)',
							'269' => 'Comoros (+269)',
							'242' => 'Congo (+242)',
							'682' => 'Cook Islands (+682)',
							'506' => 'Costa Rica (+506)','225' => 'Cote d Ivoire (+225)',
							'385' => 'Croatia (+385)',
							'53' => 'Cuba (+53)',
							'90392' => 'Cyprus North (+90392)',
							'357' => 'Cyprus South (+357)',
							'420' => 'Czech Republic (+420)',
							'45' => 'Denmark (+45)',
							'253' => 'Djibouti (+253)',
							'1809' => 'Dominica (+1809)',
							'1809' => 'Dominican Republic (+1809)',
							'593' => 'Ecuador (+593)',
							'20' => 'Egypt (+20)',
							'503' => 'El Salvador (+503)',
							'240' => 'Equatorial Guinea (+240)',
							'291' => 'Eritrea (+291)',
							'372' => 'Estonia (+372)',
							'251' => 'Ethiopia (+251)',
							'500' => 'Falkland Islands (+500)',
							'298' => 'Faroe Islands (+298)',
							'679' => 'Fiji (+679)',
							'358' => 'Finland (+358)',
							'33' => 'France (+33)',
							'594' => 'French Guiana (+594)',
							'689' => 'French Polynesia (+689)',
							'241' => 'Gabon (+241)',
							'220' => 'Gambia (+220)',
							'995' => 'Georgia (+995)',
							'49' => 'Germany (+49)',
							'233' => 'Ghana (+233)',
							'350' => 'Gibraltar (+350)',
							'30' => 'Greece (+30)',
							'299' => 'Greenland (+299)',
							'1473' => 'Grenada (+1473)',
							'590' => 'Guadeloupe (+590)',
							'671' => 'Guam (+671)',
							'502' => 'Guatemala (+502)',
							'224' => 'Guinea (+224)',
							'245' => 'Guinea - Bissau (+245)',
							'592' => 'Guyana (+592)',
							'509' => 'Haiti (+509)',
							'504' => 'Honduras (+504)',
							'852' => 'Hong Kong (+852)',
							'36' => 'Hungary (+36)',
							'354' => 'Iceland (+354)',
							'91' => 'India (+91)',
							'62' => 'Indonesia (+62)',
							'98' => 'Iran (+98)',
							'964' => 'Iraq (+964)',
							'353' => 'Ireland (+353)',
							'39' => 'Italy (+39)','972' => 'Israel (+972)',
							'1876' => 'Jamaica (+1876)',
							'81' => 'Japan (+81)',
							'962' => 'Jordan (+962)',
							'7' => 'Kazakhstan (+7)',
							'254' => 'Kenya (+254)',
							'686' => 'Kiribati (+686)',
							'850' => 'Korea North (+850)',
							'82' => 'Korea South (+82)',
							'965' => 'Kuwait (+965)',
							'996' => 'Kyrgyzstan (+996)',
							'856' => 'Laos (+856)',
							'371' => 'Latvia (+371)',
							'961' => 'Lebanon (+961)',
							'266' => 'Lesotho (+266)',
							'231' => 'Liberia (+231)',
							'218' => 'Libya (+218)',
							'417' => 'Liechtenstein (+417)',
							'370' => 'Lithuania (+370)',
							'352' => 'Luxembourg (+352)',
							'853' => 'Macao (+853)',
							'389' => 'Macedonia (+389)',
							'261' => 'Madagascar (+261)',
							'265' => 'Malawi (+265)',
							'60' => 'Malaysia (+60)',
							'960' => 'Maldives (+960)',
							'223' => 'Mali (+223)',
							'356' => 'Malta (+356)',
							'692' => 'Marshall Islands (+692)',
							'596' => 'Martinique (+596)',
							'222' => 'Mauritania (+222)',
							'269' => 'Mayotte (+269)',
							'52' => 'Mexico (+52)',
							'691' => 'Micronesia (+691)',
							'373' => 'Moldova (+373)',
							'377' => 'Monaco (+377)',
							'976' => 'Mongolia (+976)',
							'1664' => 'Montserrat (+1664)',
							'212' => 'Morocco (+212)',
							'258' => 'Mozambique (+258)',
							'95' => 'Myanmar (+95)',
							'264' => 'Namibia (+264)',
							'674' => 'Nauru (+674)',
							'977' => 'Nepal (+977)',
							'31' => 'Netherlands (+31)',
							'687' => 'New Caledonia (+687)',
							'64' => 'New Zealand (+64)',
							'505' => 'Nicaragua (+505)',
							'227' => 'Niger (+227)',
							'234' => 'Nigeria (+234)',
							'683' => 'Niue (+683)',
							'672' => 'Norfolk Islands (+672)',
							'670' => 'Northern Marianas (+670)',
							'47' => 'Norway (+47)',
							'968' => 'Oman (+968)',
							'680' => 'Palau (+680)','970' => 'Palestine (+970)',
							'507' => 'Panama (+507)',
							'675' => 'Papua New Guinea (+675)',
							'595' => 'Paraguay (+595)',
							'51' => 'Peru (+51)',
							'63' => 'Philippines (+63)',
							'48' => 'Poland (+48)',
							'351' => 'Portugal (+351)',
							'1787' => 'Puerto Rico (+1787)',
							'974' => 'Qatar (+974)',
							'262' => 'Reunion (+262)',
							'40' => 'Romania (+40)',
							'7' => 'Russia (+7)',
							'250' => 'Rwanda (+250)',
							'378' => 'San Marino (+378)',
							'239' => 'Sao Tome & Principe (+239)',
							'966' => 'Saudi Arabia (+966)',
							'221' => 'Senegal (+221)',
							'381' => 'Serbia (+381)',
							'248' => 'Seychelles (+248)',
							'232' => 'Sierra Leone (+232)',
							'65' => 'Singapore (+65)',
							'421' => 'Slovak Republic (+421)',
							'386' => 'Slovenia (+386)',
							'677' => 'Solomon Islands (+677)',
							'252' => 'Somalia (+252)',
							'27' => 'South Africa (+27)',
							'34' => 'Spain (+34)',
							'94' => 'Sri Lanka (+94)',
							'290' => 'St. Helena (+290)',
							'1869' => 'St. Kitts (+1869)',
							'1758' => 'St. Lucia (+1758)',
							'249' => 'Sudan (+249)','211' => 'South Sudan (+211)',
							'597' => 'Suriname (+597)',
							'268' => 'Swaziland (+268)',
							'46' => 'Sweden (+46)',
							'41' => 'Switzerland (+41)',
							'963' => 'Syria (+963)',
							'886' => 'Taiwan (+886)',
							'7' => 'Tajikstan (+7)',
							'66' => 'Thailand (+66)',
							'228' => 'Togo (+228)',
							'676' => 'Tonga (+676)',
							'1868' => 'Trinidad & Tobago (+1868)',
							'216' => 'Tunisia (+216)',
							'90' => 'Turkey (+90)',
							'7' => 'Turkmenistan (+7)',
							'993' => 'Turkmenistan (+993)',
							'1649' => 'Turks & Caicos Islands (+1649)',
							'688' => 'Tuvalu (+688)',
							'256' => 'Uganda (+256)',
							'380' => 'Ukraine (+380)',
							'971' => 'United Arab Emirates (+971)',
							'598' => 'Uruguay (+598)',
							'7' => 'Uzbekistan (+7)',
							'678' => 'Vanuatu (+678)',
							'379' => 'Vatican City (+379)',
							'58' => 'Venezuela (+58)',
							'84' => 'Vietnam (+84)',
							'84' => 'Virgin Islands - British (+1284)',
							'84' => 'Virgin Islands - US (+1340)',
							'681' => 'Wallis & Futuna (+681)',
							'969' => 'Yemen (North)(+969)',
							'967' => 'Yemen (South)(+967)',
							'260' => 'Zambia (+260)',
							'263' => 'Zimbabwe (+263)',
						];

						$temp=  substr(strstr($phone, '+'),1);
					if($temp != false){$phone=$temp;}
                                                $countrycode='';
						// sort the array by key, descending
						krsort($countrys, SORT_NUMERIC);

						// iterate over all countries
						foreach($countrys as $we => $ccode){
							// if number begins with current number
							if(strpos($phone, '' . $we) === 0){
								// store country code and break the loop
								$countrycode = $we;
								break;
							}
						}

						if(!empty($countrycode)){
							$size=strlen($countrycode);
							$phone=substr($phone,$size);
						}



				$criteria->addSearchCondition('tel', $phone ,TRUE, "AND");
				$criteria->addSearchCondition('second_tel', $phone ,TRUE, "OR");
			$criteria->addSearchCondition('user_sales', $userid ,false, "AND");
			



}

	

			if(!empty($_GET['Search']['secondtel']))
			$criteria->addSearchCondition('secondtel', $_GET['Search']['secondtel'],false, "AND"); 
			if(!empty($_GET['Search']['receipt']))
			$criteria->addSearchCondition('receipt', $_GET['Search']['receipt'],false, "AND");
			if(!empty($_GET['Search']['communication']))
			$criteria->addSearchCondition('communication', $_GET['Search']['communication'],false, "AND");
			if(!empty($_GET['Search']['close']))
			$criteria->addSearchCondition('close', $_GET['Search']['close'],false, "AND");
			if(!empty($_GET['Search']['duplicate']))
			$criteria->addSearchCondition('duplicate', $_GET['Search']['duplicate'],false, "AND"); 
			if(!empty($_GET['Search']['place']))
			$criteria->addSearchCondition('interest_id', $_GET['Search']['place'],false, "AND");
			
			if(!empty($_GET['Search']['code'])){
			if($_GET['Search']['code']==1){


					$criteria->addSearchCondition('international_code', 20 ,false, "AND");

				}else if($_GET['Search']['code']==2){

					
			            $criteria->addNotInCondition('international_code', array(20));
				}else{}
			
			}
			
				if($_GET['cold']==1){
            $criteria->addCondition('coldcall IS NOT NULL');
                 }elseif($_GET['cold']==2){
            $criteria->addCondition('coldcall IS NULL');
        }
			
			
			if(!empty($_GET['Search']['answer'])){
    			if($_GET['Search']['answer']==1){
    				$criteria->addSearchCondition('answer', $_GET['Search']['answer'],false, "AND");
    			}else if($_GET['Search']['answer']==2){
    				$criteria->addSearchCondition('answer', $_GET['Search']['answer'],false, "AND");
    			}else{
    			}
			}
			
			
			
			if(!empty($_GET['Search']['substatus'])){
				if(sizeOf((array)$_GET['Search']['substatus'])>1){  

                    $intArraysubstatus = array_map(
					function($intArraysubstatus){ return (int)$intArraysubstatus; },
					$_GET['Search']['substatus']
				);
				$criteria->addInCondition('substatus', $intArraysubstatus , "AND");
		       	}
		}
			
			if(!empty($_GET['Search']['status'])){
    			if(sizeOf((array)$_GET['Search']['status'])>1){
                    $val=true;
    			    //var_dump($_REQUEST['status']);exit;
    			    
    			    if($_GET['Search']['status'][1]!=0){
    			      
                    $intArraystatus = array_map(
    					function($value6){ return (int)$value6; },
    					$_GET['Search']['status']
    				);
    				 $criteria->addInCondition('status', $intArraystatus , "AND");
    				  
    			    }else{
    				$criteria->addCondition('status IS NULL');
    			    }
    		 	}
			}	
			
			if(!empty($_GET['Search']['campaign'])){
		 		if(sizeOf((array)$_GET['Search']['campaign'])>1){
                    $intArray4 = array_map(
					function($value4){ return (int)$value4; },
					$_GET['Search']['campaign']
				);
                                unset($intArray4[0]);

				$criteria->addInCondition('campaign_id', $intArray4 , "AND");
			}
			}
			if(!empty($_GET['Search']['platform'])){
			    if(sizeOf((array)$_GET['Search']['platform'])>1){
				$intArray = array_map(
					function($value){ return (int)$value; },
					$_GET['Search']['platform']
				);
				$criteria->addInCondition('platform_id', $intArray  , "AND");
			}
			}
			
			
			
			
			if(!empty($_GET['Search']['sales'])){
			    if(sizeOf((array)$_GET['Search']['sales'])>1){
				$intArray = array_map(
					function($value){ return (int)$value; },
					$_GET['Search']['sales']
				);
				$criteria->addInCondition('user_sales', $intArray  , "AND");
			}
			}
			
			
		 
			 
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');


			$main=Mainsettings::model()->findByPk(1);
            if(empty($main->pagecount)){$pagecount=10;}else{$pagecount=$main->pagecount;}
			$dataProvider = new CActiveDataProvider('Leads', array(
					'pagination' => array(
						'pageSize' =>$pagecount,
					),
					'criteria' => $criteria,
				));
			$allleads = Leads::model()->findAll($criteria); 	
			$count=count($allleads);
	
		} else{

                
                 
		}
		$option=8;
		$visible=1;
		$allcampaign= Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allstatues= Statues::model()->findAll();
		
			$allplaces= Interestedplace::model()->findAll();

		$this->render('leadsresult', array(
											
				'allleads' => $allleads,					
				'userid' => $userid,					
				'dataProvider' => $dataProvider,			
				'allplatform' => $allplatform,			
				'allcampaign' => $allcampaign,			
				'allstatues' => $allstatues,		
				'option' => $option,		
				'count' => $count,		
				'allplaces' => $allplaces,
        
      

											
			));
			
		
			
}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}	
			
	}






	public function actionSearchleadidclosed(){
		Yii::app()->user->setState('searchleadclosed', $_GET['Search']);
		$this->redirect(array('searchleadclosed'));
	}




	public function actionSearchleadclosed(){
	
	
	

	if(Yii::app()->user->isMember()){
    
	    
	$userid=Yii::app()->user->id;

		if(empty($_GET['Search']) && Yii::app()->user->hasState('searchleadclosed'))
		$_GET['Search'] = Yii::app()->user->getState('searchleadclosed');

		if(isset($_GET['Search'])){


			$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
			$criteria->addSearchCondition('user_sales', $userid ,false, "AND");

			$criteria->addCondition('close IS NOT NULL');
			if(!empty($_GET['Search']['title']))
			$criteria->addSearchCondition('title', $_GET['Search']['title'],TRUE, "AND");

			if(!empty($_GET['Search']['tel'])){


$phone= $_GET['Search']['tel'];
if($phone[0]=='0')
    $phone = substr($phone , 1);
$countrys = [
							'44' => 'UK (+44)',
							'213' => 'Algeria (+213)',
							'376' => 'Andorra (+376)',
							'244' => 'Angola (+244)',
							'1264' => 'Anguilla (+1264)',
							'1268' => 'Antigua & Barbuda (+1268)',
							'54' => 'Argentina (+54)',
							'374' => 'Armenia (+374)',
							'297' => 'Aruba (+297)',
							'61' => 'Australia (+61)',
							'43' => 'Austria (+43)',
							'994' => 'Azerbaijan (+994)',
							'1242' => 'Bahamas (+1242)',
							'973' => 'Bahrain (+973)',
							'880' => 'Bangladesh (+880)',
							'1246' => 'Barbados (+1246)',
							'375' => 'Belarus (+375)',
							'32' => 'Belgium (+32)',
							'501' => 'Belize (+501)',
							'229' => 'Benin (+229)',
							'1441' => 'Bermuda (+1441)',
							'975' => 'Bhutan (+975)',
							'591' => 'Bolivia (+591)',
							'387' => 'Bosnia Herzegovina (+387)',
							'267' => 'Botswana (+267)',
							'55' => 'Brazil (+55)',
							'673' => 'Brunei (+673)',
							'359' => 'Bulgaria (+359)',
							'226' => 'Burkina Faso (+226)',
							'257' => 'Burundi (+257)',
							'855' => 'Cambodia (+855)',
							'237' => 'Cameroon (+237)',
							'238' => 'Cape Verde Islands (+238)',
							'1345' => 'Cayman Islands (+1345)',
							'236' => 'Central African Republic (+236)',
							'56' => 'Chile (+56)',
							'86' => 'China (+86)',
							'57' => 'Colombia (+57)',
							'269' => 'Comoros (+269)',
							'242' => 'Congo (+242)',
							'682' => 'Cook Islands (+682)',
							'506' => 'Costa Rica (+506)','225' => 'Cote d Ivoire (+225)',
							'385' => 'Croatia (+385)',
							'53' => 'Cuba (+53)',
							'90392' => 'Cyprus North (+90392)',
							'357' => 'Cyprus South (+357)',
							'420' => 'Czech Republic (+420)',
							'45' => 'Denmark (+45)',
							'253' => 'Djibouti (+253)',
							'1809' => 'Dominica (+1809)',
							'1809' => 'Dominican Republic (+1809)',
							'593' => 'Ecuador (+593)',
							'20' => 'Egypt (+20)',
							'503' => 'El Salvador (+503)',
							'240' => 'Equatorial Guinea (+240)',
							'291' => 'Eritrea (+291)',
							'372' => 'Estonia (+372)',
							'251' => 'Ethiopia (+251)',
							'500' => 'Falkland Islands (+500)',
							'298' => 'Faroe Islands (+298)',
							'679' => 'Fiji (+679)',
							'358' => 'Finland (+358)',
							'33' => 'France (+33)',
							'594' => 'French Guiana (+594)',
							'689' => 'French Polynesia (+689)',
							'241' => 'Gabon (+241)',
							'220' => 'Gambia (+220)',
							'995' => 'Georgia (+995)',
							'49' => 'Germany (+49)',
							'233' => 'Ghana (+233)',
							'350' => 'Gibraltar (+350)',
							'30' => 'Greece (+30)',
							'299' => 'Greenland (+299)',
							'1473' => 'Grenada (+1473)',
							'590' => 'Guadeloupe (+590)',
							'671' => 'Guam (+671)',
							'502' => 'Guatemala (+502)',
							'224' => 'Guinea (+224)',
							'245' => 'Guinea - Bissau (+245)',
							'592' => 'Guyana (+592)',
							'509' => 'Haiti (+509)',
							'504' => 'Honduras (+504)',
							'852' => 'Hong Kong (+852)',
							'36' => 'Hungary (+36)',
							'354' => 'Iceland (+354)',
							'91' => 'India (+91)',
							'62' => 'Indonesia (+62)',
							'98' => 'Iran (+98)',
							'964' => 'Iraq (+964)',
							'353' => 'Ireland (+353)',
							'39' => 'Italy (+39)','972' => 'Israel (+972)',
							'1876' => 'Jamaica (+1876)',
							'81' => 'Japan (+81)',
							'962' => 'Jordan (+962)',
							'7' => 'Kazakhstan (+7)',
							'254' => 'Kenya (+254)',
							'686' => 'Kiribati (+686)',
							'850' => 'Korea North (+850)',
							'82' => 'Korea South (+82)',
							'965' => 'Kuwait (+965)',
							'996' => 'Kyrgyzstan (+996)',
							'856' => 'Laos (+856)',
							'371' => 'Latvia (+371)',
							'961' => 'Lebanon (+961)',
							'266' => 'Lesotho (+266)',
							'231' => 'Liberia (+231)',
							'218' => 'Libya (+218)',
							'417' => 'Liechtenstein (+417)',
							'370' => 'Lithuania (+370)',
							'352' => 'Luxembourg (+352)',
							'853' => 'Macao (+853)',
							'389' => 'Macedonia (+389)',
							'261' => 'Madagascar (+261)',
							'265' => 'Malawi (+265)',
							'60' => 'Malaysia (+60)',
							'960' => 'Maldives (+960)',
							'223' => 'Mali (+223)',
							'356' => 'Malta (+356)',
							'692' => 'Marshall Islands (+692)',
							'596' => 'Martinique (+596)',
							'222' => 'Mauritania (+222)',
							'269' => 'Mayotte (+269)',
							'52' => 'Mexico (+52)',
							'691' => 'Micronesia (+691)',
							'373' => 'Moldova (+373)',
							'377' => 'Monaco (+377)',
							'976' => 'Mongolia (+976)',
							'1664' => 'Montserrat (+1664)',
							'212' => 'Morocco (+212)',
							'258' => 'Mozambique (+258)',
							'95' => 'Myanmar (+95)',
							'264' => 'Namibia (+264)',
							'674' => 'Nauru (+674)',
							'977' => 'Nepal (+977)',
							'31' => 'Netherlands (+31)',
							'687' => 'New Caledonia (+687)',
							'64' => 'New Zealand (+64)',
							'505' => 'Nicaragua (+505)',
							'227' => 'Niger (+227)',
							'234' => 'Nigeria (+234)',
							'683' => 'Niue (+683)',
							'672' => 'Norfolk Islands (+672)',
							'670' => 'Northern Marianas (+670)',
							'47' => 'Norway (+47)',
							'968' => 'Oman (+968)',
							'680' => 'Palau (+680)','970' => 'Palestine (+970)',
							'507' => 'Panama (+507)',
							'675' => 'Papua New Guinea (+675)',
							'595' => 'Paraguay (+595)',
							'51' => 'Peru (+51)',
							'63' => 'Philippines (+63)',
							'48' => 'Poland (+48)',
							'351' => 'Portugal (+351)',
							'1787' => 'Puerto Rico (+1787)',
							'974' => 'Qatar (+974)',
							'262' => 'Reunion (+262)',
							'40' => 'Romania (+40)',
							'7' => 'Russia (+7)',
							'250' => 'Rwanda (+250)',
							'378' => 'San Marino (+378)',
							'239' => 'Sao Tome & Principe (+239)',
							'966' => 'Saudi Arabia (+966)',
							'221' => 'Senegal (+221)',
							'381' => 'Serbia (+381)',
							'248' => 'Seychelles (+248)',
							'232' => 'Sierra Leone (+232)',
							'65' => 'Singapore (+65)',
							'421' => 'Slovak Republic (+421)',
							'386' => 'Slovenia (+386)',
							'677' => 'Solomon Islands (+677)',
							'252' => 'Somalia (+252)',
							'27' => 'South Africa (+27)',
							'34' => 'Spain (+34)',
							'94' => 'Sri Lanka (+94)',
							'290' => 'St. Helena (+290)',
							'1869' => 'St. Kitts (+1869)',
							'1758' => 'St. Lucia (+1758)',
							'249' => 'Sudan (+249)','211' => 'South Sudan (+211)',
							'597' => 'Suriname (+597)',
							'268' => 'Swaziland (+268)',
							'46' => 'Sweden (+46)',
							'41' => 'Switzerland (+41)',
							'963' => 'Syria (+963)',
							'886' => 'Taiwan (+886)',
							'7' => 'Tajikstan (+7)',
							'66' => 'Thailand (+66)',
							'228' => 'Togo (+228)',
							'676' => 'Tonga (+676)',
							'1868' => 'Trinidad & Tobago (+1868)',
							'216' => 'Tunisia (+216)',
							'90' => 'Turkey (+90)',
							'7' => 'Turkmenistan (+7)',
							'993' => 'Turkmenistan (+993)',
							'1649' => 'Turks & Caicos Islands (+1649)',
							'688' => 'Tuvalu (+688)',
							'256' => 'Uganda (+256)',
							'380' => 'Ukraine (+380)',
							'971' => 'United Arab Emirates (+971)',
							'598' => 'Uruguay (+598)',
							'7' => 'Uzbekistan (+7)',
							'678' => 'Vanuatu (+678)',
							'379' => 'Vatican City (+379)',
							'58' => 'Venezuela (+58)',
							'84' => 'Vietnam (+84)',
							'84' => 'Virgin Islands - British (+1284)',
							'84' => 'Virgin Islands - US (+1340)',
							'681' => 'Wallis & Futuna (+681)',
							'969' => 'Yemen (North)(+969)',
							'967' => 'Yemen (South)(+967)',
							'260' => 'Zambia (+260)',
							'263' => 'Zimbabwe (+263)',
						];

						$temp=  substr(strstr($phone, '+'),1);
					if($temp != false){$phone=$temp;}
                                                $countrycode='';
						// sort the array by key, descending
						krsort($countrys, SORT_NUMERIC);

						// iterate over all countries
						foreach($countrys as $we => $ccode){
							// if number begins with current number
							if(strpos($phone, '' . $we) === 0){
								// store country code and break the loop
								$countrycode = $we;
								break;
							}
						}

						if(!empty($countrycode)){
							$size=strlen($countrycode);
							$phone=substr($phone,$size);
						}



				$criteria->addSearchCondition('tel', $phone ,TRUE, "AND");
				$criteria->addSearchCondition('second_tel', $phone ,TRUE, "OR");
			$criteria->addSearchCondition('user_sales', $userid ,false, "AND");
			



}

	

			if(!empty($_GET['Search']['secondtel']))
			$criteria->addSearchCondition('secondtel', $_GET['Search']['secondtel'],false, "AND"); 
			if(!empty($_GET['Search']['receipt']))
			$criteria->addSearchCondition('receipt', $_GET['Search']['receipt'],false, "AND");
			if(!empty($_GET['Search']['communication']))
			$criteria->addSearchCondition('communication', $_GET['Search']['communication'],false, "AND");
			if(!empty($_GET['Search']['close']))
			$criteria->addSearchCondition('close', $_GET['Search']['close'],false, "AND");
			if(!empty($_GET['Search']['duplicate']))
			$criteria->addSearchCondition('duplicate', $_GET['Search']['duplicate'],false, "AND"); 
			if(!empty($_GET['Search']['place']))
			$criteria->addSearchCondition('interest_id', $_GET['Search']['place'],false, "AND");
			
			
			if($_GET['Search']['place']==1){


					$criteria->addSearchCondition('international_code', 20 ,false, "AND");

				}else if($_GET['Search']['place']==2){

					
			            $criteria->addNotInCondition('international_code', array(20));
				}else{}
			
			
			
			
			
			
			
				if(sizeOf((array)$_GET['Search']['substatus'])>1){  

                    $intArraysubstatus = array_map(
					function($intArraysubstatus){ return (int)$intArraysubstatus; },
					$_GET['Search']['substatus']
				);
				$criteria->addInCondition('substatus', $intArraysubstatus , "AND");
		       	}
			
			
    			if(sizeOf((array)$_GET['Search']['status'])>1){
                    $val=true;
    			    //var_dump($_REQUEST['status']);exit;
    			    
    			    if($_GET['Search']['status'][1]!=0){
    			      
                    $intArraystatus = array_map(
    					function($value6){ return (int)$value6; },
    					$_GET['Search']['status']
    				);
    				 $criteria->addInCondition('status', $intArraystatus , "AND");
    				  
    			    }else{
    				$criteria->addCondition('status IS NULL');
    			    }
    		 	}
    		 	
		 		if(sizeOf((array)$_GET['Search']['campaign'])>1){
                    $intArray4 = array_map(
					function($value4){ return (int)$value4; },
					$_GET['Search']['campaign']
				);
                                unset($intArray4[0]);

				$criteria->addInCondition('campaign_id', $intArray4 , "AND");
			}
			
			
			if(sizeOf((array)$_GET['Search']['platform'])>1){
				$intArray = array_map(
					function($value){ return (int)$value; },
					$_GET['Search']['platform']
				);
				$criteria->addInCondition('platform_id', $intArray  , "AND");
			}
			
			
		 
			 
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');


			$dataProvider = new CActiveDataProvider('Leads', array(
					'pagination' => array(
						'pageSize' =>50,
					),
					'criteria' => $criteria,
				));
			$allleads = Leads::model()->findAll($criteria); 	
			$count=count($allleads);
	
		} else{

                
                 
		}
		$option=4;
		$visible=1;
		$allcampaign= Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allstatues= Statues::model()->findAll();
		
			$allplaces= Interestedplace::model()->findAll();

		$this->render('leadsresultclosed', array(
											
				'allleads' => $allleads,					
				'userid' => $userid,					
				'dataProvider' => $dataProvider,			
				'allplatform' => $allplatform,			
				'allcampaign' => $allcampaign,			
				'allstatues' => $allstatues,		
				'option' => $option,		
				'count' => $count,		
				'allplaces' => $allplaces,
        
      

											
			));
			
	
	}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}		
			
	}









	public function actionSearchunitredirect(){
		Yii::app()->user->setState('searchunit', $_GET['Search']);
		$this->redirect(array('searchunit'));
	}

	public function actionSearchunit(){
	    
	    
	    

	if(Yii::app()->user->isMember()){

	    
		if(empty($_GET['Search']) && Yii::app()->user->hasState('searchunit'))
		$_GET['Search'] = Yii::app()->user->getState('searchunit');

        $userid=Yii::app()->user->id;
    	$user=User::model()->findByPk($userid);


		if(isset($_GET['Search'])){


			$criteria = new CDbCriteria();
			$criteria->order = 'id ASC';

			$criteria->condition = "booking IS NULL ";
			$criteria->addSearchCondition('hidden', 1,false, "AND");
			
			
				if(!empty($_GET['Search']['projects']))
			$criteria->addSearchCondition('projects_id', $_GET['projects'],TRUE, "AND");
			
			if(!empty($_GET['Search']['building']))
			$criteria->addSearchCondition('building_id', $_GET['building'],TRUE, "AND");
			
			if(!empty($_GET['Search']['title']))
			$criteria->addSearchCondition('title', $_GET['title'],TRUE, "AND");
			
				if(!empty($_GET['Search']['code']))
			$criteria->addSearchCondition('code', $_GET['Search']['code'],false, "AND");
			
			if(!empty($_GET['Search']['floor_id']))
			$criteria->addSearchCondition('floor_id', $_GET['Search']['floor_id'],false, "AND");
			if(!empty($_GET['Search']['activity']))
			$criteria->addSearchCondition('activity', $_GET['Search']['activity'],false, "AND");
			if(!empty($_GET['Search']['delivery_date']))
			$criteria->addSearchCondition('delivery_date', $_GET['Search']['delivery_date'],false, "AND");
			if(!empty($_GET['Search']['area_sold']))
			$criteria->addSearchCondition('area_sold', $_GET['Search']['area_sold'],false, "AND");
			if(!empty($_GET['Search']['garden']))
			$criteria->addSearchCondition('garden', $_GET['Search']['garden'],false, "AND");
			if(!empty($_GET['Search']['studio']))
			$criteria->addSearchCondition('studio', $_GET['Search']['studio'],false, "AND");
			if(!empty($_GET['Search']['parking']))
			$criteria->addSearchCondition('parking', $_GET['Search']['parking'],false, "AND");
			if(!empty($_GET['Search']['closet']))
			$criteria->addSearchCondition('closet', $_GET['Search']['closet'],false, "AND");
			if(!empty($_GET['Search']['roof']))
			$criteria->addSearchCondition('roof', $_GET['Search']['roof'],false, "AND");
			if(!empty($_GET['Search']['number_receptions']))
			$criteria->addSearchCondition('number_receptions', $_GET['Search']['number_receptions'],false, "AND");
			if(!empty($_GET['Search']['number_rooms']))
			$criteria->addSearchCondition('number_rooms', $_GET['Search']['number_rooms'],false, "AND");
			if(!empty($_GET['Search']['number_terace']))
			$criteria->addSearchCondition('number_terace', $_GET['Search']['number_terace'],false, "AND");
			if(!empty($_GET['Search']['number_baths']))
			$criteria->addSearchCondition('number_baths', $_GET['Search']['number_baths'],false, "AND");
			if(!empty($_GET['Search']['number_kitchen']))
			$criteria->addSearchCondition('number_kitchen', $_GET['Search']['number_kitchen'],false, "AND");
			
			
			
			
			if(!empty($_GET['Search']['Finishing']))
			$criteria->addSearchCondition('Finishing', $_GET['Search']['Finishing'],false, "AND");
			
			if(!empty($_GET['Search']['land_type']))
			$criteria->addSearchCondition('land_type', $_GET['Search']['land_type'],false, "AND");
			
			if(!empty($_GET['Search']['owning_type']))
			$criteria->addSearchCondition('owning_type', $_GET['Search']['owning_type'],false, "AND");
			
			if(!empty($_GET['Search']['place_status']))
			$criteria->addSearchCondition('place_status', $_GET['Search']['place_status'],false, "AND");
			
			if(!empty($_GET['Search']['commission_months']))
			$criteria->addSearchCondition('commission_months', $_GET['Search']['commission_months'],false, "AND");
			
			if(!empty($_GET['Search']['governorate']))
			$criteria->addSearchCondition('governorate', $_GET['Search']['governorate'],false, "AND");
			
			if(!empty($_GET['Search']['city']))
			$criteria->addSearchCondition('city', $_GET['Search']['city'],false, "AND");
			
			if(!empty($_GET['Search']['region']))
			$criteria->addSearchCondition('region', $_GET['Search']['region'],false, "AND");
			

			$secert= $_GET['Search']['lead_id'];
			$lead= Leads::model()->findByAttributes(array('secert'=>$secert));
		
			$visible = 1;
			$alltypebuliding = TypeBuliding::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

			$allfloor = Floor::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));


			$allunits = Units::model()->findAll($criteria);
			$total = Count($allunits);

					
		} else{

                
                 
		}




		//$alllike= LikeUnit::model()->findAll(array( 'condition' => 'lead_id=' . $lead->id));
                
		$this->render('searchresult', array(
											
				'lead' => $lead,						
				'allunits' => $allunits ,					
				'alllike' => $alllike,
				'alltypebuliding'=>$alltypebuliding ,	
				'allfloor'=>$allfloor ,
				'total'=>$total ,
                        

											
			));
			
			
	}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
			
	}

















	public function actionSearchunitredirectbr(){
		Yii::app()->user->setState('searchunitbr', $_GET['Search']);
		$this->redirect(array('searchunitbr'));
	}

	public function actionSearchunitbr(){
	    
	    

	if(Yii::app()->user->isMember()){


	    
		if(empty($_GET['Search']) && Yii::app()->user->hasState('searchunitbr'))
		$_GET['Search'] = Yii::app()->user->getState('searchunitbr');

		if(isset($_GET['Search'])){


			$criteria = new CDbCriteria();
			$criteria->order = 'id ASC';

			$criteria->condition = "booking IS NULL ";
			$criteria->addSearchCondition('hidden', 1,false, "AND");
			if(!empty($_GET['Search']['title']))
			$criteria->addSearchCondition('title', $_GET['title'],TRUE, "AND");
			if(!empty($_GET['Search']['floor_id']))
			$criteria->addSearchCondition('floor_id', $_GET['Search']['floor_id'],false, "AND");
			if(!empty($_GET['Search']['code']))
			$criteria->addSearchCondition('code', $_GET['Search']['code'],false, "AND");
			if(!empty($_GET['Search']['activity']))
			$criteria->addSearchCondition('activity', $_GET['Search']['activity'],false, "AND");
			if(!empty($_GET['Search']['delivery_date']))
			$criteria->addSearchCondition('delivery_date', $_GET['Search']['delivery_date'],false, "AND");
			if(!empty($_GET['Search']['area_sold']))
			$criteria->addSearchCondition('area_sold', $_GET['Search']['area_sold'],false, "AND");
			if(!empty($_GET['Search']['garden']))
			$criteria->addSearchCondition('garden', $_GET['Search']['garden'],false, "AND");
			if(!empty($_GET['Search']['studio']))
			$criteria->addSearchCondition('studio', $_GET['Search']['studio'],false, "AND");
			if(!empty($_GET['Search']['parking']))
			$criteria->addSearchCondition('parking', $_GET['Search']['parking'],false, "AND");
			if(!empty($_GET['Search']['closet']))
			$criteria->addSearchCondition('closet', $_GET['Search']['closet'],false, "AND");
			if(!empty($_GET['Search']['roof']))
			$criteria->addSearchCondition('roof', $_GET['Search']['roof'],false, "AND");
			if(!empty($_GET['Search']['number_receptions']))
			$criteria->addSearchCondition('number_receptions', $_GET['Search']['number_receptions'],false, "AND");
			if(!empty($_GET['Search']['number_rooms']))
			$criteria->addSearchCondition('number_rooms', $_GET['Search']['number_rooms'],false, "AND");
			if(!empty($_GET['Search']['number_terace']))
			$criteria->addSearchCondition('number_terace', $_GET['Search']['number_terace'],false, "AND");
			if(!empty($_GET['Search']['number_baths']))
			$criteria->addSearchCondition('number_baths', $_GET['Search']['number_baths'],false, "AND");
			if(!empty($_GET['Search']['number_kitchen']))
			$criteria->addSearchCondition('number_kitchen', $_GET['Search']['number_kitchen'],false, "AND");

		
			$visible = 1;
			$alltypebuliding = TypeBuliding::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));

			$allfloor = Floor::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));


			$allunits = Units::model()->findAll($criteria);

					
		} else{

                
                 
		}




                
		$this->render('searchresultbr', array(
											
				'lead' => $lead,						
				'allunits' => $allunits ,					
				'alllike' => $alllike,
				'alltypebuliding'=>$alltypebuliding ,	
				'allfloor'=>$allfloor ,
                        

											
			));
			
			
	}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
			
			
	}















		
		
		
		
	
		
		
		







		
		
		
		
		
		
		
		

	public function actionDownloadpdf4activities($secret){   
	    
	    
	    if(Yii::app()->user->isMember()){
	    
		$model=DailyDate::model()->findByAttributes(array('secret'=>$secret));




                        $criteria = new CDbCriteria;
			$criteria->condition .= "close IS NULL";
			$criteria->addSearchCondition('follow_date' , $model->second_date);

			$allactivities=Activities::model()->findAll($criteria);


		
		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 
		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
		//$mpdf->autoLangToFont = false;
		//$mpdf->autoArabic = false;
		//$mpdf->charset_in='utf-8';
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');
		$html = $this->renderPartial('_result2',array('allactivities'=>$allactivities,
				'today' => $today,'time' => $time), true);
		$main=Mainsettings::model()->findByPk(1);	    
		$mpdf1 = new mPDF('s','A4','','',10,10,80,35,10,10);
		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
		$mpdf1->SetProtection(array('print'));
		$mpdf1->SetTitle('search Result-');
		$mpdf1->SetAuthor("Brandshtine.");
		//$mpdf1->SetWatermarkText("");
		//$mpdf1->showWatermarkText = true;
		//$mpdf1->watermark_font = 'DejaVuSansCondensed';
		//$mpdf1->watermarkTextAlpha = 0.1;
		$mpdf1->SetDisplayMode('fullpage');
		$mpdf1->SetAutoFont('4');		  
		$mpdf1->WriteHTML($html);
		$file_name= 'Activities Result.pdf';
		ob_end_clean();
		$mpdf1->Output($file_name,'D' );
	    }else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
	}



public function actionDownloadpdf4activitiesuser($secret){  
    
     if(Yii::app()->user->isMember()){
		$model=DailyDate::model()->findByAttributes(array('secret'=>$secret));




                        $criteria = new CDbCriteria;
			$criteria->condition .= "close IS NULL";
			$start = date('Y-m-d', strtotime("+1 days"));
			$criteria->addSearchCondition('follow_date' , $model->second_date);
			$criteria->addCondition('user_id=' . $model->user_id);

			$allactivities=Activities::model()->findAll($criteria);


		
		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 
		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
		//$mpdf->autoLangToFont = false;
		//$mpdf->autoArabic = false;
		//$mpdf->charset_in='utf-8';
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');
		$html = $this->renderPartial('_result2',array('allactivities'=>$allactivities,
				'today' => $today,'time' => $time), true);
		$main=Mainsettings::model()->findByPk(1);	    
		$mpdf1 = new mPDF('s','A4','','',10,10,80,35,10,10);
		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
		$mpdf1->SetProtection(array('print'));
		$mpdf1->SetTitle('search Result-');
		$mpdf1->SetAuthor("Brandshtine.");
		//$mpdf1->SetWatermarkText("");
		//$mpdf1->showWatermarkText = true;
		//$mpdf1->watermark_font = 'DejaVuSansCondensed';
		//$mpdf1->watermarkTextAlpha = 0.1;
		$mpdf1->SetDisplayMode('fullpage');
		$mpdf1->SetAutoFont('4');		  
		$mpdf1->WriteHTML($html);
		$file_name= 'Activities Result.pdf';
		ob_end_clean();
		$mpdf1->Output($file_name,'D' );	
		
		
		
}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
		
	}



	public function actionDownloadpdf($secret){     
	    
	    if(Yii::app()->user->isMember()){
	    
		$model=DailyDate::model()->findByAttributes(array('secret'=>$secret));
		$criteria = new CDbCriteria();
		$criteria->order = 'id DESC';
		$criteria->addBetweenCondition("date",$model->first_date,$model->second_date);
		$allleadss = Leads::model()->findAll($criteria);    
		$visible=1;
		$allcampaign= Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allproject = Projects::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
		$allstatues= Statues::model()->findAll();
		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 
		$mpdf= Yii::app()->ePdf->mpdf('ar-s');
		//$mpdf->autoLangToFont = false;
		//$mpdf->autoArabic = false;
		//$mpdf->charset_in='utf-8';
		ini_set('max_execution_time', 300);
		ini_set('memory_limit', '-1');
		$html = $this->renderPartial('_result',array('allleadss'=>$allleadss,'allcampaign'=>$allcampaign,'allproject' => $allproject,'allsales' => 
				$allsales,'allstatues' => $allstatues,
				'today' => $today,'time' => $time), true);
		$main=Mainsettings::model()->findByPk(1);	    
		$mpdf1 = new mPDF('s','A4','','',10,10,80,35,10,10);
		$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
		$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');
		$mpdf1->SetProtection(array('print'));
		$mpdf1->SetTitle('search Result-');
		$mpdf1->SetAuthor("Brandshtine.");
		//$mpdf1->SetWatermarkText("");
		//$mpdf1->showWatermarkText = true;
		//$mpdf1->watermark_font = 'DejaVuSansCondensed';
		//$mpdf1->watermarkTextAlpha = 0.1;
		$mpdf1->SetDisplayMode('fullpage');
		$mpdf1->SetAutoFont('4');		  
		$mpdf1->WriteHTML($html);
		$file_name= 'Search Result.pdf';
		ob_end_clean();
		$mpdf1->Output($file_name,'D' );
		
		
			
		
}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
		
	}

		
	



public function actionActivitiessearch(){
    
    
    if(Yii::app()->user->isMember()){
         //var_dump('44');exit;	    


	$userid=Yii::app()->user->id;
	$user=User::model()->findByPk($userid);
	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
	$today = date("Y-m-d");                     // 03.10.01
	$time = date("H:i:s"); 

$this->layout = '//layouts/systemcgridview';
	if(isset($_REQUEST['search'])){


$arrayofinfo=array('details'=>$_REQUEST['search'],'startdate'=>$_REQUEST['startdate'],'enddate'=>$_REQUEST['enddate'],'startfollowdate'=>$_REQUEST['startfollowdate'],'endfollowdate'=>$_REQUEST['endfollowdate'],'status'=>$_REQUEST['status'],'tel'=>$_REQUEST['tel']);
		
		
		$criteria = new CDbCriteria();
		$criteria->order = 'id DESC';
		$criteria->addCondition('user_id=' . $userid);


	if(!empty($_REQUEST['details']) ){
				$criteria->addSearchCondition('details', $_REQUEST['details'],TRUE, "AND");
			}
		


       if(!empty($_REQUEST['startfollowdate']) AND !empty($_REQUEST['endfollowdate'])){
           $criteria->condition = "close IS NULL ";
			$criteria->addSearchCondition('user_id', $userid,false, "AND");
			$criteria->addBetweenCondition("follow_date",$_REQUEST['startfollowdate'],$_REQUEST['endfollowdate'],'AND');
			
				if(!empty($_REQUEST['search']) ){
			$criteria->addSearchCondition('name', $_REQUEST['search'],TRUE, "AND");
		}
		if(!empty($_REQUEST['tel']) ){

$phone= $_REQUEST['tel'];
if($phone[0]=='0')
    $phone = substr($phone , 1);
$countrys = [
							'44' => 'UK (+44)',
							'213' => 'Algeria (+213)',
							'376' => 'Andorra (+376)',
							'244' => 'Angola (+244)',
							'1264' => 'Anguilla (+1264)',
							'1268' => 'Antigua & Barbuda (+1268)',
							'54' => 'Argentina (+54)',
							'374' => 'Armenia (+374)',
							'297' => 'Aruba (+297)',
							'61' => 'Australia (+61)',
							'43' => 'Austria (+43)',
							'994' => 'Azerbaijan (+994)',
							'1242' => 'Bahamas (+1242)',
							'973' => 'Bahrain (+973)',
							'880' => 'Bangladesh (+880)',
							'1246' => 'Barbados (+1246)',
							'375' => 'Belarus (+375)',
							'32' => 'Belgium (+32)',
							'501' => 'Belize (+501)',
							'229' => 'Benin (+229)',
							'1441' => 'Bermuda (+1441)',
							'975' => 'Bhutan (+975)',
							'591' => 'Bolivia (+591)',
							'387' => 'Bosnia Herzegovina (+387)',
							'267' => 'Botswana (+267)',
							'55' => 'Brazil (+55)',
							'673' => 'Brunei (+673)',
							'359' => 'Bulgaria (+359)',
							'226' => 'Burkina Faso (+226)',
							'257' => 'Burundi (+257)',
							'855' => 'Cambodia (+855)',
							'237' => 'Cameroon (+237)',
							'238' => 'Cape Verde Islands (+238)',
							'1345' => 'Cayman Islands (+1345)',
							'236' => 'Central African Republic (+236)',
							'56' => 'Chile (+56)',
							'86' => 'China (+86)',
							'57' => 'Colombia (+57)',
							'269' => 'Comoros (+269)',
							'242' => 'Congo (+242)',
							'682' => 'Cook Islands (+682)',
							'506' => 'Costa Rica (+506)','225' => 'Cote d Ivoire (+225)',
							'385' => 'Croatia (+385)',
							'53' => 'Cuba (+53)',
							'90392' => 'Cyprus North (+90392)',
							'357' => 'Cyprus South (+357)',
							'420' => 'Czech Republic (+420)',
							'45' => 'Denmark (+45)',
							'253' => 'Djibouti (+253)',
							'1809' => 'Dominica (+1809)',
							'1809' => 'Dominican Republic (+1809)',
							'593' => 'Ecuador (+593)',
							'20' => 'Egypt (+20)',
							'503' => 'El Salvador (+503)',
							'240' => 'Equatorial Guinea (+240)',
							'291' => 'Eritrea (+291)',
							'372' => 'Estonia (+372)',
							'251' => 'Ethiopia (+251)',
							'500' => 'Falkland Islands (+500)',
							'298' => 'Faroe Islands (+298)',
							'679' => 'Fiji (+679)',
							'358' => 'Finland (+358)',
							'33' => 'France (+33)',
							'594' => 'French Guiana (+594)',
							'689' => 'French Polynesia (+689)',
							'241' => 'Gabon (+241)',
							'220' => 'Gambia (+220)',
							'995' => 'Georgia (+995)',
							'49' => 'Germany (+49)',
							'233' => 'Ghana (+233)',
							'350' => 'Gibraltar (+350)',
							'30' => 'Greece (+30)',
							'299' => 'Greenland (+299)',
							'1473' => 'Grenada (+1473)',
							'590' => 'Guadeloupe (+590)',
							'671' => 'Guam (+671)',
							'502' => 'Guatemala (+502)',
							'224' => 'Guinea (+224)',
							'245' => 'Guinea - Bissau (+245)',
							'592' => 'Guyana (+592)',
							'509' => 'Haiti (+509)',
							'504' => 'Honduras (+504)',
							'852' => 'Hong Kong (+852)',
							'36' => 'Hungary (+36)',
							'354' => 'Iceland (+354)',
							'91' => 'India (+91)',
							'62' => 'Indonesia (+62)',
							'98' => 'Iran (+98)',
							'964' => 'Iraq (+964)',
							'353' => 'Ireland (+353)',
							'39' => 'Italy (+39)','972' => 'Israel (+972)',
							'1876' => 'Jamaica (+1876)',
							'81' => 'Japan (+81)',
							'962' => 'Jordan (+962)',
							'7' => 'Kazakhstan (+7)',
							'254' => 'Kenya (+254)',
							'686' => 'Kiribati (+686)',
							'850' => 'Korea North (+850)',
							'82' => 'Korea South (+82)',
							'965' => 'Kuwait (+965)',
							'996' => 'Kyrgyzstan (+996)',
							'856' => 'Laos (+856)',
							'371' => 'Latvia (+371)',
							'961' => 'Lebanon (+961)',
							'266' => 'Lesotho (+266)',
							'231' => 'Liberia (+231)',
							'218' => 'Libya (+218)',
							'417' => 'Liechtenstein (+417)',
							'370' => 'Lithuania (+370)',
							'352' => 'Luxembourg (+352)',
							'853' => 'Macao (+853)',
							'389' => 'Macedonia (+389)',
							'261' => 'Madagascar (+261)',
							'265' => 'Malawi (+265)',
							'60' => 'Malaysia (+60)',
							'960' => 'Maldives (+960)',
							'223' => 'Mali (+223)',
							'356' => 'Malta (+356)',
							'692' => 'Marshall Islands (+692)',
							'596' => 'Martinique (+596)',
							'222' => 'Mauritania (+222)',
							'269' => 'Mayotte (+269)',
							'52' => 'Mexico (+52)',
							'691' => 'Micronesia (+691)',
							'373' => 'Moldova (+373)',
							'377' => 'Monaco (+377)',
							'976' => 'Mongolia (+976)',
							'1664' => 'Montserrat (+1664)',
							'212' => 'Morocco (+212)',
							'258' => 'Mozambique (+258)',
							'95' => 'Myanmar (+95)',
							'264' => 'Namibia (+264)',
							'674' => 'Nauru (+674)',
							'977' => 'Nepal (+977)',
							'31' => 'Netherlands (+31)',
							'687' => 'New Caledonia (+687)',
							'64' => 'New Zealand (+64)',
							'505' => 'Nicaragua (+505)',
							'227' => 'Niger (+227)',
							'234' => 'Nigeria (+234)',
							'683' => 'Niue (+683)',
							'672' => 'Norfolk Islands (+672)',
							'670' => 'Northern Marianas (+670)',
							'47' => 'Norway (+47)',
							'968' => 'Oman (+968)',
							'680' => 'Palau (+680)','970' => 'Palestine (+970)',
							'507' => 'Panama (+507)',
							'675' => 'Papua New Guinea (+675)',
							'595' => 'Paraguay (+595)',
							'51' => 'Peru (+51)',
							'63' => 'Philippines (+63)',
							'48' => 'Poland (+48)',
							'351' => 'Portugal (+351)',
							'1787' => 'Puerto Rico (+1787)',
							'974' => 'Qatar (+974)',
							'262' => 'Reunion (+262)',
							'40' => 'Romania (+40)',
							'7' => 'Russia (+7)',
							'250' => 'Rwanda (+250)',
							'378' => 'San Marino (+378)',
							'239' => 'Sao Tome & Principe (+239)',
							'966' => 'Saudi Arabia (+966)',
							'221' => 'Senegal (+221)',
							'381' => 'Serbia (+381)',
							'248' => 'Seychelles (+248)',
							'232' => 'Sierra Leone (+232)',
							'65' => 'Singapore (+65)',
							'421' => 'Slovak Republic (+421)',
							'386' => 'Slovenia (+386)',
							'677' => 'Solomon Islands (+677)',
							'252' => 'Somalia (+252)',
							'27' => 'South Africa (+27)',
							'34' => 'Spain (+34)',
							'94' => 'Sri Lanka (+94)',
							'290' => 'St. Helena (+290)',
							'1869' => 'St. Kitts (+1869)',
							'1758' => 'St. Lucia (+1758)',
							'249' => 'Sudan (+249)','211' => 'South Sudan (+211)',
							'597' => 'Suriname (+597)',
							'268' => 'Swaziland (+268)',
							'46' => 'Sweden (+46)',
							'41' => 'Switzerland (+41)',
							'963' => 'Syria (+963)',
							'886' => 'Taiwan (+886)',
							'7' => 'Tajikstan (+7)',
							'66' => 'Thailand (+66)',
							'228' => 'Togo (+228)',
							'676' => 'Tonga (+676)',
							'1868' => 'Trinidad & Tobago (+1868)',
							'216' => 'Tunisia (+216)',
							'90' => 'Turkey (+90)',
							'7' => 'Turkmenistan (+7)',
							'993' => 'Turkmenistan (+993)',
							'1649' => 'Turks & Caicos Islands (+1649)',
							'688' => 'Tuvalu (+688)',
							'256' => 'Uganda (+256)',
							'380' => 'Ukraine (+380)',
							'971' => 'United Arab Emirates (+971)',
							'598' => 'Uruguay (+598)',
							'7' => 'Uzbekistan (+7)',
							'678' => 'Vanuatu (+678)',
							'379' => 'Vatican City (+379)',
							'58' => 'Venezuela (+58)',
							'84' => 'Vietnam (+84)',
							'84' => 'Virgin Islands - British (+1284)',
							'84' => 'Virgin Islands - US (+1340)',
							'681' => 'Wallis & Futuna (+681)',
							'969' => 'Yemen (North)(+969)',
							'967' => 'Yemen (South)(+967)',
							'260' => 'Zambia (+260)',
							'263' => 'Zimbabwe (+263)',
						];

						$temp=  substr(strstr($phone, '+'),1);
					if($temp != false){$phone=$temp;}
                                                $countrycode='';
						// sort the array by key, descending
						krsort($countrys, SORT_NUMERIC);

						// iterate over all countries
						foreach($countrys as $we => $ccode){
							// if number begins with current number
							if(strpos($phone, '' . $we) === 0){
								// store country code and break the loop
								$countrycode = $we;
								break;
							}
						}

						if(!empty($countrycode)){
							$size=strlen($countrycode);
							$phone=substr($phone,$size);
						}



				$criteria->addSearchCondition('tel', $phone ,false, "AND");


		}
		
		
			if(!empty($_REQUEST['star'])){
			    
			    //var_dump($_REQUEST['star']);exit;
    			if($_REQUEST['star']==1){
    				$criteria->addSearchCondition('star', $_REQUEST['star'],false, "AND");
    			}else if($_REQUEST['star']==2){
    				$criteria->addCondition('star IS NULL');
    			}else{
    			}
			}
		
		
		
		if(sizeOf((array)$_REQUEST['status'])>1){
			$intArray6 = array_map(
				function($value6){ return (int)$value6; },
				$_REQUEST['status']
			);
			$criteria->addInCondition('status', $_REQUEST['status'] , "AND");
		}
		if(sizeOf((array)$_REQUEST['type'])>1){
			$intArray6 = array_map(
				function($value6){ return (int)$value6; },
				$_REQUEST['status']
			);
			$criteria->addInCondition('type', $_REQUEST['type'] , "AND");
		}
			
			


		}
		    $criteria->addSearchCondition('user_id', $userid,false, "AND");
			$criteria->addBetweenCondition("date",$_REQUEST['startdate'],$_REQUEST['enddate'],'AND');
			
				if(!empty($_REQUEST['search']) ){
			$criteria->addSearchCondition('name', $_REQUEST['search'],TRUE, "AND");
		}
		if(!empty($_REQUEST['tel']) ){

$phone= $_REQUEST['tel'];
if($phone[0]=='0')
    $phone = substr($phone , 1);
$countrys = [
							'44' => 'UK (+44)',
							'213' => 'Algeria (+213)',
							'376' => 'Andorra (+376)',
							'244' => 'Angola (+244)',
							'1264' => 'Anguilla (+1264)',
							'1268' => 'Antigua & Barbuda (+1268)',
							'54' => 'Argentina (+54)',
							'374' => 'Armenia (+374)',
							'297' => 'Aruba (+297)',
							'61' => 'Australia (+61)',
							'43' => 'Austria (+43)',
							'994' => 'Azerbaijan (+994)',
							'1242' => 'Bahamas (+1242)',
							'973' => 'Bahrain (+973)',
							'880' => 'Bangladesh (+880)',
							'1246' => 'Barbados (+1246)',
							'375' => 'Belarus (+375)',
							'32' => 'Belgium (+32)',
							'501' => 'Belize (+501)',
							'229' => 'Benin (+229)',
							'1441' => 'Bermuda (+1441)',
							'975' => 'Bhutan (+975)',
							'591' => 'Bolivia (+591)',
							'387' => 'Bosnia Herzegovina (+387)',
							'267' => 'Botswana (+267)',
							'55' => 'Brazil (+55)',
							'673' => 'Brunei (+673)',
							'359' => 'Bulgaria (+359)',
							'226' => 'Burkina Faso (+226)',
							'257' => 'Burundi (+257)',
							'855' => 'Cambodia (+855)',
							'237' => 'Cameroon (+237)',
							'238' => 'Cape Verde Islands (+238)',
							'1345' => 'Cayman Islands (+1345)',
							'236' => 'Central African Republic (+236)',
							'56' => 'Chile (+56)',
							'86' => 'China (+86)',
							'57' => 'Colombia (+57)',
							'269' => 'Comoros (+269)',
							'242' => 'Congo (+242)',
							'682' => 'Cook Islands (+682)',
							'506' => 'Costa Rica (+506)','225' => 'Cote d Ivoire (+225)',
							'385' => 'Croatia (+385)',
							'53' => 'Cuba (+53)',
							'90392' => 'Cyprus North (+90392)',
							'357' => 'Cyprus South (+357)',
							'420' => 'Czech Republic (+420)',
							'45' => 'Denmark (+45)',
							'253' => 'Djibouti (+253)',
							'1809' => 'Dominica (+1809)',
							'1809' => 'Dominican Republic (+1809)',
							'593' => 'Ecuador (+593)',
							'20' => 'Egypt (+20)',
							'503' => 'El Salvador (+503)',
							'240' => 'Equatorial Guinea (+240)',
							'291' => 'Eritrea (+291)',
							'372' => 'Estonia (+372)',
							'251' => 'Ethiopia (+251)',
							'500' => 'Falkland Islands (+500)',
							'298' => 'Faroe Islands (+298)',
							'679' => 'Fiji (+679)',
							'358' => 'Finland (+358)',
							'33' => 'France (+33)',
							'594' => 'French Guiana (+594)',
							'689' => 'French Polynesia (+689)',
							'241' => 'Gabon (+241)',
							'220' => 'Gambia (+220)',
							'995' => 'Georgia (+995)',
							'49' => 'Germany (+49)',
							'233' => 'Ghana (+233)',
							'350' => 'Gibraltar (+350)',
							'30' => 'Greece (+30)',
							'299' => 'Greenland (+299)',
							'1473' => 'Grenada (+1473)',
							'590' => 'Guadeloupe (+590)',
							'671' => 'Guam (+671)',
							'502' => 'Guatemala (+502)',
							'224' => 'Guinea (+224)',
							'245' => 'Guinea - Bissau (+245)',
							'592' => 'Guyana (+592)',
							'509' => 'Haiti (+509)',
							'504' => 'Honduras (+504)',
							'852' => 'Hong Kong (+852)',
							'36' => 'Hungary (+36)',
							'354' => 'Iceland (+354)',
							'91' => 'India (+91)',
							'62' => 'Indonesia (+62)',
							'98' => 'Iran (+98)',
							'964' => 'Iraq (+964)',
							'353' => 'Ireland (+353)',
							'39' => 'Italy (+39)','972' => 'Israel (+972)',
							'1876' => 'Jamaica (+1876)',
							'81' => 'Japan (+81)',
							'962' => 'Jordan (+962)',
							'7' => 'Kazakhstan (+7)',
							'254' => 'Kenya (+254)',
							'686' => 'Kiribati (+686)',
							'850' => 'Korea North (+850)',
							'82' => 'Korea South (+82)',
							'965' => 'Kuwait (+965)',
							'996' => 'Kyrgyzstan (+996)',
							'856' => 'Laos (+856)',
							'371' => 'Latvia (+371)',
							'961' => 'Lebanon (+961)',
							'266' => 'Lesotho (+266)',
							'231' => 'Liberia (+231)',
							'218' => 'Libya (+218)',
							'417' => 'Liechtenstein (+417)',
							'370' => 'Lithuania (+370)',
							'352' => 'Luxembourg (+352)',
							'853' => 'Macao (+853)',
							'389' => 'Macedonia (+389)',
							'261' => 'Madagascar (+261)',
							'265' => 'Malawi (+265)',
							'60' => 'Malaysia (+60)',
							'960' => 'Maldives (+960)',
							'223' => 'Mali (+223)',
							'356' => 'Malta (+356)',
							'692' => 'Marshall Islands (+692)',
							'596' => 'Martinique (+596)',
							'222' => 'Mauritania (+222)',
							'269' => 'Mayotte (+269)',
							'52' => 'Mexico (+52)',
							'691' => 'Micronesia (+691)',
							'373' => 'Moldova (+373)',
							'377' => 'Monaco (+377)',
							'976' => 'Mongolia (+976)',
							'1664' => 'Montserrat (+1664)',
							'212' => 'Morocco (+212)',
							'258' => 'Mozambique (+258)',
							'95' => 'Myanmar (+95)',
							'264' => 'Namibia (+264)',
							'674' => 'Nauru (+674)',
							'977' => 'Nepal (+977)',
							'31' => 'Netherlands (+31)',
							'687' => 'New Caledonia (+687)',
							'64' => 'New Zealand (+64)',
							'505' => 'Nicaragua (+505)',
							'227' => 'Niger (+227)',
							'234' => 'Nigeria (+234)',
							'683' => 'Niue (+683)',
							'672' => 'Norfolk Islands (+672)',
							'670' => 'Northern Marianas (+670)',
							'47' => 'Norway (+47)',
							'968' => 'Oman (+968)',
							'680' => 'Palau (+680)','970' => 'Palestine (+970)',
							'507' => 'Panama (+507)',
							'675' => 'Papua New Guinea (+675)',
							'595' => 'Paraguay (+595)',
							'51' => 'Peru (+51)',
							'63' => 'Philippines (+63)',
							'48' => 'Poland (+48)',
							'351' => 'Portugal (+351)',
							'1787' => 'Puerto Rico (+1787)',
							'974' => 'Qatar (+974)',
							'262' => 'Reunion (+262)',
							'40' => 'Romania (+40)',
							'7' => 'Russia (+7)',
							'250' => 'Rwanda (+250)',
							'378' => 'San Marino (+378)',
							'239' => 'Sao Tome & Principe (+239)',
							'966' => 'Saudi Arabia (+966)',
							'221' => 'Senegal (+221)',
							'381' => 'Serbia (+381)',
							'248' => 'Seychelles (+248)',
							'232' => 'Sierra Leone (+232)',
							'65' => 'Singapore (+65)',
							'421' => 'Slovak Republic (+421)',
							'386' => 'Slovenia (+386)',
							'677' => 'Solomon Islands (+677)',
							'252' => 'Somalia (+252)',
							'27' => 'South Africa (+27)',
							'34' => 'Spain (+34)',
							'94' => 'Sri Lanka (+94)',
							'290' => 'St. Helena (+290)',
							'1869' => 'St. Kitts (+1869)',
							'1758' => 'St. Lucia (+1758)',
							'249' => 'Sudan (+249)','211' => 'South Sudan (+211)',
							'597' => 'Suriname (+597)',
							'268' => 'Swaziland (+268)',
							'46' => 'Sweden (+46)',
							'41' => 'Switzerland (+41)',
							'963' => 'Syria (+963)',
							'886' => 'Taiwan (+886)',
							'7' => 'Tajikstan (+7)',
							'66' => 'Thailand (+66)',
							'228' => 'Togo (+228)',
							'676' => 'Tonga (+676)',
							'1868' => 'Trinidad & Tobago (+1868)',
							'216' => 'Tunisia (+216)',
							'90' => 'Turkey (+90)',
							'7' => 'Turkmenistan (+7)',
							'993' => 'Turkmenistan (+993)',
							'1649' => 'Turks & Caicos Islands (+1649)',
							'688' => 'Tuvalu (+688)',
							'256' => 'Uganda (+256)',
							'380' => 'Ukraine (+380)',
							'971' => 'United Arab Emirates (+971)',
							'598' => 'Uruguay (+598)',
							'7' => 'Uzbekistan (+7)',
							'678' => 'Vanuatu (+678)',
							'379' => 'Vatican City (+379)',
							'58' => 'Venezuela (+58)',
							'84' => 'Vietnam (+84)',
							'84' => 'Virgin Islands - British (+1284)',
							'84' => 'Virgin Islands - US (+1340)',
							'681' => 'Wallis & Futuna (+681)',
							'969' => 'Yemen (North)(+969)',
							'967' => 'Yemen (South)(+967)',
							'260' => 'Zambia (+260)',
							'263' => 'Zimbabwe (+263)',
						];

						$temp=  substr(strstr($phone, '+'),1);
					if($temp != false){$phone=$temp;}
                                                $countrycode='';
						// sort the array by key, descending
						krsort($countrys, SORT_NUMERIC);

						// iterate over all countries
						foreach($countrys as $we => $ccode){
							// if number begins with current number
							if(strpos($phone, '' . $we) === 0){
								// store country code and break the loop
								$countrycode = $we;
								break;
							}
						}

						if(!empty($countrycode)){
							$size=strlen($countrycode);
							$phone=substr($phone,$size);
						}



				$criteria->addSearchCondition('tel', $phone ,false, "AND");


		}
		
		if(sizeOf((array)$_REQUEST['status'])>1){
		    
		    
		   // var_dump('s');exit;
			$intArray6 = array_map(
				function($value6){ return (int)$value6; },
				$_REQUEST['status']
			);
			$criteria->addInCondition('status', $_REQUEST['status'] , "AND");
		}
		
	
		
		
		if(sizeOf((array)$_REQUEST['type'])>1){
			$intArray6 = array_map(
				function($value6){ return (int)$value6; },
				$_REQUEST['status']
			);
			$criteria->addInCondition('type', $_REQUEST['type'] , "AND");
		}
			

		

		
			$total = Activities::model()->count($criteria);
$count=$total;
			$pages = new CPagination($total);
			$pages->pageSize = 50;
			$pages->applyLimit($criteria);

		        $allact = Activities::model()->findAll($criteria);
			$allstatues=Statues::model()->findAll(); 

					
	} 





		
		

	$this->render('activitiessearch', array(
											
			'allact' => $allact,					
			'arrayofinfo' => $arrayofinfo,			
			'pages' => $pages,			
			'count' => $count,			
			'total' => $total,		
			'allstatues' => $allstatues,
    

											
		));
		
		
		
		
    }else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
		
		
}



		


public function actionTransfersearch(){
    
    
    if(Yii::app()->user->isMember()){


	$userid=Yii::app()->user->id;
	$user=User::model()->findByPk($userid);
	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
	$today = date("Y-m-d");                     // 03.10.01
	$time = date("H:i:s"); 

	if(isset($_GET['Search'])){


$arrayofinfo=array(
'title'=>$_REQUEST['Search']['title'],
'tel'=>$_REQUEST['Search']['tel'],
'secondtel'=>$_REQUEST['Search']['secondtel'],
'campaign'=>$_REQUEST['Search']['campaign'],
'receipt'=>$_REQUEST['Search']['receipt'],
'communication'=>$_REQUEST['Search']['communication'],
'close'=>$_REQUEST['Search']['close'],
'duplicate'=>$_REQUEST['Search']['duplicate'],
'platform'=>$_REQUEST['Search']['platform'],
'place'=>$_REQUEST['Search']['place'],
'status'=>$_REQUEST['Search']['status'],
'startdate'=>$_REQUEST['Search']['startdate'],
'enddate'=>$_REQUEST['Search']['enddate']
);


			$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
			$criteria->addSearchCondition('user_sales', $userid ,false, "AND");
			$criteria->addSearchCondition('hidden=' . 1, false);
			$criteria->addCondition('transfer=' . 1 );
			$criteria->addCondition('close IS NULL');
			if(!empty($_GET['Search']['title']))
			$criteria->addSearchCondition('title', $_GET['Search']['title'],TRUE, "AND");
			if(!empty($_GET['Search']['tel'])){

$phone= $_GET['Search']['tel'] ;
if($phone[0]=='0')
    $phone = substr($phone , 1);
$countrys = [
							'44' => 'UK (+44)',
							'213' => 'Algeria (+213)',
							'376' => 'Andorra (+376)',
							'244' => 'Angola (+244)',
							'1264' => 'Anguilla (+1264)',
							'1268' => 'Antigua & Barbuda (+1268)',
							'54' => 'Argentina (+54)',
							'374' => 'Armenia (+374)',
							'297' => 'Aruba (+297)',
							'61' => 'Australia (+61)',
							'43' => 'Austria (+43)',
							'994' => 'Azerbaijan (+994)',
							'1242' => 'Bahamas (+1242)',
							'973' => 'Bahrain (+973)',
							'880' => 'Bangladesh (+880)',
							'1246' => 'Barbados (+1246)',
							'375' => 'Belarus (+375)',
							'32' => 'Belgium (+32)',
							'501' => 'Belize (+501)',
							'229' => 'Benin (+229)',
							'1441' => 'Bermuda (+1441)',
							'975' => 'Bhutan (+975)',
							'591' => 'Bolivia (+591)',
							'387' => 'Bosnia Herzegovina (+387)',
							'267' => 'Botswana (+267)',
							'55' => 'Brazil (+55)',
							'673' => 'Brunei (+673)',
							'359' => 'Bulgaria (+359)',
							'226' => 'Burkina Faso (+226)',
							'257' => 'Burundi (+257)',
							'855' => 'Cambodia (+855)',
							'237' => 'Cameroon (+237)',
							'238' => 'Cape Verde Islands (+238)',
							'1345' => 'Cayman Islands (+1345)',
							'236' => 'Central African Republic (+236)',
							'56' => 'Chile (+56)',
							'86' => 'China (+86)',
							'57' => 'Colombia (+57)',
							'269' => 'Comoros (+269)',
							'242' => 'Congo (+242)',
							'682' => 'Cook Islands (+682)',
							'506' => 'Costa Rica (+506)','225' => 'Cote d Ivoire (+225)',
							'385' => 'Croatia (+385)',
							'53' => 'Cuba (+53)',
							'90392' => 'Cyprus North (+90392)',
							'357' => 'Cyprus South (+357)',
							'420' => 'Czech Republic (+420)',
							'45' => 'Denmark (+45)',
							'253' => 'Djibouti (+253)',
							'1809' => 'Dominica (+1809)',
							'1809' => 'Dominican Republic (+1809)',
							'593' => 'Ecuador (+593)',
							'20' => 'Egypt (+20)',
							'503' => 'El Salvador (+503)',
							'240' => 'Equatorial Guinea (+240)',
							'291' => 'Eritrea (+291)',
							'372' => 'Estonia (+372)',
							'251' => 'Ethiopia (+251)',
							'500' => 'Falkland Islands (+500)',
							'298' => 'Faroe Islands (+298)',
							'679' => 'Fiji (+679)',
							'358' => 'Finland (+358)',
							'33' => 'France (+33)',
							'594' => 'French Guiana (+594)',
							'689' => 'French Polynesia (+689)',
							'241' => 'Gabon (+241)',
							'220' => 'Gambia (+220)',
							'995' => 'Georgia (+995)',
							'49' => 'Germany (+49)',
							'233' => 'Ghana (+233)',
							'350' => 'Gibraltar (+350)',
							'30' => 'Greece (+30)',
							'299' => 'Greenland (+299)',
							'1473' => 'Grenada (+1473)',
							'590' => 'Guadeloupe (+590)',
							'671' => 'Guam (+671)',
							'502' => 'Guatemala (+502)',
							'224' => 'Guinea (+224)',
							'245' => 'Guinea - Bissau (+245)',
							'592' => 'Guyana (+592)',
							'509' => 'Haiti (+509)',
							'504' => 'Honduras (+504)',
							'852' => 'Hong Kong (+852)',
							'36' => 'Hungary (+36)',
							'354' => 'Iceland (+354)',
							'91' => 'India (+91)',
							'62' => 'Indonesia (+62)',
							'98' => 'Iran (+98)',
							'964' => 'Iraq (+964)',
							'353' => 'Ireland (+353)',
							'39' => 'Italy (+39)','972' => 'Israel (+972)',
							'1876' => 'Jamaica (+1876)',
							'81' => 'Japan (+81)',
							'962' => 'Jordan (+962)',
							'7' => 'Kazakhstan (+7)',
							'254' => 'Kenya (+254)',
							'686' => 'Kiribati (+686)',
							'850' => 'Korea North (+850)',
							'82' => 'Korea South (+82)',
							'965' => 'Kuwait (+965)',
							'996' => 'Kyrgyzstan (+996)',
							'856' => 'Laos (+856)',
							'371' => 'Latvia (+371)',
							'961' => 'Lebanon (+961)',
							'266' => 'Lesotho (+266)',
							'231' => 'Liberia (+231)',
							'218' => 'Libya (+218)',
							'417' => 'Liechtenstein (+417)',
							'370' => 'Lithuania (+370)',
							'352' => 'Luxembourg (+352)',
							'853' => 'Macao (+853)',
							'389' => 'Macedonia (+389)',
							'261' => 'Madagascar (+261)',
							'265' => 'Malawi (+265)',
							'60' => 'Malaysia (+60)',
							'960' => 'Maldives (+960)',
							'223' => 'Mali (+223)',
							'356' => 'Malta (+356)',
							'692' => 'Marshall Islands (+692)',
							'596' => 'Martinique (+596)',
							'222' => 'Mauritania (+222)',
							'269' => 'Mayotte (+269)',
							'52' => 'Mexico (+52)',
							'691' => 'Micronesia (+691)',
							'373' => 'Moldova (+373)',
							'377' => 'Monaco (+377)',
							'976' => 'Mongolia (+976)',
							'1664' => 'Montserrat (+1664)',
							'212' => 'Morocco (+212)',
							'258' => 'Mozambique (+258)',
							'95' => 'Myanmar (+95)',
							'264' => 'Namibia (+264)',
							'674' => 'Nauru (+674)',
							'977' => 'Nepal (+977)',
							'31' => 'Netherlands (+31)',
							'687' => 'New Caledonia (+687)',
							'64' => 'New Zealand (+64)',
							'505' => 'Nicaragua (+505)',
							'227' => 'Niger (+227)',
							'234' => 'Nigeria (+234)',
							'683' => 'Niue (+683)',
							'672' => 'Norfolk Islands (+672)',
							'670' => 'Northern Marianas (+670)',
							'47' => 'Norway (+47)',
							'968' => 'Oman (+968)',
							'680' => 'Palau (+680)','970' => 'Palestine (+970)',
							'507' => 'Panama (+507)',
							'675' => 'Papua New Guinea (+675)',
							'595' => 'Paraguay (+595)',
							'51' => 'Peru (+51)',
							'63' => 'Philippines (+63)',
							'48' => 'Poland (+48)',
							'351' => 'Portugal (+351)',
							'1787' => 'Puerto Rico (+1787)',
							'974' => 'Qatar (+974)',
							'262' => 'Reunion (+262)',
							'40' => 'Romania (+40)',
							'7' => 'Russia (+7)',
							'250' => 'Rwanda (+250)',
							'378' => 'San Marino (+378)',
							'239' => 'Sao Tome & Principe (+239)',
							'966' => 'Saudi Arabia (+966)',
							'221' => 'Senegal (+221)',
							'381' => 'Serbia (+381)',
							'248' => 'Seychelles (+248)',
							'232' => 'Sierra Leone (+232)',
							'65' => 'Singapore (+65)',
							'421' => 'Slovak Republic (+421)',
							'386' => 'Slovenia (+386)',
							'677' => 'Solomon Islands (+677)',
							'252' => 'Somalia (+252)',
							'27' => 'South Africa (+27)',
							'34' => 'Spain (+34)',
							'94' => 'Sri Lanka (+94)',
							'290' => 'St. Helena (+290)',
							'1869' => 'St. Kitts (+1869)',
							'1758' => 'St. Lucia (+1758)',
							'249' => 'Sudan (+249)','211' => 'South Sudan (+211)',
							'597' => 'Suriname (+597)',
							'268' => 'Swaziland (+268)',
							'46' => 'Sweden (+46)',
							'41' => 'Switzerland (+41)',
							'963' => 'Syria (+963)',
							'886' => 'Taiwan (+886)',
							'7' => 'Tajikstan (+7)',
							'66' => 'Thailand (+66)',
							'228' => 'Togo (+228)',
							'676' => 'Tonga (+676)',
							'1868' => 'Trinidad & Tobago (+1868)',
							'216' => 'Tunisia (+216)',
							'90' => 'Turkey (+90)',
							'7' => 'Turkmenistan (+7)',
							'993' => 'Turkmenistan (+993)',
							'1649' => 'Turks & Caicos Islands (+1649)',
							'688' => 'Tuvalu (+688)',
							'256' => 'Uganda (+256)',
							'380' => 'Ukraine (+380)',
							'971' => 'United Arab Emirates (+971)',
							'598' => 'Uruguay (+598)',
							'7' => 'Uzbekistan (+7)',
							'678' => 'Vanuatu (+678)',
							'379' => 'Vatican City (+379)',
							'58' => 'Venezuela (+58)',
							'84' => 'Vietnam (+84)',
							'84' => 'Virgin Islands - British (+1284)',
							'84' => 'Virgin Islands - US (+1340)',
							'681' => 'Wallis & Futuna (+681)',
							'969' => 'Yemen (North)(+969)',
							'967' => 'Yemen (South)(+967)',
							'260' => 'Zambia (+260)',
							'263' => 'Zimbabwe (+263)',
						];

						$temp=  substr(strstr($phone, '+'),1);
					if($temp != false){$phone=$temp;}
                                                $countrycode='';
						// sort the array by key, descending
						krsort($countrys, SORT_NUMERIC);

						// iterate over all countries
						foreach($countrys as $we => $ccode){
							// if number begins with current number
							if(strpos($phone, '' . $we) === 0){
								// store country code and break the loop
								$countrycode = $we;
								break;
							}
						}

						if(!empty($countrycode)){
							$size=strlen($countrycode);
							$phone=substr($phone,$size);
						}



				$criteria->addSearchCondition('tel', $phone ,false, "AND");


}
			if(!empty($_GET['Search']['secondtel']))
			$criteria->addSearchCondition('secondtel', $_GET['Search']['secondtel'],false, "AND");
			if(!empty($_GET['Search']['campaign']))
			$criteria->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");
			if(!empty($_GET['Search']['receipt']))
			$criteria->addSearchCondition('receipt', $_GET['Search']['receipt'],false, "AND");
			if(!empty($_GET['Search']['communication']))
			$criteria->addSearchCondition('communication', $_GET['Search']['communication'],false, "AND");
			if(!empty($_GET['Search']['close']))
			$criteria->addSearchCondition('close', $_GET['Search']['close'],false, "AND");
			if(!empty($_GET['Search']['duplicate']))
			$criteria->addSearchCondition('duplicate', $_GET['Search']['duplicate'],false, "AND");
			if(!empty($_GET['Search']['platform']))
			$criteria->addSearchCondition('platform_id', $_GET['Search']['platform'],false, "AND");
			if(!empty($_GET['Search']['place']))
			$criteria->addSearchCondition('interest_id', $_GET['Search']['place'],false, "AND");
			if(!empty($_GET['Search']['status']))
			$criteria->addSearchCondition('status', $_GET['Search']['status'],false, "AND");
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');


			$total = Leads::model()->count($criteria);
			$pages = new CPagination($total);
			$pages->pageSize = 50;
			$pages->applyLimit($criteria);

			$allleads = Leads::model()->findAll($criteria);

	
		}




		$visible=1;
		$allcampaign= Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allstatues= Statues::model()->findAll();
		
			$allplaces= Interestedplace::model()->findAll();

		
		

	$this->render('transfered', array(
											
			'userid' => $userid,					
			'pages' => $pages ,					
			'arrayofinfo' => $arrayofinfo,		
			'total' => $total,		
			'allleads' => $allleads,	
			'allcampaign' => $allcampaign,	
			'allplatform' => $allplatform,	
			'allstatues' => $allstatues,	
			'allplaces' => $allplaces,
    

											
		));
		
		
				
    }else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
		
		
		
}











public function actionSearchintegrationteamleader(){
    
    
    if(Yii::app()->user->isMember()){


	$userid=Yii::app()->user->id;
	$user=User::model()->findByPk($userid);
	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
	$today = date("Y-m-d");                     // 03.10.01
	$time = date("H:i:s"); 


	    $this->layout = '//layouts/systemcgridview';








	if(isset($_GET['Search'])){

$arrayofinfo=array(
'campaign'=>$_REQUEST['Search']['campaign'],
'platform'=>$_REQUEST['Search']['platform_id'],
'startdate'=>$_REQUEST['Search']['startdate'],
'enddate'=>$_REQUEST['Search']['enddate']
);

			$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
			$criteria->condition = "communication IS NULL AND distribute_id IS NULL AND user_sales IS NULL AND receipt IS NULL";
            $criteria->addCondition('user_id ='.$userid.' OR user_integration='.$userid);
        
 
			$visible=1;
			$criteria->addCondition('hidden=' . $visible);
			
			
			if(!empty($_GET['Search']['campaign']))
			$criteria->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");	
			if(!empty($_GET['Search']['platform_id']))
			$criteria->addSearchCondition('platform_id', $_GET['Search']['platform_id'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');

if($_REQUEST['ccode']==1){


					$criteria->addSearchCondition('international_code', 20 ,false, "AND");

				}else if($_REQUEST['ccode']==2){

					
			            $criteria->addNotInCondition('international_code', array(20));
				}else{}



			$total = Leads::model()->count($criteria);
			$dataProvider = new CActiveDataProvider('Leads', array(
					'pagination' => array(
						'pageSize' =>50,

					),
					'criteria' => $criteria,
				));

		}




$model=new Leads();
if(isset($_POST['Leads']) AND isset($_POST['number'])){

//ini_set('display_errors','On'); 
//error_reporting(E_ALL);

	$per= $_POST['Leads'];
	$num= $_POST['number'];
	$sumsize=0;
	for($x=0;$x<sizeof($num);$x++){
		$sumsize+=(int)$num[$x];
	}
$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
			$criteria->condition = "communication IS NULL AND distribute_id IS NULL AND user_sales IS NULL AND receipt IS NULL";
    		$criteria->addCondition('user_id ='.$userid.' OR user_integration='.$userid);

			$visible=1;
			$criteria->addCondition('hidden=' . $visible);
			
			
			if(!empty($_GET['Search']['campaign']))
			$criteria->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");	
			if(!empty($_GET['Search']['platform_id']))
			$criteria->addSearchCondition('platform_id', $_GET['Search']['platform_id'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');

if($_REQUEST['ccode']==1){


					$criteria->addSearchCondition('international_code', 20 ,false, "AND");

				}else if($_REQUEST['ccode']==2){

					
			            $criteria->addNotInCondition('international_code', array(20));
				}else{}
	$leadsnum=Leads::model()->count($criteria);

	$leadsnum = (int)$leadsnum;
	if($sumsize > $leadsnum){
		Yii::app()->user->setFlash('success', "Cannot Proceed This Action Because There is No Enough Leads ");
		Yii::app()->controller->refresh();
	
	}
	for($i=0;$i<sizeof($per);$i++){
	
	
	
	
	$criteria2 = new CDbCriteria();
			$criteria2->order = 'id DESC';
			$criteria2->condition = "communication IS NULL AND distribute_id IS NULL AND user_sales IS NULL AND receipt IS NULL";
    		$criteria2->addCondition('user_id ='.$userid.' OR user_integration='.$userid);

			$visible=1;
			$criteria2->addCondition('hidden=' . $visible);
			
			
			if(!empty($_GET['Search']['campaign']))
			$criteria2->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");	
			if(!empty($_GET['Search']['platform_id']))
			$criteria2->addSearchCondition('platform_id', $_GET['Search']['platform_id'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria2->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');

if($_REQUEST['ccode']==1){


					$criteria2->addSearchCondition('international_code', 20 ,false, "AND");

				}else if($_REQUEST['ccode']==2){

					
			            $criteria2->addNotInCondition('international_code', array(20));
				}else{}
				
				
				
		$criteria2->limit = (int)$num[$i];
		$leads=Leads::model()->findAll($criteria2);
		foreach($leads as $lead){
			$lead->user_sales= (int)$per[$i];
			$lead->communicate_date = $today ;
			$lead->date = $today ;
			$lead->fresh_sales = (int)$per[$i];
			if(!$lead->save()){
            //var_dump($lead->getErrors());
}
		}
	}

	
			$this->redirect(array('marketing/uploadleadsteamleader')	);
}







if(isset($_POST['Leads2']) AND isset($_POST['number2'])){

//ini_set('display_errors','On'); 
//error_reporting(E_ALL);

	$per= $_POST['Leads2'];
	$num= $_POST['number2'];
	$sumsize=0;
	for($x=0;$x<sizeof($num);$x++){
		$sumsize+=(int)$num[$x];
	}
$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
			$criteria->condition = "communication IS NULL AND distribute_id IS NULL AND user_sales IS NULL AND receipt IS NULL";
    		$criteria->addCondition('user_id ='.$userid.' OR user_integration='.$userid);
			$visible=1;
			$criteria->addCondition('hidden=' . $visible);
			
			
			if(!empty($_GET['Search']['campaign']))
			$criteria->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");	
			if(!empty($_GET['Search']['platform_id']))
			$criteria->addSearchCondition('platform_id', $_GET['Search']['platform_id'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');

if($_REQUEST['ccode']==1){


					$criteria->addSearchCondition('international_code', 20 ,false, "AND");

				}else if($_REQUEST['ccode']==2){

					
			            $criteria->addNotInCondition('international_code', array(20));
				}else{}
	$leadsnum=Leads::model()->count($criteria);

	$leadsnum = (int)$leadsnum;
	if($sumsize > $leadsnum){
		Yii::app()->user->setFlash('success2', "Cannot Proceed This Action Because There is No Enough Leads ");
		Yii::app()->controller->refresh();
	
	}
	for($i=0;$i<sizeof($per);$i++){
	
	
	$criteria2 = new CDbCriteria();
			$criteria2->order = 'id DESC';
			$criteria2->condition = "communication IS NULL AND distribute_id IS NULL AND user_sales IS NULL AND receipt IS NULL";
    		$criteria2->addCondition('user_id ='.$userid.' OR user_integration='.$userid);
			$visible=1;
			$criteria2->addCondition('hidden=' . $visible);
			
			
			if(!empty($_GET['Search']['campaign']))
			$criteria2->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");	
			if(!empty($_GET['Search']['platform_id']))
			$criteria2->addSearchCondition('platform_id', $_GET['Search']['platform_id'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria2->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');

if($_REQUEST['ccode']==1){


					$criteria2->addSearchCondition('international_code', 20 ,false, "AND");

				}else if($_REQUEST['ccode']==2){

					
			            $criteria2->addNotInCondition('international_code', array(20));
				}else{}
				
				
				
		$criteria2->limit = (int)$num[$i];
		$leads=Leads::model()->findAll($criteria2);
		foreach($leads as $lead){
			$lead->user_integration = (int)$per[$i];
$log=new Distributelog();
$log->date=$today;
$log->time=$time;
$log->user_id=$userid;
$log->secret=rand().$userid;
$log->lead_id=$lead->id;
$log->coldcall=$lead->coldcall;
$log->too=(int)$per[$i];
$log->save();



if ($lead->save()) {
$main = Mainsettings::model()->findByPk(1);
$em=User::model()->findByPk($lead->user_integration);
if (!empty($em->mobile)) {                                                     
                                                                           
$url = Yii::app()->getBaseUrl(true) . "/leads/profile/" . $lead->id;
// Twilio Account SID and Auth Token
$sid    = $main->whatsapp_sid;
$token  = $main->whatsapp_token;

// Recipient's WhatsApp number
$to = "whatsapp:+" . $em->mobile;
// Your WhatsApp Business number
$from = "whatsapp:+" . $main->whatsapp_from;

// Template SID (Use your actual Template SID)
//$templateSid = "HX3651fc98925d84c20a5ebba0cac47ad1";
$templateSid = $main->whatsapp_templatesid_1;


if(!empty($main->hide_number_whatsapp)) {                                                     
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $url,
);
}else{
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $lead->international_code.$lead->tel,
);  
}



// Convert TemplateParams to JSON
$templateParams = json_encode($templateParams);

// Twilio API URL for sending template messages
$url = "https://api.twilio.com/2010-04-01/Accounts/$sid/Messages.json";

// Data to be sent in the POST request
$data = array(
    'To' => $to,
    'From' => $from,
    'ContentSid' => $templateSid, // استخدم ContentSid وليس TemplateSid
    'ContentVariables' => $templateParams // استخدم ContentVariables لتمرير المعلمات
);

// Initialize cURL
$ch = curl_init($url);

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_USERPWD, "$sid:$token");

// Execute the request and get the response
$response = curl_exec($ch);

// Check for cURL errors
if ($response === false) {
  //  echo 'cURL Error: ' . curl_error($ch);
} else {
   // $response_data = json_decode($response, true);
    
    // Check if SID exists in the response
    if (isset($response_data['sid'])) {
      //  echo 'Message SID: ' . $response_data['sid'];
    } else {
     //   echo 'No SID found in the response. Full response: ' . print_r($response_data, true);
    }
}

// Close the cURL session
curl_close($ch);

}
 
}






			if(!$lead->save()){
           // var_dump($lead->getErrors());
}
		}
	}

	
			$this->redirect(array('marketing/uploadleadsteamleader')	);
}




if(isset($_POST['checks']) AND isset($_POST['salescheck'])){
 
 
$criteria = new CDbCriteria();       
$criteria->addInCondition('id', $_POST['checks']);
$allleadsss= Leads::model()->findAll($criteria);
	
	    
  		foreach($allleadsss as $lead){ 
  		    
  		    
  		    $lead->user_sales= $_POST['salescheck']; 
			$lead->communicate_date = $today ;
			$lead->date = $today ;
			$lead->fresh_sales =  $_POST['salescheck']; 
			if(!$lead->save()){
            //var_dump($lead->getErrors());
            }
            
            
                                    		if ($lead->save()) {
$main = Mainsettings::model()->findByPk(1);
$em=User::model()->findByPk($lead->user_sales);
if (!empty($em->mobile)) {                                                     
                                                                           
$url = Yii::app()->getBaseUrl(true) . "/leads/profile/" . $lead->id;
// Twilio Account SID and Auth Token


$sid    = $main->whatsapp_sid;
$token  = $main->whatsapp_token;

// Recipient's WhatsApp number
$to = "whatsapp:+" . $em->mobile;
// Your WhatsApp Business number
$from = "whatsapp:+" . $main->whatsapp_from;

// Template SID (Use your actual Template SID)
//$templateSid = "HX3651fc98925d84c20a5ebba0cac47ad1";
$templateSid = $main->whatsapp_templatesid_1;


if(!empty($main->hide_number_whatsapp)) {                                                     
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $url,
);
}else{
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $lead->international_code.$lead->tel,
);  
}



// Convert TemplateParams to JSON
$templateParams = json_encode($templateParams);

// Twilio API URL for sending template messages
$url = "https://api.twilio.com/2010-04-01/Accounts/$sid/Messages.json";

// Data to be sent in the POST request
$data = array(
    'To' => $to,
    'From' => $from,
    'ContentSid' => $templateSid, // استخدم ContentSid وليس TemplateSid
    'ContentVariables' => $templateParams // استخدم ContentVariables لتمرير المعلمات
);

// Initialize cURL
$ch = curl_init($url);

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_USERPWD, "$sid:$token");

// Execute the request and get the response
$response = curl_exec($ch);

// Check for cURL errors
if ($response === false) {
  //  echo 'cURL Error: ' . curl_error($ch);
} else {
   // $response_data = json_decode($response, true);
    
    // Check if SID exists in the response
    if (isset($response_data['sid'])) {
      //  echo 'Message SID: ' . $response_data['sid'];
    } else {
     //   echo 'No SID found in the response. Full response: ' . print_r($response_data, true);
    }
}

// Close the cURL session
curl_close($ch);

}
 
}

            

 

		}
	
	  

	
			//$this->redirect(array('marketing/uploadleads')	);
					Yii::app()->controller->refresh();

}




if(isset($_POST['checks2']) AND isset($_POST['salescheck2'])){

 
$criteria = new CDbCriteria();       
$criteria->addInCondition('id', $_POST['checks2']);
$allleadsss= Leads::model()->findAll($criteria);
	
	    
  		foreach($allleadsss as $lead){ 
  		    
  		    
  		    			$lead->user_integration = $_POST['salescheck2'];
                        $log=new Distributelog();
                        $log->date=$today;
                        $log->time=$time;
                        $log->user_id=$userid;
                        $log->secret=rand().$userid;
                        $log->lead_id=$lead->id;
                        $log->coldcall=$lead->coldcall;
                        $log->too=(int)$_POST['salescheck2'];
                        $log->save();
                        
                        
                        		if ($lead->save()) {
$main = Mainsettings::model()->findByPk(1);
$em=User::model()->findByPk($lead->user_integration);
if (!empty($em->mobile)) {                                                     
                                                                           
$url = Yii::app()->getBaseUrl(true) . "/leads/profile/" . $lead->id;
// Twilio Account SID and Auth Token


$sid    = $main->whatsapp_sid;
$token  = $main->whatsapp_token;

// Recipient's WhatsApp number
$to = "whatsapp:+" . $em->mobile;
// Your WhatsApp Business number
$from = "whatsapp:+" . $main->whatsapp_from;

// Template SID (Use your actual Template SID)
//$templateSid = "HX3651fc98925d84c20a5ebba0cac47ad1";
$templateSid = $main->whatsapp_templatesid_1;


if(!empty($main->hide_number_whatsapp)) {                                                     
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $url,
);
}else{
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $lead->international_code.$lead->tel,
);  
}



// Convert TemplateParams to JSON
$templateParams = json_encode($templateParams);

// Twilio API URL for sending template messages
$url = "https://api.twilio.com/2010-04-01/Accounts/$sid/Messages.json";

// Data to be sent in the POST request
$data = array(
    'To' => $to,
    'From' => $from,
    'ContentSid' => $templateSid, // استخدم ContentSid وليس TemplateSid
    'ContentVariables' => $templateParams // استخدم ContentVariables لتمرير المعلمات
);

// Initialize cURL
$ch = curl_init($url);

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_USERPWD, "$sid:$token");

// Execute the request and get the response
$response = curl_exec($ch);

// Check for cURL errors
if ($response === false) {
  //  echo 'cURL Error: ' . curl_error($ch);
} else {
   // $response_data = json_decode($response, true);
    
    // Check if SID exists in the response
    if (isset($response_data['sid'])) {
      //  echo 'Message SID: ' . $response_data['sid'];
    } else {
     //   echo 'No SID found in the response. Full response: ' . print_r($response_data, true);
    }
}

// Close the cURL session
curl_close($ch);

}
 
}

                        
                        
                    	if(!$lead->save()){
                                   // var_dump($lead->getErrors());
                        }

 

		}
	
	  

	
			//$this->redirect(array('marketing/uploadleads')	);
					Yii::app()->controller->refresh();

}




		$visible=1;
		$allcampaign= Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allstatues= Statues::model()->findAll();
		$allplaces= Interestedplace::model()->findAll();

		
		

	$this->render('integrationsearchteamleader', array(
											
			'userid' => $userid,					
			'model' => $model,					
			'arrayofinfo' => $arrayofinfo,		
			'total' => $total,		
			'dataProvider' => $dataProvider,	
			'allcampaign' => $allcampaign,	
			'allplatform' => $allplatform,	
			'allstatues' => $allstatues,	
			'allplaces' => $allplaces,
    

											
		));
		
		
		
    }else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
		
		
}





public function actionSearchintegration(){
    if(Yii::app()->user->isMember()){
    	$userid=Yii::app()->user->id;
    	$user=User::model()->findByPk($userid);
    	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
    	$today = date("Y-m-d");                     // 03.10.01
    	$time = date("H:i:s"); 
        $this->layout = '//layouts/systemcgridview';
        if(isset($_GET['Search']) OR isset($_GET['branch']) ){
            $arrayofinfo=array(
                'campaign'=>$_REQUEST['Search']['campaign'],
                'startdate'=>$_REQUEST['Search']['startdate'],
                'enddate'=>$_REQUEST['Search']['enddate']
            );
			$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
            $userInfo=User::model()->findByPk($userid);
            if (!empty($userInfo->limitsformanager)) {
               // var_dump($userInfo);exit;
                // تعديل الشرط ليتحقق من user_integration = $currentUserId إذا كانت limitsformanager غير فارغة
                $criteria->condition = "communication IS NULL AND distribute_id IS NULL AND user_sales IS NULL AND receipt IS NULL AND unseenauto IS NULL";
                $criteria->addSearchCondition('user_integration', $userInfo->id,false, "AND");	
            }else{
              $criteria->condition = "communication IS NULL AND distribute_id IS NULL AND user_sales IS NULL AND receipt IS NULL  AND unseenauto IS NULL AND user_integration IS NULL";
            }
			$criteria->addCondition('distribute_id IS  NULL');
			$visible=1;
			$criteria->addCondition('hidden=' . $visible);
			if(!empty($_GET['Search']['projects']))
			$criteria->addSearchCondition('project_id', $_GET['Search']['projects'],false, "AND");
			if(!empty($_GET['Search']['interest_id']))
			$criteria->addSearchCondition('interest_id', $_GET['Search']['interest_id'],false, "AND");
			if(!empty($_GET['Search']['unit_type']))
			$criteria->addSearchCondition('unit_type', $_GET['Search']['unit_type'],false, "AND");
			if(!empty($_GET['Search']['campaign']))
			$criteria->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");	
			if(!empty($_GET['Search']['platform_id']))
			$criteria->addSearchCondition('platform_id', $_GET['Search']['platform_id'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');
            if($_REQUEST['ccode']==1){
				$criteria->addSearchCondition('international_code', 20 ,false, "AND");
			}else if($_REQUEST['ccode']==2){
                $criteria->addNotInCondition('international_code', array(20));
			}else{}
			if($_REQUEST['cold']==1){
                $criteria->addSearchCondition('coldcall', $_REQUEST['cold'],false, "AND");
			}else if($_REQUEST['cold']==2){
                $criteria->addCondition('coldcall IS NULL');
			}else{}
    		if($_GET['fake']==1){
                $criteria->addCondition('fake_id IS NOT NULL');
            }elseif($_GET['fake']==2){
                $criteria->addCondition('fake_id IS NULL');
            }
            if($_GET['branch']==1){
               $criteria->addCondition('transfer_branch IS NOT NULL');
                }else{
               $criteria->addCondition('transfer_branch IS NULL');
            }
            $total = Leads::model()->count($criteria);
			$dataProvider = new CActiveDataProvider('Leads', array(
				'pagination' => array(
					'pageSize' =>100,
				),
				'criteria' => $criteria,
			));
		}
		
		
		
		
		
		$model=new Leads();
if(isset($_POST['Leads']) AND isset($_POST['number'])){
    

//ini_set('display_errors','On'); 
//error_reporting(E_ALL);

	$per= $_POST['Leads'];
	$num= $_POST['number'];
	$actual = [];  // هنا نجمع الأعداد الفعلية

	$sumsize=0;
	for($x=0;$x<sizeof($num);$x++){
		$sumsize+=(int)$num[$x];
	}
$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
			$criteria->condition = "communication IS NULL AND distribute_id IS NULL AND user_sales IS NULL AND receipt IS NULL AND unseenauto IS NULL AND user_integration IS NULL ";
			$criteria->addCondition('distribute_id IS  NULL');
			$visible=1;
			$criteria->addCondition('hidden=' . $visible);
			
			if(!empty($_GET['Search']['projects']))
			$criteria->addSearchCondition('project_id', $_GET['Search']['projects'],false, "AND");
			if(!empty($_GET['Search']['interest_id']))
			$criteria->addSearchCondition('interest_id', $_GET['Search']['interest_id'],false, "AND");
		//	var_dump($_GET['Search']['interest_id']);exit;
			if(!empty($_GET['Search']['campaign']))
			$criteria->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");	
			if(!empty($_GET['Search']['platform_id']))
			$criteria->addSearchCondition('platform_id', $_GET['Search']['platform_id'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');

if($_REQUEST['ccode']==1){


					$criteria->addSearchCondition('international_code', 20 ,false, "AND");

				}else if($_REQUEST['ccode']==2){

					
			            $criteria->addNotInCondition('international_code', array(20));
				}else{}
				
				
				
	
				
        
        
        if($_REQUEST['cold']==1){
        $criteria->addSearchCondition('coldcall', $_REQUEST['cold'],false, "AND");
        }else if($_REQUEST['cold']==2){
        $criteria->addCondition('coldcall IS NULL');
        }else{
        }

		
				
						if($_GET['fake']==1){
        $criteria->addCondition('fake_id IS NOT NULL');
        }elseif($_GET['fake']==2){
        $criteria->addCondition('fake_id IS NULL');
        }


	$leadsnum=Leads::model()->count($criteria);

	$leadsnum = (int)$leadsnum;
	if($sumsize > $leadsnum){
		Yii::app()->user->setFlash('success', "Cannot Proceed This Action Because There is No Enough Leads ");
		Yii::app()->controller->refresh();
	
	}
	for($i=0;$i<sizeof($per);$i++){
	
	
	
	
	$criteria2 = new CDbCriteria();
			$criteria2->order = 'id DESC';
			$criteria2->condition = "communication IS NULL AND distribute_id IS NULL AND user_sales IS NULL AND receipt IS NULL   AND unseenauto IS NULL AND user_integration IS NULL";
			$criteria2->addCondition('distribute_id IS  NULL');
			$visible=1;
			$criteria2->addCondition('hidden=' . $visible);
			
			
			if(!empty($_GET['Search']['projects']))
			$criteria->addSearchCondition('project_id', $_GET['Search']['projects'],false, "AND");
			if(!empty($_GET['Search']['interest_id']))
			$criteria->addSearchCondition('interest_id', $_GET['Search']['interest_id'],false, "AND");
			if(!empty($_GET['Search']['campaign']))
			$criteria2->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");	
			if(!empty($_GET['Search']['platform_id']))
			$criteria2->addSearchCondition('platform_id', $_GET['Search']['platform_id'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria2->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');

if($_REQUEST['ccode']==1){


					$criteria2->addSearchCondition('international_code', 20 ,false, "AND");

				}else if($_REQUEST['ccode']==2){

					
			            $criteria2->addNotInCondition('international_code', array(20));
				}else{}
				
						if($_GET['fake']==1){
        $criteria2->addCondition('fake_id IS NOT NULL');
        }elseif($_GET['fake']==2){
        $criteria2->addCondition('fake_id IS NULL');
        }
        
        
        
        
         
        if($_REQUEST['cold']==1){
        $criteria2->addSearchCondition('coldcall', $_REQUEST['cold'],false, "AND");
        }else if($_REQUEST['cold']==2){
        $criteria2->addCondition('coldcall IS NULL');
        }else{
        }

		


				
		$criteria2->limit = (int)$num[$i];
		$leads=Leads::model()->findAll($criteria2);
		foreach($leads as $lead){
			$lead->user_sales= (int)$per[$i];
			$lead->communicate_date = $today ;
			$lead->date = $today ;
			$lead->time = $time ;
			$lead->fresh_sales = (int)$per[$i];
			
			
			

			
			
			if(!$lead->save()){
            //var_dump($lead->getErrors());
            }else{
                
                
                
                
                
                
                
                
                $log=new Distributelog();
                $log->date=$today;
                $log->time=$time;
                $log->user_id=$userid;
                $log->secret=rand().$userid;
                $log->lead_id=$lead->id;
                $log->coldcall=$lead->coldcall;
                $log->too=(int)$per[$i];
                $log->save();
            }
		}
		
		        $actual[$per[$i]] = count($leads);

		
	}

	
	
	
	


$main = Mainsettings::model()->findByPk(1);
foreach ($actual as $salesRepId => $assignedCount) {
    
//var_dump($assignedCount);exit;


    if ($assignedCount > 0) {
        $em = User::model()->findByPk($salesRepId);
        if (!empty($em->mobile)) {
            
            $sid         = $main->whatsapp_sid;
            $token       = $main->whatsapp_token;
            $to          = "whatsapp:+" . $em->mobile;          
            $from        = "whatsapp:+" . $main->whatsapp_from; 
            $templateSid = $main->whatsapp_templatesid_3;       
            
            $templateParams = [
                '1' => $assignedCount,
            ];

            $url = "https://api.twilio.com/2010-04-01/Accounts/{$sid}/Messages.json";
            

            
            
            // Data to be sent in the POST request
$data = array(
    'To' => $to,
    'From' => $from,
    'ContentSid' => $templateSid, // استخدم ContentSid وليس TemplateSid
    'ContentVariables' => $templateParams // استخدم ContentVariables لتمرير المعلمات
);
            
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
            curl_setopt($ch, CURLOPT_USERPWD, "{$sid}:{$token}");
            
            $response = curl_exec($ch);
            curl_close($ch);
        } 
    } 
} 



	
			$this->redirect(array('marketing/uploadleads')	);
}


	





if(isset($_POST['Leadsduplicate']) AND isset($_POST['numberduplicate'])){
var_dump(3);exit;

//ini_set('display_errors','On'); 
//error_reporting(E_ALL);

	$per= $_POST['Leadsduplicate'];
	$num= $_POST['numberduplicate'];
	$sumsize=0;
	for($x=0;$x<sizeof($num);$x++){
		$sumsize+=(int)$num[$x];
	}
	
	

$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
			$criteria->condition = "communication IS NULL AND distribute_id IS NULL AND user_sales IS NULL AND receipt IS NULL AND unseenauto IS NULL";
			$criteria->addCondition('distribute_id IS  NULL');
			$visible=1;
			$criteria->addCondition('hidden=' . $visible);
			
			if(!empty($_GET['Search']['projects']))
			$criteria->addSearchCondition('project_id', $_GET['Search']['projects'],false, "AND");
			if(!empty($_GET['Search']['interest_id']))
			$criteria->addSearchCondition('interest_id', $_GET['Search']['interest_id'],false, "AND");
			if(!empty($_GET['Search']['campaign']))
			$criteria->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");	
			if(!empty($_GET['Search']['platform_id']))
			$criteria->addSearchCondition('platform_id', $_GET['Search']['platform_id'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');

if($_REQUEST['ccode']==1){


					$criteria->addSearchCondition('international_code', 20 ,false, "AND");

				}else if($_REQUEST['ccode']==2){

					
			            $criteria->addNotInCondition('international_code', array(20));
				}else{}
				
	
        
        if($_REQUEST['cold']==1){
        $criteria->addSearchCondition('coldcall', $_REQUEST['cold'],false, "AND");
        }else if($_REQUEST['cold']==2){
        $criteria->addCondition('coldcall IS NULL');
        }else{
        }

		
				
						if($_GET['fake']==1){
        $criteria->addCondition('fake_id IS NOT NULL');
        }elseif($_GET['fake']==2){
        $criteria->addCondition('fake_id IS NULL');
        }


	$leadsnum=Leads::model()->count($criteria);

	//$leadsnum = (int)$leadsnum;
	//if($sumsize > $leadsnum){
	//	Yii::app()->user->setFlash('success', "Cannot Proceed This Action Because There is No Enough Leads ");
	//	Yii::app()->controller->refresh();
	
	//}
	for($i=0;$i<sizeof($per);$i++){
	
	
	
	
	$criteria2 = new CDbCriteria();
			$criteria2->order = 'id DESC';
			$criteria2->condition = "communication IS NULL AND distribute_id IS NULL AND user_sales IS NULL AND receipt IS NULL   AND unseenauto IS NULL";
			$criteria2->addCondition('distribute_id IS  NULL');
			$visible=1;
			$criteria2->addCondition('hidden=' . $visible);

			
			
			if(!empty($_GET['Search']['projects']))
			$criteria->addSearchCondition('project_id', $_GET['Search']['projects'],false, "AND");
			if(!empty($_GET['Search']['interest_id']))
			$criteria->addSearchCondition('interest_id', $_GET['Search']['interest_id'],false, "AND");
			if(!empty($_GET['Search']['campaign']))
			$criteria2->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");	
			if(!empty($_GET['Search']['platform_id']))
			$criteria2->addSearchCondition('platform_id', $_GET['Search']['platform_id'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria2->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');

if($_REQUEST['ccode']==1){


					$criteria2->addSearchCondition('international_code', 20 ,false, "AND");

				}else if($_REQUEST['ccode']==2){

					
			            $criteria2->addNotInCondition('international_code', array(20));
				}else{}
				
						if($_GET['fake']==1){
        $criteria2->addCondition('fake_id IS NOT NULL');
        }elseif($_GET['fake']==2){
        $criteria2->addCondition('fake_id IS NULL');
        }
        
        
        
        
         
        if($_REQUEST['cold']==1){
        $criteria2->addSearchCondition('coldcall', $_REQUEST['cold'],false, "AND");
        }else if($_REQUEST['cold']==2){
        $criteria2->addCondition('coldcall IS NULL');
        }else{
        }

		


				
		$criteria2->limit = (int)$num[$i];
		$leads=Leads::model()->findAll($criteria2);
		//var_dump($leads);exit;
		foreach($leads as $lead){
			$lead->user_sales= (int)$per[$i];
			$lead->communicate_date = $today ;
			$lead->date = $today ;
			$lead->time = $time ;
			$lead->fresh_sales = (int)$per[$i];
			if($lead->save()){
    
	 
    	 
    	 	
$model= new Leads();
$rnd = rand(0,99999);
$model->user_id = $userid;
$model->date = $today;
$model->title = $lead->title;
$model->tel = $lead->tel;
$model->international_code = $lead->international_code;
$model->user_sales = NULL;
$model->user_marketing =$lead->user_marketing;
$model->feedback_date = $lead->feedback_date;
$model->communicate_date = $lead->feedback_date;
$model->campaign_id = $lead->campaign_id;
$model->strategy_id = $lead->strategy_id;
$model->fresh_sales = NULL;
$model->time = $time;
$model->dtime = $time;
$model->hidden = 1;
$model->coldcall = $lead->coldcall;
$model->notes = $lead->notes;
$model->block_duplicate=(int)$per[$i];
$model->save();    
if(!$model->save()){
var_dump($model->getErrors()); exit;
}

	if($model->save()){
	 $model->secert = $model->id;   
	 $model->save();   
	}
				
    	    

    
    
    
    
    
    
    
            }else{
                $log=new Distributelog();
                $log->date=$today;
                $log->time=$time;
                $log->user_id=$userid;
                $log->secret=rand().$userid;
                $log->lead_id=$lead->id;
                $log->coldcall=$lead->coldcall;
                $log->too=(int)$per[$i];
                $log->save();
            }
		}
	}

	
			$this->redirect(array('marketing/uploadleads')	);
}


if(isset($_POST['checksduplicate']) AND isset($_POST['salescheckduplicate'])){

$per= $_POST['salescheckduplicate'];



foreach ($per as $key => $value) {
if($value != 0){


$criteria = new CDbCriteria();       
$criteria->addInCondition('id', $_POST['checksduplicate']);


$allleadsss= Leads::model()->findAll($criteria);
	
	    
foreach($allleadsss as $lead){ 

if($lead->user_sales == NULL)
{
$lead->user_sales= (int)$value; 
$lead->communicate_date = $today;
$lead->date = $today ;
$lead->fresh_sales = (int)$value; 
$lead->save();
    
    
}else{
    
        	 	
$model= new Leads();
$rnd = rand(0,99999);
$model->user_id = $userid;
$model->date = $lead->date;
$model->title = $lead->title;
$model->tel = $lead->tel;
$model->international_code = $lead->international_code;
$model->user_sales = (int)$value;
$model->user_marketing =$lead->user_marketing;
$model->feedback_date = $lead->feedback_date;
$model->communicate_date = $lead->feedback_date;
$model->campaign_id = $lead->campaign_id;
$model->strategy_id = $lead->strategy_id;
$model->platform_id = $lead->platform_id;
$model->fresh_sales = (int)$value;
$model->time = $lead->time;
$model->dtime = $time;
$model->hidden = 1;
$model->coldcall = $lead->coldcall;
$model->notes = $lead->notes;
$model->block_duplicate=$lead->id;
$model->save();    
if(!$model->save()){
var_dump($model->getErrors()); exit;
}

if($model->save()){
$model->secert = $model->id;   
$model->save();   
}
    

}  		   


}


}
}
  	




	
	  

	
			//$this->redirect(array('marketing/uploadleads')	);
					Yii::app()->controller->refresh();

}






if(isset($_POST['Leads2']) AND isset($_POST['number2'])){
//ini_set('display_errors','On'); 
//error_reporting(E_ALL);

	$per= $_POST['Leads2'];
	$num= $_POST['number2'];
	$sumsize=0;
	for($x=0;$x<sizeof($num);$x++){
		$sumsize+=(int)$num[$x];
	}
$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
			$criteria->condition = "communication IS NULL AND distribute_id IS NULL AND user_sales IS NULL AND receipt IS NULL  AND unseenauto IS NULL AND user_integration IS NULL";
			$criteria->addCondition('distribute_id IS  NULL');
			$visible=1;
			$criteria->addCondition('hidden=' . $visible);
			
			

		
			if(!empty($_GET['Search']['projects']))
			$criteria->addSearchCondition('project_id', $_GET['Search']['projects'],false, "AND");
			if(!empty($_GET['Search']['interest_id']))
			$criteria->addSearchCondition('interest_id', $_GET['Search']['interest_id'],false, "AND");
			if(!empty($_GET['Search']['unit_type']))
			$criteria->addSearchCondition('unit_type', $_GET['Search']['unit_type'],false, "AND");
			if(!empty($_GET['Search']['campaign']))
			$criteria->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");	
			if(!empty($_GET['Search']['platform_id']))
			$criteria->addSearchCondition('platform_id', $_GET['Search']['platform_id'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');

if($_REQUEST['ccode']==1){


					$criteria->addSearchCondition('international_code', 20 ,false, "AND");

				}else if($_REQUEST['ccode']==2){

					
			            $criteria->addNotInCondition('international_code', array(20));
				}else{}
				
				
				
		
		 
        if($_REQUEST['cold']==1){
        $criteria->addSearchCondition('coldcall', $_REQUEST['cold'],false, "AND");
        }else if($_REQUEST['cold']==2){
        $criteria->addCondition('coldcall IS NULL');
        }else{
        }

		
				

		if($_GET['fake']==1){
        $criteria->addCondition('fake_id IS NOT NULL');
        }elseif($_GET['fake']==2){
        $criteria->addCondition('fake_id IS NULL');
        }


	$leadsnum=Leads::model()->count($criteria);
	
	//var_dump($leadsnum);exit;


	$leadsnum = (int)$leadsnum;
	if($sumsize > $leadsnum){
		Yii::app()->user->setFlash('success2', "Cannot Proceed This Action Because There is No Enough Leads ");
		Yii::app()->controller->refresh();
	
	}
	for($i=0;$i<sizeof($per);$i++){
	
	
	$criteria2 = new CDbCriteria();
			$criteria2->order = 'id DESC';
			$criteria2->condition = "communication IS NULL AND distribute_id IS NULL AND user_sales IS NULL AND receipt IS NULL  AND unseenauto IS NULL AND user_integration IS NULL";
			$criteria2->addCondition('distribute_id IS  NULL');
			$visible=1;
			$criteria2->addCondition('hidden=' . $visible);
			
			
			
			if(!empty($_GET['Search']['projects']))
			$criteria2->addSearchCondition('project_id', $_GET['Search']['projects'],false, "AND");
			if(!empty($_GET['Search']['interest_id']))
			$criteria2->addSearchCondition('interest_id', $_GET['Search']['interest_id'],false, "AND");
			if(!empty($_GET['Search']['unit_type']))
			$criteria2->addSearchCondition('unit_type', $_GET['Search']['unit_type'],false, "AND");
			if(!empty($_GET['Search']['campaign']))
			$criteria2->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");	
			if(!empty($_GET['Search']['platform_id']))
			$criteria2->addSearchCondition('platform_id', $_GET['Search']['platform_id'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria2->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');

if($_REQUEST['ccode']==1){


					$criteria2->addSearchCondition('international_code', 20 ,false, "AND");

				}else if($_REQUEST['ccode']==2){

					
			            $criteria2->addNotInCondition('international_code', array(20));
				}else{}
				
				
				
		 
        if($_REQUEST['cold']==1){
        $criteria2->addSearchCondition('coldcall', $_REQUEST['cold'],false, "AND");
        }else if($_REQUEST['cold']==2){
        $criteria2->addCondition('coldcall IS NULL');
        }else{
        }

		
				

		if($_GET['fake']==1){
        $criteria2->addCondition('fake_id IS NOT NULL');
        }elseif($_GET['fake']==2){
        $criteria2->addCondition('fake_id IS NULL');
        }



		$leaderi = (int)$per[$i];
		$criteria2->limit = (int)$num[$i];
		$leads=Leads::model()->findAll($criteria2);
		foreach($leads as $lead){
			$lead->user_integration = (int)$per[$i];
$log=new Distributelog();
$log->date=$today;
$log->time=$time;
$log->user_id=$userid;
$log->secret=rand().$userid;
$log->lead_id=$lead->id;
$log->coldcall=$lead->coldcall;
$log->too=(int)$per[$i];
$log->save();
if(!$lead->save()){
           // var_dump($lead->getErrors());
}



if($lead->save()){

    
$em=User::model()->findByPk($lead->user_integration);
$main = Mainsettings::model()->findByPk(1);

if (!empty($em->mobile)) {                                                     
$url = Yii::app()->getBaseUrl(true) . "/leads/profile/" . $lead->id;

$sid    = $main->whatsapp_sid;
$token  = $main->whatsapp_token;

// Recipient's WhatsApp number
$to = "whatsapp:+" . $em->mobile;
// Your WhatsApp Business number
$from = "whatsapp:+" . $main->whatsapp_from;

// Template SID (Use your actual Template SID)
//$templateSid = "HX3651fc98925d84c20a5ebba0cac47ad1";
$templateSid = $main->whatsapp_templatesid_1;

if(!empty($main->hide_number_whatsapp)) {                                                     
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $url,
);
}else{
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $lead->international_code.$lead->tel,
);  
}


// Convert TemplateParams to JSON
$templateParams = json_encode($templateParams);

// Twilio API URL for sending template messages
$url = "https://api.twilio.com/2010-04-01/Accounts/$sid/Messages.json";

// Data to be sent in the POST request
$data = array(
    'To' => $to,
    'From' => $from,
    'ContentSid' => $templateSid, // استخدم ContentSid وليس TemplateSid
    'ContentVariables' => $templateParams // استخدم ContentVariables لتمرير المعلمات
);

// Initialize cURL
$ch = curl_init($url);

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_USERPWD, "$sid:$token");

// Execute the request and get the response
$response = curl_exec($ch);

// Check for cURL errors
if ($response === false) {
   // echo 'cURL Error: ' . curl_error($ch);
} else {
   $response_data = json_decode($response, true);
    
    // Check if SID exists in the response
    if (isset($response_data['sid'])) {
       // echo 'Message SID: ' . $response_data['sid'];
    } else {
     //  echo 'No SID found in the response. Full response: ' . print_r($response_data, true);
    }
}

// Close the cURL session
curl_close($ch);

}
 

}

		}
		
		

    
		
		
		
		
		
	}
	
	
	
	
		

	
	
	
	

	
	
		
                                               Yii::app()->controller->refresh();
}




if(isset($_POST['checks']) AND isset($_POST['salescheck'])){

 
$criteria = new CDbCriteria();       
$criteria->addInCondition('id', $_POST['checks']);
$allleadsss= Leads::model()->findAll($criteria);
	
	    
  		foreach($allleadsss as $lead){ 
  		    
  		    
  		    $lead->user_sales= $_POST['salescheck']; 
			$lead->communicate_date = $today ;
			$lead->date = $today ;
			$lead->fresh_sales =  $_POST['salescheck']; 
		
		
		
		if ($lead->save()) {
$main = Mainsettings::model()->findByPk(1);
$em=User::model()->findByPk($lead->user_sales);
if (!empty($em->mobile)) {                                                     
                                                                           
$url = Yii::app()->getBaseUrl(true) . "/leads/profile/" . $lead->id;
// Twilio Account SID and Auth Token


$sid    = $main->whatsapp_sid;
$token  = $main->whatsapp_token;

// Recipient's WhatsApp number
$to = "whatsapp:+" . $em->mobile;
// Your WhatsApp Business number
$from = "whatsapp:+" . $main->whatsapp_from;

// Template SID (Use your actual Template SID)
//$templateSid = "HX3651fc98925d84c20a5ebba0cac47ad1";
$templateSid = $main->whatsapp_templatesid_1;



if(!empty($main->hide_number_whatsapp)) {                                                     
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $url,
);
}else{
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $lead->international_code.$lead->tel,
);  
}



// Convert TemplateParams to JSON
$templateParams = json_encode($templateParams);

// Twilio API URL for sending template messages
$url = "https://api.twilio.com/2010-04-01/Accounts/$sid/Messages.json";

// Data to be sent in the POST request
$data = array(
    'To' => $to,
    'From' => $from,
    'ContentSid' => $templateSid, // استخدم ContentSid وليس TemplateSid
    'ContentVariables' => $templateParams // استخدم ContentVariables لتمرير المعلمات
);

// Initialize cURL
$ch = curl_init($url);

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_USERPWD, "$sid:$token");

// Execute the request and get the response
$response = curl_exec($ch);

// Check for cURL errors
if ($response === false) {
  //  echo 'cURL Error: ' . curl_error($ch);
} else {
   // $response_data = json_decode($response, true);
    
    // Check if SID exists in the response
    if (isset($response_data['sid'])) {
      //  echo 'Message SID: ' . $response_data['sid'];
    } else {
     //   echo 'No SID found in the response. Full response: ' . print_r($response_data, true);
    }
}

// Close the cURL session
curl_close($ch);

}
 
}


 

		}
	
	  

	
			//$this->redirect(array('marketing/uploadleads')	);
					Yii::app()->controller->refresh();

}


if(isset($_POST['checks2']) AND isset($_POST['salescheck2'])){
 //var_dump('sss');exit;
 
$criteria = new CDbCriteria();       
$criteria->addInCondition('id', $_POST['checks2']);
$allleadsss= Leads::model()->findAll($criteria);
	
	    
  		foreach($allleadsss as $lead){ 
  		    
  		    
  		    			$lead->user_integration = $_POST['salescheck2'];
                        $log=new Distributelog();
                        $log->date=$today;
                        $log->time=$time;
                        $log->user_id=$userid;
                        $log->secret=rand().$userid;
                        $log->lead_id=$lead->id;
                        $log->coldcall=$lead->coldcall;
                        $log->too=(int)$_POST['salescheck2'];
                        $log->save();
                        
                        		if ($lead->save()) {
$main = Mainsettings::model()->findByPk(1);
$em=User::model()->findByPk($lead->user_integration);
if (!empty($em->mobile)) {                                                     
                                                                           
$url = Yii::app()->getBaseUrl(true) . "/leads/profile/" . $lead->id;
// Twilio Account SID and Auth Token

$sid    = $main->whatsapp_sid;
$token  = $main->whatsapp_token;

// Recipient's WhatsApp number
$to = "whatsapp:+" . $em->mobile;
// Your WhatsApp Business number
$from = "whatsapp:+" . $main->whatsapp_from;

// Template SID (Use your actual Template SID)
//$templateSid = "HX3651fc98925d84c20a5ebba0cac47ad1";
$templateSid = $main->whatsapp_templatesid_1;


if(!empty($main->hide_number_whatsapp)) {                                                     
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $url,
);
}else{
// Template parameters as key-value pairs
$templateParams = array(
    '1' => $lead->title,
    '2' => $lead->international_code.$lead->tel,
);  
}



// Convert TemplateParams to JSON
$templateParams = json_encode($templateParams);

// Twilio API URL for sending template messages
$url = "https://api.twilio.com/2010-04-01/Accounts/$sid/Messages.json";

// Data to be sent in the POST request
$data = array(
    'To' => $to,
    'From' => $from,
    'ContentSid' => $templateSid, // استخدم ContentSid وليس TemplateSid
    'ContentVariables' => $templateParams // استخدم ContentVariables لتمرير المعلمات
);

// Initialize cURL
$ch = curl_init($url);

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_USERPWD, "$sid:$token");

// Execute the request and get the response
$response = curl_exec($ch);

// Check for cURL errors
if ($response === false) {
  //  echo 'cURL Error: ' . curl_error($ch);
} else {
   // $response_data = json_decode($response, true);
    
    // Check if SID exists in the response
    if (isset($response_data['sid'])) {
      //  echo 'Message SID: ' . $response_data['sid'];
    } else {
     //   echo 'No SID found in the response. Full response: ' . print_r($response_data, true);
    }
}

// Close the cURL session
curl_close($ch);

}
 
}

                        
                        
                    	if(!$lead->save()){
                                   // var_dump($lead->getErrors());
                        }

 

		}
	
	  

	
			//$this->redirect(array('marketing/uploadleads')	);
					Yii::app()->controller->refresh();

}



		$visible=1;
		$allcampaign= Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allstatues= Statues::model()->findAll();
		$allplaces= Interestedplace::model()->findAll();

		
		

	$this->render('integrationsearch', array(
											
			'userid' => $userid,					
			'model' => $model,					
			'arrayofinfo' => $arrayofinfo,		
			'total' => $total,		
			'dataProvider' => $dataProvider,	
			'allcampaign' => $allcampaign,	
			'allplatform' => $allplatform,	
			'allstatues' => $allstatues,	
			'allplaces' => $allplaces,
    

											
		));
		
		
		
}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
		
}








public function actionSearchintegration2(){

if(Yii::app()->user->isMember()){
	$userid=Yii::app()->user->id;
	$user=User::model()->findByPk($userid);
	$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
	$today = date("Y-m-d");                     // 03.10.01
	$time = date("H:i:s"); 










	if(isset($_GET['Search'])){


$arrayofinfo=array(
'campaign'=>$_REQUEST['Search']['campaign'],
'startdate'=>$_REQUEST['Search']['startdate'],
'enddate'=>$_REQUEST['Search']['enddate']
);

			$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
			$criteria->condition = "communication IS NULL AND distribute_id IS NOT NULL AND user_sales IS  NULL  AND receipt IS  NULL ";
			$visible=1;
			$criteria->addCondition('hidden=' . $visible);



$user=User::model()->findByPk($userid);
if($user->salesmanger==1){}else{$criteria->addCondition('distribute_id=' . $userid);}

			
			
			
			if(!empty($_GET['Search']['campaign']))
			$criteria->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');


			$total = Leads::model()->count($criteria);
			$dataProvider = new CActiveDataProvider('Leads', array(
					'pagination' => array(
						'pageSize' =>50,

					),
					'criteria' => $criteria,
				));

		}




$model=new Leads();
if(isset($_POST['Leads']) AND isset($_POST['number'])){

//ini_set('display_errors','On'); 
//error_reporting(E_ALL);

	$per= $_POST['Leads'];
	$num= $_POST['number'];
	$sumsize=0;
	for($x=0;$x<sizeof($num);$x++){
		$sumsize+=(int)$num[$x];
	}
	$criteria = new CDbCriteria();
	$criteria->condition = "communicate_date IS NULL ";
	$criteria->addCondition('hidden=' . $visible);
	$criteria->addCondition('distribute_id=' . $userid);
	$criteria->order = 'id DESC';
			
			if(!empty($_GET['Search']['campaign']))
			$criteria->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');

	$leadsnum=Leads::model()->count($criteria);

	$leadsnum = (int)$leadsnum;
	if($sumsize > $leadsnum){
		Yii::app()->user->setFlash('success', "Cannot Proceed This Action Because There is No Enough Leads ");
		Yii::app()->controller->refresh();
	
	}
	for($i=0;$i<sizeof($per);$i++){
		$criteria2 = new CDbCriteria();
		$criteria2->condition = "communicate_date IS NULL ";
	$criteria2->addCondition('distribute_id=' . $userid);
		$criteria2->addCondition('hidden=1');
		$criteria2->order = 'id DESC';
			
			if(!empty($_GET['Search']['campaign']))
			$criteria2->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria2->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');
		$criteria2->limit = (int)$num[$i];
		$leads=Leads::model()->findAll($criteria2);
		foreach($leads as $lead){
			$lead->user_sales= (int)$per[$i];
			$lead->communicate_date = $today ;
			if(!$lead->save()){
            //var_dump($lead->getErrors());
}
		}
	}

	
			$this->redirect(array('distributed')	);
			
			
			
			
}







if(isset($_POST['Leads2']) AND isset($_POST['number2'])){

//ini_set('display_errors','On'); 
//error_reporting(E_ALL);

	$per= $_POST['Leads2'];
	$num= $_POST['number2'];
	$sumsize=0;
	for($x=0;$x<sizeof($num);$x++){
		$sumsize+=(int)$num[$x];
	}
	$criteria = new CDbCriteria();
	$criteria->condition = "communicate_date IS NULL ";
	$criteria->addCondition('hidden=' . $visible);
	$criteria->addCondition('distribute_id=' . $userid);
	$criteria->order = 'id DESC';
			
			if(!empty($_GET['Search']['campaign']))
			$criteria->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');

	$leadsnum=Leads::model()->count($criteria);

	$leadsnum = (int)$leadsnum;
	if($sumsize > $leadsnum){
		Yii::app()->user->setFlash('success2', "Cannot Proceed This Action Because There is No Enough Leads ");
		Yii::app()->controller->refresh();
	
	}
	for($i=0;$i<sizeof($per);$i++){
		$criteria2 = new CDbCriteria();
		$criteria2->condition = "communicate_date IS NULL ";
	$criteria2->addCondition('distribute_id=' . $userid);
		$criteria2->addCondition('hidden=1');
		$criteria2->order = 'id DESC';
			
			if(!empty($_GET['Search']['campaign']))
			$criteria2->addSearchCondition('campaign_id', $_GET['Search']['campaign'],false, "AND");		
			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria2->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');
		$criteria2->limit = (int)$num[$i];
		$leads=Leads::model()->findAll($criteria2);
		foreach($leads as $lead){
			$lead->user_integration = (int)$per[$i];
$log=new Distributelog();
$log->date=$today;
$log->time=$time;
$log->user_id=$userid;
$log->secret=rand().$userid;
$log->lead_id=$lead->id;
$log->coldcall=$lead->coldcall;
$log->too=(int)$per[$i];
$log->save();
			if(!$lead->save()){
           // var_dump($lead->getErrors());
}
		}
	}

	
			$this->redirect(array('distributed')	);
}




		$visible=1;
		$allcampaign= Campaign::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allplatform= Platform::model()->findAll(array( 'condition' => 'hidden=' . $visible ,'order'=>'id DESC'  ));
		$allstatues= Statues::model()->findAll();
		$allplaces= Interestedplace::model()->findAll();

		
		

	$this->render('integrationsearch', array(
											
			'userid' => $userid,					
			'model' => $model,					
			'arrayofinfo' => $arrayofinfo,		
			'total' => $total,		
			'dataProvider' => $dataProvider,	
			'allcampaign' => $allcampaign,	
			'allplatform' => $allplatform,	
			'allstatues' => $allstatues,	
			'allplaces' => $allplaces,
    

											
		));
		
		
}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
		
}



























	public function actionUpcomingtelesales(){
		if(Yii::app()->user->isMember()){
			$userid=Yii::app()->user->id;
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);

		
			$visible = 1;
	
	
			$allsales = User::model()->findAll(array( 'condition' => 'sales=' . $visible ,'order'=>'id DESC'  ));
	

			$allnotetype=NoteType::model()->findAll();
			$allstatues=Statues::model()->findAll();

			$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
			//$criteria->addCondition('user_id=' . $userid);


$criteria->addCondition('confirmsales IS NULL &&  confirm IS NULL');


			$dataProvider = new CActiveDataProvider('Visit', array(
					'pagination' => array(
					
					),
					'criteria' => $criteria,
				));


            
			$allvisit = Visit::model()->findAll($criteria);

		
	

		
		
		
		
			$this->render('upcomingteleseales',array(
					'userid'=>$userid ,	
					'dataProvider' => $dataProvider,		
					'allvisit'=>$allvisit ,
					'allsales'=>$allsales,        
					'allnotetype'=>$allnotetype,
					'allstatues'=>$allstatues,



				));
		}


		else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('login/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}

	}



               public function actionVisitsforsales(){
                              if(Yii::app()->user->isMember()){
                                             $userid=Yii::app()->user->id;
                                             $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');}; 
                                             $today = date("Y-m-d");                     // 03.10.01
                                             $time = date("H:i:s");                      // 17:16:18      
              
                                             $rnd = rand(0,9);
                       
                                             $main=Mainsettings::model()->findByPk(1);
                                             $visible = 1;     
 
 
                                             $criteria = new CDbCriteria(); 
                                			$criteria = new CDbCriteria();
                                			$criteria->order = 'id DESC';
                                			$criteria->addSearchCondition('user_id', $userid ,false, "AND");
			
			
                                             $dataProvider = new CActiveDataProvider('Visit', array(
                                                                           'pagination' => array(
                                                                                          'pageSize' =>50,
                                                                           ),
                                                                           'criteria' => $criteria,
                                                            ));
 
  
                                             		if(isset($_GET['Search'])){


			$criteria = new CDbCriteria();
			$criteria->order = 'id DESC'; 
			$criteria->addSearchCondition('user_id', $userid ,false, "AND");

			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');
			if(isset($_GET['Search']['visit'])){
			$criteria->addSearchCondition('confirmsales', $_GET['Search']['visit'],false, "AND");
			}
			
			$dataProvider = new CActiveDataProvider('Visit', array(
					'pagination' => array(
						'pageSize' =>50,
					),
					'criteria' => $criteria,
				));	
 
	    	}
	    	
 
                             
                             
                             
                             
                                             $this->render('visitsforsales',array(
                                                                           'userid'=>$userid ,          
                                                                           'model'=>$model ,         
                                                                           'pages' => $pages,                         
                                                                           'allleads'=>$allleads ,
                                                                           'allcampaign'=>$allcampaign,
                                                                           'allproject'=>$allproject,
                                                                           'allsales'=>$allsales,
                                                                           'allplatform'=>$allplatform ,
                                                                           'allplaces'=>$allplaces,
                                                                           'allstatues'=>$allstatues,
                                                                           'alltelesales'=>$alltelesales,
                                                                           'allbranch'=>$allbranch,
 
 
                                                                           'dataProvider'=>$dataProvider ,
 
 
 
                                                            ));
                              }
 
 
                              else{
                                             $model=new LoginForm;
                                             // if it is ajax validation request
                                             if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
                                                            echo CActiveForm::validate($model);
                                                            Yii::app()->end();
                                             }
                                             // collect user input data
                                             if(isset($_POST['LoginForm'])){
                                                            $model->attributes=$_POST['LoginForm'];
                                                            // validate user input and redirect to the previous page if valid
                                                            if($model->validate() && $model->login())
                                                            $this->redirect(array('login/index')            );
                                             }
                                             // display the login form
                                             $this->redirect(array('home/index')          );
                              }
 
               }






public function actionSearchvisittelesales(){
    
    
		Yii::app()->user->setState('visit', $_GET['Search']);
		$this->redirect(array('searchvisits'));
	}




	public function actionSearchvisits(){

if(Yii::app()->user->isMember()){

		$userid=Yii::app()->user->id;
                $user=User::model()->findByPk($userid);
			$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");      
		if(empty($_GET['Search']) && Yii::app()->user->hasState('visit'))
		$_GET['Search'] = Yii::app()->user->getState('visit');

		if(isset($_GET['Search'])){


			$criteria = new CDbCriteria();
			$criteria->order = 'id DESC';
			if(!empty($_GET['Search']['user']))
			$criteria->addSearchCondition('user_id', $_GET['Search']['user'],false, "AND");

			if(!empty($_GET['Search']['startdate']) && !empty($_GET['Search']['enddate'] ))
			$criteria->addBetweenCondition("date",$_GET['Search']['startdate'],$_GET['Search']['enddate'],'AND');
	


			$dataProvider = new CActiveDataProvider('Visit', array(
					'pagination' => array(
						'pageSize' =>50,
					),
					'criteria' => $criteria,
				));	

	
		}

$pdf=TRUE;



if(isset($_POST['downloadpdf'])){
                        $allleadss=Visit::model()->findAll($criteria);

			

				$mpdf= Yii::app()->ePdf->mpdf('ar-s');

		  

				ini_set('max_execution_time', 300);
				ini_set('memory_limit', '-1');
				$html = $this->renderPartial('//marketing/_visit',array('allleadss'=>$allleadss,'user' => $user,'today' => $today,'time' => $time), true);
	

				$main=Mainsettings::model()->findByPk(1);	    
				$mpdf1 = new mPDF('s','A4','','',10,10,80,35,10,10);
				$mpdf1->SetHTMLHeader('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->headerphoto.'">');
				$mpdf1->SetHTMLFooter('<img style="overflow:hidden; margin:0 ;width:100%" src="'.Yii::app()->getBaseUrl(true) .'/img/'.$main->footerphoto.'">'.'{PAGENO}');

				$mpdf1->SetProtection(array('print'));
				$mpdf1->SetTitle('VisitLeads');
				$mpdf1->SetAuthor("Solid.");
				$mpdf1->SetDisplayMode('fullpage');
				$mpdf1->SetAutoFont('4');		  
				$mpdf1->WriteHTML($html);


				$file_name= 'VisitLeads.pdf';
				ob_end_clean();
				$mpdf1->Output($file_name,'I' );
			}



		$this->render('upcomingteleseales', array(
															
				'userid' => $userid,									
				'pdf' => $pdf,					
				'dataProvider' => $dataProvider,
        
      

											
			));
			
			
	}else{
			$model=new LoginForm;
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			// collect user input data
			if(isset($_POST['LoginForm'])){
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate() && $model->login())
				$this->redirect(array('home/index')	);
			}
			// display the login form
			$this->redirect(array('home/index')	);
		}
	}





public function actionMissedvisit($id){



	if(Yii::app()->user->isMember()){

		$userid=Yii::app()->user->id;
		$main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s"); 

		$visit=Visit::model()->findByPk($id);

		$newmodel=new Activities();
		$newmodel->user_id = $userid;
		$newmodel->date = $today;
		$newmodel->details= $_POST['details'];
		$newmodel->follow_date= $visit->date;
		$newmodel->type= 1 ;
		$newmodel->time = $time;
		$newmodel->code= $_POST['form_token'];
                $url= $_POST['page'];

		$lead=Leads::model()->findByPk($visit->lead_id);
		 
$lead->follow_date=$newmodel->follow_date;                               
$lead->follow_time=$newmodel->follow_time;
$lead->action_time=$newmodel->time;

                                $lead->checkup_activity=$today; 
                                $lead->visitactive=NULL;
                                $lead->save();
		$newmodel->lead_date=$lead->date;
		$newmodel->name=$lead->title;
		$newmodel->tel=$lead->tel;
		$newmodel->status=$lead->status;
		$newmodel->leads_id = $lead->id;
		$newmodel->coldcall = $lead->coldcall;
		$newmodel->indirect = $lead->indirect;

		if($newmodel->save()){
			$newmodel->secert=$newmodel->id;
			if($newmodel->save()){

				
                                $visit->missed=1;
                                $visit->reason=$_POST['details'];
                                $visit->save();

                                //add best sales
                                $userid=Yii::app()->user->id;


  $main = Mainsettings::model()->findByPk(1);
                if ($main->countrytimezone !== null) {
                date_default_timezone_set($main->countrytimezone);
                } else {
                // Handle the case when the Mainsettings record with primary key 1 is not found
                $main = Mainsettings::model()->findByPk(1);if ($main->countrytimezone !== null) {date_default_timezone_set($main->countrytimezone);   } else { date_default_timezone_set('Africa/Cairo');};
                }
                            	$today = date("Y-m-d");
                                $best = Bestsales::model()->findByAttributes(array('user_sales'=>$userid,'date'=>$today));
                                if(!empty($best)){
                                    $best->actnum+=1;
                                    $best->save();
                                }else{
                                    $best =new Bestsales();
                                    $best->user_sales=$userid;
                                    $best->date=$today;
                                    $best->actnum=1;
                                    $best->save();
                                }
                                //add bestsales




                                        $user=User::model()->findByPk($lead->user_sales);
					if(!empty($user->player_id)){
						$content = array(
							"en" => $lead->title.' Missed a Meeting                  Press Here To Open Profile '
						);
		
						 $mainapp=Mainsettings::model()->findByPk(1);
						$fields = array(
							'app_id' =>"$main->appkey",
							'include_player_ids' => array($user->player_id),
							'data' => array("foo" => "bar"),
							'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$lead->secert ,
							'contents' => $content
						);
		
						$fields = json_encode($fields);
    			
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
						curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
								'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
						curl_setopt($ch, CURLOPT_HEADER, FALSE);
						curl_setopt($ch, CURLOPT_POST, TRUE);
						curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

						$response = curl_exec($ch);
						curl_close($ch);




					}else{
					
					}
					if(!empty($user->player_id_mobile)){
						$content = array(
							"en" => $lead->title.' Missed a Meeting                  Press Here To Open Profile '
						);
		
						 $mainapp=Mainsettings::model()->findByPk(1);
						$fields = array(
							'app_id' =>"$main->appkey",
							'include_player_ids' => array($user->player_id_mobile),
							'data' => array("foo" => "bar"),
							'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$lead->secert ,
							'contents' => $content
						);
		
						$fields = json_encode($fields);
    			
						$ch = curl_init();
						curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
						curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
								'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
						curl_setopt($ch, CURLOPT_HEADER, FALSE);
						curl_setopt($ch, CURLOPT_POST, TRUE);
						curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
						curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

						$response = curl_exec($ch);
						curl_close($ch);




					}else{
					
					}
					


					//notification to team leader



					$criteria = new CDbCriteria;
					$criteria->addCondition('sales_id=' . $user->id);
					$leader=Teamleader::model()->find($criteria);
					$leader=User::model()->findByPk($leader->leader_id);
					if(!empty($leader)){
						if(!empty($leader->player_id)){
							$content = array(
								"en" => $lead->title.' Missed a Meeting                  Press Here To Open Profile '
							);
							
							$fields = array(
								'app_id' => "d55878ac-5a32-444a-90c8-d9a053cad61c",
								'include_player_ids' => array($leader->player_id),
								'data' => array("foo" => "bar"),
								'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$lead->secert ,
								'contents' => $content
							);
							
							$fields = json_encode($fields);
					    			
							$ch = curl_init();
							curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
							curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
									'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
							curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
							curl_setopt($ch, CURLOPT_HEADER, FALSE);
							curl_setopt($ch, CURLOPT_POST, TRUE);
							curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
							curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

							$response = curl_exec($ch);
							curl_close($ch);
						}else{
						
						}



						if(!empty($leader->player_id_mobile)){
							$content = array(
								"en" => $lead->title.' Missed a Meeting                  Press Here To Open Profile '
							);
							
							$fields = array(
								'app_id' => "d55878ac-5a32-444a-90c8-d9a053cad61c",
								'include_player_ids' => array($leader->player_id_mobile),
								'data' => array("foo" => "bar"),
								'url' => Yii::app()->getBaseUrl(true).'/leads/profile/'.$lead->secert ,
								'contents' => $content
							);
							
							$fields = json_encode($fields);
					    			
							$ch = curl_init();
							curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
							curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
									'Authorization: Basic NGEwMGZmMjItY2NkNy0xMWUzLTk5ZDUtMDAwYzI5NDBlNjJj'));
							curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
							curl_setopt($ch, CURLOPT_HEADER, FALSE);
							curl_setopt($ch, CURLOPT_POST, TRUE);
							curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
							curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

							$response = curl_exec($ch);
							curl_close($ch);
						}else{
						
						}
                                         
                                if($url ==1 )
                                $this->redirect(array('upcomingtelesales')	);else{$this->redirect(array('marketing/upcomingvisit')	);}
                                }else{
				if($url ==1 )	
                                $this->redirect(array('upcomingtelesales')	);else{$this->redirect(array('marketing/upcomingvisit')	);}
								}

			}
			
		}else{
              if($url ==1 )
              $this->redirect(array('upcomingtelesales')	);else{$this->redirect(array('marketing/upcomingvisit')	);}
		}







	}else{
		$model=new LoginForm;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form'){
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if(isset($_POST['LoginForm'])){
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
			$this->redirect(array('home/index')	);
		}
		// display the login form
		$this->redirect(array('home/index')	);
	}


}


	

}