<?php

class StaticwordsController extends FrontController 
{

	 public $layout='//layouts/system';


/**
* @return array action filters
*/
public function filters()
{
	return array(
	'accessControl', // perform access control for CRUD operations
	);
}

/**
* Specifies the access control rules.
* This method is used by the 'accessControl' filter.
* @return array access control rules
*/
public function accessRules()
{
return array(

        array('allow', // allow authenticated users to perform any action
            'users'=>array('@'),
            'expression' => 'Yii::app()->user->isMember()',
        ),
        array('deny',  // deny all users
            'users'=>array('*'),
        ),
    );
}

/**
* Displays a particular model.
* @param integer $id the ID of the model to be displayed
*/
public function actionView($id)
{
	

	$this->render('view',array(
	'model'=>$this->loadModel($id),
	));
}

/**
* Creates a new model.
* If creation is successful, the browser will be redirected to the 'view' page.
*/
public function actionCreate()
{
	$model=new Staticwords;

	


	// Uncomment the following line if AJAX validation is needed
	// $this->performAjaxValidation($model);

	if(isset($_POST['Staticwords']))
	{
		$model->attributes=$_POST['Staticwords'];
		if($model->save())
		$this->redirect(array('view','id'=>$model->id));
	}

	$this->render('create',array(
	'model'=>$model,
	));
}

/**
* Updates a particular model.
* If update is successful, the browser will be redirected to the 'view' page.
* @param integer $id the ID of the model to be updated
*/
public function actionUpdate($id)
{

	$model=$this->loadModel($id);

	
	// Uncomment the following line if AJAX validation is needed
	// $this->performAjaxValidation($model);

	if(isset($_POST['Staticwords']))
	{
		$model->attributes=$_POST['Staticwords'];
		if($model->save())
		$this->redirect(array('view','id'=>$model->id));
	}

	$this->render('update',array(
	'model'=>$model,
	));
}

/**
* Deletes a particular model.
* If deletion is successful, the browser will be redirected to the 'admin' page.
* @param integer $id the ID of the model to be deleted
*/
public function actionDelete($id)
{
	if(Yii::app()->request->isPostRequest)
	{
		// we only allow deletion via POST request
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
		$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
	}
	else
	throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
}


/**
* Manages all models.
*/
public function actionIndex()
{

	$model=new Staticwords('search');

	
	$model->unsetAttributes();  // clear any default values
	if(isset($_GET['Staticwords']))
	$model->attributes=$_GET['Staticwords'];

	$this->render('index',array(
	'model'=>$model,
));
}

/**
* Returns the data model based on the primary key given in the GET variable.
* If the data model is not found, an HTTP exception will be raised.
* @param integer the ID of the model to be loaded
*/
public function loadModel($id)
{
	$model=Staticwords::model()->findByPk($id);
	if($model===null)
	throw new CHttpException(404,'The requested page does not exist.');
	return $model;
}

/**
* Performs the AJAX validation.
* @param CModel the model to be validated
*/
protected function performAjaxValidation($model)
{
	if(isset($_POST['ajax']) && $_POST['ajax']==='staticwords-form')
	{
		echo CActiveForm::validate($model);
		Yii::app()->end();
	}
}
}