<?php

/**
 * This is the model class for table "active_partners".
 *
 * The followings are the available columns in table 'active_partners':
 * @property integer $id
 * @property integer $lead_id
 * @property string $company_name
 * @property string $partner_name
 * @property string $business_consultant
 * @property string $phone_number
 * @property string $finance_contact_number
 * @property string $email
 * @property string $location
 * @property string $app_id
 * @property string $contract_date
 * @property string $tax_id
 * @property string $cr_id
 * @property string $vat_id_date
 * @property string $advance_payment
 * @property string $referral_form
 * @property string $category
 * @property string $last_activity_date
 * @property string $status
 * @property string $notes
 * @property string $created_at
 * @property string $updated_at
 *
 * The followings are the available model relations:
 * @property Leads $lead
 */
class ActivePartners extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'active_partners';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('lead_id, company_name, partner_name', 'required'),
			array('lead_id', 'numerical', 'integerOnly'=>true),
			array('company_name, partner_name, business_consultant, email, location, referral_form', 'length', 'max'=>255),
			array('phone_number, finance_contact_number', 'length', 'max'=>50),
			array('app_id, tax_id, cr_id, category', 'length', 'max'=>100),
			array('advance_payment', 'length', 'max'=>3),
			array('status', 'length', 'max'=>8),
			array('contract_date, vat_id_date, last_activity_date, notes, created_at, updated_at', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, lead_id, company_name, partner_name, business_consultant, phone_number, finance_contact_number, email, location, app_id, contract_date, tax_id, cr_id, vat_id_date, advance_payment, referral_form, category, last_activity_date, status, notes, created_at, updated_at', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'lead' => array(self::BELONGS_TO, 'Leads', 'lead_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'lead_id' => 'Lead',
			'company_name' => 'Company Name',
			'partner_name' => 'Partner Name',
			'business_consultant' => 'Business Consultant',
			'phone_number' => 'Phone Number',
			'finance_contact_number' => 'Finance Contact Number',
			'email' => 'Email',
			'location' => 'Location',
			'app_id' => 'App',
			'contract_date' => 'Contract Date',
			'tax_id' => 'Tax',
			'cr_id' => 'Cr',
			'vat_id_date' => 'Vat Id Date',
			'advance_payment' => 'Advance Payment',
			'referral_form' => 'Referral Form',
			'category' => 'Category',
			'last_activity_date' => 'Last Activity Date',
			'status' => 'Status',
			'notes' => 'Notes',
			'created_at' => 'Created At',
			'updated_at' => 'Updated At',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('company_name',$this->company_name,true);
		$criteria->compare('partner_name',$this->partner_name,true);
		$criteria->compare('business_consultant',$this->business_consultant,true);
		$criteria->compare('phone_number',$this->phone_number,true);
		$criteria->compare('finance_contact_number',$this->finance_contact_number,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('app_id',$this->app_id,true);
		$criteria->compare('contract_date',$this->contract_date,true);
		$criteria->compare('tax_id',$this->tax_id,true);
		$criteria->compare('cr_id',$this->cr_id,true);
		$criteria->compare('vat_id_date',$this->vat_id_date,true);
		$criteria->compare('advance_payment',$this->advance_payment,true);
		$criteria->compare('referral_form',$this->referral_form,true);
		$criteria->compare('category',$this->category,true);
		$criteria->compare('last_activity_date',$this->last_activity_date,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('created_at',$this->created_at,true);
		$criteria->compare('updated_at',$this->updated_at,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ActivePartners the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
