<?php

/**
 * This is the model class for table "activities".
 *
 * The followings are the available columns in table 'activities':
 * @property integer $id
 * @property integer $user_id
 * @property integer $too
 * @property integer $leads_id
 * @property integer $units_id
 * @property integer $whois
 * @property string $date
 * @property string $time
 * @property string $secert
 * @property string $follow_date
 * @property integer $type
 * @property string $details
 * @property string $status
 * @property string $name

 * @property string $tel

 */
class Activities extends CActiveRecord
{
    
    
    
    
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'activities';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
            array('code', 'unique'),
			array('code', 'required'),
			array('user_id, too, leads_id,broker_id, whois, units_id, type,close, usermeet,confirm,hidden,hideteamleader,coldcall,indirect,star,marketing_id,expvisit,callback,sort,notfi ', 'numerical', 'integerOnly'=>true),
			array('follow_time, status, name, tel,code, substatus,notes', 'length', 'max'=>255),
			array('details, report, follow_date,follow_time, date, time, secert,confirm,hidden,lead_date,coldcall,callback,notfi', 'safe'),
			
			//array( 'follow_date', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'follow_time', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'status', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'name', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'tel', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'code', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'substatus', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'too', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'whois', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'usermeet', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'secert', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			//array( 'report', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			//array( 'details', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),



			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, too, leads_id, follow_date,follow_time, details, status, substatus,report,close, date,confirm, time, type, secert,lead_date,marketing_id,expvisit,notfi', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(

		'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
		'employee2'    => array(self::BELONGS_TO, 'User',    'too'),


'statuesaction'    => array(self::BELONGS_TO, 'Statues',    'status'),
'substatusaction'    => array(self::BELONGS_TO, 'Substatus',    'substatus'),

'client'    => array(self::BELONGS_TO, 'Leads',    'leads_id'),



		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'leads_id' => 'Leads',
                        'units_id' => 'Units',
			'follow_date' => 'follow_date',
			'follow_time' => 'follow_time',
			'type' => 'Type',
			'details' => 'Details',
			'status' => 'Status',
			'usermeet' => 'Usermeet',
                        'whois' => 'Whois',
                        'name' => 'Name',
                        'tel' => 'Tel',
			'secert' => 'Secert',
			'date' => 'Date',
			'time' => 'Time',
			'report' => 'Report',
			'close' => 'Close',
			'confirm' => 'Confirm',
			'too' => 'Too',
			'hidden' => 'Hidden',
			'substatus' => 'Substatus',
			'lead_date' => 'Lead_date',
	'coldcall' => 'Coldcall',
		'marketing_id' => 'marketing id',
		'expvisit' => 'expvisit',
		'callback' => 'callback',
			

			

			



		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('leads_id',$this->leads_id);
		$criteria->compare('units_id',$this->units_id);
		$criteria->compare('close',$this->close);
		$criteria->compare('confirm',$this->confirm);
		$criteria->compare('report',$this->report,true);
		$criteria->compare('follow_date',$this->follow_date,true);
		$criteria->compare('follow_time',$this->follow_time,true);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('substatus',$this->status,true);
                $criteria->compare('name',$this->name,true);
                $criteria->compare('tel',$this->tel,true);
                $criteria->compare('usermeet',$this->usermeet,true);
		$criteria->compare('secert',$this->secert,true);
                $criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('too',$this->too,true);
		$criteria->compare('hidden',$this->hidden,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}




		
		
		
		public function lateforsales()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;
        $start = '2019-01-01';
        $end = date('Y-m-d', strtotime("-1 days"));
        

       // $criteria->addCondition('coldcall IS NULL AND broker_id IS NULL AND indirect IS NULL');

        
      

        
        
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        $criteria = new CDbCriteria;
        $criteria->condition = "close IS NULL && too IS NULL && broker_id IS NULL  && coldcall IS  NULL";
        

        $agent=User::model()->findByPk($userid);
        if($agent->sales ==1 or $agent->telesales ==1 ){
        $criteria->addCondition('user_id=' . $userid);
        }else{
        $criteria->addCondition('marketing_id=' . $userid);
        
        //var_dump($userid);exit;
        }   
        
        //	$criteria->addCondition('user_id=' . $userid);
        $criteria->order = 'follow_date DESC';
        $start = '2018-01-1';
        $check = date('Y-m-d', strtotime("-1 days"));
        $criteria->addBetweenCondition("follow_date",$start,$check);



		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
	
		public function lateforsalescold()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;
        $start = '2019-01-01';
        $end = date('Y-m-d', strtotime("-1 days"));
        

       // $criteria->addCondition('coldcall IS NULL AND broker_id IS NULL AND indirect IS NULL');

        
      

        
        
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        $criteria = new CDbCriteria;
        $criteria->condition = "close IS NULL && too IS NULL && broker_id IS NULL  && coldcall IS  NULL";
        
        
        $agent=User::model()->findByPk($userid);
        if($agent->sales ==1 or $agent->telesales ==1 ){
        $criteria->addCondition('user_id=' . $userid);
        }else{
        $criteria->addCondition('marketing_id=' . $userid);
        
        //var_dump($userid);exit;
        }   
        
        //	$criteria->addCondition('user_id=' . $userid);
        $criteria->order = 'follow_date DESC';
        $start = '2018-01-1';
        $check = date('Y-m-d', strtotime("-1 days"));
        $criteria->addBetweenCondition("follow_date",$start,$check);



		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
		
		
		



		public function lateforadmin()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;
        $start = '2019-01-01';
        $end = date('Y-m-d', strtotime("-1 days"));
        

       // $criteria->addCondition('coldcall IS NULL AND broker_id IS NULL AND indirect IS NULL');

        
        $criteria->condition = "close IS NULL AND too IS NULL AND close IS NULL";
        
        
        if($_GET['cold']==1){
        $criteria->addCondition('coldcall IS NOT NULL');
        }else if($_GET['cold']==2){
        $criteria->addCondition('coldcall IS NULL');
        }
        
        if($_GET['indirect']==1){
        $criteria->addCondition('indirect IS NOT NULL');
        }else if($_GET['indirect']==2){
        $criteria->addCondition('indirect IS NULL AND broker_id IS NULL');
        }
        
	        $criteria->addBetweenCondition("follow_date",$start,$end,'AND');


		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
	
	
	
	
	


		public function dailyactivitiesforadmin()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
		
		 	$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

        $close = 1; 
        $criteria = new CDbCriteria();             
        $criteria->addSearchCondition('date', $today, false);
        if($_GET['cold']==1){
        $criteria->addCondition('coldcall IS NOT NULL');
        }else if($_GET['cold']==2){
        $criteria->addCondition('coldcall IS NULL');
        }
        if($_GET['indirect']==1){
        $criteria->addCondition('indirect IS NOT NULL');
        }else if($_GET['indirect']==2){
        $criteria->addCondition('indirect IS NULL AND broker_id IS NULL');
        }
        if(!empty($_GET['sales'])){
        $criteria->addSearchCondition('user_id', $_GET['sales'] , false);
        }
        if($_GET['broker']==1){
        $criteria->addCondition('broker_id IS NOT NULL');
        }


        
		$criteria->compare('date',$this->date);
		$criteria->compare('time',$this->time);
		$criteria->compare('follow_time',$this->follow_time, true);
		$criteria->compare('follow_date',$this->follow_date);
		$criteria->compare('tel',$this->tel, true);
		$criteria->compare('name',$this->name, true);
		$criteria->compare('status',$this->status);
		$criteria->compare('substatus',$this->substatus);
		$criteria->compare('details',$this->details, true);
		
        $sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort'); 
        $sort->attributes = array(
            'name'=>array(
                'asc'=>'name ASC',
                'desc'=>'name DESC',
            ),
            'telephone'=>array(
                'asc'=>'tel ASC',
                'desc'=>'tel DESC',
            ),
            'date'=>array(
                'asc'=>'date ASC',
                'desc'=>'date DESC',
            ),
            'time'=>array(
                'asc'=>'ime ASC',
                'desc'=>'time DESC',
            ),
            'follow_date'=>array(
                'asc'=>'follow_date ASC',
                'desc'=>'follow_date DESC',
            ),
            'follow_time'=>array(
                'asc'=>'follow_time ASC',
                'desc'=>'follow_time DESC',
            ),
            'details'=>array(
                'asc'=>'details ASC',
                'desc'=>'details DESC',
            ),
            'status'=>array(
                'asc'=>'status ASC',
                'desc'=>'status DESC',
            ),
            'substatus'=>array(
                'asc'=>'substatus ASC',
                'desc'=>'substatus DESC',
            ),
            '*', 
        );

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>$sort,
		));
	}
	
	
	
	
	
	
	
	
		public function freshactivitiesforadmin()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		
		
		$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);
 $criteria = new CDbCriteria(); 
$userid=Yii::app()->user->id;
$allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
$arr=array();
foreach($allemployee as $leader){
$arr[]=$leader->sales_id;
}             
//$criteria->addCondition('close=' . $close);
$criteria->condition = "close IS NULL";
//$criteria->addInCondition('user_id', $arr);
//$criteria->condition = "report IS NULL";
$start = date('Y-m-d');
$end = date('Y-m-d');

$criteria->addBetweenCondition("follow_date",$start,$end,'AND');
if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}
if($_GET['indirect']==1){
$criteria->addCondition('indirect IS NOT NULL');
}else if($_GET['indirect']==2){
$criteria->addCondition('indirect IS NULL AND broker_id IS NULL');
}

if($_GET['broker']==1){
$criteria->addCondition('broker_id IS NOT NULL');
if(!empty($_GET['sales'])){
$criteria->addSearchCondition('user_id', $_GET['sales'] , false);
}
}
	
        
        
		$criteria->compare('date',$this->date);
		$criteria->compare('follow_time',$this->follow_time, true);
		$criteria->compare('follow_date',$this->follow_date, true);
		$criteria->compare('tel',$this->tel, true);
		$criteria->compare('name',$this->name, true);
		$criteria->compare('status',$this->status);
		$criteria->compare('substatus',$this->substatus);
		$criteria->compare('details',$this->details, true);
		
        $sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort'); 
        $sort->attributes = array(
            'name'=>array(
                'asc'=>'name ASC',
                'desc'=>'name DESC',
            ),
            'telephone'=>array(
                'asc'=>'tel ASC',
                'desc'=>'tel DESC',
            ),
            'follow_time'=>array(
                'asc'=>'follow_time ASC',
                'desc'=>'follow_time DESC',
            ),
            'details'=>array(
                'asc'=>'details ASC',
                'desc'=>'details DESC',
            ),
            'status'=>array(
                'asc'=>'status ASC',
                'desc'=>'status DESC',
            ),
            'substatus'=>array(
                'asc'=>'substatus ASC',
                'desc'=>'substatus DESC',
            ),
            '*', 
        );

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>$sort,
		));
	}
	

	
	
	
		
	
	
		public function freshactivitiesforsales()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;
       
       	$userid=Yii::app()->user->id;
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");                     // 03.10.01
		$time = date("H:i:s");                      // 17:16:18	
		$rnd = rand(0,99999);

       
        $criteria->condition = "close IS NULL && too IS NULL && broker_id IS NULL  && coldcall IS  NULL";
		
            if (isset($_REQUEST['marketing'])) {
            $marketing =  $_REQUEST['marketing'];
           // $criteria->addCondition('marketing_id=' . $marketing);
            
            
         $currentUserId = Yii::app()->user->id;
        if ($currentUserId) {
        
        //var_dump($currentUserId);exit;
        // استعلام للحصول على جميع المعلومات من جدول المستخدمين بناءً على معرف المستخدم
        $userInfo = Yii::app()->db->createCommand()
        ->select('*') // اختر جميع الأعمدة أو الأعمدة التي تحتاجها فقط
        ->from('user') // اسم جدول المستخدمين
        ->where('id=:userId', array(':userId' => $currentUserId))
        ->queryRow();
        
        // Ensure limitsformarketing is an array, even if it's not set or empty
        $limitsArray = isset($userInfo['limitsformarketing']) 
        ? $userInfo['limitsformarketing'] 
        : [];
        
        
        // Check if limitsArray is not empty
        if (!empty($limitsArray)) {

        if (!is_array($limitsArray)) {
        $limitsArray = (array)$limitsArray;
        }
        
        
         
         if (!in_array($currentUserId, $limitsArray)) {
            $limitsArray[] = $currentUserId;
        }
        
        
        
        // Convert the limitsArray to a comma-separated string
        $limitsString = implode(',', $limitsArray);
        // Ensure limitsString is not empty before adding the condition
        if (!empty($limitsString)) {
            
         //var_dump($limitsString);exit;
        // Display the contents of $limitsString for debugging
        //var_dump($limitsString);
        //exit; // Stop execution to view the output of var_dump
        
        // Add search condition using IN clause for user_id
      $criteria->addCondition("marketing_id IN (" . $limitsString . ")");
        }
        } else {

 $criteria->addCondition(" marketing_id = " . $userid);



}


}

            
            
            }else{
            $criteria->addCondition('user_id=' . $userid);
            
            
            }
		$criteria->order = 'follow_date DESC';
		$start = '2018-01-1';
		$check = date('Y-m-d');
		$criteria->addBetweenCondition("follow_date",$today,$today);
        
        
        
		$criteria->compare('date',$this->date);
		$criteria->compare('follow_time',$this->follow_time, true);
		$criteria->compare('follow_date',$this->follow_date, true);
		$criteria->compare('tel',$this->tel, true);
		$criteria->compare('name',$this->name, true);
		$criteria->compare('status',$this->status);
		$criteria->compare('substatus',$this->substatus);
		$criteria->compare('details',$this->details, true);
		
        $sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort'); 
        $sort->attributes = array(
            'name'=>array(
                'asc'=>'name ASC',
                'desc'=>'name DESC',
            ),
            'telephone'=>array(
                'asc'=>'tel ASC',
                'desc'=>'tel DESC',
            ),
            'follow_time'=>array(
                'asc'=>'follow_time ASC',
                'desc'=>'follow_time DESC',
            ),
            'details'=>array(
                'asc'=>'details ASC',
                'desc'=>'details DESC',
            ),
            'status'=>array(
                'asc'=>'status ASC',
                'desc'=>'status DESC',
            ),
            'substatus'=>array(
                'asc'=>'substatus ASC',
                'desc'=>'substatus DESC',
            ),
            '*', 
        );

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>$sort,
		));
	}
	


protected function beforeSave()
{
    if (parent::beforeSave()) {
        // تعيين marketing_id ليكون user_id الخاص بالعميل
        $this->marketing_id = $this->client->user_id;
        return true;
    } else {
        return false;
    }
}








	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Activities the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}





}
