<?php

/**
 * This is the model class for table "check_method".
 *
 * The followings are the available columns in table 'check_method':
 * @property integer $id
 * @property string $date
 * @property string $time
 * @property integer $user_id
 * @property integer $lead_id
 * @property integer $tree_id
 * @property integer $reservation_id
 * @property integer $installment_id
 * @property string $image
 * @property string $due_date
 * @property integer $send_to_bank
 * @property string $send_date
 * @property integer $refused
 * @property string $refuse_date
 * @property integer $confirm
 * @property string $confirm_date
 * @property integer $restriction_id
 */
class CheckMethod extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'check_method';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
            array('image', 'file', 'types'=>'jpg, pdf, png, xlsx, csv, cad, xls','safe' => true ,'allowEmpty' => true),
			array('date, time, user_id, lead_id, reservation_id, installment_id, image, due_date', 'required'),
			array('user_id, lead_id, tree_id, reservation_id, installment_id, send_to_bank, refused, confirm, restriction_id , cheqe_id , banker_id ', 'numerical', 'integerOnly'=>true),
			array('image', 'length', 'max'=>255),
			array('send_date, refuse_date, confirm_date', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, time, user_id, lead_id, tree_id, reservation_id, installment_id, image, due_date, send_to_bank, send_date, refused, refuse_date, confirm, confirm_date, restriction_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
'installment'    => array(self::BELONGS_TO, 'Installments',    'installment_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'time' => 'Time',
			'user_id' => 'User',
			'lead_id' => 'Lead',
			'tree_id' => 'Tree',
			'reservation_id' => 'Reservation',
			'installment_id' => 'Installment',
			'image' => 'Image',
			'due_date' => 'Due Date',
			'send_to_bank' => 'Send To Bank',
			'send_date' => 'Send Date',
			'refused' => 'Refused',
			'refuse_date' => 'Refuse Date',
			'confirm' => 'Confirm',
			'confirm_date' => 'Confirm Date',
			'restriction_id' => 'Restriction',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('tree_id',$this->tree_id);
		$criteria->compare('reservation_id',$this->reservation_id);
		$criteria->compare('installment_id',$this->installment_id);
		$criteria->compare('image',$this->image,true);
		$criteria->compare('due_date',$this->due_date,true);
		$criteria->compare('send_to_bank',$this->send_to_bank);
		$criteria->compare('send_date',$this->send_date,true);
		$criteria->compare('refused',$this->refused);
		$criteria->compare('refuse_date',$this->refuse_date,true);
		$criteria->compare('confirm',$this->confirm);
		$criteria->compare('confirm_date',$this->confirm_date,true);
		$criteria->compare('restriction_id',$this->restriction_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CheckMethod the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
