<?php

/**
 * This is the model class for table "company".
 *
 * The followings are the available columns in table 'company':
 * @property integer $id
 * @property string $name
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property string $email
 * @property integer $secert
 * @property string $details
 * @property integer $close
 * @property integer $datesearch
 * @property integer $installments
 * @property integer $platform
 * @property integer $statues
 * @property integer $place
 * @property integer $receipt
 * @property integer $closed
 * @property integer $duplicate
 * @property integer $communication
 * @property integer $feedback
 */
class Company extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'company';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name, user_id, date, time,category_id, secert', 'required'),
			array('user_id, secert,category_id, close, datesearch, installments, platform, statues, place, receipt, closed, duplicate, communication, feedback', 'numerical', 'integerOnly'=>true),
			array('name, email, details', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, name, user_id, date, time, email, secert, details, close, datesearch, installments, platform, statues, place, receipt, closed, duplicate, communication, feedback', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'name' => 'Name',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'email' => 'Email',
			'secert' => 'Secert',
			'details' => 'Details',
			'close' => 'Close',
			'datesearch' => 'Datesearch',
			'installments' => 'Installments',
			'platform' => 'Platform',
			'statues' => 'Statues',
			'place' => 'Place',
			'receipt' => 'Receipt',
			'closed' => 'Closed',
			'duplicate' => 'Duplicate',
			'communication' => 'Communication',
			'feedback' => 'Feedback',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('secert',$this->secert);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('close',$this->close);
		$criteria->compare('datesearch',$this->datesearch);
		$criteria->compare('installments',$this->installments);
		$criteria->compare('platform',$this->platform);
		$criteria->compare('statues',$this->statues);
		$criteria->compare('place',$this->place);
		$criteria->compare('receipt',$this->receipt);
		$criteria->compare('closed',$this->closed);
		$criteria->compare('duplicate',$this->duplicate);
		$criteria->compare('communication',$this->communication);
		$criteria->compare('feedback',$this->feedback);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Company the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
