<?php

/**
 * This is the model class for table "customerservice".
 *
 * The followings are the available columns in table 'customerservice':
 * @property integer $id
 * @property integer $user_id
 * @property integer $employee_id
 * @property integer $lead_id
 * @property string $date
 * @property string $time
 * @property string $details
 * @property integer $service_id
 * @property string $report
 * @property integer $Secret
 * @property string $follow_date
 * @property integer $seen
 */
class Customerservice extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'customerservice';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, employee_id, lead_id, service_id, Secret, seen,done,unit_id', 'numerical', 'integerOnly'=>true),
			array('date, time, details, report, follow_date, follow_time,tel,secondtel,name,tickettype', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, employee_id, lead_id, date, time, details, service_id, report, Secret, follow_date, follow_time, seen,tel,secondtel,name,tickettype', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    

		'employee'    => array(self::BELONGS_TO, 'User',    'employee_id'),	
		'service'    => array(self::BELONGS_TO, 'Services',    'service_id'),
		'user'    => array(self::BELONGS_TO, 'User',    'user_id'),	
		'lead'    => array(self::BELONGS_TO, 'Leads',    'lead_id'),
		
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'employee_id' => 'Employee',
			'lead_id' => 'Lead',
			'date' => 'Date',
			'time' => 'Time',
			'details' => 'Details',
			'service_id' => 'Service',
			'report' => 'Report',
			'Secret' => 'Secret',
			'follow_date' => 'Follow Date',
			'seen' => 'Seen',
			'follow_time' => 'Follow Time',
			'tickettype' => 'tickettype',
			
			
			
			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;
$criteria->order = 'date DESC';
$criteria->addCondition('Secret IS NOT NULL');
		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('lead_id',$this->lead_id);
		
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('service_id',$this->service_id);
		$criteria->compare('report',$this->report,true);
		$criteria->compare('Secret',$this->Secret);
		$criteria->compare('follow_date',$this->follow_date,true);
		$criteria->compare('seen',$this->seen);

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
	
		public function searchtickets()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

            $criteria = new CDbCriteria();

            				$criteria->order = 'date DESC';
            				
            				$criteria->addCondition('Secret IS NOT NULL');


            $criteria->addSearchCondition('lead_id', $_REQUEST['lead'],false, "AND");
            $criteria->addBetweenCondition("date",$_REQUEST['startdate2'],$_REQUEST['enddate2'],'AND');
            if($_REQUEST['confirm']==1){
            $criteria->addSearchCondition('done', $_REQUEST['confirm'],false, "AND");
            }else if($_REQUEST['confirm']==2){
            $criteria->addSearchCondition('done', $_REQUEST['confirm'],false, "AND");
            }else if($_REQUEST['confirm']==4){
            $criteria->addSearchCondition('done', $_REQUEST['confirm'],false, "AND");
            }else if($_REQUEST['confirm']==3){
			    
			//    var_dump($_REQUEST['confirm']);exit;
			   $criteria->addCondition('done IS NULL');
		
			}
            if(sizeOf($_REQUEST['user'])>1){
            $criteria->addInCondition('user_id', $_REQUEST['user'] , "AND");
            }
            

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
	
	
	

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Customerservice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
