<?php

/**
 * This is the model class for table "dailyrestrictions".
 *
 * The followings are the available columns in table 'dailyrestrictions':
 * @property integer $id
 * @property string $date
 * @property string $time
 * @property integer $user_id
 * @property integer $tree_id
 * @property integer $banker_id
 * @property string $details
 * @property double $amount
 * @property string $code
 * @property string $secret
 */
class Dailyrestrictions extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'dailyrestrictions';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, time, user_id, tree_id,tree_id_to, details, amount, code, secret', 'required'),
			array('user_id,all_id,tree_id_to, tree_id, building_tree, unit_id, cancel, lead_id', 'numerical', 'integerOnly'=>true),
				
			array('amount', 'numerical'),
			array('details, code, secret,file,object_id', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, time, user_id,tree_id_to, tree_id, banker_id, details, amount, code, secret, building_tree, unit_id, cancel, lead_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
		'tree'    => array(self::BELONGS_TO, 'Treeaccount',    'tree_id'),
		'treeto'    => array(self::BELONGS_TO, 'Treeaccount',    'tree_id_to'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'time' => 'Time',
			'user_id' => 'User',
			'tree_id' => 'Tree',
			'tree_id_to' => 'Tree To',
			'details' => 'Details',
			'amount' => 'Amount',
			'code' => 'Code',
			'secret' => 'Secret',
			'file' => 'File',
			'building_tree' => 'Building Tree',
			'unit_id' => 'Unit Tree',
			'cancel' => 'Cancel',
						'lead_id' => 'Lead',

		


			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('tree_id',$this->tree_id);
		$criteria->compare('tree_id_to',$this->tree_id_to);
		$criteria->compare('banker_id',$this->banker_id);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('amount',$this->amount);
		$criteria->compare('code',$this->code,true);
		$criteria->compare('secret',$this->secret,true);
		$criteria->compare('file',$this->file,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Dailyrestrictions the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
