<?php

/**
 * This is the model class for table "designmaterials".
 *
 * The followings are the available columns in table 'designmaterials':
 * @property integer $id
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property string $title
 * @property integer $building_id
 * @property integer $section_id
 * @property string $image
 * @property integer $secret
 * @property integer $hidden
 * @property integer $filetype
 * @property integer $confirm
 */
class Designmaterials extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'designmaterials';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
		       
            array('image', 'file', 'types'=>'jpg, pdf, png, xlsx, csv, cad, xls','safe' => true ,'allowEmpty' => true),
 array('secret','unique'),
			array('user_id, date, time, title, building_id, section_id, image, secret, filetype', 'required'),
			array('user_id, building_id, section_id, secret, hidden, filetype, confirm', 'numerical', 'integerOnly'=>true),
			array('title, image', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, date, time, title, building_id, section_id, image, secret, hidden, filetype, confirm', 'safe', 'on'=>'search'), 
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
'building'    => array(self::BELONGS_TO, 'Building',    'building_id'),
'section'    => array(self::BELONGS_TO, 'Designbuilding',    'section_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'title' => 'Title',
			'building_id' => 'Building',
			'section_id' => 'Section',
			'image' => 'Image',
			'secret' => 'Secret',
			'hidden' => 'Hidden',
			'filetype' => 'Filetype',
			'confirm' => 'Confirm',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('building_id',$this->building_id);
		$criteria->compare('section_id',$this->section_id);
		$criteria->compare('image',$this->image,true);
		$criteria->compare('secret',$this->secret);
		$criteria->compare('hidden',$this->hidden);
		$criteria->compare('filetype',$this->filetype);
		$criteria->compare('confirm',$this->confirm);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Designmaterials the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
