<?php

/**
 * This is the model class for table "fb_lead_form".
 *
 * The followings are the available columns in table 'fb_lead_form':
 * @property integer $id
 * @property string $name
 * @property string $email
 * @property string $tel
 * @property string $ad_name
 * @property string $adset_name
 * @property string $fb_id
 * @property string $ad_id
 * @property string $job
 * @property string $campaign_name
 * @property string $campaign_id
 * @property string $form_id
 * @property string $date
 */
class FbLeadForm extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'fb_lead_form';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('tel ', 'required'),
			array('name, email, tel, ad_name, adset_name, fb_id, ad_id, job, campaign_name, campaign_id, form_id, typeunit,unitsize,callingtime,formlocation, reason', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, name, email, tel, ad_name, adset_name,lead_id,callcenter, fb_id, ad_id, job, campaign_name, campaign_id, form_id, date, typeunit,unitsize,callingtime,formlocation, reason', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'name' => 'Name',
			'email' => 'Email',
			'tel' => 'Tel',
			'ad_name' => 'Ad Name',
			'adset_name' => 'Adset Name',
			'fb_id' => 'Fb',
			'ad_id' => 'Ad',
			'job' => 'Job',
			'campaign_name' => 'Campaign Name',
			'campaign_id' => 'Campaign',
			'form_id' => 'Form',
			'date' => 'Date',
			'typeunit' => 'Typeunit',
			'reason' => 'Reason',
			
			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	 
	 
	     
	 
	 
	 
	 
	 	public function callcenter()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;
		$website = 1; 
        $criteria = new CDbCriteria(); 
        $criteria->order = 'id DESC';
        $criteria->addSearchCondition('callcenter', $website, false);
        $criteria->addCondition('lead_id IS  NULL');
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
	
	 	public function fbleads()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;
		$website = 1; 
        $criteria = new CDbCriteria(); 
        $criteria->order = 'id DESC';
        $criteria->addCondition('callcenter IS  NULL');
        $criteria->addCondition('website IS  NULL');
        $criteria->addCondition('lead_id IS  NULL');
        $criteria->addCondition('lead_id IS  NULL');
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
		
	
	
	 	public function websiteleads()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;
		$website = 1; 
        $criteria = new CDbCriteria(); 
        $criteria->order = 'id DESC';
        $criteria->addCondition('callcenter IS  NULL');
        $criteria->addCondition('website IS NOT  NULL');
        $criteria->addCondition('lead_id IS  NULL');
        $criteria->addCondition('lead_id IS  NULL');
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}




	 
	 
	 
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('tel',$this->tel,true);
		$criteria->compare('ad_name',$this->ad_name,true);
		$criteria->compare('adset_name',$this->adset_name,true);
		$criteria->compare('fb_id',$this->fb_id,true);
		$criteria->compare('ad_id',$this->ad_id,true);
		$criteria->compare('job',$this->job,true);
		$criteria->compare('campaign_name',$this->campaign_name,true);
		$criteria->compare('campaign_id',$this->campaign_id,true);
		$criteria->compare('form_id',$this->form_id,true);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('typeunit',$this->typeunit,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FbLeadForm the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
