<?php

/**
 * This is the model class for table "hr_take_appointment".
 *
 * The followings are the available columns in table 'hr_take_appointment':
 * @property integer $id
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property integer $applicant_id
 * @property string $first_interview_date
 * @property string $second_interview_date
 * @property integer $mobile_number
 * @property string $assign_recruiter
 * @property string $response_of_interview
 * @property string $email
 */
class HrTakeAppointment extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'hr_take_appointment';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, date, time, applicant_id, first_interview_date, mobile_number, assign_recruiter, response_of_interview, email', 'required'),
			array('user_id, applicant_id, mobile_number', 'numerical', 'integerOnly'=>true),
			array('assign_recruiter, response_of_interview, email', 'length', 'max'=>255),
			array('second_interview_date', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, date, time, applicant_id, first_interview_date, second_interview_date, mobile_number, assign_recruiter, response_of_interview, email', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'applicant_id' => 'Applicant',
			'first_interview_date' => 'First Interview Date',
			'second_interview_date' => 'Second Interview Date',
			'mobile_number' => 'Mobile Number',
			'assign_recruiter' => 'Assign Recruiter',
			'response_of_interview' => 'Response Of Interview',
			'email' => 'Email',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('applicant_id',$this->applicant_id);
		$criteria->compare('first_interview_date',$this->first_interview_date,true);
		$criteria->compare('second_interview_date',$this->second_interview_date,true);
		$criteria->compare('mobile_number',$this->mobile_number);
		$criteria->compare('assign_recruiter',$this->assign_recruiter,true);
		$criteria->compare('response_of_interview',$this->response_of_interview,true);
		$criteria->compare('email',$this->email,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrTakeAppointment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
