<?php
class Leads extends CActiveRecord
{
    
    
    
     protected function beforeFind()
{
    // استدعاء الدالة الأصلية
    parent::beforeFind();

    // احصل على معرف المستخدم الحالي من الجلسة
    $currentUserId = Yii::app()->user->id;

    // تحقق من أن المعرف موجود
    if ($currentUserId) {
        // استعلام للحصول على جميع المعلومات من جدول المستخدمين بناءً على معرف المستخدم
        $userInfo = Yii::app()->db->createCommand()
            ->select('*') // اختر جميع الأعمدة أو الأعمدة التي تحتاجها فقط
            ->from('user') // اسم جدول المستخدمين
            ->where('id=:userId', array(':userId' => $currentUserId))
            ->queryRow();



        
        // Check if limitsformanager is not empty
        if (!empty($userInfo['limitsformanager'])) {
            
        $limitsArray = is_string($userInfo['limitsformanager']) ? explode(',', $userInfo['limitsformanager']) : $userInfo['limitsformanager'];
        
        // إضافة شرط الاستعلام بناءً على limitsformanager و currentUserId
        $this->getDbCriteria()->addCondition('user_sales IN (' . implode(',', array_map('intval', $limitsArray)) . ') OR user_integration = :userId');
        
        $this->getDbCriteria()->params[':userId'] = $currentUserId;    





        }
        
        
        
        
    
    
    if (!empty($this->limitsformarketing)) {
    // تحويل limitsformanager إلى مصفوفة إذا كانت سلسلة نصية مفصولة بفواصل
    $limitsArray = is_string($this->limitsformarketing) ? explode(',', $this->limitsformarketing) : $this->limitsformarketing;
    
    // إضافة شرط الاستعلام بناءً على limitsformanager
    $this->getDbCriteria()->addCondition('user_id IN (' . implode(',', array_map('intval', $limitsArray)) . ')');
}



    return true; // تأكد من إرجاع true للسماح بمتابعة الاستعلام
}
}
    
        

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'leads';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
	    $main=Mainsettings::model()->findByPk(1);
	    if(empty($main->system_duplicate)){
	      return array(
            array('secert,code','unique'),
            
			array('user_id, date, time, title, tel, strategy_id, hidden', 'required'),
			array('transfer_branch,block_duplicate,user_id, campaign_id,visit,expvisit, strategy_id,interest_id, user_marketing, user_sales, receipt, reopen, communication, status,substatus, statusfeedback, 	qualified, hidden, client_id, platform_id, platformchild_id, backtolife, backtolifetransfer, secert, duplicate, transfer,coldcall,indirect, feedback, close, confirmclose, international_code, international_code2,international_code3,international_code4,distribute_id,recommendation,branch, countduplicate, nonqualified, clear, pending_visit,allowduplicate, unseenauto,user_integration,fake,first_classification_user,first_classification,lastreport,callback,mediabuyer,orgrainc,first_communication,oldid,transferfrom,transferuser,eoi,visitactive', 'numerical', 'integerOnly'=>true),
			array('bimsi,contract_date,wallet_amount,questions,answers,title, second_tel,tel,tel3,tel4, feedback_report, facebook_id, career,upload, email, adsetname, adname, nameonmobile,pudget_note,space_note,unit_type,fakedate,title2,interstedin,avtocall,transferreason,counttransfer,code ,othersubstatus,ai_date,marital_status,monthly_income,property_type,client_type,idcard, integratedplatform, integratedplatformchild, integratedmarketing,reason,purchasemethod,addresss,nationality,budget,country,numberofrooms,clienttype,support,banktype,typeofproperty', 'length', 'max'=>255),
			array('communicate_date, follow_date,follow_time,action_time, followfeedback_date, checkup_activity, communicate_time,visit,expvisit,fake_id user_sales_date, transferdate,feedback_date, feedback, details,  close_date, feedback_report,last_duplicate, user_sales_time,email, sales_report, notes, hiddenactivtiesdate, 	duplicate_date,allowduplicate, unseenauto, dtime,fake,fakedate,first_classification,first_classification_user,title2,lastreport,callback,units,status_date,substatus_date,transferreason,counttransfer,transferfrom,transferuser,dup_platforms,othersubstatus,ai_date ,ai_details,eoi,tags,whatsapp_sid,whatsapp_token,whatsapp_from,whatsapp_templatesid_1,whatsapp_templatesid_2,whatsapp_templatesid_3,whatsapp_templatesid_4,marital_status,monthly_income,property_type,client_type,idcard, integratedplatform, integratedplatformchild, integratedmarketing,reason,purchasemethod,addresss,nationality,budget,country,numberofrooms,clienttype,support,banktype,typeofproperty', 'safe'),
			// The following rule is used by search().
			
			
			array( 'title', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'title2', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'tel', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'second_tel', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'feedback_report', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'email', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'adsetname', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'adname', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'facebook_id', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'career', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'international_code', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'international_code2', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	//array( 'sales_report', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	array( 'visit', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	//array( 'details', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	array( 'interest_id', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	array( 'status', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	array( 'substatus', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	array( 'statusfeedback', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	array( 'platform_id', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	array( 'platformchild_id', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	array( 'campaign_id', 'filter', 'filter' => array( 'CHtml', 'encode' ) ), 
	    	array( 'project_id', 'filter', 'filter' => array( 'CHtml', 'encode' ) ), 

			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, date,last_duplicate, time, title, tel, second_tel,interest_id, career, reopen, communicate_date, communicate_time, details, campaign_id, backtolife, backtolifetransfer, followfeedback_date, strategy_id, user_marketing, user_sales, user_sales_date, transferdate,checkup_activity, user_sales_time,upload, receipt, communication, status,substatus, statusfeedback, qualified, hidden, client_id, platform_id, platformchild_id, feedback_date, close_date, notes, sales_report,visit,expvisit,email,international_code, international_code2, secert,feedback_report, duplicate, feedback, transfer, close, confirmclose, adsetname, adname,distribute_id,recommendation, hiddenactivtiesdate,branch, duplicate_date, nonqualified, clear,first_classification_user,project_id,fresh_sales ', 'safe', 'on'=>'search'),
	        array('id, user_id, user_sales, fresh_sales, start_date, end_date, start_follow_date, end_follow_date, start_upload_date, end_upload_date, start_transfer_date, end_transfer_date, campaign_id, platform_id, status, substatus, unit_type, property_type, client_type', 'safe', 'on' => 'searchdataanalysislead'),
		);
		  
	    }else{
	        return array(
            array('secert','unique'),
			array('user_id, date, time, title, tel, strategy_id, hidden', 'required'),
			array('transfer_branch,user_id, campaign_id,visit, strategy_id,interest_id, user_marketing, user_sales, receipt, reopen, communication, status,substatus, statusfeedback, 	qualified, hidden, client_id, platform_id, platformchild_id, backtolife, backtolifetransfer, secert, duplicate, transfer,coldcall,indirect, feedback, close, confirmclose, international_code, international_code2,distribute_id,recommendation,branch, countduplicate, nonqualified, clear, pending_visit,allowduplicate, unseenauto,user_integration,first_classification_user,createlead', 'numerical', 'integerOnly'=>true),
			array('bimsi,contract_date,wallet_amount,title, second_tel,tel,tel3,tel4, feedback_report, facebook_id, career,upload, email, adsetname, adname, nameonmobile,pudget_note,space_note,unit_type,company,city', 'length', 'max'=>255),
			array('communicate_date, follow_date,follow_time,action_time, followfeedback_date, checkup_activity, communicate_time,visit,fake_id user_sales_date, transferdate,feedback_date, feedback, details,  close_date, feedback_report,last_duplicate, user_sales_time,email, sales_report, notes, hiddenactivtiesdate, 	duplicate_date,allowduplicate, unseenauto, dtime,company,city,createdate,createlead,project_id', 'safe'),
			// The following rule is used by search().
			
			array( 'title', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'tel', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'second_tel', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'feedback_report', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'email', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'adsetname', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'adname', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'facebook_id', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'career', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'international_code', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'international_code2', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	//array( 'sales_report', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	array( 'visit', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	//array( 'details', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	array( 'interest_id', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	array( 'status', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	array( 'substatus', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	array( 'statusfeedback', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	array( 'platform_id', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	array( 'platformchild_id', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
	    	array( 'campaign_id', 'filter', 'filter' => array( 'CHtml', 'encode' ) ), 
	    	array( 'project_id', 'filter', 'filter' => array( 'CHtml', 'encode' ) ), 
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, date,last_duplicate, time, title, tel, second_tel,interest_id, career, reopen, communicate_date, communicate_time, details, campaign_id, backtolife, backtolifetransfer, followfeedback_date, strategy_id, user_marketing, user_sales, user_sales_date, transferdate,checkup_activity, user_sales_time,upload, receipt, communication, status,substatus, statusfeedback, qualified, hidden, client_id, platform_id, platformchild_id, feedback_date, close_date, notes, sales_report,visit,email,international_code, international_code2, secert,feedback_report, duplicate, feedback, transfer, close, confirmclose, adsetname, adname,distribute_id,recommendation, hiddenactivtiesdate,branch, duplicate_date, nonqualified, clear,first_classification,first_classification_user,fresh_sales', 'safe', 'on'=>'search'),
            array(
                'id, user_id, user_sales, fresh_sales, user_sales_filter_type, user_sales_not_value,
                start_date, end_date, start_follow_date, end_follow_date,
                start_upload_date, end_upload_date, start_transfer_date, end_transfer_date,
                start_duplicate_date, end_duplicate_date, start_fake_date, end_fake_date,
                start_except_transfer_date, end_except_transfer_date,
                start_last_action_date, end_last_action_date, campaign_id, platform_id, status, substatus, unit_type, property_type, client_type',
                'safe', 'on' => 'searchdataanalysislead'
            ),		
        );
	    }
	}
	
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
    		'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
    		'campaign'    => array(self::BELONGS_TO, 'Campaign',    'campaign_id'),
    		'sales'    => array(self::BELONGS_TO, 'User',    'user_sales'),
    		'disto'    => array(self::BELONGS_TO, 'User',    'user_integration'),
    		'freshsales'    => array(self::BELONGS_TO, 'User',    'fresh_sales'),
    		'project'    => array(self::BELONGS_TO, 'Projects',    'project_id'),
    		'unittype'    => array(self::BELONGS_TO, 'TypeBuliding',    'unit_type'),
    		'salesadmin'    => array(self::BELONGS_TO, 'User',    'user_id'),
            'marketing'    => array(self::BELONGS_TO, 'User',    'user_id'),
            'usermarketing'    => array(self::BELONGS_TO, 'User',    'user_marketing'),
            'created'    => array(self::BELONGS_TO, 'User',    'createlead'),
            'platform'    => array(self::BELONGS_TO, 'Platform',    'platform_id'),
            'platformchild'  => array(self::BELONGS_TO, 'PlatformChild',    'platformchild_id'),
            'statuesaction'    => array(self::BELONGS_TO, 'Statues',    'status'),
            'substatusaction'    => array(self::BELONGS_TO, 'Substatus',    'substatus'),
            'othersubstatusaction'    => array(self::BELONGS_TO, 'Substatus',    'othersubstatus'),
            'strategyaction'    => array(self::BELONGS_TO, 'Strategy',    'strategy_id'),
            'propertytype' => array(self::BELONGS_TO, 'TypeBuliding', 'property_type'),
            'place'  => array(self::BELONGS_TO, 'Interestedplace',    'interest_id'),
            'branchtitle'  => array(self::BELONGS_TO, 'Branch',    'branch'),
		);
	}
	
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'title' => 'Title',
			'title2' => 'Title2',
			'tel' => 'Tel',
			'second_tel' => 'Second Tel',
			'career' => 'Career',
			'communicate_date' => 'Communicate Date',
			'communicate_time' => 'Communicate Time',
			'campaign_id' => 'Campaign',
			'strategy_id' => 'Strategy',
			'user_marketing' => 'User Marketing',
			'user_sales' => 'User Sales',
			'user_sales_date' => 'User Sales Date',
			'user_sales_time' => 'User Sales Time',
			'receipt' => 'Receipt',
			'communication' => 'Communication',
			'status' => 'Status',
			'statusfeedback' => 'Statusfeedback',
			'qualified' => 'Qualified',
			'substatus' => 'Sub Status',
			'hidden' => 'Hidden',
			'client_id' => 'Client',
			'notes' => 'Notes',
			'sales_report' => 'Sales Report',
			'secert' => 'Secert',
			'duplicate' => 'Duplicate',
			'upload' => 'Upload',
			'transfer' => 'Transfer',
			'transferdate' => 'Transferdate',
			'platform_id' => 'Platform_id',
			'platformchild_id' => 'Platformchild_id',
			'feedback_date' => 'Feedback_date',
			'close_date' => 'Close_date',
			'feedback_report' => 'Feedback_report',
			'close' => 'close',
			'distribute_id ' => 'Distribute id ',
			'visit' => 'Visit',
			'feedback' => 'Feedback',
			'followfeedback_date' => 'Followfeedback_date',
			'interest_id' => 'interest_id',
			'international_code' => 'International code',
			'international_code2' => 'International code 2',
			'checkup_activity' => 'Checkup Activity',
			'last_duplicate' => 'Last Duplicate',
			'facebook_id' => 'Facebook',
			'email' => 'Email',
            'adsetname' => 'Ad Set Name',
            'adname' => 'Ad Name',
            'confirmclose' => 'Confirm Close',
            'details' => 'Details',
            'reopen' => 'Reopen',
            'recommendation' => 'Recommendation',
            'hiddenactivtiesdate' => 'Hiddenactivtiesdate',
            'branch' => 'Branch',
            'nonqualified' => 'Nonqualified',
            'clear' => 'Clear',
            'pending_visit' => 'Pending visit',
            'allowduplicate' => 'Allow Duplicate',
            'first_classification' => 'First classification',
            'expvisit' => 'exp visit',
            'lastreport' => 'Lastreport',
            'callback' => 'callback',
            'units' => 'units',
            'status_date' => 'Statusdate',
            'substatus_date' => 'Substatusdate',
            'transferreason' => 'Transferreason',
            'tags' => 'Tags',
			'fresh_sales' => 'Fresh Sales',
		);
	}
	
	public function getClientStatus()
    {
        switch ($this->client_id) {
            case 1: return "Reservation under Review";
            case 2: return "Reservation";
            case 3: return "Contracted";
            case 4: return "Cancel";
            default: return "";
        }
    }
    
	public function search()
	{
		$criteria=new CDbCriteria;
		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('last_duplicate',$this->last_duplicate,true);
		$criteria->compare('checkup_activity',$this->checkup_activity,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('upload',$this->upload,true);
		$criteria->compare('followfeedback_date',$this->followfeedback_date,true);
		$criteria->compare('backtolife',$this->backtolife,true);
	    $criteria->compare('backtolifetransfer',$this->backtolifetransfer,true);
		$criteria->compare('international_code',$this->international_code,true);
		$criteria->compare('international_code2',$this->international_code2,true);
		$criteria->compare('tel',$this->tel,true);
		$criteria->compare('second_tel',$this->second_tel,true);
		$criteria->compare('career',$this->career,true);
		$criteria->compare('communicate_date',$this->communicate_date,true);
		$criteria->compare('communicate_time',$this->communicate_time,true);
		$criteria->compare('campaign_id',$this->campaign_id);
		$criteria->compare('interest_id',$this->interest_id);
		$criteria->compare('strategy_id',$this->strategy_id);
		$criteria->compare('user_marketing',$this->user_marketing);
		$criteria->compare('user_sales',$this->user_sales);
		$criteria->compare('fresh_sales',$this->fresh_sales);
		$criteria->compare('user_sales_date',$this->user_sales_date,true);
		$criteria->compare('user_sales_time',$this->user_sales_time,true);
		$criteria->compare('receipt',$this->receipt);
		$criteria->compare('communication',$this->communication);
		$criteria->compare('status',$this->status);
		$criteria->compare('substatus',$this->substatus);
		$criteria->compare('statusfeedback',$this->statusfeedback);
		$criteria->compare('hidden',$this->hidden);
		$criteria->compare('client_id',$this->client_id);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('sales_report',$this->sales_report,true);
		$criteria->compare('secert',$this->secert);
        $criteria->compare('duplicate',$this->duplicate);
        $criteria->compare('transfer',$this->transfer);
        $criteria->compare('transferdate',$this->transfer);
        $criteria->compare('platform_id',$this->platform_id);
        $criteria->compare('platformchild_id',$this->platformchild_id);
        $criteria->compare('close',$this->close);
        $criteria->compare('confirmclose',$this->confirmclose);
        $criteria->compare('feedback',$this->feedback);
        $criteria->compare('visit',$this->visit);
        $criteria->compare('feedback_report',$this->feedback_report);
        $criteria->compare('adsetname',$this->adsetname);
        $criteria->compare('adname',$this->adname);
        $criteria->compare('confirmclose',$this->confirmclose);
        $criteria->compare('distribute_id ',$this->distribute_id );
        $criteria->compare('recommendation ',$this->recommendation );
        $criteria->compare('hiddenactivtiesdate ',$this->hiddenactivtiesdate );
        $criteria->compare('branch ',$this->branch );
        $criteria->compare('nonqualified ',$this->nonqualified );
        $criteria->compare('clear ',$this->clear );
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
    public $start_date;
    public $end_date;
    public $start_follow_date;
    public $end_follow_date;
    public $start_upload_date;
    public $end_upload_date;
    public $start_transfer_date;
    public $end_transfer_date;
    public $start_duplicate_date;
    public $end_duplicate_date;
    public $start_fake_date;
    public $end_fake_date;
    public $start_except_transfer_date;
    public $end_except_transfer_date;
    public $start_last_action_date;
    public $end_last_action_date;
    public $user_sales_filter_type;
    public $user_sales_not_value;
    public $campaign_id;
    public $platform_id;
    public $status;
    public $substatus;
    public $unit_type;
    public $property_type;
    public $client_type;
	public $fresh_sales;
	
    public function searchdataanalysislead() {
        
        $criteria = new CDbCriteria;
    
        if (!empty($this->id)) {
            Yii::log("Filtering by id: " . $this->id, 'info');
            $criteria->compare('id', $this->id, true);
        }
        if (!empty($this->user_id)) {
            Yii::log("Filtering by added by: " . $this->user_id, 'info');
            $criteria->compare('user_id', $this->user_id);
        }
        if (!empty($this->campaign_id)) {
            Yii::log("Filtering by campaign: " . $this->campaign_id, 'info');
            $criteria->compare('campaign_id', $this->campaign_id);
        }
        if (!empty($this->platform_id)) {
            Yii::log("Filtering by platform: " . $this->platform_id, 'info');
            $criteria->compare('platform_id', $this->platform_id);
        }
        if (!empty($this->status)) {
            Yii::log("Filtering by status: " . $this->status, 'info');
            $criteria->compare('status', $this->status);
        }
        if (!empty($this->substatus)) {
            Yii::log("Filtering by substatus: " . $this->substatus, 'info');
            $criteria->compare('substatus', $this->substatus);
        }
        if (!empty($this->unit_type)) {
            Yii::log("Filtering by unit_type: " . $this->unit_type, 'info');
            $criteria->compare('unit_type', $this->unit_type);
        }
        if (!empty($this->property_type)) {
            Yii::log("Filtering by property_type: " . $this->property_type, 'info');
            $criteria->compare('property_type', $this->property_type);
        }
        if (!empty($this->client_type)) {
            Yii::log("Filtering by client_type: " . $this->client_type, 'info');
            $criteria->compare('client_type', $this->client_type);
        }
        if ($this->user_sales_filter_type === 'isEmpty') {
            $criteria->addCondition('(user_sales IS NULL)');
        } elseif ($this->user_sales_filter_type === 'isNotEmpty') {
            $criteria->addCondition('(user_sales IS NOT NULL)');
        } elseif ($this->user_sales_filter_type === 'isNot' && $this->user_sales_not_value !== '') {
            $criteria->addCondition('user_sales != :notUserSales');
            $criteria->params[':notUserSales'] = $this->user_sales_not_value;
        } else {
            if (!empty($this->user_sales)) {
                if (is_array($this->user_sales)) {
                    $criteria->addInCondition('user_sales', $this->user_sales);
                } else {
                    $criteria->compare('user_sales', $this->user_sales);
                }
            }
        }
        if (!empty($this->fresh_sales)) {
            if (is_array($this->fresh_sales)) {
                $criteria->addInCondition('fresh_sales', $this->fresh_sales);
            } else {
                $criteria->compare('fresh_sales', $this->fresh_sales);
            }
        }
        //Start & End Dates
        if (!empty($this->start_date)) {
            $criteria->addCondition('date >= :startDate');
            $criteria->params[':startDate'] = date('Y-m-d', strtotime($this->start_date));
        }
        if (!empty($this->end_date)) {
            $criteria->addCondition('date <= :endDate');
            $criteria->params[':endDate'] = date('Y-m-d', strtotime($this->end_date));
        }
        //Start & End Follow Dates
        if (!empty($this->start_follow_date)) {
            Yii::log("Filtering by start_follow_date: " . $this->start_follow_date, 'info');
            $criteria->addCondition('follow_date >= :startFollowDate');
            $criteria->params[':startFollowDate'] = date('Y-m-d', strtotime($this->start_follow_date));
        }
        if (!empty($this->end_follow_date)) {
            Yii::log("Filtering by end_follow_date: " . $this->end_follow_date, 'info');
            $criteria->addCondition('follow_date <= :endFollowDate');
            $criteria->params[':endFollowDate'] = date('Y-m-d', strtotime($this->end_follow_date));
        }
        //Start & End Upload Dates
        if (!empty($this->start_upload_date)) {
            Yii::log("Filtering by start_upload_date: " . $this->start_upload_date, 'info');
            $criteria->addCondition('sysdate >= :startUploadDate');
            $criteria->params[':startUploadDate'] = date('Y-m-d', strtotime($this->start_upload_date));
        }
        if (!empty($this->end_upload_date)) {
            Yii::log("Filtering by end_upload_date: " . $this->end_upload_date, 'info');
            $criteria->addCondition('sysdate <= :endUploadDate');
            $criteria->params[':endUploadDate'] = date('Y-m-d', strtotime($this->end_upload_date));
        }
        //Start & End Transfer Dates
        if (!empty($this->start_transfer_date)) {
            Yii::log("Filtering by start_transfer_date: " . $this->start_transfer_date, 'info');
            $criteria->addCondition('transferdate >= :startTransferDate');
            $criteria->params[':startTransferDate'] = date('Y-m-d', strtotime($this->start_transfer_date));
        }
        if (!empty($this->end_transfer_date)) {
            Yii::log("Filtering by end_transfer_date: " . $this->end_transfer_date, 'info');
            $criteria->addCondition('transferdate <= :endTransferDate');
            $criteria->params[':endTransferDate'] = date('Y-m-d', strtotime($this->end_transfer_date));
        }
        //Start & End Except Transfer Dates
        if (!empty($this->start_except_transfer_date)) {
            Yii::log("Filtering by start_except_transfer_date: " . $this->start_except_transfer_date, 'info');
            $criteria->addCondition('transferdate >= :startExceptTransferDate');
            $criteria->params[':startExceptTransferDate'] = date('Y-m-d', strtotime($this->start_except_transfer_date));
        }
        if (!empty($this->end_except_transfer_date)) {
            Yii::log("Filtering by end_except_transfer_date: " . $this->end_except_transfer_date, 'info');
            $criteria->addCondition('transferdate <= :endExceptTransferDate');
            $criteria->params[':endExceptTransferDate'] = date('Y-m-d', strtotime($this->end_except_transfer_date));
        }
    
        Yii::log("Model Criteria Params: " . print_r($criteria->params, true), 'info');
        $dataProvider = new CActiveDataProvider($this, array(
            'criteria' => $criteria,
 'pagination' => array(
        'pageSize' => (isset($_GET['pageSize']) ? (int) $_GET['pageSize'] : Yii::app()->params['defaultPageSize']),
    ),        ));

        Yii::log("Filtered Item Count: " . $dataProvider->getTotalItemCount(), 'info');
        return $dataProvider;
        
    }




	public function searchadmin()
	{
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        $start = '2012-01-01'; 
        $end = date('Y-m-d');
        
        $criteria=new CDbCriteria;
        
		if(!empty($_REQUEST['search']) ){
			$criteria->addSearchCondition('title', $_REQUEST['search'],TRUE, "AND");
		}
		if($_REQUEST['client_id']==1){
			$criteria->addSearchCondition('client_id', 1 ,false, "AND");
		}else if($_REQUEST['client_id']==2){ 
			$criteria->addCondition('client_id IS NULL');
		}else{
		}	
		if($_REQUEST['callback']==1){
			$criteria->addSearchCondition('callback', 1 ,false, "AND");
		}else if($_REQUEST['callback']==2){ 
			$criteria->addCondition('callback IS NULL');
		}else{
		}
		if(!empty($_REQUEST['email']) ){
			$criteria->addSearchCondition('email', $_REQUEST['email'],TRUE, "AND");
		}	
		if(!empty($_REQUEST['notuserids']) ){
		    $arrayofsalesx=explode(',',$_REQUEST['notuserids']);
			$criteria->addNotInCondition('user_id', $arrayofsalesx ,'AND'); 
		}	
	if (!empty($_REQUEST['team']) && is_array($_REQUEST['team'])) {
    $arr = array();
    foreach ($_REQUEST['team'] as $teamleader_id) {
        $allemployee = Teamleader::model()->findAll(array(
            'condition' => 'leader_id=' . (int)$teamleader_id,
            'order' => 'id DESC'
        ));
        foreach ($allemployee as $leader) {
            $arr[] = $leader->sales_id;
        }
    }
    if (!empty($arr)) {
        $criteria->addInCondition('user_sales', $arr, "AND");
    }
}	
		if(!empty($_REQUEST['details']) ){
			$criteria->addSearchCondition('details', $_REQUEST['details'],TRUE, "AND");
		}
		
		
		
        if(!empty($_REQUEST['transferreason']) ){
        $criteria->addSearchCondition('transferreason', $_REQUEST['transferreason'],TRUE, "AND");
        }
        
        
        
        
        
        		
        if(!empty($_REQUEST['career']) ){
        $criteria->addSearchCondition('career', $_REQUEST['career'],TRUE, "AND");
        }


		
		
        if(!empty($_REQUEST['fb_id']) ){
			$criteria->addSearchCondition('facebook_id', $_REQUEST['fb_id'],TRUE, "AND");
		}
        if(!empty($_REQUEST['adsetname']) ){
			$criteria->addSearchCondition('adsetname', $_REQUEST['adsetname'],TRUE, "AND");
		}
        if(!empty($_REQUEST['adname']) ){
			$criteria->addSearchCondition('adname', $_REQUEST['adname'],TRUE, "AND");
		}
		
		
		
		  if(!empty($_REQUEST['coderef']) ){
			$criteria->addSearchCondition('code', $_REQUEST['coderef'],TRUE, "AND");
		}
		
        if(!empty($_REQUEST['code']) ){
            $_REQUEST['startdate']="2008-6-30";
            $_REQUEST['enddate']=date("Y-m-d");
				$criteria->addSearchCondition('id', $_REQUEST['code'],false, "AND");
			}
            if(!empty($_REQUEST['tel2']) ){
            $_REQUEST['startdate']="2008-6-30";
            $_REQUEST['enddate']=date("Y-m-d");
            
            $phone= $_REQUEST['tel2'];
            if($phone[0]=='0')
            $phone = substr($phone , 1);
            $countrys = [
            			'44' => 'UK (+44)',
            			'213' => 'Algeria (+213)',
            			'376' => 'Andorra (+376)',
            			'244' => 'Angola (+244)',
            			'1264' => 'Anguilla (+1264)',
            			'1268' => 'Antigua & Barbuda (+1268)',
            			'54' => 'Argentina (+54)',
            			'374' => 'Armenia (+374)',
            			'297' => 'Aruba (+297)',
            			'61' => 'Australia (+61)',
            			'43' => 'Austria (+43)',
            			'994' => 'Azerbaijan (+994)',
            			'1242' => 'Bahamas (+1242)',
            			'973' => 'Bahrain (+973)',
            			'880' => 'Bangladesh (+880)',
            			'1246' => 'Barbados (+1246)',
            			'375' => 'Belarus (+375)',
            			'32' => 'Belgium (+32)',
            			'501' => 'Belize (+501)',
            			'229' => 'Benin (+229)',
            			'1441' => 'Bermuda (+1441)',
            			'975' => 'Bhutan (+975)',
            			'591' => 'Bolivia (+591)',
            			'387' => 'Bosnia Herzegovina (+387)',
            			'267' => 'Botswana (+267)',
            			'55' => 'Brazil (+55)',
            			'673' => 'Brunei (+673)',
            			'359' => 'Bulgaria (+359)',
            			'226' => 'Burkina Faso (+226)',
            			'257' => 'Burundi (+257)',
            			'855' => 'Cambodia (+855)',
            			'237' => 'Cameroon (+237)',
            			'238' => 'Cape Verde Islands (+238)',
            			'1345' => 'Cayman Islands (+1345)',
            			'236' => 'Central African Republic (+236)',
            			'56' => 'Chile (+56)',
            			'86' => 'China (+86)',
            			'57' => 'Colombia (+57)',
            			'269' => 'Comoros (+269)',
            			'242' => 'Congo (+242)',
            			'682' => 'Cook Islands (+682)',
            			'506' => 'Costa Rica (+506)',
            			'385' => 'Croatia (+385)',
            			'53' => 'Cuba (+53)',
            			'90392' => 'Cyprus North (+90392)',
            			'357' => 'Cyprus South (+357)',
            			'42' => 'Czech Republic (+42)',
            			'45' => 'Denmark (+45)',
            			'253' => 'Djibouti (+253)',
            			'1809' => 'Dominica (+1809)',
            			'1809' => 'Dominican Republic (+1809)',
            			'593' => 'Ecuador (+593)',
            			'20' => 'Egypt (+20)',
            			'503' => 'El Salvador (+503)',
            			'240' => 'Equatorial Guinea (+240)',
            			'291' => 'Eritrea (+291)',
            			'372' => 'Estonia (+372)',
            			'251' => 'Ethiopia (+251)',
            			'500' => 'Falkland Islands (+500)',
            			'298' => 'Faroe Islands (+298)',
            			'679' => 'Fiji (+679)',
            			'358' => 'Finland (+358)',
            			'33' => 'France (+33)',
            			'594' => 'French Guiana (+594)',
            			'689' => 'French Polynesia (+689)',
            			'241' => 'Gabon (+241)',
            			'220' => 'Gambia (+220)',
            			'7880' => 'Georgia (+7880)',
            			'49' => 'Germany (+49)',
            			'233' => 'Ghana (+233)',
            			'350' => 'Gibraltar (+350)',
            			'30' => 'Greece (+30)',
            			'299' => 'Greenland (+299)',
            			'1473' => 'Grenada (+1473)',
            			'590' => 'Guadeloupe (+590)',
            			'671' => 'Guam (+671)',
            			'502' => 'Guatemala (+502)',
            			'224' => 'Guinea (+224)',
            			'245' => 'Guinea - Bissau (+245)',
            			'592' => 'Guyana (+592)',
            			'509' => 'Haiti (+509)',
            			'504' => 'Honduras (+504)',
            			'852' => 'Hong Kong (+852)',
            			'36' => 'Hungary (+36)',
            			'354' => 'Iceland (+354)',
            			'91' => 'India (+91)',
            			'62' => 'Indonesia (+62)',
            			'98' => 'Iran (+98)',
            			'964' => 'Iraq (+964)',
            			'353' => 'Ireland (+353)',
            			'39' => 'Italy (+39)',
            			'1876' => 'Jamaica (+1876)',
            			'81' => 'Japan (+81)',
            			'962' => 'Jordan (+962)',
            			'7' => 'Kazakhstan (+7)',
            			'254' => 'Kenya (+254)',
            			'686' => 'Kiribati (+686)',
            			'850' => 'Korea North (+850)',
            			'82' => 'Korea South (+82)',
            			'965' => 'Kuwait (+965)',
            			'996' => 'Kyrgyzstan (+996)',
            			'856' => 'Laos (+856)',
            			'371' => 'Latvia (+371)',
            			'961' => 'Lebanon (+961)',
            			'266' => 'Lesotho (+266)',
            			'231' => 'Liberia (+231)',
            			'218' => 'Libya (+218)',
            			'417' => 'Liechtenstein (+417)',
            			'370' => 'Lithuania (+370)',
            			'352' => 'Luxembourg (+352)',
            			'853' => 'Macao (+853)',
            			'389' => 'Macedonia (+389)',
            			'261' => 'Madagascar (+261)',
            			'265' => 'Malawi (+265)',
            			'60' => 'Malaysia (+60)',
            			'960' => 'Maldives (+960)',
            			'223' => 'Mali (+223)',
            			'356' => 'Malta (+356)',
            			'692' => 'Marshall Islands (+692)',
            			'596' => 'Martinique (+596)',
            			'222' => 'Mauritania (+222)',
            			'269' => 'Mayotte (+269)',
            			'52' => 'Mexico (+52)',
            			'691' => 'Micronesia (+691)',
            			'373' => 'Moldova (+373)',
            			'377' => 'Monaco (+377)',
            			'976' => 'Mongolia (+976)',
            			'1664' => 'Montserrat (+1664)',
            			'212' => 'Morocco (+212)',
            			'258' => 'Mozambique (+258)',
            			'95' => 'Myanmar (+95)',
            			'264' => 'Namibia (+264)',
            			'674' => 'Nauru (+674)',
            			'977' => 'Nepal (+977)',
            			'31' => 'Netherlands (+31)',
            			'687' => 'New Caledonia (+687)',
            			'64' => 'New Zealand (+64)',
            			'505' => 'Nicaragua (+505)',
            			'227' => 'Niger (+227)',
            			'234' => 'Nigeria (+234)',
            			'683' => 'Niue (+683)',
            			'672' => 'Norfolk Islands (+672)',
            			'670' => 'Northern Marianas (+670)',
            			'47' => 'Norway (+47)',
            			'968' => 'Oman (+968)',
            			'680' => 'Palau (+680)',
            			'507' => 'Panama (+507)',
            			'675' => 'Papua New Guinea (+675)',
            			'595' => 'Paraguay (+595)',
            			'51' => 'Peru (+51)',
            			'63' => 'Philippines (+63)',
            			'48' => 'Poland (+48)',
            			'351' => 'Portugal (+351)',
            			'1787' => 'Puerto Rico (+1787)',
            			'974' => 'Qatar (+974)',
            			'262' => 'Reunion (+262)',
            			'40' => 'Romania (+40)',
            			'7' => 'Russia (+7)',
            			'250' => 'Rwanda (+250)',
            			'378' => 'San Marino (+378)',
            			'239' => 'Sao Tome & Principe (+239)',
            			'966' => 'Saudi Arabia (+966)',
            			'221' => 'Senegal (+221)',
            			'381' => 'Serbia (+381)',
            			'248' => 'Seychelles (+248)',
            			'232' => 'Sierra Leone (+232)',
            			'65' => 'Singapore (+65)',
            			'421' => 'Slovak Republic (+421)',
            			'386' => 'Slovenia (+386)',
            			'677' => 'Solomon Islands (+677)',
            			'252' => 'Somalia (+252)',
            			'27' => 'South Africa (+27)',
            			'34' => 'Spain (+34)',
            			'94' => 'Sri Lanka (+94)',
            			'290' => 'St. Helena (+290)',
            			'1869' => 'St. Kitts (+1869)',
            			'1758' => 'St. Lucia (+1758)',
            			'249' => 'Sudan (+249)',
            			'597' => 'Suriname (+597)',
            			'268' => 'Swaziland (+268)',
            			'46' => 'Sweden (+46)',
            			'41' => 'Switzerland (+41)',
            			'963' => 'Syria (+963)',
            			'886' => 'Taiwan (+886)',
            			'7' => 'Tajikstan (+7)',
            			'66' => 'Thailand (+66)',
            			'228' => 'Togo (+228)',
            			'676' => 'Tonga (+676)',
            			'1868' => 'Trinidad & Tobago (+1868)',
            			'216' => 'Tunisia (+216)',
            			'90' => 'Turkey (+90)',
            			'7' => 'Turkmenistan (+7)',
            			'993' => 'Turkmenistan (+993)',
            			'1649' => 'Turks & Caicos Islands (+1649)',
            			'688' => 'Tuvalu (+688)',
            			'256' => 'Uganda (+256)',
            			'380' => 'Ukraine (+380)',
            			'971' => 'United Arab Emirates (+971)',
            			'598' => 'Uruguay (+598)',
            			'7' => 'Uzbekistan (+7)',
            			'678' => 'Vanuatu (+678)',
            			'379' => 'Vatican City (+379)',
            			'58' => 'Venezuela (+58)',
            			'84' => 'Vietnam (+84)',
            			'84' => 'Virgin Islands - British (+1284)',
            			'84' => 'Virgin Islands - US (+1340)',
            			'681' => 'Wallis & Futuna (+681)',
            			'969' => 'Yemen (North)(+969)',
            			'967' => 'Yemen (South)(+967)',
            			'260' => 'Zambia (+260)',
            			'263' => 'Zimbabwe (+263)',
            		];
            $temp=  substr(strstr($phone, '+'),1);
            if($temp != false){$phone=$temp;}
            $countrycode='';
            // sort the array by key, descending
            krsort($countrys, SORT_NUMERIC);
            // iterate over all countries
            foreach($countrys as $we => $ccode){
                // if number begins with current number
                if(strpos($phone, '' . $we) === 0){
                	// store country code and break the loop
                	$countrycode = $we;
                	break;
                }
            }
            if(!empty($countrycode)){
                $size=strlen($countrycode);
                $phone=substr($phone,$size);
            }
            $criteria->addSearchCondition('tel', $phone ,TRUE, "or");
            $criteria->addSearchCondition('second_tel', $phone ,TRUE, "or");
			}
            if(!empty($_REQUEST['tel']) ){
            
            $phone= $_REQUEST['tel'];
            if($phone[0]=='0')
                $phone = substr($phone , 1);
            $countrys = [
            							'44' => 'UK (+44)',
            							'213' => 'Algeria (+213)',
            							'376' => 'Andorra (+376)',
            							'244' => 'Angola (+244)',
            							'1264' => 'Anguilla (+1264)',
            							'1268' => 'Antigua & Barbuda (+1268)',
            							'54' => 'Argentina (+54)',
            							'374' => 'Armenia (+374)',
            							'297' => 'Aruba (+297)',
            							'61' => 'Australia (+61)',
            							'43' => 'Austria (+43)',
            							'994' => 'Azerbaijan (+994)',
            							'1242' => 'Bahamas (+1242)',
            							'973' => 'Bahrain (+973)',
            							'880' => 'Bangladesh (+880)',
            							'1246' => 'Barbados (+1246)',
            							'375' => 'Belarus (+375)',
            							'32' => 'Belgium (+32)',
            							'501' => 'Belize (+501)',
            							'229' => 'Benin (+229)',
            							'1441' => 'Bermuda (+1441)',
            							'975' => 'Bhutan (+975)',
            							'591' => 'Bolivia (+591)',
            							'387' => 'Bosnia Herzegovina (+387)',
            							'267' => 'Botswana (+267)',
            							'55' => 'Brazil (+55)',
            							'673' => 'Brunei (+673)',
            							'359' => 'Bulgaria (+359)',
            							'226' => 'Burkina Faso (+226)',
            							'257' => 'Burundi (+257)',
            							'855' => 'Cambodia (+855)',
            							'237' => 'Cameroon (+237)',
            							'238' => 'Cape Verde Islands (+238)',
            							'1345' => 'Cayman Islands (+1345)',
            							'236' => 'Central African Republic (+236)',
            							'56' => 'Chile (+56)',
            							'86' => 'China (+86)',
            							'57' => 'Colombia (+57)',
            							'269' => 'Comoros (+269)',
            							'242' => 'Congo (+242)',
            							'682' => 'Cook Islands (+682)',
            							'506' => 'Costa Rica (+506)',
            							'385' => 'Croatia (+385)',
            							'53' => 'Cuba (+53)',
            							'90392' => 'Cyprus North (+90392)',
            							'357' => 'Cyprus South (+357)',
            							'42' => 'Czech Republic (+42)',
            							'45' => 'Denmark (+45)',
            							'253' => 'Djibouti (+253)',
            							'1809' => 'Dominica (+1809)',
            							'1809' => 'Dominican Republic (+1809)',
            							'593' => 'Ecuador (+593)',
            							'20' => 'Egypt (+20)',
            							'503' => 'El Salvador (+503)',
            							'240' => 'Equatorial Guinea (+240)',
            							'291' => 'Eritrea (+291)',
            							'372' => 'Estonia (+372)',
            							'251' => 'Ethiopia (+251)',
            							'500' => 'Falkland Islands (+500)',
            							'298' => 'Faroe Islands (+298)',
            							'679' => 'Fiji (+679)',
            							'358' => 'Finland (+358)',
            							'33' => 'France (+33)',
            							'594' => 'French Guiana (+594)',
            							'689' => 'French Polynesia (+689)',
            							'241' => 'Gabon (+241)',
            							'220' => 'Gambia (+220)',
            							'7880' => 'Georgia (+7880)',
            							'49' => 'Germany (+49)',
            							'233' => 'Ghana (+233)',
            							'350' => 'Gibraltar (+350)',
            							'30' => 'Greece (+30)',
            							'299' => 'Greenland (+299)',
            							'1473' => 'Grenada (+1473)',
            							'590' => 'Guadeloupe (+590)',
            							'671' => 'Guam (+671)',
            							'502' => 'Guatemala (+502)',
            							'224' => 'Guinea (+224)',
            							'245' => 'Guinea - Bissau (+245)',
            							'592' => 'Guyana (+592)',
            							'509' => 'Haiti (+509)',
            							'504' => 'Honduras (+504)',
            							'852' => 'Hong Kong (+852)',
            							'36' => 'Hungary (+36)',
            							'354' => 'Iceland (+354)',
            							'91' => 'India (+91)',
            							'62' => 'Indonesia (+62)',
            							'98' => 'Iran (+98)',
            							'964' => 'Iraq (+964)',
            							'353' => 'Ireland (+353)',
            							'39' => 'Italy (+39)',
            							'1876' => 'Jamaica (+1876)',
            							'81' => 'Japan (+81)',
            							'962' => 'Jordan (+962)',
            							'7' => 'Kazakhstan (+7)',
            							'254' => 'Kenya (+254)',
            							'686' => 'Kiribati (+686)',
            							'850' => 'Korea North (+850)',
            							'82' => 'Korea South (+82)',
            							'965' => 'Kuwait (+965)',
            							'996' => 'Kyrgyzstan (+996)',
            							'856' => 'Laos (+856)',
            							'371' => 'Latvia (+371)',
            							'961' => 'Lebanon (+961)',
            							'266' => 'Lesotho (+266)',
            							'231' => 'Liberia (+231)',
            							'218' => 'Libya (+218)',
            							'417' => 'Liechtenstein (+417)',
            							'370' => 'Lithuania (+370)',
            							'352' => 'Luxembourg (+352)',
            							'853' => 'Macao (+853)',
            							'389' => 'Macedonia (+389)',
            							'261' => 'Madagascar (+261)',
            							'265' => 'Malawi (+265)',
            							'60' => 'Malaysia (+60)',
            							'960' => 'Maldives (+960)',
            							'223' => 'Mali (+223)',
            							'356' => 'Malta (+356)',
            							'692' => 'Marshall Islands (+692)',
            							'596' => 'Martinique (+596)',
            							'222' => 'Mauritania (+222)',
            							'269' => 'Mayotte (+269)',
            							'52' => 'Mexico (+52)',
            							'691' => 'Micronesia (+691)',
            							'373' => 'Moldova (+373)',
            							'377' => 'Monaco (+377)',
            							'976' => 'Mongolia (+976)',
            							'1664' => 'Montserrat (+1664)',
            							'212' => 'Morocco (+212)',
            							'258' => 'Mozambique (+258)',
            							'95' => 'Myanmar (+95)',
            							'264' => 'Namibia (+264)',
            							'674' => 'Nauru (+674)',
            							'977' => 'Nepal (+977)',
            							'31' => 'Netherlands (+31)',
            							'687' => 'New Caledonia (+687)',
            							'64' => 'New Zealand (+64)',
            							'505' => 'Nicaragua (+505)',
            							'227' => 'Niger (+227)',
            							'234' => 'Nigeria (+234)',
            							'683' => 'Niue (+683)',
            							'672' => 'Norfolk Islands (+672)',
            							'670' => 'Northern Marianas (+670)',
            							'47' => 'Norway (+47)',
            							'968' => 'Oman (+968)',
            							'680' => 'Palau (+680)',
            							'507' => 'Panama (+507)',
            							'675' => 'Papua New Guinea (+675)',
            							'595' => 'Paraguay (+595)',
            							'51' => 'Peru (+51)',
            							'63' => 'Philippines (+63)',
            							'48' => 'Poland (+48)',
            							'351' => 'Portugal (+351)',
            							'1787' => 'Puerto Rico (+1787)',
            							'974' => 'Qatar (+974)',
            							'262' => 'Reunion (+262)',
            							'40' => 'Romania (+40)',
            							'7' => 'Russia (+7)',
            							'250' => 'Rwanda (+250)',
            							'378' => 'San Marino (+378)',
            							'239' => 'Sao Tome & Principe (+239)',
            							'966' => 'Saudi Arabia (+966)',
            							'221' => 'Senegal (+221)',
            							'381' => 'Serbia (+381)',
            							'248' => 'Seychelles (+248)',
            							'232' => 'Sierra Leone (+232)',
            							'65' => 'Singapore (+65)',
            							'421' => 'Slovak Republic (+421)',
            							'386' => 'Slovenia (+386)',
            							'677' => 'Solomon Islands (+677)',
            							'252' => 'Somalia (+252)',
            							'27' => 'South Africa (+27)',
            							'34' => 'Spain (+34)',
            							'94' => 'Sri Lanka (+94)',
            							'290' => 'St. Helena (+290)',
            							'1869' => 'St. Kitts (+1869)',
            							'1758' => 'St. Lucia (+1758)',
            							'249' => 'Sudan (+249)',
            							'597' => 'Suriname (+597)',
            							'268' => 'Swaziland (+268)',
            							'46' => 'Sweden (+46)',
            							'41' => 'Switzerland (+41)',
            							'963' => 'Syria (+963)',
            							'886' => 'Taiwan (+886)',
            							'7' => 'Tajikstan (+7)',
            							'66' => 'Thailand (+66)',
            							'228' => 'Togo (+228)',
            							'676' => 'Tonga (+676)',
            							'1868' => 'Trinidad & Tobago (+1868)',
            							'216' => 'Tunisia (+216)',
            							'90' => 'Turkey (+90)',
            							'7' => 'Turkmenistan (+7)',
            							'993' => 'Turkmenistan (+993)',
            							'1649' => 'Turks & Caicos Islands (+1649)',
            							'688' => 'Tuvalu (+688)',
            							'256' => 'Uganda (+256)',
            							'380' => 'Ukraine (+380)',
            							'971' => 'United Arab Emirates (+971)',
            							'598' => 'Uruguay (+598)',
            							'7' => 'Uzbekistan (+7)',
            							'678' => 'Vanuatu (+678)',
            							'379' => 'Vatican City (+379)',
            							'58' => 'Venezuela (+58)',
            							'84' => 'Vietnam (+84)',
            							'84' => 'Virgin Islands - British (+1284)',
            							'84' => 'Virgin Islands - US (+1340)',
            							'681' => 'Wallis & Futuna (+681)',
            							'969' => 'Yemen (North)(+969)',
            							'967' => 'Yemen (South)(+967)',
            							'260' => 'Zambia (+260)',
            							'263' => 'Zimbabwe (+263)',
            						];
            
            $temp=  substr(strstr($phone, '+'),1);
            if($temp != false){$phone=$temp;}
                                    $countrycode='';
            // sort the array by key, descending
            krsort($countrys, SORT_NUMERIC);
            
            // iterate over all countries
            foreach($countrys as $we => $ccode){
            	// if number begins with current number
            	if(strpos($phone, '' . $we) === 0){
            		// store country code and break the loop
            		$countrycode = $we;
            		break;
            	}
            }
            
            if(!empty($countrycode)){
            	$size=strlen($countrycode);
            	$phone=substr($phone,$size);
            }
            
            
            
            $criteria->addSearchCondition('tel', $phone ,TRUE, "or");
            $criteria->addSearchCondition('second_tel', $phone ,TRUE, "or");
            }
            if(!empty($_REQUEST['secondtel']) ){
                $criteria->addSearchCondition('second_tel', $_REQUEST['secondtel'],false, "AND");
            }
            if(!empty($_REQUEST['internationalcode']) ){
                $criteria->addSearchCondition('international_code', $_REQUEST['internationalcode'],false, "AND");
            }
            if(!empty($_REQUEST['internationalcode2']) ){
                $criteria->addSearchCondition('international_code2', $_REQUEST['internationalcode2'],false, "AND");
            }
            if($_REQUEST['communication']==1){
                $criteria->addSearchCondition('communication', $_REQUEST['communication'],false, "AND");
            }else if($_REQUEST['communication']==2){
                $criteria->addCondition('communication IS NULL');
                $criteria->addCondition('user_sales IS NOT NULL');

            }else{
            }
            if($_REQUEST['netduplicate']==1){
                $criteria->addCondition('allowduplicate IS NULL');
            }else{
            }
			
			
			
			
		// فلترة استثناء transferdate النهارده أو فترة معينة
date_default_timezone_set('Africa/Cairo');
$today = date("Y-m-d");

$conditions = [];

if (!empty($_REQUEST['exptransfer']) && $_REQUEST['exptransfer'] == 1) {
    $conditions[] = "(transferdate IS NULL OR transferdate != '$today')";
}

if (!empty($_REQUEST['expstarttransferedate']) && !empty($_REQUEST['expendtransferedate'])) {
    $start = $_REQUEST['expstarttransferedate'];
    $end = $_REQUEST['expendtransferedate'];
    $conditions[] = "(transferdate IS NULL OR transferdate < '$start' OR transferdate > '$end')";
}

if (!empty($conditions)) {
    $finalCondition = implode(" AND ", $conditions);
    $criteria->addCondition("($finalCondition)", "AND");
}
        

			
			
        
        
        	
        if($_REQUEST['startfollowdate']){
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        
        //var_dump($arrayoftoday);exit;
        //$criteria->addNotInCondition('transferdate', $arrayoftoday , "AND");
        $criteria->addBetweenCondition("follow_date",$_REQUEST['startfollowdate'],$_REQUEST['endfollowdate'],'AND');
        $criteria->addCondition('close IS NULL');
        $criteria->addCondition('communication IS NOT NULL');
        $criteria->addCondition('user_sales IS NOT NULL');

        
        
        }else{
        }



		
						
        if($_REQUEST['starttransferdate']){

        //var_dump($arrayoftoday);exit;
        //$criteria->addNotInCondition('transferdate', $arrayoftoday , "AND");
        $criteria->addBetweenCondition("transferdate",$_REQUEST['starttransferdate'],$_REQUEST['endtransferdate'],'AND');

        
        }else{
        }	
			

			
			
			
			
			
		if($_REQUEST['distributedteamleaders']==1){
				 	$criteria->addCondition('user_integration IS NOT NULL && user_sales IS  NULL');

			}else{
			}
						
			
			if (!empty($_GET['teamleader_filter'])) {
    // 1. هات كل الـ sales_id اللي القائد بتاعهم هو الفلتر المختار
    $teamMembers = Teamleader::model()->findAllByAttributes(array('leader_id' => $_GET['teamleader_filter']));
    
    // 2. حضّر الآيديّات في array
    $salesIds = array();
    foreach ($teamMembers as $member) {
        $salesIds[] = $member->sales_id;
    }

    // 3. فلتر الـ Leads بناءً على user_sales
    if (!empty($salesIds)) {
        $criteria->addInCondition('user_sales', $salesIds);
    } else {
        // علشان لو مفيش ولا واحد راجعلنا يعمل بلوك
        $criteria->addCondition('1=0');
    }
}
			
			
			if($_REQUEST['leadstate']==1){
                $criteria->condition = "nonqualified IS  NULL ";
			    $criteria->addSearchCondition('qualified', 1 ,false, "AND");
			}else if($_REQUEST['leadstate']==2){
                $criteria->addSearchCondition('nonqualified', 1 , false);
				$criteria->addCondition('qualified IS NULL');
			}else if($_REQUEST['leadstate']==3){
                $criteria->condition = "qualified IS  NULL AND nonqualified IS  NULL";
			}else if($_REQUEST['leadstate']==4){
                $criteria->addSearchCondition('nonqualified', 1, false,'AND');
                $criteria->addSearchCondition('qualified', 1, false,'AND');
			}else if($_REQUEST['leadstate']==5){
			     $criteria->addSearchCondition('first_classification', 1, false,'AND');
                $criteria->addSearchCondition('nonqualified', 1, false,'AND');
                $criteria->addSearchCondition('qualified', 1, false,'AND');
			}else if($_REQUEST['leadstate']==6){
			     $criteria->addSearchCondition('first_classification', 2, false,'AND');
                $criteria->addSearchCondition('nonqualified', 1, false,'AND');
                $criteria->addSearchCondition('qualified', 1, false,'AND');
			}else{
			}
			
			
			
			
				if($_REQUEST['firstleadstate']==1){
            $criteria->addSearchCondition('first_classification', 1 , false);

			}else if($_REQUEST['firstleadstate']==2){
                $criteria->addSearchCondition('first_classification', 2 , false);
			}else{
			}
			
				if($_REQUEST['cold']==1){


				$criteria->addSearchCondition('coldcall', $_REQUEST['cold'],false, "AND");
			}else if($_REQUEST['cold']==2){



				$criteria->addCondition('coldcall IS NULL');
			}else{
			}
			
			if($_REQUEST['indirect']==1){


				$criteria->addSearchCondition('indirect', $_REQUEST['indirect'],false, "AND");
			}else if($_REQUEST['indirect']==2){



				$criteria->addCondition('indirect IS NULL');
			}else{
			}
			
			
			
			
			
			
			
			
			if($_REQUEST['receipt']==1){


				$criteria->addSearchCondition('receipt', $_REQUEST['receipt'],false, "AND");
			}else if($_REQUEST['receipt']==2){



				$criteria->addCondition('receipt IS NULL');
			}else{
			}
			if($_REQUEST['close']==1){


				$criteria->addSearchCondition('close', $_REQUEST['close'],false, "AND");
			}else if($_REQUEST['close']==2){



				$criteria->addCondition('close IS NULL');
			}else{
			}
			if($_REQUEST['death']==1){
				$criteria->addSearchCondition('confirmclose', $_REQUEST['death'],false, "AND");
			}else if($_REQUEST['death']==2){
				$criteria->addCondition('confirmclose IS NULL');
			}else{
			}
			if($_REQUEST['visit']==1){
				$criteria->addSearchCondition('visit', $_REQUEST['visit'],false, "AND");
			}else if($_REQUEST['visit']==2){
				$criteria->addCondition('visit IS NULL');
			}else{
			}
			
			
            
            
            if($_REQUEST['eoi']==1){
            $criteria->addSearchCondition('eoi', $_REQUEST['eoi'],false, "AND");
            }else if($_REQUEST['eoi']==2){
            $criteria->addCondition('eoi IS NULL');
            }else{
            }
			
			
			
			if($_REQUEST['expvisit']==1){
				$criteria->addSearchCondition('expvisit', $_REQUEST['expvisit'],false, "AND");
			}else if($_REQUEST['expvisit']==2){
				$criteria->addCondition('expvisit IS NULL');
			}else{
			}
			
			
			
			
			
			if($_REQUEST['duplicate']==1){
				$criteria->addSearchCondition('duplicate', $_REQUEST['duplicate'],false, "AND");
			}else if($_REQUEST['duplicate']==2){
 
				$criteria->addCondition('duplicate IS NULL');
			}else{
			}
			if($_REQUEST['transferx']==1){


				$criteria->addSearchCondition('transfer', $_REQUEST['transferx'],false, "AND");

			}else if($_REQUEST['transferx']==2){
				$criteria->addCondition('transfer IS NULL');
			}else{
			}
			if($_REQUEST['reopen']==1){
				$criteria->addSearchCondition('reopen', $_REQUEST['reopen'],false, "AND");
			}else if($_REQUEST['reopen']==2){
				$criteria->addCondition('reopen IS NULL');
			}else{
			}
			if($_REQUEST['answer']==1){
				$criteria->addSearchCondition('answer', $_REQUEST['answer'],false, "AND");
			}else if($_REQUEST['answer']==2){
				$criteria->addSearchCondition('answer', $_REQUEST['answer'],false, "AND");
			}else{
			}
            if($_REQUEST['ccode']==1){
					$criteria->addSearchCondition('international_code', 20 ,false, "AND");
			}else if($_REQUEST['ccode']==2){
			            $criteria->addNotInCondition('international_code', array(20));
				}else{}
			if(!empty($_REQUEST['hidden']) ){
				$criteria->addSearchCondition('hidden', $_REQUEST['hidden'],false, "AND");
			}
			
			
		
			
			
			
			
			
			
				
			if(sizeOf((array)$_REQUEST['transferuser'])>1){
			    
			    

			     if($_REQUEST['transferuser'][1]!=0){
				$intArraytransferuser = array_map(
					function($value){ return (int)$value; },
					$_REQUEST['transferuser']
				);
				$criteria->addInCondition('transferuser', $intArraytransferuser  , "AND");
			     }else{
				$criteria->addCondition('transferuser IS NULL');
			    }
				
			}
			
			
			
			
				if(sizeOf((array)$_REQUEST['platform'])>1){
			    
			     if($_REQUEST['platform'][1]!=0){
				$intArray = array_map(
					function($value){ return (int)$value; },
					$_REQUEST['platform']
				);
				$criteria->addInCondition('platform_id', $intArray  , "AND");
			     }else{
				$criteria->addCondition('platform_id IS NULL');
			    }
				
			}
			
			
			
				if(sizeOf((array)$_REQUEST['platformchild'])>1){
			    
			     if($_REQUEST['platformchild'][1]!=0){
				$intArray = array_map(
					function($value){ return (int)$value; },
					$_REQUEST['platformchild']
				);
				$criteria->addInCondition('platformchild_id', $intArray  , "AND");
			     }else{
				$criteria->addCondition('platformchild_id IS NULL');
			    }
				
			}
			 
			if(sizeOf((array)$_REQUEST['ids'])>1){
			     
				$intArray = array_map(
					function($value){ return (int)$value; },
					$_REQUEST['ids']
				);
				$criteria->addInCondition('id', $intArray  , "AND");
			      
			
			}
			
			
			
		 
		 	
		 	
		 	
			if(sizeOf((array)$_REQUEST['place'])>1){
				$intArray2 = array_map(
					function($value2){ return (int)$value2; },
					$_REQUEST['place']
				);
				$criteria->addInCondition('interest_id', $intArray2  , "AND");

			}
			
			
			
				if(sizeOf((array)$_REQUEST['project'])>1){
				$intArray2p = array_map(
					function($value2p){ return (int)$value2p; },
					$_REQUEST['project']
				);
				$criteria->addInCondition('project_id', $intArray2p  , "AND");

			}
			if(sizeOf((array)$_REQUEST['branch'])>1){
				$intArray22 = array_map(
					function($value22){ return (int)$value22; },
					$_REQUEST['branch']
				);
				$criteria->addInCondition('branch', $intArray22  , "AND");

			}
			
			
			
				if(sizeOf((array)$_REQUEST['unit_type'])>1){
				$intArray223 = array_map(
					function($value223){ return (int)$value223; },
					$_REQUEST['unit_type']
				);
				$criteria->addInCondition('unit_type', $intArray223  , "AND");

			}
			
			
			
			
			
			if(sizeOf((array)$_REQUEST['callcenter'])>1){
				$intArray3 = array_map(
					function($value3){ return (int)$value3; },
					$_REQUEST['callcenter']
				);
				$criteria->addInCondition('user_id', $intArray3  , "AND");

			}
			
			
			
			
			
			
				if(sizeOf((array)$_REQUEST['marketingby'])>1){
				$intArray34 = array_map(
					function($value34){ return (int)$value34; },
					$_REQUEST['marketingby']
				);
				$criteria->addInCondition('user_marketing', $intArray34  , "AND");

			}
			
			
			
			
			if(sizeOf((array)$_REQUEST['campaign'])>1){
			    
			    if($_REQUEST['campaign'][1]!=0){
			      
               $intArray4 = array_map(
					function($value4){ return (int)$value4; },
					$_REQUEST['campaign']
				);
                                unset($intArray4[0]);

				$criteria->addInCondition('campaign_id', $intArray4 , "AND");
			    }else{
				$criteria->addCondition('campaign_id IS NULL');
			    }
			    
                                        
			}
			
			
			
					
            if (isset($_REQUEST['dupcampaign']) && is_array($_REQUEST['dupcampaign'])) {
            if(sizeOf((array)$_REQUEST['dupcampaign'])>1){
            $searchValue = implode(',', $_REQUEST['dupcampaign']);
            $likeCondition = '%' . $searchValue . '%';
            
            // Adding a LIKE condition to the criteria
            $criteria->addSearchCondition('dup_campaigns', $likeCondition, false, 'AND');
                	}
            }
            
            


   			
            if (isset($_REQUEST['tags']) && is_array($_REQUEST['tags'])) {
                
            if(sizeOf((array)$_REQUEST['tags'])>1){

            $searchValue = implode(',', $_REQUEST['tags']);
            $likeCondition = '%' . $searchValue . '%';

            // Adding a LIKE condition to the criteria
            $criteria->addSearchCondition('tags', $likeCondition, false, 'AND');
                	}
            }         
			
	
			
			
			if(!empty($_REQUEST['transferfrom']) ){
                $criteria->addSearchCondition('transferfrom', $_REQUEST['transferfrom'],false, "AND");
            }
			
		
			
			
			
			
			
			if(!empty($_REQUEST['transferuser']) ){
                $criteria->addSearchCondition('transferuser', $_REQUEST['transferuser'],false, "AND");
            }
			
		
			
			
			
			
			
			
			
			
			
				if(sizeOf((array)$_REQUEST['strategy'])>1){
			    
			    if($_REQUEST['strategy'][1]!=0){
			      
               $intArray4strategy = array_map(
					function($value4strategy){ return (int)$value4strategy; },
					$_REQUEST['strategy']
				);
                                unset($intArray4strategy[0]);

				$criteria->addInCondition('strategy_id', $intArray4strategy , "AND");
			    }else{
				$criteria->addCondition('strategy_id IS NULL');
			    }
			    
                                        
			}
			
			
			
            $val=false;
			if(sizeOf((array)$_REQUEST['usersales'])>1 AND $_REQUEST['unseenauto']!=1 ){
$val=true;

                                        $intArray5 = array_map(
					function($value5){ return (int)$value5; },
					$_REQUEST['usersales']
				);
				$criteria->addInCondition('user_sales', $intArray5 , "AND");
			}
			if(sizeOf((array)$_REQUEST['exusersales'])>1){
            $val=true;
             $intArrayex = array_map(
					function($valueex){ return (int)$valueex; },
					$_REQUEST['exusersales']
				);
				$criteria->addInCondition('user_sales', $intArrayex , "AND");
			}
			
			
			
			
			
			if(sizeOf((array)$_REQUEST['lastreport'])>1){
            $val=true;
             $intArraylastreport = array_map(
					function($valuelastreport){ return (int)$valuelastreport; },
					$_REQUEST['lastreport']
				);
				$criteria->addInCondition('lastreport', $intArraylastreport , "AND");
			}
			
			
			
			
			
			    if(sizeOf((array)$_REQUEST['teamdistributed'])>1){
            $val=true;
            $intArrayteamdistributed = array_map(
            function($valueteamdistributed){ return (int)$valueteamdistributed; },
            $_REQUEST['teamdistributed']
            );
            $criteria->addInCondition('user_integration', $intArrayteamdistributed , "AND");
            }
			
			
			
			
            
            $val=false;
			if(sizeOf((array)$_REQUEST['fresh'])>1){
$val=true;

                                        $intArrayfresh = array_map(
					function($valuefresh){ return (int)$valuefresh; },
					$_REQUEST['fresh']
				);
				$criteria->addInCondition('fresh_sales', $intArrayfresh , "AND");
			}
			
			
			
				if(sizeOf((array)$_REQUEST['except'])>1){
$val=true;

                                        $intArrayexcept = array_map(
					function($valueexcept){ return (int)$valueexcept; },
					$_REQUEST['except']
				);
				$criteria->addNotInCondition('user_sales', $intArrayexcept , "AND");
			}
			
			
			
			
				
				if(sizeOf((array)$_REQUEST['exceptplatform'])>1){
$val=true;

                                        $intArrayexceptplatform = array_map(
					function($valueexceptplatform){ return (int)$valueexceptplatform; },
					$_REQUEST['exceptplatform']
				);
				$criteria->addNotInCondition('platform_id', $intArrayexceptplatform , "AND");
			}
			
			
			
			
				
				if(sizeOf((array)$_REQUEST['exceptcam'])>1){
$val=true;

                                        $intArrayexceptcam = array_map(
					function($valueexceptcam){ return (int)$valueexceptcam; },
					$_REQUEST['exceptcam']
				);
				$criteria->addNotInCondition('campaign_id', $intArrayexceptcam , "AND");
			}
			
			
		
			
			
			
			if(sizeOf((array)$_REQUEST['status'])>1){
                $val=true;
			    //var_dump($_REQUEST['status']);exit;
			    
			    if($_REQUEST['status'][1]!=0){
			      
                $intArraystatus = array_map(
					function($value6){ return (int)$value6; },
					$_REQUEST['status']
				);
				 $criteria->addInCondition('status', $intArraystatus , "AND");
				  
			    }else{
				$criteria->addCondition('status IS NULL');
			    }
		 	}
		 	if(sizeOf((array)$_REQUEST['substatus'])>1){
$val=true;

                    $intArraysubstatus = array_map(
					function($intArraysubstatus){ return (int)$intArraysubstatus; },
					$_REQUEST['substatus']
				);
				$criteria->addInCondition('substatus', $intArraysubstatus , "AND");
			}
			
			
			
			
				
			
            		
        if (isset($_REQUEST['othersubstatus']) && is_array($_REQUEST['othersubstatus'])) {
        if(sizeOf((array)$_REQUEST['othersubstatus'])>1){
            $searchValue = implode(',', $_REQUEST['othersubstatus']);
            $likeCondition = '%' . $searchValue . '%';
            
            // Adding a LIKE condition to the criteria
            $criteria->addSearchCondition('othersubstatus', $likeCondition, false, 'AND');
            }
        }
            
		if($_REQUEST['unseenauto']==1){
            if(sizeOf((array)$_REQUEST['usersales'])>1){
                    $intArray5 = array_map(
					function($value5){ return (int)$value5; },
					$_REQUEST['usersales']
				);
				$criteria->addInCondition('unseenauto', $intArray5 , "AND");
			}else{
			    $criteria->addCondition('unseenauto IS NOT NULL');
			}
			$criteria->addCondition('user_sales IS NULL');
		}else if($_REQUEST['unseenauto']==2){
			$criteria->addCondition('unseenauto IS NULL');
		}else{
		}
			
        $criteria->compare('unseenauto ',$this->unseenauto );
                                
        //search for Brokers in view company 31/3/2019 7:25
	    if(!empty($user->company_id) AND empty($user->broker) ){  
               $allcampaign=Campaign::model()->findAll(array('condition'=>'company_id='.$user->company_id));

                        foreach($allcampaign as $leader){
				$arr[]=$leader->id ;
			} 
            $criteria->addInCondition('campaign_id', $arr);
	    } 
        // END OF search for Brokers in view company ahmed said dont do thing here but its organised as you see
		if(!empty($_REQUEST['startdate']) ){
			$criteria->addBetweenCondition("date",$_REQUEST['startdate'],$_REQUEST['enddate'],'AND');
		}
		if(!empty($_REQUEST['startsysdate']) ){
			$criteria->addBetweenCondition("sysdate",$_REQUEST['startsysdate'],$_REQUEST['endsysdate'],'AND');
		}
		if(!empty($_REQUEST['startactiondate']) ){
			$criteria->addBetweenCondition("checkup_activity",$_REQUEST['startactiondate'],$_REQUEST['endactiondate'],'AND');
		}
		if(!empty($_REQUEST['startduplicatedate']) ){
			$criteria->addBetweenCondition("duplicate_date",$_REQUEST['startduplicatedate'],$_REQUEST['endduplicatedate'],'AND');
		}
		if(!empty($_REQUEST['startfakedate']) ){
			$criteria->addBetweenCondition("fakedate",$_REQUEST['startfakedate'],$_REQUEST['endfakedate'],'AND');
		}
        if(!empty($_REQUEST['transfer']) ){
            $transferstatus=1;
            $criteria->addSearchCondition('transfer', $transferstatus,false, "AND");
            $criteria->addBetweenCondition("transferdate",$_REQUEST['starttransferdate'],$_REQUEST['endtransferdate'],'AND'); 
        }
        if(!empty($_REQUEST['dup']) ){
            $criteria->addSearchCondition('duplicate',$_REQUEST['dup'],false, "AND");
        }
        if(!empty($_REQUEST['startclosedate']) ){
            $criteria->addBetweenCondition("close_date",$_REQUEST['startclosedate'],$_REQUEST['endclosedate'],'AND');
        }
        
        if($_REQUEST['netduplicate']==1 ){
            
            $allleadss = Leads::model()->findAll($criteria); 
            if(!empty($allleadss)){
                $array=array();
                $arrayid=array();
            foreach($allleadss as $lead){
                if(!in_array($lead->tel,$array)){
                    $array[]=$lead->tel;
                    $arrayid[]=$lead->id;
                }
            }
            } 
        	$criteria = new CDbCriteria();
	    	$criteria->addInCondition('id', $arrayid);  
        }else{   
        }   
            
		date_default_timezone_set('Africa/Cairo');  
		$today = date("Y-m-d");          
		$time = date("H:i:s");  
		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date, true);
		$criteria->compare('tel',$this->tel, true);
		$criteria->compare('title',$this->title, true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('user_sales',$this->user_sales);
		$criteria->compare('fresh',$this->fresh_sales);
		$criteria->compare('project_id',$this->project_id);
		$criteria->compare('platform_id',$this->platform_id);
		$criteria->compare('platformchild_id', $this->platformchild_id);
		$criteria->compare('campaign_id',$this->campaign_id);
		$criteria->compare('status',$this->status);
		$criteria->compare('substatus',$this->substatus);
		$criteria->compare('details',$this->details, true);
		$criteria->compare('follow_date',$this->follow_date, true);
		$criteria->compare('adname',$this->adname, true);
		$criteria->compare('checkup_activity',$this->checkup_activity, true);
        $sort = new CSort();
		if($_REQUEST['delayaction']==1){
        $criteria->order = Yii::app()->request->getParam('sort', 'follow_date DESC');
		}else{
		    $criteria->order = Yii::app()->request->getParam('sort', 'id DESC');
		}
		
        $sort->attributes = array(
            'id'=>array(
                'asc'=>'id ASC',
                'desc'=>'id DESC',
            ),
            'title'=>array(
                'asc'=>'title ASC',
                'desc'=>'title DESC',
            ),
            'follow_date'=>array(
                'asc'=>'follow_date ASC',
                'desc'=>'follow_date DESC',
            ),
            'telephone'=>array(
                'asc'=>'tel ASC',
                'desc'=>'tel DESC',
            ),
            'adname'=>array(
                'asc'=>'adname ASC',
                'desc'=>'adname DESC',
            ),
            'user_id'=>array(
                'asc'=>'user_id ASC',
                'desc'=>'user_id DESC',
            ),
            'user_sales'=>array(
                'asc'=>'user_sales ASC',
                'desc'=>'user_sales DESC',
            ),
            'fresh_sales'=>array(
                'asc'=>'fresh_sales ASC',
                'desc'=>'fresh_sales DESC',
            ),
            'details'=>array(
                'asc'=>'details ASC',
                'desc'=>'details DESC',
            ),
            'campaign_id'=>array(
                'asc'=>'campaign_id ASC',
                'desc'=>'campaign_id DESC',
            ),
            'platform_id'=>array(
                'asc'=>'platform_id ASC',
                'desc'=>'platform_id DESC',
            ),
            'platformchild_id'=>array(
                'asc'=>'platformchild_id ASC',
                'desc'=>'platformchild_id DESC',
            ),
            'project_id'=>array(
                'asc'=>'project_id ASC',
                'desc'=>'project_id DESC',
            ),
            'status'=>array(
                'asc'=>'status ASC',
                'desc'=>'status DESC',
            ),
            'substatus'=>array(
                'asc'=>'substatus ASC',
                'desc'=>'substatus DESC',
            ),
            'visit'=>array(
                'asc'=>'visit ASC',
                'desc'=>'visit DESC',
            ),
            'client_id'=>array(
                'asc'=>'client_id ASC',
                'desc'=>'client_id DESC',
            ),
        );
        
		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		     'sort' => $sort,
		));
		
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		     'sort' => $sort,
		));
	}	
	
	
	
            
            public function searchsalesofleader()
            {
            
            
            			$userid=Yii::app()->user->id;

            if(isset($_REQUEST['search'])){
            //var_dump('22');exit;
            $allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid,'order'=>'id DESC'  ));
            $arr=array();
            foreach($allemployee as $leader){
            $arr[]=$leader->sales_id;
            } 
            
            
            $arrayofinfo=array('hidden'=>$_REQUEST['hidden'],'fb_id'=>$_REQUEST['fb_id'],'adsetname'=>$_REQUEST['adsetname'],'adname'=>$_REQUEST['adname'],'title'=>$_REQUEST['search'],'tel'=>$_REQUEST['tel'],'second_tel'=>$_REQUEST['secondtel'],'campaign_id'=>$_REQUEST['campaign'],'usersales'=>$_REQUEST['usersales'],'receipt'=>$_REQUEST['receipt'],'communication'=>$_REQUEST['communication'],'close'=>$_REQUEST['close'],'duplicate'=>$_REQUEST['duplicate'],'status'=>$_REQUEST['status'],'platform'=>$_REQUEST['platform'],'startdate'=>$_REQUEST['startdate'],'enddate'=>$_REQUEST['enddate'],'place'=>$_REQUEST['place'],'callcenter'=>$_REQUEST['callcenter']);
            $criteria = new CDbCriteria();
            $criteria->order = 'id DESC';
            
            
            $val=false;
            
            //	if(sizeOf((array)$_REQUEST['usersales'])>1){
            //  $val=true;
            // $intArray5 = array_map(
            //	function($value5){ return (int)$value5; },
            //	$_REQUEST['usersales']
            //	);
            //	$intArray5 = array_diff($intArray5, [0]);  
            //	$criteria->addInCondition('user_sales', $intArray5 , "AND");
            //	}else{
            
            //$criteria->addInCondition('user_sales', $arr , "AND");
            //	}
            
            if($_REQUEST['distributedteamleaders']!=1){
            
            if(sizeOf((array)$_REQUEST['usersales'])>1){
            $intArray5 = array_map(
            function($value5){ return (int)$value5; },
            $_REQUEST['usersales']
            );
            $criteria->addInCondition('user_sales', $intArray5  , "AND");
            
            }else{
            
            $criteria->addInCondition('user_sales', $arr , "AND");
            
            }
            
            }
            
            if(!empty($_REQUEST['search']) ){
            $criteria->addSearchCondition('title', $_REQUEST['search'],TRUE, "AND");
            }
            
            
            
            if($_REQUEST['answer']==1){
            $criteria->addSearchCondition('answer', $_REQUEST['answer'],false, "AND");
            }else if($_REQUEST['answer']==2){
            $criteria->addSearchCondition('answer', $_REQUEST['answer'],false, "AND");
            }else{ 
            
            }
            
            if($_REQUEST['transferx']==1){
                $criteria->addCondition('user_sales IS NOT NULL');
            $criteria->addSearchCondition('transfer', $_REQUEST['transferx'],false, "AND");
            }else if($_REQUEST['transferx']==2){
            $criteria->addCondition('transfer IS NULL');
            }else{
            }
            
            if($_REQUEST['visit']==1){
            $criteria->addSearchCondition('visit', $_REQUEST['visit'],false, "AND");
            }else if($_REQUEST['visit']==2){
            $criteria->addCondition('visit IS NULL');
            }else{
            }
            
            
            	if($_REQUEST['eoi']==1){
				$criteria->addSearchCondition('eoi', $_REQUEST['eoi'],false, "AND");
			}else if($_REQUEST['eoi']==2){
				$criteria->addCondition('eoi IS NULL');
			}else{
			}
            
            
            
            if(!empty($_REQUEST['team']) ){
            
            
            $allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $_REQUEST['team'] ,'order'=>'id DESC'  ));
            $arr=array();
            foreach($allemployee as $leader){
            $arr[]=$leader->sales_id;
            } 
            
            // var_dump($arr);exit;
            
            $criteria->addInCondition('user_sales', $arr  , "AND");
            
            }
            
            
            
            
            
            
            if(sizeOf((array)$_REQUEST['unit_type'])>1){
            $intArray223 = array_map(
            function($value223){ return (int)$value223; },
            $_REQUEST['unit_type']
            );
            $criteria->addInCondition('unit_type', $intArray223  , "AND");
            
            }

            
            if(sizeOf((array)$_REQUEST['teamdistributed'])>1){
            $val=true;
            $intArrayteamdistributed = array_map(
            function($valueteamdistributed){ return (int)$valueteamdistributed; },
            $_REQUEST['teamdistributed']
            );
            $criteria->addInCondition('user_integration', $intArrayteamdistributed , "AND");
            }
            
            
            
            if(sizeOf((array)$_REQUEST['fresh'])>1){
            $val=true;
            
                $intArrayfresh = array_map(
            function($valuefresh){ return (int)$valuefresh; },
            $_REQUEST['fresh']
            );
            $criteria->addInCondition('fresh_sales', $intArrayfresh , "AND");
            }else{ 
            }
            
            
            if($_REQUEST['leadstate']==1){
            $criteria->addCondition (" nonqualified IS  NULL ");
            $criteria->addSearchCondition('qualified', 1 ,false, "AND");
            }else if($_REQUEST['leadstate']==2){
            $criteria->addSearchCondition(' nonqualified', 1 , false);
            $criteria->addCondition(' qualified IS NULL');
            }else if($_REQUEST['leadstate']==3){
            $criteria->addCondition ( " qualified IS  NULL AND nonqualified IS  NULL ") ;
            }else if($_REQUEST['leadstate']==4){
            $criteria->addSearchCondition(' nonqualified', 1, false,'AND');
            $criteria->addSearchCondition(' qualified', 1, false,'AND');
            }else if($_REQUEST['leadstate']==5){
            $criteria->addSearchCondition('first_classification', 1, false,'AND');
            $criteria->addSearchCondition('nonqualified', 1, false,'AND');
            $criteria->addSearchCondition('qualified', 1, false,'AND');
            }else if($_REQUEST['leadstate']==6){
            $criteria->addSearchCondition('first_classification', 2, false,'AND');
            $criteria->addSearchCondition('nonqualified', 1, false,'AND');
            $criteria->addSearchCondition('qualified', 1, false,'AND');
            }else{
            }
            
            
            
            
            
            if($_REQUEST['client_id']==1 ){
            $criteria->addSearchCondition('client_id', 1 ,false, "AND");
            }elseif($_REQUEST['client_id']==2){
            $criteria->addCondition ( "client_id IS  NULL ");
            }
            
            if(!empty($_REQUEST['fb_id']) ){
            $criteria->addSearchCondition('facebook_id', $_REQUEST['fb_id'],TRUE, "AND");
            }
            if(!empty($_REQUEST['adsetname']) ){
            $criteria->addSearchCondition('adsetname', $_REQUEST['adsetname'],TRUE, "AND");
            }
            if(!empty($_REQUEST['adname']) ){
            $criteria->addSearchCondition('adname', $_REQUEST['adname'],TRUE, "AND");
            }
            if(!empty($_REQUEST['code']) ){
            $_REQUEST['startdate']="2008-6-30";
            $_REQUEST['enddate']=date("Y-m-d");
            $criteria->addSearchCondition('id', $_REQUEST['code'],false, "AND");
            }
            if(!empty($_REQUEST['tel2']) ){
            $_REQUEST['startdate']="2008-6-30";
            $_REQUEST['enddate']=date("Y-m-d");
            
            $phone= $_REQUEST['tel2'];
            if($phone[0]=='0')
            $phone = substr($phone , 1);
            $countrys = [
            '44' => 'UK (+44)',
            '213' => 'Algeria (+213)',
            '376' => 'Andorra (+376)',
            '244' => 'Angola (+244)',
            '1264' => 'Anguilla (+1264)',
            '1268' => 'Antigua & Barbuda (+1268)',
            '54' => 'Argentina (+54)',
            '374' => 'Armenia (+374)',
            '297' => 'Aruba (+297)',
            '61' => 'Australia (+61)',
            '43' => 'Austria (+43)',
            '994' => 'Azerbaijan (+994)',
            '1242' => 'Bahamas (+1242)',
            '973' => 'Bahrain (+973)',
            '880' => 'Bangladesh (+880)',
            '1246' => 'Barbados (+1246)',
            '375' => 'Belarus (+375)',
            '32' => 'Belgium (+32)',
            '501' => 'Belize (+501)',
            '229' => 'Benin (+229)',
            '1441' => 'Bermuda (+1441)',
            '975' => 'Bhutan (+975)',
            '591' => 'Bolivia (+591)',
            '387' => 'Bosnia Herzegovina (+387)',
            '267' => 'Botswana (+267)',
            '55' => 'Brazil (+55)',
            '673' => 'Brunei (+673)',
            '359' => 'Bulgaria (+359)',
            '226' => 'Burkina Faso (+226)',
            '257' => 'Burundi (+257)',
            '855' => 'Cambodia (+855)',
            '237' => 'Cameroon (+237)',
            '238' => 'Cape Verde Islands (+238)',
            '1345' => 'Cayman Islands (+1345)',
            '236' => 'Central African Republic (+236)',
            '56' => 'Chile (+56)',
            '86' => 'China (+86)',
            '57' => 'Colombia (+57)',
            '269' => 'Comoros (+269)',
            '242' => 'Congo (+242)',
            '682' => 'Cook Islands (+682)',
            '506' => 'Costa Rica (+506)',
            '385' => 'Croatia (+385)',
            '53' => 'Cuba (+53)',
            '90392' => 'Cyprus North (+90392)',
            '357' => 'Cyprus South (+357)',
            '42' => 'Czech Republic (+42)',
            '45' => 'Denmark (+45)',
            '253' => 'Djibouti (+253)',
            '1809' => 'Dominica (+1809)',
            '1809' => 'Dominican Republic (+1809)',
            '593' => 'Ecuador (+593)',
            '20' => 'Egypt (+20)',
            '503' => 'El Salvador (+503)',
            '240' => 'Equatorial Guinea (+240)',
            '291' => 'Eritrea (+291)',
            '372' => 'Estonia (+372)',
            '251' => 'Ethiopia (+251)',
            '500' => 'Falkland Islands (+500)',
            '298' => 'Faroe Islands (+298)',
            '679' => 'Fiji (+679)',
            '358' => 'Finland (+358)',
            '33' => 'France (+33)',
            '594' => 'French Guiana (+594)',
            '689' => 'French Polynesia (+689)',
            '241' => 'Gabon (+241)',
            '220' => 'Gambia (+220)',
            '7880' => 'Georgia (+7880)',
            '49' => 'Germany (+49)',
            '233' => 'Ghana (+233)',
            '350' => 'Gibraltar (+350)',
            '30' => 'Greece (+30)',
            '299' => 'Greenland (+299)',
            '1473' => 'Grenada (+1473)',
            '590' => 'Guadeloupe (+590)',
            '671' => 'Guam (+671)',
            '502' => 'Guatemala (+502)',
            '224' => 'Guinea (+224)',
            '245' => 'Guinea - Bissau (+245)',
            '592' => 'Guyana (+592)',
            '509' => 'Haiti (+509)',
            '504' => 'Honduras (+504)',
            '852' => 'Hong Kong (+852)',
            '36' => 'Hungary (+36)',
            '354' => 'Iceland (+354)',
            '91' => 'India (+91)',
            '62' => 'Indonesia (+62)',
            '98' => 'Iran (+98)',
            '964' => 'Iraq (+964)',
            '353' => 'Ireland (+353)',
            '39' => 'Italy (+39)',
            '1876' => 'Jamaica (+1876)',
            '81' => 'Japan (+81)',
            '962' => 'Jordan (+962)',
            '7' => 'Kazakhstan (+7)',
            '254' => 'Kenya (+254)',
            '686' => 'Kiribati (+686)',
            '850' => 'Korea North (+850)',
            '82' => 'Korea South (+82)',
            '965' => 'Kuwait (+965)',
            '996' => 'Kyrgyzstan (+996)',
            '856' => 'Laos (+856)',
            '371' => 'Latvia (+371)',
            '961' => 'Lebanon (+961)',
            '266' => 'Lesotho (+266)',
            '231' => 'Liberia (+231)',
            '218' => 'Libya (+218)',
            '417' => 'Liechtenstein (+417)',
            '370' => 'Lithuania (+370)',
            '352' => 'Luxembourg (+352)',
            '853' => 'Macao (+853)',
            '389' => 'Macedonia (+389)',
            '261' => 'Madagascar (+261)',
            '265' => 'Malawi (+265)',
            '60' => 'Malaysia (+60)',
            '960' => 'Maldives (+960)',
            '223' => 'Mali (+223)',
            '356' => 'Malta (+356)',
            '692' => 'Marshall Islands (+692)',
            '596' => 'Martinique (+596)',
            '222' => 'Mauritania (+222)',
            '269' => 'Mayotte (+269)',
            '52' => 'Mexico (+52)',
            '691' => 'Micronesia (+691)',
            '373' => 'Moldova (+373)',
            '377' => 'Monaco (+377)',
            '976' => 'Mongolia (+976)',
            '1664' => 'Montserrat (+1664)',
            '212' => 'Morocco (+212)',
            '258' => 'Mozambique (+258)',
            '95' => 'Myanmar (+95)',
            '264' => 'Namibia (+264)',
            '674' => 'Nauru (+674)',
            '977' => 'Nepal (+977)',
            '31' => 'Netherlands (+31)',
            '687' => 'New Caledonia (+687)',
            '64' => 'New Zealand (+64)',
            '505' => 'Nicaragua (+505)',
            '227' => 'Niger (+227)',
            '234' => 'Nigeria (+234)',
            '683' => 'Niue (+683)',
            '672' => 'Norfolk Islands (+672)',
            '670' => 'Northern Marianas (+670)',
            '47' => 'Norway (+47)',
            '968' => 'Oman (+968)',
            '680' => 'Palau (+680)',
            '507' => 'Panama (+507)',
            '675' => 'Papua New Guinea (+675)',
            '595' => 'Paraguay (+595)',
            '51' => 'Peru (+51)',
            '63' => 'Philippines (+63)',
            '48' => 'Poland (+48)',
            '351' => 'Portugal (+351)',
            '1787' => 'Puerto Rico (+1787)',
            '974' => 'Qatar (+974)',
            '262' => 'Reunion (+262)',
            '40' => 'Romania (+40)',
            '7' => 'Russia (+7)',
            '250' => 'Rwanda (+250)',
            '378' => 'San Marino (+378)',
            '239' => 'Sao Tome & Principe (+239)',
            '966' => 'Saudi Arabia (+966)',
            '221' => 'Senegal (+221)',
            '381' => 'Serbia (+381)',
            '248' => 'Seychelles (+248)',
            '232' => 'Sierra Leone (+232)',
            '65' => 'Singapore (+65)',
            '421' => 'Slovak Republic (+421)',
            '386' => 'Slovenia (+386)',
            '677' => 'Solomon Islands (+677)',
            '252' => 'Somalia (+252)',
            '27' => 'South Africa (+27)',
            '34' => 'Spain (+34)',
            '94' => 'Sri Lanka (+94)',
            '290' => 'St. Helena (+290)',
            '1869' => 'St. Kitts (+1869)',
            '1758' => 'St. Lucia (+1758)',
            '249' => 'Sudan (+249)',
            '597' => 'Suriname (+597)',
            '268' => 'Swaziland (+268)',
            '46' => 'Sweden (+46)',
            '41' => 'Switzerland (+41)',
            '963' => 'Syria (+963)',
            '886' => 'Taiwan (+886)',
            '7' => 'Tajikstan (+7)',
            '66' => 'Thailand (+66)',
            '228' => 'Togo (+228)',
            '676' => 'Tonga (+676)',
            '1868' => 'Trinidad & Tobago (+1868)',
            '216' => 'Tunisia (+216)',
            '90' => 'Turkey (+90)',
            '7' => 'Turkmenistan (+7)',
            '993' => 'Turkmenistan (+993)',
            '1649' => 'Turks & Caicos Islands (+1649)',
            '688' => 'Tuvalu (+688)',
            '256' => 'Uganda (+256)',
            '380' => 'Ukraine (+380)',
            '971' => 'United Arab Emirates (+971)',
            '598' => 'Uruguay (+598)',
            '7' => 'Uzbekistan (+7)',
            '678' => 'Vanuatu (+678)',
            '379' => 'Vatican City (+379)',
            '58' => 'Venezuela (+58)',
            '84' => 'Vietnam (+84)',
            '84' => 'Virgin Islands - British (+1284)',
            '84' => 'Virgin Islands - US (+1340)',
            '681' => 'Wallis & Futuna (+681)',
            '969' => 'Yemen (North)(+969)',
            '967' => 'Yemen (South)(+967)',
            '260' => 'Zambia (+260)',
            '263' => 'Zimbabwe (+263)',
            ];
            
            $temp=  substr(strstr($phone, '+'),1);
            if($temp != false){$phone=$temp;}
                        $countrycode='';
            // sort the array by key, descending
            krsort($countrys, SORT_NUMERIC);
            
            // iterate over all countries
            foreach($countrys as $we => $ccode){
            // if number begins with current number
            if(strpos($phone, '' . $we) === 0){
            // store country code and break the loop
            $countrycode = $we;
            break;
            }
            }
            
            if(!empty($countrycode)){
            $size=strlen($countrycode);
            $phone=substr($phone,$size);
            }
            
            
            
            $criteria->addSearchCondition('tel', $phone ,TRUE, "or");
            $criteria->addSearchCondition('second_tel', $phone ,TRUE, "or");
            }
            if(!empty($_REQUEST['tel']) ){
            
            $phone= $_REQUEST['tel'];
            if($phone[0]=='0')
            $phone = substr($phone , 1);
            $countrys = [
            '44' => 'UK (+44)',
            '213' => 'Algeria (+213)',
            '376' => 'Andorra (+376)',
            '244' => 'Angola (+244)',
            '1264' => 'Anguilla (+1264)',
            '1268' => 'Antigua & Barbuda (+1268)',
            '54' => 'Argentina (+54)',
            '374' => 'Armenia (+374)',
            '297' => 'Aruba (+297)',
            '61' => 'Australia (+61)',
            '43' => 'Austria (+43)',
            '994' => 'Azerbaijan (+994)',
            '1242' => 'Bahamas (+1242)',
            '973' => 'Bahrain (+973)',
            '880' => 'Bangladesh (+880)',
            '1246' => 'Barbados (+1246)',
            '375' => 'Belarus (+375)',
            '32' => 'Belgium (+32)',
            '501' => 'Belize (+501)',
            '229' => 'Benin (+229)',
            '1441' => 'Bermuda (+1441)',
            '975' => 'Bhutan (+975)',
            '591' => 'Bolivia (+591)',
            '387' => 'Bosnia Herzegovina (+387)',
            '267' => 'Botswana (+267)',
            '55' => 'Brazil (+55)',
            '673' => 'Brunei (+673)',
            '359' => 'Bulgaria (+359)',
            '226' => 'Burkina Faso (+226)',
            '257' => 'Burundi (+257)',
            '855' => 'Cambodia (+855)',
            '237' => 'Cameroon (+237)',
            '238' => 'Cape Verde Islands (+238)',
            '1345' => 'Cayman Islands (+1345)',
            '236' => 'Central African Republic (+236)',
            '56' => 'Chile (+56)',
            '86' => 'China (+86)',
            '57' => 'Colombia (+57)',
            '269' => 'Comoros (+269)',
            '242' => 'Congo (+242)',
            '682' => 'Cook Islands (+682)',
            '506' => 'Costa Rica (+506)',
            '385' => 'Croatia (+385)',
            '53' => 'Cuba (+53)',
            '90392' => 'Cyprus North (+90392)',
            '357' => 'Cyprus South (+357)',
            '42' => 'Czech Republic (+42)',
            '45' => 'Denmark (+45)',
            '253' => 'Djibouti (+253)',
            '1809' => 'Dominica (+1809)',
            '1809' => 'Dominican Republic (+1809)',
            '593' => 'Ecuador (+593)',
            '20' => 'Egypt (+20)',
            '503' => 'El Salvador (+503)',
            '240' => 'Equatorial Guinea (+240)',
            '291' => 'Eritrea (+291)',
            '372' => 'Estonia (+372)',
            '251' => 'Ethiopia (+251)',
            '500' => 'Falkland Islands (+500)',
            '298' => 'Faroe Islands (+298)',
            '679' => 'Fiji (+679)',
            '358' => 'Finland (+358)',
            '33' => 'France (+33)',
            '594' => 'French Guiana (+594)',
            '689' => 'French Polynesia (+689)',
            '241' => 'Gabon (+241)',
            '220' => 'Gambia (+220)',
            '7880' => 'Georgia (+7880)',
            '49' => 'Germany (+49)',
            '233' => 'Ghana (+233)',
            '350' => 'Gibraltar (+350)',
            '30' => 'Greece (+30)',
            '299' => 'Greenland (+299)',
            '1473' => 'Grenada (+1473)',
            '590' => 'Guadeloupe (+590)',
            '671' => 'Guam (+671)',
            '502' => 'Guatemala (+502)',
            '224' => 'Guinea (+224)',
            '245' => 'Guinea - Bissau (+245)',
            '592' => 'Guyana (+592)',
            '509' => 'Haiti (+509)',
            '504' => 'Honduras (+504)',
            '852' => 'Hong Kong (+852)',
            '36' => 'Hungary (+36)',
            '354' => 'Iceland (+354)',
            '91' => 'India (+91)',
            '62' => 'Indonesia (+62)',
            '98' => 'Iran (+98)',
            '964' => 'Iraq (+964)',
            '353' => 'Ireland (+353)',
            '39' => 'Italy (+39)',
            '1876' => 'Jamaica (+1876)',
            '81' => 'Japan (+81)',
            '962' => 'Jordan (+962)',
            '7' => 'Kazakhstan (+7)',
            '254' => 'Kenya (+254)',
            '686' => 'Kiribati (+686)',
            '850' => 'Korea North (+850)',
            '82' => 'Korea South (+82)',
            '965' => 'Kuwait (+965)',
            '996' => 'Kyrgyzstan (+996)',
            '856' => 'Laos (+856)',
            '371' => 'Latvia (+371)',
            '961' => 'Lebanon (+961)',
            '266' => 'Lesotho (+266)',
            '231' => 'Liberia (+231)',
            '218' => 'Libya (+218)',
            '417' => 'Liechtenstein (+417)',
            '370' => 'Lithuania (+370)',
            '352' => 'Luxembourg (+352)',
            '853' => 'Macao (+853)',
            '389' => 'Macedonia (+389)',
            '261' => 'Madagascar (+261)',
            '265' => 'Malawi (+265)',
            '60' => 'Malaysia (+60)',
            '960' => 'Maldives (+960)',
            '223' => 'Mali (+223)',
            '356' => 'Malta (+356)',
            '692' => 'Marshall Islands (+692)',
            '596' => 'Martinique (+596)',
            '222' => 'Mauritania (+222)',
            '269' => 'Mayotte (+269)',
            '52' => 'Mexico (+52)',
            '691' => 'Micronesia (+691)',
            '373' => 'Moldova (+373)',
            '377' => 'Monaco (+377)',
            '976' => 'Mongolia (+976)',
            '1664' => 'Montserrat (+1664)',
            '212' => 'Morocco (+212)',
            '258' => 'Mozambique (+258)',
            '95' => 'Myanmar (+95)',
            '264' => 'Namibia (+264)',
            '674' => 'Nauru (+674)',
            '977' => 'Nepal (+977)',
            '31' => 'Netherlands (+31)',
            '687' => 'New Caledonia (+687)',
            '64' => 'New Zealand (+64)',
            '505' => 'Nicaragua (+505)',
            '227' => 'Niger (+227)',
            '234' => 'Nigeria (+234)',
            '683' => 'Niue (+683)',
            '672' => 'Norfolk Islands (+672)',
            '670' => 'Northern Marianas (+670)',
            '47' => 'Norway (+47)',
            '968' => 'Oman (+968)',
            '680' => 'Palau (+680)',
            '507' => 'Panama (+507)',
            '675' => 'Papua New Guinea (+675)',
            '595' => 'Paraguay (+595)',
            '51' => 'Peru (+51)',
            '63' => 'Philippines (+63)',
            '48' => 'Poland (+48)',
            '351' => 'Portugal (+351)',
            '1787' => 'Puerto Rico (+1787)',
            '974' => 'Qatar (+974)',
            '262' => 'Reunion (+262)',
            '40' => 'Romania (+40)',
            '7' => 'Russia (+7)',
            '250' => 'Rwanda (+250)',
            '378' => 'San Marino (+378)',
            '239' => 'Sao Tome & Principe (+239)',
            '966' => 'Saudi Arabia (+966)',
            '221' => 'Senegal (+221)',
            '381' => 'Serbia (+381)',
            '248' => 'Seychelles (+248)',
            '232' => 'Sierra Leone (+232)',
            '65' => 'Singapore (+65)',
            '421' => 'Slovak Republic (+421)',
            '386' => 'Slovenia (+386)',
            '677' => 'Solomon Islands (+677)',
            '252' => 'Somalia (+252)',
            '27' => 'South Africa (+27)',
            '34' => 'Spain (+34)',
            '94' => 'Sri Lanka (+94)',
            '290' => 'St. Helena (+290)',
            '1869' => 'St. Kitts (+1869)',
            '1758' => 'St. Lucia (+1758)',
            '249' => 'Sudan (+249)',
            '597' => 'Suriname (+597)',
            '268' => 'Swaziland (+268)',
            '46' => 'Sweden (+46)',
            '41' => 'Switzerland (+41)',
            '963' => 'Syria (+963)',
            '886' => 'Taiwan (+886)',
            '7' => 'Tajikstan (+7)',
            '66' => 'Thailand (+66)',
            '228' => 'Togo (+228)',
            '676' => 'Tonga (+676)',
            '1868' => 'Trinidad & Tobago (+1868)',
            '216' => 'Tunisia (+216)',
            '90' => 'Turkey (+90)',
            '7' => 'Turkmenistan (+7)',
            '993' => 'Turkmenistan (+993)',
            '1649' => 'Turks & Caicos Islands (+1649)',
            '688' => 'Tuvalu (+688)',
            '256' => 'Uganda (+256)',
            '380' => 'Ukraine (+380)',
            '971' => 'United Arab Emirates (+971)',
            '598' => 'Uruguay (+598)',
            '7' => 'Uzbekistan (+7)',
            '678' => 'Vanuatu (+678)',
            '379' => 'Vatican City (+379)',
            '58' => 'Venezuela (+58)',
            '84' => 'Vietnam (+84)',
            '84' => 'Virgin Islands - British (+1284)',
            '84' => 'Virgin Islands - US (+1340)',
            '681' => 'Wallis & Futuna (+681)',
            '969' => 'Yemen (North)(+969)',
            '967' => 'Yemen (South)(+967)',
            '260' => 'Zambia (+260)',
            '263' => 'Zimbabwe (+263)',
            ];
            
            $temp=  substr(strstr($phone, '+'),1);
            if($temp != false){$phone=$temp;}
                        $countrycode='';
            // sort the array by key, descending
            krsort($countrys, SORT_NUMERIC);
            
            // iterate over all countries
            foreach($countrys as $we => $ccode){
            // if number begins with current number
            if(strpos($phone, '' . $we) === 0){
            // store country code and break the loop
            $countrycode = $we;
            break;
            }
            }
            
            if(!empty($countrycode)){
            $size=strlen($countrycode);
            $phone=substr($phone,$size);
            }
            
            
            
            $criteria->addSearchCondition('tel', $phone ,TRUE, "or");
            $criteria->addSearchCondition('second_tel', $phone ,TRUE, "or");
            }
            if(!empty($_REQUEST['secondtel']) ){
            $criteria->addSearchCondition('second_tel', $_REQUEST['secondtel'],false, "AND");
            }
            
            if(!empty($_REQUEST['internationalcode']) ){
            $criteria->addSearchCondition('international_code', $_REQUEST['internationalcode'],false, "AND");
            }
            if(!empty($_REQUEST['internationalcode2']) ){
            $criteria->addSearchCondition('international_code2', $_REQUEST['internationalcode2'],false, "AND");
            }
            
            
            
            if($_REQUEST['cold']==1){
            $criteria->addCondition('coldcall IS NOT NULL');
            }else if($_REQUEST['cold']==2){
            
            $criteria->addCondition('coldcall IS NULL');
            }
            
            
            if($_REQUEST['communication']==1){
            
            
            $criteria->addSearchCondition('communication', $_REQUEST['communication'],false, "AND");
            }else if($_REQUEST['communication']==2){
            $criteria->addCondition('communication IS NULL');
            }else{
            }
            if($_REQUEST['receipt']==1){
            
            
            $criteria->addSearchCondition('receipt', $_REQUEST['receipt'],false, "AND");
            }else if($_REQUEST['receipt']==2){
            
            
            
            $criteria->addCondition('receipt IS NULL');
            }else{
            }
            if($_REQUEST['close']==1){
            
            
            $criteria->addSearchCondition('close', $_REQUEST['close'],false, "AND");
            }else if($_REQUEST['close']==2){
            
            $criteria->addCondition('close IS NULL');
            }else{
            }
            
            if($_REQUEST['reopen']==1){
            
            
            $criteria->addSearchCondition('reopen', $_REQUEST['reopen'],false, "AND");
            }else if($_REQUEST['reopen']==2){
            
            
            
            $criteria->addCondition('reopen IS NULL');
            }else{
            }
            
            if($_REQUEST['ccode']==1){
            
            
            $criteria->addSearchCondition('international_code', 20 ,false, "AND");
            
            }else if($_REQUEST['ccode']==2){
            
            
            $criteria->addNotInCondition('international_code', array(20));
            }else{}
            if(!empty($_REQUEST['hidden']) ){
            $criteria->addSearchCondition('hidden', $_REQUEST['hidden'],false, "AND");
            }
            if(sizeOf((array)$_REQUEST['platform'])>1){
            $intArray = array_map(
            function($value){ return (int)$value; },
            $_REQUEST['platform']
            );
            $criteria->addInCondition('platform_id', $intArray  , "AND");
            }
            
            
            
            
            	
			if(sizeOf((array)$_REQUEST['platformchild'])>1){
				$intArray = array_map(
					function($value){ return (int)$value; },
					$_REQUEST['platformchild']
				);
				$criteria->addInCondition('platformchild_id', $intArray  , "AND");
			}
            
           
            if(sizeOf((array)$_REQUEST['callcenter'])>1){
            $intArray3 = array_map(
            function($value3){ return (int)$value3; },
            $_REQUEST['callcenter']
            );
            $criteria->addInCondition('user_id', $intArray3  , "AND");
            
            }
            
            
            
            
				if(sizeOf((array)$_REQUEST['project'])>1){
				$intArray2p = array_map(
					function($value2p){ return (int)$value2p; },
					$_REQUEST['project']
				);
				$criteria->addInCondition('project_id', $intArray2p  , "AND");

			}
            
            
            if(sizeOf((array)$_REQUEST['campaign'])>1){
                $intArray4 = array_map(
            function($value4){ return (int)$value4; },
            $_REQUEST['campaign']
            );
            unset($intArray4[0]);
            
            $criteria->addInCondition('campaign_id', $intArray4 , "AND");
            }
            
            
            if(sizeOf((array)$_REQUEST['status'])>1){
            $val=true;
            //var_dump($_REQUEST['status']);exit;
            
            if($_REQUEST['status'][1]!=0){
            
            $intArraystatus = array_map(
            function($value6){ return (int)$value6; },
            $_REQUEST['status']
            );
            $criteria->addInCondition('status', $intArraystatus , "AND");
            
            }else{
            $criteria->addCondition('status IS NULL');
            }
            }
            
            if(sizeOf((array)$_REQUEST['substatus'])>1){
            $val=true;
            
            $intArraysubstatus = array_map(
            function($intArraysubstatus){ return (int)$intArraysubstatus; },
            $_REQUEST['substatus']
            );
            $criteria->addInCondition('substatus', $intArraysubstatus , "AND");
            }
            
            
            //search for Brokers in view company 31/3/2019 7:25
            
            
            if(!empty($user->company_id) AND empty($user->broker) ){  
            $allcampaign=Campaign::model()->findAll(array('condition'=>'company_id='.$user->company_id));
            
            foreach($allcampaign as $leader){
            $arr[]=$leader->id ;
            } 
            
            $criteria->addInCondition('campaign_id', $arr);
            } 
            
            // END OF search for Brokers in view company ahmed said dont do thing here but its organised as you see
            
            if(!empty($_REQUEST['startdate']) ){
            $criteria->addBetweenCondition("date",$_REQUEST['startdate'],$_REQUEST['enddate'],'AND');
            
            }
            
            
            if(!empty($_REQUEST['startsysdate']) ){
            $criteria->addBetweenCondition("sysdate",$_REQUEST['startsysdate'],$_REQUEST['endsysdate'],'AND');
            }
			
			if(!empty($_REQUEST['startactiondate']) ){
				$criteria->addBetweenCondition("checkup_activity",$_REQUEST['startactiondate'],$_REQUEST['endactiondate'],'AND');
			}
            
            if(!empty($_REQUEST['transfer']) ){
            $transferstatus=1;
            $criteria->addSearchCondition('transfer', $transferstatus,false, "AND");
            $criteria->addBetweenCondition("transferdate",$_REQUEST['starttransferdate'],$_REQUEST['endtransferdate'],'AND');
            
            }
            
            
            
            if (!empty($_REQUEST['exptransfer']) && $_REQUEST['exptransfer'] == 1 && 
    (empty($_REQUEST['expstarttransferedate']) || empty($_REQUEST['expendtransferedate']))) {

    // فقط استبعاد تاريخ النهاردة
    $criteria->addCondition("(transferdate != '$today' OR transferdate IS NULL)", 'AND');

} elseif (!empty($_REQUEST['expstarttransferedate']) && !empty($_REQUEST['expendtransferedate']) &&
          empty($_REQUEST['exptransfer'])) {

    // فقط استبعاد فترة
    $start = $_REQUEST['expstarttransferedate'];
    $end = $_REQUEST['expendtransferedate'];
    $criteria->addCondition("(transferdate IS NULL OR transferdate < '$start' OR transferdate > '$end')", 'AND');

} elseif (!empty($_REQUEST['exptransfer']) && $_REQUEST['exptransfer'] == 1 &&
          !empty($_REQUEST['expstarttransferedate']) && !empty($_REQUEST['expendtransferedate'])) {

    // استبعاد تاريخ النهاردة + استبعاد فترة
    $start = $_REQUEST['expstarttransferedate'];
    $end = $_REQUEST['expendtransferedate'];
    $criteria->addCondition("(
        (transferdate != '$today' OR transferdate IS NULL)
        AND
        (transferdate IS NULL OR transferdate < '$start' OR transferdate > '$end')
    )", 'AND');
}
			    
            
            
            if(sizeOf((array)$_REQUEST['ids'])>1){
            
            $intArray = array_map(
            function($value){ return (int)$value; },
            $_REQUEST['ids']
            );
            $criteria->addInCondition('id', $intArray  , "AND");
            
            
            }
            
            
            
            
            
        
        	
        if($_REQUEST['startfollowdate']){
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        
        //var_dump($arrayoftoday);exit;
        //$criteria->addNotInCondition('transferdate', $arrayoftoday , "AND");
        $criteria->addBetweenCondition("follow_date",$_REQUEST['startfollowdate'],$_REQUEST['endfollowdate'],'AND');
        $criteria->addCondition('close IS NULL');
        $criteria->addCondition('communication IS NOT NULL');
        
        
        }else{
        }
        
        
        
        
			
        
        if(!empty($_REQUEST['starttransferedate']) ){
        $criteria->addBetweenCondition("transferdate",$_REQUEST['starttransferedate'],$_REQUEST['endtransferedate'],'AND');
        
        }
        
        
        		
						
        if($_REQUEST['starttransferdate']){

        //var_dump($arrayoftoday);exit;
        //$criteria->addNotInCondition('transferdate', $arrayoftoday , "AND");
        $criteria->addBetweenCondition("transferdate",$_REQUEST['starttransferdate'],$_REQUEST['endtransferdate'],'AND');

        
        }else{
        }	
			
            
            
            
            if(sizeOf((array)$_REQUEST['teamdistributed'])>1){
            $val=true;
            $intArrayteamdistributed = array_map(
            function($valueteamdistributed){ return (int)$valueteamdistributed; },
            $_REQUEST['teamdistributed']
            );
            
            //var_dump($intArrayteamdistributed);exit;
            $criteria->addInCondition('user_integration', $intArrayteamdistributed , "AND");
            }
            
            if($_REQUEST['distributedteamleaders']==1){
            $criteria->addCondition('user_integration IS NOT NULL && user_sales IS  NULL');
            
            }else{
            }
            
            
            
            
            date_default_timezone_set('Africa/Cairo');  
            $today = date("Y-m-d");                     // 03.10.01
            $time = date("H:i:s");  
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            }
            
             
       
		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date, true);
		$criteria->compare('tel',$this->tel, true);
		$criteria->compare('title',$this->title, true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('user_sales',$this->user_sales);
		$criteria->compare('project_id',$this->project_id);
		$criteria->compare('platform_id',$this->platform_id);
		$criteria->compare('platformchild_id',$this->platformchild_id);
		$criteria->compare('campaign_id',$this->campaign_id);
		$criteria->compare('status',$this->status);
		$criteria->compare('substatus',$this->substatus);
		$criteria->compare('details',$this->details, true);
		
        $sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort', 'id DESC');
        $sort->attributes = array(
            'id'=>array(
                'asc'=>'id ASC',
                'desc'=>'id DESC',
            ),
            'title'=>array(
                'asc'=>'title ASC',
                'desc'=>'title DESC',
            ),
            'telephone'=>array(
                'asc'=>'tel ASC',
                'desc'=>'tel DESC',
            ),
            'user_id'=>array(
                'asc'=>'user_id ASC',
                'desc'=>'user_id DESC',
            ),
            'user_sales'=>array(
                'asc'=>'user_sales ASC',
                'desc'=>'user_sales DESC',
            ),
            'details'=>array(
                'asc'=>'details ASC',
                'desc'=>'details DESC',
            ),
            'campaign_id'=>array(
                'asc'=>'campaign_id ASC',
                'desc'=>'campaign_id DESC',
            ),
            'platform_id'=>array(
                'asc'=>'platform_id ASC',
                'desc'=>'platform_id DESC',
            ),
            'platformchild_id'=>array(
                'asc'=>'platformchild_id ASC',
                'desc'=>'platformchild_id DESC',
            ),
            'project_id'=>array(
                'asc'=>'project_id ASC',
                'desc'=>'project_id DESC',
            ),
            'status'=>array(
                'asc'=>'status ASC',
                'desc'=>'status DESC',
            ),
            'substatus'=>array(
                'asc'=>'substatus ASC',
                'desc'=>'substatus DESC',
            ),
            'visit'=>array(
                'asc'=>'visit ASC',
                'desc'=>'visit DESC',
            ),
            'client_id'=>array(
                'asc'=>'client_id ASC',
                'desc'=>'client_id DESC',
            ),
        );
		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));
		

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		     'sort' => $sort,
		));
	}	

	 
		public function freshleadsadmin()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;

        
		
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);




$criteria = new CDbCriteria();             
$criteria->addSearchCondition('date', $today, false);
$criteria->addCondition('user_sales IS NOT NULL');

if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}

if($_GET['indirect']==1){
$criteria->addCondition('indirect IS NOT NULL');
}else if($_GET['indirect']==2){
$criteria->addCondition('indirect IS NULL');
}



        

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
	
		public function allclients ()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;

        
		
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


 $start = '2019-01-01'; 
$end = date('Y-m-d');
 $criteria = new CDbCriteria();       
$criteria->condition = "client_id IS NOT NULL ";      

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>$sort,
		
			
		));
	}
	
	
	
	


    public function notdis()
    {
        $userid = Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     
        $time = date("H:i:s");                      
        $rnd = rand(0, 99999);
    
        $start = '2019-01-01'; 
        $end = date('Y-m-d');
        $visible = 1;
    
        $criteria = new CDbCriteria();
        $criteria->condition = "communication IS NULL AND distribute_id IS NULL AND user_sales IS NULL AND receipt IS NULL AND unseenauto IS NULL AND user_integration IS NULL";
        $criteria->addCondition('hidden=' . $visible);
        $criteria->order = 'id DESC';
    
        $user = User::model()->findByPk($userid);
        if (!empty($user->marketing) && !empty($user->callcenter) && empty($user->salesmanger)) {
            $criteria->addSearchCondition('user_id', $user->id, false);
        }
    
        if ($_GET['cold'] == 1) {
            $criteria->addCondition('coldcall IS NOT NULL');
        } elseif ($_GET['cold'] == 2) {
            $criteria->addCondition('coldcall IS NULL');
        }
    
        if ($_GET['indirect'] == 1) {
            $criteria->addCondition('indirect IS NOT NULL');
        } elseif ($_GET['indirect'] == 2) {
            $criteria->addCondition('indirect IS NULL');
        }
    
        if ($_GET['fake'] == 1) {
            $criteria->addCondition('fake_id IS NOT NULL');
        } elseif ($_GET['fake'] == 2) {
            $criteria->addCondition('fake_id IS NULL');
        }
    
        $criteria->compare('id', $this->id, true);
        $criteria->compare('date', $this->date, true);
        $criteria->compare('tel', $this->tel, true);
        $criteria->compare('title', $this->title, true);
        $criteria->compare('user_id', $this->user_id, true);
        $criteria->compare('project_id', $this->project_id, true);
        $criteria->compare('platform_id', $this->platform_id, true);
        $criteria->compare('platformchild_id', $this->platformchild_id, true);
        $criteria->compare('campaign_id', $this->campaign_id, true);
        $criteria->compare('unit_type', $this->unit_type, true);
        $criteria->compare('property_type', $this->property_type, true);
    
        $sort = new CSort();
        $sort->attributes = array(
            'title' => array('asc' => 'title ASC', 'desc' => 'title DESC'),
            'id' => array('asc' => 'id ASC', 'desc' => 'id DESC'),
            'date' => array('asc' => 'date ASC', 'desc' => 'date DESC'),
            'tel' => array('asc' => 'tel ASC', 'desc' => 'tel DESC'),
            'second_tel' => array('asc' => 'second_tel ASC', 'desc' => 'second_tel DESC'),
            'user_id' => array('asc' => 'user_id ASC', 'desc' => 'user_id DESC'),
            'campaign_id' => array('asc' => 'campaign_id ASC', 'desc' => 'campaign_id DESC'),
            'platform_id' => array('asc' => 'platform_id ASC', 'desc' => 'platform_id DESC'),
            'platformchild_id' => array('asc' => 'platformchild_id ASC', 'desc' => 'platformchild_id DESC'),
            'project_id' => array('asc' => 'project_id ASC', 'desc' => 'project_id DESC'),
            'unit_type' => array('asc' => 'unit_type ASC', 'desc' => 'unit_type DESC'),
            'property_type' => array('asc' => 'property_type ASC', 'desc' => 'property_type DESC'),
           
            '*',
        );
    
        return new CActiveDataProvider(get_class($this), array(
            'pagination' => array(
                'pageSize' => Yii::app()->user->getState('pageSize', 10), // Set default pageSize to 10, can be adjusted dynamically
            ),
            'criteria' => $criteria,
            'sort' => $sort,
        ));
    }

		
	
	
	
		public function notcommunicationforadmin()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;

        
		
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


 $start = '2019-01-01'; 
$end = date('Y-m-d');
 $criteria = new CDbCriteria();       
$criteria->condition = "close IS NULL ";      
$criteria->addCondition('user_sales IS NOT NULL');
$criteria->addCondition('communication IS NULL');
$criteria->addCondition('transfer IS NULL');

if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}


if($_GET['indirect']==1){
$criteria->addCondition('indirect IS NOT NULL');
}else if($_GET['indirect']==2){
$criteria->addCondition('indirect IS NULL');
}
 

$criteria->addBetweenCondition("date",$start,$end);
	


      
		$criteria->compare('id',$this->id, true);
		$criteria->compare('date',$this->date, true);
		$criteria->compare('tel',$this->tel, true);
		$criteria->compare('title',$this->title, true);
		$criteria->compare('user_id',$this->user_id, true);
		$criteria->compare('user_sales',$this->user_sales, true);
		$criteria->compare('platform_id',$this->platform_id, true);
		$criteria->compare('platformchild_id',$this->platformchild_id, true);
		$criteria->compare('campaign_id',$this->campaign_id, true);
		$criteria->compare('status',$this->status);
		$criteria->compare('substatus',$this->substatus);
		$criteria->compare('details',$this->details, true);
		
        $sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort'); 
        $sort->attributes = array(
            'title'=>array(
                'asc'=>'title ASC',
                'desc'=>'title DESC',
            ),
            'tel'=>array(
                'asc'=>'tel ASC',
                'desc'=>'tel DESC',
            ),
            'user_id'=>array(
                'asc'=>'user_id ASC',
                'desc'=>'user_id DESC',
            ),
            'user_sales'=>array(
                'asc'=>'user_sales ASC',
                'desc'=>'user_sales DESC',
            ),
            'details'=>array(
                'asc'=>'details ASC',
                'desc'=>'details DESC',
            ),
            'campaign_id'=>array(
                'asc'=>'campaign_id ASC',
                'desc'=>'campaign_id DESC',
            ),
            'platform_id'=>array(
                'asc'=>'platform_id ASC',
                'desc'=>'platform_id DESC',
            ),
            'platformchild_id'=>array(
                'asc'=>'platformchild_id ASC',
                'desc'=>'platformchild_id DESC',
            ),
            'status'=>array(
                'asc'=>'status ASC',
                'desc'=>'status DESC',
            ),
            'substatus'=>array(
                'asc'=>'substatus ASC',
                'desc'=>'substatus DESC',
            ),
            'visit'=>array(
                'asc'=>'visit ASC',
                'desc'=>'visit DESC',
            ),
            'client_id'=>array(
                'asc'=>'client_id ASC',
                'desc'=>'client_id DESC',
            ),
            '*', 
        );

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>$sort,
		
			
		));
	}
	
	
	
	
	
	
	
	
	
	
	
		public function rotationforadmin()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;

        
		
			$userid=Yii::app()->user->id;
			date_default_timezone_set('Africa/Cairo');  
			$today = date("Y-m-d");                     // 03.10.01
			$time = date("H:i:s");                      // 17:16:18	
			$rnd = rand(0,99999);


	

$start = '2019-01-01'; 
$end = date('Y-m-d');
 $criteria = new CDbCriteria();       
//$criteria->condition = "transfer IS NOT NULL && communication IS  NULL  ";

$criteria->addCondition('user_sales IS NOT NULL');
$criteria->addCondition('communication IS NULL');
$criteria->addCondition('transfer IS NOT NULL');


if($_GET['cold']==1){
$criteria->addCondition('coldcall IS NOT NULL');
}else if($_GET['cold']==2){
$criteria->addCondition('coldcall IS NULL');
}
if($_GET['indirect']==1){
$criteria->addCondition('indirect IS NOT NULL');
}else if($_GET['indirect']==2){
$criteria->addCondition('indirect IS NULL');
}
	
	
//$criteria->addBetweenCondition("date",$start,$end);

      
		$criteria->compare('id',$this->id, true);
		$criteria->compare('date',$this->date, true);
		$criteria->compare('tel',$this->tel, true);
		$criteria->compare('title',$this->title, true);
		$criteria->compare('user_id',$this->user_id, true);
		$criteria->compare('user_sales',$this->user_sales, true);
		$criteria->compare('platform_id',$this->platform_id, true);
		$criteria->compare('platformchild_id',$this->platformchild_id, true);
		$criteria->compare('campaign_id',$this->campaign_id, true);
		$criteria->compare('status',$this->status);
		$criteria->compare('substatus',$this->substatus);
		$criteria->compare('details',$this->details, true);
		
        $sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort'); 
        $sort->attributes = array(
            'title'=>array(
                'asc'=>'title ASC',
                'desc'=>'title DESC',
            ),
            'tel'=>array(
                'asc'=>'tel ASC',
                'desc'=>'tel DESC',
            ),
            'user_id'=>array(
                'asc'=>'user_id ASC',
                'desc'=>'user_id DESC',
            ),
            'user_sales'=>array(
                'asc'=>'user_sales ASC',
                'desc'=>'user_sales DESC',
            ),
            'details'=>array(
                'asc'=>'details ASC',
                'desc'=>'details DESC',
            ),
            'campaign_id'=>array(
                'asc'=>'campaign_id ASC',
                'desc'=>'campaign_id DESC',
            ),
            'platform_id'=>array(
                'asc'=>'platform_id ASC',
                'desc'=>'platform_id DESC',
            ),
            'platformchild_id'=>array(
                'asc'=>'platformchild_id ASC',
                'desc'=>'platformchild_id DESC',
            ),
            'status'=>array(
                'asc'=>'status ASC',
                'desc'=>'status DESC',
            ),
            'substatus'=>array(
                'asc'=>'substatus ASC',
                'desc'=>'substatus DESC',
            ),
            'visit'=>array(
                'asc'=>'visit ASC',
                'desc'=>'visit DESC',
            ),
            'client_id'=>array(
                'asc'=>'client_id ASC',
                'desc'=>'client_id DESC',
            ),
            '*', 
        );

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>$sort,
		));
	}
	
	
	
	
	
	

	
		public function notcommunicationsales()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        
 $start = '2012-01-01'; 
$end = date('Y-m-d');
        
		$criteria=new CDbCriteria;

        $criteria->condition = "close IS NULL ";      
        $criteria->addCondition('communication IS NULL');
        $criteria->addCondition('transfer IS NULL');
        
        if($_GET['cold']==1){
        $criteria->addCondition('coldcall IS NOT NULL');
        }else if($_GET['cold']==2){
        $criteria->addCondition('coldcall IS NULL');
        }else if($_GET['indirect']==1){
        $criteria->addCondition('indirect IS NOT NULL');
        }
        

        $agent=User::model()->findByPk($userid);
        if($agent->sales ==1 or $agent->telesales ==1 ){
        $criteria->addSearchCondition('user_sales', $userid, false);
        }else{
        $criteria->addSearchCondition('user_id', $userid, false);
        }   
        
        
        $agent=User::model()->findByPk($userid);
        if($agent->sales ==1 or $agent->telesales ==1 ){
        $criteria->addSearchCondition('user_sales', $userid, false);
        }else{
        $criteria->addSearchCondition('user_id', $userid, false);
        }   
        
       $criteria->addBetweenCondition("date",$start,$end);
	
	

       
		$criteria->compare('id',$this->id, true);
		$criteria->compare('tel',$this->tel, true);
		$criteria->compare('title',$this->title);
		$criteria->compare('date',$this->date);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('user_sales',$this->user_sales);
		$criteria->compare('platform_id',$this->platform_id);
		$criteria->compare('platformchild_id',$this->platformchild_id);
		$criteria->compare('campaign_id',$this->campaign_id);
		$criteria->compare('status',$this->status);
		$criteria->compare('substatus',$this->substatus);
		$criteria->compare('details',$this->details, true);
		
        $sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort'); 
        $sort->attributes = array(
            'id'=>array(
                'asc'=>'id ASC',
                'desc'=>'id DESC',
            ),
            'title'=>array(
                'asc'=>'title ASC',
                'desc'=>'title DESC',
            ),
            'date'=>array(
                'asc'=>'date ASC',
                'desc'=>'date DESC',
            ),
            'tel'=>array(
                'asc'=>'tel ASC',
                'desc'=>'tel DESC',
            ),
            'second_tel'=>array(
                'asc'=>'second_tel ASC',
                'desc'=>'second_tel DESC',
            ),
            'user_id'=>array(
                'asc'=>'user_id ASC',
                'desc'=>'user_id DESC',
            ),
            'user_sales'=>array(
                'asc'=>'user_sales ASC',
                'desc'=>'user_sales DESC',
            ),
            'details'=>array(
                'asc'=>'details ASC',
                'desc'=>'details DESC',
            ),
            'project_id'=>array(
                'asc'=>'project_id ASC',
                'desc'=>'project_id DESC',
            ),
            'campaign_id'=>array(
                'asc'=>'campaign_id ASC',
                'desc'=>'campaign_id DESC',
            ),
            'platform_id'=>array(
                'asc'=>'platform_id ASC',
                'desc'=>'platform_id DESC',
            ),
            'platformchild_id'=>array(
                'asc'=>'platformchild_id ASC',
                'desc'=>'platformchild_id DESC',
            ),
            'status'=>array(
                'asc'=>'status ASC',
                'desc'=>'status DESC',
            ),
            'substatus'=>array(
                'asc'=>'substatus ASC',
                'desc'=>'substatus DESC',
            ),
            'visit'=>array(
                'asc'=>'visit ASC',
                'desc'=>'visit DESC',
            ),
            'client_id'=>array(
                'asc'=>'client_id ASC',
                'desc'=>'client_id DESC',
            ),
            '*', 
        );

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>$sort,
		
			
		));
	}
	
	
	
	
	
	
		public function notcommunicationsalesfake()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        
 $start = '2012-01-01'; 
$end = date('Y-m-d');
        
		$criteria=new CDbCriteria;

        $criteria->condition = "close IS NULL ";      
        $criteria->addCondition('communication IS NULL');

        if($_GET['cold']==1){
        $criteria->addCondition('coldcall IS NOT NULL');
        }else if($_GET['cold']==2){
        $criteria->addCondition('coldcall IS NULL');
        }else if($_GET['indirect']==1){
        $criteria->addCondition('indirect IS NOT NULL');
        }
        

        $agent=User::model()->findByPk($userid);
        if($agent->sales ==1 or $agent->telesales ==1 ){
        $criteria->addSearchCondition('user_sales', $userid, false);
        }else{
        $criteria->addSearchCondition('user_id', $userid, false);
        }   
        
        
        $agent=User::model()->findByPk($userid);
        if($agent->sales ==1 or $agent->telesales ==1 ){
        $criteria->addSearchCondition('user_sales', $userid, false);
        }else{
        $criteria->addSearchCondition('user_id', $userid, false);
        }   
        
       $criteria->addBetweenCondition("fakedate",$start,$end);
	
	

       
		$criteria->compare('id',$this->id);
		//$criteria->compare('date',$this->date);
		$criteria->compare('tel',$this->tel, true);
		$criteria->compare('title',$this->title);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('user_sales',$this->user_sales);
		$criteria->compare('platform_id',$this->platform_id);
		$criteria->compare('platformchild_id',$this->platformchild_id);
		$criteria->compare('campaign_id',$this->campaign_id);
		$criteria->compare('status',$this->status);
		$criteria->compare('substatus',$this->substatus);
		$criteria->compare('details',$this->details, true);
		
        $sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort'); 
        $sort->attributes = array(
            'title'=>array(
                'asc'=>'title ASC',
                'desc'=>'title DESC',
            ),
            'telephone'=>array(
                'asc'=>'tel ASC',
                'desc'=>'tel DESC',
            ),
            'user_id'=>array(
                'asc'=>'user_id ASC',
                'desc'=>'user_id DESC',
            ),
            'user_sales'=>array(
                'asc'=>'user_sales ASC',
                'desc'=>'user_sales DESC',
            ),
            'details'=>array(
                'asc'=>'details ASC',
                'desc'=>'details DESC',
            ),
            'campaign_id'=>array(
                'asc'=>'campaign_id ASC',
                'desc'=>'campaign_id DESC',
            ),
            'platform_id'=>array(
                'asc'=>'platform_id ASC',
                'desc'=>'platform_id DESC',
            ),
            'platformchild_id'=>array(
                'asc'=>'platformchild_id ASC',
                'desc'=>'platformchild_id DESC',
            ),
            'status'=>array(
                'asc'=>'status ASC',
                'desc'=>'status DESC',
            ),
            'substatus'=>array(
                'asc'=>'substatus ASC',
                'desc'=>'substatus DESC',
            ),
            'visit'=>array(
                'asc'=>'visit ASC',
                'desc'=>'visit DESC',
            ),
            'client_id'=>array(
                'asc'=>'client_id ASC',
                'desc'=>'client_id DESC',
            ),
            '*', 
        );

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>$sort,
		
			
		));
	}
	
	

	
	
		public function notcommunicationtransfersalestoday()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        
 $start = '2012-01-01'; 
$end = date('Y-m-d');
        
		$criteria=new CDbCriteria;
        $criteria->condition = "transfer IS NOT NULL && communication IS  NULL  && fake IS  NULL ";
        if($_GET['cold']==1){
        $criteria->addCondition('coldcall IS NOT NULL');
        }else if($_GET['cold']==2){
        $criteria->addCondition('coldcall IS NULL');
        }
        $criteria->addCondition('user_sales=' . $userid);
        
        $criteria->addSearchCondition('date', $today, false);

        $criteria->order = 'transferdate DESC';

	
       
		$criteria->compare('id',$this->id);
		//$criteria->compare('date',$this->date);
		$criteria->compare('tel',$this->tel, true);
		$criteria->compare('title',$this->title);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('user_sales',$this->user_sales);
		$criteria->compare('platform_id',$this->platform_id);
		$criteria->compare('platformchild_id',$this->platformchild_id);
		$criteria->compare('campaign_id',$this->campaign_id);
		$criteria->compare('status',$this->status);
		$criteria->compare('substatus',$this->substatus);
		$criteria->compare('details',$this->details, true);
		
        $sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort'); 
        $sort->attributes = array(
            'title'=>array(
                'asc'=>'title ASC',
                'desc'=>'title DESC',
            ),
            'telephone'=>array(
                'asc'=>'tel ASC',
                'desc'=>'tel DESC',
            ),
            'user_id'=>array(
                'asc'=>'user_id ASC',
                'desc'=>'user_id DESC',
            ),
            'user_sales'=>array(
                'asc'=>'user_sales ASC',
                'desc'=>'user_sales DESC',
            ),
            'details'=>array(
                'asc'=>'details ASC',
                'desc'=>'details DESC',
            ),
            'campaign_id'=>array(
                'asc'=>'campaign_id ASC',
                'desc'=>'campaign_id DESC',
            ),
            'platform_id'=>array(
                'asc'=>'platform_id ASC',
                'desc'=>'platform_id DESC',
            ),
            'platformchild_id'=>array(
                'asc'=>'platformchild_id ASC',
                'desc'=>'platformchild_id DESC',
            ),
            'status'=>array(
                'asc'=>'status ASC',
                'desc'=>'status DESC',
            ),
            'substatus'=>array(
                'asc'=>'substatus ASC',
                'desc'=>'substatus DESC',
            ),
            'visit'=>array(
                'asc'=>'visit ASC',
                'desc'=>'visit DESC',
            ),
            'client_id'=>array(
                'asc'=>'client_id ASC',
                'desc'=>'client_id DESC',
            ),
            '*', 
        );

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>$sort,
		
			
		));
	}
	
	
	
		public function notcommunicationtransfersales()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
        
 $start = '2012-01-01'; 
$end = date('Y-m-d');
        
		$criteria=new CDbCriteria;
        $criteria->condition = "transfer IS NOT NULL && communication IS  NULL && fake IS  NULL ";
        if($_GET['cold']==1){
        $criteria->addCondition('coldcall IS NOT NULL');
        }else if($_GET['cold']==2){
        $criteria->addCondition('coldcall IS NULL');
        }
        $criteria->addCondition('user_sales=' . $userid);
        $criteria->order = 'transferdate DESC';

	
       
		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date);
		$criteria->compare('tel',$this->tel, true);
		$criteria->compare('title',$this->title);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('user_sales',$this->user_sales);
		$criteria->compare('platform_id',$this->platform_id);
		$criteria->compare('platformchild_id',$this->platformchild_id);
		$criteria->compare('campaign_id',$this->campaign_id);
		$criteria->compare('status',$this->status);
		$criteria->compare('substatus',$this->substatus);
		$criteria->compare('details',$this->details, true);
		
        $sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort'); 
        $sort->attributes = array(
            'title'=>array(
                'asc'=>'title ASC',
                'desc'=>'title DESC',
            ),
            'telephone'=>array(
                'asc'=>'tel ASC',
                'desc'=>'tel DESC',
            ),
            'user_id'=>array(
                'asc'=>'user_id ASC',
                'desc'=>'user_id DESC',
            ),
            'user_sales'=>array(
                'asc'=>'user_sales ASC',
                'desc'=>'user_sales DESC',
            ),
            'details'=>array(
                'asc'=>'details ASC',
                'desc'=>'details DESC',
            ),
            'campaign_id'=>array(
                'asc'=>'campaign_id ASC',
                'desc'=>'campaign_id DESC',
            ),
            'platform_id'=>array(
                'asc'=>'platform_id ASC',
                'desc'=>'platform_id DESC',
            ),
            'platformchild_id'=>array(
                'asc'=>'platformchild_id ASC',
                'desc'=>'platformchild_id DESC',
            ),
            'status'=>array(
                'asc'=>'status ASC',
                'desc'=>'status DESC',
            ),
            'substatus'=>array(
                'asc'=>'substatus ASC',
                'desc'=>'substatus DESC',
            ),
            'visit'=>array(
                'asc'=>'visit ASC',
                'desc'=>'visit DESC',
            ),
            'client_id'=>array(
                'asc'=>'client_id ASC',
                'desc'=>'client_id DESC',
            ),
            '*', 
        );

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>$sort,
		
			
		));
	}
	
	
	
	
	
	
	
	
	
	
	
	
		public function leadsformarketingofmarketingteam()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
      
      
      
      
// الحصول على ID المستخدم الحالي
$userid = Yii::app()->user->id;

// البحث عن المستخدم
$marketingleader = User::model()->findByPk($userid);

// التحقق من وجود limitsformarketing
if (isset($marketingleader->limitsformarketing)) {
    // إزالة الفواصل من النتيجة
    $cleanedLimits = str_replace(',', '', $marketingleader->limitsformarketing);
    echo "Cleaned limits for marketing: " . $cleanedLimits . PHP_EOL;

    // تحويل النتيجة إلى مصفوفة (إذا كانت القيم مفصولة بفواصل أصلًا)
    $idsArray = explode(',', $marketingleader->limitsformarketing);

    // البحث عن المستخدمين في جدول User باستخدام القيم المستخرجة
    $criteria = new CDbCriteria();
    $criteria->addInCondition('id', $idsArray); // البحث بناءً على القيم في مصفوفة
    $allemployee = User::model()->findAll($criteria);
}


      //  $userid=Yii::app()->user->id;
       // $allemployee = User::model()->findAll(array( 'condition' => 'marketinglevel=' . $userid ,'order'=>'id DESC'  ));
        $arr=array();
        foreach($allemployee as $leader){
        $arr[]=$leader->id;
        } 
        
        $criteria=new CDbCriteria;
        $criteria->order = 'date DESC , time DESC';
        $user=User::model()->findByPk($userid);
       // $criteria->addCondition(" user_id = " . $userid." or user_marketing = ". $userid);
      
        $criteria->addInCondition('user_id', $arr  , "AND");

      

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
	
	public function leadsformarketing()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
      
        
        
        $criteria=new CDbCriteria;
        $criteria->order = 'date DESC , time DESC';
        $user=User::model()->findByPk($userid);
      
      
      
         $currentUserId = Yii::app()->user->id;
       if ($currentUserId) {
           

        // استعلام للحصول على جميع المعلومات من جدول المستخدمين بناءً على معرف المستخدم
        $userInfo = Yii::app()->db->createCommand()
            ->select('*') // اختر جميع الأعمدة أو الأعمدة التي تحتاجها فقط
            ->from('user') // اسم جدول المستخدمين
            ->where('id=:userId', array(':userId' => $currentUserId))
            ->queryRow();

// Ensure limitsformarketing is an array, even if it's not set or empty
$limitsArray = isset($userInfo['limitsformarketing']) 
               ? $userInfo['limitsformarketing'] 
               : [];


// Check if limitsArray is not empty
if (!empty($limitsArray)) {
    
        if (!is_array($limitsArray)) {
        $limitsArray = (array)$limitsArray;
        }

    
    
    // Convert the limitsArray to a comma-separated string
    $limitsString = implode(',', $limitsArray);
    // Ensure limitsString is not empty before adding the condition
    if (!empty($limitsString)) {
        // Display the contents of $limitsString for debugging
        //var_dump($limitsString);
        //exit; // Stop execution to view the output of var_dump

        // Add search condition using IN clause for user_id
        $criteria->addCondition("user_id IN (" . $limitsString . ")");
    }
} else {

 $criteria->addCondition(" user_id = " . $userid." or user_marketing = ". $userid);



}




		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	}
	
	
	
	
	
	
		public function sales($salesx)
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
      
        
        
        
        $criteria = new CDbCriteria();
        $criteria->order = 'id DESC';
       
        			$criteria->condition = "close IS NULL ";

        //$criteria->condition .= "file IS NOT NULL";
            $criteria->addSearchCondition('user_sales', $salesx,False, "AND");

			
      

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,'defaultOrder'=>'id ASC', 
		));
	}
	
	
	
	
	
	
	
	
	
	public function beforeSave()
  	{
 	parent::beforeSave();
		{
  			if($this->isNewRecord)
  		{
  			$this->sysdate = ($this->date);
  			$this->duplicate_date = ($this->date);
  		}


  		}
  		return TRUE;
  	}
	
	

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Leads the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}






}
