<?php

/**
 * This is the model class for table "notifi".
 *
 * The followings are the available columns in table 'notifi':
 * @property integer $id
 * @property string $date
 * @property string $time
 * @property integer $user_id
 * @property string $message
 * @property string $url
 * @property integer $sendto
 * @property integer $sent
 */
class Notifi extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'notifi';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, time, user_id, message, url, sendto', 'required'),
			array('user_id, sendto, sent', 'numerical', 'integerOnly'=>true),
			array('url', 'length', 'max'=>255),
			
			array( 'message', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'url', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),

			
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, time, user_id, message,platform, url, sendto, sent', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'time' => 'Time',
			'user_id' => 'User',
			'message' => 'Message',
			'url' => 'Url',
			'sendto' => 'Sendto',
			'sent' => 'Sent',
			'platform' => 'platform',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
$userid=Yii::app()->user->id;
		$criteria=new CDbCriteria;
$criteria->order = 'id DESC';
        $criteria->limit = 10;
        
        		$criteria->addSearchCondition('sendto', $userid , false);


		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Notifi the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
