<?php

/**
 * This is the model class for table "user".
 *
 * The followings are the available columns in table 'user':
 * @property integer $id
 * @property string $username
 * @property string $email
 * @property string $mobile
 * @property string $mobile2
 * @property string $password
 * @property string $player_id
 * @property string $player_id_mobile
 * @property string $fname
 * @property string $lname
 * @property string $image
 * @property string $file
 * @property string $details
 * @property integer $level
 * @property string $diactivation_date
 * @property integer $active
 * @property integer $flag
 * @property integer $engineering
 * @property integer $marketing
 * @property integer $callcenter
 * @property integer $customerservice
 * @property integer $sales
 * @property integer $salesmanger
 * @property integer $teamleader
 * @property integer $broker
 * @property integer $hr
 * @property integer $accounting
 * @property integer $legalaffairs
 * @property integer $ceo
 */
class User extends CActiveRecord
{
    
    
    
    protected function beforeFind()
{
    // استدعاء الدالة الأصلية
    parent::beforeFind();

    // احصل على معرف المستخدم الحالي من الجلسة
    $currentUserId = Yii::app()->user->id;

    // تحقق من أن المعرف موجود
    if ($currentUserId) {
        // استعلام للحصول على جميع المعلومات من جدول المستخدمين بناءً على معرف المستخدم
        $userInfo = Yii::app()->db->createCommand()
            ->select('*') // اختر جميع الأعمدة أو الأعمدة التي تحتاجها فقط
            ->from('user') // اسم جدول المستخدمين
            ->where('id=:userId', array(':userId' => $currentUserId))
            ->queryRow();

        // تحقق مما إذا كانت البيانات تم إرجاعها
        if ($userInfo) {
            // تعيين البيانات إلى الخاصية المطلوبة
            $this->limitsformanager = isset($userInfo['limitsformanager']) ? $userInfo['limitsformanager'] : null;
            $this->limitsformarketing = isset($userInfo['limitsformarketing']) ? $userInfo['limitsformarketing'] : null;

        } else {
            // تعامل مع حالة عدم وجود بيانات
            $this->limitsformanager = null; // أو تعيين قيمة افتراضية مناسبة
        }
    } else {
        // تعامل مع حالة عدم وجود معرف مستخدم
        $this->limitsformanager = null; // أو تعيين قيمة افتراضية مناسبة
    }

    // Debug: تحقق مما إذا كانت limitsformanager قد تم تعيينها بشكل صحيح
   // var_dump($this->limitsformanager); exit;

    // تحقق من أن limitsformanager ليست فارغة
    if (!empty($this->limitsformanager)) {
        // تحويل limitsformanager إلى مصفوفة إذا كانت سلسلة نصية مفصولة بفواصل
        $limitsArray = is_string($this->limitsformanager) ? explode(',', $this->limitsformanager) : $this->limitsformanager;

        // إضافة شرط الاستعلام بناءً على limitsformanager و currentUserId
        $this->getDbCriteria()->addCondition('id IN (' . implode(',', array_map('intval', $limitsArray)) . ') OR id = :userId');
        $this->getDbCriteria()->params[':userId'] = $currentUserId;
    }
    
    
    
    
    
    
    

    return true; // تأكد من إرجاع true للسماح بمتابعة الاستعلام
}

    
    // Other model methods and properties

    
    
 
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user';
	}
	
	

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
		    
		    
		   array('code','unique'),

		   // array('secert','username'),
            array('image', 'file', 'types'=>'jpg, jpeg, pdf, png, xlsx, csv, cad, xls','safe' => true ,'allowEmpty' => true),
            
			array('username', 'required'),
			array('level, active, flag, engineering, marketing, callcenter, feedback, purchasingmanager,customerservice, sales, telesales,  salesmanger, teamleader, broker, hr, accounting, legalaffairs, ceo,officeboy,indirectsales, company_id,searchleads,searchactivities,searchfeedback,searchusers,recorderforlead,	allrecorderlead,allrecorderother,transfer,note,integration,distribute,pre_distribute ,distribute_manager_teamleader,distribute_to_telesales ,distribute_to_sales ,notification ,activitiesnotifi ,hiddentel ,hiddenlogo ,hiddenxlxs ,super_admin  ,distribution_report  ,performance_fresh_leads  ,performance_fresh_leads_with_campaign ,performance_fresh_leads_with_platform ,performance_fresh_leads_with_project ,performance_fresh_leads_with_teamleader ,performance_fresh_leads_with_status ,performance_fresh_leads_with_status_and_campaign ,performance_transfer_leads_with_teamleader ,performance_by_day ,teamleader_manager_performance ,performance_activities_with_projects ,performance_activities_with_status ,sales_activity_type ,not_communication ,rotation ,strategy_classification ,campaign_vs_status_vs_substatus ,platform_classification ,platform_vs_status_substatus_vs_sales ,platform_vs_status_substatus_vs_teamleader ,platform_vs_status_substatus_vs_campaign ,platform_vs_status_substatus_vs_platformchild ,platform_vs_status_substatus_vs_project ,performance_activities  ,performance_visit  ,activities_vs_status_vs_substatus  ,sales_vs_status  ,sales_vs_status_substatus  ,sales_vs_reservation_vs_contract  ,sales_vs_broker  ,teamleader_vs_sales_vs_broker  ,duplicate_vs_fresh_duplicate  ,marketing_vs_status_substatus  ,campaigns_vs_sales  ,campaigns_vs_status_substatus  ,platform_vs_sales  ,platform_vs_status  ,platform_vs_status_substatus  ,leads_classification_report  ,qualified_vs_status_substatus_vs_sales  ,non_qualified_vs_status_substatus_vs_sales  ,not_clear_vs_status_substatus_vs_sales  ,mixed_classification_vs_status_substatus_vs_sales  ,ceo_report  ,teamleader_report  ,teamleader_vs_sales_vs_broker_vs_leads  ,late_report  ,social_media_report  ,media_byuer_report  ,campaign_classification  ,editlead  ,deletelead, assign_to, teamleader_level, orientation_report, imready,create_strategy,confirm_reservation,contracted_leads,confirm_eoi,clients_details,cancel_con,delete_con,edit_con,uploaded_date_for_teamleader,distribution_report_tl_level_2,distribution_report_tl_level_3,distribution_report_tl_level_4,distribution_report_tl_level_5,deletevisit,orgrainc,mediabuyer,ext_no,addleadup,resale,salesadmin,marketinglevel,marketingleader,targetnumber,permitted_only_for_the_legal_department,print_inst,confirm_print_inst,allow_duplicate,indirectsalesforsales,hrid', 'numerical', 'integerOnly'=>true),
			
			
			
			
			
			
			array('username, email, player_id, player_id_mobile, teamname,fname, lname, image, file,distribute_to,passwordapp,latitude,longitude,deletevisit,session_id,code,limitsformanager,limitsformarketing', 'length', 'max'=>255),
			array('mobile, mobile2', 'length', 'max'=>50),
			array('password', 'length', 'max'=>90),
			array('details, diactivation_date,token ', 'safe'),
			
			array( 'username', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'email', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'details', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
         	array( 'image', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'player_id', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
         	array( 'player_id_mobile', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
         	array( 'fname', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
         	array( 'lname', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
         	array( 'passwordapp', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
         	array( 'token', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),

			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, username, email, mobile, mobile2, password, player_id,session_id, player_id_mobile, fname, lname, image, file, details, level, diactivation_date, active, flag, engineering, marketing, callcenter, feedback, customerservice, sales, telesales, salesmanger, teamleader, broker, hr, recorderforlead,	allrecorderlead, allrecorderother, accounting, legalaffairs, ceo,officeboy, company_id,searchleads,searchactivities,searchfeedback,searchusers,transfer,note,integration,distribute,distribute_to ,pre_distribute ,distribute_manager_teamleader,distribute_to_telesales ,distribute_to_sales ,notification ,activitiesnotifi ,hiddentel ,hiddenlogo ,hiddenxlxs ,super_admin  ,distribution_report  ,performance_fresh_leads  ,performance_activities  ,performance_visit  ,activities_vs_status_vs_substatus  ,sales_vs_status  ,sales_vs_status_substatus  ,sales_vs_reservation_vs_contract  ,sales_vs_broker  ,teamleader_vs_sales_vs_broker  ,duplicate_vs_fresh_duplicate  ,marketing_vs_status_substatus  ,campaigns_vs_sales  ,campaigns_vs_status_substatus  ,platform_vs_sales  ,platform_vs_status  ,platform_vs_status_substatus  ,leads_classification_report  ,qualified_vs_status_substatus_vs_sales  ,non_qualified_vs_status_substatus_vs_sales  ,not_clear_vs_status_substatus_vs_sales  ,mixed_classification_vs_status_substatus_vs_sales  ,ceo_report  ,teamleader_report  ,teamleader_vs_sales_vs_broker_vs_leads  ,late_report  ,social_media_report  ,media_byuer_report  ,campaign_classification  ,deletelead, assign_to, teamleader_level,orientation_report, latitude,longitude,create_strategy,confirm_reservation,contracted_leads,confirm_eoi,clients_details,uploaded_date_for_teamleader,distribution_report_tl_level_2,distribution_report_tl_level_3,distribution_report_tl_level_4,distribution_report_tl_level_5,addleadup,resale,salesadmin,marketinglevel,marketingleader,lastLoginTime,lastVisitTime,shiftstart,shiftend,permitted_only_for_the_legal_department,limitsformanager,limitsformarketing,print_inst,confirm_print_inst,allow_duplicate,indirectsalesforsales', 'safe', 'on'=>'search'),
		);
	}
	
	
	

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'username' => 'Username',
			'email' => 'Email',
			'mobile' => 'Mobile',
			'mobile2' => 'Mobile2',
			'password' => 'Password',
			'player_id' => 'Player',
			'player_id_mobile' => 'Player Id Mobile',
			'fname' => 'Fname',
			'lname' => 'Lname',
			'image' => 'Image',
			'file' => 'File',
			'details' => 'Details',
			'level' => 'Level',
			'diactivation_date' => 'Diactivation Date',
			'active' => 'Active',
			'flag' => 'Flag',
			'engineering' => 'Engineering',
			'marketing' => 'Marketing',
			'callcenter' => 'Callcenter',
			'feedback' => 'feedback',
			'customerservice' => 'Customerservice',
			'sales' => 'Sales',
			'salesmanger' => 'Salesmanger',
			'telesales' => 'Telesales',
			'teamleader' => 'Teamleader',
			'broker' => 'Broker',
			'hr' => 'Hr',
			'accounting' => 'Accounting',
			'legalaffairs' => 'Legalaffairs',
			'ceo' => 'Ceo',
			'officeboy' => 'Officeboy',
			'purchasingmanager' => 'Purchasing Manager',
			'indirectsales' => 'Indirect Sales',
			'company_id' => 'company_id',
			'searchleads' => 'searchleads',
			'searchactivities' => 'searchactivities',
			'searchfeedback' => 'searchfeedback',
			'searchusers' => 'searchusers',
			'transfer' => 'transfer',
			'note' => 'note',
			'integration' => 'integration',
			'distribute' => 'distribute',
			'distribute_to' => 'Distribute To',
			'distribute_to_telesales ' => 'Distribute To Telesales',
			'distribute_to_sales ' => 'Distribute To Sales',
			'pre_distribute' => 'Pre Distribute',
			'recorderforlead' => 'Recorder for lead',
			'allrecorderlead' => 'All Recorderlead',
			'allrecorderother' => 'All Recorderother',
			'distribute_manager_teamleader' => 'Distribute To Manager or Teamleader',
			'notification' => 'Notification',
			'activitiesnotifi' => 'Activitiesnotifi',
						'hiddentel' => 'Hiddentel',

			'hiddenlogo' => 'Hiddenlogo',

			'hiddenxlxs' => 'Hiddenxlxs',
			'super_admin' => 'Super Admin',
			
			
			
		   'distribution_report_tl_level_2' => 'Distribution Report TL (Level 2)',
		   'distribution_report_tl_level_3' => 'Distribution Report TL (Level 3)',
		   'distribution_report_tl_level_4' => 'Distribution Report TL (Level 4)',
		   'distribution_report_tl_level_5' => 'Distribution Report TL (Level 5)',
			'distribution_report' => 'Distribution Report',
			'performance_fresh_leads' => 'Performance Fresh Leads',
			'performance_activities' => 'Performance Activities',
			'performance_visit' => 'Performance Visit',
			'activities_vs_status_vs_substatus' => 'Activities Vs Status Vs Substatus',
			'sales_vs_status' => 'Sales Vs Status',
			'sales_vs_status_substatus' => 'Sales Vs Status & Substatus',
			'sales_vs_reservation_vs_contract' => 'Sales Vs Reservation Vs Contract',
			'sales_vs_broker' => 'Sales Vs Broker',
			'teamleader_vs_sales_vs_broker' => 'Teamleader Vs Sales Vs Broker',
			'duplicate_vs_fresh_duplicate' => 'Duplicate Vs Fresh Duplicate',
			'marketing_vs_status_substatus' => 'Marketing Vs Status & Substatus',
			'campaigns_vs_sales' => 'Campaigns Vs Sales',
			'campaigns_vs_status_substatus' => 'Campaigns vs Status & Substatus',
			'platform_vs_sales' => 'Platform Vs Sales',
			'platform_vs_status' => 'Platform Vs Status',
			'platform_vs_status_substatus' => 'Platform vs Status & Substatus',
			'leads_classification_report' => 'Leads Classification Report',
			'qualified_vs_status_substatus_vs_sales' => 'Qualified Vs Status & Substatus Vs Sales',
			'non_qualified_vs_status_substatus_vs_sales' => 'Non Qualified Vs Status & Substatus Vs Sales',
			'not_clear_vs_status_substatus_vs_sales' => 'Not Clear Vs Status & Substatus Vs Sales',
			'mixed_classification_vs_status_substatus_vs_sales' => 'Mixed Classification Vs Status & Substatus Vs Sales',
			'ceo_report' => 'CEO Report',
			'teamleader_report' => 'Teamleader Report',
			'teamleader_vs_sales_vs_broker_vs_leads' => 'Teamleader Vs Sales Vs Broker Vs Leads',
			'late_report' => 'Late Report',
			'social_media_report' => 'Social Media Report',
			'media_byuer_report' => 'Media Byuer Report',
			'campaign_classification' => 'Campaign Classification',
			
			'editlead' => 'Edit lead',
		   'deletelead' => 'Delet elead',
		   'assign_to' => 'assign to',
		   'teamleader_level' => 'teamleader_level',
		   'latitude' => 'Latitude',
		   'longitude' => 'Longitude',
		   'imready' => 'imready',
		   'create_strategy' => 'Create Strategy',
		   'confirm_reservation' => 'Confirm Reservation',
		   'contracted_leads' => 'Contracted Leads',
		   'confirm_eoi' => 'Confirm EOI',
		   'clients_details' => 'Clients Details',
		   'uploaded_date_for_teamleader' => 'Upload Date for Teamleader',
		    'deletevisit' => 'deletevisit',
		    'ext_no' => 'ext no',
		    'salesadmin' => 'salesadmin',
		    'marketinglevel' => 'marketinglevel',
		    'marketingleader' => 'marketingleader',
		    'targetnumber' => 'targetnumber',
		    'confirm_print_inst' => 'confirm Print Inst',
		    'allow_duplicate' => 'allow_duplicate',
		    'indirectsalesforsales' => 'indirectsalesforsales',
		    
		    






		);
	}
public function fullName()
{
    return trim($this->fname . ' ' . $this->lname);
}
	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('username',$this->username,true);
		$criteria->compare('distribute_to',$this->distribute_to,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('mobile',$this->mobile,true);
		$criteria->compare('mobile2',$this->mobile2,true);
		$criteria->compare('password',$this->password,true);
		$criteria->compare('player_id',$this->player_id,true);
		$criteria->compare('player_id_mobile',$this->player_id_mobile,true);
		$criteria->compare('fname',$this->fname,true);
		$criteria->compare('lname',$this->lname,true);
		$criteria->compare('image',$this->image,true);
		$criteria->compare('file',$this->file,true);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('level',$this->level);
		$criteria->compare('diactivation_date',$this->diactivation_date,true);
		$criteria->compare('active',$this->active);
		$criteria->compare('flag',$this->flag);
		$criteria->compare('engineering',$this->engineering);
		$criteria->compare('marketing',$this->marketing);
		$criteria->compare('callcenter',$this->callcenter);
		$criteria->compare('feedback',$this->feedback);
		$criteria->compare('customerservice',$this->customerservice);
		$criteria->compare('sales',$this->sales);
		$criteria->compare('salesmanger',$this->salesmanger);
		$criteria->compare('telesales',$this->telesales);
		$criteria->compare('teamleader',$this->teamleader);
		$criteria->compare('broker',$this->broker);
		$criteria->compare('hr',$this->hr);
		$criteria->compare('accounting',$this->accounting);
		$criteria->compare('legalaffairs',$this->legalaffairs);
		$criteria->compare('ceo',$this->ceo);
		$criteria->compare('officeboy',$this->officeboy);
		$criteria->compare('purchasingmanager',$this->purchasingmanager);
		$criteria->compare('indirectsales',$this->indirectsales);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('searchleads',$this->searchleads);
		$criteria->compare('searchactivities',$this->searchactivities);
		$criteria->compare('searchfeedback',$this->searchfeedback);
		$criteria->compare('searchusers',$this->searchusers);
		$criteria->compare('transfer',$this->transfer);
		$criteria->compare('note',$this->note);
		$criteria->compare('integration',$this->integration);
		$criteria->compare('distribute',$this->distribute);
		$criteria->compare('distribute_to_telesales',$this->distribute_to_telesales);
		$criteria->compare('distribute_to_sales',$this->distribute_to_sales);
		$criteria->compare('distribute_manager_teamleader',$this->distribute_manager_teamleader);
		$criteria->compare('pre_distribute',$this->pre_distribute);
		$criteria->compare('deletevisit',$this->deletevisit);
		$criteria->compare('marketinglevel',$this->deletevisit);
		$criteria->compare('marketingleader',$this->marketingleader);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return User the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function validatePassword($password)
	{
		return CPasswordHelper::verifyPassword($password,$this->password);
	}

	public function hashPassword($password)
	{
		return CPasswordHelper::hashPassword($password);
	}



  public function beforeSave()
  	{
 	parent::beforeSave();
		{
  			if($this->isNewRecord)
  		
  			$this->password = $this->hashPassword($this->password);

  		}
  		return TRUE;
  	}
	
	public function getAll()
	{
		return CHtml::listData(self::model()->findAll(), 'id', 'username');
		
		
	}
	
	
	
	

	
}
