<?php $allwords18 = Staticwords::model()->findByPk(18); ?>
<?php $user = User::model()->findByPK($userid); ?>
<?php if ($user->engineering == 1): ?>

<!-- Include Tabulator CSS & JS -->
<link href="https://unpkg.com/tabulator-tables@5.5.0/dist/css/tabulator.min.css" rel="stylesheet">
<script src="https://unpkg.com/tabulator-tables@5.5.0/dist/js/tabulator.min.js"></script>

<div class="card shadow-sm border-0 mb-4">
    <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
        <h3 class="mb-0">Campaign DIS</h3>
        <button class="btn btn-light btn-sm" data-toggle="modal" data-target="#kt_modal_4">+ New Campaign DIS</button>
    </div>
    <div class="card-body p-4">
        <?php
        $grouped = [];
        $allcampaigndistribution = Campaigndistribution::model()->findAll(['order' => 'date DESC']);

        if (!empty($allcampaigndistribution)) {
            foreach ($allcampaigndistribution as $cd) {
                $key = date('Y - F', strtotime($cd->date));
                if (!isset($grouped[$key])) {
                    $grouped[$key] = [];
                }
                $grouped[$key][] = $cd;
            }
        }
        ?>

        <div class="accordion" id="campaignAccordion">
            <?php if (!empty($grouped)): ?>
                <?php $i = 0; foreach ($grouped as $groupTitle => $records): $i++; ?>
                    <div class="card mb-2">
                        <div class="card-header" id="heading<?php echo $i; ?>">
                            <h2 class="mb-0">
                                <button class="btn btn-outline-dark btn-block text-left <?php echo $i !== 1 ? 'collapsed' : ''; ?>" type="button" data-toggle="collapse" data-target="#collapse<?php echo $i; ?>" aria-expanded="<?php echo $i === 1 ? 'true' : 'false'; ?>" aria-controls="collapse<?php echo $i; ?>">
                                    <?php echo $groupTitle; ?>
                                </button>
                            </h2>
                        </div>
                        <div id="collapse<?php echo $i; ?>" class="collapse <?php echo $i === 1 ? 'show' : ''; ?>" aria-labelledby="heading<?php echo $i; ?>" data-parent="#campaignAccordion">
                            <div class="card-body">
                                <div id="tabulator-<?php echo $i; ?>"></div>
                                <script>
                                document.addEventListener("DOMContentLoaded", function () {
                                    const tableData<?php echo $i; ?> = <?php echo CJSON::encode(array_map(function($cd) {
                                        return [
                                            'date'        => $cd->date,
                                            'start_date'  => $cd->start_date,
                                            'end_date'    => $cd->end_date,
                                            'campaign'    => Campaign::model()->findByPk($cd->campaign_id)->title ?? 'N/A',
                                            'action'      => Yii::app()->getBaseUrl(true) . '/engineering/campaigndistribution/' . $cd->id,
                                        ];
                                    }, $records)); ?>;

                                    new Tabulator("#tabulator-<?php echo $i; ?>", {
                                        layout: "fitColumns",
                                        responsiveLayout: "collapse",
                                        columns: [
                                            { title: "Date", field: "date", sorter: "date" },
                                            { title: "Start Date", field: "start_date" },
                                            { title: "End Date", field: "end_date" },
                                            { title: "Campaign", field: "campaign" },
                                            { title: "Action", field: "action", formatter: function(cell) {
                                                return `<a class='btn btn-primary btn-sm' href='${cell.getValue()}'>Details</a>`;
                                            }},
                                        ],
                                        data: tableData<?php echo $i; ?>,
                                    });
                                });
                                </script>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="alert alert-warning">No data available.</div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Modal for Creating Campaign DIS -->
<div class="modal fade" id="kt_modal_4" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create Campaign DIS</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <?php $form = $this->beginWidget('CActiveForm', array(
                'id' => 'floor-floor-form',
                'htmlOptions' => array('onsubmit' => 'return confirm("Are YOU SURE")', 'class' => 'solid-form'),
                'enableAjaxValidation' => false,
            )); ?>
            <div class="modal-body">
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label>Start Date</label>
                        <?php echo $form->dateField($model, 'start_date', array('class' => "form-control")); ?>
                        <?php echo $form->error($model, 'start_date'); ?>
                    </div>
                    <div class="form-group col-md-6">
                        <label>End Date</label>
                        <?php echo $form->dateField($model, 'end_date', array('class' => "form-control")); ?>
                        <?php echo $form->error($model, 'end_date'); ?>
                    </div>
                    <div class="form-group col-md-6">
                        <label>Min Leads</label>
                        <?php echo $form->textField($model, 'min_leads', array('class' => "form-control")); ?>
                        <?php echo $form->error($model, 'min_leads'); ?>
                    </div>
                    <div class="form-group col-md-6">
                        <label>Campaign</label>
                        <select class="kt_select2_class form-control" name="CampaignDistribution[campaign_id]">
                            <?php foreach (Campaign::model()->findAll() as $campaign): ?>
                                <option value="<?php echo $campaign->id; ?>"><?php echo $campaign->title; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>
            <?php $this->endWidget(); ?>
        </div>
    </div>
</div>

<?php else: ?>
<div class="alert alert-danger">You don't have permission to access this page.</div>
<?php endif; ?>