<?php


	ini_set('max_execution_time', 300);
	ini_set('memory_limit', '-1');



	?>
	<div class="kt-portlet kt-portlet--height-fluid col-xl-12 col-md-12 col-lg-12" id="reportHolder">
		<div class="kt-portlet__head">
			<div class="kt-portlet__head-label">
				<h3 class="kt-portlet__head-title">
					Trial Balance/ميزان المراجعة
				</h3>
			</div>
			<div class="kt-portlet__head-toolbar">
				<div class="kt-widget__action mr-1">
					<button type="button" class="btn btn-bold btn-label-brand btn-sm"  onclick="ExportExcel1('xlsx')">Excel</button>
				</div>
				<div class="kt-widget__action">
					<button type="button" class="btn btn-bold btn-label-brand btn-sm" id="pngReportButton">PNG</button>
				</div>
			</div>
		</div>
				<div class="kt-portlet__body">
					<!--Solid Form-->
					<div class="kt-portlet__body kt-portlet__body--fit"  >
<?php
// Define the date range (replace with your actual dates)
$date_from = '2024-01-01';
$date_to = '2024-08-31';

// The MySQL query with placeholders
$sql = "
    SELECT 
        fi_tree.id,
        fi_tree.title,
        fi_tree.code,
        fi_main_tree.title AS main_tree_title,
        
        COALESCE(SUM(CASE 
            WHEN fi_generalledger.type_id = 1 AND fi_generalledger.date < :date_from THEN fi_generalledger.amount 
            WHEN fi_generalledger.type_id = 2 AND fi_generalledger.date < :date_from THEN -fi_generalledger.amount 
            ELSE 0 
        END), 0) AS beginning_balance,
        
        COALESCE(SUM(CASE 
            WHEN fi_generalledger.type_id = 1 AND fi_generalledger.date BETWEEN :date_from AND :date_to THEN fi_generalledger.amount 
            ELSE 0 
        END), 0) AS total_credit,
        
        COALESCE(SUM(CASE 
            WHEN fi_generalledger.type_id = 2 AND fi_generalledger.date BETWEEN :date_from AND :date_to THEN fi_generalledger.amount 
            ELSE 0 
        END), 0) AS total_debit,
        
        COALESCE(SUM(CASE 
            WHEN fi_generalledger.type_id = 1 AND fi_generalledger.date <= :date_to THEN fi_generalledger.amount 
            WHEN fi_generalledger.type_id = 2 AND fi_generalledger.date <= :date_to THEN -fi_generalledger.amount 
            ELSE 0 
        END), 0) AS end_balance

    FROM 
        fi_tree
    JOIN 
        fi_main_tree ON fi_tree.main_tree_id = fi_main_tree.id
    LEFT JOIN 
        fi_generalledger ON fi_tree.id = fi_generalledger.tree_id
    GROUP BY 
        fi_tree.id, fi_tree.title, fi_tree.code, fi_main_tree.title
    ORDER BY 
        fi_tree.code;
";

// Execute the query with the date range parameters
$command = Yii::app()->db->createCommand($sql);
$command->bindParam(":date_from", $date_from);
$command->bindParam(":date_to", $date_to);
$data = $command->queryAll();

// Display the results in a table
?>

<table border="1" class="table thead-light striped bordered condensed responsive dataTable">
    <tr>
        <th>Code</th>
        <th>Title</th>
        <th>Main Tree Title</th>
        <th>Beginning Balance</th>
        <th>Total Credit</th>
        <th>Total Debit</th>
        <th>End Balance</th>
    </tr>
    <?php foreach ($data as $row): ?>
        <tr>
            <td><?php echo CHtml::encode($row['code']); ?></td>
            <td><?php echo CHtml::encode($row['title']); ?></td>
            <td><?php echo CHtml::encode($row['main_tree_title']); ?></td>
            <td><?php echo CHtml::encode($row['beginning_balance']); ?></td>
            <td><?php echo CHtml::encode($row['total_credit']); ?></td>
            <td><?php echo CHtml::encode($row['total_debit']); ?></td>
            <td><?php echo CHtml::encode($row['end_balance']); ?></td>
        </tr>
    <?php endforeach; ?>
</table>












		<style>
    		span.tooltipfix {
    			width: unset;
    			display: block;
    			font-weight: 900;
    		}
			.romaAllLeadstitle{
				background: #d866e7 !Important;
				color: black !important;
			}
			.romaAllLeads{
				background: #d866e7 !Important;
				color: black !important;
			}
			.romatitle{
				background: #66d5e7 !Important;
				color: black !important;
			}
			.roma{
				background: #66d5e7 !Important;
				color: black !important;
			}
			.romaNoStatustitle{
				background: #e76666 !Important;
				color: black !important;
			}
			.romaNoStatus{
				background: #e76666 !Important;
				color: black !important;
			}

			div.fixedtableholder {
				width: calc(100% - 15em) ;
				overflow-x: scroll;
				overflow-y: visible;
				padding-bottom: 1px;
				margin-left: 15em;
			}
			.fixedtableholder .header th {
				vertical-align: middle;
				top: auto;
				min-height: 100px !important;
			}
    		.headcol {
    			position: absolute;
    			width: 189px;
    			left: 17px;
    			top: auto;
    			border-right: 0px none black;
    			border-top-width: 3px;
    			margin-top: 0px;
    			z-index: 9;
    		}
    		.headcol:before {
    			content: ' ';
    		}
    		.headcoltitle {
    			min-width: 189px !important;
    			margin: auto;
    			display: grid;
    			background: #9e9e9e !important;
    			color: white !important;
    			height: 105px !important;
    		}
		</style>
	</div>
	</div>
	</div>