<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Professional Real Estate Sales Chat</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            background-color: #fff;
            box-shadow: 0px 0px 15px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
        }

        h4.text-center {
            margin-bottom: 20px;
        }

        .messages {
            border: 1px solid #ddd;
            padding: 15px;
            height: 400px;
            overflow-y: auto;
            margin-bottom: 20px;
            background-color: #f1f1f1;
            border-radius: 5px;
        }

        .message {
            padding: 10px;
            background-color: #e9ecef;
            border-radius: 5px;
            margin-bottom: 10px;
        }

        .form-control {
            border-radius: 5px;
        }

        button#sendMessage {
            border-radius: 5px;
        }

        .loader {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #3498db;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            animation: spin 2s linear infinite;
            display: inline-block;
            margin-left: 10px;
            vertical-align: middle;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="container">
        <h4 class="text-center">Professional Real Estate Sales Chat</h4>

        <form id="chatForm" method="post">
            <div class="row form-group">
                <div class="col-9">
                    <input type="text" class="form-control" id="conversationId" placeholder="Set chat ID or leave blank for new chat" value="">
                </div>
                <div class="col-3">
                    <select class="form-control" id="chatModel">
                        <option value="gpt-3.5-turbo">GPT-3.5</option>
                        <option value="gpt-4">GPT-4</option>
                    </select>
                </div>
            </div>

            <div class="messages" id="messages">
                <!-- Messages will be displayed here -->
            </div>

            <div class="row">
                <div class="form-group col-9">
                    <textarea rows="1" class="form-control" id="messageInput" placeholder="Enter a message"></textarea>
                </div>
                <div class="col-3">
                    <button type="submit" class="btn btn-primary w-100" id="sendMessage">
                        Send <span class="loader" id="loader" style="display: none;"></span>
                    </button>
                </div>
            </div>
        </form>
    </div>

    <script>
        document.getElementById("chatForm").addEventListener("submit", function(event) {
            event.preventDefault();

            const messageInput = document.getElementById("messageInput");
            const conversationId = document.getElementById("conversationId").value;
            const chatModel = document.getElementById("chatModel").value;
            const message = messageInput.value.trim();

            if (message === "") {
                alert("Please enter a message.");
                return;
            }

            document.getElementById("loader").style.display = "inline-block";
            document.getElementById("sendMessage").disabled = true;

            fetch("", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json"
                },
                body: JSON.stringify({
                    message: message,
                    chat_model: chatModel,
                    conversation_id: conversationId,
                })
            })
            .then(response => response.json())
            .then(data => {
                document.getElementById("loader").style.display = "none";
                document.getElementById("sendMessage").disabled = false;

                const messages = document.getElementById("messages");
                const messageElement = document.createElement("div");
                messageElement.classList.add("message");

                if (data.error) {
                    messageElement.innerHTML = `<p><b>Error:</b> ${data.error.msg}</p>`;
                } else {
                    messageElement.innerHTML = `<p><b>AI:</b> ${data.choices[0].message.content}</p>`;
                }

                messages.appendChild(messageElement);
                messageInput.value = "";
            })
            .catch(error => {
                document.getElementById("loader").style.display = "none";
                document.getElementById("sendMessage").disabled = false;

                const messages = document.getElementById("messages");
                const messageElement = document.createElement("div");
                messageElement.classList.add("message");
                messageElement.innerHTML = `<p><b>Error:</b> An error occurred. Please try again.</p>`;

                messages.appendChild(messageElement);
                console.error("Error:", error);
            });
        });
    </script>
</body>
</html>

<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);

    $data = json_decode(file_get_contents('php://input'), true);

    $openaiApiKey = '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';
    $modelName = $data['chat_model'] ?? 'gpt-4';
    $apiUrl = "https://api.openai.com/v1/chat/completions";

    $postData = json_encode([
        "model" => $modelName,
        "messages" => [
            ["role" => "system", "content" => "You are a helpful assistant."],
            ["role" => "user", "content" => $data['message']]
        ]
    ]);

    $ch = curl_init($apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $openaiApiKey",
        "Content-Type: application/json"
    ]);

    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);

    if ($error) {
        echo json_encode(["error" => ["msg" => "cURL Error: $error"]]);
    } else {
        $responseDecoded = json_decode($response, true);
        if (isset($responseDecoded['error'])) {
            echo json_encode(["error" => ["msg" => $responseDecoded['error']['message']]]);
        } else {
            echo $response;
        }
    }
}
?>
