<?php
$this->layout = '//layouts/systemcgridview';
$startDate = $_GET['start_date'] ?? date('Y-m-d');
$endDate = $_GET['end_date'] ?? date('Y-m-d');
$extension = $_GET['extension'] ?? '';
$caller = $_GET['caller'] ?? '';
$callee = $_GET['callee'] ?? '';
$submit = isset($_GET['submit']);

$data = [];
$error = '';

if ($submit) {
    $apiUser = 'cdrapi';
    $apiPass = 'cdrapi123';
    $ucmHost = '192.168.1.24:8089'; // Use actual IP here
    $url = "http://$ucmHost/cgi-bin/api-cdr-http?username=$apiUser&password=$apiPass&start_time=$startDate&end_time=$endDate";

    if ($extension) $url .= "&extension=$extension";
    if ($caller) $url .= "&caller=$caller";
    if ($callee) $url .= "&callee=$callee";

    $response = @file_get_contents($url);
    if ($response) {
        $json = json_decode($response, true);
        if (!empty($json['cdr'])) {
            $data = $json['cdr'];
        } else {
            $error = 'No call records found.';
        }
    } else {
        $error = 'Challenge Failed or API unreachable.';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Grandstream Call Reports</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body class="p-4 bg-light">
    <div class="container bg-white p-4 rounded shadow">
        <h2 class="mb-4">📞 Grandstream Call Reports</h2>
        <form method="get" class="row g-3 mb-4">
            <div class="col-md-3">
                <label class="form-label">Start Date</label>
                <input type="date" name="start_date" value="<?= $startDate ?>" class="form-control">
            </div>
            <div class="col-md-3">
                <label class="form-label">End Date</label>
                <input type="date" name="end_date" value="<?= $endDate ?>" class="form-control">
            </div>
            <div class="col-md-2">
                <label class="form-label">Extension</label>
                <input type="text" name="extension" value="<?= $extension ?>" class="form-control">
            </div>
            <div class="col-md-2">
                <label class="form-label">Caller</label>
                <input type="text" name="caller" value="<?= $caller ?>" class="form-control">
            </div>
            <div class="col-md-2">
                <label class="form-label">Callee</label>
                <input type="text" name="callee" value="<?= $callee ?>" class="form-control">
            </div>
            <div class="col-md-12 d-flex justify-content-between mt-3">
                <button type="submit" name="submit" value="1" class="btn btn-primary">Search</button>
                <?php if (!empty($data)): ?>
                    <a href="data:application/vnd.ms-excel;charset=utf-8,<?= urlencode(generateCSV($data)) ?>"
                       download="call_report.xls" class="btn btn-success">Export to Excel</a>
                <?php endif; ?>
            </div>
        </form>

        <?php if ($error): ?>
            <div class="alert alert-danger"><?= $error ?></div>
        <?php elseif (!empty($data)): ?>
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Call Date</th>
                            <th>Caller</th>
                            <th>Callee</th>
                            <th>Extension</th>
                            <th>Duration</th>
                            <th>Direction</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($data as $row): ?>
                            <tr>
                                <td><?= $row['start_time'] ?? '' ?></td>
                                <td><?= $row['caller'] ?? '' ?></td>
                                <td><?= $row['callee'] ?? '' ?></td>
                                <td><?= $row['extension'] ?? '' ?></td>
                                <td><?= $row['duration'] ?? '' ?></td>
                                <td><?= $row['direction'] ?? '' ?></td>
                                <td><?= $row['status'] ?? '' ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>

<script>
    // Optional JS enhancements
    console.log("Grandstream CDR Page Ready");
</script>
</body>
</html>

<?php
function generateCSV($rows) {
    ob_start();
    $out = fopen('php://output', 'w');
    fputcsv($out, ['Call Date', 'Caller', 'Callee', 'Extension', 'Duration', 'Direction', 'Status']);
    foreach ($rows as $r) {
        fputcsv($out, [
            $r['start_time'] ?? '',
            $r['caller'] ?? '',
            $r['callee'] ?? '',
            $r['extension'] ?? '',
            $r['duration'] ?? '',
            $r['direction'] ?? '',
            $r['status'] ?? ''
        ]);
    }
    fclose($out);
    return ob_get_clean();
}
?>