
	<style>
	    .chart-container {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        
        .chart {
            flex: 1;
            max-width: 50%;
        }
        
        .legend {
            max-width: 50%;
        }

	</style>
	<?php
// Use the actual project ID
$project_id = $project->id;
$list = Yii::app()->db->createCommand("
    SELECT
        'Total' AS project_title,
        SUM(total_units) AS total_units,
        SUM(available_units) AS available_units,
        SUM(available_units_price) AS available_units_price,
        SUM(reserved_units) AS reserved_units,
        SUM(reserved_units_price) AS reserved_units_price,
        SUM(sold_units) AS sold_units,
        SUM(sold_units_price) AS sold_units_price,
        SUM(held_units) AS held_units,
        SUM(held_units_price) AS held_units_price,
        SUM(blocked_units) AS blocked_units,
        SUM(blocked_units_price) AS blocked_units_price,
        SUM(off_units) AS off_units,
        SUM(off_units_price) AS off_units_price,
        SUM(pending_units) AS pending_units,
        SUM(pending_units_price) AS pending_units_price
    FROM (
        SELECT
            p.title AS project_title,
            COUNT(*) AS total_units,
            SUM(CASE WHEN booking IS NULL THEN 1 ELSE 0 END) AS available_units,
            SUM(CASE WHEN booking IS NULL THEN u.total ELSE 0 END) AS available_units_price,
            SUM(CASE WHEN booking = 1 THEN 1 ELSE 0 END) AS reserved_units,
            SUM(CASE WHEN booking = 1 THEN u.total ELSE 0 END) AS reserved_units_price,
            SUM(CASE WHEN booking = 2 THEN 1 ELSE 0 END) AS sold_units,
            SUM(CASE WHEN booking = 2 THEN u.total ELSE 0 END) AS sold_units_price,
            SUM(CASE WHEN booking = 4 THEN 1 ELSE 0 END) AS held_units,
            SUM(CASE WHEN booking = 4 THEN u.total ELSE 0 END) AS held_units_price,
            SUM(CASE WHEN booking = 3 THEN 1 ELSE 0 END) AS blocked_units,
            SUM(CASE WHEN booking = 3 THEN u.total ELSE 0 END) AS blocked_units_price,
            SUM(CASE WHEN booking = 5 THEN 1 ELSE 0 END) AS off_units,
            SUM(CASE WHEN booking = 5 THEN u.total ELSE 0 END) AS off_units_price,
            SUM(CASE WHEN booking = 7 THEN 1 ELSE 0 END) AS pending_units,
            SUM(CASE WHEN booking = 7 THEN u.total ELSE 0 END) AS pending_units_price
        FROM units u
        JOIN projects p ON u.projects_id = p.id
        GROUP BY p.title
        HAVING project_title IS NOT NULL -- Filter out the rollup rows
    ) AS aggregated_data
")->queryAll();

?>
	<div class="col-xl-12 col-lg-12 order-lg-2 order-xl-1">
		<!--begin:: Widgets/Profit Share-->
		<div class="kt-portlet kt-portlet--height-fluid">
			<div class="kt-widget14">
				<div class="kt-widget14__header">
					<h3 class="kt-widget14__title">
						Units Analyzes
					</h3>
					<span class="kt-widget14__desc">
						Explore detailed unit analysis in charts
					</span>
				</div>
				<div class="kt-widget14__content w-100">
					<div class="kt-widget14__chart w-100">
						<div class="chart-container">
                            <div id="kt_chart_profit_sharechartdiv" class="chart"></div>
                            <div id="kt_chart_legendkt_chart_profit_sharechartdiv" class="legend" style="height:210px;"></div>
                        </div>
					</div>
				</div>
			</div>
		</div>
		<!--end:: Widgets/Profit Share-->
	</div>
								
   <script>
   $(document).ready(function() {
    am4core.ready(function() {
        // Apply themes
        am4core.useTheme(am4themes_animated);

        // Create chart instance
        var chart = am4core.create("kt_chart_profit_sharechartdiv", am4charts.PieChart);

        // Add data
        chart.data = [
            <?php if(!empty($list)){
    foreach($list as $item) { ?>
            { "technology": "Available", "share": <?php echo $item['available_units']; ?> },
            { "technology": "Reserved", "share": <?php echo $item['reserved_units']; ?> },
            { "technology": "Sold", "share": <?php echo $item['sold_units']; ?> },
            { "technology": "Hold", "share": <?php echo $item['held_units']; ?> },
            { "technology": "Blocked", "share": <?php echo $item['blocked_units']; ?> },
            { "technology": "Off", "share": <?php echo $item['off_units']; ?> },
            { "technology": "Pending", "share": <?php echo $item['pending_units']; ?> },
            
<?php }  } ?>
        ];
        // Add and configure Series
        var pieSeries = chart.series.push(new am4charts.PieSeries());
        pieSeries.dataFields.value = "share";
        pieSeries.dataFields.category = "technology";

        // Make the chart a doughnut chart
        chart.innerRadius = am4core.percent(75);

        // Disable ticks and labels
        pieSeries.labels.template.disabled = true;
        pieSeries.ticks.template.disabled = true;

        // Add colors
        pieSeries.slices.template.propertyFields.fill = "color";
        pieSeries.colors.list = [
            am4core.color("#1dc9b7"),  // Equivalent to KTApp.getStateColor('success')
            am4core.color("#22b9ff"),  // Equivalent to KTApp.getStateColor('danger')
            am4core.color("#ffb822")   // Equivalent to KTApp.getStateColor('brand')
        ];

        // Add a legend
        chart.legend = new am4charts.Legend();
        chart.legend.parent = am4core.create("kt_chart_legendkt_chart_profit_sharechartdiv", am4core.Container);
        chart.legend.position = "right";
        chart.legend.itemContainers.template.paddingTop = 1;
        chart.legend.itemContainers.template.paddingBottom = 1;
        chart.legend.markers.template.width = 23;
        chart.legend.markers.template.height = 5;

        // Tooltip configuration
        pieSeries.slices.template.tooltipText = "{category}: {value.formatNumber('#')}";
        pieSeries.slices.template.tooltip.background.fill = am4core.color("#007bff");
        pieSeries.slices.template.tooltip.fontSize = 8;
        pieSeries.slices.template.tooltip.fontWeight = "bold";
        pieSeries.slices.template.tooltip.fill = am4core.color("#ffffff");
        pieSeries.slices.template.tooltip.cornerRadius = 4;
        pieSeries.slices.template.tooltip.pointerOrientation = "vertical";
        pieSeries.slices.template.tooltip.background.strokeWidth = 0;
    }); // end am4core.ready()
});
    </script>
    <?php
		$list= Yii::app()->db->createCommand("SELECT
COUNT(CASE WHEN (reservation.con_date = '' OR reservation.con_date IS NULL) AND reservation.confirm IS NULL THEN reservation.lead_id END) AS 'CountRes',
COUNT(CASE WHEN (reservation.con_date != '' OR reservation.con_date IS NOT NULL) AND reservation.confirm IS NOT NULL THEN reservation.lead_id END) AS 'CountCon'
FROM `reservation`
WHERE reservation.cancel IS NULL
")->queryAll();
		//if($list)
		//echo build_table($list);
		?>
    <div class="col-xl-12 col-lg-12 order-lg-2 order-xl-1">
    	<!--begin:: Widgets/Revenue Change-->
    	<div class="kt-portlet kt-portlet--height-fluid">
    		<div class="kt-widget14">
    			<div class="kt-widget14__header mb-4">
    				<h3 class="kt-widget14__title float-left">
    					Contract Pipeline
    				</h3>
    				<div class="kt-portlet__head-toolbar" style="float: right;margin:-10px 0px 20px;">
    					<a href="#" class="btn btn-icon" data-toggle="dropdown">
    						<i class="flaticon-more-1 kt-font-dark"></i>
    					</a>
    					<div class="dropdown-menu dropdown-menu-fit dropdown-menu-right" style="max-height: 200px; overflow-y: scroll;">
    						<ul class="kt-nav">
            					<li class="kt-nav__item">
            						<a target="_blank" href="<?php echo Yii::app()->getBaseUrl(true) ?>/account/confirmreservation" class="kt-nav__link">
            							<i class="kt-nav__link-icon flaticon2-graph-1"></i>
            							<span class="kt-nav__link-text">Reservation</span>
            						</a>
            					</li>
            					<li class="kt-nav__item">
            						<a target="_blank" href="<?php echo Yii::app()->getBaseUrl(true) ?>/sales/conreservation" class="kt-nav__link">
            							<i class="kt-nav__link-icon flaticon2-graph-1"></i>
            							<span class="kt-nav__link-text">Contracted</span>
            						</a>
            					</li>
    						</ul>
    					</div>
    				</div>
    			</div>
    			<div class="kt-widget14__content w-100">
    				<div class="kt-widget14__chart w-100">
						<div class="chart-container">
        					<div id="kt_chart_revenue_change1" class="chart"></div>
                            <div id="kt_chart_legendkt_chart_revenue_change1" class="legend"></div>
                        </div>
    				</div>
    			</div>
    		</div>
    	</div>
    	<!--end:: Widgets/Revenue Change-->
    </div>
								
   <script>
$(document).ready(function() {
    am4core.ready(function() {
        // Apply themes
        am4core.useTheme(am4themes_animated);

        // Create chart instance
        var chart = am4core.create("kt_chart_revenue_change1", am4charts.PieChart);

        // Add data
        chart.data = [
                   <?php if(!empty($list)){
    foreach($list as $item) { ?>
            { "technology": "Reservation", "share": <?php echo $item['CountRes']; ?> },
            { "technology": "Contract", "share": <?php echo $item['CountCon']; ?> },
            
<?php }  } ?>
        ];

        // Add and configure Series
        var pieSeries = chart.series.push(new am4charts.PieSeries());
        pieSeries.dataFields.value = "share";
        pieSeries.dataFields.category = "technology";

        // Make the chart a doughnut chart
        chart.innerRadius = am4core.percent(75);

        // Disable ticks and labels
        pieSeries.labels.template.disabled = true;
        pieSeries.ticks.template.disabled = true;

        // Add colors
        pieSeries.slices.template.propertyFields.fill = "color";
        pieSeries.colors.list = [
            am4core.color("#1dc9b7"),  // Equivalent to KTApp.getStateColor('success')
            am4core.color("#22b9ff"),  // Equivalent to KTApp.getStateColor('danger')
            am4core.color("#ffb822")   // Equivalent to KTApp.getStateColor('brand')
        ];

        // Add a legend
        chart.legend = new am4charts.Legend();
        chart.legend.parent = am4core.create("kt_chart_legendkt_chart_revenue_change1", am4core.Container);
        chart.legend.position = "right";
        // chart.legend.valign = "middle";
        // chart.legend.marginRight = 15;
         chart.legend.itemContainers.template.paddingTop = 1;
         chart.legend.itemContainers.template.paddingBottom = 1;
        // chart.legend.labels.template.maxWidth = 100;
        // chart.legend.itemContainers.template.width = am4core.percent(100);
        // chart.legend.labels.template.truncate = true;
        // chart.legend.labels.template.wrap = true;
        // chart.legend.useDefaultMarker = true;
        chart.legend.markers.template.width = 23;
        chart.legend.markers.template.height = 5;

        // Tooltip configuration
        pieSeries.slices.template.tooltipText = "{category}: {value.formatNumber('#')}";
        pieSeries.slices.template.tooltip.background.fill = am4core.color("#007bff");
        pieSeries.slices.template.tooltip.fontSize = 8;
        pieSeries.slices.template.tooltip.fontWeight = "bold";
        pieSeries.slices.template.tooltip.fill = am4core.color("#ffffff");
        pieSeries.slices.template.tooltip.cornerRadius = 4;
        pieSeries.slices.template.tooltip.pointerOrientation = "vertical";
        pieSeries.slices.template.tooltip.background.strokeWidth = 0;

        // Adjust chart container position
        chart.chartContainer.style.marginLeft = "0"; // Set left margin to 0 or adjust as needed
        chart.chartContainer.style.marginRight = "auto"; // Align to the right

    }); // end am4core.ready()
});

    </script>
    <?php
		$list= Yii::app()->db->createCommand("SELECT
COUNT(CASE WHEN installments.confirm IS NULL THEN installments.id END) 'notyet',
COUNT(CASE WHEN installments.confirm IS NOT NULL THEN installments.id END) 'paid'
FROM `installments`
")->queryAll();
		//if($list)
		//echo build_table($list);
		?>
	<div class="col-xl-12 col-lg-12 order-lg-2 order-xl-1">
		<!--begin:: Widgets/Revenue Change-->
		<div class="kt-portlet kt-portlet--height-fluid">
			<div class="kt-widget14">
				<div class="kt-widget14__header">
					<h3 class="kt-widget14__title">
						Revenue Change
					</h3>
					<span class="kt-widget14__desc">
						Breakdown of revenue changes, including installment payments
					</span>
				</div>
				<div class="kt-widget14__content w-100">
					<div class="kt-widget14__chart w-100">
						<div class="chart-container">
    						<div id="kt_chart_revenue_change2" class="chart"></div>
                            <div id="kt_chart_legendkt_chart_revenue_change2" class="legend"></div>
                        </div>
					</div>
				</div>
			</div>
		</div>
		<!--end:: Widgets/Revenue Change-->
	</div>
								
   <script>

        $(document).ready(function() {
           am4core.ready(function() {
            // Apply themes
            am4core.useTheme(am4themes_animated);

            // Create chart instance
            var chart = am4core.create("kt_chart_revenue_change2", am4charts.PieChart);

            // Add data
            chart.data = [
                     <?php if(!empty($list)){
    foreach($list as $item) { ?>
            { "technology": "Paid", "share": <?php echo $item['paid']; ?> },
            { "technology": "Not Yet", "share": <?php echo $item['notyet']; ?> },
            
<?php }  } ?>
            ];

            // Add and configure Series
            var pieSeries = chart.series.push(new am4charts.PieSeries());
            pieSeries.dataFields.value = "share";
            pieSeries.dataFields.category = "technology";

            // Make the chart a doughnut chart
            chart.innerRadius = am4core.percent(75);

            // Disable ticks and labels
            pieSeries.labels.template.disabled = true;
            pieSeries.ticks.template.disabled = true;

            // Add colors
            pieSeries.slices.template.propertyFields.fill = "color";
            pieSeries.colors.list = [
                am4core.color("#1dc9b7"),  // Equivalent to KTApp.getStateColor('success')
                am4core.color("#22b9ff"),  // Equivalent to KTApp.getStateColor('danger')
                am4core.color("#ffb822")   // Equivalent to KTApp.getStateColor('brand')
            ];

            // Add a legend
                chart.legend = new am4charts.Legend();
                chart.legend.parent = am4core.create("kt_chart_legendkt_chart_revenue_change2", am4core.Container);
                chart.legend.position = "right";
                // chart.legend.valign = "middle";
                // chart.legend.marginRight = 15;
                 chart.legend.itemContainers.template.paddingTop = 1;
                 chart.legend.itemContainers.template.paddingBottom = 1;
                // chart.legend.labels.template.maxWidth = 100;
                // chart.legend.itemContainers.template.width = am4core.percent(100);
                // chart.legend.labels.template.truncate = true;
                // chart.legend.labels.template.wrap = true;
                // chart.legend.useDefaultMarker = true;
                chart.legend.markers.template.width = 23;
                chart.legend.markers.template.height = 5;

            // Tooltip configuration
            pieSeries.slices.template.tooltipText = "{category}: {value.formatNumber('#')}";
            pieSeries.slices.template.tooltip.background.fill = am4core.color("#007bff");
            pieSeries.slices.template.tooltip.fontSize = 8;
            pieSeries.slices.template.tooltip.fontWeight = "bold";
            pieSeries.slices.template.tooltip.fill = am4core.color("#ffffff");
            pieSeries.slices.template.tooltip.cornerRadius = 4;
            pieSeries.slices.template.tooltip.pointerOrientation = "vertical";
            pieSeries.slices.template.tooltip.background.strokeWidth = 0;
        }); // end am4core.ready()
});
    </script>