<?php
$baseUrl = Yii::app()->getBaseUrl(true);
?>

<!-- Styles -->
<link rel="stylesheet" href="<?= $baseUrl ?>/js/daterangepicker.css" />
<link rel="stylesheet" href="<?= $baseUrl ?>/js/tom-select.bootstrap5.min.css" />
<link rel="stylesheet" href="<?= $baseUrl ?>/js/jquery.dataTables.min.css">
<link rel="stylesheet" href="<?= $baseUrl ?>/js/buttons.dataTables.min.css">

<!-- Scripts -->
<script src="<?= $baseUrl ?>/js/jquery.dataTables.min.js"></script>
<script src="<?= $baseUrl ?>/js/dataTables.buttons.min.js"></script>
<script src="<?= $baseUrl ?>/js/buttons.html5.min.js"></script>
<script src="<?= $baseUrl ?>/js/buttons.print.min.js"></script>
<script src="<?= $baseUrl ?>/js/buttons.colVis.min.js"></script>
<script src="<?= $baseUrl ?>/js/dataTables.colReorder.min.js"></script>
<script src="<?= $baseUrl ?>/js/dataTables.responsive.min.js"></script>
<script src="<?= $baseUrl ?>/js/daterangepicker.min.js"></script>
<script src="<?= $baseUrl ?>/js/tom-select.complete.min.js"></script>

<!-- Debounce helper (must come before your ready block) -->
<script>
function debounce(func, delay) {
  let timer;
  return function (...args) {
    const context = this;
    clearTimeout(timer);
    timer = setTimeout(() => func.apply(context, args), delay);
  };
}
</script>

<!-- Custom Fixes -->
<style>
  .filter-form {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
    gap: 12px;
    margin-bottom: 20px;
    padding: 15px;
    background: #fafafa;
    border: 1px solid #ddd;
    border-radius: 8px;
  }
  .filter-form input,
  .filter-form select {
    height: 40px;
    padding: 6px 10px;
    font-size: 14px;
    border: 1px solid #ccc;
    border-radius: 6px;
    background: white;
    width: 100%;
  }
  div.dataTables_filter { display: none !important; }
  .dataTables_wrapper .dataTables_length {
    float: right !important;
    margin-top: -15px;
    margin-right: 20px;
  }
  table.dataTable {
    width: 100% !important;
    table-layout: auto;
  }
  .dataTables_scrollHeadInner, .dataTables_scrollHeadInner table {
    width: 100% !important;
  }
</style>

<!-- Controls -->
<div class="filter-buttons">
  <button id="resetTable">Reset Filters</button>
  <button id="saveFilters">Save Filters</button>
  <button id="loadFilters">Load Filters</button>
</div>
<style>/* Show + icon only if not child/parent/hasChild */
table.dataTable tbody tr:not(.dt-hasChild):not(.parent):not(.child) td:first-child::before {
    content: '+';
    position: absolute;
    left: 0px;
    z-index: 9;
    border: 1px solid #cd2f2f;
    border-radius: 50%;
    width: 10px;
    height: 10px;
    text-align: center;
    color: #cd2f2f;
    line-height: 7px;
    font-weight: bold;
    background-color: #fff;
    margin-top: 4px;
    font-size: 12px;
}
/* Reverse rule — clears content for these rows */
table.dataTable tbody tr.dt-hasChild td:first-child::before,
table.dataTable tbody tr.parent td:first-child::before,
table.dataTable tbody tr.child td:first-child::before {
    content: '';
}
</style>
<div style="width: 300px; margin: 20px 0;">
  <label for="filterSelector"><b>Select Columns to Filter:</b></label>
  <select id="filterSelector" multiple placeholder="Select Filters..."></select>
</div>

<!-- Filters and Table -->
<div class="filter-form" id="external-filters"></div>
<table id="leadsTable" class="display nowrap" style="width:100%">
  <thead><tr id="lead-header"></tr></thead>
</table>
<?php
$alltypebuliding = TypeBuliding::model()->findAll(['condition' => 'hidden=1', 'order' => 'id DESC']);
$staticJson = json_encode(array_map(function($t) {
    return ['id' => $t->id, 'title' => $t->title, 'parent_id' => $t->parent_id];
}, $alltypebuliding));
?>
<script>
const allTypes = <?= $staticJson ?>;
$(document).ready(function () {
  const columns = [
    "ID","Code","Date","Time","Name","1st Telephone","2nd Telephone",
    "Created By","Sales","Auto Assign","Ad Name","Order Type","Property Type",
    "Projects","Campaign","Platform","Platform Child","Notes","Sales Report",
    "Action Date","Status","Sub Status","Follow Date","Follow Time",
    "Action Time","Transfer Date","User Name","Visit","Client"
  ];
  const dataSrc = [
    "id","code","date","time","title","tel","second_tel",
    "created_fname","sales_fname","unseen_fname","adname","unittype_title","propertytype_title",
    "project_title","campaign_title","platform_title","platformchild_title","notes","sales_report",
    "checkup_activity","status_title","substatus_title","follow_date","follow_time",
    "action_time","transferdate","transfer_fname","visit","client_id"
  ];
const dropdownAjaxIndices = [7,8,13,14,15,16,20,21,26].filter(i => ![11,12].includes(i)); // exclude Order Type (11) & Property Type (12)
const dateIndices = [2,19,22,23];

  // build headers
  columns.forEach(t => $('#lead-header').append(`<th>${t}</th>`));

  const table = $('#leadsTable').DataTable({
    processing: true,
    serverSide: true,
    responsive: true,
    colReorder: true,
    stateSave: true,
    scrollX: true,
    autoWidth: false,
    ajax: {
      url: "<?= Yii::app()->createUrl('login/getLeadsJsonDT') ?>",
      type: "GET"
    },
    columns: dataSrc.map(d => ({ data: d })),
    dom: 'Blfrtip',
    buttons: [
      'copyHtml5','excelHtml5','csvHtml5','pdfHtml5','print',
      { extend:'colvis', text:'Choose Columns' }
    ],
    pageLength: 10,
    initComplete: function () {
      const api = this.api();
      const filters = $('#external-filters').empty();

      columns.forEach((title, idx) => {
        const wrapper = $('<div>').hide();
        let input;

        if (dropdownAjaxIndices.includes(idx)) {
          input = $(`<select id="filter_${idx}" multiple placeholder="All ${title}"></select>`);
          wrapper.append(input).appendTo(filters);
          new TomSelect(`#filter_${idx}`, {
            plugins: ['remove_button'],
            valueField: 'text',
            labelField: 'text',
            searchField: 'text',
            create: false,
            preload: true,
            load(query, cb) {
              $.ajax({
                url: "<?= Yii::app()->createUrl('login/getFilterOptions') ?>",
                data: { term: query, column: idx },
                dataType: 'json',
                success: res => cb(res.results)
              });
            },
            onChange(vals) {
              api.column(idx).search(vals.join('|'), false, false).draw();
            }
          });

        } else if (dateIndices.includes(idx)) {
          input = $(`<input type="text" id="filter_${idx}" placeholder="${title}" />`);
          input.daterangepicker({
            autoUpdateInput: false,
            locale: { cancelLabel: 'Clear', format: 'YYYY-MM-DD' }
          });
          input.on('apply.daterangepicker', (e,p) => {
            const r = p.startDate.format('YYYY-MM-DD') + ' to ' + p.endDate.format('YYYY-MM-DD');
            $(e.target).val(r);
            api.column(idx).search(r).draw();
          });
          input.on('cancel.daterangepicker', e => {
            $(e.target).val('').trigger('change');
          });
          wrapper.append(input).appendTo(filters);

        } else if (idx === 11) { // Order Type
          input = $(`<select id="filter_${idx}" multiple placeholder="All ${title}"></select>`);
          const staticOptions = allTypes.filter(t => t.parent_id === null);
          staticOptions.forEach(opt => {
            input.append(`<option value="${opt.id}">${opt.title}</option>`);
          });
          wrapper.append(input).appendTo(filters);
        
          new TomSelect(`#filter_${idx}`, {
            plugins: ['remove_button'],
            onChange(vals) {
              const propSelect = document.getElementById("filter_12")?.tomselect;
              if (!propSelect) return;
        
              propSelect.clear();
              propSelect.clearOptions();
              const children = allTypes.filter(t => vals.includes(String(t.parent_id)));
              children.forEach(child => {
                propSelect.addOption({ value: child.id, text: child.title });
              });
              propSelect.refreshOptions(false);
        
              api.column(idx).search(vals.join('|'), false, false).draw();
            }
          });
        
        } else if (idx === 12) { // Property Type
          input = $(`<select id="filter_${idx}" multiple placeholder="All ${title}"></select>`);
          wrapper.append(input).appendTo(filters);
        
          new TomSelect(`#filter_${idx}`, {
            plugins: ['remove_button'],
            valueField: 'id',
            labelField: 'title',
            searchField: 'title',
            create: false,
            onChange(vals) {
              api.column(idx).search(vals.join('|'), false, false).draw();
            }
          }); } else {
          input = $(`<input type="text" id="filter_${idx}" placeholder="${title}" />`);
          input.on('keyup change', function () {
              api.column(idx).search(this.value).draw();
            });
          wrapper.append(input).appendTo(filters);
        }
      });

      // build the filterSelector
      columns.forEach((t,i) => {
        $('#filterSelector').append(`<option value="${i}">${t}</option>`);
      });
      new TomSelect('#filterSelector', {
        plugins: ['remove_button'],
        onChange(vals) {
          $('#external-filters > div').hide();
          columns.forEach((_,i) => {
            const $inp = $(`#filter_${i}`);
            if (vals.includes(i.toString())) {
              $inp.parent().show();
            } else {
              $inp.val('').trigger('change');
              if ($inp[0].tomselect) $inp[0].tomselect.clear();
              if ($inp.data('daterangepicker')) {
                $inp.data('daterangepicker').setStartDate(moment());
                $inp.data('daterangepicker').setEndDate(moment());
                $inp.val('');
              }
              table.column(i).search('').draw();
            }
          });
        }
      });
    }
  });

  // adjust on redraw
  table.on('draw.dt', () => {
      table.columns.adjust(); // ✅ don't call `.draw()` here!
    });

  // buttons
  $('#resetTable').on('click', () => {
    $('.filter-form input, .filter-form select').val('').trigger('change');
    table.search('').columns().search('').draw();
  });
  $('#saveFilters').on('click', () => {
    const f = {};
    $('.filter-form input, .filter-form select').each(function(){
      f[$(this).attr('id')] = $(this).val();
    });
    localStorage.setItem('FilterPreset_leadsTable', JSON.stringify(f));
  });
  $('#loadFilters').on('click', () => {
    const saved = JSON.parse(localStorage.getItem('FilterPreset_leadsTable'));
    if (!saved) return;
    Object.entries(saved).forEach(([id,val]) => {
      $(`#${id}`).val(val).trigger('change');
    });
  });
});
</script>