<?php
// Step 1: Get total deleted leads per day
$countSql = "
    SELECT 
        DATE(d.date) AS delete_date, 
        COUNT(*) AS total_deleted 
    FROM 
        deleteleads d 
    GROUP BY 
        DATE(d.date) 
    ORDER BY 
        delete_date DESC
";
$countResults = Yii::app()->db->createCommand($countSql)->queryAll();

// Step 2: Get per-day per-user deletion count
$userCountSql = "
    SELECT 
        DATE(d.date) AS delete_date, 
        d.user_id, 
        u.fname AS user_fname, 
        u.lname AS user_lname, 
        COUNT(*) AS total_by_user 
    FROM 
        deleteleads d
    LEFT JOIN 
        user u ON d.user_id = u.id
    GROUP BY 
        DATE(d.date), d.user_id
    ORDER BY 
        delete_date DESC, total_by_user DESC
";
$userCountResults = Yii::app()->db->createCommand($userCountSql)->queryAll();

// Step 3: Organize per-user breakdown by date
$groupedUsers = [];
foreach ($userCountResults as $row) {
    $date = date("d F, Y", strtotime($row['delete_date']));
    $groupedUsers[$date][] = [
        'user' => trim($row['user_fname'] . ' ' . $row['user_lname']),
        'count' => $row['total_by_user']
    ];
}

// Step 4: Pagination for deleted leads table
$limit = 50;
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int) $_GET['page'] : 1;
$page = max($page, 1);
$offset = ($page - 1) * $limit;

$totalSql = "SELECT COUNT(*) as total FROM deleteleads";
$totalCount = Yii::app()->db->createCommand($totalSql)->queryRow();
$totalRows = $totalCount['total'];
$totalPages = ceil($totalRows / $limit);

$sql = "SELECT 
            d.id, d.user_id, u1.fname as user_fname, u1.lname as user_lname, 
            d.date, d.time, d.lead_id, d.tel, d.title, d.user_sales, 
            u2.fname as user_sales_fname, u2.lname as user_sales_lname, 
            d.camp_id, d.platform_id, d.details 
        FROM deleteleads d
        LEFT JOIN user u1 ON d.user_id = u1.id
        LEFT JOIN user u2 ON d.user_sales = u2.id
        ORDER BY d.id DESC
        LIMIT $limit OFFSET $offset";
$results = Yii::app()->db->createCommand($sql)->queryAll();
?>

<!-- Accordion Summary -->
<h3 class="mb-4 text-primary font-weight-bold">📊 Summary of Deleted Leads by Date</h3>
<div class="accordion" id="deletedLeadsAccordion">
    <?php 
    $index = 0;
    foreach ($countResults as $item): 
        $formattedDate = date("d F, Y", strtotime($item['delete_date']));
        $id = 'collapse' . $index;
        $headingId = 'heading' . $index;
    ?>
    <div class="card shadow-sm mb-2 border-0 rounded">
        <div class="card-header bg-light border-bottom" id="<?php echo $headingId; ?>">
            <h5 class="mb-0 d-flex justify-content-between align-items-center">
                <button class="btn btn-link text-left text-dark font-weight-bold w-100 d-flex justify-content-between align-items-center <?php echo $index !== 0 ? 'collapsed' : ''; ?>" 
                        type="button" 
                        data-toggle="collapse" 
                        data-target="#<?php echo $id; ?>" 
                        aria-expanded="<?php echo $index === 0 ? 'true' : 'false'; ?>" 
                        aria-controls="<?php echo $id; ?>">
                    <span>
                        <?php echo CHtml::encode($formattedDate); ?>
                    </span>
                    <span class="badge badge-primary badge-pill">
                        <?php echo CHtml::encode($item['total_deleted']); ?> Lead<?php echo $item['total_deleted'] > 1 ? 's' : ''; ?>
                    </span>
                </button>
            </h5>
        </div>
        <div id="<?php echo $id; ?>" class="collapse <?php echo $index === 0 ? 'show' : ''; ?>" aria-labelledby="<?php echo $headingId; ?>" data-parent="#deletedLeadsAccordion">
            <div class="card-body bg-white">
                <?php if (isset($groupedUsers[$formattedDate])): ?>
                    <ul class="list-group list-group-flush">
                        <?php foreach ($groupedUsers[$formattedDate] as $u): ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span><?php echo CHtml::encode($u['user']); ?></span>
                                <span class="badge badge-secondary"><?php echo CHtml::encode($u['count']); ?> Lead<?php echo $u['count'] > 1 ? 's' : ''; ?></span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php else: ?>
                    <p class="text-muted mb-0">No breakdown available.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php $index++; endforeach; ?>
</div>

<hr>

<!-- Paginated Table -->
<h3>Deleted Leads (Page <?php echo $page; ?> of <?php echo $totalPages; ?>)</h3>
<table border="1" class="dataTable responsive table table-bordered table-striped table-hover">
    <thead class="thead-dark">
        <tr>
            <th>ID</th>
            <th>User</th>
            <th>Date</th>
            <th>Time</th>
            <th>Lead ID</th>
            <th>Tel</th>
            <th>Title</th>
            <th>User Sales</th>
            <th>Camp ID</th>
            <th>Platform ID</th>
            <th>Details</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($results as $row): ?>
        <tr>
            <td><?php echo CHtml::encode($row['id']); ?></td>
            <td><?php echo CHtml::encode($row['user_fname'] . ' ' . $row['user_lname']); ?></td>
            <td><?php echo CHtml::encode($row['date']); ?></td>
            <td><?php echo CHtml::encode($row['time']); ?></td>
            <td><?php echo CHtml::encode($row['lead_id']); ?></td>
            <td><?php echo CHtml::encode($row['tel']); ?></td>
            <td><?php echo CHtml::encode($row['title']); ?></td>
            <td><?php echo CHtml::encode($row['user_sales_fname'] . ' ' . $row['user_sales_lname']); ?></td>
            <td><?php echo CHtml::encode($row['camp_id']); ?></td>
            <td><?php echo CHtml::encode($row['platform_id']); ?></td>
            <td><?php echo CHtml::encode($row['details']); ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<!-- Pagination Controls -->
<nav>
    <ul class="pagination">
        <?php if ($page > 1): ?>
            <li class="page-item"><a class="page-link" href="?page=1">⏮ First</a></li>
            <li class="page-item"><a class="page-link" href="?page=<?php echo $page - 1; ?>">◀ Prev</a></li>
        <?php endif; ?>

        <?php
        $start = max(1, $page - 2);
        $end = min($totalPages, $page + 2);
        for ($i = $start; $i <= $end; $i++): ?>
            <li class="page-item <?php echo $i == $page ? 'active' : ''; ?>">
                <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
            </li>
        <?php endfor; ?>

        <?php if ($page < $totalPages): ?>
            <li class="page-item"><a class="page-link" href="?page=<?php echo $page + 1; ?>">Next ▶</a></li>
            <li class="page-item"><a class="page-link" href="?page=<?php echo $totalPages; ?>">Last ⏭</a></li>
        <?php endif; ?>
    </ul>
</nav>
<style>
.pagination {
    display: flex;
    padding-left: 0;
    list-style: none;
    border-radius: 0.25rem;
    width: 100%;
    flex-direction: row;
}
li.page-item {
    display: inline-flex;
}
</style>