<?php
function build_table($array)
{
    // Start table
    $html = '<table class="dataTable table responsive">';
    // Header row
    $html .= '<tr>';
    foreach ($array[0] as $key => $value) {
        $html .= '<th>' . htmlspecialchars($key) . '</th>';
    }
    $html .= '</tr>';
    // Data rows
    foreach ($array as $row) {
        $html .= '<tr>';
        foreach ($row as $key => $value) {
            if ($key === 'Lead ID' || $key === 'Lead Title') {
                // Generate the href dynamically
                $link = Yii::app()->getBaseUrl(true) . '/leads/profile/' . $row['Lead ID'];
                $html .= '<td><a href="' . htmlspecialchars($link) . '">' . htmlspecialchars($value) . '</a></td>';
            } else {
                $html .= '<td>' . htmlspecialchars($value) . '</td>';
            }
        }
        $html .= '</tr>';
    }
    // Finish table and return it
    $html .= '</table>';
    return $html;
}

$list = Yii::app()->db->createCommand("
    SELECT
        leads.id AS 'Lead ID',
        leads.title AS 'Lead Title',
        leads.date AS 'Lead Date'
    FROM leads
    WHERE leads.status IS NOT NULL
      AND leads.user_sales IS NULL
")->queryAll();

if ($list) {
    echo build_table($list);
}
?>
