<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- Leaflet (map) -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<!-- Leaflet Control Geocoder (search in map) -->
<link rel="stylesheet" href="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.css" />
<script src="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.js"></script>

<!-- Choices.js (searchable select for timezone) -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/choices.js/public/assets/styles/choices.min.css"/>
<script src="https://cdn.jsdelivr.net/npm/choices.js/public/assets/scripts/choices.min.js"></script>

<?php if (Yii::app()->user->hasFlash('success')): ?>
<div class="alert alert-success alert-dismissible fade show mt-3" role="alert">
  <?php echo Yii::app()->user->getFlash('success'); ?>
  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
<?php endif; ?>

<div class="mt-4">
  <div class="card shadow-sm rounded-4">
    <!-- Header -->
    <div class="card-header settings-header text-white">
      <div class="d-flex align-items-center gap-3">
        <div class="settings-header-icon">⚙️</div>
        <div>
          <h4 class="settings-header-title mb-0">Main Settings</h4>
          <div class="settings-header-sub text-white-50">Configure platform defaults & behavior</div>
        </div>
      </div>
    </div>

    <div class="card-body">
      <?php
      // ---------- IMPORTANT: Fix action so it doesn't redirect to //login/... ----------
      $form = $this->beginWidget('CActiveForm', array(
        'id' => 'mainsettings-form',
        'enableAjaxValidation' => false,
        'method' => 'post',
        'action' => Yii::app()->createUrl('/login/mainsettingsview'),
        'htmlOptions' => array('class' => 'needs-validation', 'novalidate' => 'novalidate'),
      ));
      ?>

      <?php if (Yii::app()->request->enableCsrfValidation): ?>
        <input type="hidden"
               name="<?php echo CHtml::encode(Yii::app()->request->csrfTokenName); ?>"
               value="<?php echo CHtml::encode(Yii::app()->request->csrfToken); ?>">
      <?php endif; ?>

      <div class="accordion settings-accordion mt-3" id="settingsAccordion">
        <?php
        // 1) Always-skip list
        $skipAlways = [
          'headerphoto','footerphoto','logo','logo_colored','id','msg_pt1','msg_pt2','clause','clause2',
          'visitmessage','dealmessage','menu_color','menu_header_color','menu_nav_header_color','side_menu_calendar_text',
          'side_menu_nav_circle','menu_links_bg','comp_title_color','comp_beside_title_color','comp_text_size',
          'table_content_text_size','table_content_text_color','menu_links_color','menu_links_color_on_hover',
          'menu_links_color_on_active','menu_links_size','box_title_color','box_title_size','box_main_background',
          'bar_lvl_1','bar_lvl_2','bar_lvl_3','bar_lvl_4','email','accounttree','substatusreq','recordpath','supplier_id',
          'revenues_id','expenses_id','orgins_id','obligation_id','safe_id','banks_id','cheques_id','property_rights_id',
          'local_client_id','global_client_id','company_type','ourcompany_logid','company_name','default_branch',
          'local_liability_id','global_liability_id','local_revenues_id','global_revenues_id','session'
        ];

        // 2) Groups
        $groups = [
          'Create Leads' => [
            'minlength','code','create_lead_hide_campaign','hideselectcampaign','create_lead_hide_platformchild',
            'platformchildrequired','create_lead_hide_projects','projectreq','hideplaceaddlead','placename','placereq',
            'monthlyincome_req','maritalstatus_req','somehidesinaddleads','spacename','create_lead_hide_adname',
            'create_lead_hide_3rdnumber','create_lead_hide_4thnumber','create_lead_hide_client_id',
            'create_lead_hide_employee_recommendation','create_lead_hide_branch','careername','create_lead_hide_fbid',
            'create_lead_hide_adsetname','hideaddplace'
          ],
          'Reservation' => [
            'resunder_name_required','resunder_phone_required','resunder_id_card_required','resunder_address_required',
            'resunder_nationality_required','resunder_job_required','resunder_address_email_required',
            'resunder_salesbroker_required','resunder_teamleaderbroker_required','resunder_unit_price_required',
            'resunder_downpayment_required','resunder_amount_paid_required','resunder_resv_date_required',
            'resunder_res_delivery_date_required','resunder_res_mantan_amount_required','resunder_cashflow_required',
            'resunder_commercialno_required','resunder_inst_number_required','resunder_teamleader1_required',
            'resunder_sales1_required','resunder_sakes1ra_required','resunder_finishing_required',
            'resunder_teamleader1ra_required','resunder_manager1_required','resunder_manager1ra_required',
            'resunder_sourcetitle_required','resunder_details_required','resform_total_unit_price',
            'resform_total_paid','resform_payment_method','resform_terms','resform_source'
          ],
          'Profile EOI' => [
            'eoi_unit','hide_eoi_id','hide_eoi_passport','hide_eoi_address','hide_eoi_job','hide_eoi_building',
            'hide_eoi_broker_id','eoi_otherareaname','hide_eoi_date_in_profile','eoi_area_req','eoi_floor_req'
          ],
          'Profile Edit Lead (Sales View)' => [
            'editleadsales','editsalesnameonly','editsalescodeonly','editsalessecondnameonly','editsalesaddressonly','editsalescareeronly','editsalesemailonly',
            'editsalestagonly','editsalesbudgetonly','editsalesspaceonly','editsalestelephoneonly'
          ],
          'Profile' => [
            'profile_hide_old_history','profile_hide_visit','profile_hide_close','profile_hide_request','profile_hide_quotation','profile_hide_request_transfer',
            'profile_hide_resale','profile_hide_feedback','profile_hide_eoi','profile_hide_mortgage','profile_hide_record_history','profile_hide_mention','profile_hide_transfer','profile_hide_integration',
            'profile_hide_transfer_to_branch','profile_hide_ticket','profile_hide_documents','profile_visit_hide_visited_units',
            'profile_visit_location_text1','profile_visit_location_text2','profile_visit_location_text3','profile_visit_location_text4','profile_visit_location_text5',
            'profile_visit_location_text6','profile_visit_location_text7','profile_visit_location_text8','profile_visit_location_text9'
          ],
          'Profile Quotation' => [
            'broker_quotation','profile_quot_broker_bua_text','profile_quot_broker_incentive_text','profile_quot_broker_contract_date_text','profile_quot_broker_reservation_details_text','quot_name_required','quot_id_card_required','quot_mail_required','quot_nationality_required',
            'quot_full_address_text_required','quot_address_in_details_required','quot_government_required',
            'quot_full_address_required','quot_state_required','quot_region_required','quot_street_required',
            'quot_buliding_required','quot_salesbroker_required','quot_teamleaderbroker_required','quot_developer_required',
            'quot_eoi_id_required','quot_amount_required','quot_end_date_required','quot_deposit_required',
            'quot_downpayment_required','quot_unit_required','quot_details_required','quot_return_lead_name',
            'quot_hide_id','quot_hide_passport','quot_name_readonly','quot_unit_price_readonly',
            'quot_hide_payment_plan_dates','profile_quot_broker_hide_unit_code','profile_quot_broker_hide_license',
            'profile_quot_broker_hide_transaction_type','profile_quot_broker_hide_destination','profile_quot_broker_hide_unit_type',
            'profile_quot_broker_hide_developer','profile_quot_broker_hide_project','profile_quot_broker_hide_outdoor','profile_quot_broker_hide_downpayment_percentage',
            'profile_quot_broker_hide_incentive','profile_quot_broker_hide_documents'
          ],
          'SMS Bulk' => ['username','password','sender'],
          'FTP Details' => ['ftphost','ftpusername','ftppassword'],
          'Timezone' => [],
          'Company Location' => ['latitude','longitude'],
          'Whatsapp Details' => [
            'whatsapp_sid','whatsapp_token','whatsapp_from','whatsapp_templatesid_1','whatsapp_templatesid_2','whatsapp_templatesid_3','whatsapp_templatesid_4','whatsapp_templatesid_5'
          ],
          'Enable/Disable Some Functions' => [
            'disable_directdata','disable_colddata','disable_indirectdata','disable_admin_inventory_search','disable_broker_search','disable_admin_code_generator',
            'disable_admin_attendance','disable_admin_mention','disable_admin_meeting_telesales','disable_admin_auto_assign',
            'disable_admin_reopen','disable_admin_retention','disable_admin_agent_dis_chart','disable_admin_units_analyzes','disable_admin_notdis_facebook','disable_admin_notdis_callcenter',
            'disable_admin_notdis_website','disable_admin_notdis_branch','disable_admin_top_achiever','disable_sales_meeting',
            'disable_sales_tsmeeting','disable_sales_closed','disable_sales_today_comment','disable_sales_top_achiever','disable_today_heros','disable_notifications_firebase',
            'disable_pending_teamleaders','disable_duplicate_admin_view','disable_transfer_admin_view','hide_notesandfeedback_for_sales','dashboard_classification','dashboard_status'
          ],
          'Some General Texts' => [
            'quotationname','visitname','fakenewleadname','coldcallname','platformname','platformchildname',
            'totalbefordiscname','totalname','buildingregionname','unitdetailsname','notcommunicationname',
            'order_type_name','property_type_name','space_name','campaign_name'
          ],
          'APIs' => ['post_url','post_url_resv','post_url_eoi','post_url_resv_delete','post_token','apicode'],
        ];

        // 3) Flat set of grouped fields to avoid duplicates
        $groupedFields = [];
        foreach ($groups as $fields) { foreach ($fields as $f) { $groupedFields[$f] = true; } }

        // Timezone attribute key
        $tzAttrKey = null;
        if (array_key_exists('countrytimezone', $model->attributes)) {
          $tzAttrKey = 'countrytimezone';
          $groupedFields['countrytimezone'] = true;
        } elseif (array_key_exists('timezone', $model->attributes)) {
          $tzAttrKey = 'timezone';
          $groupedFields['timezone'] = true;
        }

        // Forced render types
        $numericOnly = ['minlength','maxuser','inderict','ext_no','minegycode'];
        $dateOnly    = ['beginningofthemonth','endofthemonth'];
        $yearOnly    = ['beginningofannual'];

        // 4) Field renderer (manual HTML for date/number)
        $renderField = function($field) use ($model, $tzAttrKey, $numericOnly, $dateOnly, $yearOnly) {
          if ($tzAttrKey && strtolower($field) === strtolower($tzAttrKey)) return; // handled in Timezone section
          if (!array_key_exists($field, $model->attributes)) return;

          $col    = $model->getTableSchema()->columns[$field] ?? null;
          $dbType = $col ? strtolower((string)$col->dbType) : '';
          $fname  = strtolower($field);
          $val    = isset($model->$field) ? (string)$model->$field : '';

          $id   = CHtml::activeId($model, $field);
          $name = CHtml::activeName($model, $field);
          $value= CHtml::encode($val);

          echo '<div class="col-md-4">';
            echo '<label class="form-label">' . CHtml::encode($model->getAttributeLabel($field)) . '</label>';

            if (in_array($fname, $numericOnly, true)) {
              echo '<input type="number" class="form-control" step="1" min="0" inputmode="numeric" id="'.$id.'" name="'.$name.'" value="'.$value.'">';
            }
            elseif (in_array($fname, $dateOnly, true)) {
              echo '<input type="date" class="form-control" id="'.$id.'" name="'.$name.'" value="'.$value.'" placeholder="YYYY-MM-DD">';
            }
            elseif (in_array($fname, $yearOnly, true)) {
              $current = (int)date('Y');
              $startY  = 2000;
              $endY    = $current + 5;
              $years   = [];
              for ($y = $endY; $y >= $startY; $y--) { $years[$y] = (string)$y; }
              echo CHtml::activeDropDownList($model, $field, $years, [
                'class' => 'form-select',
                'prompt'=> 'Select year…'
              ]);
            }
            elseif ($col && preg_match('/\b(int|tinyint|bit|bool|boolean)\b/', $dbType)) {
              $ynClass = '';
              if ($val === '1')      $ynClass = 'yn-yes is-valid';
              elseif ($val === '0')  $ynClass = 'yn-no is-invalid';

              echo CHtml::activeDropDownList(
                $model,
                $field,
                ['' => 'Select…', 1 => 'Yes', 0 => 'No'],
                ['class' => 'form-select yn-select ' . $ynClass, 'data-yn' => '1']
              );
            }
            elseif ($col && strpos($dbType, 'text') !== false) {
              echo CHtml::activeTextArea($model, $field, [
                'class' => 'form-control form-control-textlike',
                'rows'  => 1,
              ]);
            }
            else {
              echo CHtml::activeTextField($model, $field, ['class' => 'form-control']);
            }

            echo CHtml::error($model, $field, ['class' => 'text-danger small']);
          echo '</div>';
        };

        // ===== Countries -> timezones =====
        $getCountryName = function(string $code): string {
          if (function_exists('locale_get_display_region')) {
            $name = @locale_get_display_region('-'.$code, 'en');
            if (!empty($name) && $name !== '-'.$code) return $name;
          }
          return $code;
        };

        $countriesTz = [];
        for ($i = 65; $i <= 90; $i++) {
          for ($j = 65; $j <= 90; $j++) {
            $code = chr($i).chr($j);
            try {
              $tzs = @DateTimeZone::listIdentifiers(DateTimeZone::PER_COUNTRY, $code);
              if (!empty($tzs)) { sort($tzs, SORT_NATURAL); $countriesTz[$code] = $tzs; }
            } catch (Throwable $e) {}
          }
        }
        uksort($countriesTz, function($a,$b) use ($getCountryName){
          return strnatcasecmp($getCountryName($a), $getCountryName($b));
        });
        $fmtOffset = function (int $seconds) {
          $sign = $seconds < 0 ? '-' : '+';
          $seconds = abs($seconds);
          $h = floor($seconds / 3600);
          $m = floor(($seconds % 3600) / 60);
          return sprintf('GMT%s%02d:%02d', $sign, $h, $m);
        };

        $tzOptions = [];
        foreach ($countriesTz as $code => $tzs) {
          $label = $getCountryName($code);
          $tzOptions[$label] = [];
          foreach ($tzs as $tz) {
            try {
              $z = new DateTimeZone($tz);
              $offset = $fmtOffset($z->getOffset(new DateTime('now', $z)));
              $tzOptions[$label][$tz] = $tz . ' — ' . $offset;
            } catch (Throwable $e) {}
          }
        }

        $tzAttrName = $tzAttrKey ?: 'countrytimezone';
        $tzSelectId = 'country-timezone-select';

        // 5) Render groups (special handling for Timezone & Company Location)
        $accIndex = 0;
        foreach ($groups as $sectionTitle => $fields) {
          $accIndex++;
          $slug = strtolower(preg_replace('/[^a-zA-Z0-9]+/', '-', $sectionTitle));
          $headingId = "settings-heading-$slug";
          $collapseId = "settings-collapse-$slug";
          $open = ($accIndex === 1);

          $latId = $lngId = '';
          if ($sectionTitle === 'Company Location') {
            if (array_key_exists('latitude', $model->attributes))  $latId = CHtml::activeId($model, 'latitude');
            if (array_key_exists('longitude', $model->attributes)) $lngId = CHtml::activeId($model, 'longitude');
          }
          ?>
          <div class="accordion-item mb-2">
            <h2 class="accordion-header" id="<?php echo $headingId; ?>">
              <button class="accordion-button <?php echo $open ? '' : 'collapsed'; ?>"
                      type="button"
                      data-bs-toggle="collapse"
                      data-bs-target="#<?php echo $collapseId; ?>"
                      aria-expanded="<?php echo $open ? 'true' : 'false'; ?>"
                      aria-controls="<?php echo $collapseId; ?>">
                <span class="me-2 accordion-icon"></span>
                <?php echo CHtml::encode($sectionTitle); ?>
              </button>
            </h2>
            <div id="<?php echo $collapseId; ?>"
                 class="accordion-collapse collapse <?php echo $open ? 'show' : ''; ?>"
                 data-bs-parent="#settingsAccordion"
                 aria-labelledby="<?php echo $headingId; ?>">
              <div class="accordion-body">

                <?php if ($sectionTitle === 'Timezone'): ?>
                  <div class="mb-3 tz-select-wrap position-relative">
                    <label for="<?php echo $tzSelectId; ?>" class="form-label fw-semibold">Country / Timezone</label>
                    <?php
                      echo CHtml::activeDropDownList(
                        $model,
                        $tzAttrName,
                        $tzOptions,
                        [
                          'id'    => $tzSelectId,
                          'class' => 'form-select',
                          'prompt'=> 'Select a timezone…',
                        ]
                      );
                    ?>
                    <div class="form-text">Search by city or zone, e.g. “Cairo”, “Europe/Paris”, “GMT+02”.</div>
                  </div>
                <?php endif; ?>

                <?php if ($sectionTitle === 'Company Location'): ?>
                  <div class="mb-3">
                    <div id="company-map"
                         class="map-box rounded-3 border"
                         data-lat-input-id="<?php echo CHtml::encode($latId); ?>"
                         data-lng-input-id="<?php echo CHtml::encode($lngId); ?>">
                    </div>
                    <div class="form-text mt-1">
                      Click the map or drag the marker. Use search or the current-location button.
                    </div>
                  </div>
                <?php endif; ?>

                <div class="row g-3">
                  <?php
                  if (!empty($fields)) {
                    foreach ($fields as $field) {
                      if (!array_key_exists($field, $model->attributes)) { continue; }
                      $renderField($field);
                    }
                  } else {
                    echo '<div class="text-muted small">No fields configured yet for this section.</div>';
                  }
                  ?>
                </div>
              </div>
            </div>
          </div>
          <?php
        } // end groups

        // 6) General
        $generalFields = [];
        foreach ($model->attributes as $field => $value) {
          if (in_array($field, $skipAlways, true)) continue;
          if (isset($groupedFields[$field])) continue;
          $generalFields[] = $field;
        }
        ?>
        <div class="accordion-item mb-2">
          <h2 class="accordion-header" id="settings-heading-general">
            <button class="accordion-button collapsed" type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#settings-collapse-general"
                    aria-expanded="false"
                    aria-controls="settings-collapse-general">
              <span class="me-2 accordion-icon"></span>
              General
            </button>
          </h2>
          <div id="settings-collapse-general" class="accordion-collapse collapse"
               data-bs-parent="#settingsAccordion" aria-labelledby="settings-heading-general">
            <div class="accordion-body">
              <div class="row g-3">
                <?php
                if (!empty($generalFields)) {
                  foreach ($generalFields as $field) {
                    if (!array_key_exists($field, $model->attributes)) continue;
                    $renderField($field);
                  }
                } else {
                  echo '<div class="text-muted small">No general fields.</div>';
                }
                ?>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="text-center mt-4">
        <?php echo CHtml::submitButton('Save Settings', ['class' => 'btn btn-success px-5']); ?>
      </div>

      <?php $this->endWidget(); ?>
    </div>
  </div>
</div>

<style>
  .settings-header{background:linear-gradient(135deg,#3e4958,#630538);padding:1rem 1.25rem;border-top-left-radius:1rem;border-top-right-radius:1rem}
  .settings-header-icon{width:42px;height:42px;line-height:42px;display:inline-flex;align-items:center;justify-content:center;border-radius:12px;background:rgba(255,255,255,.15);font-size:20px}
  .settings-header-title{font-weight:800;letter-spacing:.2px}
  .settings-header-sub{font-size:.875rem;margin-top:.25rem}

  .settings-accordion{--bs-accordion-border-color:rgba(0,0,0,.08);--bs-accordion-border-radius:1rem;--bs-accordion-inner-border-radius:1rem;--bs-accordion-btn-padding-y:.9rem;--bs-accordion-btn-padding-x:1.15rem;--bs-accordion-active-bg:rgba(13,110,253,.06);--bs-accordion-active-color:#0d6efd;--bs-accordion-btn-focus-box-shadow:0 0 0 0 rgba(0,0,0,0);overflow:visible}
  .settings-accordion .accordion-item{border:1px solid var(--bs-accordion-border-color);border-radius:1rem;overflow:visible;box-shadow:0 3px 12px rgba(0,0,0,.05);background:#fff}
  .settings-accordion .accordion-collapse,.settings-accordion .accordion-body{overflow:visible}
  .settings-accordion .accordion-button{font-weight:700;gap:.5rem;color:#212529;background:#fff}
  .settings-accordion .accordion-button:hover{color:#0d6efd;background:rgba(13,110,253,.04)}
  .settings-accordion .accordion-button:not(.collapsed){color:var(--bs-accordion-active-color);background:var(--bs-accordion-active-bg)}
  .settings-accordion .accordion-button:focus{box-shadow:none}
  .settings-accordion .accordion-icon{display:inline-block;width:.85rem;height:.85rem;border-right:2px solid currentColor;border-bottom:2px solid currentColor;transform:rotate(-45deg);transition:transform .2s ease;opacity:.8;margin-top:.2rem}
  .settings-accordion .accordion-button:not(.collapsed) .accordion-icon{transform:rotate(135deg)}

  .settings-accordion .form-label{font-weight:600}
  .settings-accordion .form-control,.settings-accordion .form-select{border-radius:.65rem;border-color:rgba(0,0,0,.175)}
  .settings-accordion .form-control:focus,.settings-accordion .form-select:focus{border-color:#86b7fe;box-shadow:0 0 0 .2rem rgba(13,110,253,.15)}

  .settings-accordion .form-control-textlike{height:calc(1.5em + .75rem + 2px);padding:.375rem .75rem;line-height:1.5;resize:vertical}

  .settings-accordion .form-select.yn-yes{border-color:var(--bs-success);background-color:var(--bs-success-bg-subtle);color:var(--bs-success-text-emphasis)}
  .settings-accordion .form-select.yn-no{border-color:var(--bs-danger);background-color:var(--bs-danger-bg-subtle);color:var(--bs-danger-text-emphasis)}
  .settings-accordion .form-select.is-valid:focus{box-shadow:0 0 0 .2rem rgba(25,135,84,.15)}
  .settings-accordion .form-select.is-invalid:focus{box-shadow:0 0 0 .2rem rgba(220,53,69,.15)}

  .map-box{height:360px;width:100%;position:relative}
  .leaflet-control-locate{background:#fff;border:1px solid rgba(0,0,0,.15);border-radius:.5rem;box-shadow:0 4px 14px rgba(0,0,0,.08);display:flex;align-items:center;justify-content:center;width:38px;height:38px;cursor:pointer}
  .leaflet-control-locate:hover{background:#f8f9fa}
  .leaflet-control-locate .loc-dot{width:14px;height:14px;border-radius:50%;border:2px solid #0d6efd;background:rgba(13,110,253,.15)}

  .tz-select-wrap{position:relative;z-index:10}
  .settings-accordion .choices{overflow:visible}
  .settings-accordion .choices__list--dropdown{z-index:2000}

  .settings-accordion,.settings-accordion .accordion-item,.settings-accordion .accordion-collapse{transform:translateZ(0);will-change:height}
  .settings-accordion .accordion-item.is-animating{box-shadow:none!important}
  .settings-accordion .accordion-collapse.is-animating{overflow:hidden!important}
</style>

<script>
(function () {
  'use strict';

  // Validation
  document.querySelectorAll('.needs-validation').forEach(function (form) {
    form.addEventListener('submit', function (event) {
      if (!form.checkValidity()) {
        event.preventDefault();
        event.stopPropagation();
      }
      form.classList.add('was-validated');
    }, false);
  });

  // Yes/No coloring
  function applyYNClass(sel) {
    sel.classList.remove('yn-yes','yn-no','is-valid','is-invalid');
    if (sel.value === '1') { sel.classList.add('yn-yes','is-valid'); }
    else if (sel.value === '0') { sel.classList.add('yn-no','is-invalid'); }
  }
  document.querySelectorAll('.yn-select[data-yn="1"]').forEach(function (sel) {
    applyYNClass(sel); sel.addEventListener('change', function(){ applyYNClass(sel); });
  });

  // Timezone Choices
  (function initTimezoneChoices(){
    try {
      var tzSel = document.getElementById('country-timezone-select');
      if (!tzSel || !window.Choices) return;
      if (tzSel.dataset.choicesBound === '1') return;

      new Choices(tzSel, {
        searchEnabled: true,
        shouldSort: false,
        itemSelectText: '',
        searchPlaceholderValue: 'Search timezones…',
        renderSelectedChoices: 'always',
        allowHTML: true
      });
      tzSel.dataset.choicesBound = '1';

      var box = tzSel.parentElement.querySelector('.choices');
      if (box) box.classList.add('w-100');
    } catch (e) { console.warn('Timezone select init failed:', e); }
  })();

  // Leaflet map
  (function initMap(){
    var mapEl = document.getElementById('company-map');
    if (!mapEl || !window.L) return;

    try {
      var latInputId = mapEl.getAttribute('data-lat-input-id') || '';
      var lngInputId = mapEl.getAttribute('data-lng-input-id') || '';
      var latInput = latInputId ? document.getElementById(latInputId) : null;
      var lngInput = lngInputId ? document.getElementById(lngInputId) : null;

      var lat = parseFloat(latInput && latInput.value);
      var lng = parseFloat(lngInput && lngInput.value);
      var hasCoords = Number.isFinite(lat) && Number.isFinite(lng);

      var start = hasCoords ? [lat, lng] : [30.0444, 31.2357]; // Cairo default
      var zoom  = hasCoords ? 14 : 6;

      var map = L.map(mapEl, { zoomControl: true }).setView(start, zoom);

      L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        maxZoom: 19,
        attribution: '&copy; OpenStreetMap contributors'
      }).addTo(map);

      var marker = L.marker(start, { draggable: true }).addTo(map);

      function setPos(latlng, setView) {
        if (latInput) latInput.value = (+latlng.lat).toFixed(6);
        if (lngInput) lngInput.value = (+latlng.lng).toFixed(6);
        marker.setLatLng(latlng);
        if (setView) map.setView(latlng, Math.max(map.getZoom(), 15));
      }

      map.on('click', function(e){ setPos(e.latlng, false); });
      marker.on('dragend', function(){ setPos(marker.getLatLng(), false); });

      try {
        if (L.Control && L.Control.geocoder) {
          L.Control.geocoder({ defaultMarkGeocode: false })
            .on('markgeocode', function(e) { setPos(e.geocode.center, true); })
            .addTo(map);
        }
      } catch(e) { console.warn('Geocoder init failed:', e); }

      var LocateControl = L.Control.extend({
        options: { position: 'topleft' },
        onAdd: function() {
          var container = L.DomUtil.create('div', 'leaflet-control-locate');
          container.title = 'Use current location';
          L.DomUtil.create('div', 'loc-dot', container);
          L.DomEvent.disableClickPropagation(container);
          L.DomEvent.on(container, 'click', function () {
            if (!navigator.geolocation) { alert('Geolocation is not supported by your browser.'); return; }
            navigator.geolocation.getCurrentPosition(function (pos) {
              setPos({ lat: pos.coords.latitude, lng: pos.coords.longitude }, true);
            }, function (err) {
              alert('Unable to fetch your location: ' + (err && err.message ? err.message : 'Unknown error'));
            }, { enableHighAccuracy: true, timeout: 10000, maximumAge: 0 });
          });
          return container;
        }
      });
      map.addControl(new LocateControl());

      document.addEventListener('shown.bs.collapse', function (ev) {
        if (ev.target.contains(mapEl) || mapEl === ev.target || mapEl.contains(ev.target)) {
          setTimeout(function(){ map.invalidateSize(); }, 200);
        }
      });

      if (hasCoords) { setPos({ lat: lat, lng: lng }, false); }
    } catch (e) { console.error('Map init failed:', e); }
  })();

  // Accordion paint fix
  (function() {
    document.addEventListener('show.bs.collapse', function (ev) {
      var c = ev.target, i = c.closest('.accordion-item'); if (!i) return;
      i.classList.add('is-animating'); c.classList.add('is-animating');
    });
    document.addEventListener('shown.bs.collapse', function (ev) {
      var c = ev.target, i = c.closest('.accordion-item'); if (!i) return;
      c.classList.remove('is-animating'); i.classList.remove('is-animating');
    });
    document.addEventListener('hide.bs.collapse', function (ev) {
      var c = ev.target, i = c.closest('.accordion-item'); if (!i) return;
      i.classList.add('is-animating'); c.classList.add('is-animating');
    });
    document.addEventListener('hidden.bs.collapse', function (ev) {
      var c = ev.target, i = c.closest('.accordion-item'); if (!i) return;
      c.classList.remove('is-animating'); i.classList.remove('is-animating');
    });
  })();
})();
</script>