
<?php 
$allwords2 = Staticwords::model()->findByPk(2); 
$today = date("Y-m-d"); 
$close = 1; 

// Fetch the total number of leads in the Leads table
$totalLeads = Leads::model()->count(); 
?>

<div class="row">
    <?php 
    // Loop through all statuses
    $allstatues = Statues::model()->findAll(); 
    foreach ($allstatues as $stat) {
        // Prepare criteria for counting leads for each status
        $criteria = new CDbCriteria();             
        $criteria->addSearchCondition('status', $stat->id, false);
        $criteria->addCondition('coldcall IS NULL');  
        $allleads = Leads::model()->count($criteria);

        // Calculate percentage of leads for this status
        $percentage = ($totalLeads > 0) ? round(($allleads / $totalLeads) * 100, 2) : 0;

        if (!empty($allleads)) { 
    ?>
           <div class="col-6 col-sm-6 col-md-3">
                <div class="lead-stats-icons-holder lead-stats-icons-holder-st" data-toggle="modal" data-target="#kt_modal_new_card<?php echo $stat->id; ?>">
                    <span class="icon-holder">
                        <img src="<?php echo Yii::app()->getBaseUrl(true) ?>/img/solid-icons/Status.png" height="45px" class="pl-5 pr-5">
                    </span>
                    <span class="text-holder">
                        <h4><?php echo $stat->title; ?></h4>
                        <h4><?php echo $allleads; ?> (<?php echo $percentage; ?>%)</h4>
                    </span>
                </div>
            </div>

            <!-- Modal for showing sub-statuses -->
            <div class="modal fade" id="kt_modal_new_card<?php echo $stat->id; ?>" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered mw-650px">
                    <div class="modal-content">
                        <div class="modal-body scroll-y p-0">
                            <?php 
                            // Fetch all substatuses for the current status
                            $allsubstatues = Substatus::model()->findAll(array('condition' => 'parent_id=' . $stat->id)); 
                            if (!empty($allsubstatues)) {
                                foreach ($allsubstatues as $substatues) { 
                                    $criteriaSub = new CDbCriteria();
                                    $criteriaSub->addCondition('coldcall IS NULL');
                                    $criteriaSub->addCondition('status = ' . $stat->id);
                                    $criteriaSub->addSearchCondition('substatus', $substatues->id, false);
                                    $subLeadCount = Leads::model()->count($criteriaSub);

                                    if (!empty($subLeadCount)) {
                            ?>
                                <a class="dropdown-item" href="<?php echo Yii::app()->getBaseUrl(true) ?>/en/sales/searchsales?startdate=&enddate=&usersales%5B%5D=&team=&exusersales%5B%5D=&lastreport%5B%5D=&teamdistributed%5B%5D=&project%5B%5D=&platform%5B%5D=&platformchild%5B%5D=&status%5B%5D=&substatus%5B%5D=&substatus%5B%5D=<?php echo $substatues->id; ?>&othersubstatus%5B%5D=&strategy%5B%5D=&campaign%5B%5D=&dupcampaign%5B%5D=&tags%5B%5D=&callcenter%5B%5D=&marketingby%5B%5D=&startsysdate=&endsysdate=&startduplicatedate=&endduplicatedate=&startfakeedate=&endfakedate=&expstarttransferedate=&expendtransferedate=&startfollowdate=&endfollowdate=&startactiondate=&endactiondate=&starttransferdate=&endtransferdate=&search=&email=&details=&transferreason=&career=&fb_id=&adsetname=&adname=&coderef=&internationalcode=&tel=&internationalcode2=&secondtel=&fresh%5B%5D=&except%5B%5D=&exceptplatform%5B%5D=&exceptcam%5B%5D=&place%5B%5D=&unit_type%5B%5D=&branch%5B%5D=&leadstate=&firstleadstate=&leadaction=&yt0=Search" target="_blank">
                                    <?php echo $subLeadCount; ?> <?php echo $substatues->title; ?>
                                </a>
                            <?php } else { ?>
                                <a class="dropdown-item">
                                    0 <?php echo $substatues->title; ?>
                                </a>
                            <?php } } } ?>
                            
                            <!-- Link to view all leads with this status -->
                            <a class="dropdown-item" href="<?php echo Yii::app()->getBaseUrl(true) ?>/en/sales/searchsales?startdate=&enddate=&usersales%5B%5D=&team=&exusersales%5B%5D=&lastreport%5B%5D=&teamdistributed%5B%5D=&project%5B%5D=&platform%5B%5D=&platformchild%5B%5D=&status%5B%5D=&status%5B%5D=<?php echo $stat->id ?>&substatus%5B%5D=&othersubstatus%5B%5D=&strategy%5B%5D=&campaign%5B%5D=&dupcampaign%5B%5D=&tags%5B%5D=&callcenter%5B%5D=&marketingby%5B%5D=&startsysdate=&endsysdate=&startduplicatedate=&endduplicatedate=&startfakeedate=&endfakedate=&expstarttransferedate=&expendtransferedate=&startfollowdate=&endfollowdate=&startactiondate=&endactiondate=&starttransferdate=&endtransferdate=&search=&email=&details=&transferreason=&career=&fb_id=&adsetname=&adname=&coderef=&internationalcode=&tel=&internationalcode2=&secondtel=&fresh%5B%5D=&except%5B%5D=&exceptplatform%5B%5D=&exceptcam%5B%5D=&place%5B%5D=&unit_type%5B%5D=&branch%5B%5D=&leadstate=&firstleadstate=&leadaction=&yt0=Search" target="_blank">
                                View All
                            </a>
                        </div>
                    </div>
                </div>
            </div>
    <?php 
        } else { 
    ?>
            <div class="col-6 col-sm-6 col-md-3">
                <div class="lead-stats-icons-holder lead-stats-icons-holder-st">
                    <span class="icon-holder">
                        <img src="<?php echo Yii::app()->getBaseUrl(true) ?>/img/solid-icons/Status.png" height="45px" class="pl-5 pr-5">
                    </span>
                    <span class="text-holder">
                        <h4><?php echo $stat->title; ?></h4>
                        <h4>0 (0%)</h4>
                    </span>
                </div>
            </div>
    <?php 
        } 
    } 

    // Block for "No Status" leads where status is NULL
    $criteriaNoStatus = new CDbCriteria();
    $criteriaNoStatus->addCondition('status IS NULL');
    $criteriaNoStatus->addCondition('coldcall IS NULL');
    $noStatusLeads = Leads::model()->count($criteriaNoStatus);
    $noStatusPercentage = ($totalLeads > 0) ? round(($noStatusLeads / $totalLeads) * 100, 2) : 0;
    ?>
    
    <div class="col-6 col-sm-6 col-md-3">
        <div class="lead-stats-icons-holder lead-stats-icons-holder-nc">
            <span class="icon-holder">
                <img src="<?php echo Yii::app()->getBaseUrl(true) ?>/img/solid-icons/Not Communicated.png" height="45px" class="pl-5 pr-5">
            </span>
            <span class="text-holder">
                <h4>No Status</h4>
                <h4><?php echo $noStatusLeads; ?> (<?php echo $noStatusPercentage; ?>%)</h4>
            </span>
        </div>
    </div>
    
    <!-- Additional block for "Cold Call" leads -->
    <?php 
    $criteriaColdCall = new CDbCriteria();
    $criteriaColdCall->addCondition('coldcall IS NOT NULL');
    $coldCallLeads = Leads::model()->count($criteriaColdCall);
    $coldCallPercentage = ($totalLeads > 0) ? round(($coldCallLeads / $totalLeads) * 100, 2) : 0;
    ?>
    
    <div class="col-6 col-sm-6 col-md-3">
        <div class="lead-stats-icons-holder lead-stats-icons-holder-fu">
            <span class="icon-holder">
                <img src="<?php echo Yii::app()->getBaseUrl(true) ?>/img/solid-icons/not-clear.png" height="45px" class="pl-5 pr-5">
            </span>
            <span class="text-holder">
                <h4>Cold/Indirect Data</h4>
                <h4><?php echo $coldCallLeads; ?> (<?php echo $coldCallPercentage; ?>%)</h4>
            </span>
        </div>
    </div>
</div>
