<?php

// Get current user ID
$userid = Yii::app()->user->id;

// Fetch all employees where the current user is the team leader
$allemployee = Teamleader::model()->findAll(array(
    'condition' => 'leader_id = :userid',
    'params' => array(':userid' => $userid),
    'order' => 'id DESC'
));

// Initialize an empty array to store sales_id of employees
$salesIds = array();
foreach ($allemployee as $leader) {
    $salesIds[] = $leader->sales_id;
}

// Fetch static words (assuming these are needed for other parts of the view)
$allwords25 = Staticwords::model()->findByPk(25);
$allwords30 = Staticwords::model()->findByPk(30);

// Define date range for the current month
$start = date('Y-m-01');  // First day of the current month
$end = date('Y-m-t');     // Last day of the current month

// Define the visit status (visit = 1)
$visit = 1;

// Prepare criteria to fetch leads within the date range and matching other conditions
$criteria = new CDbCriteria();
$criteria->addBetweenCondition("date", $start, $end);   // Filter by date range
$criteria->addSearchCondition('confirmsales', $visit, false); // Check confirm sales status
$criteria->addInCondition('user_id', $salesIds);  // Match sales_ids from teamleader's employees

// Fetch all leads matching the criteria
$allleads = Visit::model()->findAll($criteria);

// Check if there are any leads and display count, otherwise display 0
if (!empty($allleads)) {
    ?>
    <a href="<?php echo Yii::app()->getBaseUrl(true) ?>/visitleadsmonth" class="kt-widget4__title" target="_blank">
        <?php echo count($allleads); ?>
    </a>
<?php 
} else { 
    echo 0; 
}
?>
