<?php
require 's3/aws-autoloader.php';
use Aws\S3\S3Client;
use Aws\S3\Exception\S3Exception;
class ApiappController extends FrontController
{
    public $layout = '//layouts/loginlayout';
    
    public function filters() {
        return array(
            'accessControl',
        );
    }
    
    public function accessRules() {
        return array(
            array(
                'allow',
                'actions' => array('loginApi'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('loginApi', 'getAllLeads'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('getAllLeads'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('getAllLeadsSQL'),
                'users'   => array('*'),
            ),
            
            array(
                'allow',
                'actions' => array('getAllLeadsex'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('getAllacts'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('getAllstatues'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('getAllbrokers'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('getAllsubstatues'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAllstatuesforlead'),
                'users'   => array('*'), 
            ),
            array(
                'allow',
                'actions' => array('insertLeadActivityByUrl'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('InsertLeadCloseByUrl'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('InsertVisitByUrl'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('InsertLeadByUrl'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('InsertLocationByUrl'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAllUsers'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAllUsersex'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAllplatforms'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAllcampaigns'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAllcampaignsex'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAlltypesex'),
                'users'   => array('*'),
            ),
            array(
                'allow',
                'actions' => array('GetAllstatuesforleadclose'),
                'users'   => array('*'),
            ),
            array(
                'deny',
                'users' => array('*'),
            ),
        );
    }
    
    public function actionLoginApi() {
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
        header('Content-Type: application/json');
        $token = $_GET['token'] ?? null;
        if ('ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3' !== $token) {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
        if (isset($_GET['username'], $_GET['password'])) {
            $credentials = [
                'username' => $_GET['username'],
                'password' => $_GET['password'],
            ];
        } else {
            echo CJSON::encode([
                'status'  => false,
                'message' => 'Missing login credentials.',
            ]);
            Yii::app()->end();
        }
        $model = new LoginForm;
        $model->attributes = $credentials;
        if ($model->validate() && $model->login()) {
            $userid = Yii::app()->user->id;
            $user   = User::model()->findByPk($userid);
            if ($user !== null) {
                unset($user->password);
                $data = $user->attributes;
                echo CJSON::encode([
                    'status'  => true,
                    'message' => 'Authentication successful.',
                    'data'    => $data,
                ]);
            } else {
                echo CJSON::encode([
                    'status' => false,
                    'message' => 'User not found.',
                ]);
            }
            Yii::app()->end();
        }
        $errors = [];
        foreach ($model->getErrors() as $attr => $msgs) {
            $errors[$attr] = $msgs;
        }
        echo CJSON::encode([
            'status'  => false,
            'message' => 'Authentication failed.',
            'errors'  => $errors,
        ]);
        Yii::app()->end();
    }
    
    public function actionGetAllLeads() {
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
        $token         = isset($_GET['token'])         ? $_GET['token']         : null;
        $userSales     = isset($_GET['user'])          ? $_GET['user']          : null;
        $communication = isset($_GET['communication']) ? $_GET['communication'] : null;
        $transfer      = isset($_GET['transfer'])         ? $_GET['transfer']         : null;
        $close      = isset($_GET['close'])         ? $_GET['close']         : null;
        $type      = isset($_GET['type'])         ? $_GET['type']         : null;
        $followup      = isset($_GET['followup'])         ? $_GET['followup']         : null;
        $delay      = isset($_GET['delay'])         ? $_GET['delay']         : null;
        $startfollowdate      = isset($_GET['startfollowdate'])         ? $_GET['startfollowdate']         : null;
        $endfollowdate      = isset($_GET['endfollowdate'])         ? $_GET['endfollowdate']         : null;
        $id      = isset($_GET['id'])         ? $_GET['id']         : null;
        $phone      = isset($_GET['phone'])         ? $_GET['phone']         : null;
        $status      = isset($_GET['status'])         ? $_GET['status']         : null;
        $tel      = isset($_GET['tel'])         ? $_GET['tel']         : null;
        $title      = isset($_GET['title'])         ? $_GET['title']         : null;
        $date_from      = isset($_GET['date_from'])         ? $_GET['date_from']         : null;
        $date_to      = isset($_GET['date_to'])         ? $_GET['date_to']         : null;
        $notes      = isset($_GET['notes'])         ? $_GET['notes']         : null;
        $project_id      = isset($_GET['project_id'])         ? $_GET['project_id']         : null;
        $campaign_id      = isset($_GET['campaign_id'])         ? $_GET['campaign_id']         : null;
        $interest_id      = isset($_GET['interest_id'])         ? $_GET['interest_id']         : null;
        $platform_id      = isset($_GET['platform_id'])         ? $_GET['platform_id']         : null;
        $platformchild_id      = isset($_GET['platformchild_id'])         ? $_GET['platformchild_id']         : null;

     
        header('Content-Type: application/json');
        if ('ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3' !== $token) {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        if ($limit > 500) {
            $limit = 500;
        }
        $criteria = new CDbCriteria();
        if (!empty($startfollowdate) && !empty($endfollowdate)) {
            $startObj = DateTime::createFromFormat('d-m-Y', $startfollowdate);
            $endObj   = DateTime::createFromFormat('d-m-Y', $endfollowdate);
            if ($startObj && $endObj) {
                $start = $startObj->format('Y-m-d');
                $end   = $endObj->format('Y-m-d');
                $criteria->addBetweenCondition(
                    'follow_date',
                    $start,
                    $end
                );
            }
        }
        
        if (!empty($date_from) && !empty($date_to)) {
            $startObjfrom = DateTime::createFromFormat('d-m-Y', $date_from);
            $endObjfrom   = DateTime::createFromFormat('d-m-Y', $date_to);
            if ($startObj && $endObj) {
                $startfrom = $startObjfrom->format('Y-m-d');
                $endfrom   = $endObjfrom->format('Y-m-d');
                $criteria->addBetweenCondition(
                    'date',
                    $startfrom,
                    $endObjfrom
                );
            }
        }

        if ($id !== null) {
            $criteria->compare('id', $id);
        }
        if ($phone !== null) {
            if (substr($phone, 0, 1) === '0') {
                $phone = substr($phone, 1);
            }
            $criteria->compare('tel', $phone);
        }
        
        
        
        if (!empty($tel)) {
         //   var_dump($tel);exit;
        $where .= ' AND l.tel = :tel';
        $params[':tel'] = $tel;
        }

       
       
        
        if ($notes !== null) {
        
        $criteria->compare('note', $notes);
        
        //   $where .= ' AND l.title = :title';
        //   $params[':title'] = $title;
        }
        
        
         
        if ($campaign_id !== null) {
        
        $criteria->compare('campaign_id', $campaign_id);
        
        //   $where .= ' AND l.title = :title';
        //   $params[':title'] = $title;
        }
        
         if ($platform_id !== null) {
        
        $criteria->compare('platform_id', $platform_id);
        
        //   $where .= ' AND l.title = :title';
        //   $params[':title'] = $title;
        }



    
        if ($title !== null) {
        
        $criteria->compare('title', $title);
        
        //   $where .= ' AND l.title = :title';
        //   $params[':title'] = $title;
        }
    
    
    
    
    
    
     if ($status !== null) {
            $criteria->compare('status', $status);
        }
        if ($followup !== null) {
            $today = date('Y-m-d');
            $criteria->addBetweenCondition(
                'follow_date', $today, $today
            );
        }
        if ($delay !== null) {
            $yesterday = date('Y-m-d', strtotime('-1 day'));
            $criteria->addCondition("follow_date <= :yesterday");
            $criteria->params[':yesterday'] = $yesterday;
        }
        if ($userSales !== null) {
            $criteria->compare('user_sales', $userSales);
        }
        if ($communication !== null) {
            if ((string)$communication === '1') {
                $criteria->compare('communication', 1);
            } else {
                $criteria->addCondition('communication IS NULL');
            
            }
        }
    
       
        
        
        if ($transfer !== null) {
        // عند value = '1'، نُشترط أن يكون transfer = 1 فقط
        if ((string)$transfer === '1') {
        $criteria->compare('transfer', 1);
        } else {
        $criteria->addCondition('transfer IS NULL');
    
        }
        }
        
        
        if ($close !== null) {
        // عند value = '1'، نُشترط أن يكون transfer = 1 فقط
        if ((string)$close === '1') {
        $criteria->compare('close', 1);
        } else {
            
        $criteria->addCondition('close IS NULL');
    
        }
        }
        
        
        
        
      
      
      if ($type !== null) {
    
        switch ((string)$type) {
            case '1':
                // حالة 1: عرض السجلات اللي فيها coldcall فاضية (NULL)
                $criteria->addCondition('coldcall IS NULL');
                $criteria->addCondition('indirect IS NULL');
    
                break;
            case '2':
                // حالة 2: عرض السجلات المُغلقة فقط (close = 1)
                $criteria->addCondition('coldcall IS NOT NULL');
                $criteria->addCondition('indirect IS NULL');
    //var_dump(11);exit;
                break;
            case '3':
                // حالة 3: عرض السجلات غير المُغلقة (close = 0)
               // $criteria->compare('close', 0);
                //$criteria->addCondition('coldcall IS NOT NULL');
                $criteria->addCondition('indirect IS NOT NULL');
                
    
                break;
            default:
                // أي قيمة أخرى: ما نضيف شرط
                break;
        }
    }
    
        
    
        // لحساب totalCount لا تُضيف limit و offset
        $totalCount = Leads::model()->count($criteria);
    
        // بعد حساب totalCount، نضيف limit و offset لجلب الدُفعة
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب الدُفعة المحددة من السجلات
        $allLeads = Leads::model()->findAll($criteria);
    
        $result = [];
        foreach ($allLeads as $lead) {
            $result[] = $lead->attributes;
        }
    
        // حساب عدد الصفحات بالتقريب للأعلى
        $pages = ($totalCount > 0)
            ? (int) ceil($totalCount / $limit)
            : 0;
    
        // تجهيز الاستجابة بصيغة JSON مع معلومات pagination
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionGetAllLeadsSQL() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?: 'Africa/Cairo');
    
        // قراءة المتغيرات
        $token         = $_GET['token'] ?? null;
        $userSales     = $_GET['user'] ?? null;
        $communication = $_GET['communication'] ?? null;
        $transfer      = $_GET['transfer'] ?? null;
        $close         = $_GET['close'] ?? null;
        $type          = $_GET['type'] ?? null;
        $followup      = $_GET['followup'] ?? null;
        $delay         = $_GET['delay'] ?? null;
        $startfollowdate = $_GET['startfollowdate'] ?? null;
        $endfollowdate   = $_GET['endfollowdate'] ?? null;
        $id            = $_GET['id'] ?? null;
        $phone         = $_GET['phone'] ?? null;
        $status         = $_GET['status'] ?? null;
      

    
        header('Content-Type: application/json');
    
        // تحقق من التوكن
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode(['status' => false, 'message' => 'Unauthorized']);
            Yii::app()->end();
        }
    
        // Pagination
        $limit = 50;
        $page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int) $_GET['page'] : 1;
        $page = max($page, 1);
        $offset = ($page - 1) * $limit;
    
        // بناء الشروط
        $where = '1=1';
        $params = [];
    
        if ($userSales !== null) {
            $where .= ' AND l.user_sales = :userSales';
            $params[':userSales'] = $userSales;
        }
        
       
        if ($status !== null) {
            $where .= ' AND l.status = :status';
            $params[':status'] = $status;
        }
    
        if ($communication !== null) {
            if ($communication == '1') {
                $where .= ' AND l.communication = 1';
            } else {
                $where .= ' AND l.communication IS NULL';
            }
        }
    
        if ($transfer !== null) {
            if ($transfer == '1') {
                $where .= ' AND l.transfer = 1';
            } else {
                $where .= ' AND l.transfer IS NULL';
            }
        }
    
        if ($close !== null) {
            if ($close == '1') {
                $where .= ' AND l.close = 1';
            } else {
                $where .= ' AND l.close IS NULL';
            }
        }
    
        if ($id !== null) {
            $where .= ' AND l.id = :id';
            $params[':id'] = $id;
        }
    
        if ($phone !== null) {
            if (substr($phone, 0, 1) === '0') {
                $phone = substr($phone, 1);
            }
            $where .= ' AND l.tel = :phone';
            $params[':phone'] = $phone;
        }
    
        if ($followup !== null) {
            $today = date('Y-m-d');
            $where .= " AND DATE(l.follow_date) = :today";
            $params[':today'] = $today;
        }
    
        if ($delay !== null) {
            $yesterday = date('Y-m-d', strtotime('-1 day'));
            $where .= " AND DATE(l.follow_date) <= :yesterday";
            $params[':yesterday'] = $yesterday;
        }
    
        if (!empty($startfollowdate) && !empty($endfollowdate)) {
            $startObj = DateTime::createFromFormat('d-m-Y', $startfollowdate);
            $endObj   = DateTime::createFromFormat('d-m-Y', $endfollowdate);
    
            if ($startObj && $endObj) {
                $start = $startObj->format('Y-m-d');
                $end   = $endObj->format('Y-m-d');
                $where .= " AND DATE(l.follow_date) BETWEEN :start AND :end";
                $params[':start'] = $start;
                $params[':end'] = $end;
            }
        }
    
        if ($type !== null) {
            switch ((string)$type) {
                case '1':
                    $where .= ' AND l.coldcall IS NULL AND l.indirect IS NULL';
                    break;
                case '2':
                    $where .= ' AND l.coldcall IS NOT NULL AND l.indirect IS NULL';
                    break;
                case '3':
                    $where .= ' AND l.indirect IS NOT NULL';
                    break;
            }
        }
    
        // Total count
        $countSql = "SELECT COUNT(*) as total FROM leads l WHERE $where";
        $total = Yii::app()->db->createCommand($countSql)->queryRow(true, $params);
        $totalCount = $total['total'];
        $totalPages = ceil($totalCount / $limit);
    
        // Get paginated results
        $sql = "SELECT 
                    l.* 
                FROM leads l
                WHERE $where
                ORDER BY l.id DESC
                LIMIT $limit OFFSET $offset";
    
        $command = Yii::app()->db->createCommand($sql);
        foreach ($params as $key => $val) {
            $command->bindValue($key, $val);
        }
        $rows = $command->queryAll();
    
        echo CJSON::encode([
            'status' => true,
            'page' => $page,
            'limit' => $limit,
            'offset' => $offset,
            'totalCount' => (int)$totalCount,
            'totalPages' => $totalPages,
            'returned' => count($rows),
            'data' => $rows
        ]);
        Yii::app()->end();
    }

    public function actionGetAllActs() {
        
      //  var_dump(111);exit;
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token         = $_GET['token']         ?? null;
        $userSales     = $_GET['user']          ?? null;
        $close         = $_GET['close']         ?? null;
        $type          = $_GET['type']          ?? null;
        $followup      = $_GET['followup']      ?? null;
        $startfollowdate = $_GET['startfollowdate'] ?? null;
        $endfollowdate   = $_GET['endfollowdate']   ?? null;
        $lead   = $_GET['id']   ?? null;
        $hidden   = $_GET['hidden']   ?? null;
    
    
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 500); // أقصى حد 500
    
        $criteria = new CDbCriteria();
    
        // فلترة تاريخ follow_date: الأولوية لـ start/end، ثم followup، ثم delay
      
    
        // فلترة حسب المستخدم
        if ($userSales !== null) {
            $criteria->compare('user_id', $userSales);
        }
        
        
         if ($lead !== null) {
            $criteria->compare('leads_id', $lead);
        }
    
      
        if ($followup !== null) {
        $today = date('Y-m-d');
        $criteria->addBetweenCondition(
        'date',
        $today,
        $today
        );
        }
        
        // فلترة النوع
        if ($hidden !== null) {
            switch ((string)$hidden) {
                case '1':
                    $criteria->addCondition('hidden IS NULL');
                    break;
                case '2':
                    $criteria->addCondition('hidden IS NOT NULL');
                    break;
               
            }
        }
        
    
        // فلترة النوع
        if ($type !== null) {
            switch ((string)$type) {
                case '1':
                    $criteria->addCondition('coldcall IS NULL');
                    $criteria->addCondition('indirect IS NULL');
                    break;
                case '2':
                    $criteria->addCondition('coldcall IS NOT NULL');
                    $criteria->addCondition('indirect IS NULL');
                    break;
                case '3':
                    $criteria->addCondition('indirect IS NOT NULL');
                    break;
            }
        }
    
        // حساب عدد السجلات
        $totalCount = Activities::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allactivities = Activities::model()->findAll($criteria);
        $result = [];
        foreach ($allactivities as $activities) {
            $result[] = $activities->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionGetAllbrokers() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token = $_GET['token'] ?? null;
        $id    = $_GET['id']    ?? null;
        $user    = $_GET['user']    ?? null;
    
        header('Content-Type: application/json');
    
        // التحقق من التوكن
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // إعداد limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 500);
    
        // إعداد الكريتيريا
        $criteria = new CDbCriteria();
    
        // فلترة حسب الـ ID إن وجد
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
        
        
         if ($user !== null) {
            $criteria->compare('user_sales', $user);
        }
    
        // حساب العدد الكلي
        $totalCount = Brokers::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allBrokers = Brokers::model()->findAll($criteria);
        $result = [];
        foreach ($allBrokers as $broker) {
            $result[] = $broker->attributes;
        }
    
        // إعداد الرد
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionGetAllstatues() {
        
      //  var_dump(111);exit;
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token         = $_GET['token']         ?? null;
        $id     = $_GET['id']          ?? null;
       
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 500); // أقصى حد 500
    
        $criteria = new CDbCriteria();
    
        // فلترة تاريخ follow_date: الأولوية لـ start/end، ثم followup، ثم delay
      
    
        // فلترة حسب المستخدم
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
    
        // حساب عدد السجلات
        $totalCount = Statues::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allstatues = Statues::model()->findAll($criteria);
        $result = [];
        foreach ($allstatues as $statues) {
            $result[] = $statues->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionGetAllUsers() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token = $_GET['token'] ?? null;
        $id    = $_GET['id']    ?? null;
    
        header('Content-Type: application/json');
    
        // التحقق من التوكن
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 500); // الحد الأقصى 500
    
        $criteria = new CDbCriteria();
    
        // فلترة حسب id
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
        // حساب العدد الكلي
        $totalCount = User::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allUsers = User::model()->findAll($criteria);
        $result = [];
        foreach ($allUsers as $user) {
            $result[] = $user->attributes;
        }
    
        // إعداد الرد
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'     => true,
            'totalCount' => (int)$totalCount,
            'limit'      => (int)$limit,
            'offset'     => (int)$offset,
            'returned'   => count($result),
            'pages'      => $pages,
            'data'       => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionGetAllsubstatues() {
        
      //  var_dump(111);exit;
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token         = $_GET['token']         ?? null;
        $id     = $_GET['id']          ?? null;
        $status     = $_GET['status']          ?? null;
       
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 500); // أقصى حد 500
    
        $criteria = new CDbCriteria();
    
        // فلترة تاريخ follow_date: الأولوية لـ start/end، ثم followup، ثم delay
      
    
        // فلترة حسب المستخدم
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
        
        
         if ($status !== null) {
            $criteria->compare('parent_id', $status);
        }
    
      
      
        
        
    
        
    
    
        // حساب عدد السجلات
        $totalCount = Substatus::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allstatues = Substatus::model()->findAll($criteria);
        $result = [];
        foreach ($allstatues as $statues) {
            $result[] = $statues->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }

    public function actionGetAllstatuesforlead() {
        header('Content-Type: application/json');
    
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
    
        // التحقق من التوكن
        $token = $_GET['token'] ?? null;
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // إعداد limit و offset
        $limit  = min((int) ($_GET['limit'] ?? 100), 500);
        $offset = (int) ($_GET['offset'] ?? 0);
    
        // إعداد الاستعلام
        $id = $_GET['id'] ?? null;
        $criteria = new CDbCriteria();
        $criteria->order = "sort ASC, id ASC";
    
        // فقط الحالات التي clear = 1
        $criteria->addCondition("clear = 1");
    
        if ($id !== null) {
            $lead = Leads::model()->findByPk($id);
            if ($lead && $lead->status) {
                $status = Statues::model()->findByPk($lead->status);
                if ($status) {
                    $startingSort = (int)$status->sort;
    
                    // فلترة حسب ترتيب الحالة
                    $criteria->addCondition("sort >= :startSort");
                    $criteria->params[':startSort'] = $startingSort;
    
                    // فلترة visit حسب حالة lead
                    if ((int)$lead->visit !== 1) {
                        $criteria->addCondition("(visit IS NULL OR visit != 1)");
                    }
                }
            }
        }
    
        // حساب عدد السجلات
        $totalCount = Statues::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allstatues = Statues::model()->findAll($criteria);
        $result = [];
        foreach ($allstatues as $statues) {
            $result[] = $statues->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        echo json_encode([
            'status'      => true,
            'totalCount'  => $totalCount,
            'limit'       => $limit,
            'offset'      => $offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ]);
    
        Yii::app()->end();
    }
    
    public function actionGetAllstatuesforleadclose() {
        header('Content-Type: application/json');
    
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
    
        // التحقق من التوكن
        $token = $_GET['token'] ?? null;
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // إعداد limit و offset
        $limit  = min((int) ($_GET['limit'] ?? 100), 500);
        $offset = (int) ($_GET['offset'] ?? 0);
    
        // إعداد الاستعلام
        $criteria = new CDbCriteria();
        $criteria->order = "sort ASC, id ASC";
    
        // فقط الحالات التي clear = 2 (مغلقة)
        $criteria->addCondition("clear = 2");
    
        // لا نحتاج فلترة حسب lead أو الترتيب
        // فقط نفلتر visit إذا تم إرسال ID
        $id = $_GET['id'] ?? null;
        if ($id !== null) {
            $lead = Leads::model()->findByPk($id);
            if ($lead && (int)$lead->visit !== 1) {
                $criteria->addCondition("(visit IS NULL OR visit != 1)");
            }
        }
    
        // حساب عدد السجلات
        $totalCount = Statues::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allstatues = Statues::model()->findAll($criteria);
        $result = [];
        foreach ($allstatues as $statues) {
            $result[] = $statues->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        echo json_encode([
            'status'      => true,
            'totalCount'  => $totalCount,
            'limit'       => $limit,
            'offset'      => $offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ]);
    
        Yii::app()->end();
    }
    
    public function actionInsertLeadByUrl() {
        header('Content-Type: application/json');
    
        // إعداد التوقيت المحلي
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
    
        // التحقق من التوكن
        $token = $_GET['token'] ?? null;
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode(['status' => false, 'message' => 'Invalid token']);
            Yii::app()->end();
        }
    
        // استقبال البيانات
        $title       = $_GET['title']        ?? null;
        $tel         = $_GET['tel']          ?? null;
        $second_tel  = $_GET['second_tel']   ?? null;
        $tel3        = $_GET['tel3']         ?? null;
        $tel4        = $_GET['tel4']         ?? null;
        $email       = $_GET['email']        ?? null;
        $job         = $_GET['job']          ?? null;
        $notes       = $_GET['notes']        ?? null;
        $project_id  = $_GET['project_id']   ?? null;
        $campaign_id = $_GET['campaign_id']  ?? null;
        $interest_id = $_GET['interest_id']  ?? null;
        $platform_id = $_GET['platform_id']  ?? null;
        $platformchild_id = $_GET['platformchild_id'] ?? null;
        $user_id     = $_GET['user_id']      ?? null;
        $user_sales  = $_GET['user_sales']   ?? null;
        $user_marketing = $_GET['user_marketing'] ?? null;
        $fresh_sales = $_GET['fresh_sales']  ?? null;
        $orgrainc    = $_GET['orgrainc']     ?? null;
        $mediabuyer  = $_GET['mediabuyer']   ?? null;
        $branch      = $_GET['branch']       ?? null;
        $tag_id      = $_GET['tag_id']       ?? null;
        $tag         = $_GET['tag']          ?? null;
        $place       = $_GET['place']        ?? null;
        $campaign    = $_GET['campaign']     ?? null;
    
        // تحقق من user
        if (!$user_id || !User::model()->findByPk($user_id)) {
            echo json_encode(['status' => false, 'message' => 'Invalid user_id']);
            Yii::app()->end();
        }
    
        // تحقق من project
        if (!$project_id || !Projects::model()->findByPk($project_id)) {
            echo json_encode(['status' => false, 'message' => 'Invalid project_id']);
            Yii::app()->end();
        }
    
        // ربط strategy من campaign
        $campaignModel = Campaign::model()->findByPk($campaign_id);
        if (!$campaignModel || !$campaignModel->strategy_id) {
            echo json_encode(['status' => false, 'message' => 'Invalid campaign or missing strategy_id']);
            Yii::app()->end();
        }
        $strategy_id = $campaignModel->strategy_id;
    
        // إدخال البيانات
        $lead = new Leads();
        $lead->title           = $title;
        $lead->tel             = $tel;
        $lead->second_tel      = $second_tel;
        $lead->tel3            = $tel3;
        $lead->tel4            = $tel4;
        $lead->email           = $email;
        $lead->career          = $job;
        $lead->notes           = $notes;
        $lead->project_id      = $project_id;
        $lead->campaign_id     = $campaign_id;
        $lead->interest_id     = $interest_id;
        $lead->platform_id     = $platform_id;
        $lead->platformchild_id = $platformchild_id;
        $lead->user_id         = $user_id;
        $lead->user_sales      = $user_sales;
        $lead->user_marketing  = $user_marketing;
        $lead->fresh_sales     = $fresh_sales;
        $lead->orgrainc        = $orgrainc;
        $lead->mediabuyer      = $mediabuyer;
        $lead->strategy_id     = $strategy_id;
        $lead->date            = date('Y-m-d');
        $lead->time            = date('H:i:s');
        //$lead->communication   = NULL;
        $lead->hidden   = 1;
    
    
        // tag تلقائي إذا مش موجود
        if ($tag_id) {
            $lead->tag_id = $tag_id;
        } elseif ($tag) {
            $tagModel = Tag::model()->find('title=:t', [':t' => $tag]);
            if ($tagModel) {
                $lead->tag_id = $tagModel->id;
            } else {
                $newTag = new Tag();
                $newTag->title = $tag;
                if ($newTag->save()) {
                    $lead->tag_id = $newTag->id;
                }
            }
        }
    
        // place تلقائي
        if ($place) {
            $placeModel = Interestedplace::model()->find('title=:t', [':t' => $place]);
            if ($placeModel) {
                $lead->place = $placeModel->id;
            } else {
                $newPlace = new Interestedplace();
                $newPlace->title = $place;
                if ($newPlace->save()) {
                    $lead->place = $newPlace->id;
                }
            }
        }
    
      
    
        // الحفظ
        if ($lead->save()) {
            echo json_encode([
                'status' => true,
                'message' => 'Lead created successfully',
                'lead_id' => $lead->id,
                'secert' => $lead->id
            ]);
        } else {
            echo json_encode([
                'status' => false,
                'message' => 'Failed to save lead',
                'errors' => $lead->getErrors()
            ]);
        }
    
        Yii::app()->end();
    }
    
    public function actionInsertLeadActivityByUrl() {
        header('Content-Type: application/json');
    
        // ضبط التوقيت المحلي
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
    
        // التحقق من التوكن
        $token = $_GET['token'] ?? null;
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode(['status' => false, 'message' => 'Invalid or missing token']);
            Yii::app()->end();
        }
    
        // استقبال البيانات
        $user_id       = $_GET['user_id']       ?? null;
        $lead_id       = $_GET['leads_id']      ?? null;
        $report        = $_GET['report']        ?? null;
        $follow_date   = $_GET['follow_date']   ?? null;
        $follow_time   = $_GET['follow_time']   ?? null;
        $status_id     = $_GET['status']        ?? null;
        $substatus_id  = $_GET['substatus']     ?? null;
        $type          = $_GET['type']          ?? 1;
        $star          = $_GET['star']          ?? 0;
    
        // الوقت الحالي
        $today  = date('Y-m-d');
        $time   = date('H:i:s');
        $uniqid = uniqid();
        $rnd    = rand(10000, 99999);
    
        // تحقق من الحقول الأساسية
        if (!$user_id || !$lead_id || !$report || !$follow_date || !$status_id) {
            echo json_encode([
                'status' => false,
                'message' => 'Missing required fields',
                'fields' => compact('user_id', 'lead_id', 'report', 'follow_date', 'status_id')
            ]);
            Yii::app()->end();
        }
    
        // تحميل السجلات
        $lead       = Leads::model()->findByPk($lead_id);
        $user       = User::model()->findByPk($user_id);
        $status     = Statues::model()->findByPk($status_id);
        $substatus  = Substatus::model()->findByPk($substatus_id);
    
        if (!$lead || !$user || !$status) {
            echo json_encode(['status' => false, 'message' => 'Lead, User, or Status not found']);
            Yii::app()->end();
        }
    
        // تحقق من شرط visit
        if ((int)$status->visit === 1 && (int)$lead->visit !== 1) {
            echo json_encode(['status' => false, 'message' => 'This status requires visit = 1 in lead']);
            Yii::app()->end();
        }
    
        // إنشاء Activity
        $activity = new Activities();
        $activity->user_id       = $lead->user_sales;
        $activity->marketing_id  = $lead->user_id;
        $activity->date          = $today;
        $activity->details       = $report;
        $activity->follow_date   = $follow_date;
        $activity->follow_time   = $follow_time;
        $activity->status        = $status_id;
        $activity->substatus     = $substatus_id;
        $activity->type          = $type;
        $activity->star          = $star;
        $activity->time          = $time;
        $activity->code          = $uniqid;
    
        if ($user->salesmanger == 1 || $user->teamleader == 1) {
            $activity->manger_id = $user->id;
        }
    
        // تحديث بيانات Lead
        $lead->sales_report      = $report;
        $lead->communication     = 1;
        $lead->follow_date       = $follow_date;
        $lead->follow_time       = $follow_time;
        $lead->action_time       = $time;
        $lead->checkup_activity  = $today;
        $lead->visitactive       = null;
        $lead->details          .= ' / ' . $today . ' ' . $report;
    
        if (empty($lead->first_communication)) {
            $lead->first_communication = $user_id;
        }
    
        if ($status_id != $lead->status) {
            $lead->status_date = $today;
        }
    
        $lead->status = $status_id;
    
        if ($substatus_id != $lead->substatus) {
            $lead->substatus_date = $today;
        }
    
        $lead->substatus = $substatus_id;
    
        // زيارة تلقائية إذا مطلوب
        if ((int)$status->visit === 1 && (int)$main->createvisitauto === 1) {
            $visit = new Visit();
            $visit->date         = $today;
            $visit->lead_id      = $lead->id;
            $visit->user_id      = $user_id;
            $visit->lead_date    = $lead->date;
            $visit->code         = $uniqid;
            $visit->details      = $report;
            $visit->dateaction   = $today;
            $visit->timeaction   = $time;
            $visit->from_time    = $time;
            $visit->to_time      = $time;
    
            if (!$visit->save()) {
                echo json_encode([
                    'status' => false,
                    'message' => 'Visit creation failed',
                    'errors' => $visit->getErrors()
                ]);
                Yii::app()->end();
            }
        }
    
        // التأهيل
        if ((int)$status->qualified === 1) {
            $lead->qualified = 1;
            if (empty($lead->first_classification)) {
                $lead->first_classification = 1;
                $lead->first_classification_user = $user_id;
            }
        }
    
        if ((int)$status->nonqualified === 1) {
            $lead->nonqualified = 1;
            if (empty($lead->first_classification)) {
                $lead->first_classification = 2;
                $lead->first_classification_user = $user_id;
            }
        }
    
        // معالجة answer, callback, expvisit
        foreach ([$status, $substatus] as $source) {
            if ($source) {
                if ($source->answer == 1) { $lead->answer = 1; $activity->answer = 1; }
                if ($source->answer == 2) { $lead->answer = 2; $activity->answer = 2; }
                if ($source->callback == 1) { $lead->callback = 1; $activity->callback = 1; }
                if ($source->expvisit == 1) { $lead->expvisit = 1; $activity->expvisit = 1; }
            }
        }
    
        // إغلاق أو عميل
        if ((int)$status->close === 1 || (int)$status->client === 1) {
            $lead->close         = 1;
            $lead->reopen        = null;
            $lead->communication = 1;
            $lead->visitactive   = null;
            $lead->close_date    = $today;
            $activity->report    = 'Closed In ' . $today . ' - ' . $report;
            $activity->close     = 1;
    
            if (empty($lead->first_communication)) {
                $lead->first_communication = $user_id;
            }
        }
    
        // بيانات إضافية للـ Activity
        $activity->name       = $lead->title;
        $activity->tel        = $lead->tel;
        $activity->coldcall   = $lead->coldcall;
        $activity->indirect   = $lead->indirect;
        $activity->lead_date  = $lead->date;
        $activity->leads_id   = $lead->id;
        $activity->secert     = $rnd . $user_id;
    
        // حفظ
        if ($activity->save() && $lead->save()) {
            $activity->secert = $activity->id;
            $activity->save(false);
    
            echo json_encode([
                'status' => true,
                'message' => 'Activity saved and lead updated',
                'activity_id' => $activity->id
            ]);
        } else {
            echo json_encode([
                'status' => false,
                'message' => 'Failed to save',
                'activity_errors' => $activity->getErrors(),
                'lead_errors' => $lead->getErrors()
            ]);
        }
    
        Yii::app()->end();
    }
    
    public function actionInsertLeadCloseByUrl() {
        header('Content-Type: application/json');
    
        // التوقيت المحلي
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
    
        $today = date("Y-m-d");
        $time  = date("H:i:s");
    
        // التحقق من التوكن
        $token = $_GET['token'] ?? null;
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode(['status' => false, 'message' => 'Unauthorized']);
            Yii::app()->end();
        }
    
        // استقبال البيانات من GET
        $secert    = $_GET['secert']    ?? null;
        $code      = $_GET['code']      ?? uniqid();
        $status_id = $_GET['status']    ?? null;
        $report    = $_GET['report']    ?? null;
        $substatus = $_GET['substatus'] ?? null;
        $user_id   = $_GET['user_id']   ?? Yii::app()->user->id;
    
        $user = User::model()->findByPk($user_id);
        $lead = Leads::model()->findByAttributes(['secert' => $secert]);
    
        if (!$lead || !$status_id || !$report) {
            echo json_encode(['status' => false, 'message' => 'Missing required fields']);
            Yii::app()->end();
        }
    
        // تحديث بيانات الـ Lead
        $lead->close         = 1;
        $lead->reopen        = null;
        $lead->communication = 1;
        if (empty($lead->first_communication)) {
            $lead->first_communication = $user_id;
        }
        $lead->close_date = $today;
        $lead->status     = $status_id;
    
        $status = Statues::model()->findByPk($status_id);
        if ($status) {
            if ($status->qualified == 1) {
                $lead->qualified = 1;
                if (empty($lead->first_classification)) {
                    $lead->first_classification = 1;
                    $lead->first_classification_user = $user_id;
                }
            }
            if ($status->nonqualified == 1) {
                $lead->nonqualified = 1;
                if (empty($lead->first_classification)) {
                    $lead->first_classification = 2;
                    $lead->first_classification_user = $user_id;
                }
            }
        }
    
        // حفظ الـ Substatus
        $lead->othersubstatus = '';
        if (is_array($substatus)) {
            foreach ($substatus as $s) {
                $lead->othersubstatus .= ',' . $s;
            }
            $lead->substatus = array_shift($substatus);
        } else {
            $lead->substatus = $substatus;
        }
    
        // تحميل الـ Substatus
        $substatus_model = Substatus::model()->findByPk($lead->substatus);
        if ($substatus_model) {
            if ($substatus_model->answer == 1) $lead->answer = 1;
            if ($substatus_model->answer == 2) $lead->answer = 2;
            if ($substatus_model->expvisit == 1) $lead->expvisit = 1;
            if ($substatus_model->callback == 1) $lead->callback = 1;
        }
    
        if ($user->salesmanger == 1 || $user->teamleader == 1) {
            $lead->manger_id = $user_id;
        }
    
        $lead->sales_report = $report;
        $lead->save();
    
        // إغلاق جميع الأنشطة السابقة
        $criteria = new CDbCriteria;
        $criteria->condition = "close IS NULL OR report IS NULL";
        $criteria->addCondition('leads_id=' . $lead->id);
        $activities = Activities::model()->findAll($criteria);
    
        foreach ($activities as $act) {
            $act->close  = 1;
            $act->report = 'Closed In ' . $today . ' - ' . $report;
            $act->save();
        }
    
        // إنشاء Activity جديدة
        $activity = new Activities();
        $activity->user_id     = $user_id;
        $activity->manger_id   = $user_id;
        $activity->leads_id    = $lead->id;
        $activity->lead_date   = $lead->date;
        $activity->date        = $today;
        $activity->time        = $time;
        $activity->details     = $report;
        $activity->code        = $code;
        $activity->report      = 'Closed In ' . $today . ' - ' . $report;
        $activity->follow_date = $today;
        $activity->status      = $status_id;
        $activity->substatus   = $lead->substatus;
        $activity->type        = 1;
        $activity->close       = 1;
    
        if ($substatus_model) {
            if ($substatus_model->answer == 1) $activity->answer = 1;
            if ($substatus_model->answer == 2) $activity->answer = 2;
            if ($substatus_model->expvisit == 1) $activity->expvisit = 1;
            if ($substatus_model->callback == 1) $activity->callback = 1;
        }
    
        if ($activity->save()) {
            $activity->secert     = $activity->id;
            $activity->name       = $lead->title;
            $activity->tel        = $lead->tel;
            $activity->coldcall   = $lead->coldcall;
            $activity->indirect   = $lead->indirect;
            $activity->save();
    
            $lead->follow_date      = $today;
            $lead->checkup_activity = $today;
            $lead->save();
        }
    
        // تحديث Best Sales
        $best = Bestsales::model()->findByAttributes(['user_sales' => $user_id, 'date' => $today]);
        if ($best) {
            $best->actnum += 1;
            $best->save();
        } else {
            $best = new Bestsales();
            $best->user_sales = $user_id;
            $best->date       = $today;
            $best->actnum     = 1;
            $best->save();
        }
    
        echo json_encode([
            'status' => true,
            'message' => 'Lead closed and activity created successfully',
            'activity_id' => $activity->id
        ]);
        Yii::app()->end();
    }
    
    public function actionInsertLocationByUrl() {
        header('Content-Type: application/json');
    
        // إعداد المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
    
        // التحقق من التوكن
        $token = $_GET['token'] ?? null;
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode(['status' => false, 'message' => 'Invalid token']);
            Yii::app()->end();
        }
    
        // جلب المتغيرات
        $user_id        = $_GET['user_id']     ?? null;
        $company_id     = $_GET['com']         ?? null;
        $close          = $_GET['close']       ?? 0;
        $latitude       = $_GET['latitude']    ?? null;
        $longitude      = $_GET['longitude']   ?? null;
        $description    = $_GET['description'] ?? "Start Meeting";
        $orientation_id = $_GET['or']          ?? null;
    
        $date = date("Y-m-d");
        $time = date("H:i:s");
    
        // التحقق من القيم الأساسية
        if (!$user_id || !$company_id || $latitude === null || $longitude === null) {
            echo json_encode(['status' => false, 'message' => 'Missing required parameters']);
            Yii::app()->end();
        }
    
        // ✅ حالة بدء الاجتماع
        if ($close != 1) {
            $or = new Orientation();
            $or->date = $date;
            $or->time = $time;
            $or->user_id = $user_id;
            $or->company_id = $company_id;
            $or->meeting_description = "Start Meeting";
    
            if ($or->save()) {
                $location = new OrientationLocations();
                $location->user_id = $user_id;
                $location->company_id = $company_id;
                $location->orientation_id = $or->id;
                $location->type_id = 1;
                $location->date = $date;
                $location->time = $time;
                $location->latitude = $latitude;
                $location->longitude = $longitude;
                $location->meeting_description = "Start Meeting";
    
                if ($location->save()) {
                    echo json_encode([
                        'status' => true,
                        'message' => 'Orientation started successfully',
                        'orientation_id' => $or->id
                    ]);
                } else {
                    $or->delete(); // rollback
                    echo json_encode([
                        'status' => false,
                        'message' => 'Failed to save location',
                        'errors' => $location->getErrors()
                    ]);
                }
            } else {
                echo json_encode([
                    'status' => false,
                    'message' => 'Failed to create orientation',
                    'errors' => $or->getErrors()
                ]);
            }
        }
    
        // ✅ حالة إغلاق الاجتماع
        else {
            if (!$orientation_id) {
                echo json_encode(['status' => false, 'message' => 'Missing orientation ID']);
                Yii::app()->end();
            }
    
            $or = Orientation::model()->findByPk($orientation_id);
            if (!$or) {
                echo json_encode(['status' => false, 'message' => 'Orientation not found']);
                Yii::app()->end();
            }
    
            $or->close = 1;
            $or->meeting_description = $description;
    
            if ($or->save()) {
                $location = new OrientationLocations();
                $location->user_id = $user_id;
                $location->company_id = $company_id;
                $location->orientation_id = $or->id;
                $location->type_id = 2;
                $location->date = $date;
                $location->time = $time;
                $location->latitude = $latitude;
                $location->longitude = $longitude;
                $location->meeting_description = $description;
    
                if ($location->save()) {
                    echo json_encode([
                        'status' => true,
                        'message' => 'Orientation closed successfully'
                    ]);
                } else {
                    $or->delete(); // rollback
                    echo json_encode([
                        'status' => false,
                        'message' => 'Failed to save closing location',
                        'errors' => $location->getErrors()
                    ]);
                }
            } else {
                echo json_encode([
                    'status' => false,
                    'message' => 'Failed to close orientation',
                    'errors' => $or->getErrors()
                ]);
            }
        }
    
        Yii::app()->end();
    }
    
    public function actionInsertVisitByUrl() {
        header('Content-Type: application/json');
    
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
    
        $token = $_GET['token'] ?? null;
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode(['status' => false, 'message' => 'Invalid token']);
            Yii::app()->end();
        }
    
        $secert      = $_GET['secert'] ?? null;
        $uniqid      = $_GET['code'] ?? uniqid();
        $date        = $_GET['date'] ?? date("Y-m-d");
        $details     = $_GET['details'] ?? null;
        $from_time   = $_GET['from_time'] ?? null;
        $to_time     = $_GET['to_time'] ?? null;
        $user_id     = $_GET['user'] ?? Yii::app()->user->id;
    
        if (!$secert || !$details || !$from_time || !$to_time) {
            echo json_encode(['status' => false, 'message' => 'Missing required parameters']);
            Yii::app()->end();
        }
    
        $today = date("Y-m-d");
        $time  = date("H:i:s");
    
        $lead = Leads::model()->findByAttributes(['secert' => $secert]);
        if (!$lead) {
            echo json_encode(['status' => false, 'message' => 'Lead not found']);
            Yii::app()->end();
        }
    
        $lead->visit         = 1;
        $lead->visitactive   = 1;
        $lead->pending_visit = $_GET['pending_visit'] ?? null;
        $lead->save();
    
        $visit = new Visit();
        if ($lead->coldcall == 1) $visit->coldcall = 1;
        if ($lead->coldcall == 3) $visit->coldcall = 3;
    
        $visit->date          = $date;
        $visit->lead_id       = $lead->id;
        $visit->lead_date     = $lead->date;
        $visit->marketing_id  = $lead->user_id;
        $visit->code          = $uniqid;
        $visit->details       = $details;
        $visit->dateaction    = $today;
        $visit->timeaction    = $time;
        $visit->user_id       = $user_id;
        $visit->from_time     = $from_time;
        $visit->to_time       = $to_time;
    
        if (!empty($from_time) && !empty($to_time)) {
            $visit->hour = strtotime($to_time) - strtotime($from_time);
        }
    
        $lastVisit = Visit::model()->find([
            'condition' => 'lead_id = :lid',
            'params' => [':lid' => $lead->id],
            'order' => 'id DESC',
            'limit' => 1
        ]);
        if ($lastVisit) {
            $visit->novisit = $lastVisit->novisit + 1;
        }
    
        $visit->downpayment   = $_GET['downpayment']   ?? null;
        $visit->months        = $_GET['months']        ?? null;
        $visit->amount        = $_GET['amount']        ?? null;
        $visit->pending_visit = $_GET['pending_visit'] ?? null;
    
        $visit->unit_ids   = isset($_GET['unit'])      ? implode(",", (array)$_GET['unit'])      : null;
        $visit->attended   = isset($_GET['sales'])     ? implode(",", (array)$_GET['sales'])     : null;
        $visit->color_ids  = isset($_GET['colors'])    ? implode(",", (array)$_GET['colors'])    : null;
        $visit->cash       = isset($_GET['cash'])      ? implode(",", (array)$_GET['cash'])      : null;
        $visit->cash_date  = isset($_GET['cash_date']) ? implode(",", (array)$_GET['cash_date']) : null;
    
        if (isset($_GET['confirmsales'])) {
            $visit->confirmsales = 1;
            $visit->type         = $_GET['type'] ?? 1;
        }
    
        if ($visit->save()) {
            // SMS Notification only
            if (!empty($main->visitmessage)) {
                $agent = User::model()->findByPk($lead->user_sales);
                $message = "{$main->visitmessage}\nللتواصل:\n{$agent->fname} {$agent->lname}\n{$agent->mobile}";
                $encodedMessage = rawurlencode($message);
                $url = "https://smsmisr.com/api/SMS/?environment=1&username={$main->username}&password={$main->password}&language=2&sender={$main->sender}&mobile={$lead->international_code}{$lead->tel}&message={$encodedMessage}";
    
                $curl = curl_init($url);
                curl_setopt_array($curl, [
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_HTTPHEADER => ["Content-Type: application/json"],
                ]);
                curl_exec($curl);
                curl_close($curl);
            }
    
            echo json_encode(['status' => true, 'message' => 'Visit created successfully']);
        } else {
            echo json_encode([
                'status' => false,
                'message' => 'Visit creation failed',
                'errors' => $visit->getErrors()
            ]);
        }
    
        Yii::app()->end();
    }

    public function actionGetAllplatforms() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token = $_GET['token'] ?? null;
        $id    = $_GET['id']    ?? null;
    
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 500); // أقصى حد 500
    
        $criteria = new CDbCriteria();
    
        // فلترة حسب المستخدم
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
        // حساب عدد السجلات
        $totalCount = Platform::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allPlatforms = Platform::model()->findAll($criteria);
        $result = [];
        foreach ($allPlatforms as $platform) {
            $result[] = $platform->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionGetAllcampaigns() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token = $_GET['token'] ?? null;
        $id    = $_GET['id']    ?? null;
    
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 100;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 500); // أقصى حد 500
    
        $criteria = new CDbCriteria();
    
        // فلترة حسب ID الحملة (اختياري)
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
        // حساب عدد السجلات
        $totalCount = Campaign::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allCampaigns = Campaign::model()->findAll($criteria);
        $result = [];
        foreach ($allCampaigns as $campaign) {
            $result[] = $campaign->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionCloseLeadByApi() {
        header('Content-Type: application/json');
    
        if (!Yii::app()->request->isGetRequest) {
            echo json_encode(['status' => false, 'message' => 'Invalid request method']);
            Yii::app()->end();
        }
    
        // بيانات من اللينك
        $token     = $_GET['token']    ?? null;
        $secert    = $_GET['secert']   ?? null;
        $status    = $_GET['status']   ?? null;
        $substatus = $_GET['substatus'] ?? null; // بصيغة "8,12"
        $report    = $_GET['report']   ?? '';
    
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode(['status' => false, 'message' => 'Unauthorized']);
            Yii::app()->end();
        }
    
        $userId = Yii::app()->user->id;
        $lead = Leads::model()->findByAttributes(['secert' => $secert]);
        if (!$lead) {
            echo json_encode(['status' => false, 'message' => 'Lead not found']);
            Yii::app()->end();
        }
    
        // إعدادات الوقت
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?? 'Africa/Cairo');
        $today = date("Y-m-d");
        $time = date("H:i:s");
    
        // تحديث lead
        $lead->close = 1;
        $lead->reopen = null;
        $lead->communication = 1;
        if (empty($lead->first_communication)) {
            $lead->first_communication = $userId;
        }
        $lead->close_date = $today;
    
        $qualifiedtest = Statues::model()->findByPk($status);
        if ($qualifiedtest) {
            if ($qualifiedtest->qualified == 1) {
                $lead->qualified = 1;
                if (empty($lead->first_classification)) {
                    $lead->first_classification = 1;
                    $lead->first_classification_user = $userId;
                }
            }
            if ($qualifiedtest->nonqualified == 1) {
                $lead->nonqualified = 1;
                if (empty($lead->first_classification)) {
                    $lead->first_classification = 2;
                    $lead->first_classification_user = $userId;
                }
            }
        }
    
        $lead->status = $status;
    
        // substatus معالجة
        $subArr = explode(',', $substatus);
        $lead->othersubstatus = implode(',', $subArr);
        $lead->substatus = !empty($subArr) ? $subArr[0] : null;
    
        $substatusModel = Substatus::model()->findByPk($lead->substatus);
        if ($substatusModel) {
            if ($substatusModel->answer == 1) $lead->answer = 1;
            if ($substatusModel->answer == 2) $lead->answer = 2;
            if ($substatusModel->expvisit == 1) $lead->expvisit = 1;
            if ($substatusModel->callback == 1) $lead->callback = 1;
        }
    
        $lead->sales_report = $report;
        $lead->save();
    
        // إغلاق الأنشطة القديمة
        $criteria = new CDbCriteria;
        $criteria->condition = "close IS NULL OR report IS NULL";
        $criteria->addCondition('leads_id=' . $lead->id);
        $activities = Activities::model()->findAll($criteria);
        foreach ($activities as $activity) {
            $activity->close = 1;
            $activity->report = 'Closed In ' . $today . ' - ' . $report;
            $activity->save();
        }
    
        // إنشاء Activity جديدة
        $newActivity = new Activities();
        $newActivity->user_id = $userId;
        $newActivity->manger_id = $userId;
        $newActivity->leads_id = $lead->id;
        $newActivity->lead_date = $lead->date;
        $newActivity->date = $today;
        $newActivity->time = $time;
        $newActivity->details = $report;
        $newActivity->report = 'Closed In ' . $today . ' - ' . $report;
        $newActivity->follow_date = $today;
        $newActivity->status = $status;
        $newActivity->substatus = $lead->substatus;
    
        if ($substatusModel) {
            if ($substatusModel->answer == 1) $newActivity->answer = 1;
            if ($substatusModel->answer == 2) $newActivity->answer = 2;
            if ($substatusModel->expvisit == 1) $newActivity->expvisit = 1;
            if ($substatusModel->callback == 1) $newActivity->callback = 1;
        }
    
        $newActivity->type = 1;
        $newActivity->close = 1;
        $newActivity->save();
    
        // تحديث بيانات lead النهائية
        $lead->follow_date = $newActivity->follow_date;
        $lead->checkup_activity = $today;
        $lead->save();
    
        $newActivity->secert = $newActivity->id;
        $newActivity->name = $lead->title;
        $newActivity->tel = $lead->tel;
        $newActivity->coldcall = $lead->coldcall;
        $newActivity->indirect = $lead->indirect;
        $newActivity->save();
    
        // تسجيل bestsales
        $best = Bestsales::model()->findByAttributes(['user_sales' => $userId, 'date' => $today]);
        if ($best) {
            $best->actnum += 1;
            $best->save();
        } else {
            $best = new Bestsales();
            $best->user_sales = $userId;
            $best->date = $today;
            $best->actnum = 1;
            $best->save();
        }
    
        echo json_encode(['status' => true, 'message' => 'Lead closed successfully via GET URL']);
        Yii::app()->end();
    }
    
    //Business Developing Module APIs
    public function actionGetAllLeadsex() {
        $main = Mainsettings::model()->findByPk(1);
        date_default_timezone_set($main->countrytimezone ?: 'Africa/Cairo');
    
        $token = $_GET['token'] ?? null;
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo CJSON::encode(['status' => false, 'message' => 'Unauthorized or missing token']);
            Yii::app()->end();
        }
    
        $criteria = new CDbCriteria();
    
        // All filters
        $filters = [
            'id', 'phone', 'user', 'communication', 'transfer', 'close', 'type',
            'followup', 'delay', 'startdate', 'enddate',
            'startfollowdate', 'endfollowdate',
            'starttransferdate', 'endtransferdate',
            'campaign_id', 'platform_id', 'platformchild_id', 'status', 'substatus',
            'user_sales', 'fresh_sales', 'unit_type', 'property_type', 'client_type'
        ];
    
        foreach ($filters as $key) {
            $$key = $_GET[$key] ?? null;
        }
    
        // ID & phone
        if ($id !== null) $criteria->compare('id', $id);
        if ($phone !== null) {
            if (substr($phone, 0, 1) === '0') $phone = substr($phone, 1);
            $criteria->compare('tel', $phone);
        }
    
        if ($user !== null) $criteria->compare('user_sales', $user);
    
        // Date filter: lead date
        if ($startdate && $enddate) {
            $startObj = DateTime::createFromFormat('d-m-Y', $startdate) ?: DateTime::createFromFormat('Y-m-d', $startdate);
            $endObj = DateTime::createFromFormat('d-m-Y', $enddate) ?: DateTime::createFromFormat('Y-m-d', $enddate);
            if ($startObj && $endObj) {
                $criteria->addBetweenCondition('date', $startObj->format('Y-m-d'), $endObj->format('Y-m-d'));
            }
        }
    
        // Date filter: follow_date
        if ($startfollowdate && $endfollowdate) {
            $startObj = DateTime::createFromFormat('d-m-Y', $startfollowdate) ?: DateTime::createFromFormat('Y-m-d', $startfollowdate);
            $endObj = DateTime::createFromFormat('d-m-Y', $endfollowdate) ?: DateTime::createFromFormat('Y-m-d', $endfollowdate);
            if ($startObj && $endObj) {
                $criteria->addBetweenCondition('follow_date', $startObj->format('Y-m-d'), $endObj->format('Y-m-d'));
            }
        }
    
        // Date filter: transferdate
        if ($starttransferdate && $endtransferdate) {
            $startObj = DateTime::createFromFormat('d-m-Y', $starttransferdate) ?: DateTime::createFromFormat('Y-m-d', $starttransferdate);
            $endObj = DateTime::createFromFormat('d-m-Y', $endtransferdate) ?: DateTime::createFromFormat('Y-m-d', $endtransferdate);
            if ($startObj && $endObj) {
                $criteria->addBetweenCondition('transferdate', $startObj->format('Y-m-d'), $endObj->format('Y-m-d'));
            }
        }
    
        // followup = today
        if ($followup !== null) {
            $today = date('Y-m-d');
            $criteria->addBetweenCondition('follow_date', $today, $today);
        }
    
        // delay = before yesterday
        if ($delay !== null) {
            $yesterday = date('Y-m-d', strtotime('-1 day'));
            $criteria->addCondition('follow_date <= :yesterday');
            $criteria->params[':yesterday'] = $yesterday;
        }
    
        // other conditions
        if ($communication !== null) {
            $criteria->addCondition((string)$communication === '1' ? 'communication = 1' : 'communication IS NULL');
        }
    
        if ($transfer !== null) {
            $criteria->addCondition((string)$transfer === '1' ? 'transfer = 1' : 'transfer IS NULL');
        }
    
        if ($close !== null) {
            $criteria->addCondition((string)$close === '1' ? 'close = 1' : 'close IS NULL');
        }
    
        // type logic
        if ($type !== null) {
            switch ((string)$type) {
                case '1': // fresh
                    $criteria->addCondition('coldcall IS NULL');
                    $criteria->addCondition('indirect IS NULL');
                    break;
                case '2': // cold
                    $criteria->addCondition('coldcall IS NOT NULL');
                    $criteria->addCondition('indirect IS NULL');
                    break;
                case '3': // indirect
                    $criteria->addCondition('indirect IS NOT NULL');
                    break;
            }
        }
    
        // other filters
        if ($campaign_id !== null)        $criteria->compare('campaign_id', $campaign_id);
        if ($platform_id !== null)        $criteria->compare('platform_id', $platform_id);
        if ($platformchild_id !== null)  $criteria->compare('platformchild_id', $platformchild_id);
        if ($status !== null)            $criteria->compare('status', $status);
        if ($substatus !== null)         $criteria->compare('substatus', $substatus);
        if ($fresh_sales !== null)       $criteria->compare('fresh_sales', $fresh_sales);
        if ($unit_type !== null)         $criteria->compare('unit_type', $unit_type);
        if ($property_type !== null)     $criteria->compare('property_type', $property_type);
        if ($client_type !== null)       $criteria->compare('client_type', $client_type);
    
        // pagination
        $limit = min((int)($_GET['limit'] ?? 100), 50000000);
        $offset = (int)($_GET['offset'] ?? 0);
    
        $totalCount = Leads::model()->count($criteria);
        $criteria->limit = $limit;
        $criteria->offset = $offset;
    
        $leads = Leads::model()->findAll($criteria);
        $result = array_map(function ($lead) {
            return $lead->attributes;
        }, $leads);
    
        echo CJSON::encode([
            'status'     => true,
            'totalCount' => $totalCount,
            'limit'      => $limit,
            'offset'     => $offset,
            'returned'   => count($result),
            'pages'      => $totalCount > 0 ? ceil($totalCount / $limit) : 0,
            'data'       => $result,
        ]);
    
        Yii::app()->end();
    }
    
    public function actionGetAllcampaignsex() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token = $_GET['token'] ?? null;
        $id    = $_GET['id']    ?? null;
    
        header('Content-Type: application/json');
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 1000;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 5000000); // أقصى حد 500
    
        $criteria = new CDbCriteria();
    
        // فلترة حسب ID الحملة (اختياري)
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
        // حساب عدد السجلات
        $totalCount = Campaign::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allCampaigns = Campaign::model()->findAll($criteria);
        $result = [];
        foreach ($allCampaigns as $campaign) {
            $result[] = $campaign->attributes;
        }
    
        // إعداد الرد النهائي
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    
    public function actionGetAllUsersex() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // جلب المتغيرات من GET
        $token = $_GET['token'] ?? null;
        $id    = $_GET['id']    ?? null;
    
        header('Content-Type: application/json');
    
        // التحقق من التوكن
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 1000;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 50000000); // الحد الأقصى 500
    
        $criteria = new CDbCriteria();
    
        // فلترة حسب id
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
        // حساب العدد الكلي
        $totalCount = User::model()->count($criteria);
    
        // تطبيق limit و offset
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        // جلب البيانات
        $allUsers = User::model()->findAll($criteria);
        $result = [];
        foreach ($allUsers as $user) {
            $result[] = $user->attributes;
        }
    
        // إعداد الرد
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        $response = [
            'status'     => true,
            'totalCount' => (int)$totalCount,
            'limit'      => (int)$limit,
            'offset'     => (int)$offset,
            'returned'   => count($result),
            'pages'      => $pages,
            'data'       => $result,
        ];
    
        echo CJSON::encode($response);
        Yii::app()->end();
    }

    public function actionGetAlltypesex() {
        // ضبط المنطقة الزمنية
        $main = Mainsettings::model()->findByPk(1);
        if ($main && $main->countrytimezone !== null) {
            date_default_timezone_set($main->countrytimezone);
        } else {
            date_default_timezone_set('Africa/Cairo');
        }
    
        // التوكن والأي دي
        $token = $_GET['token'] ?? null;
        $id    = $_GET['id']    ?? null;
    
        header('Content-Type: application/json');
    
        if ($token !== 'ZeZbu0s5CkBDaEm8ygo1rOBDuYQGHYT0szd33txcEFutJRRI1Bjmx4WU2KbVVUl3') {
            echo json_encode([
                'status'  => false,
                'message' => 'Unauthorized or missing token',
            ]);
            Yii::app()->end();
        }
    
        // قراءة limit و offset
        $limit  = isset($_GET['limit'])  ? (int)$_GET['limit']  : 1000;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        $limit = min($limit, 5000000); // أقصى حد
    
        $criteria = new CDbCriteria();
    
        // فلترة اختيارية بـ id
        if ($id !== null) {
            $criteria->compare('id', $id);
        }
    
        // ممكن تضيف فلترة بالعنوان أو parent_id لو حبيت هنا
    
        $totalCount = TypeBuliding::model()->count($criteria);
    
        $criteria->limit  = $limit;
        $criteria->offset = $offset;
    
        $allTypes = TypeBuliding::model()->findAll($criteria);
        $result = [];
    
        foreach ($allTypes as $type) {
            $item = $type->attributes;
    
            // جلب اسم الأب لو موجود
            if (!empty($type->parent_id)) {
                $parent = TypeBuliding::model()->findByPk($type->parent_id);
                $item['parent_title'] = $parent ? $parent->title : null;
            } else {
                $item['parent_title'] = null;
            }
    
            $result[] = $item;
        }
    
        $pages = ($totalCount > 0) ? (int) ceil($totalCount / $limit) : 0;
    
        echo CJSON::encode([
            'status'      => true,
            'totalCount'  => (int)$totalCount,
            'limit'       => (int)$limit,
            'offset'      => (int)$offset,
            'returned'    => count($result),
            'pages'       => $pages,
            'data'        => $result,
        ]);
    
        Yii::app()->end();
    }
}
