<?php

class Building extends CActiveRecord
{

	public function tableName()
	{
		return 'building';
	}

	public function rules()
	{
		return array(
			array('user_id, projects_id,  elevator, floor_start, floor_end, number_units, tree_id, number_roles, sold_units, reserved_units, remaning_units, status, hidden, toilets, internet, conditioning, extinguishingnetwork, firealarm, securitycameras, securityguards, additionalpositions, restaurants, bankingservices,bulding_number', 'numerical', 'integerOnly'=>true),
			array('size_buliding, number_area, size_buliding_net ,percentage_construction,sort', 'numerical'),
			array('title,  neighboring_area, area_area, latiude, longitude, secert, activity,upload', 'length', 'max'=>255),
			array('delivery_date, details', 'safe'),
			array('id, title, user_id, date, time, projects_id, size_buliding, size_buliding_net, elevator, tree_id, floor_start, floor_end, number_area, neighboring_area, area_area, delivery_date, number_units, number_roles, sold_units, reserved_units,sort, remaning_units, details, latiude, longitude, status, secert, hidden, activity, toilets, internet, conditioning, extinguishingnetwork, firealarm, securitycameras, securityguards, additionalpositions, restaurants, bankingservices', 'safe', 'on'=>'search'),
		);
	}

	public function relations()
	{
		return array(
            'neighbor'    => array(self::BELONGS_TO, 'Area',    'neighboring_area'),
            'project'    => array(self::BELONGS_TO, 'Projects',    'projects_id'),
            'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
            'floorstart'    => array(self::BELONGS_TO, 'Floor',    'floor_start'),	
            'floorend'    => array(self::BELONGS_TO, 'Floor',    'floor_end'),
            'xactivity'    => array(self::BELONGS_TO, 'TypeBuliding',    'activity'),
		);
	}

	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => 'Title',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'projects_id' => 'Projects',
			'size_buliding' => 'Size Buliding',
            'percentage_construction' => 'Percentage Construction',
			'size_buliding_net' => 'Size Buliding Net',
			'elevator' => 'Elevator',
			'floor_start' => 'Floor Start',
			'floor_end' => 'Floor End',
			'number_area' => 'Plot. No.',
			'neighboring_area' => 'Neighboring Area',
			'area_area' => 'Zone',
			'delivery_date' => 'Delivery Date',
			'number_units' => 'Number Units',
			'number_roles' => 'Number Floors',
			'sold_units' => 'Sold Units',
			'reserved_units' => 'Reserved Units',
			'remaning_units' => 'Remaning Units',
			'details' => 'Details',
			'latiude' => 'Latiude',
			'longitude' => 'Longitude',
			'status' => 'Status',
			'secert' => 'Secert',
			'hidden' => 'Hidden',
			'activity' => 'Activity',
			'sort' => 'Sort',
		);
	}

	public function search()
    {
        $criteria = new CDbCriteria;
    
        $criteria->addSearchCondition('hidden', 1, false);
        if (!empty($_REQUEST['project'])) {
            $criteria->addSearchCondition('projects_id', $_REQUEST['project'], false, "AND");
        }
        $criteria->compare('title', $this->title);
        $criteria->compare('date', $this->date);
        $criteria->compare('time', $this->time);
        $criteria->compare('projects_id', $this->projects_id);
        $criteria->compare('activity', $this->activity);
        $criteria->compare('id', $this->id);

        $allBuildings = Building::model()->findAll($criteria);
    
        usort($allBuildings, function($a, $b) {
            return strnatcmp($a->title, $b->title);
        });
    
        $dataProvider = new CArrayDataProvider($allBuildings, array(
            'pagination' => array('pageSize' => Yii::app()->user->getState('pageSize', Yii::app()->params['defaultPageSize'])),
        ));
    
        return $dataProvider;
    }

	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
