<?php

/**
 * This is the model class for table "exportxlxsleads".
 *
 * The followings are the available columns in table 'exportxlxsleads':
 * @property integer $id
 * @property integer $exportxlx_id
 * @property integer $leads_id
 * @property string $user_sales
 * @property string $user_id
 * @property string $fresh_sales
 * @property string $title
 * @property string $tel
 * @property string $tel2
 * @property string $email
 * @property string $strategy
 * @property string $campaign
 * @property string $platform
 * @property string $platformchild
 * @property string $statues
 * @property string $substatues
 * @property string $notes
 * @property string $details
 * @property string $date
 * @property string $duplicatedate
 * @property string $followdate
 * @property string $visit
 * @property string $international_code
 */
class Exportxlxsleads extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'exportxlxsleads';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('exportxlx_id, leads_id', 'required'),
			array('exportxlx_id, leads_id', 'numerical', 'integerOnly'=>true),
			array('user_sales, user_id, fresh_sales, title, tel, tel2, email, strategy, campaign, platform, platformchild, statues, substatues,  date, duplicatedate, followdate, visit, international_code,project,classification,lastclassification', 'length', 'max'=>255),
			array('details', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, exportxlx_id, leads_id, user_sales, user_id, fresh_sales, title, tel, tel2, email, strategy, campaign, platform, platformchild, statues, substatues, notes, details, date, duplicatedate, followdate, visit, international_code, lastreport,classification,lastclassification', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    
		    
		    		'lead'    => array(self::BELONGS_TO, 'Leads',    'leads_id'),

		    
		    
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'exportxlx_id' => 'Exportxlx',
			'leads_id' => 'Leads',
			'user_sales' => 'User Sales',
			'user_id' => 'User',
			'fresh_sales' => 'Fresh Sales',
			'title' => 'Title',
			'tel' => 'Tel',
			'tel2' => 'Tel2',
			'email' => 'Email',
			'strategy' => 'Strategy',
			'campaign' => 'Campaign',
			'platform' => 'Platform',
			'platformchild' => 'Platformchild',
			'statues' => 'Statues',
			'substatues' => 'Substatues',
			'notes' => 'Notes',
			'details' => 'Details',
			'date' => 'Date',
			'duplicatedate' => 'Duplicatedate',
			'followdate' => 'Followdate',
			'visit' => 'Visit',
			'international_code' => 'International Code',
			'lastreport' => 'Last Report',
			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('exportxlx_id',$this->exportxlx_id);
		$criteria->compare('leads_id',$this->leads_id);
		$criteria->compare('user_sales',$this->user_sales,true);
		$criteria->compare('user_id',$this->user_id,true);
		$criteria->compare('fresh_sales',$this->fresh_sales,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('tel',$this->tel,true);
		$criteria->compare('tel2',$this->tel2,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('strategy',$this->strategy,true);
		$criteria->compare('campaign',$this->campaign,true);
		$criteria->compare('platform',$this->platform,true);
		$criteria->compare('platformchild',$this->platformchild,true);
		$criteria->compare('statues',$this->statues,true);
		$criteria->compare('substatues',$this->substatues,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('duplicatedate',$this->duplicatedate,true);
		$criteria->compare('followdate',$this->followdate,true);
		$criteria->compare('visit',$this->visit,true);
		$criteria->compare('international_code',$this->international_code,true);
		$criteria->compare('lastreport',$this->lastreport,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Exportxlxsleads the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
