<?php

/**
 * This is the model class for table "fi_tree".
 *
 * The followings are the available columns in table 'fi_tree':
 * @property integer $id
 * @property string $title
 * @property string $date
 * @property string $time
 * @property integer $user_id
 * @property integer $code
 * @property integer $tree_id
 * @property string $description
 * @property double $credit_balance_start
 * @property double $credit_balance_till
 * @property integer $main_tree_id
 */
class FiTree extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'fi_tree';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, time, user_id, code, tree_id', 'required'),
			array('user_id, code, tree_id, main_tree_id', 'numerical', 'integerOnly'=>true),
			array('credit_balance_start, credit_balance_till', 'numerical'),
			array('title', 'length', 'max'=>255),
			array('description', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, title, date, time, user_id, code, tree_id, description, credit_balance_start, credit_balance_till, main_tree_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => 'Title',
			'date' => 'Date',
			'time' => 'Time',
			'user_id' => 'User',
			'code' => 'Code',
			'tree_id' => 'Tree',
			'description' => 'Description',
			'credit_balance_start' => 'Credit Balance Start',
			'credit_balance_till' => 'Credit Balance Till',
			'main_tree_id' => 'Main Tree',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('code',$this->code);
		$criteria->compare('tree_id',$this->tree_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('credit_balance_start',$this->credit_balance_start);
		$criteria->compare('credit_balance_till',$this->credit_balance_till);
		$criteria->compare('main_tree_id',$this->main_tree_id);



    // Add filtering based on campaign_id in request_reservation
        //$criteria->condition .= "file IS NOT NULL";

			
      	
        $sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort'); 
        $sort->attributes = array(
            'title'=>array(
                'asc'=>'title ASC',
                'desc'=>'title DESC',
            ),
            'code'=>array(
                'asc'=>'code ASC',
                'desc'=>'code DESC',
            ),
            '*', 
        );

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		     'sort' => $sort,
		));
	}
	
	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FiTree the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
