<?php

/**
 * This is the model class for table "francisreadytoistrub".
 *
 * The followings are the available columns in table 'francisreadytoistrub':
 * @property integer $id
 * @property integer $user_id
 * @property integer $owner_id
 * @property integer $assign_to
 * @property integer $total
 * @property string $date
 * @property string $time
 * @property integer $lead_id
 * @property integer $confirm
 */
class Francisreadytoistrub extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'francisreadytoistrub';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, owner_id, date, time, lead_id', 'required'),
			array('user_id, owner_id, assign_to, total, lead_id, confirm', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, owner_id, assign_to, total, date, time, lead_id, confirm', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'owner_id' => 'Owner',
			'assign_to' => 'Assign To',
			'total' => 'Total',
			'date' => 'Date',
			'time' => 'Time',
			'lead_id' => 'Lead',
			'confirm' => 'Confirm',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('owner_id',$this->owner_id);
		$criteria->compare('assign_to',$this->assign_to);
		$criteria->compare('total',$this->total);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('confirm',$this->confirm);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Francisreadytoistrub the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
