<?php

/**
 * This is the model class for table "hr_attendance_rules".
 *
 * The followings are the available columns in table 'hr_attendance_rules':
 * @property integer $id
 * @property string $date
 * @property string $time
 * @property integer $user_id
 * @property string $title
 * @property string $attendanceminutes
 * @property string $leavingminutes
 * @property string $description
 * @property integer $noofdays
 */
class HrAttendanceRules extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'hr_attendance_rules';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, time, user_id', 'required'),
			array('user_id, noofdays', 'numerical', 'integerOnly'=>true),
			array('title, attendanceminutes,attendanceminutesend, leavingminutes,leavingminutesend,additional,rival,sms,extratime,approve', 'length', 'max'=>255),
			array('description', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, time, user_id, title, attendanceminutes,attendanceminutesend, leavingminutes,leavingminutesend, description, noofdays,additional,rival,sms,extratime,approve', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'time' => 'Time',
			'user_id' => 'User',
			'title' => 'Title',
			'attendanceminutes' => 'Attendanceminutes',
			'leavingminutes' => 'Leavingminutes',
			'description' => 'Description',
			'noofdays' => 'Noofdays',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('attendanceminutes',$this->attendanceminutes,true);
		$criteria->compare('leavingminutes',$this->leavingminutes,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('noofdays',$this->noofdays);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrAttendanceRules the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
