<?php

/**
 * This is the model class for table "installments".
 *
 * The followings are the available columns in table 'installments':
 * @property integer $id
 * @property integer $lead_id
 * @property integer $user_id
 * @property integer $reservation_id
 * @property integer $unit_id
 * @property string $date
 * @property string $payment_date
 * @property integer $amount
 * @property integer $level
 */
class Installments extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'installments';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
		  array('numberinst','unique'),

			array('lead_id, user_id, reservation_id, unit_id, date, payment_date, amount', 'required'),
			array('lead_id, user_id, reservation_id, unit_id, level,confirm,split,cash,bank,bankcheck,settlement,dailyrestrictions_id,building_tree,banker_id,lastactionby,typeofinstalment,hold,quickpay,confirm_print,visa,confirm_data,numberinst,typeofpayment', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, lead_id, user_id, reservation_id, unit_id, date, payment_date,due_date,datedonepayment,confirm, amount, level,split,cash,bank,bankcheck,settlement,file,dailyrestrictions_id,building_tree,banker_id,lastactionby,typeofinstalment,hold,quickpay,reservation_date,amount,note,drawee_bank,cheque_storage_location,cheque_number,notes,confirm_print,visa,confirm_data,numberinst,typeofpayment', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
'client'    => array(self::BELONGS_TO, 'Leads',    'lead_id'),
'reservation'    => array(self::BELONGS_TO, 'Reservation',    'reservation_id'),
'unit'    => array(self::BELONGS_TO, 'Units',    'unit_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'lead_id' => 'Lead',
			'user_id' => 'User',
			'reservation_id' => 'Reservation',
			'unit_id' => 'Unit',
			'date' => 'Date',
			'payment_date' => 'Payment Date',
			'amount' => 'Amount',
			'level' => 'Level',
			'confirm' => 'Confirm',
			'datedonepayment' => 'Datedonepayment',
			'split' => 'split',
			'reservation_date' => 'Reservation Date',
			'note' => 'note',
			'confirm_print' => 'Confirm Print',
			'confirm_data' => 'Confirm Data',

			


			

			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;
				$criteria->order = 'payment_date DESC';

		$criteria->compare('id',$this->id);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('reservation_id',$this->reservation_id);
		$criteria->compare('unit_id',$this->unit_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('payment_date',$this->payment_date,true);
		$criteria->compare('amount',$this->amount);
		$criteria->compare('level',$this->level);
		$criteria->compare('confirm',$this->confirm);
		$criteria->compare('split',$this->split);
		$criteria->compare('cash',$this->cash);
		$criteria->compare('bank',$this->bank);
		$criteria->compare('file',$this->file);
		$criteria->compare('banker_id',$this->banker_id);
        $criteria->addCondition('confirm_data IS NULL');



		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
	
	
	
		public function searchints()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

            $criteria = new CDbCriteria();

            				$criteria->order = 'payment_date DESC';

            $criteria->addSearchCondition('level', $_REQUEST['yearly'],false, "OR");
            $criteria->addSearchCondition('level', $_REQUEST['monthly'],false, "OR");
            //$criteria->addSearchCondition('confirm', $_REQUEST['confirm'],false, "AND");
            $criteria->addSearchCondition('amount', $_REQUEST['amount'],false, "AND");
            $criteria->addSearchCondition('lead_id', $_REQUEST['lead'],false, "AND");
            $criteria->addSearchCondition('unit_id', $_REQUEST['unit'],false, "AND");
                        $criteria->addSearchCondition('typeofinstalment', $_REQUEST['type'],false, "AND");

            
            
if(isset($_REQUEST['building'])) {
    $build = Building::model()->findByPk($_REQUEST['building']);
    if($build !== null) {
        $criteriabu = new CDbCriteria();
        $criteriabu->compare('building_id', $build->id);
        $units = Units::model()->findAll($criteriabu);
        // Now you have all units related to the building
        $arr=array();
        foreach($units as $unit) {
        $arr[]=$unit->id;
        }
        
        $criteria->addInCondition('unit_id', $arr);

    } 
}
            
            
            //$criteria->addBetweenCondition("date",$_REQUEST['startdate'],$_REQUEST['enddate'],'AND');
            $criteria->addBetweenCondition("payment_date",$_REQUEST['startdate2'],$_REQUEST['enddate2'],'AND');
                        $criteria->addBetweenCondition("due_date",$_REQUEST['startdate3'],$_REQUEST['enddate3'],'AND');
                        		$criteria->addBetweenCondition("reservation_date",$_REQUEST['startdate4'],$_REQUEST['enddate4'],'AND');


            if($_REQUEST['confirm']==1){
            $criteria->addSearchCondition('confirm', $_REQUEST['confirm'],false, "AND");
            }else if($_REQUEST['confirm']==2){
            $criteria->addCondition('confirm IS NULL');
            }else{
            }
            if(sizeOf($_REQUEST['user'])>1){
            $criteria->addInCondition('user_id', $_REQUEST['user'] , "AND");
            }
            
		
		
		$criteria->compare('id',$this->id, true);
		$criteria->compare('hold',$this->hold, true);
		$criteria->compare('drawee_bank',$this->drawee_bank);
		$criteria->compare('cheque_storage_location',$this->cheque_storage_location);
		$criteria->compare('cheque_number',$this->cheque_number);
		$criteria->compare('notes',$this->notes);
		$criteria->compare('payment_date',$this->payment_date);
		$criteria->compare('due_date',$this->due_date);
		$criteria->compare('amount',$this->amount, true);
		
		
		
        $sort = new CSort();
        $criteria->order = Yii::app()->request->getParam('sort'); 
        $sort->attributes = array(
            'id'=>array(
                'asc'=>'id ASC',
                'desc'=>'id DESC',
            ),
            'hold'=>array(
                'asc'=>'hold ASC',
                'desc'=>'hold DESC',
            ),
            'drawee_bank'=>array(
                'asc'=>'drawee_bank ASC',
                'desc'=>'drawee_bank DESC',
            ),
            'cheque_storage_location'=>array(
                'asc'=>'cheque_storage_location ASC',
                'desc'=>'cheque_storage_location DESC',
            ),
            'cheque_number'=>array(
                'asc'=>'cheque_number ASC',
                'desc'=>'cheque_number DESC',
            ),
            'notes'=>array(
                'asc'=>'notes ASC',
                'desc'=>'notes DESC',
            ),
            'payment_date'=>array(
                'asc'=>'payment_date ASC',
                'desc'=>'payment_date DESC',
            ),
            'due_date'=>array(
                'asc'=>'due_date ASC',
                'desc'=>'due_date DESC',
            ),
            'amount'=>array(
                'asc'=>'amount ASC',
                'desc'=>'amount DESC',
            ),
            '*', 
        );

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>$sort,
		
			
		));
	}
	
	
	
	
		public function pending()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;
		$criteria->order = 'payment_date DESC';
        $criteria->addCondition('confirm_data IS NOT NULL');


		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
	
	
	
		public function month()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        
        
        $start = date("Y-m-01");                     // 03.10.01
        $end = date("Y-m-31");                     // 03.10.01
        
        
        $criteria=new CDbCriteria;
        
        $criteria->addBetweenCondition("payment_date",$start,$end,'AND');
        $criteria->addCondition('confirm_data IS NULL');

        


		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Installments the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
