<?php

/**
 * This is the model class for table "inventory".
 *
 * The followings are the available columns in table 'inventory':
 * @property integer $id
 * @property string $date
 * @property integer $parent_id
 * @property integer $user_id
 * @property double $quantity
 * @property integer $material_id
 * @property double $price
 * @property integer $place_id
 * @property integer $building_id
 * @property integer $secret
 * @property integer $confirm
 * @property string $details
 * @property integer $design_id
 * @property integer $supplier_id
 * @property integer $type
 * @property double $relativeweight
 * @property double $selling_price
 * @property double $complition_rate
 */
class Inventory extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'inventory';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, user_id, building_id, secret, details', 'required'),
			array('parent_id, user_id, material_id, place_id, building_id, secret, confirm, design_id, type', 'numerical', 'integerOnly'=>true),
			array('quantity, price, relativeweight, selling_price,building_number, complition_rate,current_quantity', 'numerical'),
			array('details', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, parent_id, user_id, quantity, material_id, price, place_id, building_id, secret, confirm, details, design_id, supplier_id, type, relativeweight, selling_price, complition_rate', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array( 
		    'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
		    'supplier'    => array(self::BELONGS_TO, 'Suppliers',    'supplier_id'),
		    'building'    => array(self::BELONGS_TO, 'Building',    'building_id'), 
		    'design'    => array(self::BELONGS_TO, 'Designmaterials',    'design_id'),
		    'material'    => array(self::BELONGS_TO, 'InventoryTitles',    'material_id'),
		    'place'    => array(self::BELONGS_TO, 'InventoryPlaces',    'place_id'),
		    'parent'    => array(self::BELONGS_TO, 'Inventory',    'parent_id'),
		    );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'parent_id' => 'Parent',
			'user_id' => 'User',
			'quantity' => 'Quantity',
			'material_id' => 'Material',
			'price' => 'Price',
			'place_id' => 'Place',
			'building_id' => 'Building',
			'secret' => 'Secret',
			'confirm' => 'Confirm',
			'details' => 'Details',
			'design_id' => 'Design',
			'supplier_id' => 'Supplier',
			'type' => 'Type',
			'relativeweight' => 'Relativeweight',
			'selling_price' => 'Selling Price',
			'complition_rate' => 'Complition Rate',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('parent_id',$this->parent_id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('material_id',$this->material_id);
		$criteria->compare('price',$this->price);
		$criteria->compare('place_id',$this->place_id);
		$criteria->compare('building_id',$this->building_id);
		$criteria->compare('secret',$this->secret);
		$criteria->compare('confirm',$this->confirm);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('design_id',$this->design_id);
		$criteria->compare('supplier_id',$this->supplier_id);
		$criteria->compare('type',$this->type);
		$criteria->compare('relativeweight',$this->relativeweight);
		$criteria->compare('selling_price',$this->selling_price);
		$criteria->compare('complition_rate',$this->complition_rate);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Inventory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
