<?php

/**
 * This is the model class for table "mortgage_financing".
 *
 * The followings are the available columns in table 'mortgage_financing':
 * @property integer $id
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property integer $lead_id
 * @property string $email_sent_to_employee
 * @property string $bank_name
 * @property integer $credit_score_approval_sent
 * @property string $idcard
 * @property string $credit_score_inquiry
 * @property integer $credit_score_approval_status
 * @property string $expression_of_interest_form
 * @property integer $form_approval_status
 * @property string $form_number
 * @property string $receipt
 * @property integer $approval_status
 * @property integer $housing_status
 * @property string $unit_code
 */
class MortgageFinancing extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'mortgage_financing';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, date, time, lead_id', 'required'),
			array('user_id, lead_id, credit_score_approval_sent, credit_score_approval_status, form_approval_status, approval_status, housing_status', 'numerical', 'integerOnly'=>true),
			array('email_sent_to_employee, bank_name, idcard, credit_score_inquiry, expression_of_interest_form, receipt', 'length', 'max'=>255),
			array('form_number, unit_code', 'length', 'max'=>100),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, date, time, lead_id, email_sent_to_employee, bank_name, credit_score_approval_sent, idcard, credit_score_inquiry, credit_score_approval_status, expression_of_interest_form, form_approval_status, form_number, receipt, approval_status, housing_status, unit_code,name,birthdate,transfer', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'lead_id' => 'Lead',
			'email_sent_to_employee' => 'Email Sent To Employee',
			'bank_name' => 'Bank Name',
			'credit_score_approval_sent' => 'Credit Score Approval Sent',
			'idcard' => 'Idcard',
			'credit_score_inquiry' => 'Credit Score Inquiry',
			'credit_score_approval_status' => 'Credit Score Approval Status',
			'expression_of_interest_form' => 'Expression Of Interest Form',
			'form_approval_status' => 'Form Approval Status',
			'form_number' => 'Form Number',
			'receipt' => 'Receipt',
			'approval_status' => 'Approval Status',
			'housing_status' => 'Housing Status',
			'unit_code' => 'Unit Code',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('email_sent_to_employee',$this->email_sent_to_employee,true);
		$criteria->compare('bank_name',$this->bank_name,true);
		$criteria->compare('credit_score_approval_sent',$this->credit_score_approval_sent);
		$criteria->compare('idcard',$this->idcard,true);
		$criteria->compare('credit_score_inquiry',$this->credit_score_inquiry,true);
		$criteria->compare('credit_score_approval_status',$this->credit_score_approval_status);
		$criteria->compare('expression_of_interest_form',$this->expression_of_interest_form,true);
		$criteria->compare('form_approval_status',$this->form_approval_status);
		$criteria->compare('form_number',$this->form_number,true);
		$criteria->compare('receipt',$this->receipt,true);
		$criteria->compare('approval_status',$this->approval_status);
		$criteria->compare('housing_status',$this->housing_status);
		$criteria->compare('unit_code',$this->unit_code,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MortgageFinancing the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
