<?php

/**
 * This is the model class for table "notes".
 *
 * The followings are the available columns in table 'notes':
 * @property integer $id
 * @property integer $user_id
 * @property integer $lead_id
 * @property string $note
 * @property integer $note_type
 * @property string $date
 * @property string $time
 * @property integer $secert
 */
class Notes extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'notes';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, lead_id, note, note_type, date, time, secert', 'required'),
			array('user_id, lead_id, note_type,sales_id,activities_id, secert,hide', 'numerical', 'integerOnly'=>true),
			//array('note', 'length', 'max'=>255),
			array( 'note', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),

			
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, lead_id, note,sales_id, note_type, date, time, secert', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(


	'type'    => array(self::BELONGS_TO, 'NoteType',    'note_type'),

	'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),


        'lead'    => array(self::BELONGS_TO, 'Leads',    'lead_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'lead_id' => 'Lead',
			'note' => 'Note',
			'note_type' => 'Note Type',
			'date' => 'Date',
			'time' => 'Time',
			'secert' => 'Secert',
			'hide' => 'Hide',
			'sales_id' => 'Sales ID',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('note',$this->note,true);
		$criteria->compare('note_type',$this->note_type);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('secert',$this->secert);
		$criteria->compare('hide',$this->hide);
		$criteria->compare('sales_id',$this->sales_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Notes the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
