<?php

/**
 * This is the model class for table "projects".
 *
 * The followings are the available columns in table 'projects':
 * @property integer $id
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property string $address
 * @property integer $size_land
 * @property string $delivery_date
 * @property integer $number_buldings
 * @property integer $sold_units
 * @property integer $reserved_units
 * @property integer $remaning_units
 * @property string $details
 * @property integer $status
 * @property integer $secert
 * @property integer $hidden
 */
class Projects extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'projects';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('title,user_id, date, time, status, secert, hidden', 'required'),
			array('user_id, number_buldings, sold_units, reserved_units, remaning_units, country, governorate, city, region,  status, secert, hidden', 'numerical', 'integerOnly'=>true),
			array('size_land, size_land_net,percentage_construction,sort', 'numerical'),
			array('address , activity', 'length', 'max'=>255),
			
			
			array( 'title', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'address', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'activity', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'details', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),

			
			array('delivery_date, details', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, date, time, address, size_land, size_land_net, delivery_date, number_buldings, number_roles, sold_units, reserved_units, remaning_units, details, country, governorate, city, region, percentage_construction, status, secert,sort, hidden, activity', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		
			
		'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
                'governoratename'    => array(self::BELONGS_TO, 'Area',    'governorate'),		
                'cityname'    => array(self::BELONGS_TO, 'Area',    'city'),		
                'regionname'    => array(self::BELONGS_TO, 'Area',    'region'),	
                'xactivity'    => array(self::BELONGS_TO, 'TypeBuliding',    'activity'),		
	

		
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => 'Title',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'country' => 'Country',
                        'governorate' => 'Governorate',
                        'city' => 'City',
                        'region' => 'Region',
                        'percentage_construction' => 'Percentage Construction',
			'address' => 'Address',
			'number_plot' => 'Number Plot',
			'size_land' => 'Size Land',
			'size_land_net' => 'Size Land Net',
			'delivery_date' => 'Delivery Date',
			'number_roles' => 'Number Roles',
			'sold_units' => 'Sold Units',
			'reserved_units' => 'Reserved Units',
			'remaning_units' => 'Remaning Units',
			'details' => 'Details',
			'status' => 'Status',
			'secert' => 'Secert',
			'hidden' => 'Hidden',
			'activity' => 'Activity',
			'sort' => 'sort',
			'project_id' => 'Project Id',
			

		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

	
		$criteria=new CDbCriteria;
$criteria->addCondition('`delete` IS NULL');



		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('country',$this->country,true);
		$criteria->compare('governorate',$this->governorate,true);
		$criteria->compare('city',$this->city,true);
		$criteria->compare('region',$this->region,true);
		$criteria->compare('percentage_construction',$this->percentage_construction,true);

		$criteria->compare('address',$this->address,true);
		$criteria->compare('number_plot',$this->number_plot);
		$criteria->compare('size_land',$this->size_land);
		$criteria->compare('size_land_net',$this->size_land_net);
		$criteria->compare('delivery_date',$this->delivery_date,true);
		$criteria->compare('number_roles',$this->number_roles);
		$criteria->compare('sold_units',$this->sold_units);
		$criteria->compare('reserved_units',$this->reserved_units);
		$criteria->compare('remaning_units',$this->remaning_units);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('secert',$this->secert);
		$criteria->compare('hidden',$this->hidden);
		$criteria->compare('sort',$this->sort);


		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,'defaultOrder'=>'id ASC', 
		));
	}
	
	
	
	
	

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Projects the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
