<?php

/**
 * This is the model class for table "related_target".
 *
 * The followings are the available columns in table 'related_target':
 * @property integer $id
 * @property integer $main_target_id
 * @property string $title
 * @property string $start_date
 * @property string $end_date
 * @property string $ratio
 * @property string $exp_amount
 * @property string $date
 * @property string $time
 *
 * The followings are the available model relations:
 * @property MainTarget $mainTarget
 */
class RelatedTarget extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'related_target';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('main_target_id, title, start_date, end_date, ratio, exp_amount, date, time', 'required'),
			array('main_target_id', 'numerical', 'integerOnly'=>true),
			array('title, exp_amount', 'length', 'max'=>100),
			array('ratio', 'length', 'max'=>5),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, main_target_id, title, start_date, end_date, ratio, exp_amount, date, time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'mainTarget' => array(self::BELONGS_TO, 'MainTarget', 'main_target_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'main_target_id' => 'Main Target',
			'title' => 'Title',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'ratio' => 'Ratio',
			'exp_amount' => 'Exp Amount',
			'date' => 'Date',
			'time' => 'Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('main_target_id',$this->main_target_id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('ratio',$this->ratio,true);
		$criteria->compare('exp_amount',$this->exp_amount,true);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return RelatedTarget the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
