<?php

/**
 * This is the model class for table "request_reservation".
 *
 * The followings are the available columns in table 'request_reservation':
 * @property integer $id
 * @property integer $user_id
 * @property string $date
 * @property string $time
 * @property integer $lead_id
 * @property integer $unit_id
 * @property string $details
 * @property integer $confirm
 * @property integer $secret
 * @property integer $amount
 * @property integer $deposit
 * @property string $end_date
 * @property string $downpayment
 */
class RequestReservation extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'request_reservation';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
	
	
	return array(
    array('user_id, date, time', 'required'),
    array('user_id, lead_id, unit_id, confirm, secret, amount, deposit, res, con, cancel, sales, campaign_id, strategy_id, platform, platformchild, developer,bookingform', 'numerical', 'integerOnly'=>true),
    
    array('downpayment ,id_card, name, state, government, region, street, building, floor, apartment, mail, salesbroker, teamleaderbroker, paymentplan_id, delivery_date, email,address_email,passport', 'length', 'max'=>255),
    array('details, end_date', 'safe'),
    
    // Adding the new columns with the appropriate rules
    array('destination, incentive, unitcode, projects, documents, license, transaction_type, unit_type', 'length', 'max'=>255),
    array('date_allowdownpayment', 'date', 'format'=>'yyyy-MM-dd'),
    array('bua_indoor_size, outdoor_size', 'numerical'),

    // The following rule is used by search().
    // @todo Please remove those attributes that should not be searched.
    array('id, user_id, date, time, lead_id, unit_id, details, confirm, secret, amount, deposit, end_date, downpayment, res_date, con_date, cancel_date, sales, campaign_id, strategy_id, platform, platformchild, developer, state, government, region, street, building, floor, apartment, mail, salesbroker, teamleaderbroker, paymentplan_id, delivery_date, email, destination, incentive, date_allowdownpayment, unitcode, projects, bua_indoor_size, outdoor_size, documents, license, transaction_type, unit_type,address_email,bookingform,passport', 'safe', 'on'=>'search'),
);

	
	
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
	
        return array(
        
        
        'lead'    => array(self::BELONGS_TO, 'Leads',    'lead_id'),
        'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
        'salesx'    => array(self::BELONGS_TO, 'User',    'sales'),
        'salesx2'    => array(self::BELONGS_TO, 'User',    'sales2'),
        'salesx3'    => array(self::BELONGS_TO, 'User',    'sales3'),
        'salesx4'    => array(self::BELONGS_TO, 'User',    'sales4'),
        'salesx5'    => array(self::BELONGS_TO, 'User',    'sales5'),
        'salesx6'    => array(self::BELONGS_TO, 'User',    'sales6'),

            'leaderx'    => array(self::BELONGS_TO, 'User',    'teamleader'),
            'leaderx2'    => array(self::BELONGS_TO, 'User',    'teamleader2'),
            'leaderx3'    => array(self::BELONGS_TO, 'User',    'teamleader3'),
            'leaderx4'    => array(self::BELONGS_TO, 'User',    'teamleader4'),
            'leaderx5'    => array(self::BELONGS_TO, 'User',    'teamleader5'),
            'leaderx6'    => array(self::BELONGS_TO, 'User',    'teamleader6'),

        'unit'    => array(self::BELONGS_TO, 'Units',    'unit_id'),
        'campaign'    => array(self::BELONGS_TO, 'Campaign',    'campaign_id'),
        'platformtitle'    => array(self::BELONGS_TO, 'Platform',    'platform'),
        'strategy'    => array(self::BELONGS_TO, 'Strategy',    'strategy_id'),


        
        
        );
	
	
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'date' => 'Date',
			'time' => 'Time',
			'lead_id' => 'Lead',
			'unit_id' => 'Unit',
			'details' => 'Details',
			'confirm' => 'Confirm',
			'secret' => 'Secret',
			'amount' => 'Amount',
			'deposit' => 'Deposit',
			'end_date' => 'End Date',
			'downpayment' => 'Downpayment',
			'developer' => 'Developer',
			'id_card' => 'ID Card',
			'name' => 'Name',

			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('time',$this->time,true);
		$criteria->compare('lead_id',$this->lead_id);
		$criteria->compare('unit_id',$this->unit_id);
		$criteria->compare('details',$this->details,true);
		$criteria->compare('confirm',$this->confirm);
		$criteria->compare('secret',$this->secret);
		$criteria->compare('amount',$this->amount);
		$criteria->compare('deposit',$this->deposit);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('downpayment',$this->downpayment,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	
	
	
	

	
	
	
	
		public function requestreservationx()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
      
        
        
        
        $criteria = new CDbCriteria();
       	$criteria->condition .= "confirm IS NULL";

			
      

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,'defaultOrder'=>'id ASC', 
		));
	}
	
	
	
	
	
	
	
	
	
	
	
		public function requestreservationxleader()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
        $userid=Yii::app()->user->id;
        date_default_timezone_set('Africa/Cairo');  
        $today = date("Y-m-d");                     // 03.10.01
        $time = date("H:i:s");                      // 17:16:18	
        $rnd = rand(0,99999);
      
        
        
        
        $criteria = new CDbCriteria();
        
        
        
        
       	$criteria->condition .= "confirm IS NULL";

			 $allemployee = Teamleader::model()->findAll(array( 'condition' => 'leader_id=' . $userid ,'order'=>'id DESC'  ));
            $arr=array();
            foreach($allemployee as $leader){
            $arr[]=$leader->sales_id;
            } 

			$criteria->addInCondition('sales', $arr  , "AND");
			
      

		return new CActiveDataProvider(get_class($this), array(
			'pagination' => array(	'pageSize'=>Yii::app()->user->getState('pageSize',Yii::app()->params['defaultPageSize'])),
			'criteria'=>$criteria,
		));

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,'defaultOrder'=>'id ASC', 
		));
	}
	
	
	

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return RequestReservation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
