<?php

/**
 * This is the model class for table "statues".
 *
 * The followings are the available columns in table 'statues':
 * @property integer $id
 * @property string $title
 * @property string $color
 * @property integer $user_id
 * @property integer $secret
 * @property string $date
 * @property string $time
 */
class Statues extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'statues';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('title, user_id, secret, date, time', 'required'),
			array('user_id, secret,sms,duplicate,other_table,qualified,nonqualified,clear,answer,callback,close', 'numerical', 'integerOnly'=>true),
			array('title, color', 'length', 'max'=>255),
			array( 'title', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),
			array( 'sms_text', 'filter', 'filter' => array( 'CHtml', 'encode' ) ),



			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, title, color, user_id, secret, date, time,sms_text,other_table,qualified,nonqualified,clear,answer,callback,close', 'safe', 'on'=>'search'),
		);
	}
	
	
	
	
	
	

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(


'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),


		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => 'Title',
			'user_id' => 'User',
			'secret' => 'Secret',
			'date' => 'Date',
			'time' => 'Time',
			'color' => 'Color',
			'sms' => 'SMS',
			'sms_text' => 'SMS TEXT',
			'duplicate' => 'Duplicate',
			'other_table' => 'Other Table',
			'qualified' => 'Qualified',	
			'clear' => 'Clear',	
			'nonqualified' => 'Nonqualified',	
			'answer' => 'Answer',	
			'callback' => 'Callback',	

			
		

		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

        $criteria->compare('id',$this->id);
        $criteria->compare('title',$this->title,true);
        $criteria->compare('user_id',$this->user_id);
        $criteria->compare('sms',$this->sms);
        $criteria->compare('duplicate',$this->duplicate);
        $criteria->compare('secret',$this->secret);
        $criteria->compare('other_table',$this->other_table);
        $criteria->compare('date',$this->date,true);
        $criteria->compare('time',$this->time,true);
        $criteria->compare('color',$this->color,true);
        $criteria->compare('sms_text',$this->sms_text,true);
        $criteria->compare('answer',$this->answer,true);
        $criteria->compare('callback',$this->callback,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Statues the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	
	
	
	
}
