<?php

/**
 * This is the model class for table "viewtree".
 *
 * The followings are the available columns in table 'viewtree':
 * @property integer $id
 * @property integer $user_id
 * @property string $date
 * @property integer $sortid
 * @property integer $tree_id
 * @property string $icon
 * @property string $intro
 */
class Viewtree extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'viewtree';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_id, date, sortid, tree_id, icon, intro', 'required'),
			array('user_id, sortid, tree_id', 'numerical', 'integerOnly'=>true),
			array('icon, intro', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, user_id, date, sortid, tree_id, icon, intro', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		'employee'    => array(self::BELONGS_TO, 'User',    'user_id'),
		'tree'    => array(self::BELONGS_TO, 'Treeaccount',    'tree_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_id' => 'User',
			'date' => 'Date',
			'sortid' => 'Sortid',
			'tree_id' => 'Tree',
			'icon' => 'Icon',
			'intro' => 'Intro',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('sortid',$this->sortid);
		$criteria->compare('tree_id',$this->tree_id);
		$criteria->compare('icon',$this->icon,true);
		$criteria->compare('intro',$this->intro,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Viewtree the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
