<?php

/**
 * This is the model class for table "vtiger_crmentity".
 *
 * The followings are the available columns in table 'vtiger_crmentity':
 * @property integer $crmid
 * @property integer $smcreatorid
 * @property integer $smownerid
 * @property integer $modifiedby
 * @property string $setype
 * @property string $description
 * @property string $createdtime
 * @property string $modifiedtime
 * @property string $viewedtime
 * @property string $status
 * @property integer $version
 * @property integer $presence
 * @property integer $deleted
 * @property integer $smgroupid
 * @property string $source
 * @property string $label
 */
class VtigerCrmentity extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vtiger_crmentity';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('crmid, createdtime, modifiedtime', 'required'),
			array('crmid, smcreatorid, smownerid, modifiedby, version, presence, deleted, smgroupid', 'numerical', 'integerOnly'=>true),
			array('setype, source', 'length', 'max'=>100),
			array('status', 'length', 'max'=>50),
			array('label', 'length', 'max'=>255),
			array('description, viewedtime', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('crmid, smcreatorid, smownerid, modifiedby, setype, description, createdtime, modifiedtime, viewedtime, status, version, presence, deleted, smgroupid, source, label', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'crmid' => 'Crmid',
			'smcreatorid' => 'Smcreatorid',
			'smownerid' => 'Smownerid',
			'modifiedby' => 'Modifiedby',
			'setype' => 'Setype',
			'description' => 'Description',
			'createdtime' => 'Createdtime',
			'modifiedtime' => 'Modifiedtime',
			'viewedtime' => 'Viewedtime',
			'status' => 'Status',
			'version' => 'Version',
			'presence' => 'Presence',
			'deleted' => 'Deleted',
			'smgroupid' => 'Smgroupid',
			'source' => 'Source',
			'label' => 'Label',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('crmid',$this->crmid);
		$criteria->compare('smcreatorid',$this->smcreatorid);
		$criteria->compare('smownerid',$this->smownerid);
		$criteria->compare('modifiedby',$this->modifiedby);
		$criteria->compare('setype',$this->setype,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('createdtime',$this->createdtime,true);
		$criteria->compare('modifiedtime',$this->modifiedtime,true);
		$criteria->compare('viewedtime',$this->viewedtime,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('version',$this->version);
		$criteria->compare('presence',$this->presence);
		$criteria->compare('deleted',$this->deleted);
		$criteria->compare('smgroupid',$this->smgroupid);
		$criteria->compare('source',$this->source,true);
		$criteria->compare('label',$this->label,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return VtigerCrmentity the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
